//  Copyright John Maddock 2008.
//  Use, modification and distribution are subject to the
//  Boost Software License, Version 1.0. (See accompanying file
//  LICENSE_1_0.txt or copy at http://www.boost.org/LICENSE_1_0.txt)

#define SC_(x) static_cast<typename table_type<T>::type>(BOOST_JOIN(x, L))
   static const boost::array<boost::array<typename table_type<T>::type, 6>, 3000> ncbeta = {{
      {{ SC_(1.454305052757263183593750000000000000000), SC_(1.454305052757263183593750000000000000000e-1), SC_(5.940588760375976562500000000000000000000e1), SC_(9.976066350936889648437500000000000000000e-1), SC_(2.759834870217354705236013708534509068967e-1), SC_(7.240165129782645294763986291465490931033e-1) }}, 
      {{ SC_(1.454305052757263183593750000000000000000), SC_(1.454305052757263183593750000000000000000e-1), SC_(1.451677856445312500000000000000000000000e2), SC_(9.990068674087524414062500000000000000000e-1), SC_(2.757975665000284929998400439182434398680e-1), SC_(7.242024334999715070001599560817565601320e-1) }}, 
      {{ SC_(1.454305052757263183593750000000000000000), SC_(1.454305052757263183593750000000000000000e-1), SC_(1.929777069091796875000000000000000000000e2), SC_(9.992512464523315429687500000000000000000e-1), SC_(2.757802819095769722518059796277858159202e-1), SC_(7.242197180904230277481940203722141840798e-1) }}, 
      {{ SC_(1.454305052757263183593750000000000000000), SC_(3.635762631893157958984375000000000000000e-1), SC_(6.038262176513671875000000000000000000000e1), SC_(9.961022734642028808593750000000000000000e-1), SC_(4.949484084085013882284839924844591052030e-1), SC_(5.050515915914986117715160075155408947970e-1) }}, 
      {{ SC_(1.454305052757263183593750000000000000000), SC_(3.635762631893157958984375000000000000000e-1), SC_(1.481294555664062500000000000000000000000e2), SC_(9.983823299407958984375000000000000000000e-1), SC_(4.946201811284367289305268285202655846240e-1), SC_(5.053798188715632710694731714797344153760e-1) }}, 
      {{ SC_(1.454305052757263183593750000000000000000), SC_(3.635762631893157958984375000000000000000e-1), SC_(1.935389862060546875000000000000000000000e2), SC_(9.987584948539733886718750000000000000000e-1), SC_(4.945965085725495633413346642780624277086e-1), SC_(5.054034914274504366586653357219375722914e-1) }}, 
      {{ SC_(1.454305052757263183593750000000000000000), SC_(7.271525263786315917968750000000000000000e-1), SC_(6.163340759277343750000000000000000000000e1), SC_(9.943350553512573242187500000000000000000e-1), SC_(7.067242511174509034733895807356551147428e-1), SC_(2.932757488825490965266104192643448852572e-1) }}, 
      {{ SC_(1.454305052757263183593750000000000000000), SC_(7.271525263786315917968750000000000000000e-1), SC_(1.486264953613281250000000000000000000000e2), SC_(9.975933432579040527343750000000000000000e-1), SC_(7.063204046711177968479175758665909815947e-1), SC_(2.936795953288822031520824241334090184053e-1) }}, 
      {{ SC_(1.454305052757263183593750000000000000000), SC_(7.271525263786315917968750000000000000000e-1), SC_(1.937735595703125000000000000000000000000e2), SC_(9.981468915939331054687500000000000000000e-1), SC_(7.062805762166387906359787891104213355210e-1), SC_(2.937194237833612093640212108895786644790e-1) }}, 
      {{ SC_(1.454305052757263183593750000000000000000), SC_(1.090728759765625000000000000000000000000), SC_(7.225879669189453125000000000000000000000e1), SC_(9.942231774330139160156250000000000000000e-1), SC_(8.372920335940658618578320877705617571936e-1), SC_(1.627079664059341381421679122294382428064e-1) }}, 
      {{ SC_(1.454305052757263183593750000000000000000), SC_(1.090728759765625000000000000000000000000), SC_(1.515480346679687500000000000000000000000e2), SC_(9.971802234649658203125000000000000000000e-1), SC_(8.370187919390128563087545041366727719913e-1), SC_(1.629812080609871436912454958633272280087e-1) }}, 
      {{ SC_(1.454305052757263183593750000000000000000), SC_(1.090728759765625000000000000000000000000), SC_(1.941185607910156250000000000000000000000e2), SC_(9.977884292602539062500000000000000000000e-1), SC_(8.369846256186989556701034949935290540605e-1), SC_(1.630153743813010443298965050064709459395e-1) }}, 
      {{ SC_(1.454305052757263183593750000000000000000), SC_(1.308874487876892089843750000000000000000), SC_(9.566968083381652832031250000000000000000e-1), SC_(5.778348073363304138183593750000000000000e-2), SC_(1.409704128923593153631527182055535438009e-2), SC_(9.859029587107640684636847281794446456199e-1) }}, 
      {{ SC_(1.454305052757263183593750000000000000000), SC_(1.308874487876892089843750000000000000000), SC_(7.844540405273437500000000000000000000000e1), SC_(9.681322425603866577148437500000000000000e-2), SC_(2.569096227285625192995992565780836758662e-17), SC_(9.999999999999999743090377271437480700401e-1) }}, 
      {{ SC_(1.454305052757263183593750000000000000000), SC_(1.308874487876892089843750000000000000000), SC_(1.584414672851562500000000000000000000000e2), SC_(9.838468581438064575195312500000000000000e-2), SC_(7.148747906745571900269746100091585733876e-33), SC_(9.999999999999999999999999999999928512521e-1) }}, 
      {{ SC_(1.454305052757263183593750000000000000000), SC_(1.308874487876892089843750000000000000000), SC_(1.962219390869140625000000000000000000000e2), SC_(9.868995845317840576171875000000000000000e-2), SC_(3.133324157161160812982715199693443151905e-40), SC_(9.999999999999999999999999999999999999997e-1) }}, 
      {{ SC_(1.454305052757263183593750000000000000000), SC_(1.439761996269226074218750000000000000000), SC_(7.142335891723632812500000000000000000000), SC_(1.895702630281448364257812500000000000000e-1), SC_(8.246187378326890920818812693938620222737e-3), SC_(9.917538126216731090791811873060613797773e-1) }}, 
      {{ SC_(1.454305052757263183593750000000000000000), SC_(1.439761996269226074218750000000000000000), SC_(7.974770355224609375000000000000000000000e1), SC_(2.414003908634185791015625000000000000000e-1), SC_(2.743306172427076308949349814705500897953e-14), SC_(9.999999999999725669382757292369105065019e-1) }}, 
      {{ SC_(1.454305052757263183593750000000000000000), SC_(1.439761996269226074218750000000000000000), SC_(1.595857238769531250000000000000000000000e2), SC_(2.455961406230926513671875000000000000000e-1), SC_(3.615587311674064774434229582160414432976e-27), SC_(9.999999999999999999999999963844126883259e-1) }}, 
      {{ SC_(1.454305052757263183593750000000000000000), SC_(1.439761996269226074218750000000000000000), SC_(1.985762634277343750000000000000000000000e2), SC_(2.464439719915390014648437500000000000000e-1), SC_(1.769432346388276500700335757818980807043e-33), SC_(9.999999999999999999999999999999982305677e-1) }}, 
      {{ SC_(1.454305052757263183593750000000000000000), SC_(1.452850818634033203125000000000000000000), SC_(1.950807952880859375000000000000000000000e1), SC_(4.391348361968994140625000000000000000000e-1), SC_(2.673764091042295518866919574008896029552e-3), SC_(9.973262359089577044811330804259911039704e-1) }}, 
      {{ SC_(1.454305052757263183593750000000000000000), SC_(1.452850818634033203125000000000000000000), SC_(8.435225677490234375000000000000000000000e1), SC_(4.835526645183563232421875000000000000000e-1), SC_(4.197372846541376004107385263233562496292e-10), SC_(9.999999995802627153458623995892614736766e-1) }}, 
      {{ SC_(1.454305052757263183593750000000000000000), SC_(1.452850818634033203125000000000000000000), SC_(1.596211700439453125000000000000000000000e2), SC_(4.911155700683593750000000000000000000000e-1), SC_(3.695059050069457866849050715946269539742e-18), SC_(9.999999999999999963049409499305421331509e-1) }}, 
      {{ SC_(1.454305052757263183593750000000000000000), SC_(1.452850818634033203125000000000000000000), SC_(1.992922668457031250000000000000000000000e2), SC_(4.928494989871978759765625000000000000000e-1), SC_(2.004823756718951621438737650562766380258e-22), SC_(9.999999999999999999997995176243281048379e-1) }}, 
      {{ SC_(1.454305052757263183593750000000000000000), SC_(1.454305052757263183593750000000000000000), SC_(2.197235107421875000000000000000000000000e1), SC_(6.670339703559875488281250000000000000000e-1), SC_(2.938827902133597908162529714537893342335e-2), SC_(9.706117209786640209183747028546210665767e-1) }}, 
      {{ SC_(1.454305052757263183593750000000000000000), SC_(1.454305052757263183593750000000000000000), SC_(8.441753387451171875000000000000000000000e1), SC_(7.253233790397644042968750000000000000000e-1), SC_(1.828399814138725196172294345445724389776e-5), SC_(9.999817160018586127480382770565455427561e-1) }}, 
      {{ SC_(1.454305052757263183593750000000000000000), SC_(1.454305052757263183593750000000000000000), SC_(1.600560913085937500000000000000000000000e2), SC_(7.366956472396850585937500000000000000000e-1), SC_(1.838909377742473059089666873575275698077e-9), SC_(9.999999981610906222575269409103331264247e-1) }}, 
      {{ SC_(1.454305052757263183593750000000000000000), SC_(1.454450488090515136718750000000000000000), SC_(2.249290275573730468750000000000000000000e1), SC_(8.023343086242675781250000000000000000000e-1), SC_(1.444816643582166349744437266238358383054e-1), SC_(8.555183356417833650255562733761641616946e-1) }}, 
      {{ SC_(1.454305052757263183593750000000000000000), SC_(1.454450488090515136718750000000000000000), SC_(9.495173645019531250000000000000000000000e1), SC_(8.735338449478149414062500000000000000000e-1), SC_(5.297391880242822813440890445530785806678e-3), SC_(9.947026081197571771865591095544692141933e-1) }}, 
      {{ SC_(1.454305052757263183593750000000000000000), SC_(1.454450488090515136718750000000000000000), SC_(1.629447326660156250000000000000000000000e2), SC_(8.843094706535339355468750000000000000000e-1), SC_(2.109987510023566218907025733718046851867e-4), SC_(9.997890012489976433781092974266281953148e-1) }}, 
      {{ SC_(1.454305052757263183593750000000000000000), SC_(1.455759406089782714843750000000000000000), SC_(2.539736366271972656250000000000000000000e1), SC_(8.928544521331787109375000000000000000000e-1), SC_(3.547407387217092519571701060719919695556e-1), SC_(6.452592612782907480428298939280080304444e-1) }}, 
      {{ SC_(1.454305052757263183593750000000000000000), SC_(1.455759406089782714843750000000000000000), SC_(9.707512664794921875000000000000000000000e1), SC_(9.614732861518859863281250000000000000000e-1), SC_(2.611091095508861765371680541840956899457e-1), SC_(7.388908904491138234628319458159043100543e-1) }}, 
      {{ SC_(1.454305052757263183593750000000000000000), SC_(1.455759406089782714843750000000000000000), SC_(1.670017089843750000000000000000000000000e2), SC_(9.731349945068359375000000000000000000000e-1), SC_(1.940330038798788046724413303549101135332e-1), SC_(8.059669961201211953275586696450898864668e-1) }}, 
      {{ SC_(1.454305052757263183593750000000000000000), SC_(1.468848109245300292968750000000000000000), SC_(2.709540176391601562500000000000000000000e1), SC_(9.054616093635559082031250000000000000000e-1), SC_(3.905836257290503311421287149477297051216e-1), SC_(6.094163742709496688578712850522702948784e-1) }}, 
      {{ SC_(1.454305052757263183593750000000000000000), SC_(1.468848109245300292968750000000000000000), SC_(1.007325439453125000000000000000000000000e2), SC_(9.709756374359130859375000000000000000000e-1), SC_(3.753844614900924354145268955128904198463e-1), SC_(6.246155385099075645854731044871095801537e-1) }}, 
      {{ SC_(1.454305052757263183593750000000000000000), SC_(1.468848109245300292968750000000000000000), SC_(1.698258666992187500000000000000000000000e2), SC_(9.821102619171142578125000000000000000000e-1), SC_(3.648451596781998922228271535859833907049e-1), SC_(6.351548403218001077771728464140166092951e-1) }}, 
      {{ SC_(1.454305052757263183593750000000000000000), SC_(1.599735617637634277343750000000000000000), SC_(2.837726783752441406250000000000000000000e1), SC_(9.027946591377258300781250000000000000000e-1), SC_(3.994481344166706347071818471461165810451e-1), SC_(6.005518655833293652928181528538834189549e-1) }}, 
      {{ SC_(1.454305052757263183593750000000000000000), SC_(1.599735617637634277343750000000000000000), SC_(1.093762969970703125000000000000000000000e2), SC_(9.718407988548278808593750000000000000000e-1), SC_(3.954357512869085630066564425659524044339e-1), SC_(6.045642487130914369933435574340475955661e-1) }}, 
      {{ SC_(1.454305052757263183593750000000000000000), SC_(1.599735617637634277343750000000000000000), SC_(1.756861267089843750000000000000000000000e2), SC_(9.822134971618652343750000000000000000000e-1), SC_(3.951860745186655290524861501883898882522e-1), SC_(6.048139254813344709475138498116101117478e-1) }}, 
      {{ SC_(1.454305052757263183593750000000000000000), SC_(1.745166182518005371093750000000000000000), SC_(3.152261734008789062500000000000000000000e1), SC_(9.039335846900939941406250000000000000000e-1), SC_(4.034567451009304048585061955097242530617e-1), SC_(5.965432548990695951414938044902757469383e-1) }}, 
      {{ SC_(1.454305052757263183593750000000000000000), SC_(1.745166182518005371093750000000000000000), SC_(1.094441146850585937500000000000000000000e2), SC_(9.693817496299743652343750000000000000000e-1), SC_(3.999349356267901779097748250899115060062e-1), SC_(6.000650643732098220902251749100884939938e-1) }}, 
      {{ SC_(1.454305052757263183593750000000000000000), SC_(1.745166182518005371093750000000000000000), SC_(1.811583862304687500000000000000000000000e2), SC_(9.812008142471313476562500000000000000000e-1), SC_(3.996591569909480845917200256671608991653e-1), SC_(6.003408430090519154082799743328391008347e-1) }}, 
      {{ SC_(1.454305052757263183593750000000000000000), SC_(1.890596508979797363281250000000000000000), SC_(3.423733520507812500000000000000000000000e1), SC_(9.039308428764343261718750000000000000000e-1), SC_(4.075414522865678416055270738540772311928e-1), SC_(5.924585477134321583944729261459227688072e-1) }}, 
      {{ SC_(1.454305052757263183593750000000000000000), SC_(1.890596508979797363281250000000000000000), SC_(1.264718551635742187500000000000000000000e2), SC_(9.712282419204711914062500000000000000000e-1), SC_(4.042366483257852646737355474134075723046e-1), SC_(5.957633516742147353262644525865924276954e-1) }}, 
      {{ SC_(1.454305052757263183593750000000000000000), SC_(1.890596508979797363281250000000000000000), SC_(1.826751708984375000000000000000000000000e2), SC_(9.798489809036254882812500000000000000000e-1), SC_(4.040529458975031201558234570112972505675e-1), SC_(5.959470541024968798441765429887027494325e-1) }}, 
      {{ SC_(1.454305052757263183593750000000000000000), SC_(2.181457519531250000000000000000000000000), SC_(3.477303314208984375000000000000000000000e1), SC_(8.932165503501892089843750000000000000000e-1), SC_(4.196040744142951370235014827671730626531e-1), SC_(5.803959255857048629764985172328269373469e-1) }}, 
      {{ SC_(1.454305052757263183593750000000000000000), SC_(2.181457519531250000000000000000000000000), SC_(1.279526672363281250000000000000000000000e2), SC_(9.676080346107482910156250000000000000000e-1), SC_(4.160241471932662346234005638447945943191e-1), SC_(5.839758528067337653765994361552054056809e-1) }}, 
      {{ SC_(1.454305052757263183593750000000000000000), SC_(2.181457519531250000000000000000000000000), SC_(1.831471099853515625000000000000000000000e2), SC_(9.770854115486145019531250000000000000000e-1), SC_(4.158245920573030252337620932502862854216e-1), SC_(5.841754079426969747662379067497137145784e-1) }}, 
      {{ SC_(1.454305052757263183593750000000000000000), SC_(2.908610105514526367187500000000000000000), SC_(3.767639541625976562500000000000000000000e1), SC_(8.820433020591735839843750000000000000000e-1), SC_(4.895484702256356762390308845835055338300e-1), SC_(5.104515297743643237609691154164944661700e-1) }}, 
      {{ SC_(1.454305052757263183593750000000000000000), SC_(2.908610105514526367187500000000000000000), SC_(1.310955810546875000000000000000000000000e2), SC_(9.616703391075134277343750000000000000000e-1), SC_(4.852896389054532990013477094741957837547e-1), SC_(5.147103610945467009986522905258042162453e-1) }}, 
      {{ SC_(1.454305052757263183593750000000000000000), SC_(2.908610105514526367187500000000000000000), SC_(1.867986450195312500000000000000000000000e2), SC_(9.726884961128234863281250000000000000000e-1), SC_(4.850256268066020087353144387623113929601e-1), SC_(5.149743731933979912646855612376886070399e-1) }}, 
      {{ SC_(1.454305052757263183593750000000000000000), SC_(4.362915039062500000000000000000000000000), SC_(4.238486480712890625000000000000000000000e1), SC_(8.614798784255981445312500000000000000000e-1), SC_(5.884548078925982877372322454535815427048e-1), SC_(4.115451921074017122627677545464184572952e-1) }}, 
      {{ SC_(1.454305052757263183593750000000000000000), SC_(4.362915039062500000000000000000000000000), SC_(1.311481323242187500000000000000000000000e2), SC_(9.484174847602844238281250000000000000000e-1), SC_(5.829003968003181859827925473746335160193e-1), SC_(4.170996031996818140172074526253664839807e-1) }}, 
      {{ SC_(1.454305052757263183593750000000000000000), SC_(4.362915039062500000000000000000000000000), SC_(1.914333953857421875000000000000000000000e2), SC_(9.638592004776000976562500000000000000000e-1), SC_(5.824357183371835930850248019898267857302e-1), SC_(4.175642816628164069149751980101732142698e-1) }}, 
      {{ SC_(1.454305052757263183593750000000000000000), SC_(5.817220211029052734375000000000000000000), SC_(4.420680999755859375000000000000000000000e1), SC_(8.437643647193908691406250000000000000000e-1), SC_(6.877689126985590678729196980659326128520e-1), SC_(3.122310873014409321270803019340673871480e-1) }}, 
      {{ SC_(1.454305052757263183593750000000000000000), SC_(5.817220211029052734375000000000000000000), SC_(1.357470245361328125000000000000000000000e2), SC_(9.397355914115905761718750000000000000000e-1), SC_(6.802657470523751397057188962080634416444e-1), SC_(3.197342529476248602942811037919365583556e-1) }}, 
      {{ SC_(1.454305052757263183593750000000000000000), SC_(5.817220211029052734375000000000000000000), SC_(1.915013732910156250000000000000000000000e2), SC_(9.561730027198791503906250000000000000000e-1), SC_(6.796471288397932298915701548036010615867e-1), SC_(3.203528711602067701084298451963989384133e-1) }}, 
      {{ SC_(1.454305052757263183593750000000000000000), SC_(7.271525382995605468750000000000000000000), SC_(5.569964599609375000000000000000000000000e1), SC_(8.647022843360900878906250000000000000000e-1), SC_(8.223643224171615413929725001008431837543e-1), SC_(1.776356775828384586070274998991568162457e-1) }}, 
      {{ SC_(1.454305052757263183593750000000000000000), SC_(7.271525382995605468750000000000000000000), SC_(1.362719116210937500000000000000000000000e2), SC_(9.362024664878845214843750000000000000000e-1), SC_(8.166333330997769887900278651735051489581e-1), SC_(1.833666669002230112099721348264948510419e-1) }}, 
      {{ SC_(1.454305052757263183593750000000000000000), SC_(7.271525382995605468750000000000000000000), SC_(1.918984832763671875000000000000000000000e2), SC_(9.532827138900756835937500000000000000000e-1), SC_(8.158731225304289595587318169554547977876e-1), SC_(1.841268774695710404412681830445452022124e-1) }}, 
      {{ SC_(7.624480247497558593750000000000000000000), SC_(7.624480128288269042968750000000000000000e-1), SC_(4.238486480712890625000000000000000000000e1), SC_(9.867996573448181152343750000000000000000e-1), SC_(5.583365136095776339081731551107376175956e-1), SC_(4.416634863904223660918268448892623824044e-1) }}, 
      {{ SC_(7.624480247497558593750000000000000000000), SC_(7.624480128288269042968750000000000000000e-1), SC_(1.311481323242187500000000000000000000000e2), SC_(9.947838187217712402343750000000000000000e-1), SC_(5.566168002155693478057404053061743980239e-1), SC_(4.433831997844306521942595946938256019761e-1) }}, 
      {{ SC_(7.624480247497558593750000000000000000000), SC_(7.624480128288269042968750000000000000000e-1), SC_(1.914333953857421875000000000000000000000e2), SC_(9.963057041168212890625000000000000000000e-1), SC_(5.564496201392487472922328566260597919103e-1), SC_(4.435503798607512527077671433739402080897e-1) }}, 
      {{ SC_(7.624480247497558593750000000000000000000), SC_(1.906120061874389648437500000000000000000), SC_(4.420680999755859375000000000000000000000e1), SC_(9.794712066650390625000000000000000000000e-1), SC_(8.497055851817405545060679899366824974256e-1), SC_(1.502944148182594454939320100633175025744e-1) }}, 
      {{ SC_(7.624480247497558593750000000000000000000), SC_(1.906120061874389648437500000000000000000), SC_(1.357470245361328125000000000000000000000e2), SC_(9.916985034942626953125000000000000000000e-1), SC_(8.474874632512543819213109447818134823510e-1), SC_(1.525125367487456180786890552181865176490e-1) }}, 
      {{ SC_(7.624480247497558593750000000000000000000), SC_(1.906120061874389648437500000000000000000), SC_(1.915013732910156250000000000000000000000e2), SC_(9.939128756523132324218750000000000000000e-1), SC_(8.472816502098915116438513790356648635429e-1), SC_(1.527183497901084883561486209643351364571e-1) }}, 
      {{ SC_(7.624480247497558593750000000000000000000), SC_(3.812240123748779296875000000000000000000), SC_(5.569964599609375000000000000000000000000e1), SC_(9.753030538558959960937500000000000000000e-1), SC_(9.791209648136790484042915910612526702029e-1), SC_(2.087903518632095159570840893874732979707e-2) }}, 
      {{ SC_(7.624480247497558593750000000000000000000), SC_(3.812240123748779296875000000000000000000), SC_(1.362719116210937500000000000000000000000e2), SC_(9.878938794136047363281250000000000000000e-1), SC_(9.783940548223053365034160675124105817852e-1), SC_(2.160594517769466349658393248758941821483e-2) }}, 
      {{ SC_(7.624480247497558593750000000000000000000), SC_(3.812240123748779296875000000000000000000), SC_(1.918984832763671875000000000000000000000e2), SC_(9.910510778427124023437500000000000000000e-1), SC_(9.782879208350783282339552209987683458332e-1), SC_(2.171207916492167176604477900123165416678e-2) }}, 
      {{ SC_(7.624480247497558593750000000000000000000), SC_(5.718359947204589843750000000000000000000), SC_(5.940588760375976562500000000000000000000e1), SC_(9.730053544044494628906250000000000000000e-1), SC_(9.982493838270047731925588204065902788169e-1), SC_(1.750616172995226807441179593409721183106e-3) }}, 
      {{ SC_(7.624480247497558593750000000000000000000), SC_(5.718359947204589843750000000000000000000), SC_(1.451677856445312500000000000000000000000e2), SC_(9.865593314170837402343750000000000000000e-1), SC_(9.981190183485590775558085116693982955543e-1), SC_(1.880981651440922444191488330601704445733e-3) }}, 
      {{ SC_(7.624480247497558593750000000000000000000), SC_(5.718359947204589843750000000000000000000), SC_(1.929777069091796875000000000000000000000e2), SC_(9.895037412643432617187500000000000000000e-1), SC_(9.981016284704615841952385761223267538834e-1), SC_(1.898371529538415804761423877673246116642e-3) }}, 
      {{ SC_(7.624480247497558593750000000000000000000), SC_(6.862031936645507812500000000000000000000), SC_(6.038262176513671875000000000000000000000e1), SC_(8.440877497196197509765625000000000000000e-2), SC_(3.755943830843802753212026887627679690736e-17), SC_(9.999999999999999624405616915619724678797e-1) }}, 
      {{ SC_(7.624480247497558593750000000000000000000), SC_(6.862031936645507812500000000000000000000), SC_(1.481294555664062500000000000000000000000e2), SC_(9.217758476734161376953125000000000000000e-2), SC_(2.452867989962132252598005207969066251996e-33), SC_(9.999999999999999999999999999999975471320e-1) }}, 
      {{ SC_(7.624480247497558593750000000000000000000), SC_(6.862031936645507812500000000000000000000), SC_(1.935389862060546875000000000000000000000e2), SC_(9.378399699926376342773437500000000000000e-2), SC_(7.326380398259610879523263914480645888648e-42), SC_(1.000000000000000000000000000000000000000) }}, 
      {{ SC_(7.624480247497558593750000000000000000000), SC_(7.548235416412353515625000000000000000000), SC_(6.163340759277343750000000000000000000000e1), SC_(2.083696871995925903320312500000000000000e-1), SC_(4.113418732222352000620535111242945452697e-12), SC_(9.999999999958865812677776479993794648888e-1) }}, 
      {{ SC_(7.624480247497558593750000000000000000000), SC_(7.548235416412353515625000000000000000000), SC_(1.486264953613281250000000000000000000000e2), SC_(2.287165373563766479492187500000000000000e-1), SC_(7.417996899714786870861217709534278603188e-25), SC_(9.999999999999999999999992582003100285213e-1) }}, 
      {{ SC_(7.624480247497558593750000000000000000000), SC_(7.548235416412353515625000000000000000000), SC_(1.937735595703125000000000000000000000000e2), SC_(2.330302745103836059570312500000000000000e-1), SC_(1.076663665386329451031141034971411916591e-31), SC_(9.999999999999999999999999999998923336335e-1) }}, 
      {{ SC_(7.624480247497558593750000000000000000000), SC_(7.616856098175048828125000000000000000000), SC_(7.225879669189453125000000000000000000000e1), SC_(4.248488843441009521484375000000000000000e-1), SC_(7.405942273134401395620660999540454629700e-8), SC_(9.999999259405772686559860437933900045955e-1) }}, 
      {{ SC_(7.624480247497558593750000000000000000000), SC_(7.616856098175048828125000000000000000000), SC_(1.515480346679687500000000000000000000000e2), SC_(4.577734470367431640625000000000000000000e-1), SC_(4.218355638088579286544834491993072994126e-15), SC_(9.999999999999957816443619114207134551655e-1) }}, 
      {{ SC_(7.624480247497558593750000000000000000000), SC_(7.616856098175048828125000000000000000000), SC_(1.941185607910156250000000000000000000000e2), SC_(4.658262133598327636718750000000000000000e-1), SC_(3.412378004626004639402336175754391429280e-19), SC_(9.999999999999999996587621995373995360598e-1) }}, 
      {{ SC_(7.624480247497558593750000000000000000000), SC_(7.624480247497558593750000000000000000000), SC_(9.566968083381652832031250000000000000000e-1), SC_(3.857024908065795898437500000000000000000e-1), SC_(1.571265298972650161264039710307769773888e-1), SC_(8.428734701027349838735960289692230226112e-1) }}, 
      {{ SC_(7.624480247497558593750000000000000000000), SC_(7.624480247497558593750000000000000000000), SC_(7.844540405273437500000000000000000000000e1), SC_(6.436336636543273925781250000000000000000e-1), SC_(6.065581230974913623448999867938032076832e-4), SC_(9.993934418769025086376551000132061967923e-1) }}, 
      {{ SC_(7.624480247497558593750000000000000000000), SC_(7.624480247497558593750000000000000000000), SC_(1.584414672851562500000000000000000000000e2), SC_(6.889315247535705566406250000000000000000e-1), SC_(3.787953719836815014657091125143381525034e-7), SC_(9.999996212046280163184985342908874856618e-1) }}, 
      {{ SC_(7.624480247497558593750000000000000000000), SC_(7.624480247497558593750000000000000000000), SC_(1.962219390869140625000000000000000000000e2), SC_(6.991705894470214843750000000000000000000e-1), SC_(8.741334104843869137635933359621165453347e-9), SC_(9.999999912586658951561308623640666403788e-1) }}, 
      {{ SC_(7.624480247497558593750000000000000000000), SC_(7.625242710113525390625000000000000000000), SC_(7.142335891723632812500000000000000000000), SC_(5.316908359527587890625000000000000000000e-1), SC_(3.026145691313365431159593595202609036506e-1), SC_(6.973854308686634568840406404797390963494e-1) }}, 
      {{ SC_(7.624480247497558593750000000000000000000), SC_(7.625242710113525390625000000000000000000), SC_(7.974770355224609375000000000000000000000e1), SC_(7.738693356513977050781250000000000000000e-1), SC_(5.679063157641000774918240822342526680721e-2), SC_(9.432093684235899922508175917765747331928e-1) }}, 
      {{ SC_(7.624480247497558593750000000000000000000), SC_(7.625242710113525390625000000000000000000), SC_(1.595857238769531250000000000000000000000e2), SC_(8.271553516387939453125000000000000000000e-1), SC_(5.650714474455609373650126758889557888297e-3), SC_(9.943492855255443906263498732411104421117e-1) }}, 
      {{ SC_(7.624480247497558593750000000000000000000), SC_(7.625242710113525390625000000000000000000), SC_(1.985762634277343750000000000000000000000e2), SC_(8.396298885345458984375000000000000000000e-1), SC_(1.609319479610728794258608178671694900088e-3), SC_(9.983906805203892712057413918213283050999e-1) }}, 
      {{ SC_(7.624480247497558593750000000000000000000), SC_(7.632104873657226562500000000000000000000), SC_(1.950807952880859375000000000000000000000e1), SC_(6.831862926483154296875000000000000000000e-1), SC_(4.418914847422064267345755941123344911377e-1), SC_(5.581085152577935732654244058876655088623e-1) }}, 
      {{ SC_(7.624480247497558593750000000000000000000), SC_(7.632104873657226562500000000000000000000), SC_(8.435225677490234375000000000000000000000e1), SC_(8.567589521408081054687500000000000000000e-1), SC_(3.860026420207432571543414254360707551225e-1), SC_(6.139973579792567428456585745639292448775e-1) }}, 
      {{ SC_(7.624480247497558593750000000000000000000), SC_(7.632104873657226562500000000000000000000), SC_(1.596211700439453125000000000000000000000e2), SC_(9.098197817802429199218750000000000000000e-1), SC_(3.367191996336441634737050657029827678022e-1), SC_(6.632808003663558365262949342970172321978e-1) }}, 
      {{ SC_(7.624480247497558593750000000000000000000), SC_(7.632104873657226562500000000000000000000), SC_(1.992922668457031250000000000000000000000e2), SC_(9.237456321716308593750000000000000000000e-1), SC_(3.127680084687374032263176335563365193018e-1), SC_(6.872319915312625967736823664436634806982e-1) }}, 
      {{ SC_(7.624480247497558593750000000000000000000), SC_(7.700725078582763671875000000000000000000), SC_(2.197235107421875000000000000000000000000e1), SC_(7.019761204719543457031250000000000000000e-1), SC_(4.644035773550324302995365428354641378299e-1), SC_(5.355964226449675697004634571645358621701e-1) }}, 
      {{ SC_(7.624480247497558593750000000000000000000), SC_(7.700725078582763671875000000000000000000), SC_(8.441753387451171875000000000000000000000e1), SC_(8.635822534561157226562500000000000000000e-1), SC_(4.480221589800738793494618535895062290185e-1), SC_(5.519778410199261206505381464104937709815e-1) }}, 
      {{ SC_(7.624480247497558593750000000000000000000), SC_(7.700725078582763671875000000000000000000), SC_(1.600560913085937500000000000000000000000e2), SC_(9.176107048988342285156250000000000000000e-1), SC_(4.408061852324650018434589056925708821801e-1), SC_(5.591938147675349981565410943074291178199e-1) }}, 
      {{ SC_(7.624480247497558593750000000000000000000), SC_(8.386928558349609375000000000000000000000), SC_(2.249290275573730468750000000000000000000e1), SC_(6.876541376113891601562500000000000000000e-1), SC_(4.696174584362813630479899485798979045392e-1), SC_(5.303825415637186369520100514201020954608e-1) }}, 
      {{ SC_(7.624480247497558593750000000000000000000), SC_(8.386928558349609375000000000000000000000), SC_(9.495173645019531250000000000000000000000e1), SC_(8.663399219512939453125000000000000000000e-1), SC_(4.567904524586741240883157415742417524927e-1), SC_(5.432095475413258759116842584257582475073e-1) }}, 
      {{ SC_(7.624480247497558593750000000000000000000), SC_(8.386928558349609375000000000000000000000), SC_(1.629447326660156250000000000000000000000e2), SC_(9.132283329963684082031250000000000000000e-1), SC_(4.552102194920640380157155461933502978862e-1), SC_(5.447897805079359619842844538066497021138e-1) }}, 
      {{ SC_(7.624480247497558593750000000000000000000), SC_(9.149376869201660156250000000000000000000), SC_(2.539736366271972656250000000000000000000e1), SC_(6.850557923316955566406250000000000000000e-1), SC_(4.707599856336169735470290015968805012282e-1), SC_(5.292400143663830264529709984031194987718e-1) }}, 
      {{ SC_(7.624480247497558593750000000000000000000), SC_(9.149376869201660156250000000000000000000), SC_(9.707512664794921875000000000000000000000e1), SC_(8.583316802978515625000000000000000000000e-1), SC_(4.589617787376114440734641232845035085695e-1), SC_(5.410382212623885559265358767154964914305e-1) }}, 
      {{ SC_(7.624480247497558593750000000000000000000), SC_(9.149376869201660156250000000000000000000), SC_(1.670017089843750000000000000000000000000e2), SC_(9.080083370208740234375000000000000000000e-1), SC_(4.573235512617251771389342808608536486599e-1), SC_(5.426764487382748228610657191391463513401e-1) }}, 
      {{ SC_(7.624480247497558593750000000000000000000), SC_(9.911824226379394531250000000000000000000), SC_(2.709540176391601562500000000000000000000e1), SC_(6.769798398017883300781250000000000000000e-1), SC_(4.734862181596002006611019444405780704935e-1), SC_(5.265137818403997993388980555594219295065e-1) }}, 
      {{ SC_(7.624480247497558593750000000000000000000), SC_(9.911824226379394531250000000000000000000), SC_(1.007325439453125000000000000000000000000e2), SC_(8.525816202163696289062500000000000000000e-1), SC_(4.618527903295305055931322180316456704293e-1), SC_(5.381472096704694944068677819683543295707e-1) }}, 
      {{ SC_(7.624480247497558593750000000000000000000), SC_(9.911824226379394531250000000000000000000), SC_(1.698258666992187500000000000000000000000e2), SC_(9.025660753250122070312500000000000000000e-1), SC_(4.602328847044463517408905213793696147627e-1), SC_(5.397671152955536482591094786206303852373e-1) }}, 
      {{ SC_(7.624480247497558593750000000000000000000), SC_(1.143671989440917968750000000000000000000e1), SC_(2.837726783752441406250000000000000000000e1), SC_(6.550716161727905273437500000000000000000e-1), SC_(4.903745842374428012275904844218844585056e-1), SC_(5.096254157625571987724095155781155414944e-1) }}, 
      {{ SC_(7.624480247497558593750000000000000000000), SC_(1.143671989440917968750000000000000000000e1), SC_(1.093762969970703125000000000000000000000e2), SC_(8.449160456657409667968750000000000000000e-1), SC_(4.770637427212332552201997152796081991578e-1), SC_(5.229362572787667447798002847203918008422e-1) }}, 
      {{ SC_(7.624480247497558593750000000000000000000), SC_(1.143671989440917968750000000000000000000e1), SC_(1.756861267089843750000000000000000000000e2), SC_(8.932641148567199707031250000000000000000e-1), SC_(4.754312320056804319285655123611456156852e-1), SC_(5.245687679943195680714344876388543843148e-1) }}, 
      {{ SC_(7.624480247497558593750000000000000000000), SC_(1.524896049499511718750000000000000000000e1), SC_(3.152261734008789062500000000000000000000e1), SC_(6.373971104621887207031250000000000000000e-1), SC_(6.428124609852474305779352247516926967840e-1), SC_(3.571875390147525694220647752483073032160e-1) }}, 
      {{ SC_(7.624480247497558593750000000000000000000), SC_(1.524896049499511718750000000000000000000e1), SC_(1.094441146850585937500000000000000000000e2), SC_(8.197230696678161621093750000000000000000e-1), SC_(6.175238502611826164386094657182779631945e-1), SC_(3.824761497388173835613905342817220368055e-1) }}, 
      {{ SC_(7.624480247497558593750000000000000000000), SC_(1.524896049499511718750000000000000000000e1), SC_(1.811583862304687500000000000000000000000e2), SC_(8.769508600234985351562500000000000000000e-1), SC_(6.136232830736803735363746828795793852822e-1), SC_(3.863767169263196264636253171204206147178e-1) }}, 
      {{ SC_(7.624480247497558593750000000000000000000), SC_(2.287343978881835937500000000000000000000e1), SC_(3.423733520507812500000000000000000000000e1), SC_(5.966717600822448730468750000000000000000e-1), SC_(8.312265233503014666848900622233169143836e-1), SC_(1.687734766496985333151099377766830856164e-1) }}, 
      {{ SC_(7.624480247497558593750000000000000000000), SC_(2.287343978881835937500000000000000000000e1), SC_(1.264718551635742187500000000000000000000e2), SC_(7.951819300651550292968750000000000000000e-1), SC_(7.926044589739312626912643695810339044158e-1), SC_(2.073955410260687373087356304189660955842e-1) }}, 
      {{ SC_(7.624480247497558593750000000000000000000), SC_(2.287343978881835937500000000000000000000e1), SC_(1.826751708984375000000000000000000000000e2), SC_(8.425870537757873535156250000000000000000e-1), SC_(7.877422239122586071967188458598773235884e-1), SC_(2.122577760877413928032811541401226764116e-1) }}, 
      {{ SC_(7.624480247497558593750000000000000000000), SC_(3.049792098999023437500000000000000000000e1), SC_(3.477303314208984375000000000000000000000e1), SC_(5.749815106391906738281250000000000000000e-1), SC_(9.505962409504530415434655614111811678427e-1), SC_(4.940375904954695845653443858881883215732e-2) }}, 
      {{ SC_(7.624480247497558593750000000000000000000), SC_(3.049792098999023437500000000000000000000e1), SC_(1.279526672363281250000000000000000000000e2), SC_(7.688127756118774414062500000000000000000e-1), SC_(9.200685609402012770972334698170512284356e-1), SC_(7.993143905979872290276653018294877156437e-2) }}, 
      {{ SC_(7.624480247497558593750000000000000000000), SC_(3.049792098999023437500000000000000000000e1), SC_(1.831471099853515625000000000000000000000e2), SC_(8.181311488151550292968750000000000000000e-1), SC_(9.153100699281930939686446815949785497444e-1), SC_(8.468993007180690603135531840502145025556e-2) }}, 
      {{ SC_(7.624480247497558593750000000000000000000), SC_(3.812240219116210937500000000000000000000e1), SC_(3.767639541625976562500000000000000000000e1), SC_(6.047118902206420898437500000000000000000e-1), SC_(9.974585483491717219160912674151947264988e-1), SC_(2.541451650828278083908732584805273501214e-3) }}, 
      {{ SC_(7.624480247497558593750000000000000000000), SC_(3.812240219116210937500000000000000000000e1), SC_(1.310955810546875000000000000000000000000e2), SC_(7.704344391822814941406250000000000000000e-1), SC_(9.925100425218208742075372658793746074022e-1), SC_(7.489957478179125792462734120625392597827e-3) }}, 
      {{ SC_(7.624480247497558593750000000000000000000), SC_(3.812240219116210937500000000000000000000e1), SC_(1.867986450195312500000000000000000000000e2), SC_(8.164697885513305664062500000000000000000e-1), SC_(9.913139558893207273343961301792093710870e-1), SC_(8.686044110679272665603869820790628912963e-3) }}, 
      {{ SC_(1.995931053161621093750000000000000000000e1), SC_(1.995931029319763183593750000000000000000), SC_(3.423733520507812500000000000000000000000e1), SC_(9.741731882095336914062500000000000000000e-1), SC_(7.408382940705442812761382870570004799152e-1), SC_(2.591617059294557187238617129429995200848e-1) }}, 
      {{ SC_(1.995931053161621093750000000000000000000e1), SC_(1.995931029319763183593750000000000000000), SC_(1.264718551635742187500000000000000000000e2), SC_(9.881834983825683593750000000000000000000e-1), SC_(7.365371281653738626256831449404403937075e-1), SC_(2.634628718346261373743168550595596062925e-1) }}, 
      {{ SC_(1.995931053161621093750000000000000000000e1), SC_(1.995931029319763183593750000000000000000), SC_(1.826751708984375000000000000000000000000e2), SC_(9.911285638809204101562500000000000000000e-1), SC_(7.360356893309326805076449063728270553799e-1), SC_(2.639643106690673194923550936271729446201e-1) }}, 
      {{ SC_(1.995931053161621093750000000000000000000e1), SC_(4.989827632904052734375000000000000000000), SC_(3.477303314208984375000000000000000000000e1), SC_(9.603310823440551757812500000000000000000e-1), SC_(9.753188879694608208470656696863880115085e-1), SC_(2.468111203053917915293433031361198849151e-2) }}, 
      {{ SC_(1.995931053161621093750000000000000000000e1), SC_(4.989827632904052734375000000000000000000), SC_(1.279526672363281250000000000000000000000e2), SC_(9.811445474624633789062500000000000000000e-1), SC_(9.730024497157043772087854153004967979111e-1), SC_(2.699755028429562279121458469950320208888e-2) }}, 
      {{ SC_(1.995931053161621093750000000000000000000e1), SC_(4.989827632904052734375000000000000000000), SC_(1.831471099853515625000000000000000000000e2), SC_(9.856294393539428710937500000000000000000e-1), SC_(9.727143538596598471393626669677729628799e-1), SC_(2.728564614034015286063733303222703712006e-2) }}, 
      {{ SC_(1.995931053161621093750000000000000000000e1), SC_(9.979655265808105468750000000000000000000), SC_(3.767639541625976562500000000000000000000e1), SC_(9.484457969665527343750000000000000000000e-1), SC_(9.998172337658695019615371193026397227315e-1), SC_(1.827662341304980384628806973602772684657e-4) }}, 
      {{ SC_(1.995931053161621093750000000000000000000e1), SC_(9.979655265808105468750000000000000000000), SC_(1.310955810546875000000000000000000000000e2), SC_(9.736837744712829589843750000000000000000e-1), SC_(9.997473186095272219631887279280689836660e-1), SC_(2.526813904727780368112720719310163340037e-4) }}, 
      {{ SC_(1.995931053161621093750000000000000000000e1), SC_(9.979655265808105468750000000000000000000), SC_(1.867986450195312500000000000000000000000e2), SC_(9.796475768089294433593750000000000000000e-1), SC_(9.997361542911015734345905143450935330183e-1), SC_(2.638457088984265654094856549064669816569e-4) }}, 
      {{ SC_(1.995931053161621093750000000000000000000e1), SC_(1.496948242187500000000000000000000000000e1), SC_(4.238486480712890625000000000000000000000e1), SC_(9.462940692901611328125000000000000000000e-1), SC_(9.999997225413026385848802769260578168407e-1), SC_(2.774586973614151197230739421831592713956e-7) }}, 
      {{ SC_(1.995931053161621093750000000000000000000e1), SC_(1.496948242187500000000000000000000000000e1), SC_(1.311481323242187500000000000000000000000e2), SC_(9.700174331665039062500000000000000000000e-1), SC_(9.999994738938901984771105462345944196467e-1), SC_(5.261061098015228894537654055803532732147e-7) }}, 
      {{ SC_(1.995931053161621093750000000000000000000e1), SC_(1.496948242187500000000000000000000000000e1), SC_(1.914333953857421875000000000000000000000e2), SC_(9.769552946090698242187500000000000000000e-1), SC_(9.999994124711133180273035689866300266105e-1), SC_(5.875288866819726964310133699733894708452e-7) }}, 
      {{ SC_(1.995931053161621093750000000000000000000e1), SC_(1.796337890625000000000000000000000000000e1), SC_(4.420680999755859375000000000000000000000e1), SC_(6.989046931266784667968750000000000000000e-2), SC_(1.541415905847030040364960568148174613008e-22), SC_(9.999999999999999999998458584094152969960e-1) }}, 
      {{ SC_(1.995931053161621093750000000000000000000e1), SC_(1.796337890625000000000000000000000000000e1), SC_(1.357470245361328125000000000000000000000e2), SC_(8.291780948638916015625000000000000000000e-2), SC_(3.943611693933028746175091781549447528318e-38), SC_(9.999999999999999999999999999999999999606e-1) }}, 
      {{ SC_(1.995931053161621093750000000000000000000e1), SC_(1.796337890625000000000000000000000000000e1), SC_(1.915013732910156250000000000000000000000e2), SC_(8.648972958326339721679687500000000000000e-2), SC_(3.986693162600503871428823597727742020261e-48), SC_(1.000000000000000000000000000000000000000) }}, 
      {{ SC_(1.995931053161621093750000000000000000000e1), SC_(1.975971794128417968750000000000000000000e1), SC_(5.569964599609375000000000000000000000000e1), SC_(1.764444708824157714843750000000000000000e-1), SC_(7.086141772160172188722634200465002941712e-15), SC_(9.999999999999929138582278398278112773658e-1) }}, 
      {{ SC_(1.995931053161621093750000000000000000000e1), SC_(1.975971794128417968750000000000000000000e1), SC_(1.362719116210937500000000000000000000000e2), SC_(2.039301395416259765625000000000000000000e-1), SC_(2.167594331132033517339292393017988105871e-25), SC_(9.999999999999999999999997832405668867966e-1) }}, 
      {{ SC_(1.995931053161621093750000000000000000000e1), SC_(1.975971794128417968750000000000000000000e1), SC_(1.918984832763671875000000000000000000000e2), SC_(2.133983671665191650390625000000000000000e-1), SC_(4.006395383614845886273721517122751711436e-33), SC_(9.999999999999999999999999999999959936046e-1) }}, 
      {{ SC_(1.995931053161621093750000000000000000000e1), SC_(1.993935203552246093750000000000000000000e1), SC_(5.940588760375976562500000000000000000000e1), SC_(3.558825850486755371093750000000000000000e-1), SC_(1.316792957722986392279017932711226555636e-7), SC_(9.999998683207042277013607720982067288773e-1) }}, 
      {{ SC_(1.995931053161621093750000000000000000000e1), SC_(1.993935203552246093750000000000000000000e1), SC_(1.451677856445312500000000000000000000000e2), SC_(4.108584523200988769531250000000000000000e-1), SC_(4.656371478281345568373251459288408023899e-14), SC_(9.999999999999534362852171865443162674854e-1) }}, 
      {{ SC_(1.995931053161621093750000000000000000000e1), SC_(1.993935203552246093750000000000000000000e1), SC_(1.929777069091796875000000000000000000000e2), SC_(4.265226721763610839843750000000000000000e-1), SC_(5.167697951249365772670201174518338833788e-18), SC_(9.999999999999999948323020487506342273298e-1) }}, 
      {{ SC_(1.995931053161621093750000000000000000000e1), SC_(1.995931053161621093750000000000000000000e1), SC_(6.038262176513671875000000000000000000000e1), SC_(5.351741313934326171875000000000000000000e-1), SC_(2.978727713147487405618880338582143291906e-3), SC_(9.970212722868525125943811196614178567081e-1) }}, 
      {{ SC_(1.995931053161621093750000000000000000000e1), SC_(1.995931053161621093750000000000000000000e1), SC_(1.481294555664062500000000000000000000000e2), SC_(6.179208755493164062500000000000000000000e-1), SC_(9.074331652010097105431852299377019654278e-6), SC_(9.999909256683479899028945681477006229803e-1) }}, 
      {{ SC_(1.995931053161621093750000000000000000000e1), SC_(1.995931053161621093750000000000000000000e1), SC_(1.935389862060546875000000000000000000000e2), SC_(6.399171948432922363281250000000000000000e-1), SC_(2.862745986073834584347808505738760950446e-7), SC_(9.999997137254013926165415652191494261239e-1) }}, 
      {{ SC_(1.995931053161621093750000000000000000000e1), SC_(1.996130752563476562500000000000000000000e1), SC_(6.163340759277343750000000000000000000000e1), SC_(6.444656252861022949218750000000000000000e-1), SC_(1.130706919611876908329532228461076353491e-1), SC_(8.869293080388123091670467771538923646509e-1) }}, 
      {{ SC_(1.995931053161621093750000000000000000000e1), SC_(1.996130752563476562500000000000000000000e1), SC_(1.486264953613281250000000000000000000000e2), SC_(7.418377399444580078125000000000000000000e-1), SC_(2.386645306159966159274383606778639530506e-2), SC_(9.761335469384003384072561639322136046949e-1) }}, 
      {{ SC_(1.995931053161621093750000000000000000000e1), SC_(1.996130752563476562500000000000000000000e1), SC_(1.937735595703125000000000000000000000000e2), SC_(7.680028676986694335937500000000000000000e-1), SC_(9.287367914997785443309213661391813553237e-3), SC_(9.907126320850022145566907863386081864468e-1) }}, 
      {{ SC_(1.995931053161621093750000000000000000000e1), SC_(1.997927093505859375000000000000000000000e1), SC_(7.225879669189453125000000000000000000000e1), SC_(7.283527255058288574218750000000000000000e-1), SC_(4.250755609018307710611375039776811545152e-1), SC_(5.749244390981692289388624960223188454848e-1) }}, 
      {{ SC_(1.995931053161621093750000000000000000000e1), SC_(1.997927093505859375000000000000000000000e1), SC_(1.515480346679687500000000000000000000000e2), SC_(8.180963993072509765625000000000000000000e-1), SC_(3.886716166425962258099172631187086984953e-1), SC_(6.113283833574037741900827368812913015047e-1) }}, 
      {{ SC_(1.995931053161621093750000000000000000000e1), SC_(1.997927093505859375000000000000000000000e1), SC_(1.941185607910156250000000000000000000000e2), SC_(8.448753952980041503906250000000000000000e-1), SC_(3.707170346668911875254653800081967037812e-1), SC_(6.292829653331088124745346199918032962188e-1) }}, 
      {{ SC_(1.995931053161621093750000000000000000000e1), SC_(2.015890312194824218750000000000000000000e1), SC_(9.566968083381652832031250000000000000000e-1), SC_(5.027858018875122070312500000000000000000e-1), SC_(4.969412997890168330137207647114440090776e-1), SC_(5.030587002109831669862792352885559909224e-1) }}, 
      {{ SC_(1.995931053161621093750000000000000000000e1), SC_(2.015890312194824218750000000000000000000e1), SC_(7.844540405273437500000000000000000000000e1), SC_(7.435929775238037109375000000000000000000e-1), SC_(4.715853908811941614877409812552808367336e-1), SC_(5.284146091188058385122590187447191632664e-1) }}, 
      {{ SC_(1.995931053161621093750000000000000000000e1), SC_(2.015890312194824218750000000000000000000e1), SC_(1.584414672851562500000000000000000000000e2), SC_(8.293088674545288085937500000000000000000e-1), SC_(4.643014645147949480020151112391576934988e-1), SC_(5.356985354852050519979848887608423065012e-1) }}, 
      {{ SC_(1.995931053161621093750000000000000000000e1), SC_(2.015890312194824218750000000000000000000e1), SC_(1.962219390869140625000000000000000000000e2), SC_(8.525609374046325683593750000000000000000e-1), SC_(4.619209726863627855699324793778868517598e-1), SC_(5.380790273136372144300675206221131482402e-1) }}, 
      {{ SC_(1.995931053161621093750000000000000000000e1), SC_(2.195524215698242187500000000000000000000e1), SC_(7.142335891723632812500000000000000000000), SC_(5.164825916290283203125000000000000000000e-1), SC_(4.970058567386508226991101241744207835166e-1), SC_(5.029941432613491773008898758255792164834e-1) }}, 
      {{ SC_(1.995931053161621093750000000000000000000e1), SC_(2.195524215698242187500000000000000000000e1), SC_(7.974770355224609375000000000000000000000e1), SC_(7.299603223800659179687500000000000000000e-1), SC_(4.786123736123854171606633620070760911465e-1), SC_(5.213876263876145828393366379929239088535e-1) }}, 
      {{ SC_(1.995931053161621093750000000000000000000e1), SC_(2.195524215698242187500000000000000000000e1), SC_(1.595857238769531250000000000000000000000e2), SC_(8.186346292495727539062500000000000000000e-1), SC_(4.746474422857339344595202026425607585186e-1), SC_(5.253525577142660655404797973574392414814e-1) }}, 
      {{ SC_(1.995931053161621093750000000000000000000e1), SC_(2.195524215698242187500000000000000000000e1), SC_(1.985762634277343750000000000000000000000e2), SC_(8.437382578849792480468750000000000000000e-1), SC_(4.738432252689081778139651906850833680783e-1), SC_(5.261567747310918221860348093149166319217e-1) }}, 
      {{ SC_(1.995931053161621093750000000000000000000e1), SC_(2.395117378234863281250000000000000000000e1), SC_(1.950807952880859375000000000000000000000e1), SC_(5.522201657295227050781250000000000000000e-1), SC_(4.927544873878115256027679844644216222808e-1), SC_(5.072455126121884743972320155355783777192e-1) }}, 
      {{ SC_(1.995931053161621093750000000000000000000e1), SC_(2.395117378234863281250000000000000000000e1), SC_(8.435225677490234375000000000000000000000e1), SC_(7.202227711677551269531250000000000000000e-1), SC_(4.799862519169614921818046457155353732424e-1), SC_(5.200137480830385078181953542844646267576e-1) }}, 
      {{ SC_(1.995931053161621093750000000000000000000e1), SC_(2.395117378234863281250000000000000000000e1), SC_(1.596211700439453125000000000000000000000e2), SC_(8.054199814796447753906250000000000000000e-1), SC_(4.762559125275585909009620055365705786500e-1), SC_(5.237440874724414090990379944634294213500e-1) }}, 
      {{ SC_(1.995931053161621093750000000000000000000e1), SC_(2.395117378234863281250000000000000000000e1), SC_(1.992922668457031250000000000000000000000e2), SC_(8.323687314987182617187500000000000000000e-1), SC_(4.753937827383009088066631387982761164002e-1), SC_(5.246062172616990911933368612017238835998e-1) }}, 
      {{ SC_(1.995931053161621093750000000000000000000e1), SC_(2.594710350036621093750000000000000000000e1), SC_(2.197235107421875000000000000000000000000e1), SC_(5.428374409675598144531250000000000000000e-1), SC_(4.956800307961997114278459588570310829491e-1), SC_(5.043199692038002885721540411429689170509e-1) }}, 
      {{ SC_(1.995931053161621093750000000000000000000e1), SC_(2.594710350036621093750000000000000000000e1), SC_(8.441753387451171875000000000000000000000e1), SC_(7.042269110679626464843750000000000000000e-1), SC_(4.833786578470320072983235534849258838431e-1), SC_(5.166213421529679927016764465150741161569e-1) }}, 
      {{ SC_(1.995931053161621093750000000000000000000e1), SC_(2.594710350036621093750000000000000000000e1), SC_(1.600560913085937500000000000000000000000e2), SC_(7.931306362152099609375000000000000000000e-1), SC_(4.794078092864211721613534089241989534103e-1), SC_(5.205921907135788278386465910758010465897e-1) }}, 
      {{ SC_(1.995931053161621093750000000000000000000e1), SC_(2.993896484375000000000000000000000000000e1), SC_(2.249290275573730468750000000000000000000e1), SC_(5.137485861778259277343750000000000000000e-1), SC_(5.235170389752835539128855091236904809155e-1), SC_(4.764829610247164460871144908763095190845e-1) }}, 
      {{ SC_(1.995931053161621093750000000000000000000e1), SC_(2.993896484375000000000000000000000000000e1), SC_(9.495173645019531250000000000000000000000e1), SC_(6.940567493438720703125000000000000000000e-1), SC_(5.062761805085524109597413191981272351845e-1), SC_(4.937238194914475890402586808018727648155e-1) }}, 
      {{ SC_(1.995931053161621093750000000000000000000e1), SC_(2.993896484375000000000000000000000000000e1), SC_(1.629447326660156250000000000000000000000e2), SC_(7.732942700386047363281250000000000000000e-1), SC_(5.020290210689933361337430653481245253324e-1), SC_(4.979709789310066638662569346518754746676e-1) }}, 
      {{ SC_(1.995931053161621093750000000000000000000e1), SC_(3.991862106323242187500000000000000000000e1), SC_(2.539736366271972656250000000000000000000e1), SC_(4.987759590148925781250000000000000000000e-1), SC_(7.813885935375723935343961116642161881538e-1), SC_(2.186114064624276064656038883357838118462e-1) }}, 
      {{ SC_(1.995931053161621093750000000000000000000e1), SC_(3.991862106323242187500000000000000000000e1), SC_(9.707512664794921875000000000000000000000e1), SC_(6.638901829719543457031250000000000000000e-1), SC_(7.338931087294629977412262345353223483737e-1), SC_(2.661068912705370022587737654646776516263e-1) }}, 
      {{ SC_(1.995931053161621093750000000000000000000e1), SC_(3.991862106323242187500000000000000000000e1), SC_(1.670017089843750000000000000000000000000e2), SC_(7.458685636520385742187500000000000000000e-1), SC_(7.207487623216047013458220111033644266719e-1), SC_(2.792512376783952986541779888966355733281e-1) }}, 
      {{ SC_(1.995931053161621093750000000000000000000e1), SC_(5.987792968750000000000000000000000000000e1), SC_(2.709540176391601562500000000000000000000e1), SC_(4.648410081863403320312500000000000000000e-1), SC_(9.714378410852579699015849655663674153434e-1), SC_(2.856215891474203009841503443363258465657e-2) }}, 
      {{ SC_(1.995931053161621093750000000000000000000e1), SC_(5.987792968750000000000000000000000000000e1), SC_(1.007325439453125000000000000000000000000e2), SC_(6.156285405158996582031250000000000000000e-1), SC_(9.398977916777962465347502846202321319832e-1), SC_(6.010220832220375346524971537976786801678e-2) }}, 
      {{ SC_(1.995931053161621093750000000000000000000e1), SC_(5.987792968750000000000000000000000000000e1), SC_(1.698258666992187500000000000000000000000e2), SC_(6.961801648139953613281250000000000000000e-1), SC_(9.274408938538724339984782060823000808991e-1), SC_(7.255910614612756600152179391769991910087e-2) }}, 
      {{ SC_(1.995931053161621093750000000000000000000e1), SC_(7.983724212646484375000000000000000000000e1), SC_(2.837726783752441406250000000000000000000e1), SC_(4.606287479400634765625000000000000000000e-1), SC_(9.993177569139733889940129887383697757984e-1), SC_(6.822430860266110059870112616302242016109e-4) }}, 
      {{ SC_(1.995931053161621093750000000000000000000e1), SC_(7.983724212646484375000000000000000000000e1), SC_(1.093762969970703125000000000000000000000e2), SC_(6.015528440475463867187500000000000000000e-1), SC_(9.955555255775011630748569686361844168189e-1), SC_(4.444474422498836925143031363815583181133e-3) }}, 
      {{ SC_(1.995931053161621093750000000000000000000e1), SC_(7.983724212646484375000000000000000000000e1), SC_(1.756861267089843750000000000000000000000e2), SC_(6.718897223472595214843750000000000000000e-1), SC_(9.931137747426306132851364220622300065618e-1), SC_(6.886225257369386714863577937769993438228e-3) }}, 
      {{ SC_(1.995931053161621093750000000000000000000e1), SC_(9.979655456542968750000000000000000000000e1), SC_(3.152261734008789062500000000000000000000e1), SC_(5.086369514465332031250000000000000000000e-1), SC_(9.999999412292843983789844041562565170640e-1), SC_(5.877071560162101559584374348293595366081e-8) }}, 
      {{ SC_(1.995931053161621093750000000000000000000e1), SC_(9.979655456542968750000000000000000000000e1), SC_(1.094441146850585937500000000000000000000e2), SC_(6.179996132850646972656250000000000000000e-1), SC_(9.999963011069543439437960806845487715181e-1), SC_(3.698893045656056203919315451228481926462e-6) }}, 
      {{ SC_(1.995931053161621093750000000000000000000e1), SC_(9.979655456542968750000000000000000000000e1), SC_(1.811583862304687500000000000000000000000e2), SC_(6.830425858497619628906250000000000000000e-1), SC_(9.999875350118307225168050085180514951668e-1), SC_(1.246498816927748319499148194850483323863e-5) }}, 
      {{ SC_(2.241741943359375000000000000000000000000e1), SC_(2.241741895675659179687500000000000000000), SC_(2.709540176391601562500000000000000000000e1), SC_(9.703907966613769531250000000000000000000e-1), SC_(7.635829916461788274785160669645831585802e-1), SC_(2.364170083538211725214839330354168414198e-1) }}, 
      {{ SC_(2.241741943359375000000000000000000000000e1), SC_(2.241741895675659179687500000000000000000), SC_(1.007325439453125000000000000000000000000e2), SC_(9.849264621734619140625000000000000000000e-1), SC_(7.584994117007332038678540002743882786950e-1), SC_(2.415005882992667961321459997256117213050e-1) }}, 
      {{ SC_(2.241741943359375000000000000000000000000e1), SC_(2.241741895675659179687500000000000000000), SC_(1.698258666992187500000000000000000000000e2), SC_(9.896981120109558105468750000000000000000e-1), SC_(7.575499559255044548327896743816837662904e-1), SC_(2.424500440744955451672103256183162337096e-1) }}, 
      {{ SC_(2.241741943359375000000000000000000000000e1), SC_(5.604354858398437500000000000000000000000), SC_(2.837726783752441406250000000000000000000e1), SC_(9.553902745246887207031250000000000000000e-1), SC_(9.827615437879942153773469825584679850322e-1), SC_(1.723845621200578462265301744153201496781e-2) }}, 
      {{ SC_(2.241741943359375000000000000000000000000e1), SC_(5.604354858398437500000000000000000000000), SC_(1.093762969970703125000000000000000000000e2), SC_(9.772330522537231445312500000000000000000e-1), SC_(9.805683888437216165262780302480661286797e-1), SC_(1.943161115627838347372196975193387132031e-2) }}, 
      {{ SC_(2.241741943359375000000000000000000000000e1), SC_(5.604354858398437500000000000000000000000), SC_(1.756861267089843750000000000000000000000e2), SC_(9.837712645530700683593750000000000000000e-1), SC_(9.801803585213448860391980071037238737304e-1), SC_(1.981964147865511396080199289627612626965e-2) }}, 
      {{ SC_(2.241741943359375000000000000000000000000e1), SC_(1.120870971679687500000000000000000000000e1), SC_(3.152261734008789062500000000000000000000e1), SC_(9.428946971893310546875000000000000000000e-1), SC_(9.999327596803017143611420915683964167509e-1), SC_(6.724031969828563885790843160358324911206e-5) }}, 
      {{ SC_(2.241741943359375000000000000000000000000e1), SC_(1.120870971679687500000000000000000000000e1), SC_(1.094441146850585937500000000000000000000e2), SC_(9.680601954460144042968750000000000000000e-1), SC_(9.998976764344291002987649890648685920297e-1), SC_(1.023235655708997012350109351314079703335e-4) }}, 
      {{ SC_(2.241741943359375000000000000000000000000e1), SC_(1.120870971679687500000000000000000000000e1), SC_(1.811583862304687500000000000000000000000e2), SC_(9.773066639900207519531250000000000000000e-1), SC_(9.998883216981117757565806133741020322118e-1), SC_(1.116783018882242434193866258979677882322e-4) }}, 
      {{ SC_(2.241741943359375000000000000000000000000e1), SC_(1.681306457519531250000000000000000000000e1), SC_(3.423733520507812500000000000000000000000e1), SC_(9.400036931037902832031250000000000000000e-1), SC_(9.999999598203098643331479190588131760091e-1), SC_(4.017969013566685208094118682399092570886e-8) }}, 
      {{ SC_(2.241741943359375000000000000000000000000e1), SC_(1.681306457519531250000000000000000000000e1), SC_(1.264718551635742187500000000000000000000e2), SC_(9.669856429100036621093750000000000000000e-1), SC_(9.999998981986600335909693355817767458296e-1), SC_(1.018013399664090306644182232541703525367e-7) }}, 
      {{ SC_(2.241741943359375000000000000000000000000e1), SC_(1.681306457519531250000000000000000000000e1), SC_(1.826751708984375000000000000000000000000e2), SC_(9.741082787513732910156250000000000000000e-1), SC_(9.999998827743325633909442022921262828630e-1), SC_(1.172256674366090557977078737171369948468e-7) }}, 
      {{ SC_(2.241741943359375000000000000000000000000e1), SC_(2.017567634582519531250000000000000000000e1), SC_(3.477303314208984375000000000000000000000e1), SC_(6.619987636804580688476562500000000000000e-2), SC_(8.299957997484651336439434638942611769324e-23), SC_(9.999999999999999999999170004200251534866e-1) }}, 
      {{ SC_(2.241741943359375000000000000000000000000e1), SC_(2.017567634582519531250000000000000000000e1), SC_(1.279526672363281250000000000000000000000e2), SC_(8.096139878034591674804687500000000000000e-2), SC_(2.776862058962013023307418088479883467159e-38), SC_(9.999999999999999999999999999999999999722e-1) }}, 
      {{ SC_(2.241741943359375000000000000000000000000e1), SC_(2.017567634582519531250000000000000000000e1), SC_(1.831471099853515625000000000000000000000e2), SC_(8.488573133945465087890625000000000000000e-2), SC_(4.539601934054068143316613916925916609917e-48), SC_(1.000000000000000000000000000000000000000) }}, 
      {{ SC_(2.241741943359375000000000000000000000000e1), SC_(2.219324493408203125000000000000000000000e1), SC_(3.767639541625976562500000000000000000000e1), SC_(1.621454060077667236328125000000000000000e-1), SC_(1.427128617140851113427900853557590172752e-13), SC_(9.999999999998572871382859148886572099146e-1) }}, 
      {{ SC_(2.241741943359375000000000000000000000000e1), SC_(2.219324493408203125000000000000000000000e1), SC_(1.310955810546875000000000000000000000000e2), SC_(1.993612945079803466796875000000000000000e-1), SC_(2.561867126294035801350150137029858904247e-25), SC_(9.999999999999999999999997438132873705964e-1) }}, 
      {{ SC_(2.241741943359375000000000000000000000000e1), SC_(2.219324493408203125000000000000000000000e1), SC_(1.867986450195312500000000000000000000000e2), SC_(2.096006125211715698242187500000000000000e-1), SC_(6.148308895790599844958183920373339693805e-33), SC_(9.999999999999999999999999999999938516911e-1) }}, 
      {{ SC_(2.241741943359375000000000000000000000000e1), SC_(2.239500236511230468750000000000000000000e1), SC_(4.238486480712890625000000000000000000000e1), SC_(3.295281529426574707031250000000000000000e-1), SC_(9.430648810993725423217849034933858629676e-7), SC_(9.999990569351189006274576782150965066141e-1) }}, 
      {{ SC_(2.241741943359375000000000000000000000000e1), SC_(2.239500236511230468750000000000000000000e1), SC_(1.311481323242187500000000000000000000000e2), SC_(3.980150520801544189453125000000000000000e-1), SC_(4.792773513038008166837294944328830296199e-13), SC_(9.999999999995207226486961991833162705056e-1) }}, 
      {{ SC_(2.241741943359375000000000000000000000000e1), SC_(2.239500236511230468750000000000000000000e1), SC_(1.914333953857421875000000000000000000000e2), SC_(4.199328124523162841796875000000000000000e-1), SC_(7.016081038358678888161074556425999689765e-18), SC_(9.999999999999999929839189616413211118389e-1) }}, 
      {{ SC_(2.241741943359375000000000000000000000000e1), SC_(2.241741943359375000000000000000000000000e1), SC_(4.420680999755859375000000000000000000000e1), SC_(4.975881576538085937500000000000000000000e-1), SC_(6.457417203689098926322454195490891054589e-3), SC_(9.935425827963109010736775458045091089454e-1) }}, 
      {{ SC_(2.241741943359375000000000000000000000000e1), SC_(2.241741943359375000000000000000000000000e1), SC_(1.357470245361328125000000000000000000000e2), SC_(6.000297665596008300781250000000000000000e-1), SC_(2.468945109267072581572662489051005468883e-5), SC_(9.999753105489073292741842733751094899453e-1) }}, 
      {{ SC_(2.241741943359375000000000000000000000000e1), SC_(2.241741943359375000000000000000000000000e1), SC_(1.915013732910156250000000000000000000000e2), SC_(6.298274993896484375000000000000000000000e-1), SC_(4.371898672910001218245475856290738416967e-7), SC_(9.999995628101327089998781754524143709262e-1) }}, 
      {{ SC_(2.241741943359375000000000000000000000000e1), SC_(2.241966247558593750000000000000000000000e1), SC_(5.569964599609375000000000000000000000000e1), SC_(6.209393143653869628906250000000000000000e-1), SC_(1.230617716293545963006052264276936901717e-1), SC_(8.769382283706454036993947735723063098283e-1) }}, 
      {{ SC_(2.241741943359375000000000000000000000000e1), SC_(2.241966247558593750000000000000000000000e1), SC_(1.362719116210937500000000000000000000000e2), SC_(7.204402089118957519531250000000000000000e-1), SC_(3.258095306338609065701942004994775445733e-2), SC_(9.674190469366139093429805799500522455427e-1) }}, 
      {{ SC_(2.241741943359375000000000000000000000000e1), SC_(2.241966247558593750000000000000000000000e1), SC_(1.918984832763671875000000000000000000000e2), SC_(7.559847831726074218750000000000000000000e-1), SC_(1.102543036729227321924107952065577767094e-2), SC_(9.889745696327077267807589204793442223291e-1) }}, 
      {{ SC_(2.241741943359375000000000000000000000000e1), SC_(2.243983840942382812500000000000000000000e1), SC_(5.940588760375976562500000000000000000000e1), SC_(6.904550194740295410156250000000000000000e-1), SC_(4.337121160333579056570227115592226818220e-1), SC_(5.662878839666420943429772884407773181780e-1) }}, 
      {{ SC_(2.241741943359375000000000000000000000000e1), SC_(2.243983840942382812500000000000000000000e1), SC_(1.451677856445312500000000000000000000000e2), SC_(7.998421788215637207031250000000000000000e-1), SC_(3.952962879090011769497294019448643942574e-1), SC_(6.047037120909988230502705980551356057426e-1) }}, 
      {{ SC_(2.241741943359375000000000000000000000000e1), SC_(2.243983840942382812500000000000000000000e1), SC_(1.929777069091796875000000000000000000000e2), SC_(8.320704698562622070312500000000000000000e-1), SC_(3.760157092848693874986336462815890132920e-1), SC_(6.239842907151306125013663537184109867080e-1) }}, 
      {{ SC_(2.241741943359375000000000000000000000000e1), SC_(2.264159393310546875000000000000000000000e1), SC_(6.038262176513671875000000000000000000000e1), SC_(6.968145966529846191406250000000000000000e-1), SC_(4.763801139154600932667751557568374427056e-1), SC_(5.236198860845399067332248442431625572944e-1) }}, 
      {{ SC_(2.241741943359375000000000000000000000000e1), SC_(2.264159393310546875000000000000000000000e1), SC_(1.481294555664062500000000000000000000000e2), SC_(8.081311583518981933593750000000000000000e-1), SC_(4.672128838407926063042278834720376507600e-1), SC_(5.327871161592073936957721165279623492400e-1) }}, 
      {{ SC_(2.241741943359375000000000000000000000000e1), SC_(2.264159393310546875000000000000000000000e1), SC_(1.935389862060546875000000000000000000000e2), SC_(8.387517929077148437500000000000000000000e-1), SC_(4.643233044694214121561984055658981323481e-1), SC_(5.356766955305785878438015944341018676519e-1) }}, 
      {{ SC_(2.241741943359375000000000000000000000000e1), SC_(2.465916252136230468750000000000000000000e1), SC_(6.163340759277343750000000000000000000000e1), SC_(6.818158626556396484375000000000000000000e-1), SC_(4.826148971053793617132976289455589721885e-1), SC_(5.173851028946206382867023710544410278115e-1) }}, 
      {{ SC_(2.241741943359375000000000000000000000000e1), SC_(2.465916252136230468750000000000000000000e1), SC_(1.486264953613281250000000000000000000000e2), SC_(7.958352565765380859375000000000000000000e-1), SC_(4.768720090280046475637743747029598196363e-1), SC_(5.231279909719953524362256252970401803637e-1) }}, 
      {{ SC_(2.241741943359375000000000000000000000000e1), SC_(2.465916252136230468750000000000000000000e1), SC_(1.937735595703125000000000000000000000000e2), SC_(8.279114961624145507812500000000000000000e-1), SC_(4.757777837579221005869991010225498015466e-1), SC_(5.242222162420778994130008989774501984534e-1) }}, 
      {{ SC_(2.241741943359375000000000000000000000000e1), SC_(2.690090370178222656250000000000000000000e1), SC_(7.225879669189453125000000000000000000000e1), SC_(6.836508512496948242187500000000000000000e-1), SC_(4.831349365264527835502624389995538525326e-1), SC_(5.168650634735472164497375610004461474674e-1) }}, 
      {{ SC_(2.241741943359375000000000000000000000000e1), SC_(2.690090370178222656250000000000000000000e1), SC_(1.515480346679687500000000000000000000000e2), SC_(7.839319109916687011718750000000000000000e-1), SC_(4.783622090510290737801591362756259782103e-1), SC_(5.216377909489709262198408637243740217897e-1) }}, 
      {{ SC_(2.241741943359375000000000000000000000000e1), SC_(2.690090370178222656250000000000000000000e1), SC_(1.941185607910156250000000000000000000000e2), SC_(8.154085278511047363281250000000000000000e-1), SC_(4.772968661156615021824473793458829304726e-1), SC_(5.227031338843384978175526206541170695274e-1) }}, 
      {{ SC_(2.241741943359375000000000000000000000000e1), SC_(2.914264488220214843750000000000000000000e1), SC_(9.566968083381652832031250000000000000000e-1), SC_(4.404388964176177978515625000000000000000e-1), SC_(5.075156193494140475859616297564815123164e-1), SC_(4.924843806505859524140383702435184876836e-1) }}, 
      {{ SC_(2.241741943359375000000000000000000000000e1), SC_(2.914264488220214843750000000000000000000e1), SC_(7.844540405273437500000000000000000000000e1), SC_(6.777793169021606445312500000000000000000e-1), SC_(4.860159485314486060872620685736922462986e-1), SC_(5.139840514685513939127379314263077537014e-1) }}, 
      {{ SC_(2.241741943359375000000000000000000000000e1), SC_(2.914264488220214843750000000000000000000e1), SC_(1.584414672851562500000000000000000000000e2), SC_(7.763556838035583496093750000000000000000e-1), SC_(4.813978627534322877865185946823534982344e-1), SC_(5.186021372465677122134814053176465017656e-1) }}, 
      {{ SC_(2.241741943359375000000000000000000000000e1), SC_(2.914264488220214843750000000000000000000e1), SC_(1.962219390869140625000000000000000000000e2), SC_(8.046312928199768066406250000000000000000e-1), SC_(4.804379157460654364066594536424021730503e-1), SC_(5.195620842539345635933405463575978269497e-1) }}, 
      {{ SC_(2.241741943359375000000000000000000000000e1), SC_(3.362612915039062500000000000000000000000e1), SC_(7.142335891723632812500000000000000000000), SC_(4.409660100936889648437500000000000000000e-1), SC_(5.365801037565103439326697412437294751765e-1), SC_(4.634198962434896560673302587562705248235e-1) }}, 
      {{ SC_(2.241741943359375000000000000000000000000e1), SC_(3.362612915039062500000000000000000000000e1), SC_(7.974770355224609375000000000000000000000e1), SC_(6.513928771018981933593750000000000000000e-1), SC_(5.115807794620776748625937135181971649120e-1), SC_(4.884192205379223251374062864818028350880e-1) }}, 
      {{ SC_(2.241741943359375000000000000000000000000e1), SC_(3.362612915039062500000000000000000000000e1), SC_(1.595857238769531250000000000000000000000e2), SC_(7.538422942161560058593750000000000000000e-1), SC_(5.054153923254303746083576412896473693523e-1), SC_(4.945846076745696253916423587103526306477e-1) }}, 
      {{ SC_(2.241741943359375000000000000000000000000e1), SC_(3.362612915039062500000000000000000000000e1), SC_(1.985762634277343750000000000000000000000e2), SC_(7.847818732261657714843750000000000000000e-1), SC_(5.040760839883801119619830091417282127130e-1), SC_(4.959239160116198880380169908582717872870e-1) }}, 
      {{ SC_(2.241741943359375000000000000000000000000e1), SC_(4.483483886718750000000000000000000000000e1), SC_(1.950807952880859375000000000000000000000e1), SC_(4.698357284069061279296875000000000000000e-1), SC_(8.079301186554627703766345794083912517163e-1), SC_(1.920698813445372296233654205916087482837e-1) }}, 
      {{ SC_(2.241741943359375000000000000000000000000e1), SC_(4.483483886718750000000000000000000000000e1), SC_(8.435225677490234375000000000000000000000e1), SC_(6.262167096138000488281250000000000000000e-1), SC_(7.552453942045795934042530739291088417071e-1), SC_(2.447546057954204065957469260708911582929e-1) }}, 
      {{ SC_(2.241741943359375000000000000000000000000e1), SC_(4.483483886718750000000000000000000000000e1), SC_(1.596211700439453125000000000000000000000e2), SC_(7.218239903450012207031250000000000000000e-1), SC_(7.373899323785499796156031502131470439582e-1), SC_(2.626100676214500203843968497868529560418e-1) }}, 
      {{ SC_(2.241741943359375000000000000000000000000e1), SC_(4.483483886718750000000000000000000000000e1), SC_(1.992922668457031250000000000000000000000e2), SC_(7.549122571945190429687500000000000000000e-1), SC_(7.328553280011029573928031024135869197053e-1), SC_(2.671446719988970426071968975864130802947e-1) }}, 
      {{ SC_(2.241741943359375000000000000000000000000e1), SC_(6.725225830078125000000000000000000000000e1), SC_(2.197235107421875000000000000000000000000e1), SC_(4.426124691963195800781250000000000000000e-1), SC_(9.824718193643486560792490308815777391566e-1), SC_(1.752818063565134392075096911842226084340e-2) }}, 
      {{ SC_(2.241741943359375000000000000000000000000e1), SC_(6.725225830078125000000000000000000000000e1), SC_(8.441753387451171875000000000000000000000e1), SC_(5.740050077438354492187500000000000000000e-1), SC_(9.573595341300341238766404919691728435772e-1), SC_(4.264046586996587612335950803082715642283e-2) }}, 
      {{ SC_(2.241741943359375000000000000000000000000e1), SC_(6.725225830078125000000000000000000000000e1), SC_(1.600560913085937500000000000000000000000e2), SC_(6.688270568847656250000000000000000000000e-1), SC_(9.426886360757341564135860634931872259130e-1), SC_(5.731136392426584358641393650681277408698e-2) }}, 
      {{ SC_(2.241741943359375000000000000000000000000e1), SC_(8.966967773437500000000000000000000000000e1), SC_(2.249290275573730468750000000000000000000e1), SC_(4.403171241283416748046875000000000000000e-1), SC_(9.998068028470095026541010817931132180498e-1), SC_(1.931971529904973458989182068867819501823e-4) }}, 
      {{ SC_(2.241741943359375000000000000000000000000e1), SC_(8.966967773437500000000000000000000000000e1), SC_(9.495173645019531250000000000000000000000e1), SC_(5.669088959693908691406250000000000000000e-1), SC_(9.980089636787180459170659645460800632018e-1), SC_(1.991036321281954082934035453919936798213e-3) }}, 
      {{ SC_(2.241741943359375000000000000000000000000e1), SC_(8.966967773437500000000000000000000000000e1), SC_(1.629447326660156250000000000000000000000e2), SC_(6.428659558296203613281250000000000000000e-1), SC_(9.962384977136654251058731775841753405035e-1), SC_(3.761502286334574894126822415824659496480e-3) }}, 
      {{ SC_(2.241741943359375000000000000000000000000e1), SC_(1.120870971679687500000000000000000000000e2), SC_(2.539736366271972656250000000000000000000e1), SC_(4.920727014541625976562500000000000000000e-1), SC_(9.999999972630105638004271130198819145930e-1), SC_(2.736989436199572886980118085406989234164e-9) }}, 
      {{ SC_(2.241741943359375000000000000000000000000e1), SC_(1.120870971679687500000000000000000000000e2), SC_(9.707512664794921875000000000000000000000e1), SC_(5.911706089973449707031250000000000000000e-1), SC_(9.999995300183164206046435068448156771411e-1), SC_(4.699816835793953564931551843228588931883e-7) }}, 
      {{ SC_(2.241741943359375000000000000000000000000e1), SC_(1.120870971679687500000000000000000000000e2), SC_(1.670017089843750000000000000000000000000e2), SC_(6.566322445869445800781250000000000000000e-1), SC_(9.999975796834645003480373819987783277144e-1), SC_(2.420316535499651962618001221672285613313e-6) }}, 
      {{ SC_(2.293667030334472656250000000000000000000e1), SC_(2.293667078018188476562500000000000000000), SC_(2.197235107421875000000000000000000000000e1), SC_(9.680687189102172851562500000000000000000e-1), SC_(7.688187618129344717319483079585034439370e-1), SC_(2.311812381870655282680516920414965560630e-1) }}, 
      {{ SC_(2.293667030334472656250000000000000000000e1), SC_(2.293667078018188476562500000000000000000), SC_(8.441753387451171875000000000000000000000e1), SC_(9.828367233276367187500000000000000000000e-1), SC_(7.631810438338212214539061905239208273362e-1), SC_(2.368189561661787785460938094760791726638e-1) }}, 
      {{ SC_(2.293667030334472656250000000000000000000e1), SC_(2.293667078018188476562500000000000000000), SC_(1.600560913085937500000000000000000000000e2), SC_(9.890258908271789550781250000000000000000e-1), SC_(7.618303640603260322190474731549684763975e-1), SC_(2.381696359396739677809525268450315236025e-1) }}, 
      {{ SC_(2.293667030334472656250000000000000000000e1), SC_(5.734167575836181640625000000000000000000), SC_(2.249290275573730468750000000000000000000e1), SC_(9.517782926559448242187500000000000000000e-1), SC_(9.843673846642922793844015497955631012332e-1), SC_(1.563261533570772061559845020443689876677e-2) }}, 
      {{ SC_(2.293667030334472656250000000000000000000e1), SC_(5.734167575836181640625000000000000000000), SC_(9.495173645019531250000000000000000000000e1), SC_(9.746930599212646484375000000000000000000e-1), SC_(9.819923771777782768543047714907753766710e-1), SC_(1.800762282222172314569522850922462332904e-2) }}, 
      {{ SC_(2.293667030334472656250000000000000000000e1), SC_(5.734167575836181640625000000000000000000), SC_(1.629447326660156250000000000000000000000e2), SC_(9.825297594070434570312500000000000000000e-1), SC_(9.815080571269559150822804920535269482670e-1), SC_(1.849194287304408491771950794647305173304e-2) }}, 
      {{ SC_(2.293667030334472656250000000000000000000e1), SC_(1.146833515167236328125000000000000000000e1), SC_(2.539736366271972656250000000000000000000e1), SC_(9.387841224670410156250000000000000000000e-1), SC_(9.999496687450904693905637015486697083231e-1), SC_(5.033125490953060943629845133029167687759e-5) }}, 
      {{ SC_(2.293667030334472656250000000000000000000e1), SC_(1.146833515167236328125000000000000000000e1), SC_(9.707512664794921875000000000000000000000e1), SC_(9.651890397071838378906250000000000000000e-1), SC_(9.999173710862373285353488476406081262144e-1), SC_(8.262891376267146465115235939187378563856e-5) }}, 
      {{ SC_(2.293667030334472656250000000000000000000e1), SC_(1.146833515167236328125000000000000000000e1), SC_(1.670017089843750000000000000000000000000e2), SC_(9.755372405052185058593750000000000000000e-1), SC_(9.999078520131845332819604436479968974939e-1), SC_(9.214798681546671803955635200310250605688e-5) }}, 
      {{ SC_(2.293667030334472656250000000000000000000e1), SC_(1.720250320434570312500000000000000000000e1), SC_(2.709540176391601562500000000000000000000e1), SC_(9.356142282485961914062500000000000000000e-1), SC_(9.999999776641352353688605884331404986254e-1), SC_(2.233586476463113941156685950137460253656e-8) }}, 
      {{ SC_(2.293667030334472656250000000000000000000e1), SC_(1.720250320434570312500000000000000000000e1), SC_(1.007325439453125000000000000000000000000e2), SC_(9.617519378662109375000000000000000000000e-1), SC_(9.999999360345952773837020523485780795362e-1), SC_(6.396540472261629794765142192046382922162e-8) }}, 
      {{ SC_(2.293667030334472656250000000000000000000e1), SC_(1.720250320434570312500000000000000000000e1), SC_(1.698258666992187500000000000000000000000e2), SC_(9.723380804061889648437500000000000000000e-1), SC_(9.999999184802514472182058627394876521306e-1), SC_(8.151974855278179413726051234786944105942e-8) }}, 
      {{ SC_(2.293667030334472656250000000000000000000e1), SC_(2.064300346374511718750000000000000000000e1), SC_(2.837726783752441406250000000000000000000e1), SC_(6.411393731832504272460937500000000000000e-2), SC_(3.084415919740871219779020502581751300891e-22), SC_(9.999999999999999999996915584080259128780e-1) }}, 
      {{ SC_(2.293667030334472656250000000000000000000e1), SC_(2.064300346374511718750000000000000000000e1), SC_(1.093762969970703125000000000000000000000e2), SC_(7.887415587902069091796875000000000000000e-2), SC_(2.191478685245434180496549601029939306067e-35), SC_(9.999999999999999999999999999999999780852e-1) }}, 
      {{ SC_(2.293667030334472656250000000000000000000e1), SC_(2.064300346374511718750000000000000000000e1), SC_(1.756861267089843750000000000000000000000e2), SC_(8.421278744935989379882812500000000000000e-2), SC_(4.793007966221651947319418879285899411435e-47), SC_(1.000000000000000000000000000000000000000) }}, 
      {{ SC_(2.293667030334472656250000000000000000000e1), SC_(2.270730400085449218750000000000000000000e1), SC_(3.152261734008789062500000000000000000000e1), SC_(1.571650654077529907226562500000000000000e-1), SC_(4.525263713869596347887156188307538478896e-13), SC_(9.999999999995474736286130403652112843812e-1) }}, 
      {{ SC_(2.293667030334472656250000000000000000000e1), SC_(2.270730400085449218750000000000000000000e1), SC_(1.094441146850585937500000000000000000000e2), SC_(1.931315064430236816406250000000000000000e-1), SC_(1.366125196441966592117800570037007821887e-22), SC_(9.999999999999999999998633874803558033408e-1) }}, 
      {{ SC_(2.293667030334472656250000000000000000000e1), SC_(2.270730400085449218750000000000000000000e1), SC_(1.811583862304687500000000000000000000000e2), SC_(2.081235945224761962890625000000000000000e-1), SC_(2.841297094807645411972305780482852432934e-32), SC_(9.999999999999999999999999999999715870291e-1) }}, 
      {{ SC_(2.293667030334472656250000000000000000000e1), SC_(2.291373443603515625000000000000000000000e1), SC_(3.423733520507812500000000000000000000000e1), SC_(3.172701299190521240234375000000000000000e-1), SC_(2.575022839612756332151553533831258844079e-6), SC_(9.999974249771603872436678484464661687412e-1) }}, 
      {{ SC_(2.293667030334472656250000000000000000000e1), SC_(2.291373443603515625000000000000000000000e1), SC_(1.264718551635742187500000000000000000000e2), SC_(3.944162130355834960937500000000000000000e-1), SC_(1.030275288099839611074150428264935572537e-12), SC_(9.999999999989697247119001603889258495717e-1) }}, 
      {{ SC_(2.293667030334472656250000000000000000000e1), SC_(2.291373443603515625000000000000000000000e1), SC_(1.826751708984375000000000000000000000000e2), SC_(4.160825312137603759765625000000000000000e-1), SC_(3.632392292544180821152532929390808669449e-17), SC_(9.999999999999999636760770745581917884747e-1) }}, 
      {{ SC_(2.293667030334472656250000000000000000000e1), SC_(2.293667030334472656250000000000000000000e1), SC_(3.477303314208984375000000000000000000000e1), SC_(4.768846035003662109375000000000000000000e-1), SC_(1.004099651842211513010157642305168185411e-2), SC_(9.899590034815778848698984235769483181459e-1) }}, 
      {{ SC_(2.293667030334472656250000000000000000000e1), SC_(2.293667030334472656250000000000000000000e1), SC_(1.279526672363281250000000000000000000000e2), SC_(5.925693511962890625000000000000000000000e-1), SC_(4.250861805522427665927587989832068399885e-5), SC_(9.999574913819447757233407241201016793160e-1) }}, 
      {{ SC_(2.293667030334472656250000000000000000000e1), SC_(2.293667030334472656250000000000000000000e1), SC_(1.831471099853515625000000000000000000000e2), SC_(6.242358684539794921875000000000000000000e-1), SC_(8.556977758473975433696226046555017616930e-7), SC_(9.999991443022241526024566303773953444982e-1) }}, 
      {{ SC_(2.293667030334472656250000000000000000000e1), SC_(2.293896484375000000000000000000000000000e1), SC_(3.767639541625976562500000000000000000000e1), SC_(5.795439481735229492187500000000000000000e-1), SC_(1.578083243550451581680277641466597138112e-1), SC_(8.421916756449548418319722358533402861888e-1) }}, 
      {{ SC_(2.293667030334472656250000000000000000000e1), SC_(2.293896484375000000000000000000000000000e1), SC_(1.310955810546875000000000000000000000000e2), SC_(7.137369513511657714843750000000000000000e-1), SC_(3.620318535559171919216628366024390331764e-2), SC_(9.637968146444082808078337163397560966824e-1) }}, 
      {{ SC_(2.293667030334472656250000000000000000000e1), SC_(2.293896484375000000000000000000000000000e1), SC_(1.867986450195312500000000000000000000000e2), SC_(7.510538101196289062500000000000000000000e-1), SC_(1.252347571928060645010016810197572572323e-2), SC_(9.874765242807193935498998318980242742768e-1) }}, 
      {{ SC_(2.293667030334472656250000000000000000000e1), SC_(2.295960807800292968750000000000000000000e1), SC_(4.238486480712890625000000000000000000000e1), SC_(6.495994329452514648437500000000000000000e-1), SC_(4.430885213522799453151206594887950111625e-1), SC_(5.569114786477200546848793405112049888375e-1) }}, 
      {{ SC_(2.293667030334472656250000000000000000000e1), SC_(2.295960807800292968750000000000000000000e1), SC_(1.311481323242187500000000000000000000000e2), SC_(7.850130200386047363281250000000000000000e-1), SC_(4.018030211715430613926644841594394197697e-1), SC_(5.981969788284569386073355158405605802303e-1) }}, 
      {{ SC_(2.293667030334472656250000000000000000000e1), SC_(2.295960807800292968750000000000000000000e1), SC_(1.914333953857421875000000000000000000000e2), SC_(8.287259936332702636718750000000000000000e-1), SC_(3.775270872985088243320182991883632193725e-1), SC_(6.224729127014911756679817008116367806275e-1) }}, 
      {{ SC_(2.293667030334472656250000000000000000000e1), SC_(2.316603660583496093750000000000000000000e1), SC_(4.420680999755859375000000000000000000000e1), SC_(6.580799818038940429687500000000000000000e-1), SC_(4.799161292777372035564927407196921897643e-1), SC_(5.200838707222627964435072592803078102357e-1) }}, 
      {{ SC_(2.293667030334472656250000000000000000000e1), SC_(2.316603660583496093750000000000000000000e1), SC_(1.357470245361328125000000000000000000000e2), SC_(7.948891520500183105468750000000000000000e-1), SC_(4.685366263502575757749641298944325928506e-1), SC_(5.314633736497424242250358701055674071494e-1) }}, 
      {{ SC_(2.293667030334472656250000000000000000000e1), SC_(2.316603660583496093750000000000000000000e1), SC_(1.915013732910156250000000000000000000000e2), SC_(8.350772857666015625000000000000000000000e-1), SC_(4.648700803471992036663523216050554567938e-1), SC_(5.351299196528007963336476783949445432062e-1) }}, 
      {{ SC_(2.293667030334472656250000000000000000000e1), SC_(2.523033714294433593750000000000000000000e1), SC_(5.569964599609375000000000000000000000000e1), SC_(6.664957404136657714843750000000000000000e-1), SC_(4.838170390465426020480431352745198795863e-1), SC_(5.161829609534573979519568647254801204137e-1) }}, 
      {{ SC_(2.293667030334472656250000000000000000000e1), SC_(2.523033714294433593750000000000000000000e1), SC_(1.362719116210937500000000000000000000000e2), SC_(7.819709181785583496093750000000000000000e-1), SC_(4.776678888258561401636861924640223692733e-1), SC_(5.223321111741438598363138075359776307267e-1) }}, 
      {{ SC_(2.293667030334472656250000000000000000000e1), SC_(2.523033714294433593750000000000000000000e1), SC_(1.918984832763671875000000000000000000000e2), SC_(8.241218924522399902343750000000000000000e-1), SC_(4.761697794733234106946782230087514450475e-1), SC_(5.238302205266765893053217769912485549525e-1) }}, 
      {{ SC_(2.293667030334472656250000000000000000000e1), SC_(2.752400588989257812500000000000000000000e1), SC_(5.940588760375976562500000000000000000000e1), SC_(6.550996899604797363281250000000000000000e-1), SC_(4.850978411273276913423426550682004946368e-1), SC_(5.149021588726723086576573449317995053632e-1) }}, 
      {{ SC_(2.293667030334472656250000000000000000000e1), SC_(2.752400588989257812500000000000000000000e1), SC_(1.451677856445312500000000000000000000000e2), SC_(7.752587199211120605468750000000000000000e-1), SC_(4.789366532195581203308175074637699183540e-1), SC_(5.210633467804418796691824925362300816460e-1) }}, 
      {{ SC_(2.293667030334472656250000000000000000000e1), SC_(2.752400588989257812500000000000000000000e1), SC_(1.929777069091796875000000000000000000000e2), SC_(8.118794560432434082031250000000000000000e-1), SC_(4.776679034423161474273827789835744266328e-1), SC_(5.223320965576838525726172210164255733672e-1) }}, 
      {{ SC_(2.293667030334472656250000000000000000000e1), SC_(2.981767082214355468750000000000000000000e1), SC_(6.038262176513671875000000000000000000000e1), SC_(6.392987966537475585937500000000000000000e-1), SC_(4.886086923528876904161113515345889858641e-1), SC_(5.113913076471123095838886484654110141359e-1) }}, 
      {{ SC_(2.293667030334472656250000000000000000000e1), SC_(2.981767082214355468750000000000000000000e1), SC_(1.481294555664062500000000000000000000000e2), SC_(7.640334367752075195312500000000000000000e-1), SC_(4.821219854713634588566814910280127841887e-1), SC_(5.178780145286365411433185089719872158113e-1) }}, 
      {{ SC_(2.293667030334472656250000000000000000000e1), SC_(2.981767082214355468750000000000000000000e1), SC_(1.935389862060546875000000000000000000000e2), SC_(7.999194264411926269531250000000000000000e-1), SC_(4.808585398072847713036339989021491142590e-1), SC_(5.191414601927152286963660010978508857410e-1) }}, 
      {{ SC_(2.293667030334472656250000000000000000000e1), SC_(3.440500640869140625000000000000000000000e1), SC_(6.163340759277343750000000000000000000000e1), SC_(6.120682358741760253906250000000000000000e-1), SC_(5.152183440487684681245759310499377163645e-1), SC_(4.847816559512315318754240689500622836355e-1) }}, 
      {{ SC_(2.293667030334472656250000000000000000000e1), SC_(3.440500640869140625000000000000000000000e1), SC_(1.486264953613281250000000000000000000000e2), SC_(7.401509284973144531250000000000000000000e-1), SC_(5.065694495484961544273488207719780190086e-1), SC_(4.934305504515038455726511792280219809914e-1) }}, 
      {{ SC_(2.293667030334472656250000000000000000000e1), SC_(3.440500640869140625000000000000000000000e1), SC_(1.937735595703125000000000000000000000000e2), SC_(7.782308459281921386718750000000000000000e-1), SC_(5.048406063903426302139917565556926976223e-1), SC_(4.951593936096573697860082434443073023777e-1) }}, 
      {{ SC_(2.293667030334472656250000000000000000000e1), SC_(4.587334060668945312500000000000000000000e1), SC_(7.225879669189453125000000000000000000000e1), SC_(6.012951135635375976562500000000000000000e-1), SC_(7.640023974947258928057697444948891645713e-1), SC_(2.359976025052741071942302555051108354287e-1) }}, 
      {{ SC_(2.293667030334472656250000000000000000000e1), SC_(4.587334060668945312500000000000000000000e1), SC_(1.515480346679687500000000000000000000000e2), SC_(7.105199098587036132812500000000000000000e-1), SC_(7.417812242826567642741591054284996566902e-1), SC_(2.582187757173432357258408945715003433098e-1) }}, 
      {{ SC_(2.293667030334472656250000000000000000000e1), SC_(4.587334060668945312500000000000000000000e1), SC_(1.941185607910156250000000000000000000000e2), SC_(7.476919889450073242187500000000000000000e-1), SC_(7.364404015133866686433181111454146768895e-1), SC_(2.635595984866133313566818888545853231105e-1) }}, 
      {{ SC_(2.293667030334472656250000000000000000000e1), SC_(6.881001281738281250000000000000000000000e1), SC_(9.566968083381652832031250000000000000000e-1), SC_(3.782067894935607910156250000000000000000e-1), SC_(9.945993525563016074544324819496406713955e-1), SC_(5.400647443698392545567518050359328604520e-3) }}, 
      {{ SC_(2.293667030334472656250000000000000000000e1), SC_(6.881001281738281250000000000000000000000e1), SC_(7.844540405273437500000000000000000000000e1), SC_(5.611737966537475585937500000000000000000e-1), SC_(9.613590857584603189051704041507950009109e-1), SC_(3.864091424153968109482959584920499908908e-2) }}, 
      {{ SC_(2.293667030334472656250000000000000000000e1), SC_(6.881001281738281250000000000000000000000e1), SC_(1.584414672851562500000000000000000000000e2), SC_(6.636956334114074707031250000000000000000e-1), SC_(9.454993054954102265207157553482193491420e-1), SC_(5.450069450458977347928424465178065085796e-2) }}, 
      {{ SC_(2.293667030334472656250000000000000000000e1), SC_(6.881001281738281250000000000000000000000e1), SC_(1.962219390869140625000000000000000000000e2), SC_(6.971533894538879394531250000000000000000e-1), SC_(9.412338103081676515088813221275079787653e-1), SC_(5.876618969183234849111867787249202123473e-2) }}, 
      {{ SC_(2.293667030334472656250000000000000000000e1), SC_(9.174668121337890625000000000000000000000e1), SC_(7.142335891723632812500000000000000000000), SC_(4.030469655990600585937500000000000000000e-1), SC_(9.999673676776586122601134335350955247283e-1), SC_(3.263232234138773988656646490447527171498e-5) }}, 
      {{ SC_(2.293667030334472656250000000000000000000e1), SC_(9.174668121337890625000000000000000000000e1), SC_(7.974770355224609375000000000000000000000e1), SC_(5.426148176193237304687500000000000000000e-1), SC_(9.986550090781461830403460528203007197845e-1), SC_(1.344990921853816959653947179699280215502e-3) }}, 
      {{ SC_(2.293667030334472656250000000000000000000e1), SC_(9.174668121337890625000000000000000000000e1), SC_(1.595857238769531250000000000000000000000e2), SC_(6.363397836685180664062500000000000000000e-1), SC_(9.967241062432174395907257084088679683553e-1), SC_(3.275893756782560409274291591132031644694e-3) }}, 
      {{ SC_(2.293667030334472656250000000000000000000e1), SC_(9.174668121337890625000000000000000000000e1), SC_(1.985762634277343750000000000000000000000e2), SC_(6.694539785385131835937500000000000000000e-1), SC_(9.959584511215616913430574700304105996647e-1), SC_(4.041548878438308656942529969589400335278e-3) }}, 
      {{ SC_(2.293667030334472656250000000000000000000e1), SC_(1.146833496093750000000000000000000000000e2), SC_(1.950807952880859375000000000000000000000e1), SC_(4.809812307357788085937500000000000000000e-1), SC_(9.999999993770254190310384202626614857265e-1), SC_(6.229745809689615797373385142735378134399e-10) }}, 
      {{ SC_(2.293667030334472656250000000000000000000e1), SC_(1.146833496093750000000000000000000000000e2), SC_(8.435225677490234375000000000000000000000e1), SC_(5.742104649543762207031250000000000000000e-1), SC_(9.999998041425544870078243014663282228824e-1), SC_(1.958574455129921756985336717771176038415e-7) }}, 
      {{ SC_(2.293667030334472656250000000000000000000e1), SC_(1.146833496093750000000000000000000000000e2), SC_(1.596211700439453125000000000000000000000e2), SC_(6.477743387222290039062500000000000000000e-1), SC_(9.999984395523066982775878271102242206983e-1), SC_(1.560447693301722412172889775779301704712e-6) }}, 
      {{ SC_(2.293667030334472656250000000000000000000e1), SC_(1.146833496093750000000000000000000000000e2), SC_(1.992922668457031250000000000000000000000e2), SC_(6.771941781044006347656250000000000000000e-1), SC_(9.999972305677240511297444874699457177213e-1), SC_(2.769432275948870255512530054282278715589e-6) }}, 
      {{ SC_(2.583386993408203125000000000000000000000e1), SC_(2.583387136459350585937500000000000000000), SC_(9.566968083381652832031250000000000000000e-1), SC_(9.552723169326782226562500000000000000000e-1), SC_(7.974326433652250763668142292832714493687e-1), SC_(2.025673566347749236331857707167285506313e-1) }}, 
      {{ SC_(2.583386993408203125000000000000000000000e1), SC_(2.583387136459350585937500000000000000000), SC_(7.844540405273437500000000000000000000000e1), SC_(9.807397127151489257812500000000000000000e-1), SC_(7.851401571267353967226195386372427864769e-1), SC_(2.148598428732646032773804613627572135231e-1) }}, 
      {{ SC_(2.583386993408203125000000000000000000000e1), SC_(2.583387136459350585937500000000000000000), SC_(1.584414672851562500000000000000000000000e2), SC_(9.879176020622253417968750000000000000000e-1), SC_(7.834776999675132430087825310939292500182e-1), SC_(2.165223000324867569912174689060707499818e-1) }}, 
      {{ SC_(2.583386993408203125000000000000000000000e1), SC_(2.583387136459350585937500000000000000000), SC_(1.962219390869140625000000000000000000000e2), SC_(9.897286891937255859375000000000000000000e-1), SC_(7.831772964500218388430543418216192228121e-1), SC_(2.168227035499781611569456581783807771879e-1) }}, 
      {{ SC_(2.583386993408203125000000000000000000000e1), SC_(6.458467483520507812500000000000000000000), SC_(7.142335891723632812500000000000000000000), SC_(9.398050904273986816406250000000000000000e-1), SC_(9.906397655210469681263942842990180224998e-1), SC_(9.360234478953031873605715700981977500204e-3) }}, 
      {{ SC_(2.583386993408203125000000000000000000000e1), SC_(6.458467483520507812500000000000000000000), SC_(7.974770355224609375000000000000000000000e1), SC_(9.699401259422302246093750000000000000000e-1), SC_(9.878210769118570383236129526535506436149e-1), SC_(1.217892308814296167638704734644935638507e-2) }}, 
      {{ SC_(2.583386993408203125000000000000000000000e1), SC_(6.458467483520507812500000000000000000000), SC_(1.595857238769531250000000000000000000000e2), SC_(9.806709885597229003906250000000000000000e-1), SC_(9.872455778853041714250639973153520320998e-1), SC_(1.275442211469582857493600268464796790018e-2) }}, 
      {{ SC_(2.583386993408203125000000000000000000000e1), SC_(6.458467483520507812500000000000000000000), SC_(1.985762634277343750000000000000000000000e2), SC_(9.835448861122131347656250000000000000000e-1), SC_(9.871324465864882683090705422143206913714e-1), SC_(1.286755341351173169092945778567930862856e-2) }}, 
      {{ SC_(2.583386993408203125000000000000000000000e1), SC_(1.291693496704101562500000000000000000000e1), SC_(1.950807952880859375000000000000000000000e1), SC_(9.331485033035278320312500000000000000000e-1), SC_(9.999852973145626359262624210861472451060e-1), SC_(1.470268543736407373757891385275489402192e-5) }}, 
      {{ SC_(2.583386993408203125000000000000000000000e1), SC_(1.291693496704101562500000000000000000000e1), SC_(8.435225677490234375000000000000000000000e1), SC_(9.598399400711059570312500000000000000000e-1), SC_(9.999719894576340549643910001853159775108e-1), SC_(2.801054236594503560899981468402248915982e-5) }}, 
      {{ SC_(2.583386993408203125000000000000000000000e1), SC_(1.291693496704101562500000000000000000000e1), SC_(1.596211700439453125000000000000000000000e2), SC_(9.726085662841796875000000000000000000000e-1), SC_(9.999667162444443395025709420934237193872e-1), SC_(3.328375555566049742905790657628061282604e-5) }}, 
      {{ SC_(2.583386993408203125000000000000000000000e1), SC_(1.291693496704101562500000000000000000000e1), SC_(1.992922668457031250000000000000000000000e2), SC_(9.765454530715942382812500000000000000000e-1), SC_(9.999653911276691905418736686251376211845e-1), SC_(3.460887233080945812633137486237881554568e-5) }}, 
      {{ SC_(2.583386993408203125000000000000000000000e1), SC_(1.937540245056152343750000000000000000000e1), SC_(2.197235107421875000000000000000000000000e1), SC_(9.308028817176818847656250000000000000000e-1), SC_(9.999999978061110058330953774530644349515e-1), SC_(2.193888994166904622546935565048475864764e-9) }}, 
      {{ SC_(2.583386993408203125000000000000000000000e1), SC_(1.937540245056152343750000000000000000000e1), SC_(8.441753387451171875000000000000000000000e1), SC_(9.554269909858703613281250000000000000000e-1), SC_(9.999999920476115197348971637624395725289e-1), SC_(7.952388480265102836237560427471070697629e-9) }}, 
      {{ SC_(2.583386993408203125000000000000000000000e1), SC_(1.937540245056152343750000000000000000000e1), SC_(1.600560913085937500000000000000000000000e2), SC_(9.689002037048339843750000000000000000000e-1), SC_(9.999999880899467578978459620078492212915e-1), SC_(1.191005324210215403799215077870849770332e-8) }}, 
      {{ SC_(2.583386993408203125000000000000000000000e1), SC_(2.325048255920410156250000000000000000000e1), SC_(2.249290275573730468750000000000000000000e1), SC_(6.134259700775146484375000000000000000000e-2), SC_(1.696486426499949545597464413355658583062e-23), SC_(9.999999999999999999999830351357350005045e-1) }}, 
      {{ SC_(2.583386993408203125000000000000000000000e1), SC_(2.325048255920410156250000000000000000000e1), SC_(9.495173645019531250000000000000000000000e1), SC_(7.579865306615829467773437500000000000000e-2), SC_(8.138439281065427021243368584132794610378e-35), SC_(9.999999999999999999999999999999999186156e-1) }}, 
      {{ SC_(2.583386993408203125000000000000000000000e1), SC_(2.325048255920410156250000000000000000000e1), SC_(1.629447326660156250000000000000000000000e2), SC_(8.210615813732147216796875000000000000000e-2), SC_(1.486213712834933534387248613228486126814e-46), SC_(1.000000000000000000000000000000000000000) }}, 
      {{ SC_(2.583386993408203125000000000000000000000e1), SC_(2.557553100585937500000000000000000000000e1), SC_(2.539736366271972656250000000000000000000e1), SC_(1.499558538198471069335937500000000000000e-1), SC_(1.932746606124828016861357845340816310920e-13), SC_(9.999999999998067253393875171983138642155e-1) }}, 
      {{ SC_(2.583386993408203125000000000000000000000e1), SC_(2.557553100585937500000000000000000000000e1), SC_(9.707512664794921875000000000000000000000e1), SC_(1.857164055109024047851562500000000000000e-1), SC_(7.712133934562550418644205952336566946835e-22), SC_(9.999999999999999999992287866065437449581e-1) }}, 
      {{ SC_(2.583386993408203125000000000000000000000e1), SC_(2.557553100585937500000000000000000000000e1), SC_(1.670017089843750000000000000000000000000e2), SC_(2.023889720439910888671875000000000000000e-1), SC_(4.906825429676104887816960613190434713910e-31), SC_(9.999999999999999999999999999995093174570e-1) }}, 
      {{ SC_(2.583386993408203125000000000000000000000e1), SC_(2.580803680419921875000000000000000000000e1), SC_(2.709540176391601562500000000000000000000e1), SC_(3.014230132102966308593750000000000000000e-1), SC_(2.971168137508455265091385455392926038950e-6), SC_(9.999970288318624915447349086145446070740e-1) }}, 
      {{ SC_(2.583386993408203125000000000000000000000e1), SC_(2.580803680419921875000000000000000000000e1), SC_(1.007325439453125000000000000000000000000e2), SC_(3.728878796100616455078125000000000000000e-1), SC_(5.211217217111162876870470617441662641780e-11), SC_(9.999999999478878278288883712312952938256e-1) }}, 
      {{ SC_(2.583386993408203125000000000000000000000e1), SC_(2.580803680419921875000000000000000000000e1), SC_(1.698258666992187500000000000000000000000e2), SC_(4.050727188587188720703125000000000000000e-1), SC_(3.249642086512734691309081662321891170061e-16), SC_(9.999999999999996750357913487265308690918e-1) }}, 
      {{ SC_(2.583386993408203125000000000000000000000e1), SC_(2.583386993408203125000000000000000000000e1), SC_(2.837726783752441406250000000000000000000e1), SC_(4.548305273056030273437500000000000000000e-1), SC_(1.126553945901932586773900270204709788023e-2), SC_(9.887344605409806741322609972979529021198e-1) }}, 
      {{ SC_(2.583386993408203125000000000000000000000e1), SC_(2.583386993408203125000000000000000000000e1), SC_(1.093762969970703125000000000000000000000e2), SC_(5.669440627098083496093750000000000000000e-1), SC_(1.427683339053983382413738479084514800503e-4), SC_(9.998572316660946016617586261520915485199e-1) }}, 
      {{ SC_(2.583386993408203125000000000000000000000e1), SC_(2.583386993408203125000000000000000000000e1), SC_(1.756861267089843750000000000000000000000e2), SC_(6.104921698570251464843750000000000000000e-1), SC_(1.770883417786152794109777109337845166137e-6), SC_(9.999982291165822138472058902228906621548e-1) }}, 
      {{ SC_(2.583386993408203125000000000000000000000e1), SC_(2.583645439147949218750000000000000000000e1), SC_(3.152261734008789062500000000000000000000e1), SC_(5.539693832397460937500000000000000000000e-1), SC_(1.656087968851212075283119354192700001701e-1), SC_(8.343912031148787924716880645807299998299e-1) }}, 
      {{ SC_(2.583386993408203125000000000000000000000e1), SC_(2.583645439147949218750000000000000000000e1), SC_(1.094441146850585937500000000000000000000e2), SC_(6.803863048553466796875000000000000000000e-1), SC_(5.440984427704003612408480098076809691426e-2), SC_(9.455901557229599638759151990192319030857e-1) }}, 
      {{ SC_(2.583386993408203125000000000000000000000e1), SC_(2.583645439147949218750000000000000000000e1), SC_(1.811583862304687500000000000000000000000e2), SC_(7.358033061027526855468750000000000000000e-1), SC_(1.556138490334746033534402877211606474075e-2), SC_(9.844386150966525396646559712278839352592e-1) }}, 
      {{ SC_(2.583386993408203125000000000000000000000e1), SC_(2.585970497131347656250000000000000000000e1), SC_(3.423733520507812500000000000000000000000e1), SC_(6.166120767593383789062500000000000000000e-1), SC_(4.486022037434627015927726549723347909083e-1), SC_(5.513977962565372984072273450276652090917e-1) }}, 
      {{ SC_(2.583386993408203125000000000000000000000e1), SC_(2.585970497131347656250000000000000000000e1), SC_(1.264718551635742187500000000000000000000e2), SC_(7.661786675453186035156250000000000000000e-1), SC_(4.069087659008246442198647308973466807090e-1), SC_(5.930912340991753557801352691026533192910e-1) }}, 
      {{ SC_(2.583386993408203125000000000000000000000e1), SC_(2.585970497131347656250000000000000000000e1), SC_(1.826751708984375000000000000000000000000e2), SC_(8.102111220359802246093750000000000000000e-1), SC_(3.852448294964985427963243842803351074199e-1), SC_(6.147551705035014572036756157196648925801e-1) }}, 
      {{ SC_(2.583386993408203125000000000000000000000e1), SC_(2.609220886230468750000000000000000000000e1), SC_(3.477303314208984375000000000000000000000e1), SC_(6.215729117393493652343750000000000000000e-1), SC_(4.838854086117135297414073071866600843956e-1), SC_(5.161145913882864702585926928133399156044e-1) }}, 
      {{ SC_(2.583386993408203125000000000000000000000e1), SC_(2.609220886230468750000000000000000000000e1), SC_(1.279526672363281250000000000000000000000e2), SC_(7.730318307876586914062500000000000000000e-1), SC_(4.712274537812448964661207406632717274733e-1), SC_(5.287725462187551035338792593367282725267e-1) }}, 
      {{ SC_(2.583386993408203125000000000000000000000e1), SC_(2.609220886230468750000000000000000000000e1), SC_(1.831471099853515625000000000000000000000e2), SC_(8.165463209152221679687500000000000000000e-1), SC_(4.675063184664571836942201397398569638961e-1), SC_(5.324936815335428163057798602601430361039e-1) }}, 
      {{ SC_(2.583386993408203125000000000000000000000e1), SC_(2.841725730895996093750000000000000000000e1), SC_(3.767639541625976562500000000000000000000e1), SC_(6.098271608352661132812500000000000000000e-1), SC_(4.887862351784118806500752473307444598910e-1), SC_(5.112137648215881193499247526692555401090e-1) }}, 
      {{ SC_(2.583386993408203125000000000000000000000e1), SC_(2.841725730895996093750000000000000000000e1), SC_(1.310955810546875000000000000000000000000e2), SC_(7.617086768150329589843750000000000000000e-1), SC_(4.797579369368827966102845411831701138939e-1), SC_(5.202420630631172033897154588168298861061e-1) }}, 
      {{ SC_(2.583386993408203125000000000000000000000e1), SC_(2.841725730895996093750000000000000000000e1), SC_(1.867986450195312500000000000000000000000e2), SC_(8.067123889923095703125000000000000000000e-1), SC_(4.780827126540396212861470701077975367058e-1), SC_(5.219172873459603787138529298922024632942e-1) }}, 
      {{ SC_(2.583386993408203125000000000000000000000e1), SC_(3.100064468383789062500000000000000000000e1), SC_(4.238486480712890625000000000000000000000e1), SC_(6.013500094413757324218750000000000000000e-1), SC_(4.896653777465017691131965753944975686560e-1), SC_(5.103346222534982308868034246055024313440e-1) }}, 
      {{ SC_(2.583386993408203125000000000000000000000e1), SC_(3.100064468383789062500000000000000000000e1), SC_(1.311481323242187500000000000000000000000e2), SC_(7.456616163253784179687500000000000000000e-1), SC_(4.813258148263517996234967957122146971841e-1), SC_(5.186741851736482003765032042877853028159e-1) }}, 
      {{ SC_(2.583386993408203125000000000000000000000e1), SC_(3.100064468383789062500000000000000000000e1), SC_(1.914333953857421875000000000000000000000e2), SC_(7.959699034690856933593750000000000000000e-1), SC_(4.794681890821067941708977478182521509082e-1), SC_(5.205318109178932058291022521817478490918e-1) }}, 
      {{ SC_(2.583386993408203125000000000000000000000e1), SC_(3.358403015136718750000000000000000000000e1), SC_(4.420680999755859375000000000000000000000e1), SC_(5.870764851570129394531250000000000000000e-1), SC_(4.932029023673743518236996737483891945467e-1), SC_(5.067970976326256481763003262516108054533e-1) }}, 
      {{ SC_(2.583386993408203125000000000000000000000e1), SC_(3.358403015136718750000000000000000000000e1), SC_(1.357470245361328125000000000000000000000e2), SC_(7.353237271308898925781250000000000000000e-1), SC_(4.845505602169135078106408880376388262034e-1), SC_(5.154494397830864921893591119623611737966e-1) }}, 
      {{ SC_(2.583386993408203125000000000000000000000e1), SC_(3.358403015136718750000000000000000000000e1), SC_(1.915013732910156250000000000000000000000e2), SC_(7.829205989837646484375000000000000000000e-1), SC_(4.827656466073171527333859922079144559754e-1), SC_(5.172343533926828472666140077920855440246e-1) }}, 
      {{ SC_(2.583386993408203125000000000000000000000e1), SC_(3.875080490112304687500000000000000000000e1), SC_(5.569964599609375000000000000000000000000e1), SC_(5.835733413696289062500000000000000000000e-1), SC_(5.201234014375338596560524916052521861498e-1), SC_(4.798765985624661403439475083947478138502e-1) }}, 
      {{ SC_(2.583386993408203125000000000000000000000e1), SC_(3.875080490112304687500000000000000000000e1), SC_(1.362719116210937500000000000000000000000e2), SC_(7.097998857498168945312500000000000000000e-1), SC_(5.107087908953240484564312286977664904514e-1), SC_(4.892912091046759515435687713022335095486e-1) }}, 
      {{ SC_(2.583386993408203125000000000000000000000e1), SC_(3.875080490112304687500000000000000000000e1), SC_(1.918984832763671875000000000000000000000e2), SC_(7.601131200790405273437500000000000000000e-1), SC_(5.082046910782645863338148320245130242780e-1), SC_(4.917953089217354136661851679754869757220e-1) }}, 
      {{ SC_(2.583386993408203125000000000000000000000e1), SC_(5.166773986816406250000000000000000000000e1), SC_(5.940588760375976562500000000000000000000e1), SC_(5.607270002365112304687500000000000000000e-1), SC_(7.896712255987101509626804066552265600935e-1), SC_(2.103287744012898490373195933447734399065e-1) }}, 
      {{ SC_(2.583386993408203125000000000000000000000e1), SC_(5.166773986816406250000000000000000000000e1), SC_(1.451677856445312500000000000000000000000e2), SC_(6.860321760177612304687500000000000000000e-1), SC_(7.599399692396986510300884403159572524540e-1), SC_(2.400600307603013489699115596840427475460e-1) }}, 
      {{ SC_(2.583386993408203125000000000000000000000e1), SC_(5.166773986816406250000000000000000000000e1), SC_(1.929777069091796875000000000000000000000e2), SC_(7.291783094406127929687500000000000000000e-1), SC_(7.530171212190769095339531711075596254869e-1), SC_(2.469828787809230904660468288924403745131e-1) }}, 
      {{ SC_(2.583386993408203125000000000000000000000e1), SC_(7.750160980224609375000000000000000000000e1), SC_(6.038262176513671875000000000000000000000e1), SC_(5.154976844787597656250000000000000000000e-1), SC_(9.767355724951647950501677505536895074059e-1), SC_(2.326442750483520494983224944631049259408e-2) }}, 
      {{ SC_(2.583386993408203125000000000000000000000e1), SC_(7.750160980224609375000000000000000000000e1), SC_(1.481294555664062500000000000000000000000e2), SC_(6.350812315940856933593750000000000000000e-1), SC_(9.593659029129607671697369891644931494121e-1), SC_(4.063409708703923283026301083550685058786e-2) }}, 
      {{ SC_(2.583386993408203125000000000000000000000e1), SC_(7.750160980224609375000000000000000000000e1), SC_(1.935389862060546875000000000000000000000e2), SC_(6.764660477638244628906250000000000000000e-1), SC_(9.543115668351455834723910050941155124028e-1), SC_(4.568843316485441652760899490588448759722e-2) }}, 
      {{ SC_(2.583386993408203125000000000000000000000e1), SC_(1.033354797363281250000000000000000000000e2), SC_(6.163340759277343750000000000000000000000e1), SC_(5.025532841682434082031250000000000000000e-1), SC_(9.996300080763052751982591100249712593755e-1), SC_(3.699919236947248017408899750287406244824e-4) }}, 
      {{ SC_(2.583386993408203125000000000000000000000e1), SC_(1.033354797363281250000000000000000000000e2), SC_(1.486264953613281250000000000000000000000e2), SC_(6.086569428443908691406250000000000000000e-1), SC_(9.984633659946992431894251166996552003879e-1), SC_(1.536634005300756810574883300344799612142e-3) }}, 
      {{ SC_(2.583386993408203125000000000000000000000e1), SC_(1.033354797363281250000000000000000000000e2), SC_(1.937735595703125000000000000000000000000e2), SC_(6.477001309394836425781250000000000000000e-1), SC_(9.978873190595281847195079913346139777929e-1), SC_(2.112680940471815280492008665386022207121e-3) }}, 
      {{ SC_(2.583386993408203125000000000000000000000e1), SC_(1.291693420410156250000000000000000000000e2), SC_(7.225879669189453125000000000000000000000e1), SC_(5.490143895149230957031250000000000000000e-1), SC_(9.999999886651320258768769077294580116514e-1), SC_(1.133486797412312309227054198834855500123e-8) }}, 
      {{ SC_(2.583386993408203125000000000000000000000e1), SC_(1.291693420410156250000000000000000000000e2), SC_(1.515480346679687500000000000000000000000e2), SC_(6.263261437416076660156250000000000000000e-1), SC_(9.999997870519182066775466897801841707690e-1), SC_(2.129480817933224533102198158292309740240e-7) }}, 
      {{ SC_(2.583386993408203125000000000000000000000e1), SC_(1.291693420410156250000000000000000000000e2), SC_(1.941185607910156250000000000000000000000e2), SC_(6.578450202941894531250000000000000000000e-1), SC_(9.999995319406643052416772320918195638184e-1), SC_(4.680593356947583227679081804361816215988e-7) }}, 
      {{ SC_(2.752766227722167968750000000000000000000e1), SC_(2.752766370773315429687500000000000000000), SC_(6.038262176513671875000000000000000000000e1), SC_(9.770513176918029785156250000000000000000e-1), SC_(7.975113593999453347244009582635739785377e-1), SC_(2.024886406000546652755990417364260214623e-1) }}, 
      {{ SC_(2.752766227722167968750000000000000000000e1), SC_(2.752766370773315429687500000000000000000), SC_(1.481294555664062500000000000000000000000e2), SC_(9.867196083068847656250000000000000000000e-1), SC_(7.949923700967745049386462649618801557064e-1), SC_(2.050076299032254950613537350381198442936e-1) }}, 
      {{ SC_(2.752766227722167968750000000000000000000e1), SC_(2.752766370773315429687500000000000000000), SC_(1.935389862060546875000000000000000000000e2), SC_(9.891016483306884765625000000000000000000e-1), SC_(7.945772222840904124171162521461456548122e-1), SC_(2.054227777159095875828837478538543451878e-1) }}, 
      {{ SC_(2.752766227722167968750000000000000000000e1), SC_(6.881915569305419921875000000000000000000), SC_(6.163340759277343750000000000000000000000e1), SC_(9.645758271217346191406250000000000000000e-1), SC_(9.904853863591813610386875227410137440869e-1), SC_(9.514613640818638961312477258986255913129e-3) }}, 
      {{ SC_(2.752766227722167968750000000000000000000e1), SC_(6.881915569305419921875000000000000000000), SC_(1.486264953613281250000000000000000000000e2), SC_(9.787681102752685546875000000000000000000e-1), SC_(9.897509073902875691715788128694095484896e-1), SC_(1.024909260971243082842118713059045151037e-2) }}, 
      {{ SC_(2.752766227722167968750000000000000000000e1), SC_(6.881915569305419921875000000000000000000), SC_(1.937735595703125000000000000000000000000e2), SC_(9.824301004409790039062500000000000000000e-1), SC_(9.896186217492077186630372837722192947046e-1), SC_(1.038137825079228133696271622778070529539e-2) }}, 
      {{ SC_(2.752766227722167968750000000000000000000e1), SC_(1.376383113861083984375000000000000000000e1), SC_(7.225879669189453125000000000000000000000e1), SC_(9.552872776985168457031250000000000000000e-1), SC_(9.999856897223208716907108114278577176532e-1), SC_(1.431027767912830928918857214228234675552e-5) }}, 
      {{ SC_(2.752766227722167968750000000000000000000e1), SC_(1.376383113861083984375000000000000000000e1), SC_(1.515480346679687500000000000000000000000e2), SC_(9.704440236091613769531250000000000000000e-1), SC_(9.999817816962564171583644499090729225164e-1), SC_(1.821830374358284163555009092707748357362e-5) }}, 
      {{ SC_(2.752766227722167968750000000000000000000e1), SC_(1.376383113861083984375000000000000000000e1), SC_(1.941185607910156250000000000000000000000e2), SC_(9.750026464462280273437500000000000000000e-1), SC_(9.999808193313633447401909115489769410998e-1), SC_(1.918066863665525980908845102305890017284e-5) }}, 
      {{ SC_(2.752766227722167968750000000000000000000e1), SC_(2.064574623107910156250000000000000000000e1), SC_(9.566968083381652832031250000000000000000e-1), SC_(9.151113033294677734375000000000000000000e-1), SC_(9.999999998597539165064049062546184692540e-1), SC_(1.402460834935950937453815307460285357477e-10) }}, 
      {{ SC_(2.752766227722167968750000000000000000000e1), SC_(2.064574623107910156250000000000000000000e1), SC_(7.844540405273437500000000000000000000000e1), SC_(9.525110125541687011718750000000000000000e-1), SC_(9.999999976598309602596335498448108245849e-1), SC_(2.340169039740366450155189175415056956476e-9) }}, 
      {{ SC_(2.752766227722167968750000000000000000000e1), SC_(2.064574623107910156250000000000000000000e1), SC_(1.584414672851562500000000000000000000000e2), SC_(9.674293994903564453125000000000000000000e-1), SC_(9.999999961120882531951027562951951380738e-1), SC_(3.887911746804897243704804861926219100385e-9) }}, 
      {{ SC_(2.752766227722167968750000000000000000000e1), SC_(2.064574623107910156250000000000000000000e1), SC_(1.962219390869140625000000000000000000000e2), SC_(9.716437458992004394531250000000000000000e-1), SC_(9.999999956835383932437788784600902099812e-1), SC_(4.316461606756221121539909790018837010051e-9) }}, 
      {{ SC_(2.752766227722167968750000000000000000000e1), SC_(2.477489471435546875000000000000000000000e1), SC_(7.142335891723632812500000000000000000000), SC_(5.560841038823127746582031250000000000000e-2), SC_(8.394379778773792641708164968416768362177e-23), SC_(9.999999999999999999999160562022122620736e-1) }}, 
      {{ SC_(2.752766227722167968750000000000000000000e1), SC_(2.477489471435546875000000000000000000000e1), SC_(7.974770355224609375000000000000000000000e1), SC_(7.299616932868957519531250000000000000000e-2), SC_(1.995715531200874020421000181388357451948e-33), SC_(9.999999999999999999999999999999980042845e-1) }}, 
      {{ SC_(2.752766227722167968750000000000000000000e1), SC_(2.477489471435546875000000000000000000000e1), SC_(1.595857238769531250000000000000000000000e2), SC_(8.115892857313156127929687500000000000000e-2), SC_(5.113366436824410885409232210059145393081e-47), SC_(1.000000000000000000000000000000000000000) }}, 
      {{ SC_(2.752766227722167968750000000000000000000e1), SC_(2.477489471435546875000000000000000000000e1), SC_(1.985762634277343750000000000000000000000e2), SC_(8.358610421419143676757812500000000000000e-2), SC_(6.735721044916908750417003158673859278913e-54), SC_(1.000000000000000000000000000000000000000) }}, 
      {{ SC_(2.752766227722167968750000000000000000000e1), SC_(2.725238609313964843750000000000000000000e1), SC_(1.950807952880859375000000000000000000000e1), SC_(1.441791206598281860351562500000000000000e-1), SC_(1.853471321358063351000504356222667207527e-13), SC_(9.999999999998146528678641936648999495644e-1) }}, 
      {{ SC_(2.752766227722167968750000000000000000000e1), SC_(2.725238609313964843750000000000000000000e1), SC_(8.435225677490234375000000000000000000000e1), SC_(1.794148683547973632812500000000000000000e-1), SC_(9.095812031806169339185119921202541541984e-21), SC_(9.999999999999999999909041879681938306608e-1) }}, 
      {{ SC_(2.752766227722167968750000000000000000000e1), SC_(2.725238609313964843750000000000000000000e1), SC_(1.596211700439453125000000000000000000000e2), SC_(1.991560906171798706054687500000000000000e-1), SC_(1.764858323331854032218595497048236622960e-30), SC_(9.999999999999999999999999999982351416767e-1) }}, 
      {{ SC_(2.752766227722167968750000000000000000000e1), SC_(2.725238609313964843750000000000000000000e1), SC_(1.992922668457031250000000000000000000000e2), SC_(2.056968659162521362304687500000000000000e-1), SC_(7.500606652061039484953919659408486591003e-36), SC_(9.999999999999999999999999999999999924994e-1) }}, 
      {{ SC_(2.752766227722167968750000000000000000000e1), SC_(2.750013542175292968750000000000000000000e1), SC_(2.197235107421875000000000000000000000000e1), SC_(2.911846339702606201171875000000000000000e-1), SC_(3.463208093580485739708514267756722864007e-6), SC_(9.999965367919064195142602914857322432771e-1) }}, 
      {{ SC_(2.752766227722167968750000000000000000000e1), SC_(2.750013542175292968750000000000000000000e1), SC_(8.441753387451171875000000000000000000000e1), SC_(3.579603135585784912109375000000000000000e-1), SC_(5.066662854891751249321812277096796531689e-10), SC_(9.999999994933337145108248750678187722903e-1) }}, 
      {{ SC_(2.752766227722167968750000000000000000000e1), SC_(2.750013542175292968750000000000000000000e1), SC_(1.600560913085937500000000000000000000000e2), SC_(3.977430760860443115234375000000000000000e-1), SC_(1.576024258517301021204766222408179146328e-15), SC_(9.999999999999984239757414826989787952338e-1) }}, 
      {{ SC_(2.752766227722167968750000000000000000000e1), SC_(2.752766227722167968750000000000000000000e1), SC_(2.249290275573730468750000000000000000000e1), SC_(4.378127753734588623046875000000000000000e-1), SC_(1.297189521299496891546998595771884801470e-2), SC_(9.870281047870050310845300140422811519853e-1) }}, 
      {{ SC_(2.752766227722167968750000000000000000000e1), SC_(2.752766227722167968750000000000000000000e1), SC_(9.495173645019531250000000000000000000000e1), SC_(5.477300286293029785156250000000000000000e-1), SC_(3.281742978020972912769166278689390664756e-4), SC_(9.996718257021979027087230833721310609335e-1) }}, 
      {{ SC_(2.752766227722167968750000000000000000000e1), SC_(2.752766227722167968750000000000000000000e1), SC_(1.629447326660156250000000000000000000000e2), SC_(5.981188416481018066406250000000000000000e-1), SC_(4.562222853831624102353338984830487458070e-6), SC_(9.999954377771461683758976466610151695125e-1) }}, 
      {{ SC_(2.752766227722167968750000000000000000000e1), SC_(2.753041458129882812500000000000000000000e1), SC_(2.539736366271972656250000000000000000000e1), SC_(5.333073139190673828125000000000000000000e-1), SC_(1.745201762025807317755133792616261747858e-1), SC_(8.254798237974192682244866207383738252142e-1) }}, 
      {{ SC_(2.752766227722167968750000000000000000000e1), SC_(2.753041458129882812500000000000000000000e1), SC_(9.707512664794921875000000000000000000000e1), SC_(6.597443819046020507812500000000000000000e-1), SC_(6.651431865653121562062684264359204888491e-2), SC_(9.334856813434687843793731573564079511151e-1) }}, 
      {{ SC_(2.752766227722167968750000000000000000000e1), SC_(2.753041458129882812500000000000000000000e1), SC_(1.670017089843750000000000000000000000000e2), SC_(7.204003334045410156250000000000000000000e-1), SC_(2.109874024974469389539597490757038872086e-2), SC_(9.789012597502553061046040250924296112791e-1) }}, 
      {{ SC_(2.752766227722167968750000000000000000000e1), SC_(2.755519104003906250000000000000000000000e1), SC_(2.709540176391601562500000000000000000000e1), SC_(5.913713574409484863281250000000000000000e-1), SC_(4.528496997447177187959379844224499620953e-1), SC_(5.471503002552822812040620155775500379047e-1) }}, 
      {{ SC_(2.752766227722167968750000000000000000000e1), SC_(2.755519104003906250000000000000000000000e1), SC_(1.007325439453125000000000000000000000000e2), SC_(7.301287055015563964843750000000000000000e-1), SC_(4.186429517390883204974602192757142222336e-1), SC_(5.813570482609116795025397807242857777664e-1) }}, 
      {{ SC_(2.752766227722167968750000000000000000000e1), SC_(2.755519104003906250000000000000000000000e1), SC_(1.698258666992187500000000000000000000000e2), SC_(7.942953109741210937500000000000000000000e-1), SC_(3.920839960740760116665478131801086218958e-1), SC_(6.079160039259239883334521868198913781042e-1) }}, 
      {{ SC_(2.752766227722167968750000000000000000000e1), SC_(2.780293846130371093750000000000000000000e1), SC_(2.837726783752441406250000000000000000000e1), SC_(5.982953906059265136718750000000000000000e-1), SC_(4.863438159244443703801193343052339678217e-1), SC_(5.136561840755556296198806656947660321783e-1) }}, 
      {{ SC_(2.752766227722167968750000000000000000000e1), SC_(2.780293846130371093750000000000000000000e1), SC_(1.093762969970703125000000000000000000000e2), SC_(7.454011440277099609375000000000000000000e-1), SC_(4.738506193972365772734621941591137266958e-1), SC_(5.261493806027634227265378058408862733042e-1) }}, 
      {{ SC_(2.752766227722167968750000000000000000000e1), SC_(2.780293846130371093750000000000000000000e1), SC_(1.756861267089843750000000000000000000000e2), SC_(8.041725754737854003906250000000000000000e-1), SC_(4.690443905115316548723235517939218396239e-1), SC_(5.309556094884683451276764482060781603761e-1) }}, 
      {{ SC_(2.752766227722167968750000000000000000000e1), SC_(3.028042984008789062500000000000000000000e1), SC_(3.152261734008789062500000000000000000000e1), SC_(5.872114300727844238281250000000000000000e-1), SC_(4.909369411323992431476434087209390006519e-1), SC_(5.090630588676007568523565912790609993481e-1) }}, 
      {{ SC_(2.752766227722167968750000000000000000000e1), SC_(3.028042984008789062500000000000000000000e1), SC_(1.094441146850585937500000000000000000000e2), SC_(7.297499179840087890625000000000000000000e-1), SC_(4.817893573753912491010125431565720146021e-1), SC_(5.182106426246087508989874568434279853979e-1) }}, 
      {{ SC_(2.752766227722167968750000000000000000000e1), SC_(3.028042984008789062500000000000000000000e1), SC_(1.811583862304687500000000000000000000000e2), SC_(7.950970530509948730468750000000000000000e-1), SC_(4.791470680048617608203226602014444080682e-1), SC_(5.208529319951382391796773397985555919318e-1) }}, 
      {{ SC_(2.752766227722167968750000000000000000000e1), SC_(3.303319549560546875000000000000000000000e1), SC_(3.423733520507812500000000000000000000000e1), SC_(5.735865235328674316406250000000000000000e-1), SC_(4.921374625043126237814355201536159492026e-1), SC_(5.078625374956873762185644798463840507974e-1) }}, 
      {{ SC_(2.752766227722167968750000000000000000000e1), SC_(3.303319549560546875000000000000000000000e1), SC_(1.264718551635742187500000000000000000000e2), SC_(7.320917844772338867187500000000000000000e-1), SC_(4.824906957363902014301163050214086248963e-1), SC_(5.175093042636097985698836949785913751037e-1) }}, 
      {{ SC_(2.752766227722167968750000000000000000000e1), SC_(3.303319549560546875000000000000000000000e1), SC_(1.826751708984375000000000000000000000000e2), SC_(7.816919684410095214843750000000000000000e-1), SC_(4.805858605303204844790774284634635379443e-1), SC_(5.194141394696795155209225715365364620557e-1) }}, 
      {{ SC_(2.752766227722167968750000000000000000000e1), SC_(3.578596115112304687500000000000000000000e1), SC_(3.477303314208984375000000000000000000000e1), SC_(5.558167695999145507812500000000000000000e-1), SC_(4.960529560889892757947800618018198475149e-1), SC_(5.039470439110107242052199381981801524851e-1) }}, 
      {{ SC_(2.752766227722167968750000000000000000000e1), SC_(3.578596115112304687500000000000000000000e1), SC_(1.279526672363281250000000000000000000000e2), SC_(7.180345654487609863281250000000000000000e-1), SC_(4.859228514583006875638431061753561242225e-1), SC_(5.140771485416993124361568938246438757775e-1) }}, 
      {{ SC_(2.752766227722167968750000000000000000000e1), SC_(3.578596115112304687500000000000000000000e1), SC_(1.831471099853515625000000000000000000000e2), SC_(7.683044075965881347656250000000000000000e-1), SC_(4.839439185574183106688157932285860278181e-1), SC_(5.160560814425816893311842067714139721819e-1) }}, 
      {{ SC_(2.752766227722167968750000000000000000000e1), SC_(4.129149246215820312500000000000000000000e1), SC_(3.767639541625976562500000000000000000000e1), SC_(5.324648022651672363281250000000000000000e-1), SC_(5.267609261893484459648556826880839956962e-1), SC_(4.732390738106515540351443173119160043038e-1) }}, 
      {{ SC_(2.752766227722167968750000000000000000000e1), SC_(4.129149246215820312500000000000000000000e1), SC_(1.310955810546875000000000000000000000000e2), SC_(6.946340203285217285156250000000000000000e-1), SC_(5.129302806548202002573318437958320323336e-1), SC_(4.870697193451797997426681562041679676664e-1) }}, 
      {{ SC_(2.752766227722167968750000000000000000000e1), SC_(4.129149246215820312500000000000000000000e1), SC_(1.867986450195312500000000000000000000000e2), SC_(7.470832467079162597656250000000000000000e-1), SC_(5.101776399408603119069011448994914204834e-1), SC_(4.898223600591396880930988551005085795166e-1) }}, 
      {{ SC_(2.752766227722167968750000000000000000000e1), SC_(5.505532455444335937500000000000000000000e1), SC_(4.238486480712890625000000000000000000000e1), SC_(5.167565941810607910156250000000000000000e-1), SC_(8.124439951569215657470162814604925066319e-1), SC_(1.875560048430784342529837185395074933681e-1) }}, 
      {{ SC_(2.752766227722167968750000000000000000000e1), SC_(5.505532455444335937500000000000000000000e1), SC_(1.311481323242187500000000000000000000000e2), SC_(6.611716747283935546875000000000000000000e-1), SC_(7.722632024580460017932629237602409733145e-1), SC_(2.277367975419539982067370762397590266855e-1) }}, 
      {{ SC_(2.752766227722167968750000000000000000000e1), SC_(5.505532455444335937500000000000000000000e1), SC_(1.914333953857421875000000000000000000000e2), SC_(7.184460163116455078125000000000000000000e-1), SC_(7.622463465373164170180178161391476004172e-1), SC_(2.377536534626835829819821838608523995828e-1) }}, 
      {{ SC_(2.752766227722167968750000000000000000000e1), SC_(8.258298492431640625000000000000000000000e1), SC_(4.420680999755859375000000000000000000000e1), SC_(4.788286983966827392578125000000000000000e-1), SC_(9.852520536699364048022696755243066195658e-1), SC_(1.474794633006359519773032447569338043415e-2) }}, 
      {{ SC_(2.752766227722167968750000000000000000000e1), SC_(8.258298492431640625000000000000000000000e1), SC_(1.357470245361328125000000000000000000000e2), SC_(6.125127077102661132812500000000000000000e-1), SC_(9.669176729073647909522037413788633686410e-1), SC_(3.308232709263520904779625862113663135900e-2) }}, 
      {{ SC_(2.752766227722167968750000000000000000000e1), SC_(8.258298492431640625000000000000000000000e1), SC_(1.915013732910156250000000000000000000000e2), SC_(6.649461388587951660156250000000000000000e-1), SC_(9.607026540720982161934915834028349974923e-1), SC_(3.929734592790178380650841659716500250765e-2) }}, 
      {{ SC_(2.752766227722167968750000000000000000000e1), SC_(1.101106491088867187500000000000000000000e2), SC_(5.569964599609375000000000000000000000000e1), SC_(4.876573085784912109375000000000000000000e-1), SC_(9.998216984378308544406818653733466180591e-1), SC_(1.783015621691455593181346266533819408922e-4) }}, 
      {{ SC_(2.752766227722167968750000000000000000000e1), SC_(1.101106491088867187500000000000000000000e2), SC_(1.362719116210937500000000000000000000000e2), SC_(5.877190828323364257812500000000000000000e-1), SC_(9.990994307401305984013624491785721898680e-1), SC_(9.005692598694015986375508214278101319549e-4) }}, 
      {{ SC_(2.752766227722167968750000000000000000000e1), SC_(1.101106491088867187500000000000000000000e2), SC_(1.918984832763671875000000000000000000000e2), SC_(6.367552280426025390625000000000000000000e-1), SC_(9.985633518427642052917923853106523329267e-1), SC_(1.436648157235794708207614689347667073276e-3) }}, 
      {{ SC_(2.752766227722167968750000000000000000000e1), SC_(1.376383056640625000000000000000000000000e2), SC_(5.940588760375976562500000000000000000000e1), SC_(5.287568569183349609375000000000000000000e-1), SC_(9.999999988478662161938587604970889564130e-1), SC_(1.152133783806141239502911043586983689096e-9) }}, 
      {{ SC_(2.752766227722167968750000000000000000000e1), SC_(1.376383056640625000000000000000000000000e2), SC_(1.451677856445312500000000000000000000000e2), SC_(6.135572791099548339843750000000000000000e-1), SC_(9.999999400002628056226673092594557931030e-1), SC_(5.999973719437733269074054420689697081156e-8) }}, 
      {{ SC_(2.752766227722167968750000000000000000000e1), SC_(1.376383056640625000000000000000000000000e2), SC_(1.929777069091796875000000000000000000000e2), SC_(6.488190293312072753906250000000000000000e-1), SC_(9.999998353946304370183853159765609084098e-1), SC_(1.646053695629816146840234390915901866926e-7) }}, 
      {{ SC_(2.880632400512695312500000000000000000000e1), SC_(2.880632400512695312500000000000000000000), SC_(4.420680999755859375000000000000000000000e1), SC_(9.730190038681030273437500000000000000000e-1), SC_(8.068797100928167069967000315150294871340e-1), SC_(1.931202899071832930032999684849705128660e-1) }}, 
      {{ SC_(2.880632400512695312500000000000000000000e1), SC_(2.880632400512695312500000000000000000000), SC_(1.357470245361328125000000000000000000000e2), SC_(9.854341745376586914062500000000000000000e-1), SC_(8.032370571252681025024346508177457377390e-1), SC_(1.967629428747318974975653491822542622610e-1) }}, 
      {{ SC_(2.880632400512695312500000000000000000000e1), SC_(2.880632400512695312500000000000000000000), SC_(1.915013732910156250000000000000000000000e2), SC_(9.886312484741210937500000000000000000000e-1), SC_(8.026530477764596767954791426429929372166e-1), SC_(1.973469522235403232045208573570070627834e-1) }}, 
      {{ SC_(2.880632400512695312500000000000000000000e1), SC_(7.201581001281738281250000000000000000000), SC_(5.569964599609375000000000000000000000000e1), SC_(9.621514678001403808593750000000000000000e-1), SC_(9.920464801031604209706330965197178972601e-1), SC_(7.953519896839579029366903480282102739916e-3) }}, 
      {{ SC_(2.880632400512695312500000000000000000000e1), SC_(7.201581001281738281250000000000000000000), SC_(1.362719116210937500000000000000000000000e2), SC_(9.768050909042358398437500000000000000000e-1), SC_(9.913295756239150349541145770845940301313e-1), SC_(8.670424376084965045885422915405969868685e-3) }}, 
      {{ SC_(2.880632400512695312500000000000000000000e1), SC_(7.201581001281738281250000000000000000000), SC_(1.918984832763671875000000000000000000000e2), SC_(9.817080497741699218750000000000000000000e-1), SC_(9.911628367614247757722040890138083407151e-1), SC_(8.837163238575224227795910986191659284931e-3) }}, 
      {{ SC_(2.880632400512695312500000000000000000000e1), SC_(1.440316200256347656250000000000000000000e1), SC_(5.940588760375976562500000000000000000000e1), SC_(9.503389596939086914062500000000000000000e-1), SC_(9.999917831097311136563981106492248557907e-1), SC_(8.216890268886343601889350775144209315679e-6) }}, 
      {{ SC_(2.880632400512695312500000000000000000000e1), SC_(1.440316200256347656250000000000000000000e1), SC_(1.451677856445312500000000000000000000000e2), SC_(9.687349796295166015625000000000000000000e-1), SC_(9.999884778023019499857746857874428382957e-1), SC_(1.152219769805001422531421255716170433573e-5) }}, 
      {{ SC_(2.880632400512695312500000000000000000000e1), SC_(1.440316200256347656250000000000000000000e1), SC_(1.929777069091796875000000000000000000000e2), SC_(9.740970730781555175781250000000000000000e-1), SC_(9.999876878115687640862764199338061894655e-1), SC_(1.231218843123591372358006619381053454645e-5) }}, 
      {{ SC_(2.880632400512695312500000000000000000000e1), SC_(2.160474395751953125000000000000000000000e1), SC_(6.038262176513671875000000000000000000000e1), SC_(9.461426734924316406250000000000000000000e-1), SC_(9.999999992542547414346051393690713635961e-1), SC_(7.457452585653948606309286364039205285752e-10) }}, 
      {{ SC_(2.880632400512695312500000000000000000000e1), SC_(2.160474395751953125000000000000000000000e1), SC_(1.481294555664062500000000000000000000000e2), SC_(9.651209115982055664062500000000000000000e-1), SC_(9.999999983930519264862330396021914475425e-1), SC_(1.606948073513766960397808552457457141018e-9) }}, 
      {{ SC_(2.880632400512695312500000000000000000000e1), SC_(2.160474395751953125000000000000000000000e1), SC_(1.935389862060546875000000000000000000000e2), SC_(9.705107212066650390625000000000000000000e-1), SC_(9.999999981363077154052324017167252274645e-1), SC_(1.863692284594767598283274772535458118731e-9) }}, 
      {{ SC_(2.880632400512695312500000000000000000000e1), SC_(2.592569160461425781250000000000000000000e1), SC_(6.163340759277343750000000000000000000000e1), SC_(6.956721842288970947265625000000000000000e-2), SC_(2.136476277025674616568742311336959008419e-31), SC_(9.999999999999999999999999999997863523723e-1) }}, 
      {{ SC_(2.880632400512695312500000000000000000000e1), SC_(2.592569160461425781250000000000000000000e1), SC_(1.486264953613281250000000000000000000000e2), SC_(7.981996238231658935546875000000000000000e-2), SC_(6.496268169819162304967831892322192708184e-46), SC_(1.000000000000000000000000000000000000000) }}, 
      {{ SC_(2.880632400512695312500000000000000000000e1), SC_(2.592569160461425781250000000000000000000e1), SC_(1.937735595703125000000000000000000000000e2), SC_(8.282867074012756347656250000000000000000e-2), SC_(7.953103437746198287233263991122991400960e-54), SC_(1.000000000000000000000000000000000000000) }}, 
      {{ SC_(2.880632400512695312500000000000000000000e1), SC_(2.851826095581054687500000000000000000000e1), SC_(7.225879669189453125000000000000000000000e1), SC_(1.733948290348052978515625000000000000000e-1), SC_(1.045974394230105065304550123697772956999e-19), SC_(9.999999999999999998954025605769894934695e-1) }}, 
      {{ SC_(2.880632400512695312500000000000000000000e1), SC_(2.851826095581054687500000000000000000000e1), SC_(1.515480346679687500000000000000000000000e2), SC_(1.962048411369323730468750000000000000000e-1), SC_(9.488421403802247160364771448909156463610e-30), SC_(9.999999999999999999999999999905115785962e-1) }}, 
      {{ SC_(2.880632400512695312500000000000000000000e1), SC_(2.851826095581054687500000000000000000000e1), SC_(1.941185607910156250000000000000000000000e2), SC_(2.036311775445938110351562500000000000000e-1), SC_(1.856615251148309515772927607089012584225e-35), SC_(9.999999999999999999999999999999999814338e-1) }}, 
      {{ SC_(2.880632400512695312500000000000000000000e1), SC_(2.877751731872558593750000000000000000000e1), SC_(9.566968083381652832031250000000000000000e-1), SC_(2.521485090255737304687500000000000000000e-1), SC_(2.302373635831504777584729321141567474424e-5), SC_(9.999769762636416849522241527067885843253e-1) }}, 
      {{ SC_(2.880632400512695312500000000000000000000e1), SC_(2.877751731872558593750000000000000000000e1), SC_(7.844540405273437500000000000000000000000e1), SC_(3.507437705993652343750000000000000000000e-1), SC_(9.598499781154295135585989084919362363732e-10), SC_(9.999999990401500218845704864414010915081e-1) }}, 
      {{ SC_(2.880632400512695312500000000000000000000e1), SC_(2.877751731872558593750000000000000000000e1), SC_(1.584414672851562500000000000000000000000e2), SC_(3.943773210048675537109375000000000000000e-1), SC_(1.793617637802149741490037653909281123894e-15), SC_(9.999999999999982063823621978502585099623e-1) }}, 
      {{ SC_(2.880632400512695312500000000000000000000e1), SC_(2.877751731872558593750000000000000000000e1), SC_(1.962219390869140625000000000000000000000e2), SC_(4.072095155715942382812500000000000000000e-1), SC_(2.088659583759922127133504465288729150163e-18), SC_(9.999999999999999979113404162400778728665e-1) }}, 
      {{ SC_(2.880632400512695312500000000000000000000e1), SC_(2.880632400512695312500000000000000000000e1), SC_(7.142335891723632812500000000000000000000), SC_(3.965511023998260498046875000000000000000e-1), SC_(2.153913248273071535904239974901363311248e-2), SC_(9.784608675172692846409576002509863668875e-1) }}, 
      {{ SC_(2.880632400512695312500000000000000000000e1), SC_(2.880632400512695312500000000000000000000e1), SC_(7.974770355224609375000000000000000000000e1), SC_(5.274523496627807617187500000000000000000e-1), SC_(7.395748842120466699212244103222860771175e-4), SC_(9.992604251157879533300787755896777139229e-1) }}, 
      {{ SC_(2.880632400512695312500000000000000000000e1), SC_(2.880632400512695312500000000000000000000e1), SC_(1.595857238769531250000000000000000000000e2), SC_(5.921020507812500000000000000000000000000e-1), SC_(5.894583075557959727129937322074580290961e-6), SC_(9.999941054169244420402728700626779254197e-1) }}, 
      {{ SC_(2.880632400512695312500000000000000000000e1), SC_(2.880632400512695312500000000000000000000e1), SC_(1.985762634277343750000000000000000000000e2), SC_(6.117478013038635253906250000000000000000e-1), SC_(4.115038135562104216792272360010806587743e-7), SC_(9.999995884961864437895783207727639989193e-1) }}, 
      {{ SC_(2.880632400512695312500000000000000000000e1), SC_(2.880920600891113281250000000000000000000e1), SC_(1.950807952880859375000000000000000000000e1), SC_(5.143064260482788085937500000000000000000e-1), SC_(1.833521032998541419949329310920839812261e-1), SC_(8.166478967001458580050670689079160187739e-1) }}, 
      {{ SC_(2.880632400512695312500000000000000000000e1), SC_(2.880920600891113281250000000000000000000e1), SC_(8.435225677490234375000000000000000000000e1), SC_(6.390753984451293945312500000000000000000e-1), SC_(8.015652276556068146555166592242625838817e-2), SC_(9.198434772344393185344483340775737416118e-1) }}, 
      {{ SC_(2.880632400512695312500000000000000000000e1), SC_(2.880920600891113281250000000000000000000e1), SC_(1.596211700439453125000000000000000000000e2), SC_(7.105319499969482421875000000000000000000e-1), SC_(2.462306772605277616543066436852426017845e-2), SC_(9.753769322739472238345693356314757398216e-1) }}, 
      {{ SC_(2.880632400512695312500000000000000000000e1), SC_(2.880920600891113281250000000000000000000e1), SC_(1.992922668457031250000000000000000000000e2), SC_(7.344621419906616210937500000000000000000e-1), SC_(1.215896321992275372950679761470606843476e-2), SC_(9.878410367800772462704932023852939315652e-1) }}, 
      {{ SC_(2.880632400512695312500000000000000000000e1), SC_(2.883513259887695312500000000000000000000e1), SC_(2.197235107421875000000000000000000000000e1), SC_(5.730634331703186035156250000000000000000e-1), SC_(4.557823384519997634493034544268319141640e-1), SC_(5.442176615480002365506965455731680858360e-1) }}, 
      {{ SC_(2.880632400512695312500000000000000000000e1), SC_(2.883513259887695312500000000000000000000e1), SC_(8.441753387451171875000000000000000000000e1), SC_(7.028936147689819335937500000000000000000e-1), SC_(4.260924552309073990022224616760238606760e-1), SC_(5.739075447690926009977775383239761393240e-1) }}, 
      {{ SC_(2.880632400512695312500000000000000000000e1), SC_(2.883513259887695312500000000000000000000e1), SC_(1.600560913085937500000000000000000000000e2), SC_(7.817671298980712890625000000000000000000e-1), SC_(3.969948614353518473975052127333170476103e-1), SC_(6.030051385646481526024947872666829523897e-1) }}, 
      {{ SC_(2.880632400512695312500000000000000000000e1), SC_(2.909438705444335937500000000000000000000e1), SC_(2.249290275573730468750000000000000000000e1), SC_(5.776717066764831542968750000000000000000e-1), SC_(4.884950958305907029215449279034248226967e-1), SC_(5.115049041694092970784550720965751773033e-1) }}, 
      {{ SC_(2.880632400512695312500000000000000000000e1), SC_(2.909438705444335937500000000000000000000e1), SC_(9.495173645019531250000000000000000000000e1), SC_(7.219976782798767089843750000000000000000e-1), SC_(4.759617606269071557495272611931218097799e-1), SC_(5.240382393730928442504727388068781902201e-1) }}, 
      {{ SC_(2.880632400512695312500000000000000000000e1), SC_(2.909438705444335937500000000000000000000e1), SC_(1.629447326660156250000000000000000000000e2), SC_(7.895822525024414062500000000000000000000e-1), SC_(4.705871887105642541793315807863055473208e-1), SC_(5.294128112894357458206684192136944526792e-1) }}, 
      {{ SC_(2.880632400512695312500000000000000000000e1), SC_(3.168695640563964843750000000000000000000e1), SC_(2.539736366271972656250000000000000000000e1), SC_(5.660443305969238281250000000000000000000e-1), SC_(4.929126660822659599000075621586704254818e-1), SC_(5.070873339177340400999924378413295745182e-1) }}, 
      {{ SC_(2.880632400512695312500000000000000000000e1), SC_(3.168695640563964843750000000000000000000e1), SC_(9.707512664794921875000000000000000000000e1), SC_(7.081896066665649414062500000000000000000e-1), SC_(4.832422364132912738788865210464727740212e-1), SC_(5.167577635867087261211134789535272259788e-1) }}, 
      {{ SC_(2.880632400512695312500000000000000000000e1), SC_(3.168695640563964843750000000000000000000e1), SC_(1.670017089843750000000000000000000000000e2), SC_(7.790564894676208496093750000000000000000e-1), SC_(4.801695660303202690872199424479782860599e-1), SC_(5.198304339696797309127800575520217139401e-1) }}, 
      {{ SC_(2.880632400512695312500000000000000000000e1), SC_(3.456758880615234375000000000000000000000e1), SC_(2.709540176391601562500000000000000000000e1), SC_(5.496289134025573730468750000000000000000e-1), SC_(4.942887914359515816909244906684844911497e-1), SC_(5.057112085640484183090755093315155088503e-1) }}, 
      {{ SC_(2.880632400512695312500000000000000000000e1), SC_(3.456758880615234375000000000000000000000e1), SC_(1.007325439453125000000000000000000000000e2), SC_(6.949301958084106445312500000000000000000e-1), SC_(4.846011328382766592377953198566244326945e-1), SC_(5.153988671617233407622046801433755673055e-1) }}, 
      {{ SC_(2.880632400512695312500000000000000000000e1), SC_(3.456758880615234375000000000000000000000e1), SC_(1.698258666992187500000000000000000000000e2), SC_(7.660102248191833496093750000000000000000e-1), SC_(4.815710742928868541630442578820868850460e-1), SC_(5.184289257071131458369557421179131149540e-1) }}, 
      {{ SC_(2.880632400512695312500000000000000000000e1), SC_(3.744821929931640625000000000000000000000e1), SC_(2.837726783752441406250000000000000000000e1), SC_(5.339215397834777832031250000000000000000e-1), SC_(4.981254538752599462034411025917937358292e-1), SC_(5.018745461247400537965588974082062641708e-1) }}, 
      {{ SC_(2.880632400512695312500000000000000000000e1), SC_(3.744821929931640625000000000000000000000e1), SC_(1.093762969970703125000000000000000000000e2), SC_(6.895167231559753417968750000000000000000e-1), SC_(4.876686312757143582618652647778361719409e-1), SC_(5.123313687242856417381347352221638280591e-1) }}, 
      {{ SC_(2.880632400512695312500000000000000000000e1), SC_(3.744821929931640625000000000000000000000e1), SC_(1.756861267089843750000000000000000000000e2), SC_(7.563284635543823242187500000000000000000e-1), SC_(4.848366823325336056696521778739000778033e-1), SC_(5.151633176674663943303478221260999221967e-1) }}, 
      {{ SC_(2.880632400512695312500000000000000000000e1), SC_(4.320948791503906250000000000000000000000e1), SC_(3.152261734008789062500000000000000000000e1), SC_(5.116131901741027832031250000000000000000e-1), SC_(5.301548323158756175415525200692690345758e-1), SC_(4.698451676841243824584474799307309654242e-1) }}, 
      {{ SC_(2.880632400512695312500000000000000000000e1), SC_(4.320948791503906250000000000000000000000e1), SC_(1.094441146850585937500000000000000000000e2), SC_(6.612896919250488281250000000000000000000e-1), SC_(5.160029929554685741230763219828432519416e-1), SC_(4.839970070445314258769236780171567480584e-1) }}, 
      {{ SC_(2.880632400512695312500000000000000000000e1), SC_(4.320948791503906250000000000000000000000e1), SC_(1.811583862304687500000000000000000000000e2), SC_(7.359805107116699218750000000000000000000e-1), SC_(5.116937653591875489466727942990381231008e-1), SC_(4.883062346408124510533272057009618768992e-1) }}, 
      {{ SC_(2.880632400512695312500000000000000000000e1), SC_(5.761264801025390625000000000000000000000e1), SC_(3.423733520507812500000000000000000000000e1), SC_(4.933362305164337158203125000000000000000e-1), SC_(8.273317950915005279293176516131753920457e-1), SC_(1.726682049084994720706823483868246079543e-1) }}, 
      {{ SC_(2.880632400512695312500000000000000000000e1), SC_(5.761264801025390625000000000000000000000e1), SC_(1.264718551635742187500000000000000000000e2), SC_(6.490391492843627929687500000000000000000e-1), SC_(7.802706653830080288554378731348872203453e-1), SC_(2.197293346169919711445621268651127796547e-1) }}, 
      {{ SC_(2.880632400512695312500000000000000000000e1), SC_(5.761264801025390625000000000000000000000e1), SC_(1.826751708984375000000000000000000000000e2), SC_(7.045029997825622558593750000000000000000e-1), SC_(7.699649530915759246617043895835126449680e-1), SC_(2.300350469084240753382956104164873550320e-1) }}, 
      {{ SC_(2.880632400512695312500000000000000000000e1), SC_(8.641897583007812500000000000000000000000e1), SC_(3.477303314208984375000000000000000000000e1), SC_(4.564058482646942138671875000000000000000e-1), SC_(9.898318211915503313574872600441754964457e-1), SC_(1.016817880844966864251273995582450355435e-2) }}, 
      {{ SC_(2.880632400512695312500000000000000000000e1), SC_(8.641897583007812500000000000000000000000e1), SC_(1.279526672363281250000000000000000000000e2), SC_(5.973291397094726562500000000000000000000e-1), SC_(9.717908465737417495641546847174774616500e-1), SC_(2.820915342625825043584531528252253834995e-2) }}, 
      {{ SC_(2.880632400512695312500000000000000000000e1), SC_(8.641897583007812500000000000000000000000e1), SC_(1.831471099853515625000000000000000000000e2), SC_(6.510134935379028320312500000000000000000e-1), SC_(9.655896632456884265383362653277847505952e-1), SC_(3.441033675431157346166373467221524940479e-2) }}, 
      {{ SC_(2.880632400512695312500000000000000000000e1), SC_(1.152252960205078125000000000000000000000e2), SC_(3.767639541625976562500000000000000000000e1), SC_(4.554068148136138916015625000000000000000e-1), SC_(9.999488178579066132029726565281889153386e-1), SC_(5.118214209338679702734347181108466143006e-5) }}, 
      {{ SC_(2.880632400512695312500000000000000000000e1), SC_(1.152252960205078125000000000000000000000e2), SC_(1.310955810546875000000000000000000000000e2), SC_(5.764511227607727050781250000000000000000e-1), SC_(9.993856371957048428751278424253705653520e-1), SC_(6.143628042951571248721575746294346480119e-4) }}, 
      {{ SC_(2.880632400512695312500000000000000000000e1), SC_(1.152252960205078125000000000000000000000e2), SC_(1.867986450195312500000000000000000000000e2), SC_(6.260735988616943359375000000000000000000e-1), SC_(9.989591038539630417567296615188608608088e-1), SC_(1.040896146036958243270338481139139191216e-3) }}, 
      {{ SC_(2.880632400512695312500000000000000000000e1), SC_(1.440316162109375000000000000000000000000e2), SC_(4.238486480712890625000000000000000000000e1), SC_(5.048449039459228515625000000000000000000e-1), SC_(9.999999999285866732234780308095317188623e-1), SC_(7.141332677652196919046828113770400405922e-11) }}, 
      {{ SC_(2.880632400512695312500000000000000000000e1), SC_(1.440316162109375000000000000000000000000e2), SC_(1.311481323242187500000000000000000000000e2), SC_(5.967826843261718750000000000000000000000e-1), SC_(9.999999832811063454224692937717419211649e-1), SC_(1.671889365457753070622825807883506060344e-8) }}, 
      {{ SC_(2.880632400512695312500000000000000000000e1), SC_(1.440316162109375000000000000000000000000e2), SC_(1.914333953857421875000000000000000000000e2), SC_(6.419778466224670410156250000000000000000e-1), SC_(9.999999271500380326192509576095234355239e-1), SC_(7.284996196738074904239047656447606435842e-8) }}, 
      {{ SC_(3.194380950927734375000000000000000000000e1), SC_(3.194380998611450195312500000000000000000), SC_(3.477303314208984375000000000000000000000e1), SC_(9.693999886512756347656250000000000000000e-1), SC_(8.260260193267359778856777312211683650862e-1), SC_(1.739739806732640221143222687788316349138e-1) }}, 
      {{ SC_(3.194380950927734375000000000000000000000e1), SC_(3.194380998611450195312500000000000000000), SC_(1.279526672363281250000000000000000000000e2), SC_(9.837804436683654785156250000000000000000e-1), SC_(8.214850700129190203827872356858409876934e-1), SC_(1.785149299870809796172127643141590123066e-1) }}, 
      {{ SC_(3.194380950927734375000000000000000000000e1), SC_(3.194380998611450195312500000000000000000), SC_(1.831471099853515625000000000000000000000e2), SC_(9.873231649398803710937500000000000000000e-1), SC_(8.207970215005903762872745499415357826599e-1), SC_(1.792029784994096237127254500584642173401e-1) }}, 
      {{ SC_(3.194380950927734375000000000000000000000e1), SC_(7.985952377319335937500000000000000000000), SC_(3.767639541625976562500000000000000000000e1), SC_(9.544563889503479003906250000000000000000e-1), SC_(9.950065506120419448851456305296809317388e-1), SC_(4.993449387958055114854369470319068261215e-3) }}, 
      {{ SC_(3.194380950927734375000000000000000000000e1), SC_(7.985952377319335937500000000000000000000), SC_(1.310955810546875000000000000000000000000e2), SC_(9.746138453483581542968750000000000000000e-1), SC_(9.941809864606134620090564510383846270356e-1), SC_(5.819013539386537990943548961615372964364e-3) }}, 
      {{ SC_(3.194380950927734375000000000000000000000e1), SC_(7.985952377319335937500000000000000000000), SC_(1.867986450195312500000000000000000000000e2), SC_(9.799295663833618164062500000000000000000e-1), SC_(9.940359020112552617062431865234380171955e-1), SC_(5.964097988744738293756813476561982804501e-3) }}, 
      {{ SC_(3.194380950927734375000000000000000000000e1), SC_(1.597190475463867187500000000000000000000e1), SC_(4.238486480712890625000000000000000000000e1), SC_(9.419649839401245117187500000000000000000e-1), SC_(9.999978538644932619564729585142280342994e-1), SC_(2.146135506738043527041485771965700570122e-6) }}, 
      {{ SC_(3.194380950927734375000000000000000000000e1), SC_(1.597190475463867187500000000000000000000e1), SC_(1.311481323242187500000000000000000000000e2), SC_(9.646372795104980468750000000000000000000e-1), SC_(9.999962891165259181947966843141500812930e-1), SC_(3.710883474081805203315685849918706957328e-6) }}, 
      {{ SC_(3.194380950927734375000000000000000000000e1), SC_(1.597190475463867187500000000000000000000e1), SC_(1.914333953857421875000000000000000000000e2), SC_(9.720710515975952148437500000000000000000e-1), SC_(9.999958466447523184863881866769836065492e-1), SC_(4.153355247681513611813323016393450771043e-6) }}, 
      {{ SC_(3.194380950927734375000000000000000000000e1), SC_(2.395785713195800781250000000000000000000e1), SC_(4.420680999755859375000000000000000000000e1), SC_(9.383504390716552734375000000000000000000e-1), SC_(9.999999999437009117057570806375360684719e-1), SC_(5.629908829424291936246393152808958212606e-11) }}, 
      {{ SC_(3.194380950927734375000000000000000000000e1), SC_(2.395785713195800781250000000000000000000e1), SC_(1.357470245361328125000000000000000000000e2), SC_(9.611166119575500488281250000000000000000e-1), SC_(9.999999998125169325998244176105698208551e-1), SC_(1.874830674001755823894301791448730241765e-10) }}, 
      {{ SC_(3.194380950927734375000000000000000000000e1), SC_(2.395785713195800781250000000000000000000e1), SC_(1.915013732910156250000000000000000000000e2), SC_(9.682726860046386718750000000000000000000e-1), SC_(9.999999997615091048284016536304210298772e-1), SC_(2.384908951715983463695789701228419876757e-10) }}, 
      {{ SC_(3.194380950927734375000000000000000000000e1), SC_(2.874942779541015625000000000000000000000e1), SC_(5.569964599609375000000000000000000000000e1), SC_(6.741522997617721557617187500000000000000e-2), SC_(1.157262363993572722458864758445707939678e-32), SC_(9.999999999999999999999999999999884273764e-1) }}, 
      {{ SC_(3.194380950927734375000000000000000000000e1), SC_(2.874942779541015625000000000000000000000e1), SC_(1.362719116210937500000000000000000000000e2), SC_(7.759246230125427246093750000000000000000e-2), SC_(8.399195296340050460282563249920712663957e-46), SC_(1.000000000000000000000000000000000000000) }}, 
      {{ SC_(3.194380950927734375000000000000000000000e1), SC_(2.874942779541015625000000000000000000000e1), SC_(1.918984832763671875000000000000000000000e2), SC_(8.157470077276229858398437500000000000000e-2), SC_(1.970343340958597703008896109724661500964e-55), SC_(1.000000000000000000000000000000000000000) }}, 
      {{ SC_(3.194380950927734375000000000000000000000e1), SC_(3.162437248229980468750000000000000000000e1), SC_(5.940588760375976562500000000000000000000e1), SC_(1.649459451436996459960937500000000000000e-1), SC_(3.061443971290968135862345930270666758115e-19), SC_(9.999999999999999996938556028709031864138e-1) }}, 
      {{ SC_(3.194380950927734375000000000000000000000e1), SC_(3.162437248229980468750000000000000000000e1), SC_(1.451677856445312500000000000000000000000e2), SC_(1.917045265436172485351562500000000000000e-1), SC_(8.687265644594313035288678646994035208795e-30), SC_(9.999999999999999999999999999913127343554e-1) }}, 
      {{ SC_(3.194380950927734375000000000000000000000e1), SC_(3.162437248229980468750000000000000000000e1), SC_(1.929777069091796875000000000000000000000e2), SC_(2.004184871912002563476562500000000000000e-1), SC_(4.234500337391609210516626012605926968555e-36), SC_(9.999999999999999999999999999999999957655e-1) }}, 
      {{ SC_(3.194380950927734375000000000000000000000e1), SC_(3.191186523437500000000000000000000000000e1), SC_(6.038262176513671875000000000000000000000e1), SC_(3.297617137432098388671875000000000000000e-1), SC_(6.397226552304448407467692550748876481690e-9), SC_(9.999999936027734476955515925323074492511e-1) }}, 
      {{ SC_(3.194380950927734375000000000000000000000e1), SC_(3.191186523437500000000000000000000000000e1), SC_(1.481294555664062500000000000000000000000e2), SC_(3.838601112365722656250000000000000000000e-1), SC_(6.746637877022358436282760741524595387510e-15), SC_(9.999999999999932533621229776415637172393e-1) }}, 
      {{ SC_(3.194380950927734375000000000000000000000e1), SC_(3.191186523437500000000000000000000000000e1), SC_(1.935389862060546875000000000000000000000e2), SC_(4.002909660339355468750000000000000000000e-1), SC_(2.527362620497046120776314498896923796811e-18), SC_(9.999999999999999974726373795029538792237e-1) }}, 
      {{ SC_(3.194380950927734375000000000000000000000e1), SC_(3.194380950927734375000000000000000000000e1), SC_(6.163340759277343750000000000000000000000e1), SC_(4.961554706096649169921875000000000000000e-1), SC_(1.637751008467659153383934979816514064221e-3), SC_(9.983622489915323408466160650201834859358e-1) }}, 
      {{ SC_(3.194380950927734375000000000000000000000e1), SC_(3.194380950927734375000000000000000000000e1), SC_(1.486264953613281250000000000000000000000e2), SC_(5.759701728820800781250000000000000000000e-1), SC_(1.229344260438730679491595549129733963497e-5), SC_(9.999877065573956126932050840445087026604e-1) }}, 
      {{ SC_(3.194380950927734375000000000000000000000e1), SC_(3.194380950927734375000000000000000000000e1), SC_(1.937735595703125000000000000000000000000e2), SC_(6.004260778427124023437500000000000000000e-1), SC_(6.535669787674647394460340760825354999569e-7), SC_(9.999993464330212325352605539659239174645e-1) }}, 
      {{ SC_(3.194380950927734375000000000000000000000e1), SC_(3.194700431823730468750000000000000000000e1), SC_(7.225879669189453125000000000000000000000e1), SC_(6.114968657493591308593750000000000000000e-1), SC_(9.338914184892585489085307470614434862894e-2), SC_(9.066108581510741451091469252938556513711e-1) }}, 
      {{ SC_(3.194380950927734375000000000000000000000e1), SC_(3.194700431823730468750000000000000000000e1), SC_(1.515480346679687500000000000000000000000e2), SC_(6.933338046073913574218750000000000000000e-1), SC_(2.943813896070135959616683451120397054035e-2), SC_(9.705618610392986404038331654887960294597e-1) }}, 
      {{ SC_(3.194380950927734375000000000000000000000e1), SC_(3.194700431823730468750000000000000000000e1), SC_(1.941185607910156250000000000000000000000e2), SC_(7.206895351409912109375000000000000000000e-1), SC_(1.446367335856828866862784084389840441717e-2), SC_(9.855363266414317113313721591561015955828e-1) }}, 
      {{ SC_(3.194380950927734375000000000000000000000e1), SC_(3.197575569152832031250000000000000000000e1), SC_(9.566968083381652832031250000000000000000e-1), SC_(4.983745813369750976562500000000000000000e-1), SC_(4.676935786810435213661803137997908046609e-1), SC_(5.323064213189564786338196862002091953391e-1) }}, 
      {{ SC_(3.194380950927734375000000000000000000000e1), SC_(3.197575569152832031250000000000000000000e1), SC_(7.844540405273437500000000000000000000000e1), SC_(6.819525957107543945312500000000000000000e-1), SC_(4.298853344142211633635314645521574723034e-1), SC_(5.701146655857788366364685354478425276966e-1) }}, 
      {{ SC_(3.194380950927734375000000000000000000000e1), SC_(3.197575569152832031250000000000000000000e1), SC_(1.584414672851562500000000000000000000000e2), SC_(7.679913043975830078125000000000000000000e-1), SC_(4.002936489512545118622633944339851628205e-1), SC_(5.997063510487454881377366055660148371795e-1) }}, 
      {{ SC_(3.194380950927734375000000000000000000000e1), SC_(3.197575569152832031250000000000000000000e1), SC_(1.962219390869140625000000000000000000000e2), SC_(7.938993573188781738281250000000000000000e-1), SC_(3.873115665015572525177212965290580838512e-1), SC_(6.126884334984427474822787034709419161488e-1) }}, 
      {{ SC_(3.194380950927734375000000000000000000000e1), SC_(3.226324844360351562500000000000000000000e1), SC_(7.142335891723632812500000000000000000000), SC_(5.230943560600280761718750000000000000000e-1), SC_(4.942156932925085423605789198250582106082e-1), SC_(5.057843067074914576394210801749417893918e-1) }}, 
      {{ SC_(3.194380950927734375000000000000000000000e1), SC_(3.226324844360351562500000000000000000000e1), SC_(7.974770355224609375000000000000000000000e1), SC_(6.881877779960632324218750000000000000000e-1), SC_(4.791638431594409987980420425586640220748e-1), SC_(5.208361568405590012019579574413359779252e-1) }}, 
      {{ SC_(3.194380950927734375000000000000000000000e1), SC_(3.226324844360351562500000000000000000000e1), SC_(1.595857238769531250000000000000000000000e2), SC_(7.743122577667236328125000000000000000000e-1), SC_(4.724532738880884540711233079463632758207e-1), SC_(5.275467261119115459288766920536367241793e-1) }}, 
      {{ SC_(3.194380950927734375000000000000000000000e1), SC_(3.226324844360351562500000000000000000000e1), SC_(1.985762634277343750000000000000000000000e2), SC_(8.011305332183837890625000000000000000000e-1), SC_(4.701885318315305636008578034933316256769e-1), SC_(5.298114681684694363991421965066683743231e-1) }}, 
      {{ SC_(3.194380950927734375000000000000000000000e1), SC_(3.513819122314453125000000000000000000000e1), SC_(1.950807952880859375000000000000000000000e1), SC_(5.419304966926574707031250000000000000000e-1), SC_(4.953269506782204957336213287947897885890e-1), SC_(5.046730493217795042663786712052102114110e-1) }}, 
      {{ SC_(3.194380950927734375000000000000000000000e1), SC_(3.513819122314453125000000000000000000000e1), SC_(8.435225677490234375000000000000000000000e1), SC_(6.772565841674804687500000000000000000000e-1), SC_(4.856808798598094676059149009374425508734e-1), SC_(5.143191201401905323940850990625574491266e-1) }}, 
      {{ SC_(3.194380950927734375000000000000000000000e1), SC_(3.513819122314453125000000000000000000000e1), SC_(1.596211700439453125000000000000000000000e2), SC_(7.599050998687744140625000000000000000000e-1), SC_(4.818588903416782319111361074333982682179e-1), SC_(5.181411096583217680888638925666017317821e-1) }}, 
      {{ SC_(3.194380950927734375000000000000000000000e1), SC_(3.513819122314453125000000000000000000000e1), SC_(1.992922668457031250000000000000000000000e2), SC_(7.884930968284606933593750000000000000000e-1), SC_(4.808495530900824962259202136006230586812e-1), SC_(5.191504469099175037740797863993769413188e-1) }}, 
      {{ SC_(3.194380950927734375000000000000000000000e1), SC_(3.833257293701171875000000000000000000000e1), SC_(2.197235107421875000000000000000000000000e1), SC_(5.275498628616333007812500000000000000000e-1), SC_(4.964536994106811051111083691816542118780e-1), SC_(5.035463005893188948888916308183457881220e-1) }}, 
      {{ SC_(3.194380950927734375000000000000000000000e1), SC_(3.833257293701171875000000000000000000000e1), SC_(8.441753387451171875000000000000000000000e1), SC_(6.581184267997741699218750000000000000000e-1), SC_(4.872819633319759077166221414797636228752e-1), SC_(5.127180366680240922833778585202363771248e-1) }}, 
      {{ SC_(3.194380950927734375000000000000000000000e1), SC_(3.833257293701171875000000000000000000000e1), SC_(1.600560913085937500000000000000000000000e2), SC_(7.440892457962036132812500000000000000000e-1), SC_(4.833107043648304254643578573513901809033e-1), SC_(5.166892956351695745356421426486098190967e-1) }}, 
      {{ SC_(3.194380950927734375000000000000000000000e1), SC_(4.152695083618164062500000000000000000000e1), SC_(2.249290275573730468750000000000000000000e1), SC_(5.095391869544982910156250000000000000000e-1), SC_(5.006608704665156111097331467465614209583e-1), SC_(4.993391295334843888902668532534385790417e-1) }}, 
      {{ SC_(3.194380950927734375000000000000000000000e1), SC_(4.152695083618164062500000000000000000000e1), SC_(9.495173645019531250000000000000000000000e1), SC_(6.558803915977478027343750000000000000000e-1), SC_(4.902517918741350655835785177902840495380e-1), SC_(5.097482081258649344164214822097159504620e-1) }}, 
      {{ SC_(3.194380950927734375000000000000000000000e1), SC_(4.152695083618164062500000000000000000000e1), SC_(1.629447326660156250000000000000000000000e2), SC_(7.313449382781982421875000000000000000000e-1), SC_(4.867790025315515088519045589730667618618e-1), SC_(5.132209974684484911480954410269332381382e-1) }}, 
      {{ SC_(3.194380950927734375000000000000000000000e1), SC_(4.791571426391601562500000000000000000000e1), SC_(2.539736366271972656250000000000000000000e1), SC_(4.866838455200195312500000000000000000000e-1), SC_(5.354228666072679553730068696805140194201e-1), SC_(4.645771333927320446269931303194859805799e-1) }}, 
      {{ SC_(3.194380950927734375000000000000000000000e1), SC_(4.791571426391601562500000000000000000000e1), SC_(9.707512664794921875000000000000000000000e1), SC_(6.294232010841369628906250000000000000000e-1), SC_(5.204667626961465069160431473028317478325e-1), SC_(4.795332373038534930839568526971682521675e-1) }}, 
      {{ SC_(3.194380950927734375000000000000000000000e1), SC_(4.791571426391601562500000000000000000000e1), SC_(1.670017089843750000000000000000000000000e2), SC_(7.086824774742126464843750000000000000000e-1), SC_(5.153488529079714075290137115882511189647e-1), SC_(4.846511470920285924709862884117488810353e-1) }}, 
      {{ SC_(3.194380950927734375000000000000000000000e1), SC_(6.388761901855468750000000000000000000000e1), SC_(2.709540176391601562500000000000000000000e1), SC_(4.684047996997833251953125000000000000000e-1), SC_(8.509747298818906618002599488554042455468e-1), SC_(1.490252701181093381997400511445957544532e-1) }}, 
      {{ SC_(3.194380950927734375000000000000000000000e1), SC_(6.388761901855468750000000000000000000000e1), SC_(1.007325439453125000000000000000000000000e2), SC_(6.017959713935852050781250000000000000000e-1), SC_(8.040166171624068113516851070084422074159e-1), SC_(1.959833828375931886483148929915577925841e-1) }}, 
      {{ SC_(3.194380950927734375000000000000000000000e1), SC_(6.388761901855468750000000000000000000000e1), SC_(1.698258666992187500000000000000000000000e2), SC_(6.778289079666137695312500000000000000000e-1), SC_(7.873242614696552503273243836399543096996e-1), SC_(2.126757385303447496726756163600456903004e-1) }}, 
      {{ SC_(3.194380950927734375000000000000000000000e1), SC_(9.583142852783203125000000000000000000000e1), SC_(2.837726783752441406250000000000000000000e1), SC_(4.370698332786560058593750000000000000000e-1), SC_(9.944900032424498784854346609539446666459e-1), SC_(5.509996757550121514565339046055333354120e-3) }}, 
      {{ SC_(3.194380950927734375000000000000000000000e1), SC_(9.583142852783203125000000000000000000000e1), SC_(1.093762969970703125000000000000000000000e2), SC_(5.616068243980407714843750000000000000000e-1), SC_(9.816100428954079345786271587748514688826e-1), SC_(1.838995710459206542137284122514853111745e-2) }}, 
      {{ SC_(3.194380950927734375000000000000000000000e1), SC_(9.583142852783203125000000000000000000000e1), SC_(1.756861267089843750000000000000000000000e2), SC_(6.289256811141967773437500000000000000000e-1), SC_(9.746099524111097091503770686366825783429e-1), SC_(2.539004758889029084962293136331742165707e-2) }}, 
      {{ SC_(3.194380950927734375000000000000000000000e1), SC_(1.277752380371093750000000000000000000000e2), SC_(3.152261734008789062500000000000000000000e1), SC_(4.396013617515563964843750000000000000000e-1), SC_(9.999887356859756612069764055910735061410e-1), SC_(1.126431402433879302359440892649385900707e-5) }}, 
      {{ SC_(3.194380950927734375000000000000000000000e1), SC_(1.277752380371093750000000000000000000000e2), SC_(1.094441146850585937500000000000000000000e2), SC_(5.411065816879272460937500000000000000000e-1), SC_(9.998079789035861614686916448007484740837e-1), SC_(1.920210964138385313083551992515259162730e-4) }}, 
      {{ SC_(3.194380950927734375000000000000000000000e1), SC_(1.277752380371093750000000000000000000000e2), SC_(1.811583862304687500000000000000000000000e2), SC_(6.067461371421813964843750000000000000000e-1), SC_(9.995183471056826185669698753410421015767e-1), SC_(4.816528943173814330301246589578984233171e-4) }}, 
      {{ SC_(3.194380950927734375000000000000000000000e1), SC_(1.597190551757812500000000000000000000000e2), SC_(3.423733520507812500000000000000000000000e1), SC_(4.897959232330322265625000000000000000000e-1), SC_(9.999999999986877693957108690266921266523e-1), SC_(1.312230604289130973307873347721202842111e-12) }}, 
      {{ SC_(3.194380950927734375000000000000000000000e1), SC_(1.597190551757812500000000000000000000000e2), SC_(1.264718551635742187500000000000000000000e2), SC_(5.818614959716796875000000000000000000000e-1), SC_(9.999999984576143219842935217568062636499e-1), SC_(1.542385678015706478243193736350143771181e-9) }}, 
      {{ SC_(3.194380950927734375000000000000000000000e1), SC_(1.597190551757812500000000000000000000000e2), SC_(1.826751708984375000000000000000000000000e2), SC_(6.233193278312683105468750000000000000000e-1), SC_(9.999999916788869156025587091035464168397e-1), SC_(8.321113084397441290896453583160334627109e-9) }}, 
      {{ SC_(3.808220291137695312500000000000000000000e1), SC_(3.808220386505126953125000000000000000000), SC_(2.837726783752441406250000000000000000000e1), SC_(9.658927917480468750000000000000000000000e-1), SC_(8.563426072741865823733527606466457804101e-1), SC_(1.436573927258134176266472393533542195899e-1) }}, 
      {{ SC_(3.808220291137695312500000000000000000000e1), SC_(3.808220386505126953125000000000000000000), SC_(1.093762969970703125000000000000000000000e2), SC_(9.801687002182006835937500000000000000000e-1), SC_(8.515915192695767626436415369895876829114e-1), SC_(1.484084807304232373563584630104123170886e-1) }}, 
      {{ SC_(3.808220291137695312500000000000000000000e1), SC_(3.808220386505126953125000000000000000000), SC_(1.756861267089843750000000000000000000000e2), SC_(9.852463006973266601562500000000000000000e-1), SC_(8.505168415168493085525885887263763838284e-1), SC_(1.494831584831506914474114112736236161716e-1) }}, 
      {{ SC_(3.808220291137695312500000000000000000000e1), SC_(9.520550727844238281250000000000000000000), SC_(3.152261734008789062500000000000000000000e1), SC_(9.497195482254028320312500000000000000000e-1), SC_(9.978283815283615143870072852300519244686e-1), SC_(2.171618471638485612992714769948075531450e-3) }}, 
      {{ SC_(3.808220291137695312500000000000000000000e1), SC_(9.520550727844238281250000000000000000000), SC_(1.094441146850585937500000000000000000000e2), SC_(9.688237309455871582031250000000000000000e-1), SC_(9.973565800809777176600271306266883984554e-1), SC_(2.643419919022282339972869373311601544620e-3) }}, 
      {{ SC_(3.808220291137695312500000000000000000000e1), SC_(9.520550727844238281250000000000000000000), SC_(1.811583862304687500000000000000000000000e2), SC_(9.769248366355895996093750000000000000000e-1), SC_(9.972150066122643813150113033965086014197e-1), SC_(2.784993387735618684988696603491398580259e-3) }}, 
      {{ SC_(3.808220291137695312500000000000000000000e1), SC_(1.904110145568847656250000000000000000000e1), SC_(3.423733520507812500000000000000000000000e1), SC_(9.356824755668640136718750000000000000000e-1), SC_(9.999998129005235840760979100133646855155e-1), SC_(1.870994764159239020899866353144844691623e-7) }}, 
      {{ SC_(3.808220291137695312500000000000000000000e1), SC_(1.904110145568847656250000000000000000000e1), SC_(1.264718551635742187500000000000000000000e2), SC_(9.602767825126647949218750000000000000000e-1), SC_(9.999995811184444326266039688957444548635e-1), SC_(4.188815555673733960311042555451365153215e-7) }}, 
      {{ SC_(3.808220291137695312500000000000000000000e1), SC_(1.904110145568847656250000000000000000000e1), SC_(1.826751708984375000000000000000000000000e2), SC_(9.678029417991638183593750000000000000000e-1), SC_(9.999995112387623522175579075006933334502e-1), SC_(4.887612376477824420924993066665498154293e-7) }}, 
      {{ SC_(3.808220291137695312500000000000000000000e1), SC_(2.856165313720703125000000000000000000000e1), SC_(3.477303314208984375000000000000000000000e1), SC_(9.318532347679138183593750000000000000000e-1), SC_(9.999999999995146396584400208028082066710e-1), SC_(4.853603415599791971917933290089508035579e-13) }}, 
      {{ SC_(3.808220291137695312500000000000000000000e1), SC_(2.856165313720703125000000000000000000000e1), SC_(1.279526672363281250000000000000000000000e2), SC_(9.561036229133605957031250000000000000000e-1), SC_(9.999999999971294575226838068628109324610e-1), SC_(2.870542477316193137189067538971826735392e-12) }}, 
      {{ SC_(3.808220291137695312500000000000000000000e1), SC_(2.856165313720703125000000000000000000000e1), SC_(1.831471099853515625000000000000000000000e2), SC_(9.637635946273803710937500000000000000000e-1), SC_(9.999999999959163884485100515773231587615e-1), SC_(4.083611551489948422676841238502572235814e-12) }}, 
      {{ SC_(3.808220291137695312500000000000000000000e1), SC_(3.427398300170898437500000000000000000000e1), SC_(3.767639541625976562500000000000000000000e1), SC_(6.233143433928489685058593750000000000000e-2), SC_(2.137454223373882323328771099675373743006e-34), SC_(9.999999999999999999999999999999997862546e-1) }}, 
      {{ SC_(3.808220291137695312500000000000000000000e1), SC_(3.427398300170898437500000000000000000000e1), SC_(1.310955810546875000000000000000000000000e2), SC_(7.506082952022552490234375000000000000000e-2), SC_(5.927886950143367246142859218190237283869e-49), SC_(1.000000000000000000000000000000000000000) }}, 
      {{ SC_(3.808220291137695312500000000000000000000e1), SC_(3.427398300170898437500000000000000000000e1), SC_(1.867986450195312500000000000000000000000e2), SC_(7.925228029489517211914062500000000000000e-2), SC_(2.074279337336462233186302920116736702026e-58), SC_(1.000000000000000000000000000000000000000) }}, 
      {{ SC_(3.808220291137695312500000000000000000000e1), SC_(3.770138168334960937500000000000000000000e1), SC_(4.238486480712890625000000000000000000000e1), SC_(1.525884419679641723632812500000000000000e-1), SC_(1.721366226591562077748128978100880877057e-19), SC_(9.999999999999999998278633773408437922252e-1) }}, 
      {{ SC_(3.808220291137695312500000000000000000000e1), SC_(3.770138168334960937500000000000000000000e1), SC_(1.311481323242187500000000000000000000000e2), SC_(1.831038892269134521484375000000000000000e-1), SC_(8.221520467525445456256150459868950188900e-30), SC_(9.999999999999999999999999999917784795325e-1) }}, 
      {{ SC_(3.808220291137695312500000000000000000000e1), SC_(3.770138168334960937500000000000000000000e1), SC_(1.914333953857421875000000000000000000000e2), SC_(1.948629617691040039062500000000000000000e-1), SC_(1.542794777039853402767996961814617721916e-37), SC_(9.999999999999999999999999999999999998457e-1) }}, 
      {{ SC_(3.808220291137695312500000000000000000000e1), SC_(3.804412078857421875000000000000000000000e1), SC_(4.420680999755859375000000000000000000000e1), SC_(3.059076964855194091796875000000000000000e-1), SC_(1.102551570994872278897210096428393690804e-8), SC_(9.999999889744842900512772110278990357161e-1) }}, 
      {{ SC_(3.808220291137695312500000000000000000000e1), SC_(3.804412078857421875000000000000000000000e1), SC_(1.357470245361328125000000000000000000000e2), SC_(3.674698173999786376953125000000000000000e-1), SC_(1.722896647011938374259852205954135763707e-14), SC_(9.999999999999827710335298806162574014779e-1) }}, 
      {{ SC_(3.808220291137695312500000000000000000000e1), SC_(3.804412078857421875000000000000000000000e1), SC_(1.915013732910156250000000000000000000000e2), SC_(3.889687657356262207031250000000000000000e-1), SC_(1.659246247667165824702471385981245952215e-18), SC_(9.999999999999999983407537523328341752975e-1) }}, 
      {{ SC_(3.808220291137695312500000000000000000000e1), SC_(3.808220291137695312500000000000000000000e1), SC_(5.569964599609375000000000000000000000000e1), SC_(4.746994376182556152343750000000000000000e-1), SC_(1.539163384932173183120787656068618969788e-3), SC_(9.984608366150678268168792123439313810302e-1) }}, 
      {{ SC_(3.808220291137695312500000000000000000000e1), SC_(3.808220291137695312500000000000000000000e1), SC_(1.362719116210937500000000000000000000000e2), SC_(5.514203906059265136718750000000000000000e-1), SC_(2.392504552778900718720882274193369894556e-5), SC_(9.999760749544722109928127911772580663011e-1) }}, 
      {{ SC_(3.808220291137695312500000000000000000000e1), SC_(3.808220291137695312500000000000000000000e1), SC_(1.918984832763671875000000000000000000000e2), SC_(5.835160613059997558593750000000000000000e-1), SC_(8.333401701198688583602488532327847807034e-7), SC_(9.999991666598298801311416397511467672152e-1) }}, 
      {{ SC_(3.808220291137695312500000000000000000000e1), SC_(3.808600997924804687500000000000000000000e1), SC_(5.940588760375976562500000000000000000000e1), SC_(5.753766894340515136718750000000000000000e-1), SC_(1.042217078255863012680223937923653620170e-1), SC_(8.957782921744136987319776062076346379830e-1) }}, 
      {{ SC_(3.808220291137695312500000000000000000000e1), SC_(3.808600997924804687500000000000000000000e1), SC_(1.451677856445312500000000000000000000000e2), SC_(6.688110232353210449218750000000000000000e-1), SC_(3.390550261373350673784302710972646616694e-2), SC_(9.660944973862664932621569728902735338331e-1) }}, 
      {{ SC_(3.808220291137695312500000000000000000000e1), SC_(3.808600997924804687500000000000000000000e1), SC_(1.929777069091796875000000000000000000000e2), SC_(7.008285522460937500000000000000000000000e-1), SC_(1.637967886891116064284045744205009725936e-2), SC_(9.836203211310888393571595425579499027406e-1) }}, 
      {{ SC_(3.808220291137695312500000000000000000000e1), SC_(3.812028503417968750000000000000000000000e1), SC_(6.038262176513671875000000000000000000000e1), SC_(6.343426108360290527343750000000000000000e-1), SC_(4.383294965513927332307482041195137309818e-1), SC_(5.616705034486072667692517958804862690182e-1) }}, 
      {{ SC_(3.808220291137695312500000000000000000000e1), SC_(3.812028503417968750000000000000000000000e1), SC_(1.481294555664062500000000000000000000000e2), SC_(7.380297780036926269531250000000000000000e-1), SC_(4.076046072179173449862355768460705635203e-1), SC_(5.923953927820826550137644231539294364797e-1) }}, 
      {{ SC_(3.808220291137695312500000000000000000000e1), SC_(3.812028503417968750000000000000000000000e1), SC_(1.935389862060546875000000000000000000000e2), SC_(7.711140513420104980468750000000000000000e-1), SC_(3.930977008330805823788334539947229168434e-1), SC_(6.069022991669194176211665460052770831566e-1) }}, 
      {{ SC_(3.808220291137695312500000000000000000000e1), SC_(3.846302413940429687500000000000000000000e1), SC_(6.163340759277343750000000000000000000000e1), SC_(6.401457190513610839843750000000000000000e-1), SC_(4.836716282170760901058525934235312894449e-1), SC_(5.163283717829239098941474065764687105551e-1) }}, 
      {{ SC_(3.808220291137695312500000000000000000000e1), SC_(3.846302413940429687500000000000000000000e1), SC_(1.486264953613281250000000000000000000000e2), SC_(7.434622645378112792968750000000000000000e-1), SC_(4.757548073333334191954528552003651174812e-1), SC_(5.242451926666665808045471447996348825188e-1) }}, 
      {{ SC_(3.808220291137695312500000000000000000000e1), SC_(3.846302413940429687500000000000000000000e1), SC_(1.937735595703125000000000000000000000000e2), SC_(7.767323255538940429687500000000000000000e-1), SC_(4.731221920982746383059738376753476164131e-1), SC_(5.268778079017253616940261623246523835869e-1) }}, 
      {{ SC_(3.808220291137695312500000000000000000000e1), SC_(4.189042282104492187500000000000000000000e1), SC_(7.225879669189453125000000000000000000000e1), SC_(6.382259130477905273437500000000000000000e-1), SC_(4.890118151451701253136749083501689513828e-1), SC_(5.109881848548298746863250916498310486172e-1) }}, 
      {{ SC_(3.808220291137695312500000000000000000000e1), SC_(4.189042282104492187500000000000000000000e1), SC_(1.515480346679687500000000000000000000000e2), SC_(7.301946282386779785156250000000000000000e-1), SC_(4.844936558359576621646388940885141811279e-1), SC_(5.155063441640423378353611059114858188721e-1) }}, 
      {{ SC_(3.808220291137695312500000000000000000000e1), SC_(4.189042282104492187500000000000000000000e1), SC_(1.941185607910156250000000000000000000000e2), SC_(7.626407742500305175781250000000000000000e-1), SC_(4.832872189586293777015283127365472008063e-1), SC_(5.167127810413706222984716872634527991937e-1) }}, 
      {{ SC_(3.808220291137695312500000000000000000000e1), SC_(4.569864654541015625000000000000000000000e1), SC_(9.566968083381652832031250000000000000000e-1), SC_(4.576597511768341064453125000000000000000e-1), SC_(5.027829931355172466769930014983753189484e-1), SC_(4.972170068644827533230069985016246810516e-1) }}, 
      {{ SC_(3.808220291137695312500000000000000000000e1), SC_(4.569864654541015625000000000000000000000e1), SC_(7.844540405273437500000000000000000000000e1), SC_(6.275511384010314941406250000000000000000e-1), SC_(4.900358454907748814140141419509256757565e-1), SC_(5.099641545092251185859858580490743242435e-1) }}, 
      {{ SC_(3.808220291137695312500000000000000000000e1), SC_(4.569864654541015625000000000000000000000e1), SC_(1.584414672851562500000000000000000000000e2), SC_(7.188351154327392578125000000000000000000e-1), SC_(4.856902869514857340689778585727640352748e-1), SC_(5.143097130485142659310221414272359647252e-1) }}, 
      {{ SC_(3.808220291137695312500000000000000000000e1), SC_(4.569864654541015625000000000000000000000e1), SC_(1.962219390869140625000000000000000000000e2), SC_(7.480393648147583007812500000000000000000e-1), SC_(4.846222273155380180316376793332181438926e-1), SC_(5.153777726844619819683623206667818561074e-1) }}, 
      {{ SC_(3.808220291137695312500000000000000000000e1), SC_(4.950686264038085937500000000000000000000e1), SC_(7.142335891723632812500000000000000000000), SC_(4.572342038154602050781250000000000000000e-1), SC_(5.058860232224121876077683036502729008899e-1), SC_(4.941139767775878123922316963497270991101e-1) }}, 
      {{ SC_(3.808220291137695312500000000000000000000e1), SC_(4.950686264038085937500000000000000000000e1), SC_(7.974770355224609375000000000000000000000e1), SC_(6.110336780548095703125000000000000000000e-1), SC_(4.940081768671389097608986129131431805557e-1), SC_(5.059918231328610902391013870868568194443e-1) }}, 
      {{ SC_(3.808220291137695312500000000000000000000e1), SC_(4.950686264038085937500000000000000000000e1), SC_(1.595857238769531250000000000000000000000e2), SC_(7.036821246147155761718750000000000000000e-1), SC_(4.894291978083181796778455200979752544654e-1), SC_(5.105708021916818203221544799020247455346e-1) }}, 
      {{ SC_(3.808220291137695312500000000000000000000e1), SC_(4.950686264038085937500000000000000000000e1), SC_(1.985762634277343750000000000000000000000e2), SC_(7.345957159996032714843750000000000000000e-1), SC_(4.882574175188067906234872748039579768906e-1), SC_(5.117425824811932093765127251960420231094e-1) }}, 
      {{ SC_(3.808220291137695312500000000000000000000e1), SC_(5.712330627441406250000000000000000000000e1), SC_(1.950807952880859375000000000000000000000e1), SC_(4.606702625751495361328125000000000000000e-1), SC_(5.427206056454457613897351481522002800797e-1), SC_(4.572793943545542386102648518477997199203e-1) }}, 
      {{ SC_(3.808220291137695312500000000000000000000e1), SC_(5.712330627441406250000000000000000000000e1), SC_(8.435225677490234375000000000000000000000e1), SC_(5.873966813087463378906250000000000000000e-1), SC_(5.276687004038488307236433379963036193139e-1), SC_(4.723312995961511692763566620036963806861e-1) }}, 
      {{ SC_(3.808220291137695312500000000000000000000e1), SC_(5.712330627441406250000000000000000000000e1), SC_(1.596211700439453125000000000000000000000e2), SC_(6.760006546974182128906250000000000000000e-1), SC_(5.211096279708897199477480091624202643839e-1), SC_(4.788903720291102800522519908375797356161e-1) }}, 
      {{ SC_(3.808220291137695312500000000000000000000e1), SC_(5.712330627441406250000000000000000000000e1), SC_(1.992922668457031250000000000000000000000e2), SC_(7.089776992797851562500000000000000000000e-1), SC_(5.192509560033910285276825474165494230806e-1), SC_(4.807490439966089714723174525834505769194e-1) }}, 
      {{ SC_(3.808220291137695312500000000000000000000e1), SC_(7.616440582275390625000000000000000000000e1), SC_(2.197235107421875000000000000000000000000e1), SC_(4.467194080352783203125000000000000000000e-1), SC_(8.823885134877280951252067355558827013239e-1), SC_(1.176114865122719048747932644441172986761e-1) }}, 
      {{ SC_(3.808220291137695312500000000000000000000e1), SC_(7.616440582275390625000000000000000000000e1), SC_(8.441753387451171875000000000000000000000e1), SC_(5.566802024841308593750000000000000000000e-1), SC_(8.386290669376076388588943172707172946019e-1), SC_(1.613709330623923611411056827292827053981e-1) }}, 
      {{ SC_(3.808220291137695312500000000000000000000e1), SC_(7.616440582275390625000000000000000000000e1), SC_(1.600560913085937500000000000000000000000e2), SC_(6.428397893905639648437500000000000000000e-1), SC_(8.162920695068440835880728484374727295157e-1), SC_(1.837079304931559164119271515625272704843e-1) }}, 
      {{ SC_(3.808220291137695312500000000000000000000e1), SC_(1.142466125488281250000000000000000000000e2), SC_(2.249290275573730468750000000000000000000e1), SC_(4.177266061305999755859375000000000000000e-1), SC_(9.981471531104312635814641370045640905537e-1), SC_(1.852846889568736418535862995435909446346e-3) }}, 
      {{ SC_(3.808220291137695312500000000000000000000e1), SC_(1.142466125488281250000000000000000000000e2), SC_(9.495173645019531250000000000000000000000e1), SC_(5.229404568672180175781250000000000000000e-1), SC_(9.916664726731446020195232067425523548929e-1), SC_(8.333527326855397980476793257447645107066e-3) }}, 
      {{ SC_(3.808220291137695312500000000000000000000e1), SC_(1.142466125488281250000000000000000000000e2), SC_(1.629447326660156250000000000000000000000e2), SC_(5.921859145164489746093750000000000000000e-1), SC_(9.864202606978140294381999492474818851871e-1), SC_(1.357973930218597056180005075251811481286e-2) }}, 
      {{ SC_(3.808220291137695312500000000000000000000e1), SC_(1.523288116455078125000000000000000000000e2), SC_(2.539736366271972656250000000000000000000e1), SC_(4.229124188423156738281250000000000000000e-1), SC_(9.999993079238245605831585566445948507845e-1), SC_(6.920761754394168414433554051492155049116e-7) }}, 
      {{ SC_(3.808220291137695312500000000000000000000e1), SC_(1.523288116455078125000000000000000000000e2), SC_(9.707512664794921875000000000000000000000e1), SC_(5.092014074325561523437500000000000000000e-1), SC_(9.999749050218702591021710768820576457111e-1), SC_(2.509497812974089782892311794235428894733e-5) }}, 
      {{ SC_(3.808220291137695312500000000000000000000e1), SC_(1.523288116455078125000000000000000000000e2), SC_(1.670017089843750000000000000000000000000e2), SC_(5.717366337776184082031250000000000000000e-1), SC_(9.999074544178612317103614653518855049688e-1), SC_(9.254558213876828963853464811449503118539e-5) }}, 
      {{ SC_(3.808220291137695312500000000000000000000e1), SC_(1.904110107421875000000000000000000000000e2), SC_(2.709540176391601562500000000000000000000e1), SC_(4.754191339015960693359375000000000000000e-1), SC_(9.999999999999990170607719302877647880871e-1), SC_(9.829392280697122352119129324805984922350e-16) }}, 
      {{ SC_(3.808220291137695312500000000000000000000e1), SC_(1.904110107421875000000000000000000000000e2), SC_(1.007325439453125000000000000000000000000e2), SC_(5.444914102554321289062500000000000000000e-1), SC_(9.999999999959653457731156896541644113603e-1), SC_(4.034654226884310345835588639725867636551e-12) }}, 
      {{ SC_(3.808220291137695312500000000000000000000e1), SC_(1.904110107421875000000000000000000000000e2), SC_(1.698258666992187500000000000000000000000e2), SC_(5.946141481399536132812500000000000000000e-1), SC_(9.999999999046058085999760598343831530485e-1), SC_(9.539419140002394016561684695154422454419e-11) }}, 
      {{ SC_(4.277890396118164062500000000000000000000e1), SC_(4.277890682220458984375000000000000000000), SC_(2.249290275573730468750000000000000000000e1), SC_(9.631921052932739257812500000000000000000e-1), SC_(8.755228232122582083692507775678078383317e-1), SC_(1.244771767877417916307492224321921616683e-1) }}, 
      {{ SC_(4.277890396118164062500000000000000000000e1), SC_(4.277890682220458984375000000000000000000), SC_(9.495173645019531250000000000000000000000e1), SC_(9.772532582283020019531250000000000000000e-1), SC_(8.706942035487680586554859614828063377837e-1), SC_(1.293057964512319413445140385171936622163e-1) }}, 
      {{ SC_(4.277890396118164062500000000000000000000e1), SC_(4.277890682220458984375000000000000000000), SC_(1.629447326660156250000000000000000000000e2), SC_(9.832762479782104492187500000000000000000e-1), SC_(8.693365498969344826655352638011747409032e-1), SC_(1.306634501030655173344647361988252590968e-1) }}, 
      {{ SC_(4.277890396118164062500000000000000000000e1), SC_(1.069472599029541015625000000000000000000e1), SC_(2.539736366271972656250000000000000000000e1), SC_(9.459706544876098632812500000000000000000e-1), SC_(9.988644277294003786851298439508384633729e-1), SC_(1.135572270599621314870156049161536627075e-3) }}, 
      {{ SC_(4.277890396118164062500000000000000000000e1), SC_(1.069472599029541015625000000000000000000e1), SC_(9.707512664794921875000000000000000000000e1), SC_(9.648907780647277832031250000000000000000e-1), SC_(9.985568119043668362635912894865235559313e-1), SC_(1.443188095633163736408710513476444068718e-3) }}, 
      {{ SC_(4.277890396118164062500000000000000000000e1), SC_(1.069472599029541015625000000000000000000e1), SC_(1.670017089843750000000000000000000000000e2), SC_(9.738581180572509765625000000000000000000e-1), SC_(9.984481516512716010588703449457811176525e-1), SC_(1.551848348728398941129655054218882347487e-3) }}, 
      {{ SC_(4.277890396118164062500000000000000000000e1), SC_(2.138945198059082031250000000000000000000e1), SC_(2.709540176391601562500000000000000000000e1), SC_(9.310392141342163085937500000000000000000e-1), SC_(9.999999729652382905216296026202094454167e-1), SC_(2.703476170947837039737979055458331627989e-8) }}, 
      {{ SC_(4.277890396118164062500000000000000000000e1), SC_(2.138945198059082031250000000000000000000e1), SC_(1.007325439453125000000000000000000000000e2), SC_(9.531329870223999023437500000000000000000e-1), SC_(9.999999309183766474150261025609044179979e-1), SC_(6.908162335258497389743909558200213340081e-8) }}, 
      {{ SC_(4.277890396118164062500000000000000000000e1), SC_(2.138945198059082031250000000000000000000e1), SC_(1.698258666992187500000000000000000000000e2), SC_(9.639942049980163574218750000000000000000e-1), SC_(9.999999074343808927746813264256432983271e-1), SC_(9.256561910722531867357435670167290374672e-8) }}, 
      {{ SC_(4.277890396118164062500000000000000000000e1), SC_(3.208417892456054687500000000000000000000e1), SC_(2.837726783752441406250000000000000000000e1), SC_(9.278136491775512695312500000000000000000e-1), SC_(9.999999999999882793280698747740484151592e-1), SC_(1.172067193012522595158484077108312837315e-14) }}, 
      {{ SC_(4.277890396118164062500000000000000000000e1), SC_(3.208417892456054687500000000000000000000e1), SC_(1.093762969970703125000000000000000000000e2), SC_(9.503073692321777343750000000000000000000e-1), SC_(9.999999999999037321155413017632757068195e-1), SC_(9.626788445869823672429318054630983168777e-14) }}, 
      {{ SC_(4.277890396118164062500000000000000000000e1), SC_(3.208417892456054687500000000000000000000e1), SC_(1.756861267089843750000000000000000000000e2), SC_(9.604309201240539550781250000000000000000e-1), SC_(9.999999999998254602568615033563815623017e-1), SC_(1.745397431384966436184376983271963095190e-13) }}, 
      {{ SC_(4.277890396118164062500000000000000000000e1), SC_(3.850101089477539062500000000000000000000e1), SC_(3.152261734008789062500000000000000000000e1), SC_(6.025869399309158325195312500000000000000e-2), SC_(5.976066231037161176914897394360693494706e-37), SC_(9.999999999999999999999999999999999994024e-1) }}, 
      {{ SC_(4.277890396118164062500000000000000000000e1), SC_(3.850101089477539062500000000000000000000e1), SC_(1.094441146850585937500000000000000000000e2), SC_(7.160709053277969360351562500000000000000e-2), SC_(1.455752923331606955481866339267660737835e-48), SC_(1.000000000000000000000000000000000000000) }}, 
      {{ SC_(4.277890396118164062500000000000000000000e1), SC_(3.850101089477539062500000000000000000000e1), SC_(1.811583862304687500000000000000000000000e2), SC_(7.752864062786102294921875000000000000000e-2), SC_(1.844078791871799867678473501614547913514e-60), SC_(1.000000000000000000000000000000000000000) }}, 
      {{ SC_(4.277890396118164062500000000000000000000e1), SC_(4.235111618041992187500000000000000000000e1), SC_(3.423733520507812500000000000000000000000e1), SC_(1.462811529636383056640625000000000000000e-1), SC_(2.534786093906178114037641080877310874635e-20), SC_(9.999999999999999999746521390609382188596e-1) }}, 
      {{ SC_(4.277890396118164062500000000000000000000e1), SC_(4.235111618041992187500000000000000000000e1), SC_(1.264718551635742187500000000000000000000e2), SC_(1.784324049949645996093750000000000000000e-1), SC_(1.107626309040836528856946963942224091151e-30), SC_(9.999999999999999999999999999988923736910e-1) }}, 
      {{ SC_(4.277890396118164062500000000000000000000e1), SC_(4.235111618041992187500000000000000000000e1), SC_(1.826751708984375000000000000000000000000e2), SC_(1.898255944252014160156250000000000000000e-1), SC_(9.978233578318973500983750214065458604070e-38), SC_(9.999999999999999999999999999999999999002e-1) }}, 
      {{ SC_(4.277890396118164062500000000000000000000e1), SC_(4.273612594604492187500000000000000000000e1), SC_(3.477303314208984375000000000000000000000e1), SC_(2.920036315917968750000000000000000000000e-1), SC_(9.485511216160963805023008779374115767962e-9), SC_(9.999999905144887838390361949769912206259e-1) }}, 
      {{ SC_(4.277890396118164062500000000000000000000e1), SC_(4.273612594604492187500000000000000000000e1), SC_(1.279526672363281250000000000000000000000e2), SC_(3.566523492336273193359375000000000000000e-1), SC_(2.211918807205680740630150100396488756860e-14), SC_(9.999999999999778808119279431925936984990e-1) }}, 
      {{ SC_(4.277890396118164062500000000000000000000e1), SC_(4.273612594604492187500000000000000000000e1), SC_(1.831471099853515625000000000000000000000e2), SC_(3.789845407009124755859375000000000000000e-1), SC_(3.222826472865468746590014635718158255233e-18), SC_(9.999999999999999967771735271345312534100e-1) }}, 
      {{ SC_(4.277890396118164062500000000000000000000e1), SC_(4.277890396118164062500000000000000000000e1), SC_(3.767639541625976562500000000000000000000e1), SC_(4.421373009681701660156250000000000000000e-1), SC_(2.485335075678997093720078939437237508291e-3), SC_(9.975146649243210029062799210605627624917e-1) }}, 
      {{ SC_(4.277890396118164062500000000000000000000e1), SC_(4.277890396118164062500000000000000000000e1), SC_(1.310955810546875000000000000000000000000e2), SC_(5.370609760284423828125000000000000000000e-1), SC_(2.807699163324021877271278682197828941138e-5), SC_(9.999719230083667597812272872131780217106e-1) }}, 
      {{ SC_(4.277890396118164062500000000000000000000e1), SC_(4.277890396118164062500000000000000000000e1), SC_(1.867986450195312500000000000000000000000e2), SC_(5.701929926872253417968750000000000000000e-1), SC_(1.146403033260757869836164104677065497048e-6), SC_(9.999988535969667392421301638358953229345e-1) }}, 
      {{ SC_(4.277890396118164062500000000000000000000e1), SC_(4.278318405151367187500000000000000000000e1), SC_(4.238486480712890625000000000000000000000e1), SC_(5.386432409286499023437500000000000000000e-1), SC_(1.193614700026502095824479036999683740469e-1), SC_(8.806385299973497904175520963000316259531e-1) }}, 
      {{ SC_(4.277890396118164062500000000000000000000e1), SC_(4.278318405151367187500000000000000000000e1), SC_(1.311481323242187500000000000000000000000e2), SC_(6.444991827011108398437500000000000000000e-1), SC_(4.142210993185109405256507984471621223199e-2), SC_(9.585778900681489059474349201552837877680e-1) }}, 
      {{ SC_(4.277890396118164062500000000000000000000e1), SC_(4.278318405151367187500000000000000000000e1), SC_(1.914333953857421875000000000000000000000e2), SC_(6.869744062423706054687500000000000000000e-1), SC_(1.762608820526848119502087842017528212082e-2), SC_(9.823739117947315188049791215798247178792e-1) }}, 
      {{ SC_(4.277890396118164062500000000000000000000e1), SC_(4.282168579101562500000000000000000000000e1), SC_(4.420680999755859375000000000000000000000e1), SC_(5.956390500068664550781250000000000000000e-1), SC_(4.446185270697781422792201035473413587209e-1), SC_(5.553814729302218577207798964526586412791e-1) }}, 
      {{ SC_(4.277890396118164062500000000000000000000e1), SC_(4.282168579101562500000000000000000000000e1), SC_(1.357470245361328125000000000000000000000e2), SC_(7.129784822463989257812500000000000000000e-1), SC_(4.134592522858411598248267351747830653393e-1), SC_(5.865407477141588401751732648252169346607e-1) }}, 
      {{ SC_(4.277890396118164062500000000000000000000e1), SC_(4.282168579101562500000000000000000000000e1), SC_(1.915013732910156250000000000000000000000e2), SC_(7.555550932884216308593750000000000000000e-1), SC_(3.964615821481212842229836258658812485856e-1), SC_(6.035384178518787157770163741341187514144e-1) }}, 
      {{ SC_(4.277890396118164062500000000000000000000e1), SC_(4.320669174194335937500000000000000000000e1), SC_(5.569964599609375000000000000000000000000e1), SC_(6.190106272697448730468750000000000000000e-1), SC_(4.856694263298091012155271808581021019562e-1), SC_(5.143305736701908987844728191418978980438e-1) }}, 
      {{ SC_(4.277890396118164062500000000000000000000e1), SC_(4.320669174194335937500000000000000000000e1), SC_(1.362719116210937500000000000000000000000e2), SC_(7.181353569030761718750000000000000000000e-1), SC_(4.781348276296898281366678807701173409752e-1), SC_(5.218651723703101718633321192298826590248e-1) }}, 
      {{ SC_(4.277890396118164062500000000000000000000e1), SC_(4.320669174194335937500000000000000000000e1), SC_(1.918984832763671875000000000000000000000e2), SC_(7.610653638839721679687500000000000000000e-1), SC_(4.748551067773526518759983552624060380065e-1), SC_(5.251448932226473481240016447375939619935e-1) }}, 
      {{ SC_(4.277890396118164062500000000000000000000e1), SC_(4.705679702758789062500000000000000000000e1), SC_(5.940588760375976562500000000000000000000e1), SC_(6.055282950401306152343750000000000000000e-1), SC_(4.915576130632339911057119984010503731302e-1), SC_(5.084423869367660088942880015989496268698e-1) }}, 
      {{ SC_(4.277890396118164062500000000000000000000e1), SC_(4.705679702758789062500000000000000000000e1), SC_(1.451677856445312500000000000000000000000e2), SC_(7.094792127609252929687500000000000000000e-1), SC_(4.861906336367432924171014368088716013613e-1), SC_(5.138093663632567075828985631911283986387e-1) }}, 
      {{ SC_(4.277890396118164062500000000000000000000e1), SC_(4.705679702758789062500000000000000000000e1), SC_(1.929777069091796875000000000000000000000e2), SC_(7.467452287673950195312500000000000000000e-1), SC_(4.847651604331846315383459692002043188080e-1), SC_(5.152348395668153684616540307997956811920e-1) }}, 
      {{ SC_(4.277890396118164062500000000000000000000e1), SC_(5.133468627929687500000000000000000000000e1), SC_(6.038262176513671875000000000000000000000e1), SC_(5.862604975700378417968750000000000000000e-1), SC_(4.930193301203185630665461317982889532696e-1), SC_(5.069806698796814369334538682017110467304e-1) }}, 
      {{ SC_(4.277890396118164062500000000000000000000e1), SC_(5.133468627929687500000000000000000000000e1), SC_(1.481294555664062500000000000000000000000e2), SC_(6.939916610717773437500000000000000000000e-1), SC_(4.874999731341537383407311625196717391253e-1), SC_(5.125000268658462616592688374803282608747e-1) }}, 
      {{ SC_(4.277890396118164062500000000000000000000e1), SC_(5.133468627929687500000000000000000000000e1), SC_(1.935389862060546875000000000000000000000e2), SC_(7.303800582885742187500000000000000000000e-1), SC_(4.861154252979878563981531036755458404546e-1), SC_(5.138845747020121436018468963244541595454e-1) }}, 
      {{ SC_(4.277890396118164062500000000000000000000e1), SC_(5.561257171630859375000000000000000000000e1), SC_(6.163340759277343750000000000000000000000e1), SC_(5.692257285118103027343750000000000000000e-1), SC_(4.972581914108318848512610067350353335012e-1), SC_(5.027418085891681151487389932649646664988e-1) }}, 
      {{ SC_(4.277890396118164062500000000000000000000e1), SC_(5.561257171630859375000000000000000000000e1), SC_(1.486264953613281250000000000000000000000e2), SC_(6.775106787681579589843750000000000000000e-1), SC_(4.914474336995175408335968795002564671233e-1), SC_(5.085525663004824591664031204997435328767e-1) }}, 
      {{ SC_(4.277890396118164062500000000000000000000e1), SC_(5.561257171630859375000000000000000000000e1), SC_(1.937735595703125000000000000000000000000e2), SC_(7.147753238677978515625000000000000000000e-1), SC_(4.899623473905917657784641322621247425187e-1), SC_(5.100376526094082342215358677378752574813e-1) }}, 
      {{ SC_(4.277890396118164062500000000000000000000e1), SC_(6.416835784912109375000000000000000000000e1), SC_(7.225879669189453125000000000000000000000e1), SC_(5.551673769950866699218750000000000000000e-1), SC_(5.332683348205125151620517437653134081769e-1), SC_(4.667316651794874848379482562346865918231e-1) }}, 
      {{ SC_(4.277890396118164062500000000000000000000e1), SC_(6.416835784912109375000000000000000000000e1), SC_(1.515480346679687500000000000000000000000e2), SC_(6.515062451362609863281250000000000000000e-1), SC_(5.253002946061257595538435934000296937927e-1), SC_(4.746997053938742404461564065999703062073e-1) }}, 
      {{ SC_(4.277890396118164062500000000000000000000e1), SC_(6.416835784912109375000000000000000000000e1), SC_(1.941185607910156250000000000000000000000e2), SC_(6.878472566604614257812500000000000000000e-1), SC_(5.230637885772765121499941132428672311533e-1), SC_(4.769362114227234878500058867571327688467e-1) }}, 
      {{ SC_(4.277890396118164062500000000000000000000e1), SC_(8.555780792236328125000000000000000000000e1), SC_(9.566968083381652832031250000000000000000e-1), SC_(3.961725831031799316406250000000000000000e-1), SC_(9.233839962708603776048745997958273276214e-1), SC_(7.661600372913962239512540020417267237858e-2) }}, 
      {{ SC_(4.277890396118164062500000000000000000000e1), SC_(8.555780792236328125000000000000000000000e1), SC_(7.844540405273437500000000000000000000000e1), SC_(5.351589918136596679687500000000000000000e-1), SC_(8.598743082038405088804578796104832262222e-1), SC_(1.401256917961594911195421203895167737778e-1) }}, 
      {{ SC_(4.277890396118164062500000000000000000000e1), SC_(8.555780792236328125000000000000000000000e1), SC_(1.584414672851562500000000000000000000000e2), SC_(6.245721578598022460937500000000000000000e-1), SC_(8.349929113214196137004104833757599423059e-1), SC_(1.650070886785803862995895166242400576941e-1) }}, 
      {{ SC_(4.277890396118164062500000000000000000000e1), SC_(8.555780792236328125000000000000000000000e1), SC_(1.962219390869140625000000000000000000000e2), SC_(6.558646559715270996093750000000000000000e-1), SC_(8.282490189696207377183639481911589841260e-1), SC_(1.717509810303792622816360518088410158740e-1) }}, 
      {{ SC_(4.277890396118164062500000000000000000000e1), SC_(1.283367156982421875000000000000000000000e2), SC_(7.142335891723632812500000000000000000000), SC_(3.877053856849670410156250000000000000000e-1), SC_(9.995951751273492290640834508493467416154e-1), SC_(4.048248726507709359165491506532583845706e-4) }}, 
      {{ SC_(4.277890396118164062500000000000000000000e1), SC_(1.283367156982421875000000000000000000000e2), SC_(7.974770355224609375000000000000000000000e1), SC_(4.926616549491882324218750000000000000000e-1), SC_(9.960006834158818761058179176144675242067e-1), SC_(3.999316584118123894182082385532475793269e-3) }}, 
      {{ SC_(4.277890396118164062500000000000000000000e1), SC_(1.283367156982421875000000000000000000000e2), SC_(1.595857238769531250000000000000000000000e2), SC_(5.732196569442749023437500000000000000000e-1), SC_(9.915559916754428338942706817589548460482e-1), SC_(8.444008324557166105729318241045153951763e-3) }}, 
      {{ SC_(4.277890396118164062500000000000000000000e1), SC_(1.283367156982421875000000000000000000000e2), SC_(1.985762634277343750000000000000000000000e2), SC_(6.039534211158752441406250000000000000000e-1), SC_(9.897417075175684149283307734073673632108e-1), SC_(1.025829248243158507166922659263263678923e-2) }}, 
      {{ SC_(4.277890396118164062500000000000000000000e1), SC_(1.711156158447265625000000000000000000000e2), SC_(1.950807952880859375000000000000000000000e1), SC_(4.113395214080810546875000000000000000000e-1), SC_(9.999999389170526848160036466719439327451e-1), SC_(6.108294731518399635332805606725487612105e-8) }}, 
      {{ SC_(4.277890396118164062500000000000000000000e1), SC_(1.711156158447265625000000000000000000000e2), SC_(8.435225677490234375000000000000000000000e1), SC_(4.856416881084442138671875000000000000000e-1), SC_(9.999959902618402626190955600061985255129e-1), SC_(4.009738159737380904439993801474487140233e-6) }}, 
      {{ SC_(4.277890396118164062500000000000000000000e1), SC_(1.711156158447265625000000000000000000000e2), SC_(1.596211700439453125000000000000000000000e2), SC_(5.514236092567443847656250000000000000000e-1), SC_(9.999752570425554718147084447444866798098e-1), SC_(2.474295744452818529155525551332019023550e-5) }}, 
      {{ SC_(4.277890396118164062500000000000000000000e1), SC_(1.711156158447265625000000000000000000000e2), SC_(1.992922668457031250000000000000000000000e2), SC_(5.797647833824157714843750000000000000000e-1), SC_(9.999573446521787236351364970574593878921e-1), SC_(4.265534782127636486350294254061210787196e-5) }}, 
      {{ SC_(4.277890396118164062500000000000000000000e1), SC_(2.138945159912109375000000000000000000000e2), SC_(2.197235107421875000000000000000000000000e1), SC_(4.671657085418701171875000000000000000000e-1), SC_(9.999999999999999971365599508369023970341e-1), SC_(2.863440049163097602965852041098636576970e-18) }}, 
      {{ SC_(4.277890396118164062500000000000000000000e1), SC_(2.138945159912109375000000000000000000000e2), SC_(8.441753387451171875000000000000000000000e1), SC_(5.226757526397705078125000000000000000000e-1), SC_(9.999999999999749028364463105375051048952e-1), SC_(2.509716355368946249489510482127206626331e-14) }}, 
      {{ SC_(4.277890396118164062500000000000000000000e1), SC_(2.138945159912109375000000000000000000000e2), SC_(1.600560913085937500000000000000000000000e2), SC_(5.761913061141967773437500000000000000000e-1), SC_(9.999999999976199464252602037091843511194e-1), SC_(2.380053574739796290815648880607831149707e-12) }}, 
      {{ SC_(4.459629440307617187500000000000000000000e1), SC_(4.459629535675048828125000000000000000000), SC_(7.142335891723632812500000000000000000000), SC_(9.575752615928649902343750000000000000000e-1), SC_(8.842672447293480579510320920669672154552e-1), SC_(1.157327552706519420489679079330327845448e-1) }}, 
      {{ SC_(4.459629440307617187500000000000000000000e1), SC_(4.459629535675048828125000000000000000000), SC_(7.974770355224609375000000000000000000000e1), SC_(9.747996926307678222656250000000000000000e-1), SC_(8.776963957637832869687431821423175041237e-1), SC_(1.223036042362167130312568178576824958763e-1) }}, 
      {{ SC_(4.459629440307617187500000000000000000000e1), SC_(4.459629535675048828125000000000000000000), SC_(1.595857238769531250000000000000000000000e2), SC_(9.826111793518066406250000000000000000000e-1), SC_(8.758449461546161148506278741048631110221e-1), SC_(1.241550538453838851493721258951368889779e-1) }}, 
      {{ SC_(4.459629440307617187500000000000000000000e1), SC_(4.459629535675048828125000000000000000000), SC_(1.985762634277343750000000000000000000000e2), SC_(9.849008321762084960937500000000000000000e-1), SC_(8.754316685051775712637969207848173711511e-1), SC_(1.245683314948224287362030792151826288489e-1) }}, 
      {{ SC_(4.459629440307617187500000000000000000000e1), SC_(1.114907360076904296875000000000000000000e1), SC_(1.950807952880859375000000000000000000000e1), SC_(9.431322216987609863281250000000000000000e-1), SC_(9.991407265906897514932415585942831285547e-1), SC_(8.592734093102485067584414057168714453172e-4) }}, 
      {{ SC_(4.459629440307617187500000000000000000000e1), SC_(1.114907360076904296875000000000000000000e1), SC_(8.435225677490234375000000000000000000000e1), SC_(9.618806242942810058593750000000000000000e-1), SC_(9.988776454938044895350181624277958228841e-1), SC_(1.122354506195510464981837572204177115946e-3) }}, 
      {{ SC_(4.459629440307617187500000000000000000000e1), SC_(1.114907360076904296875000000000000000000e1), SC_(1.596211700439453125000000000000000000000e2), SC_(9.724652767181396484375000000000000000000e-1), SC_(9.987646663387754799880911295097068237116e-1), SC_(1.235333661224520011908870490293176288417e-3) }}, 
      {{ SC_(4.459629440307617187500000000000000000000e1), SC_(1.114907360076904296875000000000000000000e1), SC_(1.992922668457031250000000000000000000000e2), SC_(9.759852290153503417968750000000000000000e-1), SC_(9.987341185127259802161380398650030321082e-1), SC_(1.265881487274019783861960134996967891814e-3) }}, 
      {{ SC_(4.459629440307617187500000000000000000000e1), SC_(2.229814720153808593750000000000000000000e1), SC_(2.197235107421875000000000000000000000000e1), SC_(9.282923936843872070312500000000000000000e-1), SC_(9.999999881844361297850312149778552561262e-1), SC_(1.181556387021496878502214474387378005789e-8) }}, 
      {{ SC_(4.459629440307617187500000000000000000000e1), SC_(2.229814720153808593750000000000000000000e1), SC_(8.441753387451171875000000000000000000000e1), SC_(9.487246274948120117187500000000000000000e-1), SC_(9.999999682565840505235587097507615752941e-1), SC_(3.174341594947644129024923842470593214560e-8) }}, 
      {{ SC_(4.459629440307617187500000000000000000000e1), SC_(2.229814720153808593750000000000000000000e1), SC_(1.600560913085937500000000000000000000000e2), SC_(9.619172811508178710937500000000000000000e-1), SC_(9.999999523828653676091327304719149904893e-1), SC_(4.761713463239086726952808500951071632771e-8) }}, 
      {{ SC_(4.459629440307617187500000000000000000000e1), SC_(3.344721984863281250000000000000000000000e1), SC_(2.249290275573730468750000000000000000000e1), SC_(9.249761104583740234375000000000000000000e-1), SC_(9.999999999999977796385983804980505031757e-1), SC_(2.220361401619501949496824295933869006624e-15) }}, 
      {{ SC_(4.459629440307617187500000000000000000000e1), SC_(3.344721984863281250000000000000000000000e1), SC_(9.495173645019531250000000000000000000000e1), SC_(9.465453028678894042968750000000000000000e-1), SC_(9.999999999999777616068306182067550383126e-1), SC_(2.223839316938179324496168739124243207845e-14) }}, 
      {{ SC_(4.459629440307617187500000000000000000000e1), SC_(3.344721984863281250000000000000000000000e1), SC_(1.629447326660156250000000000000000000000e2), SC_(9.579297900199890136718750000000000000000e-1), SC_(9.999999999999524025828783811771341268706e-1), SC_(4.759741712161882286587312937464002753937e-14) }}, 
      {{ SC_(4.459629440307617187500000000000000000000e1), SC_(4.013666534423828125000000000000000000000e1), SC_(2.539736366271972656250000000000000000000e1), SC_(5.875020101666450500488281250000000000000e-2), SC_(1.771890439732220702757105744182829143770e-37), SC_(9.999999999999999999999999999999999998228e-1) }}, 
      {{ SC_(4.459629440307617187500000000000000000000e1), SC_(4.013666534423828125000000000000000000000e1), SC_(9.707512664794921875000000000000000000000e1), SC_(6.980101019144058227539062500000000000000e-2), SC_(7.652856578479348945074462500389925227054e-48), SC_(1.000000000000000000000000000000000000000) }}, 
      {{ SC_(4.459629440307617187500000000000000000000e1), SC_(4.013666534423828125000000000000000000000e1), SC_(1.670017089843750000000000000000000000000e2), SC_(7.607194036245346069335937500000000000000e-2), SC_(2.980896225925974697972841549244580035071e-59), SC_(1.000000000000000000000000000000000000000) }}, 
      {{ SC_(4.459629440307617187500000000000000000000e1), SC_(4.415033340454101562500000000000000000000e1), SC_(2.709540176391601562500000000000000000000e1), SC_(1.419600546360015869140625000000000000000e-1), SC_(2.748410704213459369088643770286696785853e-20), SC_(9.999999999999999999725158929578654063091e-1) }}, 
      {{ SC_(4.459629440307617187500000000000000000000e1), SC_(4.415033340454101562500000000000000000000e1), SC_(1.007325439453125000000000000000000000000e2), SC_(1.704508811235427856445312500000000000000e-1), SC_(3.469416940965144713313375928150207765204e-28), SC_(9.999999999999999999999999996530583059035e-1) }}, 
      {{ SC_(4.459629440307617187500000000000000000000e1), SC_(4.415033340454101562500000000000000000000e1), SC_(1.698258666992187500000000000000000000000e2), SC_(1.862622946500778198242187500000000000000e-1), SC_(1.269943893523674585515720040164048657885e-36), SC_(9.999999999999999999999999999999999987301e-1) }}, 
      {{ SC_(4.459629440307617187500000000000000000000e1), SC_(4.455169677734375000000000000000000000000e1), SC_(2.837726783752441406250000000000000000000e1), SC_(2.841477096080780029296875000000000000000e-1), SC_(1.189737680319739634700945199697390203492e-8), SC_(9.999999881026231968026036529905480030261e-1) }}, 
      {{ SC_(4.459629440307617187500000000000000000000e1), SC_(4.455169677734375000000000000000000000000e1), SC_(1.093762969970703125000000000000000000000e2), SC_(3.447209894657135009765625000000000000000e-1), SC_(2.418167849094555058570115170623935401533e-13), SC_(9.999999999997581832150905444941429884829e-1) }}, 
      {{ SC_(4.459629440307617187500000000000000000000e1), SC_(4.455169677734375000000000000000000000000e1), SC_(1.756861267089843750000000000000000000000e2), SC_(3.737884461879730224609375000000000000000e-1), SC_(7.947382396911129270732956571197267132486e-18), SC_(9.999999999999999920526176030888707292670e-1) }}, 
      {{ SC_(4.459629440307617187500000000000000000000e1), SC_(4.459629440307617187500000000000000000000e1), SC_(3.152261734008789062500000000000000000000e1), SC_(4.308590888977050781250000000000000000000e-1), SC_(2.807654945481784699200954534182252911873e-3), SC_(9.971923450545182153007990454658177470881e-1) }}, 
      {{ SC_(4.459629440307617187500000000000000000000e1), SC_(4.459629440307617187500000000000000000000e1), SC_(1.094441146850585937500000000000000000000e2), SC_(5.169758200645446777343750000000000000000e-1), SC_(8.198358478191484019117275911964618299338e-5), SC_(9.999180164152180851598088272408803538170e-1) }}, 
      {{ SC_(4.459629440307617187500000000000000000000e1), SC_(4.459629440307617187500000000000000000000e1), SC_(1.811583862304687500000000000000000000000e2), SC_(5.634247064590454101562500000000000000000e-1), SC_(1.577230336397072624077806210748638507793e-6), SC_(9.999984227696636029273759221937892513615e-1) }}, 
      {{ SC_(4.459629440307617187500000000000000000000e1), SC_(4.460075378417968750000000000000000000000e1), SC_(3.423733520507812500000000000000000000000e1), SC_(5.218670368194580078125000000000000000000e-1), SC_(1.267187924983776416839190967481102479210e-1), SC_(8.732812075016223583160809032518897520790e-1) }}, 
      {{ SC_(4.459629440307617187500000000000000000000e1), SC_(4.460075378417968750000000000000000000000e1), SC_(1.264718551635742187500000000000000000000e2), SC_(6.359500288963317871093750000000000000000e-1), SC_(4.388948315228592068392519754498901186489e-2), SC_(9.561105168477140793160748024550109881351e-1) }}, 
      {{ SC_(4.459629440307617187500000000000000000000e1), SC_(4.460075378417968750000000000000000000000e1), SC_(1.826751708984375000000000000000000000000e2), SC_(6.770335435867309570312500000000000000000e-1), SC_(2.030666447672919859151466262771453720087e-2), SC_(9.796933355232708014084853373722854627991e-1) }}, 
      {{ SC_(4.459629440307617187500000000000000000000e1), SC_(4.464089202880859375000000000000000000000e1), SC_(3.477303314208984375000000000000000000000e1), SC_(5.748758912086486816406250000000000000000e-1), SC_(4.480645889950505694138923829445312356190e-1), SC_(5.519354110049494305861076170554687643810e-1) }}, 
      {{ SC_(4.459629440307617187500000000000000000000e1), SC_(4.464089202880859375000000000000000000000e1), SC_(1.279526672363281250000000000000000000000e2), SC_(7.007635831832885742187500000000000000000e-1), SC_(4.164199267508211592503808597431176321923e-1), SC_(5.835800732491788407496191402568823678077e-1) }}, 
      {{ SC_(4.459629440307617187500000000000000000000e1), SC_(4.464089202880859375000000000000000000000e1), SC_(1.831471099853515625000000000000000000000e2), SC_(7.448914051055908203125000000000000000000e-1), SC_(3.997936025911681349717477426162319925536e-1), SC_(6.002063974088318650282522573837680074464e-1) }}, 
      {{ SC_(4.459629440307617187500000000000000000000e1), SC_(4.504225540161132812500000000000000000000e1), SC_(3.767639541625976562500000000000000000000e1), SC_(5.835261344909667968750000000000000000000e-1), SC_(4.886508930257011992664003286498472758308e-1), SC_(5.113491069742988007335996713501527241692e-1) }}, 
      {{ SC_(4.459629440307617187500000000000000000000e1), SC_(4.504225540161132812500000000000000000000e1), SC_(1.310955810546875000000000000000000000000e2), SC_(7.082548141479492187500000000000000000000e-1), SC_(4.790128509886726416428271178822740071671e-1), SC_(5.209871490113273583571728821177259928329e-1) }}, 
      {{ SC_(4.459629440307617187500000000000000000000e1), SC_(4.504225540161132812500000000000000000000e1), SC_(1.867986450195312500000000000000000000000e2), SC_(7.524791359901428222656250000000000000000e-1), SC_(4.756786872350586487601884331385182535913e-1), SC_(5.243213127649413512398115668614817464087e-1) }}, 
      {{ SC_(4.459629440307617187500000000000000000000e1), SC_(4.905592346191406250000000000000000000000e1), SC_(4.238486480712890625000000000000000000000e1), SC_(5.721634030342102050781250000000000000000e-1), SC_(4.938897919990399072595888508822680948521e-1), SC_(5.061102080009600927404111491177319051479e-1) }}, 
      {{ SC_(4.459629440307617187500000000000000000000e1), SC_(4.905592346191406250000000000000000000000e1), SC_(1.311481323242187500000000000000000000000e2), SC_(6.911137700080871582031250000000000000000e-1), SC_(4.872518685504714592462570047942558765720e-1), SC_(5.127481314495285407537429952057441234280e-1) }}, 
      {{ SC_(4.459629440307617187500000000000000000000e1), SC_(4.905592346191406250000000000000000000000e1), SC_(1.914333953857421875000000000000000000000e2), SC_(7.402590513229370117187500000000000000000e-1), SC_(4.853041834144153542384593144693712928650e-1), SC_(5.146958165855846457615406855306287071350e-1) }}, 
      {{ SC_(4.459629440307617187500000000000000000000e1), SC_(5.351555633544921875000000000000000000000e1), SC_(4.420680999755859375000000000000000000000e1), SC_(5.541992783546447753906250000000000000000e-1), SC_(4.952355036306895428906486983237108895923e-1), SC_(5.047644963693104571093513016762891104077e-1) }}, 
      {{ SC_(4.459629440307617187500000000000000000000e1), SC_(5.351555633544921875000000000000000000000e1), SC_(1.357470245361328125000000000000000000000e2), SC_(6.768267154693603515625000000000000000000e-1), SC_(4.884869702623582269688494493808233989103e-1), SC_(5.115130297376417730311505506191766010897e-1) }}, 
      {{ SC_(4.459629440307617187500000000000000000000e1), SC_(5.351555633544921875000000000000000000000e1), SC_(1.915013732910156250000000000000000000000e2), SC_(7.232753634452819824218750000000000000000e-1), SC_(4.866615552577055696794535562560358965627e-1), SC_(5.133384447422944303205464437439641034373e-1) }}, 
      {{ SC_(4.459629440307617187500000000000000000000e1), SC_(5.797518157958984375000000000000000000000e1), SC_(5.569964599609375000000000000000000000000e1), SC_(5.551946759223937988281250000000000000000e-1), SC_(4.983862282066407252383712302597525364658e-1), SC_(5.016137717933592747616287697402474635342e-1) }}, 
      {{ SC_(4.459629440307617187500000000000000000000e1), SC_(5.797518157958984375000000000000000000000e1), SC_(1.362719116210937500000000000000000000000e2), SC_(6.599287986755371093750000000000000000000e-1), SC_(4.925310755965802354718051424128850116155e-1), SC_(5.074689244034197645281948575871149883845e-1) }}, 
      {{ SC_(4.459629440307617187500000000000000000000e1), SC_(5.797518157958984375000000000000000000000e1), SC_(1.918984832763671875000000000000000000000e2), SC_(7.075455784797668457031250000000000000000e-1), SC_(4.905677403080998868787143598131704561794e-1), SC_(5.094322596919001131212856401868295438206e-1) }}, 
      {{ SC_(4.459629440307617187500000000000000000000e1), SC_(6.689443969726562500000000000000000000000e1), SC_(5.940588760375976562500000000000000000000e1), SC_(5.302140712738037109375000000000000000000e-1), SC_(5.368597981316881747351644995012061526264e-1), SC_(4.631402018683118252648355004987938473736e-1) }}, 
      {{ SC_(4.459629440307617187500000000000000000000e1), SC_(6.689443969726562500000000000000000000000e1), SC_(1.451677856445312500000000000000000000000e2), SC_(6.394180059432983398437500000000000000000e-1), SC_(5.270821492909532668719153079595155411469e-1), SC_(4.729178507090467331280846920404844588531e-1) }}, 
      {{ SC_(4.459629440307617187500000000000000000000e1), SC_(6.689443969726562500000000000000000000000e1), SC_(1.929777069091796875000000000000000000000e2), SC_(6.808347105979919433593750000000000000000e-1), SC_(5.244336597399081838762851152308621196023e-1), SC_(4.755663402600918161237148847691378803977e-1) }}, 
      {{ SC_(4.459629440307617187500000000000000000000e1), SC_(8.919258880615234375000000000000000000000e1), SC_(6.038262176513671875000000000000000000000e1), SC_(5.049694180488586425781250000000000000000e-1), SC_(8.755686493140322853266268859223581596061e-1), SC_(1.244313506859677146733731140776418403939e-1) }}, 
      {{ SC_(4.459629440307617187500000000000000000000e1), SC_(8.919258880615234375000000000000000000000e1), SC_(1.481294555664062500000000000000000000000e2), SC_(6.092289090156555175781250000000000000000e-1), SC_(8.438469178884697479969377880483894462068e-1), SC_(1.561530821115302520030622119516105537932e-1) }}, 
      {{ SC_(4.459629440307617187500000000000000000000e1), SC_(8.919258880615234375000000000000000000000e1), SC_(1.935389862060546875000000000000000000000e2), SC_(6.476737260818481445312500000000000000000e-1), SC_(8.351818159884888907736271700221117327597e-1), SC_(1.648181840115111092263728299778882672403e-1) }}, 
      {{ SC_(4.459629440307617187500000000000000000000e1), SC_(1.337888793945312500000000000000000000000e2), SC_(6.163340759277343750000000000000000000000e1), SC_(4.666910767555236816406250000000000000000e-1), SC_(9.976641838384766536969892922201964526599e-1), SC_(2.335816161523346303010707779803547340104e-3) }}, 
      {{ SC_(4.459629440307617187500000000000000000000e1), SC_(1.337888793945312500000000000000000000000e2), SC_(1.486264953613281250000000000000000000000e2), SC_(5.582858324050903320312500000000000000000e-1), SC_(9.934376086497550684352857302644727180672e-1), SC_(6.562391350244931564714269735527281932818e-3) }}, 
      {{ SC_(4.459629440307617187500000000000000000000e1), SC_(1.337888793945312500000000000000000000000e2), SC_(1.937735595703125000000000000000000000000e2), SC_(5.944618582725524902343750000000000000000e-1), SC_(9.915194694351280584894680681793606556884e-1), SC_(8.480530564871941510531931820639344311555e-3) }}, 
      {{ SC_(4.459629440307617187500000000000000000000e1), SC_(1.783851776123046875000000000000000000000e2), SC_(7.225879669189453125000000000000000000000e1), SC_(4.701371788978576660156250000000000000000e-1), SC_(9.999986247250799786149268867087122149951e-1), SC_(1.375274920021385073113291287785004903974e-6) }}, 
      {{ SC_(4.459629440307617187500000000000000000000e1), SC_(1.783851776123046875000000000000000000000e2), SC_(1.515480346679687500000000000000000000000e2), SC_(5.403068065643310546875000000000000000000e-1), SC_(9.999867513327791492372570104242542678592e-1), SC_(1.324866722085076274298957574573214077257e-5) }}, 
      {{ SC_(4.459629440307617187500000000000000000000e1), SC_(1.783851776123046875000000000000000000000e2), SC_(1.941185607910156250000000000000000000000e2), SC_(5.708377957344055175781250000000000000000e-1), SC_(9.999745093337545422593612030790989872223e-1), SC_(2.549066624545774063879692090101277769785e-5) }}, 
      {{ SC_(4.459629440307617187500000000000000000000e1), SC_(2.229814758300781250000000000000000000000e2), SC_(9.566968083381652832031250000000000000000e-1), SC_(4.454321563243865966796875000000000000000e-1), SC_(9.999999999999999999997150353283814111071e-1), SC_(2.849646716185888929052107149190328580257e-22) }}, 
      {{ SC_(4.459629440307617187500000000000000000000e1), SC_(2.229814758300781250000000000000000000000e2), SC_(7.844540405273437500000000000000000000000e1), SC_(5.152671933174133300781250000000000000000e-1), SC_(9.999999999999969544753149621202093743806e-1), SC_(3.045524685037879790625619361017263699140e-15) }}, 
      {{ SC_(4.459629440307617187500000000000000000000e1), SC_(2.229814758300781250000000000000000000000e2), SC_(1.584414672851562500000000000000000000000e2), SC_(5.710701346397399902343750000000000000000e-1), SC_(9.999999999994105423899749530866450633520e-1), SC_(5.894576100250469133549366480359164204459e-13) }}, 
      {{ SC_(4.459629440307617187500000000000000000000e1), SC_(2.229814758300781250000000000000000000000e2), SC_(1.962219390869140625000000000000000000000e2), SC_(5.931967496871948242187500000000000000000e-1), SC_(9.999999999974863287656392572415449871237e-1), SC_(2.513671234360742758455012876298483431205e-12) }}, 
      {{ SC_(5.606039810180664062500000000000000000000e1), SC_(5.606040000915527343750000000000000000000), SC_(6.163340759277343750000000000000000000000e1), SC_(9.695823192596435546875000000000000000000e-1), SC_(9.114884985041130692730945775840379509842e-1), SC_(8.851150149588693072690542241596204901583e-2) }}, 
      {{ SC_(5.606039810180664062500000000000000000000e1), SC_(5.606040000915527343750000000000000000000), SC_(1.486264953613281250000000000000000000000e2), SC_(9.793035984039306640625000000000000000000e-1), SC_(9.091543174498713789394465766079887076425e-1), SC_(9.084568255012862106055342339201129235751e-2) }}, 
      {{ SC_(5.606039810180664062500000000000000000000e1), SC_(5.606040000915527343750000000000000000000), SC_(1.937735595703125000000000000000000000000e2), SC_(9.822531342506408691406250000000000000000e-1), SC_(9.086236822451915686930313130521078891759e-1), SC_(9.137631775480843130696868694789211082411e-2) }}, 
      {{ SC_(5.606039810180664062500000000000000000000e1), SC_(1.401509952545166015625000000000000000000e1), SC_(7.225879669189453125000000000000000000000e1), SC_(9.558714628219604492187500000000000000000e-1), SC_(9.997419400608085138138263644012868303129e-1), SC_(2.580599391914861861736355987131696870607e-4) }}, 
      {{ SC_(5.606039810180664062500000000000000000000e1), SC_(1.401509952545166015625000000000000000000e1), SC_(1.515480346679687500000000000000000000000e2), SC_(9.678549170494079589843750000000000000000e-1), SC_(9.996980734452230782666289636007607185163e-1), SC_(3.019265547769217333710363992392814836891e-4) }}, 
      {{ SC_(5.606039810180664062500000000000000000000e1), SC_(1.401509952545166015625000000000000000000e1), SC_(1.941185607910156250000000000000000000000e2), SC_(9.719511866569519042968750000000000000000e-1), SC_(9.996854816261552230548028281151294244918e-1), SC_(3.145183738447769451971718848705755081700e-4) }}, 
      {{ SC_(5.606039810180664062500000000000000000000e1), SC_(2.803019905090332031250000000000000000000e1), SC_(9.566968083381652832031250000000000000000e-1), SC_(9.171324968338012695312500000000000000000e-1), SC_(9.999999999360303619907592361167395224647e-1), SC_(6.396963800924076388326047753530464620299e-11) }}, 
      {{ SC_(5.606039810180664062500000000000000000000e1), SC_(2.803019905090332031250000000000000000000e1), SC_(7.844540405273437500000000000000000000000e1), SC_(9.430261850357055664062500000000000000000e-1), SC_(9.999999995442725511786136349340790131659e-1), SC_(4.557274488213863650659209868341323242135e-10) }}, 
      {{ SC_(5.606039810180664062500000000000000000000e1), SC_(2.803019905090332031250000000000000000000e1), SC_(1.584414672851562500000000000000000000000e2), SC_(9.569634199142456054687500000000000000000e-1), SC_(9.999999991585323633988129021539858179775e-1), SC_(8.414676366011870978460141820224957623416e-10) }}, 
      {{ SC_(5.606039810180664062500000000000000000000e1), SC_(2.803019905090332031250000000000000000000e1), SC_(1.962219390869140625000000000000000000000e2), SC_(9.614259004592895507812500000000000000000e-1), SC_(9.999999990208228372251260553597554705195e-1), SC_(9.791771627748739446402445294804876428313e-10) }}, 
      {{ SC_(5.606039810180664062500000000000000000000e1), SC_(4.204529953002929687500000000000000000000e1), SC_(7.142335891723632812500000000000000000000), SC_(9.172676801681518554687500000000000000000e-1), SC_(9.999999999999999998621502037577604782674e-1), SC_(1.378497962422395217325559836434535434547e-19) }}, 
      {{ SC_(5.606039810180664062500000000000000000000e1), SC_(4.204529953002929687500000000000000000000e1), SC_(7.974770355224609375000000000000000000000e1), SC_(9.389281272888183593750000000000000000000e-1), SC_(9.999999999999999947916189848795448553572e-1), SC_(5.208381015120455144642801065946575483588e-18) }}, 
      {{ SC_(5.606039810180664062500000000000000000000e1), SC_(4.204529953002929687500000000000000000000e1), SC_(1.595857238769531250000000000000000000000e2), SC_(9.526119828224182128906250000000000000000e-1), SC_(9.999999999999999796482334310045638172402e-1), SC_(2.035176656899543618275978214150416242521e-17) }}, 
      {{ SC_(5.606039810180664062500000000000000000000e1), SC_(4.204529953002929687500000000000000000000e1), SC_(1.985762634277343750000000000000000000000e2), SC_(9.572910070419311523437500000000000000000e-1), SC_(9.999999999999999708349905357321695818116e-1), SC_(2.916500946426783041818839049684297747646e-17) }}, 
      {{ SC_(5.606039810180664062500000000000000000000e1), SC_(5.045435714721679687500000000000000000000e1), SC_(1.950807952880859375000000000000000000000e1), SC_(5.657410621643066406250000000000000000000e-2), SC_(4.129813636044570076625904111880005953275e-45), SC_(1.000000000000000000000000000000000000000) }}, 
      {{ SC_(5.606039810180664062500000000000000000000e1), SC_(5.045435714721679687500000000000000000000e1), SC_(8.435225677490234375000000000000000000000e1), SC_(6.600289046764373779296875000000000000000e-2), SC_(6.963377907779745303785788975657492419219e-54), SC_(1.000000000000000000000000000000000000000) }}, 
      {{ SC_(5.606039810180664062500000000000000000000e1), SC_(5.045435714721679687500000000000000000000e1), SC_(1.596211700439453125000000000000000000000e2), SC_(7.285911589860916137695312500000000000000e-2), SC_(1.182612056593030778679142942526814160716e-65), SC_(1.000000000000000000000000000000000000000) }}, 
      {{ SC_(5.606039810180664062500000000000000000000e1), SC_(5.045435714721679687500000000000000000000e1), SC_(1.992922668457031250000000000000000000000e2), SC_(7.546933740377426147460937500000000000000e-2), SC_(3.395967996459244244099443043926906196603e-72), SC_(1.000000000000000000000000000000000000000) }}, 
      {{ SC_(5.606039810180664062500000000000000000000e1), SC_(5.549979400634765625000000000000000000000e1), SC_(2.197235107421875000000000000000000000000e1), SC_(1.366951465606689453125000000000000000000e-1), SC_(6.072165762572895918058334284607636190642e-24), SC_(9.999999999999999999999939278342374271041e-1) }}, 
      {{ SC_(5.606039810180664062500000000000000000000e1), SC_(5.549979400634765625000000000000000000000e1), SC_(8.441753387451171875000000000000000000000e1), SC_(1.596064865589141845703125000000000000000e-1), SC_(3.633226148748184866784530912567140904410e-30), SC_(9.999999999999999999999999999963667738513e-1) }}, 
      {{ SC_(5.606039810180664062500000000000000000000e1), SC_(5.549979400634765625000000000000000000000e1), SC_(1.600560913085937500000000000000000000000e2), SC_(1.774214357137680053710937500000000000000e-1), SC_(6.409349993829986885516386400955963821230e-39), SC_(9.999999999999999999999999999999999999936e-1) }}, 
      {{ SC_(5.606039810180664062500000000000000000000e1), SC_(5.600433731079101562500000000000000000000e1), SC_(2.249290275573730468750000000000000000000e1), SC_(2.727466523647308349609375000000000000000e-1), SC_(8.161928523517120390075514600125074688797e-10), SC_(9.999999991838071476482879609924485399875e-1) }}, 
      {{ SC_(5.606039810180664062500000000000000000000e1), SC_(5.600433731079101562500000000000000000000e1), SC_(9.495173645019531250000000000000000000000e1), SC_(3.241551220417022705078125000000000000000e-1), SC_(1.096711487473584917101240423772594501630e-13), SC_(9.999999999998903288512526415082898759576e-1) }}, 
      {{ SC_(5.606039810180664062500000000000000000000e1), SC_(5.600433731079101562500000000000000000000e1), SC_(1.629447326660156250000000000000000000000e2), SC_(3.549989759922027587890625000000000000000e-1), SC_(5.785195076427286028791944321381639778410e-18), SC_(9.999999999999999942148049235727139712081e-1) }}, 
      {{ SC_(5.606039810180664062500000000000000000000e1), SC_(5.606039810180664062500000000000000000000e1), SC_(2.539736366271972656250000000000000000000e1), SC_(4.128766059875488281250000000000000000000e-1), SC_(1.604712549224758057729962498695087465840e-3), SC_(9.983952874507752419422700375013049125342e-1) }}, 
      {{ SC_(5.606039810180664062500000000000000000000e1), SC_(5.606039810180664062500000000000000000000e1), SC_(9.707512664794921875000000000000000000000e1), SC_(4.878016114234924316406250000000000000000e-1), SC_(8.494492216609684753952640483121305249557e-5), SC_(9.999150550778339031524604735951687869475e-1) }}, 
      {{ SC_(5.606039810180664062500000000000000000000e1), SC_(5.606039810180664062500000000000000000000e1), SC_(1.670017089843750000000000000000000000000e2), SC_(5.345993041992187500000000000000000000000e-1), SC_(2.638938857976476073415295448577132237917e-6), SC_(9.999973610611420235239265847045514228678e-1) }}, 
      {{ SC_(5.606039810180664062500000000000000000000e1), SC_(5.606600570678710937500000000000000000000e1), SC_(2.709540176391601562500000000000000000000e1), SC_(4.981456398963928222656250000000000000000e-1), SC_(1.162524559051086061311549185316900301749e-1), SC_(8.837475440948913938688450814683099698251e-1) }}, 
      {{ SC_(5.606039810180664062500000000000000000000e1), SC_(5.606600570678710937500000000000000000000e1), SC_(1.007325439453125000000000000000000000000e2), SC_(5.888742208480834960937500000000000000000e-1), SC_(5.585751534929140852310037701270526352927e-2), SC_(9.441424846507085914768996229872947364707e-1) }}, 
      {{ SC_(5.606039810180664062500000000000000000000e1), SC_(5.606600570678710937500000000000000000000e1), SC_(1.698258666992187500000000000000000000000e2), SC_(6.433519124984741210937500000000000000000e-1), SC_(2.459640897944735926104587964241815459039e-2), SC_(9.754035910205526407389541203575818454096e-1) }}, 
      {{ SC_(5.606039810180664062500000000000000000000e1), SC_(5.611646270751953125000000000000000000000e1), SC_(2.837726783752441406250000000000000000000e1), SC_(5.499695539474487304687500000000000000000e-1), SC_(4.482187957548615101581043051608739446815e-1), SC_(5.517812042451384898418956948391260553185e-1) }}, 
      {{ SC_(5.606039810180664062500000000000000000000e1), SC_(5.611646270751953125000000000000000000000e1), SC_(1.093762969970703125000000000000000000000e2), SC_(6.564105153083801269531250000000000000000e-1), SC_(4.236122619418189706962782541661423190766e-1), SC_(5.763877380581810293037217458338576809234e-1) }}, 
      {{ SC_(5.606039810180664062500000000000000000000e1), SC_(5.611646270751953125000000000000000000000e1), SC_(1.756861267089843750000000000000000000000e2), SC_(7.116413712501525878906250000000000000000e-1), SC_(4.055168332621459170881599254346702051784e-1), SC_(5.944831667378540829118400745653297948216e-1) }}, 
      {{ SC_(5.606039810180664062500000000000000000000e1), SC_(5.662100219726562500000000000000000000000e1), SC_(3.152261734008789062500000000000000000000e1), SC_(5.581932067871093750000000000000000000000e-1), SC_(4.908288229099271329347367369354056865715e-1), SC_(5.091711770900728670652632630645943134285e-1) }}, 
      {{ SC_(5.606039810180664062500000000000000000000e1), SC_(5.662100219726562500000000000000000000000e1), SC_(1.094441146850585937500000000000000000000e2), SC_(6.604476571083068847656250000000000000000e-1), SC_(4.830826970095703988755208873733095106668e-1), SC_(5.169173029904296011244791126266904893332e-1) }}, 
      {{ SC_(5.606039810180664062500000000000000000000e1), SC_(5.662100219726562500000000000000000000000e1), SC_(1.811583862304687500000000000000000000000e2), SC_(7.201048731803894042968750000000000000000e-1), SC_(4.787742592671350848091715907722539410146e-1), SC_(5.212257407328649151908284092277460589854e-1) }}, 
      {{ SC_(5.606039810180664062500000000000000000000e1), SC_(6.166643905639648437500000000000000000000e1), SC_(3.423733520507812500000000000000000000000e1), SC_(5.422576665878295898437500000000000000000e-1), SC_(4.964587823929547707242705677788218527763e-1), SC_(5.035412176070452292757294322211781472237e-1) }}, 
      {{ SC_(5.606039810180664062500000000000000000000e1), SC_(6.166643905639648437500000000000000000000e1), SC_(1.264718551635742187500000000000000000000e2), SC_(6.585733294486999511718750000000000000000e-1), SC_(4.899965222232118080070997559984024802587e-1), SC_(5.100034777767881919929002440015975197413e-1) }}, 
      {{ SC_(5.606039810180664062500000000000000000000e1), SC_(6.166643905639648437500000000000000000000e1), SC_(1.826751708984375000000000000000000000000e2), SC_(7.044197916984558105468750000000000000000e-1), SC_(4.881205059052409701390680180313411088606e-1), SC_(5.118794940947590298609319819686588911394e-1) }}, 
      {{ SC_(5.606039810180664062500000000000000000000e1), SC_(6.727248382568359375000000000000000000000e1), SC_(3.477303314208984375000000000000000000000e1), SC_(5.215669274330139160156250000000000000000e-1), SC_(4.979076094053848910863813577601694168219e-1), SC_(5.020923905946151089136186422398305831781e-1) }}, 
      {{ SC_(5.606039810180664062500000000000000000000e1), SC_(6.727248382568359375000000000000000000000e1), SC_(1.279526672363281250000000000000000000000e2), SC_(6.402290463447570800781250000000000000000e-1), SC_(4.913291064145423050944850941628587800944e-1), SC_(5.086708935854576949055149058371412199056e-1) }}, 
      {{ SC_(5.606039810180664062500000000000000000000e1), SC_(6.727248382568359375000000000000000000000e1), SC_(1.831471099853515625000000000000000000000e2), SC_(6.863791942596435546875000000000000000000e-1), SC_(4.894426212816009796603036544320975242134e-1), SC_(5.105573787183990203396963455679024757866e-1) }}, 
      {{ SC_(5.606039810180664062500000000000000000000e1), SC_(7.287851715087890625000000000000000000000e1), SC_(3.767639541625976562500000000000000000000e1), SC_(5.069025754928588867187500000000000000000e-1), SC_(5.026251593288125879216507308784240933249e-1), SC_(4.973748406711874120783492691215759066751e-1) }}, 
      {{ SC_(5.606039810180664062500000000000000000000e1), SC_(7.287851715087890625000000000000000000000e1), SC_(1.310955810546875000000000000000000000000e2), SC_(6.250033378601074218750000000000000000000e-1), SC_(4.956603828992022844447838461417823883477e-1), SC_(5.043396171007977155552161538582176116523e-1) }}, 
      {{ SC_(5.606039810180664062500000000000000000000e1), SC_(7.287851715087890625000000000000000000000e1), SC_(1.867986450195312500000000000000000000000e2), SC_(6.719265580177307128906250000000000000000e-1), SC_(4.936358511935012386060477962252738564799e-1), SC_(5.063641488064987613939522037747261435201e-1) }}, 
      {{ SC_(5.606039810180664062500000000000000000000e1), SC_(8.409059906005859375000000000000000000000e1), SC_(4.238486480712890625000000000000000000000e1), SC_(4.835501015186309814453125000000000000000e-1), SC_(5.480786673443744618325321733974513005490e-1), SC_(4.519213326556255381674678266025486994510e-1) }}, 
      {{ SC_(5.606039810180664062500000000000000000000e1), SC_(8.409059906005859375000000000000000000000e1), SC_(1.311481323242187500000000000000000000000e2), SC_(5.946676731109619140625000000000000000000e-1), SC_(5.359555199276947636444901603706998289670e-1), SC_(4.640444800723052363555098396293001710330e-1) }}, 
      {{ SC_(5.606039810180664062500000000000000000000e1), SC_(8.409059906005859375000000000000000000000e1), SC_(1.914333953857421875000000000000000000000e2), SC_(6.464065909385681152343750000000000000000e-1), SC_(5.320734003751584751823622217450681756394e-1), SC_(4.679265996248415248176377782549318243606e-1) }}, 
      {{ SC_(5.606039810180664062500000000000000000000e1), SC_(1.121207962036132812500000000000000000000e2), SC_(4.420680999755859375000000000000000000000e1), SC_(4.640122354030609130859375000000000000000e-1), SC_(9.174796699942739233914902649097503869275e-1), SC_(8.252033000572607660850973509024961307253e-2) }}, 
      {{ SC_(5.606039810180664062500000000000000000000e1), SC_(1.121207962036132812500000000000000000000e2), SC_(1.357470245361328125000000000000000000000e2), SC_(5.676758885383605957031250000000000000000e-1), SC_(8.827267993234566008245981617522991173408e-1), SC_(1.172732006765433991754018382477008826592e-1) }}, 
      {{ SC_(5.606039810180664062500000000000000000000e1), SC_(1.121207962036132812500000000000000000000e2), SC_(1.915013732910156250000000000000000000000e2), SC_(6.132786273956298828125000000000000000000e-1), SC_(8.712650019654670574614569017696138375732e-1), SC_(1.287349980345329425385430982303861624268e-1) }}, 
      {{ SC_(5.606039810180664062500000000000000000000e1), SC_(1.681811981201171875000000000000000000000e2), SC_(5.569964599609375000000000000000000000000e1), SC_(4.438033103942871093750000000000000000000e-1), SC_(9.995396866832894798380741961375746371031e-1), SC_(4.603133167105201619258038624253628968601e-4) }}, 
      {{ SC_(5.606039810180664062500000000000000000000e1), SC_(1.681811981201171875000000000000000000000e2), SC_(1.362719116210937500000000000000000000000e2), SC_(5.202685594558715820312500000000000000000e-1), SC_(9.982329503350662998190231244406390849956e-1), SC_(1.767049664933700180976875559360915004421e-3) }}, 
      {{ SC_(5.606039810180664062500000000000000000000e1), SC_(1.681811981201171875000000000000000000000e2), SC_(1.918984832763671875000000000000000000000e2), SC_(5.618795156478881835937500000000000000000e-1), SC_(9.972128567281733712120466128430746850942e-1), SC_(2.787143271826628787953387156925314905822e-3) }}, 
      {{ SC_(5.606039810180664062500000000000000000000e1), SC_(2.242415924072265625000000000000000000000e2), SC_(5.940588760375976562500000000000000000000e1), SC_(4.434061348438262939453125000000000000000e-1), SC_(9.999999862948356913186497259540337217048e-1), SC_(1.370516430868135027404596627829519441257e-8) }}, 
      {{ SC_(5.606039810180664062500000000000000000000e1), SC_(2.242415924072265625000000000000000000000e2), SC_(1.451677856445312500000000000000000000000e2), SC_(5.109068155288696289062500000000000000000e-1), SC_(9.999995381934577034994373826069471110556e-1), SC_(4.618065422965005626173930528889444339354e-7) }}, 
      {{ SC_(5.606039810180664062500000000000000000000e1), SC_(2.242415924072265625000000000000000000000e2), SC_(1.929777069091796875000000000000000000000e2), SC_(5.418923497200012207031250000000000000000e-1), SC_(9.999987142158420346656137190552258575623e-1), SC_(1.285784157965334386280944774142437661073e-6) }}, 
      {{ SC_(5.606039810180664062500000000000000000000e1), SC_(2.803020019531250000000000000000000000000e2), SC_(6.038262176513671875000000000000000000000e1), SC_(4.900884032249450683593750000000000000000e-1), SC_(9.999999999999999999892403375183619316651e-1), SC_(1.075966248163806833492082111634726230525e-20) }}, 
      {{ SC_(5.606039810180664062500000000000000000000e1), SC_(2.803020019531250000000000000000000000000e2), SC_(1.481294555664062500000000000000000000000e2), SC_(5.444985032081604003906250000000000000000e-1), SC_(9.999999999999999458813165641029364559350e-1), SC_(5.411868343589706354406503863109731495894e-17) }}, 
      {{ SC_(5.606039810180664062500000000000000000000e1), SC_(2.803020019531250000000000000000000000000e2), SC_(1.935389862060546875000000000000000000000e2), SC_(5.683430433273315429687500000000000000000e-1), SC_(9.999999999999993801069391419667428644567e-1), SC_(6.198930608580332571355432656228096181957e-16) }}, 
      {{ SC_(5.975737380981445312500000000000000000000e1), SC_(5.975737571716308593750000000000000000000), SC_(5.569964599609375000000000000000000000000e1), SC_(9.679709672927856445312500000000000000000e-1), SC_(9.201133799453796469216784990573653778164e-1), SC_(7.988662005462035307832150094263462218360e-2) }}, 
      {{ SC_(5.975737380981445312500000000000000000000e1), SC_(5.975737571716308593750000000000000000000), SC_(1.362719116210937500000000000000000000000e2), SC_(9.775958061218261718750000000000000000000e-1), SC_(9.177855426789493664597784419260802727569e-1), SC_(8.221445732105063354022155807391972724312e-2) }}, 
      {{ SC_(5.975737380981445312500000000000000000000e1), SC_(5.975737571716308593750000000000000000000), SC_(1.918984832763671875000000000000000000000e2), SC_(9.814523458480834960937500000000000000000e-1), SC_(9.170863663886790147403163019584996383222e-1), SC_(8.291363361132098525968369804150036167779e-2) }}, 
      {{ SC_(5.975737380981445312500000000000000000000e1), SC_(1.493934345245361328125000000000000000000e1), SC_(5.940588760375976562500000000000000000000e1), SC_(9.521707892417907714843750000000000000000e-1), SC_(9.998452568966483256872177960329201491508e-1), SC_(1.547431033516743127822039670798508491526e-4) }}, 
      {{ SC_(5.975737380981445312500000000000000000000e1), SC_(1.493934345245361328125000000000000000000e1), SC_(1.451677856445312500000000000000000000000e2), SC_(9.660753607749938964843750000000000000000e-1), SC_(9.998091891200375269148224649069878824380e-1), SC_(1.908108799624730851775350930121175620106e-4) }}, 
      {{ SC_(5.975737380981445312500000000000000000000e1), SC_(1.493934345245361328125000000000000000000e1), SC_(1.929777069091796875000000000000000000000e2), SC_(9.708142876625061035156250000000000000000e-1), SC_(9.997988702970952614052868026008366974535e-1), SC_(2.011297029047385947131973991633025465345e-4) }}, 
      {{ SC_(5.975737380981445312500000000000000000000e1), SC_(2.987868690490722656250000000000000000000e1), SC_(6.038262176513671875000000000000000000000e1), SC_(9.375320076942443847656250000000000000000e-1), SC_(9.999999999098979671213689134737806705211e-1), SC_(9.010203287863108652621932947892957592379e-11) }}, 
      {{ SC_(5.975737380981445312500000000000000000000e1), SC_(2.987868690490722656250000000000000000000e1), SC_(1.481294555664062500000000000000000000000e2), SC_(9.542438387870788574218750000000000000000e-1), SC_(9.999999997844420312778276426500343110475e-1), SC_(2.155579687221723573499656889525194139153e-10) }}, 
      {{ SC_(5.975737380981445312500000000000000000000e1), SC_(2.987868690490722656250000000000000000000e1), SC_(1.935389862060546875000000000000000000000e2), SC_(9.598162174224853515625000000000000000000e-1), SC_(9.999999997330245041767739898340094741493e-1), SC_(2.669754958232260101659905258507366520061e-10) }}, 
      {{ SC_(5.975737380981445312500000000000000000000e1), SC_(4.481803131103515625000000000000000000000e1), SC_(6.163340759277343750000000000000000000000e1), SC_(9.336839318275451660156250000000000000000e-1), SC_(9.999999999999999997866503419247707111797e-1), SC_(2.133496580752292888203317145860466197517e-19) }}, 
      {{ SC_(5.975737380981445312500000000000000000000e1), SC_(4.481803131103515625000000000000000000000e1), SC_(1.486264953613281250000000000000000000000e2), SC_(9.497764706611633300781250000000000000000e-1), SC_(9.999999999999999985611761902214596118704e-1), SC_(1.438823809778540388129562649810900751615e-18) }}, 
      {{ SC_(5.975737380981445312500000000000000000000e1), SC_(4.481803131103515625000000000000000000000e1), SC_(1.937735595703125000000000000000000000000e2), SC_(9.554010629653930664062500000000000000000e-1), SC_(9.999999999999999976475540089099031625407e-1), SC_(2.352445991090096837459323489255281443884e-18) }}, 
      {{ SC_(5.975737380981445312500000000000000000000e1), SC_(5.378163528442382812500000000000000000000e1), SC_(7.225879669189453125000000000000000000000e1), SC_(6.400818377733230590820312500000000000000e-2), SC_(9.760733477627769915408748661248507159548e-55), SC_(1.000000000000000000000000000000000000000) }}, 
      {{ SC_(5.975737380981445312500000000000000000000e1), SC_(5.378163528442382812500000000000000000000e1), SC_(1.515480346679687500000000000000000000000e2), SC_(7.153109461069107055664062500000000000000e-2), SC_(7.532381858600092626809075985941264380570e-67), SC_(1.000000000000000000000000000000000000000) }}, 
      {{ SC_(5.975737380981445312500000000000000000000e1), SC_(5.378163528442382812500000000000000000000e1), SC_(1.941185607910156250000000000000000000000e2), SC_(7.440657168626785278320312500000000000000e-2), SC_(8.790796989285837458515838992636991456217e-74), SC_(1.000000000000000000000000000000000000000) }}, 
      {{ SC_(5.975737380981445312500000000000000000000e1), SC_(5.915980148315429687500000000000000000000e1), SC_(9.566968083381652832031250000000000000000e-1), SC_(1.261222660541534423828125000000000000000e-1), SC_(1.334222535244353425770033524559354386850e-23), SC_(9.999999999999999999999866577746475564657e-1) }}, 
      {{ SC_(5.975737380981445312500000000000000000000e1), SC_(5.915980148315429687500000000000000000000e1), SC_(7.844540405273437500000000000000000000000e1), SC_(1.563288271427154541015625000000000000000e-1), SC_(8.699006960502535827028923171330453867615e-31), SC_(9.999999999999999999999999999991300993039e-1) }}, 
      {{ SC_(5.975737380981445312500000000000000000000e1), SC_(5.915980148315429687500000000000000000000e1), SC_(1.584414672851562500000000000000000000000e2), SC_(1.752046495676040649414062500000000000000e-1), SC_(6.826618994969464963963079379115484443134e-40), SC_(9.999999999999999999999999999999999999993e-1) }}, 
      {{ SC_(5.975737380981445312500000000000000000000e1), SC_(5.915980148315429687500000000000000000000e1), SC_(1.962219390869140625000000000000000000000e2), SC_(1.817104369401931762695312500000000000000e-1), SC_(1.725207372423860141707725443832477930526e-44), SC_(1.000000000000000000000000000000000000000) }}, 
      {{ SC_(5.975737380981445312500000000000000000000e1), SC_(5.969761657714843750000000000000000000000e1), SC_(7.142335891723632812500000000000000000000), SC_(2.573211193084716796875000000000000000000e-1), SC_(1.272578721013945107048891874003844094051e-9), SC_(9.999999987274212789860548929511081259962e-1) }}, 
      {{ SC_(5.975737380981445312500000000000000000000e1), SC_(5.969761657714843750000000000000000000000e1), SC_(7.974770355224609375000000000000000000000e1), SC_(3.123648464679718017578125000000000000000e-1), SC_(3.133852237082342124461795727869320954010e-13), SC_(9.999999999996866147762917657875538204272e-1) }}, 
      {{ SC_(5.975737380981445312500000000000000000000e1), SC_(5.969761657714843750000000000000000000000e1), SC_(1.595857238769531250000000000000000000000e2), SC_(3.498914837837219238281250000000000000000e-1), SC_(4.214052266889809807026514972294960334364e-18), SC_(9.999999999999999957859477331101901929735e-1) }}, 
      {{ SC_(5.975737380981445312500000000000000000000e1), SC_(5.969761657714843750000000000000000000000e1), SC_(1.985762634277343750000000000000000000000e2), SC_(3.632608652114868164062500000000000000000e-1), SC_(1.076235423225768317482759346129627128481e-20), SC_(9.999999999999999999892376457677423168252e-1) }}, 
      {{ SC_(5.975737380981445312500000000000000000000e1), SC_(5.975737380981445312500000000000000000000e1), SC_(1.950807952880859375000000000000000000000e1), SC_(4.030933976173400878906250000000000000000e-1), SC_(1.519734425251781022684005539164882668595e-3), SC_(9.984802655747482189773159944608351173314e-1) }}, 
      {{ SC_(5.975737380981445312500000000000000000000e1), SC_(5.975737380981445312500000000000000000000e1), SC_(8.435225677490234375000000000000000000000e1), SC_(4.723694324493408203125000000000000000000e-1), SC_(1.218338577614202649784493433456658607550e-4), SC_(9.998781661422385797350215506566543341392e-1) }}, 
      {{ SC_(5.975737380981445312500000000000000000000e1), SC_(5.975737380981445312500000000000000000000e1), SC_(1.596211700439453125000000000000000000000e2), SC_(5.246996879577636718750000000000000000000e-1), SC_(3.392214263996985578060595323110408362724e-6), SC_(9.999966077857360030144219394046768895916e-1) }}, 
      {{ SC_(5.975737380981445312500000000000000000000e1), SC_(5.975737380981445312500000000000000000000e1), SC_(1.992922668457031250000000000000000000000e2), SC_(5.450774431228637695312500000000000000000e-1), SC_(4.126533613439907201156849676474266493423e-7), SC_(9.999995873466386560092798843150323525734e-1) }}, 
      {{ SC_(5.975737380981445312500000000000000000000e1), SC_(5.976335144042968750000000000000000000000e1), SC_(2.197235107421875000000000000000000000000e1), SC_(4.875949025154113769531250000000000000000e-1), SC_(1.154813182750311580788103145857733356472e-1), SC_(8.845186817249688419211896854142266643528e-1) }}, 
      {{ SC_(5.975737380981445312500000000000000000000e1), SC_(5.976335144042968750000000000000000000000e1), SC_(8.441753387451171875000000000000000000000e1), SC_(5.668893456459045410156250000000000000000e-1), SC_(6.427632565237940228805551972399695372962e-2), SC_(9.357236743476205977119444802760030462704e-1) }}, 
      {{ SC_(5.975737380981445312500000000000000000000e1), SC_(5.976335144042968750000000000000000000000e1), SC_(1.600560913085937500000000000000000000000e2), SC_(6.299150586128234863281250000000000000000e-1), SC_(2.749245476998986282947722823955258377607e-2), SC_(9.725075452300101371705227717604474162239e-1) }}, 
      {{ SC_(5.975737380981445312500000000000000000000e1), SC_(5.981713485717773437500000000000000000000e1), SC_(2.249290275573730468750000000000000000000e1), SC_(5.370306968688964843750000000000000000000e-1), SC_(4.492560066662246085491056680653014016047e-1), SC_(5.507439933337753914508943319346985983953e-1) }}, 
      {{ SC_(5.975737380981445312500000000000000000000e1), SC_(5.981713485717773437500000000000000000000e1), SC_(9.495173645019531250000000000000000000000e1), SC_(6.348992586135864257812500000000000000000e-1), SC_(4.277345784211049678236345645414784363601e-1), SC_(5.722654215788950321763654354585215636399e-1) }}, 
      {{ SC_(5.975737380981445312500000000000000000000e1), SC_(5.981713485717773437500000000000000000000e1), SC_(1.629447326660156250000000000000000000000e2), SC_(6.948533058166503906250000000000000000000e-1), SC_(4.095330130268029689176892744470250129002e-1), SC_(5.904669869731970310823107255529749870998e-1) }}, 
      {{ SC_(5.975737380981445312500000000000000000000e1), SC_(6.035494613647460937500000000000000000000e1), SC_(2.539736366271972656250000000000000000000e1), SC_(5.446852445602416992187500000000000000000e-1), SC_(4.918843506644269915193337805714207396297e-1), SC_(5.081156493355730084806662194285792603703e-1) }}, 
      {{ SC_(5.975737380981445312500000000000000000000e1), SC_(6.035494613647460937500000000000000000000e1), SC_(9.707512664794921875000000000000000000000e1), SC_(6.408765316009521484375000000000000000000e-1), SC_(4.845903679315329061062049992711150227936e-1), SC_(5.154096320684670938937950007288849772064e-1) }}, 
      {{ SC_(5.975737380981445312500000000000000000000e1), SC_(6.035494613647460937500000000000000000000e1), SC_(1.670017089843750000000000000000000000000e2), SC_(7.022803425788879394531250000000000000000e-1), SC_(4.802016641808682494567200884450867457139e-1), SC_(5.197983358191317505432799115549132542861e-1) }}, 
      {{ SC_(5.975737380981445312500000000000000000000e1), SC_(6.573311614990234375000000000000000000000e1), SC_(2.709540176391601562500000000000000000000e1), SC_(5.268984436988830566406250000000000000000e-1), SC_(4.975801484353097388590924320261224841799e-1), SC_(5.024198515646902611409075679738775158201e-1) }}, 
      {{ SC_(5.975737380981445312500000000000000000000e1), SC_(6.573311614990234375000000000000000000000e1), SC_(1.007325439453125000000000000000000000000e2), SC_(6.256034374237060546875000000000000000000e-1), SC_(4.918361449781835093897037286989661768469e-1), SC_(5.081638550218164906102962713010338231531e-1) }}, 
      {{ SC_(5.975737380981445312500000000000000000000e1), SC_(6.573311614990234375000000000000000000000e1), SC_(1.698258666992187500000000000000000000000e2), SC_(6.869860887527465820312500000000000000000e-1), SC_(4.891444348048826910781306787375316666854e-1), SC_(5.108555651951173089218693212624683333146e-1) }}, 
      {{ SC_(5.975737380981445312500000000000000000000e1), SC_(7.170885467529296875000000000000000000000e1), SC_(2.837726783752441406250000000000000000000e1), SC_(5.073996782302856445312500000000000000000e-1), SC_(4.989308308947501563644693528249050414115e-1), SC_(5.010691691052498436355306471750949585885e-1) }}, 
      {{ SC_(5.975737380981445312500000000000000000000e1), SC_(7.170885467529296875000000000000000000000e1), SC_(1.093762969970703125000000000000000000000e2), SC_(6.142188906669616699218750000000000000000e-1), SC_(4.928087372485417608849622921176463653722e-1), SC_(5.071912627514582391150377078823536346278e-1) }}, 
      {{ SC_(5.975737380981445312500000000000000000000e1), SC_(7.170885467529296875000000000000000000000e1), SC_(1.756861267089843750000000000000000000000e2), SC_(6.724596619606018066406250000000000000000e-1), SC_(4.903135242049714192433048059311108236450e-1), SC_(5.096864757950285807566951940688891763550e-1) }}, 
      {{ SC_(5.975737380981445312500000000000000000000e1), SC_(7.768458557128906250000000000000000000000e1), SC_(3.152261734008789062500000000000000000000e1), SC_(4.930977225303649902343750000000000000000e-1), SC_(5.038143419725954867745913593667117634203e-1), SC_(4.961856580274045132254086406332882365797e-1) }}, 
      {{ SC_(5.975737380981445312500000000000000000000e1), SC_(7.768458557128906250000000000000000000000e1), SC_(1.094441146850585937500000000000000000000e2), SC_(5.955435037612915039062500000000000000000e-1), SC_(4.974801902600920626111636353828615274896e-1), SC_(5.025198097399079373888363646171384725104e-1) }}, 
      {{ SC_(5.975737380981445312500000000000000000000e1), SC_(7.768458557128906250000000000000000000000e1), SC_(1.811583862304687500000000000000000000000e2), SC_(6.590571403503417968750000000000000000000e-1), SC_(4.945810075140466005603160797634480611632e-1), SC_(5.054189924859533994396839202365519388368e-1) }}, 
      {{ SC_(5.975737380981445312500000000000000000000e1), SC_(8.963606262207031250000000000000000000000e1), SC_(3.423733520507812500000000000000000000000e1), SC_(4.666852056980133056640625000000000000000e-1), SC_(5.521546883321586841468885819678476633692e-1), SC_(4.478453116678413158531114180321523366308e-1) }}, 
      {{ SC_(5.975737380981445312500000000000000000000e1), SC_(8.963606262207031250000000000000000000000e1), SC_(1.264718551635742187500000000000000000000e2), SC_(5.820299386978149414062500000000000000000e-1), SC_(5.386375011167115178355702675815935104076e-1), SC_(4.613624988832884821644297324184064895924e-1) }}, 
      {{ SC_(5.975737380981445312500000000000000000000e1), SC_(8.963606262207031250000000000000000000000e1), SC_(1.826751708984375000000000000000000000000e2), SC_(6.307561397552490234375000000000000000000e-1), SC_(5.347517697031526402703247075158664446809e-1), SC_(4.652482302968473597296752924841335553191e-1) }}, 
      {{ SC_(5.975737380981445312500000000000000000000e1), SC_(1.195147476196289062500000000000000000000e2), SC_(3.477303314208984375000000000000000000000e1), SC_(4.472726285457611083984375000000000000000e-1), SC_(9.308177051770030991356768464233387336207e-1), SC_(6.918229482299690086432315357666126637931e-2) }}, 
      {{ SC_(5.975737380981445312500000000000000000000e1), SC_(1.195147476196289062500000000000000000000e2), SC_(1.279526672363281250000000000000000000000e2), SC_(5.528553128242492675781250000000000000000e-1), SC_(8.943694502550560325652518200614140747214e-1), SC_(1.056305497449439674347481799385859252786e-1) }}, 
      {{ SC_(5.975737380981445312500000000000000000000e1), SC_(1.195147476196289062500000000000000000000e2), SC_(1.831471099853515625000000000000000000000e2), SC_(5.983491539955139160156250000000000000000e-1), SC_(8.825030075627862442852980640727418151266e-1), SC_(1.174969924372137557147019359272581848734e-1) }}, 
      {{ SC_(5.975737380981445312500000000000000000000e1), SC_(1.792721252441406250000000000000000000000e2), SC_(3.767639541625976562500000000000000000000e1), SC_(4.204944968223571777343750000000000000000e-1), SC_(9.998434492063506939135689113409775645590e-1), SC_(1.565507936493060864310886590224354409858e-4) }}, 
      {{ SC_(5.975737380981445312500000000000000000000e1), SC_(1.792721252441406250000000000000000000000e2), SC_(1.310955810546875000000000000000000000000e2), SC_(5.091590881347656250000000000000000000000e-1), SC_(9.988883710436946570086364980868507169931e-1), SC_(1.111628956305342991363501913149283006872e-3) }}, 
      {{ SC_(5.975737380981445312500000000000000000000e1), SC_(1.792721252441406250000000000000000000000e2), SC_(1.867986450195312500000000000000000000000e2), SC_(5.502204298973083496093750000000000000000e-1), SC_(9.981377897994174279588775251062446592375e-1), SC_(1.862210200582572041122474893755340762483e-3) }}, 
      {{ SC_(5.975737380981445312500000000000000000000e1), SC_(2.390294952392578125000000000000000000000e2), SC_(4.238486480712890625000000000000000000000e1), SC_(4.252537190914154052734375000000000000000e-1), SC_(9.999999990204845353404663008592139558918e-1), SC_(9.795154646595336991407860441082220397664e-10) }}, 
      {{ SC_(5.975737380981445312500000000000000000000e1), SC_(2.390294952392578125000000000000000000000e2), SC_(1.311481323242187500000000000000000000000e2), SC_(4.951169490814208984375000000000000000000e-1), SC_(9.999998963575866939968384576414869336430e-1), SC_(1.036424133060031615423585130663569936189e-7) }}, 
      {{ SC_(5.975737380981445312500000000000000000000e1), SC_(2.390294952392578125000000000000000000000e2), SC_(1.914333953857421875000000000000000000000e2), SC_(5.336368083953857421875000000000000000000e-1), SC_(9.999995385717638385966854847663628194430e-1), SC_(4.614282361614033145152336371805570226679e-7) }}, 
      {{ SC_(5.975737380981445312500000000000000000000e1), SC_(2.987868652343750000000000000000000000000e2), SC_(4.420680999755859375000000000000000000000e1), SC_(4.766245484352111816406250000000000000000e-1), SC_(9.999999999999999999999808336355192056206e-1), SC_(1.916636448079437944412952911093288094892e-23) }}, 
      {{ SC_(5.975737380981445312500000000000000000000e1), SC_(2.987868652343750000000000000000000000000e2), SC_(1.357470245361328125000000000000000000000e2), SC_(5.326986312866210937500000000000000000000e-1), SC_(9.999999999999999988133665308083294717363e-1), SC_(1.186633469191670528263662465265233899840e-18) }}, 
      {{ SC_(5.975737380981445312500000000000000000000e1), SC_(2.987868652343750000000000000000000000000e2), SC_(1.915013732910156250000000000000000000000e2), SC_(5.613341927528381347656250000000000000000e-1), SC_(9.999999999999999640864792930001370417835e-1), SC_(3.591352070699986295821654711311986012253e-17) }}, 
      {{ SC_(6.197932434082031250000000000000000000000e1), SC_(6.197932720184326171875000000000000000000), SC_(3.767639541625976562500000000000000000000e1), SC_(9.642974138259887695312500000000000000000e-1), SC_(9.256722039401997542617361016618592224964e-1), SC_(7.432779605980024573826389833814077750357e-2) }}, 
      {{ SC_(6.197932434082031250000000000000000000000e1), SC_(6.197932720184326171875000000000000000000), SC_(1.310955810546875000000000000000000000000e2), SC_(9.767408967018127441406250000000000000000e-1), SC_(9.225175391112732485859369891200489663645e-1), SC_(7.748246088872675141406301087995103363546e-2) }}, 
      {{ SC_(6.197932434082031250000000000000000000000e1), SC_(6.197932720184326171875000000000000000000), SC_(1.867986450195312500000000000000000000000e2), SC_(9.807518720626831054687500000000000000000e-1), SC_(9.217874847476833465483591136338574290357e-1), SC_(7.821251525231665345164088636614257096435e-2) }}, 
      {{ SC_(6.197932434082031250000000000000000000000e1), SC_(1.549483108520507812500000000000000000000e1), SC_(4.238486480712890625000000000000000000000e1), SC_(9.475386142730712890625000000000000000000e-1), SC_(9.998924040211285807938855588611045275723e-1), SC_(1.075959788714192061144411388954724277321e-4) }}, 
      {{ SC_(6.197932434082031250000000000000000000000e1), SC_(1.549483108520507812500000000000000000000e1), SC_(1.311481323242187500000000000000000000000e2), SC_(9.637779593467712402343750000000000000000e-1), SC_(9.998576298377740721499341337230321679391e-1), SC_(1.423701622259278500658662769678320608679e-4) }}, 
      {{ SC_(6.197932434082031250000000000000000000000e1), SC_(1.549483108520507812500000000000000000000e1), SC_(1.914333953857421875000000000000000000000e2), SC_(9.700825810432434082031250000000000000000e-1), SC_(9.998463469450255551627567358680655596545e-1), SC_(1.536530549744448372432641319344403454885e-4) }}, 
      {{ SC_(6.197932434082031250000000000000000000000e1), SC_(3.098966217041015625000000000000000000000e1), SC_(4.420680999755859375000000000000000000000e1), SC_(9.325611591339111328125000000000000000000e-1), SC_(9.999999999711954314346702787417960037760e-1), SC_(2.880456856532972125820399622401911947191e-11) }}, 
      {{ SC_(6.197932434082031250000000000000000000000e1), SC_(3.098966217041015625000000000000000000000e1), SC_(1.357470245361328125000000000000000000000e2), SC_(9.517059326171875000000000000000000000000e-1), SC_(9.999999999096023877781214632025021034390e-1), SC_(9.039761222187853679749789656096286891639e-11) }}, 
      {{ SC_(6.197932434082031250000000000000000000000e1), SC_(3.098966217041015625000000000000000000000e1), SC_(1.915013732910156250000000000000000000000e2), SC_(9.588371515274047851562500000000000000000e-1), SC_(9.999999998782417423865972469732497831031e-1), SC_(1.217582576134027530267502168969262218779e-10) }}, 
      {{ SC_(6.197932434082031250000000000000000000000e1), SC_(4.648449325561523437500000000000000000000e1), SC_(5.569964599609375000000000000000000000000e1), SC_(9.316955208778381347656250000000000000000e-1), SC_(9.999999999999999999656362491049932624202e-1), SC_(3.436375089500673757980304592442506674120e-20) }}, 
      {{ SC_(6.197932434082031250000000000000000000000e1), SC_(4.648449325561523437500000000000000000000e1), SC_(1.362719116210937500000000000000000000000e2), SC_(9.472411274909973144531250000000000000000e-1), SC_(9.999999999999999997378389978717790735027e-1), SC_(2.621610021282209264973058152343717663327e-19) }}, 
      {{ SC_(6.197932434082031250000000000000000000000e1), SC_(4.648449325561523437500000000000000000000e1), SC_(1.918984832763671875000000000000000000000e2), SC_(9.544146060943603515625000000000000000000e-1), SC_(9.999999999999999994812724180253334334193e-1), SC_(5.187275819746665665807083046361439401921e-19) }}, 
      {{ SC_(6.197932434082031250000000000000000000000e1), SC_(5.578139114379882812500000000000000000000e1), SC_(5.940588760375976562500000000000000000000e1), SC_(6.212111935019493103027343750000000000000e-2), SC_(1.604254551974596323743168978971079477687e-54), SC_(1.000000000000000000000000000000000000000) }}, 
      {{ SC_(6.197932434082031250000000000000000000000e1), SC_(5.578139114379882812500000000000000000000e1), SC_(1.451677856445312500000000000000000000000e2), SC_(7.063581794500350952148437500000000000000e-2), SC_(2.397532927087273367312016637096367263122e-67), SC_(1.000000000000000000000000000000000000000) }}, 
      {{ SC_(6.197932434082031250000000000000000000000e1), SC_(5.578139114379882812500000000000000000000e1), SC_(1.929777069091796875000000000000000000000e2), SC_(7.390956580638885498046875000000000000000e-2), SC_(4.495214367990653353161938915328291199237e-75), SC_(1.000000000000000000000000000000000000000) }}, 
      {{ SC_(6.197932434082031250000000000000000000000e1), SC_(6.135953140258789062500000000000000000000e1), SC_(6.038262176513671875000000000000000000000e1), SC_(1.499575674533843994140625000000000000000e-1), SC_(1.100488465997658044838817802119712032381e-29), SC_(9.999999999999999999999999999889951153400e-1) }}, 
      {{ SC_(6.197932434082031250000000000000000000000e1), SC_(6.135953140258789062500000000000000000000e1), SC_(1.481294555664062500000000000000000000000e2), SC_(1.721440702676773071289062500000000000000e-1), SC_(2.224293971894387767711093234733515806122e-39), SC_(9.999999999999999999999999999999999999978e-1) }}, 
      {{ SC_(6.197932434082031250000000000000000000000e1), SC_(6.135953140258789062500000000000000000000e1), SC_(1.935389862060546875000000000000000000000e2), SC_(1.801683753728866577148437500000000000000e-1), SC_(7.668663856565264015527256325011794966254e-45), SC_(1.000000000000000000000000000000000000000) }}, 
      {{ SC_(6.197932434082031250000000000000000000000e1), SC_(6.191734695434570312500000000000000000000e1), SC_(6.163340759277343750000000000000000000000e1), SC_(2.996389567852020263671875000000000000000e-1), SC_(1.681710452561555094979693255776776408719e-12), SC_(9.999999999983182895474384449050203067442e-1) }}, 
      {{ SC_(6.197932434082031250000000000000000000000e1), SC_(6.191734695434570312500000000000000000000e1), SC_(1.486264953613281250000000000000000000000e2), SC_(3.435132205486297607421875000000000000000e-1), SC_(1.274481039557659378440325004985612632764e-17), SC_(9.999999999999999872551896044234062155967e-1) }}, 
      {{ SC_(6.197932434082031250000000000000000000000e1), SC_(6.191734695434570312500000000000000000000e1), SC_(1.937735595703125000000000000000000000000e2), SC_(3.594993948936462402343750000000000000000e-1), SC_(1.430734889235720165472319654309901454756e-20), SC_(9.999999999999999999856926511076427983453e-1) }}, 
      {{ SC_(6.197932434082031250000000000000000000000e1), SC_(6.197932434082031250000000000000000000000e1), SC_(7.225879669189453125000000000000000000000e1), SC_(4.592223465442657470703125000000000000000e-1), SC_(1.783533407735872349406821256759901806814e-4), SC_(9.998216466592264127650593178743240098193e-1) }}, 
      {{ SC_(6.197932434082031250000000000000000000000e1), SC_(6.197932434082031250000000000000000000000e1), SC_(1.515480346679687500000000000000000000000e2), SC_(5.168243646621704101562500000000000000000e-1), SC_(4.662718744265836036178655574659983782786e-6), SC_(9.999953372812557341639638213444253400162e-1) }}, 
      {{ SC_(6.197932434082031250000000000000000000000e1), SC_(6.197932434082031250000000000000000000000e1), SC_(1.941185607910156250000000000000000000000e2), SC_(5.392621159553527832031250000000000000000e-1), SC_(5.123237424845331796560373539942027662922e-7), SC_(9.999994876762575154668203439626460057972e-1) }}, 
      {{ SC_(6.197932434082031250000000000000000000000e1), SC_(6.198552322387695312500000000000000000000e1), SC_(9.566968083381652832031250000000000000000e-1), SC_(4.516934752464294433593750000000000000000e-1), SC_(1.317606262403009915397315152442657464280e-1), SC_(8.682393737596990084602684847557342535720e-1) }}, 
      {{ SC_(6.197932434082031250000000000000000000000e1), SC_(6.198552322387695312500000000000000000000e1), SC_(7.844540405273437500000000000000000000000e1), SC_(5.576384663581848144531250000000000000000e-1), SC_(6.677222997406274409696879201152866835992e-2), SC_(9.332277700259372559030312079884713316401e-1) }}, 
      {{ SC_(6.197932434082031250000000000000000000000e1), SC_(6.198552322387695312500000000000000000000e1), SC_(1.584414672851562500000000000000000000000e2), SC_(6.249114274978637695312500000000000000000e-1), SC_(2.778313631235200512265389958089219809818e-2), SC_(9.722168636876479948773461004191078019018e-1) }}, 
      {{ SC_(6.197932434082031250000000000000000000000e1), SC_(6.198552322387695312500000000000000000000e1), SC_(1.962219390869140625000000000000000000000e2), SC_(6.482933759689331054687500000000000000000e-1), SC_(1.746032475269156841419473690891470506993e-2), SC_(9.825396752473084315858052630910852949301e-1) }}, 
      {{ SC_(6.197932434082031250000000000000000000000e1), SC_(6.204130554199218750000000000000000000000e1), SC_(7.142335891723632812500000000000000000000), SC_(5.085085034370422363281250000000000000000e-1), SC_(4.535155010284341089148776231296762627782e-1), SC_(5.464844989715658910851223768703237372218e-1) }}, 
      {{ SC_(6.197932434082031250000000000000000000000e1), SC_(6.204130554199218750000000000000000000000e1), SC_(7.974770355224609375000000000000000000000e1), SC_(6.146849393844604492187500000000000000000e-1), SC_(4.318818748640485876836339445245503098989e-1), SC_(5.681181251359514123163660554754496901011e-1) }}, 
      {{ SC_(6.197932434082031250000000000000000000000e1), SC_(6.204130554199218750000000000000000000000e1), SC_(1.595857238769531250000000000000000000000e2), SC_(6.880627870559692382812500000000000000000e-1), SC_(4.106950724054951081016464031613160495550e-1), SC_(5.893049275945048918983535968386839504450e-1) }}, 
      {{ SC_(6.197932434082031250000000000000000000000e1), SC_(6.204130554199218750000000000000000000000e1), SC_(1.985762634277343750000000000000000000000e2), SC_(7.144031524658203125000000000000000000000e-1), SC_(4.008817254640360197901381054172353166409e-1), SC_(5.991182745359639802098618945827646833591e-1) }}, 
      {{ SC_(6.197932434082031250000000000000000000000e1), SC_(6.259911727905273437500000000000000000000e1), SC_(1.950807952880859375000000000000000000000e1), SC_(5.332130193710327148437500000000000000000e-1), SC_(4.927698070742369658803749039612138386530e-1), SC_(5.072301929257630341196250960387861613470e-1) }}, 
      {{ SC_(6.197932434082031250000000000000000000000e1), SC_(6.259911727905273437500000000000000000000e1), SC_(8.435225677490234375000000000000000000000e1), SC_(6.234099268913269042968750000000000000000e-1), SC_(4.858917508892085220950538973816783167623e-1), SC_(5.141082491107914779049461026183216832377e-1) }}, 
      {{ SC_(6.197932434082031250000000000000000000000e1), SC_(6.259911727905273437500000000000000000000e1), SC_(1.596211700439453125000000000000000000000e2), SC_(6.924473643302917480468750000000000000000e-1), SC_(4.809700499908510421205231320675169308930e-1), SC_(5.190299500091489578794768679324830691070e-1) }}, 
      {{ SC_(6.197932434082031250000000000000000000000e1), SC_(6.259911727905273437500000000000000000000e1), SC_(1.992922668457031250000000000000000000000e2), SC_(7.195459604263305664062500000000000000000e-1), SC_(4.790078941239612195416457461375839475168e-1), SC_(5.209921058760387804583542538624160524832e-1) }}, 
      {{ SC_(6.197932434082031250000000000000000000000e1), SC_(6.817726135253906250000000000000000000000e1), SC_(2.197235107421875000000000000000000000000e1), SC_(5.166960358619689941406250000000000000000e-1), SC_(4.983034982784102958750228563953812627423e-1), SC_(5.016965017215897041249771436046187372577e-1) }}, 
      {{ SC_(6.197932434082031250000000000000000000000e1), SC_(6.817726135253906250000000000000000000000e1), SC_(8.441753387451171875000000000000000000000e1), SC_(6.038988232612609863281250000000000000000e-1), SC_(4.930735587793269444740898928906761571016e-1), SC_(5.069264412206730555259101071093238428984e-1) }}, 
      {{ SC_(6.197932434082031250000000000000000000000e1), SC_(6.817726135253906250000000000000000000000e1), SC_(1.600560913085937500000000000000000000000e2), SC_(6.750439405441284179687500000000000000000e-1), SC_(4.898058970487145371594149804203490242889e-1), SC_(5.101941029512854628405850195796509757111e-1) }}, 
      {{ SC_(6.197932434082031250000000000000000000000e1), SC_(7.437519073486328125000000000000000000000e1), SC_(2.249290275573730468750000000000000000000e1), SC_(4.958966374397277832031250000000000000000e-1), SC_(4.997308287987352956193113188112105011228e-1), SC_(5.002691712012647043806886811887894988772e-1) }}, 
      {{ SC_(6.197932434082031250000000000000000000000e1), SC_(7.437519073486328125000000000000000000000e1), SC_(9.495173645019531250000000000000000000000e1), SC_(5.948861837387084960937500000000000000000e-1), SC_(4.938919202935398899463581081036312881287e-1), SC_(5.061080797064601100536418918963687118713e-1) }}, 
      {{ SC_(6.197932434082031250000000000000000000000e1), SC_(7.437519073486328125000000000000000000000e1), SC_(1.629447326660156250000000000000000000000e2), SC_(6.580061912536621093750000000000000000000e-1), SC_(4.910603321790085505709922515836154997850e-1), SC_(5.089396678209914494290077484163845002150e-1) }}, 
      {{ SC_(6.197932434082031250000000000000000000000e1), SC_(8.057312011718750000000000000000000000000e1), SC_(2.539736366271972656250000000000000000000e1), SC_(4.812596142292022705078125000000000000000e-1), SC_(5.047812151665517092410815845318908837276e-1), SC_(4.952187848334482907589184154681091162724e-1) }}, 
      {{ SC_(6.197932434082031250000000000000000000000e1), SC_(8.057312011718750000000000000000000000000e1), SC_(9.707512664794921875000000000000000000000e1), SC_(5.782112479209899902343750000000000000000e-1), SC_(4.985843432577967876168896167701372517329e-1), SC_(5.014156567422032123831103832298627482671e-1) }}, 
      {{ SC_(6.197932434082031250000000000000000000000e1), SC_(8.057312011718750000000000000000000000000e1), SC_(1.670017089843750000000000000000000000000e2), SC_(6.433400511741638183593750000000000000000e-1), SC_(4.954651710613176046367484068349363440761e-1), SC_(5.045348289386823953632515931650636559239e-1) }}, 
      {{ SC_(6.197932434082031250000000000000000000000e1), SC_(9.296898651123046875000000000000000000000e1), SC_(2.709540176391601562500000000000000000000e1), SC_(4.534444510936737060546875000000000000000e-1), SC_(5.552019840842180097239615746294087201287e-1), SC_(4.447980159157819902760384253705912798713e-1) }}, 
      {{ SC_(6.197932434082031250000000000000000000000e1), SC_(9.296898651123046875000000000000000000000e1), SC_(1.007325439453125000000000000000000000000e2), SC_(5.511352419853210449218750000000000000000e-1), SC_(5.425051543174883303503953923687921664431e-1), SC_(4.574948456825116696496046076312078335569e-1) }}, 
      {{ SC_(6.197932434082031250000000000000000000000e1), SC_(9.296898651123046875000000000000000000000e1), SC_(1.698258666992187500000000000000000000000e2), SC_(6.156763434410095214843750000000000000000e-1), SC_(5.367933250233719122258009328702279702620e-1), SC_(4.632066749766280877741990671297720297380e-1) }}, 
      {{ SC_(6.197932434082031250000000000000000000000e1), SC_(1.239586486816406250000000000000000000000e2), SC_(2.837726783752441406250000000000000000000e1), SC_(4.367085993289947509765625000000000000000e-1), SC_(9.386819259921228943181279045959583315029e-1), SC_(6.131807400787710568187209540404166849713e-2) }}, 
      {{ SC_(6.197932434082031250000000000000000000000e1), SC_(1.239586486816406250000000000000000000000e2), SC_(1.093762969970703125000000000000000000000e2), SC_(5.312390923500061035156250000000000000000e-1), SC_(9.048618250095238187039148590763659428547e-1), SC_(9.513817499047618129608514092363405714530e-2) }}, 
      {{ SC_(6.197932434082031250000000000000000000000e1), SC_(1.239586486816406250000000000000000000000e2), SC_(1.756861267089843750000000000000000000000e2), SC_(5.879124999046325683593750000000000000000e-1), SC_(8.893745568317642597154056720484098519065e-1), SC_(1.106254431682357402845943279515901480935e-1) }}, 
      {{ SC_(6.197932434082031250000000000000000000000e1), SC_(1.859379730224609375000000000000000000000e2), SC_(3.152261734008789062500000000000000000000e1), SC_(4.122259914875030517578125000000000000000e-1), SC_(9.999106315047360344635228148233632932119e-1), SC_(8.936849526396553647718517663670678814777e-5) }}, 
      {{ SC_(6.197932434082031250000000000000000000000e1), SC_(1.859379730224609375000000000000000000000e2), SC_(1.094441146850585937500000000000000000000e2), SC_(4.877041578292846679687500000000000000000e-1), SC_(9.993531773827541230890669314374380679945e-1), SC_(6.468226172458769109330685625619320054694e-4) }}, 
      {{ SC_(6.197932434082031250000000000000000000000e1), SC_(1.859379730224609375000000000000000000000e2), SC_(1.811583862304687500000000000000000000000e2), SC_(5.418835878372192382812500000000000000000e-1), SC_(9.985765712468285494276792083809361714263e-1), SC_(1.423428753171450572320791619063828573678e-3) }}, 
      {{ SC_(6.197932434082031250000000000000000000000e1), SC_(2.479172973632812500000000000000000000000e2), SC_(3.423733520507812500000000000000000000000e1), SC_(4.167363047599792480468750000000000000000e-1), SC_(9.999999998057235718828603121331253766840e-1), SC_(1.942764281171396878668746233160078932538e-10) }}, 
      {{ SC_(6.197932434082031250000000000000000000000e1), SC_(2.479172973632812500000000000000000000000e2), SC_(1.264718551635742187500000000000000000000e2), SC_(4.886743724346160888671875000000000000000e-1), SC_(9.999999548187176438179066500271732467167e-1), SC_(4.518128235618209334997282675328328670535e-8) }}, 
      {{ SC_(6.197932434082031250000000000000000000000e1), SC_(2.479172973632812500000000000000000000000e2), SC_(1.826751708984375000000000000000000000000e2), SC_(5.244328379631042480468750000000000000000e-1), SC_(9.999997910065076850412027005373578553534e-1), SC_(2.089934923149587972994626421446466256094e-7) }}, 
      {{ SC_(6.197932434082031250000000000000000000000e1), SC_(3.098966064453125000000000000000000000000e2), SC_(3.477303314208984375000000000000000000000e1), SC_(4.691976010799407958984375000000000000000e-1), SC_(9.999999999999999999999997202270158235089e-1), SC_(2.797729841764910596054462104593491395411e-25) }}, 
      {{ SC_(6.197932434082031250000000000000000000000e1), SC_(3.098966064453125000000000000000000000000e2), SC_(1.279526672363281250000000000000000000000e2), SC_(5.258316993713378906250000000000000000000e-1), SC_(9.999999999999999998972008578905391710017e-1), SC_(1.027991421094608289983184975446870620177e-19) }}, 
      {{ SC_(6.197932434082031250000000000000000000000e1), SC_(3.098966064453125000000000000000000000000e2), SC_(1.831471099853515625000000000000000000000e2), SC_(5.540273189544677734375000000000000000000e-1), SC_(9.999999999999999957116221269461129572459e-1), SC_(4.288377873053887042754135044886355878318e-18) }}, 
      {{ SC_(7.257815551757812500000000000000000000000e1), SC_(7.257815837860107421875000000000000000000), SC_(3.152261734008789062500000000000000000000e1), SC_(9.619741439819335937500000000000000000000e-1), SC_(9.440035849228498997751486919327064637464e-1), SC_(5.599641507715010022485130806729353625360e-2) }}, 
      {{ SC_(7.257815551757812500000000000000000000000e1), SC_(7.257815837860107421875000000000000000000), SC_(1.094441146850585937500000000000000000000e2), SC_(9.729493856430053710937500000000000000000e-1), SC_(9.413989596949035799815403593414905195547e-1), SC_(5.860104030509642001845964065850948044526e-2) }}, 
      {{ SC_(7.257815551757812500000000000000000000000e1), SC_(7.257815837860107421875000000000000000000), SC_(1.811583862304687500000000000000000000000e2), SC_(9.786390662193298339843750000000000000000e-1), SC_(9.403961034000079618085379276460766122730e-1), SC_(5.960389659999203819146207235392338772704e-2) }}, 
      {{ SC_(7.257815551757812500000000000000000000000e1), SC_(1.814453887939453125000000000000000000000e1), SC_(3.423733520507812500000000000000000000000e1), SC_(9.438334107398986816406250000000000000000e-1), SC_(9.999732218969475376078585398753881308487e-1), SC_(2.677810305246239214146012461186915132357e-5) }}, 
      {{ SC_(7.257815551757812500000000000000000000000e1), SC_(1.814453887939453125000000000000000000000e1), SC_(1.264718551635742187500000000000000000000e2), SC_(9.606107473373413085937500000000000000000e-1), SC_(9.999613582187329610032180097774811379064e-1), SC_(3.864178126703899678199022251886209361876e-5) }}, 
      {{ SC_(7.257815551757812500000000000000000000000e1), SC_(1.814453887939453125000000000000000000000e1), SC_(1.826751708984375000000000000000000000000e2), SC_(9.666876792907714843750000000000000000000e-1), SC_(9.999575403277926797641415564265702652502e-1), SC_(4.245967220732023585844357342973474975674e-5) }}, 
      {{ SC_(7.257815551757812500000000000000000000000e1), SC_(3.628907775878906250000000000000000000000e1), SC_(3.477303314208984375000000000000000000000e1), SC_(9.280642271041870117187500000000000000000e-1), SC_(9.999999999995781313891407062892287277177e-1), SC_(4.218686108592937107712722823186783378705e-13) }}, 
      {{ SC_(7.257815551757812500000000000000000000000e1), SC_(3.628907775878906250000000000000000000000e1), SC_(1.279526672363281250000000000000000000000e2), SC_(9.473992586135864257812500000000000000000e-1), SC_(9.999999999980980574084198036179720714180e-1), SC_(1.901942591580196382027928581971358698177e-12) }}, 
      {{ SC_(7.257815551757812500000000000000000000000e1), SC_(3.628907775878906250000000000000000000000e1), SC_(1.831471099853515625000000000000000000000e2), SC_(9.546352624893188476562500000000000000000e-1), SC_(9.999999999971790728255618475144497824366e-1), SC_(2.820927174438152485550217563418623802395e-12) }}, 
      {{ SC_(7.257815551757812500000000000000000000000e1), SC_(5.443361663818359375000000000000000000000e1), SC_(3.767639541625976562500000000000000000000e1), SC_(9.252905845642089843750000000000000000000e-1), SC_(9.999999999999999999999936333985367791099e-1), SC_(6.366601463220890097313386117562405866940e-24) }}, 
      {{ SC_(7.257815551757812500000000000000000000000e1), SC_(5.443361663818359375000000000000000000000e1), SC_(1.310955810546875000000000000000000000000e2), SC_(9.433631300926208496093750000000000000000e-1), SC_(9.999999999999999999998446088035291177578e-1), SC_(1.553911964708822421780769447247125979540e-22) }}, 
      {{ SC_(7.257815551757812500000000000000000000000e1), SC_(5.443361663818359375000000000000000000000e1), SC_(1.867986450195312500000000000000000000000e2), SC_(9.505122303962707519531250000000000000000e-1), SC_(9.999999999999999999996248042350412789194e-1), SC_(3.751957649587210805833550731293728119639e-22) }}, 
      {{ SC_(7.257815551757812500000000000000000000000e1), SC_(6.532033538818359375000000000000000000000e1), SC_(4.238486480712890625000000000000000000000e1), SC_(5.890712887048721313476562500000000000000e-2), SC_(6.455493958581931599237920388513580927569e-60), SC_(1.000000000000000000000000000000000000000) }}, 
      {{ SC_(7.257815551757812500000000000000000000000e1), SC_(6.532033538818359375000000000000000000000e1), SC_(1.311481323242187500000000000000000000000e2), SC_(6.784638017416000366210937500000000000000e-2), SC_(1.781376271616161570405304232439374309596e-72), SC_(1.000000000000000000000000000000000000000) }}, 
      {{ SC_(7.257815551757812500000000000000000000000e1), SC_(6.532033538818359375000000000000000000000e1), SC_(1.914333953857421875000000000000000000000e2), SC_(7.199030369520187377929687500000000000000e-2), SC_(6.054540667726739921324548182468022315727e-82), SC_(1.000000000000000000000000000000000000000) }}, 
      {{ SC_(7.257815551757812500000000000000000000000e1), SC_(7.185237121582031250000000000000000000000e1), SC_(4.420680999755859375000000000000000000000e1), SC_(1.420495659112930297851562500000000000000e-1), SC_(7.288026489029892047649306562952055445529e-32), SC_(9.999999999999999999999999999999271197351e-1) }}, 
      {{ SC_(7.257815551757812500000000000000000000000e1), SC_(7.185237121582031250000000000000000000000e1), SC_(1.357470245361328125000000000000000000000e2), SC_(1.652623564004898071289062500000000000000e-1), SC_(2.008479020224000195921229655231688827545e-41), SC_(1.000000000000000000000000000000000000000) }}, 
      {{ SC_(7.257815551757812500000000000000000000000e1), SC_(7.185237121582031250000000000000000000000e1), SC_(1.915013732910156250000000000000000000000e2), SC_(1.750861108303070068359375000000000000000e-1), SC_(6.483735685122101024634553416430010390183e-48), SC_(1.000000000000000000000000000000000000000) }}, 
      {{ SC_(7.257815551757812500000000000000000000000e1), SC_(7.250557708740234375000000000000000000000e1), SC_(5.569964599609375000000000000000000000000e1), SC_(2.901705801486968994140625000000000000000e-1), SC_(1.755923183904666705127512296791479809883e-13), SC_(9.999999999998244076816095333294872487703e-1) }}, 
      {{ SC_(7.257815551757812500000000000000000000000e1), SC_(7.250557708740234375000000000000000000000e1), SC_(1.362719116210937500000000000000000000000e2), SC_(3.297196626663208007812500000000000000000e-1), SC_(5.563952735103655219657271315664529822458e-18), SC_(9.999999999999999944360472648963447803427e-1) }}, 
      {{ SC_(7.257815551757812500000000000000000000000e1), SC_(7.250557708740234375000000000000000000000e1), SC_(1.918984832763671875000000000000000000000e2), SC_(3.493456840515136718750000000000000000000e-1), SC_(1.853431324804537548872648180335219860929e-21), SC_(9.999999999999999999981465686751954624511e-1) }}, 
      {{ SC_(7.257815551757812500000000000000000000000e1), SC_(7.257815551757812500000000000000000000000e1), SC_(5.940588760375976562500000000000000000000e1), SC_(4.383980035781860351562500000000000000000e-1), SC_(1.525057015276873963089693824137711085909e-4), SC_(9.998474942984723126036910306175862288914e-1) }}, 
      {{ SC_(7.257815551757812500000000000000000000000e1), SC_(7.257815551757812500000000000000000000000e1), SC_(1.451677856445312500000000000000000000000e2), SC_(4.996238946914672851562500000000000000000e-1), SC_(3.883841390299441744955408288082013649791e-6), SC_(9.999961161586097005582550445917119179864e-1) }}, 
      {{ SC_(7.257815551757812500000000000000000000000e1), SC_(7.257815551757812500000000000000000000000e1), SC_(1.929777069091796875000000000000000000000e2), SC_(5.243651866912841796875000000000000000000e-1), SC_(3.744206179999814672070160235576508465051e-7), SC_(9.999996255793820000185327929839764423492e-1) }}, 
      {{ SC_(7.257815551757812500000000000000000000000e1), SC_(7.258541107177734375000000000000000000000e1), SC_(6.038262176513671875000000000000000000000e1), SC_(5.270932912826538085937500000000000000000e-1), SC_(7.035874447852149688693045322655085764925e-2), SC_(9.296412555214785031130695467734491423508e-1) }}, 
      {{ SC_(7.257815551757812500000000000000000000000e1), SC_(7.258541107177734375000000000000000000000e1), SC_(1.481294555664062500000000000000000000000e2), SC_(6.015552282333374023437500000000000000000e-1), SC_(2.940821817181117050319125916325333642227e-2), SC_(9.705917818281888294968087408367466635777e-1) }}, 
      {{ SC_(7.257815551757812500000000000000000000000e1), SC_(7.258541107177734375000000000000000000000e1), SC_(1.935389862060546875000000000000000000000e2), SC_(6.295331120491027832031250000000000000000e-1), SC_(1.758277819883402233374016430821547090051e-2), SC_(9.824172218011659776662598356917845290995e-1) }}, 
      {{ SC_(7.257815551757812500000000000000000000000e1), SC_(7.265073394775390625000000000000000000000e1), SC_(6.163340759277343750000000000000000000000e1), SC_(5.810391902923583984375000000000000000000e-1), SC_(4.355770100464032193139107571057575584648e-1), SC_(5.644229899535967806860892428942424415352e-1) }}, 
      {{ SC_(7.257815551757812500000000000000000000000e1), SC_(7.265073394775390625000000000000000000000e1), SC_(1.486264953613281250000000000000000000000e2), SC_(6.618847846984863281250000000000000000000e-1), SC_(4.141247538063024644953578106200573961295e-1), SC_(5.858752461936975355046421893799426038705e-1) }}, 
      {{ SC_(7.257815551757812500000000000000000000000e1), SC_(7.265073394775390625000000000000000000000e1), SC_(1.937735595703125000000000000000000000000e2), SC_(6.924434900283813476562500000000000000000e-1), SC_(4.035868990137983914381158106532891183389e-1), SC_(5.964131009862016085618841893467108816611e-1) }}, 
      {{ SC_(7.257815551757812500000000000000000000000e1), SC_(7.330393981933593750000000000000000000000e1), SC_(7.225879669189453125000000000000000000000e1), SC_(5.962204933166503906250000000000000000000e-1), SC_(4.879117750563156036858207218973377803755e-1), SC_(5.120882249436843963141792781026622196245e-1) }}, 
      {{ SC_(7.257815551757812500000000000000000000000e1), SC_(7.330393981933593750000000000000000000000e1), SC_(1.515480346679687500000000000000000000000e2), SC_(6.681109666824340820312500000000000000000e-1), SC_(4.828737782617481215488971709967441767624e-1), SC_(5.171262217382518784511028290032558232376e-1) }}, 
      {{ SC_(7.257815551757812500000000000000000000000e1), SC_(7.330393981933593750000000000000000000000e1), SC_(1.941185607910156250000000000000000000000e2), SC_(6.970709562301635742187500000000000000000e-1), SC_(4.808369197000994087348932297900173340278e-1), SC_(5.191630802999005912651067702099826659722e-1) }}, 
      {{ SC_(7.257815551757812500000000000000000000000e1), SC_(7.983597564697265625000000000000000000000e1), SC_(9.566968083381652832031250000000000000000e-1), SC_(4.778186082839965820312500000000000000000e-1), SC_(5.009222453613130581418343054335349874383e-1), SC_(4.990777546386869418581656945664650125617e-1) }}, 
      {{ SC_(7.257815551757812500000000000000000000000e1), SC_(7.983597564697265625000000000000000000000e1), SC_(7.844540405273437500000000000000000000000e1), SC_(5.829547047615051269531250000000000000000e-1), SC_(4.946464912588584335383345872195912528584e-1), SC_(5.053535087411415664616654127804087471416e-1) }}, 
      {{ SC_(7.257815551757812500000000000000000000000e1), SC_(7.983597564697265625000000000000000000000e1), SC_(1.584414672851562500000000000000000000000e2), SC_(6.548280715942382812500000000000000000000e-1), SC_(4.913566960799946273693725538627452322159e-1), SC_(5.086433039200053726306274461372547677841e-1) }}, 
      {{ SC_(7.257815551757812500000000000000000000000e1), SC_(7.983597564697265625000000000000000000000e1), SC_(1.962219390869140625000000000000000000000e2), SC_(6.808272600173950195312500000000000000000e-1), SC_(4.903681932640381007566414071192024810894e-1), SC_(5.096318067359618992433585928807975189106e-1) }}, 
      {{ SC_(7.257815551757812500000000000000000000000e1), SC_(8.709378814697265625000000000000000000000e1), SC_(7.142335891723632812500000000000000000000), SC_(4.664599001407623291015625000000000000000e-1), SC_(5.017042740771785468542975363290394377055e-1), SC_(4.982957259228214531457024636709605622945e-1) }}, 
      {{ SC_(7.257815551757812500000000000000000000000e1), SC_(8.709378814697265625000000000000000000000e1), SC_(7.974770355224609375000000000000000000000e1), SC_(5.631464719772338867187500000000000000000e-1), SC_(4.959792341723751375079829624434818092859e-1), SC_(5.040207658276248624920170375565181907141e-1) }}, 
      {{ SC_(7.257815551757812500000000000000000000000e1), SC_(8.709378814697265625000000000000000000000e1), SC_(1.595857238769531250000000000000000000000e2), SC_(6.358284950256347656250000000000000000000e-1), SC_(4.926510869465492545294440201130159067385e-1), SC_(5.073489130534507454705559798869840932615e-1) }}, 
      {{ SC_(7.257815551757812500000000000000000000000e1), SC_(8.709378814697265625000000000000000000000e1), SC_(1.985762634277343750000000000000000000000e2), SC_(6.632144451141357421875000000000000000000e-1), SC_(4.916103968701185293659360082380879868658e-1), SC_(5.083896031298814706340639917619120131342e-1) }}, 
      {{ SC_(7.257815551757812500000000000000000000000e1), SC_(9.435160064697265625000000000000000000000e1), SC_(1.950807952880859375000000000000000000000e1), SC_(4.663529396057128906250000000000000000000e-1), SC_(5.062605491984783358392293578345752101350e-1), SC_(4.937394508015216641607706421654247898650e-1) }}, 
      {{ SC_(7.257815551757812500000000000000000000000e1), SC_(9.435160064697265625000000000000000000000e1), SC_(8.435225677490234375000000000000000000000e1), SC_(5.488014817237854003906250000000000000000e-1), SC_(5.009451078367393686485476540276229046457e-1), SC_(4.990548921632606313514523459723770953543e-1) }}, 
      {{ SC_(7.257815551757812500000000000000000000000e1), SC_(9.435160064697265625000000000000000000000e1), SC_(1.596211700439453125000000000000000000000e2), SC_(6.174889802932739257812500000000000000000e-1), SC_(4.975264072012106746183491306064712993850e-1), SC_(5.024735927987893253816508693935287006150e-1) }}, 
      {{ SC_(7.257815551757812500000000000000000000000e1), SC_(9.435160064697265625000000000000000000000e1), SC_(1.992922668457031250000000000000000000000e2), SC_(6.459188461303710937500000000000000000000e-1), SC_(4.963510641435827467181557298201173065309e-1), SC_(5.036489358564172532818442701798826934691e-1) }}, 
      {{ SC_(7.257815551757812500000000000000000000000e1), SC_(1.088672332763671875000000000000000000000e2), SC_(2.197235107421875000000000000000000000000e1), SC_(4.396900534629821777343750000000000000000e-1), SC_(5.619230190960852686835754296893203171714e-1), SC_(4.380769809039147313164245703106796828286e-1) }}, 
      {{ SC_(7.257815551757812500000000000000000000000e1), SC_(1.088672332763671875000000000000000000000e2), SC_(8.441753387451171875000000000000000000000e1), SC_(5.176467895507812500000000000000000000000e-1), SC_(5.504036204284233189740652315930116549019e-1), SC_(4.495963795715766810259347684069883450981e-1) }}, 
      {{ SC_(7.257815551757812500000000000000000000000e1), SC_(1.088672332763671875000000000000000000000e2), SC_(1.600560913085937500000000000000000000000e2), SC_(5.872792601585388183593750000000000000000e-1), SC_(5.432623183344088175213357779725685745641e-1), SC_(4.567376816655911824786642220274314254359e-1) }}, 
      {{ SC_(7.257815551757812500000000000000000000000e1), SC_(1.451563110351562500000000000000000000000e2), SC_(2.249290275573730468750000000000000000000e1), SC_(4.235825836658477783203125000000000000000e-1), SC_(9.573561292739125346935268329386749653125e-1), SC_(4.264387072608746530647316706132503468751e-2) }}, 
      {{ SC_(7.257815551757812500000000000000000000000e1), SC_(1.451563110351562500000000000000000000000e2), SC_(9.495173645019531250000000000000000000000e1), SC_(5.020957589149475097656250000000000000000e-1), SC_(9.304838901657787227493783451419722142915e-1), SC_(6.951610983422127725062165485802778570849e-2) }}, 
      {{ SC_(7.257815551757812500000000000000000000000e1), SC_(1.451563110351562500000000000000000000000e2), SC_(1.629447326660156250000000000000000000000e2), SC_(5.585649609565734863281250000000000000000e-1), SC_(9.146599805000504144218304386709730788597e-1), SC_(8.534001949994958557816956132902692114032e-2) }}, 
      {{ SC_(7.257815551757812500000000000000000000000e1), SC_(2.177344665527343750000000000000000000000e2), SC_(2.539736366271972656250000000000000000000e1), SC_(4.011098742485046386718750000000000000000e-1), SC_(9.999852650129048666245685985404152944595e-1), SC_(1.473498709513337543140145958470554053006e-5) }}, 
      {{ SC_(7.257815551757812500000000000000000000000e1), SC_(2.177344665527343750000000000000000000000e2), SC_(9.707512664794921875000000000000000000000e1), SC_(4.642998874187469482421875000000000000000e-1), SC_(9.998540707517528674904688510640803834954e-1), SC_(1.459292482471325095311489359196165045990e-4) }}, 
      {{ SC_(7.257815551757812500000000000000000000000e1), SC_(2.177344665527343750000000000000000000000e2), SC_(1.670017089843750000000000000000000000000e2), SC_(5.143197774887084960937500000000000000000e-1), SC_(9.995915985893641273382196958456265524800e-1), SC_(4.084014106358726617803041543734475200310e-4) }}, 
      {{ SC_(7.257815551757812500000000000000000000000e1), SC_(2.903126220703125000000000000000000000000e2), SC_(2.709540176391601562500000000000000000000e1), SC_(4.067058265209197998046875000000000000000e-1), SC_(9.999999999985510052559965025603157891609e-1), SC_(1.448994744003497439684210839111323323628e-12) }}, 
      {{ SC_(7.257815551757812500000000000000000000000e1), SC_(2.903126220703125000000000000000000000000e2), SC_(1.007325439453125000000000000000000000000e2), SC_(4.594568610191345214843750000000000000000e-1), SC_(9.999999994868813034060782004192784515660e-1), SC_(5.131186965939217995807215484339815222898e-10) }}, 
      {{ SC_(7.257815551757812500000000000000000000000e1), SC_(2.903126220703125000000000000000000000000e2), SC_(1.698258666992187500000000000000000000000e2), SC_(5.010939836502075195312500000000000000000e-1), SC_(9.999999927789635270758104111786329058125e-1), SC_(7.221036472924189588821367094187492909924e-9) }}, 
      {{ SC_(7.257815551757812500000000000000000000000e1), SC_(3.628907775878906250000000000000000000000e2), SC_(2.837726783752441406250000000000000000000e1), SC_(4.619368612766265869140625000000000000000e-1), SC_(9.999999999999999999999999999987693453465e-1), SC_(1.230654653496300755860866612534832517019e-30) }}, 
      {{ SC_(7.257815551757812500000000000000000000000e1), SC_(3.628907775878906250000000000000000000000e2), SC_(1.093762969970703125000000000000000000000e2), SC_(5.063169002532958984375000000000000000000e-1), SC_(9.999999999999999999999981204838760611220e-1), SC_(1.879516123938878002057084364074667728261e-24) }}, 
      {{ SC_(7.257815551757812500000000000000000000000e1), SC_(3.628907775878906250000000000000000000000e2), SC_(1.756861267089843750000000000000000000000e2), SC_(5.375516414642333984375000000000000000000e-1), SC_(9.999999999999999999993428201657699413563e-1), SC_(6.571798342300586436930775283950640695549e-22) }}, 
      {{ SC_(8.004833984375000000000000000000000000000e1), SC_(8.004834175109863281250000000000000000000), SC_(2.539736366271972656250000000000000000000e1), SC_(9.602248072624206542968750000000000000000e-1), SC_(9.540521104693981894214405190380269122070e-1), SC_(4.594788953060181057855948096197308779298e-2) }}, 
      {{ SC_(8.004833984375000000000000000000000000000e1), SC_(8.004834175109863281250000000000000000000), SC_(9.707512664794921875000000000000000000000e1), SC_(9.706214666366577148437500000000000000000e-1), SC_(9.517242176334103141263534459310448988488e-1), SC_(4.827578236658968587364655406895510115122e-2) }}, 
      {{ SC_(8.004833984375000000000000000000000000000e1), SC_(8.004834175109863281250000000000000000000), SC_(1.670017089843750000000000000000000000000e2), SC_(9.766034483909606933593750000000000000000e-1), SC_(9.507023478464996886709499165492476779859e-1), SC_(4.929765215350031132905008345075232201406e-2) }}, 
      {{ SC_(8.004833984375000000000000000000000000000e1), SC_(2.001208496093750000000000000000000000000e1), SC_(2.709540176391601562500000000000000000000e1), SC_(9.412216544151306152343750000000000000000e-1), SC_(9.999901095669366635294538555486657891072e-1), SC_(9.890433063336470546144451334210892802145e-6) }}, 
      {{ SC_(8.004833984375000000000000000000000000000e1), SC_(2.001208496093750000000000000000000000000e1), SC_(1.007325439453125000000000000000000000000e2), SC_(9.555561542510986328125000000000000000000e-1), SC_(9.999855447212504720204756889025896638289e-1), SC_(1.445527874952797952431109741033617107084e-5) }}, 
      {{ SC_(8.004833984375000000000000000000000000000e1), SC_(2.001208496093750000000000000000000000000e1), SC_(1.698258666992187500000000000000000000000e2), SC_(9.638475179672241210937500000000000000000e-1), SC_(9.999830584268799981469865441329167682787e-1), SC_(1.694157312000185301345586708323172131317e-5) }}, 
      {{ SC_(8.004833984375000000000000000000000000000e1), SC_(4.002416992187500000000000000000000000000e1), SC_(2.837726783752441406250000000000000000000e1), SC_(9.254146218299865722656250000000000000000e-1), SC_(9.999999999999793162358304343658306425339e-1), SC_(2.068376416956563416935746607303093724891e-14) }}, 
      {{ SC_(8.004833984375000000000000000000000000000e1), SC_(4.002416992187500000000000000000000000000e1), SC_(1.093762969970703125000000000000000000000e2), SC_(9.426417946815490722656250000000000000000e-1), SC_(9.999999999998953877591049652827241923269e-1), SC_(1.046122408950347172758076731154083285875e-13) }}, 
      {{ SC_(8.004833984375000000000000000000000000000e1), SC_(4.002416992187500000000000000000000000000e1), SC_(1.756861267089843750000000000000000000000e2), SC_(9.517766833305358886718750000000000000000e-1), SC_(9.999999999998084454577088360524040185349e-1), SC_(1.915545422911639475959814651259096188223e-13) }}, 
      {{ SC_(8.004833984375000000000000000000000000000e1), SC_(6.003625488281250000000000000000000000000e1), SC_(3.152261734008789062500000000000000000000e1), SC_(9.229043126106262207031250000000000000000e-1), SC_(9.999999999999999999999999820464636375858e-1), SC_(1.795353636241424158477547345783949555209e-26) }}, 
      {{ SC_(8.004833984375000000000000000000000000000e1), SC_(6.003625488281250000000000000000000000000e1), SC_(1.094441146850585937500000000000000000000e2), SC_(9.382743835449218750000000000000000000000e-1), SC_(9.999999999999999999999995021945142353941e-1), SC_(4.978054857646058984870362516035478458139e-25) }}, 
      {{ SC_(8.004833984375000000000000000000000000000e1), SC_(6.003625488281250000000000000000000000000e1), SC_(1.811583862304687500000000000000000000000e2), SC_(9.478561878204345703125000000000000000000e-1), SC_(9.999999999999999999999978863886399951646e-1), SC_(2.113611360004835378401893742419839565522e-24) }}, 
      {{ SC_(8.004833984375000000000000000000000000000e1), SC_(7.204350280761718750000000000000000000000e1), SC_(3.423733520507812500000000000000000000000e1), SC_(5.739828944206237792968750000000000000000e-2), SC_(2.468490742906346298655696392469273257615e-64), SC_(1.000000000000000000000000000000000000000) }}, 
      {{ SC_(8.004833984375000000000000000000000000000e1), SC_(7.204350280761718750000000000000000000000e1), SC_(1.264718551635742187500000000000000000000e2), SC_(6.649677455425262451171875000000000000000e-2), SC_(5.519178503617831837499122121601877295099e-77), SC_(1.000000000000000000000000000000000000000) }}, 
      {{ SC_(8.004833984375000000000000000000000000000e1), SC_(7.204350280761718750000000000000000000000e1), SC_(1.826751708984375000000000000000000000000e2), SC_(7.035915553569793701171875000000000000000e-2), SC_(1.246280386423522623148799251967672117977e-85), SC_(1.000000000000000000000000000000000000000) }}, 
      {{ SC_(8.004833984375000000000000000000000000000e1), SC_(7.924785614013671875000000000000000000000e1), SC_(3.477303314208984375000000000000000000000e1), SC_(1.378045380115509033203125000000000000000e-1), SC_(1.109233710125116652022433548641069801456e-33), SC_(9.999999999999999999999999999999988907663e-1) }}, 
      {{ SC_(8.004833984375000000000000000000000000000e1), SC_(7.924785614013671875000000000000000000000e1), SC_(1.279526672363281250000000000000000000000e2), SC_(1.611516773700714111328125000000000000000e-1), SC_(4.669726817709394888378415969763369146224e-43), SC_(1.000000000000000000000000000000000000000) }}, 
      {{ SC_(8.004833984375000000000000000000000000000e1), SC_(7.924785614013671875000000000000000000000e1), SC_(1.831471099853515625000000000000000000000e2), SC_(1.709119826555252075195312500000000000000e-1), SC_(2.523647039275842337353960285704781276118e-49), SC_(1.000000000000000000000000000000000000000) }}, 
      {{ SC_(8.004833984375000000000000000000000000000e1), SC_(7.996829223632812500000000000000000000000e1), SC_(3.767639541625976562500000000000000000000e1), SC_(2.763119339942932128906250000000000000000e-1), SC_(1.561214228319882875684561009605091740811e-13), SC_(9.999999999998438785771680117124315438990e-1) }}, 
      {{ SC_(8.004833984375000000000000000000000000000e1), SC_(7.996829223632812500000000000000000000000e1), SC_(1.310955810546875000000000000000000000000e2), SC_(3.225089907646179199218750000000000000000e-1), SC_(1.676784661302445775692353274022660342807e-18), SC_(9.999999999999999983232153386975542243076e-1) }}, 
      {{ SC_(8.004833984375000000000000000000000000000e1), SC_(7.996829223632812500000000000000000000000e1), SC_(1.867986450195312500000000000000000000000e2), SC_(3.419898450374603271484375000000000000000e-1), SC_(6.910877412028717488703104776878797242748e-22), SC_(9.999999999999999999993089122587971282511e-1) }}, 
      {{ SC_(8.004833984375000000000000000000000000000e1), SC_(8.004833984375000000000000000000000000000e1), SC_(4.238486480712890625000000000000000000000e1), SC_(4.186233878135681152343750000000000000000e-1), SC_(1.738191114343775375636146069677709826750e-4), SC_(9.998261808885656224624363853930322290173e-1) }}, 
      {{ SC_(8.004833984375000000000000000000000000000e1), SC_(8.004833984375000000000000000000000000000e1), SC_(1.311481323242187500000000000000000000000e2), SC_(4.836227297782897949218750000000000000000e-1), SC_(4.985724541138918848030496592600365723574e-6), SC_(9.999950142754588610811519695034073996343e-1) }}, 
      {{ SC_(8.004833984375000000000000000000000000000e1), SC_(8.004833984375000000000000000000000000000e1), SC_(1.914333953857421875000000000000000000000e2), SC_(5.149689912796020507812500000000000000000e-1), SC_(2.970359861823640828649735150157876525392e-7), SC_(9.999997029640138176359171350264849842123e-1) }}, 
      {{ SC_(8.004833984375000000000000000000000000000e1), SC_(8.005634307861328125000000000000000000000e1), SC_(4.420680999755859375000000000000000000000e1), SC_(5.043058395385742187500000000000000000000e-1), SC_(7.377996266544780796192885371526657501011e-2), SC_(9.262200373345521920380711462847334249899e-1) }}, 
      {{ SC_(8.004833984375000000000000000000000000000e1), SC_(8.005634307861328125000000000000000000000e1), SC_(1.357470245361328125000000000000000000000e2), SC_(5.835451483726501464843750000000000000000e-1), SC_(3.164464261899620987832594922867996153708e-2), SC_(9.683553573810037901216740507713200384629e-1) }}, 
      {{ SC_(8.004833984375000000000000000000000000000e1), SC_(8.005634307861328125000000000000000000000e1), SC_(1.915013732910156250000000000000000000000e2), SC_(6.179808974266052246093750000000000000000e-1), SC_(1.740610953107099650660306486382401761960e-2), SC_(9.825938904689290034933969351361759823804e-1) }}, 
      {{ SC_(8.004833984375000000000000000000000000000e1), SC_(8.012839508056640625000000000000000000000e1), SC_(5.569964599609375000000000000000000000000e1), SC_(5.677745342254638671875000000000000000000e-1), SC_(4.358514500822524675054226955238909227096e-1), SC_(5.641485499177475324945773044761090772904e-1) }}, 
      {{ SC_(8.004833984375000000000000000000000000000e1), SC_(8.012839508056640625000000000000000000000e1), SC_(1.362719116210937500000000000000000000000e2), SC_(6.420964002609252929687500000000000000000e-1), SC_(4.169609841018826670194523768939955385481e-1), SC_(5.830390158981173329805476231060044614519e-1) }}, 
      {{ SC_(8.004833984375000000000000000000000000000e1), SC_(8.012839508056640625000000000000000000000e1), SC_(1.918984832763671875000000000000000000000e2), SC_(6.798278689384460449218750000000000000000e-1), SC_(4.045780114064151042526762563748400585863e-1), SC_(5.954219885935848957473237436251599414137e-1) }}, 
      {{ SC_(8.004833984375000000000000000000000000000e1), SC_(8.084882354736328125000000000000000000000e1), SC_(5.940588760375976562500000000000000000000e1), SC_(5.748973488807678222656250000000000000000e-1), SC_(4.893921542549370539259394941178584928629e-1), SC_(5.106078457450629460740605058821415071371e-1) }}, 
      {{ SC_(8.004833984375000000000000000000000000000e1), SC_(8.084882354736328125000000000000000000000e1), SC_(1.451677856445312500000000000000000000000e2), SC_(6.526099443435668945312500000000000000000e-1), SC_(4.839964293796737653654066356154011346602e-1), SC_(5.160035706203262346345933643845988653398e-1) }}, 
      {{ SC_(8.004833984375000000000000000000000000000e1), SC_(8.084882354736328125000000000000000000000e1), SC_(1.929777069091796875000000000000000000000e2), SC_(6.847420334815979003906250000000000000000e-1), SC_(4.817712641092908023071697528676161887974e-1), SC_(5.182287358907091976928302471323838112026e-1) }}, 
      {{ SC_(8.004833984375000000000000000000000000000e1), SC_(8.805317687988281250000000000000000000000e1), SC_(6.038262176513671875000000000000000000000e1), SC_(5.556027293205261230468750000000000000000e-1), SC_(4.963097349699660710380666418555300715423e-1), SC_(5.036902650300339289619333581444699284577e-1) }}, 
      {{ SC_(8.004833984375000000000000000000000000000e1), SC_(8.805317687988281250000000000000000000000e1), SC_(1.481294555664062500000000000000000000000e2), SC_(6.359344720840454101562500000000000000000e-1), SC_(4.925161529455987343174182908512683315456e-1), SC_(5.074838470544012656825817091487316684544e-1) }}, 
      {{ SC_(8.004833984375000000000000000000000000000e1), SC_(8.805317687988281250000000000000000000000e1), SC_(1.935389862060546875000000000000000000000e2), SC_(6.671035289764404296875000000000000000000e-1), SC_(4.913137698472864269840760056203252488938e-1), SC_(5.086862301527135730159239943796747511062e-1) }}, 
      {{ SC_(8.004833984375000000000000000000000000000e1), SC_(9.605801391601562500000000000000000000000e1), SC_(6.163340759277343750000000000000000000000e1), SC_(5.354914069175720214843750000000000000000e-1), SC_(4.976419203069481719171597228901125205275e-1), SC_(5.023580796930518280828402771098874794725e-1) }}, 
      {{ SC_(8.004833984375000000000000000000000000000e1), SC_(9.605801391601562500000000000000000000000e1), SC_(1.486264953613281250000000000000000000000e2), SC_(6.159955859184265136718750000000000000000e-1), SC_(4.938301326568947594000306641333592017937e-1), SC_(5.061698673431052405999693358666407982063e-1) }}, 
      {{ SC_(8.004833984375000000000000000000000000000e1), SC_(9.605801391601562500000000000000000000000e1), SC_(1.937735595703125000000000000000000000000e2), SC_(6.477080583572387695312500000000000000000e-1), SC_(4.926008078887687801249538938312063613492e-1), SC_(5.073991921112312198750461061687936386508e-1) }}, 
      {{ SC_(8.004833984375000000000000000000000000000e1), SC_(1.040628356933593750000000000000000000000e2), SC_(7.225879669189453125000000000000000000000e1), SC_(5.276243090629577636718750000000000000000e-1), SC_(5.025655342023486462005049581368116056027e-1), SC_(4.974344657976513537994950418631883943973e-1) }}, 
      {{ SC_(8.004833984375000000000000000000000000000e1), SC_(1.040628356933593750000000000000000000000e2), SC_(1.515480346679687500000000000000000000000e2), SC_(5.995327830314636230468750000000000000000e-1), SC_(4.988663432639080593729477481928330071647e-1), SC_(5.011336567360919406270522518071669928353e-1) }}, 
      {{ SC_(8.004833984375000000000000000000000000000e1), SC_(1.040628356933593750000000000000000000000e2), SC_(1.941185607910156250000000000000000000000e2), SC_(6.298099756240844726562500000000000000000e-1), SC_(4.975803981292017276826518048881768965289e-1), SC_(5.024196018707982723173481951118231034711e-1) }}, 
      {{ SC_(8.004833984375000000000000000000000000000e1), SC_(1.200725097656250000000000000000000000000e2), SC_(9.566968083381652832031250000000000000000e-1), SC_(4.073501229286193847656250000000000000000e-1), SC_(5.713726341831453349101284921095200721070e-1), SC_(4.286273658168546650898715078904799278930e-1) }}, 
      {{ SC_(8.004833984375000000000000000000000000000e1), SC_(1.200725097656250000000000000000000000000e2), SC_(7.844540405273437500000000000000000000000e1), SC_(5.029526948928833007812500000000000000000e-1), SC_(5.550157464960639520882279778430586023122e-1), SC_(4.449842535039360479117720221569413976878e-1) }}, 
      {{ SC_(8.004833984375000000000000000000000000000e1), SC_(1.200725097656250000000000000000000000000e2), SC_(1.584414672851562500000000000000000000000e2), SC_(5.739826560020446777343750000000000000000e-1), SC_(5.471720908819731806706213992939248481511e-1), SC_(4.528279091180268193293786007060751518489e-1) }}, 
      {{ SC_(8.004833984375000000000000000000000000000e1), SC_(1.200725097656250000000000000000000000000e2), SC_(1.962219390869140625000000000000000000000e2), SC_(6.009318232536315917968750000000000000000e-1), SC_(5.448163058977036772596303592664710845837e-1), SC_(4.551836941022963227403696407335289154163e-1) }}, 
      {{ SC_(8.004833984375000000000000000000000000000e1), SC_(1.600966796875000000000000000000000000000e2), SC_(7.142335891723632812500000000000000000000), SC_(4.027841091156005859375000000000000000000e-1), SC_(9.716833920981190222656820736451923398081e-1), SC_(2.831660790188097773431792635480766019194e-2) }}, 
      {{ SC_(8.004833984375000000000000000000000000000e1), SC_(1.600966796875000000000000000000000000000e2), SC_(7.974770355224609375000000000000000000000e1), SC_(4.799762964248657226562500000000000000000e-1), SC_(9.464040962555451521824711874676917446713e-1), SC_(5.359590374445484781752881253230825532874e-2) }}, 
      {{ SC_(8.004833984375000000000000000000000000000e1), SC_(1.600966796875000000000000000000000000000e2), SC_(1.595857238769531250000000000000000000000e2), SC_(5.447369813919067382812500000000000000000e-1), SC_(9.284361340116963809042565743908273330110e-1), SC_(7.156386598830361909574342560917266698903e-2) }}, 
      {{ SC_(8.004833984375000000000000000000000000000e1), SC_(1.600966796875000000000000000000000000000e2), SC_(1.985762634277343750000000000000000000000e2), SC_(5.708496570587158203125000000000000000000e-1), SC_(9.221110701101821171061706414996171094535e-1), SC_(7.788892988981788289382935850038289054647e-2) }}, 
      {{ SC_(8.004833984375000000000000000000000000000e1), SC_(2.401450195312500000000000000000000000000e2), SC_(1.950807952880859375000000000000000000000e1), SC_(3.934221863746643066406250000000000000000e-1), SC_(9.999963850925964007700857597386231537688e-1), SC_(3.614907403599229914240261376846231213624e-6) }}, 
      {{ SC_(8.004833984375000000000000000000000000000e1), SC_(2.401450195312500000000000000000000000000e2), SC_(8.435225677490234375000000000000000000000e1), SC_(4.475663006305694580078125000000000000000e-1), SC_(9.999569998319848340823737137628811531877e-1), SC_(4.300016801516591762628623711884681231251e-5) }}, 
      {{ SC_(8.004833984375000000000000000000000000000e1), SC_(2.401450195312500000000000000000000000000e2), SC_(1.596211700439453125000000000000000000000e2), SC_(4.994532763957977294921875000000000000000e-1), SC_(9.998352869547726781602721435604326159319e-1), SC_(1.647130452273218397278564395673840680969e-4) }}, 
      {{ SC_(8.004833984375000000000000000000000000000e1), SC_(2.401450195312500000000000000000000000000e2), SC_(1.992922668457031250000000000000000000000e2), SC_(5.230701565742492675781250000000000000000e-1), SC_(9.997436811815795723091693793973849894575e-1), SC_(2.563188184204276908306206026150105424747e-4) }}, 
      {{ SC_(8.004833984375000000000000000000000000000e1), SC_(3.201933593750000000000000000000000000000e2), SC_(2.197235107421875000000000000000000000000e1), SC_(4.010167717933654785156250000000000000000e-1), SC_(9.999999999999610069803425091803044378368e-1), SC_(3.899301965749081969556216319097961058748e-14) }}, 
      {{ SC_(8.004833984375000000000000000000000000000e1), SC_(3.201933593750000000000000000000000000000e2), SC_(8.441753387451171875000000000000000000000e1), SC_(4.432016313076019287109375000000000000000e-1), SC_(9.999999999843430194378116447848604246951e-1), SC_(1.565698056218835521513957530492194390512e-11) }}, 
      {{ SC_(8.004833984375000000000000000000000000000e1), SC_(3.201933593750000000000000000000000000000e2), SC_(1.600560913085937500000000000000000000000e2), SC_(4.869798719882965087890625000000000000000e-1), SC_(9.999999994402979792609277091205948867832e-1), SC_(5.597020207390722908794051132167790990484e-10) }}, 
      {{ SC_(8.004833984375000000000000000000000000000e1), SC_(4.002416992187500000000000000000000000000e2), SC_(2.249290275573730468750000000000000000000e1), SC_(4.571304023265838623046875000000000000000e-1), SC_(9.999999999999999999999999999999999017758e-1), SC_(9.822420728218051531459220981441373868268e-35) }}, 
      {{ SC_(8.004833984375000000000000000000000000000e1), SC_(4.002416992187500000000000000000000000000e2), SC_(9.495173645019531250000000000000000000000e1), SC_(4.943339824676513671875000000000000000000e-1), SC_(9.999999999999999999999999996313246585540e-1), SC_(3.686753414459752127659615050683247456691e-28) }}, 
      {{ SC_(8.004833984375000000000000000000000000000e1), SC_(4.002416992187500000000000000000000000000e2), SC_(1.629447326660156250000000000000000000000e2), SC_(5.248939990997314453125000000000000000000e-1), SC_(9.999999999999999999999994487607538181502e-1), SC_(5.512392461818497839579687536970944670199e-25) }}, 
      {{ SC_(8.464137268066406250000000000000000000000e1), SC_(8.464137077331542968750000000000000000000), SC_(1.950807952880859375000000000000000000000e1), SC_(9.588179588317871093750000000000000000000e-1), SC_(9.593714214414843085318225306106548261694e-1), SC_(4.062857855851569146817746938934517383061e-2) }}, 
      {{ SC_(8.464137268066406250000000000000000000000e1), SC_(8.464137077331542968750000000000000000000), SC_(8.435225677490234375000000000000000000000e1), SC_(9.686444997787475585937500000000000000000e-1), SC_(9.572292517661523530621676366481193336720e-1), SC_(4.277074823384764693783236335188066632797e-2) }}, 
      {{ SC_(8.464137268066406250000000000000000000000e1), SC_(8.464137077331542968750000000000000000000), SC_(1.596211700439453125000000000000000000000e2), SC_(9.754599332809448242187500000000000000000e-1), SC_(9.560826493429826712225711033263344194884e-1), SC_(4.391735065701732877742889667366558051161e-2) }}, 
      {{ SC_(8.464137268066406250000000000000000000000e1), SC_(8.464137077331542968750000000000000000000), SC_(1.992922668457031250000000000000000000000e2), SC_(9.779850244522094726562500000000000000000e-1), SC_(9.557287429851304894398311849065813734858e-1), SC_(4.427125701486951056016881509341862651420e-2) }}, 
      {{ SC_(8.464137268066406250000000000000000000000e1), SC_(2.116034317016601562500000000000000000000e1), SC_(2.197235107421875000000000000000000000000e1), SC_(9.395560026168823242187500000000000000000e-1), SC_(9.999946916380259779614152158318752885670e-1), SC_(5.308361974022038584784168124711433046049e-6) }}, 
      {{ SC_(8.464137268066406250000000000000000000000e1), SC_(2.116034317016601562500000000000000000000e1), SC_(8.441753387451171875000000000000000000000e1), SC_(9.522531032562255859375000000000000000000e-1), SC_(9.999922553435611551561947266899003365044e-1), SC_(7.744656438844843805273310099663495596982e-6) }}, 
      {{ SC_(8.464137268066406250000000000000000000000e1), SC_(2.116034317016601562500000000000000000000e1), SC_(1.600560913085937500000000000000000000000e2), SC_(9.619555473327636718750000000000000000000e-1), SC_(9.999904356992810448535983816143966383456e-1), SC_(9.564300718955146401618385603361654350788e-6) }}, 
      {{ SC_(8.464137268066406250000000000000000000000e1), SC_(4.232068634033203125000000000000000000000e1), SC_(2.249290275573730468750000000000000000000e1), SC_(9.234026670455932617187500000000000000000e-1), SC_(9.999999999999970297616362850598608103571e-1), SC_(2.970238363714940139189642877334732400691e-15) }}, 
      {{ SC_(8.464137268066406250000000000000000000000e1), SC_(4.232068634033203125000000000000000000000e1), SC_(9.495173645019531250000000000000000000000e1), SC_(9.392524361610412597656250000000000000000e-1), SC_(9.999999999999839211140710936776363348510e-1), SC_(1.607888592890632236366514898202952403957e-14) }}, 
      {{ SC_(8.464137268066406250000000000000000000000e1), SC_(4.232068634033203125000000000000000000000e1), SC_(1.629447326660156250000000000000000000000e2), SC_(9.491446018218994140625000000000000000000e-1), SC_(9.999999999999660353964318412251947001008e-1), SC_(3.396460356815877480529989916145376377923e-14) }}, 
      {{ SC_(8.464137268066406250000000000000000000000e1), SC_(6.348102951049804687500000000000000000000e1), SC_(2.539736366271972656250000000000000000000e1), SC_(9.210150837898254394531250000000000000000e-1), SC_(9.999999999999999999999999996059076036364e-1), SC_(3.940923963635972608587081617177871396185e-28) }}, 
      {{ SC_(8.464137268066406250000000000000000000000e1), SC_(6.348102951049804687500000000000000000000e1), SC_(9.707512664794921875000000000000000000000e1), SC_(9.353597760200500488281250000000000000000e-1), SC_(9.999999999999999999999999867149309706863e-1), SC_(1.328506902931365069402545330677064073036e-26) }}, 
      {{ SC_(8.464137268066406250000000000000000000000e1), SC_(6.348102951049804687500000000000000000000e1), SC_(1.670017089843750000000000000000000000000e2), SC_(9.451006650924682617187500000000000000000e-1), SC_(9.999999999999999999999999288974054172072e-1), SC_(7.110259458279279681839979016987762798598e-26) }}, 
      {{ SC_(8.464137268066406250000000000000000000000e1), SC_(7.617723083496093750000000000000000000000e1), SC_(2.709540176391601562500000000000000000000e1), SC_(5.629248544573783874511718750000000000000e-2), SC_(7.802128952229075857839049339730277783649e-67), SC_(1.000000000000000000000000000000000000000) }}, 
      {{ SC_(8.464137268066406250000000000000000000000e1), SC_(7.617723083496093750000000000000000000000e1), SC_(1.007325439453125000000000000000000000000e2), SC_(6.388791650533676147460937500000000000000e-2), SC_(1.809038723790718076130919932419009265755e-76), SC_(1.000000000000000000000000000000000000000) }}, 
      {{ SC_(8.464137268066406250000000000000000000000e1), SC_(7.617723083496093750000000000000000000000e1), SC_(1.698258666992187500000000000000000000000e2), SC_(6.895621865987777709960937500000000000000e-2), SC_(8.877437106201225956283619552493480175408e-87), SC_(1.000000000000000000000000000000000000000) }}, 
      {{ SC_(8.464137268066406250000000000000000000000e1), SC_(8.379496002197265625000000000000000000000e1), SC_(2.837726783752441406250000000000000000000e1), SC_(1.352421343326568603515625000000000000000e-1), SC_(8.862472993597714779696866873650311103724e-35), SC_(9.999999999999999999999999999999999113753e-1) }}, 
      {{ SC_(8.464137268066406250000000000000000000000e1), SC_(8.379496002197265625000000000000000000000e1), SC_(1.093762969970703125000000000000000000000e2), SC_(1.560087352991104125976562500000000000000e-1), SC_(1.289078680164823335077009437308830824396e-42), SC_(1.000000000000000000000000000000000000000) }}, 
      {{ SC_(8.464137268066406250000000000000000000000e1), SC_(8.379496002197265625000000000000000000000e1), SC_(1.756861267089843750000000000000000000000e2), SC_(1.681488752365112304687500000000000000000e-1), SC_(5.869568214607064010947255343373628953113e-50), SC_(1.000000000000000000000000000000000000000) }}, 
      {{ SC_(8.464137268066406250000000000000000000000e1), SC_(8.455673217773437500000000000000000000000e1), SC_(3.152261734008789062500000000000000000000e1), SC_(2.713128328323364257812500000000000000000e-1), SC_(7.914752337529879091099997145003903511850e-14), SC_(9.999999999999208524766247012090890000285e-1) }}, 
      {{ SC_(8.464137268066406250000000000000000000000e1), SC_(8.455673217773437500000000000000000000000e1), SC_(1.094441146850585937500000000000000000000e2), SC_(3.109839260578155517578125000000000000000e-1), SC_(8.601156445582454729581277641165321494305e-18), SC_(9.999999999999999913988435544175452704187e-1) }}, 
      {{ SC_(8.464137268066406250000000000000000000000e1), SC_(8.455673217773437500000000000000000000000e1), SC_(1.811583862304687500000000000000000000000e2), SC_(3.370330631732940673828125000000000000000e-1), SC_(5.152069407447772003061394905418094213063e-22), SC_(9.999999999999999999994847930592552227997e-1) }}, 
      {{ SC_(8.464137268066406250000000000000000000000e1), SC_(8.464137268066406250000000000000000000000e1), SC_(3.423733520507812500000000000000000000000e1), SC_(4.092713594436645507812500000000000000000e-1), SC_(1.686679392249735970314715972978110098380e-4), SC_(9.998313320607750264029685284027021889902e-1) }}, 
      {{ SC_(8.464137268066406250000000000000000000000e1), SC_(8.464137268066406250000000000000000000000e1), SC_(1.264718551635742187500000000000000000000e2), SC_(4.766659140586853027343750000000000000000e-1), SC_(4.742200759950908986146287276444535601175e-6), SC_(9.999952577992400490910138537127235554644e-1) }}, 
      {{ SC_(8.464137268066406250000000000000000000000e1), SC_(8.464137268066406250000000000000000000000e1), SC_(1.826751708984375000000000000000000000000e2), SC_(5.060957670211791992187500000000000000000e-1), SC_(3.685329409092298325376188382177135590882e-7), SC_(9.999996314670590907701674623811617822864e-1) }}, 
      {{ SC_(8.464137268066406250000000000000000000000e1), SC_(8.464984130859375000000000000000000000000e1), SC_(3.477303314208984375000000000000000000000e1), SC_(4.916874170303344726562500000000000000000e-1), SC_(7.505847803088233967838980371637659828126e-2), SC_(9.249415219691176603216101962836234017187e-1) }}, 
      {{ SC_(8.464137268066406250000000000000000000000e1), SC_(8.464984130859375000000000000000000000000e1), SC_(1.279526672363281250000000000000000000000e2), SC_(5.730173587799072265625000000000000000000e-1), SC_(3.287035004086092403281806543722749356620e-2), SC_(9.671296499591390759671819345627725064338e-1) }}, 
      {{ SC_(8.464137268066406250000000000000000000000e1), SC_(8.464984130859375000000000000000000000000e1), SC_(1.831471099853515625000000000000000000000e2), SC_(6.075596213340759277343750000000000000000e-1), SC_(1.859018827965749209906876500967461126737e-2), SC_(9.814098117203425079009312349903253887326e-1) }}, 
      {{ SC_(8.464137268066406250000000000000000000000e1), SC_(8.472602081298828125000000000000000000000e1), SC_(3.767639541625976562500000000000000000000e1), SC_(5.440866947174072265625000000000000000000e-1), SC_(4.392945984544640138242225985820149098184e-1), SC_(5.607054015455359861757774014179850901816e-1) }}, 
      {{ SC_(8.464137268066406250000000000000000000000e1), SC_(8.472602081298828125000000000000000000000e1), SC_(1.310955810546875000000000000000000000000e2), SC_(6.325161457061767578125000000000000000000e-1), SC_(4.179271415170554382596106674064576123089e-1), SC_(5.820728584829445617403893325935423876911e-1) }}, 
      {{ SC_(8.464137268066406250000000000000000000000e1), SC_(8.472602081298828125000000000000000000000e1), SC_(1.867986450195312500000000000000000000000e2), SC_(6.703543663024902343750000000000000000000e-1), SC_(4.058607545303382646551834545261674841975e-1), SC_(5.941392454696617353448165454738325158025e-1) }}, 
      {{ SC_(8.464137268066406250000000000000000000000e1), SC_(8.548778533935546875000000000000000000000e1), SC_(4.238486480712890625000000000000000000000e1), SC_(5.523607134819030761718750000000000000000e-1), SC_(4.909401058885401017501234955125839880855e-1), SC_(5.090598941114598982498765044874160119145e-1) }}, 
      {{ SC_(8.464137268066406250000000000000000000000e1), SC_(8.548778533935546875000000000000000000000e1), SC_(1.311481323242187500000000000000000000000e2), SC_(6.362425684928894042968750000000000000000e-1), SC_(4.851211110097423599111654828701321135706e-1), SC_(5.148788889902576400888345171298678864294e-1) }}, 
      {{ SC_(8.464137268066406250000000000000000000000e1), SC_(8.548778533935546875000000000000000000000e1), SC_(1.914333953857421875000000000000000000000e2), SC_(6.773175001144409179687500000000000000000e-1), SC_(4.823045426816291584900544819279472401177e-1), SC_(5.176954573183708415099455180720527598823e-1) }}, 
      {{ SC_(8.464137268066406250000000000000000000000e1), SC_(9.310551452636718750000000000000000000000e1), SC_(4.420680999755859375000000000000000000000e1), SC_(5.338658690452575683593750000000000000000e-1), SC_(4.975802049030548764528108880576784850239e-1), SC_(5.024197950969451235471891119423215149761e-1) }}, 
      {{ SC_(8.464137268066406250000000000000000000000e1), SC_(9.310551452636718750000000000000000000000e1), SC_(1.357470245361328125000000000000000000000e2), SC_(6.205109357833862304687500000000000000000e-1), SC_(4.933539549295499562559255641370668674294e-1), SC_(5.066460450704500437440744358629331325706e-1) }}, 
      {{ SC_(8.464137268066406250000000000000000000000e1), SC_(9.310551452636718750000000000000000000000e1), SC_(1.915013732910156250000000000000000000000e2), SC_(6.591388583183288574218750000000000000000e-1), SC_(4.918380376459953878928051279200454900800e-1), SC_(5.081619623540046121071948720799545099200e-1) }}, 
      {{ SC_(8.464137268066406250000000000000000000000e1), SC_(1.015696487426757812500000000000000000000e2), SC_(5.569964599609375000000000000000000000000e1), SC_(5.252695083618164062500000000000000000000e-1), SC_(4.982778202055833508807790030173557662158e-1), SC_(5.017221797944166491192209969826442337842e-1) }}, 
      {{ SC_(8.464137268066406250000000000000000000000e1), SC_(1.015696487426757812500000000000000000000e2), SC_(1.362719116210937500000000000000000000000e2), SC_(6.002843976020812988281250000000000000000e-1), SC_(4.946722522236446238867126045955330658205e-1), SC_(5.053277477763553761132873954044669341795e-1) }}, 
      {{ SC_(8.464137268066406250000000000000000000000e1), SC_(1.015696487426757812500000000000000000000e2), SC_(1.918984832763671875000000000000000000000e2), SC_(6.396307349205017089843750000000000000000e-1), SC_(4.931207184124006573538171977834986240428e-1), SC_(5.068792815875993426461828022165013759572e-1) }}, 
      {{ SC_(8.464137268066406250000000000000000000000e1), SC_(1.100337829589843750000000000000000000000e2), SC_(5.940588760375976562500000000000000000000e1), SC_(5.098063945770263671875000000000000000000e-1), SC_(5.038335253958970870399858746794974892650e-1), SC_(4.961664746041029129600141253205025107350e-1) }}, 
      {{ SC_(8.464137268066406250000000000000000000000e1), SC_(1.100337829589843750000000000000000000000e2), SC_(1.451677856445312500000000000000000000000e2), SC_(5.882812738418579101562500000000000000000e-1), SC_(4.996715280907567362070852731805522841700e-1), SC_(5.003284719092432637929147268194477158300e-1) }}, 
      {{ SC_(8.464137268066406250000000000000000000000e1), SC_(1.100337829589843750000000000000000000000e2), SC_(1.929777069091796875000000000000000000000e2), SC_(6.220378875732421875000000000000000000000e-1), SC_(4.982165758564908032070660623470455846962e-1), SC_(5.017834241435091967929339376529544153038e-1) }}, 
      {{ SC_(8.464137268066406250000000000000000000000e1), SC_(1.269620590209960937500000000000000000000e2), SC_(6.038262176513671875000000000000000000000e1), SC_(4.798483848571777343750000000000000000000e-1), SC_(5.598815197382384864722152292188848861280e-1), SC_(4.401184802617615135277847707811151138720e-1) }}, 
      {{ SC_(8.464137268066406250000000000000000000000e1), SC_(1.269620590209960937500000000000000000000e2), SC_(1.481294555664062500000000000000000000000e2), SC_(5.595620274543762207031250000000000000000e-1), SC_(5.501596781178568022835020913743044159683e-1), SC_(4.498403218821431977164979086256955840317e-1) }}, 
      {{ SC_(8.464137268066406250000000000000000000000e1), SC_(1.269620590209960937500000000000000000000e2), SC_(1.935389862060546875000000000000000000000e2), SC_(5.919455885887145996093750000000000000000e-1), SC_(5.471602343161163720793456293677238838028e-1), SC_(4.528397656838836279206543706322761161972e-1) }}, 
      {{ SC_(8.464137268066406250000000000000000000000e1), SC_(1.692827453613281250000000000000000000000e2), SC_(6.163340759277343750000000000000000000000e1), SC_(4.593262374401092529296875000000000000000e-1), SC_(9.572723542824895077844544978794242615144e-1), SC_(4.272764571751049221554550212057573848556e-2) }}, 
      {{ SC_(8.464137268066406250000000000000000000000e1), SC_(1.692827453613281250000000000000000000000e2), SC_(1.486264953613281250000000000000000000000e2), SC_(5.308287143707275390625000000000000000000e-1), SC_(9.374230541567378631977160981948577655610e-1), SC_(6.257694584326213680228390180514223443904e-2) }}, 
      {{ SC_(8.464137268066406250000000000000000000000e1), SC_(1.692827453613281250000000000000000000000e2), SC_(1.937735595703125000000000000000000000000e2), SC_(5.609755516052246093750000000000000000000e-1), SC_(9.301225720931271317456916024517616473107e-1), SC_(6.987742790687286825430839754823835268926e-2) }}, 
      {{ SC_(8.464137268066406250000000000000000000000e1), SC_(2.539241180419921875000000000000000000000e2), SC_(7.225879669189453125000000000000000000000e1), SC_(4.351193904876708984375000000000000000000e-1), SC_(9.999829438262898253191399592072109051567e-1), SC_(1.705617371017468086004079278909484330622e-5) }}, 
      {{ SC_(8.464137268066406250000000000000000000000e1), SC_(2.539241180419921875000000000000000000000e2), SC_(1.515480346679687500000000000000000000000e2), SC_(4.890740215778350830078125000000000000000e-1), SC_(9.999121560289185915568204200201908871203e-1), SC_(8.784397108140844317957997980911287966211e-5) }}, 
      {{ SC_(8.464137268066406250000000000000000000000e1), SC_(2.539241180419921875000000000000000000000e2), SC_(1.941185607910156250000000000000000000000e2), SC_(5.140045285224914550781250000000000000000e-1), SC_(9.998506909496148550506252034877752563780e-1), SC_(1.493090503851449493747965122247436219861e-4) }}, 
      {{ SC_(8.464137268066406250000000000000000000000e1), SC_(3.385654907226562500000000000000000000000e2), SC_(9.566968083381652832031250000000000000000e-1), SC_(3.853085041046142578125000000000000000000e-1), SC_(9.999999999999998522937196373400102628648e-1), SC_(1.477062803626599897371352068037931889209e-16) }}, 
      {{ SC_(8.464137268066406250000000000000000000000e1), SC_(3.385654907226562500000000000000000000000e2), SC_(7.844540405273437500000000000000000000000e1), SC_(4.367082417011260986328125000000000000000e-1), SC_(9.999999999979380398633132042269761536323e-1), SC_(2.061960136686795773023846367670372621777e-12) }}, 
      {{ SC_(8.464137268066406250000000000000000000000e1), SC_(3.385654907226562500000000000000000000000e2), SC_(1.584414672851562500000000000000000000000e2), SC_(4.814840257167816162109375000000000000000e-1), SC_(9.999999998720802565330955997840278953461e-1), SC_(1.279197434669044002159721046539441262573e-10) }}, 
      {{ SC_(8.464137268066406250000000000000000000000e1), SC_(3.385654907226562500000000000000000000000e2), SC_(1.962219390869140625000000000000000000000e2), SC_(5.002491474151611328125000000000000000000e-1), SC_(9.999999995579810421581932274827537049110e-1), SC_(4.420189578418067725172462950890324837668e-10) }}, 
      {{ SC_(8.464137268066406250000000000000000000000e1), SC_(4.232068481445312500000000000000000000000e2), SC_(7.142335891723632812500000000000000000000), SC_(4.483162760734558105468750000000000000000e-1), SC_(9.999999999999999999999999999999999999975e-1), SC_(2.481857279323151004082651104739500340208e-39) }}, 
      {{ SC_(8.464137268066406250000000000000000000000e1), SC_(4.232068481445312500000000000000000000000e2), SC_(7.974770355224609375000000000000000000000e1), SC_(4.848200976848602294921875000000000000000e-1), SC_(9.999999999999999999999999999994939042711e-1), SC_(5.060957288941482435832565087083111442575e-31) }}, 
      {{ SC_(8.464137268066406250000000000000000000000e1), SC_(4.232068481445312500000000000000000000000e2), SC_(1.595857238769531250000000000000000000000e2), SC_(5.197696089744567871093750000000000000000e-1), SC_(9.999999999999999999999999912883177778603e-1), SC_(8.711682222139745822135233015000200210179e-27) }}, 
      {{ SC_(8.464137268066406250000000000000000000000e1), SC_(4.232068481445312500000000000000000000000e2), SC_(1.985762634277343750000000000000000000000e2), SC_(5.351721644401550292968750000000000000000e-1), SC_(9.999999999999999999999997988197963392275e-1), SC_(2.011802036607724913378571231912978531458e-25) }}, 
      {{ SC_(9.733244323730468750000000000000000000000e1), SC_(9.733244895935058593750000000000000000000), SC_(7.225879669189453125000000000000000000000e1), SC_(9.659541845321655273437500000000000000000e-1), SC_(9.689761890587768694136128180154650336478e-1), SC_(3.102381094122313058638718198453496635215e-2) }}, 
      {{ SC_(9.733244323730468750000000000000000000000e1), SC_(9.733244895935058593750000000000000000000), SC_(1.515480346679687500000000000000000000000e2), SC_(9.733227491378784179687500000000000000000e-1), SC_(9.678803953646499685877933862773597006150e-1), SC_(3.211960463535003141220661372264029938496e-2) }}, 
      {{ SC_(9.733244323730468750000000000000000000000e1), SC_(9.733244895935058593750000000000000000000), SC_(1.941185607910156250000000000000000000000e2), SC_(9.761030673980712890625000000000000000000e-1), SC_(9.675353185601879595358630970997630601742e-1), SC_(3.246468143981204046413690290023693982579e-2) }}, 
      {{ SC_(9.733244323730468750000000000000000000000e1), SC_(2.433311080932617187500000000000000000000e1), SC_(9.566968083381652832031250000000000000000e-1), SC_(9.335922598838806152343750000000000000000e-1), SC_(9.999991405091371659936140956805720733658e-1), SC_(8.594908628340063859043194279266342278817e-7) }}, 
      {{ SC_(9.733244323730468750000000000000000000000e1), SC_(2.433311080932617187500000000000000000000e1), SC_(7.844540405273437500000000000000000000000e1), SC_(9.495095014572143554687500000000000000000e-1), SC_(9.999984239566494197534337890016961849083e-1), SC_(1.576043350580246566210998303815091732559e-6) }}, 
      {{ SC_(9.733244323730468750000000000000000000000e1), SC_(2.433311080932617187500000000000000000000e1), SC_(1.584414672851562500000000000000000000000e2), SC_(9.595444798469543457031250000000000000000e-1), SC_(9.999979416064239670245606787782716226800e-1), SC_(2.058393576032975439321221728377319983655e-6) }}, 
      {{ SC_(9.733244323730468750000000000000000000000e1), SC_(2.433311080932617187500000000000000000000e1), SC_(1.962219390869140625000000000000000000000e2), SC_(9.630191922187805175781250000000000000000e-1), SC_(9.999977798987312273553657367283358748593e-1), SC_(2.220101268772644634263271664125140691318e-6) }}, 
      {{ SC_(9.733244323730468750000000000000000000000e1), SC_(4.866622161865234375000000000000000000000e1), SC_(7.142335891723632812500000000000000000000), SC_(9.186433553695678710937500000000000000000e-1), SC_(9.999999999999999872593766704563169053429e-1), SC_(1.274062332954368309465708634246691476755e-17) }}, 
      {{ SC_(9.733244323730468750000000000000000000000e1), SC_(4.866622161865234375000000000000000000000e1), SC_(7.974770355224609375000000000000000000000e1), SC_(9.344680309295654296875000000000000000000e-1), SC_(9.999999999999998848064816885356714494308e-1), SC_(1.151935183114643285505691584455376156744e-16) }}, 
      {{ SC_(9.733244323730468750000000000000000000000e1), SC_(4.866622161865234375000000000000000000000e1), SC_(1.595857238769531250000000000000000000000e2), SC_(9.460316300392150878906250000000000000000e-1), SC_(9.999999999999996508375589097967430651972e-1), SC_(3.491624410902032569348028443087765720061e-16) }}, 
      {{ SC_(9.733244323730468750000000000000000000000e1), SC_(4.866622161865234375000000000000000000000e1), SC_(1.985762634277343750000000000000000000000e2), SC_(9.503167867660522460937500000000000000000e-1), SC_(9.999999999999995127607959472450511371014e-1), SC_(4.872392040527549488628986417268333703708e-16) }}, 
      {{ SC_(9.733244323730468750000000000000000000000e1), SC_(7.299932861328125000000000000000000000000e1), SC_(1.950807952880859375000000000000000000000e1), SC_(9.189038872718811035156250000000000000000e-1), SC_(9.999999999999999999999999999999792059221e-1), SC_(2.079407793339052272744902240435512619241e-32) }}, 
      {{ SC_(9.733244323730468750000000000000000000000e1), SC_(7.299932861328125000000000000000000000000e1), SC_(8.435225677490234375000000000000000000000e1), SC_(9.312331676483154296875000000000000000000e-1), SC_(9.999999999999999999999999999990563493696e-1), SC_(9.436506303964058697811735616838367941757e-31) }}, 
      {{ SC_(9.733244323730468750000000000000000000000e1), SC_(7.299932861328125000000000000000000000000e1), SC_(1.596211700439453125000000000000000000000e2), SC_(9.415593147277832031250000000000000000000e-1), SC_(9.999999999999999999999999999908814865622e-1), SC_(9.118513437756693381614356575065544724939e-30) }}, 
      {{ SC_(9.733244323730468750000000000000000000000e1), SC_(7.299932861328125000000000000000000000000e1), SC_(1.992922668457031250000000000000000000000e2), SC_(9.458480477333068847656250000000000000000e-1), SC_(9.999999999999999999999999999803497061227e-1), SC_(1.965029387732586746326713220957102295555e-29) }}, 
      {{ SC_(9.733244323730468750000000000000000000000e1), SC_(8.759919738769531250000000000000000000000e1), SC_(2.197235107421875000000000000000000000000e1), SC_(5.527498945593833923339843750000000000000e-2), SC_(1.649853674478676345861918413388578867623e-75), SC_(1.000000000000000000000000000000000000000) }}, 
      {{ SC_(9.733244323730468750000000000000000000000e1), SC_(8.759919738769531250000000000000000000000e1), SC_(8.441753387451171875000000000000000000000e1), SC_(6.140235066413879394531250000000000000000e-2), SC_(2.867704121056236139054503045528096084078e-83), SC_(1.000000000000000000000000000000000000000) }}, 
      {{ SC_(9.733244323730468750000000000000000000000e1), SC_(8.759919738769531250000000000000000000000e1), SC_(1.600560913085937500000000000000000000000e2), SC_(6.690098345279693603515625000000000000000e-2), SC_(4.197552727384847048115588556973876598166e-94), SC_(1.000000000000000000000000000000000000000) }}, 
      {{ SC_(9.733244323730468750000000000000000000000e1), SC_(9.635912322998046875000000000000000000000e1), SC_(2.249290275573730468750000000000000000000e1), SC_(1.324218511581420898437500000000000000000e-1), SC_(7.308139946343247070029736887562409157645e-39), SC_(9.999999999999999999999999999999999999927e-1) }}, 
      {{ SC_(9.733244323730468750000000000000000000000e1), SC_(9.635912322998046875000000000000000000000e1), SC_(9.495173645019531250000000000000000000000e1), SC_(1.500302702188491821289062500000000000000e-1), SC_(1.594524487304242822073907790687745811347e-45), SC_(1.000000000000000000000000000000000000000) }}, 
      {{ SC_(9.733244323730468750000000000000000000000e1), SC_(9.635912322998046875000000000000000000000e1), SC_(1.629447326660156250000000000000000000000e2), SC_(1.623587757349014282226562500000000000000e-1), SC_(9.814281100821859435754001279087777803570e-53), SC_(1.000000000000000000000000000000000000000) }}, 
      {{ SC_(9.733244323730468750000000000000000000000e1), SC_(9.723511505126953125000000000000000000000e1), SC_(2.539736366271972656250000000000000000000e1), SC_(2.653649151325225830078125000000000000000e-1), SC_(3.695994026124921119017263497480948336791e-15), SC_(9.999999999999963040059738750788809827365e-1) }}, 
      {{ SC_(9.733244323730468750000000000000000000000e1), SC_(9.723511505126953125000000000000000000000e1), SC_(9.707512664794921875000000000000000000000e1), SC_(2.998500168323516845703125000000000000000e-1), SC_(1.274386786430719709978613005485777571329e-18), SC_(9.999999999999999987256132135692802900214e-1) }}, 
      {{ SC_(9.733244323730468750000000000000000000000e1), SC_(9.723511505126953125000000000000000000000e1), SC_(1.670017089843750000000000000000000000000e2), SC_(3.249709010124206542968750000000000000000e-1), SC_(1.543590681565463974676066404995156374762e-22), SC_(9.999999999999999999998456409318434536025e-1) }}, 
      {{ SC_(9.733244323730468750000000000000000000000e1), SC_(9.733244323730468750000000000000000000000e1), SC_(2.709540176391601562500000000000000000000e1), SC_(3.992904424667358398437500000000000000000e-1), SC_(8.996360589920468455522580445298894515669e-5), SC_(9.999100363941007953154447741955470110548e-1) }}, 
      {{ SC_(9.733244323730468750000000000000000000000e1), SC_(9.733244323730468750000000000000000000000e1), SC_(1.007325439453125000000000000000000000000e2), SC_(4.518315196037292480468750000000000000000e-1), SC_(6.473131436532168815502636490947615627111e-6), SC_(9.999935268685634678311844973635090523844e-1) }}, 
      {{ SC_(9.733244323730468750000000000000000000000e1), SC_(9.733244323730468750000000000000000000000e1), SC_(1.698258666992187500000000000000000000000e2), SC_(4.886107742786407470703125000000000000000e-1), SC_(3.529137641636582139342873057515452149634e-7), SC_(9.999996470862358363417860657126942484548e-1) }}, 
      {{ SC_(9.733244323730468750000000000000000000000e1), SC_(9.734217834472656250000000000000000000000e1), SC_(2.837726783752441406250000000000000000000e1), SC_(4.804122745990753173828125000000000000000e-1), SC_(6.696117475826905521851279577417159797764e-2), SC_(9.330388252417309447814872042258284020224e-1) }}, 
      {{ SC_(9.733244323730468750000000000000000000000e1), SC_(9.734217834472656250000000000000000000000e1), SC_(1.093762969970703125000000000000000000000e2), SC_(5.483636856079101562500000000000000000000e-1), SC_(3.457223990649245861487129966368426660491e-2), SC_(9.654277600935075413851287003363157333951e-1) }}, 
      {{ SC_(9.733244323730468750000000000000000000000e1), SC_(9.734217834472656250000000000000000000000e1), SC_(1.756861267089843750000000000000000000000e2), SC_(5.895614624023437500000000000000000000000e-1), SC_(1.837448548529968548434350065600375617641e-2), SC_(9.816255145147003145156564993439962438236e-1) }}, 
      {{ SC_(9.733244323730468750000000000000000000000e1), SC_(9.742977905273437500000000000000000000000e1), SC_(3.152261734008789062500000000000000000000e1), SC_(5.316674709320068359375000000000000000000e-1), SC_(4.378613736520358583051772709853373819143e-1), SC_(5.621386263479641416948227290146626180857e-1) }}, 
      {{ SC_(9.733244323730468750000000000000000000000e1), SC_(9.742977905273437500000000000000000000000e1), SC_(1.094441146850585937500000000000000000000e2), SC_(6.030406355857849121093750000000000000000e-1), SC_(4.214669949278494057058953396280893108960e-1), SC_(5.785330050721505942941046603719106891040e-1) }}, 
      {{ SC_(9.733244323730468750000000000000000000000e1), SC_(9.742977905273437500000000000000000000000e1), SC_(1.811583862304687500000000000000000000000e2), SC_(6.515885591506958007812500000000000000000e-1), SC_(4.069998047508837541932493462312609396773e-1), SC_(5.930001952491162458067506537687390603227e-1) }}, 
      {{ SC_(9.733244323730468750000000000000000000000e1), SC_(9.830576324462890625000000000000000000000e1), SC_(3.423733520507812500000000000000000000000e1), SC_(5.372306704521179199218750000000000000000e-1), SC_(4.917721586625679405488714676983259451470e-1), SC_(5.082278413374320594511285323016740548530e-1) }}, 
      {{ SC_(9.733244323730468750000000000000000000000e1), SC_(9.830576324462890625000000000000000000000e1), SC_(1.264718551635742187500000000000000000000e2), SC_(6.192783117294311523437500000000000000000e-1), SC_(4.862084948519130322168926043471535535224e-1), SC_(5.137915051480869677831073956528464464776e-1) }}, 
      {{ SC_(9.733244323730468750000000000000000000000e1), SC_(9.830576324462890625000000000000000000000e1), SC_(1.826751708984375000000000000000000000000e2), SC_(6.564053297042846679687500000000000000000e-1), SC_(4.837138973284319550761419260851784246686e-1), SC_(5.162861026715680449238580739148215753314e-1) }}, 
      {{ SC_(9.733244323730468750000000000000000000000e1), SC_(1.070656890869140625000000000000000000000e2), SC_(3.477303314208984375000000000000000000000e1), SC_(5.170832276344299316406250000000000000000e-1), SC_(4.986278697423750810116669121425306594914e-1), SC_(5.013721302576249189883330878574693405086e-1) }}, 
      {{ SC_(9.733244323730468750000000000000000000000e1), SC_(1.070656890869140625000000000000000000000e2), SC_(1.279526672363281250000000000000000000000e2), SC_(6.007042527198791503906250000000000000000e-1), SC_(4.946085235544219665970212833180529519859e-1), SC_(5.053914764455780334029787166819470480141e-1) }}, 
      {{ SC_(9.733244323730468750000000000000000000000e1), SC_(1.070656890869140625000000000000000000000e2), SC_(1.831471099853515625000000000000000000000e2), SC_(6.378788352012634277343750000000000000000e-1), SC_(4.931413820840437341904923788963676311172e-1), SC_(5.068586179159562658095076211036323688828e-1) }}, 
      {{ SC_(9.733244323730468750000000000000000000000e1), SC_(1.167989349365234375000000000000000000000e2), SC_(3.767639541625976562500000000000000000000e1), SC_(4.985277056694030761718750000000000000000e-1), SC_(4.998597637116875520251667473079866940564e-1), SC_(5.001402362883124479748332526920133059436e-1) }}, 
      {{ SC_(9.733244323730468750000000000000000000000e1), SC_(1.167989349365234375000000000000000000000e2), SC_(1.310955810546875000000000000000000000000e2), SC_(5.820742249488830566406250000000000000000e-1), SC_(4.958415819177288452159858982168260482701e-1), SC_(5.041584180822711547840141017831739517299e-1) }}, 
      {{ SC_(9.733244323730468750000000000000000000000e1), SC_(1.167989349365234375000000000000000000000e2), SC_(1.867986450195312500000000000000000000000e2), SC_(6.198669672012329101562500000000000000000e-1), SC_(4.943516507564954034998087361088340625467e-1), SC_(5.056483492435045965001912638911659374533e-1) }}, 
      {{ SC_(9.733244323730468750000000000000000000000e1), SC_(1.265321731567382812500000000000000000000e2), SC_(4.238486480712890625000000000000000000000e1), SC_(4.839961826801300048828125000000000000000e-1), SC_(5.058966657237541382197445565344553526397e-1), SC_(4.941033342762458617802554434655446473603e-1) }}, 
      {{ SC_(9.733244323730468750000000000000000000000e1), SC_(1.265321731567382812500000000000000000000e2), SC_(1.311481323242187500000000000000000000000e2), SC_(5.629308819770812988281250000000000000000e-1), SC_(5.015502425097247765157496556920309999596e-1), SC_(4.984497574902752234842503443079690000404e-1) }}, 
      {{ SC_(9.733244323730468750000000000000000000000e1), SC_(1.265321731567382812500000000000000000000e2), SC_(1.914333953857421875000000000000000000000e2), SC_(6.040937900543212890625000000000000000000e-1), SC_(4.997245284556520678925678289211733500804e-1), SC_(5.002754715443479321074321710788266499196e-1) }}, 
      {{ SC_(9.733244323730468750000000000000000000000e1), SC_(1.459986572265625000000000000000000000000e2), SC_(4.420680999755859375000000000000000000000e1), SC_(4.552385807037353515625000000000000000000e-1), SC_(5.682401231290849911561032520725588460819e-1), SC_(4.317598768709150088438967479274411539181e-1) }}, 
      {{ SC_(9.733244323730468750000000000000000000000e1), SC_(1.459986572265625000000000000000000000000e2), SC_(1.357470245361328125000000000000000000000e2), SC_(5.351790189743041992187500000000000000000e-1), SC_(5.569631458028153937305272293896561422451e-1), SC_(4.430368541971846062694727706103438577549e-1) }}, 
      {{ SC_(9.733244323730468750000000000000000000000e1), SC_(1.459986572265625000000000000000000000000e2), SC_(1.915013732910156250000000000000000000000e2), SC_(5.733374357223510742187500000000000000000e-1), SC_(5.529926965502906971248281902731889902823e-1), SC_(4.470073034497093028751718097268110097177e-1) }}, 
      {{ SC_(9.733244323730468750000000000000000000000e1), SC_(1.946648864746093750000000000000000000000e2), SC_(5.569964599609375000000000000000000000000e1), SC_(4.465598464012145996093750000000000000000e-1), SC_(9.707037402534762487448002883460740739493e-1), SC_(2.929625974652375125519971165392592605068e-2) }}, 
      {{ SC_(9.733244323730468750000000000000000000000e1), SC_(1.946648864746093750000000000000000000000e2), SC_(1.362719116210937500000000000000000000000e2), SC_(5.083457827568054199218750000000000000000e-1), SC_(9.552411608638314812191305329268272628410e-1), SC_(4.475883913616851878086946707317273715901e-2) }}, 
      {{ SC_(9.733244323730468750000000000000000000000e1), SC_(1.946648864746093750000000000000000000000e2), SC_(1.918984832763671875000000000000000000000e2), SC_(5.435431003570556640625000000000000000000e-1), SC_(9.472151558800728480945000345862454711810e-1), SC_(5.278484411992715190549996541375452881902e-2) }}, 
      {{ SC_(9.733244323730468750000000000000000000000e1), SC_(2.919973144531250000000000000000000000000e2), SC_(5.940588760375976562500000000000000000000e1), SC_(4.192046523094177246093750000000000000000e-1), SC_(9.999979751320603935900796459451022853955e-1), SC_(2.024867939606409920354054897714604467122e-6) }}, 
      {{ SC_(9.733244323730468750000000000000000000000e1), SC_(2.919973144531250000000000000000000000000e2), SC_(1.451677856445312500000000000000000000000e2), SC_(4.730316698551177978515625000000000000000e-1), SC_(9.999818704854056676626740814480714092767e-1), SC_(1.812951459433233732591855192859072327249e-5) }}, 
      {{ SC_(9.733244323730468750000000000000000000000e1), SC_(2.919973144531250000000000000000000000000e2), SC_(1.929777069091796875000000000000000000000e2), SC_(4.989270567893981933593750000000000000000e-1), SC_(9.999629978890474658634250338574230254609e-1), SC_(3.700211095253413657496614257697453905557e-5) }}, 
      {{ SC_(9.733244323730468750000000000000000000000e1), SC_(3.893297729492187500000000000000000000000e2), SC_(6.038262176513671875000000000000000000000e1), SC_(4.204967617988586425781250000000000000000e-1), SC_(9.999999999999955081091137631255298153150e-1), SC_(4.491890886236874470184684978091072747354e-15) }}, 
      {{ SC_(9.733244323730468750000000000000000000000e1), SC_(3.893297729492187500000000000000000000000e2), SC_(1.481294555664062500000000000000000000000e2), SC_(4.657738506793975830078125000000000000000e-1), SC_(9.999999999985269386014698349302018296722e-1), SC_(1.473061398530165069798170327791599135395e-12) }}, 
      {{ SC_(9.733244323730468750000000000000000000000e1), SC_(3.893297729492187500000000000000000000000e2), SC_(1.935389862060546875000000000000000000000e2), SC_(4.865387380123138427734375000000000000000e-1), SC_(9.999999999910082237376067263691010666646e-1), SC_(8.991776262393273630898933335408977460271e-12) }}, 
      {{ SC_(9.733244323730468750000000000000000000000e1), SC_(4.866622314453125000000000000000000000000e2), SC_(6.163340759277343750000000000000000000000e1), SC_(4.722479879856109619140625000000000000000e-1), SC_(9.999999999999999999999999999999999999239e-1), SC_(7.609420628304719310071921635734880905549e-38) }}, 
      {{ SC_(9.733244323730468750000000000000000000000e1), SC_(4.866622314453125000000000000000000000000e2), SC_(1.486264953613281250000000000000000000000e2), SC_(5.070739388465881347656250000000000000000e-1), SC_(9.999999999999999999999999999999491635916e-1), SC_(5.083640842269130550916743522959566432764e-32) }}, 
      {{ SC_(9.733244323730468750000000000000000000000e1), SC_(4.866622314453125000000000000000000000000e2), SC_(1.937735595703125000000000000000000000000e2), SC_(5.233982801437377929687500000000000000000e-1), SC_(9.999999999999999999999999999959041766343e-1), SC_(4.095823365746574741904208816367492840318e-30) }}, 
      {{ SC_(1.009807128906250000000000000000000000000e2), SC_(1.009807109832763671875000000000000000000e1), SC_(5.940588760375976562500000000000000000000e1), SC_(9.640820026397705078125000000000000000000e-1), SC_(9.718785525453183674218027866408721718332e-1), SC_(2.812144745468163257819721335912782816681e-2) }}, 
      {{ SC_(1.009807128906250000000000000000000000000e2), SC_(1.009807109832763671875000000000000000000e1), SC_(1.451677856445312500000000000000000000000e2), SC_(9.724500179290771484375000000000000000000e-1), SC_(9.706549156696920756080137662422843912113e-1), SC_(2.934508433030792439198623375771560878872e-2) }}, 
      {{ SC_(1.009807128906250000000000000000000000000e2), SC_(1.009807109832763671875000000000000000000e1), SC_(1.929777069091796875000000000000000000000e2), SC_(9.756207466125488281250000000000000000000e-1), SC_(9.702741183769200886323292223929781637348e-1), SC_(2.972588162307991136767077760702183626520e-2) }}, 
      {{ SC_(1.009807128906250000000000000000000000000e2), SC_(2.524517822265625000000000000000000000000e1), SC_(6.038262176513671875000000000000000000000e1), SC_(9.461348056793212890625000000000000000000e-1), SC_(9.999990882534991800164344545195184020978e-1), SC_(9.117465008199835655454804815979022026707e-7) }}, 
      {{ SC_(1.009807128906250000000000000000000000000e2), SC_(2.524517822265625000000000000000000000000e1), SC_(1.481294555664062500000000000000000000000e2), SC_(9.579082131385803222656250000000000000000e-1), SC_(9.999987088245841585085563526352751405908e-1), SC_(1.291175415841491443647364724859409175081e-6) }}, 
      {{ SC_(1.009807128906250000000000000000000000000e2), SC_(2.524517822265625000000000000000000000000e1), SC_(1.935389862060546875000000000000000000000e2), SC_(9.621900916099548339843750000000000000000e-1), SC_(9.999985728721177192513347094644185801102e-1), SC_(1.427127882280748665290535581419889757145e-6) }}, 
      {{ SC_(1.009807128906250000000000000000000000000e2), SC_(5.049035644531250000000000000000000000000e1), SC_(6.163340759277343750000000000000000000000e1), SC_(9.306904077529907226562500000000000000000e-1), SC_(9.999999999999999799766791547598310026544e-1), SC_(2.002332084524016899734557520551493390388e-17) }}, 
      {{ SC_(1.009807128906250000000000000000000000000e2), SC_(5.049035644531250000000000000000000000000e1), SC_(1.486264953613281250000000000000000000000e2), SC_(9.440129995346069335937500000000000000000e-1), SC_(9.999999999999999163653736953230980066521e-1), SC_(8.363462630467690199334789889082661130203e-17) }}, 
      {{ SC_(1.009807128906250000000000000000000000000e2), SC_(5.049035644531250000000000000000000000000e1), SC_(1.937735595703125000000000000000000000000e2), SC_(9.490959644317626953125000000000000000000e-1), SC_(9.999999999999998717651299408558598719626e-1), SC_(1.282348700591441401280373885303600508586e-16) }}, 
      {{ SC_(1.009807128906250000000000000000000000000e2), SC_(7.573553466796875000000000000000000000000e1), SC_(7.225879669189453125000000000000000000000e1), SC_(9.287784695625305175781250000000000000000e-1), SC_(9.999999999999999999999999999999602060687e-1), SC_(3.979393132547657564657859341025264852322e-32) }}, 
      {{ SC_(1.009807128906250000000000000000000000000e2), SC_(7.573553466796875000000000000000000000000e1), SC_(1.515480346679687500000000000000000000000e2), SC_(9.399378299713134765625000000000000000000e-1), SC_(9.999999999999999999999999999994111588775e-1), SC_(5.888411225482704474654490185430124803633e-31) }}, 
      {{ SC_(1.009807128906250000000000000000000000000e2), SC_(7.573553466796875000000000000000000000000e1), SC_(1.941185607910156250000000000000000000000e2), SC_(9.446015954017639160156250000000000000000e-1), SC_(9.999999999999999999999999999985515597640e-1), SC_(1.448440236025449349077060851947525546460e-30) }}, 
      {{ SC_(1.009807128906250000000000000000000000000e2), SC_(9.088263702392578125000000000000000000000e1), SC_(9.566968083381652832031250000000000000000e-1), SC_(5.274877697229385375976562500000000000000e-2), SC_(5.814936415734620836568062809726334261659e-76), SC_(1.000000000000000000000000000000000000000) }}, 
      {{ SC_(1.009807128906250000000000000000000000000e2), SC_(9.088263702392578125000000000000000000000e1), SC_(7.844540405273437500000000000000000000000e1), SC_(6.064262986183166503906250000000000000000e-2), SC_(4.302783080753944118127113288408857193917e-85), SC_(1.000000000000000000000000000000000000000) }}, 
      {{ SC_(1.009807128906250000000000000000000000000e2), SC_(9.088263702392578125000000000000000000000e1), SC_(1.584414672851562500000000000000000000000e2), SC_(6.643823534250259399414062500000000000000e-2), SC_(2.054020973648914767206915848815011210282e-96), SC_(1.000000000000000000000000000000000000000) }}, 
      {{ SC_(1.009807128906250000000000000000000000000e2), SC_(9.088263702392578125000000000000000000000e1), SC_(1.962219390869140625000000000000000000000e2), SC_(6.862181425094604492187500000000000000000e-2), SC_(3.827689333817735966063928116751558734786e-102), SC_(1.000000000000000000000000000000000000000) }}, 
      {{ SC_(1.009807128906250000000000000000000000000e2), SC_(9.997090911865234375000000000000000000000e1), SC_(7.142335891723632812500000000000000000000), SC_(1.277893632650375366210937500000000000000e-1), SC_(5.482462948627922352048330096312109703611e-39), SC_(9.999999999999999999999999999999999999945e-1) }}, 
      {{ SC_(1.009807128906250000000000000000000000000e2), SC_(9.997090911865234375000000000000000000000e1), SC_(7.974770355224609375000000000000000000000e1), SC_(1.461492329835891723632812500000000000000e-1), SC_(2.654720910217239492909410610928020741907e-45), SC_(1.000000000000000000000000000000000000000) }}, 
      {{ SC_(1.009807128906250000000000000000000000000e2), SC_(9.997090911865234375000000000000000000000e1), SC_(1.595857238769531250000000000000000000000e2), SC_(1.608868390321731567382812500000000000000e-1), SC_(1.361354464796359591137217796764641660642e-53), SC_(1.000000000000000000000000000000000000000) }}, 
      {{ SC_(1.009807128906250000000000000000000000000e2), SC_(9.997090911865234375000000000000000000000e1), SC_(1.985762634277343750000000000000000000000e2), SC_(1.666657477617263793945312500000000000000e-1), SC_(5.976571127545601095540214334760197584390e-58), SC_(1.000000000000000000000000000000000000000) }}, 
      {{ SC_(1.009807128906250000000000000000000000000e2), SC_(1.008797302246093750000000000000000000000e2), SC_(1.950807952880859375000000000000000000000e1), SC_(2.615907490253448486328125000000000000000e-1), SC_(2.264210829331279504329031105204854757102e-15), SC_(9.999999999999977357891706687204956709689e-1) }}, 
      {{ SC_(1.009807128906250000000000000000000000000e2), SC_(1.008797302246093750000000000000000000000e2), SC_(8.435225677490234375000000000000000000000e1), SC_(2.931638360023498535156250000000000000000e-1), SC_(2.119387925219691680036116578290896013386e-18), SC_(9.999999999999999978806120747803083199639e-1) }}, 
      {{ SC_(1.009807128906250000000000000000000000000e2), SC_(1.008797302246093750000000000000000000000e2), SC_(1.596211700439453125000000000000000000000e2), SC_(3.207461833953857421875000000000000000000e-1), SC_(1.625211466308539452187602739895847857862e-22), SC_(9.999999999999999999998374788533691460548e-1) }}, 
      {{ SC_(1.009807128906250000000000000000000000000e2), SC_(1.008797302246093750000000000000000000000e2), SC_(1.992922668457031250000000000000000000000e2), SC_(3.325238823890686035156250000000000000000e-1), SC_(7.253378086677394918740807652720212653560e-25), SC_(9.999999999999999999999992746621913322605e-1) }}, 
      {{ SC_(1.009807128906250000000000000000000000000e2), SC_(1.009807128906250000000000000000000000000e2), SC_(2.197235107421875000000000000000000000000e1), SC_(3.942604660987854003906250000000000000000e-1), SC_(8.230746689745151417986934449350656155069e-5), SC_(9.999176925331025484858201306555064934384e-1) }}, 
      {{ SC_(1.009807128906250000000000000000000000000e2), SC_(1.009807128906250000000000000000000000000e2), SC_(8.441753387451171875000000000000000000000e1), SC_(4.396052062511444091796875000000000000000e-1), SC_(9.650004426129744261639239706138512539455e-6), SC_(9.999903499955738702557383607602938614875e-1) }}, 
      {{ SC_(1.009807128906250000000000000000000000000e2), SC_(1.009807128906250000000000000000000000000e2), SC_(1.600560913085937500000000000000000000000e2), SC_(4.811539649963378906250000000000000000000e-1), SC_(4.460684658496561574283116799667135928368e-7), SC_(9.999995539315341503438425716883200332864e-1) }}, 
      {{ SC_(1.009807128906250000000000000000000000000e2), SC_(1.009908142089843750000000000000000000000e2), SC_(2.249290275573730468750000000000000000000e1), SC_(4.736090004444122314453125000000000000000e-1), SC_(6.663775747902359627116069566561831351876e-2), SC_(9.333622425209764037288393043343816864812e-1) }}, 
      {{ SC_(1.009807128906250000000000000000000000000e2), SC_(1.009908142089843750000000000000000000000e2), SC_(9.495173645019531250000000000000000000000e1), SC_(5.353496670722961425781250000000000000000e-1), SC_(3.774409632287372126893317015124769435513e-2), SC_(9.622559036771262787310668298487523056449e-1) }}, 
      {{ SC_(1.009807128906250000000000000000000000000e2), SC_(1.009908142089843750000000000000000000000e2), SC_(1.629447326660156250000000000000000000000e2), SC_(5.790055990219116210937500000000000000000e-1), SC_(2.023455584250106122100801993564088475964e-2), SC_(9.797654441574989387789919800643591152404e-1) }}, 
      {{ SC_(1.009807128906250000000000000000000000000e2), SC_(1.010816955566406250000000000000000000000e2), SC_(2.539736366271972656250000000000000000000e1), SC_(5.239079594612121582031250000000000000000e-1), SC_(4.383132807486946677517192371791333378939e-1), SC_(5.616867192513053322482807628208666621061e-1) }}, 
      {{ SC_(1.009807128906250000000000000000000000000e2), SC_(1.010816955566406250000000000000000000000e2), SC_(9.707512664794921875000000000000000000000e1), SC_(5.903662443161010742187500000000000000000e-1), SC_(4.235453407213765256973574775046494979067e-1), SC_(5.764546592786234743026425224953505020933e-1) }}, 
      {{ SC_(1.009807128906250000000000000000000000000e2), SC_(1.010816955566406250000000000000000000000e2), SC_(1.670017089843750000000000000000000000000e2), SC_(6.392078995704650878906250000000000000000e-1), SC_(4.096495717042219420596969994020271294847e-1), SC_(5.903504282957780579403030005979728705153e-1) }}, 
      {{ SC_(1.009807128906250000000000000000000000000e2), SC_(1.019905166625976562500000000000000000000e2), SC_(2.709540176391601562500000000000000000000e1), SC_(5.282884240150451660156250000000000000000e-1), SC_(4.923110981662195486314062418605219527526e-1), SC_(5.076889018337804513685937581394780472474e-1) }}, 
      {{ SC_(1.009807128906250000000000000000000000000e2), SC_(1.019905166625976562500000000000000000000e2), SC_(1.007325439453125000000000000000000000000e2), SC_(5.964995026588439941406250000000000000000e-1), SC_(4.876970077300539882728825314938285476887e-1), SC_(5.123029922699460117271174685061714523113e-1) }}, 
      {{ SC_(1.009807128906250000000000000000000000000e2), SC_(1.019905166625976562500000000000000000000e2), SC_(1.698258666992187500000000000000000000000e2), SC_(6.447154283523559570312500000000000000000e-1), SC_(4.844803436990646826364782861140464510779e-1), SC_(5.155196563009353173635217138859535489221e-1) }}, 
      {{ SC_(1.009807128906250000000000000000000000000e2), SC_(1.110787887573242187500000000000000000000e2), SC_(2.837726783752441406250000000000000000000e1), SC_(5.089039206504821777343750000000000000000e-1), SC_(4.990870061310546434404426340936857828537e-1), SC_(5.009129938689453565595573659063142171463e-1) }}, 
      {{ SC_(1.009807128906250000000000000000000000000e2), SC_(1.110787887573242187500000000000000000000e2), SC_(1.093762969970703125000000000000000000000e2), SC_(5.832609534263610839843750000000000000000e-1), SC_(4.954493264946027886561817385698955295182e-1), SC_(5.045506735053972113438182614301044704818e-1) }}, 
      {{ SC_(1.009807128906250000000000000000000000000e2), SC_(1.110787887573242187500000000000000000000e2), SC_(1.756861267089843750000000000000000000000e2), SC_(6.292553544044494628906250000000000000000e-1), SC_(4.935837625996299133046254704219268096766e-1), SC_(5.064162374003700866953745295780731903234e-1) }}, 
      {{ SC_(1.009807128906250000000000000000000000000e2), SC_(1.211768569946289062500000000000000000000e2), SC_(3.152261734008789062500000000000000000000e1), SC_(4.905890822410583496093750000000000000000e-1), SC_(5.003063786292352696695979267520285467552e-1), SC_(4.996936213707647303304020732479714532448e-1) }}, 
      {{ SC_(1.009807128906250000000000000000000000000e2), SC_(1.211768569946289062500000000000000000000e2), SC_(1.094441146850585937500000000000000000000e2), SC_(5.620796680450439453125000000000000000000e-1), SC_(4.967931964106241317663465227656010524291e-1), SC_(5.032068035893758682336534772343989475709e-1) }}, 
      {{ SC_(1.009807128906250000000000000000000000000e2), SC_(1.211768569946289062500000000000000000000e2), SC_(1.811583862304687500000000000000000000000e2), SC_(6.122075915336608886718750000000000000000e-1), SC_(4.947541760306370556211332290611799644333e-1), SC_(5.052458239693629443788667709388200355667e-1) }}, 
      {{ SC_(1.009807128906250000000000000000000000000e2), SC_(1.312749176025390625000000000000000000000e2), SC_(3.423733520507812500000000000000000000000e1), SC_(4.739639759063720703125000000000000000000e-1), SC_(5.066449620427053261465814628629439538164e-1), SC_(4.933550379572946738534185371370560461836e-1) }}, 
      {{ SC_(1.009807128906250000000000000000000000000e2), SC_(1.312749176025390625000000000000000000000e2), SC_(1.264718551635742187500000000000000000000e2), SC_(5.558629631996154785156250000000000000000e-1), SC_(5.020631162751107400962988777356308481637e-1), SC_(4.979368837248892599037011222643691518363e-1) }}, 
      {{ SC_(1.009807128906250000000000000000000000000e2), SC_(1.312749176025390625000000000000000000000e2), SC_(1.826751708984375000000000000000000000000e2), SC_(5.943729877471923828125000000000000000000e-1), SC_(5.003248245317467441387632467298679337652e-1), SC_(4.996751754682532558612367532701320662348e-1) }}, 
      {{ SC_(1.009807128906250000000000000000000000000e2), SC_(1.514710693359375000000000000000000000000e2), SC_(3.477303314208984375000000000000000000000e1), SC_(4.440849721431732177734375000000000000000e-1), SC_(5.714864294782790207440690546725797190320e-1), SC_(4.285135705217209792559309453274202809680e-1) }}, 
      {{ SC_(1.009807128906250000000000000000000000000e2), SC_(1.514710693359375000000000000000000000000e2), SC_(1.279526672363281250000000000000000000000e2), SC_(5.257463455200195312500000000000000000000e-1), SC_(5.592252596951891406524661736354549973794e-1), SC_(4.407747403048108593475338263645450026206e-1) }}, 
      {{ SC_(1.009807128906250000000000000000000000000e2), SC_(1.514710693359375000000000000000000000000e2), SC_(1.831471099853515625000000000000000000000e2), SC_(5.637316107749938964843750000000000000000e-1), SC_(5.550672241750728413024442784428245243967e-1), SC_(4.449327758249271586975557215571754756033e-1) }}, 
      {{ SC_(1.009807128906250000000000000000000000000e2), SC_(2.019614257812500000000000000000000000000e2), SC_(3.767639541625976562500000000000000000000e1), SC_(4.293166100978851318359375000000000000000e-1), SC_(9.772380509184181594313601795452707175999e-1), SC_(2.276194908158184056863982045472928240012e-2) }}, 
      {{ SC_(1.009807128906250000000000000000000000000e2), SC_(2.019614257812500000000000000000000000000e2), SC_(1.310955810546875000000000000000000000000e2), SC_(5.015062689781188964843750000000000000000e-1), SC_(9.597203950564148372631531402040618317070e-1), SC_(4.027960494358516273684685979593816829299e-2) }}, 
      {{ SC_(1.009807128906250000000000000000000000000e2), SC_(2.019614257812500000000000000000000000000e2), SC_(1.867986450195312500000000000000000000000e2), SC_(5.364843606948852539062500000000000000000e-1), SC_(9.519032589840246896090169767637145375311e-1), SC_(4.809674101597531039098302323628546246891e-2) }}, 
      {{ SC_(1.009807128906250000000000000000000000000e2), SC_(3.029421386718750000000000000000000000000e2), SC_(4.238486480712890625000000000000000000000e1), SC_(4.060872793197631835937500000000000000000e-1), SC_(9.999993993534787416503249613621349185321e-1), SC_(6.006465212583496750386378650814679137265e-7) }}, 
      {{ SC_(1.009807128906250000000000000000000000000e2), SC_(3.029421386718750000000000000000000000000e2), SC_(1.311481323242187500000000000000000000000e2), SC_(4.621330499649047851562500000000000000000e-1), SC_(9.999910063230540969601481559725132370657e-1), SC_(8.993676945903039851844027486762934304211e-6) }}, 
      {{ SC_(1.009807128906250000000000000000000000000e2), SC_(3.029421386718750000000000000000000000000e2), SC_(1.914333953857421875000000000000000000000e2), SC_(4.945384860038757324218750000000000000000e-1), SC_(9.999758138437150794883419087847349002806e-1), SC_(2.418615628492051165809121526509971943497e-5) }}, 
      {{ SC_(1.009807128906250000000000000000000000000e2), SC_(4.039228515625000000000000000000000000000e2), SC_(4.420680999755859375000000000000000000000e1), SC_(4.103785455226898193359375000000000000000e-1), SC_(9.999999999999997951425787798686979471593e-1), SC_(2.048574212201313020528406782182758607698e-16) }}, 
      {{ SC_(1.009807128906250000000000000000000000000e2), SC_(4.039228515625000000000000000000000000000e2), SC_(1.357470245361328125000000000000000000000e2), SC_(4.574255943298339843750000000000000000000e-1), SC_(9.999999999997575558864247004840843874802e-1), SC_(2.424441135752995159156125198481428777298e-13) }}, 
      {{ SC_(1.009807128906250000000000000000000000000e2), SC_(4.039228515625000000000000000000000000000e2), SC_(1.915013732910156250000000000000000000000e2), SC_(4.825769364833831787109375000000000000000e-1), SC_(9.999999999972718496676138862867591701588e-1), SC_(2.728150332386113713240829841209798964892e-12) }}, 
      {{ SC_(1.009807128906250000000000000000000000000e2), SC_(5.049035644531250000000000000000000000000e2), SC_(5.569964599609375000000000000000000000000e1), SC_(4.688218235969543457031250000000000000000e-1), SC_(9.999999999999999999999999999999999999995e-1), SC_(5.381466971505273651821860472026406218968e-40) }}, 
      {{ SC_(1.009807128906250000000000000000000000000e2), SC_(5.049035644531250000000000000000000000000e2), SC_(1.362719116210937500000000000000000000000e2), SC_(5.005300641059875488281250000000000000000e-1), SC_(9.999999999999999999999999999999995324792e-1), SC_(4.675208411979372873152948094838956519080e-34) }}, 
      {{ SC_(1.009807128906250000000000000000000000000e2), SC_(5.049035644531250000000000000000000000000e2), SC_(1.918984832763671875000000000000000000000e2), SC_(5.203022956848144531250000000000000000000e-1), SC_(9.999999999999999999999999999998372096729e-1), SC_(1.627903270976313948189581981883424944554e-31) }}, 
      {{ SC_(1.096028594970703125000000000000000000000e2), SC_(1.096028614044189453125000000000000000000e1), SC_(4.238486480712890625000000000000000000000e1), SC_(9.613001346588134765625000000000000000000e-1), SC_(9.775233324146519024613827966349333432873e-1), SC_(2.247666758534809753861720336506665671270e-2) }}, 
      {{ SC_(1.096028594970703125000000000000000000000e2), SC_(1.096028614044189453125000000000000000000e1), SC_(1.311481323242187500000000000000000000000e2), SC_(9.705028533935546875000000000000000000000e-1), SC_(9.762734606742667850095682778462444312695e-1), SC_(2.372653932573321499043172215375556873054e-2) }}, 
      {{ SC_(1.096028594970703125000000000000000000000e2), SC_(1.096028614044189453125000000000000000000e1), SC_(1.914333953857421875000000000000000000000e2), SC_(9.746099710464477539062500000000000000000e-1), SC_(9.758215436430465734226890411650313592711e-1), SC_(2.417845635695342657731095883496864072888e-2) }}, 
      {{ SC_(1.096028594970703125000000000000000000000e2), SC_(2.740071487426757812500000000000000000000e1), SC_(4.420680999755859375000000000000000000000e1), SC_(9.425446391105651855468750000000000000000e-1), SC_(9.999997189711755704450268556392987376084e-1), SC_(2.810288244295549731443607012623916330497e-7) }}, 
      {{ SC_(1.096028594970703125000000000000000000000e2), SC_(2.740071487426757812500000000000000000000e1), SC_(1.357470245361328125000000000000000000000e2), SC_(9.553471803665161132812500000000000000000e-1), SC_(9.999995617034291636304483036996181094427e-1), SC_(4.382965708363695516963003818905572732325e-7) }}, 
      {{ SC_(1.096028594970703125000000000000000000000e2), SC_(2.740071487426757812500000000000000000000e1), SC_(1.915013732910156250000000000000000000000e2), SC_(9.606893658638000488281250000000000000000e-1), SC_(9.999994942548063296918718168929603004759e-1), SC_(5.057451936703081281831070396995241280651e-7) }}, 
      {{ SC_(1.096028594970703125000000000000000000000e2), SC_(5.480142974853515625000000000000000000000e1), SC_(5.569964599609375000000000000000000000000e1), SC_(9.286845922470092773437500000000000000000e-1), SC_(9.999999999999999993140438233218565236559e-1), SC_(6.859561766781434763441422580190545695903e-19) }}, 
      {{ SC_(1.096028594970703125000000000000000000000e2), SC_(5.480142974853515625000000000000000000000e1), SC_(1.362719116210937500000000000000000000000e2), SC_(9.410097002983093261718750000000000000000e-1), SC_(9.999999999999999968394676320222301567334e-1), SC_(3.160532367977769843266614666719837109010e-18) }}, 
      {{ SC_(1.096028594970703125000000000000000000000e2), SC_(5.480142974853515625000000000000000000000e1), SC_(1.918984832763671875000000000000000000000e2), SC_(9.473034143447875976562500000000000000000e-1), SC_(9.999999999999999941837108966589903741534e-1), SC_(5.816289103341009625846590756429354623920e-18) }}, 
      {{ SC_(1.096028594970703125000000000000000000000e2), SC_(8.220214843750000000000000000000000000000e1), SC_(5.940588760375976562500000000000000000000e1), SC_(9.257345795631408691406250000000000000000e-1), SC_(9.999999999999999999999999999999999611709e-1), SC_(3.882910887975208266391511403611528207629e-35) }}, 
      {{ SC_(1.096028594970703125000000000000000000000e2), SC_(8.220214843750000000000000000000000000000e1), SC_(1.451677856445312500000000000000000000000e2), SC_(9.377526640892028808593750000000000000000e-1), SC_(9.999999999999999999999999999999988417701e-1), SC_(1.158229875955370091718093233086510884622e-33) }}, 
      {{ SC_(1.096028594970703125000000000000000000000e2), SC_(8.220214843750000000000000000000000000000e1), SC_(1.929777069091796875000000000000000000000e2), SC_(9.429071545600891113281250000000000000000e-1), SC_(9.999999999999999999999999999999963902426e-1), SC_(3.609757367308367004097663395240607884454e-33) }}, 
      {{ SC_(1.096028594970703125000000000000000000000e2), SC_(9.864257049560546875000000000000000000000e1), SC_(6.038262176513671875000000000000000000000e1), SC_(5.860748887062072753906250000000000000000e-2), SC_(5.407193599980840409757401005600676823747e-89), SC_(1.000000000000000000000000000000000000000) }}, 
      {{ SC_(1.096028594970703125000000000000000000000e2), SC_(9.864257049560546875000000000000000000000e1), SC_(1.481294555664062500000000000000000000000e2), SC_(6.502632796764373779296875000000000000000e-2), SC_(5.875001983037493285477978679656858976715e-101), SC_(1.000000000000000000000000000000000000000) }}, 
      {{ SC_(1.096028594970703125000000000000000000000e2), SC_(9.864257049560546875000000000000000000000e1), SC_(1.935389862060546875000000000000000000000e2), SC_(6.762611865997314453125000000000000000000e-2), SC_(1.032694678290856601424166627889962046740e-107), SC_(1.000000000000000000000000000000000000000) }}, 
      {{ SC_(1.096028594970703125000000000000000000000e2), SC_(1.085068283081054687500000000000000000000e2), SC_(6.163340759277343750000000000000000000000e1), SC_(1.409709900617599487304687500000000000000e-1), SC_(1.185533553057274479116476349557385969415e-46), SC_(1.000000000000000000000000000000000000000) }}, 
      {{ SC_(1.096028594970703125000000000000000000000e2), SC_(1.085068283081054687500000000000000000000e2), SC_(1.486264953613281250000000000000000000000e2), SC_(1.571540683507919311523437500000000000000e-1), SC_(2.456846105168427250246489411341269598925e-55), SC_(1.000000000000000000000000000000000000000) }}, 
      {{ SC_(1.096028594970703125000000000000000000000e2), SC_(1.085068283081054687500000000000000000000e2), SC_(1.937735595703125000000000000000000000000e2), SC_(1.637984067201614379882812500000000000000e-1), SC_(2.862297175325759439909371127135000127992e-60), SC_(1.000000000000000000000000000000000000000) }}, 
      {{ SC_(1.096028594970703125000000000000000000000e2), SC_(1.094932556152343750000000000000000000000e2), SC_(7.225879669189453125000000000000000000000e1), SC_(2.853780686855316162109375000000000000000e-1), SC_(7.528697845629753466953150508701604685691e-19), SC_(9.999999999999999992471302154370246533047e-1) }}, 
      {{ SC_(1.096028594970703125000000000000000000000e2), SC_(1.094932556152343750000000000000000000000e2), SC_(1.515480346679687500000000000000000000000e2), SC_(3.141746819019317626953125000000000000000e-1), SC_(4.883913566596039657845621304447590991542e-23), SC_(9.999999999999999999999511608643340396034e-1) }}, 
      {{ SC_(1.096028594970703125000000000000000000000e2), SC_(1.094932556152343750000000000000000000000e2), SC_(1.941185607910156250000000000000000000000e2), SC_(3.266681730747222900390625000000000000000e-1), SC_(1.700158902030997399402687607128935194622e-25), SC_(9.999999999999999999999998299841097969003e-1) }}, 
      {{ SC_(1.096028594970703125000000000000000000000e2), SC_(1.096028594970703125000000000000000000000e2), SC_(9.566968083381652832031250000000000000000e-1), SC_(3.758128285408020019531250000000000000000e-1), SC_(8.377735037557859950065012722366190250823e-5), SC_(9.999162226496244214004993498727763380975e-1) }}, 
      {{ SC_(1.096028594970703125000000000000000000000e2), SC_(1.096028594970703125000000000000000000000e2), SC_(7.844540405273437500000000000000000000000e1), SC_(4.317284226417541503906250000000000000000e-1), SC_(6.934330075269982864533731535103095060856e-6), SC_(9.999930656699247300171354662684648969049e-1) }}, 
      {{ SC_(1.096028594970703125000000000000000000000e2), SC_(1.096028594970703125000000000000000000000e2), SC_(1.584414672851562500000000000000000000000e2), SC_(4.743030071258544921875000000000000000000e-1), SC_(2.957181641907531764731846821847824818744e-7), SC_(9.999997042818358092468235268153178152175e-1) }}, 
      {{ SC_(1.096028594970703125000000000000000000000e2), SC_(1.096028594970703125000000000000000000000e2), SC_(1.962219390869140625000000000000000000000e2), SC_(4.906936287879943847656250000000000000000e-1), SC_(5.698276663047594172069629614923652654480e-8), SC_(9.999999430172333695240582793037038507635e-1) }}, 
      {{ SC_(1.096028594970703125000000000000000000000e2), SC_(1.096138229370117187500000000000000000000e2), SC_(7.142335891723632812500000000000000000000), SC_(4.571592211723327636718750000000000000000e-1), SC_(6.606937105308503643305149542456778713256e-2), SC_(9.339306289469149635669485045754322128674e-1) }}, 
      {{ SC_(1.096028594970703125000000000000000000000e2), SC_(1.096138229370117187500000000000000000000e2), SC_(7.974770355224609375000000000000000000000e1), SC_(5.190094709396362304687500000000000000000e-1), SC_(3.889667153096788167962331672204279295438e-2), SC_(9.611033284690321183203766832779572070456e-1) }}, 
      {{ SC_(1.096028594970703125000000000000000000000e2), SC_(1.096138229370117187500000000000000000000e2), SC_(1.595857238769531250000000000000000000000e2), SC_(5.697748064994812011718750000000000000000e-1), SC_(1.936884381505198172944726111973550904231e-2), SC_(9.806311561849480182705527388802644909577e-1) }}, 
      {{ SC_(1.096028594970703125000000000000000000000e2), SC_(1.096138229370117187500000000000000000000e2), SC_(1.985762634277343750000000000000000000000e2), SC_(5.899606943130493164062500000000000000000e-1), SC_(1.329598217522095262651194710768020288867e-2), SC_(9.867040178247790473734880528923197971113e-1) }}, 
      {{ SC_(1.096028594970703125000000000000000000000e2), SC_(1.097124710083007812500000000000000000000e2), SC_(1.950807952880859375000000000000000000000e1), SC_(5.157526731491088867187500000000000000000e-1), SC_(4.374553994811978027827278215026556778040e-1), SC_(5.625446005188021972172721784973443221960e-1) }}, 
      {{ SC_(1.096028594970703125000000000000000000000e2), SC_(1.097124710083007812500000000000000000000e2), SC_(8.435225677490234375000000000000000000000e1), SC_(5.743752121925354003906250000000000000000e-1), SC_(4.248171717047938744335252329931475076316e-1), SC_(5.751828282952061255664747670068524923684e-1) }}, 
      {{ SC_(1.096028594970703125000000000000000000000e2), SC_(1.097124710083007812500000000000000000000e2), SC_(1.596211700439453125000000000000000000000e2), SC_(6.265670061111450195312500000000000000000e-1), SC_(4.105196837738331418406371413200342954708e-1), SC_(5.894803162261668581593628586799657045292e-1) }}, 
      {{ SC_(1.096028594970703125000000000000000000000e2), SC_(1.097124710083007812500000000000000000000e2), SC_(1.992922668457031250000000000000000000000e2), SC_(6.491383910179138183593750000000000000000e-1), SC_(4.031549414490435947574148430537422746170e-1), SC_(5.968450585509564052425851569462577253830e-1) }}, 
      {{ SC_(1.096028594970703125000000000000000000000e2), SC_(1.106988906860351562500000000000000000000e2), SC_(2.197235107421875000000000000000000000000e1), SC_(5.207610130310058593750000000000000000000e-1), SC_(4.926271859821741046117538598740470523497e-1), SC_(5.073728140178258953882461401259529476503e-1) }}, 
      {{ SC_(1.096028594970703125000000000000000000000e2), SC_(1.106988906860351562500000000000000000000e2), SC_(8.441753387451171875000000000000000000000e1), SC_(5.774704813957214355468750000000000000000e-1), SC_(4.888505645350285686586579666878267655928e-1), SC_(5.111494354649714313413420333121732344072e-1) }}, 
      {{ SC_(1.096028594970703125000000000000000000000e2), SC_(1.106988906860351562500000000000000000000e2), SC_(1.600560913085937500000000000000000000000e2), SC_(6.304507851600646972656250000000000000000e-1), SC_(4.853582859682007452201417417523882599940e-1), SC_(5.146417140317992547798582582476117400060e-1) }}, 
      {{ SC_(1.096028594970703125000000000000000000000e2), SC_(1.205631484985351562500000000000000000000e2), SC_(2.249290275573730468750000000000000000000e1), SC_(5.004963278770446777343750000000000000000e-1), SC_(4.995582502717025713469725813666774342402e-1), SC_(5.004417497282974286530274186333225657598e-1) }}, 
      {{ SC_(1.096028594970703125000000000000000000000e2), SC_(1.205631484985351562500000000000000000000e2), SC_(9.495173645019531250000000000000000000000e1), SC_(5.654927492141723632812500000000000000000e-1), SC_(4.964009674378364023976511940473733783734e-1), SC_(5.035990325621635976023488059526266216266e-1) }}, 
      {{ SC_(1.096028594970703125000000000000000000000e2), SC_(1.205631484985351562500000000000000000000e2), SC_(1.629447326660156250000000000000000000000e2), SC_(6.128066778182983398437500000000000000000e-1), SC_(4.944485531808249951141564137188007390350e-1), SC_(5.055514468191750048858435862811992609650e-1) }}, 
      {{ SC_(1.096028594970703125000000000000000000000e2), SC_(1.315234375000000000000000000000000000000e2), SC_(2.539736366271972656250000000000000000000e1), SC_(4.817838370800018310546875000000000000000e-1), SC_(5.008012583762561912073238023432569404529e-1), SC_(4.991987416237438087926761976567430595471e-1) }}, 
      {{ SC_(1.096028594970703125000000000000000000000e2), SC_(1.315234375000000000000000000000000000000e2), SC_(9.707512664794921875000000000000000000000e1), SC_(5.457273721694946289062500000000000000000e-1), SC_(4.976796084069687691339773934465491840677e-1), SC_(5.023203915930312308660226065534508159323e-1) }}, 
      {{ SC_(1.096028594970703125000000000000000000000e2), SC_(1.315234375000000000000000000000000000000e2), SC_(1.670017089843750000000000000000000000000e2), SC_(5.945671796798706054687500000000000000000e-1), SC_(4.956573867126303166705056836231408415981e-1), SC_(5.043426132873696833294943163768591584019e-1) }}, 
      {{ SC_(1.096028594970703125000000000000000000000e2), SC_(1.424837188720703125000000000000000000000e2), SC_(2.709540176391601562500000000000000000000e1), SC_(4.640424549579620361328125000000000000000e-1), SC_(5.075256685074441045312474207926896232157e-1), SC_(4.924743314925558954687525792073103767843e-1) }}, 
      {{ SC_(1.096028594970703125000000000000000000000e2), SC_(1.424837188720703125000000000000000000000e2), SC_(1.007325439453125000000000000000000000000e2), SC_(5.291175246238708496093750000000000000000e-1), SC_(5.037654395425406496275586817922666970833e-1), SC_(4.962345604574593503724413182077333029167e-1) }}, 
      {{ SC_(1.096028594970703125000000000000000000000e2), SC_(1.424837188720703125000000000000000000000e2), SC_(1.698258666992187500000000000000000000000e2), SC_(5.773056149482727050781250000000000000000e-1), SC_(5.014744304240839402252591012110399168289e-1), SC_(4.985255695759160597747408987889600831711e-1) }}, 
      {{ SC_(1.096028594970703125000000000000000000000e2), SC_(1.644042968750000000000000000000000000000e2), SC_(2.837726783752441406250000000000000000000e1), SC_(4.350911974906921386718750000000000000000e-1), SC_(5.760957191701832736989995076343648983311e-1), SC_(4.239042808298167263010004923656351016689e-1) }}, 
      {{ SC_(1.096028594970703125000000000000000000000e2), SC_(1.644042968750000000000000000000000000000e2), SC_(1.093762969970703125000000000000000000000e2), SC_(5.045291781425476074218750000000000000000e-1), SC_(5.646078013412303913804659525227291392340e-1), SC_(4.353921986587696086195340474772708607660e-1) }}, 
      {{ SC_(1.096028594970703125000000000000000000000e2), SC_(1.644042968750000000000000000000000000000e2), SC_(1.756861267089843750000000000000000000000e2), SC_(5.498531460762023925781250000000000000000e-1), SC_(5.591220020567057356874329903285016066253e-1), SC_(4.408779979432942643125670096714983933747e-1) }}, 
      {{ SC_(1.096028594970703125000000000000000000000e2), SC_(2.192057189941406250000000000000000000000e2), SC_(3.152261734008789062500000000000000000000e1), SC_(4.215850532054901123046875000000000000000e-1), SC_(9.830422103467130657966688725161783774407e-1), SC_(1.695778965328693420333112748382162255933e-2) }}, 
      {{ SC_(1.096028594970703125000000000000000000000e2), SC_(2.192057189941406250000000000000000000000e2), SC_(1.094441146850585937500000000000000000000e2), SC_(4.802186787128448486328125000000000000000e-1), SC_(9.702260079724523185209749066220896885165e-1), SC_(2.977399202754768147902509337791031148351e-2) }}, 
      {{ SC_(1.096028594970703125000000000000000000000e2), SC_(2.192057189941406250000000000000000000000e2), SC_(1.811583862304687500000000000000000000000e2), SC_(5.245913863182067871093750000000000000000e-1), SC_(9.608937862273857013827464213261841063549e-1), SC_(3.910621377261429861725357867381589364508e-2) }}, 
      {{ SC_(1.096028594970703125000000000000000000000e2), SC_(3.288085937500000000000000000000000000000e2), SC_(3.423733520507812500000000000000000000000e1), SC_(3.984376788139343261718750000000000000000e-1), SC_(9.999998814945918436505210488493857482921e-1), SC_(1.185054081563494789511506142517079007928e-7) }}, 
      {{ SC_(1.096028594970703125000000000000000000000e2), SC_(3.288085937500000000000000000000000000000e2), SC_(1.264718551635742187500000000000000000000e2), SC_(4.536480903625488281250000000000000000000e-1), SC_(9.999971746639685493157595274929272694233e-1), SC_(2.825336031450684240472507072730576716339e-6) }}, 
      {{ SC_(1.096028594970703125000000000000000000000e2), SC_(3.288085937500000000000000000000000000000e2), SC_(1.826751708984375000000000000000000000000e2), SC_(4.825921058654785156250000000000000000000e-1), SC_(9.999919597603722194620567629884487421723e-1), SC_(8.040239627780537943237011551257827697803e-6) }}, 
      {{ SC_(1.096028594970703125000000000000000000000e2), SC_(4.384114379882812500000000000000000000000e2), SC_(3.477303314208984375000000000000000000000e1), SC_(4.035064876079559326171875000000000000000e-1), SC_(9.999999999999999977587729708740414349506e-1), SC_(2.241227029125958565049444013529727200024e-18) }}, 
      {{ SC_(1.096028594970703125000000000000000000000e2), SC_(4.384114379882812500000000000000000000000e2), SC_(1.279526672363281250000000000000000000000e2), SC_(4.488523602485656738281250000000000000000e-1), SC_(9.999999999999913822604952693277194372980e-1), SC_(8.617739504730672280562702046599786530078e-15) }}, 
      {{ SC_(1.096028594970703125000000000000000000000e2), SC_(4.384114379882812500000000000000000000000e2), SC_(1.831471099853515625000000000000000000000e2), SC_(4.726055562496185302734375000000000000000e-1), SC_(9.999999999998676301184474505800198311934e-1), SC_(1.323698815525494199801688065904777097255e-13) }}, 
      {{ SC_(1.096028594970703125000000000000000000000e2), SC_(5.480142822265625000000000000000000000000e2), SC_(3.767639541625976562500000000000000000000e1), SC_(4.598935544490814208984375000000000000000e-1), SC_(1.000000000000000000000000000000000000000), SC_(7.558766408051445542134669562299772786491e-46) }}, 
      {{ SC_(1.096028594970703125000000000000000000000e2), SC_(5.480142822265625000000000000000000000000e2), SC_(1.310955810546875000000000000000000000000e2), SC_(4.947367608547210693359375000000000000000e-1), SC_(9.999999999999999999999999999999999999034e-1), SC_(9.657933352288461898191817144543416076048e-38) }}, 
      {{ SC_(1.096028594970703125000000000000000000000e2), SC_(5.480142822265625000000000000000000000000e2), SC_(1.867986450195312500000000000000000000000e2), SC_(5.134549140930175781250000000000000000000e-1), SC_(9.999999999999999999999999999999999351442e-1), SC_(6.485575183174931312762926940431992420778e-35) }}, 
      {{ SC_(1.096705093383789062500000000000000000000e2), SC_(1.096705150604248046875000000000000000000e1), SC_(3.423733520507812500000000000000000000000e1), SC_(9.601581096649169921875000000000000000000e-1), SC_(9.777370803729346013239081826298287410805e-1), SC_(2.226291962706539867609181737017125891951e-2) }}, 
      {{ SC_(1.096705093383789062500000000000000000000e2), SC_(1.096705150604248046875000000000000000000e1), SC_(1.264718551635742187500000000000000000000e2), SC_(9.701219797134399414062500000000000000000e-1), SC_(9.763565719542883201979794009695668052847e-1), SC_(2.364342804571167980202059903043319471531e-2) }}, 
      {{ SC_(1.096705093383789062500000000000000000000e2), SC_(1.096705150604248046875000000000000000000e1), SC_(1.826751708984375000000000000000000000000e2), SC_(9.740786552429199218750000000000000000000e-1), SC_(9.759140594424611581449060934238983588249e-1), SC_(2.408594055753884185509390657610164117513e-2) }}, 
      {{ SC_(1.096705093383789062500000000000000000000e2), SC_(2.741762733459472656250000000000000000000e1), SC_(3.477303314208984375000000000000000000000e1), SC_(9.407937526702880859375000000000000000000e-1), SC_(9.999997410662427720422788384850426040023e-1), SC_(2.589337572279577211615149573959976583920e-7) }}, 
      {{ SC_(1.096705093383789062500000000000000000000e2), SC_(2.741762733459472656250000000000000000000e1), SC_(1.279526672363281250000000000000000000000e2), SC_(9.544739723205566406250000000000000000000e-1), SC_(9.999995761645462465932904499329200753473e-1), SC_(4.238354537534067095500670799246526506827e-7) }}, 
      {{ SC_(1.096705093383789062500000000000000000000e2), SC_(2.741762733459472656250000000000000000000e1), SC_(1.831471099853515625000000000000000000000e2), SC_(9.599617719650268554687500000000000000000e-1), SC_(9.999995072736901796899060997107116756566e-1), SC_(4.927263098203100939002892883243434111121e-7) }}, 
      {{ SC_(1.096705093383789062500000000000000000000e2), SC_(5.483525466918945312500000000000000000000e1), SC_(3.767639541625976562500000000000000000000e1), SC_(9.251871109008789062500000000000000000000e-1), SC_(9.999999999999999996077281955736731797081e-1), SC_(3.922718044263268202918661657103088301724e-19) }}, 
      {{ SC_(1.096705093383789062500000000000000000000e2), SC_(5.483525466918945312500000000000000000000e1), SC_(1.310955810546875000000000000000000000000e2), SC_(9.403365254402160644531250000000000000000e-1), SC_(9.999999999999999971254628434039239127323e-1), SC_(2.874537156596076087267741707934903072992e-18) }}, 
      {{ SC_(1.096705093383789062500000000000000000000e2), SC_(5.483525466918945312500000000000000000000e1), SC_(1.867986450195312500000000000000000000000e2), SC_(9.467709064483642578125000000000000000000e-1), SC_(9.999999999999999945822475346849653699576e-1), SC_(5.417752465315034630042368612905339629281e-18) }}, 
      {{ SC_(1.096705093383789062500000000000000000000e2), SC_(8.225288391113281250000000000000000000000e1), SC_(4.238486480712890625000000000000000000000e1), SC_(9.227731823921203613281250000000000000000e-1), SC_(9.999999999999999999999999999999999870020e-1), SC_(1.299799704601070552563372341217921694685e-35) }}, 
      {{ SC_(1.096705093383789062500000000000000000000e2), SC_(8.225288391113281250000000000000000000000e1), SC_(1.311481323242187500000000000000000000000e2), SC_(9.360504746437072753906250000000000000000e-1), SC_(9.999999999999999999999999999999992672752e-1), SC_(7.327248474726217013434191882214478208423e-34) }}, 
      {{ SC_(1.096705093383789062500000000000000000000e2), SC_(8.225288391113281250000000000000000000000e1), SC_(1.914333953857421875000000000000000000000e2), SC_(9.427422881126403808593750000000000000000e-1), SC_(9.999999999999999999999999999999966627380e-1), SC_(3.337261952141243412682951597079537972278e-33) }}, 
      {{ SC_(1.096705093383789062500000000000000000000e2), SC_(9.870345306396484375000000000000000000000e1), SC_(4.420680999755859375000000000000000000000e1), SC_(5.715652182698249816894531250000000000000e-2), SC_(4.580334635015759842160710824689484953473e-87), SC_(1.000000000000000000000000000000000000000) }}, 
      {{ SC_(1.096705093383789062500000000000000000000e2), SC_(9.870345306396484375000000000000000000000e1), SC_(1.357470245361328125000000000000000000000e2), SC_(6.423813849687576293945312500000000000000e-2), SC_(3.223083633580086760660975566332783287256e-99), SC_(1.000000000000000000000000000000000000000) }}, 
      {{ SC_(1.096705093383789062500000000000000000000e2), SC_(9.870345306396484375000000000000000000000e1), SC_(1.915013732910156250000000000000000000000e2), SC_(6.751146912574768066406250000000000000000e-2), SC_(1.887968936321612135566786210471666002440e-107), SC_(1.000000000000000000000000000000000000000) }}, 
      {{ SC_(1.096705093383789062500000000000000000000e2), SC_(1.085738067626953125000000000000000000000e2), SC_(5.569964599609375000000000000000000000000e1), SC_(1.396522521972656250000000000000000000000e-1), SC_(3.868855079200269827891626636361321999452e-46), SC_(1.000000000000000000000000000000000000000) }}, 
      {{ SC_(1.096705093383789062500000000000000000000e2), SC_(1.085738067626953125000000000000000000000e2), SC_(1.362719116210937500000000000000000000000e2), SC_(1.551401019096374511718750000000000000000e-1), SC_(4.727191853456675276019873731237177390059e-54), SC_(1.000000000000000000000000000000000000000) }}, 
      {{ SC_(1.096705093383789062500000000000000000000e2), SC_(1.085738067626953125000000000000000000000e2), SC_(1.918984832763671875000000000000000000000e2), SC_(1.635251790285110473632812500000000000000e-1), SC_(4.399491027129097221202572323841727770522e-60), SC_(1.000000000000000000000000000000000000000) }}, 
      {{ SC_(1.096705093383789062500000000000000000000e2), SC_(1.095608367919921875000000000000000000000e2), SC_(5.940588760375976562500000000000000000000e1), SC_(2.798347771167755126953125000000000000000e-1), SC_(3.063332205144048550563218142598022714434e-18), SC_(9.999999999999999969366677948559514494368e-1) }}, 
      {{ SC_(1.096705093383789062500000000000000000000e2), SC_(1.095608367919921875000000000000000000000e2), SC_(1.451677856445312500000000000000000000000e2), SC_(3.121170401573181152343750000000000000000e-1), SC_(1.091931653059205274820373210431546835679e-22), SC_(9.999999999999999999998908068346940794725e-1) }}, 
      {{ SC_(1.096705093383789062500000000000000000000e2), SC_(1.095608367919921875000000000000000000000e2), SC_(1.929777069091796875000000000000000000000e2), SC_(3.263226449489593505859375000000000000000e-1), SC_(1.952026707423286460961761926543567430990e-25), SC_(9.999999999999999999999998047973292576714e-1) }}, 
      {{ SC_(1.096705093383789062500000000000000000000e2), SC_(1.096705093383789062500000000000000000000e2), SC_(6.038262176513671875000000000000000000000e1), SC_(4.202120304107666015625000000000000000000e-1), SC_(1.308619111099218195109673623169417891917e-5), SC_(9.999869138088890078180489032637683058211e-1) }}, 
      {{ SC_(1.096705093383789062500000000000000000000e2), SC_(1.096705093383789062500000000000000000000e2), SC_(1.481294555664062500000000000000000000000e2), SC_(4.694204628467559814453125000000000000000e-1), SC_(4.542552493305419361894861938331061156144e-7), SC_(9.999995457447506694580638105138061668939e-1) }}, 
      {{ SC_(1.096705093383789062500000000000000000000e2), SC_(1.096705093383789062500000000000000000000e2), SC_(1.935389862060546875000000000000000000000e2), SC_(4.895450770854949951171875000000000000000e-1), SC_(6.401558802336837798299946337305968336018e-8), SC_(9.999999359844119766316220170005366269403e-1) }}, 
      {{ SC_(1.096705093383789062500000000000000000000e2), SC_(1.096814804077148437500000000000000000000e2), SC_(6.163340759277343750000000000000000000000e1), SC_(5.052186250686645507812500000000000000000e-1), SC_(4.483654604809310449991154826672094253010e-2), SC_(9.551634539519068955000884517332790574699e-1) }}, 
      {{ SC_(1.096705093383789062500000000000000000000e2), SC_(1.096814804077148437500000000000000000000e2), SC_(1.486264953613281250000000000000000000000e2), SC_(5.635679364204406738281250000000000000000e-1), SC_(2.142870874194204146475150413132271816990e-2), SC_(9.785712912580579585352484958686772818301e-1) }}, 
      {{ SC_(1.096705093383789062500000000000000000000e2), SC_(1.096814804077148437500000000000000000000e2), SC_(1.937735595703125000000000000000000000000e2), SC_(5.875494480133056640625000000000000000000e-1), SC_(1.393573855317627584410696250206774097415e-2), SC_(9.860642614468237241558930374979322590258e-1) }}, 
      {{ SC_(1.096705093383789062500000000000000000000e2), SC_(1.097801818847656250000000000000000000000e2), SC_(7.225879669189453125000000000000000000000e1), SC_(5.645267963409423828125000000000000000000e-1), SC_(4.271457801773533995925479841207874117803e-1), SC_(5.728542198226466004074520158792125882197e-1) }}, 
      {{ SC_(1.096705093383789062500000000000000000000e2), SC_(1.097801818847656250000000000000000000000e2), SC_(1.515480346679687500000000000000000000000e2), SC_(6.215455532073974609375000000000000000000e-1), SC_(4.120267428686252663472561369256247765672e-1), SC_(5.879732571313747336527438630743752234328e-1) }}, 
      {{ SC_(1.096705093383789062500000000000000000000e2), SC_(1.097801818847656250000000000000000000000e2), SC_(1.941185607910156250000000000000000000000e2), SC_(6.462898850440979003906250000000000000000e-1), SC_(4.041062722849644399534016712835138188236e-1), SC_(5.958937277150355600465983287164861811764e-1) }}, 
      {{ SC_(1.096705093383789062500000000000000000000e2), SC_(1.107672119140625000000000000000000000000e2), SC_(9.566968083381652832031250000000000000000e-1), SC_(4.980969727039337158203125000000000000000e-1), SC_(4.941312251844845861801913573863415718411e-1), SC_(5.058687748155154138198086426136584281589e-1) }}, 
      {{ SC_(1.096705093383789062500000000000000000000e2), SC_(1.107672119140625000000000000000000000000e2), SC_(7.844540405273437500000000000000000000000e1), SC_(5.725938081741333007812500000000000000000e-1), SC_(4.891724899009183994242132182912495367421e-1), SC_(5.108275100990816005757867817087504632579e-1) }}, 
      {{ SC_(1.096705093383789062500000000000000000000e2), SC_(1.107672119140625000000000000000000000000e2), SC_(1.584414672851562500000000000000000000000e2), SC_(6.293990015983581542968750000000000000000e-1), SC_(4.854274669274623758114904437658283291903e-1), SC_(5.145725330725376241885095562341716708097e-1) }}, 
      {{ SC_(1.096705093383789062500000000000000000000e2), SC_(1.107672119140625000000000000000000000000e2), SC_(1.962219390869140625000000000000000000000e2), SC_(6.512872576713562011718750000000000000000e-1), SC_(4.839688470537408868408014580884770859907e-1), SC_(5.160311529462591131591985419115229140093e-1) }}, 
      {{ SC_(1.096705093383789062500000000000000000000e2), SC_(1.206375656127929687500000000000000000000e2), SC_(7.142335891723632812500000000000000000000), SC_(4.841549992561340332031250000000000000000e-1), SC_(5.004155320751422249519495195499125852062e-1), SC_(4.995844679248577750480504804500874147938e-1) }}, 
      {{ SC_(1.096705093383789062500000000000000000000e2), SC_(1.206375656127929687500000000000000000000e2), SC_(7.974770355224609375000000000000000000000e1), SC_(5.532511472702026367187500000000000000000e-1), SC_(4.969567541143390483141342403441492981459e-1), SC_(5.030432458856609516858657596558507018541e-1) }}, 
      {{ SC_(1.096705093383789062500000000000000000000e2), SC_(1.206375656127929687500000000000000000000e2), SC_(1.595857238769531250000000000000000000000e2), SC_(6.106504201889038085937500000000000000000e-1), SC_(4.945328736656387352671355901096657724938e-1), SC_(5.054671263343612647328644098903342275062e-1) }}, 
      {{ SC_(1.096705093383789062500000000000000000000e2), SC_(1.206375656127929687500000000000000000000e2), SC_(1.985762634277343750000000000000000000000e2), SC_(6.336492300033569335937500000000000000000e-1), SC_(4.936868700193994555579118676537219161582e-1), SC_(5.063131299806005444420881323462780838418e-1) }}, 
      {{ SC_(1.096705093383789062500000000000000000000e2), SC_(1.316046142578125000000000000000000000000e2), SC_(1.950807952880859375000000000000000000000e1), SC_(4.757110476493835449218750000000000000000e-1), SC_(5.011206740410943410660437435706670103006e-1), SC_(4.988793259589056589339562564293329896994e-1) }}, 
      {{ SC_(1.096705093383789062500000000000000000000e2), SC_(1.316046142578125000000000000000000000000e2), SC_(8.435225677490234375000000000000000000000e1), SC_(5.355090498924255371093750000000000000000e-1), SC_(4.981444159318959099020153263205760473632e-1), SC_(5.018555840681040900979846736794239526368e-1) }}, 
      {{ SC_(1.096705093383789062500000000000000000000e2), SC_(1.316046142578125000000000000000000000000e2), SC_(1.596211700439453125000000000000000000000e2), SC_(5.898499488830566406250000000000000000000e-1), SC_(4.958408657339102444598312805666566661850e-1), SC_(5.041591342660897555401687194333433338150e-1) }}, 
      {{ SC_(1.096705093383789062500000000000000000000e2), SC_(1.316046142578125000000000000000000000000e2), SC_(1.992922668457031250000000000000000000000e2), SC_(6.136812567710876464843750000000000000000e-1), SC_(4.949560403912162655892660947406781135663e-1), SC_(5.050439596087837344107339052593218864337e-1) }}, 
      {{ SC_(1.096705093383789062500000000000000000000e2), SC_(1.425716552734375000000000000000000000000e2), SC_(2.197235107421875000000000000000000000000e1), SC_(4.588280320167541503906250000000000000000e-1), SC_(5.078614440987518596135265169699128507557e-1), SC_(4.921385559012481403864734830300871492443e-1) }}, 
      {{ SC_(1.096705093383789062500000000000000000000e2), SC_(1.425716552734375000000000000000000000000e2), SC_(8.441753387451171875000000000000000000000e1), SC_(5.160533189773559570312500000000000000000e-1), SC_(5.044605446409984720006083420992132052481e-1), SC_(4.955394553590015279993916579007867947519e-1) }}, 
      {{ SC_(1.096705093383789062500000000000000000000e2), SC_(1.425716552734375000000000000000000000000e2), SC_(1.600560913085937500000000000000000000000e2), SC_(5.710344910621643066406250000000000000000e-1), SC_(5.017535076026858378859512282860838378338e-1), SC_(4.982464923973141621140487717139161621662e-1) }}, 
      {{ SC_(1.096705093383789062500000000000000000000e2), SC_(1.645057678222656250000000000000000000000e2), SC_(2.249290275573730468750000000000000000000e1), SC_(4.292694032192230224609375000000000000000e-1), SC_(5.773128611656325550412401921786486661135e-1), SC_(4.226871388343674449587598078213513338865e-1) }}, 
      {{ SC_(1.096705093383789062500000000000000000000e2), SC_(1.645057678222656250000000000000000000000e2), SC_(9.495173645019531250000000000000000000000e1), SC_(4.933913946151733398437500000000000000000e-1), SC_(5.661845861275586182390658387454847842859e-1), SC_(4.338154138724413817609341612545152157141e-1) }}, 
      {{ SC_(1.096705093383789062500000000000000000000e2), SC_(1.645057678222656250000000000000000000000e2), SC_(1.629447326660156250000000000000000000000e2), SC_(5.417333245277404785156250000000000000000e-1), SC_(5.600352973488234239618803541224496583354e-1), SC_(4.399647026511765760381196458775503416646e-1) }}, 
      {{ SC_(1.096705093383789062500000000000000000000e2), SC_(2.193410186767578125000000000000000000000e2), SC_(2.539736366271972656250000000000000000000e1), SC_(4.163984358310699462890625000000000000000e-1), SC_(9.841808911681173464653303243580890141244e-1), SC_(1.581910883188265353466967564191098587563e-2) }}, 
      {{ SC_(1.096705093383789062500000000000000000000e2), SC_(2.193410186767578125000000000000000000000e2), SC_(9.707512664794921875000000000000000000000e1), SC_(4.716745018959045410156250000000000000000e-1), SC_(9.721205803192398598301972074613538116361e-1), SC_(2.787941968076014016980279253864618836391e-2) }}, 
      {{ SC_(1.096705093383789062500000000000000000000e2), SC_(2.193410186767578125000000000000000000000e2), SC_(1.670017089843750000000000000000000000000e2), SC_(5.163811445236206054687500000000000000000e-1), SC_(9.626174884983871126853012584481610928721e-1), SC_(3.738251150161288731469874155183890712793e-2) }}, 
      {{ SC_(1.096705093383789062500000000000000000000e2), SC_(3.290115356445312500000000000000000000000e2), SC_(2.709540176391601562500000000000000000000e1), SC_(3.936833143234252929687500000000000000000e-1), SC_(9.999999210582663358571997720031760981588e-1), SC_(7.894173366414280022799682390184121112811e-8) }}, 
      {{ SC_(1.096705093383789062500000000000000000000e2), SC_(3.290115356445312500000000000000000000000e2), SC_(1.007325439453125000000000000000000000000e2), SC_(4.392496645450592041015625000000000000000e-1), SC_(9.999985222721538576682582347033715707399e-1), SC_(1.477727846142331741765296628429260130827e-6) }}, 
      {{ SC_(1.096705093383789062500000000000000000000e2), SC_(3.290115356445312500000000000000000000000e2), SC_(1.698258666992187500000000000000000000000e2), SC_(4.761959314346313476562500000000000000000e-1), SC_(9.999935091589199620904379276336042283019e-1), SC_(6.490841080037909562072366395771698122239e-6) }}, 
      {{ SC_(1.096705093383789062500000000000000000000e2), SC_(4.386820373535156250000000000000000000000e2), SC_(2.837726783752441406250000000000000000000e1), SC_(4.001099467277526855468750000000000000000e-1), SC_(9.999999999999999991134712897937404741831e-1), SC_(8.865287102062595258168810722324788363474e-19) }}, 
      {{ SC_(1.096705093383789062500000000000000000000e2), SC_(4.386820373535156250000000000000000000000e2), SC_(1.093762969970703125000000000000000000000e2), SC_(4.403387904167175292968750000000000000000e-1), SC_(9.999999999999973904276462545683625856415e-1), SC_(2.609572353745431637414358464397634038789e-15) }}, 
      {{ SC_(1.096705093383789062500000000000000000000e2), SC_(4.386820373535156250000000000000000000000e2), SC_(1.756861267089843750000000000000000000000e2), SC_(4.694698154926300048828125000000000000000e-1), SC_(9.999999999999056838662238970554406385168e-1), SC_(9.431613377610294455936148324363486223697e-14) }}, 
      {{ SC_(1.096705093383789062500000000000000000000e2), SC_(5.483525390625000000000000000000000000000e2), SC_(3.152261734008789062500000000000000000000e1), SC_(4.574212729930877685546875000000000000000e-1), SC_(1.000000000000000000000000000000000000000), SC_(1.051675634585521310714540929897793427807e-46) }}, 
      {{ SC_(1.096705093383789062500000000000000000000e2), SC_(5.483525390625000000000000000000000000000e2), SC_(1.094441146850585937500000000000000000000e2), SC_(4.870427846908569335937500000000000000000e-1), SC_(9.999999999999999999999999999999999999963e-1), SC_(3.713587935927266600818436003254068027268e-39) }}, 
      {{ SC_(1.096705093383789062500000000000000000000e2), SC_(5.483525390625000000000000000000000000000e2), SC_(1.811583862304687500000000000000000000000e2), SC_(5.115864872932434082031250000000000000000e-1), SC_(9.999999999999999999999999999999999654297e-1), SC_(3.457031919576447832036655422107897444539e-35) }}, 
      {{ SC_(1.266556701660156250000000000000000000000e2), SC_(1.266556739807128906250000000000000000000e1), SC_(2.709540176391601562500000000000000000000e1), SC_(9.585497379302978515625000000000000000000e-1), SC_(9.853069843657347545884441455850457346069e-1), SC_(1.469301563426524541155585441495426539311e-2) }}, 
      {{ SC_(1.266556701660156250000000000000000000000e2), SC_(1.266556739807128906250000000000000000000e1), SC_(1.007325439453125000000000000000000000000e2), SC_(9.665678739547729492187500000000000000000e-1), SC_(9.844161396257320212012124927855874696887e-1), SC_(1.558386037426797879878750721441253031134e-2) }}, 
      {{ SC_(1.266556701660156250000000000000000000000e2), SC_(1.266556739807128906250000000000000000000e1), SC_(1.698258666992187500000000000000000000000e2), SC_(9.717104434967041015625000000000000000000e-1), SC_(9.839396672333099612014144607077454119616e-1), SC_(1.606033276669003879858553929225458803844e-2) }}, 
      {{ SC_(1.266556701660156250000000000000000000000e2), SC_(3.166391754150390625000000000000000000000e1), SC_(2.837726783752441406250000000000000000000e1), SC_(9.387874603271484375000000000000000000000e-1), SC_(9.999999703121963761244947072774642408025e-1), SC_(2.968780362387550529272253575919754357028e-8) }}, 
      {{ SC_(1.266556701660156250000000000000000000000e2), SC_(3.166391754150390625000000000000000000000e1), SC_(1.093762969970703125000000000000000000000e2), SC_(9.503898024559020996093750000000000000000e-1), SC_(9.999999501563357360143999477280439968530e-1), SC_(4.984366426398560005227195600314700717394e-8) }}, 
      {{ SC_(1.266556701660156250000000000000000000000e2), SC_(3.166391754150390625000000000000000000000e1), SC_(1.756861267089843750000000000000000000000e2), SC_(9.570611715316772460937500000000000000000e-1), SC_(9.999999371776644718787535135414358856095e-1), SC_(6.282233552812124648645856411439046216992e-8) }}, 
      {{ SC_(1.266556701660156250000000000000000000000e2), SC_(6.332783508300781250000000000000000000000e1), SC_(3.152261734008789062500000000000000000000e1), SC_(9.230218529701232910156250000000000000000e-1), SC_(9.999999999999999999994735725284421002353e-1), SC_(5.264274715578997647409341564039670060149e-22) }}, 
      {{ SC_(1.266556701660156250000000000000000000000e2), SC_(6.332783508300781250000000000000000000000e1), SC_(1.094441146850585937500000000000000000000e2), SC_(9.352428913116455078125000000000000000000e-1), SC_(9.999999999999999999959809494561443513234e-1), SC_(4.019050543855648676590613272233664170916e-21) }}, 
      {{ SC_(1.266556701660156250000000000000000000000e2), SC_(6.332783508300781250000000000000000000000e1), SC_(1.811583862304687500000000000000000000000e2), SC_(9.435057640075683593750000000000000000000e-1), SC_(9.999999999999999999885849420486616030354e-1), SC_(1.141505795133839696455289084773082636105e-20) }}, 
      {{ SC_(1.266556701660156250000000000000000000000e2), SC_(9.499175262451171875000000000000000000000e1), SC_(3.423733520507812500000000000000000000000e1), SC_(9.204072356224060058593750000000000000000e-1), SC_(1.000000000000000000000000000000000000000), SC_(2.703133035345269908209103531318573963700e-41) }}, 
      {{ SC_(1.266556701660156250000000000000000000000e2), SC_(9.499175262451171875000000000000000000000e1), SC_(1.264718551635742187500000000000000000000e2), SC_(9.332598447799682617187500000000000000000e-1), SC_(9.999999999999999999999999999999999999965e-1), SC_(3.515662264132481753048698849371300951143e-39) }}, 
      {{ SC_(1.266556701660156250000000000000000000000e2), SC_(9.499175262451171875000000000000000000000e1), SC_(1.826751708984375000000000000000000000000e2), SC_(9.392428994178771972656250000000000000000e-1), SC_(9.999999999999999999999999999999999999807e-1), SC_(1.930515699826285234933604153242611613650e-38) }}, 
      {{ SC_(1.266556701660156250000000000000000000000e2), SC_(1.139900970458984375000000000000000000000e2), SC_(3.477303314208984375000000000000000000000e1), SC_(5.581178143620491027832031250000000000000e-2), SC_(2.484257316634623666402493227450439861983e-98), SC_(1.000000000000000000000000000000000000000) }}, 
      {{ SC_(1.266556701660156250000000000000000000000e2), SC_(1.139900970458984375000000000000000000000e2), SC_(1.279526672363281250000000000000000000000e2), SC_(6.255403906106948852539062500000000000000e-2), SC_(3.363903893621685244075800727038553821173e-110), SC_(1.000000000000000000000000000000000000000) }}, 
      {{ SC_(1.266556701660156250000000000000000000000e2), SC_(1.139900970458984375000000000000000000000e2), SC_(1.831471099853515625000000000000000000000e2), SC_(6.565983593463897705078125000000000000000e-2), SC_(4.361634025832065757560562117992766929682e-118), SC_(1.000000000000000000000000000000000000000) }}, 
      {{ SC_(1.266556701660156250000000000000000000000e2), SC_(1.253891143798828125000000000000000000000e2), SC_(3.767639541625976562500000000000000000000e1), SC_(1.342477053403854370117187500000000000000e-1), SC_(1.152014461418049135470025665919106220349e-50), SC_(1.000000000000000000000000000000000000000) }}, 
      {{ SC_(1.266556701660156250000000000000000000000e2), SC_(1.253891143798828125000000000000000000000e2), SC_(1.310955810546875000000000000000000000000e2), SC_(1.512330472469329833984375000000000000000e-1), SC_(2.159075510428587246869019012311060650867e-59), SC_(1.000000000000000000000000000000000000000) }}, 
      {{ SC_(1.266556701660156250000000000000000000000e2), SC_(1.253891143798828125000000000000000000000e2), SC_(1.867986450195312500000000000000000000000e2), SC_(1.591841131448745727539062500000000000000e-1), SC_(3.045911097723631920387391048003355212263e-65), SC_(1.000000000000000000000000000000000000000) }}, 
      {{ SC_(1.266556701660156250000000000000000000000e2), SC_(1.265290145874023437500000000000000000000e2), SC_(4.238486480712890625000000000000000000000e1), SC_(2.693600654602050781250000000000000000000e-1), SC_(1.391318875674603516001434418699731190358e-19), SC_(9.999999999999999998608681124325396483999e-1) }}, 
      {{ SC_(1.266556701660156250000000000000000000000e2), SC_(1.265290145874023437500000000000000000000e2), SC_(1.311481323242187500000000000000000000000e2), SC_(3.014004826545715332031250000000000000000e-1), SC_(6.379152214342773590974767559979181420469e-24), SC_(9.999999999999999999999936208477856572264e-1) }}, 
      {{ SC_(1.266556701660156250000000000000000000000e2), SC_(1.265290145874023437500000000000000000000e2), SC_(1.914333953857421875000000000000000000000e2), SC_(3.185325264930725097656250000000000000000e-1), SC_(3.007743221083832966139329780959080546840e-27), SC_(9.999999999999999999999999969922567789162e-1) }}, 
      {{ SC_(1.266556701660156250000000000000000000000e2), SC_(1.266556701660156250000000000000000000000e2), SC_(4.420680999755859375000000000000000000000e1), SC_(4.049950838088989257812500000000000000000e-1), SC_(7.270555730907183657640251011967222861969e-6), SC_(9.999927294442690928163423597489880327771e-1) }}, 
      {{ SC_(1.266556701660156250000000000000000000000e2), SC_(1.266556701660156250000000000000000000000e2), SC_(1.357470245361328125000000000000000000000e2), SC_(4.540512561798095703125000000000000000000e-1), SC_(2.740017511000047285719438186985591991554e-7), SC_(9.999997259982488999952714280561813014408e-1) }}, 
      {{ SC_(1.266556701660156250000000000000000000000e2), SC_(1.266556701660156250000000000000000000000e2), SC_(1.915013732910156250000000000000000000000e2), SC_(4.776518344879150390625000000000000000000e-1), SC_(2.794878418716526379074389713731004319668e-8), SC_(9.999999720512158128347362092561028626900e-1) }}, 
      {{ SC_(1.266556701660156250000000000000000000000e2), SC_(1.266683349609375000000000000000000000000e2), SC_(5.569964599609375000000000000000000000000e1), SC_(4.944086670875549316406250000000000000000e-1), SC_(3.828403403900425782133745807659690076232e-2), SC_(9.617159659609957421786625419234030992377e-1) }}, 
      {{ SC_(1.266556701660156250000000000000000000000e2), SC_(1.266683349609375000000000000000000000000e2), SC_(1.362719116210937500000000000000000000000e2), SC_(5.451294779777526855468750000000000000000e-1), SC_(2.022625747199097191290083735884700312998e-2), SC_(9.797737425280090280870991626411529968700e-1) }}, 
      {{ SC_(1.266556701660156250000000000000000000000e2), SC_(1.266683349609375000000000000000000000000e2), SC_(1.918984832763671875000000000000000000000e2), SC_(5.733469724655151367187500000000000000000e-1), SC_(1.231994466958204560772836335590133429237e-2), SC_(9.876800553304179543922716366440986657076e-1) }}, 
      {{ SC_(1.266556701660156250000000000000000000000e2), SC_(1.267823333740234375000000000000000000000e2), SC_(5.940588760375976562500000000000000000000e1), SC_(5.465423464775085449218750000000000000000e-1), SC_(4.264881807282674013616386843974726115082e-1), SC_(5.735118192717325986383613156025273884918e-1) }}, 
      {{ SC_(1.266556701660156250000000000000000000000e2), SC_(1.267823333740234375000000000000000000000e2), SC_(1.451677856445312500000000000000000000000e2), SC_(6.047491431236267089843750000000000000000e-1), SC_(4.115373370833644750889358884788455687679e-1), SC_(5.884626629166355249110641115211544312321e-1) }}, 
      {{ SC_(1.266556701660156250000000000000000000000e2), SC_(1.267823333740234375000000000000000000000e2), SC_(1.929777069091796875000000000000000000000e2), SC_(6.310295462608337402343750000000000000000e-1), SC_(4.033485147252708079437142303875590618751e-1), SC_(5.966514852747291920562857696124409381249e-1) }}, 
      {{ SC_(1.266556701660156250000000000000000000000e2), SC_(1.279222259521484375000000000000000000000e2), SC_(6.038262176513671875000000000000000000000e1), SC_(5.500684380531311035156250000000000000000e-1), SC_(4.903581542060426086465659929743792862482e-1), SC_(5.096418457939573913534340070256207137518e-1) }}, 
      {{ SC_(1.266556701660156250000000000000000000000e2), SC_(1.279222259521484375000000000000000000000e2), SC_(1.481294555664062500000000000000000000000e2), SC_(6.098784208297729492187500000000000000000e-1), SC_(4.865035442073378265453174812194984316610e-1), SC_(5.134964557926621734546825187805015683390e-1) }}, 
      {{ SC_(1.266556701660156250000000000000000000000e2), SC_(1.279222259521484375000000000000000000000e2), SC_(1.935389862060546875000000000000000000000e2), SC_(6.349885463714599609375000000000000000000e-1), SC_(4.848657802381091680326821411227684172550e-1), SC_(5.151342197618908319673178588772315827450e-1) }}, 
      {{ SC_(1.266556701660156250000000000000000000000e2), SC_(1.393212432861328125000000000000000000000e2), SC_(6.163340759277343750000000000000000000000e1), SC_(5.304144620895385742187500000000000000000e-1), SC_(4.981799358383545292998307746468779022754e-1), SC_(5.018200641616454707001692253531220977246e-1) }}, 
      {{ SC_(1.266556701660156250000000000000000000000e2), SC_(1.393212432861328125000000000000000000000e2), SC_(1.486264953613281250000000000000000000000e2), SC_(5.903183221817016601562500000000000000000e-1), SC_(4.956646321303839688462295323913079430029e-1), SC_(5.043353678696160311537704676086920569971e-1) }}, 
      {{ SC_(1.266556701660156250000000000000000000000e2), SC_(1.393212432861328125000000000000000000000e2), SC_(1.937735595703125000000000000000000000000e2), SC_(6.157682538032531738281250000000000000000e-1), SC_(4.947324973829425433950651064697810210180e-1), SC_(5.052675026170574566049348935302189789820e-1) }}, 
      {{ SC_(1.266556701660156250000000000000000000000e2), SC_(1.519868164062500000000000000000000000000e2), SC_(7.225879669189453125000000000000000000000e1), SC_(5.170246958732604980468750000000000000000e-1), SC_(4.991748942366188332491410435241225783225e-1), SC_(5.008251057633811667508589564758774216775e-1) }}, 
      {{ SC_(1.266556701660156250000000000000000000000e2), SC_(1.519868164062500000000000000000000000000e2), SC_(1.515480346679687500000000000000000000000e2), SC_(5.709474682807922363281250000000000000000e-1), SC_(4.969140270676315000295278389846071174095e-1), SC_(5.030859729323684999704721610153928825905e-1) }}, 
      {{ SC_(1.266556701660156250000000000000000000000e2), SC_(1.519868164062500000000000000000000000000e2), SC_(1.941185607910156250000000000000000000000e2), SC_(5.952211618423461914062500000000000000000e-1), SC_(4.960167588449181857770498196710200294384e-1), SC_(5.039832411550818142229501803289799705616e-1) }}, 
      {{ SC_(1.266556701660156250000000000000000000000e2), SC_(1.646523590087890625000000000000000000000e2), SC_(9.566968083381652832031250000000000000000e-1), SC_(4.362698197364807128906250000000000000000e-1), SC_(5.097387364136278739696752012387705654121e-1), SC_(4.902612635863721260303247987612294345879e-1) }}, 
      {{ SC_(1.266556701660156250000000000000000000000e2), SC_(1.646523590087890625000000000000000000000e2), SC_(7.844540405273437500000000000000000000000e1), SC_(5.021736621856689453125000000000000000000e-1), SC_(5.057835333190203678860089375927317793335e-1), SC_(4.942164666809796321139910624072682206665e-1) }}, 
      {{ SC_(1.266556701660156250000000000000000000000e2), SC_(1.646523590087890625000000000000000000000e2), SC_(1.584414672851562500000000000000000000000e2), SC_(5.558164715766906738281250000000000000000e-1), SC_(5.031305819063500485374539997401129009542e-1), SC_(4.968694180936499514625460002598870990458e-1) }}, 
      {{ SC_(1.266556701660156250000000000000000000000e2), SC_(1.646523590087890625000000000000000000000e2), SC_(1.962219390869140625000000000000000000000e2), SC_(5.773336887359619140625000000000000000000e-1), SC_(5.022035891886083416221425724441756835676e-1), SC_(4.977964108113916583778574275558243164324e-1) }}, 
      {{ SC_(1.266556701660156250000000000000000000000e2), SC_(1.899835052490234375000000000000000000000e2), SC_(7.142335891723632812500000000000000000000), SC_(4.125454127788543701171875000000000000000e-1), SC_(5.865550443876060923806328051517248339913e-1), SC_(4.134449556123939076193671948482751660087e-1) }}, 
      {{ SC_(1.266556701660156250000000000000000000000e2), SC_(1.899835052490234375000000000000000000000e2), SC_(7.974770355224609375000000000000000000000e1), SC_(4.722170531749725341796875000000000000000e-1), SC_(5.745466247175266798578682977852707478611e-1), SC_(4.254533752824733201421317022147292521389e-1) }}, 
      {{ SC_(1.266556701660156250000000000000000000000e2), SC_(1.899835052490234375000000000000000000000e2), SC_(1.595857238769531250000000000000000000000e2), SC_(5.252704620361328125000000000000000000000e-1), SC_(5.668795894421322487510104483719500412663e-1), SC_(4.331204105578677512489895516280499587337e-1) }}, 
      {{ SC_(1.266556701660156250000000000000000000000e2), SC_(1.899835052490234375000000000000000000000e2), SC_(1.985762634277343750000000000000000000000e2), SC_(5.474919676780700683593750000000000000000e-1), SC_(5.642519925441974714128527758449964543797e-1), SC_(4.357480074558025285871472241550035456203e-1) }}, 
      {{ SC_(1.266556701660156250000000000000000000000e2), SC_(2.533113403320312500000000000000000000000e2), SC_(1.950807952880859375000000000000000000000e1), SC_(4.090701043605804443359375000000000000000e-1), SC_(9.906631714765156791332176029615900382450e-1), SC_(9.336828523484320866782397038409961755048e-3) }}, 
      {{ SC_(1.266556701660156250000000000000000000000e2), SC_(2.533113403320312500000000000000000000000e2), SC_(8.435225677490234375000000000000000000000e1), SC_(4.543615281581878662109375000000000000000e-1), SC_(9.831150298511228047439478340478170782952e-1), SC_(1.688497014887719525605216595218292170484e-2) }}, 
      {{ SC_(1.266556701660156250000000000000000000000e2), SC_(2.533113403320312500000000000000000000000e2), SC_(1.596211700439453125000000000000000000000e2), SC_(4.989534616470336914062500000000000000000e-1), SC_(9.753012553660964815797022943080222793481e-1), SC_(2.469874463390351842029770569197772065194e-2) }}, 
      {{ SC_(1.266556701660156250000000000000000000000e2), SC_(2.533113403320312500000000000000000000000e2), SC_(1.992922668457031250000000000000000000000e2), SC_(5.196487307548522949218750000000000000000e-1), SC_(9.717206247858377159189312639918755055049e-1), SC_(2.827937521416228408106873600812449449509e-2) }}, 
      {{ SC_(1.266556701660156250000000000000000000000e2), SC_(3.799670104980468750000000000000000000000e2), SC_(2.197235107421875000000000000000000000000e1), SC_(3.882404863834381103515625000000000000000e-1), SC_(9.999999949731944765549867317092067105889e-1), SC_(5.026805523445013268290793289411101104701e-9) }}, 
      {{ SC_(1.266556701660156250000000000000000000000e2), SC_(3.799670104980468750000000000000000000000e2), SC_(8.441753387451171875000000000000000000000e1), SC_(4.229858219623565673828125000000000000000e-1), SC_(9.999999043382187517326504231174218646065e-1), SC_(9.566178124826734957688257813539352065615e-8) }}, 
      {{ SC_(1.266556701660156250000000000000000000000e2), SC_(3.799670104980468750000000000000000000000e2), SC_(1.600560913085937500000000000000000000000e2), SC_(4.601339697837829589843750000000000000000e-1), SC_(9.999992813108647732706005769900031184683e-1), SC_(7.186891352267293994230099968815316753353e-7) }}, 
      {{ SC_(1.266556701660156250000000000000000000000e2), SC_(5.066226806640625000000000000000000000000e2), SC_(2.249290275573730468750000000000000000000e1), SC_(3.953369557857513427734375000000000000000e-1), SC_(9.999999999999999999995573053021155370558e-1), SC_(4.426946978844629441503242894522079918211e-22) }}, 
      {{ SC_(1.266556701660156250000000000000000000000e2), SC_(5.066226806640625000000000000000000000000e2), SC_(9.495173645019531250000000000000000000000e1), SC_(4.274736940860748291015625000000000000000e-1), SC_(9.999999999999999979498625455664245437284e-1), SC_(2.050137454433575456271613327394653766487e-18) }}, 
      {{ SC_(1.266556701660156250000000000000000000000e2), SC_(5.066226806640625000000000000000000000000e2), SC_(1.629447326660156250000000000000000000000e2), SC_(4.546743333339691162109375000000000000000e-1), SC_(9.999999999999998051591385434700570336207e-1), SC_(1.948408614565299429663792560467112201811e-16) }}, 
      {{ SC_(1.266556701660156250000000000000000000000e2), SC_(6.332783203125000000000000000000000000000e2), SC_(2.539736366271972656250000000000000000000e1), SC_(4.535637199878692626953125000000000000000e-1), SC_(1.000000000000000000000000000000000000000), SC_(3.130620125784351236354312433083562746896e-55) }}, 
      {{ SC_(1.266556701660156250000000000000000000000e2), SC_(6.332783203125000000000000000000000000000e2), SC_(9.707512664794921875000000000000000000000e1), SC_(4.777591228485107421875000000000000000000e-1), SC_(1.000000000000000000000000000000000000000), SC_(4.084116520392896087336728808235715339376e-47) }}, 
      {{ SC_(1.266556701660156250000000000000000000000e2), SC_(6.332783203125000000000000000000000000000e2), SC_(1.670017089843750000000000000000000000000e2), SC_(4.993862211704254150390625000000000000000e-1), SC_(1.000000000000000000000000000000000000000), SC_(2.099833925950242078536176659141408135128e-42) }}, 
      {{ SC_(1.281327819824218750000000000000000000000e2), SC_(1.281327819824218750000000000000000000000e1), SC_(2.197235107421875000000000000000000000000e1), SC_(9.578121900558471679687500000000000000000e-1), SC_(9.858978696467633431127859300382524329838e-1), SC_(1.410213035323665688721406996174756701625e-2) }}, 
      {{ SC_(1.281327819824218750000000000000000000000e2), SC_(1.281327819824218750000000000000000000000e1), SC_(8.441753387451171875000000000000000000000e1), SC_(9.649766683578491210937500000000000000000e-1), SC_(9.850997590804589395803834639501267738117e-1), SC_(1.490024091954106041961653604987322618833e-2) }}, 
      {{ SC_(1.281327819824218750000000000000000000000e2), SC_(1.281327819824218750000000000000000000000e1), SC_(1.600560913085937500000000000000000000000e2), SC_(9.709597826004028320312500000000000000000e-1), SC_(9.845396242582476648518583516660084267340e-1), SC_(1.546037574175233514814164833399157326599e-2) }}, 
      {{ SC_(1.281327819824218750000000000000000000000e2), SC_(3.203319549560546875000000000000000000000e1), SC_(2.249290275573730468750000000000000000000e1), SC_(9.376835227012634277343750000000000000000e-1), SC_(9.999999766250072855189526671719059160999e-1), SC_(2.337499271448104733282809408390013773575e-8) }}, 
      {{ SC_(1.281327819824218750000000000000000000000e2), SC_(3.203319549560546875000000000000000000000e1), SC_(9.495173645019531250000000000000000000000e1), SC_(9.485195875167846679687500000000000000000e-1), SC_(9.999999611154596437409660545819683123402e-1), SC_(3.888454035625903394541803168765980751909e-8) }}, 
      {{ SC_(1.281327819824218750000000000000000000000e2), SC_(3.203319549560546875000000000000000000000e1), SC_(1.629447326660156250000000000000000000000e2), SC_(9.557494521141052246093750000000000000000e-1), SC_(9.999999493107919766131113208374832113470e-1), SC_(5.068920802338688867916251678865302684848e-8) }}, 
      {{ SC_(1.281327819824218750000000000000000000000e2), SC_(6.406639099121093750000000000000000000000e1), SC_(2.539736366271972656250000000000000000000e1), SC_(9.218076467514038085937500000000000000000e-1), SC_(9.999999999999999999997608681180742843701e-1), SC_(2.391318819257156298888292834343673332883e-22) }}, 
      {{ SC_(1.281327819824218750000000000000000000000e2), SC_(6.406639099121093750000000000000000000000e1), SC_(9.707512664794921875000000000000000000000e1), SC_(9.334126710891723632812500000000000000000e-1), SC_(9.999999999999999999981699607195030651247e-1), SC_(1.830039280496934875347637561070365995285e-21) }}, 
      {{ SC_(1.281327819824218750000000000000000000000e2), SC_(6.406639099121093750000000000000000000000e1), SC_(1.670017089843750000000000000000000000000e2), SC_(9.418419003486633300781250000000000000000e-1), SC_(9.999999999999999999943509661182633623554e-1), SC_(5.649033881736637644605522639384337090775e-21) }}, 
      {{ SC_(1.281327819824218750000000000000000000000e2), SC_(9.609958648681640625000000000000000000000e1), SC_(2.709540176391601562500000000000000000000e1), SC_(9.191499948501586914062500000000000000000e-1), SC_(1.000000000000000000000000000000000000000), SC_(5.131189535438801422243902045970733278378e-42) }}, 
      {{ SC_(1.281327819824218750000000000000000000000e2), SC_(9.609958648681640625000000000000000000000e1), SC_(1.007325439453125000000000000000000000000e2), SC_(9.299604892730712890625000000000000000000e-1), SC_(9.999999999999999999999999999999999999996e-1), SC_(4.367451293005923920562680283837619598959e-40) }}, 
      {{ SC_(1.281327819824218750000000000000000000000e2), SC_(9.609958648681640625000000000000000000000e1), SC_(1.698258666992187500000000000000000000000e2), SC_(9.377736449241638183593750000000000000000e-1), SC_(9.999999999999999999999999999999999999951e-1), SC_(4.860456900517374450947769736133231924960e-39) }}, 
      {{ SC_(1.281327819824218750000000000000000000000e2), SC_(1.153195037841796875000000000000000000000e2), SC_(2.837726783752441406250000000000000000000e1), SC_(5.523065477609634399414062500000000000000e-2), SC_(1.087171608699062978382285132926300238618e-98), SC_(1.000000000000000000000000000000000000000) }}, 
      {{ SC_(1.281327819824218750000000000000000000000e2), SC_(1.153195037841796875000000000000000000000e2), SC_(1.093762969970703125000000000000000000000e2), SC_(6.129661202430725097656250000000000000000e-2), SC_(1.007556121214873815578341715941363537898e-108), SC_(1.000000000000000000000000000000000000000) }}, 
      {{ SC_(1.281327819824218750000000000000000000000e2), SC_(1.153195037841796875000000000000000000000e2), SC_(1.756861267089843750000000000000000000000e2), SC_(6.516347080469131469726562500000000000000e-2), SC_(4.918218397716997084478172865532190951614e-118), SC_(1.000000000000000000000000000000000000000) }}, 
      {{ SC_(1.281327819824218750000000000000000000000e2), SC_(1.268514556884765625000000000000000000000e2), SC_(3.152261734008789062500000000000000000000e1), SC_(1.328431963920593261718750000000000000000e-1), SC_(1.088011216364248837139548909280366186115e-50), SC_(1.000000000000000000000000000000000000000) }}, 
      {{ SC_(1.281327819824218750000000000000000000000e2), SC_(1.268514556884765625000000000000000000000e2), SC_(1.094441146850585937500000000000000000000e2), SC_(1.475450098514556884765625000000000000000e-1), SC_(9.555563823508162878722581616977146848315e-58), SC_(1.000000000000000000000000000000000000000) }}, 
      {{ SC_(1.281327819824218750000000000000000000000e2), SC_(1.268514556884765625000000000000000000000e2), SC_(1.811583862304687500000000000000000000000e2), SC_(1.581589132547378540039062500000000000000e-1), SC_(3.887554903123348460132511468071419584320e-65), SC_(1.000000000000000000000000000000000000000) }}, 
      {{ SC_(1.281327819824218750000000000000000000000e2), SC_(1.280046539306640625000000000000000000000e2), SC_(3.423733520507812500000000000000000000000e1), SC_(2.657252550125122070312500000000000000000e-1), SC_(2.046404881292450968019144641941636321177e-19), SC_(9.999999999999999997953595118707549031981e-1) }}, 
      {{ SC_(1.281327819824218750000000000000000000000e2), SC_(1.280046539306640625000000000000000000000e2), SC_(1.264718551635742187500000000000000000000e2), SC_(2.994760572910308837890625000000000000000e-1), SC_(7.505747874441067729353312556218847945889e-24), SC_(9.999999999999999999999924942521255589323e-1) }}, 
      {{ SC_(1.281327819824218750000000000000000000000e2), SC_(1.280046539306640625000000000000000000000e2), SC_(1.826751708984375000000000000000000000000e2), SC_(3.156680762767791748046875000000000000000e-1), SC_(6.423607666079078243767688331701444895452e-27), SC_(9.999999999999999999999999935763923339209e-1) }}, 
      {{ SC_(1.281327819824218750000000000000000000000e2), SC_(1.281327819824218750000000000000000000000e2), SC_(3.477303314208984375000000000000000000000e1), SC_(3.987441062927246093750000000000000000000e-1), SC_(8.861126669089199384960855528411024911193e-6), SC_(9.999911388733309108006150391444715889751e-1) }}, 
      {{ SC_(1.281327819824218750000000000000000000000e2), SC_(1.281327819824218750000000000000000000000e2), SC_(1.279526672363281250000000000000000000000e2), SC_(4.497284293174743652343750000000000000000e-1), SC_(3.390582173831602116828338814092533940230e-7), SC_(9.999996609417826168397883171661185907466e-1) }}, 
      {{ SC_(1.281327819824218750000000000000000000000e2), SC_(1.281327819824218750000000000000000000000e2), SC_(1.831471099853515625000000000000000000000e2), SC_(4.735149443149566650390625000000000000000e-1), SC_(3.663806495439046878581290663286496747590e-8), SC_(9.999999633619350456095312141870933671350e-1) }}, 
      {{ SC_(1.281327819824218750000000000000000000000e2), SC_(1.281455993652343750000000000000000000000e2), SC_(3.767639541625976562500000000000000000000e1), SC_(4.806877970695495605468750000000000000000e-1), SC_(4.271108009999150805425215498886805132499e-2), SC_(9.572889199000084919457478450111319486750e-1) }}, 
      {{ SC_(1.281327819824218750000000000000000000000e2), SC_(1.281455993652343750000000000000000000000e2), SC_(1.310955810546875000000000000000000000000e2), SC_(5.414088368415832519531250000000000000000e-1), SC_(2.081516883209712269678553091779398466855e-2), SC_(9.791848311679028773032144690822060153314e-1) }}, 
      {{ SC_(1.281327819824218750000000000000000000000e2), SC_(1.281455993652343750000000000000000000000e2), SC_(1.867986450195312500000000000000000000000e2), SC_(5.699270963668823242187500000000000000000e-1), SC_(1.274653034751037478838823404993910249993e-2), SC_(9.872534696524896252116117659500608975001e-1) }}, 
      {{ SC_(1.281327819824218750000000000000000000000e2), SC_(1.282609252929687500000000000000000000000e2), SC_(4.238486480712890625000000000000000000000e1), SC_(5.324366688728332519531250000000000000000e-1), SC_(4.291815745617029557530947618202074975072e-1), SC_(5.708184254382970442469052381797925024928e-1) }}, 
      {{ SC_(1.281327819824218750000000000000000000000e2), SC_(1.282609252929687500000000000000000000000e2), SC_(1.311481323242187500000000000000000000000e2), SC_(5.953684449195861816406250000000000000000e-1), SC_(4.137811060374038283123874287237145848554e-1), SC_(5.862188939625961716876125712762854151446e-1) }}, 
      {{ SC_(1.281327819824218750000000000000000000000e2), SC_(1.282609252929687500000000000000000000000e2), SC_(1.914333953857421875000000000000000000000e2), SC_(6.291008591651916503906250000000000000000e-1), SC_(4.035048629513782375380936938711815654601e-1), SC_(5.964951370486217624619063061288184345399e-1) }}, 
      {{ SC_(1.281327819824218750000000000000000000000e2), SC_(1.294141082763671875000000000000000000000e2), SC_(4.420680999755859375000000000000000000000e1), SC_(5.365608930587768554687500000000000000000e-1), SC_(4.911993870063682913152598658036140442542e-1), SC_(5.088006129936317086847401341963859557458e-1) }}, 
      {{ SC_(1.281327819824218750000000000000000000000e2), SC_(1.294141082763671875000000000000000000000e2), SC_(1.357470245361328125000000000000000000000e2), SC_(6.014602184295654296875000000000000000000e-1), SC_(4.870271759250927453390473042583464157943e-1), SC_(5.129728240749072546609526957416535842057e-1) }}, 
      {{ SC_(1.281327819824218750000000000000000000000e2), SC_(1.294141082763671875000000000000000000000e2), SC_(1.915013732910156250000000000000000000000e2), SC_(6.327821612358093261718750000000000000000e-1), SC_(4.849914930691891119400314383650093428835e-1), SC_(5.150085069308108880599685616349906571165e-1) }}, 
      {{ SC_(1.281327819824218750000000000000000000000e2), SC_(1.409460601806640625000000000000000000000e2), SC_(5.569964599609375000000000000000000000000e1), SC_(5.251702070236206054687500000000000000000e-1), SC_(4.984302822193705526898787834707456509499e-1), SC_(5.015697177806294473101212165292543490501e-1) }}, 
      {{ SC_(1.281327819824218750000000000000000000000e2), SC_(1.409460601806640625000000000000000000000e2), SC_(1.362719116210937500000000000000000000000e2), SC_(5.817784070968627929687500000000000000000e-1), SC_(4.960187698976944215748359170538551499733e-1), SC_(5.039812301023055784251640829461448500267e-1) }}, 
      {{ SC_(1.281327819824218750000000000000000000000e2), SC_(1.409460601806640625000000000000000000000e2), SC_(1.918984832763671875000000000000000000000e2), SC_(6.135980486869812011718750000000000000000e-1), SC_(4.948380879395766927906578065261866132657e-1), SC_(5.051619120604233072093421934738133867343e-1) }}, 
      {{ SC_(1.281327819824218750000000000000000000000e2), SC_(1.537593383789062500000000000000000000000e2), SC_(5.940588760375976562500000000000000000000e1), SC_(5.064395666122436523437500000000000000000e-1), SC_(4.996711528662593901370921013247383907401e-1), SC_(5.003288471337406098629078986752616092599e-1) }}, 
      {{ SC_(1.281327819824218750000000000000000000000e2), SC_(1.537593383789062500000000000000000000000e2), SC_(1.451677856445312500000000000000000000000e2), SC_(5.660277009010314941406250000000000000000e-1), SC_(4.971290782268530582715369316954993190388e-1), SC_(5.028709217731469417284630683045006809612e-1) }}, 
      {{ SC_(1.281327819824218750000000000000000000000e2), SC_(1.537593383789062500000000000000000000000e2), SC_(1.929777069091796875000000000000000000000e2), SC_(5.934056043624877929687500000000000000000e-1), SC_(4.961108150553494740623984760998408040653e-1), SC_(5.038891849446505259376015239001591959347e-1) }}, 
      {{ SC_(1.281327819824218750000000000000000000000e2), SC_(1.665726165771484375000000000000000000000e2), SC_(6.038262176513671875000000000000000000000e1), SC_(4.876716434955596923828125000000000000000e-1), SC_(5.066319548468040408540586555432023735219e-1), SC_(4.933680451531959591459413444567976264781e-1) }}, 
      {{ SC_(1.281327819824218750000000000000000000000e2), SC_(1.665726165771484375000000000000000000000e2), SC_(1.481294555664062500000000000000000000000e2), SC_(5.485078096389770507812500000000000000000e-1), SC_(5.035165953611548180472783191873976799511e-1), SC_(4.964834046388451819527216808126023200489e-1) }}, 
      {{ SC_(1.281327819824218750000000000000000000000e2), SC_(1.665726165771484375000000000000000000000e2), SC_(1.935389862060546875000000000000000000000e2), SC_(5.746565461158752441406250000000000000000e-1), SC_(5.023736063885015118785669095455750371381e-1), SC_(4.976263936114984881214330904544249628619e-1) }}, 
      {{ SC_(1.281327819824218750000000000000000000000e2), SC_(1.921991729736328125000000000000000000000e2), SC_(6.163340759277343750000000000000000000000e1), SC_(4.579396247863769531250000000000000000000e-1), SC_(5.774651907901255254078559411511880943560e-1), SC_(4.225348092098744745921440588488119056440e-1) }}, 
      {{ SC_(1.281327819824218750000000000000000000000e2), SC_(1.921991729736328125000000000000000000000e2), SC_(1.486264953613281250000000000000000000000e2), SC_(5.175742506980895996093750000000000000000e-1), SC_(5.682744506373355368437405051574673690265e-1), SC_(4.317255493626644631562594948425326309735e-1) }}, 
      {{ SC_(1.281327819824218750000000000000000000000e2), SC_(1.921991729736328125000000000000000000000e2), SC_(1.937735595703125000000000000000000000000e2), SC_(5.436396002769470214843750000000000000000e-1), SC_(5.650931585066133608443938093167558103689e-1), SC_(4.349068414933866391556061906832441896311e-1) }}, 
      {{ SC_(1.281327819824218750000000000000000000000e2), SC_(2.562655639648437500000000000000000000000e2), SC_(7.225879669189453125000000000000000000000e1), SC_(4.458955526351928710937500000000000000000e-1), SC_(9.850585366575174994595518332188746282657e-1), SC_(1.494146334248250054044816678112537173431e-2) }}, 
      {{ SC_(1.281327819824218750000000000000000000000e2), SC_(2.562655639648437500000000000000000000000e2), SC_(1.515480346679687500000000000000000000000e2), SC_(4.935548603534698486328125000000000000000e-1), SC_(9.768833100518346076157385931339419231475e-1), SC_(2.311668994816539238426140686605807685249e-2) }}, 
      {{ SC_(1.281327819824218750000000000000000000000e2), SC_(2.562655639648437500000000000000000000000e2), SC_(1.941185607910156250000000000000000000000e2), SC_(5.159153342247009277343750000000000000000e-1), SC_(9.730643387490603813169773830016741739498e-1), SC_(2.693566125093961868302261699832582605024e-2) }}, 
      {{ SC_(1.281327819824218750000000000000000000000e2), SC_(3.843983459472656250000000000000000000000e2), SC_(9.566968083381652832031250000000000000000e-1), SC_(3.755816519260406494140625000000000000000e-1), SC_(9.999999991393911739178712286970940199067e-1), SC_(8.606088260821287713029059800932537923784e-10) }}, 
      {{ SC_(1.281327819824218750000000000000000000000e2), SC_(3.843983459472656250000000000000000000000e2), SC_(7.844540405273437500000000000000000000000e1), SC_(4.193547964096069335937500000000000000000e-1), SC_(9.999999366683667924556624745398799373192e-1), SC_(6.333163320754433752546012006268083293114e-8) }}, 
      {{ SC_(1.281327819824218750000000000000000000000e2), SC_(3.843983459472656250000000000000000000000e2), SC_(1.584414672851562500000000000000000000000e2), SC_(4.585493803024291992187500000000000000000e-1), SC_(9.999994188869459033145476977931876641591e-1), SC_(5.811130540966854523022068123358409210389e-7) }}, 
      {{ SC_(1.281327819824218750000000000000000000000e2), SC_(3.843983459472656250000000000000000000000e2), SC_(1.962219390869140625000000000000000000000e2), SC_(4.752798080444335937500000000000000000000e-1), SC_(9.999988219058379706154207076650905531185e-1), SC_(1.178094162029384579292334909446881466061e-6) }}, 
      {{ SC_(1.281327819824218750000000000000000000000e2), SC_(5.125311279296875000000000000000000000000e2), SC_(7.142335891723632812500000000000000000000), SC_(3.880213201045989990234375000000000000000e-1), SC_(9.999999999999999999999849468369511632186e-1), SC_(1.505316304883678142838766005630816771235e-23) }}, 
      {{ SC_(1.281327819824218750000000000000000000000e2), SC_(5.125311279296875000000000000000000000000e2), SC_(7.974770355224609375000000000000000000000e1), SC_(4.206219017505645751953125000000000000000e-1), SC_(9.999999999999999996925140284083481835792e-1), SC_(3.074859715916518164207882182411721800959e-19) }}, 
      {{ SC_(1.281327819824218750000000000000000000000e2), SC_(5.125311279296875000000000000000000000000e2), SC_(1.595857238769531250000000000000000000000e2), SC_(4.526870250701904296875000000000000000000e-1), SC_(9.999999999999999011399211558099785732731e-1), SC_(9.886007884419002142672692572317964464947e-17) }}, 
      {{ SC_(1.281327819824218750000000000000000000000e2), SC_(5.125311279296875000000000000000000000000e2), SC_(1.985762634277343750000000000000000000000e2), SC_(4.670921862125396728515625000000000000000e-1), SC_(9.999999999999993106186745810509094952287e-1), SC_(6.893813254189490905047712749473922796410e-16) }}, 
      {{ SC_(1.281327819824218750000000000000000000000e2), SC_(6.406639404296875000000000000000000000000e2), SC_(1.950807952880859375000000000000000000000e1), SC_(4.513958692550659179687500000000000000000e-1), SC_(1.000000000000000000000000000000000000000), SC_(7.336347783655744505876061512652094239359e-57) }}, 
      {{ SC_(1.281327819824218750000000000000000000000e2), SC_(6.406639404296875000000000000000000000000e2), SC_(8.435225677490234375000000000000000000000e1), SC_(4.733033478260040283203125000000000000000e-1), SC_(1.000000000000000000000000000000000000000), SC_(7.487558424485179197680047305996712219464e-49) }}, 
      {{ SC_(1.281327819824218750000000000000000000000e2), SC_(6.406639404296875000000000000000000000000e2), SC_(1.596211700439453125000000000000000000000e2), SC_(4.966380596160888671875000000000000000000e-1), SC_(1.000000000000000000000000000000000000000), SC_(2.129991485891492446631174288828669376064e-43) }}, 
      {{ SC_(1.281327819824218750000000000000000000000e2), SC_(6.406639404296875000000000000000000000000e2), SC_(1.992922668457031250000000000000000000000e2), SC_(5.081245303153991699218750000000000000000e-1), SC_(1.000000000000000000000000000000000000000), SC_(2.477248653650229982593776177012152598257e-41) }}, 
      {{ SC_(1.313202667236328125000000000000000000000e2), SC_(1.313202667236328125000000000000000000000e1), SC_(9.566968083381652832031250000000000000000e-1), SC_(9.546944499015808105468750000000000000000e-1), SC_(9.872855103845237165300089442999289039337e-1), SC_(1.271448961547628346999105570007109606632e-2) }}, 
      {{ SC_(1.313202667236328125000000000000000000000e2), SC_(1.313202667236328125000000000000000000000e1), SC_(7.844540405273437500000000000000000000000e1), SC_(9.642104506492614746093750000000000000000e-1), SC_(9.862365350014942087110717390019441930194e-1), SC_(1.376346499850579128892826099805580698055e-2) }}, 
      {{ SC_(1.313202667236328125000000000000000000000e2), SC_(1.313202667236328125000000000000000000000e1), SC_(1.584414672851562500000000000000000000000e2), SC_(9.705981016159057617187500000000000000000e-1), SC_(9.856607991019514219469828768412381950994e-1), SC_(1.433920089804857805301712315876180490056e-2) }}, 
      {{ SC_(1.313202667236328125000000000000000000000e2), SC_(1.313202667236328125000000000000000000000e1), SC_(1.962219390869140625000000000000000000000e2), SC_(9.728856086730957031250000000000000000000e-1), SC_(9.854807961320137228781098529098327598343e-1), SC_(1.451920386798627712189014709016724016568e-2) }}, 
      {{ SC_(1.313202667236328125000000000000000000000e2), SC_(3.283006668090820312500000000000000000000e1), SC_(7.142335891723632812500000000000000000000), SC_(9.347445368766784667968750000000000000000e-1), SC_(9.999999866410478050374768616618892730200e-1), SC_(1.335895219496252313833811072698000721835e-8) }}, 
      {{ SC_(1.313202667236328125000000000000000000000e2), SC_(3.283006668090820312500000000000000000000e1), SC_(7.974770355224609375000000000000000000000e1), SC_(9.463110566139221191406250000000000000000e-1), SC_(9.999999757545458645440828137452808903763e-1), SC_(2.424545413545591718625471910962374334365e-8) }}, 
      {{ SC_(1.313202667236328125000000000000000000000e2), SC_(3.283006668090820312500000000000000000000e1), SC_(1.595857238769531250000000000000000000000e2), SC_(9.550796151161193847656250000000000000000e-1), SC_(9.999999658486538857585802009485623714016e-1), SC_(3.415134611424141979905143762859838629558e-8) }}, 
      {{ SC_(1.313202667236328125000000000000000000000e2), SC_(3.283006668090820312500000000000000000000e1), SC_(1.985762634277343750000000000000000000000e2), SC_(9.584001302719116210937500000000000000000e-1), SC_(9.999999619068298209052303393597455277647e-1), SC_(3.809317017909476966064025447223531705967e-8) }}, 
      {{ SC_(1.313202667236328125000000000000000000000e2), SC_(6.566013336181640625000000000000000000000e1), SC_(1.950807952880859375000000000000000000000e1), SC_(9.205803275108337402343750000000000000000e-1), SC_(9.999999999999999999999434746328124983096e-1), SC_(5.652536718750169039452770726737813996465e-23) }}, 
      {{ SC_(1.313202667236328125000000000000000000000e2), SC_(6.566013336181640625000000000000000000000e1), SC_(8.435225677490234375000000000000000000000e1), SC_(9.313122034072875976562500000000000000000e-1), SC_(9.999999999999999999995746151524379276966e-1), SC_(4.253848475620723033892333221749582001725e-22) }}, 
      {{ SC_(1.313202667236328125000000000000000000000e2), SC_(6.566013336181640625000000000000000000000e1), SC_(1.596211700439453125000000000000000000000e2), SC_(9.406334161758422851562500000000000000000e-1), SC_(9.999999999999999999983855524127589419783e-1), SC_(1.614447587241058021703854664620068940999e-21) }}, 
      {{ SC_(1.313202667236328125000000000000000000000e2), SC_(6.566013336181640625000000000000000000000e1), SC_(1.992922668457031250000000000000000000000e2), SC_(9.445982575416564941406250000000000000000e-1), SC_(9.999999999999999999974006276304388642764e-1), SC_(2.599372369561135723625755830996214761172e-21) }}, 
      {{ SC_(1.313202667236328125000000000000000000000e2), SC_(9.849020385742187500000000000000000000000e1), SC_(2.197235107421875000000000000000000000000e1), SC_(9.181808829307556152343750000000000000000e-1), SC_(1.000000000000000000000000000000000000000), SC_(3.138991016161125138249042674363062600472e-43) }}, 
      {{ SC_(1.313202667236328125000000000000000000000e2), SC_(9.849020385742187500000000000000000000000e1), SC_(8.441753387451171875000000000000000000000e1), SC_(9.275445342063903808593750000000000000000e-1), SC_(1.000000000000000000000000000000000000000), SC_(2.020882226747899451231549200985364346941e-41) }}, 
      {{ SC_(1.313202667236328125000000000000000000000e2), SC_(9.849020385742187500000000000000000000000e1), SC_(1.600560913085937500000000000000000000000e2), SC_(9.363718032836914062500000000000000000000e-1), SC_(9.999999999999999999999999999999999999996e-1), SC_(3.860130790945626799089000328607899846007e-40) }}, 
      {{ SC_(1.313202667236328125000000000000000000000e2), SC_(1.181882400512695312500000000000000000000e2), SC_(2.249290275573730468750000000000000000000e1), SC_(5.466709658503532409667968750000000000000e-2), SC_(2.269407117460277421099107041516573941466e-100), SC_(1.000000000000000000000000000000000000000) }}, 
      {{ SC_(1.313202667236328125000000000000000000000e2), SC_(1.181882400512695312500000000000000000000e2), SC_(9.495173645019531250000000000000000000000e1), SC_(6.018246337771415710449218750000000000000e-2), SC_(4.201726027156736644712087037563080397437e-109), SC_(1.000000000000000000000000000000000000000) }}, 
      {{ SC_(1.313202667236328125000000000000000000000e2), SC_(1.181882400512695312500000000000000000000e2), SC_(1.629447326660156250000000000000000000000e2), SC_(6.426496803760528564453125000000000000000e-2), SC_(1.910668908603873928487111300615505955853e-118), SC_(1.000000000000000000000000000000000000000) }}, 
      {{ SC_(1.313202667236328125000000000000000000000e2), SC_(1.300070648193359375000000000000000000000e2), SC_(2.539736366271972656250000000000000000000e1), SC_(1.313716173171997070312500000000000000000e-1), SC_(2.403807278520998763426300264261804235893e-51), SC_(1.000000000000000000000000000000000000000) }}, 
      {{ SC_(1.313202667236328125000000000000000000000e2), SC_(1.300070648193359375000000000000000000000e2), SC_(9.707512664794921875000000000000000000000e1), SC_(1.450568586587905883789062500000000000000e-1), SC_(1.139214417982675157392046491844337610551e-57), SC_(1.000000000000000000000000000000000000000) }}, 
      {{ SC_(1.313202667236328125000000000000000000000e2), SC_(1.300070648193359375000000000000000000000e2), SC_(1.670017089843750000000000000000000000000e2), SC_(1.556788533926010131835937500000000000000e-1), SC_(1.014316243894075101950426346810486807638e-64), SC_(1.000000000000000000000000000000000000000) }}, 
      {{ SC_(1.313202667236328125000000000000000000000e2), SC_(1.311889495849609375000000000000000000000e2), SC_(2.709540176391601562500000000000000000000e1), SC_(2.623456120491027832031250000000000000000e-1), SC_(1.624304308736440901423167326849355753956e-19), SC_(9.999999999999999998375695691263559098577e-1) }}, 
      {{ SC_(1.313202667236328125000000000000000000000e2), SC_(1.311889495849609375000000000000000000000e2), SC_(1.007325439453125000000000000000000000000e2), SC_(2.902417182922363281250000000000000000000e-1), SC_(6.480316579077274488710563206424439396426e-23), SC_(9.999999999999999999999351968342092272551e-1) }}, 
      {{ SC_(1.313202667236328125000000000000000000000e2), SC_(1.311889495849609375000000000000000000000e2), SC_(1.698258666992187500000000000000000000000e2), SC_(3.110637962818145751953125000000000000000e-1), SC_(1.442923182522181716349042722421020908967e-26), SC_(9.999999999999999999999999855707681747782e-1) }}, 
      {{ SC_(1.313202667236328125000000000000000000000e2), SC_(1.313202667236328125000000000000000000000e2), SC_(2.837726783752441406250000000000000000000e1), SC_(3.941544294357299804687500000000000000000e-1), SC_(8.695118775644157601050743977471829508515e-6), SC_(9.999913048812243558423989492560225281705e-1) }}, 
      {{ SC_(1.313202667236328125000000000000000000000e2), SC_(1.313202667236328125000000000000000000000e2), SC_(1.093762969970703125000000000000000000000e2), SC_(4.394586086273193359375000000000000000000e-1), SC_(5.614546566001692438603443513312266397878e-7), SC_(9.999994385453433998307561396556486687734e-1) }}, 
      {{ SC_(1.313202667236328125000000000000000000000e2), SC_(1.313202667236328125000000000000000000000e2), SC_(1.756861267089843750000000000000000000000e2), SC_(4.687867462635040283203125000000000000000e-1), SC_(4.167686637885942157785843695312433652637e-8), SC_(9.999999583231336211405784221415630468757e-1) }}, 
      {{ SC_(1.313202667236328125000000000000000000000e2), SC_(1.313334045410156250000000000000000000000e2), SC_(3.152261734008789062500000000000000000000e1), SC_(4.753673076629638671875000000000000000000e-1), SC_(4.282488645509262523905524143570995213006e-2), SC_(9.571751135449073747609447585642900478699e-1) }}, 
      {{ SC_(1.313202667236328125000000000000000000000e2), SC_(1.313334045410156250000000000000000000000e2), SC_(1.094441146850585937500000000000000000000e2), SC_(5.273681879043579101562500000000000000000e-1), SC_(2.404731036740928429641838182196539453805e-2), SC_(9.759526896325907157035816181780346054619e-1) }}, 
      {{ SC_(1.313202667236328125000000000000000000000e2), SC_(1.313334045410156250000000000000000000000e2), SC_(1.811583862304687500000000000000000000000e2), SC_(5.651334524154663085937500000000000000000e-1), SC_(1.303623616915348618318016928925216080102e-2), SC_(9.869637638308465138168198307107478391990e-1) }}, 
      {{ SC_(1.313202667236328125000000000000000000000e2), SC_(1.314515991210937500000000000000000000000e2), SC_(3.423733520507812500000000000000000000000e1), SC_(5.249413251876831054687500000000000000000e-1), SC_(4.299310176358362770883017113361259678424e-1), SC_(5.700689823641637229116982886638740321576e-1) }}, 
      {{ SC_(1.313202667236328125000000000000000000000e2), SC_(1.314515991210937500000000000000000000000e2), SC_(1.264718551635742187500000000000000000000e2), SC_(5.905785560607910156250000000000000000000e-1), SC_(4.141848670269376557175339758223199506311e-1), SC_(5.858151329730623442824660241776800493689e-1) }}, 
      {{ SC_(1.313202667236328125000000000000000000000e2), SC_(1.314515991210937500000000000000000000000e2), SC_(1.826751708984375000000000000000000000000e2), SC_(6.222270727157592773437500000000000000000e-1), SC_(4.047285998831297811590574359516225054418e-1), SC_(5.952714001168702188409425640483774945582e-1) }}, 
      {{ SC_(1.313202667236328125000000000000000000000e2), SC_(1.326334686279296875000000000000000000000e2), SC_(3.477303314208984375000000000000000000000e1), SC_(5.279335975646972656250000000000000000000e-1), SC_(4.916865299790714918277311455089185037822e-1), SC_(5.083134700209285081722688544910814962178e-1) }}, 
      {{ SC_(1.313202667236328125000000000000000000000e2), SC_(1.326334686279296875000000000000000000000e2), SC_(1.279526672363281250000000000000000000000e2), SC_(5.947075486183166503906250000000000000000e-1), SC_(4.874161271817819911781716742864092889820e-1), SC_(5.125838728182180088218283257135907110180e-1) }}, 
      {{ SC_(1.313202667236328125000000000000000000000e2), SC_(1.326334686279296875000000000000000000000e2), SC_(1.831471099853515625000000000000000000000e2), SC_(6.260417699813842773437500000000000000000e-1), SC_(4.853910195684044494322470489272616869158e-1), SC_(5.146089804315955505677529510727383130842e-1) }}, 
      {{ SC_(1.313202667236328125000000000000000000000e2), SC_(1.444523010253906250000000000000000000000e2), SC_(3.767639541625976562500000000000000000000e1), SC_(5.095778107643127441406250000000000000000e-1), SC_(4.991680727866349421989620995904702141377e-1), SC_(5.008319272133650578010379004095297858623e-1) }}, 
      {{ SC_(1.313202667236328125000000000000000000000e2), SC_(1.444523010253906250000000000000000000000e2), SC_(1.310955810546875000000000000000000000000e2), SC_(5.765457153320312500000000000000000000000e-1), SC_(4.962714389850322504967352615622912419247e-1), SC_(5.037285610149677495032647384377087580753e-1) }}, 
      {{ SC_(1.313202667236328125000000000000000000000e2), SC_(1.444523010253906250000000000000000000000e2), SC_(1.867986450195312500000000000000000000000e2), SC_(6.084444522857666015625000000000000000000e-1), SC_(4.950815743029760601042666676632247030505e-1), SC_(5.049184256970239398957333323367752969495e-1) }}, 
      {{ SC_(1.313202667236328125000000000000000000000e2), SC_(1.575843200683593750000000000000000000000e2), SC_(4.238486480712890625000000000000000000000e1), SC_(4.917613863945007324218750000000000000000e-1), SC_(5.003739349416724261031236692813182266594e-1), SC_(4.996260650583275738968763307186817733406e-1) }}, 
      {{ SC_(1.313202667236328125000000000000000000000e2), SC_(1.575843200683593750000000000000000000000e2), SC_(1.311481323242187500000000000000000000000e2), SC_(5.552601218223571777343750000000000000000e-1), SC_(4.976003616268826836913772626800235045291e-1), SC_(5.023996383731173163086227373199764954709e-1) }}, 
      {{ SC_(1.313202667236328125000000000000000000000e2), SC_(1.575843200683593750000000000000000000000e2), SC_(1.914333953857421875000000000000000000000e2), SC_(5.900629758834838867187500000000000000000e-1), SC_(4.962913061007511498406402086606783311483e-1), SC_(5.037086938992488501593597913393216688517e-1) }}, 
      {{ SC_(1.313202667236328125000000000000000000000e2), SC_(1.707163391113281250000000000000000000000e2), SC_(4.420680999755859375000000000000000000000e1), SC_(4.737407863140106201171875000000000000000e-1), SC_(5.075257069771025073424522026030019851107e-1), SC_(4.924742930228974926575477973969980148893e-1) }}, 
      {{ SC_(1.313202667236328125000000000000000000000e2), SC_(1.707163391113281250000000000000000000000e2), SC_(1.357470245361328125000000000000000000000e2), SC_(5.387247204780578613281250000000000000000e-1), SC_(5.040846172904353502486242961534529981594e-1), SC_(4.959153827095646497513757038465470018406e-1) }}, 
      {{ SC_(1.313202667236328125000000000000000000000e2), SC_(1.707163391113281250000000000000000000000e2), SC_(1.915013732910156250000000000000000000000e2), SC_(5.710044503211975097656250000000000000000e-1), SC_(5.026502339343101579207694133274360402867e-1), SC_(4.973497660656898420792305866725639597133e-1) }}, 
      {{ SC_(1.313202667236328125000000000000000000000e2), SC_(1.969804077148437500000000000000000000000e2), SC_(5.569964599609375000000000000000000000000e1), SC_(4.522738754749298095703125000000000000000e-1), SC_(5.794511227250568679818170138434438725271e-1), SC_(4.205488772749431320181829861565561274729e-1) }}, 
      {{ SC_(1.313202667236328125000000000000000000000e2), SC_(1.969804077148437500000000000000000000000e2), SC_(1.362719116210937500000000000000000000000e2), SC_(5.078288912773132324218750000000000000000e-1), SC_(5.704666045586262214193538872777912977064e-1), SC_(4.295333954413737785806461127222087022936e-1) }}, 
      {{ SC_(1.313202667236328125000000000000000000000e2), SC_(1.969804077148437500000000000000000000000e2), SC_(1.918984832763671875000000000000000000000e2), SC_(5.400492548942565917968750000000000000000e-1), SC_(5.663744838998532862285781464240346220222e-1), SC_(4.336255161001467137714218535759653779778e-1) }}, 
      {{ SC_(1.313202667236328125000000000000000000000e2), SC_(2.626405334472656250000000000000000000000e2), SC_(5.940588760375976562500000000000000000000e1), SC_(4.363368749618530273437500000000000000000e-1), SC_(9.875613110587942805035801681881568044135e-1), SC_(1.243868894120571949641983181184319558653e-2) }}, 
      {{ SC_(1.313202667236328125000000000000000000000e2), SC_(2.626405334472656250000000000000000000000e2), SC_(1.451677856445312500000000000000000000000e2), SC_(4.880581796169281005859375000000000000000e-1), SC_(9.791111710818566303618055281181602377029e-1), SC_(2.088882891814336963819447188183976229712e-2) }}, 
      {{ SC_(1.313202667236328125000000000000000000000e2), SC_(2.626405334472656250000000000000000000000e2), SC_(1.929777069091796875000000000000000000000e2), SC_(5.129777193069458007812500000000000000000e-1), SC_(9.749985375263150443071917166396444282684e-1), SC_(2.500146247368495569280828336035557173158e-2) }}, 
      {{ SC_(1.313202667236328125000000000000000000000e2), SC_(3.939608154296875000000000000000000000000e2), SC_(6.038262176513671875000000000000000000000e1), SC_(4.089124798774719238281250000000000000000e-1), SC_(9.999999801753216026110134600146799078395e-1), SC_(1.982467839738898653998532009216049421336e-8) }}, 
      {{ SC_(1.313202667236328125000000000000000000000e2), SC_(3.939608154296875000000000000000000000000e2), SC_(1.481294555664062500000000000000000000000e2), SC_(4.521220624446868896484375000000000000000e-1), SC_(9.999996859041295410555671997880306454795e-1), SC_(3.140958704589444328002119693545204974093e-7) }}, 
      {{ SC_(1.313202667236328125000000000000000000000e2), SC_(3.939608154296875000000000000000000000000e2), SC_(1.935389862060546875000000000000000000000e2), SC_(4.720963537693023681640625000000000000000e-1), SC_(9.999992240100157349052590908388415218883e-1), SC_(7.759899842650947409091611584781116978384e-7) }}, 
      {{ SC_(1.313202667236328125000000000000000000000e2), SC_(5.252810668945312500000000000000000000000e2), SC_(6.163340759277343750000000000000000000000e1), SC_(4.121645092964172363281250000000000000000e-1), SC_(9.999999999999999999856341549975910848312e-1), SC_(1.436584500240891516875673143919444684567e-20) }}, 
      {{ SC_(1.313202667236328125000000000000000000000e2), SC_(5.252810668945312500000000000000000000000e2), SC_(1.486264953613281250000000000000000000000e2), SC_(4.471055865287780761718750000000000000000e-1), SC_(9.999999999999999821991915851379963911229e-1), SC_(1.780080841486200360887713912420490400503e-17) }}, 
      {{ SC_(1.313202667236328125000000000000000000000e2), SC_(5.252810668945312500000000000000000000000e2), SC_(1.937735595703125000000000000000000000000e2), SC_(4.636526703834533691406250000000000000000e-1), SC_(9.999999999999998028254486803125807697855e-1), SC_(1.971745513196874192302145005343722015794e-16) }}, 
      {{ SC_(1.313202667236328125000000000000000000000e2), SC_(6.566013183593750000000000000000000000000e2), SC_(7.225879669189453125000000000000000000000e1), SC_(4.687737524509429931640625000000000000000e-1), SC_(1.000000000000000000000000000000000000000), SC_(2.171241058247116857174086874305878584526e-51) }}, 
      {{ SC_(1.313202667236328125000000000000000000000e2), SC_(6.566013183593750000000000000000000000000e2), SC_(1.515480346679687500000000000000000000000e2), SC_(4.931331276893615722656250000000000000000e-1), SC_(1.000000000000000000000000000000000000000), SC_(3.853107177993909159611717820495930142081e-45) }}, 
      {{ SC_(1.313202667236328125000000000000000000000e2), SC_(6.566013183593750000000000000000000000000e2), SC_(1.941185607910156250000000000000000000000e2), SC_(5.053130984306335449218750000000000000000e-1), SC_(1.000000000000000000000000000000000000000), SC_(8.477980373470510213749103700628573131040e-43) }}, 
      {{ SC_(1.359076538085937500000000000000000000000e2), SC_(1.359076595306396484375000000000000000000e1), SC_(6.038262176513671875000000000000000000000e1), SC_(9.621473550796508789062500000000000000000e-1), SC_(9.878160233650467530333735468064607708443e-1), SC_(1.218397663495324696662645319353922915567e-2) }}, 
      {{ SC_(1.359076538085937500000000000000000000000e2), SC_(1.359076595306396484375000000000000000000e1), SC_(1.481294555664062500000000000000000000000e2), SC_(9.695591330528259277343750000000000000000e-1), SC_(9.871710819675402034972765644596102590294e-1), SC_(1.282891803245979650272343554038974097061e-2) }}, 
      {{ SC_(1.359076538085937500000000000000000000000e2), SC_(1.359076595306396484375000000000000000000e1), SC_(1.935389862060546875000000000000000000000e2), SC_(9.723625183105468750000000000000000000000e-1), SC_(9.869615490869445091034111935014390465435e-1), SC_(1.303845091305549089658880649856095345648e-2) }}, 
      {{ SC_(1.359076538085937500000000000000000000000e2), SC_(3.397691345214843750000000000000000000000e1), SC_(6.163340759277343750000000000000000000000e1), SC_(9.435265064239501953125000000000000000000e-1), SC_(9.999999876935633070233865199063795334892e-1), SC_(1.230643669297661348009362046651079785646e-8) }}, 
      {{ SC_(1.359076538085937500000000000000000000000e2), SC_(3.397691345214843750000000000000000000000e1), SC_(1.486264953613281250000000000000000000000e2), SC_(9.535632729530334472656250000000000000000e-1), SC_(9.999999810853068904791104715239635395074e-1), SC_(1.891469310952088952847603646049259815598e-8) }}, 
      {{ SC_(1.359076538085937500000000000000000000000e2), SC_(3.397691345214843750000000000000000000000e1), SC_(1.937735595703125000000000000000000000000e2), SC_(9.574877023696899414062500000000000000000e-1), SC_(9.999999782840882274912742542857137574630e-1), SC_(2.171591177250872574571428624253700076398e-8) }}, 
      {{ SC_(1.359076538085937500000000000000000000000e2), SC_(6.795382690429687500000000000000000000000e1), SC_(7.225879669189453125000000000000000000000e1), SC_(9.291676878929138183593750000000000000000e-1), SC_(9.999999999999999999999426924770598721053e-1), SC_(5.730752294012789474826944408710718354177e-23) }}, 
      {{ SC_(1.359076538085937500000000000000000000000e2), SC_(6.795382690429687500000000000000000000000e1), SC_(1.515480346679687500000000000000000000000e2), SC_(9.391889572143554687500000000000000000000e-1), SC_(9.999999999999999999997285880840491852027e-1), SC_(2.714119159508147972943205465610793675011e-22) }}, 
      {{ SC_(1.359076538085937500000000000000000000000e2), SC_(6.795382690429687500000000000000000000000e1), SC_(1.941185607910156250000000000000000000000e2), SC_(9.434845447540283203125000000000000000000e-1), SC_(9.999999999999999999995288409512085447324e-1), SC_(4.711590487914552676027008947985584093331e-22) }}, 
      {{ SC_(1.359076538085937500000000000000000000000e2), SC_(1.019307403564453125000000000000000000000e2), SC_(9.566968083381652832031250000000000000000e-1), SC_(9.144570231437683105468750000000000000000e-1), SC_(1.000000000000000000000000000000000000000), SC_(1.295260939119276374356452190706393502501e-45) }}, 
      {{ SC_(1.359076538085937500000000000000000000000e2), SC_(1.019307403564453125000000000000000000000e2), SC_(7.844540405273437500000000000000000000000e1), SC_(9.263824224472045898437500000000000000000e-1), SC_(1.000000000000000000000000000000000000000), SC_(5.281768475774354681284161978239667526735e-43) }}, 
      {{ SC_(1.359076538085937500000000000000000000000e2), SC_(1.019307403564453125000000000000000000000e2), SC_(1.584414672851562500000000000000000000000e2), SC_(9.356517195701599121093750000000000000000e-1), SC_(1.000000000000000000000000000000000000000), SC_(1.425128089037623568392503004839351263211e-41) }}, 
      {{ SC_(1.359076538085937500000000000000000000000e2), SC_(1.019307403564453125000000000000000000000e2), SC_(1.962219390869140625000000000000000000000e2), SC_(9.392650723457336425781250000000000000000e-1), SC_(1.000000000000000000000000000000000000000), SC_(4.133602628620946565872501858937186594686e-41) }}, 
      {{ SC_(1.359076538085937500000000000000000000000e2), SC_(1.223168869018554687500000000000000000000e2), SC_(7.142335891723632812500000000000000000000), SC_(5.327529832720756530761718750000000000000e-2), SC_(4.141414375913391103143875592490084610345e-102), SC_(1.000000000000000000000000000000000000000) }}, 
      {{ SC_(1.359076538085937500000000000000000000000e2), SC_(1.223168869018554687500000000000000000000e2), SC_(7.974770355224609375000000000000000000000e1), SC_(5.894920229911804199218750000000000000000e-2), SC_(1.841626794075514361324794550711739818718e-110), SC_(1.000000000000000000000000000000000000000) }}, 
      {{ SC_(1.359076538085937500000000000000000000000e2), SC_(1.223168869018554687500000000000000000000e2), SC_(1.595857238769531250000000000000000000000e2), SC_(6.378816813230514526367187500000000000000e-2), SC_(3.226617786083988065402197006946666208013e-121), SC_(1.000000000000000000000000000000000000000) }}, 
      {{ SC_(1.359076538085937500000000000000000000000e2), SC_(1.223168869018554687500000000000000000000e2), SC_(1.985762634277343750000000000000000000000e2), SC_(6.576012820005416870117187500000000000000e-2), SC_(7.377800326851234620729198685593700418117e-127), SC_(1.000000000000000000000000000000000000000) }}, 
      {{ SC_(1.359076538085937500000000000000000000000e2), SC_(1.345485839843750000000000000000000000000e2), SC_(1.950807952880859375000000000000000000000e1), SC_(1.299425810575485229492187500000000000000e-1), SC_(1.543034278995972708641240743047116272233e-52), SC_(1.000000000000000000000000000000000000000) }}, 
      {{ SC_(1.359076538085937500000000000000000000000e2), SC_(1.345485839843750000000000000000000000000e2), SC_(8.435225677490234375000000000000000000000e1), SC_(1.423602849245071411132812500000000000000e-1), SC_(4.282880818608136035230580763159132031931e-58), SC_(1.000000000000000000000000000000000000000) }}, 
      {{ SC_(1.359076538085937500000000000000000000000e2), SC_(1.345485839843750000000000000000000000000e2), SC_(1.596211700439453125000000000000000000000e2), SC_(1.539046019315719604492187500000000000000e-1), SC_(1.584873196861740980999360162438812432147e-65), SC_(1.000000000000000000000000000000000000000) }}, 
      {{ SC_(1.359076538085937500000000000000000000000e2), SC_(1.345485839843750000000000000000000000000e2), SC_(1.992922668457031250000000000000000000000e2), SC_(1.590478271245956420898437500000000000000e-1), SC_(9.867264188155777293620060270974210097043e-70), SC_(1.000000000000000000000000000000000000000) }}, 
      {{ SC_(1.359076538085937500000000000000000000000e2), SC_(1.357717437744140625000000000000000000000e2), SC_(2.197235107421875000000000000000000000000e1), SC_(2.598037719726562500000000000000000000000e-1), SC_(6.961885310638923892793083861372462721010e-20), SC_(9.999999999999999999303811468936107610721e-1) }}, 
      {{ SC_(1.359076538085937500000000000000000000000e2), SC_(1.357717437744140625000000000000000000000e2), SC_(8.441753387451171875000000000000000000000e1), SC_(2.836332619190216064453125000000000000000e-1), SC_(1.127326126422671680027203042032780158058e-22), SC_(9.999999999999999999998872673873577328320e-1) }}, 
      {{ SC_(1.359076538085937500000000000000000000000e2), SC_(1.357717437744140625000000000000000000000e2), SC_(1.600560913085937500000000000000000000000e2), SC_(3.068571090698242187500000000000000000000e-1), SC_(1.445374660423472200253091084718738323550e-26), SC_(9.999999999999999999999999855462533957653e-1) }}, 
      {{ SC_(1.359076538085937500000000000000000000000e2), SC_(1.359076538085937500000000000000000000000e2), SC_(2.249290275573730468750000000000000000000e1), SC_(3.898487687110900878906250000000000000000e-1), SC_(7.604514065946599612164811960630622626570e-6), SC_(9.999923954859340534003878351880393693774e-1) }}, 
      {{ SC_(1.359076538085937500000000000000000000000e2), SC_(1.359076538085937500000000000000000000000e2), SC_(9.495173645019531250000000000000000000000e1), SC_(4.306106567382812500000000000000000000000e-1), SC_(7.093380817278661283129838491877823728515e-7), SC_(9.999992906619182721338716870161508122176e-1) }}, 
      {{ SC_(1.359076538085937500000000000000000000000e2), SC_(1.359076538085937500000000000000000000000e2), SC_(1.629447326660156250000000000000000000000e2), SC_(4.612911343574523925781250000000000000000e-1), SC_(5.356908806829135511211773073483004718850e-8), SC_(9.999999464309119317086448878822692651700e-1) }}, 
      {{ SC_(1.359076538085937500000000000000000000000e2), SC_(1.359212493896484375000000000000000000000e2), SC_(2.539736366271972656250000000000000000000e1), SC_(4.699949026107788085937500000000000000000e-1), SC_(4.214382868157435049463175820484992679405e-2), SC_(9.578561713184256495053682417951500732059e-1) }}, 
      {{ SC_(1.359076538085937500000000000000000000000e2), SC_(1.359212493896484375000000000000000000000e2), SC_(9.707512664794921875000000000000000000000e1), SC_(5.179781317710876464843750000000000000000e-1), SC_(2.520803920639561197700960278891530430329e-2), SC_(9.747919607936043880229903972110846956967e-1) }}, 
      {{ SC_(1.359076538085937500000000000000000000000e2), SC_(1.359212493896484375000000000000000000000e2), SC_(1.670017089843750000000000000000000000000e2), SC_(5.555030107498168945312500000000000000000e-1), SC_(1.415508979385029576709457103362514319024e-2), SC_(9.858449102061497042329054289663748568098e-1) }}, 
      {{ SC_(1.359076538085937500000000000000000000000e2), SC_(1.360435638427734375000000000000000000000e2), SC_(2.709540176391601562500000000000000000000e1), SC_(5.181750655174255371093750000000000000000e-1), SC_(4.301630518228897179584822516499598343056e-1), SC_(5.698369481771102820415177483500401656944e-1) }}, 
      {{ SC_(1.359076538085937500000000000000000000000e2), SC_(1.360435638427734375000000000000000000000e2), SC_(1.007325439453125000000000000000000000000e2), SC_(5.719388127326965332031250000000000000000e-1), SC_(4.178751436571381142690174921831553066768e-1), SC_(5.821248563428618857309825078168446933232e-1) }}, 
      {{ SC_(1.359076538085937500000000000000000000000e2), SC_(1.360435638427734375000000000000000000000e2), SC_(1.698258666992187500000000000000000000000e2), SC_(6.123411059379577636718750000000000000000e-1), SC_(4.064440583678411217351617094477825695360e-1), SC_(5.935559416321588782648382905522174304640e-1) }}, 
      {{ SC_(1.359076538085937500000000000000000000000e2), SC_(1.372667236328125000000000000000000000000e2), SC_(2.837726783752441406250000000000000000000e1), SC_(5.217185616493225097656250000000000000000e-1), SC_(4.919831253579527144280764670430958880825e-1), SC_(5.080168746420472855719235329569041119175e-1) }}, 
      {{ SC_(1.359076538085937500000000000000000000000e2), SC_(1.372667236328125000000000000000000000000e2), SC_(1.093762969970703125000000000000000000000e2), SC_(5.805343389511108398437500000000000000000e-1), SC_(4.882522202665860714894428048366388216475e-1), SC_(5.117477797334139285105571951633611783525e-1) }}, 
      {{ SC_(1.359076538085937500000000000000000000000e2), SC_(1.372667236328125000000000000000000000000e2), SC_(1.756861267089843750000000000000000000000e2), SC_(6.189023256301879882812500000000000000000e-1), SC_(4.857916923409525355652040070187829780328e-1), SC_(5.142083076590474644347959929812170219672e-1) }}, 
      {{ SC_(1.359076538085937500000000000000000000000e2), SC_(1.494984283447265625000000000000000000000e2), SC_(3.152261734008789062500000000000000000000e1), SC_(5.035172700881958007812500000000000000000e-1), SC_(4.994627265195546279081083754115960479649e-1), SC_(5.005372734804453720918916245884039520351e-1) }}, 
      {{ SC_(1.359076538085937500000000000000000000000e2), SC_(1.494984283447265625000000000000000000000e2), SC_(1.094441146850585937500000000000000000000e2), SC_(5.602564811706542968750000000000000000000e-1), SC_(4.969797187121369177518941062039668817466e-1), SC_(5.030202812878630822481058937960331182534e-1) }}, 
      {{ SC_(1.359076538085937500000000000000000000000e2), SC_(1.494984283447265625000000000000000000000e2), SC_(1.811583862304687500000000000000000000000e2), SC_(6.021274328231811523437500000000000000000e-1), SC_(4.953869265081060108575721193843691925182e-1), SC_(5.046130734918939891424278806156308074818e-1) }}, 
      {{ SC_(1.359076538085937500000000000000000000000e2), SC_(1.630891876220703125000000000000000000000e2), SC_(3.423733520507812500000000000000000000000e1), SC_(4.840467870235443115234375000000000000000e-1), SC_(5.007517123728652815517643906569375254905e-1), SC_(4.992482876271347184482356093430624745095e-1) }}, 
      {{ SC_(1.359076538085937500000000000000000000000e2), SC_(1.630891876220703125000000000000000000000e2), SC_(1.264718551635742187500000000000000000000e2), SC_(5.495949387550354003906250000000000000000e-1), SC_(4.978866682648840681378349722066183047461e-1), SC_(5.021133317351159318621650277933816952539e-1) }}, 
      {{ SC_(1.359076538085937500000000000000000000000e2), SC_(1.630891876220703125000000000000000000000e2), SC_(1.826751708984375000000000000000000000000e2), SC_(5.819721817970275878906250000000000000000e-1), SC_(4.966606098368166246374759515201571274205e-1), SC_(5.033393901631833753625240484798428725795e-1) }}, 
      {{ SC_(1.359076538085937500000000000000000000000e2), SC_(1.766799468994140625000000000000000000000e2), SC_(3.477303314208984375000000000000000000000e1), SC_(4.650137424468994140625000000000000000000e-1), SC_(5.081636751493102929365064759835218322905e-1), SC_(4.918363248506897070634935240164781677095e-1) }}, 
      {{ SC_(1.359076538085937500000000000000000000000e2), SC_(1.766799468994140625000000000000000000000e2), SC_(1.279526672363281250000000000000000000000e2), SC_(5.310674905776977539062500000000000000000e-1), SC_(5.046043963857151728282946122147897933320e-1), SC_(4.953956036142848271717053877852102066680e-1) }}, 
      {{ SC_(1.359076538085937500000000000000000000000e2), SC_(1.766799468994140625000000000000000000000e2), SC_(1.831471099853515625000000000000000000000e2), SC_(5.630396604537963867187500000000000000000e-1), SC_(5.031568689605989315469704298517890159224e-1), SC_(4.968431310394010684530295701482109840776e-1) }}, 
      {{ SC_(1.359076538085937500000000000000000000000e2), SC_(2.038614807128906250000000000000000000000e2), SC_(3.767639541625976562500000000000000000000e1), SC_(4.370649755001068115234375000000000000000e-1), SC_(5.838276897892931186883581323592806750689e-1), SC_(4.161723102107068813116418676407193249311e-1) }}, 
      {{ SC_(1.359076538085937500000000000000000000000e2), SC_(2.038614807128906250000000000000000000000e2), SC_(1.310955810546875000000000000000000000000e2), SC_(5.018131136894226074218750000000000000000e-1), SC_(5.725744427358787008394989494483667423374e-1), SC_(4.274255572641212991605010505516332576626e-1) }}, 
      {{ SC_(1.359076538085937500000000000000000000000e2), SC_(2.038614807128906250000000000000000000000e2), SC_(1.867986450195312500000000000000000000000e2), SC_(5.337990522384643554687500000000000000000e-1), SC_(5.683491048825034056533842467050406818277e-1), SC_(4.316508951174965943466157532949593181723e-1) }}, 
      {{ SC_(1.359076538085937500000000000000000000000e2), SC_(2.718153076171875000000000000000000000000e2), SC_(4.238486480712890625000000000000000000000e1), SC_(4.238181114196777343750000000000000000000e-1), SC_(9.905568109073204649106154593010407900406e-1), SC_(9.443189092679535089384540698959209959435e-3) }}, 
      {{ SC_(1.359076538085937500000000000000000000000e2), SC_(2.718153076171875000000000000000000000000e2), SC_(1.311481323242187500000000000000000000000e2), SC_(4.777546823024749755859375000000000000000e-1), SC_(9.824331416672396177015667022539985863162e-1), SC_(1.756685833276038229843329774600141368380e-2) }}, 
      {{ SC_(1.359076538085937500000000000000000000000e2), SC_(2.718153076171875000000000000000000000000e2), SC_(1.914333953857421875000000000000000000000e2), SC_(5.089815855026245117187500000000000000000e-1), SC_(9.775455343302809723272751778798485996986e-1), SC_(2.245446566971902767272482212015140030139e-2) }}, 
      {{ SC_(1.359076538085937500000000000000000000000e2), SC_(4.077229614257812500000000000000000000000e2), SC_(4.420680999755859375000000000000000000000e1), SC_(3.993774950504302978515625000000000000000e-1), SC_(9.999999951646378432602960178294489198621e-1), SC_(4.835362156739703982170551080137887232642e-9) }}, 
      {{ SC_(1.359076538085937500000000000000000000000e2), SC_(4.077229614257812500000000000000000000000e2), SC_(1.357470245361328125000000000000000000000e2), SC_(4.442706406116485595703125000000000000000e-1), SC_(9.999998683834005580422849960428046824499e-1), SC_(1.316165994419577150039571953175500634610e-7) }}, 
      {{ SC_(1.359076538085937500000000000000000000000e2), SC_(4.077229614257812500000000000000000000000e2), SC_(1.915013732910156250000000000000000000000e2), SC_(4.684725701808929443359375000000000000000e-1), SC_(9.999995635729337250430625090445485756161e-1), SC_(4.364270662749569374909554514243839079825e-7) }}, 
      {{ SC_(1.359076538085937500000000000000000000000e2), SC_(5.436306152343750000000000000000000000000e2), SC_(5.569964599609375000000000000000000000000e1), SC_(4.088101089000701904296875000000000000000e-1), SC_(9.999999999999999999987435900947883218916e-1), SC_(1.256409905211678108358586725202590903341e-21) }}, 
      {{ SC_(1.359076538085937500000000000000000000000e2), SC_(5.436306152343750000000000000000000000000e2), SC_(1.362719116210937500000000000000000000000e2), SC_(4.406275451183319091796875000000000000000e-1), SC_(9.999999999999999983340811461080893973503e-1), SC_(1.665918853891910602649742032278341646915e-18) }}, 
      {{ SC_(1.359076538085937500000000000000000000000e2), SC_(5.436306152343750000000000000000000000000e2), SC_(1.918984832763671875000000000000000000000e2), SC_(4.606694281101226806640625000000000000000e-1), SC_(9.999999999999999597081272880870118845998e-1), SC_(4.029187271191298811540017935743319005103e-17) }}, 
      {{ SC_(1.359076538085937500000000000000000000000e2), SC_(6.795382690429687500000000000000000000000e2), SC_(5.940588760375976562500000000000000000000e1), SC_(4.639472663402557373046875000000000000000e-1), SC_(1.000000000000000000000000000000000000000), SC_(8.826647173960977584889012636778217674021e-55) }}, 
      {{ SC_(1.359076538085937500000000000000000000000e2), SC_(6.795382690429687500000000000000000000000e2), SC_(1.451677856445312500000000000000000000000e2), SC_(4.898062944412231445312500000000000000000e-1), SC_(1.000000000000000000000000000000000000000), SC_(2.210006699064197097568526372708567056945e-47) }}, 
      {{ SC_(1.359076538085937500000000000000000000000e2), SC_(6.795382690429687500000000000000000000000e2), SC_(1.929777069091796875000000000000000000000e2), SC_(5.031683444976806640625000000000000000000e-1), SC_(1.000000000000000000000000000000000000000), SC_(1.280759930633465232897434290458834254221e-44) }}, 
      {{ SC_(1.364312286376953125000000000000000000000e2), SC_(1.364312267303466796875000000000000000000e1), SC_(4.420680999755859375000000000000000000000e1), SC_(9.603511691093444824218750000000000000000e-1), SC_(9.881369967031882313105262628199340859903e-1), SC_(1.186300329681176868947373718006591400974e-2) }}, 
      {{ SC_(1.364312286376953125000000000000000000000e2), SC_(1.364312267303466796875000000000000000000e1), SC_(1.357470245361328125000000000000000000000e2), SC_(9.686561822891235351562500000000000000000e-1), SC_(9.873947676794507775002488611562359291607e-1), SC_(1.260523232054922249975113884376407083929e-2) }}, 
      {{ SC_(1.364312286376953125000000000000000000000e2), SC_(1.364312267303466796875000000000000000000e1), SC_(1.915013732910156250000000000000000000000e2), SC_(9.722063541412353515625000000000000000000e-1), SC_(9.871272568589251353250279189483626785685e-1), SC_(1.287274314107486467497208105163732143145e-2) }}, 
      {{ SC_(1.364312286376953125000000000000000000000e2), SC_(3.410780715942382812500000000000000000000e1), SC_(5.569964599609375000000000000000000000000e1), SC_(9.426514506340026855468750000000000000000e-1), SC_(9.999999889347907250260262576604837658750e-1), SC_(1.106520927497397374233951623412498420095e-8) }}, 
      {{ SC_(1.364312286376953125000000000000000000000e2), SC_(3.410780715942382812500000000000000000000e1), SC_(1.362719116210937500000000000000000000000e2), SC_(9.523080587387084960937500000000000000000e-1), SC_(9.999999830379413841388726306909085734961e-1), SC_(1.696205861586112736930909142650387261418e-8) }}, 
      {{ SC_(1.364312286376953125000000000000000000000e2), SC_(3.410780715942382812500000000000000000000e1), SC_(1.918984832763671875000000000000000000000e2), SC_(9.572790861129760742187500000000000000000e-1), SC_(9.999999797078967482282336067314597673305e-1), SC_(2.029210325177176639326854023266952472686e-8) }}, 
      {{ SC_(1.364312286376953125000000000000000000000e2), SC_(6.821561431884765625000000000000000000000e1), SC_(5.940588760375976562500000000000000000000e1), SC_(9.271894693374633789062500000000000000000e-1), SC_(9.999999999999999999999669018123248835493e-1), SC_(3.309818767511645067863701039758444539782e-23) }}, 
      {{ SC_(1.364312286376953125000000000000000000000e2), SC_(6.821561431884765625000000000000000000000e1), SC_(1.451677856445312500000000000000000000000e2), SC_(9.384267330169677734375000000000000000000e-1), SC_(9.999999999999999999997963302283217230510e-1), SC_(2.036697716782769489961538887354492580007e-22) }}, 
      {{ SC_(1.364312286376953125000000000000000000000e2), SC_(6.821561431884765625000000000000000000000e1), SC_(1.929777069091796875000000000000000000000e2), SC_(9.433077573776245117187500000000000000000e-1), SC_(9.999999999999999999996149279643541853977e-1), SC_(3.850720356458146022618520999312043766451e-22) }}, 
      {{ SC_(1.364312286376953125000000000000000000000e2), SC_(1.023234252929687500000000000000000000000e2), SC_(6.038262176513671875000000000000000000000e1), SC_(9.238760471343994140625000000000000000000e-1), SC_(1.000000000000000000000000000000000000000), SC_(1.261622092848031882352135431492908977387e-43) }}, 
      {{ SC_(1.364312286376953125000000000000000000000e2), SC_(1.023234252929687500000000000000000000000e2), SC_(1.481294555664062500000000000000000000000e2), SC_(9.345303773880004882812500000000000000000e-1), SC_(1.000000000000000000000000000000000000000), SC_(7.031495686033262409697164431761407088710e-42) }}, 
      {{ SC_(1.364312286376953125000000000000000000000e2), SC_(1.023234252929687500000000000000000000000e2), SC_(1.935389862060546875000000000000000000000e2), SC_(9.389544129371643066406250000000000000000e-1), SC_(1.000000000000000000000000000000000000000), SC_(2.673305642322184797016486771249322492038e-41) }}, 
      {{ SC_(1.364312286376953125000000000000000000000e2), SC_(1.227881011962890625000000000000000000000e2), SC_(6.163340759277343750000000000000000000000e1), SC_(5.764902755618095397949218750000000000000e-2), SC_(1.341468038116811854310768875467953043400e-108), SC_(1.000000000000000000000000000000000000000) }}, 
      {{ SC_(1.364312286376953125000000000000000000000e2), SC_(1.227881011962890625000000000000000000000e2), SC_(1.486264953613281250000000000000000000000e2), SC_(6.316097825765609741210937500000000000000e-2), SC_(4.810312983001360057456989527069744638647e-120), SC_(1.000000000000000000000000000000000000000) }}, 
      {{ SC_(1.364312286376953125000000000000000000000e2), SC_(1.227881011962890625000000000000000000000e2), SC_(1.937735595703125000000000000000000000000e2), SC_(6.549289077520370483398437500000000000000e-2), SC_(1.604351279833063145186989511855123129254e-126), SC_(1.000000000000000000000000000000000000000) }}, 
      {{ SC_(1.364312286376953125000000000000000000000e2), SC_(1.350669250488281250000000000000000000000e2), SC_(7.225879669189453125000000000000000000000e1), SC_(1.401931196451187133789062500000000000000e-1), SC_(3.575223249023877098936384542429108054215e-57), SC_(1.000000000000000000000000000000000000000) }}, 
      {{ SC_(1.364312286376953125000000000000000000000e2), SC_(1.350669250488281250000000000000000000000e2), SC_(1.515480346679687500000000000000000000000e2), SC_(1.527047008275985717773437500000000000000e-1), SC_(7.133395482085759961947541759273017820373e-65), SC_(1.000000000000000000000000000000000000000) }}, 
      {{ SC_(1.364312286376953125000000000000000000000e2), SC_(1.350669250488281250000000000000000000000e2), SC_(1.941185607910156250000000000000000000000e2), SC_(1.583158969879150390625000000000000000000e-1), SC_(2.365042606011588426798569816849894679394e-69), SC_(1.000000000000000000000000000000000000000) }}, 
      {{ SC_(1.364312286376953125000000000000000000000e2), SC_(1.362947998046875000000000000000000000000e2), SC_(9.566968083381652832031250000000000000000e-1), SC_(2.505609691143035888671875000000000000000e-1), SC_(3.923403535249831055967919677615549478831e-19), SC_(9.999999999999999996076596464750168944032e-1) }}, 
      {{ SC_(1.364312286376953125000000000000000000000e2), SC_(1.362947998046875000000000000000000000000e2), SC_(7.844540405273437500000000000000000000000e1), SC_(2.814548909664154052734375000000000000000e-1), SC_(1.877551112266221324474109831008837465355e-22), SC_(9.999999999999999999998122448887733778676e-1) }}, 
      {{ SC_(1.364312286376953125000000000000000000000e2), SC_(1.362947998046875000000000000000000000000e2), SC_(1.584414672851562500000000000000000000000e2), SC_(3.062463104724884033203125000000000000000e-1), SC_(1.535022057256975011783232559894910415079e-26), SC_(9.999999999999999999999999846497794274302e-1) }}, 
      {{ SC_(1.364312286376953125000000000000000000000e2), SC_(1.362947998046875000000000000000000000000e2), SC_(1.962219390869140625000000000000000000000e2), SC_(3.161024451255798339843750000000000000000e-1), SC_(1.239478632040633244590177009482750794129e-28), SC_(9.999999999999999999999999998760521367959e-1) }}, 
      {{ SC_(1.364312286376953125000000000000000000000e2), SC_(1.364312286376953125000000000000000000000e2), SC_(7.142335891723632812500000000000000000000), SC_(3.798272013664245605468750000000000000000e-1), SC_(1.136170709022903804930093332832773028551e-5), SC_(9.999886382929097709619506990666716722697e-1) }}, 
      {{ SC_(1.364312286376953125000000000000000000000e2), SC_(1.364312286376953125000000000000000000000e2), SC_(7.974770355224609375000000000000000000000e1), SC_(4.226790666580200195312500000000000000000e-1), SC_(1.169848943544311000888230712367058331211e-6), SC_(9.999988301510564556889991117692876329417e-1) }}, 
      {{ SC_(1.364312286376953125000000000000000000000e2), SC_(1.364312286376953125000000000000000000000e2), SC_(1.595857238769531250000000000000000000000e2), SC_(4.596624970436096191406250000000000000000e-1), SC_(5.940426759564314338503240785883544303835e-8), SC_(9.999999405957324043568566149675921411646e-1) }}, 
      {{ SC_(1.364312286376953125000000000000000000000e2), SC_(1.364312286376953125000000000000000000000e2), SC_(1.985762634277343750000000000000000000000e2), SC_(4.748512208461761474609375000000000000000e-1), SC_(1.200678548062534950542039641124138599627e-8), SC_(9.999999879932145193746504945796035887586e-1) }}, 
      {{ SC_(1.364312286376953125000000000000000000000e2), SC_(1.364448699951171875000000000000000000000e2), SC_(1.950807952880859375000000000000000000000e1), SC_(4.654554724693298339843750000000000000000e-1), SC_(4.348936326906948143634291395152009981009e-2), SC_(9.565106367309305185636570860484799001899e-1) }}, 
      {{ SC_(1.364312286376953125000000000000000000000e2), SC_(1.364448699951171875000000000000000000000e2), SC_(8.435225677490234375000000000000000000000e1), SC_(5.100564956665039062500000000000000000000e-1), SC_(2.762495426137325937348836639611789282596e-2), SC_(9.723750457386267406265116336038821071740e-1) }}, 
      {{ SC_(1.364312286376953125000000000000000000000e2), SC_(1.364448699951171875000000000000000000000e2), SC_(1.596211700439453125000000000000000000000e2), SC_(5.515910983085632324218750000000000000000e-1), SC_(1.501325733437995554537014061842681943174e-2), SC_(9.849867426656200444546298593815731805683e-1) }}, 
      {{ SC_(1.364312286376953125000000000000000000000e2), SC_(1.364448699951171875000000000000000000000e2), SC_(1.992922668457031250000000000000000000000e2), SC_(5.701175332069396972656250000000000000000e-1), SC_(1.056299165986073635801168297885812656791e-2), SC_(9.894370083401392636419883170211418734321e-1) }}, 
      {{ SC_(1.364312286376953125000000000000000000000e2), SC_(1.365676727294921875000000000000000000000e2), SC_(2.197235107421875000000000000000000000000e1), SC_(5.138467550277709960937500000000000000000e-1), SC_(4.308965715935447483014762660040709973866e-1), SC_(5.691034284064552516985237339959290026134e-1) }}, 
      {{ SC_(1.364312286376953125000000000000000000000e2), SC_(1.365676727294921875000000000000000000000e2), SC_(8.441753387451171875000000000000000000000e1), SC_(5.608878731727600097656250000000000000000e-1), SC_(4.205115895945592658367844985198392335626e-1), SC_(5.794884104054407341632155014801607664374e-1) }}, 
      {{ SC_(1.364312286376953125000000000000000000000e2), SC_(1.365676727294921875000000000000000000000e2), SC_(1.600560913085937500000000000000000000000e2), SC_(6.067748069763183593750000000000000000000e-1), SC_(4.079949836283281856228711114627272676049e-1), SC_(5.920050163716718143771288885372727323951e-1) }}, 
      {{ SC_(1.364312286376953125000000000000000000000e2), SC_(1.377955322265625000000000000000000000000e2), SC_(2.249290275573730468750000000000000000000e1), SC_(5.167245268821716308593750000000000000000e-1), SC_(4.922868152315913527283941957273279930318e-1), SC_(5.077131847684086472716058042726720069682e-1) }}, 
      {{ SC_(1.364312286376953125000000000000000000000e2), SC_(1.377955322265625000000000000000000000000e2), SC_(9.495173645019531250000000000000000000000e1), SC_(5.709000229835510253906250000000000000000e-1), SC_(4.888560123270172607528639281317040286265e-1), SC_(5.111439876729827392471360718682959713735e-1) }}, 
      {{ SC_(1.364312286376953125000000000000000000000e2), SC_(1.377955322265625000000000000000000000000e2), SC_(1.629447326660156250000000000000000000000e2), SC_(6.117446422576904296875000000000000000000e-1), SC_(4.862463979035056365749406465438461578352e-1), SC_(5.137536020964943634250593534561538421648e-1) }}, 
      {{ SC_(1.364312286376953125000000000000000000000e2), SC_(1.500743560791015625000000000000000000000e2), SC_(2.539736366271972656250000000000000000000e1), SC_(4.983505904674530029296875000000000000000e-1), SC_(4.997044336811842330308119388108485617530e-1), SC_(5.002955663188157669691880611891514382470e-1) }}, 
      {{ SC_(1.364312286376953125000000000000000000000e2), SC_(1.500743560791015625000000000000000000000e2), SC_(9.707512664794921875000000000000000000000e1), SC_(5.518808364868164062500000000000000000000e-1), SC_(4.973287770001349356061526167957268933155e-1), SC_(5.026712229998650643938473832042731066845e-1) }}, 
      {{ SC_(1.364312286376953125000000000000000000000e2), SC_(1.500743560791015625000000000000000000000e2), SC_(1.670017089843750000000000000000000000000e2), SC_(5.941532850265502929687500000000000000000e-1), SC_(4.956819241349025716587978781548016150416e-1), SC_(5.043180758650974283412021218451983849584e-1) }}, 
      {{ SC_(1.364312286376953125000000000000000000000e2), SC_(1.637174835205078125000000000000000000000e2), SC_(2.709540176391601562500000000000000000000e1), SC_(4.780825078487396240234375000000000000000e-1), SC_(5.010345611377718030849948948371055853218e-1), SC_(4.989654388622281969150051051628944146782e-1) }}, 
      {{ SC_(1.364312286376953125000000000000000000000e2), SC_(1.637174835205078125000000000000000000000e2), SC_(1.007325439453125000000000000000000000000e2), SC_(5.327782630920410156250000000000000000000e-1), SC_(4.985799570694381230717008433005984152720e-1), SC_(5.014200429305618769282991566994015847280e-1) }}, 
      {{ SC_(1.364312286376953125000000000000000000000e2), SC_(1.637174835205078125000000000000000000000e2), SC_(1.698258666992187500000000000000000000000e2), SC_(5.746269226074218750000000000000000000000e-1), SC_(4.969361738727664643609871461026276993217e-1), SC_(5.030638261272335356390128538973723006783e-1) }}, 
      {{ SC_(1.364312286376953125000000000000000000000e2), SC_(1.773605957031250000000000000000000000000e2), SC_(2.837726783752441406250000000000000000000e1), SC_(4.597032368183135986328125000000000000000e-1), SC_(5.084963114673491874966657802390627572890e-1), SC_(4.915036885326508125033342197609372427110e-1) }}, 
      {{ SC_(1.364312286376953125000000000000000000000e2), SC_(1.773605957031250000000000000000000000000e2), SC_(1.093762969970703125000000000000000000000e2), SC_(5.189568400382995605468750000000000000000e-1), SC_(5.052148003074357310809517287912505611691e-1), SC_(4.947851996925642689190482712087494388309e-1) }}, 
      {{ SC_(1.364312286376953125000000000000000000000e2), SC_(1.773605957031250000000000000000000000000e2), SC_(1.756861267089843750000000000000000000000e2), SC_(5.586043596267700195312500000000000000000e-1), SC_(5.033667753430740901331623612773331309398e-1), SC_(4.966332246569259098668376387226668690602e-1) }}, 
      {{ SC_(1.364312286376953125000000000000000000000e2), SC_(2.046468505859375000000000000000000000000e2), SC_(3.152261734008789062500000000000000000000e1), SC_(4.321094155311584472656250000000000000000e-1), SC_(5.850409079372896709912620373811126996777e-1), SC_(4.149590920627103290087379626188873003223e-1) }}, 
      {{ SC_(1.364312286376953125000000000000000000000e2), SC_(2.046468505859375000000000000000000000000e2), SC_(1.094441146850585937500000000000000000000e2), SC_(4.878945052623748779296875000000000000000e-1), SC_(5.747953274717674839224344956030023308325e-1), SC_(4.252046725282325160775655043969976691675e-1) }}, 
      {{ SC_(1.364312286376953125000000000000000000000e2), SC_(2.046468505859375000000000000000000000000e2), SC_(1.811583862304687500000000000000000000000e2), SC_(5.303701758384704589843750000000000000000e-1), SC_(5.689100305098896881755117812497496528348e-1), SC_(4.310899694901103118244882187502503471652e-1) }}, 
      {{ SC_(1.364312286376953125000000000000000000000e2), SC_(2.728624572753906250000000000000000000000e2), SC_(3.423733520507812500000000000000000000000e1), SC_(4.182154536247253417968750000000000000000e-1), SC_(9.914438185050059826685565476091030081980e-1), SC_(8.556181494994017331443452390896991802048e-3) }}, 
      {{ SC_(1.364312286376953125000000000000000000000e2), SC_(2.728624572753906250000000000000000000000e2), SC_(1.264718551635742187500000000000000000000e2), SC_(4.748963415622711181640625000000000000000e-1), SC_(9.830512672834159163393982663946600900399e-1), SC_(1.694873271658408366060173360533990996010e-2) }}, 
      {{ SC_(1.364312286376953125000000000000000000000e2), SC_(2.728624572753906250000000000000000000000e2), SC_(1.826751708984375000000000000000000000000e2), SC_(5.043314695358276367187500000000000000000e-1), SC_(9.784732306442053628134094921529997964968e-1), SC_(2.152676935579463718659050784700020350316e-2) }}, 
      {{ SC_(1.364312286376953125000000000000000000000e2), SC_(4.092937011718750000000000000000000000000e2), SC_(3.477303314208984375000000000000000000000e1), SC_(3.942641615867614746093750000000000000000e-1), SC_(9.999999973101214678522418203474553752753e-1), SC_(2.689878532147758179652544624724727636793e-9) }}, 
      {{ SC_(1.364312286376953125000000000000000000000e2), SC_(4.092937011718750000000000000000000000000e2), SC_(1.279526672363281250000000000000000000000e2), SC_(4.404853880405426025390625000000000000000e-1), SC_(9.999998994439350793979977258598276294369e-1), SC_(1.005560649206020022741401723705630669500e-7) }}, 
      {{ SC_(1.364312286376953125000000000000000000000e2), SC_(4.092937011718750000000000000000000000000e2), SC_(1.831471099853515625000000000000000000000e2), SC_(4.646857380867004394531250000000000000000e-1), SC_(9.999996492115982967847785825566124445813e-1), SC_(3.507884017032152214174433875554187224804e-7) }}, 
      {{ SC_(1.364312286376953125000000000000000000000e2), SC_(5.457249145507812500000000000000000000000e2), SC_(3.767639541625976562500000000000000000000e1), SC_(4.011299610137939453125000000000000000000e-1), SC_(9.999999999999999999999028449801727466858e-1), SC_(9.715501982725331419184769032078347577119e-23) }}, 
      {{ SC_(1.364312286376953125000000000000000000000e2), SC_(5.457249145507812500000000000000000000000e2), SC_(1.310955810546875000000000000000000000000e2), SC_(4.384974837303161621093750000000000000000e-1), SC_(9.999999999999999990245958240946660590725e-1), SC_(9.754041759053339409275013230321749769085e-19) }}, 
      {{ SC_(1.364312286376953125000000000000000000000e2), SC_(5.457249145507812500000000000000000000000e2), SC_(1.867986450195312500000000000000000000000e2), SC_(4.586414396762847900390625000000000000000e-1), SC_(9.999999999999999736955217468477508781278e-1), SC_(2.630447825315224912187224675590080590957e-17) }}, 
      {{ SC_(1.364312286376953125000000000000000000000e2), SC_(6.821561279296875000000000000000000000000e2), SC_(4.238486480712890625000000000000000000000e1), SC_(4.584479928016662597656250000000000000000e-1), SC_(1.000000000000000000000000000000000000000), SC_(3.897005045044657489142289387853327405332e-57) }}, 
      {{ SC_(1.364312286376953125000000000000000000000e2), SC_(6.821561279296875000000000000000000000000e2), SC_(1.311481323242187500000000000000000000000e2), SC_(4.856042265892028808593750000000000000000e-1), SC_(1.000000000000000000000000000000000000000), SC_(1.511059585860322905073561941394914652082e-48) }}, 
      {{ SC_(1.364312286376953125000000000000000000000e2), SC_(6.821561279296875000000000000000000000000e2), SC_(1.914333953857421875000000000000000000000e2), SC_(5.025475025177001953125000000000000000000e-1), SC_(1.000000000000000000000000000000000000000), SC_(6.695168697305792924965115180551787605635e-45) }}, 
      {{ SC_(1.453048706054687500000000000000000000000e2), SC_(1.453048706054687500000000000000000000000e1), SC_(3.477303314208984375000000000000000000000e1), SC_(9.589821100234985351562500000000000000000e-1), SC_(9.904610224564394526938268180661343224073e-1), SC_(9.538977543560547306173181933865677592722e-3) }}, 
      {{ SC_(1.453048706054687500000000000000000000000e2), SC_(1.453048706054687500000000000000000000000e1), SC_(1.279526672363281250000000000000000000000e2), SC_(9.674971103668212890625000000000000000000e-1), SC_(9.897876135101053212003961920867321334145e-1), SC_(1.021238648989467879960380791326786658554e-2) }}, 
      {{ SC_(1.453048706054687500000000000000000000000e2), SC_(1.453048706054687500000000000000000000000e1), SC_(1.831471099853515625000000000000000000000e2), SC_(9.710600376129150390625000000000000000000e-1), SC_(9.895485921711384064196893592093370307000e-1), SC_(1.045140782886159358031064079066296930002e-2) }}, 
      {{ SC_(1.453048706054687500000000000000000000000e2), SC_(3.632621765136718750000000000000000000000e1), SC_(3.767639541625976562500000000000000000000e1), SC_(9.395697116851806640625000000000000000000e-1), SC_(9.999999967924131752700319378606956921737e-1), SC_(3.207586824729968062139304307826298992359e-9) }}, 
      {{ SC_(1.453048706054687500000000000000000000000e2), SC_(3.632621765136718750000000000000000000000e1), SC_(1.310955810546875000000000000000000000000e2), SC_(9.509596824645996093750000000000000000000e-1), SC_(9.999999943383432229801894189972062017884e-1), SC_(5.661656777019810581002793798211630874923e-9) }}, 
      {{ SC_(1.453048706054687500000000000000000000000e2), SC_(3.632621765136718750000000000000000000000e1), SC_(1.867986450195312500000000000000000000000e2), SC_(9.559187293052673339843750000000000000000e-1), SC_(9.999999931043613383204879418953230442151e-1), SC_(6.895638661679512058104676955784934830289e-9) }}, 
      {{ SC_(1.453048706054687500000000000000000000000e2), SC_(7.265243530273437500000000000000000000000e1), SC_(4.238486480712890625000000000000000000000e1), SC_(9.240231513977050781250000000000000000000e-1), SC_(9.999999999999999999999993094308046124103e-1), SC_(6.905691953875896556163795687784867711888e-25) }}, 
      {{ SC_(1.453048706054687500000000000000000000000e2), SC_(7.265243530273437500000000000000000000000e1), SC_(1.311481323242187500000000000000000000000e2), SC_(9.358874559402465820312500000000000000000e-1), SC_(9.999999999999999999999937384115063653385e-1), SC_(6.261588493634661481690969624597988678172e-24) }}, 
      {{ SC_(1.453048706054687500000000000000000000000e2), SC_(7.265243530273437500000000000000000000000e1), SC_(1.914333953857421875000000000000000000000e2), SC_(9.420392513275146484375000000000000000000e-1), SC_(9.999999999999999999999846431443384926428e-1), SC_(1.535685566150735718152481377307776388229e-23) }}, 
      {{ SC_(1.453048706054687500000000000000000000000e2), SC_(1.089786529541015625000000000000000000000e2), SC_(4.420680999755859375000000000000000000000e1), SC_(9.211177229881286621093750000000000000000e-1), SC_(1.000000000000000000000000000000000000000), SC_(6.248891907391174422368473306142728590692e-47) }}, 
      {{ SC_(1.453048706054687500000000000000000000000e2), SC_(1.089786529541015625000000000000000000000e2), SC_(1.357470245361328125000000000000000000000e2), SC_(9.323001503944396972656250000000000000000e-1), SC_(1.000000000000000000000000000000000000000), SC_(8.022829979757967776120143183475571414088e-45) }}, 
      {{ SC_(1.453048706054687500000000000000000000000e2), SC_(1.089786529541015625000000000000000000000e2), SC_(1.915013732910156250000000000000000000000e2), SC_(9.376838803291320800781250000000000000000e-1), SC_(1.000000000000000000000000000000000000000), SC_(4.937846679635695403907588282446449588637e-44) }}, 
      {{ SC_(1.453048706054687500000000000000000000000e2), SC_(1.307743835449218750000000000000000000000e2), SC_(5.569964599609375000000000000000000000000e1), SC_(5.695910006761550903320312500000000000000e-2), SC_(2.473941299960356875561550791379954859000e-114), SC_(1.000000000000000000000000000000000000000) }}, 
      {{ SC_(1.453048706054687500000000000000000000000e2), SC_(1.307743835449218750000000000000000000000e2), SC_(1.362719116210937500000000000000000000000e2), SC_(6.198611482977867126464843750000000000000e-2), SC_(1.148815821295313271563964406433936011696e-124), SC_(1.000000000000000000000000000000000000000) }}, 
      {{ SC_(1.453048706054687500000000000000000000000e2), SC_(1.307743835449218750000000000000000000000e2), SC_(1.918984832763671875000000000000000000000e2), SC_(6.482391804456710815429687500000000000000e-2), SC_(1.678630757164621777804590076190219548583e-132), SC_(1.000000000000000000000000000000000000000) }}, 
      {{ SC_(1.453048706054687500000000000000000000000e2), SC_(1.438518218994140625000000000000000000000e2), SC_(5.940588760375976562500000000000000000000e1), SC_(1.371808797121047973632812500000000000000e-1), SC_(3.337862422216849409442785857794846296039e-59), SC_(1.000000000000000000000000000000000000000) }}, 
      {{ SC_(1.453048706054687500000000000000000000000e2), SC_(1.438518218994140625000000000000000000000e2), SC_(1.451677856445312500000000000000000000000e2), SC_(1.505284309387207031250000000000000000000e-1), SC_(2.644487046101233565023869020318006579834e-67), SC_(1.000000000000000000000000000000000000000) }}, 
      {{ SC_(1.453048706054687500000000000000000000000e2), SC_(1.438518218994140625000000000000000000000e2), SC_(1.929777069091796875000000000000000000000e2), SC_(1.566855907440185546875000000000000000000e-1), SC_(2.946983202748820023624969293421919022407e-72), SC_(1.000000000000000000000000000000000000000) }}, 
      {{ SC_(1.453048706054687500000000000000000000000e2), SC_(1.451595611572265625000000000000000000000e2), SC_(6.038262176513671875000000000000000000000e1), SC_(2.735855579376220703125000000000000000000e-1), SC_(1.025285497608389828266810106861030855482e-22), SC_(9.999999999999999999998974714502391610172e-1) }}, 
      {{ SC_(1.453048706054687500000000000000000000000e2), SC_(1.451595611572265625000000000000000000000e2), SC_(1.481294555664062500000000000000000000000e2), SC_(3.007834553718566894531250000000000000000e-1), SC_(4.876551760460556184868254033346162237086e-27), SC_(9.999999999999999999999999951234482395394e-1) }}, 
      {{ SC_(1.453048706054687500000000000000000000000e2), SC_(1.451595611572265625000000000000000000000e2), SC_(1.935389862060546875000000000000000000000e2), SC_(3.124476969242095947265625000000000000000e-1), SC_(1.677179444143931181269588530987111177562e-29), SC_(9.999999999999999999999999999832282055586e-1) }}, 
      {{ SC_(1.453048706054687500000000000000000000000e2), SC_(1.453048706054687500000000000000000000000e2), SC_(6.163340759277343750000000000000000000000e1), SC_(4.108519256114959716796875000000000000000e-1), SC_(1.203274048217153520512173846340060343530e-6), SC_(9.999987967259517828464794878261536599397e-1) }}, 
      {{ SC_(1.453048706054687500000000000000000000000e2), SC_(1.453048706054687500000000000000000000000e2), SC_(1.486264953613281250000000000000000000000e2), SC_(4.511986970901489257812500000000000000000e-1), SC_(5.356229768099955789263047316180128675628e-8), SC_(9.999999464377023190004421073695268381987e-1) }}, 
      {{ SC_(1.453048706054687500000000000000000000000e2), SC_(1.453048706054687500000000000000000000000e2), SC_(1.937735595703125000000000000000000000000e2), SC_(4.685807526111602783203125000000000000000e-1), SC_(8.858716425582585904223238580763710099461e-9), SC_(9.999999911412835744174140957767614192363e-1) }}, 
      {{ SC_(1.453048706054687500000000000000000000000e2), SC_(1.453193969726562500000000000000000000000e2), SC_(7.225879669189453125000000000000000000000e1), SC_(4.996013939380645751953125000000000000000e-1), SC_(2.727604028623019884413436397820186386208e-2), SC_(9.727239597137698011558656360217981361379e-1) }}, 
      {{ SC_(1.453048706054687500000000000000000000000e2), SC_(1.453193969726562500000000000000000000000e2), SC_(1.515480346679687500000000000000000000000e2), SC_(5.428441762924194335937500000000000000000e-1), SC_(1.470967715153213318347856295774993464920e-2), SC_(9.852903228484678668165214370422500653508e-1) }}, 
      {{ SC_(1.453048706054687500000000000000000000000e2), SC_(1.453193969726562500000000000000000000000e2), SC_(1.941185607910156250000000000000000000000e2), SC_(5.624259114265441894531250000000000000000e-1), SC_(1.021070437529589935693144746173571410726e-2), SC_(9.897892956247041006430685525382642858927e-1) }}, 
      {{ SC_(1.453048706054687500000000000000000000000e2), SC_(1.454501800537109375000000000000000000000e2), SC_(9.566968083381652832031250000000000000000e-1), SC_(4.955632984638214111328125000000000000000e-1), SC_(4.322529922815496431524795227882839023421e-1), SC_(5.677470077184503568475204772117160976579e-1) }}, 
      {{ SC_(1.453048706054687500000000000000000000000e2), SC_(1.454501800537109375000000000000000000000e2), SC_(7.844540405273437500000000000000000000000e1), SC_(5.534628033638000488281250000000000000000e-1), SC_(4.200146401957495289473328819484601332842e-1), SC_(5.799853598042504710526671180515398667158e-1) }}, 
      {{ SC_(1.453048706054687500000000000000000000000e2), SC_(1.454501800537109375000000000000000000000e2), SC_(1.584414672851562500000000000000000000000e2), SC_(6.005717515945434570312500000000000000000e-1), SC_(4.072976805710110927257676157197633242064e-1), SC_(5.927023194289889072742323842802366757936e-1) }}, 
      {{ SC_(1.453048706054687500000000000000000000000e2), SC_(1.454501800537109375000000000000000000000e2), SC_(1.962219390869140625000000000000000000000e2), SC_(6.194633841514587402343750000000000000000e-1), SC_(4.013480302589766384350825623306599019141e-1), SC_(5.986519697410233615649174376693400980859e-1) }}, 
      {{ SC_(1.453048706054687500000000000000000000000e2), SC_(1.467579193115234375000000000000000000000e2), SC_(7.142335891723632812500000000000000000000), SC_(5.030584931373596191406250000000000000000e-1), SC_(4.929331599251014384981830921195998026879e-1), SC_(5.070668400748985615018169078804001973121e-1) }}, 
      {{ SC_(1.453048706054687500000000000000000000000e2), SC_(1.467579193115234375000000000000000000000e2), SC_(7.974770355224609375000000000000000000000e1), SC_(5.571559667587280273437500000000000000000e-1), SC_(4.895715488450056488439529797951107679999e-1), SC_(5.104284511549943511560470202048892320001e-1) }}, 
      {{ SC_(1.453048706054687500000000000000000000000e2), SC_(1.467579193115234375000000000000000000000e2), SC_(1.595857238769531250000000000000000000000e2), SC_(6.045034527778625488281250000000000000000e-1), SC_(4.865801338209663154494497042916365696537e-1), SC_(5.134198661790336845505502957083634303463e-1) }}, 
      {{ SC_(1.453048706054687500000000000000000000000e2), SC_(1.467579193115234375000000000000000000000e2), SC_(1.985762634277343750000000000000000000000e2), SC_(6.241288185119628906250000000000000000000e-1), SC_(4.853192929817508973963766928758841580759e-1), SC_(5.146807070182491026036233071241158419241e-1) }}, 
      {{ SC_(1.453048706054687500000000000000000000000e2), SC_(1.598353576660156250000000000000000000000e2), SC_(1.950807952880859375000000000000000000000e1), SC_(4.923658668994903564453125000000000000000e-1), SC_(4.999856686403203933258072177590715294422e-1), SC_(5.000143313596796066741927822409284705578e-1) }}, 
      {{ SC_(1.453048706054687500000000000000000000000e2), SC_(1.598353576660156250000000000000000000000e2), SC_(8.435225677490234375000000000000000000000e1), SC_(5.396380424499511718750000000000000000000e-1), SC_(4.979132628114638136332157373299801402215e-1), SC_(5.020867371885361863667842626700198597785e-1) }}, 
      {{ SC_(1.453048706054687500000000000000000000000e2), SC_(1.598353576660156250000000000000000000000e2), SC_(1.596211700439453125000000000000000000000e2), SC_(5.845665335655212402343750000000000000000e-1), SC_(4.961593125987237557941328911079317421287e-1), SC_(5.038406874012762442058671088920682578713e-1) }}, 
      {{ SC_(1.453048706054687500000000000000000000000e2), SC_(1.598353576660156250000000000000000000000e2), SC_(1.992922668457031250000000000000000000000e2), SC_(6.048963665962219238281250000000000000000e-1), SC_(4.954444133231428740894446881539075031522e-1), SC_(5.045555866768571259105553118460924968478e-1) }}, 
      {{ SC_(1.453048706054687500000000000000000000000e2), SC_(1.743658447265625000000000000000000000000e2), SC_(2.197235107421875000000000000000000000000e1), SC_(4.726681113243103027343750000000000000000e-1), SC_(5.012980016702866992770486708489252624760e-1), SC_(4.987019983297133007229513291510747375240e-1) }}, 
      {{ SC_(1.453048706054687500000000000000000000000e2), SC_(1.743658447265625000000000000000000000000e2), SC_(8.441753387451171875000000000000000000000e1), SC_(5.180588960647583007812500000000000000000e-1), SC_(4.992762873523010086004845677268262782480e-1), SC_(5.007237126476989913995154322731737217520e-1) }}, 
      {{ SC_(1.453048706054687500000000000000000000000e2), SC_(1.743658447265625000000000000000000000000e2), SC_(1.600560913085937500000000000000000000000e2), SC_(5.635819435119628906250000000000000000000e-1), SC_(4.974706481478232622659672224173719174835e-1), SC_(5.025293518521767377340327775826280825165e-1) }}, 
      {{ SC_(1.453048706054687500000000000000000000000e2), SC_(1.888963317871093750000000000000000000000e2), SC_(2.249290275573730468750000000000000000000e1), SC_(4.536787271499633789062500000000000000000e-1), SC_(5.090771021500586534132145934530281915178e-1), SC_(4.909228978499413465867854065469718084822e-1) }}, 
      {{ SC_(1.453048706054687500000000000000000000000e2), SC_(1.888963317871093750000000000000000000000e2), SC_(9.495173645019531250000000000000000000000e1), SC_(5.054219365119934082031250000000000000000e-1), SC_(5.061702491772600054921308815887145330941e-1), SC_(4.938297508227399945078691184112854669059e-1) }}, 
      {{ SC_(1.453048706054687500000000000000000000000e2), SC_(1.888963317871093750000000000000000000000e2), SC_(1.629447326660156250000000000000000000000e2), SC_(5.458055734634399414062500000000000000000e-1), SC_(5.042315185388167433948222806200849317647e-1), SC_(4.957684814611832566051777193799150682353e-1) }}, 
      {{ SC_(1.453048706054687500000000000000000000000e2), SC_(2.179573059082031250000000000000000000000e2), SC_(2.539736366271972656250000000000000000000e1), SC_(4.259543418884277343750000000000000000000e-1), SC_(5.890049978950004430411838739586711366240e-1), SC_(4.109950021049995569588161260413288633760e-1) }}, 
      {{ SC_(1.453048706054687500000000000000000000000e2), SC_(2.179573059082031250000000000000000000000e2), SC_(9.707512664794921875000000000000000000000e1), SC_(4.758105576038360595703125000000000000000e-1), SC_(5.791727130481673123900291867372065116569e-1), SC_(4.208272869518326876099708132627934883431e-1) }}, 
      {{ SC_(1.453048706054687500000000000000000000000e2), SC_(2.179573059082031250000000000000000000000e2), SC_(1.670017089843750000000000000000000000000e2), SC_(5.167693495750427246093750000000000000000e-1), SC_(5.729998623864095093857357134339781585176e-1), SC_(4.270001376135904906142642865660218414824e-1) }}, 
      {{ SC_(1.453048706054687500000000000000000000000e2), SC_(2.906097412109375000000000000000000000000e2), SC_(2.709540176391601562500000000000000000000e1), SC_(4.121678769588470458984375000000000000000e-1), SC_(9.937521392367049622281863736808485104841e-1), SC_(6.247860763295037771813626319151489515904e-3) }}, 
      {{ SC_(1.453048706054687500000000000000000000000e2), SC_(2.906097412109375000000000000000000000000e2), SC_(1.007325439453125000000000000000000000000e2), SC_(4.565960764884948730468750000000000000000e-1), SC_(9.881974189052874359529043716937323018020e-1), SC_(1.180258109471256404709562830626769819804e-2) }}, 
      {{ SC_(1.453048706054687500000000000000000000000e2), SC_(2.906097412109375000000000000000000000000e2), SC_(1.698258666992187500000000000000000000000e2), SC_(4.925895035266876220703125000000000000000e-1), SC_(9.832480232276382922245113171837838036632e-1), SC_(1.675197677236170777548868281621619633677e-2) }}, 
      {{ SC_(1.453048706054687500000000000000000000000e2), SC_(4.359146118164062500000000000000000000000e2), SC_(2.837726783752441406250000000000000000000e1), SC_(3.898694217205047607421875000000000000000e-1), SC_(9.999999994816522288480138100475195438574e-1), SC_(5.183477711519861899524804561426175360855e-10) }}, 
      {{ SC_(1.453048706054687500000000000000000000000e2), SC_(4.359146118164062500000000000000000000000e2), SC_(1.093762969970703125000000000000000000000e2), SC_(4.286728501319885253906250000000000000000e-1), SC_(9.999999814240933063083136693066650475982e-1), SC_(1.857590669369168633069333495240177862370e-8) }}, 
      {{ SC_(1.453048706054687500000000000000000000000e2), SC_(4.359146118164062500000000000000000000000e2), SC_(1.756861267089843750000000000000000000000e2), SC_(4.569514393806457519531250000000000000000e-1), SC_(9.999998963039658992204148348162163821972e-1), SC_(1.036960341007795851651837836178028395933e-7) }}, 
      {{ SC_(1.453048706054687500000000000000000000000e2), SC_(5.812194824218750000000000000000000000000e2), SC_(3.152261734008789062500000000000000000000e1), SC_(3.976649045944213867187500000000000000000e-1), SC_(9.999999999999999999999987939381889617023e-1), SC_(1.206061811038297670840152413102249976845e-24) }}, 
      {{ SC_(1.453048706054687500000000000000000000000e2), SC_(5.812194824218750000000000000000000000000e2), SC_(1.094441146850585937500000000000000000000e2), SC_(4.276683926582336425781250000000000000000e-1), SC_(9.999999999999999999920580600112343240218e-1), SC_(7.941939988765675978197881853485587363068e-21) }}, 
      {{ SC_(1.453048706054687500000000000000000000000e2), SC_(5.812194824218750000000000000000000000000e2), SC_(1.811583862304687500000000000000000000000e2), SC_(4.527589976787567138671875000000000000000e-1), SC_(9.999999999999999989811602129713094755353e-1), SC_(1.018839787028690524464656436619666686360e-18) }}, 
      {{ SC_(1.453048706054687500000000000000000000000e2), SC_(7.265243530273437500000000000000000000000e2), SC_(3.423733520507812500000000000000000000000e1), SC_(4.551310837268829345703125000000000000000e-1), SC_(1.000000000000000000000000000000000000000), SC_(2.956527836260669785616437185088394272110e-62) }}, 
      {{ SC_(1.453048706054687500000000000000000000000e2), SC_(7.265243530273437500000000000000000000000e2), SC_(1.264718551635742187500000000000000000000e2), SC_(4.819777011871337890625000000000000000000e-1), SC_(1.000000000000000000000000000000000000000), SC_(1.554058715194959746697584924238225951641e-52) }}, 
      {{ SC_(1.453048706054687500000000000000000000000e2), SC_(7.265243530273437500000000000000000000000e2), SC_(1.826751708984375000000000000000000000000e2), SC_(4.970785379409790039062500000000000000000e-1), SC_(1.000000000000000000000000000000000000000), SC_(7.761231454859183564503444620579313191770e-49) }}, 
      {{ SC_(1.585453491210937500000000000000000000000e2), SC_(1.585453510284423828125000000000000000000e1), SC_(2.837726783752441406250000000000000000000e1), SC_(9.579485058784484863281250000000000000000e-1), SC_(9.930436439897346503936222533307898664219e-1), SC_(6.956356010265349606377746669210133578112e-3) }}, 
      {{ SC_(1.585453491210937500000000000000000000000e2), SC_(1.585453510284423828125000000000000000000e1), SC_(1.093762969970703125000000000000000000000e2), SC_(9.653603434562683105468750000000000000000e-1), SC_(9.925612708853622711231663022817741165432e-1), SC_(7.438729114637728876833697718225883456765e-3) }}, 
      {{ SC_(1.585453491210937500000000000000000000000e2), SC_(1.585453510284423828125000000000000000000e1), SC_(1.756861267089843750000000000000000000000e2), SC_(9.697326421737670898437500000000000000000e-1), SC_(9.923158461569891280753647624286500193520e-1), SC_(7.684153843010871924635237571349980648044e-3) }}, 
      {{ SC_(1.585453491210937500000000000000000000000e2), SC_(3.963633728027343750000000000000000000000e1), SC_(3.152261734008789062500000000000000000000e1), SC_(9.382234215736389160156250000000000000000e-1), SC_(9.999999994080591356730332004478838509403e-1), SC_(5.919408643269667995521161490596716947866e-10) }}, 
      {{ SC_(1.585453491210937500000000000000000000000e2), SC_(3.963633728027343750000000000000000000000e1), SC_(1.094441146850585937500000000000000000000e2), SC_(9.477136135101318359375000000000000000000e-1), SC_(9.999999989777964207054542682999781948453e-1), SC_(1.022203579294545731700021805154656314501e-9) }}, 
      {{ SC_(1.585453491210937500000000000000000000000e2), SC_(3.963633728027343750000000000000000000000e1), SC_(1.811583862304687500000000000000000000000e2), SC_(9.541957974433898925781250000000000000000e-1), SC_(9.999999986201490283587827131818643425866e-1), SC_(1.379850971641217286818135657413406355965e-9) }}, 
      {{ SC_(1.585453491210937500000000000000000000000e2), SC_(7.927267456054687500000000000000000000000e1), SC_(3.423733520507812500000000000000000000000e1), SC_(9.222419261932373046875000000000000000000e-1), SC_(9.999999999999999999999999964781538609451e-1), SC_(3.521846139054875362963348022335012255148e-27) }}, 
      {{ SC_(1.585453491210937500000000000000000000000e2), SC_(7.927267456054687500000000000000000000000e1), SC_(1.264718551635742187500000000000000000000e2), SC_(9.341247677803039550781250000000000000000e-1), SC_(9.999999999999999999999999560085934262000e-1), SC_(4.399140657380002836431915089578560719127e-26) }}, 
      {{ SC_(1.585453491210937500000000000000000000000e2), SC_(7.927267456054687500000000000000000000000e1), SC_(1.826751708984375000000000000000000000000e2), SC_(9.397401213645935058593750000000000000000e-1), SC_(9.999999999999999999999998873978446621122e-1), SC_(1.126021553378878301863290927744738621719e-25) }}, 
      {{ SC_(1.585453491210937500000000000000000000000e2), SC_(1.189090118408203125000000000000000000000e2), SC_(3.477303314208984375000000000000000000000e1), SC_(9.193241000175476074218750000000000000000e-1), SC_(1.000000000000000000000000000000000000000), SC_(1.745320280417250823864878356012933928362e-51) }}, 
      {{ SC_(1.585453491210937500000000000000000000000e2), SC_(1.189090118408203125000000000000000000000e2), SC_(1.279526672363281250000000000000000000000e2), SC_(9.303084015846252441406250000000000000000e-1), SC_(1.000000000000000000000000000000000000000), SC_(4.370383635178199271231211538754165135157e-49) }}, 
      {{ SC_(1.585453491210937500000000000000000000000e2), SC_(1.189090118408203125000000000000000000000e2), SC_(1.831471099853515625000000000000000000000e2), SC_(9.355121850967407226562500000000000000000e-1), SC_(1.000000000000000000000000000000000000000), SC_(3.331970971168623271187656857541689621072e-48) }}, 
      {{ SC_(1.585453491210937500000000000000000000000e2), SC_(1.426908111572265625000000000000000000000e2), SC_(3.767639541625976562500000000000000000000e1), SC_(5.541128665208816528320312500000000000000e-2), SC_(6.739535511107894732480826411904225156885e-122), SC_(1.000000000000000000000000000000000000000) }}, 
      {{ SC_(1.585453491210937500000000000000000000000e2), SC_(1.426908111572265625000000000000000000000e2), SC_(1.310955810546875000000000000000000000000e2), SC_(6.107781454920768737792968750000000000000e-2), SC_(1.875229345885258644878235856823157570921e-133), SC_(1.000000000000000000000000000000000000000) }}, 
      {{ SC_(1.585453491210937500000000000000000000000e2), SC_(1.426908111572265625000000000000000000000e2), SC_(1.867986450195312500000000000000000000000e2), SC_(6.382068991661071777343750000000000000000e-2), SC_(3.862392513699480578013366720733365052546e-141), SC_(1.000000000000000000000000000000000000000) }}, 
      {{ SC_(1.585453491210937500000000000000000000000e2), SC_(1.569598999023437500000000000000000000000e2), SC_(4.238486480712890625000000000000000000000e1), SC_(1.334345638751983642578125000000000000000e-1), SC_(1.626823609047763505733053885551523761819e-62), SC_(1.000000000000000000000000000000000000000) }}, 
      {{ SC_(1.585453491210937500000000000000000000000e2), SC_(1.569598999023437500000000000000000000000e2), SC_(1.311481323242187500000000000000000000000e2), SC_(1.469828784465789794921875000000000000000e-1), SC_(1.520431927707629828404900418419207941478e-70), SC_(1.000000000000000000000000000000000000000) }}, 
      {{ SC_(1.585453491210937500000000000000000000000e2), SC_(1.569598999023437500000000000000000000000e2), SC_(1.914333953857421875000000000000000000000e2), SC_(1.545231193304061889648437500000000000000e-1), SC_(1.229281761330691820535267003872356972950e-76), SC_(1.000000000000000000000000000000000000000) }}, 
      {{ SC_(1.585453491210937500000000000000000000000e2), SC_(1.583868103027343750000000000000000000000e2), SC_(4.420680999755859375000000000000000000000e1), SC_(2.663707137107849121093750000000000000000e-1), SC_(1.167115008526922179283173048483664132486e-23), SC_(9.999999999999999999999883288499147307782e-1) }}, 
      {{ SC_(1.585453491210937500000000000000000000000e2), SC_(1.583868103027343750000000000000000000000e2), SC_(1.357470245361328125000000000000000000000e2), SC_(2.941046357154846191406250000000000000000e-1), SC_(5.542816457569192410454417156083492678386e-28), SC_(9.999999999999999999999999994457183542431e-1) }}, 
      {{ SC_(1.585453491210937500000000000000000000000e2), SC_(1.583868103027343750000000000000000000000e2), SC_(1.915013732910156250000000000000000000000e2), SC_(3.079931735992431640625000000000000000000e-1), SC_(6.292277482574145024851557066327840831609e-31), SC_(9.999999999999999999999999999993707722517e-1) }}, 
      {{ SC_(1.585453491210937500000000000000000000000e2), SC_(1.585453491210937500000000000000000000000e2), SC_(5.569964599609375000000000000000000000000e1), SC_(4.051960706710815429687500000000000000000e-1), SC_(6.077361753325568039940198226112043294321e-7), SC_(9.999993922638246674431960059801773887957e-1) }}, 
      {{ SC_(1.585453491210937500000000000000000000000e2), SC_(1.585453491210937500000000000000000000000e2), SC_(1.362719116210937500000000000000000000000e2), SC_(4.411854147911071777343750000000000000000e-1), SC_(3.781135327632526297155558519164644330283e-8), SC_(9.999999621886467236747370284444148083536e-1) }}, 
      {{ SC_(1.585453491210937500000000000000000000000e2), SC_(1.585453491210937500000000000000000000000e2), SC_(1.918984832763671875000000000000000000000e2), SC_(4.619506597518920898437500000000000000000e-1), SC_(4.429216220943825107718981809436981031773e-9), SC_(9.999999955707837790561748922810181905630e-1) }}, 
      {{ SC_(1.585453491210937500000000000000000000000e2), SC_(1.585612030029296875000000000000000000000e2), SC_(5.940588760375976562500000000000000000000e1), SC_(4.884186089038848876953125000000000000000e-1), SC_(2.558121663164683412831896430836368077472e-2), SC_(9.744187833683531658716810356916363192253e-1) }}, 
      {{ SC_(1.585453491210937500000000000000000000000e2), SC_(1.585612030029296875000000000000000000000e2), SC_(1.451677856445312500000000000000000000000e2), SC_(5.336238145828247070312500000000000000000e-1), SC_(1.351852269525593309641495000723108817373e-2), SC_(9.864814773047440669035850499927689118263e-1) }}, 
      {{ SC_(1.585453491210937500000000000000000000000e2), SC_(1.585612030029296875000000000000000000000e2), SC_(1.929777069091796875000000000000000000000e2), SC_(5.547699332237243652343750000000000000000e-1), SC_(9.105889935559688927154244371061068601223e-3), SC_(9.908941100644403110728457556289389313988e-1) }}, 
      {{ SC_(1.585453491210937500000000000000000000000e2), SC_(1.587039031982421875000000000000000000000e2), SC_(6.038262176513671875000000000000000000000e1), SC_(5.376746654510498046875000000000000000000e-1), SC_(4.205052408216833796079601326443336498248e-1), SC_(5.794947591783166203920398673556663501752e-1) }}, 
      {{ SC_(1.585453491210937500000000000000000000000e2), SC_(1.587039031982421875000000000000000000000e2), SC_(1.481294555664062500000000000000000000000e2), SC_(5.882948040962219238281250000000000000000e-1), SC_(4.073263810202225868303435814647113252209e-1), SC_(5.926736189797774131696564185352886747791e-1) }}, 
      {{ SC_(1.585453491210937500000000000000000000000e2), SC_(1.587039031982421875000000000000000000000e2), SC_(1.935389862060546875000000000000000000000e2), SC_(6.102936267852783203125000000000000000000e-1), SC_(4.005380952399225074725008321256692252339e-1), SC_(5.994619047600774925274991678743307747661e-1) }}, 
      {{ SC_(1.585453491210937500000000000000000000000e2), SC_(1.601307983398437500000000000000000000000e2), SC_(6.163340759277343750000000000000000000000e1), SC_(5.411622524261474609375000000000000000000e-1), SC_(4.903233855803948322194368966150997885443e-1), SC_(5.096766144196051677805631033849002114557e-1) }}, 
      {{ SC_(1.585453491210937500000000000000000000000e2), SC_(1.601307983398437500000000000000000000000e2), SC_(1.486264953613281250000000000000000000000e2), SC_(5.917431116104125976562500000000000000000e-1), SC_(4.871817725261521143954224609765168459028e-1), SC_(5.128182274738478856045775390234831540972e-1) }}, 
      {{ SC_(1.585453491210937500000000000000000000000e2), SC_(1.601307983398437500000000000000000000000e2), SC_(1.937735595703125000000000000000000000000e2), SC_(6.138346791267395019531250000000000000000e-1), SC_(4.857804644399595443956133156489203429521e-1), SC_(5.142195355600404556043866843510796570479e-1) }}, 
      {{ SC_(1.585453491210937500000000000000000000000e2), SC_(1.743998870849609375000000000000000000000e2), SC_(7.225879669189453125000000000000000000000e1), SC_(5.273418426513671875000000000000000000000e-1), SC_(4.985000338638839802709645359925985385096e-1), SC_(5.014999661361160197290354640074014614904e-1) }}, 
      {{ SC_(1.585453491210937500000000000000000000000e2), SC_(1.743998870849609375000000000000000000000e2), SC_(1.515480346679687500000000000000000000000e2), SC_(5.731079578399658203125000000000000000000e-1), SC_(4.967302107681564673972936728169891224409e-1), SC_(5.032697892318435326027063271830108775591e-1) }}, 
      {{ SC_(1.585453491210937500000000000000000000000e2), SC_(1.743998870849609375000000000000000000000e2), SC_(1.941185607910156250000000000000000000000e2), SC_(5.942102074623107910156250000000000000000e-1), SC_(4.959926327749107662818720938998038223174e-1), SC_(5.040073672250892337181279061001961776826e-1) }}, 
      {{ SC_(1.585453491210937500000000000000000000000e2), SC_(1.902544250488281250000000000000000000000e2), SC_(9.566968083381652832031250000000000000000e-1), SC_(4.553447961807250976562500000000000000000e-1), SC_(5.020827043530296469017322233095593613314e-1), SC_(4.979172956469703530982677766904406386686e-1) }}, 
      {{ SC_(1.585453491210937500000000000000000000000e2), SC_(1.902544250488281250000000000000000000000e2), SC_(7.844540405273437500000000000000000000000e1), SC_(5.096032619476318359375000000000000000000e-1), SC_(4.997148916198065843598047747482433854505e-1), SC_(5.002851083801934156401952252517566145495e-1) }}, 
      {{ SC_(1.585453491210937500000000000000000000000e2), SC_(1.902544250488281250000000000000000000000e2), SC_(1.584414672851562500000000000000000000000e2), SC_(5.553538799285888671875000000000000000000e-1), SC_(4.979316431661357771007438492992138241409e-1), SC_(5.020683568338642228992561507007861758591e-1) }}, 
      {{ SC_(1.585453491210937500000000000000000000000e2), SC_(1.902544250488281250000000000000000000000e2), SC_(1.962219390869140625000000000000000000000e2), SC_(5.741233825683593750000000000000000000000e-1), SC_(4.972694868888211463048488923291522349741e-1), SC_(5.027305131111788536951511076708477650259e-1) }}, 
      {{ SC_(1.585453491210937500000000000000000000000e2), SC_(2.061089477539062500000000000000000000000e2), SC_(7.142335891723632812500000000000000000000), SC_(4.408087432384490966796875000000000000000e-1), SC_(5.101649314016377833375394902721196044311e-1), SC_(4.898350685983622166624605097278803955689e-1) }}, 
      {{ SC_(1.585453491210937500000000000000000000000e2), SC_(2.061089477539062500000000000000000000000e2), SC_(7.974770355224609375000000000000000000000e1), SC_(4.908803999423980712890625000000000000000e-1), SC_(5.072923538833729547721241353709630254796e-1), SC_(4.927076461166270452278758646290369745204e-1) }}, 
      {{ SC_(1.585453491210937500000000000000000000000e2), SC_(2.061089477539062500000000000000000000000e2), SC_(1.595857238769531250000000000000000000000e2), SC_(5.365338325500488281250000000000000000000e-1), SC_(5.050608173686341629147620961753108257604e-1), SC_(4.949391826313658370852379038246891742396e-1) }}, 
      {{ SC_(1.585453491210937500000000000000000000000e2), SC_(2.061089477539062500000000000000000000000e2), SC_(1.985762634277343750000000000000000000000e2), SC_(5.559836626052856445312500000000000000000e-1), SC_(5.042185870182800262502103828114863485249e-1), SC_(4.957814129817199737497896171885136514751e-1) }}, 
      {{ SC_(1.585453491210937500000000000000000000000e2), SC_(2.378180236816406250000000000000000000000e2), SC_(1.950807952880859375000000000000000000000e1), SC_(4.201743006706237792968750000000000000000e-1), SC_(5.941333127190532426372811110209735995733e-1), SC_(4.058666872809467573627188889790264004267e-1) }}, 
      {{ SC_(1.585453491210937500000000000000000000000e2), SC_(2.378180236816406250000000000000000000000e2), SC_(8.435225677490234375000000000000000000000e1), SC_(4.629559516906738281250000000000000000000e-1), SC_(5.849723422458812279684470616233260287892e-1), SC_(4.150276577541187720315529383766739712108e-1) }}, 
      {{ SC_(1.585453491210937500000000000000000000000e2), SC_(2.378180236816406250000000000000000000000e2), SC_(1.596211700439453125000000000000000000000e2), SC_(5.053356885910034179687500000000000000000e-1), SC_(5.779823656912214216049851219602536746743e-1), SC_(4.220176343087785783950148780397463253257e-1) }}, 
      {{ SC_(1.585453491210937500000000000000000000000e2), SC_(2.378180236816406250000000000000000000000e2), SC_(1.992922668457031250000000000000000000000e2), SC_(5.250922441482543945312500000000000000000e-1), SC_(5.752464676197711806698444443157490173490e-1), SC_(4.247535323802288193301555556842509826510e-1) }}, 
      {{ SC_(1.585453491210937500000000000000000000000e2), SC_(3.170906982421875000000000000000000000000e2), SC_(2.197235107421875000000000000000000000000e1), SC_(4.075945913791656494140625000000000000000e-1), SC_(9.958524069411463445837556254815024748373e-1), SC_(4.147593058853655416244374518497525162698e-3) }}, 
      {{ SC_(1.585453491210937500000000000000000000000e2), SC_(3.170906982421875000000000000000000000000e2), SC_(8.441753387451171875000000000000000000000e1), SC_(4.432508945465087890625000000000000000000e-1), SC_(9.924087019503898081219635523090213514780e-1), SC_(7.591298049610191878036447690978648522008e-3) }}, 
      {{ SC_(1.585453491210937500000000000000000000000e2), SC_(3.170906982421875000000000000000000000000e2), SC_(1.600560913085937500000000000000000000000e2), SC_(4.810912013053894042968750000000000000000e-1), SC_(9.881717565335755624651219138357198287793e-1), SC_(1.182824346642443753487808616428017122066e-2) }}, 
      {{ SC_(1.585453491210937500000000000000000000000e2), SC_(4.756360473632812500000000000000000000000e2), SC_(2.249290275573730468750000000000000000000e1), SC_(3.858739435672760009765625000000000000000e-1), SC_(9.999999999468648199988862783871885922569e-1), SC_(5.313518000111372161281140774314934680286e-11) }}, 
      {{ SC_(1.585453491210937500000000000000000000000e2), SC_(4.756360473632812500000000000000000000000e2), SC_(9.495173645019531250000000000000000000000e1), SC_(4.184704422950744628906250000000000000000e-1), SC_(9.999999980494361407811314651885091166590e-1), SC_(1.950563859218868534811490883341038654184e-9) }}, 
      {{ SC_(1.585453491210937500000000000000000000000e2), SC_(4.756360473632812500000000000000000000000e2), SC_(1.629447326660156250000000000000000000000e2), SC_(4.460639655590057373046875000000000000000e-1), SC_(9.999999848302683110702603936901461971437e-1), SC_(1.516973168892973960630985380285627351423e-8) }}, 
      {{ SC_(1.585453491210937500000000000000000000000e2), SC_(6.341813964843750000000000000000000000000e2), SC_(2.539736366271972656250000000000000000000e1), SC_(3.943059146404266357421875000000000000000e-1), SC_(9.999999999999999999999999975684376832654e-1), SC_(2.431562316734627986075834590559706837730e-27) }}, 
      {{ SC_(1.585453491210937500000000000000000000000e2), SC_(6.341813964843750000000000000000000000000e2), SC_(9.707512664794921875000000000000000000000e1), SC_(4.200808107852935791015625000000000000000e-1), SC_(9.999999999999999999999794140115584942758e-1), SC_(2.058598844150572419715217182040338120894e-23) }}, 
      {{ SC_(1.585453491210937500000000000000000000000e2), SC_(6.341813964843750000000000000000000000000e2), SC_(1.670017089843750000000000000000000000000e2), SC_(4.431984126567840576171875000000000000000e-1), SC_(9.999999999999999999951646755882154574994e-1), SC_(4.835324411784542500571337961841454277598e-21) }}, 
      {{ SC_(1.585453491210937500000000000000000000000e2), SC_(7.927267456054687500000000000000000000000e2), SC_(2.709540176391601562500000000000000000000e1), SC_(4.522373974323272705078125000000000000000e-1), SC_(1.000000000000000000000000000000000000000), SC_(2.468412901256688217464845529785284376664e-69) }}, 
      {{ SC_(1.585453491210937500000000000000000000000e2), SC_(7.927267456054687500000000000000000000000e2), SC_(1.007325439453125000000000000000000000000e2), SC_(4.723534584045410156250000000000000000000e-1), SC_(1.000000000000000000000000000000000000000), SC_(2.853851080376705726334469912048367988143e-60) }}, 
      {{ SC_(1.585453491210937500000000000000000000000e2), SC_(7.927267456054687500000000000000000000000e2), SC_(1.698258666992187500000000000000000000000e2), SC_(4.899305701255798339843750000000000000000e-1), SC_(1.000000000000000000000000000000000000000), SC_(6.904523504973591116497684142957056290072e-55) }}, 
      {{ SC_(1.596867675781250000000000000000000000000e2), SC_(1.596867656707763671875000000000000000000e1), SC_(2.249290275573730468750000000000000000000e1), SC_(9.572668075561523437500000000000000000000e-1), SC_(9.932712810130351814606567649344297578950e-1), SC_(6.728718986964818539343235065570242104985e-3) }}, 
      {{ SC_(1.596867675781250000000000000000000000000e2), SC_(1.596867656707763671875000000000000000000e1), SC_(9.495173645019531250000000000000000000000e1), SC_(9.641827344894409179687500000000000000000e-1), SC_(9.928209717548775090734040693301747958917e-1), SC_(7.179028245122490926595930669825204108303e-3) }}, 
      {{ SC_(1.596867675781250000000000000000000000000e2), SC_(1.596867656707763671875000000000000000000e1), SC_(1.629447326660156250000000000000000000000e2), SC_(9.689097404479980468750000000000000000000e-1), SC_(9.925537700402302639348453880375708536693e-1), SC_(7.446229959769736065154611962429146330658e-3) }}, 
      {{ SC_(1.596867675781250000000000000000000000000e2), SC_(3.992169189453125000000000000000000000000e1), SC_(2.539736366271972656250000000000000000000e1), SC_(9.373031854629516601562500000000000000000e-1), SC_(9.999999995152929429132369257693594184553e-1), SC_(4.847070570867630742306405815446800055505e-10) }}, 
      {{ SC_(1.596867675781250000000000000000000000000e2), SC_(3.992169189453125000000000000000000000000e1), SC_(9.707512664794921875000000000000000000000e1), SC_(9.463311433792114257812500000000000000000e-1), SC_(9.999999991686229698576987992337379547225e-1), SC_(8.313770301423012007662620452775121977323e-10) }}, 
      {{ SC_(1.596867675781250000000000000000000000000e2), SC_(3.992169189453125000000000000000000000000e1), SC_(1.670017089843750000000000000000000000000e2), SC_(9.529471993446350097656250000000000000000e-1), SC_(9.999999988554403469876379815773554385153e-1), SC_(1.144559653012362018422644561484655968055e-9) }}, 
      {{ SC_(1.596867675781250000000000000000000000000e2), SC_(7.984338378906250000000000000000000000000e1), SC_(2.709540176391601562500000000000000000000e1), SC_(9.211109876632690429687500000000000000000e-1), SC_(9.999999999999999999999999982691922026475e-1), SC_(1.730807797352515157273313608712611853544e-27) }}, 
      {{ SC_(1.596867675781250000000000000000000000000e2), SC_(7.984338378906250000000000000000000000000e1), SC_(1.007325439453125000000000000000000000000e2), SC_(9.311036467552185058593750000000000000000e-1), SC_(9.999999999999999999999999833712964309299e-1), SC_(1.662870356907009667876922942828551537237e-26) }}, 
      {{ SC_(1.596867675781250000000000000000000000000e2), SC_(7.984338378906250000000000000000000000000e1), SC_(1.698258666992187500000000000000000000000e2), SC_(9.384269714355468750000000000000000000000e-1), SC_(9.999999999999999999999999385245936371683e-1), SC_(6.147540636283173975798375100111005487060e-26) }}, 
      {{ SC_(1.596867675781250000000000000000000000000e2), SC_(1.197650756835937500000000000000000000000e2), SC_(2.837726783752441406250000000000000000000e1), SC_(9.184139966964721679687500000000000000000e-1), SC_(1.000000000000000000000000000000000000000), SC_(4.379573580185655922598492807586902715023e-52) }}, 
      {{ SC_(1.596867675781250000000000000000000000000e2), SC_(1.197650756835937500000000000000000000000e2), SC_(1.093762969970703125000000000000000000000e2), SC_(9.282793402671813964843750000000000000000e-1), SC_(1.000000000000000000000000000000000000000), SC_(8.242720928497823995949059991089632284889e-50) }}, 
      {{ SC_(1.596867675781250000000000000000000000000e2), SC_(1.197650756835937500000000000000000000000e2), SC_(1.756861267089843750000000000000000000000e2), SC_(9.347428679466247558593750000000000000000e-1), SC_(1.000000000000000000000000000000000000000), SC_(1.164835788454099659236844132670081411974e-48) }}, 
      {{ SC_(1.596867675781250000000000000000000000000e2), SC_(1.437180938720703125000000000000000000000e2), SC_(3.152261734008789062500000000000000000000e1), SC_(5.496379733085632324218750000000000000000e-2), SC_(4.758385887556532172208991248623111831767e-122), SC_(1.000000000000000000000000000000000000000) }}, 
      {{ SC_(1.596867675781250000000000000000000000000e2), SC_(1.437180938720703125000000000000000000000e2), SC_(1.094441146850585937500000000000000000000e2), SC_(5.985238775610923767089843750000000000000e-2), SC_(1.995405635130663167099480751991180285415e-131), SC_(1.000000000000000000000000000000000000000) }}, 
      {{ SC_(1.596867675781250000000000000000000000000e2), SC_(1.437180938720703125000000000000000000000e2), SC_(1.811583862304687500000000000000000000000e2), SC_(6.350056827068328857421875000000000000000e-2), SC_(3.757442971580959484486573130039501243119e-141), SC_(1.000000000000000000000000000000000000000) }}, 
      {{ SC_(1.596867675781250000000000000000000000000e2), SC_(1.580899047851562500000000000000000000000e2), SC_(3.423733520507812500000000000000000000000e1), SC_(1.319675743579864501953125000000000000000e-1), SC_(2.892802257189215703394395232225591257571e-62), SC_(1.000000000000000000000000000000000000000) }}, 
      {{ SC_(1.596867675781250000000000000000000000000e2), SC_(1.580899047851562500000000000000000000000e2), SC_(1.264718551635742187500000000000000000000e2), SC_(1.462247073650360107421875000000000000000e-1), SC_(1.717130634531400958346306419003169007275e-70), SC_(1.000000000000000000000000000000000000000) }}, 
      {{ SC_(1.596867675781250000000000000000000000000e2), SC_(1.580899047851562500000000000000000000000e2), SC_(1.826751708984375000000000000000000000000e2), SC_(1.533422917127609252929687500000000000000e-1), SC_(4.030609684732628104147872466627962423258e-76), SC_(1.000000000000000000000000000000000000000) }}, 
      {{ SC_(1.596867675781250000000000000000000000000e2), SC_(1.595270843505859375000000000000000000000e2), SC_(3.477303314208984375000000000000000000000e1), SC_(2.629955708980560302734375000000000000000e-1), SC_(2.099740136326087193394768276168764973439e-23), SC_(9.999999999999999999999790025986367391281e-1) }}, 
      {{ SC_(1.596867675781250000000000000000000000000e2), SC_(1.595270843505859375000000000000000000000e2), SC_(1.279526672363281250000000000000000000000e2), SC_(2.917527556419372558593750000000000000000e-1), SC_(1.001713855853602637975518149335120967081e-27), SC_(9.999999999999999999999999989982861441464e-1) }}, 
      {{ SC_(1.596867675781250000000000000000000000000e2), SC_(1.595270843505859375000000000000000000000e2), SC_(1.831471099853515625000000000000000000000e2), SC_(3.057223260402679443359375000000000000000e-1), SC_(1.312884166853857265072196269898987739266e-30), SC_(9.999999999999999999999999999986871158331e-1) }}, 
      {{ SC_(1.596867675781250000000000000000000000000e2), SC_(1.596867675781250000000000000000000000000e2), SC_(3.767639541625976562500000000000000000000e1), SC_(3.958289623260498046875000000000000000000e-1), SC_(9.830595907507385372243227872081605609762e-7), SC_(9.999990169404092492614627756772127918394e-1) }}, 
      {{ SC_(1.596867675781250000000000000000000000000e2), SC_(1.596867675781250000000000000000000000000e2), SC_(1.310955810546875000000000000000000000000e2), SC_(4.387206435203552246093750000000000000000e-1), SC_(4.260811256286046346813657720835059327443e-8), SC_(9.999999573918874371395365318634227916494e-1) }}, 
      {{ SC_(1.596867675781250000000000000000000000000e2), SC_(1.596867675781250000000000000000000000000e2), SC_(1.867986450195312500000000000000000000000e2), SC_(4.596933126449584960937500000000000000000e-1), SC_(5.074256116065452471510058776944403092611e-9), SC_(9.999999949257438839345475284899412230556e-1) }}, 
      {{ SC_(1.596867675781250000000000000000000000000e2), SC_(1.597027435302734375000000000000000000000e2), SC_(4.238486480712890625000000000000000000000e1), SC_(4.779026210308074951171875000000000000000e-1), SC_(2.828378778952839863224823769829490163267e-2), SC_(9.717162122104716013677517623017050983673e-1) }}, 
      {{ SC_(1.596867675781250000000000000000000000000e2), SC_(1.597027435302734375000000000000000000000e2), SC_(1.311481323242187500000000000000000000000e2), SC_(5.264683961868286132812500000000000000000e-1), SC_(1.491953346061045926730117849420571855083e-2), SC_(9.850804665393895407326988215057942814492e-1) }}, 
      {{ SC_(1.596867675781250000000000000000000000000e2), SC_(1.597027435302734375000000000000000000000e2), SC_(1.914333953857421875000000000000000000000e2), SC_(5.535529255867004394531250000000000000000e-1), SC_(9.126113819298951137392980793556595222126e-3), SC_(9.908738861807010488626070192064434047779e-1) }}, 
      {{ SC_(1.596867675781250000000000000000000000000e2), SC_(1.598464660644531250000000000000000000000e2), SC_(4.420680999755859375000000000000000000000e1), SC_(5.267066955566406250000000000000000000000e-1), SC_(4.227062390743599845882225399573606542913e-1), SC_(5.772937609256400154117774600426393457087e-1) }}, 
      {{ SC_(1.596867675781250000000000000000000000000e2), SC_(1.598464660644531250000000000000000000000e2), SC_(1.357470245361328125000000000000000000000e2), SC_(5.813350081443786621093750000000000000000e-1), SC_(4.090338298665393158690020352548733290282e-1), SC_(5.909661701334606841309979647451266709718e-1) }}, 
      {{ SC_(1.596867675781250000000000000000000000000e2), SC_(1.598464660644531250000000000000000000000e2), SC_(1.915013732910156250000000000000000000000e2), SC_(6.087286472320556640625000000000000000000e-1), SC_(4.007289019789947163564241954778469943234e-1), SC_(5.992710980210052836435758045221530056766e-1) }}, 
      {{ SC_(1.596867675781250000000000000000000000000e2), SC_(1.612836303710937500000000000000000000000e2), SC_(5.569964599609375000000000000000000000000e1), SC_(5.369877219200134277343750000000000000000e-1), SC_(4.905576221836658586183156191837544723223e-1), SC_(5.094423778163341413816843808162455276777e-1) }}, 
      {{ SC_(1.596867675781250000000000000000000000000e2), SC_(1.612836303710937500000000000000000000000e2), SC_(1.362719116210937500000000000000000000000e2), SC_(5.847306251525878906250000000000000000000e-1), SC_(4.876033536639612690829262362543804112182e-1), SC_(5.123966463360387309170737637456195887818e-1) }}, 
      {{ SC_(1.596867675781250000000000000000000000000e2), SC_(1.612836303710937500000000000000000000000e2), SC_(1.918984832763671875000000000000000000000e2), SC_(6.123276948928833007812500000000000000000e-1), SC_(4.858597602462539672569923405810455837860e-1), SC_(5.141402397537460327430076594189544162140e-1) }}, 
      {{ SC_(1.596867675781250000000000000000000000000e2), SC_(1.756554412841796875000000000000000000000e2), SC_(5.940588760375976562500000000000000000000e1), SC_(5.187044739723205566406250000000000000000e-1), SC_(4.988618046413059808528238557224091773745e-1), SC_(5.011381953586940191471761442775908226255e-1) }}, 
      {{ SC_(1.596867675781250000000000000000000000000e2), SC_(1.756554412841796875000000000000000000000e2), SC_(1.451677856445312500000000000000000000000e2), SC_(5.692061185836791992187500000000000000000e-1), SC_(4.968830819449765116483901686713774887364e-1), SC_(5.031169180550234883516098313286225112636e-1) }}, 
      {{ SC_(1.596867675781250000000000000000000000000e2), SC_(1.756554412841796875000000000000000000000e2), SC_(1.929777069091796875000000000000000000000e2), SC_(5.930206179618835449218750000000000000000e-1), SC_(4.960471466400383684865411736893636862956e-1), SC_(5.039528533599616315134588263106363137044e-1) }}, 
      {{ SC_(1.596867675781250000000000000000000000000e2), SC_(1.916241302490234375000000000000000000000e2), SC_(6.038262176513671875000000000000000000000e1), SC_(4.976576566696166992187500000000000000000e-1), SC_(5.002221348941268860015611882082037392745e-1), SC_(4.997778651058731139984388117917962607255e-1) }}, 
      {{ SC_(1.596867675781250000000000000000000000000e2), SC_(1.916241302490234375000000000000000000000e2), SC_(1.481294555664062500000000000000000000000e2), SC_(5.493785142898559570312500000000000000000e-1), SC_(4.981625392044124046811960495730893182749e-1), SC_(5.018374607955875953188039504269106817251e-1) }}, 
      {{ SC_(1.596867675781250000000000000000000000000e2), SC_(1.916241302490234375000000000000000000000e2), SC_(1.935389862060546875000000000000000000000e2), SC_(5.721809864044189453125000000000000000000e-1), SC_(4.973503695659729963019024913047615593139e-1), SC_(5.026496304340270036980975086952384406861e-1) }}, 
      {{ SC_(1.596867675781250000000000000000000000000e2), SC_(2.075927886962890625000000000000000000000e2), SC_(6.163340759277343750000000000000000000000e1), SC_(4.789558649063110351562500000000000000000e-1), SC_(5.079651815384983380223614932086090590006e-1), SC_(4.920348184615016619776385067913909409994e-1) }}, 
      {{ SC_(1.596867675781250000000000000000000000000e2), SC_(2.075927886962890625000000000000000000000e2), SC_(1.486264953613281250000000000000000000000e2), SC_(5.301906466484069824218750000000000000000e-1), SC_(5.053828703505113055850701503816664493872e-1), SC_(4.946171296494886944149298496183335506128e-1) }}, 
      {{ SC_(1.596867675781250000000000000000000000000e2), SC_(2.075927886962890625000000000000000000000e2), SC_(1.937735595703125000000000000000000000000e2), SC_(5.530080199241638183593750000000000000000e-1), SC_(5.043799932554074082947086362160943616745e-1), SC_(4.956200067445925917052913637839056383255e-1) }}, 
      {{ SC_(1.596867675781250000000000000000000000000e2), SC_(2.395301513671875000000000000000000000000e2), SC_(7.225879669189453125000000000000000000000e1), SC_(4.551377296447753906250000000000000000000e-1), SC_(5.867652588530180483112895329109288622186e-1), SC_(4.132347411469819516887104670890711377814e-1) }}, 
      {{ SC_(1.596867675781250000000000000000000000000e2), SC_(2.395301513671875000000000000000000000000e2), SC_(1.515480346679687500000000000000000000000e2), SC_(5.005415678024291992187500000000000000000e-1), SC_(5.789775944790170193392076682276947524458e-1), SC_(4.210224055209829806607923317723052475542e-1) }}, 
      {{ SC_(1.596867675781250000000000000000000000000e2), SC_(2.395301513671875000000000000000000000000e2), SC_(1.941185607910156250000000000000000000000e2), SC_(5.219355225563049316406250000000000000000e-1), SC_(5.759462877654108573210656008030215822248e-1), SC_(4.240537122345891426789343991969784177752e-1) }}, 
      {{ SC_(1.596867675781250000000000000000000000000e2), SC_(3.193735351562500000000000000000000000000e2), SC_(9.566968083381652832031250000000000000000e-1), SC_(3.945426940917968750000000000000000000000e-1), SC_(9.970000201215734291915567158067621574383e-1), SC_(2.999979878426570808443284193237842561716e-3) }}, 
      {{ SC_(1.596867675781250000000000000000000000000e2), SC_(3.193735351562500000000000000000000000000e2), SC_(7.844540405273437500000000000000000000000e1), SC_(4.397231638431549072265625000000000000000e-1), SC_(9.929523683425025230319705662799929766249e-1), SC_(7.047631657497476968029433720007023375126e-3) }}, 
      {{ SC_(1.596867675781250000000000000000000000000e2), SC_(3.193735351562500000000000000000000000000e2), SC_(1.584414672851562500000000000000000000000e2), SC_(4.798079133033752441406250000000000000000e-1), SC_(9.885676629825789345362624951498892067118e-1), SC_(1.143233701742106546373750485011079328817e-2) }}, 
      {{ SC_(1.596867675781250000000000000000000000000e2), SC_(3.193735351562500000000000000000000000000e2), SC_(1.962219390869140625000000000000000000000e2), SC_(4.968129992485046386718750000000000000000e-1), SC_(9.865922975525753404193190158262680279963e-1), SC_(1.340770244742465958068098417373197200372e-2) }}, 
      {{ SC_(1.596867675781250000000000000000000000000e2), SC_(4.790603027343750000000000000000000000000e2), SC_(7.142335891723632812500000000000000000000), SC_(3.784695267677307128906250000000000000000e-1), SC_(9.999999999852316807878060552912999447726e-1), SC_(1.476831921219394470870005522736249888943e-11) }}, 
      {{ SC_(1.596867675781250000000000000000000000000e2), SC_(4.790603027343750000000000000000000000000e2), SC_(7.974770355224609375000000000000000000000e1), SC_(4.116723239421844482421875000000000000000e-1), SC_(9.999999990799573611679766082392456529241e-1), SC_(9.200426388320233917607543470759063481212e-10) }}, 
      {{ SC_(1.596867675781250000000000000000000000000e2), SC_(4.790603027343750000000000000000000000000e2), SC_(1.595857238769531250000000000000000000000e2), SC_(4.443195164203643798828125000000000000000e-1), SC_(9.999999879018482201081342044661546414174e-1), SC_(1.209815177989186579553384535858255041362e-8) }}, 
      {{ SC_(1.596867675781250000000000000000000000000e2), SC_(4.790603027343750000000000000000000000000e2), SC_(1.985762634277343750000000000000000000000e2), SC_(4.589828848838806152343750000000000000000e-1), SC_(9.999999706408271528100549441276066759632e-1), SC_(2.935917284718994505587239332403680840387e-8) }}, 
      {{ SC_(1.596867675781250000000000000000000000000e2), SC_(6.387470703125000000000000000000000000000e2), SC_(1.950807952880859375000000000000000000000e1), SC_(3.920333683490753173828125000000000000000e-1), SC_(9.999999999999999999999999994439667003934e-1), SC_(5.560332996066198492474711276815593332167e-28) }}, 
      {{ SC_(1.596867675781250000000000000000000000000e2), SC_(6.387470703125000000000000000000000000000e2), SC_(8.435225677490234375000000000000000000000e1), SC_(4.154563248157501220703125000000000000000e-1), SC_(9.999999999999999999999962278132304055338e-1), SC_(3.772186769594466168038938220282791861740e-24) }}, 
      {{ SC_(1.596867675781250000000000000000000000000e2), SC_(6.387470703125000000000000000000000000000e2), SC_(1.596211700439453125000000000000000000000e2), SC_(4.404806196689605712890625000000000000000e-1), SC_(9.999999999999999999979909624798024287409e-1), SC_(2.009037520197571259065806039394722507117e-21) }}, 
      {{ SC_(1.596867675781250000000000000000000000000e2), SC_(6.387470703125000000000000000000000000000e2), SC_(1.992922668457031250000000000000000000000e2), SC_(4.528275430202484130859375000000000000000e-1), SC_(9.999999999999999999777222909593137354812e-1), SC_(2.227770904068626451884867993911551304509e-20) }}, 
      {{ SC_(1.596867675781250000000000000000000000000e2), SC_(7.984338378906250000000000000000000000000e2), SC_(2.197235107421875000000000000000000000000e1), SC_(4.507360160350799560546875000000000000000e-1), SC_(1.000000000000000000000000000000000000000), SC_(1.022573017722800297395040214664157623767e-70) }}, 
      {{ SC_(1.596867675781250000000000000000000000000e2), SC_(7.984338378906250000000000000000000000000e2), SC_(8.441753387451171875000000000000000000000e1), SC_(4.678635895252227783203125000000000000000e-1), SC_(1.000000000000000000000000000000000000000), SC_(2.242378511830998559688470564486245389069e-62) }}, 
      {{ SC_(1.596867675781250000000000000000000000000e2), SC_(7.984338378906250000000000000000000000000e2), SC_(1.600560913085937500000000000000000000000e2), SC_(4.872326254844665527343750000000000000000e-1), SC_(1.000000000000000000000000000000000000000), SC_(5.320953295222374522356743693376599970360e-56) }}, 
      {{ SC_(1.597221069335937500000000000000000000000e2), SC_(1.597221088409423828125000000000000000000e1), SC_(7.142335891723632812500000000000000000000), SC_(9.554460048675537109375000000000000000000e-1), SC_(9.934063922299266676294410884072870009167e-1), SC_(6.593607770073332370558911592712999083286e-3) }}, 
      {{ SC_(1.597221069335937500000000000000000000000e2), SC_(1.597221088409423828125000000000000000000e1), SC_(7.974770355224609375000000000000000000000e1), SC_(9.629214406013488769531250000000000000000e-1), SC_(9.929036945402843679096482786665760027013e-1), SC_(7.096305459715632090351721333423997298737e-3) }}, 
      {{ SC_(1.597221069335937500000000000000000000000e2), SC_(1.597221088409423828125000000000000000000e1), SC_(1.595857238769531250000000000000000000000e2), SC_(9.687034487724304199218750000000000000000e-1), SC_(9.925705799141886475899240018629481837111e-1), SC_(7.429420085811352410075998137051816288858e-3) }}, 
      {{ SC_(1.597221069335937500000000000000000000000e2), SC_(1.597221088409423828125000000000000000000e1), SC_(1.985762634277343750000000000000000000000e2), SC_(9.709196090698242187500000000000000000000e-1), SC_(9.924564478305319540747481766939865694669e-1), SC_(7.543552169468045925251823306013430533060e-3) }}, 
      {{ SC_(1.597221069335937500000000000000000000000e2), SC_(3.993052673339843750000000000000000000000e1), SC_(1.950807952880859375000000000000000000000e1), SC_(9.364244937896728515625000000000000000000e-1), SC_(9.999999995454261897475030903913031302743e-1), SC_(4.545738102524969096086968697256828088752e-10) }}, 
      {{ SC_(1.597221069335937500000000000000000000000e2), SC_(3.993052673339843750000000000000000000000e1), SC_(8.435225677490234375000000000000000000000e1), SC_(9.449206590652465820312500000000000000000e-1), SC_(9.999999992326374174909757227435328505318e-1), SC_(7.673625825090242772564671494682448283005e-10) }}, 
      {{ SC_(1.597221069335937500000000000000000000000e2), SC_(3.993052673339843750000000000000000000000e1), SC_(1.596211700439453125000000000000000000000e2), SC_(9.523236751556396484375000000000000000000e-1), SC_(9.999999988912808803249885311609778080287e-1), SC_(1.108719119675011468839022191971329397663e-9) }}, 
      {{ SC_(1.597221069335937500000000000000000000000e2), SC_(3.993052673339843750000000000000000000000e1), SC_(1.992922668457031250000000000000000000000e2), SC_(9.554793238639831542968750000000000000000e-1), SC_(9.999999987305483047322617627585888097610e-1), SC_(1.269451695267738237241411190239045820697e-9) }}, 
      {{ SC_(1.597221069335937500000000000000000000000e2), SC_(7.986105346679687500000000000000000000000e1), SC_(2.197235107421875000000000000000000000000e1), SC_(9.203064441680908203125000000000000000000e-1), SC_(9.999999999999999999999999986184999574709e-1), SC_(1.381500042529069962502462143010348725727e-27) }}, 
      {{ SC_(1.597221069335937500000000000000000000000e2), SC_(7.986105346679687500000000000000000000000e1), SC_(8.441753387451171875000000000000000000000e1), SC_(9.291112422943115234375000000000000000000e-1), SC_(9.999999999999999999999999890166575332668e-1), SC_(1.098334246673317132901523369503209352417e-26) }}, 
      {{ SC_(1.597221069335937500000000000000000000000e2), SC_(7.986105346679687500000000000000000000000e1), SC_(1.600560913085937500000000000000000000000e2), SC_(9.374837279319763183593750000000000000000e-1), SC_(9.999999999999999999999999479793215995332e-1), SC_(5.202067840046684239147941728348665601461e-26) }}, 
      {{ SC_(1.597221069335937500000000000000000000000e2), SC_(1.197915802001953125000000000000000000000e2), SC_(2.249290275573730468750000000000000000000e1), SC_(9.175901412963867187500000000000000000000e-1), SC_(1.000000000000000000000000000000000000000), SC_(2.524459447090253682396115706011627303689e-52) }}, 
      {{ SC_(1.597221069335937500000000000000000000000e2), SC_(1.197915802001953125000000000000000000000e2), SC_(9.495173645019531250000000000000000000000e1), SC_(9.266980886459350585937500000000000000000e-1), SC_(1.000000000000000000000000000000000000000), SC_(3.877329919524838234518076357240172231903e-50) }}, 
      {{ SC_(1.597221069335937500000000000000000000000e2), SC_(1.197915802001953125000000000000000000000e2), SC_(1.629447326660156250000000000000000000000e2), SC_(9.335893988609313964843750000000000000000e-1), SC_(1.000000000000000000000000000000000000000), SC_(7.347735133202871928430803259987875989458e-49) }}, 
      {{ SC_(1.597221069335937500000000000000000000000e2), SC_(1.437498931884765625000000000000000000000e2), SC_(2.539736366271972656250000000000000000000e1), SC_(5.452830716967582702636718750000000000000e-2), SC_(2.074949111423883417057646064196816209333e-121), SC_(1.000000000000000000000000000000000000000) }}, 
      {{ SC_(1.597221069335937500000000000000000000000e2), SC_(1.437498931884765625000000000000000000000e2), SC_(9.707512664794921875000000000000000000000e1), SC_(5.914707854390144348144531250000000000000e-2), SC_(7.239421664290195208382312404393165574994e-130), SC_(1.000000000000000000000000000000000000000) }}, 
      {{ SC_(1.597221069335937500000000000000000000000e2), SC_(1.437498931884765625000000000000000000000e2), SC_(1.670017089843750000000000000000000000000e2), SC_(6.283200532197952270507812500000000000000e-2), SC_(3.411086955701248489534980674665566414162e-139), SC_(1.000000000000000000000000000000000000000) }}, 
      {{ SC_(1.597221069335937500000000000000000000000e2), SC_(1.581248931884765625000000000000000000000e2), SC_(2.709540176391601562500000000000000000000e1), SC_(1.306978464126586914062500000000000000000e-1), SC_(1.033198277414325908115722805369378771962e-61), SC_(1.000000000000000000000000000000000000000) }}, 
      {{ SC_(1.597221069335937500000000000000000000000e2), SC_(1.581248931884765625000000000000000000000e2), SC_(1.007325439453125000000000000000000000000e2), SC_(1.426005363464355468750000000000000000000e-1), SC_(4.619666433877791461057000631313211448032e-68), SC_(1.000000000000000000000000000000000000000) }}, 
      {{ SC_(1.597221069335937500000000000000000000000e2), SC_(1.581248931884765625000000000000000000000e2), SC_(1.698258666992187500000000000000000000000e2), SC_(1.517977863550186157226562500000000000000e-1), SC_(8.164016321998891750377538192924386567694e-75), SC_(1.000000000000000000000000000000000000000) }}, 
      {{ SC_(1.597221069335937500000000000000000000000e2), SC_(1.595623931884765625000000000000000000000e2), SC_(2.837726783752441406250000000000000000000e1), SC_(2.607262134552001953125000000000000000000e-1), SC_(3.814918161346097719007552966338481635681e-23), SC_(9.999999999999999999999618508183865390228e-1) }}, 
      {{ SC_(1.597221069335937500000000000000000000000e2), SC_(1.595623931884765625000000000000000000000e2), SC_(1.093762969970703125000000000000000000000e2), SC_(2.865822613239288330078125000000000000000e-1), SC_(8.298955449925079864525518110106029459581e-27), SC_(9.999999999999999999999999917010445500749e-1) }}, 
      {{ SC_(1.597221069335937500000000000000000000000e2), SC_(1.595623931884765625000000000000000000000e2), SC_(1.756861267089843750000000000000000000000e2), SC_(3.039349615573883056640625000000000000000e-1), SC_(3.273345195006698389070999626878989121536e-30), SC_(9.999999999999999999999999999967266548050e-1) }}, 
      {{ SC_(1.597221069335937500000000000000000000000e2), SC_(1.597221069335937500000000000000000000000e2), SC_(3.152261734008789062500000000000000000000e1), SC_(3.925823271274566650390625000000000000000e-1), SC_(1.178473492599395899144380455328294409786e-6), SC_(9.999988215265074006041008556195446717056e-1) }}, 
      {{ SC_(1.597221069335937500000000000000000000000e2), SC_(1.597221069335937500000000000000000000000e2), SC_(1.094441146850585937500000000000000000000e2), SC_(4.297188520431518554687500000000000000000e-1), SC_(9.269901956163101162829167816548599985160e-8), SC_(9.999999073009804383689883717083218345140e-1) }}, 
      {{ SC_(1.597221069335937500000000000000000000000e2), SC_(1.597221069335937500000000000000000000000e2), SC_(1.811583862304687500000000000000000000000e2), SC_(4.576846957206726074218750000000000000000e-1), SC_(6.328473322609479097845539776278745227765e-9), SC_(9.999999936715266773905209021544602237213e-1) }}, 
      {{ SC_(1.597221069335937500000000000000000000000e2), SC_(1.597380828857421875000000000000000000000e2), SC_(3.423733520507812500000000000000000000000e1), SC_(4.728014469146728515625000000000000000000e-1), SC_(2.980394252470482234273506987940856880256e-2), SC_(9.701960574752951776572649301205914311974e-1) }}, 
      {{ SC_(1.597221069335937500000000000000000000000e2), SC_(1.597380828857421875000000000000000000000e2), SC_(1.264718551635742187500000000000000000000e2), SC_(5.241761207580566406250000000000000000000e-1), SC_(1.546571099225050394765349411525951284901e-2), SC_(9.845342890077494960523465058847404871510e-1) }}, 
      {{ SC_(1.597221069335937500000000000000000000000e2), SC_(1.597380828857421875000000000000000000000e2), SC_(1.826751708984375000000000000000000000000e2), SC_(5.498469471931457519531250000000000000000e-1), SC_(9.823550479156979391415868337706914912357e-3), SC_(9.901764495208430206085841316622930850876e-1) }}, 
      {{ SC_(1.597221069335937500000000000000000000000e2), SC_(1.598818359375000000000000000000000000000e2), SC_(3.477303314208984375000000000000000000000e1), SC_(5.202322602272033691406250000000000000000e-1), SC_(4.240947651454241601719269903682824019477e-1), SC_(5.759052348545758398280730096317175980523e-1) }}, 
      {{ SC_(1.597221069335937500000000000000000000000e2), SC_(1.598818359375000000000000000000000000000e2), SC_(1.279526672363281250000000000000000000000e2), SC_(5.771741867065429687500000000000000000000e-1), SC_(4.101942787979760618973032181304779535457e-1), SC_(5.898057212020239381026967818695220464543e-1) }}, 
      {{ SC_(1.597221069335937500000000000000000000000e2), SC_(1.598818359375000000000000000000000000000e2), SC_(1.831471099853515625000000000000000000000e2), SC_(6.048409342765808105468750000000000000000e-1), SC_(4.019664492923341867838174670780969406732e-1), SC_(5.980335507076658132161825329219030593268e-1) }}, 
      {{ SC_(1.597221069335937500000000000000000000000e2), SC_(1.613193206787109375000000000000000000000e2), SC_(3.767639541625976562500000000000000000000e1), SC_(5.247606635093688964843750000000000000000e-1), SC_(4.913030484440747648856421667131869140930e-1), SC_(5.086969515559252351143578332868130859070e-1) }}, 
      {{ SC_(1.597221069335937500000000000000000000000e2), SC_(1.613193206787109375000000000000000000000e2), SC_(1.310955810546875000000000000000000000000e2), SC_(5.819457173347473144531250000000000000000e-1), SC_(4.877762672762512475634024531992029517883e-1), SC_(5.122237327237487524365975468007970482117e-1) }}, 
      {{ SC_(1.597221069335937500000000000000000000000e2), SC_(1.613193206787109375000000000000000000000e2), SC_(1.867986450195312500000000000000000000000e2), SC_(6.099320054054260253906250000000000000000e-1), SC_(4.860119830212367807356190446786117903021e-1), SC_(5.139880169787632192643809553213882096979e-1) }}, 
      {{ SC_(1.597221069335937500000000000000000000000e2), SC_(1.756943206787109375000000000000000000000e2), SC_(4.238486480712890625000000000000000000000e1), SC_(5.072371363639831542968750000000000000000e-1), SC_(4.993455694568142784705007334475915580753e-1), SC_(5.006544305431857215294992665524084419247e-1) }}, 
      {{ SC_(1.597221069335937500000000000000000000000e2), SC_(1.756943206787109375000000000000000000000e2), SC_(1.311481323242187500000000000000000000000e2), SC_(5.616704821586608886718750000000000000000e-1), SC_(4.971616125899879580044402099614518535531e-1), SC_(5.028383874100120419955597900385481464469e-1) }}, 
      {{ SC_(1.597221069335937500000000000000000000000e2), SC_(1.756943206787109375000000000000000000000e2), SC_(1.914333953857421875000000000000000000000e2), SC_(5.922725796699523925781250000000000000000e-1), SC_(4.960730840830942583300776922081414586061e-1), SC_(5.039269159169057416699223077918585413939e-1) }}, 
      {{ SC_(1.597221069335937500000000000000000000000e2), SC_(1.916665344238281250000000000000000000000e2), SC_(4.420680999755859375000000000000000000000e1), SC_(4.867956638336181640625000000000000000000e-1), SC_(5.006888923536269161465161816820444066024e-1), SC_(4.993111076463730838534838183179555933976e-1) }}, 
      {{ SC_(1.597221069335937500000000000000000000000e2), SC_(1.916665344238281250000000000000000000000e2), SC_(1.357470245361328125000000000000000000000e2), SC_(5.427172183990478515625000000000000000000e-1), SC_(4.984116527036959919522572764575915072962e-1), SC_(5.015883472963040080477427235424084927038e-1) }}, 
      {{ SC_(1.597221069335937500000000000000000000000e2), SC_(1.916665344238281250000000000000000000000e2), SC_(1.915013732910156250000000000000000000000e2), SC_(5.711870193481445312500000000000000000000e-1), SC_(4.973848286043566530706268390018578812754e-1), SC_(5.026151713956433469293731609981421187246e-1) }}, 
      {{ SC_(1.597221069335937500000000000000000000000e2), SC_(2.076387329101562500000000000000000000000e2), SC_(5.569964599609375000000000000000000000000e1), SC_(4.750438034534454345703125000000000000000e-1), SC_(5.081823675966595887541020253206960872660e-1), SC_(4.918176324033404112458979746793039127340e-1) }}, 
      {{ SC_(1.597221069335937500000000000000000000000e2), SC_(2.076387329101562500000000000000000000000e2), SC_(1.362719116210937500000000000000000000000e2), SC_(5.235192775726318359375000000000000000000e-1), SC_(5.056935030586834406274170578911793132158e-1), SC_(4.943064969413165593725829421088206867842e-1) }}, 
      {{ SC_(1.597221069335937500000000000000000000000e2), SC_(2.076387329101562500000000000000000000000e2), SC_(1.918984832763671875000000000000000000000e2), SC_(5.520839691162109375000000000000000000000e-1), SC_(5.044192275253448495131495526832038453624e-1), SC_(4.955807724746551504868504473167961546376e-1) }}, 
      {{ SC_(1.597221069335937500000000000000000000000e2), SC_(2.395831604003906250000000000000000000000e2), SC_(5.940588760375976562500000000000000000000e1), SC_(4.469818472862243652343750000000000000000e-1), SC_(5.884140296440493956799948332869150661599e-1), SC_(4.115859703559506043200051667130849338401e-1) }}, 
      {{ SC_(1.597221069335937500000000000000000000000e2), SC_(2.395831604003906250000000000000000000000e2), SC_(1.451677856445312500000000000000000000000e2), SC_(4.971523284912109375000000000000000000000e-1), SC_(5.795006960943754158294382600287859468160e-1), SC_(4.204993039056245841705617399712140531840e-1) }}, 
      {{ SC_(1.597221069335937500000000000000000000000e2), SC_(2.395831604003906250000000000000000000000e2), SC_(1.929777069091796875000000000000000000000e2), SC_(5.213654637336730957031250000000000000000e-1), SC_(5.760303369258268090076838013917199059757e-1), SC_(4.239696630741731909923161986082800940243e-1) }}, 
      {{ SC_(1.597221069335937500000000000000000000000e2), SC_(3.194442138671875000000000000000000000000e2), SC_(6.038262176513671875000000000000000000000e1), SC_(4.297962784767150878906250000000000000000e-1), SC_(9.939492885638609398791074583522268400827e-1), SC_(6.050711436139060120892541647773159917330e-3) }}, 
      {{ SC_(1.597221069335937500000000000000000000000e2), SC_(3.194442138671875000000000000000000000000e2), SC_(1.481294555664062500000000000000000000000e2), SC_(4.749497473239898681640625000000000000000e-1), SC_(9.891302435383153722150619126265774564178e-1), SC_(1.086975646168462778493808737342254358217e-2) }}, 
      {{ SC_(1.597221069335937500000000000000000000000e2), SC_(3.194442138671875000000000000000000000000e2), SC_(1.935389862060546875000000000000000000000e2), SC_(4.956233799457550048828125000000000000000e-1), SC_(9.867401012817310069224476128769425220744e-1), SC_(1.325989871826899307755238712305747792558e-2) }}, 
      {{ SC_(1.597221069335937500000000000000000000000e2), SC_(4.791663208007812500000000000000000000000e2), SC_(6.163340759277343750000000000000000000000e1), SC_(4.037186205387115478515625000000000000000e-1), SC_(9.999999995907356896289068868349045492613e-1), SC_(4.092643103710931131650954507387360222746e-10) }}, 
      {{ SC_(1.597221069335937500000000000000000000000e2), SC_(4.791663208007812500000000000000000000000e2), SC_(1.486264953613281250000000000000000000000e2), SC_(4.400411546230316162109375000000000000000e-1), SC_(9.999999909358711105607279310855018216948e-1), SC_(9.064128889439272068914498178305168749989e-9) }}, 
      {{ SC_(1.597221069335937500000000000000000000000e2), SC_(4.791663208007812500000000000000000000000e2), SC_(1.937735595703125000000000000000000000000e2), SC_(4.572028219699859619140625000000000000000e-1), SC_(9.999999735455714651781271954060265208585e-1), SC_(2.645442853482187280459397347914147382379e-8) }}, 
      {{ SC_(1.597221069335937500000000000000000000000e2), SC_(6.388884277343750000000000000000000000000e2), SC_(7.225879669189453125000000000000000000000e1), SC_(4.112200438976287841796875000000000000000e-1), SC_(9.999999999999999999999990050516773745383e-1), SC_(9.949483226254617019129077958954647454135e-25) }}, 
      {{ SC_(1.597221069335937500000000000000000000000e2), SC_(6.388884277343750000000000000000000000000e2), SC_(1.515480346679687500000000000000000000000e2), SC_(4.378888010978698730468750000000000000000e-1), SC_(9.999999999999999999988565957737801852804e-1), SC_(1.143404226219814719550067855577542564416e-21) }}, 
      {{ SC_(1.597221069335937500000000000000000000000e2), SC_(6.388884277343750000000000000000000000000e2), SC_(1.941185607910156250000000000000000000000e2), SC_(4.512351453304290771484375000000000000000e-1), SC_(9.999999999999999999834990404220497279869e-1), SC_(1.650095957795027201306900383433558084984e-20) }}, 
      {{ SC_(1.597221069335937500000000000000000000000e2), SC_(7.986105346679687500000000000000000000000e2), SC_(9.566968083381652832031250000000000000000e-1), SC_(4.447213113307952880859375000000000000000e-1), SC_(1.000000000000000000000000000000000000000), SC_(7.247569658440674612674336757805534236133e-75) }}, 
      {{ SC_(1.597221069335937500000000000000000000000e2), SC_(7.986105346679687500000000000000000000000e2), SC_(7.844540405273437500000000000000000000000e1), SC_(4.662671983242034912109375000000000000000e-1), SC_(1.000000000000000000000000000000000000000), SC_(4.999123796258941869028321148500375753823e-63) }}, 
      {{ SC_(1.597221069335937500000000000000000000000e2), SC_(7.986105346679687500000000000000000000000e2), SC_(1.584414672851562500000000000000000000000e2), SC_(4.868252277374267578125000000000000000000e-1), SC_(1.000000000000000000000000000000000000000), SC_(3.986744726201083067799237807561424739597e-56) }}, 
      {{ SC_(1.597221069335937500000000000000000000000e2), SC_(7.986105346679687500000000000000000000000e2), SC_(1.962219390869140625000000000000000000000e2), SC_(4.959940910339355468750000000000000000000e-1), SC_(1.000000000000000000000000000000000000000), SC_(9.825731898772651525697620135729798372220e-54) }}, 
      {{ SC_(1.601559448242187500000000000000000000000e2), SC_(1.601559448242187500000000000000000000000e1), SC_(6.163340759277343750000000000000000000000e1), SC_(9.612849950790405273437500000000000000000e-1), SC_(9.930759542723117912530112723842936763358e-1), SC_(6.924045727688208746988727615706323664240e-3) }}, 
      {{ SC_(1.601559448242187500000000000000000000000e2), SC_(1.601559448242187500000000000000000000000e1), SC_(1.486264953613281250000000000000000000000e2), SC_(9.679929018020629882812500000000000000000e-1), SC_(9.926806352346529220416041079914931606775e-1), SC_(7.319364765347077958395892008506839322487e-3) }}, 
      {{ SC_(1.601559448242187500000000000000000000000e2), SC_(1.601559448242187500000000000000000000000e1), SC_(1.937735595703125000000000000000000000000e2), SC_(9.706355333328247070312500000000000000000e-1), SC_(9.925435873083728240226381565161514686378e-1), SC_(7.456412691627175977361843483848531362181e-3) }}, 
      {{ SC_(1.601559448242187500000000000000000000000e2), SC_(4.003898620605468750000000000000000000000e1), SC_(7.225879669189453125000000000000000000000e1), SC_(9.434888362884521484375000000000000000000e-1), SC_(9.999999993274896467918181936808602029028e-1), SC_(6.725103532081818063191397970971831368934e-10) }}, 
      {{ SC_(1.601559448242187500000000000000000000000e2), SC_(4.003898620605468750000000000000000000000e1), SC_(1.515480346679687500000000000000000000000e2), SC_(9.515901803970336914062500000000000000000e-1), SC_(9.999999989806382952210527250417361735718e-1), SC_(1.019361704778947274958263826428172986701e-9) }}, 
      {{ SC_(1.601559448242187500000000000000000000000e2), SC_(4.003898620605468750000000000000000000000e1), SC_(1.941185607910156250000000000000000000000e2), SC_(9.550519585609436035156250000000000000000e-1), SC_(9.999999988140492771918800704891187036740e-1), SC_(1.185950722808119929510881296325990858141e-9) }}, 
      {{ SC_(1.601559448242187500000000000000000000000e2), SC_(8.007797241210937500000000000000000000000e1), SC_(9.566968083381652832031250000000000000000e-1), SC_(9.168316125869750976562500000000000000000e-1), SC_(9.999999999999999999999999995603574483591e-1), SC_(4.396425516409267280089488621418328570818e-28) }}, 
      {{ SC_(1.601559448242187500000000000000000000000e2), SC_(8.007797241210937500000000000000000000000e1), SC_(7.844540405273437500000000000000000000000e1), SC_(9.283268451690673828125000000000000000000e-1), SC_(9.999999999999999999999999920289241937136e-1), SC_(7.971075806286389680530740001229763813517e-27) }}, 
      {{ SC_(1.601559448242187500000000000000000000000e2), SC_(8.007797241210937500000000000000000000000e1), SC_(1.584414672851562500000000000000000000000e2), SC_(9.372836351394653320312500000000000000000e-1), SC_(9.999999999999999999999999567608083198302e-1), SC_(4.323919168016975916741947210628056280920e-26) }}, 
      {{ SC_(1.601559448242187500000000000000000000000e2), SC_(8.007797241210937500000000000000000000000e1), SC_(1.962219390869140625000000000000000000000e2), SC_(9.407804012298583984375000000000000000000e-1), SC_(9.999999999999999999999999243547643146276e-1), SC_(7.564523568537242857754092713557921561799e-26) }}, 
      {{ SC_(1.601559448242187500000000000000000000000e2), SC_(1.201169586181640625000000000000000000000e2), SC_(7.142335891723632812500000000000000000000), SC_(9.153603911399841308593750000000000000000e-1), SC_(1.000000000000000000000000000000000000000), SC_(4.050004063355320574972161541554923088067e-53) }}, 
      {{ SC_(1.601559448242187500000000000000000000000e2), SC_(1.201169586181640625000000000000000000000e2), SC_(7.974770355224609375000000000000000000000e1), SC_(9.249321222305297851562500000000000000000e-1), SC_(1.000000000000000000000000000000000000000), SC_(1.212001417672951686716696228148605896251e-50) }}, 
      {{ SC_(1.601559448242187500000000000000000000000e2), SC_(1.201169586181640625000000000000000000000e2), SC_(1.595857238769531250000000000000000000000e2), SC_(9.332394599914550781250000000000000000000e-1), SC_(1.000000000000000000000000000000000000000), SC_(4.782664484076816257614066267662149672129e-49) }}, 
      {{ SC_(1.601559448242187500000000000000000000000e2), SC_(1.201169586181640625000000000000000000000e2), SC_(1.985762634277343750000000000000000000000e2), SC_(9.366638064384460449218750000000000000000e-1), SC_(1.000000000000000000000000000000000000000), SC_(1.707505359303145474194384335956755441413e-48) }}, 
      {{ SC_(1.601559448242187500000000000000000000000e2), SC_(1.441403503417968750000000000000000000000e2), SC_(1.950807952880859375000000000000000000000e1), SC_(5.409824848175048828125000000000000000000e-2), SC_(4.246365272560176795059338971909820727175e-121), SC_(1.000000000000000000000000000000000000000) }}, 
      {{ SC_(1.601559448242187500000000000000000000000e2), SC_(1.441403503417968750000000000000000000000e2), SC_(8.435225677490234375000000000000000000000e1), SC_(5.838312581181526184082031250000000000000e-2), SC_(1.387285751502368284139518411578267016896e-128), SC_(1.000000000000000000000000000000000000000) }}, 
      {{ SC_(1.601559448242187500000000000000000000000e2), SC_(1.441403503417968750000000000000000000000e2), SC_(1.596211700439453125000000000000000000000e2), SC_(6.245359778404235839843750000000000000000e-2), SC_(1.761621394028707796688147671567699451484e-138), SC_(1.000000000000000000000000000000000000000) }}, 
      {{ SC_(1.601559448242187500000000000000000000000e2), SC_(1.441403503417968750000000000000000000000e2), SC_(1.992922668457031250000000000000000000000e2), SC_(6.429482251405715942382812500000000000000e-2), SC_(4.610010757489852210381256683230027569837e-144), SC_(1.000000000000000000000000000000000000000) }}, 
      {{ SC_(1.601559448242187500000000000000000000000e2), SC_(1.585543823242187500000000000000000000000e2), SC_(2.197235107421875000000000000000000000000e1), SC_(1.297603249549865722656250000000000000000e-1), SC_(1.801244362756208047274903490969505011066e-61), SC_(1.000000000000000000000000000000000000000) }}, 
      {{ SC_(1.601559448242187500000000000000000000000e2), SC_(1.585543823242187500000000000000000000000e2), SC_(8.441753387451171875000000000000000000000e1), SC_(1.401375979185104370117187500000000000000e-1), SC_(1.012622785755154176867035904738644079673e-66), SC_(1.000000000000000000000000000000000000000) }}, 
      {{ SC_(1.601559448242187500000000000000000000000e2), SC_(1.585543823242187500000000000000000000000e2), SC_(1.600560913085937500000000000000000000000e2), SC_(1.505399346351623535156250000000000000000e-1), SC_(5.645442857999455757874583035566425659841e-74), SC_(1.000000000000000000000000000000000000000) }}, 
      {{ SC_(1.601559448242187500000000000000000000000e2), SC_(1.599957885742187500000000000000000000000e2), SC_(2.249290275573730468750000000000000000000e1), SC_(2.585801780223846435546875000000000000000e-1), SC_(5.819289633824590021607677937999839612142e-23), SC_(9.999999999999999999999418071036617540998e-1) }}, 
      {{ SC_(1.601559448242187500000000000000000000000e2), SC_(1.599957885742187500000000000000000000000e2), SC_(9.495173645019531250000000000000000000000e1), SC_(2.823177576065063476562500000000000000000e-1), SC_(3.657850594077588201428905367545893639853e-26), SC_(9.999999999999999999999999634214940592241e-1) }}, 
      {{ SC_(1.601559448242187500000000000000000000000e2), SC_(1.599957885742187500000000000000000000000e2), SC_(1.629447326660156250000000000000000000000e2), SC_(3.007133901119232177734375000000000000000e-1), SC_(1.381257229719323188500787845304216679402e-29), SC_(9.999999999999999999999999999861874277028e-1) }}, 
      {{ SC_(1.601559448242187500000000000000000000000e2), SC_(1.601559448242187500000000000000000000000e2), SC_(2.539736366271972656250000000000000000000e1), SC_(3.892585635185241699218750000000000000000e-1), SC_(1.369672676723816227939843688539488247521e-6), SC_(9.999986303273232761837720601563114605118e-1) }}, 
      {{ SC_(1.601559448242187500000000000000000000000e2), SC_(1.601559448242187500000000000000000000000e2), SC_(9.707512664794921875000000000000000000000e1), SC_(4.242307543754577636718750000000000000000e-1), SC_(1.388956148817892648354370243656865083519e-7), SC_(9.999998611043851182107351645629756343135e-1) }}, 
      {{ SC_(1.601559448242187500000000000000000000000e2), SC_(1.601559448242187500000000000000000000000e2), SC_(1.670017089843750000000000000000000000000e2), SC_(4.523905813694000244140625000000000000000e-1), SC_(1.071043038530280806178475309025594428456e-8), SC_(9.999999892895696146971919382152469097441e-1) }}, 
      {{ SC_(1.601559448242187500000000000000000000000e2), SC_(1.601719665527343750000000000000000000000e2), SC_(2.709540176391601562500000000000000000000e1), SC_(4.681856334209442138671875000000000000000e-1), SC_(3.102202227002695172422710985211907141924e-2), SC_(9.689779777299730482757728901478809285808e-1) }}, 
      {{ SC_(1.601559448242187500000000000000000000000e2), SC_(1.601719665527343750000000000000000000000e2), SC_(1.007325439453125000000000000000000000000e2), SC_(5.109795928001403808593750000000000000000e-1), SC_(1.870562899928001223600087733482428932304e-2), SC_(9.812943710007199877639991226651757106770e-1) }}, 
      {{ SC_(1.601559448242187500000000000000000000000e2), SC_(1.601719665527343750000000000000000000000e2), SC_(1.698258666992187500000000000000000000000e2), SC_(5.440899133682250976562500000000000000000e-1), SC_(1.088545191453115468291092315663139390304e-2), SC_(9.891145480854688453170890768433686060970e-1) }}, 
      {{ SC_(1.601559448242187500000000000000000000000e2), SC_(1.603161010742187500000000000000000000000e2), SC_(2.837726783752441406250000000000000000000e1), SC_(5.156896114349365234375000000000000000000e-1), SC_(4.249498457242713701438575535811375427075e-1), SC_(5.750501542757286298561424464188624572925e-1) }}, 
      {{ SC_(1.601559448242187500000000000000000000000e2), SC_(1.603161010742187500000000000000000000000e2), SC_(1.093762969970703125000000000000000000000e2), SC_(5.667818188667297363281250000000000000000e-1), SC_(4.129081957864474646579284559847921914018e-1), SC_(5.870918042135525353420715440152078085982e-1) }}, 
      {{ SC_(1.601559448242187500000000000000000000000e2), SC_(1.603161010742187500000000000000000000000e2), SC_(1.756861267089843750000000000000000000000e2), SC_(6.010931134223937988281250000000000000000e-1), SC_(4.030286257264536942004104887313829078387e-1), SC_(5.969713742735463057995895112686170921613e-1) }}, 
      {{ SC_(1.601559448242187500000000000000000000000e2), SC_(1.617575073242187500000000000000000000000e2), SC_(3.152261734008789062500000000000000000000e1), SC_(5.203794240951538085937500000000000000000e-1), SC_(4.915603527802528813596947068240693407532e-1), SC_(5.084396472197471186403052931759306592468e-1) }}, 
      {{ SC_(1.601559448242187500000000000000000000000e2), SC_(1.617575073242187500000000000000000000000e2), SC_(1.094441146850585937500000000000000000000e2), SC_(5.697837471961975097656250000000000000000e-1), SC_(4.885267448019751126863989958242953454555e-1), SC_(5.114732551980248873136010041757046545445e-1) }}, 
      {{ SC_(1.601559448242187500000000000000000000000e2), SC_(1.617575073242187500000000000000000000000e2), SC_(1.811583862304687500000000000000000000000e2), SC_(6.070372462272644042968750000000000000000e-1), SC_(4.861901805357079152323332166387649157467e-1), SC_(5.138098194642920847676667833612350842533e-1) }}, 
      {{ SC_(1.601559448242187500000000000000000000000e2), SC_(1.761715393066406250000000000000000000000e2), SC_(3.423733520507812500000000000000000000000e1), SC_(5.014921426773071289062500000000000000000e-1), SC_(4.995920887989429436906929851378598557230e-1), SC_(5.004079112010570563093070148621401442770e-1) }}, 
      {{ SC_(1.601559448242187500000000000000000000000e2), SC_(1.761715393066406250000000000000000000000e2), SC_(1.264718551635742187500000000000000000000e2), SC_(5.589152574539184570312500000000000000000e-1), SC_(4.972682034241263755749226882338711319361e-1), SC_(5.027317965758736244250773117661288680639e-1) }}, 
      {{ SC_(1.601559448242187500000000000000000000000e2), SC_(1.761715393066406250000000000000000000000e2), SC_(1.826751708984375000000000000000000000000e2), SC_(5.878561735153198242187500000000000000000e-1), SC_(4.962288201875698407896719985619568235512e-1), SC_(5.037711798124301592103280014380431764488e-1) }}, 
      {{ SC_(1.601559448242187500000000000000000000000e2), SC_(1.921871490478515625000000000000000000000e2), SC_(3.477303314208984375000000000000000000000e1), SC_(4.801813066005706787109375000000000000000e-1), SC_(5.009789116472606152697409779167802704187e-1), SC_(4.990210883527393847302590220832197295813e-1) }}, 
      {{ SC_(1.601559448242187500000000000000000000000e2), SC_(1.921871490478515625000000000000000000000e2), SC_(1.279526672363281250000000000000000000000e2), SC_(5.382419228553771972656250000000000000000e-1), SC_(4.985854055661354834827421805427620160230e-1), SC_(5.014145944338645165172578194572379839770e-1) }}, 
      {{ SC_(1.601559448242187500000000000000000000000e2), SC_(1.921871490478515625000000000000000000000e2), SC_(1.831471099853515625000000000000000000000e2), SC_(5.669069290161132812500000000000000000000e-1), SC_(4.975385270263933691336559304475990687929e-1), SC_(5.024614729736066308663440695524009312071e-1) }}, 
      {{ SC_(1.601559448242187500000000000000000000000e2), SC_(2.082027130126953125000000000000000000000e2), SC_(3.767639541625976562500000000000000000000e1), SC_(4.627517163753509521484375000000000000000e-1), SC_(5.088911120269079470809331741707531706018e-1), SC_(4.911088879730920529190668258292468293982e-1) }}, 
      {{ SC_(1.601559448242187500000000000000000000000e2), SC_(2.082027130126953125000000000000000000000e2), SC_(1.310955810546875000000000000000000000000e2), SC_(5.204792618751525878906250000000000000000e-1), SC_(5.058494729973555592755725293086274976965e-1), SC_(4.941505270026444407244274706913725023035e-1) }}, 
      {{ SC_(1.601559448242187500000000000000000000000e2), SC_(2.082027130126953125000000000000000000000e2), SC_(1.867986450195312500000000000000000000000e2), SC_(5.493617653846740722656250000000000000000e-1), SC_(5.045489022302612719364503690255632712062e-1), SC_(4.954510977697387280635496309744367287938e-1) }}, 
      {{ SC_(1.601559448242187500000000000000000000000e2), SC_(2.402339172363281250000000000000000000000e2), SC_(4.238486480712890625000000000000000000000e1), SC_(4.357359409332275390625000000000000000000e-1), SC_(5.909362610410552663936388293733093156828e-1), SC_(4.090637389589447336063611706266906843172e-1) }}, 
      {{ SC_(1.601559448242187500000000000000000000000e2), SC_(2.402339172363281250000000000000000000000e2), SC_(1.311481323242187500000000000000000000000e2), SC_(4.893870651721954345703125000000000000000e-1), SC_(5.808242950501612387121449500291501602878e-1), SC_(4.191757049498387612878550499708498397122e-1) }}, 
      {{ SC_(1.601559448242187500000000000000000000000e2), SC_(2.402339172363281250000000000000000000000e2), SC_(1.914333953857421875000000000000000000000e2), SC_(5.203694701194763183593750000000000000000e-1), SC_(5.762724653213537666288281321732035604295e-1), SC_(4.237275346786462333711718678267964395705e-1) }}, 
      {{ SC_(1.601559448242187500000000000000000000000e2), SC_(3.203118896484375000000000000000000000000e2), SC_(4.420680999755859375000000000000000000000e1), SC_(4.205436110496520996093750000000000000000e-1), SC_(9.948788657608350721161672802662089350242e-1), SC_(5.121134239164927883832719733791064975804e-3) }}, 
      {{ SC_(1.601559448242187500000000000000000000000e2), SC_(3.203118896484375000000000000000000000000e2), SC_(1.357470245361328125000000000000000000000e2), SC_(4.688375294208526611328125000000000000000e-1), SC_(9.899059832040019489779905345469870229304e-1), SC_(1.009401679599805102200946545301297706960e-2) }}, 
      {{ SC_(1.601559448242187500000000000000000000000e2), SC_(3.203118896484375000000000000000000000000e2), SC_(1.915013732910156250000000000000000000000e2), SC_(4.945032298564910888671875000000000000000e-1), SC_(9.869728311159822393552984799660908948154e-1), SC_(1.302716888401776064470152003390910518461e-2) }}, 
      {{ SC_(1.601559448242187500000000000000000000000e2), SC_(4.804678344726562500000000000000000000000e2), SC_(5.569964599609375000000000000000000000000e1), SC_(4.010013341903686523437500000000000000000e-1), SC_(9.999999997116020437959944437611953069597e-1), SC_(2.883979562040055562388046930403425928303e-10) }}, 
      {{ SC_(1.601559448242187500000000000000000000000e2), SC_(4.804678344726562500000000000000000000000e2), SC_(1.362719116210937500000000000000000000000e2), SC_(4.350071847438812255859375000000000000000e-1), SC_(9.999999939128755277823767340583134815503e-1), SC_(6.087124472217623265941686518449717751816e-9) }}, 
      {{ SC_(1.601559448242187500000000000000000000000e2), SC_(4.804678344726562500000000000000000000000e2), SC_(1.918984832763671875000000000000000000000e2), SC_(4.563191235065460205078125000000000000000e-1), SC_(9.999999758774389006684488335221826290665e-1), SC_(2.412256109933155116647781737093347475576e-8) }}, 
      {{ SC_(1.601559448242187500000000000000000000000e2), SC_(6.406237792968750000000000000000000000000e2), SC_(5.940588760375976562500000000000000000000e1), SC_(4.065995812416076660156250000000000000000e-1), SC_(9.999999999999999999999998188292146781461e-1), SC_(1.811707853218538741891150809251573762403e-25) }}, 
      {{ SC_(1.601559448242187500000000000000000000000e2), SC_(6.406237792968750000000000000000000000000e2), SC_(1.451677856445312500000000000000000000000e2), SC_(4.357053339481353759765625000000000000000e-1), SC_(9.999999999999999999993761898232031862759e-1), SC_(6.238101767968137241015158635091220845351e-22) }}, 
      {{ SC_(1.601559448242187500000000000000000000000e2), SC_(6.406237792968750000000000000000000000000e2), SC_(1.929777069091796875000000000000000000000e2), SC_(4.507256746292114257812500000000000000000e-1), SC_(9.999999999999999999866352613847858038948e-1), SC_(1.336473861521419610515671479080480089331e-20) }}, 
      {{ SC_(1.601559448242187500000000000000000000000e2), SC_(8.007797241210937500000000000000000000000e2), SC_(6.038262176513671875000000000000000000000e1), SC_(4.613510072231292724609375000000000000000e-1), SC_(1.000000000000000000000000000000000000000), SC_(2.588668998402366245779053538642166619982e-65) }}, 
      {{ SC_(1.601559448242187500000000000000000000000e2), SC_(8.007797241210937500000000000000000000000e2), SC_(1.481294555664062500000000000000000000000e2), SC_(4.841643869876861572265625000000000000000e-1), SC_(1.000000000000000000000000000000000000000), SC_(4.927729363595702604806670552821903526183e-57) }}, 
      {{ SC_(1.601559448242187500000000000000000000000e2), SC_(8.007797241210937500000000000000000000000e2), SC_(1.935389862060546875000000000000000000000e2), SC_(4.952285885810852050781250000000000000000e-1), SC_(1.000000000000000000000000000000000000000), SC_(4.614102501010913156146165426868764367879e-54) }}, 
      {{ SC_(1.630373687744140625000000000000000000000e2), SC_(1.630373764038085937500000000000000000000e1), SC_(5.569964599609375000000000000000000000000e1), SC_(9.606297612190246582031250000000000000000e-1), SC_(9.935562931027678790846295983284811972137e-1), SC_(6.443706897232120915370401671518802786271e-3) }}, 
      {{ SC_(1.630373687744140625000000000000000000000e2), SC_(1.630373764038085937500000000000000000000e1), SC_(1.362719116210937500000000000000000000000e2), SC_(9.670234918594360351562500000000000000000e-1), SC_(9.931910293086431117990996513456806556299e-1), SC_(6.808970691356888200900348654319344370099e-3) }}, 
      {{ SC_(1.630373687744140625000000000000000000000e2), SC_(1.630373764038085937500000000000000000000e1), SC_(1.918984832763671875000000000000000000000e2), SC_(9.703506231307983398437500000000000000000e-1), SC_(9.930238286179591208595462085811574366957e-1), SC_(6.976171382040879140453791418842563304255e-3) }}, 
      {{ SC_(1.630373687744140625000000000000000000000e2), SC_(4.075934219360351562500000000000000000000e1), SC_(5.940588760375976562500000000000000000000e1), SC_(9.417821168899536132812500000000000000000e-1), SC_(9.999999995694435858943035353855790814838e-1), SC_(4.305564141056964646144209185162034603469e-10) }}, 
      {{ SC_(1.630373687744140625000000000000000000000e2), SC_(4.075934219360351562500000000000000000000e1), SC_(1.451677856445312500000000000000000000000e2), SC_(9.507948160171508789062500000000000000000e-1), SC_(9.999999992992947298983111126052665374951e-1), SC_(7.007052701016888873947334625048946094579e-10) }}, 
      {{ SC_(1.630373687744140625000000000000000000000e2), SC_(4.075934219360351562500000000000000000000e1), SC_(1.929777069091796875000000000000000000000e2), SC_(9.547064900398254394531250000000000000000e-1), SC_(9.999999991638206565062865067359253529782e-1), SC_(8.361793434937134932640746470217746629943e-10) }}, 
      {{ SC_(1.630373687744140625000000000000000000000e2), SC_(8.151868438720703125000000000000000000000e1), SC_(6.038262176513671875000000000000000000000e1), SC_(9.257943034172058105468750000000000000000e-1), SC_(9.999999999999999999999999983966956295318e-1), SC_(1.603304370468225216444448276218366299771e-27) }}, 
      {{ SC_(1.630373687744140625000000000000000000000e2), SC_(8.151868438720703125000000000000000000000e1), SC_(1.481294555664062500000000000000000000000e2), SC_(9.359911680221557617187500000000000000000e-1), SC_(9.999999999999999999999999873693595176265e-1), SC_(1.263064048237349291970120162189773739303e-26) }}, 
      {{ SC_(1.630373687744140625000000000000000000000e2), SC_(8.151868438720703125000000000000000000000e1), SC_(1.935389862060546875000000000000000000000e2), SC_(9.402430057525634765625000000000000000000e-1), SC_(9.999999999999999999999999743408634223974e-1), SC_(2.565913657760262925200196794305340223845e-26) }}, 
      {{ SC_(1.630373687744140625000000000000000000000e2), SC_(1.222780303955078125000000000000000000000e2), SC_(6.163340759277343750000000000000000000000e1), SC_(9.226173162460327148437500000000000000000e-1), SC_(1.000000000000000000000000000000000000000), SC_(4.720945476695521389518203457867697594998e-52) }}, 
      {{ SC_(1.630373687744140625000000000000000000000e2), SC_(1.222780303955078125000000000000000000000e2), SC_(1.486264953613281250000000000000000000000e2), SC_(9.319585561752319335937500000000000000000e-1), SC_(1.000000000000000000000000000000000000000), SC_(4.043904054749792880853413972567690123157e-50) }}, 
      {{ SC_(1.630373687744140625000000000000000000000e2), SC_(1.222780303955078125000000000000000000000e2), SC_(1.937735595703125000000000000000000000000e2), SC_(9.359714984893798828125000000000000000000e-1), SC_(1.000000000000000000000000000000000000000), SC_(1.927117719222132638554093122088465424340e-49) }}, 
      {{ SC_(1.630373687744140625000000000000000000000e2), SC_(1.467336273193359375000000000000000000000e2), SC_(7.225879669189453125000000000000000000000e1), SC_(5.756641551852226257324218750000000000000e-2), SC_(3.420302567940635006646250072675550017115e-129), SC_(1.000000000000000000000000000000000000000) }}, 
      {{ SC_(1.630373687744140625000000000000000000000e2), SC_(1.467336273193359375000000000000000000000e2), SC_(1.515480346679687500000000000000000000000e2), SC_(6.192184612154960632324218750000000000000e-2), SC_(1.969355465691819139849115935133339255749e-139), SC_(1.000000000000000000000000000000000000000) }}, 
      {{ SC_(1.630373687744140625000000000000000000000e2), SC_(1.467336273193359375000000000000000000000e2), SC_(1.941185607910156250000000000000000000000e2), SC_(6.391131877899169921875000000000000000000e-2), SC_(2.298586074124694348678657683543199036868e-145), SC_(1.000000000000000000000000000000000000000) }}, 
      {{ SC_(1.630373687744140625000000000000000000000e2), SC_(1.614069976806640625000000000000000000000e2), SC_(9.566968083381652832031250000000000000000e-1), SC_(1.258106827735900878906250000000000000000e-1), SC_(5.909840286449754873336995141223478473486e-61), SC_(1.000000000000000000000000000000000000000) }}, 
      {{ SC_(1.630373687744140625000000000000000000000e2), SC_(1.614069976806640625000000000000000000000e2), SC_(7.844540405273437500000000000000000000000e1), SC_(1.390091478824615478515625000000000000000e-1), SC_(3.262838379095799690892025649392015927424e-67), SC_(1.000000000000000000000000000000000000000) }}, 
      {{ SC_(1.630373687744140625000000000000000000000e2), SC_(1.614069976806640625000000000000000000000e2), SC_(1.584414672851562500000000000000000000000e2), SC_(1.499879658222198486328125000000000000000e-1), SC_(8.137968121355539882531263804777061914850e-75), SC_(1.000000000000000000000000000000000000000) }}, 
      {{ SC_(1.630373687744140625000000000000000000000e2), SC_(1.614069976806640625000000000000000000000e2), SC_(1.962219390869140625000000000000000000000e2), SC_(1.544529348611831665039062500000000000000e-1), SC_(1.107514896122736737400469116370649502460e-78), SC_(1.000000000000000000000000000000000000000) }}, 
      {{ SC_(1.630373687744140625000000000000000000000e2), SC_(1.628743286132812500000000000000000000000e2), SC_(7.142335891723632812500000000000000000000), SC_(2.528252601623535156250000000000000000000e-1), SC_(9.992017048653645050082794812848996070812e-23), SC_(9.999999999999999999999000798295134635495e-1) }}, 
      {{ SC_(1.630373687744140625000000000000000000000e2), SC_(1.628743286132812500000000000000000000000e2), SC_(7.974770355224609375000000000000000000000e1), SC_(2.772972881793975830078125000000000000000e-1), SC_(8.355695746559728134031853759014692948066e-26), SC_(9.999999999999999999999999164430425344027e-1) }}, 
      {{ SC_(1.630373687744140625000000000000000000000e2), SC_(1.628743286132812500000000000000000000000e2), SC_(1.595857238769531250000000000000000000000e2), SC_(2.991724610328674316406250000000000000000e-1), SC_(9.405196185903223507952280504809911021910e-30), SC_(9.999999999999999999999999999905948038141e-1) }}, 
      {{ SC_(1.630373687744140625000000000000000000000e2), SC_(1.628743286132812500000000000000000000000e2), SC_(1.985762634277343750000000000000000000000e2), SC_(3.083680272102355957031250000000000000000e-1), SC_(7.732693429343392404244609245151219063442e-32), SC_(9.999999999999999999999999999999226730657e-1) }}, 
      {{ SC_(1.630373687744140625000000000000000000000e2), SC_(1.630373687744140625000000000000000000000e2), SC_(1.950807952880859375000000000000000000000e1), SC_(3.858602643013000488281250000000000000000e-1), SC_(1.336875583673285773733736759605662981817e-6), SC_(9.999986631244163267142262662632403943370e-1) }}, 
      {{ SC_(1.630373687744140625000000000000000000000e2), SC_(1.630373687744140625000000000000000000000e2), SC_(8.435225677490234375000000000000000000000e1), SC_(4.178458452224731445312500000000000000000e-1), SC_(1.777683963986852634570441180764383292001e-7), SC_(9.999998222316036013147365429558819235617e-1) }}, 
      {{ SC_(1.630373687744140625000000000000000000000e2), SC_(1.630373687744140625000000000000000000000e2), SC_(1.596211700439453125000000000000000000000e2), SC_(4.485915303230285644531250000000000000000e-1), SC_(1.193016936364723714660687616333299934917e-8), SC_(9.999999880698306363527628533931238366670e-1) }}, 
      {{ SC_(1.630373687744140625000000000000000000000e2), SC_(1.630373687744140625000000000000000000000e2), SC_(1.992922668457031250000000000000000000000e2), SC_(4.626162648200988769531250000000000000000e-1), SC_(2.531514662811007549911050458160004416685e-9), SC_(9.999999974684853371889924500889495418400e-1) }}, 
      {{ SC_(1.630373687744140625000000000000000000000e2), SC_(1.630536804199218750000000000000000000000e2), SC_(2.197235107421875000000000000000000000000e1), SC_(4.646027386188507080078125000000000000000e-1), SC_(3.092963748053377734404266049326548076351e-2), SC_(9.690703625194662226559573395067345192365e-1) }}, 
      {{ SC_(1.630373687744140625000000000000000000000e2), SC_(1.630536804199218750000000000000000000000e2), SC_(8.441753387451171875000000000000000000000e1), SC_(5.014280080795288085937500000000000000000e-1), SC_(2.038944389374962245829210105264242398363e-2), SC_(9.796105561062503775417078989473575760164e-1) }}, 
      {{ SC_(1.630373687744140625000000000000000000000e2), SC_(1.630536804199218750000000000000000000000e2), SC_(1.600560913085937500000000000000000000000e2), SC_(5.384815931320190429687500000000000000000e-1), SC_(1.145046091776315867012180956559524354096e-2), SC_(9.885495390822368413298781904344047564590e-1) }}, 
      {{ SC_(1.630373687744140625000000000000000000000e2), SC_(1.632004089355468750000000000000000000000e2), SC_(2.249290275573730468750000000000000000000e1), SC_(5.112091302871704101562500000000000000000e-1), SC_(4.252237759138953027623318261461145773289e-1), SC_(5.747762240861046972376681738538854226711e-1) }}, 
      {{ SC_(1.630373687744140625000000000000000000000e2), SC_(1.632004089355468750000000000000000000000e2), SC_(9.495173645019531250000000000000000000000e1), SC_(5.575209259986877441406250000000000000000e-1), SC_(4.146118942432729928912116464195397243021e-1), SC_(5.853881057567270071087883535804602756979e-1) }}, 
      {{ SC_(1.630373687744140625000000000000000000000e2), SC_(1.632004089355468750000000000000000000000e2), SC_(1.629447326660156250000000000000000000000e2), SC_(5.935232639312744140625000000000000000000e-1), SC_(4.045878501580102295126059006197513860449e-1), SC_(5.954121498419897704873940993802486139551e-1) }}, 
      {{ SC_(1.630373687744140625000000000000000000000e2), SC_(1.646677398681640625000000000000000000000e2), SC_(2.539736366271972656250000000000000000000e1), SC_(5.156884193420410156250000000000000000000e-1), SC_(4.917845751971763314864628691790510896323e-1), SC_(5.082154248028236685135371308209489103677e-1) }}, 
      {{ SC_(1.630373687744140625000000000000000000000e2), SC_(1.646677398681640625000000000000000000000e2), SC_(9.707512664794921875000000000000000000000e1), SC_(5.616241097450256347656250000000000000000e-1), SC_(4.889820570784608079215164065701884732042e-1), SC_(5.110179429215391920784835934298115267958e-1) }}, 
      {{ SC_(1.630373687744140625000000000000000000000e2), SC_(1.646677398681640625000000000000000000000e2), SC_(1.670017089843750000000000000000000000000e2), SC_(5.987521409988403320312500000000000000000e-1), SC_(4.866683046829549544671533094604175520818e-1), SC_(5.133316953170450455328466905395824479182e-1) }}, 
      {{ SC_(1.630373687744140625000000000000000000000e2), SC_(1.793411102294921875000000000000000000000e2), SC_(2.709540176391601562500000000000000000000e1), SC_(4.960744678974151611328125000000000000000e-1), SC_(4.998272480441766841302154556477438815044e-1), SC_(5.001727519558233158697845443522561184956e-1) }}, 
      {{ SC_(1.630373687744140625000000000000000000000e2), SC_(1.793411102294921875000000000000000000000e2), SC_(1.007325439453125000000000000000000000000e2), SC_(5.432156324386596679687500000000000000000e-1), SC_(4.978905541476173224497328523270531672230e-1), SC_(5.021094458523826775502671476729468327770e-1) }}, 
      {{ SC_(1.630373687744140625000000000000000000000e2), SC_(1.793411102294921875000000000000000000000e2), SC_(1.698258666992187500000000000000000000000e2), SC_(5.800886154174804687500000000000000000000e-1), SC_(4.965292844242172741777110441105119035948e-1), SC_(5.034707155757827258222889558894880964052e-1) }}, 
      {{ SC_(1.630373687744140625000000000000000000000e2), SC_(1.956448516845703125000000000000000000000e2), SC_(2.837726783752441406250000000000000000000e1), SC_(4.753002226352691650390625000000000000000e-1), SC_(5.011965242560373080551227735855859835665e-1), SC_(4.988034757439626919448772264144140164335e-1) }}, 
      {{ SC_(1.630373687744140625000000000000000000000e2), SC_(1.956448516845703125000000000000000000000e2), SC_(1.093762969970703125000000000000000000000e2), SC_(5.266039371490478515625000000000000000000e-1), SC_(4.990581410343268777145923704227063683368e-1), SC_(5.009418589656731222854076295772936316632e-1) }}, 
      {{ SC_(1.630373687744140625000000000000000000000e2), SC_(1.956448516845703125000000000000000000000e2), SC_(1.756861267089843750000000000000000000000e2), SC_(5.617012381553649902343750000000000000000e-1), SC_(4.977537713900510525342680718646063189081e-1), SC_(5.022462286099489474657319281353936810919e-1) }}, 
      {{ SC_(1.630373687744140625000000000000000000000e2), SC_(2.119485778808593750000000000000000000000e2), SC_(3.152261734008789062500000000000000000000e1), SC_(4.580673575401306152343750000000000000000e-1), SC_(5.092306707290052172052444725031429111317e-1), SC_(4.907693292709947827947555274968570888683e-1) }}, 
      {{ SC_(1.630373687744140625000000000000000000000e2), SC_(2.119485778808593750000000000000000000000e2), SC_(1.094441146850585937500000000000000000000e2), SC_(5.071081519126892089843750000000000000000e-1), SC_(5.065798214269287145758075892364911462583e-1), SC_(4.934201785730712854241924107635088537417e-1) }}, 
      {{ SC_(1.630373687744140625000000000000000000000e2), SC_(2.119485778808593750000000000000000000000e2), SC_(1.811583862304687500000000000000000000000e2), SC_(5.450146794319152832031250000000000000000e-1), SC_(5.048226273932115433932901707115286890365e-1), SC_(4.951773726067884566067098292884713109635e-1) }}, 
      {{ SC_(1.630373687744140625000000000000000000000e2), SC_(2.445560607910156250000000000000000000000e2), SC_(3.423733520507812500000000000000000000000e1), SC_(4.298309385776519775390625000000000000000e-1), SC_(5.930564848234523092043388669470896388172e-1), SC_(4.069435151765476907956611330529103611828e-1) }}, 
      {{ SC_(1.630373687744140625000000000000000000000e2), SC_(2.445560607910156250000000000000000000000e2), SC_(1.264718551635742187500000000000000000000e2), SC_(4.855805337429046630859375000000000000000e-1), SC_(5.821686187816236543876330548228211443096e-1), SC_(4.178313812183763456123669451771788556904e-1) }}, 
      {{ SC_(1.630373687744140625000000000000000000000e2), SC_(2.445560607910156250000000000000000000000e2), SC_(1.826751708984375000000000000000000000000e2), SC_(5.145149230957031250000000000000000000000e-1), SC_(5.777836056176716658641370289334754705621e-1), SC_(4.222163943823283341358629710665245294379e-1) }}, 
      {{ SC_(1.630373687744140625000000000000000000000e2), SC_(3.260747375488281250000000000000000000000e2), SC_(3.477303314208984375000000000000000000000e1), SC_(4.147039055824279785156250000000000000000e-1), SC_(9.957053760631118580149856312697589133084e-1), SC_(4.294623936888141985014368730241086691645e-3) }}, 
      {{ SC_(1.630373687744140625000000000000000000000e2), SC_(3.260747375488281250000000000000000000000e2), SC_(1.279526672363281250000000000000000000000e2), SC_(4.639309942722320556640625000000000000000e-1), SC_(9.909739671658793040864406921120801420748e-1), SC_(9.026032834120695913559307887919857925230e-3) }}, 
      {{ SC_(1.630373687744140625000000000000000000000e2), SC_(3.260747375488281250000000000000000000000e2), SC_(1.831471099853515625000000000000000000000e2), SC_(4.893759191036224365234375000000000000000e-1), SC_(9.882007741270885820406824981051627329662e-1), SC_(1.179922587291141795931750189483726703378e-2) }}, 
      {{ SC_(1.630373687744140625000000000000000000000e2), SC_(4.891121215820312500000000000000000000000e2), SC_(3.767639541625976562500000000000000000000e1), SC_(3.925216794013977050781250000000000000000e-1), SC_(9.999999999275952177978139665258784045905e-1), SC_(7.240478220218603347412159540946890321270e-11) }}, 
      {{ SC_(1.630373687744140625000000000000000000000e2), SC_(4.891121215820312500000000000000000000000e2), SC_(1.310955810546875000000000000000000000000e2), SC_(4.320094287395477294921875000000000000000e-1), SC_(9.999999963959435502900064207103482153265e-1), SC_(3.604056449709993579289651784673500967196e-9) }}, 
      {{ SC_(1.630373687744140625000000000000000000000e2), SC_(4.891121215820312500000000000000000000000e2), SC_(1.867986450195312500000000000000000000000e2), SC_(4.532056152820587158203125000000000000000e-1), SC_(9.999999848011624572357940260510615751683e-1), SC_(1.519883754276420597394893842483173577055e-8) }}, 
      {{ SC_(1.630373687744140625000000000000000000000e2), SC_(6.521494750976562500000000000000000000000e2), SC_(4.238486480712890625000000000000000000000e1), SC_(4.001899957656860351562500000000000000000e-1), SC_(9.999999999999999999999999940579456466474e-1), SC_(5.942054353352580342541247979443108156402e-27) }}, 
      {{ SC_(1.630373687744140625000000000000000000000e2), SC_(6.521494750976562500000000000000000000000e2), SC_(1.311481323242187500000000000000000000000e2), SC_(4.303835928440093994140625000000000000000e-1), SC_(9.999999999999999999999226300791552782080e-1), SC_(7.736992084472179196146278700454203621942e-23) }}, 
      {{ SC_(1.630373687744140625000000000000000000000e2), SC_(6.521494750976562500000000000000000000000e2), SC_(1.914333953857421875000000000000000000000e2), SC_(4.492157399654388427734375000000000000000e-1), SC_(9.999999999999999999953820626723727735355e-1), SC_(4.617937327627226464490420710225802640181e-21) }}, 
      {{ SC_(1.630373687744140625000000000000000000000e2), SC_(8.151868286132812500000000000000000000000e2), SC_(4.420680999755859375000000000000000000000e1), SC_(4.567081034183502197265625000000000000000e-1), SC_(1.000000000000000000000000000000000000000), SC_(9.752902870742778284562922713959487681244e-69) }}, 
      {{ SC_(1.630373687744140625000000000000000000000e2), SC_(8.151868286132812500000000000000000000000e2), SC_(1.357470245361328125000000000000000000000e2), SC_(4.804581105709075927734375000000000000000e-1), SC_(1.000000000000000000000000000000000000000), SC_(3.700822699329500505094742077663290201814e-59) }}, 
      {{ SC_(1.630373687744140625000000000000000000000e2), SC_(8.151868286132812500000000000000000000000e2), SC_(1.915013732910156250000000000000000000000e2), SC_(4.939332306385040283203125000000000000000e-1), SC_(1.000000000000000000000000000000000000000), SC_(2.517960666804497444107789572782497968312e-55) }}, 
      {{ SC_(1.670842132568359375000000000000000000000e2), SC_(1.670842170715332031250000000000000000000e1), SC_(3.767639541625976562500000000000000000000e1), SC_(9.587523937225341796875000000000000000000e-1), SC_(9.942335905106021273517319758357619628138e-1), SC_(5.766409489397872648268024164238037186200e-3) }}, 
      {{ SC_(1.670842132568359375000000000000000000000e2), SC_(1.670842170715332031250000000000000000000e1), SC_(1.310955810546875000000000000000000000000e2), SC_(9.664593935012817382812500000000000000000e-1), SC_(9.938115955123158497550438503590698024639e-1), SC_(6.188404487684150244956149640930197536138e-3) }}, 
      {{ SC_(1.670842132568359375000000000000000000000e2), SC_(1.670842170715332031250000000000000000000e1), SC_(1.867986450195312500000000000000000000000e2), SC_(9.698246717453002929687500000000000000000e-1), SC_(9.936517189837226380771266009257774789510e-1), SC_(6.348281016277361922873399074222521048961e-3) }}, 
      {{ SC_(1.670842132568359375000000000000000000000e2), SC_(4.177105331420898437500000000000000000000e1), SC_(4.238486480712890625000000000000000000000e1), SC_(9.394505620002746582031250000000000000000e-1), SC_(9.999999997720111755303239820525655130981e-1), SC_(2.279888244696760179474344869018715165844e-10) }}, 
      {{ SC_(1.670842132568359375000000000000000000000e2), SC_(4.177105331420898437500000000000000000000e1), SC_(1.311481323242187500000000000000000000000e2), SC_(9.492189288139343261718750000000000000000e-1), SC_(9.999999995969400351334474178144472049652e-1), SC_(4.030599648665525821855527950347996198678e-10) }}, 
      {{ SC_(1.670842132568359375000000000000000000000e2), SC_(4.177105331420898437500000000000000000000e1), SC_(1.914333953857421875000000000000000000000e2), SC_(9.542372226715087890625000000000000000000e-1), SC_(9.999999994881964036813492069268563032196e-1), SC_(5.118035963186507930731436967804115444109e-10) }}, 
      {{ SC_(1.670842132568359375000000000000000000000e2), SC_(8.354210662841796875000000000000000000000e1), SC_(4.420680999755859375000000000000000000000e1), SC_(9.233976602554321289062500000000000000000e-1), SC_(9.999999999999999999999999997954202830440e-1), SC_(2.045797169560084434633966819695642988559e-28) }}, 
      {{ SC_(1.670842132568359375000000000000000000000e2), SC_(8.354210662841796875000000000000000000000e1), SC_(1.357470245361328125000000000000000000000e2), SC_(9.343814253807067871093750000000000000000e-1), SC_(9.999999999999999999999999977287740110036e-1), SC_(2.271225988996429622208864850734883658599e-27) }}, 
      {{ SC_(1.670842132568359375000000000000000000000e2), SC_(8.354210662841796875000000000000000000000e1), SC_(1.915013732910156250000000000000000000000e2), SC_(9.396547675132751464843750000000000000000e-1), SC_(9.999999999999999999999999942613390055000e-1), SC_(5.738660994500043506156353958043952297229e-27) }}, 
      {{ SC_(1.670842132568359375000000000000000000000e2), SC_(1.253131561279296875000000000000000000000e2), SC_(5.569964599609375000000000000000000000000e1), SC_(9.217184782028198242187500000000000000000e-1), SC_(1.000000000000000000000000000000000000000), SC_(1.609235577873935458026214914145940466882e-53) }}, 
      {{ SC_(1.670842132568359375000000000000000000000e2), SC_(1.253131561279296875000000000000000000000e2), SC_(1.362719116210937500000000000000000000000e2), SC_(9.304481148719787597656250000000000000000e-1), SC_(1.000000000000000000000000000000000000000), SC_(1.341414003625199227346746503812995123806e-51) }}, 
      {{ SC_(1.670842132568359375000000000000000000000e2), SC_(1.253131561279296875000000000000000000000e2), SC_(1.918984832763671875000000000000000000000e2), SC_(9.354221820831298828125000000000000000000e-1), SC_(1.000000000000000000000000000000000000000), SC_(1.034685724276529181496308843798267938605e-50) }}, 
      {{ SC_(1.670842132568359375000000000000000000000e2), SC_(1.503757934570312500000000000000000000000e2), SC_(5.940588760375976562500000000000000000000e1), SC_(5.667370185256004333496093750000000000000e-2), SC_(1.330341416337730802423267869525286033449e-130), SC_(1.000000000000000000000000000000000000000) }}, 
      {{ SC_(1.670842132568359375000000000000000000000e2), SC_(1.503757934570312500000000000000000000000e2), SC_(1.451677856445312500000000000000000000000e2), SC_(6.142805144190788269042968750000000000000e-2), SC_(1.826546234199942525098048579244588919963e-141), SC_(1.000000000000000000000000000000000000000) }}, 
      {{ SC_(1.670842132568359375000000000000000000000e2), SC_(1.503757934570312500000000000000000000000e2), SC_(1.929777069091796875000000000000000000000e2), SC_(6.365240365266799926757812500000000000000e-2), SC_(4.494589889910130696029858617460365578063e-148), SC_(1.000000000000000000000000000000000000000) }}, 
      {{ SC_(1.670842132568359375000000000000000000000e2), SC_(1.654133758544921875000000000000000000000e2), SC_(6.038262176513671875000000000000000000000e1), SC_(1.359550505876541137695312500000000000000e-1), SC_(4.370409011104534824515878505324267358944e-67), SC_(1.000000000000000000000000000000000000000) }}, 
      {{ SC_(1.670842132568359375000000000000000000000e2), SC_(1.654133758544921875000000000000000000000e2), SC_(1.481294555664062500000000000000000000000e2), SC_(1.482397764921188354492187500000000000000e-1), SC_(3.333070744749822633367222754984306262082e-75), SC_(1.000000000000000000000000000000000000000) }}, 
      {{ SC_(1.670842132568359375000000000000000000000e2), SC_(1.654133758544921875000000000000000000000e2), SC_(1.935389862060546875000000000000000000000e2), SC_(1.536146402359008789062500000000000000000e-1), SC_(8.482321386032046534979986685673767348436e-80), SC_(1.000000000000000000000000000000000000000) }}, 
      {{ SC_(1.670842132568359375000000000000000000000e2), SC_(1.669171295166015625000000000000000000000e2), SC_(6.163340759277343750000000000000000000000e1), SC_(2.711793780326843261718750000000000000000e-1), SC_(1.735745221391930842909440255249666067509e-25), SC_(9.999999999999999999999998264254778608069e-1) }}, 
      {{ SC_(1.670842132568359375000000000000000000000e2), SC_(1.669171295166015625000000000000000000000e2), SC_(1.486264953613281250000000000000000000000e2), SC_(2.955111861228942871093750000000000000000e-1), SC_(1.138938918217574534987293974945913709444e-29), SC_(9.999999999999999999999999999886106108178e-1) }}, 
      {{ SC_(1.670842132568359375000000000000000000000e2), SC_(1.669171295166015625000000000000000000000e2), SC_(1.937735595703125000000000000000000000000e2), SC_(3.062092959880828857421875000000000000000e-1), SC_(4.739613659166597929584140251105656021485e-32), SC_(9.999999999999999999999999999999526038634e-1) }}, 
      {{ SC_(1.670842132568359375000000000000000000000e2), SC_(1.670842132568359375000000000000000000000e2), SC_(7.225879669189453125000000000000000000000e1), SC_(4.114990234375000000000000000000000000000e-1), SC_(2.036039790168830393167742564829647577317e-7), SC_(9.999997963960209831169606832257435170352e-1) }}, 
      {{ SC_(1.670842132568359375000000000000000000000e2), SC_(1.670842132568359375000000000000000000000e2), SC_(1.515480346679687500000000000000000000000e2), SC_(4.441773891448974609375000000000000000000e-1), SC_(1.261779012345736703630517446689759681152e-8), SC_(9.999999873822098765426329636948255331024e-1) }}, 
      {{ SC_(1.670842132568359375000000000000000000000e2), SC_(1.670842132568359375000000000000000000000e2), SC_(1.941185607910156250000000000000000000000e2), SC_(4.592520594596862792968750000000000000000e-1), SC_(2.451378648355771069148764166419129771272e-9), SC_(9.999999975486213516442289308512358335809e-1) }}, 
      {{ SC_(1.670842132568359375000000000000000000000e2), SC_(1.671009216308593750000000000000000000000e2), SC_(9.566968083381652832031250000000000000000e-1), SC_(4.506188333034515380859375000000000000000e-1), SC_(3.335255011831767526068137438113452523337e-2), SC_(9.666474498816823247393186256188654747666e-1) }}, 
      {{ SC_(1.670842132568359375000000000000000000000e2), SC_(1.671009216308593750000000000000000000000e2), SC_(7.844540405273437500000000000000000000000e1), SC_(4.971345067024230957031250000000000000000e-1), SC_(2.030877921346190913191423239355692237115e-2), SC_(9.796912207865380908680857676064430776288e-1) }}, 
      {{ SC_(1.670842132568359375000000000000000000000e2), SC_(1.671009216308593750000000000000000000000e2), SC_(1.584414672851562500000000000000000000000e2), SC_(5.360464453697204589843750000000000000000e-1), SC_(1.112848517514136927609871791823176821146e-2), SC_(9.888715148248586307239012820817682317885e-1) }}, 
      {{ SC_(1.670842132568359375000000000000000000000e2), SC_(1.671009216308593750000000000000000000000e2), SC_(1.962219390869140625000000000000000000000e2), SC_(5.519288778305053710937500000000000000000e-1), SC_(8.162406536111995393879453852165781389688e-3), SC_(9.918375934638880046061205461478342186103e-1) }}, 
      {{ SC_(1.670842132568359375000000000000000000000e2), SC_(1.672513122558593750000000000000000000000e2), SC_(7.142335891723632812500000000000000000000), SC_(4.999713003635406494140625000000000000000e-1), SC_(4.265633731887210132255610898267998992761e-1), SC_(5.734366268112789867744389101732001007239e-1) }}, 
      {{ SC_(1.670842132568359375000000000000000000000e2), SC_(1.672513122558593750000000000000000000000e2), SC_(7.974770355224609375000000000000000000000e1), SC_(5.473976135253906250000000000000000000000e-1), SC_(4.161836092670758311558169287473262805646e-1), SC_(5.838163907329241688441830712526737194354e-1) }}, 
      {{ SC_(1.670842132568359375000000000000000000000e2), SC_(1.672513122558593750000000000000000000000e2), SC_(1.595857238769531250000000000000000000000e2), SC_(5.899891853332519531250000000000000000000e-1), SC_(4.045999169139177153203666569187419864023e-1), SC_(5.954000830860822846796333430812580135977e-1) }}, 
      {{ SC_(1.670842132568359375000000000000000000000e2), SC_(1.672513122558593750000000000000000000000e2), SC_(1.985762634277343750000000000000000000000e2), SC_(6.079493165016174316406250000000000000000e-1), SC_(3.989619237539546420281744224985557964793e-1), SC_(6.010380762460453579718255775014442035207e-1) }}, 
      {{ SC_(1.670842132568359375000000000000000000000e2), SC_(1.687550506591796875000000000000000000000e2), SC_(1.950807952880859375000000000000000000000e1), SC_(5.111431479454040527343750000000000000000e-1), SC_(4.919721974750751657550292999543179875058e-1), SC_(5.080278025249248342449707000456820124942e-1) }}, 
      {{ SC_(1.670842132568359375000000000000000000000e2), SC_(1.687550506591796875000000000000000000000e2), SC_(8.435225677490234375000000000000000000000e1), SC_(5.528910756111145019531250000000000000000e-1), SC_(4.894478721694063010949930964313555125604e-1), SC_(5.105521278305936989050069035686444874396e-1) }}, 
      {{ SC_(1.670842132568359375000000000000000000000e2), SC_(1.687550506591796875000000000000000000000e2), SC_(1.596211700439453125000000000000000000000e2), SC_(5.932157635688781738281250000000000000000e-1), SC_(4.869518715454078470727433900514738442626e-1), SC_(5.130481284545921529272566099485261557374e-1) }}, 
      {{ SC_(1.670842132568359375000000000000000000000e2), SC_(1.687550506591796875000000000000000000000e2), SC_(1.992922668457031250000000000000000000000e2), SC_(6.116738915443420410156250000000000000000e-1), SC_(4.857848092847305187201567269248591750469e-1), SC_(5.142151907152694812798432730751408249531e-1) }}, 
      {{ SC_(1.670842132568359375000000000000000000000e2), SC_(1.837926330566406250000000000000000000000e2), SC_(2.197235107421875000000000000000000000000e1), SC_(4.920507371425628662109375000000000000000e-1), SC_(5.000000054127555269849349538874741507541e-1), SC_(4.999999945872444730150650461125258492459e-1) }}, 
      {{ SC_(1.670842132568359375000000000000000000000e2), SC_(1.837926330566406250000000000000000000000e2), SC_(8.441753387451171875000000000000000000000e1), SC_(5.323083996772766113281250000000000000000e-1), SC_(4.983411851960613031441037832570603418089e-1), SC_(5.016588148039386968558962167429396581911e-1) }}, 
      {{ SC_(1.670842132568359375000000000000000000000e2), SC_(1.837926330566406250000000000000000000000e2), SC_(1.600560913085937500000000000000000000000e2), SC_(5.732890367507934570312500000000000000000e-1), SC_(4.968089148255982886351911658329095150640e-1), SC_(5.031910851744017113648088341670904849360e-1) }}, 
      {{ SC_(1.670842132568359375000000000000000000000e2), SC_(2.005010681152343750000000000000000000000e2), SC_(2.249290275573730468750000000000000000000e1), SC_(4.707499146461486816406250000000000000000e-1), SC_(5.013989322085405557409201843714841334425e-1), SC_(4.986010677914594442590798156285158665575e-1) }}, 
      {{ SC_(1.670842132568359375000000000000000000000e2), SC_(2.005010681152343750000000000000000000000e2), SC_(9.495173645019531250000000000000000000000e1), SC_(5.168513059616088867187500000000000000000e-1), SC_(4.994707784485777765085808381278951533928e-1), SC_(5.005292215514222234914191618721048466072e-1) }}, 
      {{ SC_(1.670842132568359375000000000000000000000e2), SC_(2.005010681152343750000000000000000000000e2), SC_(1.629447326660156250000000000000000000000e2), SC_(5.533713102340698242187500000000000000000e-1), SC_(4.980914428105574359149206239333393270510e-1), SC_(5.019085571894425640850793760666606729490e-1) }}, 
      {{ SC_(1.670842132568359375000000000000000000000e2), SC_(2.172094726562500000000000000000000000000e2), SC_(2.539736366271972656250000000000000000000e1), SC_(4.533649384975433349609375000000000000000e-1), SC_(5.095992910513862310300233719393222436206e-1), SC_(4.904007089486137689699766280606777563794e-1) }}, 
      {{ SC_(1.670842132568359375000000000000000000000e2), SC_(2.172094726562500000000000000000000000000e2), SC_(9.707512664794921875000000000000000000000e1), SC_(4.985373914241790771484375000000000000000e-1), SC_(5.071173502184303853143278033005184879834e-1), SC_(4.928826497815696146856721966994815120166e-1) }}, 
      {{ SC_(1.670842132568359375000000000000000000000e2), SC_(2.172094726562500000000000000000000000000e2), SC_(1.670017089843750000000000000000000000000e2), SC_(5.359602570533752441406250000000000000000e-1), SC_(5.053375961197232223749815881649856919187e-1), SC_(4.946624038802767776250184118350143080813e-1) }}, 
      {{ SC_(1.670842132568359375000000000000000000000e2), SC_(2.506263122558593750000000000000000000000e2), SC_(2.709540176391601562500000000000000000000e1), SC_(4.245606660842895507812500000000000000000e-1), SC_(5.953993986310994665681116857932702915048e-1), SC_(4.046006013689005334318883142067297084952e-1) }}, 
      {{ SC_(1.670842132568359375000000000000000000000e2), SC_(2.506263122558593750000000000000000000000e2), SC_(1.007325439453125000000000000000000000000e2), SC_(4.697410464286804199218750000000000000000e-1), SC_(5.859224686560363897735405664081415297267e-1), SC_(4.140775313439636102264594335918584702733e-1) }}, 
      {{ SC_(1.670842132568359375000000000000000000000e2), SC_(2.506263122558593750000000000000000000000e2), SC_(1.698258666992187500000000000000000000000e2), SC_(5.061347484588623046875000000000000000000e-1), SC_(5.799748322979435916175910662866850948821e-1), SC_(4.200251677020564083824089337133149051179e-1) }}, 
      {{ SC_(1.670842132568359375000000000000000000000e2), SC_(3.341684265136718750000000000000000000000e2), SC_(2.837726783752441406250000000000000000000e1), SC_(4.105910658836364746093750000000000000000e-1), SC_(9.964095355555133284312714068288297675864e-1), SC_(3.590464444486671568728593171170232413635e-3) }}, 
      {{ SC_(1.670842132568359375000000000000000000000e2), SC_(3.341684265136718750000000000000000000000e2), SC_(1.093762969970703125000000000000000000000e2), SC_(4.534611701965332031250000000000000000000e-1), SC_(9.926887961931652035820987131584553509255e-1), SC_(7.311203806834796417901286841544649074533e-3) }}, 
      {{ SC_(1.670842132568359375000000000000000000000e2), SC_(3.341684265136718750000000000000000000000e2), SC_(1.756861267089843750000000000000000000000e2), SC_(4.841816723346710205078125000000000000000e-1), SC_(9.895814020651648879481881856001523908065e-1), SC_(1.041859793483511205181181439984760919347e-2) }}, 
      {{ SC_(1.670842132568359375000000000000000000000e2), SC_(5.012526245117187500000000000000000000000e2), SC_(3.152261734008789062500000000000000000000e1), SC_(3.893791735172271728515625000000000000000e-1), SC_(9.999999999719526748218637586847701603206e-1), SC_(2.804732517813624131522983967939857981195e-11) }}, 
      {{ SC_(1.670842132568359375000000000000000000000e2), SC_(5.012526245117187500000000000000000000000e2), SC_(1.094441146850585937500000000000000000000e2), SC_(4.222403764724731445312500000000000000000e-1), SC_(9.999999989493415004854962429447327922017e-1), SC_(1.050658499514503757055267207798257961511e-9) }}, 
      {{ SC_(1.670842132568359375000000000000000000000e2), SC_(5.012526245117187500000000000000000000000e2), SC_(1.811583862304687500000000000000000000000e2), SC_(4.495093226432800292968750000000000000000e-1), SC_(9.999999918704005222112999871551669753279e-1), SC_(8.129599477788700012844833024672072861452e-9) }}, 
      {{ SC_(1.670842132568359375000000000000000000000e2), SC_(6.683368530273437500000000000000000000000e2), SC_(3.423733520507812500000000000000000000000e1), SC_(3.969578444957733154296875000000000000000e-1), SC_(9.999999999999999999999999996449949793950e-1), SC_(3.550050206049821683527030194240759281910e-28) }}, 
      {{ SC_(1.670842132568359375000000000000000000000e2), SC_(6.683368530273437500000000000000000000000e2), SC_(1.264718551635742187500000000000000000000e2), SC_(4.278734326362609863281250000000000000000e-1), SC_(9.999999999999999999999876660281083657549e-1), SC_(1.233397189163424511355052235453483461937e-23) }}, 
      {{ SC_(1.670842132568359375000000000000000000000e2), SC_(6.683368530273437500000000000000000000000e2), SC_(1.826751708984375000000000000000000000000e2), SC_(4.452061951160430908203125000000000000000e-1), SC_(9.999999999999999999993126330449557659874e-1), SC_(6.873669550442340126294990903082843153494e-22) }}, 
      {{ SC_(1.670842132568359375000000000000000000000e2), SC_(8.354210815429687500000000000000000000000e2), SC_(3.477303314208984375000000000000000000000e1), SC_(4.539060890674591064453125000000000000000e-1), SC_(1.000000000000000000000000000000000000000), SC_(5.947127602702723027058426165216061632884e-72) }}, 
      {{ SC_(1.670842132568359375000000000000000000000e2), SC_(8.354210815429687500000000000000000000000e2), SC_(1.279526672363281250000000000000000000000e2), SC_(4.777418673038482666015625000000000000000e-1), SC_(1.000000000000000000000000000000000000000), SC_(1.786872698124985431470457252830418410225e-61) }}, 
      {{ SC_(1.670842132568359375000000000000000000000e2), SC_(8.354210815429687500000000000000000000000e2), SC_(1.831471099853515625000000000000000000000e2), SC_(4.909050762653350830078125000000000000000e-1), SC_(1.000000000000000000000000000000000000000), SC_(1.854205340056095964232034825919480844883e-57) }}, 
      {{ SC_(1.699013061523437500000000000000000000000e2), SC_(1.699013137817382812500000000000000000000e1), SC_(3.152261734008789062500000000000000000000e1), SC_(9.580645561218261718750000000000000000000e-1), SC_(9.946319375053046523938369307638000834297e-1), SC_(5.368062494695347606163069236199916570292e-3) }}, 
      {{ SC_(1.699013061523437500000000000000000000000e2), SC_(1.699013137817382812500000000000000000000e1), SC_(1.094441146850585937500000000000000000000e2), SC_(9.648072719573974609375000000000000000000e-1), SC_(9.942714147374234971819183026103043327734e-1), SC_(5.728585262576502818081697389695667226568e-3) }}, 
      {{ SC_(1.699013061523437500000000000000000000000e2), SC_(1.699013137817382812500000000000000000000e1), SC_(1.811583862304687500000000000000000000000e2), SC_(9.693478941917419433593750000000000000000e-1), SC_(9.940598880943816570820491772804116286276e-1), SC_(5.940111905618342917950822719588371372406e-3) }}, 
      {{ SC_(1.699013061523437500000000000000000000000e2), SC_(4.247532653808593750000000000000000000000e1), SC_(3.423733520507812500000000000000000000000e1), SC_(9.382861256599426269531250000000000000000e-1), SC_(9.999999998502265805779709693824718862833e-1), SC_(1.497734194220290306175281137167078974331e-10) }}, 
      {{ SC_(1.699013061523437500000000000000000000000e2), SC_(4.247532653808593750000000000000000000000e1), SC_(1.264718551635742187500000000000000000000e2), SC_(9.485864043235778808593750000000000000000e-1), SC_(9.999999997200254764346194934662887825865e-1), SC_(2.799745235653805065337112174134503003386e-10) }}, 
      {{ SC_(1.699013061523437500000000000000000000000e2), SC_(4.247532653808593750000000000000000000000e1), SC_(1.826751708984375000000000000000000000000e2), SC_(9.533361792564392089843750000000000000000e-1), SC_(9.999999996459974607811997308464160699108e-1), SC_(3.540025392188002691535839300892183481050e-10) }}, 
      {{ SC_(1.699013061523437500000000000000000000000e2), SC_(8.495065307617187500000000000000000000000e1), SC_(3.477303314208984375000000000000000000000e1), SC_(9.219704866409301757812500000000000000000e-1), SC_(9.999999999999999999999999999500375848328e-1), SC_(4.996241516724583596926151516032929301440e-29) }}, 
      {{ SC_(1.699013061523437500000000000000000000000e2), SC_(8.495065307617187500000000000000000000000e1), SC_(1.279526672363281250000000000000000000000e2), SC_(9.333465099334716796875000000000000000000e-1), SC_(9.999999999999999999999999993113966258593e-1), SC_(6.886033741406950195268813540710243079426e-28) }}, 
      {{ SC_(1.699013061523437500000000000000000000000e2), SC_(8.495065307617187500000000000000000000000e1), SC_(1.831471099853515625000000000000000000000e2), SC_(9.386481046676635742187500000000000000000e-1), SC_(9.999999999999999999999999981782497152985e-1), SC_(1.821750284701547432710337470515987438111e-27) }}, 
      {{ SC_(1.699013061523437500000000000000000000000e2), SC_(1.274259796142578125000000000000000000000e2), SC_(3.767639541625976562500000000000000000000e1), SC_(9.193776845932006835937500000000000000000e-1), SC_(1.000000000000000000000000000000000000000), SC_(5.126352873743406811105888316941932894098e-55) }}, 
      {{ SC_(1.699013061523437500000000000000000000000e2), SC_(1.274259796142578125000000000000000000000e2), SC_(1.310955810546875000000000000000000000000e2), SC_(9.297336935997009277343750000000000000000e-1), SC_(1.000000000000000000000000000000000000000), SC_(1.411189975601508891088767013729005312634e-52) }}, 
      {{ SC_(1.699013061523437500000000000000000000000e2), SC_(1.274259796142578125000000000000000000000e2), SC_(1.867986450195312500000000000000000000000e2), SC_(9.347349405288696289062500000000000000000e-1), SC_(1.000000000000000000000000000000000000000), SC_(1.188885843731107892685391033813800137832e-51) }}, 
      {{ SC_(1.699013061523437500000000000000000000000e2), SC_(1.529111785888671875000000000000000000000e2), SC_(4.238486480712890625000000000000000000000e1), SC_(5.554175376892089843750000000000000000000e-2), SC_(1.062496380344226051036249347141771205980e-130), SC_(1.000000000000000000000000000000000000000) }}, 
      {{ SC_(1.699013061523437500000000000000000000000e2), SC_(1.529111785888671875000000000000000000000e2), SC_(1.311481323242187500000000000000000000000e2), SC_(6.061201170086860656738281250000000000000e-2), SC_(1.287019760223503856236189611875430945027e-141), SC_(1.000000000000000000000000000000000000000) }}, 
      {{ SC_(1.699013061523437500000000000000000000000e2), SC_(1.529111785888671875000000000000000000000e2), SC_(1.914333953857421875000000000000000000000e2), SC_(6.344466656446456909179687500000000000000e-2), SC_(7.418224279335730767394638100552820487350e-150), SC_(1.000000000000000000000000000000000000000) }}, 
      {{ SC_(1.699013061523437500000000000000000000000e2), SC_(1.682023010253906250000000000000000000000e2), SC_(4.420680999755859375000000000000000000000e1), SC_(1.332400888204574584960937500000000000000e-1), SC_(9.568389428229512307397049720261749792226e-67), SC_(1.000000000000000000000000000000000000000) }}, 
      {{ SC_(1.699013061523437500000000000000000000000e2), SC_(1.682023010253906250000000000000000000000e2), SC_(1.357470245361328125000000000000000000000e2), SC_(1.463786661624908447265625000000000000000e-1), SC_(5.558913837383175857762476163640600118968e-75), SC_(1.000000000000000000000000000000000000000) }}, 
      {{ SC_(1.699013061523437500000000000000000000000e2), SC_(1.682023010253906250000000000000000000000e2), SC_(1.915013732910156250000000000000000000000e2), SC_(1.530274301767349243164062500000000000000e-1), SC_(1.466149310406508116074457899902792024109e-80), SC_(1.000000000000000000000000000000000000000) }}, 
      {{ SC_(1.699013061523437500000000000000000000000e2), SC_(1.697313995361328125000000000000000000000e2), SC_(5.569964599609375000000000000000000000000e1), SC_(2.690143287181854248046875000000000000000e-1), SC_(1.408379435486688863944825891389511411249e-25), SC_(9.999999999999999999999998591620564513311e-1) }}, 
      {{ SC_(1.699013061523437500000000000000000000000e2), SC_(1.697313995361328125000000000000000000000e2), SC_(1.362719116210937500000000000000000000000e2), SC_(2.917925417423248291015625000000000000000e-1), SC_(2.211467309733435970496948671637004343789e-29), SC_(9.999999999999999999999999999778853269027e-1) }}, 
      {{ SC_(1.699013061523437500000000000000000000000e2), SC_(1.697313995361328125000000000000000000000e2), SC_(1.918984832763671875000000000000000000000e2), SC_(3.050685524940490722656250000000000000000e-1), SC_(2.791580524280759004596406221865274164850e-32), SC_(9.999999999999999999999999999999720841948e-1) }}, 
      {{ SC_(1.699013061523437500000000000000000000000e2), SC_(1.699013061523437500000000000000000000000e2), SC_(5.940588760375976562500000000000000000000e1), SC_(4.050695896148681640625000000000000000000e-1), SC_(2.554025797428501647710035530926461781745e-7), SC_(9.999997445974202571498352289964469073538e-1) }}, 
      {{ SC_(1.699013061523437500000000000000000000000e2), SC_(1.699013061523437500000000000000000000000e2), SC_(1.451677856445312500000000000000000000000e2), SC_(4.408716559410095214843750000000000000000e-1), SC_(1.343046048506172192954796018617314086814e-8), SC_(9.999999865695395149382780704520398138269e-1) }}, 
      {{ SC_(1.699013061523437500000000000000000000000e2), SC_(1.699013061523437500000000000000000000000e2), SC_(1.929777069091796875000000000000000000000e2), SC_(4.577857553958892822265625000000000000000e-1), SC_(2.169791647173691197874714869496178181393e-9), SC_(9.999999978302083528263088021252851305038e-1) }}, 
      {{ SC_(1.699013061523437500000000000000000000000e2), SC_(1.699183044433593750000000000000000000000e2), SC_(6.038262176513671875000000000000000000000e1), SC_(4.866062402725219726562500000000000000000e-1), SC_(2.225290691224991183118789350784730921239e-2), SC_(9.777470930877500881688121064921526907876e-1) }}, 
      {{ SC_(1.699013061523437500000000000000000000000e2), SC_(1.699183044433593750000000000000000000000e2), SC_(1.481294555664062500000000000000000000000e2), SC_(5.303493738174438476562500000000000000000e-1), SC_(1.172669003686580879054800371944712317076e-2), SC_(9.882733099631341912094519962805528768292e-1) }}, 
      {{ SC_(1.699013061523437500000000000000000000000e2), SC_(1.699183044433593750000000000000000000000e2), SC_(1.935389862060546875000000000000000000000e2), SC_(5.495466589927673339843750000000000000000e-1), SC_(8.123194126888632303920315055108628590875e-3), SC_(9.918768058731113676960796849448913714091e-1) }}, 
      {{ SC_(1.699013061523437500000000000000000000000e2), SC_(1.700712127685546875000000000000000000000e2), SC_(6.163340759277343750000000000000000000000e1), SC_(5.358114242553710937500000000000000000000e-1), SC_(4.183091278743482528336021579221093328894e-1), SC_(5.816908721256517471663978420778906671106e-1) }}, 
      {{ SC_(1.699013061523437500000000000000000000000e2), SC_(1.700712127685546875000000000000000000000e2), SC_(1.486264953613281250000000000000000000000e2), SC_(5.834125280380249023437500000000000000000e-1), SC_(4.058332366979856443052378967916447125416e-1), SC_(5.941667633020143556947621032083552874584e-1) }}, 
      {{ SC_(1.699013061523437500000000000000000000000e2), SC_(1.700712127685546875000000000000000000000e2), SC_(1.937735595703125000000000000000000000000e2), SC_(6.043930649757385253906250000000000000000e-1), SC_(3.993670203272777568573801775578207038342e-1), SC_(6.006329796727222431426198224421792961658e-1) }}, 
      {{ SC_(1.699013061523437500000000000000000000000e2), SC_(1.716003112792968750000000000000000000000e2), SC_(7.225879669189453125000000000000000000000e1), SC_(5.449267625808715820312500000000000000000e-1), SC_(4.898826302043251060440965048116818361566e-1), SC_(5.101173697956748939559034951883181638434e-1) }}, 
      {{ SC_(1.699013061523437500000000000000000000000e2), SC_(1.716003112792968750000000000000000000000e2), SC_(1.515480346679687500000000000000000000000e2), SC_(5.879927277565002441406250000000000000000e-1), SC_(4.872315289738290068850449168407228737557e-1), SC_(5.127684710261709931149550831592771262443e-1) }}, 
      {{ SC_(1.699013061523437500000000000000000000000e2), SC_(1.716003112792968750000000000000000000000e2), SC_(1.941185607910156250000000000000000000000e2), SC_(6.079135537147521972656250000000000000000e-1), SC_(4.859785737478939823949865233723269205664e-1), SC_(5.140214262521060176050134766276730794336e-1) }}, 
      {{ SC_(1.699013061523437500000000000000000000000e2), SC_(1.868914337158203125000000000000000000000e2), SC_(9.566968083381652832031250000000000000000e-1), SC_(4.768898487091064453125000000000000000000e-1), SC_(5.006419355993899264926936152856079329022e-1), SC_(4.993580644006100735073063847143920670978e-1) }}, 
      {{ SC_(1.699013061523437500000000000000000000000e2), SC_(1.868914337158203125000000000000000000000e2), SC_(7.844540405273437500000000000000000000000e1), SC_(5.279523134231567382812500000000000000000e-1), SC_(4.985267563883266724800581440621959956629e-1), SC_(5.014732436116733275199418559378040043371e-1) }}, 
      {{ SC_(1.699013061523437500000000000000000000000e2), SC_(1.868914337158203125000000000000000000000e2), SC_(1.584414672851562500000000000000000000000e2), SC_(5.711845755577087402343750000000000000000e-1), SC_(4.969093566576716361391326065631661668064e-1), SC_(5.030906433423283638608673934368338331936e-1) }}, 
      {{ SC_(1.699013061523437500000000000000000000000e2), SC_(1.868914337158203125000000000000000000000e2), SC_(1.962219390869140625000000000000000000000e2), SC_(5.889678597450256347656250000000000000000e-1), SC_(4.963015737988199046013990949704129678102e-1), SC_(5.036984262011800953986009050295870321898e-1) }}, 
      {{ SC_(1.699013061523437500000000000000000000000e2), SC_(2.038815765380859375000000000000000000000e2), SC_(7.142335891723632812500000000000000000000), SC_(4.597479403018951416015625000000000000000e-1), SC_(5.018770934006262222005616409020168102391e-1), SC_(4.981229065993737777994383590979831897609e-1) }}, 
      {{ SC_(1.699013061523437500000000000000000000000e2), SC_(2.038815765380859375000000000000000000000e2), SC_(7.974770355224609375000000000000000000000e1), SC_(5.070582032203674316406250000000000000000e-1), SC_(4.998780937140113538251587060166434311802e-1), SC_(5.001219062859886461748412939833565688198e-1) }}, 
      {{ SC_(1.699013061523437500000000000000000000000e2), SC_(2.038815765380859375000000000000000000000e2), SC_(1.595857238769531250000000000000000000000e2), SC_(5.503721833229064941406250000000000000000e-1), SC_(4.982258255197684702359889649365088290909e-1), SC_(5.017741744802315297640110350634911709091e-1) }}, 
      {{ SC_(1.699013061523437500000000000000000000000e2), SC_(2.038815765380859375000000000000000000000e2), SC_(1.985762634277343750000000000000000000000e2), SC_(5.688773393630981445312500000000000000000e-1), SC_(4.975837495750864533244966807733806742605e-1), SC_(5.024162504249135466755033192266193257395e-1) }}, 
      {{ SC_(1.699013061523437500000000000000000000000e2), SC_(2.208716888427734375000000000000000000000e2), SC_(1.950807952880859375000000000000000000000e1), SC_(4.490647912025451660156250000000000000000e-1), SC_(5.099162679111820603150305454187710068288e-1), SC_(4.900837320888179396849694545812289931712e-1) }}, 
      {{ SC_(1.699013061523437500000000000000000000000e2), SC_(2.208716888427734375000000000000000000000e2), SC_(8.435225677490234375000000000000000000000e1), SC_(4.902387857437133789062500000000000000000e-1), SC_(5.076166880932875828533046911166360970553e-1), SC_(4.923833119067124171466953088833639029447e-1) }}, 
      {{ SC_(1.699013061523437500000000000000000000000e2), SC_(2.208716888427734375000000000000000000000e2), SC_(1.596211700439453125000000000000000000000e2), SC_(5.309429764747619628906250000000000000000e-1), SC_(5.056419382308596368706003017174933729747e-1), SC_(4.943580617691403631293996982825066270253e-1) }}, 
      {{ SC_(1.699013061523437500000000000000000000000e2), SC_(2.208716888427734375000000000000000000000e2), SC_(1.992922668457031250000000000000000000000e2), SC_(5.498902201652526855468750000000000000000e-1), SC_(5.048185445854858933928690782982057818865e-1), SC_(4.951814554145141066071309217017942181135e-1) }}, 
      {{ SC_(1.699013061523437500000000000000000000000e2), SC_(2.548519592285156250000000000000000000000e2), SC_(2.197235107421875000000000000000000000000e1), SC_(4.208849370479583740234375000000000000000e-1), SC_(5.970631783473246572652442735088276982556e-1), SC_(4.029368216526753427347557264911723017444e-1) }}, 
      {{ SC_(1.699013061523437500000000000000000000000e2), SC_(2.548519592285156250000000000000000000000e2), SC_(8.441753387451171875000000000000000000000e1), SC_(4.595330953598022460937500000000000000000e-1), SC_(5.885500309915903198133341673768504630691e-1), SC_(4.114499690084096801866658326231495369309e-1) }}, 
      {{ SC_(1.699013061523437500000000000000000000000e2), SC_(2.548519592285156250000000000000000000000e2), SC_(1.600560913085937500000000000000000000000e2), SC_(4.999657869338989257812500000000000000000e-1), SC_(5.815852545710582153767841574328651320648e-1), SC_(4.184147454289417846232158425671348679352e-1) }}, 
      {{ SC_(1.699013061523437500000000000000000000000e2), SC_(3.398026123046875000000000000000000000000e2), SC_(2.249290275573730468750000000000000000000e1), SC_(4.069986939430236816406250000000000000000e-1), SC_(9.968952826205011834721016354476547481563e-1), SC_(3.104717379498816527898364552345251843701e-3) }}, 
      {{ SC_(1.699013061523437500000000000000000000000e2), SC_(3.398026123046875000000000000000000000000e2), SC_(9.495173645019531250000000000000000000000e1), SC_(4.454955160617828369140625000000000000000e-1), SC_(9.938177615861524529400913446787980554442e-1), SC_(6.182238413847547059908655321201944555778e-3) }}, 
      {{ SC_(1.699013061523437500000000000000000000000e2), SC_(3.398026123046875000000000000000000000000e2), SC_(1.629447326660156250000000000000000000000e2), SC_(4.773412048816680908203125000000000000000e-1), SC_(9.907920969485508549532424838010020953460e-1), SC_(9.207903051449145046757516198997904654028e-3) }}, 
      {{ SC_(1.699013061523437500000000000000000000000e2), SC_(5.097039184570312500000000000000000000000e2), SC_(2.539736366271972656250000000000000000000e1), SC_(3.864479064941406250000000000000000000000e-1), SC_(9.999999999873503241328268643703585664033e-1), SC_(1.264967586717313562964143359668924825561e-11) }}, 
      {{ SC_(1.699013061523437500000000000000000000000e2), SC_(5.097039184570312500000000000000000000000e2), SC_(9.707512664794921875000000000000000000000e1), SC_(4.166087508201599121093750000000000000000e-1), SC_(9.999999995411338431003706679593778688951e-1), SC_(4.588661568996293320406221311048545836875e-10) }}, 
      {{ SC_(1.699013061523437500000000000000000000000e2), SC_(5.097039184570312500000000000000000000000e2), SC_(1.670017089843750000000000000000000000000e2), SC_(4.433091878890991210937500000000000000000e-1), SC_(9.999999959465341513214515485187735156991e-1), SC_(4.053465848678548451481226484300869564537e-9) }}, 
      {{ SC_(1.699013061523437500000000000000000000000e2), SC_(6.796052246093750000000000000000000000000e2), SC_(2.709540176391601562500000000000000000000e1), SC_(3.942642807960510253906250000000000000000e-1), SC_(9.999999999999999999999999999634427807271e-1), SC_(3.655721927293126054421248487202773504424e-29) }}, 
      {{ SC_(1.699013061523437500000000000000000000000e2), SC_(6.796052246093750000000000000000000000000e2), SC_(1.007325439453125000000000000000000000000e2), SC_(4.190225601196289062500000000000000000000e-1), SC_(9.999999999999999999999995644420342786007e-1), SC_(4.355579657213993493782344864578515590150e-25) }}, 
      {{ SC_(1.699013061523437500000000000000000000000e2), SC_(6.796052246093750000000000000000000000000e2), SC_(1.698258666992187500000000000000000000000e2), SC_(4.404824078083038330078125000000000000000e-1), SC_(9.999999999999999999998862812924516414640e-1), SC_(1.137187075483585359872497455949955018341e-22) }}, 
      {{ SC_(1.699013061523437500000000000000000000000e2), SC_(8.495065307617187500000000000000000000000e2), SC_(2.837726783752441406250000000000000000000e1), SC_(4.520635306835174560546875000000000000000e-1), SC_(1.000000000000000000000000000000000000000), SC_(3.013349674145034436537834769585174289713e-74) }}, 
      {{ SC_(1.699013061523437500000000000000000000000e2), SC_(8.495065307617187500000000000000000000000e2), SC_(1.093762969970703125000000000000000000000e2), SC_(4.727058410644531250000000000000000000000e-1), SC_(1.000000000000000000000000000000000000000), SC_(2.688075313968737271729073655990434193583e-64) }}, 
      {{ SC_(1.699013061523437500000000000000000000000e2), SC_(8.495065307617187500000000000000000000000e2), SC_(1.756861267089843750000000000000000000000e2), SC_(4.884824454784393310546875000000000000000e-1), SC_(1.000000000000000000000000000000000000000), SC_(4.437424867142276257541825887933120649349e-59) }}, 
      {{ SC_(1.757469177246093750000000000000000000000e2), SC_(1.757469177246093750000000000000000000000e1), SC_(2.539736366271972656250000000000000000000e1), SC_(9.573343992233276367187500000000000000000e-1), SC_(9.953400847308506621372797592246430975366e-1), SC_(4.659915269149337862720240775356902463387e-3) }}, 
      {{ SC_(1.757469177246093750000000000000000000000e2), SC_(1.757469177246093750000000000000000000000e1), SC_(9.707512664794921875000000000000000000000e1), SC_(9.636373519897460937500000000000000000000e-1), SC_(9.950302309057083130079182130363697028263e-1), SC_(4.969769094291686992081786963630297173685e-3) }}, 
      {{ SC_(1.757469177246093750000000000000000000000e2), SC_(1.757469177246093750000000000000000000000e1), SC_(1.670017089843750000000000000000000000000e2), SC_(9.682217836380004882812500000000000000000e-1), SC_(9.948315922473736108555299119815106534822e-1), SC_(5.168407752626389144470088018489346517824e-3) }}, 
      {{ SC_(1.757469177246093750000000000000000000000e2), SC_(4.393672943115234375000000000000000000000e1), SC_(2.709540176391601562500000000000000000000e1), SC_(9.371901750564575195312500000000000000000e-1), SC_(9.999999999319293808745841948973187466567e-1), SC_(6.807061912541580510268125334325947930963e-11) }}, 
      {{ SC_(1.757469177246093750000000000000000000000e2), SC_(4.393672943115234375000000000000000000000e1), SC_(1.007325439453125000000000000000000000000e2), SC_(9.457296729087829589843750000000000000000e-1), SC_(9.999999998803142182140895761044813672624e-1), SC_(1.196857817859104238955186327375993655342e-10) }}, 
      {{ SC_(1.757469177246093750000000000000000000000e2), SC_(4.393672943115234375000000000000000000000e1), SC_(1.698258666992187500000000000000000000000e2), SC_(9.518741369247436523437500000000000000000e-1), SC_(9.999999998330800612384571149588600764228e-1), SC_(1.669199387615428850411399235772271338003e-10) }}, 
      {{ SC_(1.757469177246093750000000000000000000000e2), SC_(8.787345886230468750000000000000000000000e1), SC_(2.837726783752441406250000000000000000000e1), SC_(9.209082126617431640625000000000000000000e-1), SC_(9.999999999999999999999999999957131068023e-1), SC_(4.286893197693889377105951019655054311676e-30) }}, 
      {{ SC_(1.757469177246093750000000000000000000000e2), SC_(8.787345886230468750000000000000000000000e1), SC_(1.093762969970703125000000000000000000000e2), SC_(9.309468269348144531250000000000000000000e-1), SC_(9.999999999999999999999999999472816467982e-1), SC_(5.271835320180293365471953407139294305381e-29) }}, 
      {{ SC_(1.757469177246093750000000000000000000000e2), SC_(8.787345886230468750000000000000000000000e1), SC_(1.756861267089843750000000000000000000000e2), SC_(9.374501705169677734375000000000000000000e-1), SC_(9.999999999999999999999999998077212678651e-1), SC_(1.922787321349016365525347879114991292533e-28) }}, 
      {{ SC_(1.757469177246093750000000000000000000000e2), SC_(1.318101806640625000000000000000000000000e2), SC_(3.152261734008789062500000000000000000000e1), SC_(9.184518456459045410156250000000000000000e-1), SC_(1.000000000000000000000000000000000000000), SC_(4.098195890058605929532536536368596678908e-57) }}, 
      {{ SC_(1.757469177246093750000000000000000000000e2), SC_(1.318101806640625000000000000000000000000e2), SC_(1.094441146850585937500000000000000000000e2), SC_(9.272024631500244140625000000000000000000e-1), SC_(1.000000000000000000000000000000000000000), SC_(7.349046583303494747899356097214429743140e-55) }}, 
      {{ SC_(1.757469177246093750000000000000000000000e2), SC_(1.318101806640625000000000000000000000000e2), SC_(1.811583862304687500000000000000000000000e2), SC_(9.337485432624816894531250000000000000000e-1), SC_(1.000000000000000000000000000000000000000), SC_(1.536364119130228388365475636217260344626e-53) }}, 
      {{ SC_(1.757469177246093750000000000000000000000e2), SC_(1.581722259521484375000000000000000000000e2), SC_(3.423733520507812500000000000000000000000e1), SC_(5.493528395891189575195312500000000000000e-2), SC_(4.663144052786764091666654582990947719208e-134), SC_(1.000000000000000000000000000000000000000) }}, 
      {{ SC_(1.757469177246093750000000000000000000000e2), SC_(1.581722259521484375000000000000000000000e2), SC_(1.264718551635742187500000000000000000000e2), SC_(6.015772372484207153320312500000000000000e-2), SC_(3.295428852069419519002549119433174713451e-145), SC_(1.000000000000000000000000000000000000000) }}, 
      {{ SC_(1.757469177246093750000000000000000000000e2), SC_(1.581722259521484375000000000000000000000e2), SC_(1.826751708984375000000000000000000000000e2), SC_(6.278669089078903198242187500000000000000e-2), SC_(8.641645560008791882729701789696209179424e-153), SC_(1.000000000000000000000000000000000000000) }}, 
      {{ SC_(1.757469177246093750000000000000000000000e2), SC_(1.739894561767578125000000000000000000000e2), SC_(3.477303314208984375000000000000000000000e1), SC_(1.315029561519622802734375000000000000000e-1), SC_(4.350331598524162755122336567981775589992e-68), SC_(1.000000000000000000000000000000000000000) }}, 
      {{ SC_(1.757469177246093750000000000000000000000e2), SC_(1.739894561767578125000000000000000000000e2), SC_(1.279526672363281250000000000000000000000e2), SC_(1.448216438293457031250000000000000000000e-1), SC_(2.722122090006269383525808776052831958960e-76), SC_(1.000000000000000000000000000000000000000) }}, 
      {{ SC_(1.757469177246093750000000000000000000000e2), SC_(1.739894561767578125000000000000000000000e2), SC_(1.831471099853515625000000000000000000000e2), SC_(1.513894498348236083984375000000000000000e-1), SC_(9.904818724321465844187907946125633320041e-82), SC_(1.000000000000000000000000000000000000000) }}, 
      {{ SC_(1.757469177246093750000000000000000000000e2), SC_(1.755711669921875000000000000000000000000e2), SC_(3.767639541625976562500000000000000000000e1), SC_(2.628092169761657714843750000000000000000e-1), SC_(1.526841601615674468493602255401951303254e-25), SC_(9.999999999999999999999998473158398384326e-1) }}, 
      {{ SC_(1.757469177246093750000000000000000000000e2), SC_(1.755711669921875000000000000000000000000e2), SC_(1.310955810546875000000000000000000000000e2), SC_(2.893358469009399414062500000000000000000e-1), SC_(7.836516678587575236677758837457322579686e-30), SC_(9.999999999999999999999999999921634833214e-1) }}, 
      {{ SC_(1.757469177246093750000000000000000000000e2), SC_(1.755711669921875000000000000000000000000e2), SC_(1.867986450195312500000000000000000000000e2), SC_(3.025104403495788574218750000000000000000e-1), SC_(1.067887806693581365621255794113102160782e-32), SC_(9.999999999999999999999999999999893211219e-1) }}, 
      {{ SC_(1.757469177246093750000000000000000000000e2), SC_(1.757469177246093750000000000000000000000e2), SC_(4.238486480712890625000000000000000000000e1), SC_(3.962700366973876953125000000000000000000e-1), SC_(2.929490429138666154163531232123090727914e-7), SC_(9.999997070509570861333845836468767876909e-1) }}, 
      {{ SC_(1.757469177246093750000000000000000000000e2), SC_(1.757469177246093750000000000000000000000e2), SC_(1.311481323242187500000000000000000000000e2), SC_(4.338407516479492187500000000000000000000e-1), SC_(1.550317619815609356520693701494804917010e-8), SC_(9.999999844968238018439064347930629850520e-1) }}, 
      {{ SC_(1.757469177246093750000000000000000000000e2), SC_(1.757469177246093750000000000000000000000e2), SC_(1.914333953857421875000000000000000000000e2), SC_(4.551203846931457519531250000000000000000e-1), SC_(1.626516042886771789523169339749887418537e-9), SC_(9.999999983734839571132282104768306602501e-1) }}, 
      {{ SC_(1.757469177246093750000000000000000000000e2), SC_(1.757644958496093750000000000000000000000e2), SC_(4.420680999755859375000000000000000000000e1), SC_(4.765341579914093017578125000000000000000e-1), SC_(2.310658713074818761892434452590902243812e-2), SC_(9.768934128692518123810756554740909775619e-1) }}, 
      {{ SC_(1.757469177246093750000000000000000000000e2), SC_(1.757644958496093750000000000000000000000e2), SC_(1.357470245361328125000000000000000000000e2), SC_(5.226638317108154296875000000000000000000e-1), SC_(1.212827875952284573078561727599413149228e-2), SC_(9.878717212404771542692143827240058685077e-1) }}, 
      {{ SC_(1.757469177246093750000000000000000000000e2), SC_(1.757644958496093750000000000000000000000e2), SC_(1.915013732910156250000000000000000000000e2), SC_(5.461498498916625976562500000000000000000e-1), SC_(7.801903846804653933896383131586723750373e-3), SC_(9.921980961531953460661036168684132762496e-1) }}, 
      {{ SC_(1.757469177246093750000000000000000000000e2), SC_(1.759226684570312500000000000000000000000e2), SC_(5.569964599609375000000000000000000000000e1), SC_(5.310060381889343261718750000000000000000e-1), SC_(4.181117434322654289777915709305702792082e-1), SC_(5.818882565677345710222084290694297207918e-1) }}, 
      {{ SC_(1.757469177246093750000000000000000000000e2), SC_(1.759226684570312500000000000000000000000e2), SC_(1.362719116210937500000000000000000000000e2), SC_(5.749726295471191406250000000000000000000e-1), SC_(4.068255444173863569987155375363325205213e-1), SC_(5.931744555826136430012844624636674794787e-1) }}, 
      {{ SC_(1.757469177246093750000000000000000000000e2), SC_(1.759226684570312500000000000000000000000e2), SC_(1.918984832763671875000000000000000000000e2), SC_(6.007249355316162109375000000000000000000e-1), SC_(3.990219498133565159418688532124440061792e-1), SC_(6.009780501866434840581311467875559938208e-1) }}, 
      {{ SC_(1.757469177246093750000000000000000000000e2), SC_(1.775043792724609375000000000000000000000e2), SC_(5.940588760375976562500000000000000000000e1), SC_(5.358564257621765136718750000000000000000e-1), SC_(4.903226995401363412016815462002872283063e-1), SC_(5.096773004598636587983184537997127716937e-1) }}, 
      {{ SC_(1.757469177246093750000000000000000000000e2), SC_(1.775043792724609375000000000000000000000e2), SC_(1.451677856445312500000000000000000000000e2), SC_(5.824119448661804199218750000000000000000e-1), SC_(4.874820557582746330191106080911419454613e-1), SC_(5.125179442417253669808893919088580545387e-1) }}, 
      {{ SC_(1.757469177246093750000000000000000000000e2), SC_(1.775043792724609375000000000000000000000e2), SC_(1.929777069091796875000000000000000000000e2), SC_(6.045245528221130371093750000000000000000e-1), SC_(4.860998040859719827051427280637186313060e-1), SC_(5.139001959140280172948572719362813686940e-1) }}, 
      {{ SC_(1.757469177246093750000000000000000000000e2), SC_(1.933216094970703125000000000000000000000e2), SC_(6.038262176513671875000000000000000000000e1), SC_(5.157083272933959960937500000000000000000e-1), SC_(4.990352045489852924984253717009880793843e-1), SC_(5.009647954510147075015746282990119206157e-1) }}, 
      {{ SC_(1.757469177246093750000000000000000000000e2), SC_(1.933216094970703125000000000000000000000e2), SC_(1.481294555664062500000000000000000000000e2), SC_(5.635747909545898437500000000000000000000e-1), SC_(4.972268009227968338573786734953292537839e-1), SC_(5.027731990772031661426213265046707462161e-1) }}, 
      {{ SC_(1.757469177246093750000000000000000000000e2), SC_(1.933216094970703125000000000000000000000e2), SC_(1.935389862060546875000000000000000000000e2), SC_(5.848174691200256347656250000000000000000e-1), SC_(4.965004315315004614986110176892537184121e-1), SC_(5.034995684684995385013889823107462815879e-1) }}, 
      {{ SC_(1.757469177246093750000000000000000000000e2), SC_(2.108963165283203125000000000000000000000e2), SC_(6.163340759277343750000000000000000000000e1), SC_(4.947718679904937744140625000000000000000e-1), SC_(5.004021527432211242569358481262675385951e-1), SC_(4.995978472567788757430641518737324614049e-1) }}, 
      {{ SC_(1.757469177246093750000000000000000000000e2), SC_(2.108963165283203125000000000000000000000e2), SC_(1.486264953613281250000000000000000000000e2), SC_(5.423668622970581054687500000000000000000e-1), SC_(4.985663335493922341095922916941181257603e-1), SC_(5.014336664506077658904077083058818742397e-1) }}, 
      {{ SC_(1.757469177246093750000000000000000000000e2), SC_(2.108963165283203125000000000000000000000e2), SC_(1.937735595703125000000000000000000000000e2), SC_(5.637031793594360351562500000000000000000e-1), SC_(4.978213121853052463954795057571007642639e-1), SC_(5.021786878146947536045204942428992357361e-1) }}, 
      {{ SC_(1.757469177246093750000000000000000000000e2), SC_(2.284709777832031250000000000000000000000e2), SC_(7.225879669189453125000000000000000000000e1), SC_(4.815790653228759765625000000000000000000e-1), SC_(5.082163419885128723696457684232954007296e-1), SC_(4.917836580114871276303542315767045992704e-1) }}, 
      {{ SC_(1.757469177246093750000000000000000000000e2), SC_(2.284709777832031250000000000000000000000e2), SC_(1.515480346679687500000000000000000000000e2), SC_(5.243299603462219238281250000000000000000e-1), SC_(5.061025352412440427325853320613894170885e-1), SC_(4.938974647587559572674146679386105829115e-1) }}, 
      {{ SC_(1.757469177246093750000000000000000000000e2), SC_(2.284709777832031250000000000000000000000e2), SC_(1.941185607910156250000000000000000000000e2), SC_(5.445017218589782714843750000000000000000e-1), SC_(5.052138705231373057152908604858527570391e-1), SC_(4.947861294768626942847091395141472429609e-1) }}, 
      {{ SC_(1.757469177246093750000000000000000000000e2), SC_(2.636203613281250000000000000000000000000e2), SC_(9.566968083381652832031250000000000000000e-1), SC_(4.065852165222167968750000000000000000000e-1), SC_(6.024318099108848518119476579603699123668e-1), SC_(3.975681900891151481880523420396300876332e-1) }}, 
      {{ SC_(1.757469177246093750000000000000000000000e2), SC_(2.636203613281250000000000000000000000000e2), SC_(7.844540405273437500000000000000000000000e1), SC_(4.545331597328186035156250000000000000000e-1), SC_(5.910146156623970802270066769612049120963e-1), SC_(4.089853843376029197729933230387950879037e-1) }}, 
      {{ SC_(1.757469177246093750000000000000000000000e2), SC_(2.636203613281250000000000000000000000000e2), SC_(1.584414672851562500000000000000000000000e2), SC_(4.965422451496124267578125000000000000000e-1), SC_(5.835246695310516726103598849115893949881e-1), SC_(4.164753304689483273896401150884106050119e-1) }}, 
      {{ SC_(1.757469177246093750000000000000000000000e2), SC_(2.636203613281250000000000000000000000000e2), SC_(1.962219390869140625000000000000000000000e2), SC_(5.142149329185485839843750000000000000000e-1), SC_(5.808768644264984393568204219633087812198e-1), SC_(4.191231355735015606431795780366912187802e-1) }}, 
      {{ SC_(1.757469177246093750000000000000000000000e2), SC_(3.514938354492187500000000000000000000000e2), SC_(7.142335891723632812500000000000000000000), SC_(3.980091810226440429687500000000000000000e-1), SC_(9.978338171931910496330115592605837251858e-1), SC_(2.166182806808950366988440739416274814250e-3) }}, 
      {{ SC_(1.757469177246093750000000000000000000000e2), SC_(3.514938354492187500000000000000000000000e2), SC_(7.974770355224609375000000000000000000000e1), SC_(4.364816844463348388671875000000000000000e-1), SC_(9.952409117867613639022907996477672547297e-1), SC_(4.759088213238636097709200352232745270315e-3) }}, 
      {{ SC_(1.757469177246093750000000000000000000000e2), SC_(3.514938354492187500000000000000000000000e2), SC_(1.595857238769531250000000000000000000000e2), SC_(4.734903872013092041015625000000000000000e-1), SC_(9.920952432867064025998730019682081509351e-1), SC_(7.904756713293597400126998031791849064934e-3) }}, 
      {{ SC_(1.757469177246093750000000000000000000000e2), SC_(3.514938354492187500000000000000000000000e2), SC_(1.985762634277343750000000000000000000000e2), SC_(4.898548424243927001953125000000000000000e-1), SC_(9.905735711517547745904547369038391579219e-1), SC_(9.426428848245225409545263096160842078085e-3) }}, 
      {{ SC_(1.757469177246093750000000000000000000000e2), SC_(5.272407226562500000000000000000000000000e2), SC_(1.950807952880859375000000000000000000000e1), SC_(3.835414648056030273437500000000000000000e-1), SC_(9.999999999963406779261964931190983558161e-1), SC_(3.659322073803506880901644183915864458813e-12) }}, 
      {{ SC_(1.757469177246093750000000000000000000000e2), SC_(5.272407226562500000000000000000000000000e2), SC_(8.435225677490234375000000000000000000000e1), SC_(4.103301167488098144531250000000000000000e-1), SC_(9.999999998755458207830154459341415929622e-1), SC_(1.244541792169845540658584070377837877970e-10) }}, 
      {{ SC_(1.757469177246093750000000000000000000000e2), SC_(5.272407226562500000000000000000000000000e2), SC_(1.596211700439453125000000000000000000000e2), SC_(4.386491179466247558593750000000000000000e-1), SC_(9.999999984042417406223016562144139471791e-1), SC_(1.595758259377698343785586052820860566475e-9) }}, 
      {{ SC_(1.757469177246093750000000000000000000000e2), SC_(5.272407226562500000000000000000000000000e2), SC_(1.992922668457031250000000000000000000000e2), SC_(4.525084495544433593750000000000000000000e-1), SC_(9.999999957551793898777829262322447878335e-1), SC_(4.244820610122217073767755212166508324107e-9) }}, 
      {{ SC_(1.757469177246093750000000000000000000000e2), SC_(7.029876708984375000000000000000000000000e2), SC_(2.197235107421875000000000000000000000000e1), SC_(3.922056257724761962890625000000000000000e-1), SC_(9.999999999999999999999999999985092383478e-1), SC_(1.490761652151097391109773616811902073310e-30) }}, 
      {{ SC_(1.757469177246093750000000000000000000000e2), SC_(7.029876708984375000000000000000000000000e2), SC_(8.441753387451171875000000000000000000000e1), SC_(4.127905070781707763671875000000000000000e-1), SC_(9.999999999999999999999999909989855393974e-1), SC_(9.001014460602619412250466942013772067344e-27) }}, 
      {{ SC_(1.757469177246093750000000000000000000000e2), SC_(7.029876708984375000000000000000000000000e2), SC_(1.600560913085937500000000000000000000000e2), SC_(4.359324872493743896484375000000000000000e-1), SC_(9.999999999999999999999925425567450651223e-1), SC_(7.457443254934877739469783172678603269830e-24) }}, 
      {{ SC_(1.757469177246093750000000000000000000000e2), SC_(8.787346191406250000000000000000000000000e2), SC_(2.249290275573730468750000000000000000000e1), SC_(4.503016769886016845703125000000000000000e-1), SC_(1.000000000000000000000000000000000000000), SC_(6.750070955278218312275839860662937576382e-78) }}, 
      {{ SC_(1.757469177246093750000000000000000000000e2), SC_(8.787346191406250000000000000000000000000e2), SC_(9.495173645019531250000000000000000000000e1), SC_(4.683587849140167236328125000000000000000e-1), SC_(1.000000000000000000000000000000000000000), SC_(3.252842303398639904263505258650845919542e-68) }}, 
      {{ SC_(1.757469177246093750000000000000000000000e2), SC_(8.787346191406250000000000000000000000000e2), SC_(1.629447326660156250000000000000000000000e2), SC_(4.842571914196014404296875000000000000000e-1), SC_(1.000000000000000000000000000000000000000), SC_(2.404955466656105050458009556379784203833e-62) }}, 
      {{ SC_(1.812054901123046875000000000000000000000e2), SC_(1.812055015563964843750000000000000000000e1), SC_(1.950807952880859375000000000000000000000e1), SC_(9.566563367843627929687500000000000000000e-1), SC_(9.959173537730610748417695253985743475112e-1), SC_(4.082646226938925158230474601425652488803e-3) }}, 
      {{ SC_(1.812054901123046875000000000000000000000e2), SC_(1.812055015563964843750000000000000000000e1), SC_(8.435225677490234375000000000000000000000e1), SC_(9.624565839767456054687500000000000000000e-1), SC_(9.956538938892484206006402613471843310385e-1), SC_(4.346106110751579399359738652815668961500e-3) }}, 
      {{ SC_(1.812054901123046875000000000000000000000e2), SC_(1.812055015563964843750000000000000000000e1), SC_(1.596211700439453125000000000000000000000e2), SC_(9.675085544586181640625000000000000000000e-1), SC_(9.954503828727584662469401932063600098799e-1), SC_(4.549617127241533753059806793639990120075e-3) }}, 
      {{ SC_(1.812054901123046875000000000000000000000e2), SC_(1.812055015563964843750000000000000000000e1), SC_(1.992922668457031250000000000000000000000e2), SC_(9.696614742279052734375000000000000000000e-1), SC_(9.953714877424033390052774537400454419725e-1), SC_(4.628512257596660994722546259954558027530e-3) }}, 
      {{ SC_(1.812054901123046875000000000000000000000e2), SC_(4.530137252807617187500000000000000000000e1), SC_(2.197235107421875000000000000000000000000e1), SC_(9.364048838615417480468750000000000000000e-1), SC_(9.999999999670023170133966452417835571822e-1), SC_(3.299768298660335475821644281777580531502e-11) }}, 
      {{ SC_(1.812054901123046875000000000000000000000e2), SC_(4.530137252807617187500000000000000000000e1), SC_(8.441753387451171875000000000000000000000e1), SC_(9.437721967697143554687500000000000000000e-1), SC_(9.999999999445073008505281972240198060721e-1), SC_(5.549269914947180277598019392791868302783e-11) }}, 
      {{ SC_(1.812054901123046875000000000000000000000e2), SC_(4.530137252807617187500000000000000000000e1), SC_(1.600560913085937500000000000000000000000e2), SC_(9.506962299346923828125000000000000000000e-1), SC_(9.999999999169746236530276725137317121114e-1), SC_(8.302537634697232748626828788864607446239e-11) }}, 
      {{ SC_(1.812054901123046875000000000000000000000e2), SC_(9.060274505615234375000000000000000000000e1), SC_(2.249290275573730468750000000000000000000e1), SC_(9.199664592742919921875000000000000000000e-1), SC_(9.999999999999999999999999999995720450568e-1), SC_(4.279549431578185893443180959702790489286e-31) }}, 
      {{ SC_(1.812054901123046875000000000000000000000e2), SC_(9.060274505615234375000000000000000000000e1), SC_(9.495173645019531250000000000000000000000e1), SC_(9.290248751640319824218750000000000000000e-1), SC_(9.999999999999999999999999999951433317881e-1), SC_(4.856668211903459863418664241231415216294e-30) }}, 
      {{ SC_(1.812054901123046875000000000000000000000e2), SC_(9.060274505615234375000000000000000000000e1), SC_(1.629447326660156250000000000000000000000e2), SC_(9.358428716659545898437500000000000000000e-1), SC_(9.999999999999999999999999999789787693225e-1), SC_(2.102123067746158003410276037533717700670e-29) }}, 
      {{ SC_(1.812054901123046875000000000000000000000e2), SC_(1.359041137695312500000000000000000000000e2), SC_(2.539736366271972656250000000000000000000e1), SC_(9.175763726234436035156250000000000000000e-1), SC_(1.000000000000000000000000000000000000000), SC_(4.223862224073086597625879655877896667372e-59) }}, 
      {{ SC_(1.812054901123046875000000000000000000000e2), SC_(1.359041137695312500000000000000000000000e2), SC_(9.707512664794921875000000000000000000000e1), SC_(9.256368279457092285156250000000000000000e-1), SC_(1.000000000000000000000000000000000000000), SC_(7.169940878838238392877809889372838621168e-57) }}, 
      {{ SC_(1.812054901123046875000000000000000000000e2), SC_(1.359041137695312500000000000000000000000e2), SC_(1.670017089843750000000000000000000000000e2), SC_(9.321162104606628417968750000000000000000e-1), SC_(1.000000000000000000000000000000000000000), SC_(1.856240933065391719692650369372742450999e-55) }}, 
      {{ SC_(1.812054901123046875000000000000000000000e2), SC_(1.630849304199218750000000000000000000000e2), SC_(2.709540176391601562500000000000000000000e1), SC_(5.442012101411819458007812500000000000000e-2), SC_(2.886849718237293705780786481046572117950e-137), SC_(1.000000000000000000000000000000000000000) }}, 
      {{ SC_(1.812054901123046875000000000000000000000e2), SC_(1.630849304199218750000000000000000000000e2), SC_(1.007325439453125000000000000000000000000e2), SC_(5.866339802742004394531250000000000000000e-2), SC_(7.372846767731345071034901671794361945985e-146), SC_(1.000000000000000000000000000000000000000) }}, 
      {{ SC_(1.812054901123046875000000000000000000000e2), SC_(1.630849304199218750000000000000000000000e2), SC_(1.698258666992187500000000000000000000000e2), SC_(6.198536232113838195800781250000000000000e-2), SC_(6.457796107278544508179985633577270418102e-155), SC_(1.000000000000000000000000000000000000000) }}, 
      {{ SC_(1.812054901123046875000000000000000000000e2), SC_(1.793934326171875000000000000000000000000e2), SC_(2.837726783752441406250000000000000000000e1), SC_(1.303244978189468383789062500000000000000e-1), SC_(1.498076019124361717016584839967424865590e-69), SC_(1.000000000000000000000000000000000000000) }}, 
      {{ SC_(1.812054901123046875000000000000000000000e2), SC_(1.793934326171875000000000000000000000000e2), SC_(1.093762969970703125000000000000000000000e2), SC_(1.419721245765686035156250000000000000000e-1), SC_(1.760084746948828758039019560865808668376e-76), SC_(1.000000000000000000000000000000000000000) }}, 
      {{ SC_(1.812054901123046875000000000000000000000e2), SC_(1.793934326171875000000000000000000000000e2), SC_(1.756861267089843750000000000000000000000e2), SC_(1.499470323324203491210937500000000000000e-1), SC_(7.079570065907268760480742986665112342645e-83), SC_(1.000000000000000000000000000000000000000) }}, 
      {{ SC_(1.812054901123046875000000000000000000000e2), SC_(1.810242919921875000000000000000000000000e2), SC_(3.152261734008789062500000000000000000000e1), SC_(2.605178058147430419921875000000000000000e-1), SC_(5.634353658818430016436692893610735929470e-26), SC_(9.999999999999999999999999436564634118157e-1) }}, 
      {{ SC_(1.812054901123046875000000000000000000000e2), SC_(1.810242919921875000000000000000000000000e2), SC_(1.094441146850585937500000000000000000000e2), SC_(2.828510999679565429687500000000000000000e-1), SC_(1.915879182884980603640885568385091484496e-29), SC_(9.999999999999999999999999999808412081712e-1) }}, 
      {{ SC_(1.812054901123046875000000000000000000000e2), SC_(1.810242919921875000000000000000000000000e2), SC_(1.811583862304687500000000000000000000000e2), SC_(3.000213503837585449218750000000000000000e-1), SC_(4.768357647195077731362476767552320278102e-33), SC_(9.999999999999999999999999999999952316424e-1) }}, 
      {{ SC_(1.812054901123046875000000000000000000000e2), SC_(1.812054901123046875000000000000000000000e2), SC_(3.423733520507812500000000000000000000000e1), SC_(3.918718099594116210937500000000000000000e-1), SC_(2.594703431325831751112132245668147446004e-7), SC_(9.999997405296568674168248887867754331853e-1) }}, 
      {{ SC_(1.812054901123046875000000000000000000000e2), SC_(1.812054901123046875000000000000000000000e2), SC_(1.264718551635742187500000000000000000000e2), SC_(4.306001663208007812500000000000000000000e-1), SC_(1.296349654636936518151426760189142864050e-8), SC_(9.999999870365034536306348184857323981086e-1) }}, 
      {{ SC_(1.812054901123046875000000000000000000000e2), SC_(1.812054901123046875000000000000000000000e2), SC_(1.826751708984375000000000000000000000000e2), SC_(4.503529667854309082031250000000000000000e-1), SC_(1.640672414761342267901674185306624809045e-9), SC_(9.999999983593275852386577320983258146934e-1) }}, 
      {{ SC_(1.812054901123046875000000000000000000000e2), SC_(1.812236175537109375000000000000000000000e2), SC_(3.477303314208984375000000000000000000000e1), SC_(4.705260097980499267578125000000000000000e-1), SC_(2.299299012253699547711168721683120392260e-2), SC_(9.770070098774630045228883127831687960774e-1) }}, 
      {{ SC_(1.812054901123046875000000000000000000000e2), SC_(1.812236175537109375000000000000000000000e2), SC_(1.279526672363281250000000000000000000000e2), SC_(5.173626542091369628906250000000000000000e-1), SC_(1.212693417765220117540069620910398806404e-2), SC_(9.878730658223477988245993037908960119360e-1) }}, 
      {{ SC_(1.812054901123046875000000000000000000000e2), SC_(1.812236175537109375000000000000000000000e2), SC_(1.831471099853515625000000000000000000000e2), SC_(5.405886173248291015625000000000000000000e-1), SC_(7.908495767888510919809566431003347846699e-3), SC_(9.920915042321114890801904335689966521533e-1) }}, 
      {{ SC_(1.812054901123046875000000000000000000000e2), SC_(1.813867034912109375000000000000000000000e2), SC_(3.767639541625976562500000000000000000000e1), SC_(5.191510915756225585937500000000000000000e-1), SC_(4.195874255755164896318599847716609736877e-1), SC_(5.804125744244835103681400152283390263123e-1) }}, 
      {{ SC_(1.812054901123046875000000000000000000000e2), SC_(1.813867034912109375000000000000000000000e2), SC_(1.310955810546875000000000000000000000000e2), SC_(5.704244971275329589843750000000000000000e-1), SC_(4.068061945822230946557033312517916201884e-1), SC_(5.931938054177769053442966687482083798116e-1) }}, 
      {{ SC_(1.812054901123046875000000000000000000000e2), SC_(1.813867034912109375000000000000000000000e2), SC_(1.867986450195312500000000000000000000000e2), SC_(5.960156917572021484375000000000000000000e-1), SC_(3.991393137076577138968809367559543913639e-1), SC_(6.008606862923422861031190632440456086361e-1) }}, 
      {{ SC_(1.812054901123046875000000000000000000000e2), SC_(1.830175476074218750000000000000000000000e2), SC_(4.238486480712890625000000000000000000000e1), SC_(5.245493650436401367187500000000000000000e-1), SC_(4.908946237829231338100528381335051963151e-1), SC_(5.091053762170768661899471618664948036849e-1) }}, 
      {{ SC_(1.812054901123046875000000000000000000000e2), SC_(1.830175476074218750000000000000000000000e2), SC_(1.311481323242187500000000000000000000000e2), SC_(5.734516978263854980468750000000000000000e-1), SC_(4.879431799842054065831635644477156298254e-1), SC_(5.120568200157945934168364355522843701746e-1) }}, 
      {{ SC_(1.812054901123046875000000000000000000000e2), SC_(1.830175476074218750000000000000000000000e2), SC_(1.914333953857421875000000000000000000000e2), SC_(6.013017296791076660156250000000000000000e-1), SC_(4.862141680810003331087368205954511544533e-1), SC_(5.137858319189996668912631794045488455467e-1) }}, 
      {{ SC_(1.812054901123046875000000000000000000000e2), SC_(1.993260498046875000000000000000000000000e2), SC_(4.420680999755859375000000000000000000000e1), SC_(5.048784613609313964843750000000000000000e-1), SC_(4.994801852908195647496574869698359323561e-1), SC_(5.005198147091804352503425130301640676439e-1) }}, 
      {{ SC_(1.812054901123046875000000000000000000000e2), SC_(1.993260498046875000000000000000000000000e2), SC_(1.357470245361328125000000000000000000000e2), SC_(5.553276538848876953125000000000000000000e-1), SC_(4.975598324672097316313398613273509324755e-1), SC_(5.024401675327902683686601386726490675245e-1) }}, 
      {{ SC_(1.812054901123046875000000000000000000000e2), SC_(1.993260498046875000000000000000000000000e2), SC_(1.915013732910156250000000000000000000000e2), SC_(5.813192725181579589843750000000000000000e-1), SC_(4.966676664412912862714194638167882414385e-1), SC_(5.033323335587087137285805361832117585615e-1) }}, 
      {{ SC_(1.812054901123046875000000000000000000000e2), SC_(2.174465942382812500000000000000000000000e2), SC_(5.569964599609375000000000000000000000000e1), SC_(4.901356101036071777343750000000000000000e-1), SC_(5.006078319242163491995859118122722269393e-1), SC_(4.993921680757836508004140881877277730607e-1) }}, 
      {{ SC_(1.812054901123046875000000000000000000000e2), SC_(2.174465942382812500000000000000000000000e2), SC_(1.362719116210937500000000000000000000000e2), SC_(5.340651273727416992187500000000000000000e-1), SC_(4.989094914787976971124525393158251401054e-1), SC_(5.010905085212023028875474606841748598946e-1) }}, 
      {{ SC_(1.812054901123046875000000000000000000000e2), SC_(2.174465942382812500000000000000000000000e2), SC_(1.918984832763671875000000000000000000000e2), SC_(5.602313876152038574218750000000000000000e-1), SC_(4.979918918822526124111351267631179148098e-1), SC_(5.020081081177473875888648732368820851902e-1) }}, 
      {{ SC_(1.812054901123046875000000000000000000000e2), SC_(2.355671234130859375000000000000000000000e2), SC_(5.940588760375976562500000000000000000000e1), SC_(4.728337526321411132812500000000000000000e-1), SC_(5.088165843871218512069718135527857622961e-1), SC_(4.911834156128781487930281864472142377039e-1) }}, 
      {{ SC_(1.812054901123046875000000000000000000000e2), SC_(2.355671234130859375000000000000000000000e2), SC_(1.451677856445312500000000000000000000000e2), SC_(5.189537405967712402343750000000000000000e-1), SC_(5.064934476137953532555593272495246248783e-1), SC_(4.935065523862046467444406727504753751217e-1) }}, 
      {{ SC_(1.812054901123046875000000000000000000000e2), SC_(2.355671234130859375000000000000000000000e2), SC_(1.929777069091796875000000000000000000000e2), SC_(5.413293838500976562500000000000000000000e-1), SC_(5.055015061561282654973013987467420167804e-1), SC_(4.944984938438717345026986012532579832196e-1) }}, 
      {{ SC_(1.812054901123046875000000000000000000000e2), SC_(2.718082275390625000000000000000000000000e2), SC_(6.038262176513671875000000000000000000000e1), SC_(4.429862201213836669921875000000000000000e-1), SC_(5.948164604492985588790107986261646312806e-1), SC_(4.051835395507014411209892013738353687194e-1) }}, 
      {{ SC_(1.812054901123046875000000000000000000000e2), SC_(2.718082275390625000000000000000000000000e2), SC_(1.481294555664062500000000000000000000000e2), SC_(4.892813265323638916015625000000000000000e-1), SC_(5.859957174215638222639346547324231475842e-1), SC_(4.140042825784361777360653452675768524158e-1) }}, 
      {{ SC_(1.812054901123046875000000000000000000000e2), SC_(2.718082275390625000000000000000000000000e2), SC_(1.935389862060546875000000000000000000000e2), SC_(5.103465914726257324218750000000000000000e-1), SC_(5.827128144572482992860919060430235845811e-1), SC_(4.172871855427517007139080939569764154189e-1) }}, 
      {{ SC_(1.812054901123046875000000000000000000000e2), SC_(3.624109802246093750000000000000000000000e2), SC_(6.163340759277343750000000000000000000000e1), SC_(4.263992607593536376953125000000000000000e-1), SC_(9.964569947414909935470357896765906825355e-1), SC_(3.543005258509006452964210323409317464508e-3) }}, 
      {{ SC_(1.812054901123046875000000000000000000000e2), SC_(3.624109802246093750000000000000000000000e2), SC_(1.486264953613281250000000000000000000000e2), SC_(4.667214751243591308593750000000000000000e-1), SC_(9.934309748015782119527660941653426431254e-1), SC_(6.569025198421788047233905834657356874607e-3) }}, 
      {{ SC_(1.812054901123046875000000000000000000000e2), SC_(3.624109802246093750000000000000000000000e2), SC_(1.937735595703125000000000000000000000000e2), SC_(4.854946732521057128906250000000000000000e-1), SC_(9.918347517937643398860086505027176419970e-1), SC_(8.165248206235660113991349497282358003005e-3) }}, 
      {{ SC_(1.812054901123046875000000000000000000000e2), SC_(5.436164550781250000000000000000000000000e2), SC_(7.225879669189453125000000000000000000000e1), SC_(4.046374261379241943359375000000000000000e-1), SC_(9.999999999656887575331368878574390870234e-1), SC_(3.431124246686311214256091297660069800403e-11) }}, 
      {{ SC_(1.812054901123046875000000000000000000000e2), SC_(5.436164550781250000000000000000000000000e2), SC_(1.515480346679687500000000000000000000000e2), SC_(4.340875148773193359375000000000000000000e-1), SC_(9.999999993666889816621329312737214820112e-1), SC_(6.333110183378670687262785179888391151702e-10) }}, 
      {{ SC_(1.812054901123046875000000000000000000000e2), SC_(5.436164550781250000000000000000000000000e2), SC_(1.941185607910156250000000000000000000000e2), SC_(4.487296044826507568359375000000000000000e-1), SC_(9.999999980721670867931469493732202556495e-1), SC_(1.927832913206853050626779744350470859181e-9) }}, 
      {{ SC_(1.812054901123046875000000000000000000000e2), SC_(7.248219604492187500000000000000000000000e2), SC_(9.566968083381652832031250000000000000000e-1), SC_(3.849397301673889160156250000000000000000e-1), SC_(9.999999999999999999999999999999973689406e-1), SC_(2.631059438525473136304770068315176553826e-33) }}, 
      {{ SC_(1.812054901123046875000000000000000000000e2), SC_(7.248219604492187500000000000000000000000e2), SC_(7.844540405273437500000000000000000000000e1), SC_(4.101245701313018798828125000000000000000e-1), SC_(9.999999999999999999999999994216037815613e-1), SC_(5.783962184387165951746639137959536384747e-28) }}, 
      {{ SC_(1.812054901123046875000000000000000000000e2), SC_(7.248219604492187500000000000000000000000e2), SC_(1.584414672851562500000000000000000000000e2), SC_(4.340503513813018798828125000000000000000e-1), SC_(9.999999999999999999999990377479687412265e-1), SC_(9.622520312587735416885346705725800557378e-25) }}, 
      {{ SC_(1.812054901123046875000000000000000000000e2), SC_(7.248219604492187500000000000000000000000e2), SC_(1.962219390869140625000000000000000000000e2), SC_(4.446884989738464355468750000000000000000e-1), SC_(9.999999999999999999999874234175548701873e-1), SC_(1.257658244512981271888033059243700498406e-23) }}, 
      {{ SC_(1.812054901123046875000000000000000000000e2), SC_(9.060274658203125000000000000000000000000e2), SC_(7.142335891723632812500000000000000000000), SC_(4.462616145610809326171875000000000000000e-1), SC_(1.000000000000000000000000000000000000000), SC_(2.546882379401071227062056473207554425391e-83) }}, 
      {{ SC_(1.812054901123046875000000000000000000000e2), SC_(9.060274658203125000000000000000000000000e2), SC_(7.974770355224609375000000000000000000000e1), SC_(4.640816152095794677734375000000000000000e-1), SC_(1.000000000000000000000000000000000000000), SC_(3.065221717437812440534472448362876271415e-72) }}, 
      {{ SC_(1.812054901123046875000000000000000000000e2), SC_(9.060274658203125000000000000000000000000e2), SC_(1.595857238769531250000000000000000000000e2), SC_(4.823990166187286376953125000000000000000e-1), SC_(1.000000000000000000000000000000000000000), SC_(7.761881715694691658234562444330402173292e-65) }}, 
      {{ SC_(1.812054901123046875000000000000000000000e2), SC_(9.060274658203125000000000000000000000000e2), SC_(1.985762634277343750000000000000000000000e2), SC_(4.908974468708038330078125000000000000000e-1), SC_(1.000000000000000000000000000000000000000), SC_(3.911514658214188920125352566583228436181e-62) }}, 
      {{ SC_(1.827184753417968750000000000000000000000e2), SC_(1.827184867858886718750000000000000000000e1), SC_(7.225879669189453125000000000000000000000e1), SC_(9.614465236663818359375000000000000000000e-1), SC_(9.958417370270455671682888163968364954533e-1), SC_(4.158262972954432831711183603163504546680e-3) }}, 
      {{ SC_(1.827184753417968750000000000000000000000e2), SC_(1.827184867858886718750000000000000000000e1), SC_(1.515480346679687500000000000000000000000e2), SC_(9.669575691223144531250000000000000000000e-1), SC_(9.956215228151742468905766185138197641587e-1), SC_(4.378477184825753109423381486180235841258e-3) }}, 
      {{ SC_(1.827184753417968750000000000000000000000e2), SC_(1.827184867858886718750000000000000000000e1), SC_(1.941185607910156250000000000000000000000e2), SC_(9.693141579627990722656250000000000000000e-1), SC_(9.955364312495689567306147929655662244131e-1), SC_(4.463568750431043269385207034433775586868e-3) }}, 
      {{ SC_(1.827184753417968750000000000000000000000e2), SC_(4.567961883544921875000000000000000000000e1), SC_(9.566968083381652832031250000000000000000e-1), SC_(9.334720373153686523437500000000000000000e-1), SC_(9.999999999784011151656787731831723220431e-1), SC_(2.159888483432122681682767795685620766242e-11) }}, 
      {{ SC_(1.827184753417968750000000000000000000000e2), SC_(4.567961883544921875000000000000000000000e1), SC_(7.844540405273437500000000000000000000000e1), SC_(9.430729150772094726562500000000000000000e-1), SC_(9.999999999557163463096285625285277489223e-1), SC_(4.428365369037143747147225107774900352899e-11) }}, 
      {{ SC_(1.827184753417968750000000000000000000000e2), SC_(4.567961883544921875000000000000000000000e1), SC_(1.584414672851562500000000000000000000000e2), SC_(9.504604935646057128906250000000000000000e-1), SC_(9.999999999313162833214580562225118534674e-1), SC_(6.868371667854194377748814653263903439389e-11) }}, 
      {{ SC_(1.827184753417968750000000000000000000000e2), SC_(4.567961883544921875000000000000000000000e1), SC_(1.962219390869140625000000000000000000000e2), SC_(9.533227086067199707031250000000000000000e-1), SC_(9.999999999203905801768172708749881257176e-1), SC_(7.960941982318272912501187428239471759860e-11) }}, 
      {{ SC_(1.827184753417968750000000000000000000000e2), SC_(9.135923767089843750000000000000000000000e1), SC_(7.142335891723632812500000000000000000000), SC_(9.177346825599670410156250000000000000000e-1), SC_(9.999999999999999999999999999998803664272e-1), SC_(1.196335727701846650559388181039587093752e-31) }}, 
      {{ SC_(1.827184753417968750000000000000000000000e2), SC_(9.135923767089843750000000000000000000000e1), SC_(7.974770355224609375000000000000000000000e1), SC_(9.272211194038391113281250000000000000000e-1), SC_(9.999999999999999999999999999981789336844e-1), SC_(1.821066315599975020489538574215574072610e-30) }}, 
      {{ SC_(1.827184753417968750000000000000000000000e2), SC_(9.135923767089843750000000000000000000000e1), SC_(1.595857238769531250000000000000000000000e2), SC_(9.354160428047180175781250000000000000000e-1), SC_(9.999999999999999999999999999886379287712e-1), SC_(1.136207122878755012266202181067022077571e-29) }}, 
      {{ SC_(1.827184753417968750000000000000000000000e2), SC_(9.135923767089843750000000000000000000000e1), SC_(1.985762634277343750000000000000000000000e2), SC_(9.387837052345275878906250000000000000000e-1), SC_(9.999999999999999999999999999783569291568e-1), SC_(2.164307084318060307523863904196708638782e-29) }}, 
      {{ SC_(1.827184753417968750000000000000000000000e2), SC_(1.370388488769531250000000000000000000000e2), SC_(1.950807952880859375000000000000000000000e1), SC_(9.168155193328857421875000000000000000000e-1), SC_(1.000000000000000000000000000000000000000), SC_(7.952904093836814774201153214392389287383e-60) }}, 
      {{ SC_(1.827184753417968750000000000000000000000e2), SC_(1.370388488769531250000000000000000000000e2), SC_(8.435225677490234375000000000000000000000e1), SC_(9.242496490478515625000000000000000000000e-1), SC_(1.000000000000000000000000000000000000000), SC_(1.129614883917948399982177903311045666589e-57) }}, 
      {{ SC_(1.827184753417968750000000000000000000000e2), SC_(1.370388488769531250000000000000000000000e2), SC_(1.596211700439453125000000000000000000000e2), SC_(9.313721656799316406250000000000000000000e-1), SC_(1.000000000000000000000000000000000000000), SC_(4.698884070900834468836207606858038381270e-56) }}, 
      {{ SC_(1.827184753417968750000000000000000000000e2), SC_(1.370388488769531250000000000000000000000e2), SC_(1.992922668457031250000000000000000000000e2), SC_(9.346135854721069335937500000000000000000e-1), SC_(1.000000000000000000000000000000000000000), SC_(2.004737245152041111087772178468392065847e-55) }}, 
      {{ SC_(1.827184753417968750000000000000000000000e2), SC_(1.644466247558593750000000000000000000000e2), SC_(2.197235107421875000000000000000000000000e1), SC_(5.408066138625144958496093750000000000000e-2), SC_(7.954549488789278821203135921175581568306e-138), SC_(1.000000000000000000000000000000000000000) }}, 
      {{ SC_(1.827184753417968750000000000000000000000e2), SC_(1.644466247558593750000000000000000000000e2), SC_(8.441753387451171875000000000000000000000e1), SC_(5.775463581085205078125000000000000000000e-2), SC_(6.076950939112410802666294607824683459477e-145), SC_(1.000000000000000000000000000000000000000) }}, 
      {{ SC_(1.827184753417968750000000000000000000000e2), SC_(1.644466247558593750000000000000000000000e2), SC_(1.600560913085937500000000000000000000000e2), SC_(6.148844584822654724121093750000000000000e-2), SC_(1.129647779906505798985995784827646515298e-154), SC_(1.000000000000000000000000000000000000000) }}, 
      {{ SC_(1.827184753417968750000000000000000000000e2), SC_(1.808912963867187500000000000000000000000e2), SC_(2.249290275573730468750000000000000000000e1), SC_(1.293498873710632324218750000000000000000e-1), SC_(1.212297089391038026582206156247646223090e-69), SC_(1.000000000000000000000000000000000000000) }}, 
      {{ SC_(1.827184753417968750000000000000000000000e2), SC_(1.808912963867187500000000000000000000000e2), SC_(9.495173645019531250000000000000000000000e1), SC_(1.399608105421066284179687500000000000000e-1), SC_(1.052868048038960799368309601168716825299e-75), SC_(1.000000000000000000000000000000000000000) }}, 
      {{ SC_(1.827184753417968750000000000000000000000e2), SC_(1.808912963867187500000000000000000000000e2), SC_(1.629447326660156250000000000000000000000e2), SC_(1.483526378870010375976562500000000000000e-1), SC_(3.884502752879205968879091243612521260628e-82), SC_(1.000000000000000000000000000000000000000) }}, 
      {{ SC_(1.827184753417968750000000000000000000000e2), SC_(1.825357666015625000000000000000000000000e2), SC_(2.539736366271972656250000000000000000000e1), SC_(2.584990262985229492187500000000000000000e-1), SC_(6.420210442693378197210671164442165445237e-26), SC_(9.999999999999999999999999357978955730662e-1) }}, 
      {{ SC_(1.827184753417968750000000000000000000000e2), SC_(1.825357666015625000000000000000000000000e2), SC_(9.707512664794921875000000000000000000000e1), SC_(2.793727219104766845703125000000000000000e-1), SC_(4.801554510993043742383930008241919581982e-29), SC_(9.999999999999999999999999999519844548901e-1) }}, 
      {{ SC_(1.827184753417968750000000000000000000000e2), SC_(1.825357666015625000000000000000000000000e2), SC_(1.670017089843750000000000000000000000000e2), SC_(2.965355217456817626953125000000000000000e-1), SC_(1.713889408871080254076289962881030477282e-32), SC_(9.999999999999999999999999999999828611059e-1) }}, 
      {{ SC_(1.827184753417968750000000000000000000000e2), SC_(1.827184753417968750000000000000000000000e2), SC_(2.709540176391601562500000000000000000000e1), SC_(3.883711695671081542968750000000000000000e-1), SC_(2.885240601040756104211457468761084381934e-7), SC_(9.999997114759398959243895788542531238916e-1) }}, 
      {{ SC_(1.827184753417968750000000000000000000000e2), SC_(1.827184753417968750000000000000000000000e2), SC_(1.007325439453125000000000000000000000000e2), SC_(4.203277826309204101562500000000000000000e-1), SC_(2.863862488055078200967152434443884826039e-8), SC_(9.999999713613751194492179903284756555612e-1) }}, 
      {{ SC_(1.827184753417968750000000000000000000000e2), SC_(1.827184753417968750000000000000000000000e2), SC_(1.698258666992187500000000000000000000000e2), SC_(4.455783963203430175781250000000000000000e-1), SC_(2.432391001366536243272963463393397510819e-9), SC_(9.999999975676089986334637567270365366066e-1) }}, 
      {{ SC_(1.827184753417968750000000000000000000000e2), SC_(1.827367553710937500000000000000000000000e2), SC_(2.837726783752441406250000000000000000000e1), SC_(4.667537510395050048828125000000000000000e-1), SC_(2.349181816378352726190959908226558673619e-2), SC_(9.765081818362164727380904009177344132638e-1) }}, 
      {{ SC_(1.827184753417968750000000000000000000000e2), SC_(1.827367553710937500000000000000000000000e2), SC_(1.093762969970703125000000000000000000000e2), SC_(5.084335803985595703125000000000000000000e-1), SC_(1.366708005248165945457121810566777566508e-2), SC_(9.863329199475183405454287818943322243349e-1) }}, 
      {{ SC_(1.827184753417968750000000000000000000000e2), SC_(1.827367553710937500000000000000000000000e2), SC_(1.756861267089843750000000000000000000000e2), SC_(5.370306372642517089843750000000000000000e-1), SC_(8.266691490223428821898095306822000197747e-3), SC_(9.917333085097765711781019046931779998023e-1) }}, 
      {{ SC_(1.827184753417968750000000000000000000000e2), SC_(1.829011993408203125000000000000000000000e2), SC_(3.152261734008789062500000000000000000000e1), SC_(5.151682496070861816406250000000000000000e-1), SC_(4.201296209802723716372361996809827173877e-1), SC_(5.798703790197276283627638003190172826123e-1) }}, 
      {{ SC_(1.827184753417968750000000000000000000000e2), SC_(1.829011993408203125000000000000000000000e2), SC_(1.094441146850585937500000000000000000000e2), SC_(5.590928196907043457031250000000000000000e-1), SC_(4.095623454256481802864942731334041606044e-1), SC_(5.904376545743518197135057268665958393956e-1) }}, 
      {{ SC_(1.827184753417968750000000000000000000000e2), SC_(1.829011993408203125000000000000000000000e2), SC_(1.811583862304687500000000000000000000000e2), SC_(5.929121971130371093750000000000000000000e-1), SC_(3.997435029745732560700638931974275346954e-1), SC_(6.002564970254267439299361068025724653046e-1) }}, 
      {{ SC_(1.827184753417968750000000000000000000000e2), SC_(1.845456542968750000000000000000000000000e2), SC_(3.423733520507812500000000000000000000000e1), SC_(5.193155407905578613281250000000000000000e-1), SC_(4.911750609582495475582649261517009829843e-1), SC_(5.088249390417504524417350738482990170157e-1) }}, 
      {{ SC_(1.827184753417968750000000000000000000000e2), SC_(1.845456542968750000000000000000000000000e2), SC_(1.264718551635742187500000000000000000000e2), SC_(5.706050992012023925781250000000000000000e-1), SC_(4.880912441902859344014985488345874416798e-1), SC_(5.119087558097140655985014511654125583202e-1) }}, 
      {{ SC_(1.827184753417968750000000000000000000000e2), SC_(1.845456542968750000000000000000000000000e2), SC_(1.826751708984375000000000000000000000000e2), SC_(5.968183875083923339843750000000000000000e-1), SC_(4.864700442950805521615834338370725565754e-1), SC_(5.135299557049194478384165661629274434246e-1) }}, 
      {{ SC_(1.827184753417968750000000000000000000000e2), SC_(2.009903259277343750000000000000000000000e2), SC_(3.477303314208984375000000000000000000000e1), SC_(4.988422095775604248046875000000000000000e-1), SC_(4.997252690727566191543648229986091355496e-1), SC_(5.002747309272433808456351770013908644504e-1) }}, 
      {{ SC_(1.827184753417968750000000000000000000000e2), SC_(2.009903259277343750000000000000000000000e2), SC_(1.279526672363281250000000000000000000000e2), SC_(5.509020090103149414062500000000000000000e-1), SC_(4.977274644804262862816536819737460907824e-1), SC_(5.022725355195737137183463180262539092176e-1) }}, 
      {{ SC_(1.827184753417968750000000000000000000000e2), SC_(2.009903259277343750000000000000000000000e2), SC_(1.831471099853515625000000000000000000000e2), SC_(5.769424438476562500000000000000000000000e-1), SC_(4.968266212877898487729799468939024420743e-1), SC_(5.031733787122101512270200531060975579257e-1) }}, 
      {{ SC_(1.827184753417968750000000000000000000000e2), SC_(2.192621765136718750000000000000000000000e2), SC_(3.767639541625976562500000000000000000000e1), SC_(4.789597392082214355468750000000000000000e-1), SC_(5.010697259597532421742596494233521082929e-1), SC_(4.989302740402467578257403505766478917071e-1) }}, 
      {{ SC_(1.827184753417968750000000000000000000000e2), SC_(2.192621765136718750000000000000000000000e2), SC_(1.310955810546875000000000000000000000000e2), SC_(5.309247970581054687500000000000000000000e-1), SC_(4.990342661163638809638451378728117107864e-1), SC_(5.009657338836361190361548621271882892136e-1) }}, 
      {{ SC_(1.827184753417968750000000000000000000000e2), SC_(2.192621765136718750000000000000000000000e2), SC_(1.867986450195312500000000000000000000000e2), SC_(5.572617053985595703125000000000000000000e-1), SC_(4.981068506223925370969557266613425669748e-1), SC_(5.018931493776074629030442733386574330252e-1) }}, 
      {{ SC_(1.827184753417968750000000000000000000000e2), SC_(2.375340118408203125000000000000000000000e2), SC_(4.238486480712890625000000000000000000000e1), SC_(4.623961150646209716796875000000000000000e-1), SC_(5.094297474652239595486268225000524245196e-1), SC_(4.905702525347760404513731774999475754804e-1) }}, 
      {{ SC_(1.827184753417968750000000000000000000000e2), SC_(2.375340118408203125000000000000000000000e2), SC_(1.311481323242187500000000000000000000000e2), SC_(5.114251375198364257812500000000000000000e-1), SC_(5.068851010638085601826420949743884388292e-1), SC_(4.931148989361914398173579050256115611708e-1) }}, 
      {{ SC_(1.827184753417968750000000000000000000000e2), SC_(2.375340118408203125000000000000000000000e2), SC_(1.914333953857421875000000000000000000000e2), SC_(5.399298667907714843750000000000000000000e-1), SC_(5.056020302576617080002493069005644620521e-1), SC_(4.943979697423382919997506930994355379479e-1) }}, 
      {{ SC_(1.827184753417968750000000000000000000000e2), SC_(2.740776977539062500000000000000000000000e2), SC_(4.420680999755859375000000000000000000000e1), SC_(4.333045482635498046875000000000000000000e-1), SC_(5.973968683638224726034203985173418130623e-1), SC_(4.026031316361775273965796014826581869377e-1) }}, 
      {{ SC_(1.827184753417968750000000000000000000000e2), SC_(2.740776977539062500000000000000000000000e2), SC_(1.357470245361328125000000000000000000000e2), SC_(4.826631247997283935546875000000000000000e-1), SC_(5.874710105856871327837674084576970219184e-1), SC_(4.125289894143128672162325915423029780816e-1) }}, 
      {{ SC_(1.827184753417968750000000000000000000000e2), SC_(2.740776977539062500000000000000000000000e2), SC_(1.915013732910156250000000000000000000000e2), SC_(5.087309479713439941406250000000000000000e-1), SC_(5.833022699722344737848382325075885334187e-1), SC_(4.166977300277655262151617674924114665813e-1) }}, 
      {{ SC_(1.827184753417968750000000000000000000000e2), SC_(3.654369506835937500000000000000000000000e2), SC_(5.569964599609375000000000000000000000000e1), SC_(4.231939911842346191406250000000000000000e-1), SC_(9.967781663156764680630613525141739921264e-1), SC_(3.221833684323531936938647485826007873590e-3) }}, 
      {{ SC_(1.827184753417968750000000000000000000000e2), SC_(3.654369506835937500000000000000000000000e2), SC_(1.362719116210937500000000000000000000000e2), SC_(4.608475565910339355468750000000000000000e-1), SC_(9.940873658821745977822453196035070835287e-1), SC_(5.912634117825402217754680396492916471262e-3) }}, 
      {{ SC_(1.827184753417968750000000000000000000000e2), SC_(3.654369506835937500000000000000000000000e2), SC_(1.918984832763671875000000000000000000000e2), SC_(4.841021001338958740234375000000000000000e-1), SC_(9.921743557064726422825767223621615178893e-1), SC_(7.825644293527357717423277637838482110655e-3) }}, 
      {{ SC_(1.827184753417968750000000000000000000000e2), SC_(5.481553955078125000000000000000000000000e2), SC_(5.940588760375976562500000000000000000000e1), SC_(3.993774354457855224609375000000000000000e-1), SC_(9.999999999851807474782070887837355542582e-1), SC_(1.481925252179291121626444574177769116440e-11) }}, 
      {{ SC_(1.827184753417968750000000000000000000000e2), SC_(5.481553955078125000000000000000000000000e2), SC_(1.451677856445312500000000000000000000000e2), SC_(4.313982427120208740234375000000000000000e-1), SC_(9.999999995686912820534640133263238284690e-1), SC_(4.313087179465359866736761715309812125439e-10) }}, 
      {{ SC_(1.827184753417968750000000000000000000000e2), SC_(5.481553955078125000000000000000000000000e2), SC_(1.929777069091796875000000000000000000000e2), SC_(4.478110671043395996093750000000000000000e-1), SC_(9.999999984435380501672738174984676726445e-1), SC_(1.556461949832726182501532327355517988630e-9) }}, 
      {{ SC_(1.827184753417968750000000000000000000000e2), SC_(7.308739013671875000000000000000000000000e2), SC_(6.038262176513671875000000000000000000000e1), SC_(4.042811095714569091796875000000000000000e-1), SC_(9.999999999999999999999999999654883711682e-1), SC_(3.451162883178698979991819995815804945554e-29) }}, 
      {{ SC_(1.827184753417968750000000000000000000000e2), SC_(7.308739013671875000000000000000000000000e2), SC_(1.481294555664062500000000000000000000000e2), SC_(4.307200312614440917968750000000000000000e-1), SC_(9.999999999999999999999997447537547521491e-1), SC_(2.552462452478508508435096963959758312853e-25) }}, 
      {{ SC_(1.827184753417968750000000000000000000000e2), SC_(7.308739013671875000000000000000000000000e2), SC_(1.935389862060546875000000000000000000000e2), SC_(4.435023367404937744140625000000000000000e-1), SC_(9.999999999999999999999936846515620382461e-1), SC_(6.315348437961753883986897901062284837149e-24) }}, 
      {{ SC_(1.827184753417968750000000000000000000000e2), SC_(9.135924072265625000000000000000000000000e2), SC_(6.163340759277343750000000000000000000000e1), SC_(4.596207439899444580078125000000000000000e-1), SC_(1.000000000000000000000000000000000000000), SC_(4.036362620515347463351748808972528767769e-75) }}, 
      {{ SC_(1.827184753417968750000000000000000000000e2), SC_(9.135924072265625000000000000000000000000e2), SC_(1.486264953613281250000000000000000000000e2), SC_(4.796838462352752685546875000000000000000e-1), SC_(1.000000000000000000000000000000000000000), SC_(2.594664045195780280914678039358242430265e-66) }}, 
      {{ SC_(1.827184753417968750000000000000000000000e2), SC_(9.135924072265625000000000000000000000000e2), SC_(1.937735595703125000000000000000000000000e2), SC_(4.895204007625579833984375000000000000000e-1), SC_(1.000000000000000000000000000000000000000), SC_(4.723382870695954132657648419899275829029e-63) }}, 
      {{ SC_(1.831892395019531250000000000000000000000e2), SC_(1.831892395019531250000000000000000000000e1), SC_(5.940588760375976562500000000000000000000e1), SC_(9.603628516197204589843750000000000000000e-1), SC_(9.959318080821379563450937074114119943579e-1), SC_(4.068191917862043654906292588588005642121e-3) }}, 
      {{ SC_(1.831892395019531250000000000000000000000e2), SC_(1.831892395019531250000000000000000000000e1), SC_(1.451677856445312500000000000000000000000e2), SC_(9.665502309799194335937500000000000000000e-1), SC_(9.956823652285968951457171290079816789310e-1), SC_(4.317634771403104854282870992018321068984e-3) }}, 
      {{ SC_(1.831892395019531250000000000000000000000e2), SC_(1.831892395019531250000000000000000000000e1), SC_(1.929777069091796875000000000000000000000e2), SC_(9.692298173904418945312500000000000000000e-1), SC_(9.955856984049715061176794516052801519090e-1), SC_(4.414301595028493882320548394719848091020e-3) }}, 
      {{ SC_(1.831892395019531250000000000000000000000e2), SC_(4.579730987548828125000000000000000000000e1), SC_(6.038262176513671875000000000000000000000e1), SC_(9.410727620124816894531250000000000000000e-1), SC_(9.999999999634205417442628117178560289719e-1), SC_(3.657945825573718828214397102813828397377e-11) }}, 
      {{ SC_(1.831892395019531250000000000000000000000e2), SC_(4.579730987548828125000000000000000000000e1), SC_(1.481294555664062500000000000000000000000e2), SC_(9.495857954025268554687500000000000000000e-1), SC_(9.999999999380187812338584459754697732207e-1), SC_(6.198121876614155402453022677927129529888e-11) }}, 
      {{ SC_(1.831892395019531250000000000000000000000e2), SC_(4.579730987548828125000000000000000000000e1), SC_(1.935389862060546875000000000000000000000e2), SC_(9.530946612358093261718750000000000000000e-1), SC_(9.999999999254824752682922543737980502855e-1), SC_(7.451752473170774562620194971446214727587e-11) }}, 
      {{ SC_(1.831892395019531250000000000000000000000e2), SC_(9.159461975097656250000000000000000000000e1), SC_(6.163340759277343750000000000000000000000e1), SC_(9.250452518463134765625000000000000000000e-1), SC_(9.999999999999999999999999999991228387055e-1), SC_(8.771612944761362864675288893384796643857e-31) }}, 
      {{ SC_(1.831892395019531250000000000000000000000e2), SC_(9.159461975097656250000000000000000000000e1), SC_(1.486264953613281250000000000000000000000e2), SC_(9.343660473823547363281250000000000000000e-1), SC_(9.999999999999999999999999999922188143820e-1), SC_(7.781185618021541571946139554654316905355e-30) }}, 
      {{ SC_(1.831892395019531250000000000000000000000e2), SC_(9.159461975097656250000000000000000000000e1), SC_(1.937735595703125000000000000000000000000e2), SC_(9.383467435836791992187500000000000000000e-1), SC_(9.999999999999999999999999999830480867782e-1), SC_(1.695191322175131208526642991067293527623e-29) }}, 
      {{ SC_(1.831892395019531250000000000000000000000e2), SC_(1.373919372558593750000000000000000000000e2), SC_(7.225879669189453125000000000000000000000e1), SC_(9.229453802108764648437500000000000000000e-1), SC_(1.000000000000000000000000000000000000000), SC_(3.719062770976144981499994372537023825274e-58) }}, 
      {{ SC_(1.831892395019531250000000000000000000000e2), SC_(1.373919372558593750000000000000000000000e2), SC_(1.515480346679687500000000000000000000000e2), SC_(9.306388497352600097656250000000000000000e-1), SC_(1.000000000000000000000000000000000000000), SC_(2.405706211675584104349728650026841074880e-56) }}, 
      {{ SC_(1.831892395019531250000000000000000000000e2), SC_(1.373919372558593750000000000000000000000e2), SC_(1.941185607910156250000000000000000000000e2), SC_(9.341690540313720703125000000000000000000e-1), SC_(1.000000000000000000000000000000000000000), SC_(1.205192015746274445715461862455075468631e-55) }}, 
      {{ SC_(1.831892395019531250000000000000000000000e2), SC_(1.648703155517578125000000000000000000000e2), SC_(9.566968083381652832031250000000000000000e-1), SC_(5.269640311598777770996093750000000000000e-2), SC_(5.012657063541276677405707935648904884053e-136), SC_(1.000000000000000000000000000000000000000) }}, 
      {{ SC_(1.831892395019531250000000000000000000000e2), SC_(1.648703155517578125000000000000000000000e2), SC_(7.844540405273437500000000000000000000000e1), SC_(5.741776898503303527832031250000000000000e-2), SC_(1.458831448659767343421841944743959108603e-144), SC_(1.000000000000000000000000000000000000000) }}, 
      {{ SC_(1.831892395019531250000000000000000000000e2), SC_(1.648703155517578125000000000000000000000e2), SC_(1.584414672851562500000000000000000000000e2), SC_(6.139727309346199035644531250000000000000e-2), SC_(8.574432564377341729153513698458946320960e-155), SC_(1.000000000000000000000000000000000000000) }}, 
      {{ SC_(1.831892395019531250000000000000000000000e2), SC_(1.648703155517578125000000000000000000000e2), SC_(1.962219390869140625000000000000000000000e2), SC_(6.302948296070098876953125000000000000000e-2), SC_(5.621732671207059770725895843468730300033e-160), SC_(1.000000000000000000000000000000000000000) }}, 
      {{ SC_(1.831892395019531250000000000000000000000e2), SC_(1.813573455810546875000000000000000000000e2), SC_(7.142335891723632812500000000000000000000), SC_(1.268314421176910400390625000000000000000e-1), SC_(1.138989895191049531110752474171848093507e-68), SC_(1.000000000000000000000000000000000000000) }}, 
      {{ SC_(1.831892395019531250000000000000000000000e2), SC_(1.813573455810546875000000000000000000000e2), SC_(7.974770355224609375000000000000000000000e1), SC_(1.378632634878158569335937500000000000000e-1), SC_(1.601561761340656163696945878818485643197e-74), SC_(1.000000000000000000000000000000000000000) }}, 
      {{ SC_(1.831892395019531250000000000000000000000e2), SC_(1.813573455810546875000000000000000000000e2), SC_(1.595857238769531250000000000000000000000e2), SC_(1.479211449623107910156250000000000000000e-1), SC_(5.695064435384708555397331568488641256176e-82), SC_(1.000000000000000000000000000000000000000) }}, 
      {{ SC_(1.831892395019531250000000000000000000000e2), SC_(1.813573455810546875000000000000000000000e2), SC_(1.985762634277343750000000000000000000000e2), SC_(1.522059887647628784179687500000000000000e-1), SC_(6.963976660406827096835054742729974292083e-86), SC_(1.000000000000000000000000000000000000000) }}, 
      {{ SC_(1.831892395019531250000000000000000000000e2), SC_(1.830060577392578125000000000000000000000e2), SC_(1.950807952880859375000000000000000000000e1), SC_(2.565912902355194091796875000000000000000e-1), SC_(9.583496552065196247775016516643622181852e-26), SC_(9.999999999999999999999999041650344793480e-1) }}, 
      {{ SC_(1.831892395019531250000000000000000000000e2), SC_(1.830060577392578125000000000000000000000e2), SC_(8.435225677490234375000000000000000000000e1), SC_(2.758751809597015380859375000000000000000e-1), SC_(1.629696962104815883060371700201583834265e-28), SC_(9.999999999999999999999999998370303037895e-1) }}, 
      {{ SC_(1.831892395019531250000000000000000000000e2), SC_(1.830060577392578125000000000000000000000e2), SC_(1.596211700439453125000000000000000000000e2), SC_(2.947566509246826171875000000000000000000e-1), SC_(3.599627971491224237874409849636284067422e-32), SC_(9.999999999999999999999999999999640037203e-1) }}, 
      {{ SC_(1.831892395019531250000000000000000000000e2), SC_(1.830060577392578125000000000000000000000e2), SC_(1.992922668457031250000000000000000000000e2), SC_(3.034845292568206787109375000000000000000e-1), SC_(3.046741463181066922333479789811279931084e-34), SC_(9.999999999999999999999999999999996953259e-1) }}, 
      {{ SC_(1.831892395019531250000000000000000000000e2), SC_(1.831892395019531250000000000000000000000e2), SC_(2.197235107421875000000000000000000000000e1), SC_(3.858892321586608886718750000000000000000e-1), SC_(3.234788492206814617426455344099436607375e-7), SC_(9.999996765211507793185382573544655900563e-1) }}, 
      {{ SC_(1.831892395019531250000000000000000000000e2), SC_(1.831892395019531250000000000000000000000e2), SC_(8.441753387451171875000000000000000000000e1), SC_(4.136540293693542480468750000000000000000e-1), SC_(4.780740584941519648845127211528157532725e-8), SC_(9.999999521925941505848035115487278847184e-1) }}, 
      {{ SC_(1.831892395019531250000000000000000000000e2), SC_(1.831892395019531250000000000000000000000e2), SC_(1.600560913085937500000000000000000000000e2), SC_(4.421032667160034179687500000000000000000e-1), SC_(3.399216379381454368632311056884140161991e-9), SC_(9.999999966007836206185456313676889431159e-1) }}, 
      {{ SC_(1.831892395019531250000000000000000000000e2), SC_(1.832075653076171875000000000000000000000e2), SC_(2.249290275573730468750000000000000000000e1), SC_(4.633449912071228027343750000000000000000e-1), SC_(2.420772879574992529154268685841870506569e-2), SC_(9.757922712042500747084573131415812949343e-1) }}, 
      {{ SC_(1.831892395019531250000000000000000000000e2), SC_(1.832075653076171875000000000000000000000e2), SC_(9.495173645019531250000000000000000000000e1), SC_(5.014896988868713378906250000000000000000e-1), SC_(1.506636305249321674582149104677187525267e-2), SC_(9.849336369475067832541785089532281247473e-1) }}, 
      {{ SC_(1.831892395019531250000000000000000000000e2), SC_(1.832075653076171875000000000000000000000e2), SC_(1.629447326660156250000000000000000000000e2), SC_(5.316920280456542968750000000000000000000e-1), SC_(9.094249190890923045681813289324920348531e-3), SC_(9.909057508091090769543181867106750796515e-1) }}, 
      {{ SC_(1.831892395019531250000000000000000000000e2), SC_(1.833724365234375000000000000000000000000e2), SC_(2.539736366271972656250000000000000000000e1), SC_(5.112926363945007324218750000000000000000e-1), SC_(4.208547511860700514150673858306710381736e-1), SC_(5.791452488139299485849326141693289618264e-1) }}, 
      {{ SC_(1.831892395019531250000000000000000000000e2), SC_(1.833724365234375000000000000000000000000e2), SC_(9.707512664794921875000000000000000000000e1), SC_(5.525386929512023925781250000000000000000e-1), SC_(4.111805656159895576117974601645341947418e-1), SC_(5.888194343840104423882025398354658052582e-1) }}, 
      {{ SC_(1.831892395019531250000000000000000000000e2), SC_(1.833724365234375000000000000000000000000e2), SC_(1.670017089843750000000000000000000000000e2), SC_(5.864704251289367675781250000000000000000e-1), SC_(4.016250860282170869162590329456317398318e-1), SC_(5.983749139717829130837409670543682601682e-1) }}, 
      {{ SC_(1.831892395019531250000000000000000000000e2), SC_(1.850211334228515625000000000000000000000e2), SC_(2.709540176391601562500000000000000000000e1), SC_(5.147842168807983398437500000000000000000e-1), SC_(4.914315439246625796760913953727015550732e-1), SC_(5.085684560753374203239086046272984449268e-1) }}, 
      {{ SC_(1.831892395019531250000000000000000000000e2), SC_(1.850211334228515625000000000000000000000e2), SC_(1.007325439453125000000000000000000000000e2), SC_(5.572906136512756347656250000000000000000e-1), SC_(4.888951821337963121259281550012182019546e-1), SC_(5.111048178662036878740718449987817980454e-1) }}, 
      {{ SC_(1.831892395019531250000000000000000000000e2), SC_(1.850211334228515625000000000000000000000e2), SC_(1.698258666992187500000000000000000000000e2), SC_(5.909155607223510742187500000000000000000e-1), SC_(4.868302767636421621046759425915723269450e-1), SC_(5.131697232363578378953240574084276730550e-1) }}, 
      {{ SC_(1.831892395019531250000000000000000000000e2), SC_(2.015081634521484375000000000000000000000e2), SC_(2.837726783752441406250000000000000000000e1), SC_(4.947776794433593750000000000000000000000e-1), SC_(4.998897618006052115453944821248100702717e-1), SC_(5.001102381993947884546055178751899297283e-1) }}, 
      {{ SC_(1.831892395019531250000000000000000000000e2), SC_(2.015081634521484375000000000000000000000e2), SC_(1.093762969970703125000000000000000000000e2), SC_(5.412565469741821289062500000000000000000e-1), SC_(4.980819916871217968217651920244778565716e-1), SC_(5.019180083128782031782348079755221434284e-1) }}, 
      {{ SC_(1.831892395019531250000000000000000000000e2), SC_(2.015081634521484375000000000000000000000e2), SC_(1.756861267089843750000000000000000000000e2), SC_(5.733964443206787109375000000000000000000e-1), SC_(4.969484803576037086280749969481121108653e-1), SC_(5.030515196423962913719250030518878891347e-1) }}, 
      {{ SC_(1.831892395019531250000000000000000000000e2), SC_(2.198271026611328125000000000000000000000e2), SC_(3.152261734008789062500000000000000000000e1), SC_(4.750797450542449951171875000000000000000e-1), SC_(5.012307191936324223658841968234478267346e-1), SC_(4.987692808063675776341158031765521732654e-1) }}, 
      {{ SC_(1.831892395019531250000000000000000000000e2), SC_(2.198271026611328125000000000000000000000e2), SC_(1.094441146850585937500000000000000000000e2), SC_(5.196764469146728515625000000000000000000e-1), SC_(4.994556097601754142213582418941343516720e-1), SC_(5.005443902398245857786417581058656483280e-1) }}, 
      {{ SC_(1.831892395019531250000000000000000000000e2), SC_(2.198271026611328125000000000000000000000e2), SC_(1.811583862304687500000000000000000000000e2), SC_(5.545202493667602539062500000000000000000e-1), SC_(4.982046767513496278523753634415502860854e-1), SC_(5.017953232486503721476246365584497139146e-1) }}, 
      {{ SC_(1.831892395019531250000000000000000000000e2), SC_(2.381459960937500000000000000000000000000e2), SC_(3.423733520507812500000000000000000000000e1), SC_(4.573448598384857177734375000000000000000e-1), SC_(5.097266129544324584639427465873456865509e-1), SC_(4.902733870455675415360572534126543134491e-1) }}, 
      {{ SC_(1.831892395019531250000000000000000000000e2), SC_(2.381459960937500000000000000000000000000e2), SC_(1.264718551635742187500000000000000000000e2), SC_(5.089015960693359375000000000000000000000e-1), SC_(5.070184963329001873577329135500978794507e-1), SC_(4.929815036670998126422670864499021205493e-1) }}, 
      {{ SC_(1.831892395019531250000000000000000000000e2), SC_(2.381459960937500000000000000000000000000e2), SC_(1.826751708984375000000000000000000000000e2), SC_(5.357843637466430664062500000000000000000e-1), SC_(5.057930760525553616477325474656060806470e-1), SC_(4.942069239474446383522674525343939193530e-1) }}, 
      {{ SC_(1.831892395019531250000000000000000000000e2), SC_(2.747838745117187500000000000000000000000e2), SC_(3.477303314208984375000000000000000000000e1), SC_(4.276245534420013427734375000000000000000e-1), SC_(5.988776180510504326833818885297355168118e-1), SC_(4.011223819489495673166181114702644831882e-1) }}, 
      {{ SC_(1.831892395019531250000000000000000000000e2), SC_(2.747838745117187500000000000000000000000e2), SC_(1.279526672363281250000000000000000000000e2), SC_(4.786331653594970703125000000000000000000e-1), SC_(5.882857178441849629399050524610890560020e-1), SC_(4.117142821558150370600949475389109439980e-1) }}, 
      {{ SC_(1.831892395019531250000000000000000000000e2), SC_(2.747838745117187500000000000000000000000e2), SC_(1.831471099853515625000000000000000000000e2), SC_(5.047813653945922851562500000000000000000e-1), SC_(5.840045034979370437274956783265655751217e-1), SC_(4.159954965020629562725043216734344248783e-1) }}, 
      {{ SC_(1.831892395019531250000000000000000000000e2), SC_(3.663784790039062500000000000000000000000e2), SC_(3.767639541625976562500000000000000000000e1), SC_(4.139913916587829589843750000000000000000e-1), SC_(9.973634968644689438077400715829784550230e-1), SC_(2.636503135531056192259928417021544976978e-3) }}, 
      {{ SC_(1.831892395019531250000000000000000000000e2), SC_(3.663784790039062500000000000000000000000e2), SC_(1.310955810546875000000000000000000000000e2), SC_(4.584285020828247070312500000000000000000e-1), SC_(9.943299155867957495067806687417216673534e-1), SC_(5.670084413204250493219331258278332646564e-3) }}, 
      {{ SC_(1.831892395019531250000000000000000000000e2), SC_(3.663784790039062500000000000000000000000e2), SC_(1.867986450195312500000000000000000000000e2), SC_(4.818605482578277587890625000000000000000e-1), SC_(9.924303814424934192704221375972608530768e-1), SC_(7.569618557506580729577862402739146923170e-3) }}, 
      {{ SC_(1.831892395019531250000000000000000000000e2), SC_(5.495677490234375000000000000000000000000e2), SC_(4.238486480712890625000000000000000000000e1), SC_(3.925452232360839843750000000000000000000e-1), SC_(9.999999999945368375441811956663231812863e-1), SC_(5.463162455818804333676818713673427542954e-12) }}, 
      {{ SC_(1.831892395019531250000000000000000000000e2), SC_(5.495677490234375000000000000000000000000e2), SC_(1.311481323242187500000000000000000000000e2), SC_(4.262778162956237792968750000000000000000e-1), SC_(9.999999997389305788290726466165875889943e-1), SC_(2.610694211709273533834124110057069970954e-10) }}, 
      {{ SC_(1.831892395019531250000000000000000000000e2), SC_(5.495677490234375000000000000000000000000e2), SC_(1.914333953857421875000000000000000000000e2), SC_(4.471315145492553710937500000000000000000e-1), SC_(9.999999985849897095983750785903583861856e-1), SC_(1.415010290401624921409641613814371044361e-9) }}, 
      {{ SC_(1.831892395019531250000000000000000000000e2), SC_(7.327569580078125000000000000000000000000e2), SC_(4.420680999755859375000000000000000000000e1), SC_(3.991006612777709960937500000000000000000e-1), SC_(9.999999999999999999999999999970302551869e-1), SC_(2.969744813117787977293827004500353759028e-30) }}, 
      {{ SC_(1.831892395019531250000000000000000000000e2), SC_(7.327569580078125000000000000000000000000e2), SC_(1.357470245361328125000000000000000000000e2), SC_(4.270304441452026367187500000000000000000e-1), SC_(9.999999999999999999999999212046496373463e-1), SC_(7.879535036265365749599468586098957860902e-26) }}, 
      {{ SC_(1.831892395019531250000000000000000000000e2), SC_(7.327569580078125000000000000000000000000e2), SC_(1.915013732910156250000000000000000000000e2), SC_(4.428054988384246826171875000000000000000e-1), SC_(9.999999999999999999999952860593576790832e-1), SC_(4.713940642320916819570790870780202088595e-24) }}, 
      {{ SC_(1.831892395019531250000000000000000000000e2), SC_(9.159461669921875000000000000000000000000e2), SC_(5.569964599609375000000000000000000000000e1), SC_(4.581613540649414062500000000000000000000e-1), SC_(1.000000000000000000000000000000000000000), SC_(4.059502324616300953903306635862989595431e-76) }}, 
      {{ SC_(1.831892395019531250000000000000000000000e2), SC_(9.159461669921875000000000000000000000000e2), SC_(1.362719116210937500000000000000000000000e2), SC_(4.768471717834472656250000000000000000000e-1), SC_(1.000000000000000000000000000000000000000), SC_(1.591668114429635471154418857321981252837e-67) }}, 
      {{ SC_(1.831892395019531250000000000000000000000e2), SC_(9.159461669921875000000000000000000000000e2), SC_(1.918984832763671875000000000000000000000e2), SC_(4.890137612819671630859375000000000000000e-1), SC_(1.000000000000000000000000000000000000000), SC_(2.297344114508716573612274936577560722445e-63) }}, 
      {{ SC_(1.868316497802734375000000000000000000000e2), SC_(1.868316459655761718750000000000000000000e1), SC_(4.238486480712890625000000000000000000000e1), SC_(9.587775468826293945312500000000000000000e-1), SC_(9.963176956432822424732328469443533221375e-1), SC_(3.682304356717757526767153055646677862460e-3) }}, 
      {{ SC_(1.868316497802734375000000000000000000000e2), SC_(1.868316459655761718750000000000000000000e1), SC_(1.311481323242187500000000000000000000000e2), SC_(9.655097723007202148437500000000000000000e-1), SC_(9.960558569481452718441670806680901948064e-1), SC_(3.944143051854728155832919331909805193570e-3) }}, 
      {{ SC_(1.868316497802734375000000000000000000000e2), SC_(1.868316459655761718750000000000000000000e1), SC_(1.914333953857421875000000000000000000000e2), SC_(9.689559936523437500000000000000000000000e-1), SC_(9.959372583302798415518304720255580266971e-1), SC_(4.062741669720158448169527974441973302861e-3) }}, 
      {{ SC_(1.868316497802734375000000000000000000000e2), SC_(4.670791244506835937500000000000000000000e1), SC_(4.420680999755859375000000000000000000000e1), SC_(9.390768408775329589843750000000000000000e-1), SC_(9.999999999795587930872571575519994879239e-1), SC_(2.044120691274284244800051207611555871453e-11) }}, 
      {{ SC_(1.868316497802734375000000000000000000000e2), SC_(4.670791244506835937500000000000000000000e1), SC_(1.357470245361328125000000000000000000000e2), SC_(9.483070373535156250000000000000000000000e-1), SC_(9.999999999624131336977093602611909638521e-1), SC_(3.758686630229063973880903614787550807283e-11) }}, 
      {{ SC_(1.868316497802734375000000000000000000000e2), SC_(4.670791244506835937500000000000000000000e1), SC_(1.915013732910156250000000000000000000000e2), SC_(9.526768326759338378906250000000000000000e-1), SC_(9.999999999522490493519477486593921065814e-1), SC_(4.775095064805225134060789341864382574798e-11) }}, 
      {{ SC_(1.868316497802734375000000000000000000000e2), SC_(9.341582489013671875000000000000000000000e1), SC_(5.569964599609375000000000000000000000000e1), SC_(9.241771697998046875000000000000000000000e-1), SC_(9.999999999999999999999999999998162764578e-1), SC_(1.837235421585409574740837758834787825659e-31) }}, 
      {{ SC_(1.868316497802734375000000000000000000000e2), SC_(9.341582489013671875000000000000000000000e1), SC_(1.362719116210937500000000000000000000000e2), SC_(9.329271316528320312500000000000000000000e-1), SC_(9.999999999999999999999999999984141813625e-1), SC_(1.585818637450675011176408594910820208382e-30) }}, 
      {{ SC_(1.868316497802734375000000000000000000000e2), SC_(9.341582489013671875000000000000000000000e1), SC_(1.918984832763671875000000000000000000000e2), SC_(9.378787875175476074218750000000000000000e-1), SC_(9.999999999999999999999999999956337041698e-1), SC_(4.366295830193479620182449220588156583185e-30) }}, 
      {{ SC_(1.868316497802734375000000000000000000000e2), SC_(1.401237335205078125000000000000000000000e2), SC_(5.940588760375976562500000000000000000000e1), SC_(9.214057326316833496093750000000000000000e-1), SC_(1.000000000000000000000000000000000000000), SC_(1.059903928589393919764923401252698906715e-59) }}, 
      {{ SC_(1.868316497802734375000000000000000000000e2), SC_(1.401237335205078125000000000000000000000e2), SC_(1.451677856445312500000000000000000000000e2), SC_(9.298254251480102539062500000000000000000e-1), SC_(1.000000000000000000000000000000000000000), SC_(1.332398386650845277305358089101768432560e-57) }}, 
      {{ SC_(1.868316497802734375000000000000000000000e2), SC_(1.401237335205078125000000000000000000000e2), SC_(1.929777069091796875000000000000000000000e2), SC_(9.337815642356872558593750000000000000000e-1), SC_(1.000000000000000000000000000000000000000), SC_(8.680005329308165326418595668850130771806e-57) }}, 
      {{ SC_(1.868316497802734375000000000000000000000e2), SC_(1.681484832763671875000000000000000000000e2), SC_(6.038262176513671875000000000000000000000e1), SC_(5.633562803268432617187500000000000000000e-2), SC_(4.447068939706990795747316317720768695532e-145), SC_(1.000000000000000000000000000000000000000) }}, 
      {{ SC_(1.868316497802734375000000000000000000000e2), SC_(1.681484832763671875000000000000000000000e2), SC_(1.481294555664062500000000000000000000000e2), SC_(6.079288199543952941894531250000000000000e-2), SC_(4.985436374795471556324443006011763471499e-156), SC_(1.000000000000000000000000000000000000000) }}, 
      {{ SC_(1.868316497802734375000000000000000000000e2), SC_(1.681484832763671875000000000000000000000e2), SC_(1.935389862060546875000000000000000000000e2), SC_(6.276074051856994628906250000000000000000e-2), SC_(3.385541959190152585302144025972466803283e-162), SC_(1.000000000000000000000000000000000000000) }}, 
      {{ SC_(1.868316497802734375000000000000000000000e2), SC_(1.849633331298828125000000000000000000000e2), SC_(6.163340759277343750000000000000000000000e1), SC_(1.351259797811508178710937500000000000000e-1), SC_(2.862178397150002291392501447375824592982e-74), SC_(1.000000000000000000000000000000000000000) }}, 
      {{ SC_(1.868316497802734375000000000000000000000e2), SC_(1.849633331298828125000000000000000000000e2), SC_(1.486264953613281250000000000000000000000e2), SC_(1.463074535131454467773437500000000000000e-1), SC_(3.517782027403150932723865989298868669424e-82), SC_(1.000000000000000000000000000000000000000) }}, 
      {{ SC_(1.868316497802734375000000000000000000000e2), SC_(1.849633331298828125000000000000000000000e2), SC_(1.937735595703125000000000000000000000000e2), SC_(1.512950062751770019531250000000000000000e-1), SC_(1.172151827172948926009037704069731235569e-86), SC_(1.000000000000000000000000000000000000000) }}, 
      {{ SC_(1.868316497802734375000000000000000000000e2), SC_(1.866448211669921875000000000000000000000e2), SC_(7.225879669189453125000000000000000000000e1), SC_(2.721162736415863037109375000000000000000e-1), SC_(2.022082792003978748488011508054285644117e-28), SC_(9.999999999999999999999999997977917207996e-1) }}, 
      {{ SC_(1.868316497802734375000000000000000000000e2), SC_(1.866448211669921875000000000000000000000e2), SC_(1.515480346679687500000000000000000000000e2), SC_(2.921928763389587402343750000000000000000e-1), SC_(3.361680613170037577420301350713394183359e-32), SC_(9.999999999999999999999999999999663831939e-1) }}, 
      {{ SC_(1.868316497802734375000000000000000000000e2), SC_(1.866448211669921875000000000000000000000e2), SC_(1.941185607910156250000000000000000000000e2), SC_(3.015808165073394775390625000000000000000e-1), SC_(2.125987960851663370229738337113877663360e-34), SC_(9.999999999999999999999999999999997874012e-1) }}, 
      {{ SC_(1.868316497802734375000000000000000000000e2), SC_(1.868316497802734375000000000000000000000e2), SC_(9.566968083381652832031250000000000000000e-1), SC_(3.754781484603881835937500000000000000000e-1), SC_(4.497700533855937231559430279358618251824e-7), SC_(9.999995502299466144062768440569720641382e-1) }}, 
      {{ SC_(1.868316497802734375000000000000000000000e2), SC_(1.868316497802734375000000000000000000000e2), SC_(7.844540405273437500000000000000000000000e1), SC_(4.105455875396728515625000000000000000000e-1), SC_(4.577443027674754507065748541977160219207e-8), SC_(9.999999542255697232524549293425145802284e-1) }}, 
      {{ SC_(1.868316497802734375000000000000000000000e2), SC_(1.868316497802734375000000000000000000000e2), SC_(1.584414672851562500000000000000000000000e2), SC_(4.404773712158203125000000000000000000000e-1), SC_(2.878482383701850865363124943526369207651e-9), SC_(9.999999971215176162981491346368750564736e-1) }}, 
      {{ SC_(1.868316497802734375000000000000000000000e2), SC_(1.868316497802734375000000000000000000000e2), SC_(1.962219390869140625000000000000000000000e2), SC_(4.528546929359436035156250000000000000000e-1), SC_(6.948302369840317331281293469502580800578e-10), SC_(9.999999993051697630159682668718706530497e-1) }}, 
      {{ SC_(1.868316497802734375000000000000000000000e2), SC_(1.868503417968750000000000000000000000000e2), SC_(7.142335891723632812500000000000000000000), SC_(4.542262852191925048828125000000000000000e-1), SC_(2.535661945623525169326897277943106177441e-2), SC_(9.746433805437647483067310272205689382256e-1) }}, 
      {{ SC_(1.868316497802734375000000000000000000000e2), SC_(1.868503417968750000000000000000000000000e2), SC_(7.974770355224609375000000000000000000000e1), SC_(4.932725429534912109375000000000000000000e-1), SC_(1.606121020229939281545591351433764512794e-2), SC_(9.839387897977006071845440864856623548721e-1) }}, 
      {{ SC_(1.868316497802734375000000000000000000000e2), SC_(1.868503417968750000000000000000000000000e2), SC_(1.595857238769531250000000000000000000000e2), SC_(5.290189981460571289062500000000000000000e-1), SC_(8.987441058229357802791261903726578976017e-3), SC_(9.910125589417706421972087380962734210240e-1) }}, 
      {{ SC_(1.868316497802734375000000000000000000000e2), SC_(1.868503417968750000000000000000000000000e2), SC_(1.985762634277343750000000000000000000000e2), SC_(5.442905426025390625000000000000000000000e-1), SC_(6.602306792028241286062229301777150804366e-3), SC_(9.933976932079717587139377706982228491956e-1) }}, 
      {{ SC_(1.868316497802734375000000000000000000000e2), SC_(1.870184936523437500000000000000000000000e2), SC_(1.950807952880859375000000000000000000000e1), SC_(5.073134303092956542968750000000000000000e-1), SC_(4.209268271155798324468781429021331112299e-1), SC_(5.790731728844201675531218570978668887701e-1) }}, 
      {{ SC_(1.868316497802734375000000000000000000000e2), SC_(1.870184936523437500000000000000000000000e2), SC_(8.435225677490234375000000000000000000000e1), SC_(5.448516011238098144531250000000000000000e-1), SC_(4.123299733704996770290202963883995083763e-1), SC_(5.876700266295003229709797036116004916237e-1) }}, 
      {{ SC_(1.868316497802734375000000000000000000000e2), SC_(1.870184936523437500000000000000000000000e2), SC_(1.596211700439453125000000000000000000000e2), SC_(5.817211270332336425781250000000000000000e-1), SC_(4.021833682054327630251775991372782977418e-1), SC_(5.978166317945672369748224008627217022582e-1) }}, 
      {{ SC_(1.868316497802734375000000000000000000000e2), SC_(1.870184936523437500000000000000000000000e2), SC_(1.992922668457031250000000000000000000000e2), SC_(5.988024473190307617187500000000000000000e-1), SC_(3.968307430121048883939293776121339171215e-1), SC_(6.031692569878951116060706223878660828785e-1) }}, 
      {{ SC_(1.868316497802734375000000000000000000000e2), SC_(1.886999664306640625000000000000000000000e2), SC_(2.197235107421875000000000000000000000000e1), SC_(5.112472176551818847656250000000000000000e-1), SC_(4.915651691739803976815504566377784456494e-1), SC_(5.084348308260196023184495433622215543506e-1) }}, 
      {{ SC_(1.868316497802734375000000000000000000000e2), SC_(1.886999664306640625000000000000000000000e2), SC_(8.441753387451171875000000000000000000000e1), SC_(5.476266741752624511718750000000000000000e-1), SC_(4.894133851577763536747747611720382352977e-1), SC_(5.105866148422236463252252388279617647023e-1) }}, 
      {{ SC_(1.868316497802734375000000000000000000000e2), SC_(1.886999664306640625000000000000000000000e2), SC_(1.600560913085937500000000000000000000000e2), SC_(5.850389599800109863281250000000000000000e-1), SC_(4.871353574134042241992281060783184460675e-1), SC_(5.128646425865957758007718939216815539325e-1) }}, 
      {{ SC_(1.868316497802734375000000000000000000000e2), SC_(2.055148162841796875000000000000000000000e2), SC_(2.249290275573730468750000000000000000000e1), SC_(4.907517135143280029296875000000000000000e-1), SC_(5.000525801943659909068202280819680867571e-1), SC_(4.999474198056340090931797719180319132429e-1) }}, 
      {{ SC_(1.868316497802734375000000000000000000000e2), SC_(2.055148162841796875000000000000000000000e2), SC_(9.495173645019531250000000000000000000000e1), SC_(5.326175093650817871093750000000000000000e-1), SC_(4.984198412460916132702722563886927342051e-1), SC_(5.015801587539083867297277436113072657949e-1) }}, 
      {{ SC_(1.868316497802734375000000000000000000000e2), SC_(2.055148162841796875000000000000000000000e2), SC_(1.629447326660156250000000000000000000000e2), SC_(5.661012530326843261718750000000000000000e-1), SC_(4.972240651844518411249762244490171129154e-1), SC_(5.027759348155481588750237755509828870846e-1) }}, 
      {{ SC_(1.868316497802734375000000000000000000000e2), SC_(2.241979827880859375000000000000000000000e2), SC_(2.539736366271972656250000000000000000000e1), SC_(4.709076583385467529296875000000000000000e-1), SC_(5.014074055272636507831245320154745839579e-1), SC_(4.985925944727363492168754679845254160421e-1) }}, 
      {{ SC_(1.868316497802734375000000000000000000000e2), SC_(2.241979827880859375000000000000000000000e2), SC_(9.707512664794921875000000000000000000000e1), SC_(5.120908021926879882812500000000000000000e-1), SC_(4.997639941646187793778471851103036801080e-1), SC_(5.002360058353812206221528148896963198920e-1) }}, 
      {{ SC_(1.868316497802734375000000000000000000000e2), SC_(2.241979827880859375000000000000000000000e2), SC_(1.670017089843750000000000000000000000000e2), SC_(5.465353131294250488281250000000000000000e-1), SC_(4.985087069193308315872700468487246538903e-1), SC_(5.014912930806691684127299531512753461097e-1) }}, 
      {{ SC_(1.868316497802734375000000000000000000000e2), SC_(2.428811340332031250000000000000000000000e2), SC_(2.709540176391601562500000000000000000000e1), SC_(4.525674581527709960937500000000000000000e-1), SC_(5.100808234644975009062095658429859103203e-1), SC_(4.899191765355024990937904341570140896797e-1) }}, 
      {{ SC_(1.868316497802734375000000000000000000000e2), SC_(2.428811340332031250000000000000000000000e2), SC_(1.007325439453125000000000000000000000000e2), SC_(4.944759309291839599609375000000000000000e-1), SC_(5.078148560012502469593373179232002172845e-1), SC_(4.921851439987497530406626820767997827155e-1) }}, 
      {{ SC_(1.868316497802734375000000000000000000000e2), SC_(2.428811340332031250000000000000000000000e2), SC_(1.698258666992187500000000000000000000000e2), SC_(5.283634662628173828125000000000000000000e-1), SC_(5.062139159523141199270455974378673978902e-1), SC_(4.937860840476858800729544025621326021098e-1) }}, 
      {{ SC_(1.868316497802734375000000000000000000000e2), SC_(2.802474670410156250000000000000000000000e2), SC_(2.837726783752441406250000000000000000000e1), SC_(4.234192073345184326171875000000000000000e-1), SC_(6.008538366056769163695375771003735921976e-1), SC_(3.991461633943230836304624228996264078024e-1) }}, 
      {{ SC_(1.868316497802734375000000000000000000000e2), SC_(2.802474670410156250000000000000000000000e2), SC_(1.093762969970703125000000000000000000000e2), SC_(4.680990874767303466796875000000000000000e-1), SC_(5.910782350013849280965970779662706996082e-1), SC_(4.089217649986150719034029220337293003918e-1) }}, 
      {{ SC_(1.868316497802734375000000000000000000000e2), SC_(2.802474670410156250000000000000000000000e2), SC_(1.756861267089843750000000000000000000000e2), SC_(4.998363554477691650390625000000000000000e-1), SC_(5.856111839155466379952355919583217586207e-1), SC_(4.143888160844533620047644080416782413793e-1) }}, 
      {{ SC_(1.868316497802734375000000000000000000000e2), SC_(3.736632995605468750000000000000000000000e2), SC_(3.152261734008789062500000000000000000000e1), SC_(4.104879200458526611328125000000000000000e-1), SC_(9.977634129614769713261808375225142044560e-1), SC_(2.236587038523028673819162477485795544012e-3) }}, 
      {{ SC_(1.868316497802734375000000000000000000000e2), SC_(3.736632995605468750000000000000000000000e2), SC_(1.094441146850585937500000000000000000000e2), SC_(4.477671980857849121093750000000000000000e-1), SC_(9.954839777072194816039103604039021748732e-1), SC_(4.516022292780518396089639596097825126785e-3) }}, 
      {{ SC_(1.868316497802734375000000000000000000000e2), SC_(3.736632995605468750000000000000000000000e2), SC_(1.811583862304687500000000000000000000000e2), SC_(4.781447052955627441406250000000000000000e-1), SC_(9.932138854421588185405702141532360143174e-1), SC_(6.786114557841181459429785846763985682646e-3) }}, 
      {{ SC_(1.868316497802734375000000000000000000000e2), SC_(5.604949340820312500000000000000000000000e2), SC_(3.423733520507812500000000000000000000000e1), SC_(3.889780938625335693359375000000000000000e-1), SC_(9.999999999980114625928336468947770120812e-1), SC_(1.988537407166353105222987918765187371666e-12) }}, 
      {{ SC_(1.868316497802734375000000000000000000000e2), SC_(5.604949340820312500000000000000000000000e2), SC_(1.264718551635742187500000000000000000000e2), SC_(4.237038493156433105468750000000000000000e-1), SC_(9.999999998616464327616151142902751542499e-1), SC_(1.383535672383848857097248457500658774113e-10) }}, 
      {{ SC_(1.868316497802734375000000000000000000000e2), SC_(5.604949340820312500000000000000000000000e2), SC_(1.826751708984375000000000000000000000000e2), SC_(4.429954588413238525390625000000000000000e-1), SC_(9.999999992765584611721190545108493610788e-1), SC_(7.234415388278809454891506389211637116534e-10) }}, 
      {{ SC_(1.868316497802734375000000000000000000000e2), SC_(7.473265991210937500000000000000000000000e2), SC_(3.477303314208984375000000000000000000000e1), SC_(3.958480060100555419921875000000000000000e-1), SC_(9.999999999999999999999999999998355135244e-1), SC_(1.644864755988219356176566879879524070422e-31) }}, 
      {{ SC_(1.868316497802734375000000000000000000000e2), SC_(7.473265991210937500000000000000000000000e2), SC_(1.279526672363281250000000000000000000000e2), SC_(4.240219891071319580078125000000000000000e-1), SC_(9.999999999999999999999999893029123285237e-1), SC_(1.069708767147633811962675955343390185735e-26) }}, 
      {{ SC_(1.868316497802734375000000000000000000000e2), SC_(7.473265991210937500000000000000000000000e2), SC_(1.831471099853515625000000000000000000000e2), SC_(4.395058453083038330078125000000000000000e-1), SC_(9.999999999999999999999992319065655813393e-1), SC_(7.680934344186606873432848227812634105556e-25) }}, 
      {{ SC_(1.868316497802734375000000000000000000000e2), SC_(9.341582641601562500000000000000000000000e2), SC_(3.767639541625976562500000000000000000000e1), SC_(4.536183178424835205078125000000000000000e-1), SC_(1.000000000000000000000000000000000000000), SC_(2.237863146757550731903964269669974262080e-80) }}, 
      {{ SC_(1.868316497802734375000000000000000000000e2), SC_(9.341582641601562500000000000000000000000e2), SC_(1.310955810546875000000000000000000000000e2), SC_(4.751105010509490966796875000000000000000e-1), SC_(1.000000000000000000000000000000000000000), SC_(1.667682789439155670897247959265187978634e-69) }}, 
      {{ SC_(1.868316497802734375000000000000000000000e2), SC_(9.341582641601562500000000000000000000000e2), SC_(1.867986450195312500000000000000000000000e2), SC_(4.871400296688079833984375000000000000000e-1), SC_(1.000000000000000000000000000000000000000), SC_(3.505126337791643072167314646255905863950e-65) }}, 
      {{ SC_(1.914548034667968750000000000000000000000e2), SC_(1.914548110961914062500000000000000000000e1), SC_(3.423733520507812500000000000000000000000e1), SC_(9.579485654830932617187500000000000000000e-1), SC_(9.967147450132703599376396376476660680642e-1), SC_(3.285254986729640062360362352333931935837e-3) }}, 
      {{ SC_(1.914548034667968750000000000000000000000e2), SC_(1.914548110961914062500000000000000000000e1), SC_(1.264718551635742187500000000000000000000e2), SC_(9.650126099586486816406250000000000000000e-1), SC_(9.964583689751538403894430468672572032925e-1), SC_(3.541631024846159610556953132742796707486e-3) }}, 
      {{ SC_(1.914548034667968750000000000000000000000e2), SC_(1.914548110961914062500000000000000000000e1), SC_(1.826751708984375000000000000000000000000e2), SC_(9.682638645172119140625000000000000000000e-1), SC_(9.963536394540283238746189036463208139012e-1), SC_(3.646360545971676125381096353679186098800e-3) }}, 
      {{ SC_(1.914548034667968750000000000000000000000e2), SC_(4.786370086669921875000000000000000000000e1), SC_(3.477303314208984375000000000000000000000e1), SC_(9.378322362899780273437500000000000000000e-1), SC_(9.999999999893773588576049646894005392432e-1), SC_(1.062264114239503531059946075680098661959e-11) }}, 
      {{ SC_(1.914548034667968750000000000000000000000e2), SC_(4.786370086669921875000000000000000000000e1), SC_(1.279526672363281250000000000000000000000e2), SC_(9.473592638969421386718750000000000000000e-1), SC_(9.999999999793864224158856362901292624797e-1), SC_(2.061357758411436370987073752034015739094e-11) }}, 
      {{ SC_(1.914548034667968750000000000000000000000e2), SC_(4.786370086669921875000000000000000000000e1), SC_(1.831471099853515625000000000000000000000e2), SC_(9.517428278923034667968750000000000000000e-1), SC_(9.999999999734734302968841503704956342469e-1), SC_(2.652656970311584962950436575313905758575e-11) }}, 
      {{ SC_(1.914548034667968750000000000000000000000e2), SC_(9.572740173339843750000000000000000000000e1), SC_(3.767639541625976562500000000000000000000e1), SC_(9.217808246612548828125000000000000000000e-1), SC_(9.999999999999999999999999999999832265460e-1), SC_(1.677345404419443459415889877162318013801e-32) }}, 
      {{ SC_(1.914548034667968750000000000000000000000e2), SC_(9.572740173339843750000000000000000000000e1), SC_(1.310955810546875000000000000000000000000e2), SC_(9.321167469024658203125000000000000000000e-1), SC_(9.999999999999999999999999999997426062479e-1), SC_(2.573937521308322973176762776165513488690e-31) }}, 
      {{ SC_(1.914548034667968750000000000000000000000e2), SC_(9.572740173339843750000000000000000000000e1), SC_(1.867986450195312500000000000000000000000e2), SC_(9.370771646499633789062500000000000000000e-1), SC_(9.999999999999999999999999999992559813065e-1), SC_(7.440186934733374478679588980523334245599e-31) }}, 
      {{ SC_(1.914548034667968750000000000000000000000e2), SC_(1.435910949707031250000000000000000000000e2), SC_(4.238486480712890625000000000000000000000e1), SC_(9.193713665008544921875000000000000000000e-1), SC_(1.000000000000000000000000000000000000000), SC_(9.549099101749093292330329120860845651025e-62) }}, 
      {{ SC_(1.914548034667968750000000000000000000000e2), SC_(1.435910949707031250000000000000000000000e2), SC_(1.311481323242187500000000000000000000000e2), SC_(9.282862544059753417968750000000000000000e-1), SC_(1.000000000000000000000000000000000000000), SC_(2.489285350477218385340059841434491070430e-59) }}, 
      {{ SC_(1.914548034667968750000000000000000000000e2), SC_(1.435910949707031250000000000000000000000e2), SC_(1.914333953857421875000000000000000000000e2), SC_(9.332972764968872070312500000000000000000e-1), SC_(1.000000000000000000000000000000000000000), SC_(3.052412889016873249384909130498891105212e-58) }}, 
      {{ SC_(1.914548034667968750000000000000000000000e2), SC_(1.723093261718750000000000000000000000000e2), SC_(4.420680999755859375000000000000000000000e1), SC_(5.533832311630249023437500000000000000000e-2), SC_(1.312377006542553517078410286766428497368e-146), SC_(1.000000000000000000000000000000000000000) }}, 
      {{ SC_(1.914548034667968750000000000000000000000e2), SC_(1.723093261718750000000000000000000000000e2), SC_(1.357470245361328125000000000000000000000e2), SC_(6.006555631756782531738281250000000000000e-2), SC_(9.985397904872050839235004002675215788018e-158), SC_(1.000000000000000000000000000000000000000) }}, 
      {{ SC_(1.914548034667968750000000000000000000000e2), SC_(1.723093261718750000000000000000000000000e2), SC_(1.915013732910156250000000000000000000000e2), SC_(6.248489767313003540039062500000000000000e-2), SC_(3.277951905988299432266390768061110791783e-165), SC_(1.000000000000000000000000000000000000000) }}, 
      {{ SC_(1.914548034667968750000000000000000000000e2), SC_(1.895402526855468750000000000000000000000e2), SC_(5.569964599609375000000000000000000000000e1), SC_(1.340808272361755371093750000000000000000e-1), SC_(1.966199991499434990582410563570124954148e-75), SC_(1.000000000000000000000000000000000000000) }}, 
      {{ SC_(1.914548034667968750000000000000000000000e2), SC_(1.895402526855468750000000000000000000000e2), SC_(1.362719116210937500000000000000000000000e2), SC_(1.444604843854904174804687500000000000000e-1), SC_(1.262741479544473659449727590596408440983e-82), SC_(1.000000000000000000000000000000000000000) }}, 
      {{ SC_(1.914548034667968750000000000000000000000e2), SC_(1.895402526855468750000000000000000000000e2), SC_(1.918984832763671875000000000000000000000e2), SC_(1.506067365407943725585937500000000000000e-1), SC_(4.488030046678398097942175857000619480468e-88), SC_(1.000000000000000000000000000000000000000) }}, 
      {{ SC_(1.914548034667968750000000000000000000000e2), SC_(1.912633514404296875000000000000000000000e2), SC_(5.940588760375976562500000000000000000000e1), SC_(2.680808007717132568359375000000000000000e-1), SC_(1.966378557699341313446967906342943372548e-28), SC_(9.999999999999999999999999998033621442301e-1) }}, 
      {{ SC_(1.914548034667968750000000000000000000000e2), SC_(1.912633514404296875000000000000000000000e2), SC_(1.451677856445312500000000000000000000000e2), SC_(2.898863852024078369140625000000000000000e-1), SC_(1.931641473752132951418225919775654130651e-32), SC_(9.999999999999999999999999999999806835853e-1) }}, 
      {{ SC_(1.914548034667968750000000000000000000000e2), SC_(1.912633514404296875000000000000000000000e2), SC_(1.929777069091796875000000000000000000000e2), SC_(3.003537952899932861328125000000000000000e-1), SC_(6.898411312106771071890603615349603780285e-35), SC_(9.999999999999999999999999999999999310159e-1) }}, 
      {{ SC_(1.914548034667968750000000000000000000000e2), SC_(1.914548034667968750000000000000000000000e2), SC_(6.038262176513671875000000000000000000000e1), SC_(4.023452103137969970703125000000000000000e-1), SC_(5.981423868988404350928959535789947967549e-8), SC_(9.999999401857613101159564907104046421005e-1) }}, 
      {{ SC_(1.914548034667968750000000000000000000000e2), SC_(1.914548034667968750000000000000000000000e2), SC_(1.481294555664062500000000000000000000000e2), SC_(4.356671869754791259765625000000000000000e-1), SC_(3.138145583802731765851335275547333237272e-9), SC_(9.999999968618544161972682341486647244527e-1) }}, 
      {{ SC_(1.914548034667968750000000000000000000000e2), SC_(1.914548034667968750000000000000000000000e2), SC_(1.935389862060546875000000000000000000000e2), SC_(4.505258798599243164062500000000000000000e-1), SC_(5.825986475371888964082208748359924646150e-10), SC_(9.999999994174013524628111035917791251640e-1) }}, 
      {{ SC_(1.914548034667968750000000000000000000000e2), SC_(1.914739532470703125000000000000000000000e2), SC_(6.163340759277343750000000000000000000000e1), SC_(4.834212362766265869140625000000000000000e-1), SC_(1.718468620267071908444558631463499472402e-2), SC_(9.828153137973292809155544136853650052760e-1) }}, 
      {{ SC_(1.914548034667968750000000000000000000000e2), SC_(1.914739532470703125000000000000000000000e2), SC_(1.486264953613281250000000000000000000000e2), SC_(5.229834318161010742187500000000000000000e-1), SC_(9.306844523826908295421186594157483056811e-3), SC_(9.906931554761730917045788134058425169432e-1) }}, 
      {{ SC_(1.914548034667968750000000000000000000000e2), SC_(1.914739532470703125000000000000000000000e2), SC_(1.937735595703125000000000000000000000000e2), SC_(5.406971573829650878906250000000000000000e-1), SC_(6.554548315854596665130156027942420446006e-3), SC_(9.934454516841454033348698439720575795540e-1) }}, 
      {{ SC_(1.914548034667968750000000000000000000000e2), SC_(1.916462707519531250000000000000000000000e2), SC_(7.225879669189453125000000000000000000000e1), SC_(5.373401641845703125000000000000000000000e-1), SC_(4.131860902404184630760003386260409549565e-1), SC_(5.868139097595815369239996613739590450435e-1) }}, 
      {{ SC_(1.914548034667968750000000000000000000000e2), SC_(1.916462707519531250000000000000000000000e2), SC_(1.515480346679687500000000000000000000000e2), SC_(5.763840079307556152343750000000000000000e-1), SC_(4.026808459586198173997646594783409106602e-1), SC_(5.973191540413801826002353405216590893398e-1) }}, 
      {{ SC_(1.914548034667968750000000000000000000000e2), SC_(1.916462707519531250000000000000000000000e2), SC_(1.941185607910156250000000000000000000000e2), SC_(5.946952104568481445312500000000000000000e-1), SC_(3.970231583726993389549088812564272355809e-1), SC_(6.029768416273006610450911187435727644191e-1) }}, 
      {{ SC_(1.914548034667968750000000000000000000000e2), SC_(1.933693542480468750000000000000000000000e2), SC_(9.566968083381652832031250000000000000000e-1), SC_(4.976365268230438232421875000000000000000e-1), SC_(4.922509903754604077378291971357599638520e-1), SC_(5.077490096245395922621708028642400361480e-1) }}, 
      {{ SC_(1.914548034667968750000000000000000000000e2), SC_(1.933693542480468750000000000000000000000e2), SC_(7.844540405273437500000000000000000000000e1), SC_(5.433472394943237304687500000000000000000e-1), SC_(4.895870367088976357309979501752919334589e-1), SC_(5.104129632911023642690020498247080665411e-1) }}, 
      {{ SC_(1.914548034667968750000000000000000000000e2), SC_(1.933693542480468750000000000000000000000e2), SC_(1.584414672851562500000000000000000000000e2), SC_(5.825595855712890625000000000000000000000e-1), SC_(4.872112979187464752840434925157900842994e-1), SC_(5.127887020812535247159565074842099157006e-1) }}, 
      {{ SC_(1.914548034667968750000000000000000000000e2), SC_(1.933693542480468750000000000000000000000e2), SC_(1.962219390869140625000000000000000000000e2), SC_(5.988277196884155273437500000000000000000e-1), SC_(4.862004736984283653761511521388617607171e-1), SC_(5.137995263015716346238488478611382392829e-1) }}, 
      {{ SC_(1.914548034667968750000000000000000000000e2), SC_(2.106002807617187500000000000000000000000e2), SC_(7.142335891723632812500000000000000000000), SC_(4.807908833026885986328125000000000000000e-1), SC_(5.004490290771490944743684582898450958628e-1), SC_(4.995509709228509055256315417101549041372e-1) }}, 
      {{ SC_(1.914548034667968750000000000000000000000e2), SC_(2.106002807617187500000000000000000000000e2), SC_(7.974770355224609375000000000000000000000e1), SC_(5.233548879623413085937500000000000000000e-1), SC_(4.987851305145870236031702064717919575453e-1), SC_(5.012148694854129763968297935282080424547e-1) }}, 
      {{ SC_(1.914548034667968750000000000000000000000e2), SC_(2.106002807617187500000000000000000000000e2), SC_(1.595857238769531250000000000000000000000e2), SC_(5.627818703651428222656250000000000000000e-1), SC_(4.973699679581935130246001045678219257234e-1), SC_(5.026300320418064869753998954321780742766e-1) }}, 
      {{ SC_(1.914548034667968750000000000000000000000e2), SC_(2.106002807617187500000000000000000000000e2), SC_(1.985762634277343750000000000000000000000e2), SC_(5.797619819641113281250000000000000000000e-1), SC_(4.968081345290152481973221341096233011977e-1), SC_(5.031918654709847518026778658903766988023e-1) }}, 
      {{ SC_(1.914548034667968750000000000000000000000e2), SC_(2.297457733154296875000000000000000000000e2), SC_(1.950807952880859375000000000000000000000e1), SC_(4.669163525104522705078125000000000000000e-1), SC_(5.015741844848916668906937582223171859269e-1), SC_(4.984258155151083331093062417776828140731e-1) }}, 
      {{ SC_(1.914548034667968750000000000000000000000e2), SC_(2.297457733154296875000000000000000000000e2), SC_(8.435225677490234375000000000000000000000e1), SC_(5.041444301605224609375000000000000000000e-1), SC_(5.000885655348983350528736262335454617116e-1), SC_(4.999114344651016649471263737664545382884e-1) }}, 
      {{ SC_(1.914548034667968750000000000000000000000e2), SC_(2.297457733154296875000000000000000000000e2), SC_(1.596211700439453125000000000000000000000e2), SC_(5.413359403610229492187500000000000000000e-1), SC_(4.987258350011313825652891581903252840735e-1), SC_(5.012741649988686174347108418096747159265e-1) }}, 
      {{ SC_(1.914548034667968750000000000000000000000e2), SC_(2.297457733154296875000000000000000000000e2), SC_(1.992922668457031250000000000000000000000e2), SC_(5.587815046310424804687500000000000000000e-1), SC_(4.981339717018360419057282207419525641307e-1), SC_(5.018660282981639580942717792580474358693e-1) }}, 
      {{ SC_(1.914548034667968750000000000000000000000e2), SC_(2.488912353515625000000000000000000000000e2), SC_(2.197235107421875000000000000000000000000e1), SC_(4.490621685981750488281250000000000000000e-1), SC_(5.103829198910775789574619733452534400340e-1), SC_(4.896170801089224210425380266547465599660e-1) }}, 
      {{ SC_(1.914548034667968750000000000000000000000e2), SC_(2.488912353515625000000000000000000000000e2), SC_(8.441753387451171875000000000000000000000e1), SC_(4.846436977386474609375000000000000000000e-1), SC_(5.084253480704127069277217218752567404221e-1), SC_(4.915746519295872930722782781247432595779e-1) }}, 
      {{ SC_(1.914548034667968750000000000000000000000e2), SC_(2.488912353515625000000000000000000000000e2), SC_(1.600560913085937500000000000000000000000e2), SC_(5.220437049865722656250000000000000000000e-1), SC_(5.066154465635958606907841119246002804117e-1), SC_(4.933845534364041393092158880753997195883e-1) }}, 
      {{ SC_(1.914548034667968750000000000000000000000e2), SC_(2.871821899414062500000000000000000000000e2), SC_(2.249290275573730468750000000000000000000e1), SC_(4.195514619350433349609375000000000000000e-1), SC_(6.030261013519089572735624199934393622371e-1), SC_(3.969738986480910427264375800065606377629e-1) }}, 
      {{ SC_(1.914548034667968750000000000000000000000e2), SC_(2.871821899414062500000000000000000000000e2), SC_(9.495173645019531250000000000000000000000e1), SC_(4.594552218914031982421875000000000000000e-1), SC_(5.938660644985190050412496861273887248358e-1), SC_(4.061339355014809949587503138726112751642e-1) }}, 
      {{ SC_(1.914548034667968750000000000000000000000e2), SC_(2.871821899414062500000000000000000000000e2), SC_(1.629447326660156250000000000000000000000e2), SC_(4.922194480895996093750000000000000000000e-1), SC_(5.879013679181315293187361682840045288135e-1), SC_(4.120986320818684706812638317159954711865e-1) }}, 
      {{ SC_(1.914548034667968750000000000000000000000e2), SC_(3.829096069335937500000000000000000000000e2), SC_(2.539736366271972656250000000000000000000e1), SC_(4.070271849632263183593750000000000000000e-1), SC_(9.981565433223774844055709037894261430976e-1), SC_(1.843456677622515594429096210573856902401e-3) }}, 
      {{ SC_(1.914548034667968750000000000000000000000e2), SC_(3.829096069335937500000000000000000000000e2), SC_(9.707512664794921875000000000000000000000e1), SC_(4.410947561264038085937500000000000000000e-1), SC_(9.963122616357876717907280310221121065256e-1), SC_(3.687738364212328209271968977887893474436e-3) }}, 
      {{ SC_(1.914548034667968750000000000000000000000e2), SC_(3.829096069335937500000000000000000000000e2), SC_(1.670017089843750000000000000000000000000e2), SC_(4.707627594470977783203125000000000000000e-1), SC_(9.943098531562429794660119846625877353672e-1), SC_(5.690146843757020533988015337412264632778e-3) }}, 
      {{ SC_(1.914548034667968750000000000000000000000e2), SC_(5.743643798828125000000000000000000000000e2), SC_(2.709540176391601562500000000000000000000e1), SC_(3.858506679534912109375000000000000000000e-1), SC_(9.999999999993526256468811554681980653084e-1), SC_(6.473743531188445318019346916419113080167e-13) }}, 
      {{ SC_(1.914548034667968750000000000000000000000e2), SC_(5.743643798828125000000000000000000000000e2), SC_(1.007325439453125000000000000000000000000e2), SC_(4.135240316390991210937500000000000000000e-1), SC_(9.999999999711541319726055527859648661643e-1), SC_(2.884586802739444721403513383568728378116e-11) }}, 
      {{ SC_(1.914548034667968750000000000000000000000e2), SC_(5.743643798828125000000000000000000000000e2), SC_(1.698258666992187500000000000000000000000e2), SC_(4.373162686824798583984375000000000000000e-1), SC_(9.999999997130949756223186372064430547015e-1), SC_(2.869050243776813627935569452984621898652e-10) }}, 
      {{ SC_(1.914548034667968750000000000000000000000e2), SC_(7.658192138671875000000000000000000000000e2), SC_(2.837726783752441406250000000000000000000e1), SC_(3.935942053794860839843750000000000000000e-1), SC_(9.999999999999999999999999999999908336887e-1), SC_(9.166311312871321945141380546217710323711e-33) }}, 
      {{ SC_(1.914548034667968750000000000000000000000e2), SC_(7.658192138671875000000000000000000000000e2), SC_(1.093762969970703125000000000000000000000e2), SC_(4.178406894207000732421875000000000000000e-1), SC_(9.999999999999999999999999996601293596640e-1), SC_(3.398706403359843891439883861127291754796e-28) }}, 
      {{ SC_(1.914548034667968750000000000000000000000e2), SC_(7.658192138671875000000000000000000000000e2), SC_(1.756861267089843750000000000000000000000e2), SC_(4.362936913967132568359375000000000000000e-1), SC_(9.999999999999999999999999094649590415443e-1), SC_(9.053504095845568224190077033287530220608e-26) }}, 
      {{ SC_(1.914548034667968750000000000000000000000e2), SC_(9.572740478515625000000000000000000000000e2), SC_(3.152261734008789062500000000000000000000e1), SC_(4.519574940204620361328125000000000000000e-1), SC_(1.000000000000000000000000000000000000000), SC_(1.876931654902788811732776921970647579974e-83) }}, 
      {{ SC_(1.914548034667968750000000000000000000000e2), SC_(9.572740478515625000000000000000000000000e2), SC_(1.094441146850585937500000000000000000000e2), SC_(4.696860313415527343750000000000000000000e-1), SC_(1.000000000000000000000000000000000000000), SC_(1.675901116919480178807058687658567665309e-73) }}, 
      {{ SC_(1.914548034667968750000000000000000000000e2), SC_(9.572740478515625000000000000000000000000e2), SC_(1.811583862304687500000000000000000000000e2), SC_(4.850188195705413818359375000000000000000e-1), SC_(1.000000000000000000000000000000000000000), SC_(1.853160481442819646577297244790643330532e-67) }}, 
      {{ SC_(1.915226135253906250000000000000000000000e2), SC_(1.915226173400878906250000000000000000000e1), SC_(2.709540176391601562500000000000000000000e1), SC_(9.572803378105163574218750000000000000000e-1), SC_(9.967459494477729793655185204363636530589e-1), SC_(3.254050552227020634481479563636346941148e-3) }}, 
      {{ SC_(1.915226135253906250000000000000000000000e2), SC_(1.915226173400878906250000000000000000000e1), SC_(1.007325439453125000000000000000000000000e2), SC_(9.632885456085205078125000000000000000000e-1), SC_(9.965227001689587948824853278235778806172e-1), SC_(3.477299831041205117514672176422119382845e-3) }}, 
      {{ SC_(1.915226135253906250000000000000000000000e2), SC_(1.915226173400878906250000000000000000000e1), SC_(1.698258666992187500000000000000000000000e2), SC_(9.675716161727905273437500000000000000000e-1), SC_(9.963806875572768448682202240637289173246e-1), SC_(3.619312442723155131779775936271082675352e-3) }}, 
      {{ SC_(1.915226135253906250000000000000000000000e2), SC_(4.788065338134765625000000000000000000000e1), SC_(2.837726783752441406250000000000000000000e1), SC_(9.370495080947875976562500000000000000000e-1), SC_(9.999999999901020233157008181959642962239e-1), SC_(9.897976684299181804035703776137044754191e-12) }}, 
      {{ SC_(1.915226135253906250000000000000000000000e2), SC_(4.788065338134765625000000000000000000000e1), SC_(1.093762969970703125000000000000000000000e2), SC_(9.456961154937744140625000000000000000000e-1), SC_(9.999999999815681741277203251463600907327e-1), SC_(1.843182587227967485363990926726611677975e-11) }}, 
      {{ SC_(1.915226135253906250000000000000000000000e2), SC_(4.788065338134765625000000000000000000000e1), SC_(1.756861267089843750000000000000000000000e2), SC_(9.511887431144714355468750000000000000000e-1), SC_(9.999999999744666448116090989150081412469e-1), SC_(2.553335518839090108499185875309059456555e-11) }}, 
      {{ SC_(1.915226135253906250000000000000000000000e2), SC_(9.576130676269531250000000000000000000000e1), SC_(3.152261734008789062500000000000000000000e1), SC_(9.209872484207153320312500000000000000000e-1), SC_(9.999999999999999999999999999999871983784e-1), SC_(1.280162158800570326448481254838325139038e-32) }}, 
      {{ SC_(1.915226135253906250000000000000000000000e2), SC_(9.576130676269531250000000000000000000000e1), SC_(1.094441146850585937500000000000000000000e2), SC_(9.299675226211547851562500000000000000000e-1), SC_(9.999999999999999999999999999998484111907e-1), SC_(1.515888092553010700226697757865014454818e-31) }}, 
      {{ SC_(1.915226135253906250000000000000000000000e2), SC_(9.576130676269531250000000000000000000000e1), SC_(1.811583862304687500000000000000000000000e2), SC_(9.366026520729064941406250000000000000000e-1), SC_(9.999999999999999999999999999993396582287e-1), SC_(6.603417713497002294104731476551533388632e-31) }}, 
      {{ SC_(1.915226135253906250000000000000000000000e2), SC_(1.436419677734375000000000000000000000000e2), SC_(3.423733520507812500000000000000000000000e1), SC_(9.184396266937255859375000000000000000000e-1), SC_(1.000000000000000000000000000000000000000), SC_(4.575049691832965249117880655007595061682e-62) }}, 
      {{ SC_(1.915226135253906250000000000000000000000e2), SC_(1.436419677734375000000000000000000000000e2), SC_(1.264718551635742187500000000000000000000e2), SC_(9.278619289398193359375000000000000000000e-1), SC_(1.000000000000000000000000000000000000000), SC_(1.887210507559917589827493186499807394781e-59) }}, 
      {{ SC_(1.915226135253906250000000000000000000000e2), SC_(1.436419677734375000000000000000000000000e2), SC_(1.826751708984375000000000000000000000000e2), SC_(9.326080083847045898437500000000000000000e-1), SC_(1.000000000000000000000000000000000000000), SC_(2.109867144570236638518506880190176246047e-58) }}, 
      {{ SC_(1.915226135253906250000000000000000000000e2), SC_(1.723703460693359375000000000000000000000e2), SC_(3.477303314208984375000000000000000000000e1), SC_(5.478619411587715148925781250000000000000e-2), SC_(1.278360136808086137572060005243603424145e-145), SC_(1.000000000000000000000000000000000000000) }}, 
      {{ SC_(1.915226135253906250000000000000000000000e2), SC_(1.723703460693359375000000000000000000000e2), SC_(1.279526672363281250000000000000000000000e2), SC_(5.970017239451408386230468750000000000000e-2), SC_(9.113036200140252135665775531164698085950e-157), SC_(1.000000000000000000000000000000000000000) }}, 
      {{ SC_(1.915226135253906250000000000000000000000e2), SC_(1.723703460693359375000000000000000000000e2), SC_(1.831471099853515625000000000000000000000e2), SC_(6.213850528001785278320312500000000000000e-2), SC_(4.127505516864149493224144252207621590632e-164), SC_(1.000000000000000000000000000000000000000) }}, 
      {{ SC_(1.915226135253906250000000000000000000000e2), SC_(1.896073913574218750000000000000000000000e2), SC_(3.767639541625976562500000000000000000000e1), SC_(1.314720064401626586914062500000000000000e-1), SC_(5.382123816995328776483388654688765571794e-74), SC_(1.000000000000000000000000000000000000000) }}, 
      {{ SC_(1.915226135253906250000000000000000000000e2), SC_(1.896073913574218750000000000000000000000e2), SC_(1.310955810546875000000000000000000000000e2), SC_(1.438442468643188476562500000000000000000e-1), SC_(3.687720857169455117118277212910701098618e-82), SC_(1.000000000000000000000000000000000000000) }}, 
      {{ SC_(1.915226135253906250000000000000000000000e2), SC_(1.896073913574218750000000000000000000000e2), SC_(1.867986450195312500000000000000000000000e2), SC_(1.500662267208099365234375000000000000000e-1), SC_(1.384697361828017015530790958686701736777e-87), SC_(1.000000000000000000000000000000000000000) }}, 
      {{ SC_(1.915226135253906250000000000000000000000e2), SC_(1.913311004638671875000000000000000000000e2), SC_(4.238486480712890625000000000000000000000e1), SC_(2.632004022598266601562500000000000000000e-1), SC_(1.018250146021720794707423440868790225691e-27), SC_(9.999999999999999999999999989817498539783e-1) }}, 
      {{ SC_(1.915226135253906250000000000000000000000e2), SC_(1.913311004638671875000000000000000000000e2), SC_(1.311481323242187500000000000000000000000e2), SC_(2.865949571132659912109375000000000000000e-1), SC_(9.313749657125893315232294813318208044897e-32), SC_(9.999999999999999999999999999999068625034e-1) }}, 
      {{ SC_(1.915226135253906250000000000000000000000e2), SC_(1.913311004638671875000000000000000000000e2), SC_(1.914333953857421875000000000000000000000e2), SC_(3.000178635120391845703125000000000000000e-1), SC_(8.160813238621691866761926077817156669015e-35), SC_(9.999999999999999999999999999999999183919e-1) }}, 
      {{ SC_(1.915226135253906250000000000000000000000e2), SC_(1.915226135253906250000000000000000000000e2), SC_(4.420680999755859375000000000000000000000e1), SC_(3.954108357429504394531250000000000000000e-1), SC_(9.735248811166686459832315994793078799392e-8), SC_(9.999999026475118883331354016768400520692e-1) }}, 
      {{ SC_(1.915226135253906250000000000000000000000e2), SC_(1.915226135253906250000000000000000000000e2), SC_(1.357470245361328125000000000000000000000e2), SC_(4.313396811485290527343750000000000000000e-1), SC_(4.860213113801580999685972348061636003270e-9), SC_(9.999999951397868861984190003140276519384e-1) }}, 
      {{ SC_(1.915226135253906250000000000000000000000e2), SC_(1.915226135253906250000000000000000000000e2), SC_(1.915013732910156250000000000000000000000e2), SC_(4.498680531978607177734375000000000000000e-1), SC_(6.270355555551768624951512882166373821052e-10), SC_(9.999999993729644444448231375048487117834e-1) }}, 
      {{ SC_(1.915226135253906250000000000000000000000e2), SC_(1.915417633056640625000000000000000000000e2), SC_(5.569964599609375000000000000000000000000e1), SC_(4.804086685180664062500000000000000000000e-1), SC_(1.784428959618809981520934737757382743139e-2), SC_(9.821557104038119001847906526224261725686e-1) }}, 
      {{ SC_(1.915226135253906250000000000000000000000e2), SC_(1.915417633056640625000000000000000000000e2), SC_(1.362719116210937500000000000000000000000e2), SC_(5.178077220916748046875000000000000000000e-1), SC_(1.019935235648183844716446180073133415679e-2), SC_(9.898006476435181615528355381992686658432e-1) }}, 
      {{ SC_(1.915226135253906250000000000000000000000e2), SC_(1.915417633056640625000000000000000000000e2), SC_(1.918984832763671875000000000000000000000e2), SC_(5.399691462516784667968750000000000000000e-1), SC_(6.648842079769746152174241504454528489475e-3), SC_(9.933511579202302538478257584955454715105e-1) }}, 
      {{ SC_(1.915226135253906250000000000000000000000e2), SC_(1.917141418457031250000000000000000000000e2), SC_(5.940588760375976562500000000000000000000e1), SC_(5.302959680557250976562500000000000000000e-1), SC_(4.148618734374563033176801676609255259345e-1), SC_(5.851381265625436966823198323390744740655e-1) }}, 
      {{ SC_(1.915226135253906250000000000000000000000e2), SC_(1.917141418457031250000000000000000000000e2), SC_(1.451677856445312500000000000000000000000e2), SC_(5.734692811965942382812500000000000000000e-1), SC_(4.035197600567718710488116687793936585053e-1), SC_(5.964802399432281289511883312206063414947e-1) }}, 
      {{ SC_(1.915226135253906250000000000000000000000e2), SC_(1.917141418457031250000000000000000000000e2), SC_(1.929777069091796875000000000000000000000e2), SC_(5.941975116729736328125000000000000000000e-1), SC_(3.971669829448375454045586227882545593741e-1), SC_(6.028330170551624545954413772117454406259e-1) }}, 
      {{ SC_(1.915226135253906250000000000000000000000e2), SC_(1.934378356933593750000000000000000000000e2), SC_(6.038262176513671875000000000000000000000e1), SC_(5.334395766258239746093750000000000000000e-1), SC_(4.901752688406924613716172575420645632919e-1), SC_(5.098247311593075386283827424579354367081e-1) }}, 
      {{ SC_(1.915226135253906250000000000000000000000e2), SC_(1.934378356933593750000000000000000000000e2), SC_(1.481294555664062500000000000000000000000e2), SC_(5.778633356094360351562500000000000000000e-1), SC_(4.874983763915470114363732212960021362135e-1), SC_(5.125016236084529885636267787039978637865e-1) }}, 
      {{ SC_(1.915226135253906250000000000000000000000e2), SC_(1.934378356933593750000000000000000000000e2), SC_(1.935389862060546875000000000000000000000e2), SC_(5.976859927177429199218750000000000000000e-1), SC_(4.862711951470073252204211584030924746496e-1), SC_(5.137288048529926747795788415969075253504e-1) }}, 
      {{ SC_(1.915226135253906250000000000000000000000e2), SC_(2.106748809814453125000000000000000000000e2), SC_(6.163340759277343750000000000000000000000e1), SC_(5.133889317512512207031250000000000000000e-1), SC_(4.991648263900566287697841903790786071011e-1), SC_(5.008351736099433712302158096209213928989e-1) }}, 
      {{ SC_(1.915226135253906250000000000000000000000e2), SC_(2.106748809814453125000000000000000000000e2), SC_(1.486264953613281250000000000000000000000e2), SC_(5.577353835105895996093750000000000000000e-1), SC_(4.975426596231888878170474086394599860779e-1), SC_(5.024573403768111121829525913605400139221e-1) }}, 
      {{ SC_(1.915226135253906250000000000000000000000e2), SC_(2.106748809814453125000000000000000000000e2), SC_(1.937735595703125000000000000000000000000e2), SC_(5.777129530906677246093750000000000000000e-1), SC_(4.968751803459962670544449506566023612980e-1), SC_(5.031248196540037329455550493433976387020e-1) }}, 
      {{ SC_(1.915226135253906250000000000000000000000e2), SC_(2.298271484375000000000000000000000000000e2), SC_(7.225879669189453125000000000000000000000e1), SC_(4.975862205028533935546875000000000000000e-1), SC_(5.003431072522842969585020057506336690150e-1), SC_(4.996568927477157030414979942493663309850e-1) }}, 
      {{ SC_(1.915226135253906250000000000000000000000e2), SC_(2.298271484375000000000000000000000000000e2), SC_(1.515480346679687500000000000000000000000e2), SC_(5.375908017158508300781250000000000000000e-1), SC_(4.988569441662882645472838247914119534104e-1), SC_(5.011430558337117354527161752085880465896e-1) }}, 
      {{ SC_(1.915226135253906250000000000000000000000e2), SC_(2.298271484375000000000000000000000000000e2), SC_(1.941185607910156250000000000000000000000e2), SC_(5.565525889396667480468750000000000000000e-1), SC_(4.982093080422022432574168214649129555601e-1), SC_(5.017906919577977567425831785350870444399e-1) }}, 
      {{ SC_(1.915226135253906250000000000000000000000e2), SC_(2.489793853759765625000000000000000000000e2), SC_(9.566968083381652832031250000000000000000e-1), SC_(4.359584152698516845703125000000000000000e-1), SC_(5.111606579894996160993639029895531089392e-1), SC_(4.888393420105003839006360970104468910608e-1) }}, 
      {{ SC_(1.915226135253906250000000000000000000000e2), SC_(2.489793853759765625000000000000000000000e2), SC_(7.844540405273437500000000000000000000000e1), SC_(4.814254045486450195312500000000000000000e-1), SC_(5.085945047902334505377019470517507642429e-1), SC_(4.914054952097665494622980529482492357571e-1) }}, 
      {{ SC_(1.915226135253906250000000000000000000000e2), SC_(2.489793853759765625000000000000000000000e2), SC_(1.584414672851562500000000000000000000000e2), SC_(5.212762951850891113281250000000000000000e-1), SC_(5.066520393732185821576113199083233419544e-1), SC_(4.933479606267814178423886800916766580456e-1) }}, 
      {{ SC_(1.915226135253906250000000000000000000000e2), SC_(2.489793853759765625000000000000000000000e2), SC_(1.962219390869140625000000000000000000000e2), SC_(5.380453467369079589843750000000000000000e-1), SC_(5.059168267145105514236878554158209247204e-1), SC_(4.940831732854894485763121445841790752796e-1) }}, 
      {{ SC_(1.915226135253906250000000000000000000000e2), SC_(2.872839355468750000000000000000000000000e2), SC_(7.142335891723632812500000000000000000000), SC_(4.103294909000396728515625000000000000000e-1), SC_(6.055479890318672896528882713180573710843e-1), SC_(3.944520109681327103471117286819426289157e-1) }}, 
      {{ SC_(1.915226135253906250000000000000000000000e2), SC_(2.872839355468750000000000000000000000000e2), SC_(7.974770355224609375000000000000000000000e1), SC_(4.515279531478881835937500000000000000000e-1), SC_(5.955142517796549689875488794402174136342e-1), SC_(4.044857482203450310124511205597825863658e-1) }}, 
      {{ SC_(1.915226135253906250000000000000000000000e2), SC_(2.872839355468750000000000000000000000000e2), SC_(1.595857238769531250000000000000000000000e2), SC_(4.906684756278991699218750000000000000000e-1), SC_(5.881735087235163957532831586839526248550e-1), SC_(4.118264912764836042467168413160473751450e-1) }}, 
      {{ SC_(1.915226135253906250000000000000000000000e2), SC_(2.872839355468750000000000000000000000000e2), SC_(1.985762634277343750000000000000000000000e2), SC_(5.078244805335998535156250000000000000000e-1), SC_(5.854520920517211219462808106042437326165e-1), SC_(4.145479079482788780537191893957562673835e-1) }}, 
      {{ SC_(1.915226135253906250000000000000000000000e2), SC_(3.830452270507812500000000000000000000000e2), SC_(1.950807952880859375000000000000000000000e1), SC_(4.040393233299255371093750000000000000000e-1), SC_(9.982928900467757301227695095133083489799e-1), SC_(1.707109953224269877230490486691651020113e-3) }}, 
      {{ SC_(1.915226135253906250000000000000000000000e2), SC_(3.830452270507812500000000000000000000000e2), SC_(8.435225677490234375000000000000000000000e1), SC_(4.353223443031311035156250000000000000000e-1), SC_(9.966678975599993906856035539393146622797e-1), SC_(3.332102440000609314396446060685337720349e-3) }}, 
      {{ SC_(1.915226135253906250000000000000000000000e2), SC_(3.830452270507812500000000000000000000000e2), SC_(1.596211700439453125000000000000000000000e2), SC_(4.677577912807464599609375000000000000000e-1), SC_(9.945330618139075698544375696728298181369e-1), SC_(5.466938186092430145562430327170181863124e-3) }}, 
      {{ SC_(1.915226135253906250000000000000000000000e2), SC_(3.830452270507812500000000000000000000000e2), SC_(1.992922668457031250000000000000000000000e2), SC_(4.833995103836059570312500000000000000000e-1), SC_(9.933819743968650171955502779170030372508e-1), SC_(6.618025603134982804449722082996962749190e-3) }}, 
      {{ SC_(1.915226135253906250000000000000000000000e2), SC_(5.745678710937500000000000000000000000000e2), SC_(2.197235107421875000000000000000000000000e1), SC_(3.838249444961547851562500000000000000000e-1), SC_(9.999999999995480294370637590392816111558e-1), SC_(4.519705629362409607183888442442582171986e-13) }}, 
      {{ SC_(1.915226135253906250000000000000000000000e2), SC_(5.745678710937500000000000000000000000000e2), SC_(8.441753387451171875000000000000000000000e1), SC_(4.075987637042999267578125000000000000000e-1), SC_(9.999999999856166722710432289648300617436e-1), SC_(1.438332772895677103516993825643899190781e-11) }}, 
      {{ SC_(1.915226135253906250000000000000000000000e2), SC_(5.745678710937500000000000000000000000000e2), SC_(1.600560913085937500000000000000000000000e2), SC_(4.340508282184600830078125000000000000000e-1), SC_(9.999999997843397037492123244757095047695e-1), SC_(2.156602962507876755242904952305260816308e-10) }}, 
      {{ SC_(1.915226135253906250000000000000000000000e2), SC_(7.660904541015625000000000000000000000000e2), SC_(2.249290275573730468750000000000000000000e1), SC_(3.917514085769653320312500000000000000000e-1), SC_(9.999999999999999999999999999999968290319e-1), SC_(3.170968091272018941838978671793305284719e-33) }}, 
      {{ SC_(1.915226135253906250000000000000000000000e2), SC_(7.660904541015625000000000000000000000000e2), SC_(9.495173645019531250000000000000000000000e1), SC_(4.136558175086975097656250000000000000000e-1), SC_(9.999999999999999999999999999257807023153e-1), SC_(7.421929768466780913846069804151302438277e-29) }}, 
      {{ SC_(1.915226135253906250000000000000000000000e2), SC_(7.660904541015625000000000000000000000000e2), SC_(1.629447326660156250000000000000000000000e2), SC_(4.328235089778900146484375000000000000000e-1), SC_(9.999999999999999999999999653884397818454e-1), SC_(3.461156021815458394680926120940275032176e-26) }}, 
      {{ SC_(1.915226135253906250000000000000000000000e2), SC_(9.576130371093750000000000000000000000000e2), SC_(2.539736366271972656250000000000000000000e1), SC_(4.505114257335662841796875000000000000000e-1), SC_(1.000000000000000000000000000000000000000), SC_(1.577068266464517121605809729104889118849e-84) }}, 
      {{ SC_(1.915226135253906250000000000000000000000e2), SC_(9.576130371093750000000000000000000000000e2), SC_(9.707512664794921875000000000000000000000e1), SC_(4.669411480426788330078125000000000000000e-1), SC_(1.000000000000000000000000000000000000000), SC_(8.280505798451449791692321580195541411450e-75) }}, 
      {{ SC_(1.915226135253906250000000000000000000000e2), SC_(9.576130371093750000000000000000000000000e2), SC_(1.670017089843750000000000000000000000000e2), SC_(4.820502400398254394531250000000000000000e-1), SC_(1.000000000000000000000000000000000000000), SC_(1.576090736871312455446303836477534164427e-68) }}, 
      {{ SC_(1.919187469482421875000000000000000000000e2), SC_(1.919187545776367187500000000000000000000e1), SC_(2.197235107421875000000000000000000000000e1), SC_(9.567842483520507812500000000000000000000e-1), SC_(9.967944560238842911822012468190493244196e-1), SC_(3.205543976115708817798753180950675580356e-3) }}, 
      {{ SC_(1.919187469482421875000000000000000000000e2), SC_(1.919187545776367187500000000000000000000e1), SC_(8.441753387451171875000000000000000000000e1), SC_(9.620943069458007812500000000000000000000e-1), SC_(9.965952245810590573311622620924777909253e-1), SC_(3.404775418940942668837737907522209074717e-3) }}, 
      {{ SC_(1.919187469482421875000000000000000000000e2), SC_(1.919187545776367187500000000000000000000e1), SC_(1.600560913085937500000000000000000000000e2), SC_(9.670088291168212890625000000000000000000e-1), SC_(9.964299579581572394744951403325930967949e-1), SC_(3.570042041842760525504859667406903205079e-3) }}, 
      {{ SC_(1.919187469482421875000000000000000000000e2), SC_(4.797968673706054687500000000000000000000e1), SC_(2.249290275573730468750000000000000000000e1), SC_(9.363073706626892089843750000000000000000e-1), SC_(9.999999999911211421686283957921374229257e-1), SC_(8.878857831371604207862577074319630326623e-12) }}, 
      {{ SC_(1.919187469482421875000000000000000000000e2), SC_(4.797968673706054687500000000000000000000e1), SC_(9.495173645019531250000000000000000000000e1), SC_(9.443150758743286132812500000000000000000e-1), SC_(9.999999999839269578401121472881512325785e-1), SC_(1.607304215988785271184876742147558575977e-11) }}, 
      {{ SC_(1.919187469482421875000000000000000000000e2), SC_(4.797968673706054687500000000000000000000e1), SC_(1.629447326660156250000000000000000000000e2), SC_(9.501950740814208984375000000000000000000e-1), SC_(9.999999999769362759909934584248209554365e-1), SC_(2.306372400900654157517904456352515931966e-11) }}, 
      {{ SC_(1.919187469482421875000000000000000000000e2), SC_(9.595937347412109375000000000000000000000e1), SC_(2.539736366271972656250000000000000000000e1), SC_(9.201760888099670410156250000000000000000e-1), SC_(9.999999999999999999999999999999914522255e-1), SC_(8.547774512509825615145108085779846586768e-33) }}, 
      {{ SC_(1.919187469482421875000000000000000000000e2), SC_(9.595937347412109375000000000000000000000e1), SC_(9.707512664794921875000000000000000000000e1), SC_(9.286593198776245117187500000000000000000e-1), SC_(9.999999999999999999999999999999047356117e-1), SC_(9.526438829828555244724762541089548290810e-32) }}, 
      {{ SC_(1.919187469482421875000000000000000000000e2), SC_(9.595937347412109375000000000000000000000e1), SC_(1.670017089843750000000000000000000000000e2), SC_(9.353642463684082031250000000000000000000e-1), SC_(9.999999999999999999999999999995549177624e-1), SC_(4.450822375932106789952360185405177829424e-31) }}, 
      {{ SC_(1.919187469482421875000000000000000000000e2), SC_(1.439390563964843750000000000000000000000e2), SC_(2.709540176391601562500000000000000000000e1), SC_(9.176000356674194335937500000000000000000e-1), SC_(1.000000000000000000000000000000000000000), SC_(1.809388451205498688084932597936672272559e-62) }}, 
      {{ SC_(1.919187469482421875000000000000000000000e2), SC_(1.439390563964843750000000000000000000000e2), SC_(1.007325439453125000000000000000000000000e2), SC_(9.254382848739624023437500000000000000000e-1), SC_(1.000000000000000000000000000000000000000), SC_(3.622045621999010435218206909917631417829e-60) }}, 
      {{ SC_(1.919187469482421875000000000000000000000e2), SC_(1.439390563964843750000000000000000000000e2), SC_(1.698258666992187500000000000000000000000e2), SC_(9.315503239631652832031250000000000000000e-1), SC_(1.000000000000000000000000000000000000000), SC_(9.682208859669398252539830159719803061144e-59) }}, 
      {{ SC_(1.919187469482421875000000000000000000000e2), SC_(1.727268676757812500000000000000000000000e2), SC_(2.837726783752441406250000000000000000000e1), SC_(5.440118536353111267089843750000000000000e-2), SC_(3.217317427888949670635062525149263727824e-145), SC_(1.000000000000000000000000000000000000000) }}, 
      {{ SC_(1.919187469482421875000000000000000000000e2), SC_(1.727268676757812500000000000000000000000e2), SC_(1.093762969970703125000000000000000000000e2), SC_(5.879640579223632812500000000000000000000e-2), SC_(1.088044558480624071562867824365284953432e-154), SC_(1.000000000000000000000000000000000000000) }}, 
      {{ SC_(1.919187469482421875000000000000000000000e2), SC_(1.727268676757812500000000000000000000000e2), SC_(1.756861267089843750000000000000000000000e2), SC_(6.181098148226737976074218750000000000000e-2), SC_(2.240586901730431526985950837231018585360e-163), SC_(1.000000000000000000000000000000000000000) }}, 
      {{ SC_(1.919187469482421875000000000000000000000e2), SC_(1.899995574951171875000000000000000000000e2), SC_(3.152261734008789062500000000000000000000e1), SC_(1.305454969406127929687500000000000000000e-1), SC_(1.181586045457319315560327951477565757404e-73), SC_(1.000000000000000000000000000000000000000) }}, 
      {{ SC_(1.919187469482421875000000000000000000000e2), SC_(1.899995574951171875000000000000000000000e2), SC_(1.094441146850585937500000000000000000000e2), SC_(1.411838531494140625000000000000000000000e-1), SC_(2.728833882356961469499563974435766875701e-80), SC_(1.000000000000000000000000000000000000000) }}, 
      {{ SC_(1.919187469482421875000000000000000000000e2), SC_(1.899995574951171875000000000000000000000e2), SC_(1.811583862304687500000000000000000000000e2), SC_(1.494298130273818969726562500000000000000e-1), SC_(3.693601908224172089412296431430319342309e-87), SC_(1.000000000000000000000000000000000000000) }}, 
      {{ SC_(1.919187469482421875000000000000000000000e2), SC_(1.917268371582031250000000000000000000000e2), SC_(3.423733520507812500000000000000000000000e1), SC_(2.607729732990264892578125000000000000000e-1), SC_(1.966668902747142323186760000847042606894e-27), SC_(9.999999999999999999999999980333310972529e-1) }}, 
      {{ SC_(1.919187469482421875000000000000000000000e2), SC_(1.917268371582031250000000000000000000000e2), SC_(1.264718551635742187500000000000000000000e2), SC_(2.854156494140625000000000000000000000000e-1), SC_(1.407459019632273834418662945071753719436e-31), SC_(9.999999999999999999999999999998592540980e-1) }}, 
      {{ SC_(1.919187469482421875000000000000000000000e2), SC_(1.917268371582031250000000000000000000000e2), SC_(1.826751708984375000000000000000000000000e2), SC_(2.980934083461761474609375000000000000000e-1), SC_(2.097076922274570208968824509015818137451e-34), SC_(9.999999999999999999999999999999997902923e-1) }}, 
      {{ SC_(1.919187469482421875000000000000000000000e2), SC_(1.919187469482421875000000000000000000000e2), SC_(3.477303314208984375000000000000000000000e1), SC_(3.912113904953002929687500000000000000000e-1), SC_(1.252116510372723395015164236549082502780e-7), SC_(9.999998747883489627276604984835763450917e-1) }}, 
      {{ SC_(1.919187469482421875000000000000000000000e2), SC_(1.919187469482421875000000000000000000000e2), SC_(1.279526672363281250000000000000000000000e2), SC_(4.284713566303253173828125000000000000000e-1), SC_(6.233245053453233993432337085493971845343e-9), SC_(9.999999937667549465467660065676629145060e-1) }}, 
      {{ SC_(1.919187469482421875000000000000000000000e2), SC_(1.919187469482421875000000000000000000000e2), SC_(1.831471099853515625000000000000000000000e2), SC_(4.471096992492675781250000000000000000000e-1), SC_(8.397045520753459040535466401326041507221e-10), SC_(9.999999991602954479246540959464533598674e-1) }}, 
      {{ SC_(1.919187469482421875000000000000000000000e2), SC_(1.919379425048828125000000000000000000000e2), SC_(3.767639541625976562500000000000000000000e1), SC_(4.709798395633697509765625000000000000000e-1), SC_(1.990187353698504281136970849693112102668e-2), SC_(9.800981264630149571886302915030688789733e-1) }}, 
      {{ SC_(1.919187469482421875000000000000000000000e2), SC_(1.919379425048828125000000000000000000000e2), SC_(1.310955810546875000000000000000000000000e2), SC_(5.154906511306762695312500000000000000000e-1), SC_(1.055100945239054755165950463623104416712e-2), SC_(9.894489905476094524483404953637689558329e-1) }}, 
      {{ SC_(1.919187469482421875000000000000000000000e2), SC_(1.919379425048828125000000000000000000000e2), SC_(1.867986450195312500000000000000000000000e2), SC_(5.378987789154052734375000000000000000000e-1), SC_(6.896173351668546441771640395586108146021e-3), SC_(9.931038266483314535582283596044138918540e-1) }}, 
      {{ SC_(1.919187469482421875000000000000000000000e2), SC_(1.921106719970703125000000000000000000000e2), SC_(4.238486480712890625000000000000000000000e1), SC_(5.205926895141601562500000000000000000000e-1), SC_(4.170102975788307022368490528641819155671e-1), SC_(5.829897024211692977631509471358180844329e-1) }}, 
      {{ SC_(1.919187469482421875000000000000000000000e2), SC_(1.921106719970703125000000000000000000000e2), SC_(1.311481323242187500000000000000000000000e2), SC_(5.668465495109558105468750000000000000000e-1), SC_(4.053273501172242816799284624969247237881e-1), SC_(5.946726498827757183200715375030752762119e-1) }}, 
      {{ SC_(1.919187469482421875000000000000000000000e2), SC_(1.921106719970703125000000000000000000000e2), SC_(1.914333953857421875000000000000000000000e2), SC_(5.933972001075744628906250000000000000000e-1), SC_(3.973288290113555460227420663190454695241e-1), SC_(6.026711709886444539772579336809545304759e-1) }}, 
      {{ SC_(1.919187469482421875000000000000000000000e2), SC_(1.938379364013671875000000000000000000000e2), SC_(4.420680999755859375000000000000000000000e1), SC_(5.241562128067016601562500000000000000000e-1), SC_(4.907138857239889102792564392333483765022e-1), SC_(5.092861142760110897207435607666516234978e-1) }}, 
      {{ SC_(1.919187469482421875000000000000000000000e2), SC_(1.938379364013671875000000000000000000000e2), SC_(1.357470245361328125000000000000000000000e2), SC_(5.719826221466064453125000000000000000000e-1), SC_(4.878513739389363511893687100533684918141e-1), SC_(5.121486260610636488106312899466315081859e-1) }}, 
      {{ SC_(1.919187469482421875000000000000000000000e2), SC_(1.938379364013671875000000000000000000000e2), SC_(1.915013732910156250000000000000000000000e2), SC_(5.966716408729553222656250000000000000000e-1), SC_(4.863279202540999995445782463570361406186e-1), SC_(5.136720797459000004554217536429638593814e-1) }}, 
      {{ SC_(1.919187469482421875000000000000000000000e2), SC_(2.111106262207031250000000000000000000000e2), SC_(5.569964599609375000000000000000000000000e1), SC_(5.099733471870422363281250000000000000000e-1), SC_(4.992973971879435575570341465545901417326e-1), SC_(5.007026028120564424429658534454098582674e-1) }}, 
      {{ SC_(1.919187469482421875000000000000000000000e2), SC_(2.111106262207031250000000000000000000000e2), SC_(1.362719116210937500000000000000000000000e2), SC_(5.518018603324890136718750000000000000000e-1), SC_(4.977514236221131903806390187095697329946e-1), SC_(5.022485763778868096193609812904302670054e-1) }}, 
      {{ SC_(1.919187469482421875000000000000000000000e2), SC_(2.111106262207031250000000000000000000000e2), SC_(1.918984832763671875000000000000000000000e2), SC_(5.767514109611511230468750000000000000000e-1), SC_(4.969090513815989022388891267919586391249e-1), SC_(5.030909486184010977611108732080413608751e-1) }}, 
      {{ SC_(1.919187469482421875000000000000000000000e2), SC_(2.303025054931640625000000000000000000000e2), SC_(5.940588760375976562500000000000000000000e1), SC_(4.903725683689117431640625000000000000000e-1), SC_(5.006278551026225374017842473023023547315e-1), SC_(4.993721448973774625982157526976976452685e-1) }}, 
      {{ SC_(1.919187469482421875000000000000000000000e2), SC_(2.303025054931640625000000000000000000000e2), SC_(1.451677856445312500000000000000000000000e2), SC_(5.344677567481994628906250000000000000000e-1), SC_(4.989691170654759912465103753650716439421e-1), SC_(5.010308829345240087534896246349283560579e-1) }}, 
      {{ SC_(1.919187469482421875000000000000000000000e2), SC_(2.303025054931640625000000000000000000000e2), SC_(1.929777069091796875000000000000000000000e2), SC_(5.558943748474121093750000000000000000000e-1), SC_(4.982334928971185133569805368886236715403e-1), SC_(5.017665071028814866430194631113763284597e-1) }}, 
      {{ SC_(1.919187469482421875000000000000000000000e2), SC_(2.494943695068359375000000000000000000000e2), SC_(6.038262176513671875000000000000000000000e1), SC_(4.714236557483673095703125000000000000000e-1), SC_(5.091365146361032473676433041025718450057e-1), SC_(4.908634853638967526323566958974281549943e-1) }}, 
      {{ SC_(1.919187469482421875000000000000000000000e2), SC_(2.494943695068359375000000000000000000000e2), SC_(1.481294555664062500000000000000000000000e2), SC_(5.163427591323852539062500000000000000000e-1), SC_(5.068869804056491673102976278599165543789e-1), SC_(4.931130195943508326897023721400834456211e-1) }}, 
      {{ SC_(1.919187469482421875000000000000000000000e2), SC_(2.494943695068359375000000000000000000000e2), SC_(1.935389862060546875000000000000000000000e2), SC_(5.367215871810913085937500000000000000000e-1), SC_(5.059836947880482418376375435641666105131e-1), SC_(4.940163052119517581623624564358333894869e-1) }}, 
      {{ SC_(1.919187469482421875000000000000000000000e2), SC_(2.878781127929687500000000000000000000000e2), SC_(6.163340759277343750000000000000000000000e1), SC_(4.417274594306945800781250000000000000000e-1), SC_(5.977480338297428671444107886827951955102e-1), SC_(4.022519661702571328555892113172048044898e-1) }}, 
      {{ SC_(1.919187469482421875000000000000000000000e2), SC_(2.878781127929687500000000000000000000000e2), SC_(1.486264953613281250000000000000000000000e2), SC_(4.854870736598968505859375000000000000000e-1), SC_(5.891413870399342924550310735098570438938e-1), SC_(4.108586129600657075449689264901429561062e-1) }}, 
      {{ SC_(1.919187469482421875000000000000000000000e2), SC_(2.878781127929687500000000000000000000000e2), SC_(1.937735595703125000000000000000000000000e2), SC_(5.056025981903076171875000000000000000000e-1), SC_(5.858791153374801331811794580403941906472e-1), SC_(4.141208846625198668188205419596058093528e-1) }}, 
      {{ SC_(1.919187469482421875000000000000000000000e2), SC_(3.838374938964843750000000000000000000000e2), SC_(7.225879669189453125000000000000000000000e1), SC_(4.296698272228240966796875000000000000000e-1), SC_(9.970227186266385981501414654670076845989e-1), SC_(2.977281373361401849858534532992315401060e-3) }}, 
      {{ SC_(1.919187469482421875000000000000000000000e2), SC_(3.838374938964843750000000000000000000000e2), SC_(1.515480346679687500000000000000000000000e2), SC_(4.643296301364898681640625000000000000000e-1), SC_(9.948157020403912830256023694511625048148e-1), SC_(5.184297959608716974397630548837495185244e-3) }}, 
      {{ SC_(1.919187469482421875000000000000000000000e2), SC_(3.838374938964843750000000000000000000000e2), SC_(1.941185607910156250000000000000000000000e2), SC_(4.812575280666351318359375000000000000000e-1), SC_(9.935898383186388813202213453394045551370e-1), SC_(6.410161681361118679778654660595444863009e-3) }}, 
      {{ SC_(1.919187469482421875000000000000000000000e2), SC_(5.757562255859375000000000000000000000000e2), SC_(9.566968083381652832031250000000000000000e-1), SC_(3.753887116909027099609375000000000000000e-1), SC_(9.999999999999147088615336876348213186780e-1), SC_(8.529113846631236517868132195944955387416e-14) }}, 
      {{ SC_(1.919187469482421875000000000000000000000e2), SC_(5.757562255859375000000000000000000000000e2), SC_(7.844540405273437500000000000000000000000e1), SC_(4.053449928760528564453125000000000000000e-1), SC_(9.999999999895978756797321600146998483149e-1), SC_(1.040212432026783998530015168508335235911e-11) }}, 
      {{ SC_(1.919187469482421875000000000000000000000e2), SC_(5.757562255859375000000000000000000000000e2), SC_(1.584414672851562500000000000000000000000e2), SC_(4.334014952182769775390625000000000000000e-1), SC_(9.999999998044608532137641570523625129560e-1), SC_(1.955391467862358429476374870439795250085e-10) }}, 
      {{ SC_(1.919187469482421875000000000000000000000e2), SC_(5.757562255859375000000000000000000000000e2), SC_(1.962219390869140625000000000000000000000e2), SC_(4.457525610923767089843750000000000000000e-1), SC_(9.999999994619714433521287001161196785870e-1), SC_(5.380285566478712998838803214129951295597e-10) }}, 
      {{ SC_(1.919187469482421875000000000000000000000e2), SC_(7.676749877929687500000000000000000000000e2), SC_(7.142335891723632812500000000000000000000), SC_(3.868947029113769531250000000000000000000e-1), SC_(9.999999999999999999999999999999998609103e-1), SC_(1.390896875344701033976605812255420608002e-34) }}, 
      {{ SC_(1.919187469482421875000000000000000000000e2), SC_(7.676749877929687500000000000000000000000e2), SC_(7.974770355224609375000000000000000000000e1), SC_(4.091426134109497070312500000000000000000e-1), SC_(9.999999999999999999999999999885876497000e-1), SC_(1.141235030003259300239917991892731213974e-29) }}, 
      {{ SC_(1.919187469482421875000000000000000000000e2), SC_(7.676749877929687500000000000000000000000e2), SC_(1.595857238769531250000000000000000000000e2), SC_(4.318159818649291992187500000000000000000e-1), SC_(9.999999999999999999999999767491337979039e-1), SC_(2.325086620209607856520467096472668815687e-26) }}, 
      {{ SC_(1.919187469482421875000000000000000000000e2), SC_(7.676749877929687500000000000000000000000e2), SC_(1.985762634277343750000000000000000000000e2), SC_(4.422687292098999023437500000000000000000e-1), SC_(9.999999999999999999999996345820187251722e-1), SC_(3.654179812748278164079239382955048767637e-25) }}, 
      {{ SC_(1.919187469482421875000000000000000000000e2), SC_(9.595937500000000000000000000000000000000e2), SC_(1.950807952880859375000000000000000000000e1), SC_(4.491068422794342041015625000000000000000e-1), SC_(1.000000000000000000000000000000000000000), SC_(9.089203756221521186947205520701399424333e-86) }}, 
      {{ SC_(1.919187469482421875000000000000000000000e2), SC_(9.595937500000000000000000000000000000000e2), SC_(8.435225677490234375000000000000000000000e1), SC_(4.640578031539916992187500000000000000000e-1), SC_(1.000000000000000000000000000000000000000), SC_(2.166190329892073415800894353856697586320e-76) }}, 
      {{ SC_(1.919187469482421875000000000000000000000e2), SC_(9.595937500000000000000000000000000000000e2), SC_(1.596211700439453125000000000000000000000e2), SC_(4.804264903068542480468750000000000000000e-1), SC_(1.000000000000000000000000000000000000000), SC_(2.911647056424730473919275441298349101782e-69) }}, 
      {{ SC_(1.919187469482421875000000000000000000000e2), SC_(9.595937500000000000000000000000000000000e2), SC_(1.992922668457031250000000000000000000000e2), SC_(4.886580407619476318359375000000000000000e-1), SC_(1.000000000000000000000000000000000000000), SC_(2.137861961490428252926885581353088288534e-66) }}, 
      {{ SC_(1.929952545166015625000000000000000000000e2), SC_(1.929952621459960937500000000000000000000e1), SC_(9.566968083381652832031250000000000000000e-1), SC_(9.546471834182739257812500000000000000000e-1), SC_(9.969558564456255529977973137529937783619e-1), SC_(3.044143554374447002202686247006221638104e-3) }}, 
      {{ SC_(1.929952545166015625000000000000000000000e2), SC_(1.929952621459960937500000000000000000000e1), SC_(7.844540405273437500000000000000000000000e1), SC_(9.616100788116455078125000000000000000000e-1), SC_(9.966933001457530712822548499552408905915e-1), SC_(3.306699854246928717745150044759109408532e-3) }}, 
      {{ SC_(1.929952545166015625000000000000000000000e2), SC_(1.929952621459960937500000000000000000000e1), SC_(1.584414672851562500000000000000000000000e2), SC_(9.668670892715454101562500000000000000000e-1), SC_(9.965186287189842526088396206078830003995e-1), SC_(3.481371281015747391160379392116999600490e-3) }}, 
      {{ SC_(1.929952545166015625000000000000000000000e2), SC_(1.929952621459960937500000000000000000000e1), SC_(1.962219390869140625000000000000000000000e2), SC_(9.688807725906372070312500000000000000000e-1), SC_(9.964575604952771124700788474945373863124e-1), SC_(3.542439504722887529921152505462613687620e-3) }}, 
      {{ SC_(1.929952545166015625000000000000000000000e2), SC_(4.824881362915039062500000000000000000000e1), SC_(7.142335891723632812500000000000000000000), SC_(9.343019127845764160156250000000000000000e-1), SC_(9.999999999934345892803048089759793648043e-1), SC_(6.565410719695191024020635195696243212417e-12) }}, 
      {{ SC_(1.929952545166015625000000000000000000000e2), SC_(4.824881362915039062500000000000000000000e1), SC_(7.974770355224609375000000000000000000000e1), SC_(9.427604675292968750000000000000000000000e-1), SC_(9.999999999872786086904909745221316838685e-1), SC_(1.272139130950902547786831613148250321049e-11) }}, 
      {{ SC_(1.929952545166015625000000000000000000000e2), SC_(4.824881362915039062500000000000000000000e1), SC_(1.595857238769531250000000000000000000000e2), SC_(9.498643875122070312500000000000000000000e-1), SC_(9.999999999800468961569564813953558103002e-1), SC_(1.995310384304351860464418969977627155859e-11) }}, 
      {{ SC_(1.929952545166015625000000000000000000000e2), SC_(4.824881362915039062500000000000000000000e1), SC_(1.985762634277343750000000000000000000000e2), SC_(9.527307152748107910156250000000000000000e-1), SC_(9.999999999766233569179882608976982884109e-1), SC_(2.337664308201173910230171158908956827797e-11) }}, 
      {{ SC_(1.929952545166015625000000000000000000000e2), SC_(9.649762725830078125000000000000000000000e1), SC_(1.950807952880859375000000000000000000000e1), SC_(9.193741679191589355468750000000000000000e-1), SC_(9.999999999999999999999999999999955902939e-1), SC_(4.409706134930249351040693815506625542511e-33) }}, 
      {{ SC_(1.929952545166015625000000000000000000000e2), SC_(9.649762725830078125000000000000000000000e1), SC_(8.435225677490234375000000000000000000000e1), SC_(9.272357225418090820312500000000000000000e-1), SC_(9.999999999999999999999999999999551436374e-1), SC_(4.485636264202865578202727388421921758773e-32) }}, 
      {{ SC_(1.929952545166015625000000000000000000000e2), SC_(9.649762725830078125000000000000000000000e1), SC_(1.596211700439453125000000000000000000000e2), SC_(9.346376657485961914062500000000000000000e-1), SC_(9.999999999999999999999999999997387141645e-1), SC_(2.612858354958347534730989835443583156625e-31) }}, 
      {{ SC_(1.929952545166015625000000000000000000000e2), SC_(9.649762725830078125000000000000000000000e1), SC_(1.992922668457031250000000000000000000000e2), SC_(9.379649162292480468750000000000000000000e-1), SC_(9.999999999999999999999999999994812287463e-1), SC_(5.187712536566396505687336034502612239260e-31) }}, 
      {{ SC_(1.929952545166015625000000000000000000000e2), SC_(1.447464447021484375000000000000000000000e2), SC_(2.197235107421875000000000000000000000000e1), SC_(9.169785380363464355468750000000000000000e-1), SC_(1.000000000000000000000000000000000000000), SC_(5.069990774828872339103511815755777837637e-63) }}, 
      {{ SC_(1.929952545166015625000000000000000000000e2), SC_(1.447464447021484375000000000000000000000e2), SC_(8.441753387451171875000000000000000000000e1), SC_(9.237854480743408203125000000000000000000e-1), SC_(1.000000000000000000000000000000000000000), SC_(6.237626356244977723164797835354166702135e-61) }}, 
      {{ SC_(1.929952545166015625000000000000000000000e2), SC_(1.447464447021484375000000000000000000000e2), SC_(1.600560913085937500000000000000000000000e2), SC_(9.306733608245849609375000000000000000000e-1), SC_(1.000000000000000000000000000000000000000), SC_(3.002756973288330109236868843648956959345e-59) }}, 
      {{ SC_(1.929952545166015625000000000000000000000e2), SC_(1.736957244873046875000000000000000000000e2), SC_(2.249290275573730468750000000000000000000e1), SC_(5.403752252459526062011718750000000000000e-2), SC_(2.218713890350419813779070573174162040719e-145), SC_(1.000000000000000000000000000000000000000) }}, 
      {{ SC_(1.929952545166015625000000000000000000000e2), SC_(1.736957244873046875000000000000000000000e2), SC_(9.495173645019531250000000000000000000000e1), SC_(5.804980546236038208007812500000000000000e-2), SC_(1.116592173643264895292771909506533662379e-153), SC_(1.000000000000000000000000000000000000000) }}, 
      {{ SC_(1.929952545166015625000000000000000000000e2), SC_(1.736957244873046875000000000000000000000e2), SC_(1.629447326660156250000000000000000000000e2), SC_(6.122704222798347473144531250000000000000e-2), SC_(1.991419169875931335294217344309758105769e-162), SC_(1.000000000000000000000000000000000000000) }}, 
      {{ SC_(1.929952545166015625000000000000000000000e2), SC_(1.910653076171875000000000000000000000000e2), SC_(2.539736366271972656250000000000000000000e1), SC_(1.295990794897079467773437500000000000000e-1), SC_(1.440206001849275112938077737434660759984e-73), SC_(1.000000000000000000000000000000000000000) }}, 
      {{ SC_(1.929952545166015625000000000000000000000e2), SC_(1.910653076171875000000000000000000000000e2), SC_(9.707512664794921875000000000000000000000e1), SC_(1.395540386438369750976562500000000000000e-1), SC_(1.485115439562907203781561376442960471193e-79), SC_(1.000000000000000000000000000000000000000) }}, 
      {{ SC_(1.929952545166015625000000000000000000000e2), SC_(1.910653076171875000000000000000000000000e2), SC_(1.670017089843750000000000000000000000000e2), SC_(1.478004455566406250000000000000000000000e-1), SC_(3.909934828293154071903400419944471072033e-86), SC_(1.000000000000000000000000000000000000000) }}, 
      {{ SC_(1.929952545166015625000000000000000000000e2), SC_(1.928022613525390625000000000000000000000e2), SC_(2.709540176391601562500000000000000000000e1), SC_(2.585815191268920898437500000000000000000e-1), SC_(2.796872181151851121956136839394028305911e-27), SC_(9.999999999999999999999999972031278188481e-1) }}, 
      {{ SC_(1.929952545166015625000000000000000000000e2), SC_(1.928022613525390625000000000000000000000e2), SC_(1.007325439453125000000000000000000000000e2), SC_(2.789210081100463867187500000000000000000e-1), SC_(1.743972124832153536858982240801149481726e-30), SC_(9.999999999999999999999999999982560278752e-1) }}, 
      {{ SC_(1.929952545166015625000000000000000000000e2), SC_(1.928022613525390625000000000000000000000e2), SC_(1.698258666992187500000000000000000000000e2), SC_(2.951222956180572509765625000000000000000e-1), SC_(7.162671542509038479106961846655165572901e-34), SC_(9.999999999999999999999999999999992837328e-1) }}, 
      {{ SC_(1.929952545166015625000000000000000000000e2), SC_(1.929952545166015625000000000000000000000e2), SC_(2.837726783752441406250000000000000000000e1), SC_(3.882638216018676757812500000000000000000e-1), SC_(1.401726851476762362017170392058938291927e-7), SC_(9.999998598273148523237637982829607941062e-1) }}, 
      {{ SC_(1.929952545166015625000000000000000000000e2), SC_(1.929952545166015625000000000000000000000e2), SC_(1.093762969970703125000000000000000000000e2), SC_(4.214449524879455566406250000000000000000e-1), SC_(1.102658529283033284229146577675117213385e-8), SC_(9.999999889734147071696671577085342232488e-1) }}, 
      {{ SC_(1.929952545166015625000000000000000000000e2), SC_(1.929952545166015625000000000000000000000e2), SC_(1.756861267089843750000000000000000000000e2), SC_(4.444009959697723388671875000000000000000e-1), SC_(1.039482886881709083372306341201061098079e-9), SC_(9.999999989605171131182909166276936587989e-1) }}, 
      {{ SC_(1.929952545166015625000000000000000000000e2), SC_(1.930145568847656250000000000000000000000e2), SC_(3.152261734008789062500000000000000000000e1), SC_(4.675894379615783691406250000000000000000e-1), SC_(2.040661977999310171671399870060887459939e-2), SC_(9.795933802200068982832860012993911254006e-1) }}, 
      {{ SC_(1.929952545166015625000000000000000000000e2), SC_(1.930145568847656250000000000000000000000e2), SC_(1.094441146850585937500000000000000000000e2), SC_(5.057420134544372558593750000000000000000e-1), SC_(1.219151586063219368905826582084919770268e-2), SC_(9.878084841393678063109417341791508022973e-1) }}, 
      {{ SC_(1.929952545166015625000000000000000000000e2), SC_(1.930145568847656250000000000000000000000e2), SC_(1.811583862304687500000000000000000000000e2), SC_(5.353621244430541992187500000000000000000e-1), SC_(7.131293522419618463302662710679617966919e-3), SC_(9.928687064775803815366973372893203820331e-1) }}, 
      {{ SC_(1.929952545166015625000000000000000000000e2), SC_(1.931882629394531250000000000000000000000e2), SC_(3.423733520507812500000000000000000000000e1), SC_(5.157241225242614746093750000000000000000e-1), SC_(4.178666056743470888234946263036517511356e-1), SC_(5.821333943256529111765053736963482488644e-1) }}, 
      {{ SC_(1.929952545166015625000000000000000000000e2), SC_(1.931882629394531250000000000000000000000e2), SC_(1.264718551635742187500000000000000000000e2), SC_(5.643035173416137695312500000000000000000e-1), SC_(4.057965679192263010852380168021899783192e-1), SC_(5.942034320807736989147619831978100216808e-1) }}, 
      {{ SC_(1.929952545166015625000000000000000000000e2), SC_(1.931882629394531250000000000000000000000e2), SC_(1.826751708984375000000000000000000000000e2), SC_(5.893203616142272949218750000000000000000e-1), SC_(3.983669219364022989855166205033142890000e-1), SC_(6.016330780635977010144833794966857110000e-1) }}, 
      {{ SC_(1.929952545166015625000000000000000000000e2), SC_(1.949252014160156250000000000000000000000e2), SC_(3.477303314208984375000000000000000000000e1), SC_(5.184977650642395019531250000000000000000e-1), SC_(4.910231558682617835719136618116313622656e-1), SC_(5.089768441317382164280863381883686377344e-1) }}, 
      {{ SC_(1.929952545166015625000000000000000000000e2), SC_(1.949252014160156250000000000000000000000e2), SC_(1.279526672363281250000000000000000000000e2), SC_(5.679473876953125000000000000000000000000e-1), SC_(4.880787590367747418889305599443522396112e-1), SC_(5.119212409632252581110694400556477603888e-1) }}, 
      {{ SC_(1.929952545166015625000000000000000000000e2), SC_(1.949252014160156250000000000000000000000e2), SC_(1.831471099853515625000000000000000000000e2), SC_(5.927220582962036132812500000000000000000e-1), SC_(4.865563072511400905056420603482076224839e-1), SC_(5.134436927488599094943579396517923775161e-1) }}, 
      {{ SC_(1.929952545166015625000000000000000000000e2), SC_(2.122947845458984375000000000000000000000e2), SC_(3.767639541625976562500000000000000000000e1), SC_(4.994037151336669921875000000000000000000e-1), SC_(4.997104358200870729808854216421186545608e-1), SC_(5.002895641799129270191145783578813454392e-1) }}, 
      {{ SC_(1.929952545166015625000000000000000000000e2), SC_(2.122947845458984375000000000000000000000e2), SC_(1.310955810546875000000000000000000000000e2), SC_(5.489794015884399414062500000000000000000e-1), SC_(4.978565889209473072137766580016351710325e-1), SC_(5.021434110790526927862233419983648289675e-1) }}, 
      {{ SC_(1.929952545166015625000000000000000000000e2), SC_(2.122947845458984375000000000000000000000e2), SC_(1.867986450195312500000000000000000000000e2), SC_(5.741346478462219238281250000000000000000e-1), SC_(4.970030124753941888830417269886756532049e-1), SC_(5.029969875246058111169582730113243467951e-1) }}, 
      {{ SC_(1.929952545166015625000000000000000000000e2), SC_(2.315943145751953125000000000000000000000e2), SC_(4.238486480712890625000000000000000000000e1), SC_(4.804728627204895019531250000000000000000e-1), SC_(5.010254471126493606035807021748682281385e-1), SC_(4.989745528873506393964192978251317718615e-1) }}, 
      {{ SC_(1.929952545166015625000000000000000000000e2), SC_(2.315943145751953125000000000000000000000e2), SC_(1.311481323242187500000000000000000000000e2), SC_(5.274346470832824707031250000000000000000e-1), SC_(4.992278794630264951935358705631785742023e-1), SC_(5.007721205369735048064641294368214257977e-1) }}, 
      {{ SC_(1.929952545166015625000000000000000000000e2), SC_(2.315943145751953125000000000000000000000e2), SC_(1.914333953857421875000000000000000000000e2), SC_(5.547756552696228027343750000000000000000e-1), SC_(4.982808414512684131589590605517845668815e-1), SC_(5.017191585487315868410409394482154331185e-1) }}, 
      {{ SC_(1.929952545166015625000000000000000000000e2), SC_(2.508938140869140625000000000000000000000e2), SC_(4.420680999755859375000000000000000000000e1), SC_(4.620757102966308593750000000000000000000e-1), SC_(5.096742806702288307182803482512588683434e-1), SC_(4.903257193297711692817196517487411316566e-1) }}, 
      {{ SC_(1.929952545166015625000000000000000000000e2), SC_(2.508938140869140625000000000000000000000e2), SC_(1.357470245361328125000000000000000000000e2), SC_(5.101085305213928222656250000000000000000e-1), SC_(5.072038939363742007077669321292936985521e-1), SC_(4.927961060636257992922330678707063014479e-1) }}, 
      {{ SC_(1.929952545166015625000000000000000000000e2), SC_(2.508938140869140625000000000000000000000e2), SC_(1.915013732910156250000000000000000000000e2), SC_(5.353834033012390136718750000000000000000e-1), SC_(5.060683304676041203222498148325486442049e-1), SC_(4.939316695323958796777501851674513557951e-1) }}, 
      {{ SC_(1.929952545166015625000000000000000000000e2), SC_(2.894928894042968750000000000000000000000e2), SC_(5.569964599609375000000000000000000000000e1), SC_(4.382991194725036621093750000000000000000e-1), SC_(5.987930226862307026600996188941166357497e-1), SC_(4.012069773137692973399003811058833642503e-1) }}, 
      {{ SC_(1.929952545166015625000000000000000000000e2), SC_(2.894928894042968750000000000000000000000e2), SC_(1.362719116210937500000000000000000000000e2), SC_(4.793343842029571533203125000000000000000e-1), SC_(5.904666044668609951189657179898252403388e-1), SC_(4.095333955331390048810342820101747596612e-1) }}, 
      {{ SC_(1.929952545166015625000000000000000000000e2), SC_(2.894928894042968750000000000000000000000e2), SC_(1.918984832763671875000000000000000000000e2), SC_(5.043390393257141113281250000000000000000e-1), SC_(5.863169450109638756921202382972728731999e-1), SC_(4.136830549890361243078797617027271268001e-1) }}, 
      {{ SC_(1.929952545166015625000000000000000000000e2), SC_(3.859905090332031250000000000000000000000e2), SC_(5.940588760375976562500000000000000000000e1), SC_(4.234678745269775390625000000000000000000e-1), SC_(9.974270026676513736983997762990279592160e-1), SC_(2.572997332348626301600223700972040783986e-3) }}, 
      {{ SC_(1.929952545166015625000000000000000000000e2), SC_(3.859905090332031250000000000000000000000e2), SC_(1.451677856445312500000000000000000000000e2), SC_(4.613615870475769042968750000000000000000e-1), SC_(9.951248052562697205810270309034214554437e-1), SC_(4.875194743730279418972969096578544556342e-3) }}, 
      {{ SC_(1.929952545166015625000000000000000000000e2), SC_(3.859905090332031250000000000000000000000e2), SC_(1.929777069091796875000000000000000000000e2), SC_(4.804028868675231933593750000000000000000e-1), SC_(9.937772061022855103572014818046382412834e-1), SC_(6.222793897714489642798518195361758716586e-3) }}, 
      {{ SC_(1.929952545166015625000000000000000000000e2), SC_(5.789857788085937500000000000000000000000e2), SC_(6.038262176513671875000000000000000000000e1), SC_(3.984948694705963134765625000000000000000e-1), SC_(9.999999999963010403927945000513278401552e-1), SC_(3.698959607205499948672159844825613705820e-12) }}, 
      {{ SC_(1.929952545166015625000000000000000000000e2), SC_(5.789857788085937500000000000000000000000e2), SC_(1.481294555664062500000000000000000000000e2), SC_(4.296548962593078613281250000000000000000e-1), SC_(9.999999998752916319691030923199222227179e-1), SC_(1.247083680308969076800777772820547392721e-10) }}, 
      {{ SC_(1.929952545166015625000000000000000000000e2), SC_(5.789857788085937500000000000000000000000e2), SC_(1.935389862060546875000000000000000000000e2), SC_(4.445471167564392089843750000000000000000e-1), SC_(9.999999995596184186583775520308552478661e-1), SC_(4.403815813416224479691447521339184445756e-10) }}, 
      {{ SC_(1.929952545166015625000000000000000000000e2), SC_(7.719810180664062500000000000000000000000e2), SC_(6.163340759277343750000000000000000000000e1), SC_(4.036410748958587646484375000000000000000e-1), SC_(9.999999999999999999999999999992308648666e-1), SC_(7.691351333593873180990761187182575940182e-31) }}, 
      {{ SC_(1.929952545166015625000000000000000000000e2), SC_(7.719810180664062500000000000000000000000e2), SC_(1.486264953613281250000000000000000000000e2), SC_(4.285784661769866943359375000000000000000e-1), SC_(9.999999999999999999999999933726054578925e-1), SC_(6.627394542107492321747685615700405005859e-27) }}, 
      {{ SC_(1.929952545166015625000000000000000000000e2), SC_(7.719810180664062500000000000000000000000e2), SC_(1.937735595703125000000000000000000000000e2), SC_(4.407163858413696289062500000000000000000e-1), SC_(9.999999999999999999999998163000917355333e-1), SC_(1.836999082644666531604019440004276132866e-25) }}, 
      {{ SC_(1.929952545166015625000000000000000000000e2), SC_(9.649762573242187500000000000000000000000e2), SC_(7.225879669189453125000000000000000000000e1), SC_(4.612399935722351074218750000000000000000e-1), SC_(1.000000000000000000000000000000000000000), SC_(2.618123591968572370495477050364036042238e-78) }}, 
      {{ SC_(1.929952545166015625000000000000000000000e2), SC_(9.649762573242187500000000000000000000000e2), SC_(1.515480346679687500000000000000000000000e2), SC_(4.785395264625549316406250000000000000000e-1), SC_(1.000000000000000000000000000000000000000), SC_(2.344068447250949116468830172408077070077e-70) }}, 
      {{ SC_(1.929952545166015625000000000000000000000e2), SC_(9.649762573242187500000000000000000000000e2), SC_(1.941185607910156250000000000000000000000e2), SC_(4.873774051666259765625000000000000000000e-1), SC_(1.000000000000000000000000000000000000000), SC_(3.515390965802415854828722319240530091159e-67) }}, 
      {{ SC_(1.935551452636718750000000000000000000000e2), SC_(1.935551452636718750000000000000000000000e1), SC_(6.038262176513671875000000000000000000000e1), SC_(9.601702094078063964843750000000000000000e-1), SC_(9.967854576749450294266683725223821553888e-1), SC_(3.214542325054970573331627477617844611225e-3) }}, 
      {{ SC_(1.935551452636718750000000000000000000000e2), SC_(1.935551452636718750000000000000000000000e1), SC_(1.481294555664062500000000000000000000000e2), SC_(9.662463665008544921875000000000000000000e-1), SC_(9.965808733905577743396652628316702309198e-1), SC_(3.419126609442225660334737168329769080232e-3) }}, 
      {{ SC_(1.935551452636718750000000000000000000000e2), SC_(1.935551452636718750000000000000000000000e1), SC_(1.935389862060546875000000000000000000000e2), SC_(9.687176942825317382812500000000000000000e-1), SC_(9.965059415053592537166280103698467240002e-1), SC_(3.494058494640746283371989630153275999823e-3) }}, 
      {{ SC_(1.935551452636718750000000000000000000000e2), SC_(4.838878631591796875000000000000000000000e1), SC_(6.163340759277343750000000000000000000000e1), SC_(9.408408999443054199218750000000000000000e-1), SC_(9.999999999896298472077600525919179567791e-1), SC_(1.037015279223994740808204322085371312124e-11) }}, 
      {{ SC_(1.935551452636718750000000000000000000000e2), SC_(4.838878631591796875000000000000000000000e1), SC_(1.486264953613281250000000000000000000000e2), SC_(9.489606022834777832031250000000000000000e-1), SC_(9.999999999822723427796156135288756081280e-1), SC_(1.772765722038438647112439187201933217818e-11) }}, 
      {{ SC_(1.935551452636718750000000000000000000000e2), SC_(4.838878631591796875000000000000000000000e1), SC_(1.937735595703125000000000000000000000000e2), SC_(9.523561000823974609375000000000000000000e-1), SC_(9.999999999785313014357066779614694652487e-1), SC_(2.146869856429332203853053475133391434353e-11) }}, 
      {{ SC_(1.935551452636718750000000000000000000000e2), SC_(9.677757263183593750000000000000000000000e1), SC_(7.225879669189453125000000000000000000000e1), SC_(9.258639812469482421875000000000000000000e-1), SC_(9.999999999999999999999999999999746473603e-1), SC_(2.535263970680521161543790721542257987802e-32) }}, 
      {{ SC_(1.935551452636718750000000000000000000000e2), SC_(9.677757263183593750000000000000000000000e1), SC_(1.515480346679687500000000000000000000000e2), SC_(9.338769912719726562500000000000000000000e-1), SC_(9.999999999999999999999999999998182199750e-1), SC_(1.817800250203811097990205685224913382349e-31) }}, 
      {{ SC_(1.935551452636718750000000000000000000000e2), SC_(9.677757263183593750000000000000000000000e1), SC_(1.941185607910156250000000000000000000000e2), SC_(9.375050663948059082031250000000000000000e-1), SC_(9.999999999999999999999999999996104597332e-1), SC_(3.895402668200827536760103670112656210758e-31) }}, 
      {{ SC_(1.935551452636718750000000000000000000000e2), SC_(1.451663513183593750000000000000000000000e2), SC_(9.566968083381652832031250000000000000000e-1), SC_(9.144062399864196777343750000000000000000e-1), SC_(1.000000000000000000000000000000000000000), SC_(3.824829997085882231265205034035308468573e-64) }}, 
      {{ SC_(1.935551452636718750000000000000000000000e2), SC_(1.451663513183593750000000000000000000000e2), SC_(7.844540405273437500000000000000000000000e1), SC_(9.231599569320678710937500000000000000000e-1), SC_(1.000000000000000000000000000000000000000), SC_(2.829123061818127389183506703540165028584e-61) }}, 
      {{ SC_(1.935551452636718750000000000000000000000e2), SC_(1.451663513183593750000000000000000000000e2), SC_(1.584414672851562500000000000000000000000e2), SC_(9.305012822151184082031250000000000000000e-1), SC_(1.000000000000000000000000000000000000000), SC_(1.876619130469660214956128494531723306729e-59) }}, 
      {{ SC_(1.935551452636718750000000000000000000000e2), SC_(1.451663513183593750000000000000000000000e2), SC_(1.962219390869140625000000000000000000000e2), SC_(9.335026741027832031250000000000000000000e-1), SC_(1.000000000000000000000000000000000000000), SC_(8.107760337243195939238553068299711786246e-59) }}, 
      {{ SC_(1.935551452636718750000000000000000000000e2), SC_(1.741996307373046875000000000000000000000e2), SC_(7.142335891723632812500000000000000000000), SC_(5.308592319488525390625000000000000000000e-2), SC_(3.279913503447645251815905492604460815071e-144), SC_(1.000000000000000000000000000000000000000) }}, 
      {{ SC_(1.935551452636718750000000000000000000000e2), SC_(1.741996307373046875000000000000000000000e2), SC_(7.974770355224609375000000000000000000000e1), SC_(5.725485831499099731445312500000000000000e-2), SC_(3.043343509759325199708035257586958418376e-152), SC_(1.000000000000000000000000000000000000000) }}, 
      {{ SC_(1.935551452636718750000000000000000000000e2), SC_(1.741996307373046875000000000000000000000e2), SC_(1.595857238769531250000000000000000000000e2), SC_(6.106134876608848571777343750000000000000e-2), SC_(2.222666811564320597203340119012489659149e-162), SC_(1.000000000000000000000000000000000000000) }}, 
      {{ SC_(1.935551452636718750000000000000000000000e2), SC_(1.741996307373046875000000000000000000000e2), SC_(1.985762634277343750000000000000000000000e2), SC_(6.268460303544998168945312500000000000000e-2), SC_(1.095057139865913919064470622030242185396e-167), SC_(1.000000000000000000000000000000000000000) }}, 
      {{ SC_(1.935551452636718750000000000000000000000e2), SC_(1.916195983886718750000000000000000000000e2), SC_(1.950807952880859375000000000000000000000e1), SC_(1.286923140287399291992187500000000000000e-1), SC_(2.536088534266899728664882704577277870704e-73), SC_(1.000000000000000000000000000000000000000) }}, 
      {{ SC_(1.935551452636718750000000000000000000000e2), SC_(1.916195983886718750000000000000000000000e2), SC_(8.435225677490234375000000000000000000000e1), SC_(1.378767639398574829101562500000000000000e-1), SC_(1.254916115179380988512816481213670741080e-78), SC_(1.000000000000000000000000000000000000000) }}, 
      {{ SC_(1.935551452636718750000000000000000000000e2), SC_(1.916195983886718750000000000000000000000e2), SC_(1.596211700439453125000000000000000000000e2), SC_(1.469374299049377441406250000000000000000e-1), SC_(1.310506422431679729217659337734896965245e-85), SC_(1.000000000000000000000000000000000000000) }}, 
      {{ SC_(1.935551452636718750000000000000000000000e2), SC_(1.916195983886718750000000000000000000000e2), SC_(1.992922668457031250000000000000000000000e2), SC_(1.511486321687698364257812500000000000000e-1), SC_(1.495669054220648753042297820928728686634e-89), SC_(1.000000000000000000000000000000000000000) }}, 
      {{ SC_(1.935551452636718750000000000000000000000e2), SC_(1.933615875244140625000000000000000000000e2), SC_(2.197235107421875000000000000000000000000e1), SC_(2.570073008537292480468750000000000000000e-1), SC_(3.797144514195924625982554494502691289696e-27), SC_(9.999999999999999999999999962028554858041e-1) }}, 
      {{ SC_(1.935551452636718750000000000000000000000e2), SC_(1.933615875244140625000000000000000000000e2), SC_(8.441753387451171875000000000000000000000e1), SC_(2.746511101722717285156250000000000000000e-1), SC_(8.374414402624504658115803211264956305545e-30), SC_(9.999999999999999999999999999916255855974e-1) }}, 
      {{ SC_(1.935551452636718750000000000000000000000e2), SC_(1.933615875244140625000000000000000000000e2), SC_(1.600560913085937500000000000000000000000e2), SC_(2.928742766380310058593750000000000000000e-1), SC_(1.925794863916867731031912402913611329612e-33), SC_(9.999999999999999999999999999999980742051e-1) }}, 
      {{ SC_(1.935551452636718750000000000000000000000e2), SC_(1.935551452636718750000000000000000000000e2), SC_(2.249290275573730468750000000000000000000e1), SC_(3.855611979961395263671875000000000000000e-1), SC_(1.595586896823111680293740442751062839653e-7), SC_(9.999998404413103176888319706259557248937e-1) }}, 
      {{ SC_(1.935551452636718750000000000000000000000e2), SC_(1.935551452636718750000000000000000000000e2), SC_(9.495173645019531250000000000000000000000e1), SC_(4.158824980258941650390625000000000000000e-1), SC_(1.723423759599688590189491685296048879333e-8), SC_(9.999999827657624040031140981050831470395e-1) }}, 
      {{ SC_(1.935551452636718750000000000000000000000e2), SC_(1.935551452636718750000000000000000000000e2), SC_(1.629447326660156250000000000000000000000e2), SC_(4.400862157344818115234375000000000000000e-1), SC_(1.607539929677447357374750582214749958213e-9), SC_(9.999999983924600703225526426252494177853e-1) }}, 
      {{ SC_(1.935551452636718750000000000000000000000e2), SC_(1.935745086669921875000000000000000000000e2), SC_(2.539736366271972656250000000000000000000e1), SC_(4.642357528209686279296875000000000000000e-1), SC_(2.103490673817579615516950625371626976947e-2), SC_(9.789650932618242038448304937462837302305e-1) }}, 
      {{ SC_(1.935551452636718750000000000000000000000e2), SC_(1.935745086669921875000000000000000000000e2), SC_(9.707512664794921875000000000000000000000e1), SC_(5.000120997428894042968750000000000000000e-1), SC_(1.321451450860089684061845960718958333381e-2), SC_(9.867854854913991031593815403928104166662e-1) }}, 
      {{ SC_(1.935551452636718750000000000000000000000e2), SC_(1.935745086669921875000000000000000000000e2), SC_(1.670017089843750000000000000000000000000e2), SC_(5.296824574470520019531250000000000000000e-1), SC_(7.914961942547830665434029196551149312391e-3), SC_(9.920850380574521693345659708034488506876e-1) }}, 
      {{ SC_(1.935551452636718750000000000000000000000e2), SC_(1.937487030029296875000000000000000000000e2), SC_(2.709540176391601562500000000000000000000e1), SC_(5.114502906799316406250000000000000000000e-1), SC_(4.186765491890487079309936322117313195313e-1), SC_(5.813234508109512920690063677882686804687e-1) }}, 
      {{ SC_(1.935551452636718750000000000000000000000e2), SC_(1.937487030029296875000000000000000000000e2), SC_(1.007325439453125000000000000000000000000e2), SC_(5.516295433044433593750000000000000000000e-1), SC_(4.091077824793043761345243635361487708947e-1), SC_(5.908922175206956238654756364638512291053e-1) }}, 
      {{ SC_(1.935551452636718750000000000000000000000e2), SC_(1.937487030029296875000000000000000000000e2), SC_(1.698258666992187500000000000000000000000e2), SC_(5.836521387100219726562500000000000000000e-1), SC_(3.999974148084191631211131309284899526098e-1), SC_(6.000025851915808368788868690715100473902e-1) }}, 
      {{ SC_(1.935551452636718750000000000000000000000e2), SC_(1.954906921386718750000000000000000000000e2), SC_(2.837726783752441406250000000000000000000e1), SC_(5.146360397338867187500000000000000000000e-1), SC_(4.912371625834942373970390843036268196527e-1), SC_(5.087628374165057626029609156963731803473e-1) }}, 
      {{ SC_(1.935551452636718750000000000000000000000e2), SC_(1.954906921386718750000000000000000000000e2), SC_(1.093762969970703125000000000000000000000e2), SC_(5.587599873542785644531250000000000000000e-1), SC_(4.886252335496631210955695469029908685944e-1), SC_(5.113747664503368789044304530970091314056e-1) }}, 
      {{ SC_(1.935551452636718750000000000000000000000e2), SC_(1.954906921386718750000000000000000000000e2), SC_(1.756861267089843750000000000000000000000e2), SC_(5.893225669860839843750000000000000000000e-1), SC_(4.867587947569382289216524117695095792137e-1), SC_(5.132412052430617710783475882304904207863e-1) }}, 
      {{ SC_(1.935551452636718750000000000000000000000e2), SC_(2.129106597900390625000000000000000000000e2), SC_(3.152261734008789062500000000000000000000e1), SC_(4.956991672515869140625000000000000000000e-1), SC_(4.998563128840197496864501645749841310463e-1), SC_(5.001436871159802503135498354250158689537e-1) }}, 
      {{ SC_(1.935551452636718750000000000000000000000e2), SC_(2.129106597900390625000000000000000000000e2), SC_(1.094441146850585937500000000000000000000e2), SC_(5.382241010665893554687500000000000000000e-1), SC_(4.982433496896890268153517267908501898692e-1), SC_(5.017566503103109731846482732091498101308e-1) }}, 
      {{ SC_(1.935551452636718750000000000000000000000e2), SC_(2.129106597900390625000000000000000000000e2), SC_(1.811583862304687500000000000000000000000e2), SC_(5.714900493621826171875000000000000000000e-1), SC_(4.970939024955782471801365387110910216309e-1), SC_(5.029060975044217528198634612889089783691e-1) }}, 
      {{ SC_(1.935551452636718750000000000000000000000e2), SC_(2.322661895751953125000000000000000000000e2), SC_(3.423733520507812500000000000000000000000e1), SC_(4.756327569484710693359375000000000000000e-1), SC_(5.012211362393913027622338783600676109972e-1), SC_(4.987788637606086972377661216399323890028e-1) }}, 
      {{ SC_(1.935551452636718750000000000000000000000e2), SC_(2.322661895751953125000000000000000000000e2), SC_(1.264718551635742187500000000000000000000e2), SC_(5.249955654144287109375000000000000000000e-1), SC_(4.993191394759908596547983829788700177446e-1), SC_(5.006808605240091403452016170211299822554e-1) }}, 
      {{ SC_(1.935551452636718750000000000000000000000e2), SC_(2.322661895751953125000000000000000000000e2), SC_(1.826751708984375000000000000000000000000e2), SC_(5.507720112800598144531250000000000000000e-1), SC_(4.984191663320065464032718126729453539378e-1), SC_(5.015808336679934535967281873270546460622e-1) }}, 
      {{ SC_(1.935551452636718750000000000000000000000e2), SC_(2.516216735839843750000000000000000000000e2), SC_(3.477303314208984375000000000000000000000e1), SC_(4.565269351005554199218750000000000000000e-1), SC_(5.099988348268958194858622739355022661257e-1), SC_(4.900011651731041805141377260644977338743e-1) }}, 
      {{ SC_(1.935551452636718750000000000000000000000e2), SC_(2.516216735839843750000000000000000000000e2), SC_(1.279526672363281250000000000000000000000e2), SC_(5.061753988265991210937500000000000000000e-1), SC_(5.074034294981024224131453620410288563146e-1), SC_(4.925965705018975775868546379589711436854e-1) }}, 
      {{ SC_(1.935551452636718750000000000000000000000e2), SC_(2.516216735839843750000000000000000000000e2), SC_(1.831471099853515625000000000000000000000e2), SC_(5.315323472023010253906250000000000000000e-1), SC_(5.062493156336265990255227166860237830689e-1), SC_(4.937506843663734009744772833139762169311e-1) }}, 
      {{ SC_(1.935551452636718750000000000000000000000e2), SC_(2.903327026367187500000000000000000000000e2), SC_(3.767639541625976562500000000000000000000e1), SC_(4.281586408615112304687500000000000000000e-1), SC_(6.013575306061897085867529212151449012322e-1), SC_(3.986424693938102914132470787848550987678e-1) }}, 
      {{ SC_(1.935551452636718750000000000000000000000e2), SC_(2.903327026367187500000000000000000000000e2), SC_(1.310955810546875000000000000000000000000e2), SC_(4.766984283924102783203125000000000000000e-1), SC_(5.910704079959888725014437499625537276988e-1), SC_(4.089295920040111274985562500374462723012e-1) }}, 
      {{ SC_(1.935551452636718750000000000000000000000e2), SC_(2.903327026367187500000000000000000000000e2), SC_(1.867986450195312500000000000000000000000e2), SC_(5.019139647483825683593750000000000000000e-1), SC_(5.868211400651796211585241498547469273678e-1), SC_(4.131788599348203788414758501452530726322e-1) }}, 
      {{ SC_(1.935551452636718750000000000000000000000e2), SC_(3.871102905273437500000000000000000000000e2), SC_(4.238486480712890625000000000000000000000e1), SC_(4.152456223964691162109375000000000000000e-1), SC_(9.978705705042673288657519368126196298465e-1), SC_(2.129429495732671134248063187380370153513e-3) }}, 
      {{ SC_(1.935551452636718750000000000000000000000e2), SC_(3.871102905273437500000000000000000000000e2), SC_(1.311481323242187500000000000000000000000e2), SC_(4.553509950637817382812500000000000000000e-1), SC_(9.955762916216110618369024849850481096037e-1), SC_(4.423708378388938163097515014951890396287e-3) }}, 
      {{ SC_(1.935551452636718750000000000000000000000e2), SC_(3.871102905273437500000000000000000000000e2), SC_(1.914333953857421875000000000000000000000e2), SC_(4.795958399772644042968750000000000000000e-1), SC_(9.938991986494445039696001432870975593732e-1), SC_(6.100801350555496030399856712902440626775e-3) }}, 
      {{ SC_(1.935551452636718750000000000000000000000e2), SC_(5.806654052734375000000000000000000000000e2), SC_(4.420680999755859375000000000000000000000e1), SC_(3.923268318176269531250000000000000000000e-1), SC_(9.999999999986007839828061954141807429124e-1), SC_(1.399216017193804585819257087560964886497e-12) }}, 
      {{ SC_(1.935551452636718750000000000000000000000e2), SC_(5.806654052734375000000000000000000000000e2), SC_(1.357470245361328125000000000000000000000e2), SC_(4.253205657005310058593750000000000000000e-1), SC_(9.999999999220404852317764417448881830041e-1), SC_(7.795951476822355825511181699587967897630e-11) }}, 
      {{ SC_(1.935551452636718750000000000000000000000e2), SC_(5.806654052734375000000000000000000000000e2), SC_(1.915013732910156250000000000000000000000e2), SC_(4.437183439731597900390625000000000000000e-1), SC_(9.999999996097789291014202089733505024029e-1), SC_(3.902210708985797910266494975971397359022e-10) }}, 
      {{ SC_(1.935551452636718750000000000000000000000e2), SC_(7.742205810546875000000000000000000000000e2), SC_(5.569964599609375000000000000000000000000e1), SC_(4.018121957778930664062500000000000000000e-1), SC_(9.999999999999999999999999999997250568853e-1), SC_(2.749431146898408038083106501898872260249e-31) }}, 
      {{ SC_(1.935551452636718750000000000000000000000e2), SC_(7.742205810546875000000000000000000000000e2), SC_(1.362719116210937500000000000000000000000e2), SC_(4.250551164150238037109375000000000000000e-1), SC_(9.999999999999999999999999980880218716504e-1), SC_(1.911978128349550469946099831478417885276e-27) }}, 
      {{ SC_(1.935551452636718750000000000000000000000e2), SC_(7.742205810546875000000000000000000000000e2), SC_(1.918984832763671875000000000000000000000e2), SC_(4.400763213634490966796875000000000000000e-1), SC_(9.999999999999999999999998665674942016439e-1), SC_(1.334325057983560593179227430936682327626e-25) }}, 
      {{ SC_(1.935551452636718750000000000000000000000e2), SC_(9.677757568359375000000000000000000000000e2), SC_(5.940588760375976562500000000000000000000e1), SC_(4.582879841327667236328125000000000000000e-1), SC_(1.000000000000000000000000000000000000000), SC_(3.196533965004084048663913164287481441128e-80) }}, 
      {{ SC_(1.935551452636718750000000000000000000000e2), SC_(9.677757568359375000000000000000000000000e2), SC_(1.451677856445312500000000000000000000000e2), SC_(4.770995676517486572265625000000000000000e-1), SC_(1.000000000000000000000000000000000000000), SC_(4.041259858480715035674593111423659416323e-71) }}, 
      {{ SC_(1.935551452636718750000000000000000000000e2), SC_(9.677757568359375000000000000000000000000e2), SC_(1.929777069091796875000000000000000000000e2), SC_(4.870304763317108154296875000000000000000e-1), SC_(1.000000000000000000000000000000000000000), SC_(1.741140202089291146819800272096605908139e-67) }}, 
      {{ SC_(1.937891235351562500000000000000000000000e2), SC_(1.937891197204589843750000000000000000000e1), SC_(4.420680999755859375000000000000000000000e1), SC_(9.587993621826171875000000000000000000000e-1), SC_(9.968519804642498727075018945949901940916e-1), SC_(3.148019535750127292498105405009805908374e-3) }}, 
      {{ SC_(1.937891235351562500000000000000000000000e2), SC_(1.937891197204589843750000000000000000000e1), SC_(1.357470245361328125000000000000000000000e2), SC_(9.654934406280517578125000000000000000000e-1), SC_(9.966223278741179259500287283179966763398e-1), SC_(3.377672125882074049971271682003323660168e-3) }}, 
      {{ SC_(1.937891235351562500000000000000000000000e2), SC_(1.937891197204589843750000000000000000000e1), SC_(1.915013732910156250000000000000000000000e2), SC_(9.686027765274047851562500000000000000000e-1), SC_(9.965272261604177432344519282177069853420e-1), SC_(3.472773839582256765548071782293014657973e-3) }}, 
      {{ SC_(1.937891235351562500000000000000000000000e2), SC_(4.844728088378906250000000000000000000000e1), SC_(5.569964599609375000000000000000000000000e1), SC_(9.401848316192626953125000000000000000000e-1), SC_(9.999999999903963972489493468073407732113e-1), SC_(9.603602751050653192659226788683900256823e-12) }}, 
      {{ SC_(1.937891235351562500000000000000000000000e2), SC_(4.844728088378906250000000000000000000000e1), SC_(1.362719116210937500000000000000000000000e2), SC_(9.479318261146545410156250000000000000000e-1), SC_(9.999999999837837395314312314439786752748e-1), SC_(1.621626046856876855602132472522512524877e-11) }}, 
      {{ SC_(1.937891235351562500000000000000000000000e2), SC_(4.844728088378906250000000000000000000000e1), SC_(1.918984832763671875000000000000000000000e2), SC_(9.522078037261962890625000000000000000000e-1), SC_(9.999999999792752622690147408893244539080e-1), SC_(2.072473773098525911067554609196471759867e-11) }}, 
      {{ SC_(1.937891235351562500000000000000000000000e2), SC_(9.689456176757812500000000000000000000000e1), SC_(5.940588760375976562500000000000000000000e1), SC_(9.243705868721008300781250000000000000000e-1), SC_(9.999999999999999999999999999999846740136e-1), SC_(1.532598635117882549191496903685825631109e-32) }}, 
      {{ SC_(1.937891235351562500000000000000000000000e2), SC_(9.689456176757812500000000000000000000000e1), SC_(1.451677856445312500000000000000000000000e2), SC_(9.332807064056396484375000000000000000000e-1), SC_(9.999999999999999999999999999998533995806e-1), SC_(1.466004194292634459915329388835849043082e-31) }}, 
      {{ SC_(1.937891235351562500000000000000000000000e2), SC_(9.689456176757812500000000000000000000000e1), SC_(1.929777069091796875000000000000000000000e2), SC_(9.373942613601684570312500000000000000000e-1), SC_(9.999999999999999999999999999996488868583e-1), SC_(3.511131417315273255878281550051812909405e-31) }}, 
      {{ SC_(1.937891235351562500000000000000000000000e2), SC_(1.453418426513671875000000000000000000000e2), SC_(6.038262176513671875000000000000000000000e1), SC_(9.212752580642700195312500000000000000000e-1), SC_(1.000000000000000000000000000000000000000), SC_(6.875476348322253432521303978915008455694e-62) }}, 
      {{ SC_(1.937891235351562500000000000000000000000e2), SC_(1.453418426513671875000000000000000000000e2), SC_(1.481294555664062500000000000000000000000e2), SC_(9.296193718910217285156250000000000000000e-1), SC_(1.000000000000000000000000000000000000000), SC_(1.013778230180866225118172116027904880778e-59) }}, 
      {{ SC_(1.937891235351562500000000000000000000000e2), SC_(1.453418426513671875000000000000000000000e2), SC_(1.935389862060546875000000000000000000000e2), SC_(9.332802295684814453125000000000000000000e-1), SC_(1.000000000000000000000000000000000000000), SC_(6.236020533309923323190540483306130837702e-59) }}, 
      {{ SC_(1.937891235351562500000000000000000000000e2), SC_(1.744102020263671875000000000000000000000e2), SC_(6.163340759277343750000000000000000000000e1), SC_(5.628146603703498840332031250000000000000e-2), SC_(2.767196369131228132503362466612106282736e-150), SC_(1.000000000000000000000000000000000000000) }}, 
      {{ SC_(1.937891235351562500000000000000000000000e2), SC_(1.744102020263671875000000000000000000000e2), SC_(1.486264953613281250000000000000000000000e2), SC_(6.057142838835716247558593750000000000000e-2), SC_(4.293748138078307110156771542133541117388e-161), SC_(1.000000000000000000000000000000000000000) }}, 
      {{ SC_(1.937891235351562500000000000000000000000e2), SC_(1.744102020263671875000000000000000000000e2), SC_(1.937735595703125000000000000000000000000e2), SC_(6.248257681727409362792968750000000000000e-2), SC_(3.442103485779505762634904557134732632351e-167), SC_(1.000000000000000000000000000000000000000) }}, 
      {{ SC_(1.937891235351562500000000000000000000000e2), SC_(1.918512268066406250000000000000000000000e2), SC_(7.225879669189453125000000000000000000000e1), SC_(1.362589150667190551757812500000000000000e-1), SC_(1.153500408127377812571004805369301508747e-77), SC_(1.000000000000000000000000000000000000000) }}, 
      {{ SC_(1.937891235351562500000000000000000000000e2), SC_(1.918512268066406250000000000000000000000e2), SC_(1.515480346679687500000000000000000000000e2), SC_(1.460156440734863281250000000000000000000e-1), SC_(6.568647736947597431098293223532873075165e-85), SC_(1.000000000000000000000000000000000000000) }}, 
      {{ SC_(1.937891235351562500000000000000000000000e2), SC_(1.918512268066406250000000000000000000000e2), SC_(1.941185607910156250000000000000000000000e2), SC_(1.505949348211288452148437500000000000000e-1), SC_(4.133716961056267153438748404665744651094e-89), SC_(1.000000000000000000000000000000000000000) }}, 
      {{ SC_(1.937891235351562500000000000000000000000e2), SC_(1.935953369140625000000000000000000000000e2), SC_(9.566968083381652832031250000000000000000e-1), SC_(2.504324316978454589843750000000000000000e-1), SC_(2.244369896009805283910850403438126090213e-26), SC_(9.999999999999999999999999775563010399019e-1) }}, 
      {{ SC_(1.937891235351562500000000000000000000000e2), SC_(1.935953369140625000000000000000000000000e2), SC_(7.844540405273437500000000000000000000000e1), SC_(2.730499207973480224609375000000000000000e-1), SC_(1.456480736371657027632066559850460483160e-29), SC_(9.999999999999999999999999999854351926363e-1) }}, 
      {{ SC_(1.937891235351562500000000000000000000000e2), SC_(1.935953369140625000000000000000000000000e2), SC_(1.584414672851562500000000000000000000000e2), SC_(2.924736142158508300781250000000000000000e-1), SC_(2.177268102564361504884477649011530525348e-33), SC_(9.999999999999999999999999999999978227319e-1) }}, 
      {{ SC_(1.937891235351562500000000000000000000000e2), SC_(1.935953369140625000000000000000000000000e2), SC_(1.962219390869140625000000000000000000000e2), SC_(3.005378544330596923828125000000000000000e-1), SC_(2.459367795863671100479630519660170486911e-35), SC_(9.999999999999999999999999999999999754063e-1) }}, 
      {{ SC_(1.937891235351562500000000000000000000000e2), SC_(1.937891235351562500000000000000000000000e2), SC_(7.142335891723632812500000000000000000000), SC_(3.784150481224060058593750000000000000000e-1), SC_(2.395002034958950234222758526960317161530e-7), SC_(9.999997604997965041049765777241473039683e-1) }}, 
      {{ SC_(1.937891235351562500000000000000000000000e2), SC_(1.937891235351562500000000000000000000000e2), SC_(7.974770355224609375000000000000000000000e1), SC_(4.099067449569702148437500000000000000000e-1), SC_(2.785839342300422376348041959410694737856e-8), SC_(9.999999721416065769957762365195804058931e-1) }}, 
      {{ SC_(1.937891235351562500000000000000000000000e2), SC_(1.937891235351562500000000000000000000000e2), SC_(1.595857238769531250000000000000000000000e2), SC_(4.389090538024902343750000000000000000000e-1), SC_(1.791183170511692522238486612635484587719e-9), SC_(9.999999982088168294883074777615133873645e-1) }}, 
      {{ SC_(1.937891235351562500000000000000000000000e2), SC_(1.937891235351562500000000000000000000000e2), SC_(1.985762634277343750000000000000000000000e2), SC_(4.513498544692993164062500000000000000000e-1), SC_(4.173804370892945525973063708597793983438e-10), SC_(9.999999995826195629107054474026936291402e-1) }}, 
      {{ SC_(1.937891235351562500000000000000000000000e2), SC_(1.938085021972656250000000000000000000000e2), SC_(1.950807952880859375000000000000000000000e1), SC_(4.609973728656768798828125000000000000000e-1), SC_(2.172245943349778499571190147577652074063e-2), SC_(9.782775405665022150042880985242234792594e-1) }}, 
      {{ SC_(1.937891235351562500000000000000000000000e2), SC_(1.938085021972656250000000000000000000000e2), SC_(8.435225677490234375000000000000000000000e1), SC_(4.940480887889862060546875000000000000000e-1), SC_(1.438299085162256028438934893501572933453e-2), SC_(9.856170091483774397156106510649842706655e-1) }}, 
      {{ SC_(1.937891235351562500000000000000000000000e2), SC_(1.938085021972656250000000000000000000000e2), SC_(1.596211700439453125000000000000000000000e2), SC_(5.266830921173095703125000000000000000000e-1), SC_(8.354770612347857398443892332078738513134e-3), SC_(9.916452293876521426015561076679212614869e-1) }}, 
      {{ SC_(1.937891235351562500000000000000000000000e2), SC_(1.938085021972656250000000000000000000000e2), SC_(1.992922668457031250000000000000000000000e2), SC_(5.418612360954284667968750000000000000000e-1), SC_(6.127349181675190457209281761247704163306e-3), SC_(9.938726508183248095427907182387522958367e-1) }}, 
      {{ SC_(1.937891235351562500000000000000000000000e2), SC_(1.939829254150390625000000000000000000000e2), SC_(2.197235107421875000000000000000000000000e1), SC_(5.083638429641723632812500000000000000000e-1), SC_(4.192836734512325746405474611189140145667e-1), SC_(5.807163265487674253594525388810859854333e-1) }}, 
      {{ SC_(1.937891235351562500000000000000000000000e2), SC_(1.939829254150390625000000000000000000000e2), SC_(8.441753387451171875000000000000000000000e1), SC_(5.432662367820739746093750000000000000000e-1), SC_(4.112114525075149460958079008403994274613e-1), SC_(5.887885474924850539041920991596005725387e-1) }}, 
      {{ SC_(1.937891235351562500000000000000000000000e2), SC_(1.939829254150390625000000000000000000000e2), SC_(1.600560913085937500000000000000000000000e2), SC_(5.793260335922241210937500000000000000000e-1), SC_(4.012587551693604667311084356663261230063e-1), SC_(5.987412448306395332688915643336738769937e-1) }}, 
      {{ SC_(1.937891235351562500000000000000000000000e2), SC_(1.957270202636718750000000000000000000000e2), SC_(2.249290275573730468750000000000000000000e1), SC_(5.110677480697631835937500000000000000000e-1), SC_(4.914382271824475978382819884233707682886e-1), SC_(5.085617728175524021617180115766292317114e-1) }}, 
      {{ SC_(1.937891235351562500000000000000000000000e2), SC_(1.957270202636718750000000000000000000000e2), SC_(9.495173645019531250000000000000000000000e1), SC_(5.514405369758605957031250000000000000000e-1), SC_(4.890614803943144245875724751634840021508e-1), SC_(5.109385196056855754124275248365159978492e-1) }}, 
      {{ SC_(1.937891235351562500000000000000000000000e2), SC_(1.957270202636718750000000000000000000000e2), SC_(1.629447326660156250000000000000000000000e2), SC_(5.836966633796691894531250000000000000000e-1), SC_(4.871023628082801459440202731897325761218e-1), SC_(5.128976371917198540559797268102674238782e-1) }}, 
      {{ SC_(1.937891235351562500000000000000000000000e2), SC_(2.131680450439453125000000000000000000000e2), SC_(2.539736366271972656250000000000000000000e1), SC_(4.920041859149932861328125000000000000000e-1), SC_(5.000020459113965078685241776548296213951e-1), SC_(4.999979540886034921314758223451703786049e-1) }}, 
      {{ SC_(1.937891235351562500000000000000000000000e2), SC_(2.131680450439453125000000000000000000000e2), SC_(9.707512664794921875000000000000000000000e1), SC_(5.318982005119323730468750000000000000000e-1), SC_(4.984754289445851067636608482121021655188e-1), SC_(5.015245710554148932363391517878978344812e-1) }}, 
      {{ SC_(1.937891235351562500000000000000000000000e2), SC_(2.131680450439453125000000000000000000000e2), SC_(1.670017089843750000000000000000000000000e2), SC_(5.652185678482055664062500000000000000000e-1), SC_(4.973039294241864894083789439747614688153e-1), SC_(5.026960705758135105916210560252385311847e-1) }}, 
      {{ SC_(1.937891235351562500000000000000000000000e2), SC_(2.325469512939453125000000000000000000000e2), SC_(2.709540176391601562500000000000000000000e1), SC_(4.713604152202606201171875000000000000000e-1), SC_(5.013944131343524546979168995002971326785e-1), SC_(4.986055868656475453020831004997028673215e-1) }}, 
      {{ SC_(1.937891235351562500000000000000000000000e2), SC_(2.325469512939453125000000000000000000000e2), SC_(1.007325439453125000000000000000000000000e2), SC_(5.121164917945861816406250000000000000000e-1), SC_(4.997964270077846217106467637808144246504e-1), SC_(5.002035729922153782893532362191855753496e-1) }}, 
      {{ SC_(1.937891235351562500000000000000000000000e2), SC_(2.325469512939453125000000000000000000000e2), SC_(1.698258666992187500000000000000000000000e2), SC_(5.450372695922851562500000000000000000000e-1), SC_(4.986145303567441406720961696373899411615e-1), SC_(5.013854696432558593279038303626100588385e-1) }}, 
      {{ SC_(1.937891235351562500000000000000000000000e2), SC_(2.519258575439453125000000000000000000000e2), SC_(2.837726783752441406250000000000000000000e1), SC_(4.527308642864227294921875000000000000000e-1), SC_(5.102204712841540632868075403709789568825e-1), SC_(4.897795287158459367131924596290210431175e-1) }}, 
      {{ SC_(1.937891235351562500000000000000000000000e2), SC_(2.519258575439453125000000000000000000000e2), SC_(1.093762969970703125000000000000000000000e2), SC_(4.969472885131835937500000000000000000000e-1), SC_(5.078576309084260893364713982166540266471e-1), SC_(4.921423690915739106635286017833459733529e-1) }}, 
      {{ SC_(1.937891235351562500000000000000000000000e2), SC_(2.519258575439453125000000000000000000000e2), SC_(1.756861267089843750000000000000000000000e2), SC_(5.281640887260437011718750000000000000000e-1), SC_(5.064017685818118004630365463983651761796e-1), SC_(4.935982314181881995369634536016348238204e-1) }}, 
      {{ SC_(1.937891235351562500000000000000000000000e2), SC_(2.906836853027343750000000000000000000000e2), SC_(3.152261734008789062500000000000000000000e1), SC_(4.246219098567962646484375000000000000000e-1), SC_(6.023035410754202414358871127619530802203e-1), SC_(3.976964589245797585641128872380469197797e-1) }}, 
      {{ SC_(1.937891235351562500000000000000000000000e2), SC_(2.906836853027343750000000000000000000000e2), SC_(1.094441146850585937500000000000000000000e2), SC_(4.661303162574768066406250000000000000000e-1), SC_(5.931033515730439784510409356671590039813e-1), SC_(4.068966484269560215489590643328409960187e-1) }}, 
      {{ SC_(1.937891235351562500000000000000000000000e2), SC_(2.906836853027343750000000000000000000000e2), SC_(1.811583862304687500000000000000000000000e2), SC_(4.993766248226165771484375000000000000000e-1), SC_(5.872739215004645612887119718491655390804e-1), SC_(4.127260784995354387112880281508344609196e-1) }}, 
      {{ SC_(1.937891235351562500000000000000000000000e2), SC_(3.875782470703125000000000000000000000000e2), SC_(3.423733520507812500000000000000000000000e1), SC_(4.112465977668762207031250000000000000000e-1), SC_(9.980690887026796245843563356441909034867e-1), SC_(1.930911297320375415643664355809096513329e-3) }}, 
      {{ SC_(1.937891235351562500000000000000000000000e2), SC_(3.875782470703125000000000000000000000000e2), SC_(1.264718551635742187500000000000000000000e2), SC_(4.533110857009887695312500000000000000000e-1), SC_(9.957287910445287298931245452027201686473e-1), SC_(4.271208955471270106875454797279831352723e-3) }}, 
      {{ SC_(1.937891235351562500000000000000000000000e2), SC_(3.875782470703125000000000000000000000000e2), SC_(1.826751708984375000000000000000000000000e2), SC_(4.761225283145904541015625000000000000000e-1), SC_(9.941751458524328852934895873020901519048e-1), SC_(5.824854147567114706510412697909848095198e-3) }}, 
      {{ SC_(1.937891235351562500000000000000000000000e2), SC_(5.813673706054687500000000000000000000000e2), SC_(3.477303314208984375000000000000000000000e1), SC_(3.886941075325012207031250000000000000000e-1), SC_(9.999999999992367923632416052904517415562e-1), SC_(7.632076367583947095482584438474866592316e-13) }}, 
      {{ SC_(1.937891235351562500000000000000000000000e2), SC_(5.813673706054687500000000000000000000000e2), SC_(1.279526672363281250000000000000000000000e2), SC_(4.225982129573822021484375000000000000000e-1), SC_(9.999999999419288046803370874752554274834e-1), SC_(5.807119531966291252474457251662710088193e-11) }}, 
      {{ SC_(1.937891235351562500000000000000000000000e2), SC_(5.813673706054687500000000000000000000000e2), SC_(1.831471099853515625000000000000000000000e2), SC_(4.409656822681427001953125000000000000000e-1), SC_(9.999999996943118675917034551189624527480e-1), SC_(3.056881324082965448810375472520237207618e-10) }}, 
      {{ SC_(1.937891235351562500000000000000000000000e2), SC_(7.751564941406250000000000000000000000000e2), SC_(3.767639541625976562500000000000000000000e1), SC_(3.963398039340972900390625000000000000000e-1), SC_(9.999999999999999999999999999999829802667e-1), SC_(1.701973330890419810089660826845978225110e-32) }}, 
      {{ SC_(1.937891235351562500000000000000000000000e2), SC_(7.751564941406250000000000000000000000000e2), SC_(1.310955810546875000000000000000000000000e2), SC_(4.235721826553344726562500000000000000000e-1), SC_(9.999999999999999999999999988873270874147e-1), SC_(1.112672912585261204162339397776334435758e-27) }}, 
      {{ SC_(1.937891235351562500000000000000000000000e2), SC_(7.751564941406250000000000000000000000000e2), SC_(1.867986450195312500000000000000000000000e2), SC_(4.386723339557647705078125000000000000000e-1), SC_(9.999999999999999999999999130044676241756e-1), SC_(8.699553237582441817256639546780917642315e-26) }}, 
      {{ SC_(1.937891235351562500000000000000000000000e2), SC_(9.689456176757812500000000000000000000000e2), SC_(4.238486480712890625000000000000000000000e1), SC_(4.543806910514831542968750000000000000000e-1), SC_(1.000000000000000000000000000000000000000), SC_(8.986701393907828570613711701957258296991e-83) }}, 
      {{ SC_(1.937891235351562500000000000000000000000e2), SC_(9.689456176757812500000000000000000000000e2), SC_(1.311481323242187500000000000000000000000e2), SC_(4.740802943706512451171875000000000000000e-1), SC_(1.000000000000000000000000000000000000000), SC_(1.934473166081834345234441543606015625836e-72) }}, 
      {{ SC_(1.937891235351562500000000000000000000000e2), SC_(9.689456176757812500000000000000000000000e2), SC_(1.914333953857421875000000000000000000000e2), SC_(4.866684973239898681640625000000000000000e-1), SC_(1.000000000000000000000000000000000000000), SC_(1.094938378084481897958778668318049981689e-67) }}, 
      {{ SC_(1.941332702636718750000000000000000000000e2), SC_(1.941332817077636718750000000000000000000e1), SC_(3.477303314208984375000000000000000000000e1), SC_(9.579539299011230468750000000000000000000e-1), SC_(9.969074318399386374680085790422392517201e-1), SC_(3.092568160061362531991420957760748279900e-3) }}, 
      {{ SC_(1.941332702636718750000000000000000000000e2), SC_(1.941332817077636718750000000000000000000e1), SC_(1.279526672363281250000000000000000000000e2), SC_(9.649949073791503906250000000000000000000e-1), SC_(9.966639345197397543521089785341704720057e-1), SC_(3.336065480260245647891021465829527994304e-3) }}, 
      {{ SC_(1.941332702636718750000000000000000000000e2), SC_(1.941332817077636718750000000000000000000e1), SC_(1.831471099853515625000000000000000000000e2), SC_(9.681560993194580078125000000000000000000e-1), SC_(9.965666696444046716886942975773218332016e-1), SC_(3.433330355595328311305702422678166798374e-3) }}, 
      {{ SC_(1.941332702636718750000000000000000000000e2), SC_(4.853331756591796875000000000000000000000e1), SC_(3.767639541625976562500000000000000000000e1), SC_(9.381188154220581054687500000000000000000e-1), SC_(9.999999999921433776007916289190356462668e-1), SC_(7.856622399208371080964353733249767524923e-12) }}, 
      {{ SC_(1.941332702636718750000000000000000000000e2), SC_(4.853331756591796875000000000000000000000e1), SC_(1.310955810546875000000000000000000000000e2), SC_(9.474750757217407226562500000000000000000e-1), SC_(9.999999999848570976825971354762382169517e-1), SC_(1.514290231740286452376178304834291878726e-11) }}, 
      {{ SC_(1.941332702636718750000000000000000000000e2), SC_(4.853331756591796875000000000000000000000e1), SC_(1.867986450195312500000000000000000000000e2), SC_(9.518215060234069824218750000000000000000e-1), SC_(9.999999999805033495684558993496798039860e-1), SC_(1.949665043154410065032019601399272464411e-11) }}, 
      {{ SC_(1.941332702636718750000000000000000000000e2), SC_(9.706663513183593750000000000000000000000e1), SC_(4.238486480712890625000000000000000000000e1), SC_(9.223030805587768554687500000000000000000e-1), SC_(9.999999999999999999999999999999926631961e-1), SC_(7.336803853792495371051598331961259408478e-33) }}, 
      {{ SC_(1.941332702636718750000000000000000000000e2), SC_(9.706663513183593750000000000000000000000e1), SC_(1.311481323242187500000000000000000000000e2), SC_(9.319480657577514648437500000000000000000e-1), SC_(9.999999999999999999999999999999042500053e-1), SC_(9.574999467238774584439134062574941183483e-32) }}, 
      {{ SC_(1.941332702636718750000000000000000000000e2), SC_(9.706663513183593750000000000000000000000e1), SC_(1.914333953857421875000000000000000000000e2), SC_(9.372418522834777832031250000000000000000e-1), SC_(9.999999999999999999999999999996980304622e-1), SC_(3.019695378176952256603703886896796826953e-31) }}, 
      {{ SC_(1.941332702636718750000000000000000000000e2), SC_(1.455999450683593750000000000000000000000e2), SC_(4.420680999755859375000000000000000000000e1), SC_(9.195081591606140136718750000000000000000e-1), SC_(1.000000000000000000000000000000000000000), SC_(1.540198421372889926176551511378294882707e-62) }}, 
      {{ SC_(1.941332702636718750000000000000000000000e2), SC_(1.455999450683593750000000000000000000000e2), SC_(1.357470245361328125000000000000000000000e2), SC_(9.285294413566589355468750000000000000000e-1), SC_(1.000000000000000000000000000000000000000), SC_(4.477399917705311891427654842040972082492e-60) }}, 
      {{ SC_(1.941332702636718750000000000000000000000e2), SC_(1.455999450683593750000000000000000000000e2), SC_(1.915013732910156250000000000000000000000e2), SC_(9.330981373786926269531250000000000000000e-1), SC_(1.000000000000000000000000000000000000000), SC_(4.532642837592484111988589849861531253207e-59) }}, 
      {{ SC_(1.941332702636718750000000000000000000000e2), SC_(1.747199401855468750000000000000000000000e2), SC_(5.569964599609375000000000000000000000000e1), SC_(5.594919994473457336425781250000000000000e-2), SC_(7.453933216766134472613005883781765875606e-150), SC_(1.000000000000000000000000000000000000000) }}, 
      {{ SC_(1.941332702636718750000000000000000000000e2), SC_(1.747199401855468750000000000000000000000e2), SC_(1.362719116210937500000000000000000000000e2), SC_(6.000306084752082824707031250000000000000e-2), SC_(1.004990056849688109852138100450976949274e-159), SC_(1.000000000000000000000000000000000000000) }}, 
      {{ SC_(1.941332702636718750000000000000000000000e2), SC_(1.747199401855468750000000000000000000000e2), SC_(1.918984832763671875000000000000000000000e2), SC_(6.239315494894981384277343750000000000000e-2), SC_(3.546273903165543256628509112115188511256e-167), SC_(1.000000000000000000000000000000000000000) }}, 
      {{ SC_(1.941332702636718750000000000000000000000e2), SC_(1.921919403076171875000000000000000000000e2), SC_(5.940588760375976562500000000000000000000e1), SC_(1.344880312681198120117187500000000000000e-1), SC_(1.058043119343248838643794872047396346768e-76), SC_(1.000000000000000000000000000000000000000) }}, 
      {{ SC_(1.941332702636718750000000000000000000000e2), SC_(1.921919403076171875000000000000000000000e2), SC_(1.451677856445312500000000000000000000000e2), SC_(1.452634781599044799804687500000000000000e-1), SC_(2.038016436161299772237472108659338670329e-84), SC_(1.000000000000000000000000000000000000000) }}, 
      {{ SC_(1.941332702636718750000000000000000000000e2), SC_(1.921919403076171875000000000000000000000e2), SC_(1.929777069091796875000000000000000000000e2), SC_(1.504422724246978759765625000000000000000e-1), SC_(4.088326809951800108279662684294129778294e-89), SC_(1.000000000000000000000000000000000000000) }}, 
      {{ SC_(1.941332702636718750000000000000000000000e2), SC_(1.939391326904296875000000000000000000000e2), SC_(6.038262176513671875000000000000000000000e1), SC_(2.681216597557067871093750000000000000000e-1), SC_(8.253807953666900746631432156039603642723e-29), SC_(9.999999999999999999999999999174619204633e-1) }}, 
      {{ SC_(1.941332702636718750000000000000000000000e2), SC_(1.939391326904296875000000000000000000000e2), SC_(1.481294555664062500000000000000000000000e2), SC_(2.900986671447753906250000000000000000000e-1), SC_(6.506055786179782792935564873177254082086e-33), SC_(9.999999999999999999999999999999934939442e-1) }}, 
      {{ SC_(1.941332702636718750000000000000000000000e2), SC_(1.939391326904296875000000000000000000000e2), SC_(1.935389862060546875000000000000000000000e2), SC_(2.999152243137359619140625000000000000000e-1), SC_(3.095432973794675177502162583749652833117e-35), SC_(9.999999999999999999999999999999999690457e-1) }}, 
      {{ SC_(1.941332702636718750000000000000000000000e2), SC_(1.941332702636718750000000000000000000000e2), SC_(6.163340759277343750000000000000000000000e1), SC_(4.025141596794128417968750000000000000000e-1), SC_(4.823397476264733906396766074901021142644e-8), SC_(9.999999517660252373526609360323392509898e-1) }}, 
      {{ SC_(1.941332702636718750000000000000000000000e2), SC_(1.941332702636718750000000000000000000000e2), SC_(1.486264953613281250000000000000000000000e2), SC_(4.351342916488647460937500000000000000000e-1), SC_(2.605878221661416362899885214299347870272e-9), SC_(9.999999973941217783385836371001147857007e-1) }}, 
      {{ SC_(1.941332702636718750000000000000000000000e2), SC_(1.941332702636718750000000000000000000000e2), SC_(1.937735595703125000000000000000000000000e2), SC_(4.497652351856231689453125000000000000000e-1), SC_(4.909291811361206828666684001496483160092e-10), SC_(9.999999995090708188638793171333315998504e-1) }}, 
      {{ SC_(1.941332702636718750000000000000000000000e2), SC_(1.941526794433593750000000000000000000000e2), SC_(7.225879669189453125000000000000000000000e1), SC_(4.882041811943054199218750000000000000000e-1), SC_(1.553820454682577304550238879880940115364e-2), SC_(9.844617954531742269544976112011905988464e-1) }}, 
      {{ SC_(1.941332702636718750000000000000000000000e2), SC_(1.941526794433593750000000000000000000000e2), SC_(1.515480346679687500000000000000000000000e2), SC_(5.233269333839416503906250000000000000000e-1), SC_(8.849644682000247278580330190127288314497e-3), SC_(9.911503553179997527214196698098727116855e-1) }}, 
      {{ SC_(1.941332702636718750000000000000000000000e2), SC_(1.941526794433593750000000000000000000000e2), SC_(1.941185607910156250000000000000000000000e2), SC_(5.398246049880981445312500000000000000000e-1), SC_(6.363815535392231434607946890679977607078e-3), SC_(9.936361844646077685653920531093200223929e-1) }}, 
      {{ SC_(1.941332702636718750000000000000000000000e2), SC_(1.943274078369140625000000000000000000000e2), SC_(9.566968083381652832031250000000000000000e-1), SC_(4.953601360321044921875000000000000000000e-1), SC_(4.218511253367059252662278101301409238186e-1), SC_(5.781488746632940747337721898698590761814e-1) }}, 
      {{ SC_(1.941332702636718750000000000000000000000e2), SC_(1.943274078369140625000000000000000000000e2), SC_(7.844540405273437500000000000000000000000e1), SC_(5.400751233100891113281250000000000000000e-1), SC_(4.119370967944685498716450569725590407001e-1), SC_(5.880629032055314501283549430274409592999e-1) }}, 
      {{ SC_(1.941332702636718750000000000000000000000e2), SC_(1.943274078369140625000000000000000000000e2), SC_(1.584414672851562500000000000000000000000e2), SC_(5.784937739372253417968750000000000000000e-1), SC_(4.014283461723085755325753529453976495162e-1), SC_(5.985716538276914244674246470546023504838e-1) }}, 
      {{ SC_(1.941332702636718750000000000000000000000e2), SC_(1.943274078369140625000000000000000000000e2), SC_(1.962219390869140625000000000000000000000e2), SC_(5.944491028785705566406250000000000000000e-1), SC_(3.964519903425274485551535257040184106734e-1), SC_(6.035480096574725514448464742959815893266e-1) }}, 
      {{ SC_(1.941332702636718750000000000000000000000e2), SC_(1.960746002197265625000000000000000000000e2), SC_(7.142335891723632812500000000000000000000), SC_(5.015559792518615722656250000000000000000e-1), SC_(4.919754177158904744423849377967803386166e-1), SC_(5.080245822841095255576150622032196613834e-1) }}, 
      {{ SC_(1.941332702636718750000000000000000000000e2), SC_(1.960746002197265625000000000000000000000e2), SC_(7.974770355224609375000000000000000000000e1), SC_(5.434569120407104492187500000000000000000e-1), SC_(4.895324216231338193057947228627495029149e-1), SC_(5.104675783768661806942052771372504970851e-1) }}, 
      {{ SC_(1.941332702636718750000000000000000000000e2), SC_(1.960746002197265625000000000000000000000e2), SC_(1.595857238769531250000000000000000000000e2), SC_(5.820873379707336425781250000000000000000e-1), SC_(4.871963055784873678338468768133722028368e-1), SC_(5.128036944215126321661531231866277971632e-1) }}, 
      {{ SC_(1.941332702636718750000000000000000000000e2), SC_(1.960746002197265625000000000000000000000e2), SC_(1.985762634277343750000000000000000000000e2), SC_(5.986704826354980468750000000000000000000e-1), SC_(4.861661129548725463631557284071861349714e-1), SC_(5.138338870451274536368442715928138650286e-1) }}, 
      {{ SC_(1.941332702636718750000000000000000000000e2), SC_(2.135466003417968750000000000000000000000e2), SC_(1.950807952880859375000000000000000000000e1), SC_(4.884015321731567382812500000000000000000e-1), SC_(5.001444866064001053986118313523725097687e-1), SC_(4.998555133935998946013881686476274902313e-1) }}, 
      {{ SC_(1.941332702636718750000000000000000000000e2), SC_(2.135466003417968750000000000000000000000e2), SC_(8.435225677490234375000000000000000000000e1), SC_(5.252011418342590332031250000000000000000e-1), SC_(4.987238521167203334897594421385228399241e-1), SC_(5.012761478832796665102405578614771600759e-1) }}, 
      {{ SC_(1.941332702636718750000000000000000000000e2), SC_(2.135466003417968750000000000000000000000e2), SC_(1.596211700439453125000000000000000000000e2), SC_(5.618000030517578125000000000000000000000e-1), SC_(4.974213669818845031411677647132587030276e-1), SC_(5.025786330181154968588322352867412969724e-1) }}, 
      {{ SC_(1.941332702636718750000000000000000000000e2), SC_(2.135466003417968750000000000000000000000e2), SC_(1.992922668457031250000000000000000000000e2), SC_(5.789112448692321777343750000000000000000e-1), SC_(4.968577113270446703893397398652559779698e-1), SC_(5.031422886729553296106602601347440220302e-1) }}, 
      {{ SC_(1.941332702636718750000000000000000000000e2), SC_(2.329599304199218750000000000000000000000e2), SC_(2.197235107421875000000000000000000000000e1), SC_(4.682471454143524169921875000000000000000e-1), SC_(5.015214981727102837716037507602828940437e-1), SC_(4.984785018272897162283962492397171059563e-1) }}, 
      {{ SC_(1.941332702636718750000000000000000000000e2), SC_(2.329599304199218750000000000000000000000e2), SC_(8.441753387451171875000000000000000000000e1), SC_(5.035578608512878417968750000000000000000e-1), SC_(5.001217800861988743187111207603434418882e-1), SC_(4.998782199138011256812888792396565581118e-1) }}, 
      {{ SC_(1.941332702636718750000000000000000000000e2), SC_(2.329599304199218750000000000000000000000e2), SC_(1.600560913085937500000000000000000000000e2), SC_(5.405257940292358398437500000000000000000e-1), SC_(4.987721325781064402630302346799142823646e-1), SC_(5.012278674218935597369697653200857176354e-1) }}, 
      {{ SC_(1.941332702636718750000000000000000000000e2), SC_(2.523732452392578125000000000000000000000e2), SC_(2.249290275573730468750000000000000000000e1), SC_(4.491905868053436279296875000000000000000e-1), SC_(5.104321515423743703134458264234545710603e-1), SC_(4.895678484576256296865541735765454289397e-1) }}, 
      {{ SC_(1.941332702636718750000000000000000000000e2), SC_(2.523732452392578125000000000000000000000e2), SC_(9.495173645019531250000000000000000000000e1), SC_(4.895158708095550537109375000000000000000e-1), SC_(5.082380679412339534862241882572231032298e-1), SC_(4.917619320587660465137758117427768967702e-1) }}, 
      {{ SC_(1.941332702636718750000000000000000000000e2), SC_(2.523732452392578125000000000000000000000e2), SC_(1.629447326660156250000000000000000000000e2), SC_(5.223392248153686523437500000000000000000e-1), SC_(5.066696992357752585622329053057176881991e-1), SC_(4.933303007642247414377670946942823118009e-1) }}, 
      {{ SC_(1.941332702636718750000000000000000000000e2), SC_(2.911998901367187500000000000000000000000e2), SC_(2.539736366271972656250000000000000000000e1), SC_(4.210581183433532714843750000000000000000e-1), SC_(6.033068908344877309723280950360699672726e-1), SC_(3.966931091655122690276719049639300327274e-1) }}, 
      {{ SC_(1.941332702636718750000000000000000000000e2), SC_(2.911998901367187500000000000000000000000e2), SC_(9.707512664794921875000000000000000000000e1), SC_(4.598583281040191650390625000000000000000e-1), SC_(5.944208212903648381325911378640699372070e-1), SC_(4.055791787096351618674088621359300627930e-1) }}, 
      {{ SC_(1.941332702636718750000000000000000000000e2), SC_(2.911998901367187500000000000000000000000e2), SC_(1.670017089843750000000000000000000000000e2), SC_(4.930135607719421386718750000000000000000e-1), SC_(5.883823606921262990886111253259731029077e-1), SC_(4.116176393078737009113888746740268970923e-1) }}, 
      {{ SC_(1.941332702636718750000000000000000000000e2), SC_(3.882665405273437500000000000000000000000e2), SC_(2.709540176391601562500000000000000000000e1), SC_(4.076943993568420410156250000000000000000e-1), SC_(9.982427684560697406454570508473318155726e-1), SC_(1.757231543930259354542949152668184427442e-3) }}, 
      {{ SC_(1.941332702636718750000000000000000000000e2), SC_(3.882665405273437500000000000000000000000e2), SC_(1.007325439453125000000000000000000000000e2), SC_(4.421098232269287109375000000000000000000e-1), SC_(9.964518914693875147868766761816826720673e-1), SC_(3.548108530612485213123323818317327932713e-3) }}, 
      {{ SC_(1.941332702636718750000000000000000000000e2), SC_(3.882665405273437500000000000000000000000e2), SC_(1.698258666992187500000000000000000000000e2), SC_(4.709573984146118164062500000000000000000e-1), SC_(9.945759447695889791997062169142194095542e-1), SC_(5.424055230411020800293783085780590445810e-3) }}, 
      {{ SC_(1.941332702636718750000000000000000000000e2), SC_(5.823997802734375000000000000000000000000e2), SC_(2.837726783752441406250000000000000000000e1), SC_(3.862010538578033447265625000000000000000e-1), SC_(9.999999999995193158770065953418128437443e-1), SC_(4.806841229934046581871562557413927781057e-13) }}, 
      {{ SC_(1.941332702636718750000000000000000000000e2), SC_(5.823997802734375000000000000000000000000e2), SC_(1.093762969970703125000000000000000000000e2), SC_(4.160741567611694335937500000000000000000e-1), SC_(9.999999999717974265570380830583282855623e-1), SC_(2.820257344296191694167171443767289362095e-11) }}, 
      {{ SC_(1.941332702636718750000000000000000000000e2), SC_(5.823997802734375000000000000000000000000e2), SC_(1.756861267089843750000000000000000000000e2), SC_(4.384502470493316650390625000000000000000e-1), SC_(9.999999997601842221408837933725606348179e-1), SC_(2.398157778591162066274393651821406345883e-10) }}, 
      {{ SC_(1.941332702636718750000000000000000000000e2), SC_(7.765330810546875000000000000000000000000e2), SC_(3.152261734008789062500000000000000000000e1), SC_(3.944382667541503906250000000000000000000e-1), SC_(9.999999999999999999999999999999945689005e-1), SC_(5.431099452560142906413077706679204990962e-33) }}, 
      {{ SC_(1.941332702636718750000000000000000000000e2), SC_(7.765330810546875000000000000000000000000e2), SC_(1.094441146850585937500000000000000000000e2), SC_(4.174263775348663330078125000000000000000e-1), SC_(9.999999999999999999999999998737096780644e-1), SC_(1.262903219356421334150392457344808860924e-28) }}, 
      {{ SC_(1.941332702636718750000000000000000000000e2), SC_(7.765330810546875000000000000000000000000e2), SC_(1.811583862304687500000000000000000000000e2), SC_(4.370942711830139160156250000000000000000e-1), SC_(9.999999999999999999999999479122912902961e-1), SC_(5.208770870970385462430601110674207621782e-26) }}, 
      {{ SC_(1.941332702636718750000000000000000000000e2), SC_(9.706663818359375000000000000000000000000e2), SC_(3.423733520507812500000000000000000000000e1), SC_(4.524842798709869384765625000000000000000e-1), SC_(1.000000000000000000000000000000000000000), SC_(3.253122798519024713533778240915885417593e-84) }}, 
      {{ SC_(1.941332702636718750000000000000000000000e2), SC_(9.706663818359375000000000000000000000000e2), SC_(1.264718551635742187500000000000000000000e2), SC_(4.730298817157745361328125000000000000000e-1), SC_(1.000000000000000000000000000000000000000), SC_(5.179445639743224487317853870009703697504e-73) }}, 
      {{ SC_(1.941332702636718750000000000000000000000e2), SC_(9.706663818359375000000000000000000000000e2), SC_(1.826751708984375000000000000000000000000e2), SC_(4.848107695579528808593750000000000000000e-1), SC_(1.000000000000000000000000000000000000000), SC_(1.914899584459828923914585160971084667895e-68) }}, 
      {{ SC_(1.962313842773437500000000000000000000000e2), SC_(1.962313842773437500000000000000000000000e1), SC_(2.837726783752441406250000000000000000000e1), SC_(9.573375582695007324218750000000000000000e-1), SC_(9.970725337793103931850727060547256957899e-1), SC_(2.927466220689606814927293945274304210077e-3) }}, 
      {{ SC_(1.962313842773437500000000000000000000000e2), SC_(1.962313842773437500000000000000000000000e1), SC_(1.093762969970703125000000000000000000000e2), SC_(9.637066125869750976562500000000000000000e-1), SC_(9.968561916084230005362658312521635183546e-1), SC_(3.143808391576999463734168747836481645443e-3) }}, 
      {{ SC_(1.962313842773437500000000000000000000000e2), SC_(1.962313842773437500000000000000000000000e1), SC_(1.756861267089843750000000000000000000000e2), SC_(9.676622152328491210937500000000000000000e-1), SC_(9.967364482616788100090436530344713010741e-1), SC_(3.263551738321189990956346965528698925867e-3) }}, 
      {{ SC_(1.962313842773437500000000000000000000000e2), SC_(4.905784606933593750000000000000000000000e1), SC_(3.152261734008789062500000000000000000000e1), SC_(9.373439550399780273437500000000000000000e-1), SC_(9.999999999942755396787324507016884633769e-1), SC_(5.724460321267549298311536623119878018412e-12) }}, 
      {{ SC_(1.962313842773437500000000000000000000000e2), SC_(4.905784606933593750000000000000000000000e1), SC_(1.094441146850585937500000000000000000000e2), SC_(9.454602003097534179687500000000000000000e-1), SC_(9.999999999896036659248177906286593836693e-1), SC_(1.039633407518220937134061633072547032897e-11) }}, 
      {{ SC_(1.962313842773437500000000000000000000000e2), SC_(4.905784606933593750000000000000000000000e1), SC_(1.811583862304687500000000000000000000000e2), SC_(9.512733221054077148437500000000000000000e-1), SC_(9.999999999851905407459823109815516296873e-1), SC_(1.480945925401768901844837031271451360425e-11) }}, 
      {{ SC_(1.962313842773437500000000000000000000000e2), SC_(9.811569213867187500000000000000000000000e1), SC_(3.423733520507812500000000000000000000000e1), SC_(9.212329387664794921875000000000000000000e-1), SC_(9.999999999999999999999999999999975733488e-1), SC_(2.426651167803587898119307070822273310304e-33) }}, 
      {{ SC_(1.962313842773437500000000000000000000000e2), SC_(9.811569213867187500000000000000000000000e1), SC_(1.264718551635742187500000000000000000000e2), SC_(9.313696622848510742187500000000000000000e-1), SC_(9.999999999999999999999999999999603366297e-1), SC_(3.966337025888282510358901041389655211569e-32) }}, 
      {{ SC_(1.962313842773437500000000000000000000000e2), SC_(9.811569213867187500000000000000000000000e1), SC_(1.826751708984375000000000000000000000000e2), SC_(9.363625645637512207031250000000000000000e-1), SC_(9.999999999999999999999999999998789224771e-1), SC_(1.210775228772565588636689935690692457955e-31) }}, 
      {{ SC_(1.962313842773437500000000000000000000000e2), SC_(1.471735382080078125000000000000000000000e2), SC_(3.477303314208984375000000000000000000000e1), SC_(9.184053540229797363281250000000000000000e-1), SC_(1.000000000000000000000000000000000000000), SC_(1.486759035733609782323969155564371378134e-63) }}, 
      {{ SC_(1.962313842773437500000000000000000000000e2), SC_(1.471735382080078125000000000000000000000e2), SC_(1.279526672363281250000000000000000000000e2), SC_(9.277186989784240722656250000000000000000e-1), SC_(1.000000000000000000000000000000000000000), SC_(6.726314632893177386544815949495852015137e-61) }}, 
      {{ SC_(1.962313842773437500000000000000000000000e2), SC_(1.471735382080078125000000000000000000000e2), SC_(1.831471099853515625000000000000000000000e2), SC_(9.322978854179382324218750000000000000000e-1), SC_(1.000000000000000000000000000000000000000), SC_(7.428375629278061032166332897679027047540e-60) }}, 
      {{ SC_(1.962313842773437500000000000000000000000e2), SC_(1.766082458496093750000000000000000000000e2), SC_(3.767639541625976562500000000000000000000e1), SC_(5.490428209304809570312500000000000000000e-2), SC_(2.273655990852671475781419365934354357145e-149), SC_(1.000000000000000000000000000000000000000) }}, 
      {{ SC_(1.962313842773437500000000000000000000000e2), SC_(1.766082458496093750000000000000000000000e2), SC_(1.310955810546875000000000000000000000000e2), SC_(5.970037728548049926757812500000000000000e-2), SC_(1.444921967630908139663196535146567178897e-160), SC_(1.000000000000000000000000000000000000000) }}, 
      {{ SC_(1.962313842773437500000000000000000000000e2), SC_(1.766082458496093750000000000000000000000e2), SC_(1.867986450195312500000000000000000000000e2), SC_(6.210438162088394165039062500000000000000e-2), SC_(5.644982688153054508773610972383948443204e-168), SC_(1.000000000000000000000000000000000000000) }}, 
      {{ SC_(1.962313842773437500000000000000000000000e2), SC_(1.942690734863281250000000000000000000000e2), SC_(4.238486480712890625000000000000000000000e1), SC_(1.320156008005142211914062500000000000000e-1), SC_(4.590216931762585961954132934648868877746e-76), SC_(1.000000000000000000000000000000000000000) }}, 
      {{ SC_(1.962313842773437500000000000000000000000e2), SC_(1.942690734863281250000000000000000000000e2), SC_(1.311481323242187500000000000000000000000e2), SC_(1.434766650199890136718750000000000000000e-1), SC_(7.890223848386623980948041542755804567070e-84), SC_(1.000000000000000000000000000000000000000) }}, 
      {{ SC_(1.962313842773437500000000000000000000000e2), SC_(1.942690734863281250000000000000000000000e2), SC_(1.914333953857421875000000000000000000000e2), SC_(1.500715315341949462890625000000000000000e-1), SC_(1.087271742183535342957781102853587525745e-89), SC_(1.000000000000000000000000000000000000000) }}, 
      {{ SC_(1.962313842773437500000000000000000000000e2), SC_(1.960351562500000000000000000000000000000e2), SC_(4.420680999755859375000000000000000000000e1), SC_(2.634235024452209472656250000000000000000e-1), SC_(2.194289070041681782259396921779112899091e-28), SC_(9.999999999999999999999999997805710929958e-1) }}, 
      {{ SC_(1.962313842773437500000000000000000000000e2), SC_(1.960351562500000000000000000000000000000e2), SC_(1.357470245361328125000000000000000000000e2), SC_(2.869148850440979003906250000000000000000e-1), SC_(1.477389715095836344820287387155147308237e-32), SC_(9.999999999999999999999999999999852261028e-1) }}, 
      {{ SC_(1.962313842773437500000000000000000000000e2), SC_(1.960351562500000000000000000000000000000e2), SC_(1.915013732910156250000000000000000000000e2), SC_(2.990706562995910644531250000000000000000e-1), SC_(2.225309072273260391780392115350235769192e-35), SC_(9.999999999999999999999999999999999777469e-1) }}, 
      {{ SC_(1.962313842773437500000000000000000000000e2), SC_(1.962313842773437500000000000000000000000e2), SC_(5.569964599609375000000000000000000000000e1), SC_(3.997922539710998535156250000000000000000e-1), SC_(5.040469585522122251996065679252944179392e-8), SC_(9.999999495953041447787774800393432074706e-1) }}, 
      {{ SC_(1.962313842773437500000000000000000000000e2), SC_(1.962313842773437500000000000000000000000e2), SC_(1.362719116210937500000000000000000000000e2), SC_(4.303708076477050781250000000000000000000e-1), SC_(3.541725207401486843853439403650858950076e-9), SC_(9.999999964582747925985131561465605963491e-1) }}, 
      {{ SC_(1.962313842773437500000000000000000000000e2), SC_(1.962313842773437500000000000000000000000e2), SC_(1.918984832763671875000000000000000000000e2), SC_(4.485480785369873046875000000000000000000e-1), SC_(4.640561272588958087907711651277480684820e-10), SC_(9.999999995359438727411041912092288348723e-1) }}, 
      {{ SC_(1.962313842773437500000000000000000000000e2), SC_(1.962510070800781250000000000000000000000e2), SC_(5.940588760375976562500000000000000000000e1), SC_(4.815692007541656494140625000000000000000e-1), SC_(1.649836109487022076221215898334544010481e-2), SC_(9.835016389051297792377878410166545598952e-1) }}, 
      {{ SC_(1.962313842773437500000000000000000000000e2), SC_(1.962510070800781250000000000000000000000e2), SC_(1.451677856445312500000000000000000000000e2), SC_(5.200859904289245605468750000000000000000e-1), SC_(9.078019625146986054692390411607170570895e-3), SC_(9.909219803748530139453076095883928294291e-1) }}, 
      {{ SC_(1.962313842773437500000000000000000000000e2), SC_(1.962510070800781250000000000000000000000e2), SC_(1.929777069091796875000000000000000000000e2), SC_(5.386348366737365722656250000000000000000e-1), SC_(6.288006327698217936650696459725923157381e-3), SC_(9.937119936723017820633493035402740768426e-1) }}, 
      {{ SC_(1.962313842773437500000000000000000000000e2), SC_(1.964276275634765625000000000000000000000e2), SC_(6.038262176513671875000000000000000000000e1), SC_(5.300354361534118652343750000000000000000e-1), SC_(4.139327286572288735694081589849295212900e-1), SC_(5.860672713427711264305918410150704787100e-1) }}, 
      {{ SC_(1.962313842773437500000000000000000000000e2), SC_(1.964276275634765625000000000000000000000e2), SC_(1.481294555664062500000000000000000000000e2), SC_(5.732020735740661621093750000000000000000e-1), SC_(4.025130902687918619986070707373059165585e-1), SC_(5.974869097312081380013929292626940834415e-1) }}, 
      {{ SC_(1.962313842773437500000000000000000000000e2), SC_(1.964276275634765625000000000000000000000e2), SC_(1.935389862060546875000000000000000000000e2), SC_(5.925121307373046875000000000000000000000e-1), SC_(3.965730840150299770651235667240343966307e-1), SC_(6.034269159849700229348764332759656033693e-1) }}, 
      {{ SC_(1.962313842773437500000000000000000000000e2), SC_(1.981936950683593750000000000000000000000e2), SC_(6.163340759277343750000000000000000000000e1), SC_(5.333138108253479003906250000000000000000e-1), SC_(4.900963545832243407400222765588235617597e-1), SC_(5.099036454167756592599777234411764382403e-1) }}, 
      {{ SC_(1.962313842773437500000000000000000000000e2), SC_(1.981936950683593750000000000000000000000e2), SC_(1.486264953613281250000000000000000000000e2), SC_(5.764561891555786132812500000000000000000e-1), SC_(4.875053772307311545322745841726974619464e-1), SC_(5.124946227692688454677254158273025380536e-1) }}, 
      {{ SC_(1.962313842773437500000000000000000000000e2), SC_(1.981936950683593750000000000000000000000e2), SC_(1.937735595703125000000000000000000000000e2), SC_(5.958447456359863281250000000000000000000e-1), SC_(4.863088148531051846142582778655292197660e-1), SC_(5.136911851468948153857417221344707802340e-1) }}, 
      {{ SC_(1.962313842773437500000000000000000000000e2), SC_(2.158545227050781250000000000000000000000e2), SC_(7.225879669189453125000000000000000000000e1), SC_(5.183266997337341308593750000000000000000e-1), SC_(4.989878202169512965277701303206186097139e-1), SC_(5.010121797830487034722298696793813902861e-1) }}, 
      {{ SC_(1.962313842773437500000000000000000000000e2), SC_(2.158545227050781250000000000000000000000e2), SC_(1.515480346679687500000000000000000000000e2), SC_(5.574073195457458496093750000000000000000e-1), SC_(4.975842938191940331420600036314177410636e-1), SC_(5.024157061808059668579399963685822589364e-1) }}, 
      {{ SC_(1.962313842773437500000000000000000000000e2), SC_(2.158545227050781250000000000000000000000e2), SC_(1.941185607910156250000000000000000000000e2), SC_(5.758864879608154296875000000000000000000e-1), SC_(4.969710915123290319010686258339997625439e-1), SC_(5.030289084876709680989313741660002374561e-1) }}, 
      {{ SC_(1.962313842773437500000000000000000000000e2), SC_(2.354776763916015625000000000000000000000e2), SC_(9.566968083381652832031250000000000000000e-1), SC_(4.552022218704223632812500000000000000000e-1), SC_(5.020515955345417129880641375409943421350e-1), SC_(4.979484044654582870119358624590056578650e-1) }}, 
      {{ SC_(1.962313842773437500000000000000000000000e2), SC_(2.354776763916015625000000000000000000000e2), SC_(7.844540405273437500000000000000000000000e1), SC_(4.999365210533142089843750000000000000000e-1), SC_(5.002682244635445310969461636035457217461e-1), SC_(4.997317755364554689030538363964542782539e-1) }}, 
      {{ SC_(1.962313842773437500000000000000000000000e2), SC_(2.354776763916015625000000000000000000000e2), SC_(1.584414672851562500000000000000000000000e2), SC_(5.390256047248840332031250000000000000000e-1), SC_(4.988402157094386919645089914253009395799e-1), SC_(5.011597842905613080354910085746990604201e-1) }}, 
      {{ SC_(1.962313842773437500000000000000000000000e2), SC_(2.354776763916015625000000000000000000000e2), SC_(1.962219390869140625000000000000000000000e2), SC_(5.554407238960266113281250000000000000000e-1), SC_(4.982858402202454005421130264344773309982e-1), SC_(5.017141597797545994578869735655226690018e-1) }}, 
      {{ SC_(1.962313842773437500000000000000000000000e2), SC_(2.551007843017578125000000000000000000000e2), SC_(7.142335891723632812500000000000000000000), SC_(4.397703707218170166015625000000000000000e-1), SC_(5.110291943093093104711900232045776941871e-1), SC_(4.889708056906906895288099767954223058129e-1) }}, 
      {{ SC_(1.962313842773437500000000000000000000000e2), SC_(2.551007843017578125000000000000000000000e2), SC_(7.974770355224609375000000000000000000000e1), SC_(4.810974597930908203125000000000000000000e-1), SC_(5.087189312395667213630424059275134557569e-1), SC_(4.912810687604332786369575940724865442431e-1) }}, 
      {{ SC_(1.962313842773437500000000000000000000000e2), SC_(2.551007843017578125000000000000000000000e2), SC_(1.595857238769531250000000000000000000000e2), SC_(5.200414657592773437500000000000000000000e-1), SC_(5.068263249047159379169995337610640107296e-1), SC_(4.931736750952840620830004662389359892704e-1) }}, 
      {{ SC_(1.962313842773437500000000000000000000000e2), SC_(2.551007843017578125000000000000000000000e2), SC_(1.985762634277343750000000000000000000000e2), SC_(5.370141863822937011718750000000000000000e-1), SC_(5.060828335964098370501229849091599481190e-1), SC_(4.939171664035901629498770150908400518810e-1) }}, 
      {{ SC_(1.962313842773437500000000000000000000000e2), SC_(2.943470764160156250000000000000000000000e2), SC_(1.950807952880859375000000000000000000000e1), SC_(4.174991548061370849609375000000000000000e-1), SC_(6.047759494331017440705128953131730412833e-1), SC_(3.952240505668982559294871046868269587167e-1) }}, 
      {{ SC_(1.962313842773437500000000000000000000000e2), SC_(2.943470764160156250000000000000000000000e2), SC_(8.435225677490234375000000000000000000000e1), SC_(4.528886973857879638671875000000000000000e-1), SC_(5.963535501274153788656428592230008107377e-1), SC_(4.036464498725846211343571407769991892623e-1) }}, 
      {{ SC_(1.962313842773437500000000000000000000000e2), SC_(2.943470764160156250000000000000000000000e2), SC_(1.596211700439453125000000000000000000000e2), SC_(4.889378845691680908203125000000000000000e-1), SC_(5.895411032149224269335531557184236373837e-1), SC_(4.104588967850775730664468442815763626163e-1) }}, 
      {{ SC_(1.962313842773437500000000000000000000000e2), SC_(2.943470764160156250000000000000000000000e2), SC_(1.992922668457031250000000000000000000000e2), SC_(5.060929059982299804687500000000000000000e-1), SC_(5.867738815271522845479204697957740041492e-1), SC_(4.132261184728477154520795302042259958508e-1) }}, 
      {{ SC_(1.962313842773437500000000000000000000000e2), SC_(3.924627685546875000000000000000000000000e2), SC_(2.197235107421875000000000000000000000000e1), SC_(4.050242900848388671875000000000000000000e-1), SC_(9.984388436640015452724029136601312991722e-1), SC_(1.561156335998454727597086339868700827809e-3) }}, 
      {{ SC_(1.962313842773437500000000000000000000000e2), SC_(3.924627685546875000000000000000000000000e2), SC_(8.441753387451171875000000000000000000000e1), SC_(4.344261884689331054687500000000000000000e-1), SC_(9.970347729372029309085270150337316079749e-1), SC_(2.965227062797069091472984966268392025086e-3) }}, 
      {{ SC_(1.962313842773437500000000000000000000000e2), SC_(3.924627685546875000000000000000000000000e2), SC_(1.600560913085937500000000000000000000000e2), SC_(4.663730561733245849609375000000000000000e-1), SC_(9.950926406184121087313931927725143616163e-1), SC_(4.907359381587891268606807227485638383715e-3) }}, 
      {{ SC_(1.962313842773437500000000000000000000000e2), SC_(5.886941528320312500000000000000000000000e2), SC_(2.249290275573730468750000000000000000000e1), SC_(3.838176429271697998046875000000000000000e-1), SC_(9.999999999997613646403039047455886201774e-1), SC_(2.386353596960952544113798225857583543126e-13) }}, 
      {{ SC_(1.962313842773437500000000000000000000000e2), SC_(5.886941528320312500000000000000000000000e2), SC_(9.495173645019531250000000000000000000000e1), SC_(4.106063842773437500000000000000000000000e-1), SC_(9.999999999881025119828239736230979286685e-1), SC_(1.189748801717602637690207133148027342248e-11) }}, 
      {{ SC_(1.962313842773437500000000000000000000000e2), SC_(5.886941528320312500000000000000000000000e2), SC_(1.629447326660156250000000000000000000000e2), SC_(4.337109029293060302734375000000000000000e-1), SC_(9.999999998718031933770831762011965223080e-1), SC_(1.281968066229168237988034776919645367306e-10) }}, 
      {{ SC_(1.962313842773437500000000000000000000000e2), SC_(7.849255371093750000000000000000000000000e2), SC_(2.539736366271972656250000000000000000000e1), SC_(3.924704492092132568359375000000000000000e-1), SC_(9.999999999999999999999999999999991737428e-1), SC_(8.262572411652129230433552824957307003835e-34) }}, 
      {{ SC_(1.962313842773437500000000000000000000000e2), SC_(7.849255371093750000000000000000000000000e2), SC_(9.707512664794921875000000000000000000000e1), SC_(4.135964214801788330078125000000000000000e-1), SC_(9.999999999999999999999999999841319606330e-1), SC_(1.586803936704237831322900289107001991895e-29) }}, 
      {{ SC_(1.962313842773437500000000000000000000000e2), SC_(7.849255371093750000000000000000000000000e2), SC_(1.670017089843750000000000000000000000000e2), SC_(4.328380525112152099609375000000000000000e-1), SC_(9.999999999999999999999999911772065987760e-1), SC_(8.822793401223987378386914193183140615161e-27) }}, 
      {{ SC_(1.962313842773437500000000000000000000000e2), SC_(9.811569213867187500000000000000000000000e2), SC_(2.709540176391601562500000000000000000000e1), SC_(4.507590234279632568359375000000000000000e-1), SC_(1.000000000000000000000000000000000000000), SC_(2.308296444284175902849560187685092297105e-86) }}, 
      {{ SC_(1.962313842773437500000000000000000000000e2), SC_(9.811569213867187500000000000000000000000e2), SC_(1.007325439453125000000000000000000000000e2), SC_(4.672172367572784423828125000000000000000e-1), SC_(1.000000000000000000000000000000000000000), SC_(1.859167341769050131537440590907430241920e-76) }}, 
      {{ SC_(1.962313842773437500000000000000000000000e2), SC_(9.811569213867187500000000000000000000000e2), SC_(1.698258666992187500000000000000000000000e2), SC_(4.817881286144256591796875000000000000000e-1), SC_(1.000000000000000000000000000000000000000), SC_(2.948549056323347873506807230619227872644e-70) }}, 
      {{ SC_(1.985798187255859375000000000000000000000e2), SC_(1.985798263549804687500000000000000000000e1), SC_(2.249290275573730468750000000000000000000e1), SC_(9.567619562149047851562500000000000000000e-1), SC_(9.972437200818865638126689418497411054568e-1), SC_(2.756279918113436187331058150258894543193e-3) }}, 
      {{ SC_(1.985798187255859375000000000000000000000e2), SC_(1.985798263549804687500000000000000000000e1), SC_(9.495173645019531250000000000000000000000e1), SC_(9.626357555389404296875000000000000000000e-1), SC_(9.970493468246316776490659128483012902772e-1), SC_(2.950653175368322350934087151698709722768e-3) }}, 
      {{ SC_(1.985798187255859375000000000000000000000e2), SC_(1.985798263549804687500000000000000000000e1), SC_(1.629447326660156250000000000000000000000e2), SC_(9.668634533882141113281250000000000000000e-1), SC_(9.969237915043596384824369131002388432836e-1), SC_(3.076208495640361517563086899761156716418e-3) }}, 
      {{ SC_(1.985798187255859375000000000000000000000e2), SC_(4.964495468139648437500000000000000000000e1), SC_(2.539736366271972656250000000000000000000e1), SC_(9.365660548210144042968750000000000000000e-1), SC_(9.999999999959655076875284370673775196535e-1), SC_(4.034492312471562932622480346483934440344e-12) }}, 
      {{ SC_(1.985798187255859375000000000000000000000e2), SC_(4.964495468139648437500000000000000000000e1), SC_(9.707512664794921875000000000000000000000e1), SC_(9.442064166069030761718750000000000000000e-1), SC_(9.999999999927670610240840543922963806092e-1), SC_(7.232938975915945607703619390791060158678e-12) }}, 
      {{ SC_(1.985798187255859375000000000000000000000e2), SC_(4.964495468139648437500000000000000000000e1), SC_(1.670017089843750000000000000000000000000e2), SC_(9.500765800476074218750000000000000000000e-1), SC_(9.999999999894907191368275737661017450864e-1), SC_(1.050928086317242623389825491364672073283e-11) }}, 
      {{ SC_(1.985798187255859375000000000000000000000e2), SC_(9.928990936279296875000000000000000000000e1), SC_(2.709540176391601562500000000000000000000e1), SC_(9.202808141708374023437500000000000000000e-1), SC_(9.999999999999999999999999999999992529919e-1), SC_(7.470081062120351595347797505669637893117e-34) }}, 
      {{ SC_(1.985798187255859375000000000000000000000e2), SC_(9.928990936279296875000000000000000000000e1), SC_(1.007325439453125000000000000000000000000e2), SC_(9.286897778511047363281250000000000000000e-1), SC_(9.999999999999999999999999999999912004850e-1), SC_(8.799515001815640357040142248667483251725e-33) }}, 
      {{ SC_(1.985798187255859375000000000000000000000e2), SC_(9.928990936279296875000000000000000000000e1), SC_(1.698258666992187500000000000000000000000e2), SC_(9.351149797439575195312500000000000000000e-1), SC_(9.999999999999999999999999999999592862665e-1), SC_(4.071373349460481426824668938942676243913e-32) }}, 
      {{ SC_(1.985798187255859375000000000000000000000e2), SC_(1.489348602294921875000000000000000000000e2), SC_(2.837726783752441406250000000000000000000e1), SC_(9.176391363143920898437500000000000000000e-1), SC_(1.000000000000000000000000000000000000000), SC_(1.488066495103821190872004792761361152470e-64) }}, 
      {{ SC_(1.985798187255859375000000000000000000000e2), SC_(1.489348602294921875000000000000000000000e2), SC_(1.093762969970703125000000000000000000000e2), SC_(9.259153604507446289062500000000000000000e-1), SC_(1.000000000000000000000000000000000000000), SC_(4.623242927220404887404246633946581984988e-62) }}, 
      {{ SC_(1.985798187255859375000000000000000000000e2), SC_(1.489348602294921875000000000000000000000e2), SC_(1.756861267089843750000000000000000000000e2), SC_(9.315487742424011230468750000000000000000e-1), SC_(1.000000000000000000000000000000000000000), SC_(1.035225416951486456414917828929820685584e-60) }}, 
      {{ SC_(1.985798187255859375000000000000000000000e2), SC_(1.787218322753906250000000000000000000000e2), SC_(3.152261734008789062500000000000000000000e1), SC_(5.452635511755943298339843750000000000000e-2), SC_(2.047726515754088998258134141618281811280e-150), SC_(1.000000000000000000000000000000000000000) }}, 
      {{ SC_(1.985798187255859375000000000000000000000e2), SC_(1.787218322753906250000000000000000000000e2), SC_(1.094441146850585937500000000000000000000e2), SC_(5.861934646964073181152343750000000000000e-2), SC_(1.624591856706499915730713055852404748609e-159), SC_(1.000000000000000000000000000000000000000) }}, 
      {{ SC_(1.985798187255859375000000000000000000000e2), SC_(1.787218322753906250000000000000000000000e2), SC_(1.811583862304687500000000000000000000000e2), SC_(6.178604438900947570800781250000000000000e-2), SC_(6.943003258141124870045539612232484691351e-169), SC_(1.000000000000000000000000000000000000000) }}, 
      {{ SC_(1.985798187255859375000000000000000000000e2), SC_(1.965940246582031250000000000000000000000e2), SC_(3.423733520507812500000000000000000000000e1), SC_(1.307801455259323120117187500000000000000e-1), SC_(2.897998927583068788816470511762364405055e-76), SC_(1.000000000000000000000000000000000000000) }}, 
      {{ SC_(1.985798187255859375000000000000000000000e2), SC_(1.965940246582031250000000000000000000000e2), SC_(1.264718551635742187500000000000000000000e2), SC_(1.427525132894515991210937500000000000000e-1), SC_(3.183617704235530904883126351699070148576e-84), SC_(1.000000000000000000000000000000000000000) }}, 
      {{ SC_(1.985798187255859375000000000000000000000e2), SC_(1.965940246582031250000000000000000000000e2), SC_(1.826751708984375000000000000000000000000e2), SC_(1.489387154579162597656250000000000000000e-1), SC_(1.233824501225718731559782879913662591172e-89), SC_(1.000000000000000000000000000000000000000) }}, 
      {{ SC_(1.985798187255859375000000000000000000000e2), SC_(1.983812408447265625000000000000000000000e2), SC_(3.477303314208984375000000000000000000000e1), SC_(2.605858743190765380859375000000000000000e-1), SC_(2.722825052755446322500830338950982149408e-28), SC_(9.999999999999999999999999997277174947245e-1) }}, 
      {{ SC_(1.985798187255859375000000000000000000000e2), SC_(1.983812408447265625000000000000000000000e2), SC_(1.279526672363281250000000000000000000000e2), SC_(2.847419381141662597656250000000000000000e-1), SC_(1.826136925933265669558558065295331886263e-32), SC_(9.999999999999999999999999999999817386307e-1) }}, 
      {{ SC_(1.985798187255859375000000000000000000000e2), SC_(1.983812408447265625000000000000000000000e2), SC_(1.831471099853515625000000000000000000000e2), SC_(2.968850731849670410156250000000000000000e-1), SC_(3.165064555850406581912477145413742057086e-35), SC_(9.999999999999999999999999999999999683494e-1) }}, 
      {{ SC_(1.985798187255859375000000000000000000000e2), SC_(1.985798187255859375000000000000000000000e2), SC_(3.767639541625976562500000000000000000000e1), SC_(3.919426798820495605468750000000000000000e-1), SC_(7.389983571746480955413533707418582371507e-8), SC_(9.999999261001642825351904458646629258142e-1) }}, 
      {{ SC_(1.985798187255859375000000000000000000000e2), SC_(1.985798187255859375000000000000000000000e2), SC_(1.310955810546875000000000000000000000000e2), SC_(4.280245006084442138671875000000000000000e-1), SC_(3.657679832974711780285379871018106487113e-9), SC_(9.999999963423201670252882197146201289819e-1) }}, 
      {{ SC_(1.985798187255859375000000000000000000000e2), SC_(1.985798187255859375000000000000000000000e2), SC_(1.867986450195312500000000000000000000000e2), SC_(4.462797939777374267578125000000000000000e-1), SC_(4.872795116067093062528690488376236082965e-10), SC_(9.999999995127204883932906937471309511624e-1) }}, 
      {{ SC_(1.985798187255859375000000000000000000000e2), SC_(1.985996856689453125000000000000000000000e2), SC_(4.238486480712890625000000000000000000000e1), SC_(4.727213978767395019531250000000000000000e-1), SC_(1.787905476890302977537861649893975478547e-2), SC_(9.821209452310969702246213835010602452145e-1) }}, 
      {{ SC_(1.985798187255859375000000000000000000000e2), SC_(1.985996856689453125000000000000000000000e2), SC_(1.311481323242187500000000000000000000000e2), SC_(5.136291980743408203125000000000000000000e-1), SC_(9.813021888479642874056457649416260122687e-3), SC_(9.901869781115203571259435423505837398773e-1) }}, 
      {{ SC_(1.985798187255859375000000000000000000000e2), SC_(1.985996856689453125000000000000000000000e2), SC_(1.914333953857421875000000000000000000000e2), SC_(5.372256040573120117187500000000000000000e-1), SC_(6.216401398181919031893336559775486020278e-3), SC_(9.937835986018180809681066634402245139797e-1) }}, 
      {{ SC_(1.985798187255859375000000000000000000000e2), SC_(1.987784118652343750000000000000000000000e2), SC_(4.420680999755859375000000000000000000000e1), SC_(5.207905769348144531250000000000000000000e-1), SC_(4.155914930860563245126723531350816450789e-1), SC_(5.844085069139436754873276468649183549211e-1) }}, 
      {{ SC_(1.985798187255859375000000000000000000000e2), SC_(1.987784118652343750000000000000000000000e2), SC_(1.357470245361328125000000000000000000000e2), SC_(5.668725371360778808593750000000000000000e-1), SC_(4.038147889251609674722054079009986680681e-1), SC_(5.961852110748390325277945920990013319319e-1) }}, 
      {{ SC_(1.985798187255859375000000000000000000000e2), SC_(1.987784118652343750000000000000000000000e2), SC_(1.915013732910156250000000000000000000000e2), SC_(5.907614231109619140625000000000000000000e-1), SC_(3.965762975046463292200158446977723480175e-1), SC_(6.034237024953536707799841553022276519825e-1) }}, 
      {{ SC_(1.985798187255859375000000000000000000000e2), SC_(2.005656127929687500000000000000000000000e2), SC_(5.569964599609375000000000000000000000000e1), SC_(5.296841263771057128906250000000000000000e-1), SC_(4.902660942957800079590483164851840385473e-1), SC_(5.097339057042199920409516835148159614527e-1) }}, 
      {{ SC_(1.985798187255859375000000000000000000000e2), SC_(2.005656127929687500000000000000000000000e2), SC_(1.362719116210937500000000000000000000000e2), SC_(5.700773596763610839843750000000000000000e-1), SC_(4.878550938884232559856847244547979687958e-1), SC_(5.121449061115767440143152755452020312042e-1) }}, 
      {{ SC_(1.985798187255859375000000000000000000000e2), SC_(2.005656127929687500000000000000000000000e2), SC_(1.918984832763671875000000000000000000000e2), SC_(5.941411256790161132812500000000000000000e-1), SC_(4.863759081079153636709981694031967956522e-1), SC_(5.136240918920846363290018305968032043478e-1) }}, 
      {{ SC_(1.985798187255859375000000000000000000000e2), SC_(2.184378051757812500000000000000000000000e2), SC_(5.940588760375976562500000000000000000000e1), SC_(5.109463930130004882812500000000000000000e-1), SC_(4.992726811854633835979931161819443197104e-1), SC_(5.007273188145366164020068838180556802896e-1) }}, 
      {{ SC_(1.985798187255859375000000000000000000000e2), SC_(2.184378051757812500000000000000000000000e2), SC_(1.451677856445312500000000000000000000000e2), SC_(5.537106394767761230468750000000000000000e-1), SC_(4.977240976564029770746004724315926534919e-1), SC_(5.022759023435970229253995275684073465081e-1) }}, 
      {{ SC_(1.985798187255859375000000000000000000000e2), SC_(2.184378051757812500000000000000000000000e2), SC_(1.929777069091796875000000000000000000000e2), SC_(5.744596123695373535156250000000000000000e-1), SC_(4.970349140918615359323963102466502544443e-1), SC_(5.029650859081384640676036897533497455557e-1) }}, 
      {{ SC_(1.985798187255859375000000000000000000000e2), SC_(2.382957916259765625000000000000000000000e2), SC_(6.038262176513671875000000000000000000000e1), SC_(4.897841513156890869140625000000000000000e-1), SC_(5.006685407228495144974389279029365069529e-1), SC_(4.993314592771504855025610720970634930471e-1) }}, 
      {{ SC_(1.985798187255859375000000000000000000000e2), SC_(2.382957916259765625000000000000000000000e2), SC_(1.481294555664062500000000000000000000000e2), SC_(5.335276126861572265625000000000000000000e-1), SC_(4.990462713498655127973366428357318258279e-1), SC_(5.009537286501344872026633571642681741721e-1) }}, 
      {{ SC_(1.985798187255859375000000000000000000000e2), SC_(2.382957916259765625000000000000000000000e2), SC_(1.935389862060546875000000000000000000000e2), SC_(5.533493161201477050781250000000000000000e-1), SC_(4.983726138895511682393635368022272293211e-1), SC_(5.016273861104488317606364631977727706789e-1) }}, 
      {{ SC_(1.985798187255859375000000000000000000000e2), SC_(2.581537475585937500000000000000000000000e2), SC_(6.163340759277343750000000000000000000000e1), SC_(4.709688723087310791015625000000000000000e-1), SC_(5.093088694405923547618538367383353015310e-1), SC_(4.906911305594076452381461632616646984690e-1) }}, 
      {{ SC_(1.985798187255859375000000000000000000000e2), SC_(2.581537475585937500000000000000000000000e2), SC_(1.486264953613281250000000000000000000000e2), SC_(5.142352581024169921875000000000000000000e-1), SC_(5.071475075841301056942202959921659866432e-1), SC_(4.928524924158698943057797040078340133568e-1) }}, 
      {{ SC_(1.985798187255859375000000000000000000000e2), SC_(2.581537475585937500000000000000000000000e2), SC_(1.937735595703125000000000000000000000000e2), SC_(5.340175628662109375000000000000000000000e-1), SC_(5.062704953543421709476265182697503978540e-1), SC_(4.937295046456578290523734817302496021460e-1) }}, 
      {{ SC_(1.985798187255859375000000000000000000000e2), SC_(2.978697204589843750000000000000000000000e2), SC_(7.225879669189453125000000000000000000000e1), SC_(4.461702108383178710937500000000000000000e-1), SC_(5.983630591030863628737594906414796494825e-1), SC_(4.016369408969136371262405093585203505175e-1) }}, 
      {{ SC_(1.985798187255859375000000000000000000000e2), SC_(2.978697204589843750000000000000000000000e2), SC_(1.515480346679687500000000000000000000000e2), SC_(4.844868481159210205078125000000000000000e-1), SC_(5.908389163520486374895041468673872103621e-1), SC_(4.091610836479513625104958531326127896379e-1) }}, 
      {{ SC_(1.985798187255859375000000000000000000000e2), SC_(2.978697204589843750000000000000000000000e2), SC_(1.941185607910156250000000000000000000000e2), SC_(5.029529929161071777343750000000000000000e-1), SC_(5.877849976786670191049962450696556701202e-1), SC_(4.122150023213329808950037549303443298798e-1) }}, 
      {{ SC_(1.985798187255859375000000000000000000000e2), SC_(3.971596374511718750000000000000000000000e2), SC_(9.566968083381652832031250000000000000000e-1), SC_(3.944248557090759277343750000000000000000e-1), SC_(9.989052510696568275710497981699210604042e-1), SC_(1.094748930343172428950201830078939595840e-3) }}, 
      {{ SC_(1.985798187255859375000000000000000000000e2), SC_(3.971596374511718750000000000000000000000e2), SC_(7.844540405273437500000000000000000000000e1), SC_(4.313215017318725585937500000000000000000e-1), SC_(9.973405408737124248909686771736514784255e-1), SC_(2.659459126287575109031322826348521574493e-3) }}, 
      {{ SC_(1.985798187255859375000000000000000000000e2), SC_(3.971596374511718750000000000000000000000e2), SC_(1.584414672851562500000000000000000000000e2), SC_(4.649803340435028076171875000000000000000e-1), SC_(9.953961788076208056976245882206631901399e-1), SC_(4.603821192379194302375411779336809860096e-3) }}, 
      {{ SC_(1.985798187255859375000000000000000000000e2), SC_(3.971596374511718750000000000000000000000e2), SC_(1.962219390869140625000000000000000000000e2), SC_(4.795307815074920654296875000000000000000e-1), SC_(9.944391764056221804677929234264734676874e-1), SC_(5.560823594377819532207076573526532312558e-3) }}, 
      {{ SC_(1.985798187255859375000000000000000000000e2), SC_(5.957394409179687500000000000000000000000e2), SC_(7.142335891723632812500000000000000000000), SC_(3.777938783168792724609375000000000000000e-1), SC_(9.999999999999457330142411148234673271882e-1), SC_(5.426698575888517653267281179103393495850e-14) }}, 
      {{ SC_(1.985798187255859375000000000000000000000e2), SC_(5.957394409179687500000000000000000000000e2), SC_(7.974770355224609375000000000000000000000e1), SC_(4.048404991626739501953125000000000000000e-1), SC_(9.999999999955941164189589175993189549695e-1), SC_(4.405883581041082400681045030459361891385e-12) }}, 
      {{ SC_(1.985798187255859375000000000000000000000e2), SC_(5.957394409179687500000000000000000000000e2), SC_(1.595857238769531250000000000000000000000e2), SC_(4.319935142993927001953125000000000000000e-1), SC_(9.999999999141681039379435607896940714170e-1), SC_(8.583189606205643921030592858295126919326e-11) }}, 
      {{ SC_(1.985798187255859375000000000000000000000e2), SC_(5.957394409179687500000000000000000000000e2), SC_(1.985762634277343750000000000000000000000e2), SC_(4.443742930889129638671875000000000000000e-1), SC_(9.999999997510474032889842693429376588092e-1), SC_(2.489525967110157306570623411907855899721e-10) }}, 
      {{ SC_(1.985798187255859375000000000000000000000e2), SC_(7.943192749023437500000000000000000000000e2), SC_(1.950807952880859375000000000000000000000e1), SC_(3.905960619449615478515625000000000000000e-1), SC_(9.999999999999999999999999999999998879856e-1), SC_(1.120143516222445054281274210721486306343e-34) }}, 
      {{ SC_(1.985798187255859375000000000000000000000e2), SC_(7.943192749023437500000000000000000000000e2), SC_(8.435225677490234375000000000000000000000e1), SC_(4.096671640872955322265625000000000000000e-1), SC_(9.999999999999999999999999999984447135026e-1), SC_(1.555286497383206821165290717397838787173e-30) }}, 
      {{ SC_(1.985798187255859375000000000000000000000e2), SC_(7.943192749023437500000000000000000000000e2), SC_(1.596211700439453125000000000000000000000e2), SC_(4.303610622882843017578125000000000000000e-1), SC_(9.999999999999999999999999978441085797700e-1), SC_(2.155891420230003981179214048178958857087e-27) }}, 
      {{ SC_(1.985798187255859375000000000000000000000e2), SC_(7.943192749023437500000000000000000000000e2), SC_(1.992922668457031250000000000000000000000e2), SC_(4.406951367855072021484375000000000000000e-1), SC_(9.999999999999999999999999618388611975482e-1), SC_(3.816113880245175488534199299565263730795e-26) }}, 
      {{ SC_(1.985798187255859375000000000000000000000e2), SC_(9.928991088867187500000000000000000000000e2), SC_(2.197235107421875000000000000000000000000e1), SC_(4.495160281658172607421875000000000000000e-1), SC_(1.000000000000000000000000000000000000000), SC_(2.451345090893975509749063412726880955598e-88) }}, 
      {{ SC_(1.985798187255859375000000000000000000000e2), SC_(9.928991088867187500000000000000000000000e2), SC_(8.441753387451171875000000000000000000000e1), SC_(4.634370505809783935546875000000000000000e-1), SC_(1.000000000000000000000000000000000000000), SC_(2.696123005499604077657699779517510531495e-79) }}, 
      {{ SC_(1.985798187255859375000000000000000000000e2), SC_(9.928991088867187500000000000000000000000e2), SC_(1.600560913085937500000000000000000000000e2), SC_(4.793850779533386230468750000000000000000e-1), SC_(1.000000000000000000000000000000000000000), SC_(5.396589939566505907045656674242406173157e-72) }}, 
      {{ SC_(1.992940368652343750000000000000000000000e2), SC_(1.992940330505371093750000000000000000000e1), SC_(7.142335891723632812500000000000000000000), SC_(9.552708268165588378906250000000000000000e-1), SC_(9.973398413683968611323985586024148610421e-1), SC_(2.660158631603138867601441397585138957939e-3) }}, 
      {{ SC_(1.992940368652343750000000000000000000000e2), SC_(1.992940330505371093750000000000000000000e1), SC_(7.974770355224609375000000000000000000000e1), SC_(9.615178108215332031250000000000000000000e-1), SC_(9.971307570153157007103877764289541523116e-1), SC_(2.869242984684299289612223571045847688363e-3) }}, 
      {{ SC_(1.992940368652343750000000000000000000000e2), SC_(1.992940330505371093750000000000000000000e1), SC_(1.595857238769531250000000000000000000000e2), SC_(9.666453599929809570312500000000000000000e-1), SC_(9.969781486530578037337296169772237829983e-1), SC_(3.021851346942196266270383022776217001711e-3) }}, 
      {{ SC_(1.992940368652343750000000000000000000000e2), SC_(1.992940330505371093750000000000000000000e1), SC_(1.985762634277343750000000000000000000000e2), SC_(9.686841964721679687500000000000000000000e-1), SC_(9.969225456733535582743110503826390448089e-1), SC_(3.077454326646441725688949617360955191072e-3) }}, 
      {{ SC_(1.992940368652343750000000000000000000000e2), SC_(4.982350921630859375000000000000000000000e1), SC_(1.950807952880859375000000000000000000000e1), SC_(9.358359575271606445312500000000000000000e-1), SC_(9.999999999965254020614271361117852040369e-1), SC_(3.474597938572863888214795963140221426904e-12) }}, 
      {{ SC_(1.992940368652343750000000000000000000000e2), SC_(4.982350921630859375000000000000000000000e1), SC_(8.435225677490234375000000000000000000000e1), SC_(9.429575800895690917968750000000000000000e-1), SC_(9.999999999939130619018803542616118877197e-1), SC_(6.086938098119645738388112280319876640647e-12) }}, 
      {{ SC_(1.992940368652343750000000000000000000000e2), SC_(4.982350921630859375000000000000000000000e1), SC_(1.596211700439453125000000000000000000000e2), SC_(9.494719505310058593750000000000000000000e-1), SC_(9.999999999906736645993148616155522907470e-1), SC_(9.326335400685138384447709252983633103816e-12) }}, 
      {{ SC_(1.992940368652343750000000000000000000000e2), SC_(4.982350921630859375000000000000000000000e1), SC_(1.992922668457031250000000000000000000000e2), SC_(9.523417949676513671875000000000000000000e-1), SC_(9.999999999889979505525517028101296712932e-1), SC_(1.100204944744829718987032870678465639103e-11) }}, 
      {{ SC_(1.992940368652343750000000000000000000000e2), SC_(9.964701843261718750000000000000000000000e1), SC_(2.197235107421875000000000000000000000000e1), SC_(9.196114540100097656250000000000000000000e-1), SC_(9.999999999999999999999999999999995422172e-1), SC_(4.577828221881416191038550064767058633427e-34) }}, 
      {{ SC_(1.992940368652343750000000000000000000000e2), SC_(9.964701843261718750000000000000000000000e1), SC_(8.441753387451171875000000000000000000000e1), SC_(9.269505739212036132812500000000000000000e-1), SC_(9.999999999999999999999999999999957188140e-1), SC_(4.281185977015024842072588006442910551722e-33) }}, 
      {{ SC_(1.992940368652343750000000000000000000000e2), SC_(9.964701843261718750000000000000000000000e1), SC_(1.600560913085937500000000000000000000000e2), SC_(9.342278242111206054687500000000000000000e-1), SC_(9.999999999999999999999999999999739814039e-1), SC_(2.601859605211694321039444322773589680759e-32) }}, 
      {{ SC_(1.992940368652343750000000000000000000000e2), SC_(1.494705200195312500000000000000000000000e2), SC_(2.249290275573730468750000000000000000000e1), SC_(9.169561266899108886718750000000000000000e-1), SC_(1.000000000000000000000000000000000000000), SC_(5.078757476486174488603832341669296014670e-65) }}, 
      {{ SC_(1.992940368652343750000000000000000000000e2), SC_(1.494705200195312500000000000000000000000e2), SC_(9.495173645019531250000000000000000000000e1), SC_(9.245328307151794433593750000000000000000e-1), SC_(1.000000000000000000000000000000000000000), SC_(1.198062735689324460517282204391468064919e-62) }}, 
      {{ SC_(1.992940368652343750000000000000000000000e2), SC_(1.494705200195312500000000000000000000000e2), SC_(1.629447326660156250000000000000000000000e2), SC_(9.304865002632141113281250000000000000000e-1), SC_(1.000000000000000000000000000000000000000), SC_(3.677801238984289092488356673198126103843e-61) }}, 
      {{ SC_(1.992940368652343750000000000000000000000e2), SC_(1.793646240234375000000000000000000000000e2), SC_(2.539736366271972656250000000000000000000e1), SC_(5.416477844119071960449218750000000000000e-2), SC_(2.776631429595303821632471226009891519974e-150), SC_(1.000000000000000000000000000000000000000) }}, 
      {{ SC_(1.992940368652343750000000000000000000000e2), SC_(1.793646240234375000000000000000000000000e2), SC_(9.707512664794921875000000000000000000000e1), SC_(5.800236016511917114257812500000000000000e-2), SC_(1.673138510860741999246331189907275755619e-158), SC_(1.000000000000000000000000000000000000000) }}, 
      {{ SC_(1.992940368652343750000000000000000000000e2), SC_(1.793646240234375000000000000000000000000e2), SC_(1.670017089843750000000000000000000000000e2), SC_(6.117471680045127868652343750000000000000e-2), SC_(1.733627098870606652495088750987846784929e-167), SC_(1.000000000000000000000000000000000000000) }}, 
      {{ SC_(1.992940368652343750000000000000000000000e2), SC_(1.973011016845703125000000000000000000000e2), SC_(2.709540176391601562500000000000000000000e1), SC_(1.297266632318496704101562500000000000000e-1), SC_(5.741110529966056682991578876376585720368e-76), SC_(1.000000000000000000000000000000000000000) }}, 
      {{ SC_(1.992940368652343750000000000000000000000e2), SC_(1.973011016845703125000000000000000000000e2), SC_(1.007325439453125000000000000000000000000e2), SC_(1.396152824163436889648437500000000000000e-1), SC_(3.986465235013712024800527853926355261130e-82), SC_(1.000000000000000000000000000000000000000) }}, 
      {{ SC_(1.992940368652343750000000000000000000000e2), SC_(1.973011016845703125000000000000000000000e2), SC_(1.698258666992187500000000000000000000000e2), SC_(1.475233435630798339843750000000000000000e-1), SC_(1.282914368961631556841107109769260537362e-88), SC_(1.000000000000000000000000000000000000000) }}, 
      {{ SC_(1.992940368652343750000000000000000000000e2), SC_(1.990947418212890625000000000000000000000e2), SC_(2.837726783752441406250000000000000000000e1), SC_(2.586981952190399169921875000000000000000e-1), SC_(4.010760397811481592922659318296102139019e-28), SC_(9.999999999999999999999999995989239602189e-1) }}, 
      {{ SC_(1.992940368652343750000000000000000000000e2), SC_(1.990947418212890625000000000000000000000e2), SC_(1.093762969970703125000000000000000000000e2), SC_(2.802273929119110107421875000000000000000e-1), SC_(1.147074575458494625462413729160840794201e-31), SC_(9.999999999999999999999999999998852925425e-1) }}, 
      {{ SC_(1.992940368652343750000000000000000000000e2), SC_(1.990947418212890625000000000000000000000e2), SC_(1.756861267089843750000000000000000000000e2), SC_(2.951916158199310302734375000000000000000e-1), SC_(6.282739472900915270969727140602284966268e-35), SC_(9.999999999999999999999999999999999371726e-1) }}, 
      {{ SC_(1.992940368652343750000000000000000000000e2), SC_(1.992940368652343750000000000000000000000e2), SC_(3.152261734008789062500000000000000000000e1), SC_(3.892313838005065917968750000000000000000e-1), SC_(8.422189336248947153310041870225953476746e-8), SC_(9.999999157781066375105284668995812977405e-1) }}, 
      {{ SC_(1.992940368652343750000000000000000000000e2), SC_(1.992940368652343750000000000000000000000e2), SC_(1.094441146850585937500000000000000000000e2), SC_(4.201809167861938476562500000000000000000e-1), SC_(7.335131328288806712967036533340727031750e-9), SC_(9.999999926648686717111932870329634666593e-1) }}, 
      {{ SC_(1.992940368652343750000000000000000000000e2), SC_(1.992940368652343750000000000000000000000e2), SC_(1.811583862304687500000000000000000000000e2), SC_(4.443231821060180664062500000000000000000e-1), SC_(5.757614661494570228703696034256476014791e-10), SC_(9.999999994242385338505429771296303965744e-1) }}, 
      {{ SC_(1.992940368652343750000000000000000000000e2), SC_(1.993139648437500000000000000000000000000e2), SC_(3.423733520507812500000000000000000000000e1), SC_(4.684656560420989990234375000000000000000e-1), SC_(1.863939702782951433032535061847093568441e-2), SC_(9.813606029721704856696746493815290643156e-1) }}, 
      {{ SC_(1.992940368652343750000000000000000000000e2), SC_(1.993139648437500000000000000000000000000e2), SC_(1.264718551635742187500000000000000000000e2), SC_(5.114796757698059082031250000000000000000e-1), SC_(1.007244470524194476339420696922870052955e-2), SC_(9.899275552947580552366057930307712994705e-1) }}, 
      {{ SC_(1.992940368652343750000000000000000000000e2), SC_(1.993139648437500000000000000000000000000e2), SC_(1.826751708984375000000000000000000000000e2), SC_(5.337331295013427734375000000000000000000e-1), SC_(6.609032623936183443870278460254492940285e-3), SC_(9.933909673760638165561297215397455070597e-1) }}, 
      {{ SC_(1.992940368652343750000000000000000000000e2), SC_(1.994933471679687500000000000000000000000e2), SC_(3.477303314208984375000000000000000000000e1), SC_(5.153949856758117675781250000000000000000e-1), SC_(4.166545062867227029185104625407936519793e-1), SC_(5.833454937132772970814895374592063480207e-1) }}, 
      {{ SC_(1.992940368652343750000000000000000000000e2), SC_(1.994933471679687500000000000000000000000e2), SC_(1.279526672363281250000000000000000000000e2), SC_(5.630922913551330566406250000000000000000e-1), SC_(4.047264294803420310786201811806954855032e-1), SC_(5.952735705196579689213798188193045144968e-1) }}, 
      {{ SC_(1.992940368652343750000000000000000000000e2), SC_(1.994933471679687500000000000000000000000e2), SC_(1.831471099853515625000000000000000000000e2), SC_(5.870853066444396972656250000000000000000e-1), SC_(3.975777639882731166639751073427487388782e-1), SC_(6.024222360117268833360248926572512611218e-1) }}, 
      {{ SC_(1.992940368652343750000000000000000000000e2), SC_(2.012869720458984375000000000000000000000e2), SC_(3.767639541625976562500000000000000000000e1), SC_(5.195102095603942871093750000000000000000e-1), SC_(4.908453058041561326770248108124915148841e-1), SC_(5.091546941958438673229751891875084851159e-1) }}, 
      {{ SC_(1.992940368652343750000000000000000000000e2), SC_(2.012869720458984375000000000000000000000e2), SC_(1.310955810546875000000000000000000000000e2), SC_(5.674747824668884277343750000000000000000e-1), SC_(4.880013355565148373403579651471311501476e-1), SC_(5.119986644434851626596420348528688498524e-1) }}, 
      {{ SC_(1.992940368652343750000000000000000000000e2), SC_(2.012869720458984375000000000000000000000e2), SC_(1.867986450195312500000000000000000000000e2), SC_(5.917719602584838867187500000000000000000e-1), SC_(4.865115622386450054840671465169266303070e-1), SC_(5.134884377613549945159328534830733696930e-1) }}, 
      {{ SC_(1.992940368652343750000000000000000000000e2), SC_(2.192234497070312500000000000000000000000e2), SC_(4.238486480712890625000000000000000000000e1), SC_(5.013815760612487792968750000000000000000e-1), SC_(4.996393916841857205329558758114994140214e-1), SC_(5.003606083158142794670441241885005859786e-1) }}, 
      {{ SC_(1.992940368652343750000000000000000000000e2), SC_(2.192234497070312500000000000000000000000e2), SC_(1.311481323242187500000000000000000000000e2), SC_(5.470179319381713867187500000000000000000e-1), SC_(4.979590605173924270136788227743081964877e-1), SC_(5.020409394826075729863211772256918035123e-1) }}, 
      {{ SC_(1.992940368652343750000000000000000000000e2), SC_(2.192234497070312500000000000000000000000e2), SC_(1.914333953857421875000000000000000000000e2), SC_(5.735351443290710449218750000000000000000e-1), SC_(4.970700616975729647306042134273064266101e-1), SC_(5.029299383024270352693957865726935733899e-1) }}, 
      {{ SC_(1.992940368652343750000000000000000000000e2), SC_(2.391528472900390625000000000000000000000e2), SC_(4.420680999755859375000000000000000000000e1), SC_(4.807215332984924316406250000000000000000e-1), SC_(5.010267204369194276151409692506608230527e-1), SC_(4.989732795630805723848590307493391769473e-1) }}, 
      {{ SC_(1.992940368652343750000000000000000000000e2), SC_(2.391528472900390625000000000000000000000e2), SC_(1.357470245361328125000000000000000000000e2), SC_(5.275872349739074707031250000000000000000e-1), SC_(4.992607985019704978634733819705020939039e-1), SC_(5.007392014980295021365266180294979060961e-1) }}, 
      {{ SC_(1.992940368652343750000000000000000000000e2), SC_(2.391528472900390625000000000000000000000e2), SC_(1.915013732910156250000000000000000000000e2), SC_(5.522084236145019531250000000000000000000e-1), SC_(4.984164375342037717494529682030173040345e-1), SC_(5.015835624657962282505470317969826959655e-1) }}, 
      {{ SC_(1.992940368652343750000000000000000000000e2), SC_(2.590822448730468750000000000000000000000e2), SC_(5.569964599609375000000000000000000000000e1), SC_(4.676264822483062744140625000000000000000e-1), SC_(5.095053228212935201635041010229151710497e-1), SC_(4.904946771787064798364958989770848289503e-1) }}, 
      {{ SC_(1.992940368652343750000000000000000000000e2), SC_(2.590822448730468750000000000000000000000e2), SC_(1.362719116210937500000000000000000000000e2), SC_(5.082982182502746582031250000000000000000e-1), SC_(5.074424524427759223559954784280518560541e-1), SC_(4.925575475572240776440045215719481439459e-1) }}, 
      {{ SC_(1.992940368652343750000000000000000000000e2), SC_(2.590822448730468750000000000000000000000e2), SC_(1.918984832763671875000000000000000000000e2), SC_(5.329382419586181640625000000000000000000e-1), SC_(5.063337766350549554224443528311951973485e-1), SC_(4.936662233649450445775556471688048026515e-1) }}, 
      {{ SC_(1.992940368652343750000000000000000000000e2), SC_(2.989410400390625000000000000000000000000e2), SC_(5.940588760375976562500000000000000000000e1), SC_(4.393039345741271972656250000000000000000e-1), SC_(6.000880582476749937027945569110420971437e-1), SC_(3.999119417523250062972054430889579028563e-1) }}, 
      {{ SC_(1.992940368652343750000000000000000000000e2), SC_(2.989410400390625000000000000000000000000e2), SC_(1.451677856445312500000000000000000000000e2), SC_(4.813641905784606933593750000000000000000e-1), SC_(5.915511925062548988647870025827413811056e-1), SC_(4.084488074937451011352129974172586188944e-1) }}, 
      {{ SC_(1.992940368652343750000000000000000000000e2), SC_(2.989410400390625000000000000000000000000e2), SC_(1.929777069091796875000000000000000000000e2), SC_(5.021858811378479003906250000000000000000e-1), SC_(5.880647936741149501087277723487364132878e-1), SC_(4.119352063258850498912722276512635867122e-1) }}, 
      {{ SC_(1.992940368652343750000000000000000000000e2), SC_(3.985880737304687500000000000000000000000e2), SC_(6.038262176513671875000000000000000000000e1), SC_(4.230284094810485839843750000000000000000e-1), SC_(9.977851090407225359839297939595457214636e-1), SC_(2.214890959277464016070206040454278536350e-3) }}, 
      {{ SC_(1.992940368652343750000000000000000000000e2), SC_(3.985880737304687500000000000000000000000e2), SC_(1.481294555664062500000000000000000000000e2), SC_(4.606534242630004882812500000000000000000e-1), SC_(9.957282424377606356346329644628312528585e-1), SC_(4.271757562239364365367035537168747141534e-3) }}, 
      {{ SC_(1.992940368652343750000000000000000000000e2), SC_(3.985880737304687500000000000000000000000e2), SC_(1.935389862060546875000000000000000000000e2), SC_(4.782629907131195068359375000000000000000e-1), SC_(9.945960851426927928055493135079582151791e-1), SC_(5.403914857307207194450686492041784820904e-3) }}, 
      {{ SC_(1.992940368652343750000000000000000000000e2), SC_(5.978820800781250000000000000000000000000e2), SC_(6.163340759277343750000000000000000000000e1), SC_(3.982345759868621826171875000000000000000e-1), SC_(9.999999999983652719310843670759144107488e-1), SC_(1.634728068915632924085589251240883044304e-12) }}, 
      {{ SC_(1.992940368652343750000000000000000000000e2), SC_(5.978820800781250000000000000000000000000e2), SC_(1.486264953613281250000000000000000000000e2), SC_(4.282388091087341308593750000000000000000e-1), SC_(9.999999999441405803165315291403807033859e-1), SC_(5.585941968346847085961929661413163659822e-11) }}, 
      {{ SC_(1.992940368652343750000000000000000000000e2), SC_(5.978820800781250000000000000000000000000e2), SC_(1.937735595703125000000000000000000000000e2), SC_(4.426617622375488281250000000000000000000e-1), SC_(9.999999997983110564053295602949830922408e-1), SC_(2.016889435946704397050169077592286063336e-10) }}, 
      {{ SC_(1.992940368652343750000000000000000000000e2), SC_(7.971761474609375000000000000000000000000e2), SC_(7.225879669189453125000000000000000000000e1), SC_(4.061267971992492675781250000000000000000e-1), SC_(9.999999999999999999999999999997290246639e-1), SC_(2.709753361367076002320691695420448945649e-31) }}, 
      {{ SC_(1.992940368652343750000000000000000000000e2), SC_(7.971761474609375000000000000000000000000e2), SC_(1.515480346679687500000000000000000000000e2), SC_(4.280660748481750488281250000000000000000e-1), SC_(9.999999999999999999999999991303421392948e-1), SC_(8.696578607051932204338673773133285372742e-28) }}, 
      {{ SC_(1.992940368652343750000000000000000000000e2), SC_(7.971761474609375000000000000000000000000e2), SC_(1.941185607910156250000000000000000000000e2), SC_(4.391900300979614257812500000000000000000e-1), SC_(9.999999999999999999999999789782532523897e-1), SC_(2.102174674761034080045110832943420015762e-26) }}, 
      {{ SC_(1.992940368652343750000000000000000000000e2), SC_(9.964702148437500000000000000000000000000e2), SC_(9.566968083381652832031250000000000000000e-1), SC_(4.446664154529571533203125000000000000000e-1), SC_(1.000000000000000000000000000000000000000), SC_(6.723822936759331715719218974775798182259e-93) }}, 
      {{ SC_(1.992940368652343750000000000000000000000e2), SC_(9.964702148437500000000000000000000000000e2), SC_(7.844540405273437500000000000000000000000e1), SC_(4.620748460292816162109375000000000000000e-1), SC_(1.000000000000000000000000000000000000000), SC_(2.547617018541288535048352060726128288630e-80) }}, 
      {{ SC_(1.992940368652343750000000000000000000000e2), SC_(9.964702148437500000000000000000000000000e2), SC_(1.584414672851562500000000000000000000000e2), SC_(4.789382815361022949218750000000000000000e-1), SC_(1.000000000000000000000000000000000000000), SC_(2.016791451093890693491633506946470794739e-72) }}, 
      {{ SC_(1.992940368652343750000000000000000000000e2), SC_(9.964702148437500000000000000000000000000e2), SC_(1.962219390869140625000000000000000000000e2), SC_(4.865405857563018798828125000000000000000e-1), SC_(1.000000000000000000000000000000000000000), SC_(1.362436549196397892011134548818387099631e-69) }}
   }};
#undef SC_

