/* SPDX-License-Identifier: GPL-2.0-only OR BSD-2-Clause */
/*
 * Copyright (c) 2021-2022, Qualcomm Innovation Center, Inc. All rights reserved.
 */

#ifndef _DT_BINDINGS_CLK_QCOM_GCC_SAR2130P_H
#define _DT_BINDINGS_CLK_QCOM_GCC_SAR2130P_H

/* GCC clocks */
#define GCC_GPLL0						0
#define GCC_GPLL0_OUT_EVEN					1
#define GCC_GPLL1						2
#define GCC_GPLL9						3
#define GCC_GPLL9_OUT_EVEN					4
#define GCC_AGGRE_NOC_PCIE_1_AXI_CLK				5
#define GCC_AGGRE_USB3_PRIM_AXI_CLK				6
#define GCC_BOOT_ROM_AHB_CLK					7
#define GCC_CAMERA_AHB_CLK					8
#define GCC_CAMERA_HF_AXI_CLK					9
#define GCC_CAMERA_SF_AXI_CLK					10
#define GCC_CAMERA_XO_CLK					11
#define GCC_CFG_NOC_PCIE_ANOC_AHB_CLK				12
#define GCC_CFG_NOC_USB3_PRIM_AXI_CLK				13
#define GCC_DDRSS_GPU_AXI_CLK					14
#define GCC_DDRSS_PCIE_SF_CLK					15
#define GCC_DISP_AHB_CLK					16
#define GCC_DISP_HF_AXI_CLK					17
#define GCC_GP1_CLK						18
#define GCC_GP1_CLK_SRC						19
#define GCC_GP2_CLK						20
#define GCC_GP2_CLK_SRC						21
#define GCC_GP3_CLK						22
#define GCC_GP3_CLK_SRC						23
#define GCC_GPU_CFG_AHB_CLK					24
#define GCC_GPU_GPLL0_CLK_SRC					25
#define GCC_GPU_GPLL0_DIV_CLK_SRC				26
#define GCC_GPU_MEMNOC_GFX_CLK					27
#define GCC_GPU_SNOC_DVM_GFX_CLK				28
#define GCC_IRIS_SS_HF_AXI1_CLK					29
#define GCC_IRIS_SS_SPD_AXI1_CLK				30
#define GCC_PCIE_0_AUX_CLK					31
#define GCC_PCIE_0_AUX_CLK_SRC					32
#define GCC_PCIE_0_CFG_AHB_CLK					33
#define GCC_PCIE_0_MSTR_AXI_CLK					34
#define GCC_PCIE_0_PHY_RCHNG_CLK				35
#define GCC_PCIE_0_PHY_RCHNG_CLK_SRC				36
#define GCC_PCIE_0_PIPE_CLK					37
#define GCC_PCIE_0_PIPE_CLK_SRC					38
#define GCC_PCIE_0_SLV_AXI_CLK					39
#define GCC_PCIE_0_SLV_Q2A_AXI_CLK				40
#define GCC_PCIE_1_AUX_CLK					41
#define GCC_PCIE_1_AUX_CLK_SRC					42
#define GCC_PCIE_1_CFG_AHB_CLK					43
#define GCC_PCIE_1_MSTR_AXI_CLK					44
#define GCC_PCIE_1_PHY_RCHNG_CLK				45
#define GCC_PCIE_1_PHY_RCHNG_CLK_SRC				46
#define GCC_PCIE_1_PIPE_CLK					47
#define GCC_PCIE_1_PIPE_CLK_SRC					48
#define GCC_PCIE_1_SLV_AXI_CLK					49
#define GCC_PCIE_1_SLV_Q2A_AXI_CLK				50
#define GCC_PDM2_CLK						51
#define GCC_PDM2_CLK_SRC					52
#define GCC_PDM_AHB_CLK						53
#define GCC_PDM_XO4_CLK						54
#define GCC_QMIP_CAMERA_NRT_AHB_CLK				55
#define GCC_QMIP_CAMERA_RT_AHB_CLK				56
#define GCC_QMIP_GPU_AHB_CLK					57
#define GCC_QMIP_PCIE_AHB_CLK					58
#define GCC_QMIP_VIDEO_CV_CPU_AHB_CLK				59
#define GCC_QMIP_VIDEO_CVP_AHB_CLK				60
#define GCC_QMIP_VIDEO_LSR_AHB_CLK				61
#define GCC_QMIP_VIDEO_V_CPU_AHB_CLK				62
#define GCC_QMIP_VIDEO_VCODEC_AHB_CLK				63
#define GCC_QUPV3_WRAP0_CORE_2X_CLK				64
#define GCC_QUPV3_WRAP0_CORE_CLK				65
#define GCC_QUPV3_WRAP0_S0_CLK					66
#define GCC_QUPV3_WRAP0_S0_CLK_SRC				67
#define GCC_QUPV3_WRAP0_S1_CLK					68
#define GCC_QUPV3_WRAP0_S1_CLK_SRC				69
#define GCC_QUPV3_WRAP0_S2_CLK					70
#define GCC_QUPV3_WRAP0_S2_CLK_SRC				71
#define GCC_QUPV3_WRAP0_S3_CLK					72
#define GCC_QUPV3_WRAP0_S3_CLK_SRC				73
#define GCC_QUPV3_WRAP0_S4_CLK					74
#define GCC_QUPV3_WRAP0_S4_CLK_SRC				75
#define GCC_QUPV3_WRAP0_S5_CLK					76
#define GCC_QUPV3_WRAP0_S5_CLK_SRC				77
#define GCC_QUPV3_WRAP1_CORE_2X_CLK				78
#define GCC_QUPV3_WRAP1_CORE_CLK				79
#define GCC_QUPV3_WRAP1_S0_CLK					80
#define GCC_QUPV3_WRAP1_S0_CLK_SRC				81
#define GCC_QUPV3_WRAP1_S1_CLK					82
#define GCC_QUPV3_WRAP1_S1_CLK_SRC				83
#define GCC_QUPV3_WRAP1_S2_CLK					84
#define GCC_QUPV3_WRAP1_S2_CLK_SRC				85
#define GCC_QUPV3_WRAP1_S3_CLK					86
#define GCC_QUPV3_WRAP1_S3_CLK_SRC				87
#define GCC_QUPV3_WRAP1_S4_CLK					88
#define GCC_QUPV3_WRAP1_S4_CLK_SRC				89
#define GCC_QUPV3_WRAP1_S5_CLK					90
#define GCC_QUPV3_WRAP1_S5_CLK_SRC				91
#define GCC_QUPV3_WRAP_0_M_AHB_CLK				92
#define GCC_QUPV3_WRAP_0_S_AHB_CLK				93
#define GCC_QUPV3_WRAP_1_M_AHB_CLK				94
#define GCC_QUPV3_WRAP_1_S_AHB_CLK				95
#define GCC_SDCC1_AHB_CLK					96
#define GCC_SDCC1_APPS_CLK					97
#define GCC_SDCC1_APPS_CLK_SRC					98
#define GCC_SDCC1_ICE_CORE_CLK					99
#define GCC_SDCC1_ICE_CORE_CLK_SRC				100
#define GCC_USB30_PRIM_MASTER_CLK				101
#define GCC_USB30_PRIM_MASTER_CLK_SRC				102
#define GCC_USB30_PRIM_MOCK_UTMI_CLK				103
#define GCC_USB30_PRIM_MOCK_UTMI_CLK_SRC			104
#define GCC_USB30_PRIM_MOCK_UTMI_POSTDIV_CLK_SRC		105
#define GCC_USB30_PRIM_SLEEP_CLK				106
#define GCC_USB3_PRIM_PHY_AUX_CLK				107
#define GCC_USB3_PRIM_PHY_AUX_CLK_SRC				108
#define GCC_USB3_PRIM_PHY_COM_AUX_CLK				109
#define GCC_USB3_PRIM_PHY_PIPE_CLK				110
#define GCC_USB3_PRIM_PHY_PIPE_CLK_SRC				111
#define GCC_VIDEO_AHB_CLK					112
#define GCC_VIDEO_AXI0_CLK					113
#define GCC_VIDEO_AXI1_CLK					114
#define GCC_VIDEO_XO_CLK					115
#define GCC_GPLL4						116
#define GCC_GPLL5						117
#define GCC_GPLL7						118
#define GCC_DDRSS_SPAD_CLK					119
#define GCC_DDRSS_SPAD_CLK_SRC					120
#define GCC_VIDEO_AXI0_SREG					121
#define GCC_VIDEO_AXI1_SREG					122
#define GCC_IRIS_SS_HF_AXI1_SREG				123
#define GCC_IRIS_SS_SPD_AXI1_SREG				124

/* GCC resets */
#define GCC_CAMERA_BCR						0
#define GCC_DISPLAY_BCR						1
#define GCC_GPU_BCR						2
#define GCC_PCIE_0_BCR						3
#define GCC_PCIE_0_LINK_DOWN_BCR				4
#define GCC_PCIE_0_NOCSR_COM_PHY_BCR				5
#define GCC_PCIE_0_PHY_BCR					6
#define GCC_PCIE_0_PHY_NOCSR_COM_PHY_BCR			7
#define GCC_PCIE_1_BCR						8
#define GCC_PCIE_1_LINK_DOWN_BCR				9
#define GCC_PCIE_1_NOCSR_COM_PHY_BCR				10
#define GCC_PCIE_1_PHY_BCR					11
#define GCC_PCIE_1_PHY_NOCSR_COM_PHY_BCR			12
#define GCC_PCIE_PHY_BCR					13
#define GCC_PCIE_PHY_CFG_AHB_BCR				14
#define GCC_PCIE_PHY_COM_BCR					15
#define GCC_PDM_BCR						16
#define GCC_QUPV3_WRAPPER_0_BCR					17
#define GCC_QUPV3_WRAPPER_1_BCR					18
#define GCC_QUSB2PHY_PRIM_BCR					19
#define GCC_QUSB2PHY_SEC_BCR					20
#define GCC_SDCC1_BCR						21
#define GCC_USB30_PRIM_BCR					22
#define GCC_USB3_DP_PHY_PRIM_BCR				23
#define GCC_USB3_DP_PHY_SEC_BCR					24
#define GCC_USB3_PHY_PRIM_BCR					25
#define GCC_USB3_PHY_SEC_BCR					26
#define GCC_USB3PHY_PHY_PRIM_BCR				27
#define GCC_USB3PHY_PHY_SEC_BCR					28
#define GCC_VIDEO_AXI0_CLK_ARES					29
#define GCC_VIDEO_AXI1_CLK_ARES					30
#define GCC_VIDEO_BCR						31
#define GCC_IRIS_SS_HF_AXI_CLK_ARES				32
#define GCC_IRIS_SS_SPD_AXI_CLK_ARES				33
#define GCC_DDRSS_SPAD_CLK_ARES					34

/* GCC power domains */
#define PCIE_0_GDSC						0
#define PCIE_0_PHY_GDSC						1
#define PCIE_1_GDSC						2
#define PCIE_1_PHY_GDSC						3
#define USB30_PRIM_GDSC						4
#define USB3_PHY_GDSC						5
#define HLOS1_VOTE_MM_SNOC_MMU_TBU_HF0_GDSC			6
#define HLOS1_VOTE_MM_SNOC_MMU_TBU_SF0_GDSC			7
#define HLOS1_VOTE_TURING_MMU_TBU0_GDSC				8
#define HLOS1_VOTE_TURING_MMU_TBU1_GDSC				9

#endif
