# Copyright 2012-2015 Canonical Ltd.  This software is licensed under the
# GNU Affero General Public License version 3 (see the file LICENSE).

"""Storage for uploaded files."""

from __future__ import (
    absolute_import,
    print_function,
    unicode_literals,
    )

str = None

__metaclass__ = type
__all__ = [
    'FileStorage',
    ]


from uuid import uuid1

from django.contrib.auth.models import User
from django.db.models import (
    CharField,
    ForeignKey,
    Model,
    PROTECT,
)
from maasserver import DefaultMeta
from maasserver.models.cleansave import CleanSave
from metadataserver.fields import BinaryField


def generate_filestorage_key():
    return '%s' % uuid1()


class FileStorage(CleanSave, Model):
    """A simple file storage keyed on file name.

    :ivar filename: A file name to use for the data being stored.
    :ivar owner: This file's owner..
    :ivar content: The file's actual data.
    """

    class Meta(DefaultMeta):
        """Needed for South to recognize this model."""
        unique_together = ('filename', 'owner')

    filename = CharField(max_length=255, unique=False, editable=False)
    content = BinaryField(null=False, blank=True)
    # owner can be None: this is to support upgrading existing
    # installations where the files were not linked to users yet.
    owner = ForeignKey(
        User, default=None, blank=True, null=True, editable=False,
        on_delete=PROTECT)
    key = CharField(
        max_length=36, unique=True, default=generate_filestorage_key,
        editable=False)
