/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.gui.fontchooser;

import java.awt.Font;
import java.util.Collections;
import java.util.Enumeration;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import org.jhotdraw.gui.fontchooser.FontFamilyNode;

public class FontFaceNode
implements MutableTreeNode,
Comparable<FontFaceNode>,
Cloneable {
    private FontFamilyNode parent;
    private Font typeface;
    private String name;

    public FontFaceNode(Font font) {
        this.typeface = font;
        this.name = this.beautifyName(font.getPSName());
    }

    protected String beautifyName(String string) {
        CharSequence charSequence;
        int n = string.lastIndexOf(45);
        if (n != -1) {
            charSequence = (string = string.substring(n + 1)).toLowerCase();
            if (((String)charSequence).equals("plain")) {
                string = "Plain";
            } else if (((String)charSequence).equals("bolditalic")) {
                string = "Bold Italic";
            } else if (((String)charSequence).equals("italic")) {
                string = "Italic";
            } else if (((String)charSequence).equals("bold")) {
                string = "Bold";
            }
        } else {
            charSequence = string.toLowerCase();
            string = ((String)charSequence).endsWith("plain") ? "Plain" : (((String)charSequence).endsWith("boldoblique") ? "Bold Oblique" : (((String)charSequence).endsWith("bolditalic") ? "Bold Italic" : (((String)charSequence).endsWith("bookita") ? "Book Italic" : (((String)charSequence).endsWith("bookit") ? "Book Italic" : (((String)charSequence).endsWith("demibold") ? "Demi Bold" : (((String)charSequence).endsWith("semiita") ? "Semi Italic" : (((String)charSequence).endsWith("italic") ? "Italic" : (((String)charSequence).endsWith("book") ? "Book" : (((String)charSequence).endsWith("bold") ? "Bold" : (((String)charSequence).endsWith("bol") ? "Bold" : (((String)charSequence).endsWith("oblique") ? "Oblique" : (((String)charSequence).endsWith("regular") ? "Regular" : (((String)charSequence).endsWith("semi") ? "Semi" : "Plain")))))))))))));
        }
        charSequence = new StringBuilder();
        char c = string.charAt(0);
        ((StringBuilder)charSequence).append(c);
        for (int i = 1; i < string.length(); ++i) {
            char c2 = string.charAt(i);
            if (c != ' ' && c != '-' && Character.isUpperCase(c2) && !Character.isUpperCase(c) || Character.isDigit(c2) && !Character.isDigit(c)) {
                ((StringBuilder)charSequence).append(' ');
            }
            ((StringBuilder)charSequence).append(c2);
            c = c2;
        }
        string = ((StringBuilder)charSequence).toString();
        return string;
    }

    public void setName(String string) {
        this.name = string;
    }

    public String getName() {
        return this.name;
    }

    public Font getFont() {
        return this.typeface;
    }

    public String toString() {
        return this.name;
    }

    @Override
    public void insert(MutableTreeNode mutableTreeNode, int n) {
        throw new UnsupportedOperationException("Not allowed.");
    }

    @Override
    public void remove(int n) {
        throw new UnsupportedOperationException("Not allowed.");
    }

    @Override
    public void remove(MutableTreeNode mutableTreeNode) {
        throw new UnsupportedOperationException("Not allowed.");
    }

    @Override
    public void setUserObject(Object object) {
        throw new UnsupportedOperationException("Not allowed.");
    }

    @Override
    public void removeFromParent() {
        if (this.parent != null) {
            this.parent.remove(this);
        }
    }

    @Override
    public void setParent(MutableTreeNode mutableTreeNode) {
        this.parent = (FontFamilyNode)mutableTreeNode;
    }

    @Override
    public TreeNode getChildAt(int n) {
        throw new IndexOutOfBoundsException("" + n);
    }

    @Override
    public int getChildCount() {
        return 0;
    }

    @Override
    public TreeNode getParent() {
        return this.parent;
    }

    @Override
    public int getIndex(TreeNode treeNode) {
        return -1;
    }

    @Override
    public boolean getAllowsChildren() {
        return false;
    }

    @Override
    public boolean isLeaf() {
        return true;
    }

    public Enumeration children() {
        return Collections.enumeration(Collections.EMPTY_LIST);
    }

    @Override
    public int compareTo(FontFaceNode fontFaceNode) {
        return this.name.compareTo(fontFaceNode.name);
    }

    public FontFaceNode clone() {
        FontFaceNode fontFaceNode;
        try {
            fontFaceNode = (FontFaceNode)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            InternalError internalError = new InternalError("Clone failed");
            internalError.initCause(cloneNotSupportedException);
            throw internalError;
        }
        fontFaceNode.parent = null;
        return fontFaceNode;
    }

    public boolean isEditable() {
        return false;
    }
}

