// |reftest| async
// Copyright (C) 2022 Igalia, S.L. All rights reserved.
// This code is governed by the BSD license found in the LICENSE file.
/*---
description: |
    Thenables that reject with the `null` value do not satisfy the assertion.
flags: [async]
includes: [asyncHelpers.js]
---*/

asyncTest(async function () {
  var caught = false;

  const p = assert.throwsAsync(Error, async function () {
    throw null;
  });
  assert(p instanceof Promise);
  try {
    await p;
  } catch (err) {
    caught = true;
    assert.sameValue(
      err.constructor,
      Test262Error,
      "Expected a Test262Error, but a '" +
        err.constructor.name +
        "' was thrown."
    );
  } finally {
    assert(
      caught,
      "assert.throwsAsync did not reject when null was thrown"
    );
  }
});
