/* Generated by re2c */
/*
   +----------------------------------------------------------------------+
   | Zend Engine                                                          |
   +----------------------------------------------------------------------+
   | Copyright (c) 1998-2015 Zend Technologies Ltd. (http://www.zend.com) |
   +----------------------------------------------------------------------+
   | This source file is subject to version 2.00 of the Zend license,     |
   | that is bundled with this package in the file LICENSE, and is        |
   | available through the world-wide-web at the following url:           |
   | http://www.zend.com/license/2_00.txt.                                |
   | If you did not receive a copy of the Zend license and are unable to  |
   | obtain it through the world-wide-web, please send a note to          |
   | license@zend.com so we can mail you a copy immediately.              |
   +----------------------------------------------------------------------+
   | Authors: Marcus Boerger <helly@php.net>                              |
   |          Nuno Lopes <nlopess@php.net>                                |
   |          Scott MacVicar <scottmac@php.net>                           |
   | Flex version authors:                                                |
   |          Andi Gutmans <andi@zend.com>                                |
   |          Zeev Suraski <zeev@zend.com>                                |
   +----------------------------------------------------------------------+
*/

/* $Id$ */

#if 0
# define YYDEBUG(s, c) printf("state: %d char: %c\n", s, c)
#else
# define YYDEBUG(s, c)
#endif

#include "zend_language_scanner_defs.h"

#include <errno.h>
#include "zend.h"
#ifdef PHP_WIN32
# include <Winuser.h>
#endif
#include "zend_alloc.h"
#include <zend_language_parser.h>
#include "zend_compile.h"
#include "zend_language_scanner.h"
#include "zend_highlight.h"
#include "zend_constants.h"
#include "zend_variables.h"
#include "zend_operators.h"
#include "zend_API.h"
#include "zend_strtod.h"
#include "zend_exceptions.h"
#include "zend_virtual_cwd.h"
#include "tsrm_config_common.h"

#define YYCTYPE   unsigned char
#define YYFILL(n) { if ((YYCURSOR + n) >= (YYLIMIT + ZEND_MMAP_AHEAD)) { return 0; } }
#define YYCURSOR  SCNG(yy_cursor)
#define YYLIMIT   SCNG(yy_limit)
#define YYMARKER  SCNG(yy_marker)

#define YYGETCONDITION()  SCNG(yy_state)
#define YYSETCONDITION(s) SCNG(yy_state) = s

#define STATE(name)  yyc##name

/* emulate flex constructs */
#define BEGIN(state) YYSETCONDITION(STATE(state))
#define YYSTATE      YYGETCONDITION()
#define yytext       ((char*)SCNG(yy_text))
#define yyleng       SCNG(yy_leng)
#define yyless(x)    do { YYCURSOR = (unsigned char*)yytext + x; \
                          yyleng   = (unsigned int)x; } while(0)
#define yymore()     goto yymore_restart

/* perform sanity check. If this message is triggered you should
   increase the ZEND_MMAP_AHEAD value in the zend_streams.h file */
#define YYMAXFILL 16

#if ZEND_MMAP_AHEAD < YYMAXFILL
# error ZEND_MMAP_AHEAD should be greater than or equal to YYMAXFILL
#endif

#ifdef HAVE_STDARG_H
# include <stdarg.h>
#endif

#ifdef HAVE_UNISTD_H
# include <unistd.h>
#endif

/* Globals Macros */
#define SCNG	LANG_SCNG
#ifdef ZTS
ZEND_API ts_rsrc_id language_scanner_globals_id;
#else
ZEND_API zend_php_scanner_globals language_scanner_globals;
#endif

#define HANDLE_NEWLINES(s, l)													\
do {																			\
	char *p = (s), *boundary = p+(l);											\
																				\
	while (p<boundary) {														\
		if (*p == '\n' || (*p == '\r' && (*(p+1) != '\n'))) {					\
			CG(zend_lineno)++;													\
		}																		\
		p++;																	\
	}																			\
} while (0)

#define HANDLE_NEWLINE(c) \
{ \
	if (c == '\n' || c == '\r') { \
		CG(zend_lineno)++; \
	} \
}

/* To save initial string length after scanning to first variable */
#define SET_DOUBLE_QUOTES_SCANNED_LENGTH(len) SCNG(scanned_string_len) = (len)
#define GET_DOUBLE_QUOTES_SCANNED_LENGTH()    SCNG(scanned_string_len)

#define IS_LABEL_START(c) (((c) >= 'a' && (c) <= 'z') || ((c) >= 'A' && (c) <= 'Z') || (c) == '_' || (c) >= 0x7F)

#define ZEND_IS_OCT(c)  ((c)>='0' && (c)<='7')
#define ZEND_IS_HEX(c)  (((c)>='0' && (c)<='9') || ((c)>='a' && (c)<='f') || ((c)>='A' && (c)<='F'))

BEGIN_EXTERN_C()

static size_t encoding_filter_script_to_internal(unsigned char **to, size_t *to_length, const unsigned char *from, size_t from_length)
{
	const zend_encoding *internal_encoding = zend_multibyte_get_internal_encoding();
	ZEND_ASSERT(internal_encoding);
	return zend_multibyte_encoding_converter(to, to_length, from, from_length, internal_encoding, LANG_SCNG(script_encoding));
}

static size_t encoding_filter_script_to_intermediate(unsigned char **to, size_t *to_length, const unsigned char *from, size_t from_length)
{
	return zend_multibyte_encoding_converter(to, to_length, from, from_length, zend_multibyte_encoding_utf8, LANG_SCNG(script_encoding));
}

static size_t encoding_filter_intermediate_to_script(unsigned char **to, size_t *to_length, const unsigned char *from, size_t from_length)
{
	return zend_multibyte_encoding_converter(to, to_length, from, from_length,
LANG_SCNG(script_encoding), zend_multibyte_encoding_utf8);
}

static size_t encoding_filter_intermediate_to_internal(unsigned char **to, size_t *to_length, const unsigned char *from, size_t from_length)
{
	const zend_encoding *internal_encoding = zend_multibyte_get_internal_encoding();
	ZEND_ASSERT(internal_encoding);
	return zend_multibyte_encoding_converter(to, to_length, from, from_length,
internal_encoding, zend_multibyte_encoding_utf8);
}


static void _yy_push_state(int new_state)
{
	zend_stack_push(&SCNG(state_stack), (void *) &YYGETCONDITION());
	YYSETCONDITION(new_state);
}

#define yy_push_state(state_and_tsrm) _yy_push_state(yyc##state_and_tsrm)

static void yy_pop_state(void)
{
	int *stack_state = zend_stack_top(&SCNG(state_stack));
	YYSETCONDITION(*stack_state);
	zend_stack_del_top(&SCNG(state_stack));
}

static void yy_scan_buffer(char *str, unsigned int len)
{
	YYCURSOR       = (YYCTYPE*)str;
	YYLIMIT        = YYCURSOR + len;
	if (!SCNG(yy_start)) {
		SCNG(yy_start) = YYCURSOR;
	}
}

void startup_scanner(void)
{
	CG(parse_error) = 0;
	CG(doc_comment) = NULL;
	zend_stack_init(&SCNG(state_stack), sizeof(int));
	zend_ptr_stack_init(&SCNG(heredoc_label_stack));
}

static void heredoc_label_dtor(zend_heredoc_label *heredoc_label) {
    efree(heredoc_label->label);
}

void shutdown_scanner(void)
{
	CG(parse_error) = 0;
	RESET_DOC_COMMENT();
	zend_stack_destroy(&SCNG(state_stack));
	zend_ptr_stack_clean(&SCNG(heredoc_label_stack), (void (*)(void *)) &heredoc_label_dtor, 1);
	zend_ptr_stack_destroy(&SCNG(heredoc_label_stack));
}

ZEND_API void zend_save_lexical_state(zend_lex_state *lex_state)
{
	lex_state->yy_leng   = SCNG(yy_leng);
	lex_state->yy_start  = SCNG(yy_start);
	lex_state->yy_text   = SCNG(yy_text);
	lex_state->yy_cursor = SCNG(yy_cursor);
	lex_state->yy_marker = SCNG(yy_marker);
	lex_state->yy_limit  = SCNG(yy_limit);

	lex_state->state_stack = SCNG(state_stack);
	zend_stack_init(&SCNG(state_stack), sizeof(int));

	lex_state->heredoc_label_stack = SCNG(heredoc_label_stack);
	zend_ptr_stack_init(&SCNG(heredoc_label_stack));

	lex_state->in = SCNG(yy_in);
	lex_state->yy_state = YYSTATE;
	lex_state->filename = zend_get_compiled_filename();
	lex_state->lineno = CG(zend_lineno);

	lex_state->script_org = SCNG(script_org);
	lex_state->script_org_size = SCNG(script_org_size);
	lex_state->script_filtered = SCNG(script_filtered);
	lex_state->script_filtered_size = SCNG(script_filtered_size);
	lex_state->input_filter = SCNG(input_filter);
	lex_state->output_filter = SCNG(output_filter);
	lex_state->script_encoding = SCNG(script_encoding);

	lex_state->ast = CG(ast);
	lex_state->ast_arena = CG(ast_arena);
}

ZEND_API void zend_restore_lexical_state(zend_lex_state *lex_state)
{
	SCNG(yy_leng)   = lex_state->yy_leng;
	SCNG(yy_start)  = lex_state->yy_start;
	SCNG(yy_text)   = lex_state->yy_text;
	SCNG(yy_cursor) = lex_state->yy_cursor;
	SCNG(yy_marker) = lex_state->yy_marker;
	SCNG(yy_limit)  = lex_state->yy_limit;

	zend_stack_destroy(&SCNG(state_stack));
	SCNG(state_stack) = lex_state->state_stack;

	zend_ptr_stack_clean(&SCNG(heredoc_label_stack), (void (*)(void *)) &heredoc_label_dtor, 1);
	zend_ptr_stack_destroy(&SCNG(heredoc_label_stack));
	SCNG(heredoc_label_stack) = lex_state->heredoc_label_stack;

	SCNG(yy_in) = lex_state->in;
	YYSETCONDITION(lex_state->yy_state);
	CG(zend_lineno) = lex_state->lineno;
	zend_restore_compiled_filename(lex_state->filename);

	if (SCNG(script_filtered)) {
		efree(SCNG(script_filtered));
		SCNG(script_filtered) = NULL;
	}
	SCNG(script_org) = lex_state->script_org;
	SCNG(script_org_size) = lex_state->script_org_size;
	SCNG(script_filtered) = lex_state->script_filtered;
	SCNG(script_filtered_size) = lex_state->script_filtered_size;
	SCNG(input_filter) = lex_state->input_filter;
	SCNG(output_filter) = lex_state->output_filter;
	SCNG(script_encoding) = lex_state->script_encoding;

	CG(ast) = lex_state->ast;
	CG(ast_arena) = lex_state->ast_arena;

	RESET_DOC_COMMENT();
}

ZEND_API void zend_destroy_file_handle(zend_file_handle *file_handle)
{
	zend_llist_del_element(&CG(open_files), file_handle, (int (*)(void *, void *)) zend_compare_file_handles);
	/* zend_file_handle_dtor() operates on the copy, so we have to NULLify the original here */
	file_handle->opened_path = NULL;
	if (file_handle->free_filename) {
		file_handle->filename = NULL;
	}
}

#define BOM_UTF32_BE	"\x00\x00\xfe\xff"
#define	BOM_UTF32_LE	"\xff\xfe\x00\x00"
#define	BOM_UTF16_BE	"\xfe\xff"
#define	BOM_UTF16_LE	"\xff\xfe"
#define	BOM_UTF8		"\xef\xbb\xbf"

static const zend_encoding *zend_multibyte_detect_utf_encoding(const unsigned char *script, size_t script_size)
{
	const unsigned char *p;
	int wchar_size = 2;
	int le = 0;

	/* utf-16 or utf-32? */
	p = script;
	assert(p >= script);
	while ((size_t)(p-script) < script_size) {
		p = memchr(p, 0, script_size-(p-script)-2);
		if (!p) {
			break;
		}
		if (*(p+1) == '\0' && *(p+2) == '\0') {
			wchar_size = 4;
			break;
		}

		/* searching for UTF-32 specific byte orders, so this will do */
		p += 4;
	}

	/* BE or LE? */
	p = script;
	assert(p >= script);
	while ((size_t)(p-script) < script_size) {
		if (*p == '\0' && *(p+wchar_size-1) != '\0') {
			/* BE */
			le = 0;
			break;
		} else if (*p != '\0' && *(p+wchar_size-1) == '\0') {
			/* LE* */
			le = 1;
			break;
		}
		p += wchar_size;
	}

	if (wchar_size == 2) {
		return le ? zend_multibyte_encoding_utf16le : zend_multibyte_encoding_utf16be;
	} else {
		return le ? zend_multibyte_encoding_utf32le : zend_multibyte_encoding_utf32be;
	}

	return NULL;
}

static const zend_encoding* zend_multibyte_detect_unicode(void)
{
	const zend_encoding *script_encoding = NULL;
	int bom_size;
	unsigned char *pos1, *pos2;

	if (LANG_SCNG(script_org_size) < sizeof(BOM_UTF32_LE)-1) {
		return NULL;
	}

	/* check out BOM */
	if (!memcmp(LANG_SCNG(script_org), BOM_UTF32_BE, sizeof(BOM_UTF32_BE)-1)) {
		script_encoding = zend_multibyte_encoding_utf32be;
		bom_size = sizeof(BOM_UTF32_BE)-1;
	} else if (!memcmp(LANG_SCNG(script_org), BOM_UTF32_LE, sizeof(BOM_UTF32_LE)-1)) {
		script_encoding = zend_multibyte_encoding_utf32le;
		bom_size = sizeof(BOM_UTF32_LE)-1;
	} else if (!memcmp(LANG_SCNG(script_org), BOM_UTF16_BE, sizeof(BOM_UTF16_BE)-1)) {
		script_encoding = zend_multibyte_encoding_utf16be;
		bom_size = sizeof(BOM_UTF16_BE)-1;
	} else if (!memcmp(LANG_SCNG(script_org), BOM_UTF16_LE, sizeof(BOM_UTF16_LE)-1)) {
		script_encoding = zend_multibyte_encoding_utf16le;
		bom_size = sizeof(BOM_UTF16_LE)-1;
	} else if (!memcmp(LANG_SCNG(script_org), BOM_UTF8, sizeof(BOM_UTF8)-1)) {
		script_encoding = zend_multibyte_encoding_utf8;
		bom_size = sizeof(BOM_UTF8)-1;
	}

	if (script_encoding) {
		/* remove BOM */
		LANG_SCNG(script_org) += bom_size;
		LANG_SCNG(script_org_size) -= bom_size;

		return script_encoding;
	}

	/* script contains NULL bytes -> auto-detection */
	if ((pos1 = memchr(LANG_SCNG(script_org), 0, LANG_SCNG(script_org_size)))) {
		/* check if the NULL byte is after the __HALT_COMPILER(); */
		pos2 = LANG_SCNG(script_org);

		while (pos1 - pos2 >= sizeof("__HALT_COMPILER();")-1) {
			pos2 = memchr(pos2, '_', pos1 - pos2);
			if (!pos2) break;
			pos2++;
			if (strncasecmp((char*)pos2, "_HALT_COMPILER", sizeof("_HALT_COMPILER")-1) == 0) {
				pos2 += sizeof("_HALT_COMPILER")-1;
				while (*pos2 == ' '  ||
					   *pos2 == '\t' ||
					   *pos2 == '\r' ||
					   *pos2 == '\n') {
					pos2++;
				}
				if (*pos2 == '(') {
					pos2++;
					while (*pos2 == ' '  ||
						   *pos2 == '\t' ||
						   *pos2 == '\r' ||
						   *pos2 == '\n') {
						pos2++;
					}
					if (*pos2 == ')') {
						pos2++;
						while (*pos2 == ' '  ||
							   *pos2 == '\t' ||
							   *pos2 == '\r' ||
							   *pos2 == '\n') {
							pos2++;
						}
						if (*pos2 == ';') {
							return NULL;
						}
					}
				}
			}
		}
		/* make best effort if BOM is missing */
		return zend_multibyte_detect_utf_encoding(LANG_SCNG(script_org), LANG_SCNG(script_org_size));
	}

	return NULL;
}

static const zend_encoding* zend_multibyte_find_script_encoding(void)
{
	const zend_encoding *script_encoding;

	if (CG(detect_unicode)) {
		/* check out bom(byte order mark) and see if containing wchars */
		script_encoding = zend_multibyte_detect_unicode();
		if (script_encoding != NULL) {
			/* bom or wchar detection is prior to 'script_encoding' option */
			return script_encoding;
		}
	}

	/* if no script_encoding specified, just leave alone */
	if (!CG(script_encoding_list) || !CG(script_encoding_list_size)) {
		return NULL;
	}

	/* if multiple encodings specified, detect automagically */
	if (CG(script_encoding_list_size) > 1) {
		return zend_multibyte_encoding_detector(LANG_SCNG(script_org), LANG_SCNG(script_org_size), CG(script_encoding_list), CG(script_encoding_list_size));
	}

	return CG(script_encoding_list)[0];
}

ZEND_API int zend_multibyte_set_filter(const zend_encoding *onetime_encoding)
{
	const zend_encoding *internal_encoding = zend_multibyte_get_internal_encoding();
	const zend_encoding *script_encoding = onetime_encoding ? onetime_encoding: zend_multibyte_find_script_encoding();

	if (!script_encoding) {
		return FAILURE;
	}

	/* judge input/output filter */
	LANG_SCNG(script_encoding) = script_encoding;
	LANG_SCNG(input_filter) = NULL;
	LANG_SCNG(output_filter) = NULL;

	if (!internal_encoding || LANG_SCNG(script_encoding) == internal_encoding) {
		if (!zend_multibyte_check_lexer_compatibility(LANG_SCNG(script_encoding))) {
			/* and if not, work around w/ script_encoding -> utf-8 -> script_encoding conversion */
			LANG_SCNG(input_filter) = encoding_filter_script_to_intermediate;
			LANG_SCNG(output_filter) = encoding_filter_intermediate_to_script;
		} else {
			LANG_SCNG(input_filter) = NULL;
			LANG_SCNG(output_filter) = NULL;
		}
		return SUCCESS;
	}

	if (zend_multibyte_check_lexer_compatibility(internal_encoding)) {
		LANG_SCNG(input_filter) = encoding_filter_script_to_internal;
		LANG_SCNG(output_filter) = NULL;
	} else if (zend_multibyte_check_lexer_compatibility(LANG_SCNG(script_encoding))) {
		LANG_SCNG(input_filter) = NULL;
		LANG_SCNG(output_filter) = encoding_filter_script_to_internal;
	} else {
		/* both script and internal encodings are incompatible w/ flex */
		LANG_SCNG(input_filter) = encoding_filter_script_to_intermediate;
		LANG_SCNG(output_filter) = encoding_filter_intermediate_to_internal;
	}

	return 0;
}

ZEND_API int open_file_for_scanning(zend_file_handle *file_handle)
{
	const char *file_path = NULL;
	char *buf;
	size_t size, offset = 0;
	zend_string *compiled_filename;

	/* The shebang line was read, get the current position to obtain the buffer start */
	if (CG(start_lineno) == 2 && file_handle->type == ZEND_HANDLE_FP && file_handle->handle.fp) {
		if ((offset = ftell(file_handle->handle.fp)) == -1) {
			offset = 0;
		}
	}

	if (zend_stream_fixup(file_handle, &buf, &size) == FAILURE) {
		return FAILURE;
	}

	zend_llist_add_element(&CG(open_files), file_handle);
	if (file_handle->handle.stream.handle >= (void*)file_handle && file_handle->handle.stream.handle <= (void*)(file_handle+1)) {
		zend_file_handle *fh = (zend_file_handle*)zend_llist_get_last(&CG(open_files));
		size_t diff = (char*)file_handle->handle.stream.handle - (char*)file_handle;
		fh->handle.stream.handle = (void*)(((char*)fh) + diff);
		file_handle->handle.stream.handle = fh->handle.stream.handle;
	}

	/* Reset the scanner for scanning the new file */
	SCNG(yy_in) = file_handle;
	SCNG(yy_start) = NULL;

	if (size != -1) {
		if (CG(multibyte)) {
			SCNG(script_org) = (unsigned char*)buf;
			SCNG(script_org_size) = size;
			SCNG(script_filtered) = NULL;

			zend_multibyte_set_filter(NULL);

			if (SCNG(input_filter)) {
				if ((size_t)-1 == SCNG(input_filter)(&SCNG(script_filtered), &SCNG(script_filtered_size), SCNG(script_org), SCNG(script_org_size))) {
					zend_error_noreturn(E_COMPILE_ERROR, "Could not convert the script from the detected "
							"encoding \"%s\" to a compatible encoding", zend_multibyte_get_encoding_name(LANG_SCNG(script_encoding)));
				}
				buf = (char*)SCNG(script_filtered);
				size = SCNG(script_filtered_size);
			}
		}
		SCNG(yy_start) = (unsigned char *)buf - offset;
		yy_scan_buffer(buf, (unsigned int)size);
	} else {
		zend_error_noreturn(E_COMPILE_ERROR, "zend_stream_mmap() failed");
	}

	BEGIN(INITIAL);

	if (file_handle->opened_path) {
		file_path = file_handle->opened_path;
	} else {
		file_path = file_handle->filename;
	}

	compiled_filename = zend_string_init(file_path, strlen(file_path), 0);
	zend_set_compiled_filename(compiled_filename);
	zend_string_release(compiled_filename);

	if (CG(start_lineno)) {
		CG(zend_lineno) = CG(start_lineno);
		CG(start_lineno) = 0;
	} else {
		CG(zend_lineno) = 1;
	}

	RESET_DOC_COMMENT();
	CG(increment_lineno) = 0;
	return SUCCESS;
}
END_EXTERN_C()


ZEND_API zend_op_array *compile_file(zend_file_handle *file_handle, int type)
{
	zend_lex_state original_lex_state;
	zend_op_array *op_array = (zend_op_array *) emalloc(sizeof(zend_op_array));
	zend_op_array *original_active_op_array = CG(active_op_array);
	int compiler_result;
	zend_bool compilation_successful=0;
	zval retval_zv;
	zend_bool original_in_compilation = CG(in_compilation);

	ZVAL_LONG(&retval_zv, 1);

	zend_save_lexical_state(&original_lex_state);

	if (open_file_for_scanning(file_handle)==FAILURE) {
		if (type==ZEND_REQUIRE) {
			zend_message_dispatcher(ZMSG_FAILED_REQUIRE_FOPEN, file_handle->filename);
			zend_bailout();
		} else {
			zend_message_dispatcher(ZMSG_FAILED_INCLUDE_FOPEN, file_handle->filename);
		}
		compilation_successful=0;
	} else {
		init_op_array(op_array, ZEND_USER_FUNCTION, INITIAL_OP_ARRAY_SIZE);
		CG(in_compilation) = 1;
		CG(active_op_array) = op_array;
		zend_stack_push(&CG(context_stack), (void *) &CG(context));
		zend_init_compiler_context();
		CG(ast_arena) = zend_arena_create(1024 * 32);
		compiler_result = zendparse();
		if (compiler_result != 0) { /* parser error */
			zend_bailout();
		}
		if (zend_ast_process) {
			zend_ast_process(CG(ast));
		}
		zend_compile_top_stmt(CG(ast));
		zend_ast_destroy(CG(ast));
		zend_arena_destroy(CG(ast_arena));
		zend_do_end_compilation();
		zend_emit_final_return(&retval_zv);
		CG(in_compilation) = original_in_compilation;
		compilation_successful=1;
	}

	CG(active_op_array) = original_active_op_array;
	if (compilation_successful) {
		pass_two(op_array);
		zend_release_labels(0);
	} else {
		efree_size(op_array, sizeof(zend_op_array));
		op_array = NULL;
	}

	zend_restore_lexical_state(&original_lex_state);
	return op_array;
}


zend_op_array *compile_filename(int type, zval *filename)
{
	zend_file_handle file_handle;
	zval tmp;
	zend_op_array *retval;
	char *opened_path = NULL;

	if (Z_TYPE_P(filename) != IS_STRING) {
		tmp = *filename;
		zval_copy_ctor(&tmp);
		convert_to_string(&tmp);
		filename = &tmp;
	}
	file_handle.filename = Z_STRVAL_P(filename);
	file_handle.free_filename = 0;
	file_handle.type = ZEND_HANDLE_FILENAME;
	file_handle.opened_path = NULL;
	file_handle.handle.fp = NULL;

	retval = zend_compile_file(&file_handle, type);
	if (retval && file_handle.handle.stream.handle) {
		if (!file_handle.opened_path) {
			file_handle.opened_path = opened_path = estrndup(Z_STRVAL_P(filename), Z_STRLEN_P(filename));
		}

		zend_hash_str_add_empty_element(&EG(included_files), file_handle.opened_path, strlen(file_handle.opened_path));

		if (opened_path) {
			efree(opened_path);
		}
	}
	zend_destroy_file_handle(&file_handle);

	if (filename==&tmp) {
		zval_dtor(&tmp);
	}
	return retval;
}

ZEND_API int zend_prepare_string_for_scanning(zval *str, char *filename)
{
	char *buf;
	size_t size, old_len;
	zend_string *new_compiled_filename;

	/* enforce ZEND_MMAP_AHEAD trailing NULLs for flex... */
	old_len = Z_STRLEN_P(str);
	Z_STR_P(str) = zend_string_realloc(Z_STR_P(str), old_len + ZEND_MMAP_AHEAD, 0);
	Z_TYPE_INFO_P(str) = IS_STRING_EX;
	memset(Z_STRVAL_P(str) + old_len, 0, ZEND_MMAP_AHEAD + 1);

	SCNG(yy_in) = NULL;
	SCNG(yy_start) = NULL;

	buf = Z_STRVAL_P(str);
	size = old_len;

	if (CG(multibyte)) {
		SCNG(script_org) = (unsigned char*)buf;
		SCNG(script_org_size) = size;
		SCNG(script_filtered) = NULL;

		zend_multibyte_set_filter(zend_multibyte_get_internal_encoding());

		if (SCNG(input_filter)) {
			if ((size_t)-1 == SCNG(input_filter)(&SCNG(script_filtered), &SCNG(script_filtered_size), SCNG(script_org), SCNG(script_org_size))) {
				zend_error_noreturn(E_COMPILE_ERROR, "Could not convert the script from the detected "
						"encoding \"%s\" to a compatible encoding", zend_multibyte_get_encoding_name(LANG_SCNG(script_encoding)));
			}
			buf = (char*)SCNG(script_filtered);
			size = SCNG(script_filtered_size);
		}
	}

	yy_scan_buffer(buf, (unsigned int)size);

	new_compiled_filename = zend_string_init(filename, strlen(filename), 0);
	zend_set_compiled_filename(new_compiled_filename);
	zend_string_release(new_compiled_filename);
	CG(zend_lineno) = 1;
	CG(increment_lineno) = 0;
	RESET_DOC_COMMENT();
	return SUCCESS;
}


ZEND_API size_t zend_get_scanned_file_offset(void)
{
	size_t offset = SCNG(yy_cursor) - SCNG(yy_start);
	if (SCNG(input_filter)) {
		size_t original_offset = offset, length = 0;
		do {
			unsigned char *p = NULL;
			if ((size_t)-1 == SCNG(input_filter)(&p, &length, SCNG(script_org), offset)) {
				return (size_t)-1;
			}
			efree(p);
			if (length > original_offset) {
				offset--;
			} else if (length < original_offset) {
				offset++;
			}
		} while (original_offset != length);
	}
	return offset;
}


zend_op_array *compile_string(zval *source_string, char *filename)
{
	zend_lex_state original_lex_state;
	zend_op_array *op_array = NULL;
	zval tmp;
	zend_bool original_in_compilation = CG(in_compilation);

	if (Z_STRLEN_P(source_string)==0) {
		return NULL;
	}

	ZVAL_DUP(&tmp, source_string);
	convert_to_string(&tmp);
	source_string = &tmp;

	CG(in_compilation) = 1;
	zend_save_lexical_state(&original_lex_state);
	if (zend_prepare_string_for_scanning(source_string, filename) == SUCCESS) {
		CG(ast) = NULL;
		CG(ast_arena) = zend_arena_create(1024 * 32);
		BEGIN(ST_IN_SCRIPTING);

		if (!zendparse()) {
			zend_op_array *original_active_op_array = CG(active_op_array);
			op_array = emalloc(sizeof(zend_op_array));
			init_op_array(op_array, ZEND_EVAL_CODE, INITIAL_OP_ARRAY_SIZE);
			CG(active_op_array) = op_array;

			zend_stack_push(&CG(context_stack), (void *) &CG(context));
			zend_init_compiler_context();
			if (zend_ast_process) {
				zend_ast_process(CG(ast));
			}
			zend_compile_top_stmt(CG(ast));
			zend_do_end_compilation();
			zend_emit_final_return(NULL);
			pass_two(op_array);
			zend_release_labels(0);

			CG(active_op_array) = original_active_op_array;
		}

		zend_ast_destroy(CG(ast));
		zend_arena_destroy(CG(ast_arena));
	}

	zend_restore_lexical_state(&original_lex_state);
	zval_dtor(&tmp);
	CG(in_compilation) = original_in_compilation;
	return op_array;
}


BEGIN_EXTERN_C()
int highlight_file(char *filename, zend_syntax_highlighter_ini *syntax_highlighter_ini)
{
	zend_lex_state original_lex_state;
	zend_file_handle file_handle;

	file_handle.type = ZEND_HANDLE_FILENAME;
	file_handle.filename = filename;
	file_handle.free_filename = 0;
	file_handle.opened_path = NULL;
	zend_save_lexical_state(&original_lex_state);
	if (open_file_for_scanning(&file_handle)==FAILURE) {
		zend_message_dispatcher(ZMSG_FAILED_HIGHLIGHT_FOPEN, filename);
		zend_restore_lexical_state(&original_lex_state);
		return FAILURE;
	}
	zend_highlight(syntax_highlighter_ini);
	if (SCNG(script_filtered)) {
		efree(SCNG(script_filtered));
		SCNG(script_filtered) = NULL;
	}
	zend_destroy_file_handle(&file_handle);
	zend_restore_lexical_state(&original_lex_state);
	return SUCCESS;
}

int highlight_string(zval *str, zend_syntax_highlighter_ini *syntax_highlighter_ini, char *str_name)
{
	zend_lex_state original_lex_state;
	zval tmp = *str;

	str = &tmp;
	zval_copy_ctor(str);
	zend_save_lexical_state(&original_lex_state);
	if (zend_prepare_string_for_scanning(str, str_name)==FAILURE) {
		zend_restore_lexical_state(&original_lex_state);
		return FAILURE;
	}
	BEGIN(INITIAL);
	zend_highlight(syntax_highlighter_ini);
	if (SCNG(script_filtered)) {
		efree(SCNG(script_filtered));
		SCNG(script_filtered) = NULL;
	}
	zend_restore_lexical_state(&original_lex_state);
	zval_dtor(str);
	return SUCCESS;
}

ZEND_API void zend_multibyte_yyinput_again(zend_encoding_filter old_input_filter, const zend_encoding *old_encoding)
{
	size_t length;
	unsigned char *new_yy_start;

	/* convert and set */
	if (!SCNG(input_filter)) {
		if (SCNG(script_filtered)) {
			efree(SCNG(script_filtered));
			SCNG(script_filtered) = NULL;
		}
		SCNG(script_filtered_size) = 0;
		length = SCNG(script_org_size);
		new_yy_start = SCNG(script_org);
	} else {
		if ((size_t)-1 == SCNG(input_filter)(&new_yy_start, &length, SCNG(script_org), SCNG(script_org_size))) {
			zend_error_noreturn(E_COMPILE_ERROR, "Could not convert the script from the detected "
					"encoding \"%s\" to a compatible encoding", zend_multibyte_get_encoding_name(LANG_SCNG(script_encoding)));
		}
		if (SCNG(script_filtered)) {
			efree(SCNG(script_filtered));
		}
		SCNG(script_filtered) = new_yy_start;
		SCNG(script_filtered_size) = length;
	}

	SCNG(yy_cursor) = new_yy_start + (SCNG(yy_cursor) - SCNG(yy_start));
	SCNG(yy_marker) = new_yy_start + (SCNG(yy_marker) - SCNG(yy_start));
	SCNG(yy_text) = new_yy_start + (SCNG(yy_text) - SCNG(yy_start));
	SCNG(yy_limit) = new_yy_start + length;

	SCNG(yy_start) = new_yy_start;
}


// TODO: avoid reallocation ???
# define zend_copy_value(zendlval, yytext, yyleng) \
	if (SCNG(output_filter)) { \
		size_t sz = 0; \
		char *s = NULL; \
		SCNG(output_filter)((unsigned char **)&s, &sz, (unsigned char *)yytext, (size_t)yyleng); \
		ZVAL_STRINGL(zendlval, s, sz); \
		efree(s); \
	} else { \
		ZVAL_STRINGL(zendlval, yytext, yyleng); \
	}

static void zend_scan_escape_string(zval *zendlval, char *str, int len, char quote_type)
{
	register char *s, *t;
	char *end;

	ZVAL_STRINGL(zendlval, str, len);

	/* convert escape sequences */
	s = t = Z_STRVAL_P(zendlval);
	end = s+Z_STRLEN_P(zendlval);
	while (s<end) {
		if (*s=='\\') {
			s++;
			if (s >= end) {
				*t++ = '\\';
				break;
			}

			switch(*s) {
				case 'n':
					*t++ = '\n';
					Z_STRLEN_P(zendlval)--;
					break;
				case 'r':
					*t++ = '\r';
					Z_STRLEN_P(zendlval)--;
					break;
				case 't':
					*t++ = '\t';
					Z_STRLEN_P(zendlval)--;
					break;
				case 'f':
					*t++ = '\f';
					Z_STRLEN_P(zendlval)--;
					break;
				case 'v':
					*t++ = '\v';
					Z_STRLEN_P(zendlval)--;
					break;
				case 'e':
#ifdef PHP_WIN32
					*t++ = VK_ESCAPE;
#else
					*t++ = '\e';
#endif
					Z_STRLEN_P(zendlval)--;
					break;
				case '"':
				case '`':
					if (*s != quote_type) {
						*t++ = '\\';
						*t++ = *s;
						break;
					}
				case '\\':
				case '$':
					*t++ = *s;
					Z_STRLEN_P(zendlval)--;
					break;
				case 'x':
				case 'X':
					if (ZEND_IS_HEX(*(s+1))) {
						char hex_buf[3] = { 0, 0, 0 };

						Z_STRLEN_P(zendlval)--; /* for the 'x' */

						hex_buf[0] = *(++s);
						Z_STRLEN_P(zendlval)--;
						if (ZEND_IS_HEX(*(s+1))) {
							hex_buf[1] = *(++s);
							Z_STRLEN_P(zendlval)--;
						}
						*t++ = (char) ZEND_STRTOL(hex_buf, NULL, 16);
					} else {
						*t++ = '\\';
						*t++ = *s;
					}
					break;
				/* UTF-8 codepoint escape, format: /\\u\{\x+\}/ */
				case 'u':
					{
						/* cache where we started so we can parse after validating */
						char *start = s + 1;
						size_t len = 0;
						zend_bool valid = 1;
						unsigned long codepoint;
						size_t byte_len = 0;

						if (*start != '{') {
							/* we silently let this pass to avoid breaking code
							 * with JSON in string literals (e.g. "\"\u202e\""
							 */
							*t++ = '\\';
							*t++ = 'u';
							break;
						} else {
							/* on the other hand, invalid \u{blah} errors */
							s++;
							len++;
							s++;
							while (*s != '}') {
								if (!ZEND_IS_HEX(*s)) {
									valid = 0;
									break;
								} else {
									len++;
								}
								s++;
							}
							if (*s == '}') {
								valid = 1;
								len++;
							}
						}

						/* \u{} is invalid */
						if (len <= 2) {
							valid = 0;
						}

						if (!valid) {
							zend_error(E_COMPILE_ERROR, "Invalid UTF-8 codepoint escape sequence");
						}

						errno = 0;
						codepoint = strtoul(start + 1, NULL, 16);

						/* per RFC 3629, UTF-8 can only represent 21 bits */
						if (codepoint > 0x10FFFF || errno) {
							zend_error_noreturn(E_COMPILE_ERROR, "Invalid UTF-8 codepoint escape sequence: Codepoint too large");
						}

						/* based on https://en.wikipedia.org/wiki/UTF-8#Sample_code */
						if (codepoint < 0x80) {
							byte_len = 1;
							*t++ = codepoint;
						} else if (codepoint <= 0x7FF) {
							byte_len = 2;
							*t++ = (codepoint >> 6) + 0xC0;
							*t++ = (codepoint & 0x3F) + 0x80;
						} else if (codepoint <= 0xFFFF) {
							byte_len = 3;
							*t++ = (codepoint >> 12) + 0xE0;
							*t++ = ((codepoint >> 6) & 0x3F) + 0x80;
							*t++ = (codepoint & 0x3F) + 0x80;
						} else if (codepoint <= 0x10FFFF) {
							byte_len = 4;
							*t++ = (codepoint >> 18) + 0xF0;
							*t++ = ((codepoint >> 12) & 0x3F) + 0x80;
							*t++ = ((codepoint >> 6) & 0x3F) + 0x80;
							*t++ = (codepoint & 0x3F) + 0x80;
						}

						Z_STRLEN_P(zendlval) -= 2; /* \u */
						Z_STRLEN_P(zendlval) -= (len - byte_len);
					}
					break;
				default:
					/* check for an octal */
					if (ZEND_IS_OCT(*s)) {
						char octal_buf[4] = { 0, 0, 0, 0 };

						octal_buf[0] = *s;
						Z_STRLEN_P(zendlval)--;
						if (ZEND_IS_OCT(*(s+1))) {
							octal_buf[1] = *(++s);
							Z_STRLEN_P(zendlval)--;
							if (ZEND_IS_OCT(*(s+1))) {
								octal_buf[2] = *(++s);
								Z_STRLEN_P(zendlval)--;
							}
						}
						*t++ = (char) ZEND_STRTOL(octal_buf, NULL, 8);
					} else {
						*t++ = '\\';
						*t++ = *s;
					}
					break;
			}
		} else {
			*t++ = *s;
		}

		if (*s == '\n' || (*s == '\r' && (*(s+1) != '\n'))) {
			CG(zend_lineno)++;
		}
		s++;
	}
	*t = 0;
	if (SCNG(output_filter)) {
		size_t sz = 0;
		unsigned char *str;
		// TODO: avoid realocation ???
		s = Z_STRVAL_P(zendlval);
		SCNG(output_filter)(&str, &sz, (unsigned char *)s, (size_t)Z_STRLEN_P(zendlval));
		zval_ptr_dtor(zendlval);
		ZVAL_STRINGL(zendlval, (char *) str, sz);
		efree(str);
	}
}


int lex_scan(zval *zendlval)
{
restart:
	SCNG(yy_text) = YYCURSOR;


{
	YYCTYPE yych;
	unsigned int yyaccept = 0;
	static void *yyctable[10] = {
		&&yyc_ST_IN_SCRIPTING,
		&&yyc_ST_LOOKING_FOR_PROPERTY,
		&&yyc_ST_BACKQUOTE,
		&&yyc_ST_DOUBLE_QUOTES,
		&&yyc_ST_HEREDOC,
		&&yyc_ST_LOOKING_FOR_VARNAME,
		&&yyc_ST_VAR_OFFSET,
		&&yyc_INITIAL,
		&&yyc_ST_END_HEREDOC,
		&&yyc_ST_NOWDOC,
	};
	goto *yyctable[YYGETCONDITION()];
/* *********************************** */
yyc_ST_IN_SCRIPTING:
	{
		static const unsigned char yybm[] = {
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,  36,   4,   0,   0,   4,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			 36,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			216, 216, 152, 152, 152, 152, 152, 152, 
			152, 152,   0,   0,   0,   0,   0,   0, 
			  0, 144, 144, 144, 144, 144, 144,  16, 
			 16,  16,  16,  16,  16,  16,  16,  16, 
			 16,  16,  16,  16,  16,  16,  16,  16, 
			 16,  16,  16,   0,   0,   0,   0,  16, 
			  0, 144, 144, 144, 144, 144, 144,  16, 
			 16,  16,  16,  16,  16,  16,  16,  16, 
			 16,  16,  16,  16,  16,  16,  16,  16, 
			 16,  16,  16,   0,   0,   0,   0,  16, 
			 16,  16,  16,  16,  16,  16,  16,  16, 
			 16,  16,  16,  16,  16,  16,  16,  16, 
			 16,  16,  16,  16,  16,  16,  16,  16, 
			 16,  16,  16,  16,  16,  16,  16,  16, 
			 16,  16,  16,  16,  16,  16,  16,  16, 
			 16,  16,  16,  16,  16,  16,  16,  16, 
			 16,  16,  16,  16,  16,  16,  16,  16, 
			 16,  16,  16,  16,  16,  16,  16,  16, 
			 16,  16,  16,  16,  16,  16,  16,  16, 
			 16,  16,  16,  16,  16,  16,  16,  16, 
			 16,  16,  16,  16,  16,  16,  16,  16, 
			 16,  16,  16,  16,  16,  16,  16,  16, 
			 16,  16,  16,  16,  16,  16,  16,  16, 
			 16,  16,  16,  16,  16,  16,  16,  16, 
			 16,  16,  16,  16,  16,  16,  16,  16, 
			 16,  16,  16,  16,  16,  16,  16,  16, 
		};
		YYDEBUG(1, *YYCURSOR);
		YYFILL(16);
		yych = *YYCURSOR;
		{
			static void *yytarget[256] = {
				&&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,
				&&yy3,  &&yy5,  &&yy5,  &&yy3,  &&yy3,  &&yy5,  &&yy3,  &&yy3,
				&&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,
				&&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,
				&&yy5,  &&yy8,  &&yy10, &&yy12, &&yy14, &&yy15, &&yy16, &&yy17,
				&&yy19, &&yy20, &&yy21, &&yy22, &&yy20, &&yy23, &&yy24, &&yy25,
				&&yy26, &&yy28, &&yy28, &&yy28, &&yy28, &&yy28, &&yy28, &&yy28,
				&&yy28, &&yy28, &&yy30, &&yy20, &&yy31, &&yy32, &&yy33, &&yy34,
				&&yy20, &&yy35, &&yy37, &&yy38, &&yy39, &&yy40, &&yy41, &&yy42,
				&&yy43, &&yy45, &&yy43, &&yy43, &&yy46, &&yy43, &&yy47, &&yy48,
				&&yy49, &&yy43, &&yy50, &&yy51, &&yy52, &&yy53, &&yy54, &&yy55,
				&&yy56, &&yy57, &&yy43, &&yy20, &&yy58, &&yy20, &&yy60, &&yy61,
				&&yy62, &&yy35, &&yy37, &&yy38, &&yy39, &&yy40, &&yy41, &&yy42,
				&&yy43, &&yy45, &&yy43, &&yy43, &&yy46, &&yy43, &&yy47, &&yy48,
				&&yy49, &&yy43, &&yy50, &&yy51, &&yy52, &&yy53, &&yy54, &&yy55,
				&&yy56, &&yy57, &&yy43, &&yy64, &&yy66, &&yy67, &&yy20, &&yy43,
				&&yy43, &&yy43, &&yy43, &&yy43, &&yy43, &&yy43, &&yy43, &&yy43,
				&&yy43, &&yy43, &&yy43, &&yy43, &&yy43, &&yy43, &&yy43, &&yy43,
				&&yy43, &&yy43, &&yy43, &&yy43, &&yy43, &&yy43, &&yy43, &&yy43,
				&&yy43, &&yy43, &&yy43, &&yy43, &&yy43, &&yy43, &&yy43, &&yy43,
				&&yy43, &&yy43, &&yy43, &&yy43, &&yy43, &&yy43, &&yy43, &&yy43,
				&&yy43, &&yy43, &&yy43, &&yy43, &&yy43, &&yy43, &&yy43, &&yy43,
				&&yy43, &&yy43, &&yy43, &&yy43, &&yy43, &&yy43, &&yy43, &&yy43,
				&&yy43, &&yy43, &&yy43, &&yy43, &&yy43, &&yy43, &&yy43, &&yy43,
				&&yy43, &&yy43, &&yy43, &&yy43, &&yy43, &&yy43, &&yy43, &&yy43,
				&&yy43, &&yy43, &&yy43, &&yy43, &&yy43, &&yy43, &&yy43, &&yy43,
				&&yy43, &&yy43, &&yy43, &&yy43, &&yy43, &&yy43, &&yy43, &&yy43,
				&&yy43, &&yy43, &&yy43, &&yy43, &&yy43, &&yy43, &&yy43, &&yy43,
				&&yy43, &&yy43, &&yy43, &&yy43, &&yy43, &&yy43, &&yy43, &&yy43,
				&&yy43, &&yy43, &&yy43, &&yy43, &&yy43, &&yy43, &&yy43, &&yy43,
				&&yy43, &&yy43, &&yy43, &&yy43, &&yy43, &&yy43, &&yy43, &&yy43,
				&&yy43, &&yy43, &&yy43, &&yy43, &&yy43, &&yy43, &&yy43, &&yy43
			};
			goto *yytarget[yych];
		}
yy3:
		YYDEBUG(3, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(4, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	if (YYCURSOR > YYLIMIT) {
		return 0;
	}

	zend_error(E_COMPILE_WARNING,"Unexpected character in input:  '%c' (ASCII=%d) state=%d", yytext[0], yytext[0], YYSTATE);
	goto restart;
}
yy5:
		YYDEBUG(5, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(6, *YYCURSOR);
		if (yybm[0+yych] & 4) {
			goto yy5;
		}
		YYDEBUG(7, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	HANDLE_NEWLINES(yytext, yyleng);
	return T_WHITESPACE;
}
yy8:
		YYDEBUG(8, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '=') goto yy69;
yy9:
		YYDEBUG(9, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return yytext[0];
}
yy10:
		YYDEBUG(10, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(11, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	int bprefix = (yytext[0] != '"') ? 1 : 0;

	while (YYCURSOR < YYLIMIT) {
		switch (*YYCURSOR++) {
			case '"':
				yyleng = YYCURSOR - SCNG(yy_text);
				zend_scan_escape_string(zendlval, yytext+bprefix+1, yyleng-bprefix-2, '"');
				return T_CONSTANT_ENCAPSED_STRING;
			case '$':
				if (IS_LABEL_START(*YYCURSOR) || *YYCURSOR == '{') {
					break;
				}
				continue;
			case '{':
				if (*YYCURSOR == '$') {
					break;
				}
				continue;
			case '\\':
				if (YYCURSOR < YYLIMIT) {
					YYCURSOR++;
				}
				/* fall through */
			default:
				continue;
		}

		YYCURSOR--;
		break;
	}

	/* Remember how much was scanned to save rescanning */
	SET_DOUBLE_QUOTES_SCANNED_LENGTH(YYCURSOR - SCNG(yy_text) - yyleng);

	YYCURSOR = SCNG(yy_text) + yyleng;

	BEGIN(ST_DOUBLE_QUOTES);
	return '"';
}
yy12:
		YYDEBUG(12, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(13, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	while (YYCURSOR < YYLIMIT) {
		switch (*YYCURSOR++) {
			case '\r':
				if (*YYCURSOR == '\n') {
					YYCURSOR++;
				}
				/* fall through */
			case '\n':
				CG(zend_lineno)++;
				break;
			case '?':
				if (*YYCURSOR == '>') {
					YYCURSOR--;
					break;
				}
				/* fall through */
			default:
				continue;
		}

		break;
	}

	yyleng = YYCURSOR - SCNG(yy_text);

	return T_COMMENT;
}
yy14:
		YYDEBUG(14, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= '_') {
			if (yych <= '@') goto yy9;
			if (yych <= 'Z') goto yy71;
			if (yych <= '^') goto yy9;
			goto yy71;
		} else {
			if (yych <= '`') goto yy9;
			if (yych <= 'z') goto yy71;
			if (yych <= '~') goto yy9;
			goto yy71;
		}
yy15:
		YYDEBUG(15, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '=') goto yy74;
		goto yy9;
yy16:
		YYDEBUG(16, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '&') goto yy76;
		if (yych == '=') goto yy78;
		goto yy9;
yy17:
		YYDEBUG(17, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(18, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	register char *s, *t;
	char *end;
	int bprefix = (yytext[0] != '\'') ? 1 : 0;

	while (1) {
		if (YYCURSOR < YYLIMIT) {
			if (*YYCURSOR == '\'') {
				YYCURSOR++;
				yyleng = YYCURSOR - SCNG(yy_text);

				break;
			} else if (*YYCURSOR++ == '\\' && YYCURSOR < YYLIMIT) {
				YYCURSOR++;
			}
		} else {
			yyleng = YYLIMIT - SCNG(yy_text);

			/* Unclosed single quotes; treat similar to double quotes, but without a separate token
			 * for ' (unrecognized by parser), instead of old flex fallback to "Unexpected character..."
			 * rule, which continued in ST_IN_SCRIPTING state after the quote */
			ZVAL_NULL(zendlval);
			return T_ENCAPSED_AND_WHITESPACE;
		}
	}

	ZVAL_STRINGL(zendlval, yytext+bprefix+1, yyleng-bprefix-2);

	/* convert escape sequences */
	s = t = Z_STRVAL_P(zendlval);
	end = s+Z_STRLEN_P(zendlval);
	while (s<end) {
		if (*s=='\\') {
			s++;

			switch(*s) {
				case '\\':
				case '\'':
					*t++ = *s;
					Z_STRLEN_P(zendlval)--;
					break;
				default:
					*t++ = '\\';
					*t++ = *s;
					break;
			}
		} else {
			*t++ = *s;
		}

		if (*s == '\n' || (*s == '\r' && (*(s+1) != '\n'))) {
			CG(zend_lineno)++;
		}
		s++;
	}
	*t = 0;

	if (SCNG(output_filter)) {
		size_t sz = 0;
		char *str = NULL;
		s = Z_STRVAL_P(zendlval);
		// TODO: avoid reallocation ???
		SCNG(output_filter)((unsigned char **)&str, &sz, (unsigned char *)s, (size_t)Z_STRLEN_P(zendlval));
		ZVAL_STRINGL(zendlval, str, sz);
	}
	return T_CONSTANT_ENCAPSED_STRING;
}
yy19:
		YYDEBUG(19, *YYCURSOR);
		yyaccept = 0;
		yych = *(YYMARKER = ++YYCURSOR);
		{
			static void *yytarget[256] = {
				&&yy9,  &&yy9,  &&yy9,  &&yy9,  &&yy9,  &&yy9,  &&yy9,  &&yy9,
				&&yy9,  &&yy81, &&yy9,  &&yy9,  &&yy9,  &&yy9,  &&yy9,  &&yy9,
				&&yy9,  &&yy9,  &&yy9,  &&yy9,  &&yy9,  &&yy9,  &&yy9,  &&yy9,
				&&yy9,  &&yy9,  &&yy9,  &&yy9,  &&yy9,  &&yy9,  &&yy9,  &&yy9,
				&&yy81, &&yy9,  &&yy9,  &&yy9,  &&yy9,  &&yy9,  &&yy9,  &&yy9,
				&&yy9,  &&yy9,  &&yy9,  &&yy9,  &&yy9,  &&yy9,  &&yy9,  &&yy9,
				&&yy9,  &&yy9,  &&yy9,  &&yy9,  &&yy9,  &&yy9,  &&yy9,  &&yy9,
				&&yy9,  &&yy9,  &&yy9,  &&yy9,  &&yy9,  &&yy9,  &&yy9,  &&yy9,
				&&yy9,  &&yy81, &&yy81, &&yy9,  &&yy81, &&yy9,  &&yy81, &&yy9,
				&&yy9,  &&yy81, &&yy9,  &&yy9,  &&yy9,  &&yy9,  &&yy9,  &&yy81,
				&&yy9,  &&yy9,  &&yy81, &&yy81, &&yy9,  &&yy81, &&yy9,  &&yy9,
				&&yy9,  &&yy9,  &&yy9,  &&yy9,  &&yy9,  &&yy9,  &&yy9,  &&yy9,
				&&yy9,  &&yy81, &&yy81, &&yy9,  &&yy81, &&yy9,  &&yy81, &&yy9,
				&&yy9,  &&yy81, &&yy9,  &&yy9,  &&yy9,  &&yy9,  &&yy9,  &&yy81,
				&&yy9,  &&yy9,  &&yy81, &&yy81, &&yy9,  &&yy81, &&yy9,  &&yy9,
				&&yy9,  &&yy9,  &&yy9,  &&yy9,  &&yy9,  &&yy9,  &&yy9,  &&yy9,
				&&yy9,  &&yy9,  &&yy9,  &&yy9,  &&yy9,  &&yy9,  &&yy9,  &&yy9,
				&&yy9,  &&yy9,  &&yy9,  &&yy9,  &&yy9,  &&yy9,  &&yy9,  &&yy9,
				&&yy9,  &&yy9,  &&yy9,  &&yy9,  &&yy9,  &&yy9,  &&yy9,  &&yy9,
				&&yy9,  &&yy9,  &&yy9,  &&yy9,  &&yy9,  &&yy9,  &&yy9,  &&yy9,
				&&yy9,  &&yy9,  &&yy9,  &&yy9,  &&yy9,  &&yy9,  &&yy9,  &&yy9,
				&&yy9,  &&yy9,  &&yy9,  &&yy9,  &&yy9,  &&yy9,  &&yy9,  &&yy9,
				&&yy9,  &&yy9,  &&yy9,  &&yy9,  &&yy9,  &&yy9,  &&yy9,  &&yy9,
				&&yy9,  &&yy9,  &&yy9,  &&yy9,  &&yy9,  &&yy9,  &&yy9,  &&yy9,
				&&yy9,  &&yy9,  &&yy9,  &&yy9,  &&yy9,  &&yy9,  &&yy9,  &&yy9,
				&&yy9,  &&yy9,  &&yy9,  &&yy9,  &&yy9,  &&yy9,  &&yy9,  &&yy9,
				&&yy9,  &&yy9,  &&yy9,  &&yy9,  &&yy9,  &&yy9,  &&yy9,  &&yy9,
				&&yy9,  &&yy9,  &&yy9,  &&yy9,  &&yy9,  &&yy9,  &&yy9,  &&yy9,
				&&yy9,  &&yy9,  &&yy9,  &&yy9,  &&yy9,  &&yy9,  &&yy9,  &&yy9,
				&&yy9,  &&yy9,  &&yy9,  &&yy9,  &&yy9,  &&yy9,  &&yy9,  &&yy9,
				&&yy9,  &&yy9,  &&yy9,  &&yy9,  &&yy9,  &&yy9,  &&yy9,  &&yy9,
				&&yy9,  &&yy9,  &&yy9,  &&yy9,  &&yy9,  &&yy9,  &&yy9,  &&yy9
			};
			goto *yytarget[yych];
		}
yy20:
		YYDEBUG(20, *YYCURSOR);
		++YYCURSOR;
		goto yy9;
yy21:
		YYDEBUG(21, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '*') goto yy92;
		if (yych == '=') goto yy94;
		goto yy9;
yy22:
		YYDEBUG(22, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '+') goto yy96;
		if (yych == '=') goto yy98;
		goto yy9;
yy23:
		YYDEBUG(23, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= '<') {
			if (yych == '-') goto yy100;
			goto yy9;
		} else {
			if (yych <= '=') goto yy102;
			if (yych <= '>') goto yy104;
			goto yy9;
		}
yy24:
		YYDEBUG(24, *YYCURSOR);
		yyaccept = 0;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= '/') {
			if (yych == '.') goto yy106;
			goto yy9;
		} else {
			if (yych <= '9') goto yy107;
			if (yych == '=') goto yy110;
			goto yy9;
		}
yy25:
		YYDEBUG(25, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= '.') {
			if (yych == '*') goto yy112;
			goto yy9;
		} else {
			if (yych <= '/') goto yy12;
			if (yych == '=') goto yy114;
			goto yy9;
		}
yy26:
		YYDEBUG(26, *YYCURSOR);
		yyaccept = 1;
		yych = *(YYMARKER = ++YYCURSOR);
		{
			static void *yytarget[256] = {
				&&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,
				&&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,
				&&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,
				&&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,
				&&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,
				&&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,
				&&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,
				&&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,
				&&yy29,  &&yy29,  &&yy116, &&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,
				&&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,
				&&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,
				&&yy118, &&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,
				&&yy29,  &&yy29,  &&yy116, &&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,
				&&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,
				&&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,
				&&yy118, &&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,
				&&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,
				&&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,
				&&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,
				&&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,
				&&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,
				&&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,
				&&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,
				&&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,
				&&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,
				&&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,
				&&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,
				&&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,
				&&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,
				&&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,
				&&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,
				&&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29,  &&yy29
			};
			goto *yytarget[yych];
		}
yy27:
		YYDEBUG(27, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	char *end;
	if (yyleng < MAX_LENGTH_OF_LONG - 1) { /* Won't overflow */
		errno = 0;
		ZVAL_LONG(zendlval, ZEND_STRTOL(yytext, &end, 0));
		/* This isn't an assert, we need to ensure 019 isn't valid octal
		 * Because the lexing itself doesn't do that for us
		 */
		if (end != yytext + yyleng) {
			zend_error_noreturn(E_COMPILE_ERROR, "Invalid numeric literal");
		}
		ZEND_ASSERT(!errno);
	} else {
		errno = 0;
		ZVAL_LONG(zendlval, ZEND_STRTOL(yytext, &end, 0));
		if (errno == ERANGE) { /* Overflow */
			errno = 0;
			if (yytext[0] == '0') { /* octal overflow */
				errno = 0;
				ZVAL_DOUBLE(zendlval, zend_oct_strtod(yytext, (const char **)&end));
			} else {
				ZVAL_DOUBLE(zendlval, zend_strtod(yytext, (const char **)&end));
			}
			/* Also not an assert for the same reason */
			if (end != yytext + yyleng) {
				zend_error_noreturn(E_COMPILE_ERROR, "Invalid numeric literal");
			}
			ZEND_ASSERT(!errno);
			return T_DNUMBER;
		}
		/* Also not an assert for the same reason */
		if (end != yytext + yyleng) {
			zend_error_noreturn(E_COMPILE_ERROR, "Invalid numeric literal");
		}
		ZEND_ASSERT(!errno);
	}
	return T_LNUMBER;
}
yy28:
		YYDEBUG(28, *YYCURSOR);
		yyaccept = 1;
		YYMARKER = ++YYCURSOR;
		YYFILL(3);
		yych = *YYCURSOR;
yy29:
		YYDEBUG(29, *YYCURSOR);
		if (yybm[0+yych] & 8) {
			goto yy28;
		}
		if (yych <= 'D') {
			if (yych == '.') goto yy107;
			goto yy27;
		} else {
			if (yych <= 'E') goto yy117;
			if (yych == 'e') goto yy117;
			goto yy27;
		}
yy30:
		YYDEBUG(30, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == ':') goto yy119;
		goto yy9;
yy31:
		YYDEBUG(31, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= ';') goto yy9;
		if (yych <= '<') goto yy121;
		if (yych <= '=') goto yy123;
		if (yych <= '>') goto yy125;
		goto yy9;
yy32:
		YYDEBUG(32, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= '<') goto yy9;
		if (yych <= '=') goto yy126;
		if (yych <= '>') goto yy128;
		goto yy9;
yy33:
		YYDEBUG(33, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= '<') goto yy9;
		if (yych <= '=') goto yy130;
		if (yych <= '>') goto yy132;
		goto yy9;
yy34:
		YYDEBUG(34, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= '=') goto yy9;
		if (yych <= '>') goto yy134;
		if (yych <= '?') goto yy136;
		goto yy9;
yy35:
		YYDEBUG(35, *YYCURSOR);
		yych = *++YYCURSOR;
		{
			static void *yytarget[256] = {
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy138, &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy139, &&yy44,
				&&yy44,  &&yy44,  &&yy140, &&yy141, &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy138, &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy139, &&yy44,
				&&yy44,  &&yy44,  &&yy140, &&yy141, &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44
			};
			goto *yytarget[yych];
		}
yy36:
		YYDEBUG(36, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	zend_copy_value(zendlval, yytext, yyleng);
	return T_STRING;
}
yy37:
		YYDEBUG(37, *YYCURSOR);
		yyaccept = 2;
		yych = *(YYMARKER = ++YYCURSOR);
		{
			static void *yytarget[256] = {
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy10,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy17,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy143, &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy144, &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy144, &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44
			};
			goto *yytarget[yych];
		}
yy38:
		YYDEBUG(38, *YYCURSOR);
		yych = *++YYCURSOR;
		{
			static void *yytarget[256] = {
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy145, &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy146, &&yy44,  &&yy44,  &&yy147,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy145, &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy146, &&yy44,  &&yy44,  &&yy147,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44
			};
			goto *yytarget[yych];
		}
yy39:
		YYDEBUG(39, *YYCURSOR);
		yych = *++YYCURSOR;
		{
			static void *yytarget[256] = {
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy148, &&yy44,  &&yy44,
				&&yy44,  &&yy149, &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy150,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy148, &&yy44,  &&yy44,
				&&yy44,  &&yy149, &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy150,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44
			};
			goto *yytarget[yych];
		}
yy40:
		YYDEBUG(40, *YYCURSOR);
		yych = *++YYCURSOR;
		{
			static void *yytarget[256] = {
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy152, &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy153, &&yy154, &&yy155, &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy156, &&yy44,
				&&yy157, &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy152, &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy153, &&yy154, &&yy155, &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy156, &&yy44,
				&&yy157, &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44
			};
			goto *yytarget[yych];
		}
yy41:
		YYDEBUG(41, *YYCURSOR);
		yych = *++YYCURSOR;
		{
			static void *yytarget[256] = {
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy158, &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy159,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy160, &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy158, &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy159,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy160, &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44
			};
			goto *yytarget[yych];
		}
yy42:
		YYDEBUG(42, *YYCURSOR);
		yych = *++YYCURSOR;
		{
			static void *yytarget[256] = {
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy161, &&yy44,  &&yy44,  &&yy162,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy161, &&yy44,  &&yy44,  &&yy162,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44
			};
			goto *yytarget[yych];
		}
yy43:
		YYDEBUG(43, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
yy44:
		YYDEBUG(44, *YYCURSOR);
		if (yybm[0+yych] & 16) {
			goto yy43;
		}
		goto yy36;
yy45:
		YYDEBUG(45, *YYCURSOR);
		yych = *++YYCURSOR;
		{
			static void *yytarget[256] = {
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy163, &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy165, &&yy166, &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy167, &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy163, &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy165, &&yy166, &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy167, &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44
			};
			goto *yytarget[yych];
		}
yy46:
		YYDEBUG(46, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'I') goto yy168;
		if (yych == 'i') goto yy168;
		goto yy44;
yy47:
		YYDEBUG(47, *YYCURSOR);
		yych = *++YYCURSOR;
		{
			static void *yytarget[256] = {
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy169, &&yy44,  &&yy44,  &&yy44,  &&yy170, &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy169, &&yy44,  &&yy44,  &&yy44,  &&yy170, &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44
			};
			goto *yytarget[yych];
		}
yy48:
		YYDEBUG(48, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'R') goto yy171;
		if (yych == 'r') goto yy171;
		goto yy44;
yy49:
		YYDEBUG(49, *YYCURSOR);
		yych = *++YYCURSOR;
		{
			static void *yytarget[256] = {
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy173, &&yy44,  &&yy44,  &&yy174, &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy173, &&yy44,  &&yy44,  &&yy174, &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44
			};
			goto *yytarget[yych];
		}
yy50:
		YYDEBUG(50, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy175;
		if (yych == 'e') goto yy175;
		goto yy44;
yy51:
		YYDEBUG(51, *YYCURSOR);
		yych = *++YYCURSOR;
		{
			static void *yytarget[256] = {
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy176, &&yy44,  &&yy44,  &&yy177,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy176, &&yy44,  &&yy44,  &&yy177,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44
			};
			goto *yytarget[yych];
		}
yy52:
		YYDEBUG(52, *YYCURSOR);
		yych = *++YYCURSOR;
		{
			static void *yytarget[256] = {
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy178, &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy179, &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy178, &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy179, &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44
			};
			goto *yytarget[yych];
		}
yy53:
		YYDEBUG(53, *YYCURSOR);
		yych = *++YYCURSOR;
		{
			static void *yytarget[256] = {
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy180, &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy181, &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy180, &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy181, &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44
			};
			goto *yytarget[yych];
		}
yy54:
		YYDEBUG(54, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'A') goto yy182;
		if (yych == 'a') goto yy182;
		goto yy44;
yy55:
		YYDEBUG(55, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'H') goto yy183;
		if (yych == 'h') goto yy183;
		goto yy44;
yy56:
		YYDEBUG(56, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'O') goto yy184;
		if (yych == 'o') goto yy184;
		goto yy44;
yy57:
		YYDEBUG(57, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'I') goto yy185;
		if (yych == 'i') goto yy185;
		goto yy44;
yy58:
		YYDEBUG(58, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(59, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_NS_SEPARATOR;
}
yy60:
		YYDEBUG(60, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '=') goto yy186;
		goto yy9;
yy61:
		YYDEBUG(61, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '_') goto yy188;
		goto yy44;
yy62:
		YYDEBUG(62, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(63, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	BEGIN(ST_BACKQUOTE);
	return '`';
}
yy64:
		YYDEBUG(64, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(65, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	yy_push_state(ST_IN_SCRIPTING);
	return '{';
}
yy66:
		YYDEBUG(66, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '=') goto yy189;
		if (yych == '|') goto yy191;
		goto yy9;
yy67:
		YYDEBUG(67, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(68, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RESET_DOC_COMMENT();
	if (!zend_stack_is_empty(&SCNG(state_stack))) {
		yy_pop_state();
	}
	return '}';
}
yy69:
		YYDEBUG(69, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '=') goto yy193;
yy70:
		YYDEBUG(70, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_IS_NOT_EQUAL;
}
yy71:
		YYDEBUG(71, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(72, *YYCURSOR);
		{
			static void *yytarget[256] = {
				&&yy73, &&yy73, &&yy73, &&yy73, &&yy73, &&yy73, &&yy73, &&yy73,
				&&yy73, &&yy73, &&yy73, &&yy73, &&yy73, &&yy73, &&yy73, &&yy73,
				&&yy73, &&yy73, &&yy73, &&yy73, &&yy73, &&yy73, &&yy73, &&yy73,
				&&yy73, &&yy73, &&yy73, &&yy73, &&yy73, &&yy73, &&yy73, &&yy73,
				&&yy73, &&yy73, &&yy73, &&yy73, &&yy73, &&yy73, &&yy73, &&yy73,
				&&yy73, &&yy73, &&yy73, &&yy73, &&yy73, &&yy73, &&yy73, &&yy73,
				&&yy71, &&yy71, &&yy71, &&yy71, &&yy71, &&yy71, &&yy71, &&yy71,
				&&yy71, &&yy71, &&yy73, &&yy73, &&yy73, &&yy73, &&yy73, &&yy73,
				&&yy73, &&yy71, &&yy71, &&yy71, &&yy71, &&yy71, &&yy71, &&yy71,
				&&yy71, &&yy71, &&yy71, &&yy71, &&yy71, &&yy71, &&yy71, &&yy71,
				&&yy71, &&yy71, &&yy71, &&yy71, &&yy71, &&yy71, &&yy71, &&yy71,
				&&yy71, &&yy71, &&yy71, &&yy73, &&yy73, &&yy73, &&yy73, &&yy71,
				&&yy73, &&yy71, &&yy71, &&yy71, &&yy71, &&yy71, &&yy71, &&yy71,
				&&yy71, &&yy71, &&yy71, &&yy71, &&yy71, &&yy71, &&yy71, &&yy71,
				&&yy71, &&yy71, &&yy71, &&yy71, &&yy71, &&yy71, &&yy71, &&yy71,
				&&yy71, &&yy71, &&yy71, &&yy73, &&yy73, &&yy73, &&yy73, &&yy71,
				&&yy71, &&yy71, &&yy71, &&yy71, &&yy71, &&yy71, &&yy71, &&yy71,
				&&yy71, &&yy71, &&yy71, &&yy71, &&yy71, &&yy71, &&yy71, &&yy71,
				&&yy71, &&yy71, &&yy71, &&yy71, &&yy71, &&yy71, &&yy71, &&yy71,
				&&yy71, &&yy71, &&yy71, &&yy71, &&yy71, &&yy71, &&yy71, &&yy71,
				&&yy71, &&yy71, &&yy71, &&yy71, &&yy71, &&yy71, &&yy71, &&yy71,
				&&yy71, &&yy71, &&yy71, &&yy71, &&yy71, &&yy71, &&yy71, &&yy71,
				&&yy71, &&yy71, &&yy71, &&yy71, &&yy71, &&yy71, &&yy71, &&yy71,
				&&yy71, &&yy71, &&yy71, &&yy71, &&yy71, &&yy71, &&yy71, &&yy71,
				&&yy71, &&yy71, &&yy71, &&yy71, &&yy71, &&yy71, &&yy71, &&yy71,
				&&yy71, &&yy71, &&yy71, &&yy71, &&yy71, &&yy71, &&yy71, &&yy71,
				&&yy71, &&yy71, &&yy71, &&yy71, &&yy71, &&yy71, &&yy71, &&yy71,
				&&yy71, &&yy71, &&yy71, &&yy71, &&yy71, &&yy71, &&yy71, &&yy71,
				&&yy71, &&yy71, &&yy71, &&yy71, &&yy71, &&yy71, &&yy71, &&yy71,
				&&yy71, &&yy71, &&yy71, &&yy71, &&yy71, &&yy71, &&yy71, &&yy71,
				&&yy71, &&yy71, &&yy71, &&yy71, &&yy71, &&yy71, &&yy71, &&yy71,
				&&yy71, &&yy71, &&yy71, &&yy71, &&yy71, &&yy71, &&yy71, &&yy71
			};
			goto *yytarget[yych];
		}
yy73:
		YYDEBUG(73, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	zend_copy_value(zendlval, (yytext+1), (yyleng-1));
	return T_VARIABLE;
}
yy74:
		YYDEBUG(74, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(75, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_MOD_EQUAL;
}
yy76:
		YYDEBUG(76, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(77, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_BOOLEAN_AND;
}
yy78:
		YYDEBUG(78, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(79, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_AND_EQUAL;
}
yy80:
		YYDEBUG(80, *YYCURSOR);
		++YYCURSOR;
		YYFILL(7);
		yych = *YYCURSOR;
yy81:
		YYDEBUG(81, *YYCURSOR);
		{
			static void *yytarget[256] = {
				&&yy82, &&yy82, &&yy82, &&yy82, &&yy82, &&yy82, &&yy82, &&yy82,
				&&yy82, &&yy80, &&yy82, &&yy82, &&yy82, &&yy82, &&yy82, &&yy82,
				&&yy82, &&yy82, &&yy82, &&yy82, &&yy82, &&yy82, &&yy82, &&yy82,
				&&yy82, &&yy82, &&yy82, &&yy82, &&yy82, &&yy82, &&yy82, &&yy82,
				&&yy80, &&yy82, &&yy82, &&yy82, &&yy82, &&yy82, &&yy82, &&yy82,
				&&yy82, &&yy82, &&yy82, &&yy82, &&yy82, &&yy82, &&yy82, &&yy82,
				&&yy82, &&yy82, &&yy82, &&yy82, &&yy82, &&yy82, &&yy82, &&yy82,
				&&yy82, &&yy82, &&yy82, &&yy82, &&yy82, &&yy82, &&yy82, &&yy82,
				&&yy82, &&yy83, &&yy84, &&yy82, &&yy85, &&yy82, &&yy86, &&yy82,
				&&yy82, &&yy87, &&yy82, &&yy82, &&yy82, &&yy82, &&yy82, &&yy88,
				&&yy82, &&yy82, &&yy89, &&yy90, &&yy82, &&yy91, &&yy82, &&yy82,
				&&yy82, &&yy82, &&yy82, &&yy82, &&yy82, &&yy82, &&yy82, &&yy82,
				&&yy82, &&yy83, &&yy84, &&yy82, &&yy85, &&yy82, &&yy86, &&yy82,
				&&yy82, &&yy87, &&yy82, &&yy82, &&yy82, &&yy82, &&yy82, &&yy88,
				&&yy82, &&yy82, &&yy89, &&yy90, &&yy82, &&yy91, &&yy82, &&yy82,
				&&yy82, &&yy82, &&yy82, &&yy82, &&yy82, &&yy82, &&yy82, &&yy82,
				&&yy82, &&yy82, &&yy82, &&yy82, &&yy82, &&yy82, &&yy82, &&yy82,
				&&yy82, &&yy82, &&yy82, &&yy82, &&yy82, &&yy82, &&yy82, &&yy82,
				&&yy82, &&yy82, &&yy82, &&yy82, &&yy82, &&yy82, &&yy82, &&yy82,
				&&yy82, &&yy82, &&yy82, &&yy82, &&yy82, &&yy82, &&yy82, &&yy82,
				&&yy82, &&yy82, &&yy82, &&yy82, &&yy82, &&yy82, &&yy82, &&yy82,
				&&yy82, &&yy82, &&yy82, &&yy82, &&yy82, &&yy82, &&yy82, &&yy82,
				&&yy82, &&yy82, &&yy82, &&yy82, &&yy82, &&yy82, &&yy82, &&yy82,
				&&yy82, &&yy82, &&yy82, &&yy82, &&yy82, &&yy82, &&yy82, &&yy82,
				&&yy82, &&yy82, &&yy82, &&yy82, &&yy82, &&yy82, &&yy82, &&yy82,
				&&yy82, &&yy82, &&yy82, &&yy82, &&yy82, &&yy82, &&yy82, &&yy82,
				&&yy82, &&yy82, &&yy82, &&yy82, &&yy82, &&yy82, &&yy82, &&yy82,
				&&yy82, &&yy82, &&yy82, &&yy82, &&yy82, &&yy82, &&yy82, &&yy82,
				&&yy82, &&yy82, &&yy82, &&yy82, &&yy82, &&yy82, &&yy82, &&yy82,
				&&yy82, &&yy82, &&yy82, &&yy82, &&yy82, &&yy82, &&yy82, &&yy82,
				&&yy82, &&yy82, &&yy82, &&yy82, &&yy82, &&yy82, &&yy82, &&yy82,
				&&yy82, &&yy82, &&yy82, &&yy82, &&yy82, &&yy82, &&yy82, &&yy82
			};
			goto *yytarget[yych];
		}
yy82:
		YYDEBUG(82, *YYCURSOR);
		YYCURSOR = YYMARKER;
		if (yyaccept <= 2) {
			if (yyaccept <= 1) {
				if (yyaccept == 0) {
					goto yy9;
				} else {
					goto yy27;
				}
			} else {
				goto yy36;
			}
		} else {
			if (yyaccept <= 4) {
				if (yyaccept == 3) {
					goto yy109;
				} else {
					goto yy113;
				}
			} else {
				goto yy122;
			}
		}
yy83:
		YYDEBUG(83, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'R') goto yy195;
		if (yych == 'r') goto yy195;
		goto yy82;
yy84:
		YYDEBUG(84, *YYCURSOR);
		yych = *++YYCURSOR;
		{
			static void *yytarget[256] = {
				&&yy82,  &&yy82,  &&yy82,  &&yy82,  &&yy82,  &&yy82,  &&yy82,  &&yy82,
				&&yy82,  &&yy82,  &&yy82,  &&yy82,  &&yy82,  &&yy82,  &&yy82,  &&yy82,
				&&yy82,  &&yy82,  &&yy82,  &&yy82,  &&yy82,  &&yy82,  &&yy82,  &&yy82,
				&&yy82,  &&yy82,  &&yy82,  &&yy82,  &&yy82,  &&yy82,  &&yy82,  &&yy82,
				&&yy82,  &&yy82,  &&yy82,  &&yy82,  &&yy82,  &&yy82,  &&yy82,  &&yy82,
				&&yy82,  &&yy82,  &&yy82,  &&yy82,  &&yy82,  &&yy82,  &&yy82,  &&yy82,
				&&yy82,  &&yy82,  &&yy82,  &&yy82,  &&yy82,  &&yy82,  &&yy82,  &&yy82,
				&&yy82,  &&yy82,  &&yy82,  &&yy82,  &&yy82,  &&yy82,  &&yy82,  &&yy82,
				&&yy82,  &&yy82,  &&yy82,  &&yy82,  &&yy82,  &&yy82,  &&yy82,  &&yy82,
				&&yy82,  &&yy196, &&yy82,  &&yy82,  &&yy82,  &&yy82,  &&yy82,  &&yy197,
				&&yy82,  &&yy82,  &&yy82,  &&yy82,  &&yy82,  &&yy82,  &&yy82,  &&yy82,
				&&yy82,  &&yy82,  &&yy82,  &&yy82,  &&yy82,  &&yy82,  &&yy82,  &&yy82,
				&&yy82,  &&yy82,  &&yy82,  &&yy82,  &&yy82,  &&yy82,  &&yy82,  &&yy82,
				&&yy82,  &&yy196, &&yy82,  &&yy82,  &&yy82,  &&yy82,  &&yy82,  &&yy197,
				&&yy82,  &&yy82,  &&yy82,  &&yy82,  &&yy82,  &&yy82,  &&yy82,  &&yy82,
				&&yy82,  &&yy82,  &&yy82,  &&yy82,  &&yy82,  &&yy82,  &&yy82,  &&yy82,
				&&yy82,  &&yy82,  &&yy82,  &&yy82,  &&yy82,  &&yy82,  &&yy82,  &&yy82,
				&&yy82,  &&yy82,  &&yy82,  &&yy82,  &&yy82,  &&yy82,  &&yy82,  &&yy82,
				&&yy82,  &&yy82,  &&yy82,  &&yy82,  &&yy82,  &&yy82,  &&yy82,  &&yy82,
				&&yy82,  &&yy82,  &&yy82,  &&yy82,  &&yy82,  &&yy82,  &&yy82,  &&yy82,
				&&yy82,  &&yy82,  &&yy82,  &&yy82,  &&yy82,  &&yy82,  &&yy82,  &&yy82,
				&&yy82,  &&yy82,  &&yy82,  &&yy82,  &&yy82,  &&yy82,  &&yy82,  &&yy82,
				&&yy82,  &&yy82,  &&yy82,  &&yy82,  &&yy82,  &&yy82,  &&yy82,  &&yy82,
				&&yy82,  &&yy82,  &&yy82,  &&yy82,  &&yy82,  &&yy82,  &&yy82,  &&yy82,
				&&yy82,  &&yy82,  &&yy82,  &&yy82,  &&yy82,  &&yy82,  &&yy82,  &&yy82,
				&&yy82,  &&yy82,  &&yy82,  &&yy82,  &&yy82,  &&yy82,  &&yy82,  &&yy82,
				&&yy82,  &&yy82,  &&yy82,  &&yy82,  &&yy82,  &&yy82,  &&yy82,  &&yy82,
				&&yy82,  &&yy82,  &&yy82,  &&yy82,  &&yy82,  &&yy82,  &&yy82,  &&yy82,
				&&yy82,  &&yy82,  &&yy82,  &&yy82,  &&yy82,  &&yy82,  &&yy82,  &&yy82,
				&&yy82,  &&yy82,  &&yy82,  &&yy82,  &&yy82,  &&yy82,  &&yy82,  &&yy82,
				&&yy82,  &&yy82,  &&yy82,  &&yy82,  &&yy82,  &&yy82,  &&yy82,  &&yy82,
				&&yy82,  &&yy82,  &&yy82,  &&yy82,  &&yy82,  &&yy82,  &&yy82,  &&yy82
			};
			goto *yytarget[yych];
		}
yy85:
		YYDEBUG(85, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'O') goto yy198;
		if (yych == 'o') goto yy198;
		goto yy82;
yy86:
		YYDEBUG(86, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'L') goto yy199;
		if (yych == 'l') goto yy199;
		goto yy82;
yy87:
		YYDEBUG(87, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'N') goto yy200;
		if (yych == 'n') goto yy200;
		goto yy82;
yy88:
		YYDEBUG(88, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'B') goto yy201;
		if (yych == 'b') goto yy201;
		goto yy82;
yy89:
		YYDEBUG(89, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy202;
		if (yych == 'e') goto yy202;
		goto yy82;
yy90:
		YYDEBUG(90, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'T') goto yy203;
		if (yych == 't') goto yy203;
		goto yy82;
yy91:
		YYDEBUG(91, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'N') goto yy204;
		if (yych == 'n') goto yy204;
		goto yy82;
yy92:
		YYDEBUG(92, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '=') goto yy205;
		YYDEBUG(93, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_POW;
}
yy94:
		YYDEBUG(94, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(95, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_MUL_EQUAL;
}
yy96:
		YYDEBUG(96, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(97, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_INC;
}
yy98:
		YYDEBUG(98, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(99, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_PLUS_EQUAL;
}
yy100:
		YYDEBUG(100, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(101, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_DEC;
}
yy102:
		YYDEBUG(102, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(103, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_MINUS_EQUAL;
}
yy104:
		YYDEBUG(104, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(105, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	yy_push_state(ST_LOOKING_FOR_PROPERTY);
	return T_OBJECT_OPERATOR;
}
yy106:
		YYDEBUG(106, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '.') goto yy207;
		goto yy82;
yy107:
		YYDEBUG(107, *YYCURSOR);
		yyaccept = 3;
		YYMARKER = ++YYCURSOR;
		YYFILL(3);
		yych = *YYCURSOR;
		YYDEBUG(108, *YYCURSOR);
		if (yych <= 'D') {
			if (yych <= '/') goto yy109;
			if (yych <= '9') goto yy107;
		} else {
			if (yych <= 'E') goto yy117;
			if (yych == 'e') goto yy117;
		}
yy109:
		YYDEBUG(109, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	const char *end;

	ZVAL_DOUBLE(zendlval, zend_strtod(yytext, &end));
	/* errno isn't checked since we allow HUGE_VAL/INF overflow */
	ZEND_ASSERT(end == yytext + yyleng);
	return T_DNUMBER;
}
yy110:
		YYDEBUG(110, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(111, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_CONCAT_EQUAL;
}
yy112:
		YYDEBUG(112, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == '*') goto yy209;
yy113:
		YYDEBUG(113, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	int doc_com;

	if (yyleng > 2) {
		doc_com = 1;
		RESET_DOC_COMMENT();
	} else {
		doc_com = 0;
	}

	while (YYCURSOR < YYLIMIT) {
		if (*YYCURSOR++ == '*' && *YYCURSOR == '/') {
			break;
		}
	}

	if (YYCURSOR < YYLIMIT) {
		YYCURSOR++;
	} else {
		zend_error(E_COMPILE_WARNING, "Unterminated comment starting line %d", CG(zend_lineno));
	}

	yyleng = YYCURSOR - SCNG(yy_text);
	HANDLE_NEWLINES(yytext, yyleng);

	if (doc_com) {
		CG(doc_comment) = zend_string_init(yytext, yyleng, 0);
		return T_DOC_COMMENT;
	}

	return T_COMMENT;
}
yy114:
		YYDEBUG(114, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(115, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_DIV_EQUAL;
}
yy116:
		YYDEBUG(116, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yybm[0+yych] & 64) {
			goto yy210;
		}
		goto yy82;
yy117:
		YYDEBUG(117, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= ',') {
			if (yych == '+') goto yy213;
			goto yy82;
		} else {
			if (yych <= '-') goto yy213;
			if (yych <= '/') goto yy82;
			if (yych <= '9') goto yy214;
			goto yy82;
		}
yy118:
		YYDEBUG(118, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yybm[0+yych] & 128) {
			goto yy216;
		}
		goto yy82;
yy119:
		YYDEBUG(119, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(120, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_PAAMAYIM_NEKUDOTAYIM;
}
yy121:
		YYDEBUG(121, *YYCURSOR);
		yyaccept = 5;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= ';') goto yy122;
		if (yych <= '<') goto yy219;
		if (yych <= '=') goto yy221;
yy122:
		YYDEBUG(122, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_SL;
}
yy123:
		YYDEBUG(123, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(124, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_IS_SMALLER_OR_EQUAL;
}
yy125:
		YYDEBUG(125, *YYCURSOR);
		++YYCURSOR;
		goto yy70;
yy126:
		YYDEBUG(126, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '=') goto yy223;
		YYDEBUG(127, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_IS_EQUAL;
}
yy128:
		YYDEBUG(128, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(129, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_DOUBLE_ARROW;
}
yy130:
		YYDEBUG(130, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(131, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_IS_GREATER_OR_EQUAL;
}
yy132:
		YYDEBUG(132, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '=') goto yy225;
		YYDEBUG(133, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_SR;
}
yy134:
		YYDEBUG(134, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '\n') goto yy227;
		if (yych == '\r') goto yy228;
yy135:
		YYDEBUG(135, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	BEGIN(INITIAL);
	return T_CLOSE_TAG;  /* implicit ';' at php-end tag */
}
yy136:
		YYDEBUG(136, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(137, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_COALESCE;
}
yy138:
		YYDEBUG(138, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'S') goto yy229;
		if (yych == 's') goto yy229;
		goto yy44;
yy139:
		YYDEBUG(139, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'D') goto yy230;
		if (yych == 'd') goto yy230;
		goto yy44;
yy140:
		YYDEBUG(140, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'R') goto yy232;
		if (yych == 'r') goto yy232;
		goto yy44;
yy141:
		YYDEBUG(141, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yybm[0+yych] & 16) {
			goto yy43;
		}
		YYDEBUG(142, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_AS;
}
yy143:
		YYDEBUG(143, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '<') goto yy233;
		goto yy82;
yy144:
		YYDEBUG(144, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy234;
		if (yych == 'e') goto yy234;
		goto yy44;
yy145:
		YYDEBUG(145, *YYCURSOR);
		yych = *++YYCURSOR;
		{
			static void *yytarget[256] = {
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy235, &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy236, &&yy237, &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy235, &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy236, &&yy237, &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44
			};
			goto *yytarget[yych];
		}
yy146:
		YYDEBUG(146, *YYCURSOR);
		yych = *++YYCURSOR;
		{
			static void *yytarget[256] = {
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy238, &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy239,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy238, &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy239,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44
			};
			goto *yytarget[yych];
		}
yy147:
		YYDEBUG(147, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'N') goto yy240;
		if (yych == 'n') goto yy240;
		goto yy44;
yy148:
		YYDEBUG(148, *YYCURSOR);
		yych = *++YYCURSOR;
		{
			static void *yytarget[256] = {
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy241, &&yy44,  &&yy44,  &&yy242, &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy241, &&yy44,  &&yy44,  &&yy242, &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44
			};
			goto *yytarget[yych];
		}
yy149:
		YYDEBUG(149, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy243;
		if (yych == 'e') goto yy243;
		goto yy44;
yy150:
		YYDEBUG(150, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yybm[0+yych] & 16) {
			goto yy43;
		}
		YYDEBUG(151, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_DO;
}
yy152:
		YYDEBUG(152, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'H') goto yy245;
		if (yych == 'h') goto yy245;
		goto yy44;
yy153:
		YYDEBUG(153, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'S') goto yy246;
		if (yych == 's') goto yy246;
		goto yy44;
yy154:
		YYDEBUG(154, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'P') goto yy247;
		if (yych == 'p') goto yy247;
		goto yy44;
yy155:
		YYDEBUG(155, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'D') goto yy248;
		if (yych == 'd') goto yy248;
		goto yy44;
yy156:
		YYDEBUG(156, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'A') goto yy249;
		if (yych == 'a') goto yy249;
		goto yy44;
yy157:
		YYDEBUG(157, *YYCURSOR);
		yych = *++YYCURSOR;
		{
			static void *yytarget[256] = {
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy250, &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy251, &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy250, &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy251, &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44
			};
			goto *yytarget[yych];
		}
yy158:
		YYDEBUG(158, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'N') goto yy252;
		if (yych == 'n') goto yy252;
		goto yy44;
yy159:
		YYDEBUG(159, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'R') goto yy253;
		if (yych == 'r') goto yy253;
		goto yy44;
yy160:
		YYDEBUG(160, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'N') goto yy255;
		if (yych == 'n') goto yy255;
		goto yy44;
yy161:
		YYDEBUG(161, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'O') goto yy256;
		if (yych == 'o') goto yy256;
		goto yy44;
yy162:
		YYDEBUG(162, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'T') goto yy257;
		if (yych == 't') goto yy257;
		goto yy44;
yy163:
		YYDEBUG(163, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yybm[0+yych] & 16) {
			goto yy43;
		}
		YYDEBUG(164, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_IF;
}
yy165:
		YYDEBUG(165, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'P') goto yy258;
		if (yych == 'p') goto yy258;
		goto yy44;
yy166:
		YYDEBUG(166, *YYCURSOR);
		yych = *++YYCURSOR;
		{
			static void *yytarget[256] = {
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy259, &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy260, &&yy261, &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy259, &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy260, &&yy261, &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44
			};
			goto *yytarget[yych];
		}
yy167:
		YYDEBUG(167, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'S') goto yy262;
		if (yych == 's') goto yy262;
		goto yy44;
yy168:
		YYDEBUG(168, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'S') goto yy263;
		if (yych == 's') goto yy263;
		goto yy44;
yy169:
		YYDEBUG(169, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'M') goto yy264;
		if (yych == 'm') goto yy264;
		goto yy44;
yy170:
		YYDEBUG(170, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'W') goto yy265;
		if (yych == 'w') goto yy265;
		goto yy44;
yy171:
		YYDEBUG(171, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yybm[0+yych] & 16) {
			goto yy43;
		}
		YYDEBUG(172, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_LOGICAL_OR;
}
yy173:
		YYDEBUG(173, *YYCURSOR);
		yych = *++YYCURSOR;
		{
			static void *yytarget[256] = {
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy267, &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy268,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy267, &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy268,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44
			};
			goto *yytarget[yych];
		}
yy174:
		YYDEBUG(174, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'B') goto yy269;
		if (yych == 'b') goto yy269;
		goto yy44;
yy175:
		YYDEBUG(175, *YYCURSOR);
		yych = *++YYCURSOR;
		{
			static void *yytarget[256] = {
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy270, &&yy44,  &&yy44,  &&yy271, &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy270, &&yy44,  &&yy44,  &&yy271, &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44
			};
			goto *yytarget[yych];
		}
yy176:
		YYDEBUG(176, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'A') goto yy272;
		if (yych == 'a') goto yy272;
		goto yy44;
yy177:
		YYDEBUG(177, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'I') goto yy273;
		if (yych == 'i') goto yy273;
		goto yy44;
yy178:
		YYDEBUG(178, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'R') goto yy274;
		if (yych == 'r') goto yy274;
		goto yy44;
yy179:
		YYDEBUG(179, *YYCURSOR);
		yych = *++YYCURSOR;
		{
			static void *yytarget[256] = {
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy275, &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy276, &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy275, &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy276, &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44
			};
			goto *yytarget[yych];
		}
yy180:
		YYDEBUG(180, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'S') goto yy278;
		if (yych == 's') goto yy278;
		goto yy44;
yy181:
		YYDEBUG(181, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy279;
		if (yych == 'e') goto yy279;
		goto yy44;
yy182:
		YYDEBUG(182, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'R') goto yy281;
		if (yych == 'r') goto yy281;
		goto yy44;
yy183:
		YYDEBUG(183, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'I') goto yy283;
		if (yych == 'i') goto yy283;
		goto yy44;
yy184:
		YYDEBUG(184, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'R') goto yy284;
		if (yych == 'r') goto yy284;
		goto yy44;
yy185:
		YYDEBUG(185, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy286;
		if (yych == 'e') goto yy286;
		goto yy44;
yy186:
		YYDEBUG(186, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(187, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_XOR_EQUAL;
}
yy188:
		YYDEBUG(188, *YYCURSOR);
		yych = *++YYCURSOR;
		{
			static void *yytarget[256] = {
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy287, &&yy288, &&yy44,  &&yy289, &&yy44,
				&&yy290, &&yy44,  &&yy44,  &&yy44,  &&yy291, &&yy292, &&yy293, &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy294, &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy287, &&yy288, &&yy44,  &&yy289, &&yy44,
				&&yy290, &&yy44,  &&yy44,  &&yy44,  &&yy291, &&yy292, &&yy293, &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy294, &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44
			};
			goto *yytarget[yych];
		}
yy189:
		YYDEBUG(189, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(190, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_OR_EQUAL;
}
yy191:
		YYDEBUG(191, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(192, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_BOOLEAN_OR;
}
yy193:
		YYDEBUG(193, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(194, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_IS_NOT_IDENTICAL;
}
yy195:
		YYDEBUG(195, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'R') goto yy295;
		if (yych == 'r') goto yy295;
		goto yy82;
yy196:
		YYDEBUG(196, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'N') goto yy296;
		if (yych == 'n') goto yy296;
		goto yy82;
yy197:
		YYDEBUG(197, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'O') goto yy297;
		if (yych == 'o') goto yy297;
		goto yy82;
yy198:
		YYDEBUG(198, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'U') goto yy298;
		if (yych == 'u') goto yy298;
		goto yy82;
yy199:
		YYDEBUG(199, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'O') goto yy299;
		if (yych == 'o') goto yy299;
		goto yy82;
yy200:
		YYDEBUG(200, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'T') goto yy300;
		if (yych == 't') goto yy300;
		goto yy82;
yy201:
		YYDEBUG(201, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'J') goto yy301;
		if (yych == 'j') goto yy301;
		goto yy82;
yy202:
		YYDEBUG(202, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'A') goto yy302;
		if (yych == 'a') goto yy302;
		goto yy82;
yy203:
		YYDEBUG(203, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'R') goto yy303;
		if (yych == 'r') goto yy303;
		goto yy82;
yy204:
		YYDEBUG(204, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'S') goto yy304;
		if (yych == 's') goto yy304;
		goto yy82;
yy205:
		YYDEBUG(205, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(206, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_POW_EQUAL;
}
yy207:
		YYDEBUG(207, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(208, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_ELLIPSIS;
}
yy209:
		YYDEBUG(209, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= '\f') {
			if (yych <= 0x08) goto yy82;
			if (yych <= '\n') goto yy305;
			goto yy82;
		} else {
			if (yych <= '\r') goto yy305;
			if (yych == ' ') goto yy305;
			goto yy82;
		}
yy210:
		YYDEBUG(210, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(211, *YYCURSOR);
		if (yybm[0+yych] & 64) {
			goto yy210;
		}
		YYDEBUG(212, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	char *bin = yytext + 2; /* Skip "0b" */
	int len = yyleng - 2;
	char *end;

	/* Skip any leading 0s */
	while (*bin == '0') {
		++bin;
		--len;
	}

	if (len < SIZEOF_ZEND_LONG * 8) {
		if (len == 0) {
			ZVAL_LONG(zendlval, 0);
		} else {
			errno = 0;
			ZVAL_LONG(zendlval, ZEND_STRTOL(bin, &end, 2));
			ZEND_ASSERT(!errno && end == yytext + yyleng);
		}
		return T_LNUMBER;
	} else {
		ZVAL_DOUBLE(zendlval, zend_bin_strtod(bin, (const char **)&end));
		/* errno isn't checked since we allow HUGE_VAL/INF overflow */
		ZEND_ASSERT(end == yytext + yyleng);
		return T_DNUMBER;
	}
}
yy213:
		YYDEBUG(213, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= '/') goto yy82;
		if (yych >= ':') goto yy82;
yy214:
		YYDEBUG(214, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(215, *YYCURSOR);
		if (yych <= '/') goto yy109;
		if (yych <= '9') goto yy214;
		goto yy109;
yy216:
		YYDEBUG(216, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(217, *YYCURSOR);
		if (yybm[0+yych] & 128) {
			goto yy216;
		}
		YYDEBUG(218, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	char *hex = yytext + 2; /* Skip "0x" */
	int len = yyleng - 2;
	char *end;

	/* Skip any leading 0s */
	while (*hex == '0') {
		hex++;
		len--;
	}

	if (len < SIZEOF_ZEND_LONG * 2 || (len == SIZEOF_ZEND_LONG * 2 && *hex <= '7')) {
		if (len == 0) {
			ZVAL_LONG(zendlval, 0);
		} else {
			errno = 0;
			ZVAL_LONG(zendlval, ZEND_STRTOL(hex, &end, 16));
			ZEND_ASSERT(!errno && end == hex + len);
		}
		return T_LNUMBER;
	} else {
		ZVAL_DOUBLE(zendlval, zend_hex_strtod(hex, (const char **)&end));
		/* errno isn't checked since we allow HUGE_VAL/INF overflow */
		ZEND_ASSERT(end == hex + len);
		return T_DNUMBER;
	}
}
yy219:
		YYDEBUG(219, *YYCURSOR);
		++YYCURSOR;
		YYFILL(2);
		yych = *YYCURSOR;
		YYDEBUG(220, *YYCURSOR);
		{
			static void *yytarget[256] = {
				&&yy82,  &&yy82,  &&yy82,  &&yy82,  &&yy82,  &&yy82,  &&yy82,  &&yy82,
				&&yy82,  &&yy219, &&yy82,  &&yy82,  &&yy82,  &&yy82,  &&yy82,  &&yy82,
				&&yy82,  &&yy82,  &&yy82,  &&yy82,  &&yy82,  &&yy82,  &&yy82,  &&yy82,
				&&yy82,  &&yy82,  &&yy82,  &&yy82,  &&yy82,  &&yy82,  &&yy82,  &&yy82,
				&&yy219, &&yy82,  &&yy307, &&yy82,  &&yy82,  &&yy82,  &&yy82,  &&yy308,
				&&yy82,  &&yy82,  &&yy82,  &&yy82,  &&yy82,  &&yy82,  &&yy82,  &&yy82,
				&&yy82,  &&yy82,  &&yy82,  &&yy82,  &&yy82,  &&yy82,  &&yy82,  &&yy82,
				&&yy82,  &&yy82,  &&yy82,  &&yy82,  &&yy82,  &&yy82,  &&yy82,  &&yy82,
				&&yy82,  &&yy309, &&yy309, &&yy309, &&yy309, &&yy309, &&yy309, &&yy309,
				&&yy309, &&yy309, &&yy309, &&yy309, &&yy309, &&yy309, &&yy309, &&yy309,
				&&yy309, &&yy309, &&yy309, &&yy309, &&yy309, &&yy309, &&yy309, &&yy309,
				&&yy309, &&yy309, &&yy309, &&yy82,  &&yy82,  &&yy82,  &&yy82,  &&yy309,
				&&yy82,  &&yy309, &&yy309, &&yy309, &&yy309, &&yy309, &&yy309, &&yy309,
				&&yy309, &&yy309, &&yy309, &&yy309, &&yy309, &&yy309, &&yy309, &&yy309,
				&&yy309, &&yy309, &&yy309, &&yy309, &&yy309, &&yy309, &&yy309, &&yy309,
				&&yy309, &&yy309, &&yy309, &&yy82,  &&yy82,  &&yy82,  &&yy82,  &&yy309,
				&&yy309, &&yy309, &&yy309, &&yy309, &&yy309, &&yy309, &&yy309, &&yy309,
				&&yy309, &&yy309, &&yy309, &&yy309, &&yy309, &&yy309, &&yy309, &&yy309,
				&&yy309, &&yy309, &&yy309, &&yy309, &&yy309, &&yy309, &&yy309, &&yy309,
				&&yy309, &&yy309, &&yy309, &&yy309, &&yy309, &&yy309, &&yy309, &&yy309,
				&&yy309, &&yy309, &&yy309, &&yy309, &&yy309, &&yy309, &&yy309, &&yy309,
				&&yy309, &&yy309, &&yy309, &&yy309, &&yy309, &&yy309, &&yy309, &&yy309,
				&&yy309, &&yy309, &&yy309, &&yy309, &&yy309, &&yy309, &&yy309, &&yy309,
				&&yy309, &&yy309, &&yy309, &&yy309, &&yy309, &&yy309, &&yy309, &&yy309,
				&&yy309, &&yy309, &&yy309, &&yy309, &&yy309, &&yy309, &&yy309, &&yy309,
				&&yy309, &&yy309, &&yy309, &&yy309, &&yy309, &&yy309, &&yy309, &&yy309,
				&&yy309, &&yy309, &&yy309, &&yy309, &&yy309, &&yy309, &&yy309, &&yy309,
				&&yy309, &&yy309, &&yy309, &&yy309, &&yy309, &&yy309, &&yy309, &&yy309,
				&&yy309, &&yy309, &&yy309, &&yy309, &&yy309, &&yy309, &&yy309, &&yy309,
				&&yy309, &&yy309, &&yy309, &&yy309, &&yy309, &&yy309, &&yy309, &&yy309,
				&&yy309, &&yy309, &&yy309, &&yy309, &&yy309, &&yy309, &&yy309, &&yy309,
				&&yy309, &&yy309, &&yy309, &&yy309, &&yy309, &&yy309, &&yy309, &&yy309
			};
			goto *yytarget[yych];
		}
yy221:
		YYDEBUG(221, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(222, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_SL_EQUAL;
}
yy223:
		YYDEBUG(223, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(224, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_IS_IDENTICAL;
}
yy225:
		YYDEBUG(225, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(226, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_SR_EQUAL;
}
yy227:
		YYDEBUG(227, *YYCURSOR);
		++YYCURSOR;
		goto yy135;
yy228:
		YYDEBUG(228, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '\n') goto yy227;
		goto yy135;
yy229:
		YYDEBUG(229, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'T') goto yy311;
		if (yych == 't') goto yy311;
		goto yy44;
yy230:
		YYDEBUG(230, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yybm[0+yych] & 16) {
			goto yy43;
		}
		YYDEBUG(231, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_LOGICAL_AND;
}
yy232:
		YYDEBUG(232, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'A') goto yy312;
		if (yych == 'a') goto yy312;
		goto yy44;
yy233:
		YYDEBUG(233, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '<') goto yy219;
		goto yy82;
yy234:
		YYDEBUG(234, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'A') goto yy313;
		if (yych == 'a') goto yy313;
		goto yy44;
yy235:
		YYDEBUG(235, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'L') goto yy314;
		if (yych == 'l') goto yy314;
		goto yy44;
yy236:
		YYDEBUG(236, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy315;
		if (yych == 'e') goto yy315;
		goto yy44;
yy237:
		YYDEBUG(237, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'C') goto yy317;
		if (yych == 'c') goto yy317;
		goto yy44;
yy238:
		YYDEBUG(238, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'S') goto yy318;
		if (yych == 's') goto yy318;
		goto yy44;
yy239:
		YYDEBUG(239, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'N') goto yy319;
		if (yych == 'n') goto yy319;
		goto yy44;
yy240:
		YYDEBUG(240, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= 'T') {
			if (yych <= 'R') goto yy44;
			if (yych <= 'S') goto yy320;
			goto yy321;
		} else {
			if (yych <= 'r') goto yy44;
			if (yych <= 's') goto yy320;
			if (yych <= 't') goto yy321;
			goto yy44;
		}
yy241:
		YYDEBUG(241, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'L') goto yy322;
		if (yych == 'l') goto yy322;
		goto yy44;
yy242:
		YYDEBUG(242, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'A') goto yy323;
		if (yych == 'a') goto yy323;
		goto yy44;
yy243:
		YYDEBUG(243, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yybm[0+yych] & 16) {
			goto yy43;
		}
		YYDEBUG(244, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_EXIT;
}
yy245:
		YYDEBUG(245, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'O') goto yy324;
		if (yych == 'o') goto yy324;
		goto yy44;
yy246:
		YYDEBUG(246, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy326;
		if (yych == 'e') goto yy326;
		goto yy44;
yy247:
		YYDEBUG(247, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'T') goto yy328;
		if (yych == 't') goto yy328;
		goto yy44;
yy248:
		YYDEBUG(248, *YYCURSOR);
		yych = *++YYCURSOR;
		{
			static void *yytarget[256] = {
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy329, &&yy44,  &&yy330, &&yy44,
				&&yy44,  &&yy331, &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy332, &&yy44,  &&yy44,  &&yy44,  &&yy333,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy329, &&yy44,  &&yy330, &&yy44,
				&&yy44,  &&yy331, &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy332, &&yy44,  &&yy44,  &&yy44,  &&yy333,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44
			};
			goto *yytarget[yych];
		}
yy249:
		YYDEBUG(249, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'L') goto yy334;
		if (yych == 'l') goto yy334;
		goto yy44;
yy250:
		YYDEBUG(250, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'T') goto yy336;
		if (yych == 't') goto yy336;
		goto yy44;
yy251:
		YYDEBUG(251, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy338;
		if (yych == 'e') goto yy338;
		goto yy44;
yy252:
		YYDEBUG(252, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'A') goto yy339;
		if (yych == 'a') goto yy339;
		goto yy44;
yy253:
		YYDEBUG(253, *YYCURSOR);
		yych = *++YYCURSOR;
		{
			static void *yytarget[256] = {
				&&yy254, &&yy254, &&yy254, &&yy254, &&yy254, &&yy254, &&yy254, &&yy254,
				&&yy254, &&yy254, &&yy254, &&yy254, &&yy254, &&yy254, &&yy254, &&yy254,
				&&yy254, &&yy254, &&yy254, &&yy254, &&yy254, &&yy254, &&yy254, &&yy254,
				&&yy254, &&yy254, &&yy254, &&yy254, &&yy254, &&yy254, &&yy254, &&yy254,
				&&yy254, &&yy254, &&yy254, &&yy254, &&yy254, &&yy254, &&yy254, &&yy254,
				&&yy254, &&yy254, &&yy254, &&yy254, &&yy254, &&yy254, &&yy254, &&yy254,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy254, &&yy254, &&yy254, &&yy254, &&yy254, &&yy254,
				&&yy254, &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy340, &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy254, &&yy254, &&yy254, &&yy254, &&yy43,
				&&yy254, &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy340, &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy254, &&yy254, &&yy254, &&yy254, &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43
			};
			goto *yytarget[yych];
		}
yy254:
		YYDEBUG(254, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_FOR;
}
yy255:
		YYDEBUG(255, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'C') goto yy341;
		if (yych == 'c') goto yy341;
		goto yy44;
yy256:
		YYDEBUG(256, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'B') goto yy342;
		if (yych == 'b') goto yy342;
		goto yy44;
yy257:
		YYDEBUG(257, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'O') goto yy343;
		if (yych == 'o') goto yy343;
		goto yy44;
yy258:
		YYDEBUG(258, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'L') goto yy345;
		if (yych == 'l') goto yy345;
		goto yy44;
yy259:
		YYDEBUG(259, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'L') goto yy346;
		if (yych == 'l') goto yy346;
		goto yy44;
yy260:
		YYDEBUG(260, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'T') goto yy347;
		if (yych == 't') goto yy347;
		goto yy44;
yy261:
		YYDEBUG(261, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy348;
		if (yych == 'e') goto yy348;
		goto yy44;
yy262:
		YYDEBUG(262, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy349;
		if (yych == 'e') goto yy349;
		goto yy44;
yy263:
		YYDEBUG(263, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'T') goto yy350;
		if (yych == 't') goto yy350;
		goto yy44;
yy264:
		YYDEBUG(264, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy352;
		if (yych == 'e') goto yy352;
		goto yy44;
yy265:
		YYDEBUG(265, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yybm[0+yych] & 16) {
			goto yy43;
		}
		YYDEBUG(266, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_NEW;
}
yy267:
		YYDEBUG(267, *YYCURSOR);
		yych = *++YYCURSOR;
		{
			static void *yytarget[256] = {
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy353, &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy354, &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy353, &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy354, &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44
			};
			goto *yytarget[yych];
		}
yy268:
		YYDEBUG(268, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'T') goto yy355;
		if (yych == 't') goto yy355;
		goto yy44;
yy269:
		YYDEBUG(269, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'L') goto yy356;
		if (yych == 'l') goto yy356;
		goto yy44;
yy270:
		YYDEBUG(270, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'U') goto yy357;
		if (yych == 'u') goto yy357;
		goto yy44;
yy271:
		YYDEBUG(271, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'U') goto yy358;
		if (yych == 'u') goto yy358;
		goto yy44;
yy272:
		YYDEBUG(272, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'T') goto yy359;
		if (yych == 't') goto yy359;
		goto yy44;
yy273:
		YYDEBUG(273, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'T') goto yy360;
		if (yych == 't') goto yy360;
		goto yy44;
yy274:
		YYDEBUG(274, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'O') goto yy361;
		if (yych == 'o') goto yy361;
		goto yy44;
yy275:
		YYDEBUG(275, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'I') goto yy362;
		if (yych == 'i') goto yy362;
		goto yy44;
yy276:
		YYDEBUG(276, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yybm[0+yych] & 16) {
			goto yy43;
		}
		YYDEBUG(277, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_TRY;
}
yy278:
		YYDEBUG(278, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy363;
		if (yych == 'e') goto yy363;
		goto yy44;
yy279:
		YYDEBUG(279, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yybm[0+yych] & 16) {
			goto yy43;
		}
		YYDEBUG(280, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_USE;
}
yy281:
		YYDEBUG(281, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yybm[0+yych] & 16) {
			goto yy43;
		}
		YYDEBUG(282, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_VAR;
}
yy283:
		YYDEBUG(283, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'L') goto yy364;
		if (yych == 'l') goto yy364;
		goto yy44;
yy284:
		YYDEBUG(284, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yybm[0+yych] & 16) {
			goto yy43;
		}
		YYDEBUG(285, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_LOGICAL_XOR;
}
yy286:
		YYDEBUG(286, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'L') goto yy365;
		if (yych == 'l') goto yy365;
		goto yy44;
yy287:
		YYDEBUG(287, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'L') goto yy366;
		if (yych == 'l') goto yy366;
		goto yy44;
yy288:
		YYDEBUG(288, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'I') goto yy367;
		if (yych == 'i') goto yy367;
		goto yy44;
yy289:
		YYDEBUG(289, *YYCURSOR);
		yych = *++YYCURSOR;
		{
			static void *yytarget[256] = {
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy368, &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy369, &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy368, &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy369, &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44
			};
			goto *yytarget[yych];
		}
yy290:
		YYDEBUG(290, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'A') goto yy370;
		if (yych == 'a') goto yy370;
		goto yy44;
yy291:
		YYDEBUG(291, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'I') goto yy371;
		if (yych == 'i') goto yy371;
		goto yy44;
yy292:
		YYDEBUG(292, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy372;
		if (yych == 'e') goto yy372;
		goto yy44;
yy293:
		YYDEBUG(293, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'A') goto yy373;
		if (yych == 'a') goto yy373;
		goto yy44;
yy294:
		YYDEBUG(294, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'R') goto yy374;
		if (yych == 'r') goto yy374;
		goto yy44;
yy295:
		YYDEBUG(295, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'A') goto yy375;
		if (yych == 'a') goto yy375;
		goto yy82;
yy296:
		YYDEBUG(296, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'A') goto yy376;
		if (yych == 'a') goto yy376;
		goto yy82;
yy297:
		YYDEBUG(297, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'L') goto yy377;
		if (yych == 'l') goto yy377;
		goto yy82;
yy298:
		YYDEBUG(298, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'B') goto yy378;
		if (yych == 'b') goto yy378;
		goto yy82;
yy299:
		YYDEBUG(299, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'A') goto yy379;
		if (yych == 'a') goto yy379;
		goto yy82;
yy300:
		YYDEBUG(300, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy384;
		if (yych == 'e') goto yy384;
		goto yy381;
yy301:
		YYDEBUG(301, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy385;
		if (yych == 'e') goto yy385;
		goto yy82;
yy302:
		YYDEBUG(302, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'L') goto yy386;
		if (yych == 'l') goto yy386;
		goto yy82;
yy303:
		YYDEBUG(303, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'I') goto yy388;
		if (yych == 'i') goto yy388;
		goto yy82;
yy304:
		YYDEBUG(304, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy389;
		if (yych == 'e') goto yy389;
		goto yy82;
yy305:
		YYDEBUG(305, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(306, *YYCURSOR);
		if (yych <= '\f') {
			if (yych <= 0x08) goto yy113;
			if (yych <= '\n') goto yy305;
			goto yy113;
		} else {
			if (yych <= '\r') goto yy305;
			if (yych == ' ') goto yy305;
			goto yy113;
		}
yy307:
		YYDEBUG(307, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '"') goto yy82;
		if (yych <= '/') goto yy391;
		if (yych <= '9') goto yy82;
		goto yy391;
yy308:
		YYDEBUG(308, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '\'') goto yy82;
		if (yych <= '/') goto yy393;
		if (yych <= '9') goto yy82;
		goto yy393;
yy309:
		YYDEBUG(309, *YYCURSOR);
		++YYCURSOR;
		YYFILL(2);
		yych = *YYCURSOR;
		YYDEBUG(310, *YYCURSOR);
		{
			static void *yytarget[256] = {
				&&yy82,  &&yy82,  &&yy82,  &&yy82,  &&yy82,  &&yy82,  &&yy82,  &&yy82,
				&&yy82,  &&yy82,  &&yy394, &&yy82,  &&yy82,  &&yy396, &&yy82,  &&yy82,
				&&yy82,  &&yy82,  &&yy82,  &&yy82,  &&yy82,  &&yy82,  &&yy82,  &&yy82,
				&&yy82,  &&yy82,  &&yy82,  &&yy82,  &&yy82,  &&yy82,  &&yy82,  &&yy82,
				&&yy82,  &&yy82,  &&yy82,  &&yy82,  &&yy82,  &&yy82,  &&yy82,  &&yy82,
				&&yy82,  &&yy82,  &&yy82,  &&yy82,  &&yy82,  &&yy82,  &&yy82,  &&yy82,
				&&yy309, &&yy309, &&yy309, &&yy309, &&yy309, &&yy309, &&yy309, &&yy309,
				&&yy309, &&yy309, &&yy82,  &&yy82,  &&yy82,  &&yy82,  &&yy82,  &&yy82,
				&&yy82,  &&yy309, &&yy309, &&yy309, &&yy309, &&yy309, &&yy309, &&yy309,
				&&yy309, &&yy309, &&yy309, &&yy309, &&yy309, &&yy309, &&yy309, &&yy309,
				&&yy309, &&yy309, &&yy309, &&yy309, &&yy309, &&yy309, &&yy309, &&yy309,
				&&yy309, &&yy309, &&yy309, &&yy82,  &&yy82,  &&yy82,  &&yy82,  &&yy309,
				&&yy82,  &&yy309, &&yy309, &&yy309, &&yy309, &&yy309, &&yy309, &&yy309,
				&&yy309, &&yy309, &&yy309, &&yy309, &&yy309, &&yy309, &&yy309, &&yy309,
				&&yy309, &&yy309, &&yy309, &&yy309, &&yy309, &&yy309, &&yy309, &&yy309,
				&&yy309, &&yy309, &&yy309, &&yy82,  &&yy82,  &&yy82,  &&yy82,  &&yy309,
				&&yy309, &&yy309, &&yy309, &&yy309, &&yy309, &&yy309, &&yy309, &&yy309,
				&&yy309, &&yy309, &&yy309, &&yy309, &&yy309, &&yy309, &&yy309, &&yy309,
				&&yy309, &&yy309, &&yy309, &&yy309, &&yy309, &&yy309, &&yy309, &&yy309,
				&&yy309, &&yy309, &&yy309, &&yy309, &&yy309, &&yy309, &&yy309, &&yy309,
				&&yy309, &&yy309, &&yy309, &&yy309, &&yy309, &&yy309, &&yy309, &&yy309,
				&&yy309, &&yy309, &&yy309, &&yy309, &&yy309, &&yy309, &&yy309, &&yy309,
				&&yy309, &&yy309, &&yy309, &&yy309, &&yy309, &&yy309, &&yy309, &&yy309,
				&&yy309, &&yy309, &&yy309, &&yy309, &&yy309, &&yy309, &&yy309, &&yy309,
				&&yy309, &&yy309, &&yy309, &&yy309, &&yy309, &&yy309, &&yy309, &&yy309,
				&&yy309, &&yy309, &&yy309, &&yy309, &&yy309, &&yy309, &&yy309, &&yy309,
				&&yy309, &&yy309, &&yy309, &&yy309, &&yy309, &&yy309, &&yy309, &&yy309,
				&&yy309, &&yy309, &&yy309, &&yy309, &&yy309, &&yy309, &&yy309, &&yy309,
				&&yy309, &&yy309, &&yy309, &&yy309, &&yy309, &&yy309, &&yy309, &&yy309,
				&&yy309, &&yy309, &&yy309, &&yy309, &&yy309, &&yy309, &&yy309, &&yy309,
				&&yy309, &&yy309, &&yy309, &&yy309, &&yy309, &&yy309, &&yy309, &&yy309,
				&&yy309, &&yy309, &&yy309, &&yy309, &&yy309, &&yy309, &&yy309, &&yy309
			};
			goto *yytarget[yych];
		}
yy311:
		YYDEBUG(311, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'R') goto yy397;
		if (yych == 'r') goto yy397;
		goto yy44;
yy312:
		YYDEBUG(312, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'Y') goto yy398;
		if (yych == 'y') goto yy398;
		goto yy44;
yy313:
		YYDEBUG(313, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'K') goto yy400;
		if (yych == 'k') goto yy400;
		goto yy44;
yy314:
		YYDEBUG(314, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'A') goto yy402;
		if (yych == 'a') goto yy402;
		goto yy44;
yy315:
		YYDEBUG(315, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yybm[0+yych] & 16) {
			goto yy43;
		}
		YYDEBUG(316, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_CASE;
}
yy317:
		YYDEBUG(317, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'H') goto yy403;
		if (yych == 'h') goto yy403;
		goto yy44;
yy318:
		YYDEBUG(318, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'S') goto yy405;
		if (yych == 's') goto yy405;
		goto yy44;
yy319:
		YYDEBUG(319, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy407;
		if (yych == 'e') goto yy407;
		goto yy44;
yy320:
		YYDEBUG(320, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'T') goto yy409;
		if (yych == 't') goto yy409;
		goto yy44;
yy321:
		YYDEBUG(321, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'I') goto yy411;
		if (yych == 'i') goto yy411;
		goto yy44;
yy322:
		YYDEBUG(322, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'A') goto yy412;
		if (yych == 'a') goto yy412;
		goto yy44;
yy323:
		YYDEBUG(323, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'U') goto yy413;
		if (yych == 'u') goto yy413;
		goto yy44;
yy324:
		YYDEBUG(324, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yybm[0+yych] & 16) {
			goto yy43;
		}
		YYDEBUG(325, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_ECHO;
}
yy326:
		YYDEBUG(326, *YYCURSOR);
		yych = *++YYCURSOR;
		{
			static void *yytarget[256] = {
				&&yy327, &&yy327, &&yy327, &&yy327, &&yy327, &&yy327, &&yy327, &&yy327,
				&&yy327, &&yy327, &&yy327, &&yy327, &&yy327, &&yy327, &&yy327, &&yy327,
				&&yy327, &&yy327, &&yy327, &&yy327, &&yy327, &&yy327, &&yy327, &&yy327,
				&&yy327, &&yy327, &&yy327, &&yy327, &&yy327, &&yy327, &&yy327, &&yy327,
				&&yy327, &&yy327, &&yy327, &&yy327, &&yy327, &&yy327, &&yy327, &&yy327,
				&&yy327, &&yy327, &&yy327, &&yy327, &&yy327, &&yy327, &&yy327, &&yy327,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy327, &&yy327, &&yy327, &&yy327, &&yy327, &&yy327,
				&&yy327, &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy414, &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy327, &&yy327, &&yy327, &&yy327, &&yy43,
				&&yy327, &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy414, &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy327, &&yy327, &&yy327, &&yy327, &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43
			};
			goto *yytarget[yych];
		}
yy327:
		YYDEBUG(327, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_ELSE;
}
yy328:
		YYDEBUG(328, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'Y') goto yy415;
		if (yych == 'y') goto yy415;
		goto yy44;
yy329:
		YYDEBUG(329, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy417;
		if (yych == 'e') goto yy417;
		goto yy44;
yy330:
		YYDEBUG(330, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'O') goto yy418;
		if (yych == 'o') goto yy418;
		goto yy44;
yy331:
		YYDEBUG(331, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'F') goto yy419;
		if (yych == 'f') goto yy419;
		goto yy44;
yy332:
		YYDEBUG(332, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'W') goto yy421;
		if (yych == 'w') goto yy421;
		goto yy44;
yy333:
		YYDEBUG(333, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'H') goto yy422;
		if (yych == 'h') goto yy422;
		goto yy44;
yy334:
		YYDEBUG(334, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yybm[0+yych] & 16) {
			goto yy43;
		}
		YYDEBUG(335, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_EVAL;
}
yy336:
		YYDEBUG(336, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yybm[0+yych] & 16) {
			goto yy43;
		}
		YYDEBUG(337, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_EXIT;
}
yy338:
		YYDEBUG(338, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'N') goto yy423;
		if (yych == 'n') goto yy423;
		goto yy44;
yy339:
		YYDEBUG(339, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'L') goto yy424;
		if (yych == 'l') goto yy424;
		goto yy44;
yy340:
		YYDEBUG(340, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'A') goto yy426;
		if (yych == 'a') goto yy426;
		goto yy44;
yy341:
		YYDEBUG(341, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'T') goto yy427;
		if (yych == 't') goto yy427;
		goto yy44;
yy342:
		YYDEBUG(342, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'A') goto yy428;
		if (yych == 'a') goto yy428;
		goto yy44;
yy343:
		YYDEBUG(343, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yybm[0+yych] & 16) {
			goto yy43;
		}
		YYDEBUG(344, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_GOTO;
}
yy345:
		YYDEBUG(345, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy429;
		if (yych == 'e') goto yy429;
		goto yy44;
yy346:
		YYDEBUG(346, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'U') goto yy430;
		if (yych == 'u') goto yy430;
		goto yy44;
yy347:
		YYDEBUG(347, *YYCURSOR);
		yych = *++YYCURSOR;
		{
			static void *yytarget[256] = {
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy431, &&yy44,  &&yy44,  &&yy44,  &&yy432, &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy431, &&yy44,  &&yy44,  &&yy44,  &&yy432, &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,
				&&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44,  &&yy44
			};
			goto *yytarget[yych];
		}
yy348:
		YYDEBUG(348, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'R') goto yy433;
		if (yych == 'r') goto yy433;
		goto yy44;
yy349:
		YYDEBUG(349, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'T') goto yy434;
		if (yych == 't') goto yy434;
		goto yy44;
yy350:
		YYDEBUG(350, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yybm[0+yych] & 16) {
			goto yy43;
		}
		YYDEBUG(351, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_LIST;
}
yy352:
		YYDEBUG(352, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'S') goto yy436;
		if (yych == 's') goto yy436;
		goto yy44;
yy353:
		YYDEBUG(353, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'T') goto yy437;
		if (yych == 't') goto yy437;
		goto yy44;
yy354:
		YYDEBUG(354, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'A') goto yy439;
		if (yych == 'a') goto yy439;
		goto yy44;
yy355:
		YYDEBUG(355, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy440;
		if (yych == 'e') goto yy440;
		goto yy44;
yy356:
		YYDEBUG(356, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'I') goto yy441;
		if (yych == 'i') goto yy441;
		goto yy44;
yy357:
		YYDEBUG(357, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'I') goto yy442;
		if (yych == 'i') goto yy442;
		goto yy44;
yy358:
		YYDEBUG(358, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'R') goto yy443;
		if (yych == 'r') goto yy443;
		goto yy44;
yy359:
		YYDEBUG(359, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'I') goto yy444;
		if (yych == 'i') goto yy444;
		goto yy44;
yy360:
		YYDEBUG(360, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'C') goto yy445;
		if (yych == 'c') goto yy445;
		goto yy44;
yy361:
		YYDEBUG(361, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'W') goto yy446;
		if (yych == 'w') goto yy446;
		goto yy44;
yy362:
		YYDEBUG(362, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'T') goto yy448;
		if (yych == 't') goto yy448;
		goto yy44;
yy363:
		YYDEBUG(363, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'T') goto yy450;
		if (yych == 't') goto yy450;
		goto yy44;
yy364:
		YYDEBUG(364, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy452;
		if (yych == 'e') goto yy452;
		goto yy44;
yy365:
		YYDEBUG(365, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'D') goto yy454;
		if (yych == 'd') goto yy454;
		goto yy44;
yy366:
		YYDEBUG(366, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'A') goto yy456;
		if (yych == 'a') goto yy456;
		goto yy44;
yy367:
		YYDEBUG(367, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'R') goto yy457;
		if (yych == 'r') goto yy457;
		goto yy44;
yy368:
		YYDEBUG(368, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'L') goto yy458;
		if (yych == 'l') goto yy458;
		goto yy44;
yy369:
		YYDEBUG(369, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'N') goto yy459;
		if (yych == 'n') goto yy459;
		goto yy44;
yy370:
		YYDEBUG(370, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'L') goto yy460;
		if (yych == 'l') goto yy460;
		goto yy44;
yy371:
		YYDEBUG(371, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'N') goto yy461;
		if (yych == 'n') goto yy461;
		goto yy44;
yy372:
		YYDEBUG(372, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'T') goto yy462;
		if (yych == 't') goto yy462;
		goto yy44;
yy373:
		YYDEBUG(373, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'M') goto yy463;
		if (yych == 'm') goto yy463;
		goto yy44;
yy374:
		YYDEBUG(374, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'A') goto yy464;
		if (yych == 'a') goto yy464;
		goto yy44;
yy375:
		YYDEBUG(375, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'Y') goto yy465;
		if (yych == 'y') goto yy465;
		goto yy82;
yy376:
		YYDEBUG(376, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'R') goto yy467;
		if (yych == 'r') goto yy467;
		goto yy82;
yy377:
		YYDEBUG(377, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy472;
		if (yych == 'e') goto yy472;
		goto yy469;
yy378:
		YYDEBUG(378, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'L') goto yy473;
		if (yych == 'l') goto yy473;
		goto yy82;
yy379:
		YYDEBUG(379, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'T') goto yy386;
		if (yych == 't') goto yy386;
		goto yy82;
yy380:
		YYDEBUG(380, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
yy381:
		YYDEBUG(381, *YYCURSOR);
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy380;
			goto yy82;
		} else {
			if (yych <= ' ') goto yy380;
			if (yych != ')') goto yy82;
		}
		YYDEBUG(382, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(383, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_INT_CAST;
}
yy384:
		YYDEBUG(384, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'G') goto yy474;
		if (yych == 'g') goto yy474;
		goto yy82;
yy385:
		YYDEBUG(385, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'C') goto yy475;
		if (yych == 'c') goto yy475;
		goto yy82;
yy386:
		YYDEBUG(386, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(387, *YYCURSOR);
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy386;
			goto yy82;
		} else {
			if (yych <= ' ') goto yy386;
			if (yych == ')') goto yy476;
			goto yy82;
		}
yy388:
		YYDEBUG(388, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'N') goto yy478;
		if (yych == 'n') goto yy478;
		goto yy82;
yy389:
		YYDEBUG(389, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'T') goto yy479;
		if (yych == 't') goto yy479;
		goto yy82;
yy390:
		YYDEBUG(390, *YYCURSOR);
		++YYCURSOR;
		YYFILL(3);
		yych = *YYCURSOR;
yy391:
		YYDEBUG(391, *YYCURSOR);
		{
			static void *yytarget[256] = {
				&&yy82,  &&yy82,  &&yy82,  &&yy82,  &&yy82,  &&yy82,  &&yy82,  &&yy82,
				&&yy82,  &&yy82,  &&yy82,  &&yy82,  &&yy82,  &&yy82,  &&yy82,  &&yy82,
				&&yy82,  &&yy82,  &&yy82,  &&yy82,  &&yy82,  &&yy82,  &&yy82,  &&yy82,
				&&yy82,  &&yy82,  &&yy82,  &&yy82,  &&yy82,  &&yy82,  &&yy82,  &&yy82,
				&&yy82,  &&yy82,  &&yy481, &&yy82,  &&yy82,  &&yy82,  &&yy82,  &&yy82,
				&&yy82,  &&yy82,  &&yy82,  &&yy82,  &&yy82,  &&yy82,  &&yy82,  &&yy82,
				&&yy390, &&yy390, &&yy390, &&yy390, &&yy390, &&yy390, &&yy390, &&yy390,
				&&yy390, &&yy390, &&yy82,  &&yy82,  &&yy82,  &&yy82,  &&yy82,  &&yy82,
				&&yy82,  &&yy390, &&yy390, &&yy390, &&yy390, &&yy390, &&yy390, &&yy390,
				&&yy390, &&yy390, &&yy390, &&yy390, &&yy390, &&yy390, &&yy390, &&yy390,
				&&yy390, &&yy390, &&yy390, &&yy390, &&yy390, &&yy390, &&yy390, &&yy390,
				&&yy390, &&yy390, &&yy390, &&yy82,  &&yy82,  &&yy82,  &&yy82,  &&yy390,
				&&yy82,  &&yy390, &&yy390, &&yy390, &&yy390, &&yy390, &&yy390, &&yy390,
				&&yy390, &&yy390, &&yy390, &&yy390, &&yy390, &&yy390, &&yy390, &&yy390,
				&&yy390, &&yy390, &&yy390, &&yy390, &&yy390, &&yy390, &&yy390, &&yy390,
				&&yy390, &&yy390, &&yy390, &&yy82,  &&yy82,  &&yy82,  &&yy82,  &&yy390,
				&&yy390, &&yy390, &&yy390, &&yy390, &&yy390, &&yy390, &&yy390, &&yy390,
				&&yy390, &&yy390, &&yy390, &&yy390, &&yy390, &&yy390, &&yy390, &&yy390,
				&&yy390, &&yy390, &&yy390, &&yy390, &&yy390, &&yy390, &&yy390, &&yy390,
				&&yy390, &&yy390, &&yy390, &&yy390, &&yy390, &&yy390, &&yy390, &&yy390,
				&&yy390, &&yy390, &&yy390, &&yy390, &&yy390, &&yy390, &&yy390, &&yy390,
				&&yy390, &&yy390, &&yy390, &&yy390, &&yy390, &&yy390, &&yy390, &&yy390,
				&&yy390, &&yy390, &&yy390, &&yy390, &&yy390, &&yy390, &&yy390, &&yy390,
				&&yy390, &&yy390, &&yy390, &&yy390, &&yy390, &&yy390, &&yy390, &&yy390,
				&&yy390, &&yy390, &&yy390, &&yy390, &&yy390, &&yy390, &&yy390, &&yy390,
				&&yy390, &&yy390, &&yy390, &&yy390, &&yy390, &&yy390, &&yy390, &&yy390,
				&&yy390, &&yy390, &&yy390, &&yy390, &&yy390, &&yy390, &&yy390, &&yy390,
				&&yy390, &&yy390, &&yy390, &&yy390, &&yy390, &&yy390, &&yy390, &&yy390,
				&&yy390, &&yy390, &&yy390, &&yy390, &&yy390, &&yy390, &&yy390, &&yy390,
				&&yy390, &&yy390, &&yy390, &&yy390, &&yy390, &&yy390, &&yy390, &&yy390,
				&&yy390, &&yy390, &&yy390, &&yy390, &&yy390, &&yy390, &&yy390, &&yy390,
				&&yy390, &&yy390, &&yy390, &&yy390, &&yy390, &&yy390, &&yy390, &&yy390
			};
			goto *yytarget[yych];
		}
yy392:
		YYDEBUG(392, *YYCURSOR);
		++YYCURSOR;
		YYFILL(3);
		yych = *YYCURSOR;
yy393:
		YYDEBUG(393, *YYCURSOR);
		{
			static void *yytarget[256] = {
				&&yy82,  &&yy82,  &&yy82,  &&yy82,  &&yy82,  &&yy82,  &&yy82,  &&yy82,
				&&yy82,  &&yy82,  &&yy82,  &&yy82,  &&yy82,  &&yy82,  &&yy82,  &&yy82,
				&&yy82,  &&yy82,  &&yy82,  &&yy82,  &&yy82,  &&yy82,  &&yy82,  &&yy82,
				&&yy82,  &&yy82,  &&yy82,  &&yy82,  &&yy82,  &&yy82,  &&yy82,  &&yy82,
				&&yy82,  &&yy82,  &&yy82,  &&yy82,  &&yy82,  &&yy82,  &&yy82,  &&yy481,
				&&yy82,  &&yy82,  &&yy82,  &&yy82,  &&yy82,  &&yy82,  &&yy82,  &&yy82,
				&&yy392, &&yy392, &&yy392, &&yy392, &&yy392, &&yy392, &&yy392, &&yy392,
				&&yy392, &&yy392, &&yy82,  &&yy82,  &&yy82,  &&yy82,  &&yy82,  &&yy82,
				&&yy82,  &&yy392, &&yy392, &&yy392, &&yy392, &&yy392, &&yy392, &&yy392,
				&&yy392, &&yy392, &&yy392, &&yy392, &&yy392, &&yy392, &&yy392, &&yy392,
				&&yy392, &&yy392, &&yy392, &&yy392, &&yy392, &&yy392, &&yy392, &&yy392,
				&&yy392, &&yy392, &&yy392, &&yy82,  &&yy82,  &&yy82,  &&yy82,  &&yy392,
				&&yy82,  &&yy392, &&yy392, &&yy392, &&yy392, &&yy392, &&yy392, &&yy392,
				&&yy392, &&yy392, &&yy392, &&yy392, &&yy392, &&yy392, &&yy392, &&yy392,
				&&yy392, &&yy392, &&yy392, &&yy392, &&yy392, &&yy392, &&yy392, &&yy392,
				&&yy392, &&yy392, &&yy392, &&yy82,  &&yy82,  &&yy82,  &&yy82,  &&yy392,
				&&yy392, &&yy392, &&yy392, &&yy392, &&yy392, &&yy392, &&yy392, &&yy392,
				&&yy392, &&yy392, &&yy392, &&yy392, &&yy392, &&yy392, &&yy392, &&yy392,
				&&yy392, &&yy392, &&yy392, &&yy392, &&yy392, &&yy392, &&yy392, &&yy392,
				&&yy392, &&yy392, &&yy392, &&yy392, &&yy392, &&yy392, &&yy392, &&yy392,
				&&yy392, &&yy392, &&yy392, &&yy392, &&yy392, &&yy392, &&yy392, &&yy392,
				&&yy392, &&yy392, &&yy392, &&yy392, &&yy392, &&yy392, &&yy392, &&yy392,
				&&yy392, &&yy392, &&yy392, &&yy392, &&yy392, &&yy392, &&yy392, &&yy392,
				&&yy392, &&yy392, &&yy392, &&yy392, &&yy392, &&yy392, &&yy392, &&yy392,
				&&yy392, &&yy392, &&yy392, &&yy392, &&yy392, &&yy392, &&yy392, &&yy392,
				&&yy392, &&yy392, &&yy392, &&yy392, &&yy392, &&yy392, &&yy392, &&yy392,
				&&yy392, &&yy392, &&yy392, &&yy392, &&yy392, &&yy392, &&yy392, &&yy392,
				&&yy392, &&yy392, &&yy392, &&yy392, &&yy392, &&yy392, &&yy392, &&yy392,
				&&yy392, &&yy392, &&yy392, &&yy392, &&yy392, &&yy392, &&yy392, &&yy392,
				&&yy392, &&yy392, &&yy392, &&yy392, &&yy392, &&yy392, &&yy392, &&yy392,
				&&yy392, &&yy392, &&yy392, &&yy392, &&yy392, &&yy392, &&yy392, &&yy392,
				&&yy392, &&yy392, &&yy392, &&yy392, &&yy392, &&yy392, &&yy392, &&yy392
			};
			goto *yytarget[yych];
		}
yy394:
		YYDEBUG(394, *YYCURSOR);
		++YYCURSOR;
yy395:
		YYDEBUG(395, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	char *s;
	int bprefix = (yytext[0] != '<') ? 1 : 0;
	zend_heredoc_label *heredoc_label = emalloc(sizeof(zend_heredoc_label));

	CG(zend_lineno)++;
	heredoc_label->length = yyleng-bprefix-3-1-(yytext[yyleng-2]=='\r'?1:0);
	s = yytext+bprefix+3;
	while ((*s == ' ') || (*s == '\t')) {
		s++;
		heredoc_label->length--;
	}

	if (*s == '\'') {
		s++;
		heredoc_label->length -= 2;

		BEGIN(ST_NOWDOC);
	} else {
		if (*s == '"') {
			s++;
			heredoc_label->length -= 2;
		}

		BEGIN(ST_HEREDOC);
	}

	heredoc_label->label = estrndup(s, heredoc_label->length);

	/* Check for ending label on the next line */
	if (heredoc_label->length < YYLIMIT - YYCURSOR && !memcmp(YYCURSOR, s, heredoc_label->length)) {
		YYCTYPE *end = YYCURSOR + heredoc_label->length;

		if (*end == ';') {
			end++;
		}

		if (*end == '\n' || *end == '\r') {
			BEGIN(ST_END_HEREDOC);
		}
	}

	zend_ptr_stack_push(&SCNG(heredoc_label_stack), (void *) heredoc_label);

	return T_START_HEREDOC;
}
yy396:
		YYDEBUG(396, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '\n') goto yy394;
		goto yy395;
yy397:
		YYDEBUG(397, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'A') goto yy482;
		if (yych == 'a') goto yy482;
		goto yy44;
yy398:
		YYDEBUG(398, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yybm[0+yych] & 16) {
			goto yy43;
		}
		YYDEBUG(399, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_ARRAY;
}
yy400:
		YYDEBUG(400, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yybm[0+yych] & 16) {
			goto yy43;
		}
		YYDEBUG(401, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_BREAK;
}
yy402:
		YYDEBUG(402, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'B') goto yy483;
		if (yych == 'b') goto yy483;
		goto yy44;
yy403:
		YYDEBUG(403, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yybm[0+yych] & 16) {
			goto yy43;
		}
		YYDEBUG(404, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_CATCH;
}
yy405:
		YYDEBUG(405, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yybm[0+yych] & 16) {
			goto yy43;
		}
		YYDEBUG(406, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_CLASS;
}
yy407:
		YYDEBUG(407, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yybm[0+yych] & 16) {
			goto yy43;
		}
		YYDEBUG(408, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_CLONE;
}
yy409:
		YYDEBUG(409, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yybm[0+yych] & 16) {
			goto yy43;
		}
		YYDEBUG(410, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_CONST;
}
yy411:
		YYDEBUG(411, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'N') goto yy484;
		if (yych == 'n') goto yy484;
		goto yy44;
yy412:
		YYDEBUG(412, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'R') goto yy485;
		if (yych == 'r') goto yy485;
		goto yy44;
yy413:
		YYDEBUG(413, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'L') goto yy486;
		if (yych == 'l') goto yy486;
		goto yy44;
yy414:
		YYDEBUG(414, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'F') goto yy487;
		if (yych == 'f') goto yy487;
		goto yy44;
yy415:
		YYDEBUG(415, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yybm[0+yych] & 16) {
			goto yy43;
		}
		YYDEBUG(416, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_EMPTY;
}
yy417:
		YYDEBUG(417, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'C') goto yy489;
		if (yych == 'c') goto yy489;
		goto yy44;
yy418:
		YYDEBUG(418, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'R') goto yy490;
		if (yych == 'r') goto yy490;
		goto yy44;
yy419:
		YYDEBUG(419, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yybm[0+yych] & 16) {
			goto yy43;
		}
		YYDEBUG(420, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_ENDIF;
}
yy421:
		YYDEBUG(421, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'I') goto yy492;
		if (yych == 'i') goto yy492;
		goto yy44;
yy422:
		YYDEBUG(422, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'I') goto yy493;
		if (yych == 'i') goto yy493;
		goto yy44;
yy423:
		YYDEBUG(423, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'D') goto yy494;
		if (yych == 'd') goto yy494;
		goto yy44;
yy424:
		YYDEBUG(424, *YYCURSOR);
		yych = *++YYCURSOR;
		{
			static void *yytarget[256] = {
				&&yy425, &&yy425, &&yy425, &&yy425, &&yy425, &&yy425, &&yy425, &&yy425,
				&&yy425, &&yy425, &&yy425, &&yy425, &&yy425, &&yy425, &&yy425, &&yy425,
				&&yy425, &&yy425, &&yy425, &&yy425, &&yy425, &&yy425, &&yy425, &&yy425,
				&&yy425, &&yy425, &&yy425, &&yy425, &&yy425, &&yy425, &&yy425, &&yy425,
				&&yy425, &&yy425, &&yy425, &&yy425, &&yy425, &&yy425, &&yy425, &&yy425,
				&&yy425, &&yy425, &&yy425, &&yy425, &&yy425, &&yy425, &&yy425, &&yy425,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy425, &&yy425, &&yy425, &&yy425, &&yy425, &&yy425,
				&&yy425, &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy495, &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy425, &&yy425, &&yy425, &&yy425, &&yy43,
				&&yy425, &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy495, &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy425, &&yy425, &&yy425, &&yy425, &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43
			};
			goto *yytarget[yych];
		}
yy425:
		YYDEBUG(425, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_FINAL;
}
yy426:
		YYDEBUG(426, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'C') goto yy496;
		if (yych == 'c') goto yy496;
		goto yy44;
yy427:
		YYDEBUG(427, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'I') goto yy497;
		if (yych == 'i') goto yy497;
		goto yy44;
yy428:
		YYDEBUG(428, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'L') goto yy498;
		if (yych == 'l') goto yy498;
		goto yy44;
yy429:
		YYDEBUG(429, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'M') goto yy500;
		if (yych == 'm') goto yy500;
		goto yy44;
yy430:
		YYDEBUG(430, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'D') goto yy501;
		if (yych == 'd') goto yy501;
		goto yy44;
yy431:
		YYDEBUG(431, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'N') goto yy502;
		if (yych == 'n') goto yy502;
		goto yy44;
yy432:
		YYDEBUG(432, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'A') goto yy503;
		if (yych == 'a') goto yy503;
		goto yy44;
yy433:
		YYDEBUG(433, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'F') goto yy504;
		if (yych == 'f') goto yy504;
		goto yy44;
yy434:
		YYDEBUG(434, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yybm[0+yych] & 16) {
			goto yy43;
		}
		YYDEBUG(435, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_ISSET;
}
yy436:
		YYDEBUG(436, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'P') goto yy505;
		if (yych == 'p') goto yy505;
		goto yy44;
yy437:
		YYDEBUG(437, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yybm[0+yych] & 16) {
			goto yy43;
		}
		YYDEBUG(438, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_PRINT;
}
yy439:
		YYDEBUG(439, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'T') goto yy506;
		if (yych == 't') goto yy506;
		goto yy44;
yy440:
		YYDEBUG(440, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'C') goto yy507;
		if (yych == 'c') goto yy507;
		goto yy44;
yy441:
		YYDEBUG(441, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'C') goto yy508;
		if (yych == 'c') goto yy508;
		goto yy44;
yy442:
		YYDEBUG(442, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'R') goto yy510;
		if (yych == 'r') goto yy510;
		goto yy44;
yy443:
		YYDEBUG(443, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'N') goto yy511;
		if (yych == 'n') goto yy511;
		goto yy44;
yy444:
		YYDEBUG(444, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'C') goto yy513;
		if (yych == 'c') goto yy513;
		goto yy44;
yy445:
		YYDEBUG(445, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'H') goto yy515;
		if (yych == 'h') goto yy515;
		goto yy44;
yy446:
		YYDEBUG(446, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yybm[0+yych] & 16) {
			goto yy43;
		}
		YYDEBUG(447, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_THROW;
}
yy448:
		YYDEBUG(448, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yybm[0+yych] & 16) {
			goto yy43;
		}
		YYDEBUG(449, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_TRAIT;
}
yy450:
		YYDEBUG(450, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yybm[0+yych] & 16) {
			goto yy43;
		}
		YYDEBUG(451, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_UNSET;
}
yy452:
		YYDEBUG(452, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yybm[0+yych] & 16) {
			goto yy43;
		}
		YYDEBUG(453, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_WHILE;
}
yy454:
		YYDEBUG(454, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yybm[0+yych] & 16) {
			goto yy43;
		}
		YYDEBUG(455, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_YIELD;
}
yy456:
		YYDEBUG(456, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'S') goto yy517;
		if (yych == 's') goto yy517;
		goto yy44;
yy457:
		YYDEBUG(457, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '_') goto yy518;
		goto yy44;
yy458:
		YYDEBUG(458, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy519;
		if (yych == 'e') goto yy519;
		goto yy44;
yy459:
		YYDEBUG(459, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'C') goto yy520;
		if (yych == 'c') goto yy520;
		goto yy44;
yy460:
		YYDEBUG(460, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'T') goto yy521;
		if (yych == 't') goto yy521;
		goto yy44;
yy461:
		YYDEBUG(461, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy522;
		if (yych == 'e') goto yy522;
		goto yy44;
yy462:
		YYDEBUG(462, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'H') goto yy523;
		if (yych == 'h') goto yy523;
		goto yy44;
yy463:
		YYDEBUG(463, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy524;
		if (yych == 'e') goto yy524;
		goto yy44;
yy464:
		YYDEBUG(464, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'I') goto yy525;
		if (yych == 'i') goto yy525;
		goto yy44;
yy465:
		YYDEBUG(465, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(466, *YYCURSOR);
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy465;
			goto yy82;
		} else {
			if (yych <= ' ') goto yy465;
			if (yych == ')') goto yy526;
			goto yy82;
		}
yy467:
		YYDEBUG(467, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'Y') goto yy528;
		if (yych == 'y') goto yy528;
		goto yy82;
yy468:
		YYDEBUG(468, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
yy469:
		YYDEBUG(469, *YYCURSOR);
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy468;
			goto yy82;
		} else {
			if (yych <= ' ') goto yy468;
			if (yych != ')') goto yy82;
		}
		YYDEBUG(470, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(471, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_BOOL_CAST;
}
yy472:
		YYDEBUG(472, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'A') goto yy530;
		if (yych == 'a') goto yy530;
		goto yy82;
yy473:
		YYDEBUG(473, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy386;
		if (yych == 'e') goto yy386;
		goto yy82;
yy474:
		YYDEBUG(474, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy531;
		if (yych == 'e') goto yy531;
		goto yy82;
yy475:
		YYDEBUG(475, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'T') goto yy532;
		if (yych == 't') goto yy532;
		goto yy82;
yy476:
		YYDEBUG(476, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(477, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_DOUBLE_CAST;
}
yy478:
		YYDEBUG(478, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'G') goto yy528;
		if (yych == 'g') goto yy528;
		goto yy82;
yy479:
		YYDEBUG(479, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(480, *YYCURSOR);
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy479;
			goto yy82;
		} else {
			if (yych <= ' ') goto yy479;
			if (yych == ')') goto yy534;
			goto yy82;
		}
yy481:
		YYDEBUG(481, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '\n') goto yy394;
		if (yych == '\r') goto yy396;
		goto yy82;
yy482:
		YYDEBUG(482, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'C') goto yy536;
		if (yych == 'c') goto yy536;
		goto yy44;
yy483:
		YYDEBUG(483, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'L') goto yy537;
		if (yych == 'l') goto yy537;
		goto yy44;
yy484:
		YYDEBUG(484, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'U') goto yy538;
		if (yych == 'u') goto yy538;
		goto yy44;
yy485:
		YYDEBUG(485, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy539;
		if (yych == 'e') goto yy539;
		goto yy44;
yy486:
		YYDEBUG(486, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'T') goto yy541;
		if (yych == 't') goto yy541;
		goto yy44;
yy487:
		YYDEBUG(487, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yybm[0+yych] & 16) {
			goto yy43;
		}
		YYDEBUG(488, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_ELSEIF;
}
yy489:
		YYDEBUG(489, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'L') goto yy543;
		if (yych == 'l') goto yy543;
		goto yy44;
yy490:
		YYDEBUG(490, *YYCURSOR);
		yych = *++YYCURSOR;
		{
			static void *yytarget[256] = {
				&&yy491, &&yy491, &&yy491, &&yy491, &&yy491, &&yy491, &&yy491, &&yy491,
				&&yy491, &&yy491, &&yy491, &&yy491, &&yy491, &&yy491, &&yy491, &&yy491,
				&&yy491, &&yy491, &&yy491, &&yy491, &&yy491, &&yy491, &&yy491, &&yy491,
				&&yy491, &&yy491, &&yy491, &&yy491, &&yy491, &&yy491, &&yy491, &&yy491,
				&&yy491, &&yy491, &&yy491, &&yy491, &&yy491, &&yy491, &&yy491, &&yy491,
				&&yy491, &&yy491, &&yy491, &&yy491, &&yy491, &&yy491, &&yy491, &&yy491,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy491, &&yy491, &&yy491, &&yy491, &&yy491, &&yy491,
				&&yy491, &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy544, &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy491, &&yy491, &&yy491, &&yy491, &&yy43,
				&&yy491, &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy544, &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy491, &&yy491, &&yy491, &&yy491, &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43
			};
			goto *yytarget[yych];
		}
yy491:
		YYDEBUG(491, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_ENDFOR;
}
yy492:
		YYDEBUG(492, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'T') goto yy545;
		if (yych == 't') goto yy545;
		goto yy44;
yy493:
		YYDEBUG(493, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'L') goto yy546;
		if (yych == 'l') goto yy546;
		goto yy44;
yy494:
		YYDEBUG(494, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'S') goto yy547;
		if (yych == 's') goto yy547;
		goto yy44;
yy495:
		YYDEBUG(495, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'Y') goto yy549;
		if (yych == 'y') goto yy549;
		goto yy44;
yy496:
		YYDEBUG(496, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'H') goto yy551;
		if (yych == 'h') goto yy551;
		goto yy44;
yy497:
		YYDEBUG(497, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'O') goto yy553;
		if (yych == 'o') goto yy553;
		goto yy44;
yy498:
		YYDEBUG(498, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yybm[0+yych] & 16) {
			goto yy43;
		}
		YYDEBUG(499, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_GLOBAL;
}
yy500:
		YYDEBUG(500, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy554;
		if (yych == 'e') goto yy554;
		goto yy44;
yy501:
		YYDEBUG(501, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy555;
		if (yych == 'e') goto yy555;
		goto yy44;
yy502:
		YYDEBUG(502, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'C') goto yy557;
		if (yych == 'c') goto yy557;
		goto yy44;
yy503:
		YYDEBUG(503, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'D') goto yy558;
		if (yych == 'd') goto yy558;
		goto yy44;
yy504:
		YYDEBUG(504, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'A') goto yy559;
		if (yych == 'a') goto yy559;
		goto yy44;
yy505:
		YYDEBUG(505, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'A') goto yy560;
		if (yych == 'a') goto yy560;
		goto yy44;
yy506:
		YYDEBUG(506, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy561;
		if (yych == 'e') goto yy561;
		goto yy44;
yy507:
		YYDEBUG(507, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'T') goto yy563;
		if (yych == 't') goto yy563;
		goto yy44;
yy508:
		YYDEBUG(508, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yybm[0+yych] & 16) {
			goto yy43;
		}
		YYDEBUG(509, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_PUBLIC;
}
yy510:
		YYDEBUG(510, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy564;
		if (yych == 'e') goto yy564;
		goto yy44;
yy511:
		YYDEBUG(511, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yybm[0+yych] & 16) {
			goto yy43;
		}
		YYDEBUG(512, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_RETURN;
}
yy513:
		YYDEBUG(513, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yybm[0+yych] & 16) {
			goto yy43;
		}
		YYDEBUG(514, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_STATIC;
}
yy515:
		YYDEBUG(515, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yybm[0+yych] & 16) {
			goto yy43;
		}
		YYDEBUG(516, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_SWITCH;
}
yy517:
		YYDEBUG(517, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'S') goto yy566;
		if (yych == 's') goto yy566;
		goto yy44;
yy518:
		YYDEBUG(518, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '_') goto yy567;
		goto yy44;
yy519:
		YYDEBUG(519, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '_') goto yy569;
		goto yy44;
yy520:
		YYDEBUG(520, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'T') goto yy570;
		if (yych == 't') goto yy570;
		goto yy44;
yy521:
		YYDEBUG(521, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '_') goto yy571;
		goto yy44;
yy522:
		YYDEBUG(522, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '_') goto yy572;
		goto yy44;
yy523:
		YYDEBUG(523, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'O') goto yy573;
		if (yych == 'o') goto yy573;
		goto yy44;
yy524:
		YYDEBUG(524, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'S') goto yy574;
		if (yych == 's') goto yy574;
		goto yy44;
yy525:
		YYDEBUG(525, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'T') goto yy575;
		if (yych == 't') goto yy575;
		goto yy44;
yy526:
		YYDEBUG(526, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(527, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_ARRAY_CAST;
}
yy528:
		YYDEBUG(528, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(529, *YYCURSOR);
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy528;
			goto yy82;
		} else {
			if (yych <= ' ') goto yy528;
			if (yych == ')') goto yy576;
			goto yy82;
		}
yy530:
		YYDEBUG(530, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'N') goto yy468;
		if (yych == 'n') goto yy468;
		goto yy82;
yy531:
		YYDEBUG(531, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'R') goto yy380;
		if (yych == 'r') goto yy380;
		goto yy82;
yy532:
		YYDEBUG(532, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(533, *YYCURSOR);
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy532;
			goto yy82;
		} else {
			if (yych <= ' ') goto yy532;
			if (yych == ')') goto yy578;
			goto yy82;
		}
yy534:
		YYDEBUG(534, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(535, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_UNSET_CAST;
}
yy536:
		YYDEBUG(536, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'T') goto yy580;
		if (yych == 't') goto yy580;
		goto yy44;
yy537:
		YYDEBUG(537, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy582;
		if (yych == 'e') goto yy582;
		goto yy44;
yy538:
		YYDEBUG(538, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy584;
		if (yych == 'e') goto yy584;
		goto yy44;
yy539:
		YYDEBUG(539, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yybm[0+yych] & 16) {
			goto yy43;
		}
		YYDEBUG(540, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_DECLARE;
}
yy541:
		YYDEBUG(541, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yybm[0+yych] & 16) {
			goto yy43;
		}
		YYDEBUG(542, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_DEFAULT;
}
yy543:
		YYDEBUG(543, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'A') goto yy586;
		if (yych == 'a') goto yy586;
		goto yy44;
yy544:
		YYDEBUG(544, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'A') goto yy587;
		if (yych == 'a') goto yy587;
		goto yy44;
yy545:
		YYDEBUG(545, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'C') goto yy588;
		if (yych == 'c') goto yy588;
		goto yy44;
yy546:
		YYDEBUG(546, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy589;
		if (yych == 'e') goto yy589;
		goto yy44;
yy547:
		YYDEBUG(547, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yybm[0+yych] & 16) {
			goto yy43;
		}
		YYDEBUG(548, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_EXTENDS;
}
yy549:
		YYDEBUG(549, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yybm[0+yych] & 16) {
			goto yy43;
		}
		YYDEBUG(550, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_FINALLY;
}
yy551:
		YYDEBUG(551, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yybm[0+yych] & 16) {
			goto yy43;
		}
		YYDEBUG(552, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_FOREACH;
}
yy553:
		YYDEBUG(553, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'N') goto yy591;
		if (yych == 'n') goto yy591;
		goto yy44;
yy554:
		YYDEBUG(554, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'N') goto yy593;
		if (yych == 'n') goto yy593;
		goto yy44;
yy555:
		YYDEBUG(555, *YYCURSOR);
		yych = *++YYCURSOR;
		{
			static void *yytarget[256] = {
				&&yy556, &&yy556, &&yy556, &&yy556, &&yy556, &&yy556, &&yy556, &&yy556,
				&&yy556, &&yy556, &&yy556, &&yy556, &&yy556, &&yy556, &&yy556, &&yy556,
				&&yy556, &&yy556, &&yy556, &&yy556, &&yy556, &&yy556, &&yy556, &&yy556,
				&&yy556, &&yy556, &&yy556, &&yy556, &&yy556, &&yy556, &&yy556, &&yy556,
				&&yy556, &&yy556, &&yy556, &&yy556, &&yy556, &&yy556, &&yy556, &&yy556,
				&&yy556, &&yy556, &&yy556, &&yy556, &&yy556, &&yy556, &&yy556, &&yy556,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy556, &&yy556, &&yy556, &&yy556, &&yy556, &&yy556,
				&&yy556, &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy556, &&yy556, &&yy556, &&yy556, &&yy594,
				&&yy556, &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy556, &&yy556, &&yy556, &&yy556, &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43
			};
			goto *yytarget[yych];
		}
yy556:
		YYDEBUG(556, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_INCLUDE;
}
yy557:
		YYDEBUG(557, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy595;
		if (yych == 'e') goto yy595;
		goto yy44;
yy558:
		YYDEBUG(558, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'O') goto yy596;
		if (yych == 'o') goto yy596;
		goto yy44;
yy559:
		YYDEBUG(559, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'C') goto yy597;
		if (yych == 'c') goto yy597;
		goto yy44;
yy560:
		YYDEBUG(560, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'C') goto yy598;
		if (yych == 'c') goto yy598;
		goto yy44;
yy561:
		YYDEBUG(561, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yybm[0+yych] & 16) {
			goto yy43;
		}
		YYDEBUG(562, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_PRIVATE;
}
yy563:
		YYDEBUG(563, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy599;
		if (yych == 'e') goto yy599;
		goto yy44;
yy564:
		YYDEBUG(564, *YYCURSOR);
		yych = *++YYCURSOR;
		{
			static void *yytarget[256] = {
				&&yy565, &&yy565, &&yy565, &&yy565, &&yy565, &&yy565, &&yy565, &&yy565,
				&&yy565, &&yy565, &&yy565, &&yy565, &&yy565, &&yy565, &&yy565, &&yy565,
				&&yy565, &&yy565, &&yy565, &&yy565, &&yy565, &&yy565, &&yy565, &&yy565,
				&&yy565, &&yy565, &&yy565, &&yy565, &&yy565, &&yy565, &&yy565, &&yy565,
				&&yy565, &&yy565, &&yy565, &&yy565, &&yy565, &&yy565, &&yy565, &&yy565,
				&&yy565, &&yy565, &&yy565, &&yy565, &&yy565, &&yy565, &&yy565, &&yy565,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy565, &&yy565, &&yy565, &&yy565, &&yy565, &&yy565,
				&&yy565, &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy565, &&yy565, &&yy565, &&yy565, &&yy600,
				&&yy565, &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy565, &&yy565, &&yy565, &&yy565, &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,
				&&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43,  &&yy43
			};
			goto *yytarget[yych];
		}
yy565:
		YYDEBUG(565, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_REQUIRE;
}
yy566:
		YYDEBUG(566, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '_') goto yy601;
		goto yy44;
yy567:
		YYDEBUG(567, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yybm[0+yych] & 16) {
			goto yy43;
		}
		YYDEBUG(568, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_DIR;
}
yy569:
		YYDEBUG(569, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '_') goto yy602;
		goto yy44;
yy570:
		YYDEBUG(570, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'I') goto yy604;
		if (yych == 'i') goto yy604;
		goto yy44;
yy571:
		YYDEBUG(571, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'C') goto yy605;
		if (yych == 'c') goto yy605;
		goto yy44;
yy572:
		YYDEBUG(572, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '_') goto yy606;
		goto yy44;
yy573:
		YYDEBUG(573, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'D') goto yy608;
		if (yych == 'd') goto yy608;
		goto yy44;
yy574:
		YYDEBUG(574, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'P') goto yy609;
		if (yych == 'p') goto yy609;
		goto yy44;
yy575:
		YYDEBUG(575, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '_') goto yy610;
		goto yy44;
yy576:
		YYDEBUG(576, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(577, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_STRING_CAST;
}
yy578:
		YYDEBUG(578, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(579, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_OBJECT_CAST;
}
yy580:
		YYDEBUG(580, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yybm[0+yych] & 16) {
			goto yy43;
		}
		YYDEBUG(581, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_ABSTRACT;
}
yy582:
		YYDEBUG(582, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yybm[0+yych] & 16) {
			goto yy43;
		}
		YYDEBUG(583, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
 return T_CALLABLE;
}
yy584:
		YYDEBUG(584, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yybm[0+yych] & 16) {
			goto yy43;
		}
		YYDEBUG(585, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_CONTINUE;
}
yy586:
		YYDEBUG(586, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'R') goto yy611;
		if (yych == 'r') goto yy611;
		goto yy44;
yy587:
		YYDEBUG(587, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'C') goto yy612;
		if (yych == 'c') goto yy612;
		goto yy44;
yy588:
		YYDEBUG(588, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'H') goto yy613;
		if (yych == 'h') goto yy613;
		goto yy44;
yy589:
		YYDEBUG(589, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yybm[0+yych] & 16) {
			goto yy43;
		}
		YYDEBUG(590, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_ENDWHILE;
}
yy591:
		YYDEBUG(591, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yybm[0+yych] & 16) {
			goto yy43;
		}
		YYDEBUG(592, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_FUNCTION;
}
yy593:
		YYDEBUG(593, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'T') goto yy615;
		if (yych == 't') goto yy615;
		goto yy44;
yy594:
		YYDEBUG(594, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'O') goto yy616;
		if (yych == 'o') goto yy616;
		goto yy44;
yy595:
		YYDEBUG(595, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'O') goto yy617;
		if (yych == 'o') goto yy617;
		goto yy44;
yy596:
		YYDEBUG(596, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'F') goto yy618;
		if (yych == 'f') goto yy618;
		goto yy44;
yy597:
		YYDEBUG(597, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy620;
		if (yych == 'e') goto yy620;
		goto yy44;
yy598:
		YYDEBUG(598, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy622;
		if (yych == 'e') goto yy622;
		goto yy44;
yy599:
		YYDEBUG(599, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'D') goto yy624;
		if (yych == 'd') goto yy624;
		goto yy44;
yy600:
		YYDEBUG(600, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'O') goto yy626;
		if (yych == 'o') goto yy626;
		goto yy44;
yy601:
		YYDEBUG(601, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '_') goto yy627;
		goto yy44;
yy602:
		YYDEBUG(602, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yybm[0+yych] & 16) {
			goto yy43;
		}
		YYDEBUG(603, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_FILE;
}
yy604:
		YYDEBUG(604, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'O') goto yy629;
		if (yych == 'o') goto yy629;
		goto yy44;
yy605:
		YYDEBUG(605, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'O') goto yy630;
		if (yych == 'o') goto yy630;
		goto yy44;
yy606:
		YYDEBUG(606, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yybm[0+yych] & 16) {
			goto yy43;
		}
		YYDEBUG(607, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_LINE;
}
yy608:
		YYDEBUG(608, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '_') goto yy631;
		goto yy44;
yy609:
		YYDEBUG(609, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'A') goto yy632;
		if (yych == 'a') goto yy632;
		goto yy44;
yy610:
		YYDEBUG(610, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '_') goto yy633;
		goto yy44;
yy611:
		YYDEBUG(611, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy635;
		if (yych == 'e') goto yy635;
		goto yy44;
yy612:
		YYDEBUG(612, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'H') goto yy637;
		if (yych == 'h') goto yy637;
		goto yy44;
yy613:
		YYDEBUG(613, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yybm[0+yych] & 16) {
			goto yy43;
		}
		YYDEBUG(614, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_ENDSWITCH;
}
yy615:
		YYDEBUG(615, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'S') goto yy639;
		if (yych == 's') goto yy639;
		goto yy44;
yy616:
		YYDEBUG(616, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'N') goto yy641;
		if (yych == 'n') goto yy641;
		goto yy44;
yy617:
		YYDEBUG(617, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'F') goto yy642;
		if (yych == 'f') goto yy642;
		goto yy44;
yy618:
		YYDEBUG(618, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yybm[0+yych] & 16) {
			goto yy43;
		}
		YYDEBUG(619, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
        return T_INSTEADOF;
}
yy620:
		YYDEBUG(620, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yybm[0+yych] & 16) {
			goto yy43;
		}
		YYDEBUG(621, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_INTERFACE;
}
yy622:
		YYDEBUG(622, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yybm[0+yych] & 16) {
			goto yy43;
		}
		YYDEBUG(623, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_NAMESPACE;
}
yy624:
		YYDEBUG(624, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yybm[0+yych] & 16) {
			goto yy43;
		}
		YYDEBUG(625, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_PROTECTED;
}
yy626:
		YYDEBUG(626, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'N') goto yy644;
		if (yych == 'n') goto yy644;
		goto yy44;
yy627:
		YYDEBUG(627, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yybm[0+yych] & 16) {
			goto yy43;
		}
		YYDEBUG(628, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_CLASS_C;
}
yy629:
		YYDEBUG(629, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'N') goto yy645;
		if (yych == 'n') goto yy645;
		goto yy44;
yy630:
		YYDEBUG(630, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'M') goto yy646;
		if (yych == 'm') goto yy646;
		goto yy44;
yy631:
		YYDEBUG(631, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '_') goto yy647;
		goto yy44;
yy632:
		YYDEBUG(632, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'C') goto yy649;
		if (yych == 'c') goto yy649;
		goto yy44;
yy633:
		YYDEBUG(633, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yybm[0+yych] & 16) {
			goto yy43;
		}
		YYDEBUG(634, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_TRAIT_C;
}
yy635:
		YYDEBUG(635, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yybm[0+yych] & 16) {
			goto yy43;
		}
		YYDEBUG(636, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_ENDDECLARE;
}
yy637:
		YYDEBUG(637, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yybm[0+yych] & 16) {
			goto yy43;
		}
		YYDEBUG(638, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_ENDFOREACH;
}
yy639:
		YYDEBUG(639, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yybm[0+yych] & 16) {
			goto yy43;
		}
		YYDEBUG(640, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_IMPLEMENTS;
}
yy641:
		YYDEBUG(641, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'C') goto yy650;
		if (yych == 'c') goto yy650;
		goto yy44;
yy642:
		YYDEBUG(642, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yybm[0+yych] & 16) {
			goto yy43;
		}
		YYDEBUG(643, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_INSTANCEOF;
}
yy644:
		YYDEBUG(644, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'C') goto yy651;
		if (yych == 'c') goto yy651;
		goto yy44;
yy645:
		YYDEBUG(645, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '_') goto yy652;
		goto yy44;
yy646:
		YYDEBUG(646, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'P') goto yy653;
		if (yych == 'p') goto yy653;
		goto yy44;
yy647:
		YYDEBUG(647, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yybm[0+yych] & 16) {
			goto yy43;
		}
		YYDEBUG(648, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_METHOD_C;
}
yy649:
		YYDEBUG(649, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy654;
		if (yych == 'e') goto yy654;
		goto yy44;
yy650:
		YYDEBUG(650, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy655;
		if (yych == 'e') goto yy655;
		goto yy44;
yy651:
		YYDEBUG(651, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy657;
		if (yych == 'e') goto yy657;
		goto yy44;
yy652:
		YYDEBUG(652, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '_') goto yy659;
		goto yy44;
yy653:
		YYDEBUG(653, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'I') goto yy661;
		if (yych == 'i') goto yy661;
		goto yy44;
yy654:
		YYDEBUG(654, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '_') goto yy662;
		goto yy44;
yy655:
		YYDEBUG(655, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yybm[0+yych] & 16) {
			goto yy43;
		}
		YYDEBUG(656, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_INCLUDE_ONCE;
}
yy657:
		YYDEBUG(657, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yybm[0+yych] & 16) {
			goto yy43;
		}
		YYDEBUG(658, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_REQUIRE_ONCE;
}
yy659:
		YYDEBUG(659, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yybm[0+yych] & 16) {
			goto yy43;
		}
		YYDEBUG(660, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_FUNC_C;
}
yy661:
		YYDEBUG(661, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'L') goto yy663;
		if (yych == 'l') goto yy663;
		goto yy44;
yy662:
		YYDEBUG(662, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '_') goto yy664;
		goto yy44;
yy663:
		YYDEBUG(663, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy666;
		if (yych == 'e') goto yy666;
		goto yy44;
yy664:
		YYDEBUG(664, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yybm[0+yych] & 16) {
			goto yy43;
		}
		YYDEBUG(665, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_NS_C;
}
yy666:
		YYDEBUG(666, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'R') goto yy667;
		if (yych != 'r') goto yy44;
yy667:
		YYDEBUG(667, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yybm[0+yych] & 16) {
			goto yy43;
		}
		YYDEBUG(668, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_HALT_COMPILER;
}
	}
/* *********************************** */
yyc_ST_LOOKING_FOR_PROPERTY:
	{
		static const unsigned char yybm[] = {
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,  64,  64,   0,   0,  64,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			 64,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128,   0,   0,   0,   0,   0,   0, 
			  0, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128,   0,   0,   0,   0, 128, 
			  0, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128,   0,   0,   0,   0, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
		};
		YYDEBUG(669, *YYCURSOR);
		YYFILL(2);
		yych = *YYCURSOR;
		{
			static void *yytarget[256] = {
				&&yy671, &&yy671, &&yy671, &&yy671, &&yy671, &&yy671, &&yy671, &&yy671,
				&&yy671, &&yy673, &&yy673, &&yy671, &&yy671, &&yy673, &&yy671, &&yy671,
				&&yy671, &&yy671, &&yy671, &&yy671, &&yy671, &&yy671, &&yy671, &&yy671,
				&&yy671, &&yy671, &&yy671, &&yy671, &&yy671, &&yy671, &&yy671, &&yy671,
				&&yy673, &&yy671, &&yy671, &&yy671, &&yy671, &&yy671, &&yy671, &&yy671,
				&&yy671, &&yy671, &&yy671, &&yy671, &&yy671, &&yy676, &&yy671, &&yy671,
				&&yy671, &&yy671, &&yy671, &&yy671, &&yy671, &&yy671, &&yy671, &&yy671,
				&&yy671, &&yy671, &&yy671, &&yy671, &&yy671, &&yy671, &&yy671, &&yy671,
				&&yy671, &&yy677, &&yy677, &&yy677, &&yy677, &&yy677, &&yy677, &&yy677,
				&&yy677, &&yy677, &&yy677, &&yy677, &&yy677, &&yy677, &&yy677, &&yy677,
				&&yy677, &&yy677, &&yy677, &&yy677, &&yy677, &&yy677, &&yy677, &&yy677,
				&&yy677, &&yy677, &&yy677, &&yy671, &&yy671, &&yy671, &&yy671, &&yy677,
				&&yy671, &&yy677, &&yy677, &&yy677, &&yy677, &&yy677, &&yy677, &&yy677,
				&&yy677, &&yy677, &&yy677, &&yy677, &&yy677, &&yy677, &&yy677, &&yy677,
				&&yy677, &&yy677, &&yy677, &&yy677, &&yy677, &&yy677, &&yy677, &&yy677,
				&&yy677, &&yy677, &&yy677, &&yy671, &&yy671, &&yy671, &&yy671, &&yy677,
				&&yy677, &&yy677, &&yy677, &&yy677, &&yy677, &&yy677, &&yy677, &&yy677,
				&&yy677, &&yy677, &&yy677, &&yy677, &&yy677, &&yy677, &&yy677, &&yy677,
				&&yy677, &&yy677, &&yy677, &&yy677, &&yy677, &&yy677, &&yy677, &&yy677,
				&&yy677, &&yy677, &&yy677, &&yy677, &&yy677, &&yy677, &&yy677, &&yy677,
				&&yy677, &&yy677, &&yy677, &&yy677, &&yy677, &&yy677, &&yy677, &&yy677,
				&&yy677, &&yy677, &&yy677, &&yy677, &&yy677, &&yy677, &&yy677, &&yy677,
				&&yy677, &&yy677, &&yy677, &&yy677, &&yy677, &&yy677, &&yy677, &&yy677,
				&&yy677, &&yy677, &&yy677, &&yy677, &&yy677, &&yy677, &&yy677, &&yy677,
				&&yy677, &&yy677, &&yy677, &&yy677, &&yy677, &&yy677, &&yy677, &&yy677,
				&&yy677, &&yy677, &&yy677, &&yy677, &&yy677, &&yy677, &&yy677, &&yy677,
				&&yy677, &&yy677, &&yy677, &&yy677, &&yy677, &&yy677, &&yy677, &&yy677,
				&&yy677, &&yy677, &&yy677, &&yy677, &&yy677, &&yy677, &&yy677, &&yy677,
				&&yy677, &&yy677, &&yy677, &&yy677, &&yy677, &&yy677, &&yy677, &&yy677,
				&&yy677, &&yy677, &&yy677, &&yy677, &&yy677, &&yy677, &&yy677, &&yy677,
				&&yy677, &&yy677, &&yy677, &&yy677, &&yy677, &&yy677, &&yy677, &&yy677,
				&&yy677, &&yy677, &&yy677, &&yy677, &&yy677, &&yy677, &&yy677, &&yy677
			};
			goto *yytarget[yych];
		}
yy671:
		YYDEBUG(671, *YYCURSOR);
		++YYCURSOR;
yy672:
		YYDEBUG(672, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	yyless(0);
	yy_pop_state();
	goto restart;
}
yy673:
		YYDEBUG(673, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(674, *YYCURSOR);
		if (yybm[0+yych] & 64) {
			goto yy673;
		}
		YYDEBUG(675, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	HANDLE_NEWLINES(yytext, yyleng);
	return T_WHITESPACE;
}
yy676:
		YYDEBUG(676, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '>') goto yy680;
		goto yy672;
yy677:
		YYDEBUG(677, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(678, *YYCURSOR);
		if (yybm[0+yych] & 128) {
			goto yy677;
		}
		YYDEBUG(679, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	yy_pop_state();
	zend_copy_value(zendlval, yytext, yyleng);
	return T_STRING;
}
yy680:
		YYDEBUG(680, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(681, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_OBJECT_OPERATOR;
}
	}
/* *********************************** */
yyc_ST_BACKQUOTE:
	{
		static const unsigned char yybm[] = {
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128,   0,   0,   0,   0,   0,   0, 
			  0, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128,   0,   0,   0,   0, 128, 
			  0, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128,   0,   0,   0,   0, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
		};
		YYDEBUG(682, *YYCURSOR);
		YYFILL(2);
		yych = *YYCURSOR;
		if (yych <= '_') {
			if (yych == '$') goto yy686;
		} else {
			if (yych <= '`') goto yy687;
			if (yych == '{') goto yy689;
		}
		YYDEBUG(684, *YYCURSOR);
		++YYCURSOR;
yy685:
		YYDEBUG(685, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	if (YYCURSOR > YYLIMIT) {
		return 0;
	}
	if (yytext[0] == '\\' && YYCURSOR < YYLIMIT) {
		YYCURSOR++;
	}

	while (YYCURSOR < YYLIMIT) {
		switch (*YYCURSOR++) {
			case '`':
				break;
			case '$':
				if (IS_LABEL_START(*YYCURSOR) || *YYCURSOR == '{') {
					break;
				}
				continue;
			case '{':
				if (*YYCURSOR == '$') {
					break;
				}
				continue;
			case '\\':
				if (YYCURSOR < YYLIMIT) {
					YYCURSOR++;
				}
				/* fall through */
			default:
				continue;
		}

		YYCURSOR--;
		break;
	}

	yyleng = YYCURSOR - SCNG(yy_text);

	zend_scan_escape_string(zendlval, yytext, yyleng, '`');
	return T_ENCAPSED_AND_WHITESPACE;
}
yy686:
		YYDEBUG(686, *YYCURSOR);
		yych = *++YYCURSOR;
		{
			static void *yytarget[256] = {
				&&yy685, &&yy685, &&yy685, &&yy685, &&yy685, &&yy685, &&yy685, &&yy685,
				&&yy685, &&yy685, &&yy685, &&yy685, &&yy685, &&yy685, &&yy685, &&yy685,
				&&yy685, &&yy685, &&yy685, &&yy685, &&yy685, &&yy685, &&yy685, &&yy685,
				&&yy685, &&yy685, &&yy685, &&yy685, &&yy685, &&yy685, &&yy685, &&yy685,
				&&yy685, &&yy685, &&yy685, &&yy685, &&yy685, &&yy685, &&yy685, &&yy685,
				&&yy685, &&yy685, &&yy685, &&yy685, &&yy685, &&yy685, &&yy685, &&yy685,
				&&yy685, &&yy685, &&yy685, &&yy685, &&yy685, &&yy685, &&yy685, &&yy685,
				&&yy685, &&yy685, &&yy685, &&yy685, &&yy685, &&yy685, &&yy685, &&yy685,
				&&yy685, &&yy690, &&yy690, &&yy690, &&yy690, &&yy690, &&yy690, &&yy690,
				&&yy690, &&yy690, &&yy690, &&yy690, &&yy690, &&yy690, &&yy690, &&yy690,
				&&yy690, &&yy690, &&yy690, &&yy690, &&yy690, &&yy690, &&yy690, &&yy690,
				&&yy690, &&yy690, &&yy690, &&yy685, &&yy685, &&yy685, &&yy685, &&yy690,
				&&yy685, &&yy690, &&yy690, &&yy690, &&yy690, &&yy690, &&yy690, &&yy690,
				&&yy690, &&yy690, &&yy690, &&yy690, &&yy690, &&yy690, &&yy690, &&yy690,
				&&yy690, &&yy690, &&yy690, &&yy690, &&yy690, &&yy690, &&yy690, &&yy690,
				&&yy690, &&yy690, &&yy690, &&yy693, &&yy685, &&yy685, &&yy685, &&yy690,
				&&yy690, &&yy690, &&yy690, &&yy690, &&yy690, &&yy690, &&yy690, &&yy690,
				&&yy690, &&yy690, &&yy690, &&yy690, &&yy690, &&yy690, &&yy690, &&yy690,
				&&yy690, &&yy690, &&yy690, &&yy690, &&yy690, &&yy690, &&yy690, &&yy690,
				&&yy690, &&yy690, &&yy690, &&yy690, &&yy690, &&yy690, &&yy690, &&yy690,
				&&yy690, &&yy690, &&yy690, &&yy690, &&yy690, &&yy690, &&yy690, &&yy690,
				&&yy690, &&yy690, &&yy690, &&yy690, &&yy690, &&yy690, &&yy690, &&yy690,
				&&yy690, &&yy690, &&yy690, &&yy690, &&yy690, &&yy690, &&yy690, &&yy690,
				&&yy690, &&yy690, &&yy690, &&yy690, &&yy690, &&yy690, &&yy690, &&yy690,
				&&yy690, &&yy690, &&yy690, &&yy690, &&yy690, &&yy690, &&yy690, &&yy690,
				&&yy690, &&yy690, &&yy690, &&yy690, &&yy690, &&yy690, &&yy690, &&yy690,
				&&yy690, &&yy690, &&yy690, &&yy690, &&yy690, &&yy690, &&yy690, &&yy690,
				&&yy690, &&yy690, &&yy690, &&yy690, &&yy690, &&yy690, &&yy690, &&yy690,
				&&yy690, &&yy690, &&yy690, &&yy690, &&yy690, &&yy690, &&yy690, &&yy690,
				&&yy690, &&yy690, &&yy690, &&yy690, &&yy690, &&yy690, &&yy690, &&yy690,
				&&yy690, &&yy690, &&yy690, &&yy690, &&yy690, &&yy690, &&yy690, &&yy690,
				&&yy690, &&yy690, &&yy690, &&yy690, &&yy690, &&yy690, &&yy690, &&yy690
			};
			goto *yytarget[yych];
		}
yy687:
		YYDEBUG(687, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(688, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	BEGIN(ST_IN_SCRIPTING);
	return '`';
}
yy689:
		YYDEBUG(689, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '$') goto yy695;
		goto yy685;
yy690:
		YYDEBUG(690, *YYCURSOR);
		YYMARKER = ++YYCURSOR;
		YYFILL(3);
		yych = *YYCURSOR;
		YYDEBUG(691, *YYCURSOR);
		if (yybm[0+yych] & 128) {
			goto yy690;
		}
		if (yych == '-') goto yy697;
		if (yych <= '@') goto yy692;
		if (yych <= '[') goto yy699;
yy692:
		YYDEBUG(692, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	zend_copy_value(zendlval, (yytext+1), (yyleng-1));
	return T_VARIABLE;
}
yy693:
		YYDEBUG(693, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(694, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	yy_push_state(ST_LOOKING_FOR_VARNAME);
	return T_DOLLAR_OPEN_CURLY_BRACES;
}
yy695:
		YYDEBUG(695, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(696, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	Z_LVAL_P(zendlval) = (zend_long) '{';
	yy_push_state(ST_IN_SCRIPTING);
	yyless(1);
	return T_CURLY_OPEN;
}
yy697:
		YYDEBUG(697, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '>') goto yy701;
yy698:
		YYDEBUG(698, *YYCURSOR);
		YYCURSOR = YYMARKER;
		goto yy692;
yy699:
		YYDEBUG(699, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(700, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	yyless(yyleng - 1);
	yy_push_state(ST_VAR_OFFSET);
	zend_copy_value(zendlval, (yytext+1), (yyleng-1));
	return T_VARIABLE;
}
yy701:
		YYDEBUG(701, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= '_') {
			if (yych <= '@') goto yy698;
			if (yych <= 'Z') goto yy702;
			if (yych <= '^') goto yy698;
		} else {
			if (yych <= '`') goto yy698;
			if (yych <= 'z') goto yy702;
			if (yych <= '~') goto yy698;
		}
yy702:
		YYDEBUG(702, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(703, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	yyless(yyleng - 3);
	yy_push_state(ST_LOOKING_FOR_PROPERTY);
	zend_copy_value(zendlval, (yytext+1), (yyleng-1));
	return T_VARIABLE;
}
	}
/* *********************************** */
yyc_ST_DOUBLE_QUOTES:
	{
		static const unsigned char yybm[] = {
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128,   0,   0,   0,   0,   0,   0, 
			  0, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128,   0,   0,   0,   0, 128, 
			  0, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128,   0,   0,   0,   0, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
		};
		YYDEBUG(704, *YYCURSOR);
		YYFILL(2);
		yych = *YYCURSOR;
		if (yych <= '#') {
			if (yych == '"') goto yy708;
		} else {
			if (yych <= '$') goto yy710;
			if (yych == '{') goto yy711;
		}
		YYDEBUG(706, *YYCURSOR);
		++YYCURSOR;
yy707:
		YYDEBUG(707, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	if (GET_DOUBLE_QUOTES_SCANNED_LENGTH()) {
		YYCURSOR += GET_DOUBLE_QUOTES_SCANNED_LENGTH() - 1;
		SET_DOUBLE_QUOTES_SCANNED_LENGTH(0);

		goto double_quotes_scan_done;
	}

	if (YYCURSOR > YYLIMIT) {
		return 0;
	}
	if (yytext[0] == '\\' && YYCURSOR < YYLIMIT) {
		YYCURSOR++;
	}

	while (YYCURSOR < YYLIMIT) {
		switch (*YYCURSOR++) {
			case '"':
				break;
			case '$':
				if (IS_LABEL_START(*YYCURSOR) || *YYCURSOR == '{') {
					break;
				}
				continue;
			case '{':
				if (*YYCURSOR == '$') {
					break;
				}
				continue;
			case '\\':
				if (YYCURSOR < YYLIMIT) {
					YYCURSOR++;
				}
				/* fall through */
			default:
				continue;
		}

		YYCURSOR--;
		break;
	}

double_quotes_scan_done:
	yyleng = YYCURSOR - SCNG(yy_text);

	zend_scan_escape_string(zendlval, yytext, yyleng, '"');
	return T_ENCAPSED_AND_WHITESPACE;
}
yy708:
		YYDEBUG(708, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(709, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	BEGIN(ST_IN_SCRIPTING);
	return '"';
}
yy710:
		YYDEBUG(710, *YYCURSOR);
		yych = *++YYCURSOR;
		{
			static void *yytarget[256] = {
				&&yy707, &&yy707, &&yy707, &&yy707, &&yy707, &&yy707, &&yy707, &&yy707,
				&&yy707, &&yy707, &&yy707, &&yy707, &&yy707, &&yy707, &&yy707, &&yy707,
				&&yy707, &&yy707, &&yy707, &&yy707, &&yy707, &&yy707, &&yy707, &&yy707,
				&&yy707, &&yy707, &&yy707, &&yy707, &&yy707, &&yy707, &&yy707, &&yy707,
				&&yy707, &&yy707, &&yy707, &&yy707, &&yy707, &&yy707, &&yy707, &&yy707,
				&&yy707, &&yy707, &&yy707, &&yy707, &&yy707, &&yy707, &&yy707, &&yy707,
				&&yy707, &&yy707, &&yy707, &&yy707, &&yy707, &&yy707, &&yy707, &&yy707,
				&&yy707, &&yy707, &&yy707, &&yy707, &&yy707, &&yy707, &&yy707, &&yy707,
				&&yy707, &&yy712, &&yy712, &&yy712, &&yy712, &&yy712, &&yy712, &&yy712,
				&&yy712, &&yy712, &&yy712, &&yy712, &&yy712, &&yy712, &&yy712, &&yy712,
				&&yy712, &&yy712, &&yy712, &&yy712, &&yy712, &&yy712, &&yy712, &&yy712,
				&&yy712, &&yy712, &&yy712, &&yy707, &&yy707, &&yy707, &&yy707, &&yy712,
				&&yy707, &&yy712, &&yy712, &&yy712, &&yy712, &&yy712, &&yy712, &&yy712,
				&&yy712, &&yy712, &&yy712, &&yy712, &&yy712, &&yy712, &&yy712, &&yy712,
				&&yy712, &&yy712, &&yy712, &&yy712, &&yy712, &&yy712, &&yy712, &&yy712,
				&&yy712, &&yy712, &&yy712, &&yy715, &&yy707, &&yy707, &&yy707, &&yy712,
				&&yy712, &&yy712, &&yy712, &&yy712, &&yy712, &&yy712, &&yy712, &&yy712,
				&&yy712, &&yy712, &&yy712, &&yy712, &&yy712, &&yy712, &&yy712, &&yy712,
				&&yy712, &&yy712, &&yy712, &&yy712, &&yy712, &&yy712, &&yy712, &&yy712,
				&&yy712, &&yy712, &&yy712, &&yy712, &&yy712, &&yy712, &&yy712, &&yy712,
				&&yy712, &&yy712, &&yy712, &&yy712, &&yy712, &&yy712, &&yy712, &&yy712,
				&&yy712, &&yy712, &&yy712, &&yy712, &&yy712, &&yy712, &&yy712, &&yy712,
				&&yy712, &&yy712, &&yy712, &&yy712, &&yy712, &&yy712, &&yy712, &&yy712,
				&&yy712, &&yy712, &&yy712, &&yy712, &&yy712, &&yy712, &&yy712, &&yy712,
				&&yy712, &&yy712, &&yy712, &&yy712, &&yy712, &&yy712, &&yy712, &&yy712,
				&&yy712, &&yy712, &&yy712, &&yy712, &&yy712, &&yy712, &&yy712, &&yy712,
				&&yy712, &&yy712, &&yy712, &&yy712, &&yy712, &&yy712, &&yy712, &&yy712,
				&&yy712, &&yy712, &&yy712, &&yy712, &&yy712, &&yy712, &&yy712, &&yy712,
				&&yy712, &&yy712, &&yy712, &&yy712, &&yy712, &&yy712, &&yy712, &&yy712,
				&&yy712, &&yy712, &&yy712, &&yy712, &&yy712, &&yy712, &&yy712, &&yy712,
				&&yy712, &&yy712, &&yy712, &&yy712, &&yy712, &&yy712, &&yy712, &&yy712,
				&&yy712, &&yy712, &&yy712, &&yy712, &&yy712, &&yy712, &&yy712, &&yy712
			};
			goto *yytarget[yych];
		}
yy711:
		YYDEBUG(711, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '$') goto yy717;
		goto yy707;
yy712:
		YYDEBUG(712, *YYCURSOR);
		YYMARKER = ++YYCURSOR;
		YYFILL(3);
		yych = *YYCURSOR;
		YYDEBUG(713, *YYCURSOR);
		if (yybm[0+yych] & 128) {
			goto yy712;
		}
		if (yych == '-') goto yy719;
		if (yych <= '@') goto yy714;
		if (yych <= '[') goto yy721;
yy714:
		YYDEBUG(714, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	zend_copy_value(zendlval, (yytext+1), (yyleng-1));
	return T_VARIABLE;
}
yy715:
		YYDEBUG(715, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(716, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	yy_push_state(ST_LOOKING_FOR_VARNAME);
	return T_DOLLAR_OPEN_CURLY_BRACES;
}
yy717:
		YYDEBUG(717, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(718, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	Z_LVAL_P(zendlval) = (zend_long) '{';
	yy_push_state(ST_IN_SCRIPTING);
	yyless(1);
	return T_CURLY_OPEN;
}
yy719:
		YYDEBUG(719, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '>') goto yy723;
yy720:
		YYDEBUG(720, *YYCURSOR);
		YYCURSOR = YYMARKER;
		goto yy714;
yy721:
		YYDEBUG(721, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(722, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	yyless(yyleng - 1);
	yy_push_state(ST_VAR_OFFSET);
	zend_copy_value(zendlval, (yytext+1), (yyleng-1));
	return T_VARIABLE;
}
yy723:
		YYDEBUG(723, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= '_') {
			if (yych <= '@') goto yy720;
			if (yych <= 'Z') goto yy724;
			if (yych <= '^') goto yy720;
		} else {
			if (yych <= '`') goto yy720;
			if (yych <= 'z') goto yy724;
			if (yych <= '~') goto yy720;
		}
yy724:
		YYDEBUG(724, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(725, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	yyless(yyleng - 3);
	yy_push_state(ST_LOOKING_FOR_PROPERTY);
	zend_copy_value(zendlval, (yytext+1), (yyleng-1));
	return T_VARIABLE;
}
	}
/* *********************************** */
yyc_ST_HEREDOC:
	{
		static const unsigned char yybm[] = {
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128,   0,   0,   0,   0,   0,   0, 
			  0, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128,   0,   0,   0,   0, 128, 
			  0, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128,   0,   0,   0,   0, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
		};
		YYDEBUG(726, *YYCURSOR);
		YYFILL(2);
		yych = *YYCURSOR;
		if (yych == '$') goto yy730;
		if (yych == '{') goto yy731;
		YYDEBUG(728, *YYCURSOR);
		++YYCURSOR;
yy729:
		YYDEBUG(729, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	int newline = 0;

	zend_heredoc_label *heredoc_label = zend_ptr_stack_top(&SCNG(heredoc_label_stack));

	if (YYCURSOR > YYLIMIT) {
		return 0;
	}

	YYCURSOR--;

	while (YYCURSOR < YYLIMIT) {
		switch (*YYCURSOR++) {
			case '\r':
				if (*YYCURSOR == '\n') {
					YYCURSOR++;
				}
				/* fall through */
			case '\n':
				/* Check for ending label on the next line */
				if (IS_LABEL_START(*YYCURSOR) && heredoc_label->length < YYLIMIT - YYCURSOR && !memcmp(YYCURSOR, heredoc_label->label, heredoc_label->length)) {
					YYCTYPE *end = YYCURSOR + heredoc_label->length;

					if (*end == ';') {
						end++;
					}

					if (*end == '\n' || *end == '\r') {
						/* newline before label will be subtracted from returned text, but
						 * yyleng/yytext will include it, for zend_highlight/strip, tokenizer, etc. */
						if (YYCURSOR[-2] == '\r' && YYCURSOR[-1] == '\n') {
							newline = 2; /* Windows newline */
						} else {
							newline = 1;
						}

						CG(increment_lineno) = 1; /* For newline before label */
						BEGIN(ST_END_HEREDOC);

						goto heredoc_scan_done;
					}
				}
				continue;
			case '$':
				if (IS_LABEL_START(*YYCURSOR) || *YYCURSOR == '{') {
					break;
				}
				continue;
			case '{':
				if (*YYCURSOR == '$') {
					break;
				}
				continue;
			case '\\':
				if (YYCURSOR < YYLIMIT && *YYCURSOR != '\n' && *YYCURSOR != '\r') {
					YYCURSOR++;
				}
				/* fall through */
			default:
				continue;
		}

		YYCURSOR--;
		break;
	}

heredoc_scan_done:
	yyleng = YYCURSOR - SCNG(yy_text);

	zend_scan_escape_string(zendlval, yytext, yyleng - newline, 0);
	return T_ENCAPSED_AND_WHITESPACE;
}
yy730:
		YYDEBUG(730, *YYCURSOR);
		yych = *++YYCURSOR;
		{
			static void *yytarget[256] = {
				&&yy729, &&yy729, &&yy729, &&yy729, &&yy729, &&yy729, &&yy729, &&yy729,
				&&yy729, &&yy729, &&yy729, &&yy729, &&yy729, &&yy729, &&yy729, &&yy729,
				&&yy729, &&yy729, &&yy729, &&yy729, &&yy729, &&yy729, &&yy729, &&yy729,
				&&yy729, &&yy729, &&yy729, &&yy729, &&yy729, &&yy729, &&yy729, &&yy729,
				&&yy729, &&yy729, &&yy729, &&yy729, &&yy729, &&yy729, &&yy729, &&yy729,
				&&yy729, &&yy729, &&yy729, &&yy729, &&yy729, &&yy729, &&yy729, &&yy729,
				&&yy729, &&yy729, &&yy729, &&yy729, &&yy729, &&yy729, &&yy729, &&yy729,
				&&yy729, &&yy729, &&yy729, &&yy729, &&yy729, &&yy729, &&yy729, &&yy729,
				&&yy729, &&yy732, &&yy732, &&yy732, &&yy732, &&yy732, &&yy732, &&yy732,
				&&yy732, &&yy732, &&yy732, &&yy732, &&yy732, &&yy732, &&yy732, &&yy732,
				&&yy732, &&yy732, &&yy732, &&yy732, &&yy732, &&yy732, &&yy732, &&yy732,
				&&yy732, &&yy732, &&yy732, &&yy729, &&yy729, &&yy729, &&yy729, &&yy732,
				&&yy729, &&yy732, &&yy732, &&yy732, &&yy732, &&yy732, &&yy732, &&yy732,
				&&yy732, &&yy732, &&yy732, &&yy732, &&yy732, &&yy732, &&yy732, &&yy732,
				&&yy732, &&yy732, &&yy732, &&yy732, &&yy732, &&yy732, &&yy732, &&yy732,
				&&yy732, &&yy732, &&yy732, &&yy735, &&yy729, &&yy729, &&yy729, &&yy732,
				&&yy732, &&yy732, &&yy732, &&yy732, &&yy732, &&yy732, &&yy732, &&yy732,
				&&yy732, &&yy732, &&yy732, &&yy732, &&yy732, &&yy732, &&yy732, &&yy732,
				&&yy732, &&yy732, &&yy732, &&yy732, &&yy732, &&yy732, &&yy732, &&yy732,
				&&yy732, &&yy732, &&yy732, &&yy732, &&yy732, &&yy732, &&yy732, &&yy732,
				&&yy732, &&yy732, &&yy732, &&yy732, &&yy732, &&yy732, &&yy732, &&yy732,
				&&yy732, &&yy732, &&yy732, &&yy732, &&yy732, &&yy732, &&yy732, &&yy732,
				&&yy732, &&yy732, &&yy732, &&yy732, &&yy732, &&yy732, &&yy732, &&yy732,
				&&yy732, &&yy732, &&yy732, &&yy732, &&yy732, &&yy732, &&yy732, &&yy732,
				&&yy732, &&yy732, &&yy732, &&yy732, &&yy732, &&yy732, &&yy732, &&yy732,
				&&yy732, &&yy732, &&yy732, &&yy732, &&yy732, &&yy732, &&yy732, &&yy732,
				&&yy732, &&yy732, &&yy732, &&yy732, &&yy732, &&yy732, &&yy732, &&yy732,
				&&yy732, &&yy732, &&yy732, &&yy732, &&yy732, &&yy732, &&yy732, &&yy732,
				&&yy732, &&yy732, &&yy732, &&yy732, &&yy732, &&yy732, &&yy732, &&yy732,
				&&yy732, &&yy732, &&yy732, &&yy732, &&yy732, &&yy732, &&yy732, &&yy732,
				&&yy732, &&yy732, &&yy732, &&yy732, &&yy732, &&yy732, &&yy732, &&yy732,
				&&yy732, &&yy732, &&yy732, &&yy732, &&yy732, &&yy732, &&yy732, &&yy732
			};
			goto *yytarget[yych];
		}
yy731:
		YYDEBUG(731, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '$') goto yy737;
		goto yy729;
yy732:
		YYDEBUG(732, *YYCURSOR);
		YYMARKER = ++YYCURSOR;
		YYFILL(3);
		yych = *YYCURSOR;
		YYDEBUG(733, *YYCURSOR);
		if (yybm[0+yych] & 128) {
			goto yy732;
		}
		if (yych == '-') goto yy739;
		if (yych <= '@') goto yy734;
		if (yych <= '[') goto yy741;
yy734:
		YYDEBUG(734, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	zend_copy_value(zendlval, (yytext+1), (yyleng-1));
	return T_VARIABLE;
}
yy735:
		YYDEBUG(735, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(736, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	yy_push_state(ST_LOOKING_FOR_VARNAME);
	return T_DOLLAR_OPEN_CURLY_BRACES;
}
yy737:
		YYDEBUG(737, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(738, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	Z_LVAL_P(zendlval) = (zend_long) '{';
	yy_push_state(ST_IN_SCRIPTING);
	yyless(1);
	return T_CURLY_OPEN;
}
yy739:
		YYDEBUG(739, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '>') goto yy743;
yy740:
		YYDEBUG(740, *YYCURSOR);
		YYCURSOR = YYMARKER;
		goto yy734;
yy741:
		YYDEBUG(741, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(742, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	yyless(yyleng - 1);
	yy_push_state(ST_VAR_OFFSET);
	zend_copy_value(zendlval, (yytext+1), (yyleng-1));
	return T_VARIABLE;
}
yy743:
		YYDEBUG(743, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= '_') {
			if (yych <= '@') goto yy740;
			if (yych <= 'Z') goto yy744;
			if (yych <= '^') goto yy740;
		} else {
			if (yych <= '`') goto yy740;
			if (yych <= 'z') goto yy744;
			if (yych <= '~') goto yy740;
		}
yy744:
		YYDEBUG(744, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(745, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	yyless(yyleng - 3);
	yy_push_state(ST_LOOKING_FOR_PROPERTY);
	zend_copy_value(zendlval, (yytext+1), (yyleng-1));
	return T_VARIABLE;
}
	}
/* *********************************** */
yyc_ST_LOOKING_FOR_VARNAME:
	{
		static const unsigned char yybm[] = {
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128,   0,   0,   0,   0,   0,   0, 
			  0, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128,   0,   0,   0,   0, 128, 
			  0, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128,   0,   0,   0,   0, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
		};
		YYDEBUG(746, *YYCURSOR);
		YYFILL(2);
		yych = *YYCURSOR;
		if (yych <= '_') {
			if (yych <= '@') goto yy748;
			if (yych <= 'Z') goto yy750;
			if (yych >= '_') goto yy750;
		} else {
			if (yych <= '`') goto yy748;
			if (yych <= 'z') goto yy750;
			if (yych >= 0x7F) goto yy750;
		}
yy748:
		YYDEBUG(748, *YYCURSOR);
		++YYCURSOR;
yy749:
		YYDEBUG(749, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	yyless(0);
	yy_pop_state();
	yy_push_state(ST_IN_SCRIPTING);
	goto restart;
}
yy750:
		YYDEBUG(750, *YYCURSOR);
		yych = *(YYMARKER = ++YYCURSOR);
		{
			static void *yytarget[256] = {
				&&yy749, &&yy749, &&yy749, &&yy749, &&yy749, &&yy749, &&yy749, &&yy749,
				&&yy749, &&yy749, &&yy749, &&yy749, &&yy749, &&yy749, &&yy749, &&yy749,
				&&yy749, &&yy749, &&yy749, &&yy749, &&yy749, &&yy749, &&yy749, &&yy749,
				&&yy749, &&yy749, &&yy749, &&yy749, &&yy749, &&yy749, &&yy749, &&yy749,
				&&yy749, &&yy749, &&yy749, &&yy749, &&yy749, &&yy749, &&yy749, &&yy749,
				&&yy749, &&yy749, &&yy749, &&yy749, &&yy749, &&yy749, &&yy749, &&yy749,
				&&yy752, &&yy752, &&yy752, &&yy752, &&yy752, &&yy752, &&yy752, &&yy752,
				&&yy752, &&yy752, &&yy749, &&yy749, &&yy749, &&yy749, &&yy749, &&yy749,
				&&yy749, &&yy752, &&yy752, &&yy752, &&yy752, &&yy752, &&yy752, &&yy752,
				&&yy752, &&yy752, &&yy752, &&yy752, &&yy752, &&yy752, &&yy752, &&yy752,
				&&yy752, &&yy752, &&yy752, &&yy752, &&yy752, &&yy752, &&yy752, &&yy752,
				&&yy752, &&yy752, &&yy752, &&yy752, &&yy749, &&yy749, &&yy749, &&yy752,
				&&yy749, &&yy752, &&yy752, &&yy752, &&yy752, &&yy752, &&yy752, &&yy752,
				&&yy752, &&yy752, &&yy752, &&yy752, &&yy752, &&yy752, &&yy752, &&yy752,
				&&yy752, &&yy752, &&yy752, &&yy752, &&yy752, &&yy752, &&yy752, &&yy752,
				&&yy752, &&yy752, &&yy752, &&yy749, &&yy749, &&yy752, &&yy749, &&yy752,
				&&yy752, &&yy752, &&yy752, &&yy752, &&yy752, &&yy752, &&yy752, &&yy752,
				&&yy752, &&yy752, &&yy752, &&yy752, &&yy752, &&yy752, &&yy752, &&yy752,
				&&yy752, &&yy752, &&yy752, &&yy752, &&yy752, &&yy752, &&yy752, &&yy752,
				&&yy752, &&yy752, &&yy752, &&yy752, &&yy752, &&yy752, &&yy752, &&yy752,
				&&yy752, &&yy752, &&yy752, &&yy752, &&yy752, &&yy752, &&yy752, &&yy752,
				&&yy752, &&yy752, &&yy752, &&yy752, &&yy752, &&yy752, &&yy752, &&yy752,
				&&yy752, &&yy752, &&yy752, &&yy752, &&yy752, &&yy752, &&yy752, &&yy752,
				&&yy752, &&yy752, &&yy752, &&yy752, &&yy752, &&yy752, &&yy752, &&yy752,
				&&yy752, &&yy752, &&yy752, &&yy752, &&yy752, &&yy752, &&yy752, &&yy752,
				&&yy752, &&yy752, &&yy752, &&yy752, &&yy752, &&yy752, &&yy752, &&yy752,
				&&yy752, &&yy752, &&yy752, &&yy752, &&yy752, &&yy752, &&yy752, &&yy752,
				&&yy752, &&yy752, &&yy752, &&yy752, &&yy752, &&yy752, &&yy752, &&yy752,
				&&yy752, &&yy752, &&yy752, &&yy752, &&yy752, &&yy752, &&yy752, &&yy752,
				&&yy752, &&yy752, &&yy752, &&yy752, &&yy752, &&yy752, &&yy752, &&yy752,
				&&yy752, &&yy752, &&yy752, &&yy752, &&yy752, &&yy752, &&yy752, &&yy752,
				&&yy752, &&yy752, &&yy752, &&yy752, &&yy752, &&yy752, &&yy752, &&yy752
			};
			goto *yytarget[yych];
		}
yy751:
		YYDEBUG(751, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
yy752:
		YYDEBUG(752, *YYCURSOR);
		if (yybm[0+yych] & 128) {
			goto yy751;
		}
		if (yych <= '@') goto yy753;
		if (yych <= '[') goto yy754;
		if (yych == '}') goto yy754;
yy753:
		YYDEBUG(753, *YYCURSOR);
		YYCURSOR = YYMARKER;
		goto yy749;
yy754:
		YYDEBUG(754, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(755, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	yyless(yyleng - 1);
	zend_copy_value(zendlval, yytext, yyleng);
	yy_pop_state();
	yy_push_state(ST_IN_SCRIPTING);
	return T_STRING_VARNAME;
}
	}
/* *********************************** */
yyc_ST_VAR_OFFSET:
	{
		static const unsigned char yybm[] = {
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			240, 240, 176, 176, 176, 176, 176, 176, 
			176, 176,   0,   0,   0,   0,   0,   0, 
			  0, 160, 160, 160, 160, 160, 160,  32, 
			 32,  32,  32,  32,  32,  32,  32,  32, 
			 32,  32,  32,  32,  32,  32,  32,  32, 
			 32,  32,  32,   0,   0,   0,   0,  32, 
			  0, 160, 160, 160, 160, 160, 160,  32, 
			 32,  32,  32,  32,  32,  32,  32,  32, 
			 32,  32,  32,  32,  32,  32,  32,  32, 
			 32,  32,  32,   0,   0,   0,   0,  32, 
			 32,  32,  32,  32,  32,  32,  32,  32, 
			 32,  32,  32,  32,  32,  32,  32,  32, 
			 32,  32,  32,  32,  32,  32,  32,  32, 
			 32,  32,  32,  32,  32,  32,  32,  32, 
			 32,  32,  32,  32,  32,  32,  32,  32, 
			 32,  32,  32,  32,  32,  32,  32,  32, 
			 32,  32,  32,  32,  32,  32,  32,  32, 
			 32,  32,  32,  32,  32,  32,  32,  32, 
			 32,  32,  32,  32,  32,  32,  32,  32, 
			 32,  32,  32,  32,  32,  32,  32,  32, 
			 32,  32,  32,  32,  32,  32,  32,  32, 
			 32,  32,  32,  32,  32,  32,  32,  32, 
			 32,  32,  32,  32,  32,  32,  32,  32, 
			 32,  32,  32,  32,  32,  32,  32,  32, 
			 32,  32,  32,  32,  32,  32,  32,  32, 
			 32,  32,  32,  32,  32,  32,  32,  32, 
		};
		YYDEBUG(756, *YYCURSOR);
		YYFILL(3);
		yych = *YYCURSOR;
		{
			static void *yytarget[256] = {
				&&yy758, &&yy758, &&yy758, &&yy758, &&yy758, &&yy758, &&yy758, &&yy758,
				&&yy758, &&yy760, &&yy760, &&yy758, &&yy758, &&yy760, &&yy758, &&yy758,
				&&yy758, &&yy758, &&yy758, &&yy758, &&yy758, &&yy758, &&yy758, &&yy758,
				&&yy758, &&yy758, &&yy758, &&yy758, &&yy758, &&yy758, &&yy758, &&yy758,
				&&yy760, &&yy762, &&yy762, &&yy760, &&yy764, &&yy762, &&yy762, &&yy760,
				&&yy762, &&yy762, &&yy762, &&yy762, &&yy762, &&yy762, &&yy762, &&yy762,
				&&yy765, &&yy767, &&yy767, &&yy767, &&yy767, &&yy767, &&yy767, &&yy767,
				&&yy767, &&yy767, &&yy762, &&yy762, &&yy762, &&yy762, &&yy762, &&yy762,
				&&yy762, &&yy769, &&yy769, &&yy769, &&yy769, &&yy769, &&yy769, &&yy769,
				&&yy769, &&yy769, &&yy769, &&yy769, &&yy769, &&yy769, &&yy769, &&yy769,
				&&yy769, &&yy769, &&yy769, &&yy769, &&yy769, &&yy769, &&yy769, &&yy769,
				&&yy769, &&yy769, &&yy769, &&yy762, &&yy760, &&yy772, &&yy762, &&yy769,
				&&yy762, &&yy769, &&yy769, &&yy769, &&yy769, &&yy769, &&yy769, &&yy769,
				&&yy769, &&yy769, &&yy769, &&yy769, &&yy769, &&yy769, &&yy769, &&yy769,
				&&yy769, &&yy769, &&yy769, &&yy769, &&yy769, &&yy769, &&yy769, &&yy769,
				&&yy769, &&yy769, &&yy769, &&yy762, &&yy762, &&yy762, &&yy762, &&yy769,
				&&yy769, &&yy769, &&yy769, &&yy769, &&yy769, &&yy769, &&yy769, &&yy769,
				&&yy769, &&yy769, &&yy769, &&yy769, &&yy769, &&yy769, &&yy769, &&yy769,
				&&yy769, &&yy769, &&yy769, &&yy769, &&yy769, &&yy769, &&yy769, &&yy769,
				&&yy769, &&yy769, &&yy769, &&yy769, &&yy769, &&yy769, &&yy769, &&yy769,
				&&yy769, &&yy769, &&yy769, &&yy769, &&yy769, &&yy769, &&yy769, &&yy769,
				&&yy769, &&yy769, &&yy769, &&yy769, &&yy769, &&yy769, &&yy769, &&yy769,
				&&yy769, &&yy769, &&yy769, &&yy769, &&yy769, &&yy769, &&yy769, &&yy769,
				&&yy769, &&yy769, &&yy769, &&yy769, &&yy769, &&yy769, &&yy769, &&yy769,
				&&yy769, &&yy769, &&yy769, &&yy769, &&yy769, &&yy769, &&yy769, &&yy769,
				&&yy769, &&yy769, &&yy769, &&yy769, &&yy769, &&yy769, &&yy769, &&yy769,
				&&yy769, &&yy769, &&yy769, &&yy769, &&yy769, &&yy769, &&yy769, &&yy769,
				&&yy769, &&yy769, &&yy769, &&yy769, &&yy769, &&yy769, &&yy769, &&yy769,
				&&yy769, &&yy769, &&yy769, &&yy769, &&yy769, &&yy769, &&yy769, &&yy769,
				&&yy769, &&yy769, &&yy769, &&yy769, &&yy769, &&yy769, &&yy769, &&yy769,
				&&yy769, &&yy769, &&yy769, &&yy769, &&yy769, &&yy769, &&yy769, &&yy769,
				&&yy769, &&yy769, &&yy769, &&yy769, &&yy769, &&yy769, &&yy769, &&yy769
			};
			goto *yytarget[yych];
		}
yy758:
		YYDEBUG(758, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(759, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	if (YYCURSOR > YYLIMIT) {
		return 0;
	}

	zend_error(E_COMPILE_WARNING,"Unexpected character in input:  '%c' (ASCII=%d) state=%d", yytext[0], yytext[0], YYSTATE);
	goto restart;
}
yy760:
		YYDEBUG(760, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(761, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	/* Invalid rule to return a more explicit parse error with proper line number */
	yyless(0);
	yy_pop_state();
	ZVAL_NULL(zendlval);
	return T_ENCAPSED_AND_WHITESPACE;
}
yy762:
		YYDEBUG(762, *YYCURSOR);
		++YYCURSOR;
yy763:
		YYDEBUG(763, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	/* Only '[' can be valid, but returning other tokens will allow a more explicit parse error */
	return yytext[0];
}
yy764:
		YYDEBUG(764, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= '_') {
			if (yych <= '@') goto yy763;
			if (yych <= 'Z') goto yy774;
			if (yych <= '^') goto yy763;
			goto yy774;
		} else {
			if (yych <= '`') goto yy763;
			if (yych <= 'z') goto yy774;
			if (yych <= '~') goto yy763;
			goto yy774;
		}
yy765:
		YYDEBUG(765, *YYCURSOR);
		yych = *(YYMARKER = ++YYCURSOR);
		{
			static void *yytarget[256] = {
				&&yy766, &&yy766, &&yy766, &&yy766, &&yy766, &&yy766, &&yy766, &&yy766,
				&&yy766, &&yy766, &&yy766, &&yy766, &&yy766, &&yy766, &&yy766, &&yy766,
				&&yy766, &&yy766, &&yy766, &&yy766, &&yy766, &&yy766, &&yy766, &&yy766,
				&&yy766, &&yy766, &&yy766, &&yy766, &&yy766, &&yy766, &&yy766, &&yy766,
				&&yy766, &&yy766, &&yy766, &&yy766, &&yy766, &&yy766, &&yy766, &&yy766,
				&&yy766, &&yy766, &&yy766, &&yy766, &&yy766, &&yy766, &&yy766, &&yy766,
				&&yy777, &&yy777, &&yy777, &&yy777, &&yy777, &&yy777, &&yy777, &&yy777,
				&&yy777, &&yy777, &&yy766, &&yy766, &&yy766, &&yy766, &&yy766, &&yy766,
				&&yy766, &&yy766, &&yy780, &&yy766, &&yy766, &&yy766, &&yy766, &&yy766,
				&&yy766, &&yy766, &&yy766, &&yy766, &&yy766, &&yy766, &&yy766, &&yy766,
				&&yy766, &&yy766, &&yy766, &&yy766, &&yy766, &&yy766, &&yy766, &&yy766,
				&&yy782, &&yy766, &&yy766, &&yy766, &&yy766, &&yy766, &&yy766, &&yy766,
				&&yy766, &&yy766, &&yy780, &&yy766, &&yy766, &&yy766, &&yy766, &&yy766,
				&&yy766, &&yy766, &&yy766, &&yy766, &&yy766, &&yy766, &&yy766, &&yy766,
				&&yy766, &&yy766, &&yy766, &&yy766, &&yy766, &&yy766, &&yy766, &&yy766,
				&&yy782, &&yy766, &&yy766, &&yy766, &&yy766, &&yy766, &&yy766, &&yy766,
				&&yy766, &&yy766, &&yy766, &&yy766, &&yy766, &&yy766, &&yy766, &&yy766,
				&&yy766, &&yy766, &&yy766, &&yy766, &&yy766, &&yy766, &&yy766, &&yy766,
				&&yy766, &&yy766, &&yy766, &&yy766, &&yy766, &&yy766, &&yy766, &&yy766,
				&&yy766, &&yy766, &&yy766, &&yy766, &&yy766, &&yy766, &&yy766, &&yy766,
				&&yy766, &&yy766, &&yy766, &&yy766, &&yy766, &&yy766, &&yy766, &&yy766,
				&&yy766, &&yy766, &&yy766, &&yy766, &&yy766, &&yy766, &&yy766, &&yy766,
				&&yy766, &&yy766, &&yy766, &&yy766, &&yy766, &&yy766, &&yy766, &&yy766,
				&&yy766, &&yy766, &&yy766, &&yy766, &&yy766, &&yy766, &&yy766, &&yy766,
				&&yy766, &&yy766, &&yy766, &&yy766, &&yy766, &&yy766, &&yy766, &&yy766,
				&&yy766, &&yy766, &&yy766, &&yy766, &&yy766, &&yy766, &&yy766, &&yy766,
				&&yy766, &&yy766, &&yy766, &&yy766, &&yy766, &&yy766, &&yy766, &&yy766,
				&&yy766, &&yy766, &&yy766, &&yy766, &&yy766, &&yy766, &&yy766, &&yy766,
				&&yy766, &&yy766, &&yy766, &&yy766, &&yy766, &&yy766, &&yy766, &&yy766,
				&&yy766, &&yy766, &&yy766, &&yy766, &&yy766, &&yy766, &&yy766, &&yy766,
				&&yy766, &&yy766, &&yy766, &&yy766, &&yy766, &&yy766, &&yy766, &&yy766,
				&&yy766, &&yy766, &&yy766, &&yy766, &&yy766, &&yy766, &&yy766, &&yy766
			};
			goto *yytarget[yych];
		}
yy766:
		YYDEBUG(766, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{ /* Offset could be treated as a long */
	if (yyleng < MAX_LENGTH_OF_LONG - 1 || (yyleng == MAX_LENGTH_OF_LONG - 1 && strcmp(yytext, long_min_digits) < 0)) {
		char *end;
		errno = 0;
		ZVAL_LONG(zendlval, ZEND_STRTOL(yytext, &end, 10));
		if (errno == ERANGE) {
			goto string;
		}
		ZEND_ASSERT(end == yytext + yyleng);
	} else {
string:
		ZVAL_STRINGL(zendlval, yytext, yyleng);
	}
	return T_NUM_STRING;
}
yy767:
		YYDEBUG(767, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(768, *YYCURSOR);
		if (yybm[0+yych] & 16) {
			goto yy767;
		}
		goto yy766;
yy769:
		YYDEBUG(769, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(770, *YYCURSOR);
		if (yybm[0+yych] & 32) {
			goto yy769;
		}
		YYDEBUG(771, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	zend_copy_value(zendlval, yytext, yyleng);
	return T_STRING;
}
yy772:
		YYDEBUG(772, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(773, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	yy_pop_state();
	return ']';
}
yy774:
		YYDEBUG(774, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(775, *YYCURSOR);
		{
			static void *yytarget[256] = {
				&&yy776, &&yy776, &&yy776, &&yy776, &&yy776, &&yy776, &&yy776, &&yy776,
				&&yy776, &&yy776, &&yy776, &&yy776, &&yy776, &&yy776, &&yy776, &&yy776,
				&&yy776, &&yy776, &&yy776, &&yy776, &&yy776, &&yy776, &&yy776, &&yy776,
				&&yy776, &&yy776, &&yy776, &&yy776, &&yy776, &&yy776, &&yy776, &&yy776,
				&&yy776, &&yy776, &&yy776, &&yy776, &&yy776, &&yy776, &&yy776, &&yy776,
				&&yy776, &&yy776, &&yy776, &&yy776, &&yy776, &&yy776, &&yy776, &&yy776,
				&&yy774, &&yy774, &&yy774, &&yy774, &&yy774, &&yy774, &&yy774, &&yy774,
				&&yy774, &&yy774, &&yy776, &&yy776, &&yy776, &&yy776, &&yy776, &&yy776,
				&&yy776, &&yy774, &&yy774, &&yy774, &&yy774, &&yy774, &&yy774, &&yy774,
				&&yy774, &&yy774, &&yy774, &&yy774, &&yy774, &&yy774, &&yy774, &&yy774,
				&&yy774, &&yy774, &&yy774, &&yy774, &&yy774, &&yy774, &&yy774, &&yy774,
				&&yy774, &&yy774, &&yy774, &&yy776, &&yy776, &&yy776, &&yy776, &&yy774,
				&&yy776, &&yy774, &&yy774, &&yy774, &&yy774, &&yy774, &&yy774, &&yy774,
				&&yy774, &&yy774, &&yy774, &&yy774, &&yy774, &&yy774, &&yy774, &&yy774,
				&&yy774, &&yy774, &&yy774, &&yy774, &&yy774, &&yy774, &&yy774, &&yy774,
				&&yy774, &&yy774, &&yy774, &&yy776, &&yy776, &&yy776, &&yy776, &&yy774,
				&&yy774, &&yy774, &&yy774, &&yy774, &&yy774, &&yy774, &&yy774, &&yy774,
				&&yy774, &&yy774, &&yy774, &&yy774, &&yy774, &&yy774, &&yy774, &&yy774,
				&&yy774, &&yy774, &&yy774, &&yy774, &&yy774, &&yy774, &&yy774, &&yy774,
				&&yy774, &&yy774, &&yy774, &&yy774, &&yy774, &&yy774, &&yy774, &&yy774,
				&&yy774, &&yy774, &&yy774, &&yy774, &&yy774, &&yy774, &&yy774, &&yy774,
				&&yy774, &&yy774, &&yy774, &&yy774, &&yy774, &&yy774, &&yy774, &&yy774,
				&&yy774, &&yy774, &&yy774, &&yy774, &&yy774, &&yy774, &&yy774, &&yy774,
				&&yy774, &&yy774, &&yy774, &&yy774, &&yy774, &&yy774, &&yy774, &&yy774,
				&&yy774, &&yy774, &&yy774, &&yy774, &&yy774, &&yy774, &&yy774, &&yy774,
				&&yy774, &&yy774, &&yy774, &&yy774, &&yy774, &&yy774, &&yy774, &&yy774,
				&&yy774, &&yy774, &&yy774, &&yy774, &&yy774, &&yy774, &&yy774, &&yy774,
				&&yy774, &&yy774, &&yy774, &&yy774, &&yy774, &&yy774, &&yy774, &&yy774,
				&&yy774, &&yy774, &&yy774, &&yy774, &&yy774, &&yy774, &&yy774, &&yy774,
				&&yy774, &&yy774, &&yy774, &&yy774, &&yy774, &&yy774, &&yy774, &&yy774,
				&&yy774, &&yy774, &&yy774, &&yy774, &&yy774, &&yy774, &&yy774, &&yy774,
				&&yy774, &&yy774, &&yy774, &&yy774, &&yy774, &&yy774, &&yy774, &&yy774
			};
			goto *yytarget[yych];
		}
yy776:
		YYDEBUG(776, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	zend_copy_value(zendlval, (yytext+1), (yyleng-1));
	return T_VARIABLE;
}
yy777:
		YYDEBUG(777, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(778, *YYCURSOR);
		if (yych <= '/') goto yy779;
		if (yych <= '9') goto yy777;
yy779:
		YYDEBUG(779, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{ /* Offset must be treated as a string */
	ZVAL_STRINGL(zendlval, yytext, yyleng);
	return T_NUM_STRING;
}
yy780:
		YYDEBUG(780, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yybm[0+yych] & 64) {
			goto yy783;
		}
yy781:
		YYDEBUG(781, *YYCURSOR);
		YYCURSOR = YYMARKER;
		goto yy766;
yy782:
		YYDEBUG(782, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yybm[0+yych] & 128) {
			goto yy785;
		}
		goto yy781;
yy783:
		YYDEBUG(783, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(784, *YYCURSOR);
		if (yybm[0+yych] & 64) {
			goto yy783;
		}
		goto yy779;
yy785:
		YYDEBUG(785, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(786, *YYCURSOR);
		if (yybm[0+yych] & 128) {
			goto yy785;
		}
		goto yy779;
	}
/* *********************************** */
yyc_INITIAL:
	YYDEBUG(787, *YYCURSOR);
	YYFILL(7);
	yych = *YYCURSOR;
	if (yych == '<') goto yy791;
	YYDEBUG(789, *YYCURSOR);
	++YYCURSOR;
yy790:
	YYDEBUG(790, *YYCURSOR);
	yyleng = YYCURSOR - SCNG(yy_text);
	{
	if (YYCURSOR > YYLIMIT) {
		return 0;
	}

inline_char_handler:

	while (1) {
		YYCTYPE *ptr = memchr(YYCURSOR, '<', YYLIMIT - YYCURSOR);

		YYCURSOR = ptr ? ptr + 1 : YYLIMIT;

		if (YYCURSOR >= YYLIMIT) {
			break;
		}

		if (*YYCURSOR == '?') {
			if (CG(short_tags) || !strncasecmp((char*)YYCURSOR + 1, "php", 3) || (*(YYCURSOR + 1) == '=')) { /* Assume [ \t\n\r] follows "php" */

				YYCURSOR--;
				break;
			}
		}
	}

	yyleng = YYCURSOR - SCNG(yy_text);

	if (SCNG(output_filter)) {
		size_t readsize;
		char *s = NULL;
		size_t sz = 0;
		// TODO: avoid reallocation ???
		readsize = SCNG(output_filter)((unsigned char **)&s, &sz, (unsigned char *)yytext, (size_t)yyleng);
		ZVAL_STRINGL(zendlval, s, sz);
		efree(s);
		if (readsize < yyleng) {
			yyless(readsize);
		}
	} else {
	  ZVAL_STRINGL(zendlval, yytext, yyleng);
	}
	HANDLE_NEWLINES(yytext, yyleng);
	return T_INLINE_HTML;
}
yy791:
	YYDEBUG(791, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych != '?') goto yy790;
	YYDEBUG(792, *YYCURSOR);
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'O') {
		if (yych == '=') goto yy794;
	} else {
		if (yych <= 'P') goto yy796;
		if (yych == 'p') goto yy796;
	}
yy793:
	YYDEBUG(793, *YYCURSOR);
	yyleng = YYCURSOR - SCNG(yy_text);
	{
	if (CG(short_tags)) {
		BEGIN(ST_IN_SCRIPTING);
		return T_OPEN_TAG;
	} else {
		goto inline_char_handler;
	}
}
yy794:
	YYDEBUG(794, *YYCURSOR);
	++YYCURSOR;
	YYDEBUG(795, *YYCURSOR);
	yyleng = YYCURSOR - SCNG(yy_text);
	{
	BEGIN(ST_IN_SCRIPTING);
	return T_OPEN_TAG_WITH_ECHO;
}
yy796:
	YYDEBUG(796, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'H') goto yy798;
	if (yych == 'h') goto yy798;
yy797:
	YYDEBUG(797, *YYCURSOR);
	YYCURSOR = YYMARKER;
	goto yy793;
yy798:
	YYDEBUG(798, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'P') goto yy799;
	if (yych != 'p') goto yy797;
yy799:
	YYDEBUG(799, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '\f') {
		if (yych <= 0x08) goto yy797;
		if (yych >= '\v') goto yy797;
	} else {
		if (yych <= '\r') goto yy802;
		if (yych != ' ') goto yy797;
	}
yy800:
	YYDEBUG(800, *YYCURSOR);
	++YYCURSOR;
yy801:
	YYDEBUG(801, *YYCURSOR);
	yyleng = YYCURSOR - SCNG(yy_text);
	{
	HANDLE_NEWLINE(yytext[yyleng-1]);
	BEGIN(ST_IN_SCRIPTING);
	return T_OPEN_TAG;
}
yy802:
	YYDEBUG(802, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == '\n') goto yy800;
	goto yy801;
/* *********************************** */
yyc_ST_END_HEREDOC:
	YYDEBUG(803, *YYCURSOR);
	YYFILL(1);
	yych = *YYCURSOR;
	YYDEBUG(805, *YYCURSOR);
	++YYCURSOR;
	YYDEBUG(806, *YYCURSOR);
	yyleng = YYCURSOR - SCNG(yy_text);
	{
	zend_heredoc_label *heredoc_label = zend_ptr_stack_pop(&SCNG(heredoc_label_stack));

	YYCURSOR += heredoc_label->length - 1;
	yyleng = heredoc_label->length;

	heredoc_label_dtor(heredoc_label);
	efree(heredoc_label);

	BEGIN(ST_IN_SCRIPTING);
	return T_END_HEREDOC;
}
/* *********************************** */
yyc_ST_NOWDOC:
	YYDEBUG(807, *YYCURSOR);
	YYFILL(1);
	yych = *YYCURSOR;
	YYDEBUG(809, *YYCURSOR);
	++YYCURSOR;
	YYDEBUG(810, *YYCURSOR);
	yyleng = YYCURSOR - SCNG(yy_text);
	{
	int newline = 0;

	zend_heredoc_label *heredoc_label = zend_ptr_stack_top(&SCNG(heredoc_label_stack));

	if (YYCURSOR > YYLIMIT) {
		return 0;
	}

	YYCURSOR--;

	while (YYCURSOR < YYLIMIT) {
		switch (*YYCURSOR++) {
			case '\r':
				if (*YYCURSOR == '\n') {
					YYCURSOR++;
				}
				/* fall through */
			case '\n':
				/* Check for ending label on the next line */
				if (IS_LABEL_START(*YYCURSOR) && heredoc_label->length < YYLIMIT - YYCURSOR && !memcmp(YYCURSOR, heredoc_label->label, heredoc_label->length)) {
					YYCTYPE *end = YYCURSOR + heredoc_label->length;

					if (*end == ';') {
						end++;
					}

					if (*end == '\n' || *end == '\r') {
						/* newline before label will be subtracted from returned text, but
						 * yyleng/yytext will include it, for zend_highlight/strip, tokenizer, etc. */
						if (YYCURSOR[-2] == '\r' && YYCURSOR[-1] == '\n') {
							newline = 2; /* Windows newline */
						} else {
							newline = 1;
						}

						CG(increment_lineno) = 1; /* For newline before label */
						BEGIN(ST_END_HEREDOC);

						goto nowdoc_scan_done;
					}
				}
				/* fall through */
			default:
				continue;
		}
	}

nowdoc_scan_done:
	yyleng = YYCURSOR - SCNG(yy_text);

	zend_copy_value(zendlval, yytext, yyleng - newline);
	HANDLE_NEWLINES(yytext, yyleng - newline);
	return T_ENCAPSED_AND_WHITESPACE;
}
}

}
real_world/php20150211_zend_language_scanner.igcd--flex-syntax--case-inverted.re:1095:12: warning: escape has no effect: '\[' [-Wuseless-escape]
real_world/php20150211_zend_language_scanner.igcd--flex-syntax--case-inverted.re:1476:19: warning: escape has no effect: '\*' [-Wuseless-escape]
real_world/php20150211_zend_language_scanner.igcd--flex-syntax--case-inverted.re:1480:19: warning: escape has no effect: '\*' [-Wuseless-escape]
real_world/php20150211_zend_language_scanner.igcd--flex-syntax--case-inverted.re:2358:2: warning: looks like you use hardcoded numbers instead of autogenerated condition names: better add '/*!types:re2c*/' directive or '-t, --type-header' option and don't rely on fixed condition order. [-Wcondition-order]
