/* util.c generated by valac 0.40.4, the Vala compiler
 * generated from util.vala, do not modify */

/* Copyright 2016 Software Freedom Conservancy Inc.
 *
 * This software is licensed under the GNU Lesser General Public License
 * (version 2.1 or later).  See the COPYING file in this distribution.
 */
/* SingletonCollection is a read-only collection designed to hold exactly one item in it.  This*/
/* is far more efficient than creating a dummy collection (such as ArrayList) merely to pass around*/
/* a single item, particularly for signals which require Iterables and Collections.*/
/**/
/* This collection cannot be used to store null.*/


#include <glib.h>
#include <glib-object.h>
#include <gee.h>
#include <stdlib.h>
#include <string.h>
#include <float.h>
#include <math.h>
#include <gobject/gvaluecollector.h>


#define TYPE_SINGLETON_COLLECTION (singleton_collection_get_type ())
#define SINGLETON_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SINGLETON_COLLECTION, SingletonCollection))
#define SINGLETON_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SINGLETON_COLLECTION, SingletonCollectionClass))
#define IS_SINGLETON_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SINGLETON_COLLECTION))
#define IS_SINGLETON_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SINGLETON_COLLECTION))
#define SINGLETON_COLLECTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SINGLETON_COLLECTION, SingletonCollectionClass))

typedef struct _SingletonCollection SingletonCollection;
typedef struct _SingletonCollectionClass SingletonCollectionClass;
typedef struct _SingletonCollectionPrivate SingletonCollectionPrivate;
enum  {
	SINGLETON_COLLECTION_0_PROPERTY,
	SINGLETON_COLLECTION_G_TYPE,
	SINGLETON_COLLECTION_G_DUP_FUNC,
	SINGLETON_COLLECTION_G_DESTROY_FUNC,
	SINGLETON_COLLECTION_READ_ONLY_PROPERTY,
	SINGLETON_COLLECTION_SIZE_PROPERTY,
	SINGLETON_COLLECTION_NUM_PROPERTIES
};
static GParamSpec* singleton_collection_properties[SINGLETON_COLLECTION_NUM_PROPERTIES];
#define _g_destroy_func0(var) (((var == NULL) || (g_destroy_func == NULL)) ? NULL : (var = (g_destroy_func (var), NULL)))

#define SINGLETON_COLLECTION_TYPE_SINGLETON_ITERATOR (singleton_collection_singleton_iterator_get_type ())
#define SINGLETON_COLLECTION_SINGLETON_ITERATOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SINGLETON_COLLECTION_TYPE_SINGLETON_ITERATOR, SingletonCollectionSingletonIterator))
#define SINGLETON_COLLECTION_SINGLETON_ITERATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SINGLETON_COLLECTION_TYPE_SINGLETON_ITERATOR, SingletonCollectionSingletonIteratorClass))
#define SINGLETON_COLLECTION_IS_SINGLETON_ITERATOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SINGLETON_COLLECTION_TYPE_SINGLETON_ITERATOR))
#define SINGLETON_COLLECTION_IS_SINGLETON_ITERATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SINGLETON_COLLECTION_TYPE_SINGLETON_ITERATOR))
#define SINGLETON_COLLECTION_SINGLETON_ITERATOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SINGLETON_COLLECTION_TYPE_SINGLETON_ITERATOR, SingletonCollectionSingletonIteratorClass))

typedef struct _SingletonCollectionSingletonIterator SingletonCollectionSingletonIterator;
typedef struct _SingletonCollectionSingletonIteratorClass SingletonCollectionSingletonIteratorClass;
typedef struct _SingletonCollectionSingletonIteratorPrivate SingletonCollectionSingletonIteratorPrivate;
enum  {
	SINGLETON_COLLECTION_SINGLETON_ITERATOR_0_PROPERTY,
	SINGLETON_COLLECTION_SINGLETON_ITERATOR_G_TYPE,
	SINGLETON_COLLECTION_SINGLETON_ITERATOR_G_DUP_FUNC,
	SINGLETON_COLLECTION_SINGLETON_ITERATOR_G_DESTROY_FUNC,
	SINGLETON_COLLECTION_SINGLETON_ITERATOR_READ_ONLY_PROPERTY,
	SINGLETON_COLLECTION_SINGLETON_ITERATOR_VALID_PROPERTY,
	SINGLETON_COLLECTION_SINGLETON_ITERATOR_NUM_PROPERTIES
};
static GParamSpec* singleton_collection_singleton_iterator_properties[SINGLETON_COLLECTION_SINGLETON_ITERATOR_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define TYPE_MARKER (marker_get_type ())
#define MARKER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MARKER, Marker))
#define IS_MARKER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MARKER))
#define MARKER_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), TYPE_MARKER, MarkerIface))

typedef struct _Marker Marker;
typedef struct _MarkerIface MarkerIface;

#define TYPE_DATA_OBJECT (data_object_get_type ())
#define DATA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DATA_OBJECT, DataObject))
#define DATA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DATA_OBJECT, DataObjectClass))
#define IS_DATA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DATA_OBJECT))
#define IS_DATA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DATA_OBJECT))
#define DATA_OBJECT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DATA_OBJECT, DataObjectClass))

typedef struct _DataObject DataObject;
typedef struct _DataObjectClass DataObjectClass;

#define TYPE_UNKNOWN_TOTAL_MONITOR (unknown_total_monitor_get_type ())
#define UNKNOWN_TOTAL_MONITOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_UNKNOWN_TOTAL_MONITOR, UnknownTotalMonitor))
#define UNKNOWN_TOTAL_MONITOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_UNKNOWN_TOTAL_MONITOR, UnknownTotalMonitorClass))
#define IS_UNKNOWN_TOTAL_MONITOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_UNKNOWN_TOTAL_MONITOR))
#define IS_UNKNOWN_TOTAL_MONITOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_UNKNOWN_TOTAL_MONITOR))
#define UNKNOWN_TOTAL_MONITOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_UNKNOWN_TOTAL_MONITOR, UnknownTotalMonitorClass))

typedef struct _UnknownTotalMonitor UnknownTotalMonitor;
typedef struct _UnknownTotalMonitorClass UnknownTotalMonitorClass;
typedef struct _UnknownTotalMonitorPrivate UnknownTotalMonitorPrivate;
typedef struct _ParamSpecUnknownTotalMonitor ParamSpecUnknownTotalMonitor;

#define TYPE_AGGREGATE_PROGRESS_MONITOR (aggregate_progress_monitor_get_type ())
#define AGGREGATE_PROGRESS_MONITOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_AGGREGATE_PROGRESS_MONITOR, AggregateProgressMonitor))
#define AGGREGATE_PROGRESS_MONITOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_AGGREGATE_PROGRESS_MONITOR, AggregateProgressMonitorClass))
#define IS_AGGREGATE_PROGRESS_MONITOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_AGGREGATE_PROGRESS_MONITOR))
#define IS_AGGREGATE_PROGRESS_MONITOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_AGGREGATE_PROGRESS_MONITOR))
#define AGGREGATE_PROGRESS_MONITOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_AGGREGATE_PROGRESS_MONITOR, AggregateProgressMonitorClass))

typedef struct _AggregateProgressMonitor AggregateProgressMonitor;
typedef struct _AggregateProgressMonitorClass AggregateProgressMonitorClass;
typedef struct _AggregateProgressMonitorPrivate AggregateProgressMonitorPrivate;
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _ParamSpecAggregateProgressMonitor ParamSpecAggregateProgressMonitor;

struct _SingletonCollection {
	GeeAbstractCollection parent_instance;
	SingletonCollectionPrivate * priv;
};

struct _SingletonCollectionClass {
	GeeAbstractCollectionClass parent_class;
};

struct _SingletonCollectionPrivate {
	GType g_type;
	GBoxedCopyFunc g_dup_func;
	GDestroyNotify g_destroy_func;
	gpointer object;
};

struct _SingletonCollectionSingletonIterator {
	GObject parent_instance;
	SingletonCollectionSingletonIteratorPrivate * priv;
};

struct _SingletonCollectionSingletonIteratorClass {
	GObjectClass parent_class;
};

struct _SingletonCollectionSingletonIteratorPrivate {
	GType g_type;
	GBoxedCopyFunc g_dup_func;
	GDestroyNotify g_destroy_func;
	SingletonCollection* c;
	gboolean done;
	gpointer current;
};

struct _MarkerIface {
	GTypeInterface parent_iface;
	void (*mark) (Marker* self, DataObject* object);
	void (*unmark) (Marker* self, DataObject* object);
	gboolean (*toggle) (Marker* self, DataObject* object);
	void (*mark_many) (Marker* self, GeeCollection* list);
	void (*unmark_many) (Marker* self, GeeCollection* list);
	void (*mark_all) (Marker* self);
	gint (*get_count) (Marker* self);
	GeeCollection* (*get_all) (Marker* self);
};

typedef gboolean (*MarkedAction) (DataObject* object, GObject* user, void* user_data);
typedef gboolean (*ProgressMonitor) (guint64 current, guint64 total, gboolean do_event_loop, void* user_data);
struct _UnknownTotalMonitor {
	GTypeInstance parent_instance;
	volatile int ref_count;
	UnknownTotalMonitorPrivate * priv;
};

struct _UnknownTotalMonitorClass {
	GTypeClass parent_class;
	void (*finalize) (UnknownTotalMonitor *self);
};

struct _UnknownTotalMonitorPrivate {
	guint64 total;
	ProgressMonitor wrapped_monitor;
	gpointer wrapped_monitor_target;
};

struct _ParamSpecUnknownTotalMonitor {
	GParamSpec parent_instance;
};

struct _AggregateProgressMonitor {
	GTypeInstance parent_instance;
	volatile int ref_count;
	AggregateProgressMonitorPrivate * priv;
};

struct _AggregateProgressMonitorClass {
	GTypeClass parent_class;
	void (*finalize) (AggregateProgressMonitor *self);
};

struct _AggregateProgressMonitorPrivate {
	guint64 grand_total;
	ProgressMonitor wrapped_monitor;
	gpointer wrapped_monitor_target;
	guint64 aggregate_count;
	guint64 last_count;
};

struct _ParamSpecAggregateProgressMonitor {
	GParamSpec parent_instance;
};


static gpointer singleton_collection_parent_class = NULL;
static gpointer singleton_collection_singleton_iterator_parent_class = NULL;
static GeeTraversableIface * singleton_collection_singleton_iterator_gee_traversable_parent_iface = NULL;
static GeeIteratorIface * singleton_collection_singleton_iterator_gee_iterator_parent_iface = NULL;
static gpointer unknown_total_monitor_parent_class = NULL;
static gpointer aggregate_progress_monitor_parent_class = NULL;

GType singleton_collection_get_type (void) G_GNUC_CONST;
#define SINGLETON_COLLECTION_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_SINGLETON_COLLECTION, SingletonCollectionPrivate))
SingletonCollection* singleton_collection_new (GType g_type,
                                               GBoxedCopyFunc g_dup_func,
                                               GDestroyNotify g_destroy_func,
                                               gconstpointer object);
SingletonCollection* singleton_collection_construct (GType object_type,
                                                     GType g_type,
                                                     GBoxedCopyFunc g_dup_func,
                                                     GDestroyNotify g_destroy_func,
                                                     gconstpointer object);
static gboolean singleton_collection_real_add (GeeAbstractCollection* base,
                                        gconstpointer object);
static void singleton_collection_real_clear (GeeAbstractCollection* base);
static gboolean singleton_collection_real_contains (GeeAbstractCollection* base,
                                             gconstpointer object);
static GeeIterator* singleton_collection_real_iterator (GeeAbstractCollection* base);
static SingletonCollectionSingletonIterator* singleton_collection_singleton_iterator_new (GType g_type,
                                                                                   GBoxedCopyFunc g_dup_func,
                                                                                   GDestroyNotify g_destroy_func,
                                                                                   SingletonCollection* c);
static SingletonCollectionSingletonIterator* singleton_collection_singleton_iterator_construct (GType object_type,
                                                                                         GType g_type,
                                                                                         GBoxedCopyFunc g_dup_func,
                                                                                         GDestroyNotify g_destroy_func,
                                                                                         SingletonCollection* c);
static GType singleton_collection_singleton_iterator_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
static gboolean singleton_collection_real_remove (GeeAbstractCollection* base,
                                           gconstpointer item);
#define SINGLETON_COLLECTION_SINGLETON_ITERATOR_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), SINGLETON_COLLECTION_TYPE_SINGLETON_ITERATOR, SingletonCollectionSingletonIteratorPrivate))
static gboolean singleton_collection_singleton_iterator_real_foreach (GeeTraversable* base,
                                                               GeeForallFunc f,
                                                               void* f_target);
static gpointer singleton_collection_singleton_iterator_real_get (GeeIterator* base);
static gboolean singleton_collection_singleton_iterator_real_has_next (GeeIterator* base);
static gboolean singleton_collection_singleton_iterator_real_next (GeeIterator* base);
static void singleton_collection_singleton_iterator_real_remove (GeeIterator* base);
static void singleton_collection_singleton_iterator_finalize (GObject * obj);
static void _vala_singleton_collection_singleton_iterator_get_property (GObject * object,
                                                                 guint property_id,
                                                                 GValue * value,
                                                                 GParamSpec * pspec);
static void _vala_singleton_collection_singleton_iterator_set_property (GObject * object,
                                                                 guint property_id,
                                                                 const GValue * value,
                                                                 GParamSpec * pspec);
static void singleton_collection_finalize (GObject * obj);
static void _vala_singleton_collection_get_property (GObject * object,
                                              guint property_id,
                                              GValue * value,
                                              GParamSpec * pspec);
static void _vala_singleton_collection_set_property (GObject * object,
                                              guint property_id,
                                              const GValue * value,
                                              GParamSpec * pspec);
GType data_object_get_type (void) G_GNUC_CONST;
GType marker_get_type (void) G_GNUC_CONST;
void marker_mark (Marker* self,
                  DataObject* object);
void marker_unmark (Marker* self,
                    DataObject* object);
gboolean marker_toggle (Marker* self,
                        DataObject* object);
void marker_mark_many (Marker* self,
                       GeeCollection* list);
void marker_unmark_many (Marker* self,
                         GeeCollection* list);
void marker_mark_all (Marker* self);
gint marker_get_count (Marker* self);
GeeCollection* marker_get_all (Marker* self);
gpointer unknown_total_monitor_ref (gpointer instance);
void unknown_total_monitor_unref (gpointer instance);
GParamSpec* param_spec_unknown_total_monitor (const gchar* name,
                                              const gchar* nick,
                                              const gchar* blurb,
                                              GType object_type,
                                              GParamFlags flags);
void value_set_unknown_total_monitor (GValue* value,
                                      gpointer v_object);
void value_take_unknown_total_monitor (GValue* value,
                                       gpointer v_object);
gpointer value_get_unknown_total_monitor (const GValue* value);
GType unknown_total_monitor_get_type (void) G_GNUC_CONST;
#define UNKNOWN_TOTAL_MONITOR_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_UNKNOWN_TOTAL_MONITOR, UnknownTotalMonitorPrivate))
UnknownTotalMonitor* unknown_total_monitor_new (guint64 total,
                                                ProgressMonitor wrapped_monitor,
                                                void* wrapped_monitor_target);
UnknownTotalMonitor* unknown_total_monitor_construct (GType object_type,
                                                      guint64 total,
                                                      ProgressMonitor wrapped_monitor,
                                                      void* wrapped_monitor_target);
gboolean unknown_total_monitor_monitor (UnknownTotalMonitor* self,
                                        guint64 count,
                                        guint64 total);
static void unknown_total_monitor_finalize (UnknownTotalMonitor * obj);
gpointer aggregate_progress_monitor_ref (gpointer instance);
void aggregate_progress_monitor_unref (gpointer instance);
GParamSpec* param_spec_aggregate_progress_monitor (const gchar* name,
                                                   const gchar* nick,
                                                   const gchar* blurb,
                                                   GType object_type,
                                                   GParamFlags flags);
void value_set_aggregate_progress_monitor (GValue* value,
                                           gpointer v_object);
void value_take_aggregate_progress_monitor (GValue* value,
                                            gpointer v_object);
gpointer value_get_aggregate_progress_monitor (const GValue* value);
GType aggregate_progress_monitor_get_type (void) G_GNUC_CONST;
#define AGGREGATE_PROGRESS_MONITOR_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_AGGREGATE_PROGRESS_MONITOR, AggregateProgressMonitorPrivate))
AggregateProgressMonitor* aggregate_progress_monitor_new (guint64 grand_total,
                                                          ProgressMonitor wrapped_monitor,
                                                          void* wrapped_monitor_target);
AggregateProgressMonitor* aggregate_progress_monitor_construct (GType object_type,
                                                                guint64 grand_total,
                                                                ProgressMonitor wrapped_monitor,
                                                                void* wrapped_monitor_target);
void aggregate_progress_monitor_next_step (AggregateProgressMonitor* self,
                                           const gchar* name);
gboolean aggregate_progress_monitor_monitor (AggregateProgressMonitor* self,
                                             guint64 count,
                                             guint64 total);
static void aggregate_progress_monitor_finalize (AggregateProgressMonitor * obj);
gboolean null_progress_monitor (guint64 count,
                                guint64 total);
gdouble degrees_to_radians (gdouble theta);


SingletonCollection*
singleton_collection_construct (GType object_type,
                                GType g_type,
                                GBoxedCopyFunc g_dup_func,
                                GDestroyNotify g_destroy_func,
                                gconstpointer object)
{
	SingletonCollection * self = NULL;
	gpointer _tmp0_;
#line 65 "/home/jens/Source/shotwell/src/core/util.vala"
	self = (SingletonCollection*) gee_abstract_collection_construct (object_type, g_type, (GBoxedCopyFunc) g_dup_func, (GDestroyNotify) g_destroy_func);
#line 65 "/home/jens/Source/shotwell/src/core/util.vala"
	self->priv->g_type = g_type;
#line 65 "/home/jens/Source/shotwell/src/core/util.vala"
	self->priv->g_dup_func = g_dup_func;
#line 65 "/home/jens/Source/shotwell/src/core/util.vala"
	self->priv->g_destroy_func = g_destroy_func;
#line 66 "/home/jens/Source/shotwell/src/core/util.vala"
	_tmp0_ = ((object != NULL) && (g_dup_func != NULL)) ? g_dup_func ((gpointer) object) : ((gpointer) object);
#line 66 "/home/jens/Source/shotwell/src/core/util.vala"
	_g_destroy_func0 (self->priv->object);
#line 66 "/home/jens/Source/shotwell/src/core/util.vala"
	self->priv->object = _tmp0_;
#line 65 "/home/jens/Source/shotwell/src/core/util.vala"
	return self;
#line 366 "util.c"
}


SingletonCollection*
singleton_collection_new (GType g_type,
                          GBoxedCopyFunc g_dup_func,
                          GDestroyNotify g_destroy_func,
                          gconstpointer object)
{
#line 65 "/home/jens/Source/shotwell/src/core/util.vala"
	return singleton_collection_construct (TYPE_SINGLETON_COLLECTION, g_type, g_dup_func, g_destroy_func, object);
#line 378 "util.c"
}


static gboolean
singleton_collection_real_add (GeeAbstractCollection* base,
                               gconstpointer object)
{
	SingletonCollection * self;
	gboolean result = FALSE;
#line 73 "/home/jens/Source/shotwell/src/core/util.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_SINGLETON_COLLECTION, SingletonCollection);
#line 74 "/home/jens/Source/shotwell/src/core/util.vala"
	g_warning ("util.vala:74: Cannot add to SingletonCollection");
#line 76 "/home/jens/Source/shotwell/src/core/util.vala"
	result = FALSE;
#line 76 "/home/jens/Source/shotwell/src/core/util.vala"
	return result;
#line 396 "util.c"
}


static void
singleton_collection_real_clear (GeeAbstractCollection* base)
{
	SingletonCollection * self;
#line 79 "/home/jens/Source/shotwell/src/core/util.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_SINGLETON_COLLECTION, SingletonCollection);
#line 80 "/home/jens/Source/shotwell/src/core/util.vala"
	((self->priv->object == NULL) || (self->priv->g_destroy_func == NULL)) ? NULL : (self->priv->object = (self->priv->g_destroy_func (self->priv->object), NULL));
#line 80 "/home/jens/Source/shotwell/src/core/util.vala"
	self->priv->object = NULL;
#line 410 "util.c"
}


static gboolean
singleton_collection_real_contains (GeeAbstractCollection* base,
                                    gconstpointer object)
{
	SingletonCollection * self;
	gboolean result = FALSE;
	gconstpointer _tmp0_;
#line 83 "/home/jens/Source/shotwell/src/core/util.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_SINGLETON_COLLECTION, SingletonCollection);
#line 84 "/home/jens/Source/shotwell/src/core/util.vala"
	_tmp0_ = self->priv->object;
#line 84 "/home/jens/Source/shotwell/src/core/util.vala"
	result = _tmp0_ == object;
#line 84 "/home/jens/Source/shotwell/src/core/util.vala"
	return result;
#line 429 "util.c"
}


static GeeIterator*
singleton_collection_real_iterator (GeeAbstractCollection* base)
{
	SingletonCollection * self;
	GeeIterator* result = NULL;
	SingletonCollectionSingletonIterator* _tmp0_;
#line 87 "/home/jens/Source/shotwell/src/core/util.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_SINGLETON_COLLECTION, SingletonCollection);
#line 88 "/home/jens/Source/shotwell/src/core/util.vala"
	_tmp0_ = singleton_collection_singleton_iterator_new (self->priv->g_type, (GBoxedCopyFunc) self->priv->g_dup_func, (GDestroyNotify) self->priv->g_destroy_func, self);
#line 88 "/home/jens/Source/shotwell/src/core/util.vala"
	result = G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_ITERATOR, GeeIterator);
#line 88 "/home/jens/Source/shotwell/src/core/util.vala"
	return result;
#line 447 "util.c"
}


static gboolean
singleton_collection_real_remove (GeeAbstractCollection* base,
                                  gconstpointer item)
{
	SingletonCollection * self;
	gboolean result = FALSE;
	gconstpointer _tmp0_;
#line 91 "/home/jens/Source/shotwell/src/core/util.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_SINGLETON_COLLECTION, SingletonCollection);
#line 92 "/home/jens/Source/shotwell/src/core/util.vala"
	_tmp0_ = self->priv->object;
#line 92 "/home/jens/Source/shotwell/src/core/util.vala"
	if (item == _tmp0_) {
#line 93 "/home/jens/Source/shotwell/src/core/util.vala"
		((self->priv->object == NULL) || (self->priv->g_destroy_func == NULL)) ? NULL : (self->priv->object = (self->priv->g_destroy_func (self->priv->object), NULL));
#line 93 "/home/jens/Source/shotwell/src/core/util.vala"
		self->priv->object = NULL;
#line 95 "/home/jens/Source/shotwell/src/core/util.vala"
		result = TRUE;
#line 95 "/home/jens/Source/shotwell/src/core/util.vala"
		return result;
#line 472 "util.c"
	}
#line 98 "/home/jens/Source/shotwell/src/core/util.vala"
	result = FALSE;
#line 98 "/home/jens/Source/shotwell/src/core/util.vala"
	return result;
#line 478 "util.c"
}


static gboolean
singleton_collection_real_get_read_only (GeeAbstractCollection* base)
{
	gboolean result;
	SingletonCollection* self;
#line 70 "/home/jens/Source/shotwell/src/core/util.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_SINGLETON_COLLECTION, SingletonCollection);
#line 70 "/home/jens/Source/shotwell/src/core/util.vala"
	result = FALSE;
#line 70 "/home/jens/Source/shotwell/src/core/util.vala"
	return result;
#line 493 "util.c"
}


static gint
singleton_collection_real_get_size (GeeAbstractCollection* base)
{
	gint result;
	SingletonCollection* self;
	gint _tmp0_ = 0;
	gconstpointer _tmp1_;
#line 102 "/home/jens/Source/shotwell/src/core/util.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_SINGLETON_COLLECTION, SingletonCollection);
#line 103 "/home/jens/Source/shotwell/src/core/util.vala"
	_tmp1_ = self->priv->object;
#line 103 "/home/jens/Source/shotwell/src/core/util.vala"
	if (_tmp1_ != NULL) {
#line 103 "/home/jens/Source/shotwell/src/core/util.vala"
		_tmp0_ = 1;
#line 512 "util.c"
	} else {
#line 103 "/home/jens/Source/shotwell/src/core/util.vala"
		_tmp0_ = 0;
#line 516 "util.c"
	}
#line 103 "/home/jens/Source/shotwell/src/core/util.vala"
	result = _tmp0_;
#line 103 "/home/jens/Source/shotwell/src/core/util.vala"
	return result;
#line 522 "util.c"
}


static gpointer
_g_object_ref0 (gpointer self)
{
#line 20 "/home/jens/Source/shotwell/src/core/util.vala"
	return self ? g_object_ref (self) : NULL;
#line 531 "util.c"
}


static SingletonCollectionSingletonIterator*
singleton_collection_singleton_iterator_construct (GType object_type,
                                                   GType g_type,
                                                   GBoxedCopyFunc g_dup_func,
                                                   GDestroyNotify g_destroy_func,
                                                   SingletonCollection* c)
{
	SingletonCollectionSingletonIterator * self = NULL;
	SingletonCollection* _tmp0_;
#line 19 "/home/jens/Source/shotwell/src/core/util.vala"
	g_return_val_if_fail (IS_SINGLETON_COLLECTION (c), NULL);
#line 19 "/home/jens/Source/shotwell/src/core/util.vala"
	self = (SingletonCollectionSingletonIterator*) g_object_new (object_type, NULL);
#line 19 "/home/jens/Source/shotwell/src/core/util.vala"
	self->priv->g_type = g_type;
#line 19 "/home/jens/Source/shotwell/src/core/util.vala"
	self->priv->g_dup_func = g_dup_func;
#line 19 "/home/jens/Source/shotwell/src/core/util.vala"
	self->priv->g_destroy_func = g_destroy_func;
#line 20 "/home/jens/Source/shotwell/src/core/util.vala"
	_tmp0_ = _g_object_ref0 (c);
#line 20 "/home/jens/Source/shotwell/src/core/util.vala"
	_g_object_unref0 (self->priv->c);
#line 20 "/home/jens/Source/shotwell/src/core/util.vala"
	self->priv->c = _tmp0_;
#line 19 "/home/jens/Source/shotwell/src/core/util.vala"
	return self;
#line 562 "util.c"
}


static SingletonCollectionSingletonIterator*
singleton_collection_singleton_iterator_new (GType g_type,
                                             GBoxedCopyFunc g_dup_func,
                                             GDestroyNotify g_destroy_func,
                                             SingletonCollection* c)
{
#line 19 "/home/jens/Source/shotwell/src/core/util.vala"
	return singleton_collection_singleton_iterator_construct (SINGLETON_COLLECTION_TYPE_SINGLETON_ITERATOR, g_type, g_dup_func, g_destroy_func, c);
#line 574 "util.c"
}


static gboolean
singleton_collection_singleton_iterator_real_foreach (GeeTraversable* base,
                                                      GeeForallFunc f,
                                                      void* f_target)
{
	SingletonCollectionSingletonIterator * self;
	gboolean result = FALSE;
	SingletonCollection* _tmp0_;
	gconstpointer _tmp1_;
	gpointer _tmp2_;
#line 31 "/home/jens/Source/shotwell/src/core/util.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, SINGLETON_COLLECTION_TYPE_SINGLETON_ITERATOR, SingletonCollectionSingletonIterator);
#line 32 "/home/jens/Source/shotwell/src/core/util.vala"
	_tmp0_ = self->priv->c;
#line 32 "/home/jens/Source/shotwell/src/core/util.vala"
	_tmp1_ = _tmp0_->priv->object;
#line 32 "/home/jens/Source/shotwell/src/core/util.vala"
	_tmp2_ = ((_tmp1_ != NULL) && (self->priv->g_dup_func != NULL)) ? self->priv->g_dup_func ((gpointer) _tmp1_) : ((gpointer) _tmp1_);
#line 32 "/home/jens/Source/shotwell/src/core/util.vala"
	result = f (_tmp2_, f_target);
#line 32 "/home/jens/Source/shotwell/src/core/util.vala"
	return result;
#line 600 "util.c"
}


static gpointer
singleton_collection_singleton_iterator_real_get (GeeIterator* base)
{
	SingletonCollectionSingletonIterator * self;
	gpointer result = NULL;
	gconstpointer _tmp0_;
	gpointer _tmp1_;
#line 35 "/home/jens/Source/shotwell/src/core/util.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, SINGLETON_COLLECTION_TYPE_SINGLETON_ITERATOR, SingletonCollectionSingletonIterator);
#line 36 "/home/jens/Source/shotwell/src/core/util.vala"
	_tmp0_ = self->priv->current;
#line 36 "/home/jens/Source/shotwell/src/core/util.vala"
	_tmp1_ = ((_tmp0_ != NULL) && (self->priv->g_dup_func != NULL)) ? self->priv->g_dup_func ((gpointer) _tmp0_) : ((gpointer) _tmp0_);
#line 36 "/home/jens/Source/shotwell/src/core/util.vala"
	result = _tmp1_;
#line 36 "/home/jens/Source/shotwell/src/core/util.vala"
	return result;
#line 621 "util.c"
}


static gboolean
singleton_collection_singleton_iterator_real_has_next (GeeIterator* base)
{
	SingletonCollectionSingletonIterator * self;
	gboolean result = FALSE;
#line 39 "/home/jens/Source/shotwell/src/core/util.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, SINGLETON_COLLECTION_TYPE_SINGLETON_ITERATOR, SingletonCollectionSingletonIterator);
#line 40 "/home/jens/Source/shotwell/src/core/util.vala"
	result = FALSE;
#line 40 "/home/jens/Source/shotwell/src/core/util.vala"
	return result;
#line 636 "util.c"
}


static gboolean
singleton_collection_singleton_iterator_real_next (GeeIterator* base)
{
	SingletonCollectionSingletonIterator * self;
	gboolean result = FALSE;
	gboolean _tmp0_;
	SingletonCollection* _tmp1_;
	gconstpointer _tmp2_;
	gpointer _tmp3_;
#line 43 "/home/jens/Source/shotwell/src/core/util.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, SINGLETON_COLLECTION_TYPE_SINGLETON_ITERATOR, SingletonCollectionSingletonIterator);
#line 44 "/home/jens/Source/shotwell/src/core/util.vala"
	_tmp0_ = self->priv->done;
#line 44 "/home/jens/Source/shotwell/src/core/util.vala"
	if (_tmp0_) {
#line 45 "/home/jens/Source/shotwell/src/core/util.vala"
		result = FALSE;
#line 45 "/home/jens/Source/shotwell/src/core/util.vala"
		return result;
#line 659 "util.c"
	}
#line 47 "/home/jens/Source/shotwell/src/core/util.vala"
	self->priv->done = TRUE;
#line 48 "/home/jens/Source/shotwell/src/core/util.vala"
	_tmp1_ = self->priv->c;
#line 48 "/home/jens/Source/shotwell/src/core/util.vala"
	_tmp2_ = _tmp1_->priv->object;
#line 48 "/home/jens/Source/shotwell/src/core/util.vala"
	_tmp3_ = ((_tmp2_ != NULL) && (self->priv->g_dup_func != NULL)) ? self->priv->g_dup_func ((gpointer) _tmp2_) : ((gpointer) _tmp2_);
#line 48 "/home/jens/Source/shotwell/src/core/util.vala"
	((self->priv->current == NULL) || (self->priv->g_destroy_func == NULL)) ? NULL : (self->priv->current = (self->priv->g_destroy_func (self->priv->current), NULL));
#line 48 "/home/jens/Source/shotwell/src/core/util.vala"
	self->priv->current = _tmp3_;
#line 50 "/home/jens/Source/shotwell/src/core/util.vala"
	result = TRUE;
#line 50 "/home/jens/Source/shotwell/src/core/util.vala"
	return result;
#line 677 "util.c"
}


static void
singleton_collection_singleton_iterator_real_remove (GeeIterator* base)
{
	SingletonCollectionSingletonIterator * self;
	gboolean _tmp0_;
#line 53 "/home/jens/Source/shotwell/src/core/util.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, SINGLETON_COLLECTION_TYPE_SINGLETON_ITERATOR, SingletonCollectionSingletonIterator);
#line 54 "/home/jens/Source/shotwell/src/core/util.vala"
	_tmp0_ = self->priv->done;
#line 54 "/home/jens/Source/shotwell/src/core/util.vala"
	if (!_tmp0_) {
#line 692 "util.c"
		SingletonCollection* _tmp1_;
#line 55 "/home/jens/Source/shotwell/src/core/util.vala"
		_tmp1_ = self->priv->c;
#line 55 "/home/jens/Source/shotwell/src/core/util.vala"
		((_tmp1_->priv->object == NULL) || (self->priv->g_destroy_func == NULL)) ? NULL : (_tmp1_->priv->object = (self->priv->g_destroy_func (_tmp1_->priv->object), NULL));
#line 55 "/home/jens/Source/shotwell/src/core/util.vala"
		_tmp1_->priv->object = NULL;
#line 56 "/home/jens/Source/shotwell/src/core/util.vala"
		((self->priv->current == NULL) || (self->priv->g_destroy_func == NULL)) ? NULL : (self->priv->current = (self->priv->g_destroy_func (self->priv->current), NULL));
#line 56 "/home/jens/Source/shotwell/src/core/util.vala"
		self->priv->current = NULL;
#line 704 "util.c"
	}
#line 59 "/home/jens/Source/shotwell/src/core/util.vala"
	self->priv->done = TRUE;
#line 708 "util.c"
}


static gboolean
singleton_collection_singleton_iterator_real_get_read_only (GeeIterator* base)
{
	gboolean result;
	SingletonCollectionSingletonIterator* self;
	gboolean _tmp0_;
#line 24 "/home/jens/Source/shotwell/src/core/util.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, SINGLETON_COLLECTION_TYPE_SINGLETON_ITERATOR, SingletonCollectionSingletonIterator);
#line 24 "/home/jens/Source/shotwell/src/core/util.vala"
	_tmp0_ = self->priv->done;
#line 24 "/home/jens/Source/shotwell/src/core/util.vala"
	result = _tmp0_;
#line 24 "/home/jens/Source/shotwell/src/core/util.vala"
	return result;
#line 726 "util.c"
}


static gboolean
singleton_collection_singleton_iterator_real_get_valid (GeeIterator* base)
{
	gboolean result;
	SingletonCollectionSingletonIterator* self;
	gboolean _tmp0_;
#line 28 "/home/jens/Source/shotwell/src/core/util.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, SINGLETON_COLLECTION_TYPE_SINGLETON_ITERATOR, SingletonCollectionSingletonIterator);
#line 28 "/home/jens/Source/shotwell/src/core/util.vala"
	_tmp0_ = self->priv->done;
#line 28 "/home/jens/Source/shotwell/src/core/util.vala"
	result = _tmp0_;
#line 28 "/home/jens/Source/shotwell/src/core/util.vala"
	return result;
#line 744 "util.c"
}


static void
singleton_collection_singleton_iterator_class_init (SingletonCollectionSingletonIteratorClass * klass)
{
#line 14 "/home/jens/Source/shotwell/src/core/util.vala"
	singleton_collection_singleton_iterator_parent_class = g_type_class_peek_parent (klass);
#line 14 "/home/jens/Source/shotwell/src/core/util.vala"
	g_type_class_add_private (klass, sizeof (SingletonCollectionSingletonIteratorPrivate));
#line 14 "/home/jens/Source/shotwell/src/core/util.vala"
	G_OBJECT_CLASS (klass)->get_property = _vala_singleton_collection_singleton_iterator_get_property;
#line 14 "/home/jens/Source/shotwell/src/core/util.vala"
	G_OBJECT_CLASS (klass)->set_property = _vala_singleton_collection_singleton_iterator_set_property;
#line 14 "/home/jens/Source/shotwell/src/core/util.vala"
	G_OBJECT_CLASS (klass)->finalize = singleton_collection_singleton_iterator_finalize;
#line 14 "/home/jens/Source/shotwell/src/core/util.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), SINGLETON_COLLECTION_SINGLETON_ITERATOR_G_TYPE, g_param_spec_gtype ("g-type", "type", "type", G_TYPE_NONE, G_PARAM_STATIC_STRINGS | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
#line 14 "/home/jens/Source/shotwell/src/core/util.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), SINGLETON_COLLECTION_SINGLETON_ITERATOR_G_DUP_FUNC, g_param_spec_pointer ("g-dup-func", "dup func", "dup func", G_PARAM_STATIC_STRINGS | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
#line 14 "/home/jens/Source/shotwell/src/core/util.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), SINGLETON_COLLECTION_SINGLETON_ITERATOR_G_DESTROY_FUNC, g_param_spec_pointer ("g-destroy-func", "destroy func", "destroy func", G_PARAM_STATIC_STRINGS | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
#line 14 "/home/jens/Source/shotwell/src/core/util.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), SINGLETON_COLLECTION_SINGLETON_ITERATOR_READ_ONLY_PROPERTY, singleton_collection_singleton_iterator_properties[SINGLETON_COLLECTION_SINGLETON_ITERATOR_READ_ONLY_PROPERTY] = g_param_spec_boolean ("read-only", "read-only", "read-only", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
#line 14 "/home/jens/Source/shotwell/src/core/util.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), SINGLETON_COLLECTION_SINGLETON_ITERATOR_VALID_PROPERTY, singleton_collection_singleton_iterator_properties[SINGLETON_COLLECTION_SINGLETON_ITERATOR_VALID_PROPERTY] = g_param_spec_boolean ("valid", "valid", "valid", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
#line 771 "util.c"
}


static GType
singleton_collection_singleton_iterator_gee_traversable_get_g_type (SingletonCollectionSingletonIterator* self)
{
#line 14 "/home/jens/Source/shotwell/src/core/util.vala"
	return self->priv->g_type;
#line 780 "util.c"
}


static GBoxedCopyFunc
singleton_collection_singleton_iterator_gee_traversable_get_g_dup_func (SingletonCollectionSingletonIterator* self)
{
#line 14 "/home/jens/Source/shotwell/src/core/util.vala"
	return self->priv->g_dup_func;
#line 789 "util.c"
}


static GDestroyNotify
singleton_collection_singleton_iterator_gee_traversable_get_g_destroy_func (SingletonCollectionSingletonIterator* self)
{
#line 14 "/home/jens/Source/shotwell/src/core/util.vala"
	return self->priv->g_destroy_func;
#line 798 "util.c"
}


static void
singleton_collection_singleton_iterator_gee_traversable_interface_init (GeeTraversableIface * iface)
{
#line 14 "/home/jens/Source/shotwell/src/core/util.vala"
	singleton_collection_singleton_iterator_gee_traversable_parent_iface = g_type_interface_peek_parent (iface);
#line 14 "/home/jens/Source/shotwell/src/core/util.vala"
	iface->foreach = (gboolean (*) (GeeTraversable *, GeeForallFunc, void*)) singleton_collection_singleton_iterator_real_foreach;
#line 14 "/home/jens/Source/shotwell/src/core/util.vala"
	iface->get_g_type = (GType (*) (GeeTraversable *)) singleton_collection_singleton_iterator_gee_traversable_get_g_type;
#line 14 "/home/jens/Source/shotwell/src/core/util.vala"
	iface->get_g_dup_func = (GBoxedCopyFunc (*) (GeeTraversable *)) singleton_collection_singleton_iterator_gee_traversable_get_g_dup_func;
#line 14 "/home/jens/Source/shotwell/src/core/util.vala"
	iface->get_g_destroy_func = (GDestroyNotify (*) (GeeTraversable *)) singleton_collection_singleton_iterator_gee_traversable_get_g_destroy_func;
#line 815 "util.c"
}


static void
singleton_collection_singleton_iterator_gee_iterator_interface_init (GeeIteratorIface * iface)
{
#line 14 "/home/jens/Source/shotwell/src/core/util.vala"
	singleton_collection_singleton_iterator_gee_iterator_parent_iface = g_type_interface_peek_parent (iface);
#line 14 "/home/jens/Source/shotwell/src/core/util.vala"
	iface->get = (gpointer (*) (GeeIterator *)) singleton_collection_singleton_iterator_real_get;
#line 14 "/home/jens/Source/shotwell/src/core/util.vala"
	iface->has_next = (gboolean (*) (GeeIterator *)) singleton_collection_singleton_iterator_real_has_next;
#line 14 "/home/jens/Source/shotwell/src/core/util.vala"
	iface->next = (gboolean (*) (GeeIterator *)) singleton_collection_singleton_iterator_real_next;
#line 14 "/home/jens/Source/shotwell/src/core/util.vala"
	iface->remove = (void (*) (GeeIterator *)) singleton_collection_singleton_iterator_real_remove;
#line 14 "/home/jens/Source/shotwell/src/core/util.vala"
	iface->get_read_only = singleton_collection_singleton_iterator_real_get_read_only;
#line 14 "/home/jens/Source/shotwell/src/core/util.vala"
	iface->get_valid = singleton_collection_singleton_iterator_real_get_valid;
#line 836 "util.c"
}


static void
singleton_collection_singleton_iterator_instance_init (SingletonCollectionSingletonIterator * self)
{
#line 14 "/home/jens/Source/shotwell/src/core/util.vala"
	self->priv = SINGLETON_COLLECTION_SINGLETON_ITERATOR_GET_PRIVATE (self);
#line 16 "/home/jens/Source/shotwell/src/core/util.vala"
	self->priv->done = FALSE;
#line 17 "/home/jens/Source/shotwell/src/core/util.vala"
	self->priv->current = NULL;
#line 849 "util.c"
}


static void
singleton_collection_singleton_iterator_finalize (GObject * obj)
{
	SingletonCollectionSingletonIterator * self;
#line 14 "/home/jens/Source/shotwell/src/core/util.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SINGLETON_COLLECTION_TYPE_SINGLETON_ITERATOR, SingletonCollectionSingletonIterator);
#line 15 "/home/jens/Source/shotwell/src/core/util.vala"
	_g_object_unref0 (self->priv->c);
#line 17 "/home/jens/Source/shotwell/src/core/util.vala"
	((self->priv->current == NULL) || (self->priv->g_destroy_func == NULL)) ? NULL : (self->priv->current = (self->priv->g_destroy_func (self->priv->current), NULL));
#line 14 "/home/jens/Source/shotwell/src/core/util.vala"
	G_OBJECT_CLASS (singleton_collection_singleton_iterator_parent_class)->finalize (obj);
#line 865 "util.c"
}


static GType
singleton_collection_singleton_iterator_get_type (void)
{
	static volatile gsize singleton_collection_singleton_iterator_type_id__volatile = 0;
	if (g_once_init_enter (&singleton_collection_singleton_iterator_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (SingletonCollectionSingletonIteratorClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) singleton_collection_singleton_iterator_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SingletonCollectionSingletonIterator), 0, (GInstanceInitFunc) singleton_collection_singleton_iterator_instance_init, NULL };
		static const GInterfaceInfo gee_traversable_info = { (GInterfaceInitFunc) singleton_collection_singleton_iterator_gee_traversable_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		static const GInterfaceInfo gee_iterator_info = { (GInterfaceInitFunc) singleton_collection_singleton_iterator_gee_iterator_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType singleton_collection_singleton_iterator_type_id;
		singleton_collection_singleton_iterator_type_id = g_type_register_static (G_TYPE_OBJECT, "SingletonCollectionSingletonIterator", &g_define_type_info, 0);
		g_type_add_interface_static (singleton_collection_singleton_iterator_type_id, GEE_TYPE_TRAVERSABLE, &gee_traversable_info);
		g_type_add_interface_static (singleton_collection_singleton_iterator_type_id, GEE_TYPE_ITERATOR, &gee_iterator_info);
		g_once_init_leave (&singleton_collection_singleton_iterator_type_id__volatile, singleton_collection_singleton_iterator_type_id);
	}
	return singleton_collection_singleton_iterator_type_id__volatile;
}


static void
_vala_singleton_collection_singleton_iterator_get_property (GObject * object,
                                                            guint property_id,
                                                            GValue * value,
                                                            GParamSpec * pspec)
{
	SingletonCollectionSingletonIterator * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SINGLETON_COLLECTION_TYPE_SINGLETON_ITERATOR, SingletonCollectionSingletonIterator);
#line 14 "/home/jens/Source/shotwell/src/core/util.vala"
	switch (property_id) {
#line 14 "/home/jens/Source/shotwell/src/core/util.vala"
		case SINGLETON_COLLECTION_SINGLETON_ITERATOR_READ_ONLY_PROPERTY:
#line 14 "/home/jens/Source/shotwell/src/core/util.vala"
		g_value_set_boolean (value, gee_iterator_get_read_only (G_TYPE_CHECK_INSTANCE_CAST (self, GEE_TYPE_ITERATOR, GeeIterator)));
#line 14 "/home/jens/Source/shotwell/src/core/util.vala"
		break;
#line 14 "/home/jens/Source/shotwell/src/core/util.vala"
		case SINGLETON_COLLECTION_SINGLETON_ITERATOR_VALID_PROPERTY:
#line 14 "/home/jens/Source/shotwell/src/core/util.vala"
		g_value_set_boolean (value, gee_iterator_get_valid (G_TYPE_CHECK_INSTANCE_CAST (self, GEE_TYPE_ITERATOR, GeeIterator)));
#line 14 "/home/jens/Source/shotwell/src/core/util.vala"
		break;
#line 909 "util.c"
		default:
#line 14 "/home/jens/Source/shotwell/src/core/util.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 14 "/home/jens/Source/shotwell/src/core/util.vala"
		break;
#line 915 "util.c"
	}
}


static void
_vala_singleton_collection_singleton_iterator_set_property (GObject * object,
                                                            guint property_id,
                                                            const GValue * value,
                                                            GParamSpec * pspec)
{
	SingletonCollectionSingletonIterator * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SINGLETON_COLLECTION_TYPE_SINGLETON_ITERATOR, SingletonCollectionSingletonIterator);
#line 14 "/home/jens/Source/shotwell/src/core/util.vala"
	switch (property_id) {
#line 14 "/home/jens/Source/shotwell/src/core/util.vala"
		case SINGLETON_COLLECTION_SINGLETON_ITERATOR_G_TYPE:
#line 14 "/home/jens/Source/shotwell/src/core/util.vala"
		self->priv->g_type = g_value_get_gtype (value);
#line 14 "/home/jens/Source/shotwell/src/core/util.vala"
		break;
#line 14 "/home/jens/Source/shotwell/src/core/util.vala"
		case SINGLETON_COLLECTION_SINGLETON_ITERATOR_G_DUP_FUNC:
#line 14 "/home/jens/Source/shotwell/src/core/util.vala"
		self->priv->g_dup_func = g_value_get_pointer (value);
#line 14 "/home/jens/Source/shotwell/src/core/util.vala"
		break;
#line 14 "/home/jens/Source/shotwell/src/core/util.vala"
		case SINGLETON_COLLECTION_SINGLETON_ITERATOR_G_DESTROY_FUNC:
#line 14 "/home/jens/Source/shotwell/src/core/util.vala"
		self->priv->g_destroy_func = g_value_get_pointer (value);
#line 14 "/home/jens/Source/shotwell/src/core/util.vala"
		break;
#line 948 "util.c"
		default:
#line 14 "/home/jens/Source/shotwell/src/core/util.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 14 "/home/jens/Source/shotwell/src/core/util.vala"
		break;
#line 954 "util.c"
	}
}


static void
singleton_collection_class_init (SingletonCollectionClass * klass)
{
#line 13 "/home/jens/Source/shotwell/src/core/util.vala"
	singleton_collection_parent_class = g_type_class_peek_parent (klass);
#line 13 "/home/jens/Source/shotwell/src/core/util.vala"
	g_type_class_add_private (klass, sizeof (SingletonCollectionPrivate));
#line 13 "/home/jens/Source/shotwell/src/core/util.vala"
	((GeeAbstractCollectionClass *) klass)->add = (gboolean (*) (GeeAbstractCollection *, gconstpointer)) singleton_collection_real_add;
#line 13 "/home/jens/Source/shotwell/src/core/util.vala"
	((GeeAbstractCollectionClass *) klass)->clear = (void (*) (GeeAbstractCollection *)) singleton_collection_real_clear;
#line 13 "/home/jens/Source/shotwell/src/core/util.vala"
	((GeeAbstractCollectionClass *) klass)->contains = (gboolean (*) (GeeAbstractCollection *, gconstpointer)) singleton_collection_real_contains;
#line 13 "/home/jens/Source/shotwell/src/core/util.vala"
	((GeeAbstractCollectionClass *) klass)->iterator = (GeeIterator* (*) (GeeAbstractCollection *)) singleton_collection_real_iterator;
#line 13 "/home/jens/Source/shotwell/src/core/util.vala"
	((GeeAbstractCollectionClass *) klass)->remove = (gboolean (*) (GeeAbstractCollection *, gconstpointer)) singleton_collection_real_remove;
#line 13 "/home/jens/Source/shotwell/src/core/util.vala"
	GEE_ABSTRACT_COLLECTION_CLASS (klass)->get_read_only = singleton_collection_real_get_read_only;
#line 13 "/home/jens/Source/shotwell/src/core/util.vala"
	GEE_ABSTRACT_COLLECTION_CLASS (klass)->get_size = singleton_collection_real_get_size;
#line 13 "/home/jens/Source/shotwell/src/core/util.vala"
	G_OBJECT_CLASS (klass)->get_property = _vala_singleton_collection_get_property;
#line 13 "/home/jens/Source/shotwell/src/core/util.vala"
	G_OBJECT_CLASS (klass)->set_property = _vala_singleton_collection_set_property;
#line 13 "/home/jens/Source/shotwell/src/core/util.vala"
	G_OBJECT_CLASS (klass)->finalize = singleton_collection_finalize;
#line 13 "/home/jens/Source/shotwell/src/core/util.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), SINGLETON_COLLECTION_G_TYPE, g_param_spec_gtype ("g-type", "type", "type", G_TYPE_NONE, G_PARAM_STATIC_STRINGS | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
#line 13 "/home/jens/Source/shotwell/src/core/util.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), SINGLETON_COLLECTION_G_DUP_FUNC, g_param_spec_pointer ("g-dup-func", "dup func", "dup func", G_PARAM_STATIC_STRINGS | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
#line 13 "/home/jens/Source/shotwell/src/core/util.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), SINGLETON_COLLECTION_G_DESTROY_FUNC, g_param_spec_pointer ("g-destroy-func", "destroy func", "destroy func", G_PARAM_STATIC_STRINGS | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
#line 13 "/home/jens/Source/shotwell/src/core/util.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), SINGLETON_COLLECTION_READ_ONLY_PROPERTY, singleton_collection_properties[SINGLETON_COLLECTION_READ_ONLY_PROPERTY] = g_param_spec_boolean ("read-only", "read-only", "read-only", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
#line 13 "/home/jens/Source/shotwell/src/core/util.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), SINGLETON_COLLECTION_SIZE_PROPERTY, singleton_collection_properties[SINGLETON_COLLECTION_SIZE_PROPERTY] = g_param_spec_int ("size", "size", "size", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
#line 996 "util.c"
}


static void
singleton_collection_instance_init (SingletonCollection * self)
{
#line 13 "/home/jens/Source/shotwell/src/core/util.vala"
	self->priv = SINGLETON_COLLECTION_GET_PRIVATE (self);
#line 1005 "util.c"
}


static void
singleton_collection_finalize (GObject * obj)
{
	SingletonCollection * self;
#line 13 "/home/jens/Source/shotwell/src/core/util.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_SINGLETON_COLLECTION, SingletonCollection);
#line 63 "/home/jens/Source/shotwell/src/core/util.vala"
	((self->priv->object == NULL) || (self->priv->g_destroy_func == NULL)) ? NULL : (self->priv->object = (self->priv->g_destroy_func (self->priv->object), NULL));
#line 13 "/home/jens/Source/shotwell/src/core/util.vala"
	G_OBJECT_CLASS (singleton_collection_parent_class)->finalize (obj);
#line 1019 "util.c"
}


GType
singleton_collection_get_type (void)
{
	static volatile gsize singleton_collection_type_id__volatile = 0;
	if (g_once_init_enter (&singleton_collection_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (SingletonCollectionClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) singleton_collection_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SingletonCollection), 0, (GInstanceInitFunc) singleton_collection_instance_init, NULL };
		GType singleton_collection_type_id;
		singleton_collection_type_id = g_type_register_static (GEE_TYPE_ABSTRACT_COLLECTION, "SingletonCollection", &g_define_type_info, 0);
		g_once_init_leave (&singleton_collection_type_id__volatile, singleton_collection_type_id);
	}
	return singleton_collection_type_id__volatile;
}


static void
_vala_singleton_collection_get_property (GObject * object,
                                         guint property_id,
                                         GValue * value,
                                         GParamSpec * pspec)
{
	SingletonCollection * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_SINGLETON_COLLECTION, SingletonCollection);
#line 13 "/home/jens/Source/shotwell/src/core/util.vala"
	switch (property_id) {
#line 13 "/home/jens/Source/shotwell/src/core/util.vala"
		case SINGLETON_COLLECTION_READ_ONLY_PROPERTY:
#line 13 "/home/jens/Source/shotwell/src/core/util.vala"
		g_value_set_boolean (value, gee_abstract_collection_get_read_only (G_TYPE_CHECK_INSTANCE_CAST (self, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection)));
#line 13 "/home/jens/Source/shotwell/src/core/util.vala"
		break;
#line 13 "/home/jens/Source/shotwell/src/core/util.vala"
		case SINGLETON_COLLECTION_SIZE_PROPERTY:
#line 13 "/home/jens/Source/shotwell/src/core/util.vala"
		g_value_set_int (value, gee_abstract_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (self, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection)));
#line 13 "/home/jens/Source/shotwell/src/core/util.vala"
		break;
#line 1059 "util.c"
		default:
#line 13 "/home/jens/Source/shotwell/src/core/util.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 13 "/home/jens/Source/shotwell/src/core/util.vala"
		break;
#line 1065 "util.c"
	}
}


static void
_vala_singleton_collection_set_property (GObject * object,
                                         guint property_id,
                                         const GValue * value,
                                         GParamSpec * pspec)
{
	SingletonCollection * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_SINGLETON_COLLECTION, SingletonCollection);
#line 13 "/home/jens/Source/shotwell/src/core/util.vala"
	switch (property_id) {
#line 13 "/home/jens/Source/shotwell/src/core/util.vala"
		case SINGLETON_COLLECTION_G_TYPE:
#line 13 "/home/jens/Source/shotwell/src/core/util.vala"
		self->priv->g_type = g_value_get_gtype (value);
#line 13 "/home/jens/Source/shotwell/src/core/util.vala"
		break;
#line 13 "/home/jens/Source/shotwell/src/core/util.vala"
		case SINGLETON_COLLECTION_G_DUP_FUNC:
#line 13 "/home/jens/Source/shotwell/src/core/util.vala"
		self->priv->g_dup_func = g_value_get_pointer (value);
#line 13 "/home/jens/Source/shotwell/src/core/util.vala"
		break;
#line 13 "/home/jens/Source/shotwell/src/core/util.vala"
		case SINGLETON_COLLECTION_G_DESTROY_FUNC:
#line 13 "/home/jens/Source/shotwell/src/core/util.vala"
		self->priv->g_destroy_func = g_value_get_pointer (value);
#line 13 "/home/jens/Source/shotwell/src/core/util.vala"
		break;
#line 1098 "util.c"
		default:
#line 13 "/home/jens/Source/shotwell/src/core/util.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 13 "/home/jens/Source/shotwell/src/core/util.vala"
		break;
#line 1104 "util.c"
	}
}


void
marker_mark (Marker* self,
             DataObject* object)
{
#line 113 "/home/jens/Source/shotwell/src/core/util.vala"
	g_return_if_fail (IS_MARKER (self));
#line 113 "/home/jens/Source/shotwell/src/core/util.vala"
	MARKER_GET_INTERFACE (self)->mark (self, object);
#line 1117 "util.c"
}


void
marker_unmark (Marker* self,
               DataObject* object)
{
#line 115 "/home/jens/Source/shotwell/src/core/util.vala"
	g_return_if_fail (IS_MARKER (self));
#line 115 "/home/jens/Source/shotwell/src/core/util.vala"
	MARKER_GET_INTERFACE (self)->unmark (self, object);
#line 1129 "util.c"
}


gboolean
marker_toggle (Marker* self,
               DataObject* object)
{
#line 117 "/home/jens/Source/shotwell/src/core/util.vala"
	g_return_val_if_fail (IS_MARKER (self), FALSE);
#line 117 "/home/jens/Source/shotwell/src/core/util.vala"
	return MARKER_GET_INTERFACE (self)->toggle (self, object);
#line 1141 "util.c"
}


void
marker_mark_many (Marker* self,
                  GeeCollection* list)
{
#line 119 "/home/jens/Source/shotwell/src/core/util.vala"
	g_return_if_fail (IS_MARKER (self));
#line 119 "/home/jens/Source/shotwell/src/core/util.vala"
	MARKER_GET_INTERFACE (self)->mark_many (self, list);
#line 1153 "util.c"
}


void
marker_unmark_many (Marker* self,
                    GeeCollection* list)
{
#line 121 "/home/jens/Source/shotwell/src/core/util.vala"
	g_return_if_fail (IS_MARKER (self));
#line 121 "/home/jens/Source/shotwell/src/core/util.vala"
	MARKER_GET_INTERFACE (self)->unmark_many (self, list);
#line 1165 "util.c"
}


void
marker_mark_all (Marker* self)
{
#line 123 "/home/jens/Source/shotwell/src/core/util.vala"
	g_return_if_fail (IS_MARKER (self));
#line 123 "/home/jens/Source/shotwell/src/core/util.vala"
	MARKER_GET_INTERFACE (self)->mark_all (self);
#line 1176 "util.c"
}


gint
marker_get_count (Marker* self)
{
#line 127 "/home/jens/Source/shotwell/src/core/util.vala"
	g_return_val_if_fail (IS_MARKER (self), 0);
#line 127 "/home/jens/Source/shotwell/src/core/util.vala"
	return MARKER_GET_INTERFACE (self)->get_count (self);
#line 1187 "util.c"
}


GeeCollection*
marker_get_all (Marker* self)
{
#line 130 "/home/jens/Source/shotwell/src/core/util.vala"
	g_return_val_if_fail (IS_MARKER (self), NULL);
#line 130 "/home/jens/Source/shotwell/src/core/util.vala"
	return MARKER_GET_INTERFACE (self)->get_all (self);
#line 1198 "util.c"
}


static void
marker_base_init (MarkerIface * iface)
{
#line 112 "/home/jens/Source/shotwell/src/core/util.vala"
	static gboolean initialized = FALSE;
#line 112 "/home/jens/Source/shotwell/src/core/util.vala"
	if (!initialized) {
#line 112 "/home/jens/Source/shotwell/src/core/util.vala"
		initialized = TRUE;
#line 1211 "util.c"
	}
}


GType
marker_get_type (void)
{
	static volatile gsize marker_type_id__volatile = 0;
	if (g_once_init_enter (&marker_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (MarkerIface), (GBaseInitFunc) marker_base_init, (GBaseFinalizeFunc) NULL, (GClassInitFunc) NULL, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
		GType marker_type_id;
		marker_type_id = g_type_register_static (G_TYPE_INTERFACE, "Marker", &g_define_type_info, 0);
		g_type_interface_add_prerequisite (marker_type_id, G_TYPE_OBJECT);
		g_once_init_leave (&marker_type_id__volatile, marker_type_id);
	}
	return marker_type_id__volatile;
}


UnknownTotalMonitor*
unknown_total_monitor_construct (GType object_type,
                                 guint64 total,
                                 ProgressMonitor wrapped_monitor,
                                 void* wrapped_monitor_target)
{
	UnknownTotalMonitor* self = NULL;
#line 147 "/home/jens/Source/shotwell/src/core/util.vala"
	self = (UnknownTotalMonitor*) g_type_create_instance (object_type);
#line 148 "/home/jens/Source/shotwell/src/core/util.vala"
	self->priv->total = total;
#line 149 "/home/jens/Source/shotwell/src/core/util.vala"
	self->priv->wrapped_monitor = wrapped_monitor;
#line 149 "/home/jens/Source/shotwell/src/core/util.vala"
	self->priv->wrapped_monitor_target = wrapped_monitor_target;
#line 147 "/home/jens/Source/shotwell/src/core/util.vala"
	return self;
#line 1248 "util.c"
}


UnknownTotalMonitor*
unknown_total_monitor_new (guint64 total,
                           ProgressMonitor wrapped_monitor,
                           void* wrapped_monitor_target)
{
#line 147 "/home/jens/Source/shotwell/src/core/util.vala"
	return unknown_total_monitor_construct (TYPE_UNKNOWN_TOTAL_MONITOR, total, wrapped_monitor, wrapped_monitor_target);
#line 1259 "util.c"
}


gboolean
unknown_total_monitor_monitor (UnknownTotalMonitor* self,
                               guint64 count,
                               guint64 total)
{
	gboolean result = FALSE;
	ProgressMonitor _tmp0_;
	void* _tmp0__target;
	guint64 _tmp1_;
#line 152 "/home/jens/Source/shotwell/src/core/util.vala"
	g_return_val_if_fail (IS_UNKNOWN_TOTAL_MONITOR (self), FALSE);
#line 153 "/home/jens/Source/shotwell/src/core/util.vala"
	_tmp0_ = self->priv->wrapped_monitor;
#line 153 "/home/jens/Source/shotwell/src/core/util.vala"
	_tmp0__target = self->priv->wrapped_monitor_target;
#line 153 "/home/jens/Source/shotwell/src/core/util.vala"
	_tmp1_ = self->priv->total;
#line 153 "/home/jens/Source/shotwell/src/core/util.vala"
	result = _tmp0_ (count, _tmp1_, TRUE, _tmp0__target);
#line 153 "/home/jens/Source/shotwell/src/core/util.vala"
	return result;
#line 1284 "util.c"
}


static void
value_unknown_total_monitor_init (GValue* value)
{
#line 143 "/home/jens/Source/shotwell/src/core/util.vala"
	value->data[0].v_pointer = NULL;
#line 1293 "util.c"
}


static void
value_unknown_total_monitor_free_value (GValue* value)
{
#line 143 "/home/jens/Source/shotwell/src/core/util.vala"
	if (value->data[0].v_pointer) {
#line 143 "/home/jens/Source/shotwell/src/core/util.vala"
		unknown_total_monitor_unref (value->data[0].v_pointer);
#line 1304 "util.c"
	}
}


static void
value_unknown_total_monitor_copy_value (const GValue* src_value,
                                        GValue* dest_value)
{
#line 143 "/home/jens/Source/shotwell/src/core/util.vala"
	if (src_value->data[0].v_pointer) {
#line 143 "/home/jens/Source/shotwell/src/core/util.vala"
		dest_value->data[0].v_pointer = unknown_total_monitor_ref (src_value->data[0].v_pointer);
#line 1317 "util.c"
	} else {
#line 143 "/home/jens/Source/shotwell/src/core/util.vala"
		dest_value->data[0].v_pointer = NULL;
#line 1321 "util.c"
	}
}


static gpointer
value_unknown_total_monitor_peek_pointer (const GValue* value)
{
#line 143 "/home/jens/Source/shotwell/src/core/util.vala"
	return value->data[0].v_pointer;
#line 1331 "util.c"
}


static gchar*
value_unknown_total_monitor_collect_value (GValue* value,
                                           guint n_collect_values,
                                           GTypeCValue* collect_values,
                                           guint collect_flags)
{
#line 143 "/home/jens/Source/shotwell/src/core/util.vala"
	if (collect_values[0].v_pointer) {
#line 1343 "util.c"
		UnknownTotalMonitor * object;
		object = collect_values[0].v_pointer;
#line 143 "/home/jens/Source/shotwell/src/core/util.vala"
		if (object->parent_instance.g_class == NULL) {
#line 143 "/home/jens/Source/shotwell/src/core/util.vala"
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 1350 "util.c"
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
#line 143 "/home/jens/Source/shotwell/src/core/util.vala"
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 1354 "util.c"
		}
#line 143 "/home/jens/Source/shotwell/src/core/util.vala"
		value->data[0].v_pointer = unknown_total_monitor_ref (object);
#line 1358 "util.c"
	} else {
#line 143 "/home/jens/Source/shotwell/src/core/util.vala"
		value->data[0].v_pointer = NULL;
#line 1362 "util.c"
	}
#line 143 "/home/jens/Source/shotwell/src/core/util.vala"
	return NULL;
#line 1366 "util.c"
}


static gchar*
value_unknown_total_monitor_lcopy_value (const GValue* value,
                                         guint n_collect_values,
                                         GTypeCValue* collect_values,
                                         guint collect_flags)
{
	UnknownTotalMonitor ** object_p;
	object_p = collect_values[0].v_pointer;
#line 143 "/home/jens/Source/shotwell/src/core/util.vala"
	if (!object_p) {
#line 143 "/home/jens/Source/shotwell/src/core/util.vala"
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
#line 1382 "util.c"
	}
#line 143 "/home/jens/Source/shotwell/src/core/util.vala"
	if (!value->data[0].v_pointer) {
#line 143 "/home/jens/Source/shotwell/src/core/util.vala"
		*object_p = NULL;
#line 1388 "util.c"
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
#line 143 "/home/jens/Source/shotwell/src/core/util.vala"
		*object_p = value->data[0].v_pointer;
#line 1392 "util.c"
	} else {
#line 143 "/home/jens/Source/shotwell/src/core/util.vala"
		*object_p = unknown_total_monitor_ref (value->data[0].v_pointer);
#line 1396 "util.c"
	}
#line 143 "/home/jens/Source/shotwell/src/core/util.vala"
	return NULL;
#line 1400 "util.c"
}


GParamSpec*
param_spec_unknown_total_monitor (const gchar* name,
                                  const gchar* nick,
                                  const gchar* blurb,
                                  GType object_type,
                                  GParamFlags flags)
{
	ParamSpecUnknownTotalMonitor* spec;
#line 143 "/home/jens/Source/shotwell/src/core/util.vala"
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_UNKNOWN_TOTAL_MONITOR), NULL);
#line 143 "/home/jens/Source/shotwell/src/core/util.vala"
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
#line 143 "/home/jens/Source/shotwell/src/core/util.vala"
	G_PARAM_SPEC (spec)->value_type = object_type;
#line 143 "/home/jens/Source/shotwell/src/core/util.vala"
	return G_PARAM_SPEC (spec);
#line 1420 "util.c"
}


gpointer
value_get_unknown_total_monitor (const GValue* value)
{
#line 143 "/home/jens/Source/shotwell/src/core/util.vala"
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_UNKNOWN_TOTAL_MONITOR), NULL);
#line 143 "/home/jens/Source/shotwell/src/core/util.vala"
	return value->data[0].v_pointer;
#line 1431 "util.c"
}


void
value_set_unknown_total_monitor (GValue* value,
                                 gpointer v_object)
{
	UnknownTotalMonitor * old;
#line 143 "/home/jens/Source/shotwell/src/core/util.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_UNKNOWN_TOTAL_MONITOR));
#line 143 "/home/jens/Source/shotwell/src/core/util.vala"
	old = value->data[0].v_pointer;
#line 143 "/home/jens/Source/shotwell/src/core/util.vala"
	if (v_object) {
#line 143 "/home/jens/Source/shotwell/src/core/util.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_UNKNOWN_TOTAL_MONITOR));
#line 143 "/home/jens/Source/shotwell/src/core/util.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 143 "/home/jens/Source/shotwell/src/core/util.vala"
		value->data[0].v_pointer = v_object;
#line 143 "/home/jens/Source/shotwell/src/core/util.vala"
		unknown_total_monitor_ref (value->data[0].v_pointer);
#line 1454 "util.c"
	} else {
#line 143 "/home/jens/Source/shotwell/src/core/util.vala"
		value->data[0].v_pointer = NULL;
#line 1458 "util.c"
	}
#line 143 "/home/jens/Source/shotwell/src/core/util.vala"
	if (old) {
#line 143 "/home/jens/Source/shotwell/src/core/util.vala"
		unknown_total_monitor_unref (old);
#line 1464 "util.c"
	}
}


void
value_take_unknown_total_monitor (GValue* value,
                                  gpointer v_object)
{
	UnknownTotalMonitor * old;
#line 143 "/home/jens/Source/shotwell/src/core/util.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_UNKNOWN_TOTAL_MONITOR));
#line 143 "/home/jens/Source/shotwell/src/core/util.vala"
	old = value->data[0].v_pointer;
#line 143 "/home/jens/Source/shotwell/src/core/util.vala"
	if (v_object) {
#line 143 "/home/jens/Source/shotwell/src/core/util.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_UNKNOWN_TOTAL_MONITOR));
#line 143 "/home/jens/Source/shotwell/src/core/util.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 143 "/home/jens/Source/shotwell/src/core/util.vala"
		value->data[0].v_pointer = v_object;
#line 1486 "util.c"
	} else {
#line 143 "/home/jens/Source/shotwell/src/core/util.vala"
		value->data[0].v_pointer = NULL;
#line 1490 "util.c"
	}
#line 143 "/home/jens/Source/shotwell/src/core/util.vala"
	if (old) {
#line 143 "/home/jens/Source/shotwell/src/core/util.vala"
		unknown_total_monitor_unref (old);
#line 1496 "util.c"
	}
}


static void
unknown_total_monitor_class_init (UnknownTotalMonitorClass * klass)
{
#line 143 "/home/jens/Source/shotwell/src/core/util.vala"
	unknown_total_monitor_parent_class = g_type_class_peek_parent (klass);
#line 143 "/home/jens/Source/shotwell/src/core/util.vala"
	((UnknownTotalMonitorClass *) klass)->finalize = unknown_total_monitor_finalize;
#line 143 "/home/jens/Source/shotwell/src/core/util.vala"
	g_type_class_add_private (klass, sizeof (UnknownTotalMonitorPrivate));
#line 1510 "util.c"
}


static void
unknown_total_monitor_instance_init (UnknownTotalMonitor * self)
{
#line 143 "/home/jens/Source/shotwell/src/core/util.vala"
	self->priv = UNKNOWN_TOTAL_MONITOR_GET_PRIVATE (self);
#line 143 "/home/jens/Source/shotwell/src/core/util.vala"
	self->ref_count = 1;
#line 1521 "util.c"
}


static void
unknown_total_monitor_finalize (UnknownTotalMonitor * obj)
{
	UnknownTotalMonitor * self;
#line 143 "/home/jens/Source/shotwell/src/core/util.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_UNKNOWN_TOTAL_MONITOR, UnknownTotalMonitor);
#line 143 "/home/jens/Source/shotwell/src/core/util.vala"
	g_signal_handlers_destroy (self);
#line 1533 "util.c"
}


GType
unknown_total_monitor_get_type (void)
{
	static volatile gsize unknown_total_monitor_type_id__volatile = 0;
	if (g_once_init_enter (&unknown_total_monitor_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { value_unknown_total_monitor_init, value_unknown_total_monitor_free_value, value_unknown_total_monitor_copy_value, value_unknown_total_monitor_peek_pointer, "p", value_unknown_total_monitor_collect_value, "p", value_unknown_total_monitor_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (UnknownTotalMonitorClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) unknown_total_monitor_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (UnknownTotalMonitor), 0, (GInstanceInitFunc) unknown_total_monitor_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType unknown_total_monitor_type_id;
		unknown_total_monitor_type_id = g_type_register_fundamental (g_type_fundamental_next (), "UnknownTotalMonitor", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&unknown_total_monitor_type_id__volatile, unknown_total_monitor_type_id);
	}
	return unknown_total_monitor_type_id__volatile;
}


gpointer
unknown_total_monitor_ref (gpointer instance)
{
	UnknownTotalMonitor * self;
	self = instance;
#line 143 "/home/jens/Source/shotwell/src/core/util.vala"
	g_atomic_int_inc (&self->ref_count);
#line 143 "/home/jens/Source/shotwell/src/core/util.vala"
	return instance;
#line 1562 "util.c"
}


void
unknown_total_monitor_unref (gpointer instance)
{
	UnknownTotalMonitor * self;
	self = instance;
#line 143 "/home/jens/Source/shotwell/src/core/util.vala"
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
#line 143 "/home/jens/Source/shotwell/src/core/util.vala"
		UNKNOWN_TOTAL_MONITOR_GET_CLASS (self)->finalize (self);
#line 143 "/home/jens/Source/shotwell/src/core/util.vala"
		g_type_free_instance ((GTypeInstance *) self);
#line 1577 "util.c"
	}
}


AggregateProgressMonitor*
aggregate_progress_monitor_construct (GType object_type,
                                      guint64 grand_total,
                                      ProgressMonitor wrapped_monitor,
                                      void* wrapped_monitor_target)
{
	AggregateProgressMonitor* self = NULL;
#line 165 "/home/jens/Source/shotwell/src/core/util.vala"
	self = (AggregateProgressMonitor*) g_type_create_instance (object_type);
#line 166 "/home/jens/Source/shotwell/src/core/util.vala"
	self->priv->grand_total = grand_total;
#line 167 "/home/jens/Source/shotwell/src/core/util.vala"
	self->priv->wrapped_monitor = wrapped_monitor;
#line 167 "/home/jens/Source/shotwell/src/core/util.vala"
	self->priv->wrapped_monitor_target = wrapped_monitor_target;
#line 165 "/home/jens/Source/shotwell/src/core/util.vala"
	return self;
#line 1599 "util.c"
}


AggregateProgressMonitor*
aggregate_progress_monitor_new (guint64 grand_total,
                                ProgressMonitor wrapped_monitor,
                                void* wrapped_monitor_target)
{
#line 165 "/home/jens/Source/shotwell/src/core/util.vala"
	return aggregate_progress_monitor_construct (TYPE_AGGREGATE_PROGRESS_MONITOR, grand_total, wrapped_monitor, wrapped_monitor_target);
#line 1610 "util.c"
}


void
aggregate_progress_monitor_next_step (AggregateProgressMonitor* self,
                                      const gchar* name)
{
	guint64 _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	guint64 _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
#line 170 "/home/jens/Source/shotwell/src/core/util.vala"
	g_return_if_fail (IS_AGGREGATE_PROGRESS_MONITOR (self));
#line 170 "/home/jens/Source/shotwell/src/core/util.vala"
	g_return_if_fail (name != NULL);
#line 171 "/home/jens/Source/shotwell/src/core/util.vala"
	_tmp0_ = self->priv->aggregate_count;
#line 171 "/home/jens/Source/shotwell/src/core/util.vala"
	_tmp1_ = g_strdup_printf ("%" G_GUINT64_FORMAT, _tmp0_);
#line 171 "/home/jens/Source/shotwell/src/core/util.vala"
	_tmp2_ = _tmp1_;
#line 171 "/home/jens/Source/shotwell/src/core/util.vala"
	_tmp3_ = self->priv->grand_total;
#line 171 "/home/jens/Source/shotwell/src/core/util.vala"
	_tmp4_ = g_strdup_printf ("%" G_GUINT64_FORMAT, _tmp3_);
#line 171 "/home/jens/Source/shotwell/src/core/util.vala"
	_tmp5_ = _tmp4_;
#line 171 "/home/jens/Source/shotwell/src/core/util.vala"
	g_debug ("util.vala:171: next step: %s (%s/%s)", name, _tmp2_, _tmp5_);
#line 171 "/home/jens/Source/shotwell/src/core/util.vala"
	_g_free0 (_tmp5_);
#line 171 "/home/jens/Source/shotwell/src/core/util.vala"
	_g_free0 (_tmp2_);
#line 172 "/home/jens/Source/shotwell/src/core/util.vala"
	self->priv->last_count = G_MAXUINT64;
#line 1648 "util.c"
}


gboolean
aggregate_progress_monitor_monitor (AggregateProgressMonitor* self,
                                    guint64 count,
                                    guint64 total)
{
	gboolean result = FALSE;
	guint64 _tmp0_ = 0ULL;
	guint64 _tmp1_;
	guint64 _tmp3_;
	guint64 _tmp4_;
	guint64 _tmp5_;
	ProgressMonitor _tmp7_;
	void* _tmp7__target;
	guint64 _tmp8_;
	guint64 _tmp9_;
#line 175 "/home/jens/Source/shotwell/src/core/util.vala"
	g_return_val_if_fail (IS_AGGREGATE_PROGRESS_MONITOR (self), FALSE);
#line 177 "/home/jens/Source/shotwell/src/core/util.vala"
	_tmp1_ = self->priv->last_count;
#line 177 "/home/jens/Source/shotwell/src/core/util.vala"
	if (_tmp1_ != G_MAXUINT64) {
#line 1673 "util.c"
		guint64 _tmp2_;
#line 177 "/home/jens/Source/shotwell/src/core/util.vala"
		_tmp2_ = self->priv->last_count;
#line 177 "/home/jens/Source/shotwell/src/core/util.vala"
		_tmp0_ = count - _tmp2_;
#line 1679 "util.c"
	} else {
#line 177 "/home/jens/Source/shotwell/src/core/util.vala"
		_tmp0_ = count;
#line 1683 "util.c"
	}
#line 177 "/home/jens/Source/shotwell/src/core/util.vala"
	_tmp3_ = self->priv->aggregate_count;
#line 177 "/home/jens/Source/shotwell/src/core/util.vala"
	self->priv->aggregate_count = _tmp3_ + _tmp0_;
#line 178 "/home/jens/Source/shotwell/src/core/util.vala"
	_tmp4_ = self->priv->aggregate_count;
#line 178 "/home/jens/Source/shotwell/src/core/util.vala"
	_tmp5_ = self->priv->grand_total;
#line 178 "/home/jens/Source/shotwell/src/core/util.vala"
	if (_tmp4_ > _tmp5_) {
#line 1695 "util.c"
		guint64 _tmp6_;
#line 179 "/home/jens/Source/shotwell/src/core/util.vala"
		_tmp6_ = self->priv->grand_total;
#line 179 "/home/jens/Source/shotwell/src/core/util.vala"
		self->priv->aggregate_count = _tmp6_;
#line 1701 "util.c"
	}
#line 182 "/home/jens/Source/shotwell/src/core/util.vala"
	self->priv->last_count = count;
#line 184 "/home/jens/Source/shotwell/src/core/util.vala"
	_tmp7_ = self->priv->wrapped_monitor;
#line 184 "/home/jens/Source/shotwell/src/core/util.vala"
	_tmp7__target = self->priv->wrapped_monitor_target;
#line 184 "/home/jens/Source/shotwell/src/core/util.vala"
	_tmp8_ = self->priv->aggregate_count;
#line 184 "/home/jens/Source/shotwell/src/core/util.vala"
	_tmp9_ = self->priv->grand_total;
#line 184 "/home/jens/Source/shotwell/src/core/util.vala"
	result = _tmp7_ (_tmp8_, _tmp9_, TRUE, _tmp7__target);
#line 184 "/home/jens/Source/shotwell/src/core/util.vala"
	return result;
#line 1717 "util.c"
}


static void
value_aggregate_progress_monitor_init (GValue* value)
{
#line 159 "/home/jens/Source/shotwell/src/core/util.vala"
	value->data[0].v_pointer = NULL;
#line 1726 "util.c"
}


static void
value_aggregate_progress_monitor_free_value (GValue* value)
{
#line 159 "/home/jens/Source/shotwell/src/core/util.vala"
	if (value->data[0].v_pointer) {
#line 159 "/home/jens/Source/shotwell/src/core/util.vala"
		aggregate_progress_monitor_unref (value->data[0].v_pointer);
#line 1737 "util.c"
	}
}


static void
value_aggregate_progress_monitor_copy_value (const GValue* src_value,
                                             GValue* dest_value)
{
#line 159 "/home/jens/Source/shotwell/src/core/util.vala"
	if (src_value->data[0].v_pointer) {
#line 159 "/home/jens/Source/shotwell/src/core/util.vala"
		dest_value->data[0].v_pointer = aggregate_progress_monitor_ref (src_value->data[0].v_pointer);
#line 1750 "util.c"
	} else {
#line 159 "/home/jens/Source/shotwell/src/core/util.vala"
		dest_value->data[0].v_pointer = NULL;
#line 1754 "util.c"
	}
}


static gpointer
value_aggregate_progress_monitor_peek_pointer (const GValue* value)
{
#line 159 "/home/jens/Source/shotwell/src/core/util.vala"
	return value->data[0].v_pointer;
#line 1764 "util.c"
}


static gchar*
value_aggregate_progress_monitor_collect_value (GValue* value,
                                                guint n_collect_values,
                                                GTypeCValue* collect_values,
                                                guint collect_flags)
{
#line 159 "/home/jens/Source/shotwell/src/core/util.vala"
	if (collect_values[0].v_pointer) {
#line 1776 "util.c"
		AggregateProgressMonitor * object;
		object = collect_values[0].v_pointer;
#line 159 "/home/jens/Source/shotwell/src/core/util.vala"
		if (object->parent_instance.g_class == NULL) {
#line 159 "/home/jens/Source/shotwell/src/core/util.vala"
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 1783 "util.c"
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
#line 159 "/home/jens/Source/shotwell/src/core/util.vala"
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 1787 "util.c"
		}
#line 159 "/home/jens/Source/shotwell/src/core/util.vala"
		value->data[0].v_pointer = aggregate_progress_monitor_ref (object);
#line 1791 "util.c"
	} else {
#line 159 "/home/jens/Source/shotwell/src/core/util.vala"
		value->data[0].v_pointer = NULL;
#line 1795 "util.c"
	}
#line 159 "/home/jens/Source/shotwell/src/core/util.vala"
	return NULL;
#line 1799 "util.c"
}


static gchar*
value_aggregate_progress_monitor_lcopy_value (const GValue* value,
                                              guint n_collect_values,
                                              GTypeCValue* collect_values,
                                              guint collect_flags)
{
	AggregateProgressMonitor ** object_p;
	object_p = collect_values[0].v_pointer;
#line 159 "/home/jens/Source/shotwell/src/core/util.vala"
	if (!object_p) {
#line 159 "/home/jens/Source/shotwell/src/core/util.vala"
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
#line 1815 "util.c"
	}
#line 159 "/home/jens/Source/shotwell/src/core/util.vala"
	if (!value->data[0].v_pointer) {
#line 159 "/home/jens/Source/shotwell/src/core/util.vala"
		*object_p = NULL;
#line 1821 "util.c"
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
#line 159 "/home/jens/Source/shotwell/src/core/util.vala"
		*object_p = value->data[0].v_pointer;
#line 1825 "util.c"
	} else {
#line 159 "/home/jens/Source/shotwell/src/core/util.vala"
		*object_p = aggregate_progress_monitor_ref (value->data[0].v_pointer);
#line 1829 "util.c"
	}
#line 159 "/home/jens/Source/shotwell/src/core/util.vala"
	return NULL;
#line 1833 "util.c"
}


GParamSpec*
param_spec_aggregate_progress_monitor (const gchar* name,
                                       const gchar* nick,
                                       const gchar* blurb,
                                       GType object_type,
                                       GParamFlags flags)
{
	ParamSpecAggregateProgressMonitor* spec;
#line 159 "/home/jens/Source/shotwell/src/core/util.vala"
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_AGGREGATE_PROGRESS_MONITOR), NULL);
#line 159 "/home/jens/Source/shotwell/src/core/util.vala"
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
#line 159 "/home/jens/Source/shotwell/src/core/util.vala"
	G_PARAM_SPEC (spec)->value_type = object_type;
#line 159 "/home/jens/Source/shotwell/src/core/util.vala"
	return G_PARAM_SPEC (spec);
#line 1853 "util.c"
}


gpointer
value_get_aggregate_progress_monitor (const GValue* value)
{
#line 159 "/home/jens/Source/shotwell/src/core/util.vala"
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_AGGREGATE_PROGRESS_MONITOR), NULL);
#line 159 "/home/jens/Source/shotwell/src/core/util.vala"
	return value->data[0].v_pointer;
#line 1864 "util.c"
}


void
value_set_aggregate_progress_monitor (GValue* value,
                                      gpointer v_object)
{
	AggregateProgressMonitor * old;
#line 159 "/home/jens/Source/shotwell/src/core/util.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_AGGREGATE_PROGRESS_MONITOR));
#line 159 "/home/jens/Source/shotwell/src/core/util.vala"
	old = value->data[0].v_pointer;
#line 159 "/home/jens/Source/shotwell/src/core/util.vala"
	if (v_object) {
#line 159 "/home/jens/Source/shotwell/src/core/util.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_AGGREGATE_PROGRESS_MONITOR));
#line 159 "/home/jens/Source/shotwell/src/core/util.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 159 "/home/jens/Source/shotwell/src/core/util.vala"
		value->data[0].v_pointer = v_object;
#line 159 "/home/jens/Source/shotwell/src/core/util.vala"
		aggregate_progress_monitor_ref (value->data[0].v_pointer);
#line 1887 "util.c"
	} else {
#line 159 "/home/jens/Source/shotwell/src/core/util.vala"
		value->data[0].v_pointer = NULL;
#line 1891 "util.c"
	}
#line 159 "/home/jens/Source/shotwell/src/core/util.vala"
	if (old) {
#line 159 "/home/jens/Source/shotwell/src/core/util.vala"
		aggregate_progress_monitor_unref (old);
#line 1897 "util.c"
	}
}


void
value_take_aggregate_progress_monitor (GValue* value,
                                       gpointer v_object)
{
	AggregateProgressMonitor * old;
#line 159 "/home/jens/Source/shotwell/src/core/util.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_AGGREGATE_PROGRESS_MONITOR));
#line 159 "/home/jens/Source/shotwell/src/core/util.vala"
	old = value->data[0].v_pointer;
#line 159 "/home/jens/Source/shotwell/src/core/util.vala"
	if (v_object) {
#line 159 "/home/jens/Source/shotwell/src/core/util.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_AGGREGATE_PROGRESS_MONITOR));
#line 159 "/home/jens/Source/shotwell/src/core/util.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 159 "/home/jens/Source/shotwell/src/core/util.vala"
		value->data[0].v_pointer = v_object;
#line 1919 "util.c"
	} else {
#line 159 "/home/jens/Source/shotwell/src/core/util.vala"
		value->data[0].v_pointer = NULL;
#line 1923 "util.c"
	}
#line 159 "/home/jens/Source/shotwell/src/core/util.vala"
	if (old) {
#line 159 "/home/jens/Source/shotwell/src/core/util.vala"
		aggregate_progress_monitor_unref (old);
#line 1929 "util.c"
	}
}


static void
aggregate_progress_monitor_class_init (AggregateProgressMonitorClass * klass)
{
#line 159 "/home/jens/Source/shotwell/src/core/util.vala"
	aggregate_progress_monitor_parent_class = g_type_class_peek_parent (klass);
#line 159 "/home/jens/Source/shotwell/src/core/util.vala"
	((AggregateProgressMonitorClass *) klass)->finalize = aggregate_progress_monitor_finalize;
#line 159 "/home/jens/Source/shotwell/src/core/util.vala"
	g_type_class_add_private (klass, sizeof (AggregateProgressMonitorPrivate));
#line 1943 "util.c"
}


static void
aggregate_progress_monitor_instance_init (AggregateProgressMonitor * self)
{
#line 159 "/home/jens/Source/shotwell/src/core/util.vala"
	self->priv = AGGREGATE_PROGRESS_MONITOR_GET_PRIVATE (self);
#line 162 "/home/jens/Source/shotwell/src/core/util.vala"
	self->priv->aggregate_count = (guint64) 0;
#line 163 "/home/jens/Source/shotwell/src/core/util.vala"
	self->priv->last_count = G_MAXUINT64;
#line 159 "/home/jens/Source/shotwell/src/core/util.vala"
	self->ref_count = 1;
#line 1958 "util.c"
}


static void
aggregate_progress_monitor_finalize (AggregateProgressMonitor * obj)
{
	AggregateProgressMonitor * self;
#line 159 "/home/jens/Source/shotwell/src/core/util.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_AGGREGATE_PROGRESS_MONITOR, AggregateProgressMonitor);
#line 159 "/home/jens/Source/shotwell/src/core/util.vala"
	g_signal_handlers_destroy (self);
#line 1970 "util.c"
}


GType
aggregate_progress_monitor_get_type (void)
{
	static volatile gsize aggregate_progress_monitor_type_id__volatile = 0;
	if (g_once_init_enter (&aggregate_progress_monitor_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { value_aggregate_progress_monitor_init, value_aggregate_progress_monitor_free_value, value_aggregate_progress_monitor_copy_value, value_aggregate_progress_monitor_peek_pointer, "p", value_aggregate_progress_monitor_collect_value, "p", value_aggregate_progress_monitor_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (AggregateProgressMonitorClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) aggregate_progress_monitor_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (AggregateProgressMonitor), 0, (GInstanceInitFunc) aggregate_progress_monitor_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType aggregate_progress_monitor_type_id;
		aggregate_progress_monitor_type_id = g_type_register_fundamental (g_type_fundamental_next (), "AggregateProgressMonitor", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&aggregate_progress_monitor_type_id__volatile, aggregate_progress_monitor_type_id);
	}
	return aggregate_progress_monitor_type_id__volatile;
}


gpointer
aggregate_progress_monitor_ref (gpointer instance)
{
	AggregateProgressMonitor * self;
	self = instance;
#line 159 "/home/jens/Source/shotwell/src/core/util.vala"
	g_atomic_int_inc (&self->ref_count);
#line 159 "/home/jens/Source/shotwell/src/core/util.vala"
	return instance;
#line 1999 "util.c"
}


void
aggregate_progress_monitor_unref (gpointer instance)
{
	AggregateProgressMonitor * self;
	self = instance;
#line 159 "/home/jens/Source/shotwell/src/core/util.vala"
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
#line 159 "/home/jens/Source/shotwell/src/core/util.vala"
		AGGREGATE_PROGRESS_MONITOR_GET_CLASS (self)->finalize (self);
#line 159 "/home/jens/Source/shotwell/src/core/util.vala"
		g_type_free_instance ((GTypeInstance *) self);
#line 2014 "util.c"
	}
}


gboolean
null_progress_monitor (guint64 count,
                       guint64 total)
{
	gboolean result = FALSE;
#line 190 "/home/jens/Source/shotwell/src/core/util.vala"
	result = TRUE;
#line 190 "/home/jens/Source/shotwell/src/core/util.vala"
	return result;
#line 2028 "util.c"
}


gdouble
degrees_to_radians (gdouble theta)
{
	gdouble result = 0.0;
#line 195 "/home/jens/Source/shotwell/src/core/util.vala"
	result = theta * (G_PI / 180.0);
#line 195 "/home/jens/Source/shotwell/src/core/util.vala"
	return result;
#line 2040 "util.c"
}



