/* ui.c generated by valac 0.30.1, the Vala compiler
 * generated from ui.vala, do not modify */

/*
 * Copyright (C) 2009-2011 Canonical Ltd.
 * Author: Robert Ancell <robert.ancell@canonical.com>
 *
 * This program is free software: you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation, either version 3 of the License, or (at your option) any later
 * version. See http://www.gnu.org/copyleft/gpl.html the full text of the
 * license.
 */

#include <glib.h>
#include <glib-object.h>
#include <gio/gio.h>
#include <gtk/gtk.h>
#include <stdlib.h>
#include <string.h>
#include <glib/gi18n-lib.h>
#include <cairo.h>
#include <float.h>
#include <math.h>
#include <gdk-pixbuf/gdk-pixbuf.h>
#include <gdk/gdk.h>
#include <glib/gstdio.h>
#include <unistd.h>
#include <gobject/gvaluecollector.h>


#define TYPE_USER_INTERFACE (user_interface_get_type ())
#define USER_INTERFACE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_USER_INTERFACE, UserInterface))
#define USER_INTERFACE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_USER_INTERFACE, UserInterfaceClass))
#define IS_USER_INTERFACE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_USER_INTERFACE))
#define IS_USER_INTERFACE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_USER_INTERFACE))
#define USER_INTERFACE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_USER_INTERFACE, UserInterfaceClass))

typedef struct _UserInterface UserInterface;
typedef struct _UserInterfaceClass UserInterfaceClass;
typedef struct _UserInterfacePrivate UserInterfacePrivate;

#define TYPE_PROGRESS_BAR_DIALOG (progress_bar_dialog_get_type ())
#define PROGRESS_BAR_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PROGRESS_BAR_DIALOG, ProgressBarDialog))
#define PROGRESS_BAR_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PROGRESS_BAR_DIALOG, ProgressBarDialogClass))
#define IS_PROGRESS_BAR_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PROGRESS_BAR_DIALOG))
#define IS_PROGRESS_BAR_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PROGRESS_BAR_DIALOG))
#define PROGRESS_BAR_DIALOG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PROGRESS_BAR_DIALOG, ProgressBarDialogClass))

typedef struct _ProgressBarDialog ProgressBarDialog;
typedef struct _ProgressBarDialogClass ProgressBarDialogClass;

#define TYPE_BOOK (book_get_type ())
#define BOOK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_BOOK, Book))
#define BOOK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_BOOK, BookClass))
#define IS_BOOK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_BOOK))
#define IS_BOOK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_BOOK))
#define BOOK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_BOOK, BookClass))

typedef struct _Book Book;
typedef struct _BookClass BookClass;

#define TYPE_AUTOSAVE_MANAGER (autosave_manager_get_type ())
#define AUTOSAVE_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_AUTOSAVE_MANAGER, AutosaveManager))
#define AUTOSAVE_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_AUTOSAVE_MANAGER, AutosaveManagerClass))
#define IS_AUTOSAVE_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_AUTOSAVE_MANAGER))
#define IS_AUTOSAVE_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_AUTOSAVE_MANAGER))
#define AUTOSAVE_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_AUTOSAVE_MANAGER, AutosaveManagerClass))

typedef struct _AutosaveManager AutosaveManager;
typedef struct _AutosaveManagerClass AutosaveManagerClass;

#define TYPE_BOOK_VIEW (book_view_get_type ())
#define BOOK_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_BOOK_VIEW, BookView))
#define BOOK_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_BOOK_VIEW, BookViewClass))
#define IS_BOOK_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_BOOK_VIEW))
#define IS_BOOK_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_BOOK_VIEW))
#define BOOK_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_BOOK_VIEW, BookViewClass))

typedef struct _BookView BookView;
typedef struct _BookViewClass BookViewClass;

#define TYPE_SCAN_DIRECTION (scan_direction_get_type ())

#define TYPE_PAGE (page_get_type ())
#define PAGE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PAGE, Page))
#define PAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PAGE, PageClass))
#define IS_PAGE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PAGE))
#define IS_PAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PAGE))
#define PAGE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PAGE, PageClass))

typedef struct _Page Page;
typedef struct _PageClass PageClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _book_unref0(var) ((var == NULL) ? NULL : (var = (book_unref (var), NULL)))
#define _autosave_manager_unref0(var) ((var == NULL) ? NULL : (var = (autosave_manager_unref (var), NULL)))
#define _page_unref0(var) ((var == NULL) ? NULL : (var = (page_unref (var), NULL)))

#define TYPE_SCAN_DEVICE (scan_device_get_type ())
#define SCAN_DEVICE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SCAN_DEVICE, ScanDevice))
#define SCAN_DEVICE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SCAN_DEVICE, ScanDeviceClass))
#define IS_SCAN_DEVICE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SCAN_DEVICE))
#define IS_SCAN_DEVICE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SCAN_DEVICE))
#define SCAN_DEVICE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SCAN_DEVICE, ScanDeviceClass))

typedef struct _ScanDevice ScanDevice;
typedef struct _ScanDeviceClass ScanDeviceClass;
typedef struct _ScanDevicePrivate ScanDevicePrivate;
#define _scan_device_unref0(var) ((var == NULL) ? NULL : (var = (scan_device_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define TYPE_SCAN_TYPE (scan_type_get_type ())

#define TYPE_SCAN_OPTIONS (scan_options_get_type ())
#define SCAN_OPTIONS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SCAN_OPTIONS, ScanOptions))
#define SCAN_OPTIONS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SCAN_OPTIONS, ScanOptionsClass))
#define IS_SCAN_OPTIONS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SCAN_OPTIONS))
#define IS_SCAN_OPTIONS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SCAN_OPTIONS))
#define SCAN_OPTIONS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SCAN_OPTIONS, ScanOptionsClass))

typedef struct _ScanOptions ScanOptions;
typedef struct _ScanOptionsClass ScanOptionsClass;

#define TYPE_SCAN_MODE (scan_mode_get_type ())
typedef struct _ScanOptionsPrivate ScanOptionsPrivate;
#define _scan_options_unref0(var) ((var == NULL) ? NULL : (var = (scan_options_unref (var), NULL)))
#define _cairo_destroy0(var) ((var == NULL) ? NULL : (var = (cairo_destroy (var), NULL)))
#define _g_key_file_unref0(var) ((var == NULL) ? NULL : (var = (g_key_file_unref (var), NULL)))
typedef struct _ParamSpecUserInterface ParamSpecUserInterface;
typedef struct _ProgressBarDialogPrivate ProgressBarDialogPrivate;

struct _UserInterface {
	GTypeInstance parent_instance;
	volatile int ref_count;
	UserInterfacePrivate * priv;
};

struct _UserInterfaceClass {
	GTypeClass parent_class;
	void (*finalize) (UserInterface *self);
};

typedef enum  {
	SCAN_DIRECTION_TOP_TO_BOTTOM,
	SCAN_DIRECTION_LEFT_TO_RIGHT,
	SCAN_DIRECTION_BOTTOM_TO_TOP,
	SCAN_DIRECTION_RIGHT_TO_LEFT
} ScanDirection;

struct _UserInterfacePrivate {
	GSettings* settings;
	GtkBuilder* builder;
	GtkApplicationWindow* window;
	GMenuModel* app_menu;
	GtkMenuBar* menubar;
	GtkBox* main_vbox;
	GtkInfoBar* info_bar;
	GtkImage* info_bar_image;
	GtkLabel* info_bar_label;
	GtkButton* info_bar_close_button;
	GtkButton* info_bar_change_scanner_button;
	GtkMenuItem* page_move_left_menuitem;
	GtkMenuItem* page_move_right_menuitem;
	GtkMenuItem* page_delete_menuitem;
	GtkMenuItem* crop_rotate_menuitem;
	GtkMenuItem* save_menuitem;
	GtkMenuItem* save_as_menuitem;
	GtkMenuItem* copy_to_clipboard_menuitem;
	GtkToolButton* save_toolbutton;
	GtkMenuItem* stop_menuitem;
	GtkToolButton* stop_toolbutton;
	GtkRadioMenuItem* text_toolbar_menuitem;
	GtkRadioMenuItem* text_menu_menuitem;
	GtkRadioMenuItem* photo_toolbar_menuitem;
	GtkRadioMenuItem* photo_menu_menuitem;
	GtkDialog* authorize_dialog;
	GtkLabel* authorize_label;
	GtkEntry* username_entry;
	GtkEntry* password_entry;
	GtkDialog* preferences_dialog;
	GtkComboBox* device_combo;
	GtkComboBox* text_dpi_combo;
	GtkComboBox* photo_dpi_combo;
	GtkComboBox* page_side_combo;
	GtkComboBox* paper_size_combo;
	GtkScale* brightness_scale;
	GtkScale* contrast_scale;
	GtkScale* quality_scale;
	GtkListStore* device_model;
	GtkListStore* text_dpi_model;
	GtkListStore* photo_dpi_model;
	GtkListStore* page_side_model;
	GtkListStore* paper_size_model;
	GtkAdjustment* brightness_adjustment;
	GtkAdjustment* contrast_adjustment;
	GtkAdjustment* quality_adjustment;
	gboolean setting_devices;
	gboolean user_selected_device;
	GtkFileChooserDialog* save_dialog;
	ProgressBarDialog* progress_dialog;
	gboolean have_error;
	gchar* error_title;
	gchar* error_text;
	gboolean error_change_scanner_hint;
	Book* _book;
	gchar* book_uri;
	AutosaveManager* autosave_manager;
	BookView* book_view;
	gboolean updating_page_menu;
	gint default_page_width;
	gint default_page_height;
	gint default_page_dpi;
	ScanDirection default_page_scan_direction;
	gchar* document_hint;
	gchar* _default_file_name;
	gboolean scanning_;
	gint window_width;
	gint window_height;
	gboolean window_is_maximized;
	guint save_state_timeout;
};

struct _ScanDevice {
	GTypeInstance parent_instance;
	volatile int ref_count;
	ScanDevicePrivate * priv;
	gchar* name;
	gchar* label;
};

struct _ScanDeviceClass {
	GTypeClass parent_class;
	void (*finalize) (ScanDevice *self);
};

typedef enum  {
	SCAN_TYPE_SINGLE,
	SCAN_TYPE_ADF_FRONT,
	SCAN_TYPE_ADF_BACK,
	SCAN_TYPE_ADF_BOTH
} ScanType;

typedef enum  {
	SCAN_MODE_DEFAULT,
	SCAN_MODE_COLOR,
	SCAN_MODE_GRAY,
	SCAN_MODE_LINEART
} ScanMode;

struct _ScanOptions {
	GTypeInstance parent_instance;
	volatile int ref_count;
	ScanOptionsPrivate * priv;
	gint dpi;
	ScanMode scan_mode;
	gint depth;
	ScanType type;
	gint paper_width;
	gint paper_height;
	gint brightness;
	gint contrast;
};

struct _ScanOptionsClass {
	GTypeClass parent_class;
	void (*finalize) (ScanOptions *self);
};

struct _ParamSpecUserInterface {
	GParamSpec parent_instance;
};

struct _ProgressBarDialog {
	GtkWindow parent_instance;
	ProgressBarDialogPrivate * priv;
};

struct _ProgressBarDialogClass {
	GtkWindowClass parent_class;
};

struct _ProgressBarDialogPrivate {
	GtkProgressBar* bar;
};


static gpointer user_interface_parent_class = NULL;
static gpointer progress_bar_dialog_parent_class = NULL;

gpointer user_interface_ref (gpointer instance);
void user_interface_unref (gpointer instance);
GParamSpec* param_spec_user_interface (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_user_interface (GValue* value, gpointer v_object);
void value_take_user_interface (GValue* value, gpointer v_object);
gpointer value_get_user_interface (const GValue* value);
GType user_interface_get_type (void) G_GNUC_CONST;
GType progress_bar_dialog_get_type (void) G_GNUC_CONST;
gpointer book_ref (gpointer instance);
void book_unref (gpointer instance);
GParamSpec* param_spec_book (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_book (GValue* value, gpointer v_object);
void value_take_book (GValue* value, gpointer v_object);
gpointer value_get_book (const GValue* value);
GType book_get_type (void) G_GNUC_CONST;
gpointer autosave_manager_ref (gpointer instance);
void autosave_manager_unref (gpointer instance);
GParamSpec* param_spec_autosave_manager (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_autosave_manager (GValue* value, gpointer v_object);
void value_take_autosave_manager (GValue* value, gpointer v_object);
gpointer value_get_autosave_manager (const GValue* value);
GType autosave_manager_get_type (void) G_GNUC_CONST;
GType book_view_get_type (void) G_GNUC_CONST;
GType scan_direction_get_type (void) G_GNUC_CONST;
#define USER_INTERFACE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_USER_INTERFACE, UserInterfacePrivate))
enum  {
	USER_INTERFACE_DUMMY_PROPERTY
};
Book* user_interface_get_book (UserInterface* self);
gpointer page_ref (gpointer instance);
void page_unref (gpointer instance);
GParamSpec* param_spec_page (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_page (GValue* value, gpointer v_object);
void value_take_page (GValue* value, gpointer v_object);
gpointer value_get_page (const GValue* value);
GType page_get_type (void) G_GNUC_CONST;
static void user_interface_page_removed_cb (UserInterface* self, Book* book, Page* page);
static void _user_interface_page_removed_cb_book_page_removed (Book* _sender, Page* page, gpointer self);
static void user_interface_page_added_cb (UserInterface* self, Book* book, Page* page);
static void _user_interface_page_added_cb_book_page_added (Book* _sender, Page* page, gpointer self);
#define USER_INTERFACE_DEFAULT_TEXT_DPI 150
#define USER_INTERFACE_DEFAULT_PHOTO_DPI 300
void user_interface_new_document_activate_cb (UserInterface* self);
static void _user_interface_new_document_activate_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
void user_interface_save_document_activate_cb (UserInterface* self);
static void _user_interface_save_document_activate_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
void user_interface_save_as_document_activate_cb (UserInterface* self);
static void _user_interface_save_as_document_activate_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
void user_interface_email_document_activate_cb (UserInterface* self);
static void _user_interface_email_document_activate_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
void user_interface_print_document_activate_cb (UserInterface* self);
static void _user_interface_print_document_activate_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
void user_interface_preferences_activate_cb (UserInterface* self);
static void _user_interface_preferences_activate_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
void user_interface_help_contents_activate_cb (UserInterface* self);
static void _user_interface_help_contents_activate_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
void user_interface_about_activate_cb (UserInterface* self);
static void _user_interface_about_activate_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
void user_interface_quit_activate_cb (UserInterface* self);
static void _user_interface_quit_activate_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
UserInterface* user_interface_new (void);
UserInterface* user_interface_construct (GType object_type);
Book* book_new (void);
Book* book_construct (GType object_type);
static void user_interface_set_book (UserInterface* self, Book* value);
static void user_interface_needs_saving_cb (UserInterface* self, Book* book);
static void _user_interface_needs_saving_cb_book_needs_saving_changed (Book* _sender, gpointer self);
static void user_interface_load (UserInterface* self);
AutosaveManager* autosave_manager_new (void);
AutosaveManager* autosave_manager_construct (GType object_type);
void autosave_manager_set_book (AutosaveManager* self, Book* value);
void autosave_manager_load (AutosaveManager* self);
guint book_get_n_pages (Book* self);
static void user_interface_add_default_page (UserInterface* self);
void book_set_needs_saving (Book* self, gboolean value);
Page* book_get_page (Book* self, gint page_number);
void book_view_set_selected_page (BookView* self, Page* value);
static gboolean user_interface_find_scan_device (UserInterface* self, const gchar* device, GtkTreeIter* iter);
static void user_interface_show_error_dialog (UserInterface* self, const gchar* error_title, const gchar* error_text);
void user_interface_authorize (UserInterface* self, const gchar* resource, gchar** username, gchar** password);
void G_MODULE_EXPORT device_combo_changed_cb (GtkWidget* widget, UserInterface* self);
gchar* user_interface_get_selected_device (UserInterface* self);
static void user_interface_update_info_bar (UserInterface* self);
gpointer scan_device_ref (gpointer instance);
void scan_device_unref (gpointer instance);
GParamSpec* param_spec_scan_device (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_scan_device (GValue* value, gpointer v_object);
void value_take_scan_device (GValue* value, gpointer v_object);
gpointer value_get_scan_device (const GValue* value);
GType scan_device_get_type (void) G_GNUC_CONST;
void user_interface_set_scan_devices (UserInterface* self, GList* devices);
Page* page_new (gint width, gint height, gint dpi, ScanDirection scan_direction);
Page* page_construct (GType object_type, gint width, gint height, gint dpi, ScanDirection scan_direction);
void book_append_page (Book* self, Page* page);
static void user_interface_on_file_type_changed (UserInterface* self, GtkTreeSelection* selection);
static gchar* user_interface_get_selected_extension (UserInterface* self, GtkTreeSelection* selection);
static gchar* user_interface_choose_file_location (UserInterface* self);
const gchar* user_interface_get_default_file_name (UserInterface* self);
static void _user_interface_on_file_type_changed_gtk_tree_selection_changed (GtkTreeSelection* _sender, gpointer self);
static gboolean user_interface_save_document (UserInterface* self, gboolean force_choose_location);
void user_interface_show_progress_dialog (UserInterface* self);
void book_save (Book* self, const gchar* type, gint quality, GFile* file, GError** error);
gint user_interface_get_quality (UserInterface* self);
void user_interface_hide_progress_dialog (UserInterface* self);
void user_interface_show_error (UserInterface* self, const gchar* error_title, const gchar* error_text, gboolean change_scanner_hint);
static gboolean user_interface_prompt_to_save (UserInterface* self, const gchar* title, const gchar* discard_label);
gboolean book_get_needs_saving (Book* self);
static void user_interface_clear_document (UserInterface* self);
void book_clear (Book* self);
static void user_interface_new_document (UserInterface* self);
gboolean user_interface_get_scanning (UserInterface* self);
void G_MODULE_EXPORT new_button_clicked_cb (GtkWidget* widget, UserInterface* self);
static void user_interface_set_document_hint (UserInterface* self, const gchar* document_hint, gboolean save);
void G_MODULE_EXPORT text_menuitem_toggled_cb (GtkCheckMenuItem* widget, UserInterface* self);
void G_MODULE_EXPORT photo_menuitem_toggled_cb (GtkCheckMenuItem* widget, UserInterface* self);
GType scan_type_get_type (void) G_GNUC_CONST;
static void user_interface_set_page_side (UserInterface* self, ScanType page_side);
static void user_interface_set_paper_size (UserInterface* self, gint width, gint height);
static gint user_interface_get_text_dpi (UserInterface* self);
static gint user_interface_get_photo_dpi (UserInterface* self);
static ScanType user_interface_get_page_side (UserInterface* self);
static gboolean user_interface_get_paper_size (UserInterface* self, gint* width, gint* height);
gpointer scan_options_ref (gpointer instance);
void scan_options_unref (gpointer instance);
GParamSpec* param_spec_scan_options (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_scan_options (GValue* value, gpointer v_object);
void value_take_scan_options (GValue* value, gpointer v_object);
gpointer value_get_scan_options (const GValue* value);
GType scan_options_get_type (void) G_GNUC_CONST;
static ScanOptions* user_interface_make_scan_options (UserInterface* self);
ScanOptions* scan_options_new (void);
ScanOptions* scan_options_construct (GType object_type);
GType scan_mode_get_type (void) G_GNUC_CONST;
gint user_interface_get_brightness (UserInterface* self);
gint user_interface_get_contrast (UserInterface* self);
void G_MODULE_EXPORT scan_button_clicked_cb (GtkWidget* widget, UserInterface* self);
void G_MODULE_EXPORT stop_scan_button_clicked_cb (GtkWidget* widget, UserInterface* self);
void G_MODULE_EXPORT continuous_scan_button_clicked_cb (GtkWidget* widget, UserInterface* self);
void G_MODULE_EXPORT preferences_button_clicked_cb (GtkWidget* widget, UserInterface* self);
gboolean G_MODULE_EXPORT preferences_dialog_delete_event_cb (GtkWidget* widget, UserInterface* self);
void G_MODULE_EXPORT preferences_dialog_response_cb (GtkWidget* widget, gint response_id, UserInterface* self);
static void user_interface_update_page_menu (UserInterface* self);
Page* book_view_get_selected_page (BookView* self);
guint book_get_page_index (Book* self, Page* page);
static void user_interface_page_selected_cb (UserInterface* self, BookView* view, Page* page);
gboolean page_get_has_crop (Page* self);
const gchar* page_get_crop_name (Page* self);
static void user_interface_show_page_cb (UserInterface* self, BookView* view, Page* page);
gchar* get_temporary_filename (const gchar* prefix, const gchar* extension);
void page_save (Page* self, const gchar* type, gint quality, GFile* file, GError** error);
static void user_interface_show_page_menu_cb (UserInterface* self, BookView* view);
void G_MODULE_EXPORT rotate_left_button_clicked_cb (GtkWidget* widget, UserInterface* self);
void page_rotate_left (Page* self);
void G_MODULE_EXPORT rotate_right_button_clicked_cb (GtkWidget* widget, UserInterface* self);
void page_rotate_right (Page* self);
static void user_interface_set_crop (UserInterface* self, const gchar* crop_name);
void page_set_no_crop (Page* self);
gint page_get_width (Page* self);
gint page_get_height (Page* self);
void page_set_custom_crop (Page* self, gint width, gint height);
void page_move_crop (Page* self, gint x, gint y);
void page_set_named_crop (Page* self, const gchar* name);
void G_MODULE_EXPORT no_crop_menuitem_toggled_cb (GtkCheckMenuItem* widget, UserInterface* self);
void G_MODULE_EXPORT custom_crop_menuitem_toggled_cb (GtkCheckMenuItem* widget, UserInterface* self);
void G_MODULE_EXPORT crop_toolbutton_toggled_cb (GtkToggleToolButton* widget, UserInterface* self);
void G_MODULE_EXPORT four_by_six_menuitem_toggled_cb (GtkCheckMenuItem* widget, UserInterface* self);
void G_MODULE_EXPORT legal_menuitem_toggled_cb (GtkCheckMenuItem* widget, UserInterface* self);
void G_MODULE_EXPORT letter_menuitem_toggled_cb (GtkCheckMenuItem* widget, UserInterface* self);
void G_MODULE_EXPORT a6_menuitem_toggled_cb (GtkCheckMenuItem* widget, UserInterface* self);
void G_MODULE_EXPORT a5_menuitem_toggled_cb (GtkCheckMenuItem* widget, UserInterface* self);
void G_MODULE_EXPORT a4_menuitem_toggled_cb (GtkCheckMenuItem* widget, UserInterface* self);
void G_MODULE_EXPORT crop_rotate_menuitem_activate_cb (GtkWidget* widget, UserInterface* self);
void page_rotate_crop (Page* self);
void G_MODULE_EXPORT page_move_left_menuitem_activate_cb (GtkWidget* widget, UserInterface* self);
void book_move_page (Book* self, Page* page, guint location);
void G_MODULE_EXPORT page_move_right_menuitem_activate_cb (GtkWidget* widget, UserInterface* self);
void G_MODULE_EXPORT page_delete_menuitem_activate_cb (GtkWidget* widget, UserInterface* self);
Book* book_view_get_book (BookView* self);
void book_delete_page (Book* self, Page* page);
void G_MODULE_EXPORT save_file_button_clicked_cb (GtkWidget* widget, UserInterface* self);
void G_MODULE_EXPORT copy_to_clipboard_button_clicked_cb (GtkWidget* widget, UserInterface* self);
void page_copy_to_clipboard (Page* self, GtkWindow* window);
void G_MODULE_EXPORT save_as_file_button_clicked_cb (GtkWidget* widget, UserInterface* self);
static void user_interface_draw_page (UserInterface* self, GtkPrintOperation* operation, GtkPrintContext* print_context, gint page_number);
gboolean page_get_is_landscape (Page* self);
gint page_get_dpi (Page* self);
GdkPixbuf* page_get_image (Page* self, gboolean apply_crop);
void G_MODULE_EXPORT email_button_clicked_cb (GtkWidget* widget, UserInterface* self);
static void user_interface_print_document (UserInterface* self);
static void _user_interface_draw_page_gtk_print_operation_draw_page (GtkPrintOperation* _sender, GtkPrintContext* context, gint page_nr, gpointer self);
void G_MODULE_EXPORT print_button_clicked_cb (GtkWidget* widget, UserInterface* self);
static void user_interface_show_help (UserInterface* self);
void G_MODULE_EXPORT help_contents_menuitem_activate_cb (GtkWidget* widget, UserInterface* self);
static void user_interface_show_about (UserInterface* self);
void G_MODULE_EXPORT about_menuitem_activate_cb (GtkWidget* widget, UserInterface* self);
static gboolean user_interface_on_quit (UserInterface* self);
static void user_interface_save_state (UserInterface* self, gboolean force);
void autosave_manager_cleanup (AutosaveManager* self);
void G_MODULE_EXPORT quit_menuitem_activate_cb (GtkWidget* widget, UserInterface* self);
gboolean G_MODULE_EXPORT simple_scan_window_configure_event_cb (GtkWidget* widget, GdkEventConfigure* event, UserInterface* self);
static void user_interface_info_bar_response_cb (UserInterface* self, GtkInfoBar* widget, gint response_id);
gboolean G_MODULE_EXPORT simple_scan_window_window_state_event_cb (GtkWidget* widget, GdkEventWindowState* event, UserInterface* self);
gboolean G_MODULE_EXPORT window_delete_event_cb (GtkWidget* widget, GdkEvent* event, UserInterface* self);
static void user_interface_page_size_changed_cb (UserInterface* self, Page* page);
static void user_interface_page_scan_direction_changed_cb (UserInterface* self, Page* page);
ScanDirection page_get_scan_direction (Page* self);
static void _user_interface_page_size_changed_cb_page_size_changed (Page* _sender, gpointer self);
static void _user_interface_page_scan_direction_changed_cb_page_scan_direction_changed (Page* _sender, gpointer self);
static void user_interface_set_dpi_combo (UserInterface* self, GtkComboBox* combo, gint default_dpi, gint current_dpi);
static gboolean user_interface_has_app_menu (UserInterface* self, GtkApplication* app);
static void _user_interface_info_bar_response_cb_gtk_info_bar_response (GtkInfoBar* _sender, gint response_id, gpointer self);
static void __lambda6_ (UserInterface* self);
static void ___lambda6__gtk_combo_box_changed (GtkComboBox* _sender, gpointer self);
static void __lambda7_ (UserInterface* self);
static void ___lambda7__gtk_combo_box_changed (GtkComboBox* _sender, gpointer self);
static void __lambda8_ (UserInterface* self);
static void ___lambda8__gtk_combo_box_changed (GtkComboBox* _sender, gpointer self);
static void __lambda9_ (UserInterface* self);
static void ___lambda9__gtk_combo_box_changed (GtkComboBox* _sender, gpointer self);
void user_interface_set_brightness (UserInterface* self, gint value);
static void __lambda10_ (UserInterface* self);
static void ___lambda10__gtk_adjustment_value_changed (GtkAdjustment* _sender, gpointer self);
void user_interface_set_contrast (UserInterface* self, gint value);
static void __lambda11_ (UserInterface* self);
static void ___lambda11__gtk_adjustment_value_changed (GtkAdjustment* _sender, gpointer self);
void user_interface_set_quality (UserInterface* self, gint value);
static void __lambda12_ (UserInterface* self);
static void ___lambda12__gtk_adjustment_value_changed (GtkAdjustment* _sender, gpointer self);
BookView* book_view_new (Book* book);
BookView* book_view_construct (GType object_type, Book* book);
static void _user_interface_page_selected_cb_book_view_page_selected (BookView* _sender, Page* page, gpointer self);
static void _user_interface_show_page_cb_book_view_show_page (BookView* _sender, Page* page, gpointer self);
static void _user_interface_show_page_menu_cb_book_view_show_menu (BookView* _sender, gpointer self);
static void user_interface_load_state (UserInterface* self);
ProgressBarDialog* progress_bar_dialog_new (GtkApplicationWindow* parent, const gchar* title);
ProgressBarDialog* progress_bar_dialog_construct (GType object_type, GtkApplicationWindow* parent, const gchar* title);
static void user_interface_book_saving_cb (UserInterface* self, gint page_number);
static void _user_interface_book_saving_cb_book_saving (Book* _sender, gint i, gpointer self);
static gchar* user_interface_get_state_filename (UserInterface* self);
static gint user_interface_state_get_integer (UserInterface* self, GKeyFile* f, const gchar* group_name, const gchar* key, gint _default_);
static gboolean user_interface_state_get_boolean (UserInterface* self, GKeyFile* f, const gchar* group_name, const gchar* key, gboolean _default_);
static gchar* user_interface_state_get_string (UserInterface* self, GKeyFile* f, const gchar* group_name, const gchar* key, const gchar* _default_);
static gboolean ___lambda5_ (UserInterface* self);
static gboolean ____lambda5__gsource_func (gpointer self);
static gboolean ___lambda13_ (UserInterface* self);
static gboolean ____lambda13__gsource_func (gpointer self);
void progress_bar_dialog_set_fraction (ProgressBarDialog* self, gdouble percent);
void progress_bar_dialog_set_message (ProgressBarDialog* self, const gchar* message);
void user_interface_start (UserInterface* self);
Page* user_interface_get_selected_page (UserInterface* self);
void user_interface_set_selected_page (UserInterface* self, Page* value);
void user_interface_set_default_file_name (UserInterface* self, const gchar* value);
void user_interface_set_scanning (UserInterface* self, gboolean value);
void user_interface_set_selected_device (UserInterface* self, const gchar* value);
static void g_cclosure_user_marshal_VOID__STRING_SCAN_OPTIONS (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data);
static void g_cclosure_user_marshal_VOID__STRING_INT (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data);
static void user_interface_finalize (UserInterface* obj);
#define PROGRESS_BAR_DIALOG_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_PROGRESS_BAR_DIALOG, ProgressBarDialogPrivate))
enum  {
	PROGRESS_BAR_DIALOG_DUMMY_PROPERTY
};
static void progress_bar_dialog_finalize (GObject* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);

static const GActionEntry USER_INTERFACE_action_entries[9] = {{"new_document", _user_interface_new_document_activate_cb_gsimple_action_activate_callback}, {"save", _user_interface_save_document_activate_cb_gsimple_action_activate_callback}, {"save_as", _user_interface_save_as_document_activate_cb_gsimple_action_activate_callback}, {"email", _user_interface_email_document_activate_cb_gsimple_action_activate_callback}, {"print", _user_interface_print_document_activate_cb_gsimple_action_activate_callback}, {"preferences", _user_interface_preferences_activate_cb_gsimple_action_activate_callback}, {"help", _user_interface_help_contents_activate_cb_gsimple_action_activate_callback}, {"about", _user_interface_about_activate_cb_gsimple_action_activate_callback}, {"quit", _user_interface_quit_activate_cb_gsimple_action_activate_callback}};

static void _user_interface_page_removed_cb_book_page_removed (Book* _sender, Page* page, gpointer self) {
#line 213 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	user_interface_page_removed_cb ((UserInterface*) self, _sender, page);
#line 562 "ui.c"
}


static void _user_interface_page_added_cb_book_page_added (Book* _sender, Page* page, gpointer self) {
#line 214 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	user_interface_page_added_cb ((UserInterface*) self, _sender, page);
#line 569 "ui.c"
}


static void _user_interface_new_document_activate_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
#line 17 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	user_interface_new_document_activate_cb ((UserInterface*) self);
#line 576 "ui.c"
}


static void _user_interface_save_document_activate_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
#line 17 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	user_interface_save_document_activate_cb ((UserInterface*) self);
#line 583 "ui.c"
}


static void _user_interface_save_as_document_activate_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
#line 17 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	user_interface_save_as_document_activate_cb ((UserInterface*) self);
#line 590 "ui.c"
}


static void _user_interface_email_document_activate_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
#line 17 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	user_interface_email_document_activate_cb ((UserInterface*) self);
#line 597 "ui.c"
}


static void _user_interface_print_document_activate_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
#line 17 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	user_interface_print_document_activate_cb ((UserInterface*) self);
#line 604 "ui.c"
}


static void _user_interface_preferences_activate_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
#line 17 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	user_interface_preferences_activate_cb ((UserInterface*) self);
#line 611 "ui.c"
}


static void _user_interface_help_contents_activate_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
#line 17 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	user_interface_help_contents_activate_cb ((UserInterface*) self);
#line 618 "ui.c"
}


static void _user_interface_about_activate_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
#line 17 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	user_interface_about_activate_cb ((UserInterface*) self);
#line 625 "ui.c"
}


static void _user_interface_quit_activate_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
#line 17 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	user_interface_quit_activate_cb ((UserInterface*) self);
#line 632 "ui.c"
}


static void _user_interface_needs_saving_cb_book_needs_saving_changed (Book* _sender, gpointer self) {
#line 194 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	user_interface_needs_saving_cb ((UserInterface*) self, _sender);
#line 639 "ui.c"
}


UserInterface* user_interface_construct (GType object_type) {
	UserInterface* self = NULL;
	GSettings* _tmp0_ = NULL;
	Book* _tmp1_ = NULL;
	Book* _tmp2_ = NULL;
	Book* _tmp3_ = NULL;
	Book* _tmp4_ = NULL;
	Book* _tmp5_ = NULL;
	AutosaveManager* _tmp6_ = NULL;
	AutosaveManager* _tmp7_ = NULL;
	Book* _tmp8_ = NULL;
	AutosaveManager* _tmp9_ = NULL;
	Book* _tmp10_ = NULL;
	guint _tmp11_ = 0U;
	guint _tmp12_ = 0U;
#line 187 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	self = (UserInterface*) g_type_create_instance (object_type);
#line 189 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp0_ = g_settings_new ("org.gnome.SimpleScan");
#line 189 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_g_object_unref0 (self->priv->settings);
#line 189 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	self->priv->settings = _tmp0_;
#line 191 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp1_ = book_new ();
#line 191 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp2_ = _tmp1_;
#line 191 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	user_interface_set_book (self, _tmp2_);
#line 191 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_book_unref0 (_tmp2_);
#line 192 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp3_ = self->priv->_book;
#line 192 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	g_signal_connect (_tmp3_, "page-removed", (GCallback) _user_interface_page_removed_cb_book_page_removed, self);
#line 193 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp4_ = self->priv->_book;
#line 193 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	g_signal_connect (_tmp4_, "page-added", (GCallback) _user_interface_page_added_cb_book_page_added, self);
#line 194 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp5_ = self->priv->_book;
#line 194 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	g_signal_connect (_tmp5_, "needs-saving-changed", (GCallback) _user_interface_needs_saving_cb_book_needs_saving_changed, self);
#line 196 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	user_interface_load (self);
#line 198 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp6_ = autosave_manager_new ();
#line 198 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_autosave_manager_unref0 (self->priv->autosave_manager);
#line 198 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	self->priv->autosave_manager = _tmp6_;
#line 199 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp7_ = self->priv->autosave_manager;
#line 199 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp8_ = self->priv->_book;
#line 199 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	autosave_manager_set_book (_tmp7_, _tmp8_);
#line 200 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp9_ = self->priv->autosave_manager;
#line 200 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	autosave_manager_load (_tmp9_);
#line 202 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp10_ = self->priv->_book;
#line 202 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp11_ = book_get_n_pages (_tmp10_);
#line 202 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp12_ = _tmp11_;
#line 202 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	if (_tmp12_ == ((guint) 0)) {
#line 712 "ui.c"
		Book* _tmp13_ = NULL;
#line 204 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		user_interface_add_default_page (self);
#line 205 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		_tmp13_ = self->priv->_book;
#line 205 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		book_set_needs_saving (_tmp13_, FALSE);
#line 720 "ui.c"
	} else {
		BookView* _tmp14_ = NULL;
		Book* _tmp15_ = NULL;
		Page* _tmp16_ = NULL;
		Page* _tmp17_ = NULL;
#line 208 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		_tmp14_ = self->priv->book_view;
#line 208 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		_tmp15_ = self->priv->_book;
#line 208 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		_tmp16_ = book_get_page (_tmp15_, 0);
#line 208 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		_tmp17_ = _tmp16_;
#line 208 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		book_view_set_selected_page (_tmp14_, _tmp17_);
#line 208 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		_page_unref0 (_tmp17_);
#line 738 "ui.c"
	}
#line 187 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	return self;
#line 742 "ui.c"
}


UserInterface* user_interface_new (void) {
#line 187 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	return user_interface_construct (TYPE_USER_INTERFACE);
#line 749 "ui.c"
}


static gboolean user_interface_find_scan_device (UserInterface* self, const gchar* device, GtkTreeIter* iter) {
	GtkTreeIter _vala_iter = {0};
	gboolean result = FALSE;
	gboolean have_iter = FALSE;
	GtkListStore* _tmp0_ = NULL;
	GtkTreeIter _tmp1_ = {0};
	gboolean _tmp2_ = FALSE;
#line 217 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 217 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	g_return_val_if_fail (device != NULL, FALSE);
#line 219 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	have_iter = FALSE;
#line 221 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp0_ = self->priv->device_model;
#line 221 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp2_ = gtk_tree_model_get_iter_first ((GtkTreeModel*) _tmp0_, &_tmp1_);
#line 221 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_vala_iter = _tmp1_;
#line 221 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	if (_tmp2_) {
#line 774 "ui.c"
		{
			gboolean _tmp3_ = FALSE;
#line 223 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
			_tmp3_ = TRUE;
#line 223 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
			while (TRUE) {
#line 781 "ui.c"
				gchar* d = NULL;
				GtkListStore* _tmp8_ = NULL;
				GtkTreeIter _tmp9_ = {0};
				const gchar* _tmp10_ = NULL;
				const gchar* _tmp11_ = NULL;
#line 223 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
				if (!_tmp3_) {
#line 789 "ui.c"
					gboolean _tmp4_ = FALSE;
					gboolean _tmp5_ = FALSE;
#line 229 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
					_tmp5_ = have_iter;
#line 229 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
					if (!_tmp5_) {
#line 796 "ui.c"
						GtkListStore* _tmp6_ = NULL;
						gboolean _tmp7_ = FALSE;
#line 229 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
						_tmp6_ = self->priv->device_model;
#line 229 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
						_tmp7_ = gtk_tree_model_iter_next ((GtkTreeModel*) _tmp6_, &_vala_iter);
#line 229 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
						_tmp4_ = _tmp7_;
#line 805 "ui.c"
					} else {
#line 229 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
						_tmp4_ = FALSE;
#line 809 "ui.c"
					}
#line 229 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
					if (!_tmp4_) {
#line 229 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
						break;
#line 815 "ui.c"
					}
				}
#line 223 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
				_tmp3_ = FALSE;
#line 226 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
				_tmp8_ = self->priv->device_model;
#line 226 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
				_tmp9_ = _vala_iter;
#line 226 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
				gtk_tree_model_get ((GtkTreeModel*) _tmp8_, &_tmp9_, 0, &d, -1, -1);
#line 227 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
				_tmp10_ = d;
#line 227 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
				_tmp11_ = device;
#line 227 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
				if (g_strcmp0 (_tmp10_, _tmp11_) == 0) {
#line 228 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
					have_iter = TRUE;
#line 834 "ui.c"
				}
#line 223 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
				_g_free0 (d);
#line 838 "ui.c"
			}
		}
	}
#line 232 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	result = have_iter;
#line 232 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	if (iter) {
#line 232 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		*iter = _vala_iter;
#line 848 "ui.c"
	}
#line 232 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	return result;
#line 852 "ui.c"
}


static void user_interface_show_error_dialog (UserInterface* self, const gchar* error_title, const gchar* error_text) {
	GtkMessageDialog* dialog = NULL;
	GtkApplicationWindow* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	GtkMessageDialog* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	const gchar* _tmp4_ = NULL;
#line 235 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	g_return_if_fail (self != NULL);
#line 235 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	g_return_if_fail (error_title != NULL);
#line 235 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	g_return_if_fail (error_text != NULL);
#line 237 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp0_ = self->priv->window;
#line 237 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp1_ = error_title;
#line 237 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp2_ = (GtkMessageDialog*) gtk_message_dialog_new ((GtkWindow*) _tmp0_, GTK_DIALOG_MODAL, GTK_MESSAGE_WARNING, GTK_BUTTONS_NONE, "%s", _tmp1_);
#line 237 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	g_object_ref_sink (_tmp2_);
#line 237 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	dialog = _tmp2_;
#line 242 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp3_ = _ ("_Close");
#line 242 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	gtk_dialog_add_button ((GtkDialog*) dialog, _tmp3_, 0);
#line 243 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp4_ = error_text;
#line 243 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	gtk_message_dialog_format_secondary_text (dialog, "%s", _tmp4_);
#line 244 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	gtk_dialog_run ((GtkDialog*) dialog);
#line 245 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	gtk_widget_destroy ((GtkWidget*) dialog);
#line 235 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_g_object_unref0 (dialog);
#line 893 "ui.c"
}


void user_interface_authorize (UserInterface* self, const gchar* resource, gchar** username, gchar** password) {
	gchar* _vala_username = NULL;
	gchar* _vala_password = NULL;
	gchar* description = NULL;
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	GtkEntry* _tmp3_ = NULL;
	GtkEntry* _tmp4_ = NULL;
	GtkLabel* _tmp5_ = NULL;
	GtkDialog* _tmp6_ = NULL;
	GtkDialog* _tmp7_ = NULL;
	GtkDialog* _tmp8_ = NULL;
	GtkEntry* _tmp9_ = NULL;
	const gchar* _tmp10_ = NULL;
	gchar* _tmp11_ = NULL;
	GtkEntry* _tmp12_ = NULL;
	const gchar* _tmp13_ = NULL;
	gchar* _tmp14_ = NULL;
#line 248 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	g_return_if_fail (self != NULL);
#line 248 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	g_return_if_fail (resource != NULL);
#line 251 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp0_ = _ ("Username and password required to access '%s'");
#line 251 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp1_ = resource;
#line 251 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp2_ = g_strdup_printf (_tmp0_, _tmp1_);
#line 251 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	description = _tmp2_;
#line 253 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp3_ = self->priv->username_entry;
#line 253 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	gtk_entry_set_text (_tmp3_, "");
#line 254 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp4_ = self->priv->password_entry;
#line 254 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	gtk_entry_set_text (_tmp4_, "");
#line 255 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp5_ = self->priv->authorize_label;
#line 255 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	gtk_label_set_text (_tmp5_, description);
#line 257 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp6_ = self->priv->authorize_dialog;
#line 257 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	gtk_widget_show ((GtkWidget*) _tmp6_);
#line 258 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp7_ = self->priv->authorize_dialog;
#line 258 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	gtk_dialog_run (_tmp7_);
#line 259 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp8_ = self->priv->authorize_dialog;
#line 259 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	gtk_widget_hide ((GtkWidget*) _tmp8_);
#line 261 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp9_ = self->priv->username_entry;
#line 261 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp10_ = gtk_entry_get_text (_tmp9_);
#line 261 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp11_ = g_strdup (_tmp10_);
#line 261 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_g_free0 (_vala_username);
#line 261 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_vala_username = _tmp11_;
#line 262 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp12_ = self->priv->password_entry;
#line 262 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp13_ = gtk_entry_get_text (_tmp12_);
#line 262 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp14_ = g_strdup (_tmp13_);
#line 262 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_g_free0 (_vala_password);
#line 262 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_vala_password = _tmp14_;
#line 248 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_g_free0 (description);
#line 248 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	if (username) {
#line 248 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		*username = _vala_username;
#line 978 "ui.c"
	} else {
#line 248 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		_g_free0 (_vala_username);
#line 982 "ui.c"
	}
#line 248 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	if (password) {
#line 248 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		*password = _vala_password;
#line 988 "ui.c"
	} else {
#line 248 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		_g_free0 (_vala_password);
#line 992 "ui.c"
	}
}


void G_MODULE_EXPORT device_combo_changed_cb (GtkWidget* widget, UserInterface* self) {
	gboolean _tmp0_ = FALSE;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	gboolean _tmp4_ = FALSE;
#line 266 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	g_return_if_fail (self != NULL);
#line 266 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	g_return_if_fail (widget != NULL);
#line 268 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp0_ = self->priv->setting_devices;
#line 268 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	if (_tmp0_) {
#line 269 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		return;
#line 1013 "ui.c"
	}
#line 270 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	self->priv->user_selected_device = TRUE;
#line 271 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp1_ = user_interface_get_selected_device (self);
#line 271 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp2_ = _tmp1_;
#line 271 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp3_ = _tmp2_;
#line 271 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp4_ = _tmp3_ != NULL;
#line 271 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_g_free0 (_tmp3_);
#line 271 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	if (_tmp4_) {
#line 1029 "ui.c"
		GSettings* _tmp5_ = NULL;
		gchar* _tmp6_ = NULL;
		gchar* _tmp7_ = NULL;
		gchar* _tmp8_ = NULL;
#line 272 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		_tmp5_ = self->priv->settings;
#line 272 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		_tmp6_ = user_interface_get_selected_device (self);
#line 272 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		_tmp7_ = _tmp6_;
#line 272 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		_tmp8_ = _tmp7_;
#line 272 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		g_settings_set_string (_tmp5_, "selected-device", _tmp8_);
#line 272 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		_g_free0 (_tmp8_);
#line 1046 "ui.c"
	}
}


static void user_interface_update_info_bar (UserInterface* self) {
	GtkMessageType type = 0;
	gchar* title = NULL;
	gchar* text = NULL;
	gchar* image_id = NULL;
	gboolean show_close_button = FALSE;
	gboolean show_change_scanner_button = FALSE;
	gboolean _tmp0_ = FALSE;
	GtkInfoBar* _tmp15_ = NULL;
	GtkMessageType _tmp16_ = 0;
	GtkImage* _tmp17_ = NULL;
	const gchar* _tmp18_ = NULL;
	gchar* message = NULL;
	const gchar* _tmp19_ = NULL;
	const gchar* _tmp20_ = NULL;
	gchar* _tmp21_ = NULL;
	GtkLabel* _tmp22_ = NULL;
	const gchar* _tmp23_ = NULL;
	GtkButton* _tmp24_ = NULL;
	gboolean _tmp25_ = FALSE;
	GtkButton* _tmp26_ = NULL;
	gboolean _tmp27_ = FALSE;
	GtkInfoBar* _tmp28_ = NULL;
#line 275 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	g_return_if_fail (self != NULL);
#line 279 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	show_close_button = FALSE;
#line 280 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	show_change_scanner_button = FALSE;
#line 282 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp0_ = self->priv->have_error;
#line 282 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	if (_tmp0_) {
#line 1084 "ui.c"
		gchar* _tmp1_ = NULL;
		const gchar* _tmp2_ = NULL;
		gchar* _tmp3_ = NULL;
		const gchar* _tmp4_ = NULL;
		gchar* _tmp5_ = NULL;
		gboolean _tmp6_ = FALSE;
#line 284 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		type = GTK_MESSAGE_ERROR;
#line 285 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		_tmp1_ = g_strdup ("dialog-error");
#line 285 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		_g_free0 (image_id);
#line 285 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		image_id = _tmp1_;
#line 286 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		_tmp2_ = self->priv->error_title;
#line 286 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		_tmp3_ = g_strdup (_tmp2_);
#line 286 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		_g_free0 (title);
#line 286 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		title = _tmp3_;
#line 287 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		_tmp4_ = self->priv->error_text;
#line 287 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		_tmp5_ = g_strdup (_tmp4_);
#line 287 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		_g_free0 (text);
#line 287 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		text = _tmp5_;
#line 288 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		show_close_button = TRUE;
#line 289 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		_tmp6_ = self->priv->error_change_scanner_hint;
#line 289 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		show_change_scanner_button = _tmp6_;
#line 1121 "ui.c"
	} else {
		GtkListStore* _tmp7_ = NULL;
		gint _tmp8_ = 0;
#line 291 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		_tmp7_ = self->priv->device_model;
#line 291 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		_tmp8_ = gtk_tree_model_iter_n_children ((GtkTreeModel*) _tmp7_, NULL);
#line 291 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		if (_tmp8_ == 0) {
#line 1131 "ui.c"
			gchar* _tmp9_ = NULL;
			const gchar* _tmp10_ = NULL;
			gchar* _tmp11_ = NULL;
			const gchar* _tmp12_ = NULL;
			gchar* _tmp13_ = NULL;
#line 293 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
			type = GTK_MESSAGE_WARNING;
#line 294 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
			_tmp9_ = g_strdup ("dialog-warning");
#line 294 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
			_g_free0 (image_id);
#line 294 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
			image_id = _tmp9_;
#line 296 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
			_tmp10_ = _ ("No scanners detected");
#line 296 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
			_tmp11_ = g_strdup (_tmp10_);
#line 296 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
			_g_free0 (title);
#line 296 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
			title = _tmp11_;
#line 298 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
			_tmp12_ = _ ("Please check your scanner is connected and powered on");
#line 298 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
			_tmp13_ = g_strdup (_tmp12_);
#line 298 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
			_g_free0 (text);
#line 298 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
			text = _tmp13_;
#line 1161 "ui.c"
		} else {
			GtkInfoBar* _tmp14_ = NULL;
#line 302 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
			_tmp14_ = self->priv->info_bar;
#line 302 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
			gtk_widget_hide ((GtkWidget*) _tmp14_);
#line 303 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
			_g_free0 (image_id);
#line 303 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
			_g_free0 (text);
#line 303 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
			_g_free0 (title);
#line 303 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
			return;
#line 1176 "ui.c"
		}
	}
#line 306 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp15_ = self->priv->info_bar;
#line 306 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp16_ = type;
#line 306 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	gtk_info_bar_set_message_type (_tmp15_, _tmp16_);
#line 307 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp17_ = self->priv->info_bar_image;
#line 307 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp18_ = image_id;
#line 307 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	gtk_image_set_from_icon_name (_tmp17_, _tmp18_, GTK_ICON_SIZE_DIALOG);
#line 308 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp19_ = title;
#line 308 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp20_ = text;
#line 308 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp21_ = g_strdup_printf ("<big><b>%s</b></big>\n\n%s", _tmp19_, _tmp20_);
#line 308 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	message = _tmp21_;
#line 309 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp22_ = self->priv->info_bar_label;
#line 309 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp23_ = message;
#line 309 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	gtk_label_set_markup (_tmp22_, _tmp23_);
#line 310 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp24_ = self->priv->info_bar_close_button;
#line 310 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp25_ = show_close_button;
#line 310 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	gtk_widget_set_visible ((GtkWidget*) _tmp24_, _tmp25_);
#line 311 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp26_ = self->priv->info_bar_change_scanner_button;
#line 311 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp27_ = show_change_scanner_button;
#line 311 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	gtk_widget_set_visible ((GtkWidget*) _tmp26_, _tmp27_);
#line 312 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp28_ = self->priv->info_bar;
#line 312 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	gtk_widget_show ((GtkWidget*) _tmp28_);
#line 275 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_g_free0 (message);
#line 275 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_g_free0 (image_id);
#line 275 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_g_free0 (text);
#line 275 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_g_free0 (title);
#line 1229 "ui.c"
}


static gpointer _scan_device_ref0 (gpointer self) {
#line 329 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	return self ? scan_device_ref (self) : NULL;
#line 1236 "ui.c"
}


void user_interface_set_scan_devices (UserInterface* self, GList* devices) {
	gboolean have_selection = FALSE;
	gint index = 0;
	GtkTreeIter iter = {0};
	gboolean _tmp0_ = FALSE;
	GList* _tmp3_ = NULL;
	gboolean _tmp50_ = FALSE;
#line 315 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	g_return_if_fail (self != NULL);
#line 317 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	have_selection = FALSE;
#line 321 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	self->priv->setting_devices = TRUE;
#line 324 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp0_ = self->priv->user_selected_device;
#line 324 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	if (_tmp0_) {
#line 1257 "ui.c"
		GtkComboBox* _tmp1_ = NULL;
		gint _tmp2_ = 0;
#line 325 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		_tmp1_ = self->priv->device_combo;
#line 325 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		_tmp2_ = gtk_combo_box_get_active (_tmp1_);
#line 325 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		have_selection = _tmp2_ >= 0;
#line 1266 "ui.c"
	}
#line 328 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	index = 0;
#line 329 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp3_ = devices;
#line 1272 "ui.c"
	{
		GList* device_collection = NULL;
		GList* device_it = NULL;
#line 329 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		device_collection = _tmp3_;
#line 329 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		for (device_it = device_collection; device_it != NULL; device_it = device_it->next) {
#line 1280 "ui.c"
			ScanDevice* _tmp4_ = NULL;
			ScanDevice* device = NULL;
#line 329 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
			_tmp4_ = _scan_device_ref0 ((ScanDevice*) device_it->data);
#line 329 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
			device = _tmp4_;
#line 1287 "ui.c"
			{
				gint n_delete = 0;
				GtkListStore* _tmp5_ = NULL;
				gint _tmp6_ = 0;
				GtkTreeIter _tmp7_ = {0};
				gboolean _tmp8_ = FALSE;
				gint _tmp20_ = 0;
				gint _tmp43_ = 0;
#line 331 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
				n_delete = -1;
#line 334 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
				_tmp5_ = self->priv->device_model;
#line 334 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
				_tmp6_ = index;
#line 334 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
				_tmp8_ = gtk_tree_model_iter_nth_child ((GtkTreeModel*) _tmp5_, &_tmp7_, NULL, _tmp6_);
#line 334 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
				iter = _tmp7_;
#line 334 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
				if (_tmp8_) {
#line 1308 "ui.c"
					gint i = 0;
#line 336 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
					i = 0;
#line 1312 "ui.c"
					{
						gboolean _tmp9_ = FALSE;
#line 337 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
						_tmp9_ = TRUE;
#line 337 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
						while (TRUE) {
#line 1319 "ui.c"
							gchar* name = NULL;
							gboolean matched = FALSE;
							GtkListStore* _tmp12_ = NULL;
							GtkTreeIter _tmp13_ = {0};
							const gchar* _tmp14_ = NULL;
							ScanDevice* _tmp15_ = NULL;
							const gchar* _tmp16_ = NULL;
							gboolean _tmp17_ = FALSE;
							gint _tmp19_ = 0;
#line 337 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
							if (!_tmp9_) {
#line 1331 "ui.c"
								GtkListStore* _tmp10_ = NULL;
								gboolean _tmp11_ = FALSE;
#line 351 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
								_tmp10_ = self->priv->device_model;
#line 351 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
								_tmp11_ = gtk_tree_model_iter_next ((GtkTreeModel*) _tmp10_, &iter);
#line 351 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
								if (!_tmp11_) {
#line 351 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
									break;
#line 1342 "ui.c"
								}
							}
#line 337 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
							_tmp9_ = FALSE;
#line 342 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
							_tmp12_ = self->priv->device_model;
#line 342 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
							_tmp13_ = iter;
#line 342 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
							gtk_tree_model_get ((GtkTreeModel*) _tmp12_, &_tmp13_, 0, &name, -1, -1);
#line 343 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
							_tmp14_ = name;
#line 343 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
							_tmp15_ = device;
#line 343 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
							_tmp16_ = _tmp15_->name;
#line 343 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
							matched = g_strcmp0 (_tmp14_, _tmp16_) == 0;
#line 345 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
							_tmp17_ = matched;
#line 345 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
							if (_tmp17_) {
#line 1365 "ui.c"
								gint _tmp18_ = 0;
#line 347 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
								_tmp18_ = i;
#line 347 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
								n_delete = _tmp18_;
#line 348 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
								_g_free0 (name);
#line 348 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
								break;
#line 1375 "ui.c"
							}
#line 350 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
							_tmp19_ = i;
#line 350 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
							i = _tmp19_ + 1;
#line 337 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
							_g_free0 (name);
#line 1383 "ui.c"
						}
					}
				}
#line 355 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
				_tmp20_ = n_delete;
#line 355 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
				if (_tmp20_ >= 0) {
#line 1391 "ui.c"
					gint i = 0;
					GtkListStore* _tmp21_ = NULL;
					GtkTreeIter _tmp22_ = {0};
					ScanDevice* _tmp23_ = NULL;
					const gchar* _tmp24_ = NULL;
#line 360 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
					_tmp21_ = self->priv->device_model;
#line 360 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
					_tmp22_ = iter;
#line 360 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
					_tmp23_ = device;
#line 360 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
					_tmp24_ = _tmp23_->label;
#line 360 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
					gtk_list_store_set (_tmp21_, &_tmp22_, 1, _tmp24_, -1, -1);
#line 1407 "ui.c"
					{
						gboolean _tmp25_ = FALSE;
#line 362 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
						i = 0;
#line 362 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
						_tmp25_ = TRUE;
#line 362 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
						while (TRUE) {
#line 1416 "ui.c"
							gint _tmp27_ = 0;
							gint _tmp28_ = 0;
							GtkListStore* _tmp29_ = NULL;
							gint _tmp30_ = 0;
							GtkTreeIter _tmp31_ = {0};
							GtkListStore* _tmp32_ = NULL;
							GtkTreeIter _tmp33_ = {0};
#line 362 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
							if (!_tmp25_) {
#line 1426 "ui.c"
								gint _tmp26_ = 0;
#line 362 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
								_tmp26_ = i;
#line 362 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
								i = _tmp26_ + 1;
#line 1432 "ui.c"
							}
#line 362 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
							_tmp25_ = FALSE;
#line 362 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
							_tmp27_ = i;
#line 362 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
							_tmp28_ = n_delete;
#line 362 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
							if (!(_tmp27_ < _tmp28_)) {
#line 362 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
								break;
#line 1444 "ui.c"
							}
#line 364 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
							_tmp29_ = self->priv->device_model;
#line 364 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
							_tmp30_ = index;
#line 364 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
							gtk_tree_model_iter_nth_child ((GtkTreeModel*) _tmp29_, &_tmp31_, NULL, _tmp30_);
#line 364 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
							iter = _tmp31_;
#line 365 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
							_tmp32_ = self->priv->device_model;
#line 365 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
							_tmp33_ = iter;
#line 365 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
							gtk_list_store_remove (_tmp32_, &_tmp33_);
#line 1460 "ui.c"
						}
					}
				} else {
					GtkListStore* _tmp34_ = NULL;
					gint _tmp35_ = 0;
					GtkTreeIter _tmp36_ = {0};
					GtkListStore* _tmp37_ = NULL;
					GtkTreeIter _tmp38_ = {0};
					ScanDevice* _tmp39_ = NULL;
					const gchar* _tmp40_ = NULL;
					ScanDevice* _tmp41_ = NULL;
					const gchar* _tmp42_ = NULL;
#line 370 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
					_tmp34_ = self->priv->device_model;
#line 370 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
					_tmp35_ = index;
#line 370 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
					gtk_list_store_insert (_tmp34_, &_tmp36_, _tmp35_);
#line 370 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
					iter = _tmp36_;
#line 371 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
					_tmp37_ = self->priv->device_model;
#line 371 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
					_tmp38_ = iter;
#line 371 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
					_tmp39_ = device;
#line 371 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
					_tmp40_ = _tmp39_->name;
#line 371 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
					_tmp41_ = device;
#line 371 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
					_tmp42_ = _tmp41_->label;
#line 371 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
					gtk_list_store_set (_tmp37_, &_tmp38_, 0, _tmp40_, 1, _tmp42_, -1, -1);
#line 1495 "ui.c"
				}
#line 373 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
				_tmp43_ = index;
#line 373 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
				index = _tmp43_ + 1;
#line 329 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
				_scan_device_unref0 (device);
#line 1503 "ui.c"
			}
		}
	}
#line 377 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	while (TRUE) {
#line 1509 "ui.c"
		GtkListStore* _tmp44_ = NULL;
		gint _tmp45_ = 0;
		GtkTreeIter _tmp46_ = {0};
		gboolean _tmp47_ = FALSE;
		GtkListStore* _tmp48_ = NULL;
		GtkTreeIter _tmp49_ = {0};
#line 377 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		_tmp44_ = self->priv->device_model;
#line 377 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		_tmp45_ = index;
#line 377 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		_tmp47_ = gtk_tree_model_iter_nth_child ((GtkTreeModel*) _tmp44_, &_tmp46_, NULL, _tmp45_);
#line 377 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		iter = _tmp46_;
#line 377 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		if (!_tmp47_) {
#line 377 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
			break;
#line 1528 "ui.c"
		}
#line 378 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		_tmp48_ = self->priv->device_model;
#line 378 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		_tmp49_ = iter;
#line 378 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		gtk_list_store_remove (_tmp48_, &_tmp49_);
#line 1536 "ui.c"
	}
#line 381 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp50_ = have_selection;
#line 381 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	if (!_tmp50_) {
#line 1542 "ui.c"
		gchar* device = NULL;
		GSettings* _tmp51_ = NULL;
		gchar* _tmp52_ = NULL;
		gboolean _tmp53_ = FALSE;
		const gchar* _tmp54_ = NULL;
#line 383 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		_tmp51_ = self->priv->settings;
#line 383 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		_tmp52_ = g_settings_get_string (_tmp51_, "selected-device");
#line 383 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		device = _tmp52_;
#line 384 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		_tmp54_ = device;
#line 384 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		if (_tmp54_ != NULL) {
#line 1558 "ui.c"
			const gchar* _tmp55_ = NULL;
			GtkTreeIter _tmp56_ = {0};
			gboolean _tmp57_ = FALSE;
#line 384 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
			_tmp55_ = device;
#line 384 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
			_tmp57_ = user_interface_find_scan_device (self, _tmp55_, &_tmp56_);
#line 384 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
			iter = _tmp56_;
#line 384 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
			_tmp53_ = _tmp57_;
#line 1570 "ui.c"
		} else {
#line 384 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
			_tmp53_ = FALSE;
#line 1574 "ui.c"
		}
#line 384 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		if (_tmp53_) {
#line 1578 "ui.c"
			GtkComboBox* _tmp58_ = NULL;
			GtkTreeIter _tmp59_ = {0};
#line 385 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
			_tmp58_ = self->priv->device_combo;
#line 385 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
			_tmp59_ = iter;
#line 385 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
			gtk_combo_box_set_active_iter (_tmp58_, &_tmp59_);
#line 1587 "ui.c"
		} else {
			GtkComboBox* _tmp60_ = NULL;
#line 387 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
			_tmp60_ = self->priv->device_combo;
#line 387 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
			gtk_combo_box_set_active (_tmp60_, 0);
#line 1594 "ui.c"
		}
#line 381 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		_g_free0 (device);
#line 1598 "ui.c"
	}
#line 390 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	self->priv->setting_devices = FALSE;
#line 392 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	user_interface_update_info_bar (self);
#line 1604 "ui.c"
}


static void user_interface_add_default_page (UserInterface* self) {
	Page* page = NULL;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	ScanDirection _tmp3_ = 0;
	Page* _tmp4_ = NULL;
	Book* _tmp5_ = NULL;
	BookView* _tmp6_ = NULL;
#line 395 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	g_return_if_fail (self != NULL);
#line 397 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp0_ = self->priv->default_page_width;
#line 397 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp1_ = self->priv->default_page_height;
#line 397 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp2_ = self->priv->default_page_dpi;
#line 397 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp3_ = self->priv->default_page_scan_direction;
#line 397 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp4_ = page_new (_tmp0_, _tmp1_, _tmp2_, _tmp3_);
#line 397 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	page = _tmp4_;
#line 401 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp5_ = self->priv->_book;
#line 401 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	book_append_page (_tmp5_, page);
#line 402 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp6_ = self->priv->book_view;
#line 402 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	book_view_set_selected_page (_tmp6_, page);
#line 395 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_page_unref0 (page);
#line 1641 "ui.c"
}


static gint string_last_index_of_char (const gchar* self, gunichar c, gint start_index) {
	gint result = 0;
	gchar* _result_ = NULL;
	gint _tmp0_ = 0;
	gunichar _tmp1_ = 0U;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
#line 930 "/usr/share/vala-0.30/vapi/glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, 0);
#line 931 "/usr/share/vala-0.30/vapi/glib-2.0.vapi"
	_tmp0_ = start_index;
#line 931 "/usr/share/vala-0.30/vapi/glib-2.0.vapi"
	_tmp1_ = c;
#line 931 "/usr/share/vala-0.30/vapi/glib-2.0.vapi"
	_tmp2_ = g_utf8_strrchr (((gchar*) self) + _tmp0_, (gssize) -1, _tmp1_);
#line 931 "/usr/share/vala-0.30/vapi/glib-2.0.vapi"
	_result_ = _tmp2_;
#line 933 "/usr/share/vala-0.30/vapi/glib-2.0.vapi"
	_tmp3_ = _result_;
#line 933 "/usr/share/vala-0.30/vapi/glib-2.0.vapi"
	if (_tmp3_ != NULL) {
#line 1666 "ui.c"
		gchar* _tmp4_ = NULL;
#line 934 "/usr/share/vala-0.30/vapi/glib-2.0.vapi"
		_tmp4_ = _result_;
#line 934 "/usr/share/vala-0.30/vapi/glib-2.0.vapi"
		result = (gint) (_tmp4_ - ((gchar*) self));
#line 934 "/usr/share/vala-0.30/vapi/glib-2.0.vapi"
		return result;
#line 1674 "ui.c"
	} else {
#line 936 "/usr/share/vala-0.30/vapi/glib-2.0.vapi"
		result = -1;
#line 936 "/usr/share/vala-0.30/vapi/glib-2.0.vapi"
		return result;
#line 1680 "ui.c"
	}
}


static gchar* string_slice (const gchar* self, glong start, glong end) {
	gchar* result = NULL;
	glong string_length = 0L;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	glong _tmp2_ = 0L;
	glong _tmp5_ = 0L;
	gboolean _tmp8_ = FALSE;
	glong _tmp9_ = 0L;
	gboolean _tmp12_ = FALSE;
	glong _tmp13_ = 0L;
	glong _tmp16_ = 0L;
	glong _tmp17_ = 0L;
	glong _tmp18_ = 0L;
	glong _tmp19_ = 0L;
	glong _tmp20_ = 0L;
	gchar* _tmp21_ = NULL;
#line 1230 "/usr/share/vala-0.30/vapi/glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1231 "/usr/share/vala-0.30/vapi/glib-2.0.vapi"
	_tmp0_ = strlen (self);
#line 1231 "/usr/share/vala-0.30/vapi/glib-2.0.vapi"
	_tmp1_ = _tmp0_;
#line 1231 "/usr/share/vala-0.30/vapi/glib-2.0.vapi"
	string_length = (glong) _tmp1_;
#line 1232 "/usr/share/vala-0.30/vapi/glib-2.0.vapi"
	_tmp2_ = start;
#line 1232 "/usr/share/vala-0.30/vapi/glib-2.0.vapi"
	if (_tmp2_ < ((glong) 0)) {
#line 1714 "ui.c"
		glong _tmp3_ = 0L;
		glong _tmp4_ = 0L;
#line 1233 "/usr/share/vala-0.30/vapi/glib-2.0.vapi"
		_tmp3_ = string_length;
#line 1233 "/usr/share/vala-0.30/vapi/glib-2.0.vapi"
		_tmp4_ = start;
#line 1233 "/usr/share/vala-0.30/vapi/glib-2.0.vapi"
		start = _tmp3_ + _tmp4_;
#line 1723 "ui.c"
	}
#line 1235 "/usr/share/vala-0.30/vapi/glib-2.0.vapi"
	_tmp5_ = end;
#line 1235 "/usr/share/vala-0.30/vapi/glib-2.0.vapi"
	if (_tmp5_ < ((glong) 0)) {
#line 1729 "ui.c"
		glong _tmp6_ = 0L;
		glong _tmp7_ = 0L;
#line 1236 "/usr/share/vala-0.30/vapi/glib-2.0.vapi"
		_tmp6_ = string_length;
#line 1236 "/usr/share/vala-0.30/vapi/glib-2.0.vapi"
		_tmp7_ = end;
#line 1236 "/usr/share/vala-0.30/vapi/glib-2.0.vapi"
		end = _tmp6_ + _tmp7_;
#line 1738 "ui.c"
	}
#line 1238 "/usr/share/vala-0.30/vapi/glib-2.0.vapi"
	_tmp9_ = start;
#line 1238 "/usr/share/vala-0.30/vapi/glib-2.0.vapi"
	if (_tmp9_ >= ((glong) 0)) {
#line 1744 "ui.c"
		glong _tmp10_ = 0L;
		glong _tmp11_ = 0L;
#line 1238 "/usr/share/vala-0.30/vapi/glib-2.0.vapi"
		_tmp10_ = start;
#line 1238 "/usr/share/vala-0.30/vapi/glib-2.0.vapi"
		_tmp11_ = string_length;
#line 1238 "/usr/share/vala-0.30/vapi/glib-2.0.vapi"
		_tmp8_ = _tmp10_ <= _tmp11_;
#line 1753 "ui.c"
	} else {
#line 1238 "/usr/share/vala-0.30/vapi/glib-2.0.vapi"
		_tmp8_ = FALSE;
#line 1757 "ui.c"
	}
#line 1238 "/usr/share/vala-0.30/vapi/glib-2.0.vapi"
	g_return_val_if_fail (_tmp8_, NULL);
#line 1239 "/usr/share/vala-0.30/vapi/glib-2.0.vapi"
	_tmp13_ = end;
#line 1239 "/usr/share/vala-0.30/vapi/glib-2.0.vapi"
	if (_tmp13_ >= ((glong) 0)) {
#line 1765 "ui.c"
		glong _tmp14_ = 0L;
		glong _tmp15_ = 0L;
#line 1239 "/usr/share/vala-0.30/vapi/glib-2.0.vapi"
		_tmp14_ = end;
#line 1239 "/usr/share/vala-0.30/vapi/glib-2.0.vapi"
		_tmp15_ = string_length;
#line 1239 "/usr/share/vala-0.30/vapi/glib-2.0.vapi"
		_tmp12_ = _tmp14_ <= _tmp15_;
#line 1774 "ui.c"
	} else {
#line 1239 "/usr/share/vala-0.30/vapi/glib-2.0.vapi"
		_tmp12_ = FALSE;
#line 1778 "ui.c"
	}
#line 1239 "/usr/share/vala-0.30/vapi/glib-2.0.vapi"
	g_return_val_if_fail (_tmp12_, NULL);
#line 1240 "/usr/share/vala-0.30/vapi/glib-2.0.vapi"
	_tmp16_ = start;
#line 1240 "/usr/share/vala-0.30/vapi/glib-2.0.vapi"
	_tmp17_ = end;
#line 1240 "/usr/share/vala-0.30/vapi/glib-2.0.vapi"
	g_return_val_if_fail (_tmp16_ <= _tmp17_, NULL);
#line 1241 "/usr/share/vala-0.30/vapi/glib-2.0.vapi"
	_tmp18_ = start;
#line 1241 "/usr/share/vala-0.30/vapi/glib-2.0.vapi"
	_tmp19_ = end;
#line 1241 "/usr/share/vala-0.30/vapi/glib-2.0.vapi"
	_tmp20_ = start;
#line 1241 "/usr/share/vala-0.30/vapi/glib-2.0.vapi"
	_tmp21_ = g_strndup (((gchar*) self) + _tmp18_, (gsize) (_tmp19_ - _tmp20_));
#line 1241 "/usr/share/vala-0.30/vapi/glib-2.0.vapi"
	result = _tmp21_;
#line 1241 "/usr/share/vala-0.30/vapi/glib-2.0.vapi"
	return result;
#line 1800 "ui.c"
}


static void user_interface_on_file_type_changed (UserInterface* self, GtkTreeSelection* selection) {
	gchar* extension = NULL;
	GtkTreeSelection* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gchar* path = NULL;
	GtkFileChooserDialog* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	gchar* filename = NULL;
	const gchar* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
	gint extension_index = 0;
	const gchar* _tmp6_ = NULL;
	gint _tmp7_ = 0;
	gint _tmp8_ = 0;
	const gchar* _tmp12_ = NULL;
	const gchar* _tmp13_ = NULL;
	gchar* _tmp14_ = NULL;
	GtkFileChooserDialog* _tmp15_ = NULL;
	const gchar* _tmp16_ = NULL;
#line 405 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	g_return_if_fail (self != NULL);
#line 405 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	g_return_if_fail (selection != NULL);
#line 407 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp0_ = selection;
#line 407 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp1_ = user_interface_get_selected_extension (self, _tmp0_);
#line 407 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	extension = _tmp1_;
#line 408 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp2_ = self->priv->save_dialog;
#line 408 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp3_ = gtk_file_chooser_get_filename ((GtkFileChooser*) _tmp2_);
#line 408 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	path = _tmp3_;
#line 409 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp4_ = path;
#line 409 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp5_ = g_path_get_basename (_tmp4_);
#line 409 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	filename = _tmp5_;
#line 412 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp6_ = filename;
#line 412 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp7_ = string_last_index_of_char (_tmp6_, (gunichar) '.', 0);
#line 412 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	extension_index = _tmp7_;
#line 413 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp8_ = extension_index;
#line 413 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	if (_tmp8_ >= 0) {
#line 1855 "ui.c"
		const gchar* _tmp9_ = NULL;
		gint _tmp10_ = 0;
		gchar* _tmp11_ = NULL;
#line 414 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		_tmp9_ = filename;
#line 414 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		_tmp10_ = extension_index;
#line 414 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		_tmp11_ = string_slice (_tmp9_, (glong) 0, (glong) _tmp10_);
#line 414 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		_g_free0 (filename);
#line 414 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		filename = _tmp11_;
#line 1869 "ui.c"
	}
#line 415 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp12_ = filename;
#line 415 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp13_ = extension;
#line 415 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp14_ = g_strconcat (_tmp12_, _tmp13_, NULL);
#line 415 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_g_free0 (filename);
#line 415 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	filename = _tmp14_;
#line 416 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp15_ = self->priv->save_dialog;
#line 416 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp16_ = filename;
#line 416 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	gtk_file_chooser_set_current_name ((GtkFileChooser*) _tmp15_, _tmp16_);
#line 405 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_g_free0 (filename);
#line 405 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_g_free0 (path);
#line 405 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_g_free0 (extension);
#line 1893 "ui.c"
}


static gpointer _g_object_ref0 (gpointer self) {
#line 425 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	return self ? g_object_ref (self) : NULL;
#line 1900 "ui.c"
}


static gchar* user_interface_get_selected_extension (UserInterface* self, GtkTreeSelection* selection) {
	gchar* result = NULL;
	GtkTreeModel* model = NULL;
	GtkTreeIter iter = {0};
	gchar* extension = NULL;
	gchar* _tmp0_ = NULL;
	GtkTreeSelection* _tmp1_ = NULL;
	GtkTreeModel* _tmp2_ = NULL;
	GtkTreeIter _tmp3_ = {0};
	gboolean _tmp4_ = FALSE;
	GtkTreeModel* _tmp5_ = NULL;
#line 419 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 419 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	g_return_val_if_fail (selection != NULL, NULL);
#line 423 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp0_ = g_strdup ("");
#line 423 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	extension = _tmp0_;
#line 425 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp1_ = selection;
#line 425 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp4_ = gtk_tree_selection_get_selected (_tmp1_, &_tmp2_, &_tmp3_);
#line 425 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_g_object_unref0 (model);
#line 425 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp5_ = _g_object_ref0 (_tmp2_);
#line 425 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	model = _tmp5_;
#line 425 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	iter = _tmp3_;
#line 425 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	if (_tmp4_) {
#line 1937 "ui.c"
		GtkTreeModel* _tmp6_ = NULL;
		GtkTreeIter _tmp7_ = {0};
#line 426 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		_tmp6_ = model;
#line 426 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		_tmp7_ = iter;
#line 426 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		gtk_tree_model_get (_tmp6_, &_tmp7_, 1, &extension, -1, -1);
#line 1946 "ui.c"
	}
#line 427 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	result = extension;
#line 427 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_g_object_unref0 (model);
#line 427 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	return result;
#line 1954 "ui.c"
}


static glong string_strnlen (gchar* str, glong maxlen) {
	glong result = 0L;
	gchar* end = NULL;
	gchar* _tmp0_ = NULL;
	glong _tmp1_ = 0L;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
#line 1197 "/usr/share/vala-0.30/vapi/glib-2.0.vapi"
	_tmp0_ = str;
#line 1197 "/usr/share/vala-0.30/vapi/glib-2.0.vapi"
	_tmp1_ = maxlen;
#line 1197 "/usr/share/vala-0.30/vapi/glib-2.0.vapi"
	_tmp2_ = memchr (_tmp0_, 0, (gsize) _tmp1_);
#line 1197 "/usr/share/vala-0.30/vapi/glib-2.0.vapi"
	end = _tmp2_;
#line 1198 "/usr/share/vala-0.30/vapi/glib-2.0.vapi"
	_tmp3_ = end;
#line 1198 "/usr/share/vala-0.30/vapi/glib-2.0.vapi"
	if (_tmp3_ == NULL) {
#line 1977 "ui.c"
		glong _tmp4_ = 0L;
#line 1199 "/usr/share/vala-0.30/vapi/glib-2.0.vapi"
		_tmp4_ = maxlen;
#line 1199 "/usr/share/vala-0.30/vapi/glib-2.0.vapi"
		result = _tmp4_;
#line 1199 "/usr/share/vala-0.30/vapi/glib-2.0.vapi"
		return result;
#line 1985 "ui.c"
	} else {
		gchar* _tmp5_ = NULL;
		gchar* _tmp6_ = NULL;
#line 1201 "/usr/share/vala-0.30/vapi/glib-2.0.vapi"
		_tmp5_ = end;
#line 1201 "/usr/share/vala-0.30/vapi/glib-2.0.vapi"
		_tmp6_ = str;
#line 1201 "/usr/share/vala-0.30/vapi/glib-2.0.vapi"
		result = (glong) (_tmp5_ - _tmp6_);
#line 1201 "/usr/share/vala-0.30/vapi/glib-2.0.vapi"
		return result;
#line 1997 "ui.c"
	}
}


static gchar* string_substring (const gchar* self, glong offset, glong len) {
	gchar* result = NULL;
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	glong _tmp1_ = 0L;
	glong _tmp8_ = 0L;
	glong _tmp14_ = 0L;
	glong _tmp17_ = 0L;
	glong _tmp18_ = 0L;
	glong _tmp19_ = 0L;
	glong _tmp20_ = 0L;
	glong _tmp21_ = 0L;
	gchar* _tmp22_ = NULL;
#line 1208 "/usr/share/vala-0.30/vapi/glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1210 "/usr/share/vala-0.30/vapi/glib-2.0.vapi"
	_tmp1_ = offset;
#line 1210 "/usr/share/vala-0.30/vapi/glib-2.0.vapi"
	if (_tmp1_ >= ((glong) 0)) {
#line 2021 "ui.c"
		glong _tmp2_ = 0L;
#line 1210 "/usr/share/vala-0.30/vapi/glib-2.0.vapi"
		_tmp2_ = len;
#line 1210 "/usr/share/vala-0.30/vapi/glib-2.0.vapi"
		_tmp0_ = _tmp2_ >= ((glong) 0);
#line 2027 "ui.c"
	} else {
#line 1210 "/usr/share/vala-0.30/vapi/glib-2.0.vapi"
		_tmp0_ = FALSE;
#line 2031 "ui.c"
	}
#line 1210 "/usr/share/vala-0.30/vapi/glib-2.0.vapi"
	if (_tmp0_) {
#line 2035 "ui.c"
		glong _tmp3_ = 0L;
		glong _tmp4_ = 0L;
		glong _tmp5_ = 0L;
#line 1212 "/usr/share/vala-0.30/vapi/glib-2.0.vapi"
		_tmp3_ = offset;
#line 1212 "/usr/share/vala-0.30/vapi/glib-2.0.vapi"
		_tmp4_ = len;
#line 1212 "/usr/share/vala-0.30/vapi/glib-2.0.vapi"
		_tmp5_ = string_strnlen ((gchar*) self, _tmp3_ + _tmp4_);
#line 1212 "/usr/share/vala-0.30/vapi/glib-2.0.vapi"
		string_length = _tmp5_;
#line 2047 "ui.c"
	} else {
		gint _tmp6_ = 0;
		gint _tmp7_ = 0;
#line 1214 "/usr/share/vala-0.30/vapi/glib-2.0.vapi"
		_tmp6_ = strlen (self);
#line 1214 "/usr/share/vala-0.30/vapi/glib-2.0.vapi"
		_tmp7_ = _tmp6_;
#line 1214 "/usr/share/vala-0.30/vapi/glib-2.0.vapi"
		string_length = (glong) _tmp7_;
#line 2057 "ui.c"
	}
#line 1217 "/usr/share/vala-0.30/vapi/glib-2.0.vapi"
	_tmp8_ = offset;
#line 1217 "/usr/share/vala-0.30/vapi/glib-2.0.vapi"
	if (_tmp8_ < ((glong) 0)) {
#line 2063 "ui.c"
		glong _tmp9_ = 0L;
		glong _tmp10_ = 0L;
		glong _tmp11_ = 0L;
#line 1218 "/usr/share/vala-0.30/vapi/glib-2.0.vapi"
		_tmp9_ = string_length;
#line 1218 "/usr/share/vala-0.30/vapi/glib-2.0.vapi"
		_tmp10_ = offset;
#line 1218 "/usr/share/vala-0.30/vapi/glib-2.0.vapi"
		offset = _tmp9_ + _tmp10_;
#line 1219 "/usr/share/vala-0.30/vapi/glib-2.0.vapi"
		_tmp11_ = offset;
#line 1219 "/usr/share/vala-0.30/vapi/glib-2.0.vapi"
		g_return_val_if_fail (_tmp11_ >= ((glong) 0), NULL);
#line 2077 "ui.c"
	} else {
		glong _tmp12_ = 0L;
		glong _tmp13_ = 0L;
#line 1221 "/usr/share/vala-0.30/vapi/glib-2.0.vapi"
		_tmp12_ = offset;
#line 1221 "/usr/share/vala-0.30/vapi/glib-2.0.vapi"
		_tmp13_ = string_length;
#line 1221 "/usr/share/vala-0.30/vapi/glib-2.0.vapi"
		g_return_val_if_fail (_tmp12_ <= _tmp13_, NULL);
#line 2087 "ui.c"
	}
#line 1223 "/usr/share/vala-0.30/vapi/glib-2.0.vapi"
	_tmp14_ = len;
#line 1223 "/usr/share/vala-0.30/vapi/glib-2.0.vapi"
	if (_tmp14_ < ((glong) 0)) {
#line 2093 "ui.c"
		glong _tmp15_ = 0L;
		glong _tmp16_ = 0L;
#line 1224 "/usr/share/vala-0.30/vapi/glib-2.0.vapi"
		_tmp15_ = string_length;
#line 1224 "/usr/share/vala-0.30/vapi/glib-2.0.vapi"
		_tmp16_ = offset;
#line 1224 "/usr/share/vala-0.30/vapi/glib-2.0.vapi"
		len = _tmp15_ - _tmp16_;
#line 2102 "ui.c"
	}
#line 1226 "/usr/share/vala-0.30/vapi/glib-2.0.vapi"
	_tmp17_ = offset;
#line 1226 "/usr/share/vala-0.30/vapi/glib-2.0.vapi"
	_tmp18_ = len;
#line 1226 "/usr/share/vala-0.30/vapi/glib-2.0.vapi"
	_tmp19_ = string_length;
#line 1226 "/usr/share/vala-0.30/vapi/glib-2.0.vapi"
	g_return_val_if_fail ((_tmp17_ + _tmp18_) <= _tmp19_, NULL);
#line 1227 "/usr/share/vala-0.30/vapi/glib-2.0.vapi"
	_tmp20_ = offset;
#line 1227 "/usr/share/vala-0.30/vapi/glib-2.0.vapi"
	_tmp21_ = len;
#line 1227 "/usr/share/vala-0.30/vapi/glib-2.0.vapi"
	_tmp22_ = g_strndup (((gchar*) self) + _tmp20_, (gsize) _tmp21_);
#line 1227 "/usr/share/vala-0.30/vapi/glib-2.0.vapi"
	result = _tmp22_;
#line 1227 "/usr/share/vala-0.30/vapi/glib-2.0.vapi"
	return result;
#line 2122 "ui.c"
}


static void _user_interface_on_file_type_changed_gtk_tree_selection_changed (GtkTreeSelection* _sender, gpointer self) {
#line 514 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	user_interface_on_file_type_changed ((UserInterface*) self, _sender);
#line 2129 "ui.c"
}


static gchar* user_interface_choose_file_location (UserInterface* self) {
	gchar* result = NULL;
	gchar* directory = NULL;
	GSettings* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gboolean _tmp2_ = FALSE;
	const gchar* _tmp3_ = NULL;
	const gchar* _tmp7_ = NULL;
	GtkApplicationWindow* _tmp8_ = NULL;
	const gchar* _tmp9_ = NULL;
	const gchar* _tmp10_ = NULL;
	GtkFileChooserDialog* _tmp11_ = NULL;
	GtkFileChooserDialog* _tmp12_ = NULL;
	GtkFileChooserDialog* _tmp13_ = NULL;
	GtkFileChooserDialog* _tmp14_ = NULL;
	const gchar* _tmp15_ = NULL;
	GtkFileChooserDialog* _tmp16_ = NULL;
	const gchar* _tmp17_ = NULL;
	GtkFileFilter* filter = NULL;
	GtkFileFilter* _tmp18_ = NULL;
	GtkFileFilter* _tmp19_ = NULL;
	const gchar* _tmp20_ = NULL;
	GtkFileFilter* _tmp21_ = NULL;
	GtkFileFilter* _tmp22_ = NULL;
	GtkFileChooserDialog* _tmp23_ = NULL;
	GtkFileFilter* _tmp24_ = NULL;
	GtkFileFilter* _tmp25_ = NULL;
	GtkFileFilter* _tmp26_ = NULL;
	GtkFileFilter* _tmp27_ = NULL;
	const gchar* _tmp28_ = NULL;
	GtkFileFilter* _tmp29_ = NULL;
	GtkFileChooserDialog* _tmp30_ = NULL;
	GtkFileFilter* _tmp31_ = NULL;
	GtkFileFilter* _tmp32_ = NULL;
	GtkExpander* expander = NULL;
	const gchar* _tmp33_ = NULL;
	GtkExpander* _tmp34_ = NULL;
	GtkExpander* _tmp35_ = NULL;
	GtkFileChooserDialog* _tmp36_ = NULL;
	GtkExpander* _tmp37_ = NULL;
	gchar* default_extension = NULL;
	gchar* _tmp38_ = NULL;
	gint index = 0;
	const gchar* _tmp39_ = NULL;
	gint _tmp40_ = 0;
	gint _tmp41_ = 0;
	GtkListStore* file_type_store = NULL;
	GtkListStore* _tmp45_ = NULL;
	GtkTreeIter iter = {0};
	GtkListStore* _tmp46_ = NULL;
	GtkTreeIter _tmp47_ = {0};
	GtkListStore* _tmp48_ = NULL;
	GtkTreeIter _tmp49_ = {0};
	const gchar* _tmp50_ = NULL;
	GtkListStore* _tmp51_ = NULL;
	GtkTreeIter _tmp52_ = {0};
	GtkListStore* _tmp53_ = NULL;
	GtkTreeIter _tmp54_ = {0};
	const gchar* _tmp55_ = NULL;
	GtkListStore* _tmp56_ = NULL;
	GtkTreeIter _tmp57_ = {0};
	GtkListStore* _tmp58_ = NULL;
	GtkTreeIter _tmp59_ = {0};
	const gchar* _tmp60_ = NULL;
	GtkTreeView* file_type_view = NULL;
	GtkListStore* _tmp61_ = NULL;
	GtkTreeView* _tmp62_ = NULL;
	GtkTreeView* _tmp63_ = NULL;
	GtkTreeView* _tmp64_ = NULL;
	GtkTreeViewColumn* column = NULL;
	GtkCellRendererText* _tmp65_ = NULL;
	GtkCellRendererText* _tmp66_ = NULL;
	GtkTreeViewColumn* _tmp67_ = NULL;
	GtkTreeViewColumn* _tmp68_ = NULL;
	GtkTreeView* _tmp69_ = NULL;
	GtkTreeViewColumn* _tmp70_ = NULL;
	GtkExpander* _tmp71_ = NULL;
	GtkTreeView* _tmp72_ = NULL;
	GtkListStore* _tmp73_ = NULL;
	GtkTreeIter _tmp74_ = {0};
	gboolean _tmp75_ = FALSE;
	GtkTreeView* _tmp86_ = NULL;
	GtkTreeSelection* _tmp87_ = NULL;
	GtkExpander* _tmp88_ = NULL;
	gint response = 0;
	GtkFileChooserDialog* _tmp89_ = NULL;
	gint _tmp90_ = 0;
	gchar* uri = NULL;
	gint _tmp91_ = 0;
	GSettings* _tmp111_ = NULL;
	GtkFileChooserDialog* _tmp112_ = NULL;
	gchar* _tmp113_ = NULL;
	gchar* _tmp114_ = NULL;
	GtkTreeView* _tmp115_ = NULL;
	GtkTreeSelection* _tmp116_ = NULL;
	guint _tmp117_ = 0U;
	GtkFileChooserDialog* _tmp118_ = NULL;
#line 430 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 433 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	directory = NULL;
#line 434 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp0_ = self->priv->settings;
#line 434 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp1_ = g_settings_get_string (_tmp0_, "save-directory");
#line 434 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_g_free0 (directory);
#line 434 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	directory = _tmp1_;
#line 436 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp3_ = directory;
#line 436 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	if (_tmp3_ == NULL) {
#line 436 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		_tmp2_ = TRUE;
#line 2248 "ui.c"
	} else {
		const gchar* _tmp4_ = NULL;
#line 436 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		_tmp4_ = directory;
#line 436 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		_tmp2_ = g_strcmp0 (_tmp4_, "") == 0;
#line 2255 "ui.c"
	}
#line 436 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	if (_tmp2_) {
#line 2259 "ui.c"
		const gchar* _tmp5_ = NULL;
		gchar* _tmp6_ = NULL;
#line 437 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		_tmp5_ = g_get_user_special_dir (G_USER_DIRECTORY_DOCUMENTS);
#line 437 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		_tmp6_ = g_strdup (_tmp5_);
#line 437 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		_g_free0 (directory);
#line 437 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		directory = _tmp6_;
#line 2270 "ui.c"
	}
#line 439 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp7_ = _ ("Save As...");
#line 439 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp8_ = self->priv->window;
#line 439 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp9_ = _ ("_Cancel");
#line 439 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp10_ = _ ("_Save");
#line 439 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp11_ = (GtkFileChooserDialog*) gtk_file_chooser_dialog_new (_tmp7_, (GtkWindow*) _tmp8_, GTK_FILE_CHOOSER_ACTION_SAVE, _tmp9_, GTK_RESPONSE_CANCEL, _tmp10_, GTK_RESPONSE_ACCEPT, NULL, NULL);
#line 439 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	g_object_ref_sink (_tmp11_);
#line 439 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_g_object_unref0 (self->priv->save_dialog);
#line 439 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	self->priv->save_dialog = _tmp11_;
#line 446 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp12_ = self->priv->save_dialog;
#line 446 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	gtk_file_chooser_set_do_overwrite_confirmation ((GtkFileChooser*) _tmp12_, TRUE);
#line 447 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp13_ = self->priv->save_dialog;
#line 447 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	gtk_file_chooser_set_local_only ((GtkFileChooser*) _tmp13_, FALSE);
#line 448 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp14_ = self->priv->save_dialog;
#line 448 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp15_ = directory;
#line 448 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	gtk_file_chooser_set_current_folder ((GtkFileChooser*) _tmp14_, _tmp15_);
#line 449 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp16_ = self->priv->save_dialog;
#line 449 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp17_ = self->priv->_default_file_name;
#line 449 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	gtk_file_chooser_set_current_name ((GtkFileChooser*) _tmp16_, _tmp17_);
#line 452 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp18_ = gtk_file_filter_new ();
#line 452 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	g_object_ref_sink (_tmp18_);
#line 452 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	filter = _tmp18_;
#line 453 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp19_ = filter;
#line 453 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp20_ = _ ("Image Files");
#line 453 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	gtk_file_filter_set_name (_tmp19_, _tmp20_);
#line 455 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp21_ = filter;
#line 455 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	gtk_file_filter_add_pixbuf_formats (_tmp21_);
#line 456 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp22_ = filter;
#line 456 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	gtk_file_filter_add_mime_type (_tmp22_, "application/pdf");
#line 457 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp23_ = self->priv->save_dialog;
#line 457 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp24_ = filter;
#line 457 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp25_ = _g_object_ref0 (_tmp24_);
#line 457 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	gtk_file_chooser_add_filter ((GtkFileChooser*) _tmp23_, _tmp25_);
#line 458 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp26_ = gtk_file_filter_new ();
#line 458 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	g_object_ref_sink (_tmp26_);
#line 458 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_g_object_unref0 (filter);
#line 458 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	filter = _tmp26_;
#line 459 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp27_ = filter;
#line 459 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp28_ = _ ("All Files");
#line 459 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	gtk_file_filter_set_name (_tmp27_, _tmp28_);
#line 461 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp29_ = filter;
#line 461 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	gtk_file_filter_add_pattern (_tmp29_, "*");
#line 462 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp30_ = self->priv->save_dialog;
#line 462 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp31_ = filter;
#line 462 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp32_ = _g_object_ref0 (_tmp31_);
#line 462 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	gtk_file_chooser_add_filter ((GtkFileChooser*) _tmp30_, _tmp32_);
#line 464 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp33_ = _ ("Select File _Type");
#line 464 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp34_ = (GtkExpander*) gtk_expander_new_with_mnemonic (_tmp33_);
#line 464 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	g_object_ref_sink (_tmp34_);
#line 464 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	expander = _tmp34_;
#line 466 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp35_ = expander;
#line 466 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	gtk_expander_set_spacing (_tmp35_, 5);
#line 467 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp36_ = self->priv->save_dialog;
#line 467 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp37_ = expander;
#line 467 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	gtk_file_chooser_set_extra_widget ((GtkFileChooser*) _tmp36_, (GtkWidget*) _tmp37_);
#line 469 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp38_ = g_strdup ("");
#line 469 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	default_extension = _tmp38_;
#line 470 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp39_ = self->priv->_default_file_name;
#line 470 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp40_ = string_last_index_of_char (_tmp39_, (gunichar) '.', 0);
#line 470 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	index = _tmp40_;
#line 471 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp41_ = index;
#line 471 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	if (_tmp41_ >= 0) {
#line 2394 "ui.c"
		const gchar* _tmp42_ = NULL;
		gint _tmp43_ = 0;
		gchar* _tmp44_ = NULL;
#line 472 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		_tmp42_ = self->priv->_default_file_name;
#line 472 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		_tmp43_ = index;
#line 472 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		_tmp44_ = string_substring (_tmp42_, (glong) _tmp43_, (glong) -1);
#line 472 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		_g_free0 (default_extension);
#line 472 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		default_extension = _tmp44_;
#line 2408 "ui.c"
	}
#line 474 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp45_ = gtk_list_store_new (2, G_TYPE_STRING, G_TYPE_STRING, -1);
#line 474 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	file_type_store = _tmp45_;
#line 476 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp46_ = file_type_store;
#line 476 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	gtk_list_store_append (_tmp46_, &_tmp47_);
#line 476 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	iter = _tmp47_;
#line 477 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp48_ = file_type_store;
#line 477 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp49_ = iter;
#line 477 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp50_ = _ ("PDF (multi-page document)");
#line 477 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	gtk_list_store_set (_tmp48_, &_tmp49_, 0, _tmp50_, 1, ".pdf", -1, -1);
#line 482 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp51_ = file_type_store;
#line 482 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	gtk_list_store_append (_tmp51_, &_tmp52_);
#line 482 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	iter = _tmp52_;
#line 483 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp53_ = file_type_store;
#line 483 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp54_ = iter;
#line 483 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp55_ = _ ("JPEG (compressed)");
#line 483 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	gtk_list_store_set (_tmp53_, &_tmp54_, 0, _tmp55_, 1, ".jpg", -1, -1);
#line 488 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp56_ = file_type_store;
#line 488 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	gtk_list_store_append (_tmp56_, &_tmp57_);
#line 488 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	iter = _tmp57_;
#line 489 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp58_ = file_type_store;
#line 489 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp59_ = iter;
#line 489 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp60_ = _ ("PNG (lossless)");
#line 489 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	gtk_list_store_set (_tmp58_, &_tmp59_, 0, _tmp60_, 1, ".png", -1, -1);
#line 495 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp61_ = file_type_store;
#line 495 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp62_ = (GtkTreeView*) gtk_tree_view_new_with_model ((GtkTreeModel*) _tmp61_);
#line 495 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	g_object_ref_sink (_tmp62_);
#line 495 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	file_type_view = _tmp62_;
#line 496 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp63_ = file_type_view;
#line 496 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	gtk_tree_view_set_headers_visible (_tmp63_, FALSE);
#line 497 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp64_ = file_type_view;
#line 497 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	gtk_tree_view_set_rules_hint (_tmp64_, TRUE);
#line 498 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp65_ = (GtkCellRendererText*) gtk_cell_renderer_text_new ();
#line 498 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	g_object_ref_sink (_tmp65_);
#line 498 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp66_ = _tmp65_;
#line 498 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp67_ = gtk_tree_view_column_new_with_attributes ("", (GtkCellRenderer*) _tmp66_, "text", 0, NULL, NULL);
#line 498 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	g_object_ref_sink (_tmp67_);
#line 498 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp68_ = _tmp67_;
#line 498 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_g_object_unref0 (_tmp66_);
#line 498 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	column = _tmp68_;
#line 501 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp69_ = file_type_view;
#line 501 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp70_ = column;
#line 501 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	gtk_tree_view_append_column (_tmp69_, _tmp70_);
#line 502 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp71_ = expander;
#line 502 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp72_ = file_type_view;
#line 502 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	gtk_container_add ((GtkContainer*) _tmp71_, (GtkWidget*) _tmp72_);
#line 504 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp73_ = file_type_store;
#line 504 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp75_ = gtk_tree_model_get_iter_first ((GtkTreeModel*) _tmp73_, &_tmp74_);
#line 504 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	iter = _tmp74_;
#line 504 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	if (_tmp75_) {
#line 2508 "ui.c"
		{
			gboolean _tmp76_ = FALSE;
#line 506 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
			_tmp76_ = TRUE;
#line 506 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
			while (TRUE) {
#line 2515 "ui.c"
				gchar* e = NULL;
				GtkListStore* _tmp79_ = NULL;
				GtkTreeIter _tmp80_ = {0};
				const gchar* _tmp81_ = NULL;
				const gchar* _tmp82_ = NULL;
#line 506 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
				if (!_tmp76_) {
#line 2523 "ui.c"
					GtkListStore* _tmp77_ = NULL;
					gboolean _tmp78_ = FALSE;
#line 512 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
					_tmp77_ = file_type_store;
#line 512 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
					_tmp78_ = gtk_tree_model_iter_next ((GtkTreeModel*) _tmp77_, &iter);
#line 512 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
					if (!_tmp78_) {
#line 512 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
						break;
#line 2534 "ui.c"
					}
				}
#line 506 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
				_tmp76_ = FALSE;
#line 509 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
				_tmp79_ = file_type_store;
#line 509 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
				_tmp80_ = iter;
#line 509 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
				gtk_tree_model_get ((GtkTreeModel*) _tmp79_, &_tmp80_, 1, &e, -1, -1);
#line 510 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
				_tmp81_ = default_extension;
#line 510 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
				_tmp82_ = e;
#line 510 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
				if (g_strcmp0 (_tmp81_, _tmp82_) == 0) {
#line 2551 "ui.c"
					GtkTreeView* _tmp83_ = NULL;
					GtkTreeSelection* _tmp84_ = NULL;
					GtkTreeIter _tmp85_ = {0};
#line 511 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
					_tmp83_ = file_type_view;
#line 511 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
					_tmp84_ = gtk_tree_view_get_selection (_tmp83_);
#line 511 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
					_tmp85_ = iter;
#line 511 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
					gtk_tree_selection_select_iter (_tmp84_, &_tmp85_);
#line 2563 "ui.c"
				}
#line 506 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
				_g_free0 (e);
#line 2567 "ui.c"
			}
		}
	}
#line 514 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp86_ = file_type_view;
#line 514 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp87_ = gtk_tree_view_get_selection (_tmp86_);
#line 514 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	g_signal_connect (_tmp87_, "changed", (GCallback) _user_interface_on_file_type_changed_gtk_tree_selection_changed, self);
#line 516 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp88_ = expander;
#line 516 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	gtk_widget_show_all ((GtkWidget*) _tmp88_);
#line 518 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp89_ = self->priv->save_dialog;
#line 518 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp90_ = gtk_dialog_run ((GtkDialog*) _tmp89_);
#line 518 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	response = _tmp90_;
#line 520 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	uri = NULL;
#line 521 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp91_ = response;
#line 521 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	if (_tmp91_ == ((gint) GTK_RESPONSE_ACCEPT)) {
#line 2593 "ui.c"
		GtkTreeSelection* selection = NULL;
		GtkTreeView* _tmp92_ = NULL;
		GtkTreeSelection* _tmp93_ = NULL;
		GtkTreeSelection* _tmp94_ = NULL;
		gchar* extension = NULL;
		GtkTreeSelection* _tmp95_ = NULL;
		gchar* _tmp96_ = NULL;
		gchar* path = NULL;
		GtkFileChooserDialog* _tmp97_ = NULL;
		gchar* _tmp98_ = NULL;
		gchar* filename = NULL;
		const gchar* _tmp99_ = NULL;
		gchar* _tmp100_ = NULL;
		gint extension_index = 0;
		const gchar* _tmp101_ = NULL;
		gint _tmp102_ = 0;
		gint _tmp103_ = 0;
		const gchar* _tmp107_ = NULL;
		GFile* _tmp108_ = NULL;
		GFile* _tmp109_ = NULL;
		gchar* _tmp110_ = NULL;
#line 523 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		_tmp92_ = file_type_view;
#line 523 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		_tmp93_ = gtk_tree_view_get_selection (_tmp92_);
#line 523 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		_tmp94_ = _g_object_ref0 (_tmp93_);
#line 523 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		selection = _tmp94_;
#line 524 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		_tmp95_ = selection;
#line 524 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		_tmp96_ = user_interface_get_selected_extension (self, _tmp95_);
#line 524 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		extension = _tmp96_;
#line 526 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		_tmp97_ = self->priv->save_dialog;
#line 526 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		_tmp98_ = gtk_file_chooser_get_filename ((GtkFileChooser*) _tmp97_);
#line 526 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		path = _tmp98_;
#line 527 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		_tmp99_ = path;
#line 527 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		_tmp100_ = g_path_get_basename (_tmp99_);
#line 527 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		filename = _tmp100_;
#line 529 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		_tmp101_ = filename;
#line 529 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		_tmp102_ = string_last_index_of_char (_tmp101_, (gunichar) '.', 0);
#line 529 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		extension_index = _tmp102_;
#line 530 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		_tmp103_ = extension_index;
#line 530 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		if (_tmp103_ < 0) {
#line 2651 "ui.c"
			const gchar* _tmp104_ = NULL;
			const gchar* _tmp105_ = NULL;
			gchar* _tmp106_ = NULL;
#line 531 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
			_tmp104_ = path;
#line 531 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
			_tmp105_ = extension;
#line 531 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
			_tmp106_ = g_strconcat (_tmp104_, _tmp105_, NULL);
#line 531 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
			_g_free0 (path);
#line 531 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
			path = _tmp106_;
#line 2665 "ui.c"
		}
#line 533 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		_tmp107_ = path;
#line 533 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		_tmp108_ = g_file_new_for_path (_tmp107_);
#line 533 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		_tmp109_ = _tmp108_;
#line 533 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		_tmp110_ = g_file_get_uri (_tmp109_);
#line 533 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		_g_free0 (uri);
#line 533 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		uri = _tmp110_;
#line 533 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		_g_object_unref0 (_tmp109_);
#line 521 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		_g_free0 (filename);
#line 521 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		_g_free0 (path);
#line 521 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		_g_free0 (extension);
#line 521 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		_g_object_unref0 (selection);
#line 2689 "ui.c"
	}
#line 536 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp111_ = self->priv->settings;
#line 536 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp112_ = self->priv->save_dialog;
#line 536 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp113_ = gtk_file_chooser_get_current_folder ((GtkFileChooser*) _tmp112_);
#line 536 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp114_ = _tmp113_;
#line 536 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	g_settings_set_string (_tmp111_, "save-directory", _tmp114_);
#line 536 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_g_free0 (_tmp114_);
#line 538 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp115_ = file_type_view;
#line 538 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp116_ = gtk_tree_view_get_selection (_tmp115_);
#line 538 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	g_signal_parse_name ("changed", gtk_tree_selection_get_type (), &_tmp117_, NULL, FALSE);
#line 538 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	g_signal_handlers_disconnect_matched (_tmp116_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp117_, 0, NULL, (GCallback) _user_interface_on_file_type_changed_gtk_tree_selection_changed, self);
#line 539 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp118_ = self->priv->save_dialog;
#line 539 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	gtk_widget_destroy ((GtkWidget*) _tmp118_);
#line 540 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_g_object_unref0 (self->priv->save_dialog);
#line 540 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	self->priv->save_dialog = NULL;
#line 542 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	result = uri;
#line 542 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_g_object_unref0 (column);
#line 542 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_g_object_unref0 (file_type_view);
#line 542 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_g_object_unref0 (file_type_store);
#line 542 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_g_free0 (default_extension);
#line 542 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_g_object_unref0 (expander);
#line 542 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_g_object_unref0 (filter);
#line 542 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_g_free0 (directory);
#line 542 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	return result;
#line 2737 "ui.c"
}


static gboolean user_interface_save_document (UserInterface* self, gboolean force_choose_location) {
	gboolean result = FALSE;
	gchar* uri = NULL;
	gboolean _tmp0_ = FALSE;
	const gchar* _tmp1_ = NULL;
	const gchar* _tmp6_ = NULL;
	GFile* file = NULL;
	const gchar* _tmp7_ = NULL;
	GFile* _tmp8_ = NULL;
	const gchar* _tmp9_ = NULL;
	gchar* uri_lower = NULL;
	const gchar* _tmp10_ = NULL;
	gchar* _tmp11_ = NULL;
	gchar* format = NULL;
	gchar* _tmp12_ = NULL;
	const gchar* _tmp13_ = NULL;
	gboolean _tmp14_ = FALSE;
	const gchar* _tmp38_ = NULL;
	gchar* _tmp39_ = NULL;
	Book* _tmp40_ = NULL;
	GError * _inner_error_ = NULL;
#line 545 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 548 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp1_ = self->priv->book_uri;
#line 548 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	if (_tmp1_ != NULL) {
#line 2768 "ui.c"
		gboolean _tmp2_ = FALSE;
#line 548 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		_tmp2_ = force_choose_location;
#line 548 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		_tmp0_ = !_tmp2_;
#line 2774 "ui.c"
	} else {
#line 548 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		_tmp0_ = FALSE;
#line 2778 "ui.c"
	}
#line 548 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	if (_tmp0_) {
#line 2782 "ui.c"
		const gchar* _tmp3_ = NULL;
		gchar* _tmp4_ = NULL;
#line 549 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		_tmp3_ = self->priv->book_uri;
#line 549 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		_tmp4_ = g_strdup (_tmp3_);
#line 549 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		_g_free0 (uri);
#line 549 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		uri = _tmp4_;
#line 2793 "ui.c"
	} else {
		gchar* _tmp5_ = NULL;
#line 551 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		_tmp5_ = user_interface_choose_file_location (self);
#line 551 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		_g_free0 (uri);
#line 551 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		uri = _tmp5_;
#line 2802 "ui.c"
	}
#line 552 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp6_ = uri;
#line 552 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	if (_tmp6_ == NULL) {
#line 553 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		result = FALSE;
#line 553 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		_g_free0 (uri);
#line 553 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		return result;
#line 2814 "ui.c"
	}
#line 555 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp7_ = uri;
#line 555 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp8_ = g_file_new_for_uri (_tmp7_);
#line 555 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	file = _tmp8_;
#line 557 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp9_ = uri;
#line 557 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	g_debug ("ui.vala:557: Saving to '%s'", _tmp9_);
#line 559 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp10_ = uri;
#line 559 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp11_ = g_utf8_strdown (_tmp10_, (gssize) -1);
#line 559 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	uri_lower = _tmp11_;
#line 560 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp12_ = g_strdup ("jpeg");
#line 560 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	format = _tmp12_;
#line 561 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp13_ = uri_lower;
#line 561 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp14_ = g_str_has_suffix (_tmp13_, ".pdf");
#line 561 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	if (_tmp14_) {
#line 2842 "ui.c"
		gchar* _tmp15_ = NULL;
#line 562 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		_tmp15_ = g_strdup ("pdf");
#line 562 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		_g_free0 (format);
#line 562 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		format = _tmp15_;
#line 2850 "ui.c"
	} else {
		const gchar* _tmp16_ = NULL;
		gboolean _tmp17_ = FALSE;
#line 563 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		_tmp16_ = uri_lower;
#line 563 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		_tmp17_ = g_str_has_suffix (_tmp16_, ".ps");
#line 563 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		if (_tmp17_) {
#line 2860 "ui.c"
			gchar* _tmp18_ = NULL;
#line 564 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
			_tmp18_ = g_strdup ("ps");
#line 564 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
			_g_free0 (format);
#line 564 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
			format = _tmp18_;
#line 2868 "ui.c"
		} else {
			const gchar* _tmp19_ = NULL;
			gboolean _tmp20_ = FALSE;
#line 565 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
			_tmp19_ = uri_lower;
#line 565 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
			_tmp20_ = g_str_has_suffix (_tmp19_, ".png");
#line 565 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
			if (_tmp20_) {
#line 2878 "ui.c"
				gchar* _tmp21_ = NULL;
#line 566 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
				_tmp21_ = g_strdup ("png");
#line 566 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
				_g_free0 (format);
#line 566 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
				format = _tmp21_;
#line 2886 "ui.c"
			} else {
				gboolean _tmp22_ = FALSE;
				const gchar* _tmp23_ = NULL;
				gboolean _tmp24_ = FALSE;
#line 567 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
				_tmp23_ = uri_lower;
#line 567 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
				_tmp24_ = g_str_has_suffix (_tmp23_, ".tif");
#line 567 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
				if (_tmp24_) {
#line 567 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
					_tmp22_ = TRUE;
#line 2899 "ui.c"
				} else {
					const gchar* _tmp25_ = NULL;
					gboolean _tmp26_ = FALSE;
#line 567 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
					_tmp25_ = uri_lower;
#line 567 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
					_tmp26_ = g_str_has_suffix (_tmp25_, ".tiff");
#line 567 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
					_tmp22_ = _tmp26_;
#line 2909 "ui.c"
				}
#line 567 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
				if (_tmp22_) {
#line 2913 "ui.c"
					gchar* _tmp27_ = NULL;
#line 568 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
					_tmp27_ = g_strdup ("tiff");
#line 568 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
					_g_free0 (format);
#line 568 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
					format = _tmp27_;
#line 2921 "ui.c"
				}
			}
		}
	}
#line 570 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	user_interface_show_progress_dialog (self);
#line 2928 "ui.c"
	{
		Book* _tmp28_ = NULL;
		const gchar* _tmp29_ = NULL;
		gint _tmp30_ = 0;
		gint _tmp31_ = 0;
		GFile* _tmp32_ = NULL;
#line 573 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		_tmp28_ = self->priv->_book;
#line 573 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		_tmp29_ = format;
#line 573 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		_tmp30_ = user_interface_get_quality (self);
#line 573 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		_tmp31_ = _tmp30_;
#line 573 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		_tmp32_ = file;
#line 573 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		book_save (_tmp28_, _tmp29_, _tmp31_, _tmp32_, &_inner_error_);
#line 573 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 2949 "ui.c"
			goto __catch16_g_error;
		}
	}
	goto __finally16;
	__catch16_g_error:
	{
		GError* e = NULL;
		GError* _tmp33_ = NULL;
		const gchar* _tmp34_ = NULL;
		const gchar* _tmp35_ = NULL;
		GError* _tmp36_ = NULL;
		const gchar* _tmp37_ = NULL;
#line 571 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		e = _inner_error_;
#line 571 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		_inner_error_ = NULL;
#line 577 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		user_interface_hide_progress_dialog (self);
#line 578 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		_tmp33_ = e;
#line 578 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		_tmp34_ = _tmp33_->message;
#line 578 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		g_warning ("ui.vala:578: Error saving file: %s", _tmp34_);
#line 579 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		_tmp35_ = _ ("Failed to save file");
#line 579 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		_tmp36_ = e;
#line 579 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		_tmp37_ = _tmp36_->message;
#line 579 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		user_interface_show_error (self, _tmp35_, _tmp37_, FALSE);
#line 583 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		result = FALSE;
#line 583 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		_g_error_free0 (e);
#line 583 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		_g_free0 (format);
#line 583 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		_g_free0 (uri_lower);
#line 583 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		_g_object_unref0 (file);
#line 583 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		_g_free0 (uri);
#line 583 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		return result;
#line 2996 "ui.c"
	}
	__finally16:
#line 571 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 571 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		_g_free0 (format);
#line 571 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		_g_free0 (uri_lower);
#line 571 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		_g_object_unref0 (file);
#line 571 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		_g_free0 (uri);
#line 571 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 571 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		g_clear_error (&_inner_error_);
#line 571 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		return FALSE;
#line 3015 "ui.c"
	}
#line 586 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp38_ = uri;
#line 586 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp39_ = g_strdup (_tmp38_);
#line 586 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_g_free0 (self->priv->book_uri);
#line 586 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	self->priv->book_uri = _tmp39_;
#line 587 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp40_ = self->priv->_book;
#line 587 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	book_set_needs_saving (_tmp40_, FALSE);
#line 588 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	result = TRUE;
#line 588 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_g_free0 (format);
#line 588 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_g_free0 (uri_lower);
#line 588 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_g_object_unref0 (file);
#line 588 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_g_free0 (uri);
#line 588 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	return result;
#line 3041 "ui.c"
}


static gboolean user_interface_prompt_to_save (UserInterface* self, const gchar* title, const gchar* discard_label) {
	gboolean result = FALSE;
	Book* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	GtkMessageDialog* dialog = NULL;
	GtkApplicationWindow* _tmp3_ = NULL;
	const gchar* _tmp4_ = NULL;
	GtkMessageDialog* _tmp5_ = NULL;
	GtkMessageDialog* _tmp6_ = NULL;
	const gchar* _tmp7_ = NULL;
	GtkMessageDialog* _tmp8_ = NULL;
	const gchar* _tmp9_ = NULL;
	GtkMessageDialog* _tmp10_ = NULL;
	const gchar* _tmp11_ = NULL;
	GtkMessageDialog* _tmp12_ = NULL;
	const gchar* _tmp13_ = NULL;
	gint response = 0;
	GtkMessageDialog* _tmp14_ = NULL;
	gint _tmp15_ = 0;
	GtkMessageDialog* _tmp16_ = NULL;
	gint _tmp17_ = 0;
#line 591 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 591 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	g_return_val_if_fail (title != NULL, FALSE);
#line 591 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	g_return_val_if_fail (discard_label != NULL, FALSE);
#line 593 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp0_ = self->priv->_book;
#line 593 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp1_ = book_get_needs_saving (_tmp0_);
#line 593 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp2_ = _tmp1_;
#line 593 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	if (!_tmp2_) {
#line 594 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		result = TRUE;
#line 594 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		return result;
#line 3085 "ui.c"
	}
#line 596 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp3_ = self->priv->window;
#line 596 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp4_ = title;
#line 596 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp5_ = (GtkMessageDialog*) gtk_message_dialog_new ((GtkWindow*) _tmp3_, GTK_DIALOG_MODAL, GTK_MESSAGE_WARNING, GTK_BUTTONS_NONE, "%s", _tmp4_);
#line 596 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	g_object_ref_sink (_tmp5_);
#line 596 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	dialog = _tmp5_;
#line 601 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp6_ = dialog;
#line 601 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp7_ = _ ("If you don't save, changes will be permanently lost.");
#line 601 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	gtk_message_dialog_format_secondary_text (_tmp6_, "%s", _tmp7_);
#line 604 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp8_ = dialog;
#line 604 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp9_ = discard_label;
#line 604 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	gtk_dialog_add_button ((GtkDialog*) _tmp8_, _tmp9_, (gint) GTK_RESPONSE_NO);
#line 605 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp10_ = dialog;
#line 605 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp11_ = _ ("_Cancel");
#line 605 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	gtk_dialog_add_button ((GtkDialog*) _tmp10_, _tmp11_, (gint) GTK_RESPONSE_CANCEL);
#line 606 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp12_ = dialog;
#line 606 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp13_ = _ ("_Save");
#line 606 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	gtk_dialog_add_button ((GtkDialog*) _tmp12_, _tmp13_, (gint) GTK_RESPONSE_YES);
#line 608 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp14_ = dialog;
#line 608 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp15_ = gtk_dialog_run ((GtkDialog*) _tmp14_);
#line 608 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	response = _tmp15_;
#line 609 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp16_ = dialog;
#line 609 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	gtk_widget_destroy ((GtkWidget*) _tmp16_);
#line 611 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp17_ = response;
#line 611 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	switch (_tmp17_) {
#line 611 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		case GTK_RESPONSE_YES:
#line 3137 "ui.c"
		{
			gboolean _tmp18_ = FALSE;
#line 614 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
			_tmp18_ = user_interface_save_document (self, FALSE);
#line 614 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
			if (_tmp18_) {
#line 615 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
				result = TRUE;
#line 615 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
				_g_object_unref0 (dialog);
#line 615 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
				return result;
#line 3150 "ui.c"
			} else {
#line 617 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
				result = FALSE;
#line 617 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
				_g_object_unref0 (dialog);
#line 617 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
				return result;
#line 3158 "ui.c"
			}
		}
#line 611 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		case GTK_RESPONSE_NO:
#line 3163 "ui.c"
		{
#line 619 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
			result = TRUE;
#line 619 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
			_g_object_unref0 (dialog);
#line 619 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
			return result;
#line 3171 "ui.c"
		}
		default:
		{
#line 621 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
			result = FALSE;
#line 621 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
			_g_object_unref0 (dialog);
#line 621 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
			return result;
#line 3181 "ui.c"
		}
	}
#line 591 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_g_object_unref0 (dialog);
#line 3186 "ui.c"
}


static void user_interface_clear_document (UserInterface* self) {
	Book* _tmp0_ = NULL;
	Book* _tmp1_ = NULL;
	GtkMenuItem* _tmp2_ = NULL;
	GtkMenuItem* _tmp3_ = NULL;
#line 625 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	g_return_if_fail (self != NULL);
#line 627 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp0_ = self->priv->_book;
#line 627 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	book_clear (_tmp0_);
#line 628 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	user_interface_add_default_page (self);
#line 629 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_g_free0 (self->priv->book_uri);
#line 629 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	self->priv->book_uri = NULL;
#line 630 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp1_ = self->priv->_book;
#line 630 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	book_set_needs_saving (_tmp1_, FALSE);
#line 631 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp2_ = self->priv->save_as_menuitem;
#line 631 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	gtk_widget_set_sensitive ((GtkWidget*) _tmp2_, FALSE);
#line 632 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp3_ = self->priv->copy_to_clipboard_menuitem;
#line 632 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	gtk_widget_set_sensitive ((GtkWidget*) _tmp3_, FALSE);
#line 3219 "ui.c"
}


static void user_interface_new_document (UserInterface* self) {
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	gboolean _tmp4_ = FALSE;
#line 635 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	g_return_if_fail (self != NULL);
#line 637 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp0_ = _ ("Save current document?");
#line 637 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp1_ = _ ("Discard Changes");
#line 637 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp2_ = user_interface_prompt_to_save (self, _tmp0_, _tmp1_);
#line 637 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	if (!_tmp2_) {
#line 641 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		return;
#line 3241 "ui.c"
	}
#line 643 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp3_ = user_interface_get_scanning (self);
#line 643 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp4_ = _tmp3_;
#line 643 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	if (_tmp4_) {
#line 644 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		g_signal_emit_by_name (self, "stop-scan");
#line 3251 "ui.c"
	}
#line 645 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	user_interface_clear_document (self);
#line 3255 "ui.c"
}


void G_MODULE_EXPORT new_button_clicked_cb (GtkWidget* widget, UserInterface* self) {
#line 649 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	g_return_if_fail (self != NULL);
#line 649 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	g_return_if_fail (widget != NULL);
#line 651 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	user_interface_new_document (self);
#line 3266 "ui.c"
}


void user_interface_new_document_activate_cb (UserInterface* self) {
#line 654 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	g_return_if_fail (self != NULL);
#line 656 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	user_interface_new_document (self);
#line 3275 "ui.c"
}


static void user_interface_set_document_hint (UserInterface* self, const gchar* document_hint, gboolean save) {
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	gboolean _tmp8_ = FALSE;
#line 659 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	g_return_if_fail (self != NULL);
#line 659 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	g_return_if_fail (document_hint != NULL);
#line 661 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp0_ = document_hint;
#line 661 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp1_ = g_strdup (_tmp0_);
#line 661 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_g_free0 (self->priv->document_hint);
#line 661 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	self->priv->document_hint = _tmp1_;
#line 663 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp2_ = document_hint;
#line 663 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	if (g_strcmp0 (_tmp2_, "text") == 0) {
#line 3300 "ui.c"
		GtkRadioMenuItem* _tmp3_ = NULL;
		GtkRadioMenuItem* _tmp4_ = NULL;
#line 665 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		_tmp3_ = self->priv->text_toolbar_menuitem;
#line 665 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		gtk_check_menu_item_set_active ((GtkCheckMenuItem*) _tmp3_, TRUE);
#line 666 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		_tmp4_ = self->priv->text_menu_menuitem;
#line 666 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		gtk_check_menu_item_set_active ((GtkCheckMenuItem*) _tmp4_, TRUE);
#line 3311 "ui.c"
	} else {
		const gchar* _tmp5_ = NULL;
#line 668 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		_tmp5_ = document_hint;
#line 668 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		if (g_strcmp0 (_tmp5_, "photo") == 0) {
#line 3318 "ui.c"
			GtkRadioMenuItem* _tmp6_ = NULL;
			GtkRadioMenuItem* _tmp7_ = NULL;
#line 670 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
			_tmp6_ = self->priv->photo_toolbar_menuitem;
#line 670 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
			gtk_check_menu_item_set_active ((GtkCheckMenuItem*) _tmp6_, TRUE);
#line 671 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
			_tmp7_ = self->priv->photo_menu_menuitem;
#line 671 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
			gtk_check_menu_item_set_active ((GtkCheckMenuItem*) _tmp7_, TRUE);
#line 3329 "ui.c"
		}
	}
#line 674 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp8_ = save;
#line 674 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	if (_tmp8_) {
#line 3336 "ui.c"
		GSettings* _tmp9_ = NULL;
		const gchar* _tmp10_ = NULL;
#line 675 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		_tmp9_ = self->priv->settings;
#line 675 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		_tmp10_ = document_hint;
#line 675 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		g_settings_set_string (_tmp9_, "document-type", _tmp10_);
#line 3345 "ui.c"
	}
}


void G_MODULE_EXPORT text_menuitem_toggled_cb (GtkCheckMenuItem* widget, UserInterface* self) {
	GtkCheckMenuItem* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
#line 679 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	g_return_if_fail (self != NULL);
#line 679 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	g_return_if_fail (widget != NULL);
#line 681 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp0_ = widget;
#line 681 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp1_ = gtk_check_menu_item_get_active (_tmp0_);
#line 681 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	if (_tmp1_) {
#line 682 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		user_interface_set_document_hint (self, "text", TRUE);
#line 3365 "ui.c"
	}
}


void G_MODULE_EXPORT photo_menuitem_toggled_cb (GtkCheckMenuItem* widget, UserInterface* self) {
	GtkCheckMenuItem* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
#line 686 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	g_return_if_fail (self != NULL);
#line 686 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	g_return_if_fail (widget != NULL);
#line 688 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp0_ = widget;
#line 688 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp1_ = gtk_check_menu_item_get_active (_tmp0_);
#line 688 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	if (_tmp1_) {
#line 690 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		user_interface_set_document_hint (self, "photo", TRUE);
#line 3385 "ui.c"
	}
}


static void user_interface_set_page_side (UserInterface* self, ScanType page_side) {
	GtkTreeIter iter = {0};
	GtkListStore* _tmp0_ = NULL;
	GtkTreeIter _tmp1_ = {0};
	gboolean _tmp2_ = FALSE;
#line 694 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	g_return_if_fail (self != NULL);
#line 698 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp0_ = self->priv->page_side_model;
#line 698 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp2_ = gtk_tree_model_get_iter_first ((GtkTreeModel*) _tmp0_, &_tmp1_);
#line 698 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	iter = _tmp1_;
#line 698 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	if (_tmp2_) {
#line 3405 "ui.c"
		{
			gboolean _tmp3_ = FALSE;
#line 700 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
			_tmp3_ = TRUE;
#line 700 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
			while (TRUE) {
#line 3412 "ui.c"
				gint s = 0;
				GtkListStore* _tmp6_ = NULL;
				GtkTreeIter _tmp7_ = {0};
				gint _tmp8_ = 0;
				ScanType _tmp9_ = 0;
#line 700 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
				if (!_tmp3_) {
#line 3420 "ui.c"
					GtkListStore* _tmp4_ = NULL;
					gboolean _tmp5_ = FALSE;
#line 709 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
					_tmp4_ = self->priv->page_side_model;
#line 709 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
					_tmp5_ = gtk_tree_model_iter_next ((GtkTreeModel*) _tmp4_, &iter);
#line 709 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
					if (!_tmp5_) {
#line 709 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
						break;
#line 3431 "ui.c"
					}
				}
#line 700 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
				_tmp3_ = FALSE;
#line 703 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
				_tmp6_ = self->priv->page_side_model;
#line 703 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
				_tmp7_ = iter;
#line 703 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
				gtk_tree_model_get ((GtkTreeModel*) _tmp6_, &_tmp7_, 0, &s, -1, -1);
#line 704 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
				_tmp8_ = s;
#line 704 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
				_tmp9_ = page_side;
#line 704 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
				if (_tmp8_ == ((gint) _tmp9_)) {
#line 3448 "ui.c"
					GtkComboBox* _tmp10_ = NULL;
					GtkTreeIter _tmp11_ = {0};
#line 706 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
					_tmp10_ = self->priv->page_side_combo;
#line 706 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
					_tmp11_ = iter;
#line 706 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
					gtk_combo_box_set_active_iter (_tmp10_, &_tmp11_);
#line 707 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
					return;
#line 3459 "ui.c"
				}
			}
		}
	}
}


static void user_interface_set_paper_size (UserInterface* self, gint width, gint height) {
	GtkTreeIter iter = {0};
	gboolean have_iter = FALSE;
	gboolean _tmp14_ = FALSE;
	gboolean _tmp18_ = FALSE;
#line 713 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	g_return_if_fail (self != NULL);
#line 3474 "ui.c"
	{
		GtkListStore* _tmp0_ = NULL;
		GtkTreeIter _tmp1_ = {0};
		gboolean _tmp2_ = FALSE;
		gboolean _tmp3_ = FALSE;
#line 718 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		_tmp0_ = self->priv->paper_size_model;
#line 718 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		_tmp2_ = gtk_tree_model_get_iter_first ((GtkTreeModel*) _tmp0_, &_tmp1_);
#line 718 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		iter = _tmp1_;
#line 718 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		have_iter = _tmp2_;
#line 718 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		_tmp3_ = TRUE;
#line 718 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		while (TRUE) {
#line 3492 "ui.c"
			gboolean _tmp6_ = FALSE;
			gint w = 0;
			gint h = 0;
			GtkListStore* _tmp7_ = NULL;
			GtkTreeIter _tmp8_ = {0};
			gboolean _tmp9_ = FALSE;
			gint _tmp10_ = 0;
			gint _tmp11_ = 0;
#line 718 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
			if (!_tmp3_) {
#line 3503 "ui.c"
				GtkListStore* _tmp4_ = NULL;
				gboolean _tmp5_ = FALSE;
#line 720 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
				_tmp4_ = self->priv->paper_size_model;
#line 720 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
				_tmp5_ = gtk_tree_model_iter_next ((GtkTreeModel*) _tmp4_, &iter);
#line 720 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
				have_iter = _tmp5_;
#line 3512 "ui.c"
			}
#line 718 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
			_tmp3_ = FALSE;
#line 719 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
			_tmp6_ = have_iter;
#line 719 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
			if (!_tmp6_) {
#line 719 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
				break;
#line 3522 "ui.c"
			}
#line 723 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
			_tmp7_ = self->priv->paper_size_model;
#line 723 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
			_tmp8_ = iter;
#line 723 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
			gtk_tree_model_get ((GtkTreeModel*) _tmp7_, &_tmp8_, 0, &w, 1, &h, -1, -1);
#line 724 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
			_tmp10_ = w;
#line 724 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
			_tmp11_ = width;
#line 724 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
			if (_tmp10_ == _tmp11_) {
#line 3536 "ui.c"
				gint _tmp12_ = 0;
				gint _tmp13_ = 0;
#line 724 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
				_tmp12_ = h;
#line 724 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
				_tmp13_ = height;
#line 724 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
				_tmp9_ = _tmp12_ == _tmp13_;
#line 3545 "ui.c"
			} else {
#line 724 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
				_tmp9_ = FALSE;
#line 3549 "ui.c"
			}
#line 724 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
			if (_tmp9_) {
#line 725 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
				break;
#line 3555 "ui.c"
			}
		}
	}
#line 728 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp14_ = have_iter;
#line 728 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	if (!_tmp14_) {
#line 3563 "ui.c"
		GtkListStore* _tmp15_ = NULL;
		GtkTreeIter _tmp16_ = {0};
		gboolean _tmp17_ = FALSE;
#line 729 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		_tmp15_ = self->priv->paper_size_model;
#line 729 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		_tmp17_ = gtk_tree_model_get_iter_first ((GtkTreeModel*) _tmp15_, &_tmp16_);
#line 729 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		iter = _tmp16_;
#line 729 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		have_iter = _tmp17_;
#line 3575 "ui.c"
	}
#line 730 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp18_ = have_iter;
#line 730 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	if (_tmp18_) {
#line 3581 "ui.c"
		GtkComboBox* _tmp19_ = NULL;
		GtkTreeIter _tmp20_ = {0};
#line 731 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		_tmp19_ = self->priv->paper_size_combo;
#line 731 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		_tmp20_ = iter;
#line 731 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		gtk_combo_box_set_active_iter (_tmp19_, &_tmp20_);
#line 3590 "ui.c"
	}
}


static gint user_interface_get_text_dpi (UserInterface* self) {
	gint result = 0;
	GtkTreeIter iter = {0};
	gint dpi = 0;
	GtkComboBox* _tmp0_ = NULL;
	GtkTreeIter _tmp1_ = {0};
	gboolean _tmp2_ = FALSE;
#line 734 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 737 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	dpi = USER_INTERFACE_DEFAULT_TEXT_DPI;
#line 739 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp0_ = self->priv->text_dpi_combo;
#line 739 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp2_ = gtk_combo_box_get_active_iter (_tmp0_, &_tmp1_);
#line 739 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	iter = _tmp1_;
#line 739 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	if (_tmp2_) {
#line 3614 "ui.c"
		GtkListStore* _tmp3_ = NULL;
		GtkTreeIter _tmp4_ = {0};
#line 740 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		_tmp3_ = self->priv->text_dpi_model;
#line 740 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		_tmp4_ = iter;
#line 740 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		gtk_tree_model_get ((GtkTreeModel*) _tmp3_, &_tmp4_, 0, &dpi, -1, -1);
#line 3623 "ui.c"
	}
#line 742 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	result = dpi;
#line 742 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	return result;
#line 3629 "ui.c"
}


static gint user_interface_get_photo_dpi (UserInterface* self) {
	gint result = 0;
	GtkTreeIter iter = {0};
	gint dpi = 0;
	GtkComboBox* _tmp0_ = NULL;
	GtkTreeIter _tmp1_ = {0};
	gboolean _tmp2_ = FALSE;
#line 745 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 748 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	dpi = USER_INTERFACE_DEFAULT_PHOTO_DPI;
#line 750 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp0_ = self->priv->photo_dpi_combo;
#line 750 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp2_ = gtk_combo_box_get_active_iter (_tmp0_, &_tmp1_);
#line 750 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	iter = _tmp1_;
#line 750 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	if (_tmp2_) {
#line 3652 "ui.c"
		GtkListStore* _tmp3_ = NULL;
		GtkTreeIter _tmp4_ = {0};
#line 751 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		_tmp3_ = self->priv->photo_dpi_model;
#line 751 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		_tmp4_ = iter;
#line 751 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		gtk_tree_model_get ((GtkTreeModel*) _tmp3_, &_tmp4_, 0, &dpi, -1, -1);
#line 3661 "ui.c"
	}
#line 753 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	result = dpi;
#line 753 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	return result;
#line 3667 "ui.c"
}


static ScanType user_interface_get_page_side (UserInterface* self) {
	ScanType result = 0;
	GtkTreeIter iter = {0};
	gint page_side = 0;
	GtkComboBox* _tmp0_ = NULL;
	GtkTreeIter _tmp1_ = {0};
	gboolean _tmp2_ = FALSE;
	gint _tmp5_ = 0;
#line 756 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 759 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	page_side = (gint) SCAN_TYPE_ADF_BOTH;
#line 761 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp0_ = self->priv->page_side_combo;
#line 761 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp2_ = gtk_combo_box_get_active_iter (_tmp0_, &_tmp1_);
#line 761 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	iter = _tmp1_;
#line 761 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	if (_tmp2_) {
#line 3691 "ui.c"
		GtkListStore* _tmp3_ = NULL;
		GtkTreeIter _tmp4_ = {0};
#line 762 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		_tmp3_ = self->priv->page_side_model;
#line 762 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		_tmp4_ = iter;
#line 762 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		gtk_tree_model_get ((GtkTreeModel*) _tmp3_, &_tmp4_, 0, &page_side, -1, -1);
#line 3700 "ui.c"
	}
#line 764 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp5_ = page_side;
#line 764 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	result = (ScanType) _tmp5_;
#line 764 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	return result;
#line 3708 "ui.c"
}


static gboolean user_interface_get_paper_size (UserInterface* self, gint* width, gint* height) {
	gint _vala_width = 0;
	gint _vala_height = 0;
	gboolean result = FALSE;
	GtkTreeIter iter = {0};
	gint _tmp0_ = 0;
	GtkComboBox* _tmp1_ = NULL;
	GtkTreeIter _tmp2_ = {0};
	gboolean _tmp3_ = FALSE;
#line 767 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 771 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_vala_height = 0;
#line 771 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp0_ = _vala_height;
#line 771 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_vala_width = _tmp0_;
#line 772 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp1_ = self->priv->paper_size_combo;
#line 772 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp3_ = gtk_combo_box_get_active_iter (_tmp1_, &_tmp2_);
#line 772 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	iter = _tmp2_;
#line 772 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	if (_tmp3_) {
#line 3737 "ui.c"
		GtkListStore* _tmp4_ = NULL;
		GtkTreeIter _tmp5_ = {0};
#line 774 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		_tmp4_ = self->priv->paper_size_model;
#line 774 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		_tmp5_ = iter;
#line 774 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		gtk_tree_model_get ((GtkTreeModel*) _tmp4_, &_tmp5_, 0, &_vala_width, 1, &_vala_height, -1, -1);
#line 775 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		result = TRUE;
#line 775 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		if (width) {
#line 775 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
			*width = _vala_width;
#line 3752 "ui.c"
		}
#line 775 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		if (height) {
#line 775 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
			*height = _vala_height;
#line 3758 "ui.c"
		}
#line 775 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		return result;
#line 3762 "ui.c"
	}
#line 778 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	result = FALSE;
#line 778 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	if (width) {
#line 778 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		*width = _vala_width;
#line 3770 "ui.c"
	}
#line 778 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	if (height) {
#line 778 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		*height = _vala_height;
#line 3776 "ui.c"
	}
#line 778 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	return result;
#line 3780 "ui.c"
}


static ScanOptions* user_interface_make_scan_options (UserInterface* self) {
	ScanOptions* result = NULL;
	ScanOptions* options = NULL;
	ScanOptions* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	ScanOptions* _tmp10_ = NULL;
	ScanOptions* _tmp11_ = NULL;
	gint _tmp12_ = 0;
	gint _tmp13_ = 0;
	ScanOptions* _tmp14_ = NULL;
	gint _tmp15_ = 0;
	gint _tmp16_ = 0;
	ScanOptions* _tmp17_ = NULL;
	gint _tmp18_ = 0;
	gint _tmp19_ = 0;
#line 781 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 783 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp0_ = scan_options_new ();
#line 783 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	options = _tmp0_;
#line 784 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp1_ = self->priv->document_hint;
#line 784 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	if (g_strcmp0 (_tmp1_, "text") == 0) {
#line 3809 "ui.c"
		ScanOptions* _tmp2_ = NULL;
		ScanOptions* _tmp3_ = NULL;
		gint _tmp4_ = 0;
		ScanOptions* _tmp5_ = NULL;
#line 786 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		_tmp2_ = options;
#line 786 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		_tmp2_->scan_mode = SCAN_MODE_GRAY;
#line 787 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		_tmp3_ = options;
#line 787 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		_tmp4_ = user_interface_get_text_dpi (self);
#line 787 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		_tmp3_->dpi = _tmp4_;
#line 788 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		_tmp5_ = options;
#line 788 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		_tmp5_->depth = 2;
#line 3828 "ui.c"
	} else {
		ScanOptions* _tmp6_ = NULL;
		ScanOptions* _tmp7_ = NULL;
		gint _tmp8_ = 0;
		ScanOptions* _tmp9_ = NULL;
#line 792 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		_tmp6_ = options;
#line 792 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		_tmp6_->scan_mode = SCAN_MODE_COLOR;
#line 793 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		_tmp7_ = options;
#line 793 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		_tmp8_ = user_interface_get_photo_dpi (self);
#line 793 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		_tmp7_->dpi = _tmp8_;
#line 794 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		_tmp9_ = options;
#line 794 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		_tmp9_->depth = 8;
#line 3848 "ui.c"
	}
#line 796 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp10_ = options;
#line 796 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp11_ = options;
#line 796 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	user_interface_get_paper_size (self, &_tmp12_, &_tmp13_);
#line 796 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp10_->paper_width = _tmp12_;
#line 796 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp11_->paper_height = _tmp13_;
#line 797 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp14_ = options;
#line 797 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp15_ = user_interface_get_brightness (self);
#line 797 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp16_ = _tmp15_;
#line 797 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp14_->brightness = _tmp16_;
#line 798 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp17_ = options;
#line 798 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp18_ = user_interface_get_contrast (self);
#line 798 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp19_ = _tmp18_;
#line 798 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp17_->contrast = _tmp19_;
#line 800 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	result = options;
#line 800 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	return result;
#line 3880 "ui.c"
}


void G_MODULE_EXPORT scan_button_clicked_cb (GtkWidget* widget, UserInterface* self) {
	ScanOptions* options = NULL;
	ScanOptions* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
#line 804 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	g_return_if_fail (self != NULL);
#line 804 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	g_return_if_fail (widget != NULL);
#line 806 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp0_ = user_interface_make_scan_options (self);
#line 806 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	options = _tmp0_;
#line 807 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	options->type = SCAN_TYPE_SINGLE;
#line 808 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp1_ = user_interface_get_selected_device (self);
#line 808 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp2_ = _tmp1_;
#line 808 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp3_ = _tmp2_;
#line 808 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	g_signal_emit_by_name (self, "start-scan", _tmp3_, options);
#line 808 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_g_free0 (_tmp3_);
#line 804 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_scan_options_unref0 (options);
#line 3912 "ui.c"
}


void G_MODULE_EXPORT stop_scan_button_clicked_cb (GtkWidget* widget, UserInterface* self) {
#line 812 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	g_return_if_fail (self != NULL);
#line 812 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	g_return_if_fail (widget != NULL);
#line 814 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	g_signal_emit_by_name (self, "stop-scan");
#line 3923 "ui.c"
}


void G_MODULE_EXPORT continuous_scan_button_clicked_cb (GtkWidget* widget, UserInterface* self) {
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
#line 818 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	g_return_if_fail (self != NULL);
#line 818 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	g_return_if_fail (widget != NULL);
#line 820 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp0_ = user_interface_get_scanning (self);
#line 820 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp1_ = _tmp0_;
#line 820 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	if (_tmp1_) {
#line 821 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		g_signal_emit_by_name (self, "stop-scan");
#line 3942 "ui.c"
	} else {
		ScanOptions* options = NULL;
		ScanOptions* _tmp2_ = NULL;
		ScanOptions* _tmp3_ = NULL;
		ScanType _tmp4_ = 0;
		gchar* _tmp5_ = NULL;
		gchar* _tmp6_ = NULL;
		gchar* _tmp7_ = NULL;
		ScanOptions* _tmp8_ = NULL;
#line 824 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		_tmp2_ = user_interface_make_scan_options (self);
#line 824 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		options = _tmp2_;
#line 825 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		_tmp3_ = options;
#line 825 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		_tmp4_ = user_interface_get_page_side (self);
#line 825 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		_tmp3_->type = _tmp4_;
#line 826 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		_tmp5_ = user_interface_get_selected_device (self);
#line 826 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		_tmp6_ = _tmp5_;
#line 826 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		_tmp7_ = _tmp6_;
#line 826 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		_tmp8_ = options;
#line 826 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		g_signal_emit_by_name (self, "start-scan", _tmp7_, _tmp8_);
#line 826 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		_g_free0 (_tmp7_);
#line 820 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		_scan_options_unref0 (options);
#line 3976 "ui.c"
	}
}


void G_MODULE_EXPORT preferences_button_clicked_cb (GtkWidget* widget, UserInterface* self) {
	GtkDialog* _tmp0_ = NULL;
#line 831 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	g_return_if_fail (self != NULL);
#line 831 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	g_return_if_fail (widget != NULL);
#line 833 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp0_ = self->priv->preferences_dialog;
#line 833 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	gtk_window_present ((GtkWindow*) _tmp0_);
#line 3991 "ui.c"
}


void user_interface_preferences_activate_cb (UserInterface* self) {
	GtkDialog* _tmp0_ = NULL;
#line 836 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	g_return_if_fail (self != NULL);
#line 838 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp0_ = self->priv->preferences_dialog;
#line 838 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	gtk_window_present ((GtkWindow*) _tmp0_);
#line 4003 "ui.c"
}


gboolean G_MODULE_EXPORT preferences_dialog_delete_event_cb (GtkWidget* widget, UserInterface* self) {
	gboolean result = FALSE;
#line 842 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 842 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	g_return_val_if_fail (widget != NULL, FALSE);
#line 844 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	result = TRUE;
#line 844 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	return result;
#line 4017 "ui.c"
}


void G_MODULE_EXPORT preferences_dialog_response_cb (GtkWidget* widget, gint response_id, UserInterface* self) {
	GtkDialog* _tmp0_ = NULL;
#line 848 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	g_return_if_fail (self != NULL);
#line 848 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	g_return_if_fail (widget != NULL);
#line 850 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp0_ = self->priv->preferences_dialog;
#line 850 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	gtk_widget_hide ((GtkWidget*) _tmp0_);
#line 4031 "ui.c"
}


static gpointer _page_ref0 (gpointer self) {
#line 855 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	return self ? page_ref (self) : NULL;
#line 4038 "ui.c"
}


static void user_interface_update_page_menu (UserInterface* self) {
	Page* page = NULL;
	BookView* _tmp0_ = NULL;
	Page* _tmp1_ = NULL;
	Page* _tmp2_ = NULL;
	Page* _tmp3_ = NULL;
	Page* _tmp4_ = NULL;
#line 853 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	g_return_if_fail (self != NULL);
#line 855 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp0_ = self->priv->book_view;
#line 855 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp1_ = book_view_get_selected_page (_tmp0_);
#line 855 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp2_ = _tmp1_;
#line 855 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp3_ = _page_ref0 (_tmp2_);
#line 855 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	page = _tmp3_;
#line 856 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp4_ = page;
#line 856 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	if (_tmp4_ == NULL) {
#line 4065 "ui.c"
		GtkMenuItem* _tmp5_ = NULL;
		GtkMenuItem* _tmp6_ = NULL;
#line 858 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		_tmp5_ = self->priv->page_move_left_menuitem;
#line 858 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		gtk_widget_set_sensitive ((GtkWidget*) _tmp5_, FALSE);
#line 859 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		_tmp6_ = self->priv->page_move_right_menuitem;
#line 859 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		gtk_widget_set_sensitive ((GtkWidget*) _tmp6_, FALSE);
#line 4076 "ui.c"
	} else {
		guint index = 0U;
		Book* _tmp7_ = NULL;
		Page* _tmp8_ = NULL;
		guint _tmp9_ = 0U;
		GtkMenuItem* _tmp10_ = NULL;
		guint _tmp11_ = 0U;
		GtkMenuItem* _tmp12_ = NULL;
		guint _tmp13_ = 0U;
		Book* _tmp14_ = NULL;
		guint _tmp15_ = 0U;
		guint _tmp16_ = 0U;
#line 863 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		_tmp7_ = self->priv->_book;
#line 863 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		_tmp8_ = page;
#line 863 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		_tmp9_ = book_get_page_index (_tmp7_, _tmp8_);
#line 863 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		index = _tmp9_;
#line 864 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		_tmp10_ = self->priv->page_move_left_menuitem;
#line 864 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		_tmp11_ = index;
#line 864 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		gtk_widget_set_sensitive ((GtkWidget*) _tmp10_, _tmp11_ > ((guint) 0));
#line 865 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		_tmp12_ = self->priv->page_move_right_menuitem;
#line 865 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		_tmp13_ = index;
#line 865 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		_tmp14_ = self->priv->_book;
#line 865 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		_tmp15_ = book_get_n_pages (_tmp14_);
#line 865 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		_tmp16_ = _tmp15_;
#line 865 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		gtk_widget_set_sensitive ((GtkWidget*) _tmp12_, _tmp13_ < (_tmp16_ - 1));
#line 4115 "ui.c"
	}
#line 853 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_page_unref0 (page);
#line 4119 "ui.c"
}


static void user_interface_page_selected_cb (UserInterface* self, BookView* view, Page* page) {
	Page* _tmp0_ = NULL;
	gchar* name = NULL;
	gchar* _tmp1_ = NULL;
	Page* _tmp2_ = NULL;
	gboolean _tmp3_ = FALSE;
	gboolean _tmp4_ = FALSE;
	GtkRadioMenuItem* menuitem = NULL;
	GtkBuilder* _tmp23_ = NULL;
	const gchar* _tmp24_ = NULL;
	GObject* _tmp25_ = NULL;
	GtkRadioMenuItem* _tmp26_ = NULL;
	GtkRadioMenuItem* _tmp27_ = NULL;
	GtkToggleToolButton* toolbutton = NULL;
	GtkBuilder* _tmp28_ = NULL;
	GObject* _tmp29_ = NULL;
	GtkToggleToolButton* _tmp30_ = NULL;
	GtkToggleToolButton* _tmp31_ = NULL;
	Page* _tmp32_ = NULL;
	gboolean _tmp33_ = FALSE;
	gboolean _tmp34_ = FALSE;
#line 869 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	g_return_if_fail (self != NULL);
#line 869 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	g_return_if_fail (view != NULL);
#line 871 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp0_ = page;
#line 871 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	if (_tmp0_ == NULL) {
#line 872 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		return;
#line 4154 "ui.c"
	}
#line 874 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	self->priv->updating_page_menu = TRUE;
#line 876 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	user_interface_update_page_menu (self);
#line 878 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp1_ = g_strdup ("no_crop_menuitem");
#line 878 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	name = _tmp1_;
#line 879 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp2_ = page;
#line 879 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp3_ = page_get_has_crop (_tmp2_);
#line 879 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp4_ = _tmp3_;
#line 879 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	if (_tmp4_) {
#line 4172 "ui.c"
		gchar* crop_name = NULL;
		Page* _tmp5_ = NULL;
		const gchar* _tmp6_ = NULL;
		const gchar* _tmp7_ = NULL;
		gchar* _tmp8_ = NULL;
		const gchar* _tmp9_ = NULL;
#line 882 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		_tmp5_ = page;
#line 882 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		_tmp6_ = page_get_crop_name (_tmp5_);
#line 882 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		_tmp7_ = _tmp6_;
#line 882 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		_tmp8_ = g_strdup (_tmp7_);
#line 882 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		crop_name = _tmp8_;
#line 883 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		_tmp9_ = crop_name;
#line 883 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		if (_tmp9_ != NULL) {
#line 4193 "ui.c"
			const gchar* _tmp10_ = NULL;
#line 885 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
			_tmp10_ = crop_name;
#line 885 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
			if (g_strcmp0 (_tmp10_, "A4") == 0) {
#line 4199 "ui.c"
				gchar* _tmp11_ = NULL;
#line 886 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
				_tmp11_ = g_strdup ("a4_menuitem");
#line 886 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
				_g_free0 (name);
#line 886 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
				name = _tmp11_;
#line 4207 "ui.c"
			} else {
				const gchar* _tmp12_ = NULL;
#line 887 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
				_tmp12_ = crop_name;
#line 887 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
				if (g_strcmp0 (_tmp12_, "A5") == 0) {
#line 4214 "ui.c"
					gchar* _tmp13_ = NULL;
#line 888 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
					_tmp13_ = g_strdup ("a5_menuitem");
#line 888 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
					_g_free0 (name);
#line 888 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
					name = _tmp13_;
#line 4222 "ui.c"
				} else {
					const gchar* _tmp14_ = NULL;
#line 889 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
					_tmp14_ = crop_name;
#line 889 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
					if (g_strcmp0 (_tmp14_, "A6") == 0) {
#line 4229 "ui.c"
						gchar* _tmp15_ = NULL;
#line 890 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
						_tmp15_ = g_strdup ("a6_menuitem");
#line 890 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
						_g_free0 (name);
#line 890 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
						name = _tmp15_;
#line 4237 "ui.c"
					} else {
						const gchar* _tmp16_ = NULL;
#line 891 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
						_tmp16_ = crop_name;
#line 891 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
						if (g_strcmp0 (_tmp16_, "letter") == 0) {
#line 4244 "ui.c"
							gchar* _tmp17_ = NULL;
#line 892 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
							_tmp17_ = g_strdup ("letter_menuitem");
#line 892 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
							_g_free0 (name);
#line 892 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
							name = _tmp17_;
#line 4252 "ui.c"
						} else {
							const gchar* _tmp18_ = NULL;
#line 893 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
							_tmp18_ = crop_name;
#line 893 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
							if (g_strcmp0 (_tmp18_, "legal") == 0) {
#line 4259 "ui.c"
								gchar* _tmp19_ = NULL;
#line 894 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
								_tmp19_ = g_strdup ("legal_menuitem");
#line 894 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
								_g_free0 (name);
#line 894 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
								name = _tmp19_;
#line 4267 "ui.c"
							} else {
								const gchar* _tmp20_ = NULL;
#line 895 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
								_tmp20_ = crop_name;
#line 895 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
								if (g_strcmp0 (_tmp20_, "4x6") == 0) {
#line 4274 "ui.c"
									gchar* _tmp21_ = NULL;
#line 896 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
									_tmp21_ = g_strdup ("4x6_menuitem");
#line 896 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
									_g_free0 (name);
#line 896 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
									name = _tmp21_;
#line 4282 "ui.c"
								}
							}
						}
					}
				}
			}
		} else {
			gchar* _tmp22_ = NULL;
#line 899 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
			_tmp22_ = g_strdup ("custom_crop_menuitem");
#line 899 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
			_g_free0 (name);
#line 899 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
			name = _tmp22_;
#line 4297 "ui.c"
		}
#line 879 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		_g_free0 (crop_name);
#line 4301 "ui.c"
	}
#line 902 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp23_ = self->priv->builder;
#line 902 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp24_ = name;
#line 902 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp25_ = gtk_builder_get_object (_tmp23_, _tmp24_);
#line 902 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp26_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp25_, gtk_radio_menu_item_get_type (), GtkRadioMenuItem));
#line 902 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	menuitem = _tmp26_;
#line 903 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp27_ = menuitem;
#line 903 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	gtk_check_menu_item_set_active ((GtkCheckMenuItem*) _tmp27_, TRUE);
#line 904 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp28_ = self->priv->builder;
#line 904 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp29_ = gtk_builder_get_object (_tmp28_, "crop_toolbutton");
#line 904 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp30_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp29_, gtk_toggle_tool_button_get_type (), GtkToggleToolButton));
#line 904 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	toolbutton = _tmp30_;
#line 905 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp31_ = toolbutton;
#line 905 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp32_ = page;
#line 905 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp33_ = page_get_has_crop (_tmp32_);
#line 905 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp34_ = _tmp33_;
#line 905 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	gtk_toggle_tool_button_set_active (_tmp31_, _tmp34_);
#line 907 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	self->priv->updating_page_menu = FALSE;
#line 869 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_g_object_unref0 (toolbutton);
#line 869 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_g_object_unref0 (menuitem);
#line 869 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_g_free0 (name);
#line 4343 "ui.c"
}


static void user_interface_show_page_cb (UserInterface* self, BookView* view, Page* page) {
	gchar* path = NULL;
	gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	GFile* file = NULL;
	const gchar* _tmp2_ = NULL;
	GFile* _tmp3_ = NULL;
	GError * _inner_error_ = NULL;
#line 910 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	g_return_if_fail (self != NULL);
#line 910 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	g_return_if_fail (view != NULL);
#line 910 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	g_return_if_fail (page != NULL);
#line 912 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp0_ = get_temporary_filename ("scanned-page", "tiff");
#line 912 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	path = _tmp0_;
#line 913 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp1_ = path;
#line 913 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	if (_tmp1_ == NULL) {
#line 914 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		_g_free0 (path);
#line 914 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		return;
#line 4373 "ui.c"
	}
#line 915 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp2_ = path;
#line 915 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp3_ = g_file_new_for_path (_tmp2_);
#line 915 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	file = _tmp3_;
#line 4381 "ui.c"
	{
		Page* _tmp4_ = NULL;
		gint _tmp5_ = 0;
		gint _tmp6_ = 0;
		GFile* _tmp7_ = NULL;
#line 919 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		_tmp4_ = page;
#line 919 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		_tmp5_ = user_interface_get_quality (self);
#line 919 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		_tmp6_ = _tmp5_;
#line 919 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		_tmp7_ = file;
#line 919 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		page_save (_tmp4_, "tiff", _tmp6_, _tmp7_, &_inner_error_);
#line 919 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 4399 "ui.c"
			goto __catch17_g_error;
		}
	}
	goto __finally17;
	__catch17_g_error:
	{
		GError* e = NULL;
		const gchar* _tmp8_ = NULL;
		GError* _tmp9_ = NULL;
		const gchar* _tmp10_ = NULL;
#line 917 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		e = _inner_error_;
#line 917 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		_inner_error_ = NULL;
#line 923 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		_tmp8_ = _ ("Unable to save image for preview");
#line 923 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		_tmp9_ = e;
#line 923 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		_tmp10_ = _tmp9_->message;
#line 923 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		user_interface_show_error_dialog (self, _tmp8_, _tmp10_);
#line 926 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		_g_error_free0 (e);
#line 926 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		_g_object_unref0 (file);
#line 926 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		_g_free0 (path);
#line 926 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		return;
#line 4430 "ui.c"
	}
	__finally17:
#line 917 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 917 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		_g_object_unref0 (file);
#line 917 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		_g_free0 (path);
#line 917 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 917 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		g_clear_error (&_inner_error_);
#line 917 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		return;
#line 4445 "ui.c"
	}
	{
		GtkApplicationWindow* _tmp11_ = NULL;
		GdkScreen* _tmp12_ = NULL;
		GFile* _tmp13_ = NULL;
		gchar* _tmp14_ = NULL;
		gchar* _tmp15_ = NULL;
		guint32 _tmp16_ = 0U;
#line 931 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		_tmp11_ = self->priv->window;
#line 931 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		_tmp12_ = gtk_window_get_screen ((GtkWindow*) _tmp11_);
#line 931 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		_tmp13_ = file;
#line 931 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		_tmp14_ = g_file_get_uri (_tmp13_);
#line 931 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		_tmp15_ = _tmp14_;
#line 931 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		_tmp16_ = gtk_get_current_event_time ();
#line 931 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		gtk_show_uri (_tmp12_, _tmp15_, _tmp16_, &_inner_error_);
#line 931 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		_g_free0 (_tmp15_);
#line 931 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 4472 "ui.c"
			goto __catch18_g_error;
		}
	}
	goto __finally18;
	__catch18_g_error:
	{
		GError* e = NULL;
		const gchar* _tmp17_ = NULL;
		GError* _tmp18_ = NULL;
		const gchar* _tmp19_ = NULL;
#line 929 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		e = _inner_error_;
#line 929 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		_inner_error_ = NULL;
#line 935 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		_tmp17_ = _ ("Unable to open image preview application");
#line 935 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		_tmp18_ = e;
#line 935 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		_tmp19_ = _tmp18_->message;
#line 935 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		user_interface_show_error_dialog (self, _tmp17_, _tmp19_);
#line 929 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		_g_error_free0 (e);
#line 4497 "ui.c"
	}
	__finally18:
#line 929 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 929 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		_g_object_unref0 (file);
#line 929 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		_g_free0 (path);
#line 929 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 929 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		g_clear_error (&_inner_error_);
#line 929 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		return;
#line 4512 "ui.c"
	}
#line 910 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_g_object_unref0 (file);
#line 910 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_g_free0 (path);
#line 4518 "ui.c"
}


static void user_interface_show_page_menu_cb (UserInterface* self, BookView* view) {
	GtkMenu* menu = NULL;
	GtkBuilder* _tmp0_ = NULL;
	GObject* _tmp1_ = NULL;
	GtkMenu* _tmp2_ = NULL;
	guint32 _tmp3_ = 0U;
#line 941 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	g_return_if_fail (self != NULL);
#line 941 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	g_return_if_fail (view != NULL);
#line 943 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp0_ = self->priv->builder;
#line 943 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp1_ = gtk_builder_get_object (_tmp0_, "page_menu");
#line 943 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp2_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, gtk_menu_get_type (), GtkMenu));
#line 943 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	menu = _tmp2_;
#line 944 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp3_ = gtk_get_current_event_time ();
#line 944 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	gtk_menu_popup (menu, NULL, NULL, NULL, NULL, (guint) 3, _tmp3_);
#line 941 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_g_object_unref0 (menu);
#line 4546 "ui.c"
}


void G_MODULE_EXPORT rotate_left_button_clicked_cb (GtkWidget* widget, UserInterface* self) {
	gboolean _tmp0_ = FALSE;
	Page* page = NULL;
	BookView* _tmp1_ = NULL;
	Page* _tmp2_ = NULL;
	Page* _tmp3_ = NULL;
	Page* _tmp4_ = NULL;
	Page* _tmp5_ = NULL;
#line 948 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	g_return_if_fail (self != NULL);
#line 948 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	g_return_if_fail (widget != NULL);
#line 950 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp0_ = self->priv->updating_page_menu;
#line 950 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	if (_tmp0_) {
#line 951 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		return;
#line 4568 "ui.c"
	}
#line 952 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp1_ = self->priv->book_view;
#line 952 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp2_ = book_view_get_selected_page (_tmp1_);
#line 952 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp3_ = _tmp2_;
#line 952 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp4_ = _page_ref0 (_tmp3_);
#line 952 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	page = _tmp4_;
#line 953 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp5_ = page;
#line 953 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	if (_tmp5_ != NULL) {
#line 4584 "ui.c"
		Page* _tmp6_ = NULL;
#line 954 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		_tmp6_ = page;
#line 954 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		page_rotate_left (_tmp6_);
#line 4590 "ui.c"
	}
#line 948 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_page_unref0 (page);
#line 4594 "ui.c"
}


void G_MODULE_EXPORT rotate_right_button_clicked_cb (GtkWidget* widget, UserInterface* self) {
	gboolean _tmp0_ = FALSE;
	Page* page = NULL;
	BookView* _tmp1_ = NULL;
	Page* _tmp2_ = NULL;
	Page* _tmp3_ = NULL;
	Page* _tmp4_ = NULL;
	Page* _tmp5_ = NULL;
#line 958 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	g_return_if_fail (self != NULL);
#line 958 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	g_return_if_fail (widget != NULL);
#line 960 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp0_ = self->priv->updating_page_menu;
#line 960 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	if (_tmp0_) {
#line 961 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		return;
#line 4616 "ui.c"
	}
#line 962 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp1_ = self->priv->book_view;
#line 962 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp2_ = book_view_get_selected_page (_tmp1_);
#line 962 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp3_ = _tmp2_;
#line 962 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp4_ = _page_ref0 (_tmp3_);
#line 962 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	page = _tmp4_;
#line 963 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp5_ = page;
#line 963 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	if (_tmp5_ != NULL) {
#line 4632 "ui.c"
		Page* _tmp6_ = NULL;
#line 964 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		_tmp6_ = page;
#line 964 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		page_rotate_right (_tmp6_);
#line 4638 "ui.c"
	}
#line 958 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_page_unref0 (page);
#line 4642 "ui.c"
}


static void user_interface_set_crop (UserInterface* self, const gchar* crop_name) {
	GtkMenuItem* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gboolean _tmp2_ = FALSE;
	Page* page = NULL;
	BookView* _tmp3_ = NULL;
	Page* _tmp4_ = NULL;
	Page* _tmp5_ = NULL;
	Page* _tmp6_ = NULL;
	Page* _tmp7_ = NULL;
	const gchar* _tmp8_ = NULL;
#line 967 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	g_return_if_fail (self != NULL);
#line 969 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp0_ = self->priv->crop_rotate_menuitem;
#line 969 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp1_ = crop_name;
#line 969 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	gtk_widget_set_sensitive ((GtkWidget*) _tmp0_, _tmp1_ != NULL);
#line 971 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp2_ = self->priv->updating_page_menu;
#line 971 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	if (_tmp2_) {
#line 972 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		return;
#line 4671 "ui.c"
	}
#line 974 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp3_ = self->priv->book_view;
#line 974 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp4_ = book_view_get_selected_page (_tmp3_);
#line 974 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp5_ = _tmp4_;
#line 974 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp6_ = _page_ref0 (_tmp5_);
#line 974 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	page = _tmp6_;
#line 975 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp7_ = page;
#line 975 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	if (_tmp7_ == NULL) {
#line 977 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		g_warning ("ui.vala:977: Trying to set crop but no selected page");
#line 978 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		_page_unref0 (page);
#line 978 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		return;
#line 4693 "ui.c"
	}
#line 981 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp8_ = crop_name;
#line 981 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	if (_tmp8_ == NULL) {
#line 4699 "ui.c"
		Page* _tmp9_ = NULL;
#line 982 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		_tmp9_ = page;
#line 982 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		page_set_no_crop (_tmp9_);
#line 4705 "ui.c"
	} else {
		const gchar* _tmp10_ = NULL;
#line 983 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		_tmp10_ = crop_name;
#line 983 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		if (g_strcmp0 (_tmp10_, "custom") == 0) {
#line 4712 "ui.c"
			gint width = 0;
			Page* _tmp11_ = NULL;
			gint _tmp12_ = 0;
			gint _tmp13_ = 0;
			gint height = 0;
			Page* _tmp14_ = NULL;
			gint _tmp15_ = 0;
			gint _tmp16_ = 0;
			gint crop_width = 0;
			gint _tmp17_ = 0;
			gint crop_height = 0;
			gint _tmp18_ = 0;
			Page* _tmp19_ = NULL;
			gint _tmp20_ = 0;
			gint _tmp21_ = 0;
			Page* _tmp22_ = NULL;
			gint _tmp23_ = 0;
			gint _tmp24_ = 0;
			gint _tmp25_ = 0;
			gint _tmp26_ = 0;
#line 985 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
			_tmp11_ = page;
#line 985 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
			_tmp12_ = page_get_width (_tmp11_);
#line 985 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
			_tmp13_ = _tmp12_;
#line 985 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
			width = _tmp13_;
#line 986 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
			_tmp14_ = page;
#line 986 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
			_tmp15_ = page_get_height (_tmp14_);
#line 986 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
			_tmp16_ = _tmp15_;
#line 986 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
			height = _tmp16_;
#line 987 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
			_tmp17_ = width;
#line 987 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
			crop_width = (gint) ((_tmp17_ * 0.8) + 0.5);
#line 988 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
			_tmp18_ = height;
#line 988 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
			crop_height = (gint) ((_tmp18_ * 0.8) + 0.5);
#line 989 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
			_tmp19_ = page;
#line 989 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
			_tmp20_ = crop_width;
#line 989 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
			_tmp21_ = crop_height;
#line 989 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
			page_set_custom_crop (_tmp19_, _tmp20_, _tmp21_);
#line 990 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
			_tmp22_ = page;
#line 990 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
			_tmp23_ = width;
#line 990 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
			_tmp24_ = crop_width;
#line 990 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
			_tmp25_ = height;
#line 990 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
			_tmp26_ = crop_height;
#line 990 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
			page_move_crop (_tmp22_, (_tmp23_ - _tmp24_) / 2, (_tmp25_ - _tmp26_) / 2);
#line 4777 "ui.c"
		} else {
			Page* _tmp27_ = NULL;
			const gchar* _tmp28_ = NULL;
#line 993 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
			_tmp27_ = page;
#line 993 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
			_tmp28_ = crop_name;
#line 993 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
			page_set_named_crop (_tmp27_, _tmp28_);
#line 4787 "ui.c"
		}
	}
#line 967 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_page_unref0 (page);
#line 4792 "ui.c"
}


void G_MODULE_EXPORT no_crop_menuitem_toggled_cb (GtkCheckMenuItem* widget, UserInterface* self) {
	GtkCheckMenuItem* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
#line 997 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	g_return_if_fail (self != NULL);
#line 997 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	g_return_if_fail (widget != NULL);
#line 999 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp0_ = widget;
#line 999 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp1_ = gtk_check_menu_item_get_active (_tmp0_);
#line 999 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	if (_tmp1_) {
#line 1000 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		user_interface_set_crop (self, NULL);
#line 4811 "ui.c"
	}
}


void G_MODULE_EXPORT custom_crop_menuitem_toggled_cb (GtkCheckMenuItem* widget, UserInterface* self) {
	GtkCheckMenuItem* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
#line 1004 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	g_return_if_fail (self != NULL);
#line 1004 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	g_return_if_fail (widget != NULL);
#line 1006 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp0_ = widget;
#line 1006 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp1_ = gtk_check_menu_item_get_active (_tmp0_);
#line 1006 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	if (_tmp1_) {
#line 1007 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		user_interface_set_crop (self, "custom");
#line 4831 "ui.c"
	}
}


void G_MODULE_EXPORT crop_toolbutton_toggled_cb (GtkToggleToolButton* widget, UserInterface* self) {
	gboolean _tmp0_ = FALSE;
	GtkRadioMenuItem* menuitem = NULL;
	GtkToggleToolButton* _tmp1_ = NULL;
	gboolean _tmp2_ = FALSE;
	GtkRadioMenuItem* _tmp9_ = NULL;
#line 1011 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	g_return_if_fail (self != NULL);
#line 1011 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	g_return_if_fail (widget != NULL);
#line 1013 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp0_ = self->priv->updating_page_menu;
#line 1013 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	if (_tmp0_) {
#line 1014 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		return;
#line 4852 "ui.c"
	}
#line 1017 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp1_ = widget;
#line 1017 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp2_ = gtk_toggle_tool_button_get_active (_tmp1_);
#line 1017 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	if (_tmp2_) {
#line 4860 "ui.c"
		GtkBuilder* _tmp3_ = NULL;
		GObject* _tmp4_ = NULL;
		GtkRadioMenuItem* _tmp5_ = NULL;
#line 1018 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		_tmp3_ = self->priv->builder;
#line 1018 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		_tmp4_ = gtk_builder_get_object (_tmp3_, "custom_crop_menuitem");
#line 1018 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		_tmp5_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, gtk_radio_menu_item_get_type (), GtkRadioMenuItem));
#line 1018 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		_g_object_unref0 (menuitem);
#line 1018 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		menuitem = _tmp5_;
#line 4874 "ui.c"
	} else {
		GtkBuilder* _tmp6_ = NULL;
		GObject* _tmp7_ = NULL;
		GtkRadioMenuItem* _tmp8_ = NULL;
#line 1020 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		_tmp6_ = self->priv->builder;
#line 1020 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		_tmp7_ = gtk_builder_get_object (_tmp6_, "no_crop_menuitem");
#line 1020 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		_tmp8_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, gtk_radio_menu_item_get_type (), GtkRadioMenuItem));
#line 1020 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		_g_object_unref0 (menuitem);
#line 1020 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		menuitem = _tmp8_;
#line 4889 "ui.c"
	}
#line 1021 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp9_ = menuitem;
#line 1021 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	gtk_check_menu_item_set_active ((GtkCheckMenuItem*) _tmp9_, TRUE);
#line 1011 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_g_object_unref0 (menuitem);
#line 4897 "ui.c"
}


void G_MODULE_EXPORT four_by_six_menuitem_toggled_cb (GtkCheckMenuItem* widget, UserInterface* self) {
	GtkCheckMenuItem* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
#line 1025 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	g_return_if_fail (self != NULL);
#line 1025 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	g_return_if_fail (widget != NULL);
#line 1027 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp0_ = widget;
#line 1027 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp1_ = gtk_check_menu_item_get_active (_tmp0_);
#line 1027 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	if (_tmp1_) {
#line 1028 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		user_interface_set_crop (self, "4x6");
#line 4916 "ui.c"
	}
}


void G_MODULE_EXPORT legal_menuitem_toggled_cb (GtkCheckMenuItem* widget, UserInterface* self) {
	GtkCheckMenuItem* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
#line 1032 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	g_return_if_fail (self != NULL);
#line 1032 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	g_return_if_fail (widget != NULL);
#line 1034 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp0_ = widget;
#line 1034 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp1_ = gtk_check_menu_item_get_active (_tmp0_);
#line 1034 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	if (_tmp1_) {
#line 1035 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		user_interface_set_crop (self, "legal");
#line 4936 "ui.c"
	}
}


void G_MODULE_EXPORT letter_menuitem_toggled_cb (GtkCheckMenuItem* widget, UserInterface* self) {
	GtkCheckMenuItem* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
#line 1039 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	g_return_if_fail (self != NULL);
#line 1039 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	g_return_if_fail (widget != NULL);
#line 1041 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp0_ = widget;
#line 1041 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp1_ = gtk_check_menu_item_get_active (_tmp0_);
#line 1041 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	if (_tmp1_) {
#line 1042 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		user_interface_set_crop (self, "letter");
#line 4956 "ui.c"
	}
}


void G_MODULE_EXPORT a6_menuitem_toggled_cb (GtkCheckMenuItem* widget, UserInterface* self) {
	GtkCheckMenuItem* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
#line 1046 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	g_return_if_fail (self != NULL);
#line 1046 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	g_return_if_fail (widget != NULL);
#line 1048 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp0_ = widget;
#line 1048 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp1_ = gtk_check_menu_item_get_active (_tmp0_);
#line 1048 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	if (_tmp1_) {
#line 1049 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		user_interface_set_crop (self, "A6");
#line 4976 "ui.c"
	}
}


void G_MODULE_EXPORT a5_menuitem_toggled_cb (GtkCheckMenuItem* widget, UserInterface* self) {
	GtkCheckMenuItem* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
#line 1053 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	g_return_if_fail (self != NULL);
#line 1053 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	g_return_if_fail (widget != NULL);
#line 1055 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp0_ = widget;
#line 1055 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp1_ = gtk_check_menu_item_get_active (_tmp0_);
#line 1055 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	if (_tmp1_) {
#line 1056 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		user_interface_set_crop (self, "A5");
#line 4996 "ui.c"
	}
}


void G_MODULE_EXPORT a4_menuitem_toggled_cb (GtkCheckMenuItem* widget, UserInterface* self) {
	GtkCheckMenuItem* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
#line 1060 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	g_return_if_fail (self != NULL);
#line 1060 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	g_return_if_fail (widget != NULL);
#line 1062 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp0_ = widget;
#line 1062 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp1_ = gtk_check_menu_item_get_active (_tmp0_);
#line 1062 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	if (_tmp1_) {
#line 1063 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		user_interface_set_crop (self, "A4");
#line 5016 "ui.c"
	}
}


void G_MODULE_EXPORT crop_rotate_menuitem_activate_cb (GtkWidget* widget, UserInterface* self) {
	Page* page = NULL;
	BookView* _tmp0_ = NULL;
	Page* _tmp1_ = NULL;
	Page* _tmp2_ = NULL;
	Page* _tmp3_ = NULL;
	Page* _tmp4_ = NULL;
	Page* _tmp5_ = NULL;
#line 1067 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	g_return_if_fail (self != NULL);
#line 1067 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	g_return_if_fail (widget != NULL);
#line 1069 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp0_ = self->priv->book_view;
#line 1069 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp1_ = book_view_get_selected_page (_tmp0_);
#line 1069 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp2_ = _tmp1_;
#line 1069 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp3_ = _page_ref0 (_tmp2_);
#line 1069 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	page = _tmp3_;
#line 1070 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp4_ = page;
#line 1070 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	if (_tmp4_ == NULL) {
#line 1071 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		_page_unref0 (page);
#line 1071 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		return;
#line 5051 "ui.c"
	}
#line 1072 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp5_ = page;
#line 1072 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	page_rotate_crop (_tmp5_);
#line 1067 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_page_unref0 (page);
#line 5059 "ui.c"
}


void G_MODULE_EXPORT page_move_left_menuitem_activate_cb (GtkWidget* widget, UserInterface* self) {
	Page* page = NULL;
	BookView* _tmp0_ = NULL;
	Page* _tmp1_ = NULL;
	Page* _tmp2_ = NULL;
	Page* _tmp3_ = NULL;
	guint index = 0U;
	Book* _tmp4_ = NULL;
	Page* _tmp5_ = NULL;
	guint _tmp6_ = 0U;
	guint _tmp7_ = 0U;
#line 1076 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	g_return_if_fail (self != NULL);
#line 1076 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	g_return_if_fail (widget != NULL);
#line 1078 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp0_ = self->priv->book_view;
#line 1078 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp1_ = book_view_get_selected_page (_tmp0_);
#line 1078 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp2_ = _tmp1_;
#line 1078 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp3_ = _page_ref0 (_tmp2_);
#line 1078 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	page = _tmp3_;
#line 1079 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp4_ = self->priv->_book;
#line 1079 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp5_ = page;
#line 1079 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp6_ = book_get_page_index (_tmp4_, _tmp5_);
#line 1079 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	index = _tmp6_;
#line 1080 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp7_ = index;
#line 1080 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	if (_tmp7_ > ((guint) 0)) {
#line 5100 "ui.c"
		Book* _tmp8_ = NULL;
		Page* _tmp9_ = NULL;
		guint _tmp10_ = 0U;
#line 1081 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		_tmp8_ = self->priv->_book;
#line 1081 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		_tmp9_ = page;
#line 1081 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		_tmp10_ = index;
#line 1081 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		book_move_page (_tmp8_, _tmp9_, _tmp10_ - 1);
#line 5112 "ui.c"
	}
#line 1083 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	user_interface_update_page_menu (self);
#line 1076 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_page_unref0 (page);
#line 5118 "ui.c"
}


void G_MODULE_EXPORT page_move_right_menuitem_activate_cb (GtkWidget* widget, UserInterface* self) {
	Page* page = NULL;
	BookView* _tmp0_ = NULL;
	Page* _tmp1_ = NULL;
	Page* _tmp2_ = NULL;
	Page* _tmp3_ = NULL;
	guint index = 0U;
	Book* _tmp4_ = NULL;
	Page* _tmp5_ = NULL;
	guint _tmp6_ = 0U;
	guint _tmp7_ = 0U;
	Book* _tmp8_ = NULL;
	guint _tmp9_ = 0U;
	guint _tmp10_ = 0U;
#line 1087 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	g_return_if_fail (self != NULL);
#line 1087 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	g_return_if_fail (widget != NULL);
#line 1089 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp0_ = self->priv->book_view;
#line 1089 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp1_ = book_view_get_selected_page (_tmp0_);
#line 1089 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp2_ = _tmp1_;
#line 1089 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp3_ = _page_ref0 (_tmp2_);
#line 1089 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	page = _tmp3_;
#line 1090 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp4_ = self->priv->_book;
#line 1090 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp5_ = page;
#line 1090 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp6_ = book_get_page_index (_tmp4_, _tmp5_);
#line 1090 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	index = _tmp6_;
#line 1091 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp7_ = index;
#line 1091 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp8_ = self->priv->_book;
#line 1091 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp9_ = book_get_n_pages (_tmp8_);
#line 1091 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp10_ = _tmp9_;
#line 1091 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	if (_tmp7_ < (_tmp10_ - 1)) {
#line 5168 "ui.c"
		Book* _tmp11_ = NULL;
		Page* _tmp12_ = NULL;
		Book* _tmp13_ = NULL;
		Page* _tmp14_ = NULL;
		guint _tmp15_ = 0U;
#line 1092 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		_tmp11_ = self->priv->_book;
#line 1092 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		_tmp12_ = page;
#line 1092 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		_tmp13_ = self->priv->_book;
#line 1092 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		_tmp14_ = page;
#line 1092 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		_tmp15_ = book_get_page_index (_tmp13_, _tmp14_);
#line 1092 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		book_move_page (_tmp11_, _tmp12_, _tmp15_ + 1);
#line 5186 "ui.c"
	}
#line 1094 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	user_interface_update_page_menu (self);
#line 1087 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_page_unref0 (page);
#line 5192 "ui.c"
}


void G_MODULE_EXPORT page_delete_menuitem_activate_cb (GtkWidget* widget, UserInterface* self) {
	BookView* _tmp0_ = NULL;
	Book* _tmp1_ = NULL;
	Book* _tmp2_ = NULL;
	BookView* _tmp3_ = NULL;
	Page* _tmp4_ = NULL;
	Page* _tmp5_ = NULL;
#line 1098 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	g_return_if_fail (self != NULL);
#line 1098 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	g_return_if_fail (widget != NULL);
#line 1100 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp0_ = self->priv->book_view;
#line 1100 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp1_ = book_view_get_book (_tmp0_);
#line 1100 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp2_ = _tmp1_;
#line 1100 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp3_ = self->priv->book_view;
#line 1100 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp4_ = book_view_get_selected_page (_tmp3_);
#line 1100 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp5_ = _tmp4_;
#line 1100 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	book_delete_page (_tmp2_, _tmp5_);
#line 5221 "ui.c"
}


void G_MODULE_EXPORT save_file_button_clicked_cb (GtkWidget* widget, UserInterface* self) {
#line 1104 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	g_return_if_fail (self != NULL);
#line 1104 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	g_return_if_fail (widget != NULL);
#line 1106 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	user_interface_save_document (self, FALSE);
#line 5232 "ui.c"
}


void user_interface_save_document_activate_cb (UserInterface* self) {
#line 1109 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	g_return_if_fail (self != NULL);
#line 1111 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	user_interface_save_document (self, FALSE);
#line 5241 "ui.c"
}


void G_MODULE_EXPORT copy_to_clipboard_button_clicked_cb (GtkWidget* widget, UserInterface* self) {
	Page* page = NULL;
	BookView* _tmp0_ = NULL;
	Page* _tmp1_ = NULL;
	Page* _tmp2_ = NULL;
	Page* _tmp3_ = NULL;
	Page* _tmp4_ = NULL;
#line 1115 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	g_return_if_fail (self != NULL);
#line 1115 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	g_return_if_fail (widget != NULL);
#line 1117 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp0_ = self->priv->book_view;
#line 1117 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp1_ = book_view_get_selected_page (_tmp0_);
#line 1117 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp2_ = _tmp1_;
#line 1117 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp3_ = _page_ref0 (_tmp2_);
#line 1117 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	page = _tmp3_;
#line 1118 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp4_ = page;
#line 1118 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	if (_tmp4_ != NULL) {
#line 5270 "ui.c"
		Page* _tmp5_ = NULL;
		GtkApplicationWindow* _tmp6_ = NULL;
#line 1119 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		_tmp5_ = page;
#line 1119 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		_tmp6_ = self->priv->window;
#line 1119 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		page_copy_to_clipboard (_tmp5_, (GtkWindow*) _tmp6_);
#line 5279 "ui.c"
	}
#line 1115 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_page_unref0 (page);
#line 5283 "ui.c"
}


void G_MODULE_EXPORT save_as_file_button_clicked_cb (GtkWidget* widget, UserInterface* self) {
#line 1123 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	g_return_if_fail (self != NULL);
#line 1123 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	g_return_if_fail (widget != NULL);
#line 1125 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	user_interface_save_document (self, TRUE);
#line 5294 "ui.c"
}


void user_interface_save_as_document_activate_cb (UserInterface* self) {
#line 1128 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	g_return_if_fail (self != NULL);
#line 1130 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	user_interface_save_document (self, TRUE);
#line 5303 "ui.c"
}


static gpointer _cairo_reference0 (gpointer self) {
#line 1137 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	return self ? cairo_reference (self) : NULL;
#line 5310 "ui.c"
}


static void user_interface_draw_page (UserInterface* self, GtkPrintOperation* operation, GtkPrintContext* print_context, gint page_number) {
	cairo_t* context = NULL;
	GtkPrintContext* _tmp0_ = NULL;
	cairo_t* _tmp1_ = NULL;
	cairo_t* _tmp2_ = NULL;
	Page* page = NULL;
	Book* _tmp3_ = NULL;
	gint _tmp4_ = 0;
	Page* _tmp5_ = NULL;
	gboolean is_landscape = FALSE;
	GtkPrintContext* _tmp6_ = NULL;
	gdouble _tmp7_ = 0.0;
	GtkPrintContext* _tmp8_ = NULL;
	gdouble _tmp9_ = 0.0;
	Page* _tmp10_ = NULL;
	gboolean _tmp11_ = FALSE;
	gboolean _tmp12_ = FALSE;
	gboolean _tmp13_ = FALSE;
	cairo_t* _tmp18_ = NULL;
	GtkPrintContext* _tmp19_ = NULL;
	gdouble _tmp20_ = 0.0;
	Page* _tmp21_ = NULL;
	gint _tmp22_ = 0;
	gint _tmp23_ = 0;
	GtkPrintContext* _tmp24_ = NULL;
	gdouble _tmp25_ = 0.0;
	Page* _tmp26_ = NULL;
	gint _tmp27_ = 0;
	gint _tmp28_ = 0;
	GdkPixbuf* image = NULL;
	Page* _tmp29_ = NULL;
	GdkPixbuf* _tmp30_ = NULL;
	cairo_t* _tmp31_ = NULL;
	cairo_t* _tmp32_ = NULL;
#line 1133 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	g_return_if_fail (self != NULL);
#line 1133 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	g_return_if_fail (operation != NULL);
#line 1133 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	g_return_if_fail (print_context != NULL);
#line 1137 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp0_ = print_context;
#line 1137 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp1_ = gtk_print_context_get_cairo_context (_tmp0_);
#line 1137 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp2_ = _cairo_reference0 (_tmp1_);
#line 1137 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	context = _tmp2_;
#line 1138 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp3_ = self->priv->_book;
#line 1138 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp4_ = page_number;
#line 1138 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp5_ = book_get_page (_tmp3_, _tmp4_);
#line 1138 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	page = _tmp5_;
#line 1141 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	is_landscape = FALSE;
#line 1142 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp6_ = print_context;
#line 1142 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp7_ = gtk_print_context_get_width (_tmp6_);
#line 1142 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp8_ = print_context;
#line 1142 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp9_ = gtk_print_context_get_height (_tmp8_);
#line 1142 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	if (_tmp7_ > _tmp9_) {
#line 1143 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		is_landscape = TRUE;
#line 5384 "ui.c"
	}
#line 1144 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp10_ = page;
#line 1144 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp11_ = page_get_is_landscape (_tmp10_);
#line 1144 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp12_ = _tmp11_;
#line 1144 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp13_ = is_landscape;
#line 1144 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	if (_tmp12_ != _tmp13_) {
#line 5396 "ui.c"
		cairo_t* _tmp14_ = NULL;
		GtkPrintContext* _tmp15_ = NULL;
		gdouble _tmp16_ = 0.0;
		cairo_t* _tmp17_ = NULL;
#line 1146 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		_tmp14_ = context;
#line 1146 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		_tmp15_ = print_context;
#line 1146 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		_tmp16_ = gtk_print_context_get_width (_tmp15_);
#line 1146 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		cairo_translate (_tmp14_, _tmp16_, (gdouble) 0);
#line 1147 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		_tmp17_ = context;
#line 1147 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		cairo_rotate (_tmp17_, G_PI_2);
#line 5413 "ui.c"
	}
#line 1150 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp18_ = context;
#line 1150 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp19_ = print_context;
#line 1150 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp20_ = gtk_print_context_get_dpi_x (_tmp19_);
#line 1150 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp21_ = page;
#line 1150 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp22_ = page_get_dpi (_tmp21_);
#line 1150 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp23_ = _tmp22_;
#line 1150 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp24_ = print_context;
#line 1150 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp25_ = gtk_print_context_get_dpi_y (_tmp24_);
#line 1150 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp26_ = page;
#line 1150 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp27_ = page_get_dpi (_tmp26_);
#line 1150 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp28_ = _tmp27_;
#line 1150 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	cairo_scale (_tmp18_, _tmp20_ / _tmp23_, _tmp25_ / _tmp28_);
#line 1153 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp29_ = page;
#line 1153 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp30_ = page_get_image (_tmp29_, TRUE);
#line 1153 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	image = _tmp30_;
#line 1154 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp31_ = context;
#line 1154 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	gdk_cairo_set_source_pixbuf (_tmp31_, image, (gdouble) 0, (gdouble) 0);
#line 1155 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp32_ = context;
#line 1155 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	cairo_paint (_tmp32_);
#line 1133 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_g_object_unref0 (image);
#line 1133 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_page_unref0 (page);
#line 1133 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_cairo_destroy0 (context);
#line 5459 "ui.c"
}


void G_MODULE_EXPORT email_button_clicked_cb (GtkWidget* widget, UserInterface* self) {
	const gchar* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
#line 1159 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	g_return_if_fail (self != NULL);
#line 1159 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	g_return_if_fail (widget != NULL);
#line 1161 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp0_ = self->priv->document_hint;
#line 1161 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp1_ = user_interface_get_quality (self);
#line 1161 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp2_ = _tmp1_;
#line 1161 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	g_signal_emit_by_name (self, "email", _tmp0_, _tmp2_);
#line 5479 "ui.c"
}


void user_interface_email_document_activate_cb (UserInterface* self) {
	const gchar* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
#line 1164 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	g_return_if_fail (self != NULL);
#line 1166 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp0_ = self->priv->document_hint;
#line 1166 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp1_ = user_interface_get_quality (self);
#line 1166 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp2_ = _tmp1_;
#line 1166 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	g_signal_emit_by_name (self, "email", _tmp0_, _tmp2_);
#line 5497 "ui.c"
}


static void _user_interface_draw_page_gtk_print_operation_draw_page (GtkPrintOperation* _sender, GtkPrintContext* context, gint page_nr, gpointer self) {
#line 1173 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	user_interface_draw_page ((UserInterface*) self, _sender, context, page_nr);
#line 5504 "ui.c"
}


static void user_interface_print_document (UserInterface* self) {
	GtkPrintOperation* print = NULL;
	GtkPrintOperation* _tmp0_ = NULL;
	Book* _tmp1_ = NULL;
	guint _tmp2_ = 0U;
	guint _tmp3_ = 0U;
	guint _tmp7_ = 0U;
	GError * _inner_error_ = NULL;
#line 1169 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	g_return_if_fail (self != NULL);
#line 1171 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp0_ = gtk_print_operation_new ();
#line 1171 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	print = _tmp0_;
#line 1172 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp1_ = self->priv->_book;
#line 1172 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp2_ = book_get_n_pages (_tmp1_);
#line 1172 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp3_ = _tmp2_;
#line 1172 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	gtk_print_operation_set_n_pages (print, (gint) _tmp3_);
#line 1173 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	g_signal_connect (print, "draw-page", (GCallback) _user_interface_draw_page_gtk_print_operation_draw_page, self);
#line 5532 "ui.c"
	{
		GtkApplicationWindow* _tmp4_ = NULL;
#line 1177 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		_tmp4_ = self->priv->window;
#line 1177 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		gtk_print_operation_run (print, GTK_PRINT_OPERATION_ACTION_PRINT_DIALOG, (GtkWindow*) _tmp4_, &_inner_error_);
#line 1177 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 5541 "ui.c"
			goto __catch19_g_error;
		}
	}
	goto __finally19;
	__catch19_g_error:
	{
		GError* e = NULL;
		GError* _tmp5_ = NULL;
		const gchar* _tmp6_ = NULL;
#line 1175 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		e = _inner_error_;
#line 1175 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		_inner_error_ = NULL;
#line 1181 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		_tmp5_ = e;
#line 1181 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		_tmp6_ = _tmp5_->message;
#line 1181 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		g_warning ("ui.vala:1181: Error printing: %s", _tmp6_);
#line 1175 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		_g_error_free0 (e);
#line 5563 "ui.c"
	}
	__finally19:
#line 1175 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1175 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		_g_object_unref0 (print);
#line 1175 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1175 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		g_clear_error (&_inner_error_);
#line 1175 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		return;
#line 5576 "ui.c"
	}
#line 1184 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	g_signal_parse_name ("draw-page", gtk_print_operation_get_type (), &_tmp7_, NULL, FALSE);
#line 1184 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	g_signal_handlers_disconnect_matched (print, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp7_, 0, NULL, (GCallback) _user_interface_draw_page_gtk_print_operation_draw_page, self);
#line 1169 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_g_object_unref0 (print);
#line 5584 "ui.c"
}


void G_MODULE_EXPORT print_button_clicked_cb (GtkWidget* widget, UserInterface* self) {
#line 1188 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	g_return_if_fail (self != NULL);
#line 1188 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	g_return_if_fail (widget != NULL);
#line 1190 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	user_interface_print_document (self);
#line 5595 "ui.c"
}


void user_interface_print_document_activate_cb (UserInterface* self) {
#line 1193 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	g_return_if_fail (self != NULL);
#line 1195 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	user_interface_print_document (self);
#line 5604 "ui.c"
}


static void user_interface_show_help (UserInterface* self) {
	GError * _inner_error_ = NULL;
#line 1198 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	g_return_if_fail (self != NULL);
#line 5612 "ui.c"
	{
		GtkApplicationWindow* _tmp0_ = NULL;
		GdkScreen* _tmp1_ = NULL;
		guint32 _tmp2_ = 0U;
#line 1202 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		_tmp0_ = self->priv->window;
#line 1202 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		_tmp1_ = gtk_window_get_screen ((GtkWindow*) _tmp0_);
#line 1202 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		_tmp2_ = gtk_get_current_event_time ();
#line 1202 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		gtk_show_uri (_tmp1_, "help:simple-scan", _tmp2_, &_inner_error_);
#line 1202 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 5627 "ui.c"
			goto __catch20_g_error;
		}
	}
	goto __finally20;
	__catch20_g_error:
	{
		GError* e = NULL;
		const gchar* _tmp3_ = NULL;
		GError* _tmp4_ = NULL;
		const gchar* _tmp5_ = NULL;
#line 1200 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		e = _inner_error_;
#line 1200 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		_inner_error_ = NULL;
#line 1206 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		_tmp3_ = _ ("Unable to open help file");
#line 1206 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		_tmp4_ = e;
#line 1206 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		_tmp5_ = _tmp4_->message;
#line 1206 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		user_interface_show_error_dialog (self, _tmp3_, _tmp5_);
#line 1200 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		_g_error_free0 (e);
#line 5652 "ui.c"
	}
	__finally20:
#line 1200 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1200 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1200 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		g_clear_error (&_inner_error_);
#line 1200 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		return;
#line 5663 "ui.c"
	}
}


void G_MODULE_EXPORT help_contents_menuitem_activate_cb (GtkWidget* widget, UserInterface* self) {
#line 1213 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	g_return_if_fail (self != NULL);
#line 1213 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	g_return_if_fail (widget != NULL);
#line 1215 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	user_interface_show_help (self);
#line 5675 "ui.c"
}


void user_interface_help_contents_activate_cb (UserInterface* self) {
#line 1218 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	g_return_if_fail (self != NULL);
#line 1220 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	user_interface_show_help (self);
#line 5684 "ui.c"
}


static void user_interface_show_about (UserInterface* self) {
	gchar** authors = NULL;
	gchar* _tmp0_ = NULL;
	gchar** _tmp1_ = NULL;
	gint authors_length1 = 0;
	gint _authors_size_ = 0;
	gchar* license = NULL;
	const gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	gchar* title = NULL;
	const gchar* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
	gchar* description = NULL;
	const gchar* _tmp6_ = NULL;
	gchar* _tmp7_ = NULL;
	GtkApplicationWindow* _tmp8_ = NULL;
	const gchar* _tmp9_ = NULL;
#line 1223 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	g_return_if_fail (self != NULL);
#line 1225 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp0_ = g_strdup ("Robert Ancell <robert.ancell@canonical.com>");
#line 1225 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp1_ = g_new0 (gchar*, 1 + 1);
#line 1225 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp1_[0] = _tmp0_;
#line 1225 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	authors = _tmp1_;
#line 1225 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	authors_length1 = 1;
#line 1225 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_authors_size_ = authors_length1;
#line 1228 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp2_ = _ ("This program is free software: you can redistribute it and/or modify\n" \
"it under the terms of the GNU General Public License as published by\n" \
"the Free Software Foundation, either version 3 of the License, or\n" \
"(at your option) any later version.\n" \
"\n" \
"This program is distributed in the hope that it will be useful,\n" \
"but WITHOUT ANY WARRANTY; without even the implied warranty of\n" \
"MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\n" \
"GNU General Public License for more details.\n" \
"\n" \
"You should have received a copy of the GNU General Public License\n" \
"along with this program.  If not, see <http://www.gnu.org/licenses/>.");
#line 1228 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp3_ = g_strdup (_tmp2_);
#line 1228 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	license = _tmp3_;
#line 1231 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp4_ = _ ("About Simple Scan");
#line 1231 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp5_ = g_strdup (_tmp4_);
#line 1231 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	title = _tmp5_;
#line 1234 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp6_ = _ ("Simple document scanning tool");
#line 1234 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp7_ = g_strdup (_tmp6_);
#line 1234 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	description = _tmp7_;
#line 1236 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp8_ = self->priv->window;
#line 1236 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp9_ = _ ("translator-credits");
#line 1236 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	gtk_show_about_dialog ((GtkWindow*) _tmp8_, "title", title, "program-name", "Simple Scan", "version", VERSION, "comments", description, "logo-icon-name", "scanner", "authors", authors, "translator-credits", _tmp9_, "website", "https://launchpad.net/simple-scan", "copyright", "Copyright © 2009-2011 Canonical Ltd.", "license", license, "wrap-license", TRUE, NULL, NULL);
#line 1223 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_g_free0 (description);
#line 1223 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_g_free0 (title);
#line 1223 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_g_free0 (license);
#line 1223 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	authors = (_vala_array_free (authors, authors_length1, (GDestroyNotify) g_free), NULL);
#line 5751 "ui.c"
}


void G_MODULE_EXPORT about_menuitem_activate_cb (GtkWidget* widget, UserInterface* self) {
#line 1252 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	g_return_if_fail (self != NULL);
#line 1252 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	g_return_if_fail (widget != NULL);
#line 1254 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	user_interface_show_about (self);
#line 5762 "ui.c"
}


void user_interface_about_activate_cb (UserInterface* self) {
#line 1257 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	g_return_if_fail (self != NULL);
#line 1259 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	user_interface_show_about (self);
#line 5771 "ui.c"
}


static gboolean user_interface_on_quit (UserInterface* self) {
	gboolean result = FALSE;
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gboolean _tmp2_ = FALSE;
	GtkApplicationWindow* _tmp3_ = NULL;
	guint _tmp4_ = 0U;
	AutosaveManager* _tmp5_ = NULL;
#line 1262 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 1264 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp0_ = _ ("Save document before quitting?");
#line 1264 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp1_ = _ ("Quit without Saving");
#line 1264 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp2_ = user_interface_prompt_to_save (self, _tmp0_, _tmp1_);
#line 1264 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	if (!_tmp2_) {
#line 1268 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		result = FALSE;
#line 1268 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		return result;
#line 5797 "ui.c"
	}
#line 1270 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp3_ = self->priv->window;
#line 1270 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	gtk_widget_destroy ((GtkWidget*) _tmp3_);
#line 1272 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp4_ = self->priv->save_state_timeout;
#line 1272 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	if (_tmp4_ != ((guint) 0)) {
#line 1273 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		user_interface_save_state (self, TRUE);
#line 5809 "ui.c"
	}
#line 1275 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp5_ = self->priv->autosave_manager;
#line 1275 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	autosave_manager_cleanup (_tmp5_);
#line 1277 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	result = TRUE;
#line 1277 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	return result;
#line 5819 "ui.c"
}


void G_MODULE_EXPORT quit_menuitem_activate_cb (GtkWidget* widget, UserInterface* self) {
#line 1281 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	g_return_if_fail (self != NULL);
#line 1281 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	g_return_if_fail (widget != NULL);
#line 1283 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	user_interface_on_quit (self);
#line 5830 "ui.c"
}


void user_interface_quit_activate_cb (UserInterface* self) {
#line 1286 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	g_return_if_fail (self != NULL);
#line 1288 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	user_interface_on_quit (self);
#line 5839 "ui.c"
}


gboolean G_MODULE_EXPORT simple_scan_window_configure_event_cb (GtkWidget* widget, GdkEventConfigure* event, UserInterface* self) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
#line 1292 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 1292 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	g_return_val_if_fail (widget != NULL, FALSE);
#line 1292 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	g_return_val_if_fail (event != NULL, FALSE);
#line 1294 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp0_ = self->priv->window_is_maximized;
#line 1294 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	if (!_tmp0_) {
#line 5856 "ui.c"
		GdkEventConfigure* _tmp1_ = NULL;
		gint _tmp2_ = 0;
		GdkEventConfigure* _tmp3_ = NULL;
		gint _tmp4_ = 0;
#line 1296 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		_tmp1_ = event;
#line 1296 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		_tmp2_ = _tmp1_->width;
#line 1296 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		self->priv->window_width = _tmp2_;
#line 1297 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		_tmp3_ = event;
#line 1297 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		_tmp4_ = _tmp3_->height;
#line 1297 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		self->priv->window_height = _tmp4_;
#line 1298 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		user_interface_save_state (self, FALSE);
#line 5875 "ui.c"
	}
#line 1301 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	result = FALSE;
#line 1301 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	return result;
#line 5881 "ui.c"
}


static void user_interface_info_bar_response_cb (UserInterface* self, GtkInfoBar* widget, gint response_id) {
	gint _tmp0_ = 0;
#line 1304 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	g_return_if_fail (self != NULL);
#line 1304 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	g_return_if_fail (widget != NULL);
#line 1306 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp0_ = response_id;
#line 1306 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	if (_tmp0_ == 1) {
#line 5895 "ui.c"
		GtkComboBox* _tmp1_ = NULL;
		GtkDialog* _tmp2_ = NULL;
#line 1308 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		_tmp1_ = self->priv->device_combo;
#line 1308 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		gtk_widget_grab_focus ((GtkWidget*) _tmp1_);
#line 1309 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		_tmp2_ = self->priv->preferences_dialog;
#line 1309 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		gtk_window_present ((GtkWindow*) _tmp2_);
#line 5906 "ui.c"
	} else {
#line 1313 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		self->priv->have_error = FALSE;
#line 1314 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		_g_free0 (self->priv->error_title);
#line 1314 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		self->priv->error_title = NULL;
#line 1315 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		_g_free0 (self->priv->error_text);
#line 1315 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		self->priv->error_text = NULL;
#line 1316 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		user_interface_update_info_bar (self);
#line 5920 "ui.c"
	}
}


gboolean G_MODULE_EXPORT simple_scan_window_window_state_event_cb (GtkWidget* widget, GdkEventWindowState* event, UserInterface* self) {
	gboolean result = FALSE;
	GdkEventWindowState* _tmp0_ = NULL;
	GdkWindowState _tmp1_ = 0;
#line 1321 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 1321 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	g_return_val_if_fail (widget != NULL, FALSE);
#line 1321 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	g_return_val_if_fail (event != NULL, FALSE);
#line 1323 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp0_ = event;
#line 1323 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp1_ = _tmp0_->changed_mask;
#line 1323 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	if ((_tmp1_ & GDK_WINDOW_STATE_MAXIMIZED) != 0) {
#line 5941 "ui.c"
		GdkEventWindowState* _tmp2_ = NULL;
		GdkWindowState _tmp3_ = 0;
#line 1325 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		_tmp2_ = event;
#line 1325 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		_tmp3_ = _tmp2_->new_window_state;
#line 1325 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		self->priv->window_is_maximized = (_tmp3_ & GDK_WINDOW_STATE_MAXIMIZED) != 0;
#line 1326 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		user_interface_save_state (self, FALSE);
#line 5952 "ui.c"
	}
#line 1328 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	result = FALSE;
#line 1328 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	return result;
#line 5958 "ui.c"
}


gboolean G_MODULE_EXPORT window_delete_event_cb (GtkWidget* widget, GdkEvent* event, UserInterface* self) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
#line 1332 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 1332 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	g_return_val_if_fail (widget != NULL, FALSE);
#line 1332 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	g_return_val_if_fail (event != NULL, FALSE);
#line 1334 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp0_ = user_interface_on_quit (self);
#line 1334 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	result = !_tmp0_;
#line 1334 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	return result;
#line 5977 "ui.c"
}


static void user_interface_page_size_changed_cb (UserInterface* self, Page* page) {
	Page* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	Page* _tmp3_ = NULL;
	gint _tmp4_ = 0;
	gint _tmp5_ = 0;
	Page* _tmp6_ = NULL;
	gint _tmp7_ = 0;
	gint _tmp8_ = 0;
#line 1337 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	g_return_if_fail (self != NULL);
#line 1337 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	g_return_if_fail (page != NULL);
#line 1339 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp0_ = page;
#line 1339 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp1_ = page_get_width (_tmp0_);
#line 1339 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp2_ = _tmp1_;
#line 1339 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	self->priv->default_page_width = _tmp2_;
#line 1340 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp3_ = page;
#line 1340 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp4_ = page_get_height (_tmp3_);
#line 1340 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp5_ = _tmp4_;
#line 1340 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	self->priv->default_page_height = _tmp5_;
#line 1341 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp6_ = page;
#line 1341 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp7_ = page_get_dpi (_tmp6_);
#line 1341 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp8_ = _tmp7_;
#line 1341 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	self->priv->default_page_dpi = _tmp8_;
#line 1342 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	user_interface_save_state (self, FALSE);
#line 6021 "ui.c"
}


static void user_interface_page_scan_direction_changed_cb (UserInterface* self, Page* page) {
	Page* _tmp0_ = NULL;
	ScanDirection _tmp1_ = 0;
	ScanDirection _tmp2_ = 0;
#line 1345 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	g_return_if_fail (self != NULL);
#line 1345 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	g_return_if_fail (page != NULL);
#line 1347 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp0_ = page;
#line 1347 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp1_ = page_get_scan_direction (_tmp0_);
#line 1347 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp2_ = _tmp1_;
#line 1347 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	self->priv->default_page_scan_direction = _tmp2_;
#line 1348 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	user_interface_save_state (self, FALSE);
#line 6043 "ui.c"
}


static void _user_interface_page_size_changed_cb_page_size_changed (Page* _sender, gpointer self) {
#line 1355 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	user_interface_page_size_changed_cb ((UserInterface*) self, _sender);
#line 6050 "ui.c"
}


static void _user_interface_page_scan_direction_changed_cb_page_scan_direction_changed (Page* _sender, gpointer self) {
#line 1356 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	user_interface_page_scan_direction_changed_cb ((UserInterface*) self, _sender);
#line 6057 "ui.c"
}


static void user_interface_page_added_cb (UserInterface* self, Book* book, Page* page) {
	Page* _tmp0_ = NULL;
	Page* _tmp1_ = NULL;
	ScanDirection _tmp2_ = 0;
	ScanDirection _tmp3_ = 0;
	Page* _tmp4_ = NULL;
	Page* _tmp5_ = NULL;
#line 1351 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	g_return_if_fail (self != NULL);
#line 1351 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	g_return_if_fail (book != NULL);
#line 1351 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	g_return_if_fail (page != NULL);
#line 1353 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp0_ = page;
#line 1353 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	user_interface_page_size_changed_cb (self, _tmp0_);
#line 1354 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp1_ = page;
#line 1354 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp2_ = page_get_scan_direction (_tmp1_);
#line 1354 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp3_ = _tmp2_;
#line 1354 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	self->priv->default_page_scan_direction = _tmp3_;
#line 1355 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp4_ = page;
#line 1355 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	g_signal_connect (_tmp4_, "size-changed", (GCallback) _user_interface_page_size_changed_cb_page_size_changed, self);
#line 1356 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp5_ = page;
#line 1356 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	g_signal_connect (_tmp5_, "scan-direction-changed", (GCallback) _user_interface_page_scan_direction_changed_cb_page_scan_direction_changed, self);
#line 1358 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	user_interface_update_page_menu (self);
#line 6096 "ui.c"
}


static void user_interface_page_removed_cb (UserInterface* self, Book* book, Page* page) {
	Page* _tmp0_ = NULL;
	guint _tmp1_ = 0U;
	Page* _tmp2_ = NULL;
	guint _tmp3_ = 0U;
	Book* _tmp4_ = NULL;
	guint _tmp5_ = 0U;
	guint _tmp6_ = 0U;
#line 1361 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	g_return_if_fail (self != NULL);
#line 1361 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	g_return_if_fail (book != NULL);
#line 1361 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	g_return_if_fail (page != NULL);
#line 1363 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp0_ = page;
#line 1363 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	g_signal_parse_name ("size-changed", TYPE_PAGE, &_tmp1_, NULL, FALSE);
#line 1363 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	g_signal_handlers_disconnect_matched (_tmp0_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp1_, 0, NULL, (GCallback) _user_interface_page_size_changed_cb_page_size_changed, self);
#line 1364 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp2_ = page;
#line 1364 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	g_signal_parse_name ("scan-direction-changed", TYPE_PAGE, &_tmp3_, NULL, FALSE);
#line 1364 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	g_signal_handlers_disconnect_matched (_tmp2_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp3_, 0, NULL, (GCallback) _user_interface_page_scan_direction_changed_cb_page_scan_direction_changed, self);
#line 1367 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp4_ = book;
#line 1367 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp5_ = book_get_n_pages (_tmp4_);
#line 1367 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp6_ = _tmp5_;
#line 1367 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	if (_tmp6_ == ((guint) 1)) {
#line 1368 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		user_interface_add_default_page (self);
#line 6136 "ui.c"
	}
#line 1370 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	user_interface_update_page_menu (self);
#line 6140 "ui.c"
}


static void user_interface_set_dpi_combo (UserInterface* self, GtkComboBox* combo, gint default_dpi, gint current_dpi) {
	GtkCellRendererText* renderer = NULL;
	GtkCellRendererText* _tmp0_ = NULL;
	GtkComboBox* _tmp1_ = NULL;
	GtkCellRendererText* _tmp2_ = NULL;
	GtkComboBox* _tmp3_ = NULL;
	GtkCellRendererText* _tmp4_ = NULL;
	GtkListStore* model = NULL;
	GtkComboBox* _tmp5_ = NULL;
	GtkTreeModel* _tmp6_ = NULL;
	GtkListStore* _tmp7_ = NULL;
	gint* scan_resolutions = NULL;
	gint* _tmp8_ = NULL;
	gint scan_resolutions_length1 = 0;
	gint _scan_resolutions_size_ = 0;
	gint* _tmp9_ = NULL;
	gint _tmp9__length1 = 0;
#line 1373 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	g_return_if_fail (self != NULL);
#line 1373 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	g_return_if_fail (combo != NULL);
#line 1375 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp0_ = (GtkCellRendererText*) gtk_cell_renderer_text_new ();
#line 1375 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	g_object_ref_sink (_tmp0_);
#line 1375 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	renderer = _tmp0_;
#line 1376 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp1_ = combo;
#line 1376 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp2_ = renderer;
#line 1376 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	gtk_cell_layout_pack_start ((GtkCellLayout*) _tmp1_, (GtkCellRenderer*) _tmp2_, TRUE);
#line 1377 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp3_ = combo;
#line 1377 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp4_ = renderer;
#line 1377 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	gtk_cell_layout_add_attribute ((GtkCellLayout*) _tmp3_, (GtkCellRenderer*) _tmp4_, "text", 1);
#line 1379 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp5_ = combo;
#line 1379 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp6_ = gtk_combo_box_get_model (_tmp5_);
#line 1379 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp7_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, gtk_list_store_get_type (), GtkListStore));
#line 1379 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	model = _tmp7_;
#line 1380 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp8_ = g_new0 (gint, 6);
#line 1380 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp8_[0] = 75;
#line 1380 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp8_[1] = 150;
#line 1380 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp8_[2] = 300;
#line 1380 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp8_[3] = 600;
#line 1380 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp8_[4] = 1200;
#line 1380 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp8_[5] = 2400;
#line 1380 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	scan_resolutions = _tmp8_;
#line 1380 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	scan_resolutions_length1 = 6;
#line 1380 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_scan_resolutions_size_ = scan_resolutions_length1;
#line 1381 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp9_ = scan_resolutions;
#line 1381 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp9__length1 = scan_resolutions_length1;
#line 6215 "ui.c"
	{
		gint* dpi_collection = NULL;
		gint dpi_collection_length1 = 0;
		gint _dpi_collection_size_ = 0;
		gint dpi_it = 0;
#line 1381 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		dpi_collection = _tmp9_;
#line 1381 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		dpi_collection_length1 = _tmp9__length1;
#line 1381 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		for (dpi_it = 0; dpi_it < _tmp9__length1; dpi_it = dpi_it + 1) {
#line 6227 "ui.c"
			gint dpi = 0;
#line 1381 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
			dpi = dpi_collection[dpi_it];
#line 6231 "ui.c"
			{
				gchar* label = NULL;
				gint _tmp10_ = 0;
				gint _tmp11_ = 0;
				GtkTreeIter iter = {0};
				GtkListStore* _tmp26_ = NULL;
				GtkTreeIter _tmp27_ = {0};
				GtkListStore* _tmp28_ = NULL;
				GtkTreeIter _tmp29_ = {0};
				gint _tmp30_ = 0;
				const gchar* _tmp31_ = NULL;
				gint _tmp32_ = 0;
				gint _tmp33_ = 0;
#line 1384 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
				_tmp10_ = dpi;
#line 1384 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
				_tmp11_ = default_dpi;
#line 1384 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
				if (_tmp10_ == _tmp11_) {
#line 6251 "ui.c"
					const gchar* _tmp12_ = NULL;
					gint _tmp13_ = 0;
					gchar* _tmp14_ = NULL;
#line 1386 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
					_tmp12_ = _ ("%d dpi (default)");
#line 1386 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
					_tmp13_ = dpi;
#line 1386 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
					_tmp14_ = g_strdup_printf (_tmp12_, _tmp13_);
#line 1386 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
					_g_free0 (label);
#line 1386 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
					label = _tmp14_;
#line 6265 "ui.c"
				} else {
					gint _tmp15_ = 0;
#line 1387 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
					_tmp15_ = dpi;
#line 1387 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
					if (_tmp15_ == 75) {
#line 6272 "ui.c"
						const gchar* _tmp16_ = NULL;
						gint _tmp17_ = 0;
						gchar* _tmp18_ = NULL;
#line 1389 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
						_tmp16_ = _ ("%d dpi (draft)");
#line 1389 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
						_tmp17_ = dpi;
#line 1389 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
						_tmp18_ = g_strdup_printf (_tmp16_, _tmp17_);
#line 1389 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
						_g_free0 (label);
#line 1389 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
						label = _tmp18_;
#line 6286 "ui.c"
					} else {
						gint _tmp19_ = 0;
#line 1390 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
						_tmp19_ = dpi;
#line 1390 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
						if (_tmp19_ == 1200) {
#line 6293 "ui.c"
							const gchar* _tmp20_ = NULL;
							gint _tmp21_ = 0;
							gchar* _tmp22_ = NULL;
#line 1392 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
							_tmp20_ = _ ("%d dpi (high resolution)");
#line 1392 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
							_tmp21_ = dpi;
#line 1392 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
							_tmp22_ = g_strdup_printf (_tmp20_, _tmp21_);
#line 1392 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
							_g_free0 (label);
#line 1392 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
							label = _tmp22_;
#line 6307 "ui.c"
						} else {
							const gchar* _tmp23_ = NULL;
							gint _tmp24_ = 0;
							gchar* _tmp25_ = NULL;
#line 1395 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
							_tmp23_ = _ ("%d dpi");
#line 1395 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
							_tmp24_ = dpi;
#line 1395 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
							_tmp25_ = g_strdup_printf (_tmp23_, _tmp24_);
#line 1395 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
							_g_free0 (label);
#line 1395 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
							label = _tmp25_;
#line 6322 "ui.c"
						}
					}
				}
#line 1398 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
				_tmp26_ = model;
#line 1398 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
				gtk_list_store_append (_tmp26_, &_tmp27_);
#line 1398 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
				iter = _tmp27_;
#line 1399 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
				_tmp28_ = model;
#line 1399 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
				_tmp29_ = iter;
#line 1399 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
				_tmp30_ = dpi;
#line 1399 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
				_tmp31_ = label;
#line 1399 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
				gtk_list_store_set (_tmp28_, &_tmp29_, 0, _tmp30_, 1, _tmp31_, -1, -1);
#line 1401 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
				_tmp32_ = dpi;
#line 1401 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
				_tmp33_ = current_dpi;
#line 1401 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
				if (_tmp32_ == _tmp33_) {
#line 6348 "ui.c"
					GtkComboBox* _tmp34_ = NULL;
					GtkTreeIter _tmp35_ = {0};
#line 1402 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
					_tmp34_ = combo;
#line 1402 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
					_tmp35_ = iter;
#line 1402 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
					gtk_combo_box_set_active_iter (_tmp34_, &_tmp35_);
#line 6357 "ui.c"
				}
#line 1381 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
				_g_free0 (label);
#line 6361 "ui.c"
			}
		}
	}
#line 1373 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	scan_resolutions = (g_free (scan_resolutions), NULL);
#line 1373 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_g_object_unref0 (model);
#line 1373 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_g_object_unref0 (renderer);
#line 6371 "ui.c"
}


static void user_interface_needs_saving_cb (UserInterface* self, Book* book) {
	GtkMenuItem* _tmp0_ = NULL;
	Book* _tmp1_ = NULL;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	GtkToolButton* _tmp4_ = NULL;
	Book* _tmp5_ = NULL;
	gboolean _tmp6_ = FALSE;
	gboolean _tmp7_ = FALSE;
	Book* _tmp8_ = NULL;
	gboolean _tmp9_ = FALSE;
	gboolean _tmp10_ = FALSE;
	GtkMenuItem* _tmp12_ = NULL;
#line 1406 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	g_return_if_fail (self != NULL);
#line 1406 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	g_return_if_fail (book != NULL);
#line 1408 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp0_ = self->priv->save_menuitem;
#line 1408 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp1_ = book;
#line 1408 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp2_ = book_get_needs_saving (_tmp1_);
#line 1408 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp3_ = _tmp2_;
#line 1408 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	gtk_widget_set_sensitive ((GtkWidget*) _tmp0_, _tmp3_);
#line 1409 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp4_ = self->priv->save_toolbutton;
#line 1409 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp5_ = book;
#line 1409 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp6_ = book_get_needs_saving (_tmp5_);
#line 1409 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp7_ = _tmp6_;
#line 1409 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	gtk_widget_set_sensitive ((GtkWidget*) _tmp4_, _tmp7_);
#line 1410 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp8_ = book;
#line 1410 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp9_ = book_get_needs_saving (_tmp8_);
#line 1410 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp10_ = _tmp9_;
#line 1410 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	if (_tmp10_) {
#line 6420 "ui.c"
		GtkMenuItem* _tmp11_ = NULL;
#line 1411 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		_tmp11_ = self->priv->save_as_menuitem;
#line 1411 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		gtk_widget_set_sensitive ((GtkWidget*) _tmp11_, TRUE);
#line 6426 "ui.c"
	}
#line 1412 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp12_ = self->priv->copy_to_clipboard_menuitem;
#line 1412 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	gtk_widget_set_sensitive ((GtkWidget*) _tmp12_, TRUE);
#line 6432 "ui.c"
}


static gboolean user_interface_has_app_menu (UserInterface* self, GtkApplication* app) {
	gboolean result = FALSE;
	GtkSettings* gtk_settings = NULL;
	GtkSettings* _tmp0_ = NULL;
	GtkSettings* _tmp1_ = NULL;
	gboolean show_app_menu = FALSE;
	gboolean show_menubar = FALSE;
	GtkSettings* _tmp2_ = NULL;
	gboolean _tmp3_ = FALSE;
	gboolean _tmp4_ = FALSE;
#line 1415 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 1415 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	g_return_val_if_fail (app != NULL, FALSE);
#line 1422 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp0_ = gtk_settings_get_default ();
#line 1422 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 1422 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	gtk_settings = _tmp1_;
#line 1424 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	show_app_menu = FALSE;
#line 1425 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	show_menubar = TRUE;
#line 1426 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp2_ = gtk_settings;
#line 1426 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	g_object_get ((GObject*) _tmp2_, "gtk-shell-shows-app-menu", &show_app_menu, "gtk-shell-shows-menubar", &show_menubar, NULL, NULL);
#line 1428 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp4_ = show_app_menu;
#line 1428 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	if (_tmp4_) {
#line 6468 "ui.c"
		gboolean _tmp5_ = FALSE;
#line 1428 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		_tmp5_ = show_menubar;
#line 1428 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		_tmp3_ = !_tmp5_;
#line 6474 "ui.c"
	} else {
#line 1428 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		_tmp3_ = FALSE;
#line 6478 "ui.c"
	}
#line 1428 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	result = _tmp3_;
#line 1428 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_g_object_unref0 (gtk_settings);
#line 1428 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	return result;
#line 6486 "ui.c"
}


static void _user_interface_info_bar_response_cb_gtk_info_bar_response (GtkInfoBar* _sender, gint response_id, gpointer self) {
#line 1509 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	user_interface_info_bar_response_cb ((UserInterface*) self, _sender, response_id);
#line 6493 "ui.c"
}


static void __lambda6_ (UserInterface* self) {
	GSettings* _tmp0_ = NULL;
	gint _tmp1_ = 0;
#line 1551 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp0_ = self->priv->settings;
#line 1551 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp1_ = user_interface_get_text_dpi (self);
#line 1551 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	g_settings_set_int (_tmp0_, "text-dpi", _tmp1_);
#line 6506 "ui.c"
}


static void ___lambda6__gtk_combo_box_changed (GtkComboBox* _sender, gpointer self) {
#line 1551 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	__lambda6_ ((UserInterface*) self);
#line 6513 "ui.c"
}


static void __lambda7_ (UserInterface* self) {
	GSettings* _tmp0_ = NULL;
	gint _tmp1_ = 0;
#line 1556 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp0_ = self->priv->settings;
#line 1556 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp1_ = user_interface_get_photo_dpi (self);
#line 1556 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	g_settings_set_int (_tmp0_, "photo-dpi", _tmp1_);
#line 6526 "ui.c"
}


static void ___lambda7__gtk_combo_box_changed (GtkComboBox* _sender, gpointer self) {
#line 1556 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	__lambda7_ ((UserInterface*) self);
#line 6533 "ui.c"
}


static void __lambda8_ (UserInterface* self) {
	GSettings* _tmp0_ = NULL;
	ScanType _tmp1_ = 0;
#line 1566 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp0_ = self->priv->settings;
#line 1566 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp1_ = user_interface_get_page_side (self);
#line 1566 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	g_settings_set_enum (_tmp0_, "page-side", (gint) _tmp1_);
#line 6546 "ui.c"
}


static void ___lambda8__gtk_combo_box_changed (GtkComboBox* _sender, gpointer self) {
#line 1566 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	__lambda8_ ((UserInterface*) self);
#line 6553 "ui.c"
}


static void __lambda9_ (UserInterface* self) {
	gint w = 0;
	gint h = 0;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	GSettings* _tmp2_ = NULL;
	GSettings* _tmp3_ = NULL;
#line 1577 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	user_interface_get_paper_size (self, &_tmp0_, &_tmp1_);
#line 1577 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	w = _tmp0_;
#line 1577 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	h = _tmp1_;
#line 1578 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp2_ = self->priv->settings;
#line 1578 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	g_settings_set_int (_tmp2_, "paper-width", w);
#line 1579 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp3_ = self->priv->settings;
#line 1579 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	g_settings_set_int (_tmp3_, "paper-height", h);
#line 6578 "ui.c"
}


static void ___lambda9__gtk_combo_box_changed (GtkComboBox* _sender, gpointer self) {
#line 1574 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	__lambda9_ ((UserInterface*) self);
#line 6585 "ui.c"
}


static void __lambda10_ (UserInterface* self) {
	GSettings* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
#line 1590 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp0_ = self->priv->settings;
#line 1590 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp1_ = user_interface_get_brightness (self);
#line 1590 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp2_ = _tmp1_;
#line 1590 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	g_settings_set_int (_tmp0_, "brightness", _tmp2_);
#line 6601 "ui.c"
}


static void ___lambda10__gtk_adjustment_value_changed (GtkAdjustment* _sender, gpointer self) {
#line 1590 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	__lambda10_ ((UserInterface*) self);
#line 6608 "ui.c"
}


static void __lambda11_ (UserInterface* self) {
	GSettings* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
#line 1600 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp0_ = self->priv->settings;
#line 1600 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp1_ = user_interface_get_contrast (self);
#line 1600 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp2_ = _tmp1_;
#line 1600 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	g_settings_set_int (_tmp0_, "contrast", _tmp2_);
#line 6624 "ui.c"
}


static void ___lambda11__gtk_adjustment_value_changed (GtkAdjustment* _sender, gpointer self) {
#line 1600 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	__lambda11_ ((UserInterface*) self);
#line 6631 "ui.c"
}


static void __lambda12_ (UserInterface* self) {
	GSettings* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
#line 1610 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp0_ = self->priv->settings;
#line 1610 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp1_ = user_interface_get_quality (self);
#line 1610 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp2_ = _tmp1_;
#line 1610 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	g_settings_set_int (_tmp0_, "jpeg-quality", _tmp2_);
#line 6647 "ui.c"
}


static void ___lambda12__gtk_adjustment_value_changed (GtkAdjustment* _sender, gpointer self) {
#line 1610 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	__lambda12_ ((UserInterface*) self);
#line 6654 "ui.c"
}


static void _user_interface_page_selected_cb_book_view_page_selected (BookView* _sender, Page* page, gpointer self) {
#line 1619 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	user_interface_page_selected_cb ((UserInterface*) self, _sender, page);
#line 6661 "ui.c"
}


static void _user_interface_show_page_cb_book_view_show_page (BookView* _sender, Page* page, gpointer self) {
#line 1620 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	user_interface_show_page_cb ((UserInterface*) self, _sender, page);
#line 6668 "ui.c"
}


static void _user_interface_show_page_menu_cb_book_view_show_menu (BookView* _sender, gpointer self) {
#line 1621 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	user_interface_show_page_menu_cb ((UserInterface*) self, _sender);
#line 6675 "ui.c"
}


static void _user_interface_book_saving_cb_book_saving (Book* _sender, gint i, gpointer self) {
#line 1637 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	user_interface_book_saving_cb ((UserInterface*) self, i);
#line 6682 "ui.c"
}


static void user_interface_load (UserInterface* self) {
	GtkIconTheme* _tmp0_ = NULL;
	GtkApplication* app = NULL;
	GApplication* _tmp1_ = NULL;
	GtkApplication* _tmp2_ = NULL;
	GtkBuilder* _tmp3_ = NULL;
	GtkBuilder* _tmp12_ = NULL;
	GtkBuilder* _tmp13_ = NULL;
	GObject* _tmp14_ = NULL;
	GtkApplicationWindow* _tmp15_ = NULL;
	GtkApplication* _tmp16_ = NULL;
	GtkApplicationWindow* _tmp17_ = NULL;
	GtkBuilder* _tmp18_ = NULL;
	GObject* _tmp19_ = NULL;
	GtkMenuBar* _tmp20_ = NULL;
	GtkApplication* _tmp21_ = NULL;
	gboolean _tmp22_ = FALSE;
	GtkBuilder* _tmp30_ = NULL;
	GObject* _tmp31_ = NULL;
	GtkBox* _tmp32_ = NULL;
	GtkBuilder* _tmp33_ = NULL;
	GObject* _tmp34_ = NULL;
	GtkMenuItem* _tmp35_ = NULL;
	GtkBuilder* _tmp36_ = NULL;
	GObject* _tmp37_ = NULL;
	GtkMenuItem* _tmp38_ = NULL;
	GtkBuilder* _tmp39_ = NULL;
	GObject* _tmp40_ = NULL;
	GtkMenuItem* _tmp41_ = NULL;
	GtkBuilder* _tmp42_ = NULL;
	GObject* _tmp43_ = NULL;
	GtkMenuItem* _tmp44_ = NULL;
	GtkBuilder* _tmp45_ = NULL;
	GObject* _tmp46_ = NULL;
	GtkMenuItem* _tmp47_ = NULL;
	GtkBuilder* _tmp48_ = NULL;
	GObject* _tmp49_ = NULL;
	GtkMenuItem* _tmp50_ = NULL;
	GtkBuilder* _tmp51_ = NULL;
	GObject* _tmp52_ = NULL;
	GtkMenuItem* _tmp53_ = NULL;
	GtkBuilder* _tmp54_ = NULL;
	GObject* _tmp55_ = NULL;
	GtkToolButton* _tmp56_ = NULL;
	GtkBuilder* _tmp57_ = NULL;
	GObject* _tmp58_ = NULL;
	GtkMenuItem* _tmp59_ = NULL;
	GtkBuilder* _tmp60_ = NULL;
	GObject* _tmp61_ = NULL;
	GtkToolButton* _tmp62_ = NULL;
	GtkBuilder* _tmp63_ = NULL;
	GObject* _tmp64_ = NULL;
	GtkRadioMenuItem* _tmp65_ = NULL;
	GtkBuilder* _tmp66_ = NULL;
	GObject* _tmp67_ = NULL;
	GtkRadioMenuItem* _tmp68_ = NULL;
	GtkBuilder* _tmp69_ = NULL;
	GObject* _tmp70_ = NULL;
	GtkRadioMenuItem* _tmp71_ = NULL;
	GtkBuilder* _tmp72_ = NULL;
	GObject* _tmp73_ = NULL;
	GtkRadioMenuItem* _tmp74_ = NULL;
	GtkBuilder* _tmp75_ = NULL;
	GObject* _tmp76_ = NULL;
	GtkDialog* _tmp77_ = NULL;
	GtkBuilder* _tmp78_ = NULL;
	GObject* _tmp79_ = NULL;
	GtkLabel* _tmp80_ = NULL;
	GtkBuilder* _tmp81_ = NULL;
	GObject* _tmp82_ = NULL;
	GtkEntry* _tmp83_ = NULL;
	GtkBuilder* _tmp84_ = NULL;
	GObject* _tmp85_ = NULL;
	GtkEntry* _tmp86_ = NULL;
	GtkBuilder* _tmp87_ = NULL;
	GObject* _tmp88_ = NULL;
	GtkDialog* _tmp89_ = NULL;
	GtkBuilder* _tmp90_ = NULL;
	GObject* _tmp91_ = NULL;
	GtkComboBox* _tmp92_ = NULL;
	GtkComboBox* _tmp93_ = NULL;
	GtkTreeModel* _tmp94_ = NULL;
	GtkListStore* _tmp95_ = NULL;
	GtkBuilder* _tmp96_ = NULL;
	GObject* _tmp97_ = NULL;
	GtkComboBox* _tmp98_ = NULL;
	GtkComboBox* _tmp99_ = NULL;
	GtkTreeModel* _tmp100_ = NULL;
	GtkListStore* _tmp101_ = NULL;
	GtkBuilder* _tmp102_ = NULL;
	GObject* _tmp103_ = NULL;
	GtkComboBox* _tmp104_ = NULL;
	GtkComboBox* _tmp105_ = NULL;
	GtkTreeModel* _tmp106_ = NULL;
	GtkListStore* _tmp107_ = NULL;
	GtkBuilder* _tmp108_ = NULL;
	GObject* _tmp109_ = NULL;
	GtkComboBox* _tmp110_ = NULL;
	GtkComboBox* _tmp111_ = NULL;
	GtkTreeModel* _tmp112_ = NULL;
	GtkListStore* _tmp113_ = NULL;
	GtkBuilder* _tmp114_ = NULL;
	GObject* _tmp115_ = NULL;
	GtkComboBox* _tmp116_ = NULL;
	GtkComboBox* _tmp117_ = NULL;
	GtkTreeModel* _tmp118_ = NULL;
	GtkListStore* _tmp119_ = NULL;
	GtkBuilder* _tmp120_ = NULL;
	GObject* _tmp121_ = NULL;
	GtkScale* _tmp122_ = NULL;
	GtkScale* _tmp123_ = NULL;
	GtkAdjustment* _tmp124_ = NULL;
	GtkAdjustment* _tmp125_ = NULL;
	GtkBuilder* _tmp126_ = NULL;
	GObject* _tmp127_ = NULL;
	GtkScale* _tmp128_ = NULL;
	GtkScale* _tmp129_ = NULL;
	GtkAdjustment* _tmp130_ = NULL;
	GtkAdjustment* _tmp131_ = NULL;
	GtkBuilder* _tmp132_ = NULL;
	GObject* _tmp133_ = NULL;
	GtkScale* _tmp134_ = NULL;
	GtkScale* _tmp135_ = NULL;
	GtkAdjustment* _tmp136_ = NULL;
	GtkAdjustment* _tmp137_ = NULL;
	GtkInfoBar* _tmp138_ = NULL;
	GtkInfoBar* _tmp139_ = NULL;
	GtkBox* _tmp140_ = NULL;
	GtkInfoBar* _tmp141_ = NULL;
	GtkBox* hbox = NULL;
	GtkBox* _tmp142_ = NULL;
	GtkContainer* content_area = NULL;
	GtkInfoBar* _tmp143_ = NULL;
	GtkContainer* _tmp144_ = NULL;
	GtkContainer* _tmp145_ = NULL;
	GtkContainer* _tmp146_ = NULL;
	GtkBox* _tmp147_ = NULL;
	GtkBox* _tmp148_ = NULL;
	GtkImage* _tmp149_ = NULL;
	GtkBox* _tmp150_ = NULL;
	GtkImage* _tmp151_ = NULL;
	GtkImage* _tmp152_ = NULL;
	GtkLabel* _tmp153_ = NULL;
	GtkLabel* _tmp154_ = NULL;
	GtkBox* _tmp155_ = NULL;
	GtkLabel* _tmp156_ = NULL;
	GtkLabel* _tmp157_ = NULL;
	GtkInfoBar* _tmp158_ = NULL;
	const gchar* _tmp159_ = NULL;
	GtkButton* _tmp160_ = NULL;
	GtkButton* _tmp161_ = NULL;
	GtkInfoBar* _tmp162_ = NULL;
	const gchar* _tmp163_ = NULL;
	GtkButton* _tmp164_ = NULL;
	GtkButton* _tmp165_ = NULL;
	GtkTreeIter iter = {0};
	GtkListStore* _tmp166_ = NULL;
	GtkTreeIter _tmp167_ = {0};
	GtkListStore* _tmp168_ = NULL;
	GtkTreeIter _tmp169_ = {0};
	const gchar* _tmp170_ = NULL;
	GtkListStore* _tmp171_ = NULL;
	GtkTreeIter _tmp172_ = {0};
	GtkListStore* _tmp173_ = NULL;
	GtkTreeIter _tmp174_ = {0};
	GtkListStore* _tmp175_ = NULL;
	GtkTreeIter _tmp176_ = {0};
	GtkListStore* _tmp177_ = NULL;
	GtkTreeIter _tmp178_ = {0};
	GtkListStore* _tmp179_ = NULL;
	GtkTreeIter _tmp180_ = {0};
	GtkListStore* _tmp181_ = NULL;
	GtkTreeIter _tmp182_ = {0};
	GtkListStore* _tmp183_ = NULL;
	GtkTreeIter _tmp184_ = {0};
	GtkListStore* _tmp185_ = NULL;
	GtkTreeIter _tmp186_ = {0};
	GtkListStore* _tmp187_ = NULL;
	GtkTreeIter _tmp188_ = {0};
	GtkListStore* _tmp189_ = NULL;
	GtkTreeIter _tmp190_ = {0};
	GtkListStore* _tmp191_ = NULL;
	GtkTreeIter _tmp192_ = {0};
	GtkListStore* _tmp193_ = NULL;
	GtkTreeIter _tmp194_ = {0};
	gint dpi = 0;
	GSettings* _tmp195_ = NULL;
	gint _tmp196_ = 0;
	gint _tmp197_ = 0;
	GtkComboBox* _tmp198_ = NULL;
	gint _tmp199_ = 0;
	GtkComboBox* _tmp200_ = NULL;
	GSettings* _tmp201_ = NULL;
	gint _tmp202_ = 0;
	gint _tmp203_ = 0;
	GtkComboBox* _tmp204_ = NULL;
	gint _tmp205_ = 0;
	GtkComboBox* _tmp206_ = NULL;
	GtkCellRendererText* renderer = NULL;
	GtkCellRendererText* _tmp207_ = NULL;
	GtkComboBox* _tmp208_ = NULL;
	GtkCellRendererText* _tmp209_ = NULL;
	GtkComboBox* _tmp210_ = NULL;
	GtkCellRendererText* _tmp211_ = NULL;
	GtkCellRendererText* _tmp212_ = NULL;
	GtkComboBox* _tmp213_ = NULL;
	GtkCellRendererText* _tmp214_ = NULL;
	GtkComboBox* _tmp215_ = NULL;
	GtkCellRendererText* _tmp216_ = NULL;
	GSettings* _tmp217_ = NULL;
	gint _tmp218_ = 0;
	GtkComboBox* _tmp219_ = NULL;
	GtkCellRendererText* _tmp220_ = NULL;
	GtkComboBox* _tmp221_ = NULL;
	GtkCellRendererText* _tmp222_ = NULL;
	GtkComboBox* _tmp223_ = NULL;
	GtkCellRendererText* _tmp224_ = NULL;
	gint paper_width = 0;
	GSettings* _tmp225_ = NULL;
	gint _tmp226_ = 0;
	gint paper_height = 0;
	GSettings* _tmp227_ = NULL;
	gint _tmp228_ = 0;
	gint _tmp229_ = 0;
	gint _tmp230_ = 0;
	GtkComboBox* _tmp231_ = NULL;
	gdouble lower = 0.0;
	GtkAdjustment* _tmp232_ = NULL;
	gdouble _tmp233_ = 0.0;
	gchar* darker_label = NULL;
	const gchar* _tmp234_ = NULL;
	gchar* _tmp235_ = NULL;
	gdouble upper = 0.0;
	GtkAdjustment* _tmp236_ = NULL;
	gdouble _tmp237_ = 0.0;
	gchar* lighter_label = NULL;
	const gchar* _tmp238_ = NULL;
	gchar* _tmp239_ = NULL;
	GtkScale* _tmp240_ = NULL;
	gdouble _tmp241_ = 0.0;
	const gchar* _tmp242_ = NULL;
	GtkScale* _tmp243_ = NULL;
	GtkScale* _tmp244_ = NULL;
	gdouble _tmp245_ = 0.0;
	const gchar* _tmp246_ = NULL;
	GSettings* _tmp247_ = NULL;
	gint _tmp248_ = 0;
	GtkAdjustment* _tmp249_ = NULL;
	GtkAdjustment* _tmp250_ = NULL;
	gdouble _tmp251_ = 0.0;
	gchar* less_label = NULL;
	const gchar* _tmp252_ = NULL;
	gchar* _tmp253_ = NULL;
	GtkAdjustment* _tmp254_ = NULL;
	gdouble _tmp255_ = 0.0;
	gchar* more_label = NULL;
	const gchar* _tmp256_ = NULL;
	gchar* _tmp257_ = NULL;
	GtkScale* _tmp258_ = NULL;
	gdouble _tmp259_ = 0.0;
	const gchar* _tmp260_ = NULL;
	GtkScale* _tmp261_ = NULL;
	GtkScale* _tmp262_ = NULL;
	gdouble _tmp263_ = 0.0;
	const gchar* _tmp264_ = NULL;
	GSettings* _tmp265_ = NULL;
	gint _tmp266_ = 0;
	GtkAdjustment* _tmp267_ = NULL;
	GtkAdjustment* _tmp268_ = NULL;
	gdouble _tmp269_ = 0.0;
	gchar* minimum_label = NULL;
	const gchar* _tmp270_ = NULL;
	gchar* _tmp271_ = NULL;
	GtkAdjustment* _tmp272_ = NULL;
	gdouble _tmp273_ = 0.0;
	gchar* maximum_label = NULL;
	const gchar* _tmp274_ = NULL;
	gchar* _tmp275_ = NULL;
	GtkScale* _tmp276_ = NULL;
	gdouble _tmp277_ = 0.0;
	const gchar* _tmp278_ = NULL;
	GtkScale* _tmp279_ = NULL;
	GtkScale* _tmp280_ = NULL;
	gdouble _tmp281_ = 0.0;
	const gchar* _tmp282_ = NULL;
	GSettings* _tmp283_ = NULL;
	gint _tmp284_ = 0;
	GtkAdjustment* _tmp285_ = NULL;
	gchar* document_type = NULL;
	GSettings* _tmp286_ = NULL;
	gchar* _tmp287_ = NULL;
	const gchar* _tmp288_ = NULL;
	Book* _tmp290_ = NULL;
	BookView* _tmp291_ = NULL;
	BookView* _tmp292_ = NULL;
	GtkBox* _tmp293_ = NULL;
	BookView* _tmp294_ = NULL;
	BookView* _tmp295_ = NULL;
	BookView* _tmp296_ = NULL;
	BookView* _tmp297_ = NULL;
	BookView* _tmp298_ = NULL;
	gint _tmp299_ = 0;
	gint _tmp300_ = 0;
	GtkApplicationWindow* _tmp301_ = NULL;
	gint _tmp302_ = 0;
	gint _tmp303_ = 0;
	gboolean _tmp304_ = FALSE;
	GtkApplicationWindow* _tmp306_ = NULL;
	const gchar* _tmp307_ = NULL;
	ProgressBarDialog* _tmp308_ = NULL;
	Book* _tmp309_ = NULL;
	GError * _inner_error_ = NULL;
#line 1431 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	g_return_if_fail (self != NULL);
#line 1433 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp0_ = gtk_icon_theme_get_default ();
#line 1433 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	gtk_icon_theme_append_search_path (_tmp0_, ICON_DIR);
#line 1435 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	gtk_window_set_default_icon_name ("scanner");
#line 1437 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp1_ = g_application_get_default ();
#line 1437 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp2_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1_, gtk_application_get_type ()) ? ((GtkApplication*) _tmp1_) : NULL);
#line 1437 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	app = _tmp2_;
#line 1439 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp3_ = gtk_builder_new ();
#line 1439 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_g_object_unref0 (self->priv->builder);
#line 1439 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	self->priv->builder = _tmp3_;
#line 7018 "ui.c"
	{
		GtkBuilder* _tmp4_ = NULL;
		GtkApplication* _tmp5_ = NULL;
		gboolean _tmp6_ = FALSE;
#line 1442 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		_tmp4_ = self->priv->builder;
#line 1442 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		gtk_builder_add_from_resource (_tmp4_, "/org/gnome/SimpleScan/simple-scan.ui", &_inner_error_);
#line 1442 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 7029 "ui.c"
			goto __catch21_g_error;
		}
#line 1443 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		_tmp5_ = app;
#line 1443 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		_tmp6_ = user_interface_has_app_menu (self, _tmp5_);
#line 1443 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		if (_tmp6_) {
#line 7038 "ui.c"
			GtkBuilder* _tmp7_ = NULL;
#line 1444 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
			_tmp7_ = self->priv->builder;
#line 1444 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
			gtk_builder_add_from_resource (_tmp7_, "/org/gnome/SimpleScan/simple-scan-menu.ui", &_inner_error_);
#line 1444 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
			if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 7046 "ui.c"
				goto __catch21_g_error;
			}
		}
	}
	goto __finally21;
	__catch21_g_error:
	{
		GError* e = NULL;
		GError* _tmp8_ = NULL;
		const gchar* _tmp9_ = NULL;
		const gchar* _tmp10_ = NULL;
		const gchar* _tmp11_ = NULL;
#line 1440 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		e = _inner_error_;
#line 1440 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		_inner_error_ = NULL;
#line 1448 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		_tmp8_ = e;
#line 1448 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		_tmp9_ = _tmp8_->message;
#line 1448 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		g_critical ("ui.vala:1448: Unable to load UI: %s\n", _tmp9_);
#line 1449 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		_tmp10_ = _ ("Files missing");
#line 1449 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		_tmp11_ = _ ("Please check your installation");
#line 1449 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		user_interface_show_error_dialog (self, _tmp10_, _tmp11_);
#line 1453 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		exit (EXIT_FAILURE);
#line 1440 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		_g_error_free0 (e);
#line 7079 "ui.c"
	}
	__finally21:
#line 1440 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1440 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		_g_object_unref0 (app);
#line 1440 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1440 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		g_clear_error (&_inner_error_);
#line 1440 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		return;
#line 7092 "ui.c"
	}
#line 1455 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp12_ = self->priv->builder;
#line 1455 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	gtk_builder_connect_signals (_tmp12_, self);
#line 1457 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp13_ = self->priv->builder;
#line 1457 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp14_ = gtk_builder_get_object (_tmp13_, "simple_scan_window");
#line 1457 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp15_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp14_, gtk_application_window_get_type (), GtkApplicationWindow));
#line 1457 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_g_object_unref0 (self->priv->window);
#line 1457 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	self->priv->window = _tmp15_;
#line 1458 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp16_ = app;
#line 1458 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp17_ = self->priv->window;
#line 1458 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	gtk_application_add_window (_tmp16_, (GtkWindow*) _tmp17_);
#line 1459 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp18_ = self->priv->builder;
#line 1459 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp19_ = gtk_builder_get_object (_tmp18_, "menubar");
#line 1459 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp20_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp19_, gtk_menu_bar_get_type (), GtkMenuBar));
#line 1459 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_g_object_unref0 (self->priv->menubar);
#line 1459 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	self->priv->menubar = _tmp20_;
#line 1460 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp21_ = app;
#line 1460 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp22_ = user_interface_has_app_menu (self, _tmp21_);
#line 1460 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	if (_tmp22_) {
#line 7130 "ui.c"
		GtkBuilder* _tmp23_ = NULL;
		GObject* _tmp24_ = NULL;
		GMenuModel* _tmp25_ = NULL;
		GtkApplication* _tmp26_ = NULL;
		GtkApplication* _tmp27_ = NULL;
		GMenuModel* _tmp28_ = NULL;
		GtkMenuBar* _tmp29_ = NULL;
#line 1462 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		_tmp23_ = self->priv->builder;
#line 1462 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		_tmp24_ = gtk_builder_get_object (_tmp23_, "appmenu");
#line 1462 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		_tmp25_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp24_, g_menu_model_get_type (), GMenuModel));
#line 1462 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		_g_object_unref0 (self->priv->app_menu);
#line 1462 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		self->priv->app_menu = _tmp25_;
#line 1463 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		_tmp26_ = app;
#line 1463 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		g_action_map_add_action_entries ((GActionMap*) _tmp26_, USER_INTERFACE_action_entries, G_N_ELEMENTS (USER_INTERFACE_action_entries), self);
#line 1464 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		_tmp27_ = app;
#line 1464 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		_tmp28_ = self->priv->app_menu;
#line 1464 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		gtk_application_set_app_menu (_tmp27_, _tmp28_);
#line 1465 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		_tmp29_ = self->priv->menubar;
#line 1465 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		gtk_widget_set_visible ((GtkWidget*) _tmp29_, FALSE);
#line 7162 "ui.c"
	}
#line 1467 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp30_ = self->priv->builder;
#line 1467 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp31_ = gtk_builder_get_object (_tmp30_, "main_vbox");
#line 1467 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp32_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp31_, gtk_box_get_type (), GtkBox));
#line 1467 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_g_object_unref0 (self->priv->main_vbox);
#line 1467 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	self->priv->main_vbox = _tmp32_;
#line 1468 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp33_ = self->priv->builder;
#line 1468 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp34_ = gtk_builder_get_object (_tmp33_, "page_move_left_menuitem");
#line 1468 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp35_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp34_, gtk_menu_item_get_type (), GtkMenuItem));
#line 1468 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_g_object_unref0 (self->priv->page_move_left_menuitem);
#line 1468 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	self->priv->page_move_left_menuitem = _tmp35_;
#line 1469 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp36_ = self->priv->builder;
#line 1469 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp37_ = gtk_builder_get_object (_tmp36_, "page_move_right_menuitem");
#line 1469 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp38_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp37_, gtk_menu_item_get_type (), GtkMenuItem));
#line 1469 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_g_object_unref0 (self->priv->page_move_right_menuitem);
#line 1469 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	self->priv->page_move_right_menuitem = _tmp38_;
#line 1470 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp39_ = self->priv->builder;
#line 1470 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp40_ = gtk_builder_get_object (_tmp39_, "page_delete_menuitem");
#line 1470 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp41_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp40_, gtk_menu_item_get_type (), GtkMenuItem));
#line 1470 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_g_object_unref0 (self->priv->page_delete_menuitem);
#line 1470 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	self->priv->page_delete_menuitem = _tmp41_;
#line 1471 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp42_ = self->priv->builder;
#line 1471 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp43_ = gtk_builder_get_object (_tmp42_, "crop_rotate_menuitem");
#line 1471 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp44_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp43_, gtk_menu_item_get_type (), GtkMenuItem));
#line 1471 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_g_object_unref0 (self->priv->crop_rotate_menuitem);
#line 1471 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	self->priv->crop_rotate_menuitem = _tmp44_;
#line 1472 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp45_ = self->priv->builder;
#line 1472 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp46_ = gtk_builder_get_object (_tmp45_, "save_menuitem");
#line 1472 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp47_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp46_, gtk_menu_item_get_type (), GtkMenuItem));
#line 1472 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_g_object_unref0 (self->priv->save_menuitem);
#line 1472 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	self->priv->save_menuitem = _tmp47_;
#line 1473 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp48_ = self->priv->builder;
#line 1473 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp49_ = gtk_builder_get_object (_tmp48_, "save_as_menuitem");
#line 1473 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp50_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp49_, gtk_menu_item_get_type (), GtkMenuItem));
#line 1473 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_g_object_unref0 (self->priv->save_as_menuitem);
#line 1473 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	self->priv->save_as_menuitem = _tmp50_;
#line 1474 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp51_ = self->priv->builder;
#line 1474 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp52_ = gtk_builder_get_object (_tmp51_, "copy_to_clipboard_menuitem");
#line 1474 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp53_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp52_, gtk_menu_item_get_type (), GtkMenuItem));
#line 1474 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_g_object_unref0 (self->priv->copy_to_clipboard_menuitem);
#line 1474 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	self->priv->copy_to_clipboard_menuitem = _tmp53_;
#line 1475 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp54_ = self->priv->builder;
#line 1475 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp55_ = gtk_builder_get_object (_tmp54_, "save_toolbutton");
#line 1475 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp56_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp55_, gtk_tool_button_get_type (), GtkToolButton));
#line 1475 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_g_object_unref0 (self->priv->save_toolbutton);
#line 1475 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	self->priv->save_toolbutton = _tmp56_;
#line 1476 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp57_ = self->priv->builder;
#line 1476 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp58_ = gtk_builder_get_object (_tmp57_, "stop_scan_menuitem");
#line 1476 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp59_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp58_, gtk_menu_item_get_type (), GtkMenuItem));
#line 1476 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_g_object_unref0 (self->priv->stop_menuitem);
#line 1476 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	self->priv->stop_menuitem = _tmp59_;
#line 1477 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp60_ = self->priv->builder;
#line 1477 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp61_ = gtk_builder_get_object (_tmp60_, "stop_toolbutton");
#line 1477 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp62_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp61_, gtk_tool_button_get_type (), GtkToolButton));
#line 1477 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_g_object_unref0 (self->priv->stop_toolbutton);
#line 1477 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	self->priv->stop_toolbutton = _tmp62_;
#line 1479 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp63_ = self->priv->builder;
#line 1479 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp64_ = gtk_builder_get_object (_tmp63_, "text_toolbutton_menuitem");
#line 1479 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp65_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp64_, gtk_radio_menu_item_get_type (), GtkRadioMenuItem));
#line 1479 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_g_object_unref0 (self->priv->text_toolbar_menuitem);
#line 1479 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	self->priv->text_toolbar_menuitem = _tmp65_;
#line 1480 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp66_ = self->priv->builder;
#line 1480 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp67_ = gtk_builder_get_object (_tmp66_, "text_menuitem");
#line 1480 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp68_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp67_, gtk_radio_menu_item_get_type (), GtkRadioMenuItem));
#line 1480 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_g_object_unref0 (self->priv->text_menu_menuitem);
#line 1480 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	self->priv->text_menu_menuitem = _tmp68_;
#line 1481 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp69_ = self->priv->builder;
#line 1481 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp70_ = gtk_builder_get_object (_tmp69_, "photo_toolbutton_menuitem");
#line 1481 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp71_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp70_, gtk_radio_menu_item_get_type (), GtkRadioMenuItem));
#line 1481 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_g_object_unref0 (self->priv->photo_toolbar_menuitem);
#line 1481 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	self->priv->photo_toolbar_menuitem = _tmp71_;
#line 1482 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp72_ = self->priv->builder;
#line 1482 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp73_ = gtk_builder_get_object (_tmp72_, "photo_menuitem");
#line 1482 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp74_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp73_, gtk_radio_menu_item_get_type (), GtkRadioMenuItem));
#line 1482 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_g_object_unref0 (self->priv->photo_menu_menuitem);
#line 1482 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	self->priv->photo_menu_menuitem = _tmp74_;
#line 1484 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp75_ = self->priv->builder;
#line 1484 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp76_ = gtk_builder_get_object (_tmp75_, "authorize_dialog");
#line 1484 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp77_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp76_, gtk_dialog_get_type (), GtkDialog));
#line 1484 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_g_object_unref0 (self->priv->authorize_dialog);
#line 1484 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	self->priv->authorize_dialog = _tmp77_;
#line 1485 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp78_ = self->priv->builder;
#line 1485 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp79_ = gtk_builder_get_object (_tmp78_, "authorize_label");
#line 1485 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp80_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp79_, gtk_label_get_type (), GtkLabel));
#line 1485 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_g_object_unref0 (self->priv->authorize_label);
#line 1485 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	self->priv->authorize_label = _tmp80_;
#line 1486 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp81_ = self->priv->builder;
#line 1486 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp82_ = gtk_builder_get_object (_tmp81_, "username_entry");
#line 1486 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp83_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp82_, gtk_entry_get_type (), GtkEntry));
#line 1486 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_g_object_unref0 (self->priv->username_entry);
#line 1486 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	self->priv->username_entry = _tmp83_;
#line 1487 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp84_ = self->priv->builder;
#line 1487 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp85_ = gtk_builder_get_object (_tmp84_, "password_entry");
#line 1487 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp86_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp85_, gtk_entry_get_type (), GtkEntry));
#line 1487 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_g_object_unref0 (self->priv->password_entry);
#line 1487 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	self->priv->password_entry = _tmp86_;
#line 1489 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp87_ = self->priv->builder;
#line 1489 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp88_ = gtk_builder_get_object (_tmp87_, "preferences_dialog");
#line 1489 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp89_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp88_, gtk_dialog_get_type (), GtkDialog));
#line 1489 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_g_object_unref0 (self->priv->preferences_dialog);
#line 1489 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	self->priv->preferences_dialog = _tmp89_;
#line 1490 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp90_ = self->priv->builder;
#line 1490 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp91_ = gtk_builder_get_object (_tmp90_, "device_combo");
#line 1490 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp92_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp91_, gtk_combo_box_get_type (), GtkComboBox));
#line 1490 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_g_object_unref0 (self->priv->device_combo);
#line 1490 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	self->priv->device_combo = _tmp92_;
#line 1491 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp93_ = self->priv->device_combo;
#line 1491 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp94_ = gtk_combo_box_get_model (_tmp93_);
#line 1491 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp95_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp94_, gtk_list_store_get_type (), GtkListStore));
#line 1491 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_g_object_unref0 (self->priv->device_model);
#line 1491 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	self->priv->device_model = _tmp95_;
#line 1492 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp96_ = self->priv->builder;
#line 1492 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp97_ = gtk_builder_get_object (_tmp96_, "text_dpi_combo");
#line 1492 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp98_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp97_, gtk_combo_box_get_type (), GtkComboBox));
#line 1492 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_g_object_unref0 (self->priv->text_dpi_combo);
#line 1492 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	self->priv->text_dpi_combo = _tmp98_;
#line 1493 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp99_ = self->priv->text_dpi_combo;
#line 1493 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp100_ = gtk_combo_box_get_model (_tmp99_);
#line 1493 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp101_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp100_, gtk_list_store_get_type (), GtkListStore));
#line 1493 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_g_object_unref0 (self->priv->text_dpi_model);
#line 1493 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	self->priv->text_dpi_model = _tmp101_;
#line 1494 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp102_ = self->priv->builder;
#line 1494 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp103_ = gtk_builder_get_object (_tmp102_, "photo_dpi_combo");
#line 1494 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp104_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp103_, gtk_combo_box_get_type (), GtkComboBox));
#line 1494 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_g_object_unref0 (self->priv->photo_dpi_combo);
#line 1494 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	self->priv->photo_dpi_combo = _tmp104_;
#line 1495 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp105_ = self->priv->photo_dpi_combo;
#line 1495 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp106_ = gtk_combo_box_get_model (_tmp105_);
#line 1495 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp107_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp106_, gtk_list_store_get_type (), GtkListStore));
#line 1495 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_g_object_unref0 (self->priv->photo_dpi_model);
#line 1495 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	self->priv->photo_dpi_model = _tmp107_;
#line 1496 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp108_ = self->priv->builder;
#line 1496 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp109_ = gtk_builder_get_object (_tmp108_, "page_side_combo");
#line 1496 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp110_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp109_, gtk_combo_box_get_type (), GtkComboBox));
#line 1496 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_g_object_unref0 (self->priv->page_side_combo);
#line 1496 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	self->priv->page_side_combo = _tmp110_;
#line 1497 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp111_ = self->priv->page_side_combo;
#line 1497 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp112_ = gtk_combo_box_get_model (_tmp111_);
#line 1497 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp113_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp112_, gtk_list_store_get_type (), GtkListStore));
#line 1497 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_g_object_unref0 (self->priv->page_side_model);
#line 1497 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	self->priv->page_side_model = _tmp113_;
#line 1498 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp114_ = self->priv->builder;
#line 1498 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp115_ = gtk_builder_get_object (_tmp114_, "paper_size_combo");
#line 1498 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp116_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp115_, gtk_combo_box_get_type (), GtkComboBox));
#line 1498 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_g_object_unref0 (self->priv->paper_size_combo);
#line 1498 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	self->priv->paper_size_combo = _tmp116_;
#line 1499 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp117_ = self->priv->paper_size_combo;
#line 1499 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp118_ = gtk_combo_box_get_model (_tmp117_);
#line 1499 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp119_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp118_, gtk_list_store_get_type (), GtkListStore));
#line 1499 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_g_object_unref0 (self->priv->paper_size_model);
#line 1499 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	self->priv->paper_size_model = _tmp119_;
#line 1500 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp120_ = self->priv->builder;
#line 1500 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp121_ = gtk_builder_get_object (_tmp120_, "brightness_scale");
#line 1500 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp122_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp121_, gtk_scale_get_type (), GtkScale));
#line 1500 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_g_object_unref0 (self->priv->brightness_scale);
#line 1500 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	self->priv->brightness_scale = _tmp122_;
#line 1501 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp123_ = self->priv->brightness_scale;
#line 1501 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp124_ = gtk_range_get_adjustment ((GtkRange*) _tmp123_);
#line 1501 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp125_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp124_, gtk_adjustment_get_type (), GtkAdjustment));
#line 1501 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_g_object_unref0 (self->priv->brightness_adjustment);
#line 1501 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	self->priv->brightness_adjustment = _tmp125_;
#line 1502 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp126_ = self->priv->builder;
#line 1502 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp127_ = gtk_builder_get_object (_tmp126_, "contrast_scale");
#line 1502 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp128_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp127_, gtk_scale_get_type (), GtkScale));
#line 1502 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_g_object_unref0 (self->priv->contrast_scale);
#line 1502 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	self->priv->contrast_scale = _tmp128_;
#line 1503 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp129_ = self->priv->contrast_scale;
#line 1503 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp130_ = gtk_range_get_adjustment ((GtkRange*) _tmp129_);
#line 1503 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp131_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp130_, gtk_adjustment_get_type (), GtkAdjustment));
#line 1503 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_g_object_unref0 (self->priv->contrast_adjustment);
#line 1503 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	self->priv->contrast_adjustment = _tmp131_;
#line 1504 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp132_ = self->priv->builder;
#line 1504 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp133_ = gtk_builder_get_object (_tmp132_, "quality_scale");
#line 1504 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp134_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp133_, gtk_scale_get_type (), GtkScale));
#line 1504 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_g_object_unref0 (self->priv->quality_scale);
#line 1504 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	self->priv->quality_scale = _tmp134_;
#line 1505 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp135_ = self->priv->quality_scale;
#line 1505 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp136_ = gtk_range_get_adjustment ((GtkRange*) _tmp135_);
#line 1505 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp137_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp136_, gtk_adjustment_get_type (), GtkAdjustment));
#line 1505 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_g_object_unref0 (self->priv->quality_adjustment);
#line 1505 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	self->priv->quality_adjustment = _tmp137_;
#line 1508 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp138_ = (GtkInfoBar*) gtk_info_bar_new ();
#line 1508 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	g_object_ref_sink (_tmp138_);
#line 1508 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_g_object_unref0 (self->priv->info_bar);
#line 1508 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	self->priv->info_bar = _tmp138_;
#line 1509 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp139_ = self->priv->info_bar;
#line 1509 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	g_signal_connect (_tmp139_, "response", (GCallback) _user_interface_info_bar_response_cb_gtk_info_bar_response, self);
#line 1510 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp140_ = self->priv->main_vbox;
#line 1510 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp141_ = self->priv->info_bar;
#line 1510 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	gtk_box_pack_start (_tmp140_, (GtkWidget*) _tmp141_, FALSE, TRUE, (guint) 0);
#line 1511 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp142_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_HORIZONTAL, 12);
#line 1511 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	g_object_ref_sink (_tmp142_);
#line 1511 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	hbox = _tmp142_;
#line 1512 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp143_ = self->priv->info_bar;
#line 1512 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp144_ = gtk_info_bar_get_content_area (_tmp143_);
#line 1512 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp145_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp144_, gtk_container_get_type (), GtkContainer));
#line 1512 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	content_area = _tmp145_;
#line 1513 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp146_ = content_area;
#line 1513 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp147_ = hbox;
#line 1513 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	gtk_container_add (_tmp146_, (GtkWidget*) _tmp147_);
#line 1514 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp148_ = hbox;
#line 1514 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	gtk_widget_show ((GtkWidget*) _tmp148_);
#line 1516 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp149_ = (GtkImage*) gtk_image_new_from_icon_name ("dialog-warning", GTK_ICON_SIZE_DIALOG);
#line 1516 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	g_object_ref_sink (_tmp149_);
#line 1516 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_g_object_unref0 (self->priv->info_bar_image);
#line 1516 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	self->priv->info_bar_image = _tmp149_;
#line 1517 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp150_ = hbox;
#line 1517 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp151_ = self->priv->info_bar_image;
#line 1517 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	gtk_box_pack_start (_tmp150_, (GtkWidget*) _tmp151_, FALSE, TRUE, (guint) 0);
#line 1518 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp152_ = self->priv->info_bar_image;
#line 1518 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	gtk_widget_show ((GtkWidget*) _tmp152_);
#line 1520 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp153_ = (GtkLabel*) gtk_label_new (NULL);
#line 1520 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	g_object_ref_sink (_tmp153_);
#line 1520 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_g_object_unref0 (self->priv->info_bar_label);
#line 1520 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	self->priv->info_bar_label = _tmp153_;
#line 1521 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp154_ = self->priv->info_bar_label;
#line 1521 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	gtk_misc_set_alignment ((GtkMisc*) _tmp154_, 0.0f, 0.5f);
#line 1522 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp155_ = hbox;
#line 1522 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp156_ = self->priv->info_bar_label;
#line 1522 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	gtk_box_pack_start (_tmp155_, (GtkWidget*) _tmp156_, TRUE, TRUE, (guint) 0);
#line 1523 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp157_ = self->priv->info_bar_label;
#line 1523 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	gtk_widget_show ((GtkWidget*) _tmp157_);
#line 1525 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp158_ = self->priv->info_bar;
#line 1525 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp159_ = _ ("_Close");
#line 1525 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp160_ = gtk_info_bar_add_button (_tmp158_, _tmp159_, (gint) GTK_RESPONSE_CLOSE);
#line 1525 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp161_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp160_, gtk_button_get_type (), GtkButton));
#line 1525 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_g_object_unref0 (self->priv->info_bar_close_button);
#line 1525 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	self->priv->info_bar_close_button = _tmp161_;
#line 1526 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp162_ = self->priv->info_bar;
#line 1526 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp163_ = _ ("Change _Scanner");
#line 1526 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp164_ = gtk_info_bar_add_button (_tmp162_, _tmp163_, 1);
#line 1526 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp165_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp164_, gtk_button_get_type (), GtkButton));
#line 1526 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_g_object_unref0 (self->priv->info_bar_change_scanner_button);
#line 1526 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	self->priv->info_bar_change_scanner_button = _tmp165_;
#line 1530 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp166_ = self->priv->paper_size_model;
#line 1530 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	gtk_list_store_append (_tmp166_, &_tmp167_);
#line 1530 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	iter = _tmp167_;
#line 1531 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp168_ = self->priv->paper_size_model;
#line 1531 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp169_ = iter;
#line 1531 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp170_ = _ ("Automatic");
#line 1531 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	gtk_list_store_set (_tmp168_, &_tmp169_, 0, 0, 1, 0, 2, _tmp170_, -1, -1);
#line 1534 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp171_ = self->priv->paper_size_model;
#line 1534 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	gtk_list_store_append (_tmp171_, &_tmp172_);
#line 1534 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	iter = _tmp172_;
#line 1535 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp173_ = self->priv->paper_size_model;
#line 1535 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp174_ = iter;
#line 1535 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	gtk_list_store_set (_tmp173_, &_tmp174_, 0, 1050, 1, 1480, 2, "A6", -1, -1);
#line 1536 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp175_ = self->priv->paper_size_model;
#line 1536 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	gtk_list_store_append (_tmp175_, &_tmp176_);
#line 1536 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	iter = _tmp176_;
#line 1537 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp177_ = self->priv->paper_size_model;
#line 1537 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp178_ = iter;
#line 1537 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	gtk_list_store_set (_tmp177_, &_tmp178_, 0, 1480, 1, 2100, 2, "A5", -1, -1);
#line 1538 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp179_ = self->priv->paper_size_model;
#line 1538 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	gtk_list_store_append (_tmp179_, &_tmp180_);
#line 1538 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	iter = _tmp180_;
#line 1539 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp181_ = self->priv->paper_size_model;
#line 1539 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp182_ = iter;
#line 1539 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	gtk_list_store_set (_tmp181_, &_tmp182_, 0, 2100, 1, 2970, 2, "A4", -1, -1);
#line 1540 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp183_ = self->priv->paper_size_model;
#line 1540 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	gtk_list_store_append (_tmp183_, &_tmp184_);
#line 1540 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	iter = _tmp184_;
#line 1541 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp185_ = self->priv->paper_size_model;
#line 1541 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp186_ = iter;
#line 1541 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	gtk_list_store_set (_tmp185_, &_tmp186_, 0, 2159, 1, 2794, 2, "Letter", -1, -1);
#line 1542 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp187_ = self->priv->paper_size_model;
#line 1542 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	gtk_list_store_append (_tmp187_, &_tmp188_);
#line 1542 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	iter = _tmp188_;
#line 1543 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp189_ = self->priv->paper_size_model;
#line 1543 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp190_ = iter;
#line 1543 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	gtk_list_store_set (_tmp189_, &_tmp190_, 0, 2159, 1, 3556, 2, "Legal", -1, -1);
#line 1544 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp191_ = self->priv->paper_size_model;
#line 1544 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	gtk_list_store_append (_tmp191_, &_tmp192_);
#line 1544 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	iter = _tmp192_;
#line 1545 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp193_ = self->priv->paper_size_model;
#line 1545 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp194_ = iter;
#line 1545 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	gtk_list_store_set (_tmp193_, &_tmp194_, 0, 1016, 1, 1524, 2, "4×6", -1, -1);
#line 1547 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp195_ = self->priv->settings;
#line 1547 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp196_ = g_settings_get_int (_tmp195_, "text-dpi");
#line 1547 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	dpi = _tmp196_;
#line 1548 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp197_ = dpi;
#line 1548 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	if (_tmp197_ <= 0) {
#line 1549 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		dpi = USER_INTERFACE_DEFAULT_TEXT_DPI;
#line 7728 "ui.c"
	}
#line 1550 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp198_ = self->priv->text_dpi_combo;
#line 1550 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp199_ = dpi;
#line 1550 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	user_interface_set_dpi_combo (self, _tmp198_, USER_INTERFACE_DEFAULT_TEXT_DPI, _tmp199_);
#line 1551 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp200_ = self->priv->text_dpi_combo;
#line 1551 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	g_signal_connect (_tmp200_, "changed", (GCallback) ___lambda6__gtk_combo_box_changed, self);
#line 1552 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp201_ = self->priv->settings;
#line 1552 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp202_ = g_settings_get_int (_tmp201_, "photo-dpi");
#line 1552 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	dpi = _tmp202_;
#line 1553 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp203_ = dpi;
#line 1553 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	if (_tmp203_ <= 0) {
#line 1554 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		dpi = USER_INTERFACE_DEFAULT_PHOTO_DPI;
#line 7752 "ui.c"
	}
#line 1555 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp204_ = self->priv->photo_dpi_combo;
#line 1555 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp205_ = dpi;
#line 1555 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	user_interface_set_dpi_combo (self, _tmp204_, USER_INTERFACE_DEFAULT_PHOTO_DPI, _tmp205_);
#line 1556 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp206_ = self->priv->photo_dpi_combo;
#line 1556 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	g_signal_connect (_tmp206_, "changed", (GCallback) ___lambda7__gtk_combo_box_changed, self);
#line 1558 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp207_ = (GtkCellRendererText*) gtk_cell_renderer_text_new ();
#line 1558 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	g_object_ref_sink (_tmp207_);
#line 1558 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	renderer = _tmp207_;
#line 1559 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp208_ = self->priv->device_combo;
#line 1559 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp209_ = renderer;
#line 1559 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	gtk_cell_layout_pack_start ((GtkCellLayout*) _tmp208_, (GtkCellRenderer*) _tmp209_, TRUE);
#line 1560 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp210_ = self->priv->device_combo;
#line 1560 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp211_ = renderer;
#line 1560 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	gtk_cell_layout_add_attribute ((GtkCellLayout*) _tmp210_, (GtkCellRenderer*) _tmp211_, "text", 1);
#line 1562 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp212_ = (GtkCellRendererText*) gtk_cell_renderer_text_new ();
#line 1562 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	g_object_ref_sink (_tmp212_);
#line 1562 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_g_object_unref0 (renderer);
#line 1562 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	renderer = _tmp212_;
#line 1563 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp213_ = self->priv->page_side_combo;
#line 1563 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp214_ = renderer;
#line 1563 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	gtk_cell_layout_pack_start ((GtkCellLayout*) _tmp213_, (GtkCellRenderer*) _tmp214_, TRUE);
#line 1564 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp215_ = self->priv->page_side_combo;
#line 1564 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp216_ = renderer;
#line 1564 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	gtk_cell_layout_add_attribute ((GtkCellLayout*) _tmp215_, (GtkCellRenderer*) _tmp216_, "text", 1);
#line 1565 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp217_ = self->priv->settings;
#line 1565 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp218_ = g_settings_get_enum (_tmp217_, "page-side");
#line 1565 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	user_interface_set_page_side (self, (ScanType) _tmp218_);
#line 1566 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp219_ = self->priv->page_side_combo;
#line 1566 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	g_signal_connect (_tmp219_, "changed", (GCallback) ___lambda8__gtk_combo_box_changed, self);
#line 1568 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp220_ = (GtkCellRendererText*) gtk_cell_renderer_text_new ();
#line 1568 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	g_object_ref_sink (_tmp220_);
#line 1568 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_g_object_unref0 (renderer);
#line 1568 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	renderer = _tmp220_;
#line 1569 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp221_ = self->priv->paper_size_combo;
#line 1569 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp222_ = renderer;
#line 1569 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	gtk_cell_layout_pack_start ((GtkCellLayout*) _tmp221_, (GtkCellRenderer*) _tmp222_, TRUE);
#line 1570 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp223_ = self->priv->paper_size_combo;
#line 1570 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp224_ = renderer;
#line 1570 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	gtk_cell_layout_add_attribute ((GtkCellLayout*) _tmp223_, (GtkCellRenderer*) _tmp224_, "text", 2);
#line 1571 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp225_ = self->priv->settings;
#line 1571 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp226_ = g_settings_get_int (_tmp225_, "paper-width");
#line 1571 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	paper_width = _tmp226_;
#line 1572 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp227_ = self->priv->settings;
#line 1572 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp228_ = g_settings_get_int (_tmp227_, "paper-height");
#line 1572 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	paper_height = _tmp228_;
#line 1573 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp229_ = paper_width;
#line 1573 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp230_ = paper_height;
#line 1573 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	user_interface_set_paper_size (self, _tmp229_, _tmp230_);
#line 1574 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp231_ = self->priv->paper_size_combo;
#line 1574 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	g_signal_connect (_tmp231_, "changed", (GCallback) ___lambda9__gtk_combo_box_changed, self);
#line 1582 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp232_ = self->priv->brightness_adjustment;
#line 1582 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp233_ = gtk_adjustment_get_lower (_tmp232_);
#line 1582 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	lower = _tmp233_;
#line 1583 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp234_ = _ ("Darker");
#line 1583 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp235_ = g_strdup_printf ("<small>%s</small>", _tmp234_);
#line 1583 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	darker_label = _tmp235_;
#line 1584 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp236_ = self->priv->brightness_adjustment;
#line 1584 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp237_ = gtk_adjustment_get_upper (_tmp236_);
#line 1584 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	upper = _tmp237_;
#line 1585 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp238_ = _ ("Lighter");
#line 1585 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp239_ = g_strdup_printf ("<small>%s</small>", _tmp238_);
#line 1585 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	lighter_label = _tmp239_;
#line 1586 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp240_ = self->priv->brightness_scale;
#line 1586 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp241_ = lower;
#line 1586 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp242_ = darker_label;
#line 1586 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	gtk_scale_add_mark (_tmp240_, _tmp241_, GTK_POS_BOTTOM, _tmp242_);
#line 1587 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp243_ = self->priv->brightness_scale;
#line 1587 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	gtk_scale_add_mark (_tmp243_, (gdouble) 0, GTK_POS_BOTTOM, NULL);
#line 1588 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp244_ = self->priv->brightness_scale;
#line 1588 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp245_ = upper;
#line 1588 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp246_ = lighter_label;
#line 1588 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	gtk_scale_add_mark (_tmp244_, _tmp245_, GTK_POS_BOTTOM, _tmp246_);
#line 1589 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp247_ = self->priv->settings;
#line 1589 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp248_ = g_settings_get_int (_tmp247_, "brightness");
#line 1589 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	user_interface_set_brightness (self, _tmp248_);
#line 1590 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp249_ = self->priv->brightness_adjustment;
#line 1590 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	g_signal_connect (_tmp249_, "value-changed", (GCallback) ___lambda10__gtk_adjustment_value_changed, self);
#line 1592 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp250_ = self->priv->contrast_adjustment;
#line 1592 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp251_ = gtk_adjustment_get_lower (_tmp250_);
#line 1592 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	lower = _tmp251_;
#line 1593 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp252_ = _ ("Less");
#line 1593 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp253_ = g_strdup_printf ("<small>%s</small>", _tmp252_);
#line 1593 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	less_label = _tmp253_;
#line 1594 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp254_ = self->priv->contrast_adjustment;
#line 1594 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp255_ = gtk_adjustment_get_upper (_tmp254_);
#line 1594 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	upper = _tmp255_;
#line 1595 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp256_ = _ ("More");
#line 1595 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp257_ = g_strdup_printf ("<small>%s</small>", _tmp256_);
#line 1595 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	more_label = _tmp257_;
#line 1596 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp258_ = self->priv->contrast_scale;
#line 1596 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp259_ = lower;
#line 1596 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp260_ = less_label;
#line 1596 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	gtk_scale_add_mark (_tmp258_, _tmp259_, GTK_POS_BOTTOM, _tmp260_);
#line 1597 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp261_ = self->priv->contrast_scale;
#line 1597 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	gtk_scale_add_mark (_tmp261_, (gdouble) 0, GTK_POS_BOTTOM, NULL);
#line 1598 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp262_ = self->priv->contrast_scale;
#line 1598 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp263_ = upper;
#line 1598 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp264_ = more_label;
#line 1598 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	gtk_scale_add_mark (_tmp262_, _tmp263_, GTK_POS_BOTTOM, _tmp264_);
#line 1599 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp265_ = self->priv->settings;
#line 1599 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp266_ = g_settings_get_int (_tmp265_, "contrast");
#line 1599 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	user_interface_set_contrast (self, _tmp266_);
#line 1600 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp267_ = self->priv->contrast_adjustment;
#line 1600 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	g_signal_connect (_tmp267_, "value-changed", (GCallback) ___lambda11__gtk_adjustment_value_changed, self);
#line 1602 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp268_ = self->priv->quality_adjustment;
#line 1602 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp269_ = gtk_adjustment_get_lower (_tmp268_);
#line 1602 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	lower = _tmp269_;
#line 1603 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp270_ = _ ("Minimum");
#line 1603 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp271_ = g_strdup_printf ("<small>%s</small>", _tmp270_);
#line 1603 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	minimum_label = _tmp271_;
#line 1604 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp272_ = self->priv->quality_adjustment;
#line 1604 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp273_ = gtk_adjustment_get_upper (_tmp272_);
#line 1604 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	upper = _tmp273_;
#line 1605 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp274_ = _ ("Maximum");
#line 1605 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp275_ = g_strdup_printf ("<small>%s</small>", _tmp274_);
#line 1605 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	maximum_label = _tmp275_;
#line 1606 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp276_ = self->priv->quality_scale;
#line 1606 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp277_ = lower;
#line 1606 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp278_ = minimum_label;
#line 1606 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	gtk_scale_add_mark (_tmp276_, _tmp277_, GTK_POS_BOTTOM, _tmp278_);
#line 1607 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp279_ = self->priv->quality_scale;
#line 1607 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	gtk_scale_add_mark (_tmp279_, (gdouble) 75, GTK_POS_BOTTOM, NULL);
#line 1608 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp280_ = self->priv->quality_scale;
#line 1608 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp281_ = upper;
#line 1608 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp282_ = maximum_label;
#line 1608 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	gtk_scale_add_mark (_tmp280_, _tmp281_, GTK_POS_BOTTOM, _tmp282_);
#line 1609 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp283_ = self->priv->settings;
#line 1609 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp284_ = g_settings_get_int (_tmp283_, "jpeg-quality");
#line 1609 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	user_interface_set_quality (self, _tmp284_);
#line 1610 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp285_ = self->priv->quality_adjustment;
#line 1610 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	g_signal_connect (_tmp285_, "value-changed", (GCallback) ___lambda12__gtk_adjustment_value_changed, self);
#line 1612 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp286_ = self->priv->settings;
#line 1612 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp287_ = g_settings_get_string (_tmp286_, "document-type");
#line 1612 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	document_type = _tmp287_;
#line 1613 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp288_ = document_type;
#line 1613 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	if (_tmp288_ != NULL) {
#line 8026 "ui.c"
		const gchar* _tmp289_ = NULL;
#line 1614 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		_tmp289_ = document_type;
#line 1614 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		user_interface_set_document_hint (self, _tmp289_, FALSE);
#line 8032 "ui.c"
	}
#line 1616 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp290_ = self->priv->_book;
#line 1616 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp291_ = book_view_new (_tmp290_);
#line 1616 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	g_object_ref_sink (_tmp291_);
#line 1616 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_g_object_unref0 (self->priv->book_view);
#line 1616 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	self->priv->book_view = _tmp291_;
#line 1617 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp292_ = self->priv->book_view;
#line 1617 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	gtk_container_set_border_width ((GtkContainer*) _tmp292_, (guint) 18);
#line 1618 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp293_ = self->priv->main_vbox;
#line 1618 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp294_ = self->priv->book_view;
#line 1618 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	gtk_box_pack_end (_tmp293_, (GtkWidget*) _tmp294_, TRUE, TRUE, (guint) 0);
#line 1619 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp295_ = self->priv->book_view;
#line 1619 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	g_signal_connect (_tmp295_, "page-selected", (GCallback) _user_interface_page_selected_cb_book_view_page_selected, self);
#line 1620 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp296_ = self->priv->book_view;
#line 1620 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	g_signal_connect (_tmp296_, "show-page", (GCallback) _user_interface_show_page_cb_book_view_show_page, self);
#line 1621 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp297_ = self->priv->book_view;
#line 1621 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	g_signal_connect (_tmp297_, "show-menu", (GCallback) _user_interface_show_page_menu_cb_book_view_show_menu, self);
#line 1622 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp298_ = self->priv->book_view;
#line 1622 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	gtk_widget_show ((GtkWidget*) _tmp298_);
#line 1625 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	user_interface_load_state (self);
#line 1628 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp299_ = self->priv->window_width;
#line 1628 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp300_ = self->priv->window_height;
#line 1628 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	g_debug ("ui.vala:1628: Restoring window to %dx%d pixels", _tmp299_, _tmp300_);
#line 1629 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp301_ = self->priv->window;
#line 1629 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp302_ = self->priv->window_width;
#line 1629 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp303_ = self->priv->window_height;
#line 1629 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	gtk_window_set_default_size ((GtkWindow*) _tmp301_, _tmp302_, _tmp303_);
#line 1630 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp304_ = self->priv->window_is_maximized;
#line 1630 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	if (_tmp304_) {
#line 8090 "ui.c"
		GtkApplicationWindow* _tmp305_ = NULL;
#line 1632 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		g_debug ("ui.vala:1632: Restoring window to maximized");
#line 1633 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		_tmp305_ = self->priv->window;
#line 1633 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		gtk_window_maximize ((GtkWindow*) _tmp305_);
#line 8098 "ui.c"
	}
#line 1636 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp306_ = self->priv->window;
#line 1636 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp307_ = _ ("Saving document...");
#line 1636 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp308_ = progress_bar_dialog_new (_tmp306_, _tmp307_);
#line 1636 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	g_object_ref_sink (_tmp308_);
#line 1636 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_g_object_unref0 (self->priv->progress_dialog);
#line 1636 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	self->priv->progress_dialog = _tmp308_;
#line 1637 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp309_ = self->priv->_book;
#line 1637 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	g_signal_connect (_tmp309_, "saving", (GCallback) _user_interface_book_saving_cb_book_saving, self);
#line 1431 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_g_free0 (document_type);
#line 1431 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_g_free0 (maximum_label);
#line 1431 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_g_free0 (minimum_label);
#line 1431 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_g_free0 (more_label);
#line 1431 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_g_free0 (less_label);
#line 1431 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_g_free0 (lighter_label);
#line 1431 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_g_free0 (darker_label);
#line 1431 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_g_object_unref0 (renderer);
#line 1431 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_g_object_unref0 (content_area);
#line 1431 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_g_object_unref0 (hbox);
#line 1431 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_g_object_unref0 (app);
#line 8138 "ui.c"
}


static void user_interface_load_state (UserInterface* self) {
	gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	GKeyFile* f = NULL;
	GKeyFile* _tmp3_ = NULL;
	GKeyFile* _tmp11_ = NULL;
	gint _tmp12_ = 0;
	gint _tmp13_ = 0;
	GKeyFile* _tmp14_ = NULL;
	gint _tmp15_ = 0;
	gint _tmp16_ = 0;
	GKeyFile* _tmp17_ = NULL;
	gboolean _tmp18_ = FALSE;
	GKeyFile* _tmp19_ = NULL;
	gint _tmp20_ = 0;
	GKeyFile* _tmp21_ = NULL;
	gint _tmp22_ = 0;
	GKeyFile* _tmp23_ = NULL;
	gint _tmp24_ = 0;
	GKeyFile* _tmp25_ = NULL;
	gchar* _tmp26_ = NULL;
	gchar* _tmp27_ = NULL;
	GQuark _tmp29_ = 0U;
#line 1669 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	static GQuark _tmp28_label0 = 0;
#line 1669 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	static GQuark _tmp28_label1 = 0;
#line 1669 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	static GQuark _tmp28_label2 = 0;
#line 8172 "ui.c"
	GError * _inner_error_ = NULL;
#line 1645 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	g_return_if_fail (self != NULL);
#line 1647 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp0_ = user_interface_get_state_filename (self);
#line 1647 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp1_ = _tmp0_;
#line 1647 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp2_ = _tmp1_;
#line 1647 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	g_debug ("ui.vala:1647: Loading state from %s", _tmp2_);
#line 1647 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_g_free0 (_tmp2_);
#line 1649 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp3_ = g_key_file_new ();
#line 1649 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	f = _tmp3_;
#line 8190 "ui.c"
	{
		GKeyFile* _tmp4_ = NULL;
		gchar* _tmp5_ = NULL;
		gchar* _tmp6_ = NULL;
		gchar* _tmp7_ = NULL;
#line 1652 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		_tmp4_ = f;
#line 1652 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		_tmp5_ = user_interface_get_state_filename (self);
#line 1652 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		_tmp6_ = _tmp5_;
#line 1652 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		_tmp7_ = _tmp6_;
#line 1652 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		g_key_file_load_from_file (_tmp4_, _tmp7_, G_KEY_FILE_NONE, &_inner_error_);
#line 1652 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		_g_free0 (_tmp7_);
#line 1652 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 8210 "ui.c"
			goto __catch22_g_error;
		}
	}
	goto __finally22;
	__catch22_g_error:
	{
		GError* e = NULL;
		GError* _tmp8_ = NULL;
#line 1650 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		e = _inner_error_;
#line 1650 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		_inner_error_ = NULL;
#line 1656 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		_tmp8_ = e;
#line 1656 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		if (!g_error_matches (_tmp8_, G_FILE_ERROR, G_FILE_ERROR_NOENT)) {
#line 8227 "ui.c"
			GError* _tmp9_ = NULL;
			const gchar* _tmp10_ = NULL;
#line 1657 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
			_tmp9_ = e;
#line 1657 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
			_tmp10_ = _tmp9_->message;
#line 1657 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
			g_warning ("ui.vala:1657: Failed to load state: %s", _tmp10_);
#line 8236 "ui.c"
		}
#line 1650 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		_g_error_free0 (e);
#line 8240 "ui.c"
	}
	__finally22:
#line 1650 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1650 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		_g_key_file_unref0 (f);
#line 1650 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1650 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		g_clear_error (&_inner_error_);
#line 1650 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		return;
#line 8253 "ui.c"
	}
#line 1659 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp11_ = f;
#line 1659 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp12_ = user_interface_state_get_integer (self, _tmp11_, "window", "width", 600);
#line 1659 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	self->priv->window_width = _tmp12_;
#line 1660 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp13_ = self->priv->window_width;
#line 1660 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	if (_tmp13_ <= 0) {
#line 1661 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		self->priv->window_width = 600;
#line 8267 "ui.c"
	}
#line 1662 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp14_ = f;
#line 1662 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp15_ = user_interface_state_get_integer (self, _tmp14_, "window", "height", 400);
#line 1662 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	self->priv->window_height = _tmp15_;
#line 1663 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp16_ = self->priv->window_height;
#line 1663 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	if (_tmp16_ <= 0) {
#line 1664 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		self->priv->window_height = 400;
#line 8281 "ui.c"
	}
#line 1665 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp17_ = f;
#line 1665 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp18_ = user_interface_state_get_boolean (self, _tmp17_, "window", "is-maximized", FALSE);
#line 1665 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	self->priv->window_is_maximized = _tmp18_;
#line 1666 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp19_ = f;
#line 1666 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp20_ = user_interface_state_get_integer (self, _tmp19_, "last-page", "width", 595);
#line 1666 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	self->priv->default_page_width = _tmp20_;
#line 1667 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp21_ = f;
#line 1667 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp22_ = user_interface_state_get_integer (self, _tmp21_, "last-page", "height", 842);
#line 1667 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	self->priv->default_page_height = _tmp22_;
#line 1668 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp23_ = f;
#line 1668 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp24_ = user_interface_state_get_integer (self, _tmp23_, "last-page", "dpi", 72);
#line 1668 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	self->priv->default_page_dpi = _tmp24_;
#line 1669 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp25_ = f;
#line 1669 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp26_ = user_interface_state_get_string (self, _tmp25_, "last-page", "scan-direction", "top-to-bottom");
#line 1669 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp27_ = _tmp26_;
#line 1669 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp29_ = (NULL == _tmp27_) ? 0 : g_quark_from_string (_tmp27_);
#line 1669 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	g_free (_tmp27_);
#line 1669 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	if (_tmp29_ == ((0 != _tmp28_label0) ? _tmp28_label0 : (_tmp28_label0 = g_quark_from_static_string ("bottom-to-top")))) {
#line 1669 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		switch (0) {
#line 8321 "ui.c"
			default:
			{
#line 1676 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
				self->priv->default_page_scan_direction = SCAN_DIRECTION_BOTTOM_TO_TOP;
#line 1677 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
				break;
#line 8328 "ui.c"
			}
		}
	} else if (_tmp29_ == ((0 != _tmp28_label1) ? _tmp28_label1 : (_tmp28_label1 = g_quark_from_static_string ("left-to-right")))) {
#line 1669 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		switch (0) {
#line 8334 "ui.c"
			default:
			{
#line 1679 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
				self->priv->default_page_scan_direction = SCAN_DIRECTION_LEFT_TO_RIGHT;
#line 1680 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
				break;
#line 8341 "ui.c"
			}
		}
	} else if (_tmp29_ == ((0 != _tmp28_label2) ? _tmp28_label2 : (_tmp28_label2 = g_quark_from_static_string ("right-to-left")))) {
#line 1669 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		switch (0) {
#line 8347 "ui.c"
			default:
			{
#line 1682 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
				self->priv->default_page_scan_direction = SCAN_DIRECTION_RIGHT_TO_LEFT;
#line 1683 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
				break;
#line 8354 "ui.c"
			}
		}
	} else {
#line 1669 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		switch (0) {
#line 8360 "ui.c"
			default:
			{
#line 1673 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
				self->priv->default_page_scan_direction = SCAN_DIRECTION_TOP_TO_BOTTOM;
#line 1674 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
				break;
#line 8367 "ui.c"
			}
		}
	}
#line 1645 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_g_key_file_unref0 (f);
#line 8373 "ui.c"
}


static gint user_interface_state_get_integer (UserInterface* self, GKeyFile* f, const gchar* group_name, const gchar* key, gint _default_) {
	gint result = 0;
	GError * _inner_error_ = NULL;
#line 1687 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 1687 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	g_return_val_if_fail (f != NULL, 0);
#line 1687 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	g_return_val_if_fail (group_name != NULL, 0);
#line 1687 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	g_return_val_if_fail (key != NULL, 0);
#line 8388 "ui.c"
	{
		gint _tmp0_ = 0;
		GKeyFile* _tmp1_ = NULL;
		const gchar* _tmp2_ = NULL;
		const gchar* _tmp3_ = NULL;
		gint _tmp4_ = 0;
#line 1691 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		_tmp1_ = f;
#line 1691 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		_tmp2_ = group_name;
#line 1691 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		_tmp3_ = key;
#line 1691 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		_tmp4_ = g_key_file_get_integer (_tmp1_, _tmp2_, _tmp3_, &_inner_error_);
#line 1691 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		_tmp0_ = _tmp4_;
#line 1691 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 8407 "ui.c"
			goto __catch23_g_error;
		}
#line 1691 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		result = _tmp0_;
#line 1691 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		return result;
#line 8414 "ui.c"
	}
	goto __finally23;
	__catch23_g_error:
	{
		gint _tmp5_ = 0;
#line 1689 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		g_clear_error (&_inner_error_);
#line 1689 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		_inner_error_ = NULL;
#line 1695 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		_tmp5_ = _default_;
#line 1695 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		result = _tmp5_;
#line 1695 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		return result;
#line 8430 "ui.c"
	}
	__finally23:
#line 1689 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1689 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	g_clear_error (&_inner_error_);
#line 1689 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	return 0;
#line 8439 "ui.c"
}


static gboolean user_interface_state_get_boolean (UserInterface* self, GKeyFile* f, const gchar* group_name, const gchar* key, gboolean _default_) {
	gboolean result = FALSE;
	GError * _inner_error_ = NULL;
#line 1699 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 1699 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	g_return_val_if_fail (f != NULL, FALSE);
#line 1699 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	g_return_val_if_fail (group_name != NULL, FALSE);
#line 1699 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	g_return_val_if_fail (key != NULL, FALSE);
#line 8454 "ui.c"
	{
		gboolean _tmp0_ = FALSE;
		GKeyFile* _tmp1_ = NULL;
		const gchar* _tmp2_ = NULL;
		const gchar* _tmp3_ = NULL;
		gboolean _tmp4_ = FALSE;
#line 1703 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		_tmp1_ = f;
#line 1703 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		_tmp2_ = group_name;
#line 1703 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		_tmp3_ = key;
#line 1703 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		_tmp4_ = g_key_file_get_boolean (_tmp1_, _tmp2_, _tmp3_, &_inner_error_);
#line 1703 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		_tmp0_ = _tmp4_;
#line 1703 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 8473 "ui.c"
			goto __catch24_g_error;
		}
#line 1703 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		result = _tmp0_;
#line 1703 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		return result;
#line 8480 "ui.c"
	}
	goto __finally24;
	__catch24_g_error:
	{
		gboolean _tmp5_ = FALSE;
#line 1701 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		g_clear_error (&_inner_error_);
#line 1701 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		_inner_error_ = NULL;
#line 1707 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		_tmp5_ = _default_;
#line 1707 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		result = _tmp5_;
#line 1707 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		return result;
#line 8496 "ui.c"
	}
	__finally24:
#line 1701 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1701 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	g_clear_error (&_inner_error_);
#line 1701 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	return FALSE;
#line 8505 "ui.c"
}


static gchar* user_interface_state_get_string (UserInterface* self, GKeyFile* f, const gchar* group_name, const gchar* key, const gchar* _default_) {
	gchar* result = NULL;
	GError * _inner_error_ = NULL;
#line 1711 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 1711 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	g_return_val_if_fail (f != NULL, NULL);
#line 1711 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	g_return_val_if_fail (group_name != NULL, NULL);
#line 1711 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	g_return_val_if_fail (key != NULL, NULL);
#line 1711 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	g_return_val_if_fail (_default_ != NULL, NULL);
#line 8522 "ui.c"
	{
		gchar* _tmp0_ = NULL;
		GKeyFile* _tmp1_ = NULL;
		const gchar* _tmp2_ = NULL;
		const gchar* _tmp3_ = NULL;
		gchar* _tmp4_ = NULL;
		gchar* _tmp5_ = NULL;
#line 1715 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		_tmp1_ = f;
#line 1715 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		_tmp2_ = group_name;
#line 1715 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		_tmp3_ = key;
#line 1715 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		_tmp4_ = g_key_file_get_string (_tmp1_, _tmp2_, _tmp3_, &_inner_error_);
#line 1715 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		_tmp0_ = _tmp4_;
#line 1715 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 8542 "ui.c"
			goto __catch25_g_error;
		}
#line 1715 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		_tmp5_ = _tmp0_;
#line 1715 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		_tmp0_ = NULL;
#line 1715 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		result = _tmp5_;
#line 1715 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		_g_free0 (_tmp0_);
#line 1715 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		return result;
#line 8555 "ui.c"
	}
	goto __finally25;
	__catch25_g_error:
	{
		const gchar* _tmp6_ = NULL;
		gchar* _tmp7_ = NULL;
#line 1713 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		g_clear_error (&_inner_error_);
#line 1713 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		_inner_error_ = NULL;
#line 1719 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		_tmp6_ = _default_;
#line 1719 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		_tmp7_ = g_strdup (_tmp6_);
#line 1719 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		result = _tmp7_;
#line 1719 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		return result;
#line 8574 "ui.c"
	}
	__finally25:
#line 1713 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1713 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	g_clear_error (&_inner_error_);
#line 1713 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	return NULL;
#line 8583 "ui.c"
}


static gboolean ___lambda5_ (UserInterface* self) {
	gboolean result = FALSE;
#line 1731 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	user_interface_save_state (self, TRUE);
#line 1732 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	self->priv->save_state_timeout = (guint) 0;
#line 1733 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	result = FALSE;
#line 1733 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	return result;
#line 8597 "ui.c"
}


static gboolean ____lambda5__gsource_func (gpointer self) {
	gboolean result;
	result = ___lambda5_ ((UserInterface*) self);
#line 1729 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	return result;
#line 8606 "ui.c"
}


static void user_interface_save_state (UserInterface* self, gboolean force) {
	gboolean _tmp0_ = FALSE;
	gchar* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
	gchar* _tmp6_ = NULL;
	GKeyFile* f = NULL;
	GKeyFile* _tmp7_ = NULL;
	GKeyFile* _tmp8_ = NULL;
	gint _tmp9_ = 0;
	GKeyFile* _tmp10_ = NULL;
	gint _tmp11_ = 0;
	GKeyFile* _tmp12_ = NULL;
	gboolean _tmp13_ = FALSE;
	GKeyFile* _tmp14_ = NULL;
	gint _tmp15_ = 0;
	GKeyFile* _tmp16_ = NULL;
	gint _tmp17_ = 0;
	GKeyFile* _tmp18_ = NULL;
	gint _tmp19_ = 0;
	ScanDirection _tmp20_ = 0;
	GError * _inner_error_ = NULL;
#line 1723 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	g_return_if_fail (self != NULL);
#line 1725 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp0_ = force;
#line 1725 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	if (!_tmp0_) {
#line 8637 "ui.c"
		guint _tmp1_ = 0U;
		guint _tmp3_ = 0U;
#line 1727 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		_tmp1_ = self->priv->save_state_timeout;
#line 1727 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		if (_tmp1_ != ((guint) 0)) {
#line 8644 "ui.c"
			guint _tmp2_ = 0U;
#line 1728 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
			_tmp2_ = self->priv->save_state_timeout;
#line 1728 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
			g_source_remove (_tmp2_);
#line 8650 "ui.c"
		}
#line 1729 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		_tmp3_ = g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) 100, ____lambda5__gsource_func, user_interface_ref (self), user_interface_unref);
#line 1729 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		self->priv->save_state_timeout = _tmp3_;
#line 1735 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		return;
#line 8658 "ui.c"
	}
#line 1738 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp4_ = user_interface_get_state_filename (self);
#line 1738 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp5_ = _tmp4_;
#line 1738 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp6_ = _tmp5_;
#line 1738 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	g_debug ("ui.vala:1738: Saving state to %s", _tmp6_);
#line 1738 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_g_free0 (_tmp6_);
#line 1740 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp7_ = g_key_file_new ();
#line 1740 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	f = _tmp7_;
#line 1741 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp8_ = f;
#line 1741 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp9_ = self->priv->window_width;
#line 1741 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	g_key_file_set_integer (_tmp8_, "window", "width", _tmp9_);
#line 1742 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp10_ = f;
#line 1742 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp11_ = self->priv->window_height;
#line 1742 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	g_key_file_set_integer (_tmp10_, "window", "height", _tmp11_);
#line 1743 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp12_ = f;
#line 1743 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp13_ = self->priv->window_is_maximized;
#line 1743 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	g_key_file_set_boolean (_tmp12_, "window", "is-maximized", _tmp13_);
#line 1744 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp14_ = f;
#line 1744 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp15_ = self->priv->default_page_width;
#line 1744 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	g_key_file_set_integer (_tmp14_, "last-page", "width", _tmp15_);
#line 1745 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp16_ = f;
#line 1745 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp17_ = self->priv->default_page_height;
#line 1745 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	g_key_file_set_integer (_tmp16_, "last-page", "height", _tmp17_);
#line 1746 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp18_ = f;
#line 1746 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp19_ = self->priv->default_page_dpi;
#line 1746 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	g_key_file_set_integer (_tmp18_, "last-page", "dpi", _tmp19_);
#line 1747 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp20_ = self->priv->default_page_scan_direction;
#line 1747 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	switch (_tmp20_) {
#line 1747 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		case SCAN_DIRECTION_TOP_TO_BOTTOM:
#line 8716 "ui.c"
		{
			GKeyFile* _tmp21_ = NULL;
#line 1750 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
			_tmp21_ = f;
#line 1750 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
			g_key_file_set_value (_tmp21_, "last-page", "scan-direction", "top-to-bottom");
#line 1751 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
			break;
#line 8725 "ui.c"
		}
#line 1747 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		case SCAN_DIRECTION_BOTTOM_TO_TOP:
#line 8729 "ui.c"
		{
			GKeyFile* _tmp22_ = NULL;
#line 1753 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
			_tmp22_ = f;
#line 1753 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
			g_key_file_set_value (_tmp22_, "last-page", "scan-direction", "bottom-to-top");
#line 1754 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
			break;
#line 8738 "ui.c"
		}
#line 1747 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		case SCAN_DIRECTION_LEFT_TO_RIGHT:
#line 8742 "ui.c"
		{
			GKeyFile* _tmp23_ = NULL;
#line 1756 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
			_tmp23_ = f;
#line 1756 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
			g_key_file_set_value (_tmp23_, "last-page", "scan-direction", "left-to-right");
#line 1757 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
			break;
#line 8751 "ui.c"
		}
#line 1747 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		case SCAN_DIRECTION_RIGHT_TO_LEFT:
#line 8755 "ui.c"
		{
			GKeyFile* _tmp24_ = NULL;
#line 1759 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
			_tmp24_ = f;
#line 1759 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
			g_key_file_set_value (_tmp24_, "last-page", "scan-direction", "right-to-left");
#line 1760 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
			break;
#line 8764 "ui.c"
		}
		default:
#line 1747 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		break;
#line 8769 "ui.c"
	}
	{
		gchar* _tmp25_ = NULL;
		gchar* _tmp26_ = NULL;
		gchar* _tmp27_ = NULL;
		GKeyFile* _tmp28_ = NULL;
		gchar* _tmp29_ = NULL;
		gchar* _tmp30_ = NULL;
#line 1764 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		_tmp25_ = user_interface_get_state_filename (self);
#line 1764 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		_tmp26_ = _tmp25_;
#line 1764 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		_tmp27_ = _tmp26_;
#line 1764 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		_tmp28_ = f;
#line 1764 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		_tmp29_ = g_key_file_to_data (_tmp28_, NULL, NULL);
#line 1764 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		_tmp30_ = _tmp29_;
#line 1764 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		g_file_set_contents (_tmp27_, _tmp30_, (gssize) -1, &_inner_error_);
#line 1764 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		_g_free0 (_tmp30_);
#line 1764 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		_g_free0 (_tmp27_);
#line 1764 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 8798 "ui.c"
			goto __catch26_g_error;
		}
	}
	goto __finally26;
	__catch26_g_error:
	{
		GError* e = NULL;
		GError* _tmp31_ = NULL;
		const gchar* _tmp32_ = NULL;
#line 1762 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		e = _inner_error_;
#line 1762 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		_inner_error_ = NULL;
#line 1768 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		_tmp31_ = e;
#line 1768 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		_tmp32_ = _tmp31_->message;
#line 1768 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		g_warning ("ui.vala:1768: Failed to write state: %s", _tmp32_);
#line 1762 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		_g_error_free0 (e);
#line 8820 "ui.c"
	}
	__finally26:
#line 1762 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1762 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		_g_key_file_unref0 (f);
#line 1762 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1762 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		g_clear_error (&_inner_error_);
#line 1762 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		return;
#line 8833 "ui.c"
	}
#line 1723 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_g_key_file_unref0 (f);
#line 8837 "ui.c"
}


static gboolean ___lambda13_ (UserInterface* self) {
	gboolean result = FALSE;
	ProgressBarDialog* _tmp0_ = NULL;
#line 1783 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp0_ = self->priv->progress_dialog;
#line 1783 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	gtk_widget_hide ((GtkWidget*) _tmp0_);
#line 1784 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	result = FALSE;
#line 1784 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	return result;
#line 8852 "ui.c"
}


static gboolean ____lambda13__gsource_func (gpointer self) {
	gboolean result;
	result = ___lambda13_ ((UserInterface*) self);
#line 1782 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	return result;
#line 8861 "ui.c"
}


static void user_interface_book_saving_cb (UserInterface* self, gint page_number) {
	gint total = 0;
	Book* _tmp1_ = NULL;
	guint _tmp2_ = 0U;
	guint _tmp3_ = 0U;
	gdouble fraction = 0.0;
	gint _tmp4_ = 0;
	gint _tmp5_ = 0;
	gboolean complete = FALSE;
	gdouble _tmp6_ = 0.0;
	gboolean _tmp7_ = FALSE;
	gchar* message = NULL;
	const gchar* _tmp8_ = NULL;
	gint _tmp9_ = 0;
	gint _tmp10_ = 0;
	gchar* _tmp11_ = NULL;
	ProgressBarDialog* _tmp12_ = NULL;
	gdouble _tmp13_ = 0.0;
	ProgressBarDialog* _tmp14_ = NULL;
#line 1772 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	g_return_if_fail (self != NULL);
#line 1775 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	while (TRUE) {
#line 8888 "ui.c"
		gboolean _tmp0_ = FALSE;
#line 1775 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		_tmp0_ = gtk_events_pending ();
#line 1775 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		if (!_tmp0_) {
#line 1775 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
			break;
#line 8896 "ui.c"
		}
#line 1776 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		gtk_main_iteration ();
#line 8900 "ui.c"
	}
#line 1778 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp1_ = self->priv->_book;
#line 1778 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp2_ = book_get_n_pages (_tmp1_);
#line 1778 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp3_ = _tmp2_;
#line 1778 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	total = (gint) _tmp3_;
#line 1779 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp4_ = page_number;
#line 1779 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp5_ = total;
#line 1779 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	fraction = (_tmp4_ + 1.0) / _tmp5_;
#line 1780 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp6_ = fraction;
#line 1780 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	complete = _tmp6_ == 1.0;
#line 1781 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp7_ = complete;
#line 1781 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	if (_tmp7_) {
#line 1782 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) 500, ____lambda13__gsource_func, user_interface_ref (self), user_interface_unref);
#line 8926 "ui.c"
	}
#line 1786 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp8_ = _ ("Saving page %d out of %d");
#line 1786 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp9_ = page_number;
#line 1786 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp10_ = total;
#line 1786 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp11_ = g_strdup_printf (_tmp8_, _tmp9_ + 1, _tmp10_);
#line 1786 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	message = _tmp11_;
#line 1788 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp12_ = self->priv->progress_dialog;
#line 1788 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp13_ = fraction;
#line 1788 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	progress_bar_dialog_set_fraction (_tmp12_, _tmp13_);
#line 1789 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp14_ = self->priv->progress_dialog;
#line 1789 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	progress_bar_dialog_set_message (_tmp14_, message);
#line 1772 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_g_free0 (message);
#line 8950 "ui.c"
}


void user_interface_show_progress_dialog (UserInterface* self) {
	ProgressBarDialog* _tmp0_ = NULL;
#line 1792 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	g_return_if_fail (self != NULL);
#line 1794 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp0_ = self->priv->progress_dialog;
#line 1794 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	gtk_widget_show ((GtkWidget*) _tmp0_);
#line 8962 "ui.c"
}


void user_interface_hide_progress_dialog (UserInterface* self) {
	ProgressBarDialog* _tmp0_ = NULL;
#line 1797 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	g_return_if_fail (self != NULL);
#line 1799 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp0_ = self->priv->progress_dialog;
#line 1799 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	gtk_widget_hide ((GtkWidget*) _tmp0_);
#line 8974 "ui.c"
}


void user_interface_show_error (UserInterface* self, const gchar* error_title, const gchar* error_text, gboolean change_scanner_hint) {
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	gboolean _tmp4_ = FALSE;
#line 1802 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	g_return_if_fail (self != NULL);
#line 1802 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	g_return_if_fail (error_title != NULL);
#line 1802 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	g_return_if_fail (error_text != NULL);
#line 1804 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	self->priv->have_error = TRUE;
#line 1805 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp0_ = error_title;
#line 1805 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp1_ = g_strdup (_tmp0_);
#line 1805 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_g_free0 (self->priv->error_title);
#line 1805 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	self->priv->error_title = _tmp1_;
#line 1806 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp2_ = error_text;
#line 1806 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp3_ = g_strdup (_tmp2_);
#line 1806 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_g_free0 (self->priv->error_text);
#line 1806 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	self->priv->error_text = _tmp3_;
#line 1807 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp4_ = change_scanner_hint;
#line 1807 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	self->priv->error_change_scanner_hint = _tmp4_;
#line 1808 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	user_interface_update_info_bar (self);
#line 9014 "ui.c"
}


void user_interface_start (UserInterface* self) {
	GtkApplicationWindow* _tmp0_ = NULL;
#line 1811 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	g_return_if_fail (self != NULL);
#line 1813 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp0_ = self->priv->window;
#line 1813 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	gtk_widget_show ((GtkWidget*) _tmp0_);
#line 9026 "ui.c"
}


Book* user_interface_get_book (UserInterface* self) {
	Book* result;
	Book* _tmp0_ = NULL;
#line 92 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 92 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp0_ = self->priv->_book;
#line 92 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	result = _tmp0_;
#line 92 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	return result;
#line 9041 "ui.c"
}


static gpointer _book_ref0 (gpointer self) {
#line 92 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	return self ? book_ref (self) : NULL;
#line 9048 "ui.c"
}


static void user_interface_set_book (UserInterface* self, Book* value) {
	Book* _tmp0_ = NULL;
	Book* _tmp1_ = NULL;
#line 92 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	g_return_if_fail (self != NULL);
#line 92 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp0_ = value;
#line 92 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp1_ = _book_ref0 (_tmp0_);
#line 92 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_book_unref0 (self->priv->_book);
#line 92 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	self->priv->_book = _tmp1_;
#line 9065 "ui.c"
}


Page* user_interface_get_selected_page (UserInterface* self) {
	Page* result;
	BookView* _tmp0_ = NULL;
	Page* _tmp1_ = NULL;
	Page* _tmp2_ = NULL;
#line 97 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 99 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp0_ = self->priv->book_view;
#line 99 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp1_ = book_view_get_selected_page (_tmp0_);
#line 99 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp2_ = _tmp1_;
#line 99 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	result = _tmp2_;
#line 99 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	return result;
#line 9086 "ui.c"
}


void user_interface_set_selected_page (UserInterface* self, Page* value) {
	BookView* _tmp0_ = NULL;
	Page* _tmp1_ = NULL;
#line 101 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	g_return_if_fail (self != NULL);
#line 103 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp0_ = self->priv->book_view;
#line 103 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp1_ = value;
#line 103 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	book_view_set_selected_page (_tmp0_, _tmp1_);
#line 9101 "ui.c"
}


const gchar* user_interface_get_default_file_name (UserInterface* self) {
	const gchar* result;
	const gchar* _tmp0_ = NULL;
#line 118 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 118 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp0_ = self->priv->_default_file_name;
#line 118 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	result = _tmp0_;
#line 118 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	return result;
#line 9116 "ui.c"
}


void user_interface_set_default_file_name (UserInterface* self, const gchar* value) {
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
#line 118 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	g_return_if_fail (self != NULL);
#line 118 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp0_ = value;
#line 118 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp1_ = g_strdup (_tmp0_);
#line 118 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_g_free0 (self->priv->_default_file_name);
#line 118 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	self->priv->_default_file_name = _tmp1_;
#line 9133 "ui.c"
}


gboolean user_interface_get_scanning (UserInterface* self) {
	gboolean result;
	gboolean _tmp0_ = FALSE;
#line 122 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 122 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp0_ = self->priv->scanning_;
#line 122 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	result = _tmp0_;
#line 122 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	return result;
#line 9148 "ui.c"
}


void user_interface_set_scanning (UserInterface* self, gboolean value) {
	gboolean _tmp0_ = FALSE;
	GtkMenuItem* _tmp1_ = NULL;
	gboolean _tmp2_ = FALSE;
	GtkMenuItem* _tmp3_ = NULL;
	gboolean _tmp4_ = FALSE;
	GtkToolButton* _tmp5_ = NULL;
	gboolean _tmp6_ = FALSE;
#line 123 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	g_return_if_fail (self != NULL);
#line 125 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp0_ = value;
#line 125 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	self->priv->scanning_ = _tmp0_;
#line 126 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp1_ = self->priv->page_delete_menuitem;
#line 126 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp2_ = value;
#line 126 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	gtk_widget_set_sensitive ((GtkWidget*) _tmp1_, !_tmp2_);
#line 127 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp3_ = self->priv->stop_menuitem;
#line 127 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp4_ = value;
#line 127 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	gtk_widget_set_sensitive ((GtkWidget*) _tmp3_, _tmp4_);
#line 128 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp5_ = self->priv->stop_toolbutton;
#line 128 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp6_ = value;
#line 128 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	gtk_widget_set_sensitive ((GtkWidget*) _tmp5_, _tmp6_);
#line 9184 "ui.c"
}


gint user_interface_get_brightness (UserInterface* self) {
	gint result;
	GtkAdjustment* _tmp0_ = NULL;
	gdouble _tmp1_ = 0.0;
#line 140 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 140 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp0_ = self->priv->brightness_adjustment;
#line 140 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp1_ = gtk_adjustment_get_value (_tmp0_);
#line 140 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	result = (gint) _tmp1_;
#line 140 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	return result;
#line 9202 "ui.c"
}


void user_interface_set_brightness (UserInterface* self, gint value) {
	GtkAdjustment* _tmp0_ = NULL;
	gint _tmp1_ = 0;
#line 141 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	g_return_if_fail (self != NULL);
#line 141 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp0_ = self->priv->brightness_adjustment;
#line 141 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp1_ = value;
#line 141 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	gtk_adjustment_set_value (_tmp0_, (gdouble) _tmp1_);
#line 9217 "ui.c"
}


gint user_interface_get_contrast (UserInterface* self) {
	gint result;
	GtkAdjustment* _tmp0_ = NULL;
	gdouble _tmp1_ = 0.0;
#line 146 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 146 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp0_ = self->priv->contrast_adjustment;
#line 146 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp1_ = gtk_adjustment_get_value (_tmp0_);
#line 146 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	result = (gint) _tmp1_;
#line 146 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	return result;
#line 9235 "ui.c"
}


void user_interface_set_contrast (UserInterface* self, gint value) {
	GtkAdjustment* _tmp0_ = NULL;
	gint _tmp1_ = 0;
#line 147 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	g_return_if_fail (self != NULL);
#line 147 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp0_ = self->priv->contrast_adjustment;
#line 147 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp1_ = value;
#line 147 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	gtk_adjustment_set_value (_tmp0_, (gdouble) _tmp1_);
#line 9250 "ui.c"
}


gint user_interface_get_quality (UserInterface* self) {
	gint result;
	GtkAdjustment* _tmp0_ = NULL;
	gdouble _tmp1_ = 0.0;
#line 152 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 152 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp0_ = self->priv->quality_adjustment;
#line 152 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp1_ = gtk_adjustment_get_value (_tmp0_);
#line 152 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	result = (gint) _tmp1_;
#line 152 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	return result;
#line 9268 "ui.c"
}


void user_interface_set_quality (UserInterface* self, gint value) {
	GtkAdjustment* _tmp0_ = NULL;
	gint _tmp1_ = 0;
#line 153 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	g_return_if_fail (self != NULL);
#line 153 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp0_ = self->priv->quality_adjustment;
#line 153 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp1_ = value;
#line 153 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	gtk_adjustment_set_value (_tmp0_, (gdouble) _tmp1_);
#line 9283 "ui.c"
}


gchar* user_interface_get_selected_device (UserInterface* self) {
	gchar* result;
	GtkTreeIter iter = {0};
	GtkComboBox* _tmp0_ = NULL;
	GtkTreeIter _tmp1_ = {0};
	gboolean _tmp2_ = FALSE;
#line 158 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 162 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp0_ = self->priv->device_combo;
#line 162 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp2_ = gtk_combo_box_get_active_iter (_tmp0_, &_tmp1_);
#line 162 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	iter = _tmp1_;
#line 162 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	if (_tmp2_) {
#line 9303 "ui.c"
		gchar* device = NULL;
		GtkListStore* _tmp3_ = NULL;
		GtkTreeIter _tmp4_ = {0};
#line 165 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		_tmp3_ = self->priv->device_model;
#line 165 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		_tmp4_ = iter;
#line 165 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		gtk_tree_model_get ((GtkTreeModel*) _tmp3_, &_tmp4_, 0, &device, -1, -1);
#line 166 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		result = device;
#line 166 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		return result;
#line 9317 "ui.c"
	}
#line 169 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	result = NULL;
#line 169 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	return result;
#line 9323 "ui.c"
}


void user_interface_set_selected_device (UserInterface* self, const gchar* value) {
	GtkTreeIter iter = {0};
	const gchar* _tmp0_ = NULL;
	GtkTreeIter _tmp1_ = {0};
	gboolean _tmp2_ = FALSE;
	GtkComboBox* _tmp3_ = NULL;
	GtkTreeIter _tmp4_ = {0};
#line 172 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	g_return_if_fail (self != NULL);
#line 175 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp0_ = value;
#line 175 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp2_ = user_interface_find_scan_device (self, _tmp0_, &_tmp1_);
#line 175 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	iter = _tmp1_;
#line 175 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	if (!_tmp2_) {
#line 176 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		return;
#line 9346 "ui.c"
	}
#line 178 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp3_ = self->priv->device_combo;
#line 178 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp4_ = iter;
#line 178 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	gtk_combo_box_set_active_iter (_tmp3_, &_tmp4_);
#line 179 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	self->priv->user_selected_device = TRUE;
#line 9356 "ui.c"
}


static gchar* user_interface_get_state_filename (UserInterface* self) {
	gchar* result;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
#line 1642 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 1642 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp0_ = g_get_user_cache_dir ();
#line 1642 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp1_ = g_build_filename (_tmp0_, "simple-scan", "state", NULL);
#line 1642 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	result = _tmp1_;
#line 1642 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	return result;
#line 9374 "ui.c"
}


static void g_cclosure_user_marshal_VOID__STRING_SCAN_OPTIONS (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data) {
	typedef void (*GMarshalFunc_VOID__STRING_SCAN_OPTIONS) (gpointer data1, const char* arg_1, gpointer arg_2, gpointer data2);
	register GMarshalFunc_VOID__STRING_SCAN_OPTIONS callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
#line 12 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	g_return_if_fail (n_param_values == 3);
#line 12 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	if (G_CCLOSURE_SWAP_DATA (closure)) {
#line 12 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		data1 = closure->data;
#line 12 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		data2 = param_values->data[0].v_pointer;
#line 9393 "ui.c"
	} else {
#line 12 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		data1 = param_values->data[0].v_pointer;
#line 12 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		data2 = closure->data;
#line 9399 "ui.c"
	}
#line 12 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	callback = (GMarshalFunc_VOID__STRING_SCAN_OPTIONS) (marshal_data ? marshal_data : cc->callback);
#line 12 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	callback (data1, g_value_get_string (param_values + 1), value_get_scan_options (param_values + 2), data2);
#line 9405 "ui.c"
}


static void g_cclosure_user_marshal_VOID__STRING_INT (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data) {
	typedef void (*GMarshalFunc_VOID__STRING_INT) (gpointer data1, const char* arg_1, gint arg_2, gpointer data2);
	register GMarshalFunc_VOID__STRING_INT callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
#line 12 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	g_return_if_fail (n_param_values == 3);
#line 12 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	if (G_CCLOSURE_SWAP_DATA (closure)) {
#line 12 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		data1 = closure->data;
#line 12 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		data2 = param_values->data[0].v_pointer;
#line 9424 "ui.c"
	} else {
#line 12 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		data1 = param_values->data[0].v_pointer;
#line 12 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		data2 = closure->data;
#line 9430 "ui.c"
	}
#line 12 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	callback = (GMarshalFunc_VOID__STRING_INT) (marshal_data ? marshal_data : cc->callback);
#line 12 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	callback (data1, g_value_get_string (param_values + 1), g_value_get_int (param_values + 2), data2);
#line 9436 "ui.c"
}


static void value_user_interface_init (GValue* value) {
#line 12 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	value->data[0].v_pointer = NULL;
#line 9443 "ui.c"
}


static void value_user_interface_free_value (GValue* value) {
#line 12 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	if (value->data[0].v_pointer) {
#line 12 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		user_interface_unref (value->data[0].v_pointer);
#line 9452 "ui.c"
	}
}


static void value_user_interface_copy_value (const GValue* src_value, GValue* dest_value) {
#line 12 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	if (src_value->data[0].v_pointer) {
#line 12 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		dest_value->data[0].v_pointer = user_interface_ref (src_value->data[0].v_pointer);
#line 9462 "ui.c"
	} else {
#line 12 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		dest_value->data[0].v_pointer = NULL;
#line 9466 "ui.c"
	}
}


static gpointer value_user_interface_peek_pointer (const GValue* value) {
#line 12 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	return value->data[0].v_pointer;
#line 9474 "ui.c"
}


static gchar* value_user_interface_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
#line 12 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	if (collect_values[0].v_pointer) {
#line 9481 "ui.c"
		UserInterface* object;
		object = collect_values[0].v_pointer;
#line 12 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		if (object->parent_instance.g_class == NULL) {
#line 12 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 9488 "ui.c"
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
#line 12 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 9492 "ui.c"
		}
#line 12 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		value->data[0].v_pointer = user_interface_ref (object);
#line 9496 "ui.c"
	} else {
#line 12 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		value->data[0].v_pointer = NULL;
#line 9500 "ui.c"
	}
#line 12 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	return NULL;
#line 9504 "ui.c"
}


static gchar* value_user_interface_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	UserInterface** object_p;
	object_p = collect_values[0].v_pointer;
#line 12 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	if (!object_p) {
#line 12 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
#line 9515 "ui.c"
	}
#line 12 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	if (!value->data[0].v_pointer) {
#line 12 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		*object_p = NULL;
#line 9521 "ui.c"
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
#line 12 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		*object_p = value->data[0].v_pointer;
#line 9525 "ui.c"
	} else {
#line 12 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		*object_p = user_interface_ref (value->data[0].v_pointer);
#line 9529 "ui.c"
	}
#line 12 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	return NULL;
#line 9533 "ui.c"
}


GParamSpec* param_spec_user_interface (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	ParamSpecUserInterface* spec;
#line 12 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_USER_INTERFACE), NULL);
#line 12 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
#line 12 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	G_PARAM_SPEC (spec)->value_type = object_type;
#line 12 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	return G_PARAM_SPEC (spec);
#line 9547 "ui.c"
}


gpointer value_get_user_interface (const GValue* value) {
#line 12 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_USER_INTERFACE), NULL);
#line 12 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	return value->data[0].v_pointer;
#line 9556 "ui.c"
}


void value_set_user_interface (GValue* value, gpointer v_object) {
	UserInterface* old;
#line 12 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_USER_INTERFACE));
#line 12 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	old = value->data[0].v_pointer;
#line 12 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	if (v_object) {
#line 12 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_USER_INTERFACE));
#line 12 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 12 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		value->data[0].v_pointer = v_object;
#line 12 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		user_interface_ref (value->data[0].v_pointer);
#line 9576 "ui.c"
	} else {
#line 12 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		value->data[0].v_pointer = NULL;
#line 9580 "ui.c"
	}
#line 12 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	if (old) {
#line 12 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		user_interface_unref (old);
#line 9586 "ui.c"
	}
}


void value_take_user_interface (GValue* value, gpointer v_object) {
	UserInterface* old;
#line 12 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_USER_INTERFACE));
#line 12 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	old = value->data[0].v_pointer;
#line 12 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	if (v_object) {
#line 12 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_USER_INTERFACE));
#line 12 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 12 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		value->data[0].v_pointer = v_object;
#line 9605 "ui.c"
	} else {
#line 12 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		value->data[0].v_pointer = NULL;
#line 9609 "ui.c"
	}
#line 12 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	if (old) {
#line 12 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		user_interface_unref (old);
#line 9615 "ui.c"
	}
}


static void user_interface_class_init (UserInterfaceClass * klass) {
#line 12 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	user_interface_parent_class = g_type_class_peek_parent (klass);
#line 12 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	((UserInterfaceClass *) klass)->finalize = user_interface_finalize;
#line 12 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	g_type_class_add_private (klass, sizeof (UserInterfacePrivate));
#line 12 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	g_signal_new ("start_scan", TYPE_USER_INTERFACE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__STRING_SCAN_OPTIONS, G_TYPE_NONE, 2, G_TYPE_STRING, TYPE_SCAN_OPTIONS);
#line 12 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	g_signal_new ("stop_scan", TYPE_USER_INTERFACE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
#line 12 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	g_signal_new ("email", TYPE_USER_INTERFACE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__STRING_INT, G_TYPE_NONE, 2, G_TYPE_STRING, G_TYPE_INT);
#line 9633 "ui.c"
}


static void user_interface_instance_init (UserInterface * self) {
	gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
#line 12 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	self->priv = USER_INTERFACE_GET_PRIVATE (self);
#line 93 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	self->priv->book_uri = NULL;
#line 116 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp0_ = g_strdup ("photo");
#line 116 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	self->priv->document_hint = _tmp0_;
#line 118 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp1_ = _ ("Scanned Document.pdf");
#line 118 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp2_ = g_strdup (_tmp1_);
#line 118 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	self->priv->_default_file_name = _tmp2_;
#line 119 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	self->priv->scanning_ = FALSE;
#line 12 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	self->ref_count = 1;
#line 9659 "ui.c"
}


static void user_interface_finalize (UserInterface* obj) {
	UserInterface * self;
	Book* _tmp0_ = NULL;
	guint _tmp1_ = 0U;
	Book* _tmp2_ = NULL;
	guint _tmp3_ = 0U;
#line 12 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_USER_INTERFACE, UserInterface);
#line 12 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	g_signal_handlers_destroy (self);
#line 213 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp0_ = self->priv->_book;
#line 213 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	g_signal_parse_name ("page-removed", TYPE_BOOK, &_tmp1_, NULL, FALSE);
#line 213 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	g_signal_handlers_disconnect_matched (_tmp0_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp1_, 0, NULL, (GCallback) _user_interface_page_removed_cb_book_page_removed, self);
#line 214 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp2_ = self->priv->_book;
#line 214 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	g_signal_parse_name ("page-added", TYPE_BOOK, &_tmp3_, NULL, FALSE);
#line 214 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	g_signal_handlers_disconnect_matched (_tmp2_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp3_, 0, NULL, (GCallback) _user_interface_page_added_cb_book_page_added, self);
#line 30 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_g_object_unref0 (self->priv->settings);
#line 32 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_g_object_unref0 (self->priv->builder);
#line 34 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_g_object_unref0 (self->priv->window);
#line 35 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_g_object_unref0 (self->priv->app_menu);
#line 36 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_g_object_unref0 (self->priv->menubar);
#line 37 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_g_object_unref0 (self->priv->main_vbox);
#line 38 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_g_object_unref0 (self->priv->info_bar);
#line 39 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_g_object_unref0 (self->priv->info_bar_image);
#line 40 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_g_object_unref0 (self->priv->info_bar_label);
#line 41 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_g_object_unref0 (self->priv->info_bar_close_button);
#line 42 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_g_object_unref0 (self->priv->info_bar_change_scanner_button);
#line 43 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_g_object_unref0 (self->priv->page_move_left_menuitem);
#line 44 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_g_object_unref0 (self->priv->page_move_right_menuitem);
#line 45 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_g_object_unref0 (self->priv->page_delete_menuitem);
#line 46 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_g_object_unref0 (self->priv->crop_rotate_menuitem);
#line 47 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_g_object_unref0 (self->priv->save_menuitem);
#line 48 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_g_object_unref0 (self->priv->save_as_menuitem);
#line 49 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_g_object_unref0 (self->priv->copy_to_clipboard_menuitem);
#line 50 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_g_object_unref0 (self->priv->save_toolbutton);
#line 51 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_g_object_unref0 (self->priv->stop_menuitem);
#line 52 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_g_object_unref0 (self->priv->stop_toolbutton);
#line 54 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_g_object_unref0 (self->priv->text_toolbar_menuitem);
#line 55 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_g_object_unref0 (self->priv->text_menu_menuitem);
#line 56 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_g_object_unref0 (self->priv->photo_toolbar_menuitem);
#line 57 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_g_object_unref0 (self->priv->photo_menu_menuitem);
#line 59 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_g_object_unref0 (self->priv->authorize_dialog);
#line 60 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_g_object_unref0 (self->priv->authorize_label);
#line 61 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_g_object_unref0 (self->priv->username_entry);
#line 62 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_g_object_unref0 (self->priv->password_entry);
#line 64 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_g_object_unref0 (self->priv->preferences_dialog);
#line 65 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_g_object_unref0 (self->priv->device_combo);
#line 66 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_g_object_unref0 (self->priv->text_dpi_combo);
#line 67 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_g_object_unref0 (self->priv->photo_dpi_combo);
#line 68 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_g_object_unref0 (self->priv->page_side_combo);
#line 69 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_g_object_unref0 (self->priv->paper_size_combo);
#line 70 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_g_object_unref0 (self->priv->brightness_scale);
#line 71 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_g_object_unref0 (self->priv->contrast_scale);
#line 72 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_g_object_unref0 (self->priv->quality_scale);
#line 73 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_g_object_unref0 (self->priv->device_model);
#line 74 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_g_object_unref0 (self->priv->text_dpi_model);
#line 75 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_g_object_unref0 (self->priv->photo_dpi_model);
#line 76 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_g_object_unref0 (self->priv->page_side_model);
#line 77 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_g_object_unref0 (self->priv->paper_size_model);
#line 78 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_g_object_unref0 (self->priv->brightness_adjustment);
#line 79 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_g_object_unref0 (self->priv->contrast_adjustment);
#line 80 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_g_object_unref0 (self->priv->quality_adjustment);
#line 84 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_g_object_unref0 (self->priv->save_dialog);
#line 85 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_g_object_unref0 (self->priv->progress_dialog);
#line 88 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_g_free0 (self->priv->error_title);
#line 89 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_g_free0 (self->priv->error_text);
#line 92 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_book_unref0 (self->priv->_book);
#line 93 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_g_free0 (self->priv->book_uri);
#line 107 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_autosave_manager_unref0 (self->priv->autosave_manager);
#line 109 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_g_object_unref0 (self->priv->book_view);
#line 116 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_g_free0 (self->priv->document_hint);
#line 118 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_g_free0 (self->priv->_default_file_name);
#line 9797 "ui.c"
}


GType user_interface_get_type (void) {
	static volatile gsize user_interface_type_id__volatile = 0;
	if (g_once_init_enter (&user_interface_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { value_user_interface_init, value_user_interface_free_value, value_user_interface_copy_value, value_user_interface_peek_pointer, "p", value_user_interface_collect_value, "p", value_user_interface_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (UserInterfaceClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) user_interface_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (UserInterface), 0, (GInstanceInitFunc) user_interface_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType user_interface_type_id;
		user_interface_type_id = g_type_register_fundamental (g_type_fundamental_next (), "UserInterface", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&user_interface_type_id__volatile, user_interface_type_id);
	}
	return user_interface_type_id__volatile;
}


gpointer user_interface_ref (gpointer instance) {
	UserInterface* self;
	self = instance;
#line 12 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	g_atomic_int_inc (&self->ref_count);
#line 12 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	return instance;
#line 9822 "ui.c"
}


void user_interface_unref (gpointer instance) {
	UserInterface* self;
	self = instance;
#line 12 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
#line 12 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		USER_INTERFACE_GET_CLASS (self)->finalize (self);
#line 12 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		g_type_free_instance ((GTypeInstance *) self);
#line 9835 "ui.c"
	}
}


ProgressBarDialog* progress_bar_dialog_construct (GType object_type, GtkApplicationWindow* parent, const gchar* title) {
	ProgressBarDialog * self = NULL;
	GtkProgressBar* _tmp0_ = NULL;
	GtkBox* hbox = NULL;
	GtkBox* _tmp1_ = NULL;
	GtkBox* vbox = NULL;
	GtkBox* _tmp2_ = NULL;
	GtkProgressBar* _tmp3_ = NULL;
	GtkProgressBar* _tmp4_ = NULL;
	GtkProgressBar* _tmp5_ = NULL;
	GtkProgressBar* _tmp6_ = NULL;
	const gchar* _tmp7_ = NULL;
	GtkApplicationWindow* _tmp8_ = NULL;
	GtkProgressBar* _tmp9_ = NULL;
#line 1821 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	g_return_val_if_fail (parent != NULL, NULL);
#line 1821 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	g_return_val_if_fail (title != NULL, NULL);
#line 1821 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	self = (ProgressBarDialog*) g_object_new (object_type, NULL);
#line 1823 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp0_ = (GtkProgressBar*) gtk_progress_bar_new ();
#line 1823 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	g_object_ref_sink (_tmp0_);
#line 1823 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_g_object_unref0 (self->priv->bar);
#line 1823 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	self->priv->bar = _tmp0_;
#line 1824 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp1_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_HORIZONTAL, 5);
#line 1824 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	g_object_ref_sink (_tmp1_);
#line 1824 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	hbox = _tmp1_;
#line 1825 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp2_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_VERTICAL, 5);
#line 1825 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	g_object_ref_sink (_tmp2_);
#line 1825 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	vbox = _tmp2_;
#line 1826 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	gtk_widget_set_hexpand ((GtkWidget*) hbox, TRUE);
#line 1828 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp3_ = self->priv->bar;
#line 1828 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	gtk_progress_bar_set_text (_tmp3_, "");
#line 1829 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp4_ = self->priv->bar;
#line 1829 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	gtk_progress_bar_set_show_text (_tmp4_, TRUE);
#line 1830 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp5_ = self->priv->bar;
#line 1830 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	gtk_widget_set_size_request ((GtkWidget*) _tmp5_, 225, 25);
#line 1831 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	gtk_widget_set_size_request ((GtkWidget*) self, 250, 50);
#line 1833 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp6_ = self->priv->bar;
#line 1833 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	gtk_box_pack_start (vbox, (GtkWidget*) _tmp6_, TRUE, FALSE, (guint) 0);
#line 1834 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	gtk_box_pack_start (hbox, (GtkWidget*) vbox, TRUE, FALSE, (guint) 0);
#line 1835 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) hbox);
#line 1836 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp7_ = title;
#line 1836 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	gtk_window_set_title ((GtkWindow*) self, _tmp7_);
#line 1838 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp8_ = parent;
#line 1838 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	gtk_window_set_transient_for ((GtkWindow*) self, (GtkWindow*) _tmp8_);
#line 1839 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	gtk_window_set_position ((GtkWindow*) self, GTK_WIN_POS_CENTER_ON_PARENT);
#line 1840 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	gtk_window_set_modal ((GtkWindow*) self, TRUE);
#line 1841 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	gtk_window_set_resizable ((GtkWindow*) self, FALSE);
#line 1843 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	gtk_widget_show ((GtkWidget*) hbox);
#line 1844 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	gtk_widget_show ((GtkWidget*) vbox);
#line 1845 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp9_ = self->priv->bar;
#line 1845 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	gtk_widget_show ((GtkWidget*) _tmp9_);
#line 1821 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_g_object_unref0 (vbox);
#line 1821 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_g_object_unref0 (hbox);
#line 1821 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	return self;
#line 9932 "ui.c"
}


ProgressBarDialog* progress_bar_dialog_new (GtkApplicationWindow* parent, const gchar* title) {
#line 1821 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	return progress_bar_dialog_construct (TYPE_PROGRESS_BAR_DIALOG, parent, title);
#line 9939 "ui.c"
}


void progress_bar_dialog_set_fraction (ProgressBarDialog* self, gdouble percent) {
	GtkProgressBar* _tmp0_ = NULL;
	gdouble _tmp1_ = 0.0;
#line 1848 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	g_return_if_fail (self != NULL);
#line 1850 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp0_ = self->priv->bar;
#line 1850 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp1_ = percent;
#line 1850 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	gtk_progress_bar_set_fraction (_tmp0_, _tmp1_);
#line 9954 "ui.c"
}


void progress_bar_dialog_set_message (ProgressBarDialog* self, const gchar* message) {
	GtkProgressBar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
#line 1853 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	g_return_if_fail (self != NULL);
#line 1853 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	g_return_if_fail (message != NULL);
#line 1855 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp0_ = self->priv->bar;
#line 1855 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp1_ = message;
#line 1855 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	gtk_progress_bar_set_text (_tmp0_, _tmp1_);
#line 9971 "ui.c"
}


static void progress_bar_dialog_class_init (ProgressBarDialogClass * klass) {
#line 1817 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	progress_bar_dialog_parent_class = g_type_class_peek_parent (klass);
#line 1817 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	g_type_class_add_private (klass, sizeof (ProgressBarDialogPrivate));
#line 1817 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	G_OBJECT_CLASS (klass)->finalize = progress_bar_dialog_finalize;
#line 9982 "ui.c"
}


static void progress_bar_dialog_instance_init (ProgressBarDialog * self) {
#line 1817 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	self->priv = PROGRESS_BAR_DIALOG_GET_PRIVATE (self);
#line 9989 "ui.c"
}


static void progress_bar_dialog_finalize (GObject* obj) {
	ProgressBarDialog * self;
#line 1817 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_PROGRESS_BAR_DIALOG, ProgressBarDialog);
#line 1819 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_g_object_unref0 (self->priv->bar);
#line 1817 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	G_OBJECT_CLASS (progress_bar_dialog_parent_class)->finalize (obj);
#line 10001 "ui.c"
}


GType progress_bar_dialog_get_type (void) {
	static volatile gsize progress_bar_dialog_type_id__volatile = 0;
	if (g_once_init_enter (&progress_bar_dialog_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ProgressBarDialogClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) progress_bar_dialog_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ProgressBarDialog), 0, (GInstanceInitFunc) progress_bar_dialog_instance_init, NULL };
		GType progress_bar_dialog_type_id;
		progress_bar_dialog_type_id = g_type_register_static (gtk_window_get_type (), "ProgressBarDialog", &g_define_type_info, 0);
		g_once_init_leave (&progress_bar_dialog_type_id__volatile, progress_bar_dialog_type_id);
	}
	return progress_bar_dialog_type_id__volatile;
}


gchar* get_temporary_filename (const gchar* prefix, const gchar* extension) {
	gchar* result = NULL;
	gchar* filename = NULL;
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gchar* path = NULL;
	GError * _inner_error_ = NULL;
#line 1860 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	g_return_val_if_fail (prefix != NULL, NULL);
#line 1860 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	g_return_val_if_fail (extension != NULL, NULL);
#line 1865 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp0_ = prefix;
#line 1865 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp1_ = extension;
#line 1865 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_tmp2_ = g_strdup_printf ("%sXXXXXX.%s", _tmp0_, _tmp1_);
#line 1865 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	filename = _tmp2_;
#line 10037 "ui.c"
	{
		gint fd = 0;
		const gchar* _tmp3_ = NULL;
		gchar* _tmp4_ = NULL;
		gint _tmp5_ = 0;
		gint _tmp6_ = 0;
#line 1869 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		_tmp3_ = filename;
#line 1869 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		_tmp5_ = g_file_open_tmp (_tmp3_, &_tmp4_, &_inner_error_);
#line 1869 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		_g_free0 (path);
#line 1869 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		path = _tmp4_;
#line 1869 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		fd = _tmp5_;
#line 1869 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 10056 "ui.c"
			goto __catch27_g_error;
		}
#line 1870 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		_tmp6_ = fd;
#line 1870 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		close (_tmp6_);
#line 10063 "ui.c"
	}
	goto __finally27;
	__catch27_g_error:
	{
		GError* e = NULL;
		GError* _tmp7_ = NULL;
		const gchar* _tmp8_ = NULL;
#line 1867 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		e = _inner_error_;
#line 1867 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		_inner_error_ = NULL;
#line 1874 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		_tmp7_ = e;
#line 1874 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		_tmp8_ = _tmp7_->message;
#line 1874 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		g_warning ("ui.vala:1874: Error saving email attachment: %s", _tmp8_);
#line 1875 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		result = NULL;
#line 1875 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		_g_error_free0 (e);
#line 1875 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		_g_free0 (path);
#line 1875 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		_g_free0 (filename);
#line 1875 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		return result;
#line 10091 "ui.c"
	}
	__finally27:
#line 1867 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1867 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		_g_free0 (path);
#line 1867 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		_g_free0 (filename);
#line 1867 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1867 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		g_clear_error (&_inner_error_);
#line 1867 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
		return NULL;
#line 10106 "ui.c"
	}
#line 1878 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	result = path;
#line 1878 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	_g_free0 (filename);
#line 1878 "/home/bob/bzr/simple-scan/3.12/src/ui.vala"
	return result;
#line 10114 "ui.c"
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



