// For documentation of the format, see README in this directory.
var browserTests = [
["foo[]bar",
    [["fontname","sans-serif"]],
    "foo[]bar",
    [true],
    {"fontname":[false,false,"serif",false,false,"sans-serif"]}],
["<p>[foo</p> <p>bar]</p>",
    [["stylewithcss","true"],["fontname","sans-serif"]],
    "<p><span style=\"font-family:sans-serif\">[foo</span></p> <p><span style=\"font-family:sans-serif\">bar]</span></p>",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"fontname":[false,false,"serif",false,false,"sans-serif"]}],
["<p>[foo</p> <p>bar]</p>",
    [["stylewithcss","false"],["fontname","sans-serif"]],
    "<p><font face=\"sans-serif\">[foo</font></p> <p><font face=\"sans-serif\">bar]</font></p>",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"fontname":[false,false,"serif",false,false,"sans-serif"]}],
["<span>[foo</span> <span>bar]</span>",
    [["stylewithcss","true"],["fontname","sans-serif"]],
    "<span style=\"font-family:sans-serif\"><span>[foo</span> <span>bar]</span></span>",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"fontname":[false,false,"serif",false,false,"sans-serif"]}],
["<span>[foo</span> <span>bar]</span>",
    [["stylewithcss","false"],["fontname","sans-serif"]],
    "<font face=\"sans-serif\"><span>[foo</span> <span>bar]</span></font>",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"fontname":[false,false,"serif",false,false,"sans-serif"]}],
["<p>[foo</p><p> <span>bar</span> </p><p>baz]</p>",
    [["stylewithcss","true"],["fontname","sans-serif"]],
    "<p><span style=\"font-family:sans-serif\">[foo</span></p><p> <span style=\"font-family:sans-serif\"><span>bar</span></span> </p><p><span style=\"font-family:sans-serif\">baz]</span></p>",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"fontname":[false,false,"serif",false,false,"sans-serif"]}],
["<p>[foo</p><p> <span>bar</span> </p><p>baz]</p>",
    [["stylewithcss","false"],["fontname","sans-serif"]],
    "<p><font face=\"sans-serif\">[foo</font></p><p> <font face=\"sans-serif\"><span>bar</span></font> </p><p><font face=\"sans-serif\">baz]</font></p>",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"fontname":[false,false,"serif",false,false,"sans-serif"]}],
["<p>[foo<p><br><p>bar]",
    [["stylewithcss","true"],["fontname","sans-serif"]],
    "<p><span style=\"font-family:sans-serif\">[foo</span></p><p><span style=\"font-family:sans-serif\"><br></span></p><p><span style=\"font-family:sans-serif\">bar]</span></p>",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"fontname":[false,false,"serif",false,false,"sans-serif"]}],
["<p>[foo<p><br><p>bar]",
    [["stylewithcss","false"],["fontname","sans-serif"]],
    "<p><font face=\"sans-serif\">[foo</font></p><p><font face=\"sans-serif\"><br></font></p><p><font face=\"sans-serif\">bar]</font></p>",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"fontname":[false,false,"serif",false,false,"sans-serif"]}],
["<b>foo[]bar</b>",
    [["fontname","sans-serif"]],
    "<b>foo[]bar</b>",
    [true],
    {"fontname":[false,false,"serif",false,false,"sans-serif"]}],
["<i>foo[]bar</i>",
    [["fontname","sans-serif"]],
    "<i>foo[]bar</i>",
    [true],
    {"fontname":[false,false,"serif",false,false,"sans-serif"]}],
["<span>foo</span>{}<span>bar</span>",
    [["fontname","sans-serif"]],
    "<span>foo</span>{}<span>bar</span>",
    [true],
    {"fontname":[false,false,"serif",false,false,"sans-serif"]}],
["<span>foo[</span><span>]bar</span>",
    [["fontname","sans-serif"]],
    "<span>foo[</span><span>]bar</span>",
    [true],
    {"fontname":[false,false,"serif",false,false,"sans-serif"]}],
["foo[bar]baz",
    [["stylewithcss","true"],["fontname","sans-serif"]],
    "foo<span style=\"font-family:sans-serif\">[bar]</span>baz",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"fontname":[false,false,"serif",false,false,"sans-serif"]}],
["foo[bar]baz",
    [["stylewithcss","false"],["fontname","sans-serif"]],
    "foo<font face=\"sans-serif\">[bar]</font>baz",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"fontname":[false,false,"serif",false,false,"sans-serif"]}],
["foo[bar<b>baz]qoz</b>quz",
    [["stylewithcss","true"],["fontname","sans-serif"]],
    "foo<span style=\"font-family:sans-serif\">[bar</span><b><span style=\"font-family:sans-serif\">baz]</span>qoz</b>quz",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"fontname":[false,false,"serif",false,false,"sans-serif"]}],
["foo[bar<b>baz]qoz</b>quz",
    [["stylewithcss","false"],["fontname","sans-serif"]],
    "foo<font face=\"sans-serif\">[bar</font><b><font face=\"sans-serif\">baz]</font>qoz</b>quz",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"fontname":[false,false,"serif",false,false,"sans-serif"]}],
["foo[bar<i>baz]qoz</i>quz",
    [["stylewithcss","true"],["fontname","sans-serif"]],
    "foo<span style=\"font-family:sans-serif\">[bar</span><i><span style=\"font-family:sans-serif\">baz]</span>qoz</i>quz",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"fontname":[false,false,"serif",false,false,"sans-serif"]}],
["foo[bar<i>baz]qoz</i>quz",
    [["stylewithcss","false"],["fontname","sans-serif"]],
    "foo<font face=\"sans-serif\">[bar</font><i><font face=\"sans-serif\">baz]</font>qoz</i>quz",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"fontname":[false,false,"serif",false,false,"sans-serif"]}],
["{<p><p> <p>foo</p>}",
    [["stylewithcss","true"],["fontname","sans-serif"]],
    "{<p></p><p> </p><p><span style=\"font-family:sans-serif\">foo</span></p>}",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"fontname":[false,false,"serif",false,false,"sans-serif"]}],
["{<p><p> <p>foo</p>}",
    [["stylewithcss","false"],["fontname","sans-serif"]],
    "{<p></p><p> </p><p><font face=\"sans-serif\">foo</font></p>}",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"fontname":[false,false,"serif",false,false,"sans-serif"]}],
["<table><tbody><tr><td>foo<td>b[a]r<td>baz</table>",
    [["stylewithcss","true"],["fontname","sans-serif"]],
    "<table><tbody><tr><td>foo</td><td>b<span style=\"font-family:sans-serif\">[a]</span>r</td><td>baz</td></tr></tbody></table>",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"fontname":[false,false,"serif",false,false,"sans-serif"]}],
["<table><tbody><tr><td>foo<td>b[a]r<td>baz</table>",
    [["stylewithcss","false"],["fontname","sans-serif"]],
    "<table><tbody><tr><td>foo</td><td>b<font face=\"sans-serif\">[a]</font>r</td><td>baz</td></tr></tbody></table>",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"fontname":[false,false,"serif",false,false,"sans-serif"]}],
["<table><tbody><tr data-start=1 data-end=2><td>foo<td>bar<td>baz</table>",
    [["stylewithcss","true"],["fontname","sans-serif"]],
    "<table><tbody><tr><td>foo</td>{<td><span style=\"font-family:sans-serif\">bar</span></td>}<td>baz</td></tr></tbody></table>",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"fontname":[false,false,"serif",false,false,"sans-serif"]}],
["<table><tbody><tr data-start=1 data-end=2><td>foo<td>bar<td>baz</table>",
    [["stylewithcss","false"],["fontname","sans-serif"]],
    "<table><tbody><tr><td>foo</td>{<td><font face=\"sans-serif\">bar</font></td>}<td>baz</td></tr></tbody></table>",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"fontname":[false,false,"serif",false,false,"sans-serif"]}],
["<table><tbody><tr data-start=0 data-end=2><td>foo<td>bar<td>baz</table>",
    [["stylewithcss","true"],["fontname","sans-serif"]],
    "<table><tbody><tr>{<td><span style=\"font-family:sans-serif\">foo</span></td><td><span style=\"font-family:sans-serif\">bar</span></td>}<td>baz</td></tr></tbody></table>",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"fontname":[false,false,"serif",false,false,"sans-serif"]}],
["<table><tbody><tr data-start=0 data-end=2><td>foo<td>bar<td>baz</table>",
    [["stylewithcss","false"],["fontname","sans-serif"]],
    "<table><tbody><tr>{<td><font face=\"sans-serif\">foo</font></td><td><font face=\"sans-serif\">bar</font></td>}<td>baz</td></tr></tbody></table>",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"fontname":[false,false,"serif",false,false,"sans-serif"]}],
["<table><tbody data-start=0 data-end=1><tr><td>foo<td>bar<td>baz</table>",
    [["stylewithcss","true"],["fontname","sans-serif"]],
    "<table><tbody>{<tr><td><span style=\"font-family:sans-serif\">foo</span></td><td><span style=\"font-family:sans-serif\">bar</span></td><td><span style=\"font-family:sans-serif\">baz</span></td></tr>}</tbody></table>",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"fontname":[false,false,"serif",false,false,"sans-serif"]}],
["<table><tbody data-start=0 data-end=1><tr><td>foo<td>bar<td>baz</table>",
    [["stylewithcss","false"],["fontname","sans-serif"]],
    "<table><tbody>{<tr><td><font face=\"sans-serif\">foo</font></td><td><font face=\"sans-serif\">bar</font></td><td><font face=\"sans-serif\">baz</font></td></tr>}</tbody></table>",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"fontname":[false,false,"serif",false,false,"sans-serif"]}],
["<table data-start=0 data-end=1><tbody><tr><td>foo<td>bar<td>baz</table>",
    [["stylewithcss","true"],["fontname","sans-serif"]],
    "<table>{<tbody><tr><td><span style=\"font-family:sans-serif\">foo</span></td><td><span style=\"font-family:sans-serif\">bar</span></td><td><span style=\"font-family:sans-serif\">baz</span></td></tr></tbody>}</table>",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"fontname":[false,false,"serif",false,false,"sans-serif"]}],
["<table data-start=0 data-end=1><tbody><tr><td>foo<td>bar<td>baz</table>",
    [["stylewithcss","false"],["fontname","sans-serif"]],
    "<table>{<tbody><tr><td><font face=\"sans-serif\">foo</font></td><td><font face=\"sans-serif\">bar</font></td><td><font face=\"sans-serif\">baz</font></td></tr></tbody>}</table>",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"fontname":[false,false,"serif",false,false,"sans-serif"]}],
["{<table><tr><td>foo<td>bar<td>baz</table>}",
    [["stylewithcss","true"],["fontname","sans-serif"]],
    "{<table><tbody><tr><td><span style=\"font-family:sans-serif\">foo</span></td><td><span style=\"font-family:sans-serif\">bar</span></td><td><span style=\"font-family:sans-serif\">baz</span></td></tr></tbody></table>}",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"fontname":[false,false,"serif",false,false,"sans-serif"]}],
["{<table><tr><td>foo<td>bar<td>baz</table>}",
    [["stylewithcss","false"],["fontname","sans-serif"]],
    "{<table><tbody><tr><td><font face=\"sans-serif\">foo</font></td><td><font face=\"sans-serif\">bar</font></td><td><font face=\"sans-serif\">baz</font></td></tr></tbody></table>}",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"fontname":[false,false,"serif",false,false,"sans-serif"]}],
["foo<code>[bar]</code>baz",
    [["stylewithcss","true"],["fontname","sans-serif"]],
    "foo<code><span style=\"font-family:sans-serif\">[bar]</span></code>baz",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"fontname":[false,false,"monospace",false,false,"sans-serif"]}],
["foo<code>[bar]</code>baz",
    [["stylewithcss","false"],["fontname","sans-serif"]],
    "foo<code><font face=\"sans-serif\">[bar]</font></code>baz",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"fontname":[false,false,"monospace",false,false,"sans-serif"]}],
["foo<kbd>[bar]</kbd>baz",
    [["stylewithcss","true"],["fontname","sans-serif"]],
    "foo<kbd><span style=\"font-family:sans-serif\">[bar]</span></kbd>baz",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"fontname":[false,false,"monospace",false,false,"sans-serif"]}],
["foo<kbd>[bar]</kbd>baz",
    [["stylewithcss","false"],["fontname","sans-serif"]],
    "foo<kbd><font face=\"sans-serif\">[bar]</font></kbd>baz",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"fontname":[false,false,"monospace",false,false,"sans-serif"]}],
["foo<listing>[bar]</listing>baz",
    [["stylewithcss","true"],["fontname","sans-serif"]],
    "foo<listing><span style=\"font-family:sans-serif\">[bar]</span></listing>baz",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"fontname":[false,false,"monospace",false,false,"sans-serif"]}],
["foo<listing>[bar]</listing>baz",
    [["stylewithcss","false"],["fontname","sans-serif"]],
    "foo<listing><font face=\"sans-serif\">[bar]</font></listing>baz",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"fontname":[false,false,"monospace",false,false,"sans-serif"]}],
["foo<pre>[bar]</pre>baz",
    [["stylewithcss","true"],["fontname","sans-serif"]],
    "foo<pre><span style=\"font-family:sans-serif\">[bar]</span></pre>baz",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"fontname":[false,false,"monospace",false,false,"sans-serif"]}],
["foo<pre>[bar]</pre>baz",
    [["stylewithcss","false"],["fontname","sans-serif"]],
    "foo<pre><font face=\"sans-serif\">[bar]</font></pre>baz",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"fontname":[false,false,"monospace",false,false,"sans-serif"]}],
["foo<samp>[bar]</samp>baz",
    [["stylewithcss","true"],["fontname","sans-serif"]],
    "foo<samp><span style=\"font-family:sans-serif\">[bar]</span></samp>baz",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"fontname":[false,false,"monospace",false,false,"sans-serif"]}],
["foo<samp>[bar]</samp>baz",
    [["stylewithcss","false"],["fontname","sans-serif"]],
    "foo<samp><font face=\"sans-serif\">[bar]</font></samp>baz",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"fontname":[false,false,"monospace",false,false,"sans-serif"]}],
["foo<tt>[bar]</tt>baz",
    [["stylewithcss","true"],["fontname","sans-serif"]],
    "foo<tt><span style=\"font-family:sans-serif\">[bar]</span></tt>baz",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"fontname":[false,false,"monospace",false,false,"sans-serif"]}],
["foo<tt>[bar]</tt>baz",
    [["stylewithcss","false"],["fontname","sans-serif"]],
    "foo<tt><font face=\"sans-serif\">[bar]</font></tt>baz",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"fontname":[false,false,"monospace",false,false,"sans-serif"]}],
["foo<code>b[a]r</code>baz",
    [["stylewithcss","true"],["fontname","sans-serif"]],
    "foo<code>b<span style=\"font-family:sans-serif\">[a]</span>r</code>baz",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"fontname":[false,false,"monospace",false,false,"sans-serif"]}],
["foo<code>b[a]r</code>baz",
    [["stylewithcss","false"],["fontname","sans-serif"]],
    "foo<code>b<font face=\"sans-serif\">[a]</font>r</code>baz",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"fontname":[false,false,"monospace",false,false,"sans-serif"]}],
["foo<kbd>b[a]r</kbd>baz",
    [["stylewithcss","true"],["fontname","sans-serif"]],
    "foo<kbd>b<span style=\"font-family:sans-serif\">[a]</span>r</kbd>baz",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"fontname":[false,false,"monospace",false,false,"sans-serif"]}],
["foo<kbd>b[a]r</kbd>baz",
    [["stylewithcss","false"],["fontname","sans-serif"]],
    "foo<kbd>b<font face=\"sans-serif\">[a]</font>r</kbd>baz",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"fontname":[false,false,"monospace",false,false,"sans-serif"]}],
["foo<listing>b[a]r</listing>baz",
    [["stylewithcss","true"],["fontname","sans-serif"]],
    "foo<listing>b<span style=\"font-family:sans-serif\">[a]</span>r</listing>baz",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"fontname":[false,false,"monospace",false,false,"sans-serif"]}],
["foo<listing>b[a]r</listing>baz",
    [["stylewithcss","false"],["fontname","sans-serif"]],
    "foo<listing>b<font face=\"sans-serif\">[a]</font>r</listing>baz",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"fontname":[false,false,"monospace",false,false,"sans-serif"]}],
["foo<pre>b[a]r</pre>baz",
    [["stylewithcss","true"],["fontname","sans-serif"]],
    "foo<pre>b<span style=\"font-family:sans-serif\">[a]</span>r</pre>baz",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"fontname":[false,false,"monospace",false,false,"sans-serif"]}],
["foo<pre>b[a]r</pre>baz",
    [["stylewithcss","false"],["fontname","sans-serif"]],
    "foo<pre>b<font face=\"sans-serif\">[a]</font>r</pre>baz",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"fontname":[false,false,"monospace",false,false,"sans-serif"]}],
["foo<samp>b[a]r</samp>baz",
    [["stylewithcss","true"],["fontname","sans-serif"]],
    "foo<samp>b<span style=\"font-family:sans-serif\">[a]</span>r</samp>baz",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"fontname":[false,false,"monospace",false,false,"sans-serif"]}],
["foo<samp>b[a]r</samp>baz",
    [["stylewithcss","false"],["fontname","sans-serif"]],
    "foo<samp>b<font face=\"sans-serif\">[a]</font>r</samp>baz",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"fontname":[false,false,"monospace",false,false,"sans-serif"]}],
["foo<tt>b[a]r</tt>baz",
    [["stylewithcss","true"],["fontname","sans-serif"]],
    "foo<tt>b<span style=\"font-family:sans-serif\">[a]</span>r</tt>baz",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"fontname":[false,false,"monospace",false,false,"sans-serif"]}],
["foo<tt>b[a]r</tt>baz",
    [["stylewithcss","false"],["fontname","sans-serif"]],
    "foo<tt>b<font face=\"sans-serif\">[a]</font>r</tt>baz",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"fontname":[false,false,"monospace",false,false,"sans-serif"]}],
["[foo<code>bar</code>baz]",
    [["stylewithcss","true"],["fontname","sans-serif"]],
    "<span style=\"font-family:sans-serif\">[foo<code><span style=\"font-family:sans-serif\">bar</span></code>baz]</span>",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"fontname":[true,false,"serif",false,false,"sans-serif"]}],
["[foo<code>bar</code>baz]",
    [["stylewithcss","false"],["fontname","sans-serif"]],
    "<font face=\"sans-serif\">[foo<code><font face=\"sans-serif\">bar</font></code>baz]</font>",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"fontname":[true,false,"serif",false,false,"sans-serif"]}],
["[foo<kbd>bar</kbd>baz]",
    [["stylewithcss","true"],["fontname","sans-serif"]],
    "<span style=\"font-family:sans-serif\">[foo<kbd><span style=\"font-family:sans-serif\">bar</span></kbd>baz]</span>",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"fontname":[true,false,"serif",false,false,"sans-serif"]}],
["[foo<kbd>bar</kbd>baz]",
    [["stylewithcss","false"],["fontname","sans-serif"]],
    "<font face=\"sans-serif\">[foo<kbd><font face=\"sans-serif\">bar</font></kbd>baz]</font>",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"fontname":[true,false,"serif",false,false,"sans-serif"]}],
["[foo<listing>bar</listing>baz]",
    [["stylewithcss","true"],["fontname","sans-serif"]],
    "<span style=\"font-family:sans-serif\">[foo</span><listing><span style=\"font-family:sans-serif\">bar</span></listing><span style=\"font-family:sans-serif\">baz]</span>",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"fontname":[true,false,"serif",false,false,"sans-serif"]}],
["[foo<listing>bar</listing>baz]",
    [["stylewithcss","false"],["fontname","sans-serif"]],
    "<font face=\"sans-serif\">[foo</font><listing><font face=\"sans-serif\">bar</font></listing><font face=\"sans-serif\">baz]</font>",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"fontname":[true,false,"serif",false,false,"sans-serif"]}],
["[foo<pre>bar</pre>baz]",
    [["stylewithcss","true"],["fontname","sans-serif"]],
    "<span style=\"font-family:sans-serif\">[foo</span><pre><span style=\"font-family:sans-serif\">bar</span></pre><span style=\"font-family:sans-serif\">baz]</span>",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"fontname":[true,false,"serif",false,false,"sans-serif"]}],
["[foo<pre>bar</pre>baz]",
    [["stylewithcss","false"],["fontname","sans-serif"]],
    "<font face=\"sans-serif\">[foo</font><pre><font face=\"sans-serif\">bar</font></pre><font face=\"sans-serif\">baz]</font>",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"fontname":[true,false,"serif",false,false,"sans-serif"]}],
["[foo<samp>bar</samp>baz]",
    [["stylewithcss","true"],["fontname","sans-serif"]],
    "<span style=\"font-family:sans-serif\">[foo<samp><span style=\"font-family:sans-serif\">bar</span></samp>baz]</span>",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"fontname":[true,false,"serif",false,false,"sans-serif"]}],
["[foo<samp>bar</samp>baz]",
    [["stylewithcss","false"],["fontname","sans-serif"]],
    "<font face=\"sans-serif\">[foo<samp><font face=\"sans-serif\">bar</font></samp>baz]</font>",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"fontname":[true,false,"serif",false,false,"sans-serif"]}],
["[foo<tt>bar</tt>baz]",
    [["stylewithcss","true"],["fontname","sans-serif"]],
    "<span style=\"font-family:sans-serif\">[foo<tt><span style=\"font-family:sans-serif\">bar</span></tt>baz]</span>",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"fontname":[true,false,"serif",false,false,"sans-serif"]}],
["[foo<tt>bar</tt>baz]",
    [["stylewithcss","false"],["fontname","sans-serif"]],
    "<font face=\"sans-serif\">[foo<tt><font face=\"sans-serif\">bar</font></tt>baz]</font>",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"fontname":[true,false,"serif",false,false,"sans-serif"]}],
["[foo<code>ba]r</code>baz",
    [["stylewithcss","true"],["fontname","sans-serif"]],
    "<span style=\"font-family:sans-serif\">[foo</span><code><span style=\"font-family:sans-serif\">ba]</span>r</code>baz",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"fontname":[true,false,"serif",false,false,"sans-serif"]}],
["[foo<code>ba]r</code>baz",
    [["stylewithcss","false"],["fontname","sans-serif"]],
    "<font face=\"sans-serif\">[foo</font><code><font face=\"sans-serif\">ba]</font>r</code>baz",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"fontname":[true,false,"serif",false,false,"sans-serif"]}],
["[foo<kbd>ba]r</kbd>baz",
    [["stylewithcss","true"],["fontname","sans-serif"]],
    "<span style=\"font-family:sans-serif\">[foo</span><kbd><span style=\"font-family:sans-serif\">ba]</span>r</kbd>baz",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"fontname":[true,false,"serif",false,false,"sans-serif"]}],
["[foo<kbd>ba]r</kbd>baz",
    [["stylewithcss","false"],["fontname","sans-serif"]],
    "<font face=\"sans-serif\">[foo</font><kbd><font face=\"sans-serif\">ba]</font>r</kbd>baz",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"fontname":[true,false,"serif",false,false,"sans-serif"]}],
["[foo<listing>ba]r</listing>baz",
    [["stylewithcss","true"],["fontname","sans-serif"]],
    "<span style=\"font-family:sans-serif\">[foo</span><listing><span style=\"font-family:sans-serif\">ba]</span>r</listing>baz",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"fontname":[true,false,"serif",false,false,"sans-serif"]}],
["[foo<listing>ba]r</listing>baz",
    [["stylewithcss","false"],["fontname","sans-serif"]],
    "<font face=\"sans-serif\">[foo</font><listing><font face=\"sans-serif\">ba]</font>r</listing>baz",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"fontname":[true,false,"serif",false,false,"sans-serif"]}],
["[foo<pre>ba]r</pre>baz",
    [["stylewithcss","true"],["fontname","sans-serif"]],
    "<span style=\"font-family:sans-serif\">[foo</span><pre><span style=\"font-family:sans-serif\">ba]</span>r</pre>baz",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"fontname":[true,false,"serif",false,false,"sans-serif"]}],
["[foo<pre>ba]r</pre>baz",
    [["stylewithcss","false"],["fontname","sans-serif"]],
    "<font face=\"sans-serif\">[foo</font><pre><font face=\"sans-serif\">ba]</font>r</pre>baz",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"fontname":[true,false,"serif",false,false,"sans-serif"]}],
["[foo<samp>ba]r</samp>baz",
    [["stylewithcss","true"],["fontname","sans-serif"]],
    "<span style=\"font-family:sans-serif\">[foo</span><samp><span style=\"font-family:sans-serif\">ba]</span>r</samp>baz",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"fontname":[true,false,"serif",false,false,"sans-serif"]}],
["[foo<samp>ba]r</samp>baz",
    [["stylewithcss","false"],["fontname","sans-serif"]],
    "<font face=\"sans-serif\">[foo</font><samp><font face=\"sans-serif\">ba]</font>r</samp>baz",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"fontname":[true,false,"serif",false,false,"sans-serif"]}],
["[foo<tt>ba]r</tt>baz",
    [["stylewithcss","true"],["fontname","sans-serif"]],
    "<span style=\"font-family:sans-serif\">[foo</span><tt><span style=\"font-family:sans-serif\">ba]</span>r</tt>baz",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"fontname":[true,false,"serif",false,false,"sans-serif"]}],
["[foo<tt>ba]r</tt>baz",
    [["stylewithcss","false"],["fontname","sans-serif"]],
    "<font face=\"sans-serif\">[foo</font><tt><font face=\"sans-serif\">ba]</font>r</tt>baz",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"fontname":[true,false,"serif",false,false,"sans-serif"]}],
["foo<code>b[ar</code>baz]",
    [["stylewithcss","true"],["fontname","sans-serif"]],
    "foo<code>b<span style=\"font-family:sans-serif\">[ar</span></code><span style=\"font-family:sans-serif\">baz]</span>",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"fontname":[true,false,"monospace",false,false,"sans-serif"]}],
["foo<code>b[ar</code>baz]",
    [["stylewithcss","false"],["fontname","sans-serif"]],
    "foo<code>b<font face=\"sans-serif\">[ar</font></code><font face=\"sans-serif\">baz]</font>",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"fontname":[true,false,"monospace",false,false,"sans-serif"]}],
["foo<kbd>b[ar</kbd>baz]",
    [["stylewithcss","true"],["fontname","sans-serif"]],
    "foo<kbd>b<span style=\"font-family:sans-serif\">[ar</span></kbd><span style=\"font-family:sans-serif\">baz]</span>",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"fontname":[true,false,"monospace",false,false,"sans-serif"]}],
["foo<kbd>b[ar</kbd>baz]",
    [["stylewithcss","false"],["fontname","sans-serif"]],
    "foo<kbd>b<font face=\"sans-serif\">[ar</font></kbd><font face=\"sans-serif\">baz]</font>",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"fontname":[true,false,"monospace",false,false,"sans-serif"]}],
["foo<listing>b[ar</listing>baz]",
    [["stylewithcss","true"],["fontname","sans-serif"]],
    "foo<listing>b<span style=\"font-family:sans-serif\">[ar</span></listing><span style=\"font-family:sans-serif\">baz]</span>",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"fontname":[true,false,"monospace",false,false,"sans-serif"]}],
["foo<listing>b[ar</listing>baz]",
    [["stylewithcss","false"],["fontname","sans-serif"]],
    "foo<listing>b<font face=\"sans-serif\">[ar</font></listing><font face=\"sans-serif\">baz]</font>",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"fontname":[true,false,"monospace",false,false,"sans-serif"]}],
["foo<pre>b[ar</pre>baz]",
    [["stylewithcss","true"],["fontname","sans-serif"]],
    "foo<pre>b<span style=\"font-family:sans-serif\">[ar</span></pre><span style=\"font-family:sans-serif\">baz]</span>",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"fontname":[true,false,"monospace",false,false,"sans-serif"]}],
["foo<pre>b[ar</pre>baz]",
    [["stylewithcss","false"],["fontname","sans-serif"]],
    "foo<pre>b<font face=\"sans-serif\">[ar</font></pre><font face=\"sans-serif\">baz]</font>",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"fontname":[true,false,"monospace",false,false,"sans-serif"]}],
["foo<samp>b[ar</samp>baz]",
    [["stylewithcss","true"],["fontname","sans-serif"]],
    "foo<samp>b<span style=\"font-family:sans-serif\">[ar</span></samp><span style=\"font-family:sans-serif\">baz]</span>",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"fontname":[true,false,"monospace",false,false,"sans-serif"]}],
["foo<samp>b[ar</samp>baz]",
    [["stylewithcss","false"],["fontname","sans-serif"]],
    "foo<samp>b<font face=\"sans-serif\">[ar</font></samp><font face=\"sans-serif\">baz]</font>",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"fontname":[true,false,"monospace",false,false,"sans-serif"]}],
["foo<tt>b[ar</tt>baz]",
    [["stylewithcss","true"],["fontname","sans-serif"]],
    "foo<tt>b<span style=\"font-family:sans-serif\">[ar</span></tt><span style=\"font-family:sans-serif\">baz]</span>",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"fontname":[true,false,"monospace",false,false,"sans-serif"]}],
["foo<tt>b[ar</tt>baz]",
    [["stylewithcss","false"],["fontname","sans-serif"]],
    "foo<tt>b<font face=\"sans-serif\">[ar</font></tt><font face=\"sans-serif\">baz]</font>",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"fontname":[true,false,"monospace",false,false,"sans-serif"]}],
["foo<span style=\"font-family: sans-serif\">[bar]</span>baz",
    [["stylewithcss","true"],["fontname","sans-serif"]],
    "foo<span style=\"font-family:sans-serif\">[bar]</span>baz",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"fontname":[false,false,"sans-serif",false,false,"sans-serif"]}],
["foo<span style=\"font-family: sans-serif\">[bar]</span>baz",
    [["stylewithcss","false"],["fontname","sans-serif"]],
    "foo<font face=\"sans-serif\">[bar]</font>baz",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"fontname":[false,false,"sans-serif",false,false,"sans-serif"]}],
["foo<span style=\"font-family: sans-serif\">b[a]r</span>baz",
    [["fontname","sans-serif"]],
    "foo<span style=\"font-family:sans-serif\">b[a]r</span>baz",
    [true],
    {"fontname":[false,false,"sans-serif",false,false,"sans-serif"]}],
["foo<span style=\"font-family: monospace\">[bar]</span>baz",
    [["stylewithcss","true"],["fontname","sans-serif"]],
    "foo<span style=\"font-family:sans-serif\">[bar]</span>baz",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"fontname":[false,false,"monospace",false,false,"sans-serif"]}],
["foo<span style=\"font-family: monospace\">[bar]</span>baz",
    [["stylewithcss","false"],["fontname","sans-serif"]],
    "foo<font face=\"sans-serif\">[bar]</font>baz",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"fontname":[false,false,"monospace",false,false,"sans-serif"]}],
["foo<span style=\"font-family: monospace\">b[a]r</span>baz",
    [["stylewithcss","true"],["fontname","sans-serif"]],
    "foo<span style=\"font-family:monospace\">b<span style=\"font-family:sans-serif\">[a]</span>r</span>baz",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"fontname":[false,false,"monospace",false,false,"sans-serif"]}],
["foo<span style=\"font-family: monospace\">b[a]r</span>baz",
    [["stylewithcss","false"],["fontname","sans-serif"]],
    "foo<span style=\"font-family:monospace\">b<font face=\"sans-serif\">[a]</font>r</span>baz",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"fontname":[false,false,"monospace",false,false,"sans-serif"]}],
["foo<tt contenteditable=false>ba[r</tt>b]az",
    [["fontname","sans-serif"]],
    "foo<tt contenteditable=\"false\">ba[r</tt>b]az",
    [false],
    {"fontname":[false,false,"serif",false,false,"serif"]}],
["fo[o<tt contenteditable=false>b]ar</tt>baz",
    [["fontname","sans-serif"]],
    "fo[o<tt contenteditable=\"false\">b]ar</tt>baz",
    [false],
    {"fontname":[false,false,"serif",false,false,"serif"]}],
["foo<tt>{}<br></tt>bar",
    [["fontname","sans-serif"]],
    "foo<tt>{}<br></tt>bar",
    [true],
    {"fontname":[false,false,"monospace",false,false,"sans-serif"]}],
["foo<tt>{<br></tt>}bar",
    [["stylewithcss","true"],["fontname","sans-serif"]],
    "foo<tt>{<span style=\"font-family:sans-serif\"><br></span></tt>}bar",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"fontname":[false,false,"monospace",false,false,"sans-serif"]}],
["foo<tt>{<br></tt>}bar",
    [["stylewithcss","false"],["fontname","sans-serif"]],
    "foo<tt>{<font face=\"sans-serif\"><br></font></tt>}bar",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"fontname":[false,false,"monospace",false,false,"sans-serif"]}],
["foo<tt>{<br></tt>b]ar",
    [["stylewithcss","true"],["fontname","sans-serif"]],
    "foo<tt>{<span style=\"font-family:sans-serif\"><br></span></tt><span style=\"font-family:sans-serif\">b]</span>ar",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"fontname":[true,false,"monospace",false,false,"sans-serif"]}],
["foo<tt>{<br></tt>b]ar",
    [["stylewithcss","false"],["fontname","sans-serif"]],
    "foo<tt>{<font face=\"sans-serif\"><br></font></tt><font face=\"sans-serif\">b]</font>ar",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"fontname":[true,false,"monospace",false,false,"sans-serif"]}],
["fo[o<span style=font-family:monospace>b]ar</span>baz",
    [["stylewithcss","true"],["fontname","sans-serif"]],
    "fo<span style=\"font-family:sans-serif\">[o</span><span style=\"font-family:monospace\"><span style=\"font-family:sans-serif\">b]</span>ar</span>baz",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"fontname":[true,false,"serif",false,false,"sans-serif"]}],
["fo[o<span style=font-family:monospace>b]ar</span>baz",
    [["stylewithcss","false"],["fontname","sans-serif"]],
    "fo<font face=\"sans-serif\">[o</font><span style=\"font-family:monospace\"><font face=\"sans-serif\">b]</font>ar</span>baz",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"fontname":[true,false,"serif",false,false,"sans-serif"]}],
["foo<span style=font-family:monospace>ba[r</span>b]az",
    [["stylewithcss","true"],["fontname","sans-serif"]],
    "foo<span style=\"font-family:monospace\">ba<span style=\"font-family:sans-serif\">[r</span></span><span style=\"font-family:sans-serif\">b]</span>az",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"fontname":[true,false,"monospace",false,false,"sans-serif"]}],
["foo<span style=font-family:monospace>ba[r</span>b]az",
    [["stylewithcss","false"],["fontname","sans-serif"]],
    "foo<span style=\"font-family:monospace\">ba<font face=\"sans-serif\">[r</font></span><font face=\"sans-serif\">b]</font>az",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"fontname":[true,false,"monospace",false,false,"sans-serif"]}],
["fo[o<span style=font-family:monospace>bar</span>b]az",
    [["stylewithcss","true"],["fontname","sans-serif"]],
    "fo<span style=\"font-family:sans-serif\">[obarb]</span>az",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"fontname":[true,false,"serif",false,false,"sans-serif"]}],
["fo[o<span style=font-family:monospace>bar</span>b]az",
    [["stylewithcss","false"],["fontname","sans-serif"]],
    "fo<font face=\"sans-serif\">[obarb]</font>az",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"fontname":[true,false,"serif",false,false,"sans-serif"]}],
["foo[<span style=font-family:monospace>b]ar</span>baz",
    [["stylewithcss","true"],["fontname","sans-serif"]],
    "foo[<span style=\"font-family:monospace\"><span style=\"font-family:sans-serif\">b]</span>ar</span>baz",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"fontname":[false,false,"monospace",false,false,"sans-serif"]}],
["foo[<span style=font-family:monospace>b]ar</span>baz",
    [["stylewithcss","false"],["fontname","sans-serif"]],
    "foo[<span style=\"font-family:monospace\"><font face=\"sans-serif\">b]</font>ar</span>baz",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"fontname":[false,false,"monospace",false,false,"sans-serif"]}],
["foo<span style=font-family:monospace>ba[r</span>]baz",
    [["stylewithcss","true"],["fontname","sans-serif"]],
    "foo<span style=\"font-family:monospace\">ba<span style=\"font-family:sans-serif\">[r</span></span>]baz",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"fontname":[false,false,"monospace",false,false,"sans-serif"]}],
["foo<span style=font-family:monospace>ba[r</span>]baz",
    [["stylewithcss","false"],["fontname","sans-serif"]],
    "foo<span style=\"font-family:monospace\">ba<font face=\"sans-serif\">[r</font></span>]baz",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"fontname":[false,false,"monospace",false,false,"sans-serif"]}],
["foo[<span style=font-family:monospace>bar</span>]baz",
    [["stylewithcss","true"],["fontname","sans-serif"]],
    "foo[<span style=\"font-family:sans-serif\">bar</span>]baz",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"fontname":[false,false,"monospace",false,false,"sans-serif"]}],
["foo[<span style=font-family:monospace>bar</span>]baz",
    [["stylewithcss","false"],["fontname","sans-serif"]],
    "foo[<font face=\"sans-serif\">bar</font>]baz",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"fontname":[false,false,"monospace",false,false,"sans-serif"]}],
["foo<span style=font-family:monospace>[bar]</span>baz",
    [["stylewithcss","true"],["fontname","sans-serif"]],
    "foo<span style=\"font-family:sans-serif\">[bar]</span>baz",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"fontname":[false,false,"monospace",false,false,"sans-serif"]}],
["foo<span style=font-family:monospace>[bar]</span>baz",
    [["stylewithcss","false"],["fontname","sans-serif"]],
    "foo<font face=\"sans-serif\">[bar]</font>baz",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"fontname":[false,false,"monospace",false,false,"sans-serif"]}],
["foo{<span style=font-family:monospace>bar</span>}baz",
    [["stylewithcss","true"],["fontname","sans-serif"]],
    "foo{<span style=\"font-family:sans-serif\">bar}</span>baz",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"fontname":[false,false,"monospace",false,false,"sans-serif"]}],
["foo{<span style=font-family:monospace>bar</span>}baz",
    [["stylewithcss","false"],["fontname","sans-serif"]],
    "foo{<font face=\"sans-serif\">bar}</font>baz",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"fontname":[false,false,"monospace",false,false,"sans-serif"]}],
["fo[o<code>b]ar</code>",
    [["stylewithcss","true"],["fontname","sans-serif"]],
    "fo<span style=\"font-family:sans-serif\">[o</span><code><span style=\"font-family:sans-serif\">b]</span>ar</code>",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"fontname":[true,false,"serif",false,false,"sans-serif"]}],
["fo[o<code>b]ar</code>",
    [["stylewithcss","false"],["fontname","sans-serif"]],
    "fo<font face=\"sans-serif\">[o</font><code><font face=\"sans-serif\">b]</font>ar</code>",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"fontname":[true,false,"serif",false,false,"sans-serif"]}],
["fo[o<kbd>b]ar</kbd>",
    [["stylewithcss","true"],["fontname","sans-serif"]],
    "fo<span style=\"font-family:sans-serif\">[o</span><kbd><span style=\"font-family:sans-serif\">b]</span>ar</kbd>",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"fontname":[true,false,"serif",false,false,"sans-serif"]}],
["fo[o<kbd>b]ar</kbd>",
    [["stylewithcss","false"],["fontname","sans-serif"]],
    "fo<font face=\"sans-serif\">[o</font><kbd><font face=\"sans-serif\">b]</font>ar</kbd>",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"fontname":[true,false,"serif",false,false,"sans-serif"]}],
["fo[o<listing>b]ar</listing>",
    [["stylewithcss","true"],["fontname","sans-serif"]],
    "fo<span style=\"font-family:sans-serif\">[o</span><listing><span style=\"font-family:sans-serif\">b]</span>ar</listing>",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"fontname":[true,false,"serif",false,false,"sans-serif"]}],
["fo[o<listing>b]ar</listing>",
    [["stylewithcss","false"],["fontname","sans-serif"]],
    "fo<font face=\"sans-serif\">[o</font><listing><font face=\"sans-serif\">b]</font>ar</listing>",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"fontname":[true,false,"serif",false,false,"sans-serif"]}],
["fo[o<pre>b]ar</pre>",
    [["stylewithcss","true"],["fontname","sans-serif"]],
    "fo<span style=\"font-family:sans-serif\">[o</span><pre><span style=\"font-family:sans-serif\">b]</span>ar</pre>",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"fontname":[true,false,"serif",false,false,"sans-serif"]}],
["fo[o<pre>b]ar</pre>",
    [["stylewithcss","false"],["fontname","sans-serif"]],
    "fo<font face=\"sans-serif\">[o</font><pre><font face=\"sans-serif\">b]</font>ar</pre>",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"fontname":[true,false,"serif",false,false,"sans-serif"]}],
["fo[o<samp>b]ar</samp>",
    [["stylewithcss","true"],["fontname","sans-serif"]],
    "fo<span style=\"font-family:sans-serif\">[o</span><samp><span style=\"font-family:sans-serif\">b]</span>ar</samp>",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"fontname":[true,false,"serif",false,false,"sans-serif"]}],
["fo[o<samp>b]ar</samp>",
    [["stylewithcss","false"],["fontname","sans-serif"]],
    "fo<font face=\"sans-serif\">[o</font><samp><font face=\"sans-serif\">b]</font>ar</samp>",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"fontname":[true,false,"serif",false,false,"sans-serif"]}],
["fo[o<tt>b]ar</tt>",
    [["stylewithcss","true"],["fontname","sans-serif"]],
    "fo<span style=\"font-family:sans-serif\">[o</span><tt><span style=\"font-family:sans-serif\">b]</span>ar</tt>",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"fontname":[true,false,"serif",false,false,"sans-serif"]}],
["fo[o<tt>b]ar</tt>",
    [["stylewithcss","false"],["fontname","sans-serif"]],
    "fo<font face=\"sans-serif\">[o</font><tt><font face=\"sans-serif\">b]</font>ar</tt>",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"fontname":[true,false,"serif",false,false,"sans-serif"]}],
["<tt>fo[o</tt><code>b]ar</code>",
    [["stylewithcss","true"],["fontname","sans-serif"]],
    "<tt>fo<span style=\"font-family:sans-serif\">[o</span></tt><code><span style=\"font-family:sans-serif\">b]</span>ar</code>",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"fontname":[false,false,"monospace",false,false,"sans-serif"]}],
["<tt>fo[o</tt><code>b]ar</code>",
    [["stylewithcss","false"],["fontname","sans-serif"]],
    "<tt>fo<font face=\"sans-serif\">[o</font></tt><code><font face=\"sans-serif\">b]</font>ar</code>",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"fontname":[false,false,"monospace",false,false,"sans-serif"]}],
["<pre>fo[o</pre><samp>b]ar</samp>",
    [["stylewithcss","true"],["fontname","sans-serif"]],
    "<pre>fo<span style=\"font-family:sans-serif\">[o</span></pre><samp><span style=\"font-family:sans-serif\">b]</span>ar</samp>",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"fontname":[false,false,"monospace",false,false,"sans-serif"]}],
["<pre>fo[o</pre><samp>b]ar</samp>",
    [["stylewithcss","false"],["fontname","sans-serif"]],
    "<pre>fo<font face=\"sans-serif\">[o</font></pre><samp><font face=\"sans-serif\">b]</font>ar</samp>",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"fontname":[false,false,"monospace",false,false,"sans-serif"]}],
["<span style=font-family:monospace>fo[o</span><kbd>b]ar</kbd>",
    [["stylewithcss","true"],["fontname","sans-serif"]],
    "<span style=\"font-family:monospace\">fo<span style=\"font-family:sans-serif\">[o</span></span><kbd><span style=\"font-family:sans-serif\">b]</span>ar</kbd>",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"fontname":[false,false,"monospace",false,false,"sans-serif"]}],
["<span style=font-family:monospace>fo[o</span><kbd>b]ar</kbd>",
    [["stylewithcss","false"],["fontname","sans-serif"]],
    "<span style=\"font-family:monospace\">fo<font face=\"sans-serif\">[o</font></span><kbd><font face=\"sans-serif\">b]</font>ar</kbd>",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"fontname":[false,false,"monospace",false,false,"sans-serif"]}]
]
