/* query-operators-test.c generated by valac 0.20.1, the Vala compiler
 * generated from query-operators-test.vala, do not modify */

/* query-operators-test.vala
 *
 * Copyright © 2011 Collabora Ltd.
 *             By Siegfried-Angel Gevatter Pujals <siegfried@gevatter.com>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 2.1 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include "zeitgeist-engine.h"
#include "zeitgeist-datamodel.h"
#include "zeitgeist-internal.h"


#define TYPE_PUBLIC_ENGINE (public_engine_get_type ())
#define PUBLIC_ENGINE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PUBLIC_ENGINE, PublicEngine))
#define PUBLIC_ENGINE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PUBLIC_ENGINE, PublicEngineClass))
#define IS_PUBLIC_ENGINE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PUBLIC_ENGINE))
#define IS_PUBLIC_ENGINE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PUBLIC_ENGINE))
#define PUBLIC_ENGINE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PUBLIC_ENGINE, PublicEngineClass))

typedef struct _PublicEngine PublicEngine;
typedef struct _PublicEngineClass PublicEngineClass;
typedef struct _PublicEnginePrivate PublicEnginePrivate;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _PublicEngine {
	ZeitgeistEngine parent_instance;
	PublicEnginePrivate * priv;
};

struct _PublicEngineClass {
	ZeitgeistEngineClass parent_class;
};


static gpointer public_engine_parent_class = NULL;

gint _vala_main (gchar** args, int args_length1);
void parse_negation_test (void);
static void _parse_negation_test_gtest_func (void);
void assert_no_negation_test (void);
static void _assert_no_negation_test_gtest_func (void);
void parse_noexpand_test (void);
static void _parse_noexpand_test_gtest_func (void);
void assert_no_noexpand_test (void);
static void _assert_no_noexpand_test_gtest_func (void);
void parse_wildcard_test (void);
static void _parse_wildcard_test_gtest_func (void);
void assert_no_wildcard_test (void);
static void _assert_no_wildcard_test_gtest_func (void);
GType public_engine_get_type (void) G_GNUC_CONST;
enum  {
	PUBLIC_ENGINE_DUMMY_PROPERTY
};
void public_engine_PUBLIC_assert_no_negation (PublicEngine* self, const gchar* field, const gchar* val, GError** error);
void public_engine_PUBLIC_assert_no_noexpand (PublicEngine* self, const gchar* field, const gchar* val, GError** error);
void public_engine_PUBLIC_assert_no_wildcard (PublicEngine* self, const gchar* field, const gchar* val, GError** error);
PublicEngine* public_engine_new (void);
PublicEngine* public_engine_construct (GType object_type);


static void _parse_negation_test_gtest_func (void) {
#line 38 "/home/manish/code/zeitgeist/test/direct/query-operators-test.vala"
	parse_negation_test ();
#line 88 "query-operators-test.c"
}


static void _assert_no_negation_test_gtest_func (void) {
#line 39 "/home/manish/code/zeitgeist/test/direct/query-operators-test.vala"
	assert_no_negation_test ();
#line 95 "query-operators-test.c"
}


static void _parse_noexpand_test_gtest_func (void) {
#line 40 "/home/manish/code/zeitgeist/test/direct/query-operators-test.vala"
	parse_noexpand_test ();
#line 102 "query-operators-test.c"
}


static void _assert_no_noexpand_test_gtest_func (void) {
#line 41 "/home/manish/code/zeitgeist/test/direct/query-operators-test.vala"
	assert_no_noexpand_test ();
#line 109 "query-operators-test.c"
}


static void _parse_wildcard_test_gtest_func (void) {
#line 42 "/home/manish/code/zeitgeist/test/direct/query-operators-test.vala"
	parse_wildcard_test ();
#line 116 "query-operators-test.c"
}


static void _assert_no_wildcard_test_gtest_func (void) {
#line 43 "/home/manish/code/zeitgeist/test/direct/query-operators-test.vala"
	assert_no_wildcard_test ();
#line 123 "query-operators-test.c"
}


gint _vala_main (gchar** args, int args_length1) {
	gint result = 0;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gint _tmp2_ = 0;
#line 26 "/home/manish/code/zeitgeist/test/direct/query-operators-test.vala"
	g_test_init (&args_length1, &args, NULL);
#line 29 "/home/manish/code/zeitgeist/test/direct/query-operators-test.vala"
	g_log_set_always_fatal (G_LOG_LEVEL_CRITICAL);
#line 33 "/home/manish/code/zeitgeist/test/direct/query-operators-test.vala"
	_tmp0_ = g_setenv ("ZEITGEIST_DATA_PATH", "/tmp/zeitgeist-tests", TRUE);
#line 33 "/home/manish/code/zeitgeist/test/direct/query-operators-test.vala"
	_vala_assert (_tmp0_, "Environment.set_variable(         \"ZEITGEIST_DATA_PATH\", \"/tmp/zeitgeist-tests\", true)");
#line 35 "/home/manish/code/zeitgeist/test/direct/query-operators-test.vala"
	_tmp1_ = g_setenv ("ZEITGEIST_DATABASE_PATH", ":memory:", TRUE);
#line 35 "/home/manish/code/zeitgeist/test/direct/query-operators-test.vala"
	_vala_assert (_tmp1_, "Environment.set_variable(         \"ZEITGEIST_DATABASE_PATH\", \":memory:\", true)");
#line 38 "/home/manish/code/zeitgeist/test/direct/query-operators-test.vala"
	g_test_add_func ("/ParseNegation/main", _parse_negation_test_gtest_func);
#line 39 "/home/manish/code/zeitgeist/test/direct/query-operators-test.vala"
	g_test_add_func ("/ParseNegation/assert", _assert_no_negation_test_gtest_func);
#line 40 "/home/manish/code/zeitgeist/test/direct/query-operators-test.vala"
	g_test_add_func ("/ParseNoexpand/main", _parse_noexpand_test_gtest_func);
#line 41 "/home/manish/code/zeitgeist/test/direct/query-operators-test.vala"
	g_test_add_func ("/ParseNoexpand/assert", _assert_no_noexpand_test_gtest_func);
#line 42 "/home/manish/code/zeitgeist/test/direct/query-operators-test.vala"
	g_test_add_func ("/ParseWildcard/main", _parse_wildcard_test_gtest_func);
#line 43 "/home/manish/code/zeitgeist/test/direct/query-operators-test.vala"
	g_test_add_func ("/ParseWildlcard/assert", _assert_no_wildcard_test_gtest_func);
#line 45 "/home/manish/code/zeitgeist/test/direct/query-operators-test.vala"
	_tmp2_ = g_test_run ();
#line 45 "/home/manish/code/zeitgeist/test/direct/query-operators-test.vala"
	result = _tmp2_;
#line 45 "/home/manish/code/zeitgeist/test/direct/query-operators-test.vala"
	return result;
#line 162 "query-operators-test.c"
}


int main (int argc, char ** argv) {
#line 23 "/home/manish/code/zeitgeist/test/direct/query-operators-test.vala"
	g_type_init ();
#line 23 "/home/manish/code/zeitgeist/test/direct/query-operators-test.vala"
	return _vala_main (argv, argc);
#line 171 "query-operators-test.c"
}


void public_engine_PUBLIC_assert_no_negation (PublicEngine* self, const gchar* field, const gchar* val, GError** error) {
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	GError * _inner_error_ = NULL;
#line 50 "/home/manish/code/zeitgeist/test/direct/query-operators-test.vala"
	g_return_if_fail (self != NULL);
#line 50 "/home/manish/code/zeitgeist/test/direct/query-operators-test.vala"
	g_return_if_fail (field != NULL);
#line 50 "/home/manish/code/zeitgeist/test/direct/query-operators-test.vala"
	g_return_if_fail (val != NULL);
#line 53 "/home/manish/code/zeitgeist/test/direct/query-operators-test.vala"
	_tmp0_ = field;
#line 53 "/home/manish/code/zeitgeist/test/direct/query-operators-test.vala"
	_tmp1_ = val;
#line 53 "/home/manish/code/zeitgeist/test/direct/query-operators-test.vala"
	zeitgeist_db_reader_assert_no_negation ((ZeitgeistDbReader*) self, _tmp0_, _tmp1_, &_inner_error_);
#line 53 "/home/manish/code/zeitgeist/test/direct/query-operators-test.vala"
	if (_inner_error_ != NULL) {
#line 53 "/home/manish/code/zeitgeist/test/direct/query-operators-test.vala"
		if (_inner_error_->domain == ZEITGEIST_ENGINE_ERROR) {
#line 53 "/home/manish/code/zeitgeist/test/direct/query-operators-test.vala"
			g_propagate_error (error, _inner_error_);
#line 53 "/home/manish/code/zeitgeist/test/direct/query-operators-test.vala"
			return;
#line 199 "query-operators-test.c"
		} else {
#line 53 "/home/manish/code/zeitgeist/test/direct/query-operators-test.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 53 "/home/manish/code/zeitgeist/test/direct/query-operators-test.vala"
			g_clear_error (&_inner_error_);
#line 53 "/home/manish/code/zeitgeist/test/direct/query-operators-test.vala"
			return;
#line 207 "query-operators-test.c"
		}
	}
}


void public_engine_PUBLIC_assert_no_noexpand (PublicEngine* self, const gchar* field, const gchar* val, GError** error) {
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	GError * _inner_error_ = NULL;
#line 56 "/home/manish/code/zeitgeist/test/direct/query-operators-test.vala"
	g_return_if_fail (self != NULL);
#line 56 "/home/manish/code/zeitgeist/test/direct/query-operators-test.vala"
	g_return_if_fail (field != NULL);
#line 56 "/home/manish/code/zeitgeist/test/direct/query-operators-test.vala"
	g_return_if_fail (val != NULL);
#line 59 "/home/manish/code/zeitgeist/test/direct/query-operators-test.vala"
	_tmp0_ = field;
#line 59 "/home/manish/code/zeitgeist/test/direct/query-operators-test.vala"
	_tmp1_ = val;
#line 59 "/home/manish/code/zeitgeist/test/direct/query-operators-test.vala"
	zeitgeist_db_reader_assert_no_noexpand ((ZeitgeistDbReader*) self, _tmp0_, _tmp1_, &_inner_error_);
#line 59 "/home/manish/code/zeitgeist/test/direct/query-operators-test.vala"
	if (_inner_error_ != NULL) {
#line 59 "/home/manish/code/zeitgeist/test/direct/query-operators-test.vala"
		if (_inner_error_->domain == ZEITGEIST_ENGINE_ERROR) {
#line 59 "/home/manish/code/zeitgeist/test/direct/query-operators-test.vala"
			g_propagate_error (error, _inner_error_);
#line 59 "/home/manish/code/zeitgeist/test/direct/query-operators-test.vala"
			return;
#line 237 "query-operators-test.c"
		} else {
#line 59 "/home/manish/code/zeitgeist/test/direct/query-operators-test.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 59 "/home/manish/code/zeitgeist/test/direct/query-operators-test.vala"
			g_clear_error (&_inner_error_);
#line 59 "/home/manish/code/zeitgeist/test/direct/query-operators-test.vala"
			return;
#line 245 "query-operators-test.c"
		}
	}
}


void public_engine_PUBLIC_assert_no_wildcard (PublicEngine* self, const gchar* field, const gchar* val, GError** error) {
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	GError * _inner_error_ = NULL;
#line 62 "/home/manish/code/zeitgeist/test/direct/query-operators-test.vala"
	g_return_if_fail (self != NULL);
#line 62 "/home/manish/code/zeitgeist/test/direct/query-operators-test.vala"
	g_return_if_fail (field != NULL);
#line 62 "/home/manish/code/zeitgeist/test/direct/query-operators-test.vala"
	g_return_if_fail (val != NULL);
#line 65 "/home/manish/code/zeitgeist/test/direct/query-operators-test.vala"
	_tmp0_ = field;
#line 65 "/home/manish/code/zeitgeist/test/direct/query-operators-test.vala"
	_tmp1_ = val;
#line 65 "/home/manish/code/zeitgeist/test/direct/query-operators-test.vala"
	zeitgeist_db_reader_assert_no_wildcard ((ZeitgeistDbReader*) self, _tmp0_, _tmp1_, &_inner_error_);
#line 65 "/home/manish/code/zeitgeist/test/direct/query-operators-test.vala"
	if (_inner_error_ != NULL) {
#line 65 "/home/manish/code/zeitgeist/test/direct/query-operators-test.vala"
		if (_inner_error_->domain == ZEITGEIST_ENGINE_ERROR) {
#line 65 "/home/manish/code/zeitgeist/test/direct/query-operators-test.vala"
			g_propagate_error (error, _inner_error_);
#line 65 "/home/manish/code/zeitgeist/test/direct/query-operators-test.vala"
			return;
#line 275 "query-operators-test.c"
		} else {
#line 65 "/home/manish/code/zeitgeist/test/direct/query-operators-test.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 65 "/home/manish/code/zeitgeist/test/direct/query-operators-test.vala"
			g_clear_error (&_inner_error_);
#line 65 "/home/manish/code/zeitgeist/test/direct/query-operators-test.vala"
			return;
#line 283 "query-operators-test.c"
		}
	}
}


PublicEngine* public_engine_construct (GType object_type) {
	PublicEngine * self = NULL;
	GError * _inner_error_ = NULL;
#line 48 "/home/manish/code/zeitgeist/test/direct/query-operators-test.vala"
	self = (PublicEngine*) zeitgeist_engine_construct (object_type, &_inner_error_);
#line 48 "/home/manish/code/zeitgeist/test/direct/query-operators-test.vala"
	if (_inner_error_ != NULL) {
#line 48 "/home/manish/code/zeitgeist/test/direct/query-operators-test.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 48 "/home/manish/code/zeitgeist/test/direct/query-operators-test.vala"
		g_clear_error (&_inner_error_);
#line 48 "/home/manish/code/zeitgeist/test/direct/query-operators-test.vala"
		return NULL;
#line 302 "query-operators-test.c"
	}
#line 48 "/home/manish/code/zeitgeist/test/direct/query-operators-test.vala"
	return self;
#line 306 "query-operators-test.c"
}


PublicEngine* public_engine_new (void) {
#line 48 "/home/manish/code/zeitgeist/test/direct/query-operators-test.vala"
	return public_engine_construct (TYPE_PUBLIC_ENGINE);
#line 313 "query-operators-test.c"
}


static void public_engine_class_init (PublicEngineClass * klass) {
#line 48 "/home/manish/code/zeitgeist/test/direct/query-operators-test.vala"
	public_engine_parent_class = g_type_class_peek_parent (klass);
#line 320 "query-operators-test.c"
}


static void public_engine_instance_init (PublicEngine * self) {
}


GType public_engine_get_type (void) {
	static volatile gsize public_engine_type_id__volatile = 0;
	if (g_once_init_enter (&public_engine_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (PublicEngineClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) public_engine_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (PublicEngine), 0, (GInstanceInitFunc) public_engine_instance_init, NULL };
		GType public_engine_type_id;
		public_engine_type_id = g_type_register_static (ZEITGEIST_TYPE_ENGINE, "PublicEngine", &g_define_type_info, 0);
		g_once_init_leave (&public_engine_type_id__volatile, public_engine_type_id);
	}
	return public_engine_type_id__volatile;
}


void parse_negation_test (void) {
	gchar* val = NULL;
	gchar* _tmp0_;
	gboolean _tmp1_ = FALSE;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	gboolean _tmp4_ = FALSE;
	const gchar* _tmp5_;
	gchar* _tmp6_;
	gboolean _tmp7_ = FALSE;
	const gchar* _tmp8_;
#line 75 "/home/manish/code/zeitgeist/test/direct/query-operators-test.vala"
	_tmp0_ = g_strdup ("no negation");
#line 75 "/home/manish/code/zeitgeist/test/direct/query-operators-test.vala"
	_g_free0 (val);
#line 75 "/home/manish/code/zeitgeist/test/direct/query-operators-test.vala"
	val = _tmp0_;
#line 76 "/home/manish/code/zeitgeist/test/direct/query-operators-test.vala"
	_tmp1_ = zeitgeist_utils_parse_negation (&val);
#line 76 "/home/manish/code/zeitgeist/test/direct/query-operators-test.vala"
	_vala_assert (_tmp1_ == FALSE, "Utils.parse_negation (ref val) == false");
#line 77 "/home/manish/code/zeitgeist/test/direct/query-operators-test.vala"
	_tmp2_ = val;
#line 77 "/home/manish/code/zeitgeist/test/direct/query-operators-test.vala"
	_vala_assert (g_strcmp0 (_tmp2_, "no negation") == 0, "val == \"no negation\"");
#line 80 "/home/manish/code/zeitgeist/test/direct/query-operators-test.vala"
	_tmp3_ = g_strdup ("!negation");
#line 80 "/home/manish/code/zeitgeist/test/direct/query-operators-test.vala"
	_g_free0 (val);
#line 80 "/home/manish/code/zeitgeist/test/direct/query-operators-test.vala"
	val = _tmp3_;
#line 81 "/home/manish/code/zeitgeist/test/direct/query-operators-test.vala"
	_tmp4_ = zeitgeist_utils_parse_negation (&val);
#line 81 "/home/manish/code/zeitgeist/test/direct/query-operators-test.vala"
	_vala_assert (_tmp4_ == TRUE, "Utils.parse_negation (ref val) == true");
#line 82 "/home/manish/code/zeitgeist/test/direct/query-operators-test.vala"
	_tmp5_ = val;
#line 82 "/home/manish/code/zeitgeist/test/direct/query-operators-test.vala"
	_vala_assert (g_strcmp0 (_tmp5_, "negation") == 0, "val == \"negation\"");
#line 85 "/home/manish/code/zeitgeist/test/direct/query-operators-test.vala"
	_tmp6_ = g_strdup ("some ! chars");
#line 85 "/home/manish/code/zeitgeist/test/direct/query-operators-test.vala"
	_g_free0 (val);
#line 85 "/home/manish/code/zeitgeist/test/direct/query-operators-test.vala"
	val = _tmp6_;
#line 86 "/home/manish/code/zeitgeist/test/direct/query-operators-test.vala"
	_tmp7_ = zeitgeist_utils_parse_negation (&val);
#line 86 "/home/manish/code/zeitgeist/test/direct/query-operators-test.vala"
	_vala_assert (_tmp7_ == FALSE, "Utils.parse_negation (ref val) == false");
#line 87 "/home/manish/code/zeitgeist/test/direct/query-operators-test.vala"
	_tmp8_ = val;
#line 87 "/home/manish/code/zeitgeist/test/direct/query-operators-test.vala"
	_vala_assert (g_strcmp0 (_tmp8_, "some ! chars") == 0, "val == \"some ! chars\"");
#line 70 "/home/manish/code/zeitgeist/test/direct/query-operators-test.vala"
	_g_free0 (val);
#line 395 "query-operators-test.c"
}


void assert_no_negation_test (void) {
	PublicEngine* _tmp0_;
	PublicEngine* engine;
	PublicEngine* _tmp1_;
	PublicEngine* _tmp2_;
	PublicEngine* _tmp3_;
	GError * _inner_error_ = NULL;
#line 92 "/home/manish/code/zeitgeist/test/direct/query-operators-test.vala"
	_tmp0_ = public_engine_new ();
#line 92 "/home/manish/code/zeitgeist/test/direct/query-operators-test.vala"
	engine = _tmp0_;
#line 94 "/home/manish/code/zeitgeist/test/direct/query-operators-test.vala"
	_tmp1_ = engine;
#line 94 "/home/manish/code/zeitgeist/test/direct/query-operators-test.vala"
	public_engine_PUBLIC_assert_no_negation (_tmp1_, "field name", "good", &_inner_error_);
#line 94 "/home/manish/code/zeitgeist/test/direct/query-operators-test.vala"
	if (_inner_error_ != NULL) {
#line 94 "/home/manish/code/zeitgeist/test/direct/query-operators-test.vala"
		_g_object_unref0 (engine);
#line 94 "/home/manish/code/zeitgeist/test/direct/query-operators-test.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 94 "/home/manish/code/zeitgeist/test/direct/query-operators-test.vala"
		g_clear_error (&_inner_error_);
#line 94 "/home/manish/code/zeitgeist/test/direct/query-operators-test.vala"
		return;
#line 424 "query-operators-test.c"
	}
#line 95 "/home/manish/code/zeitgeist/test/direct/query-operators-test.vala"
	_tmp2_ = engine;
#line 95 "/home/manish/code/zeitgeist/test/direct/query-operators-test.vala"
	public_engine_PUBLIC_assert_no_negation (_tmp2_, "field name", "good!", &_inner_error_);
#line 95 "/home/manish/code/zeitgeist/test/direct/query-operators-test.vala"
	if (_inner_error_ != NULL) {
#line 95 "/home/manish/code/zeitgeist/test/direct/query-operators-test.vala"
		_g_object_unref0 (engine);
#line 95 "/home/manish/code/zeitgeist/test/direct/query-operators-test.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 95 "/home/manish/code/zeitgeist/test/direct/query-operators-test.vala"
		g_clear_error (&_inner_error_);
#line 95 "/home/manish/code/zeitgeist/test/direct/query-operators-test.vala"
		return;
#line 440 "query-operators-test.c"
	}
#line 96 "/home/manish/code/zeitgeist/test/direct/query-operators-test.vala"
	_tmp3_ = engine;
#line 96 "/home/manish/code/zeitgeist/test/direct/query-operators-test.vala"
	public_engine_PUBLIC_assert_no_negation (_tmp3_, "field name", "go!od", &_inner_error_);
#line 96 "/home/manish/code/zeitgeist/test/direct/query-operators-test.vala"
	if (_inner_error_ != NULL) {
#line 96 "/home/manish/code/zeitgeist/test/direct/query-operators-test.vala"
		_g_object_unref0 (engine);
#line 96 "/home/manish/code/zeitgeist/test/direct/query-operators-test.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 96 "/home/manish/code/zeitgeist/test/direct/query-operators-test.vala"
		g_clear_error (&_inner_error_);
#line 96 "/home/manish/code/zeitgeist/test/direct/query-operators-test.vala"
		return;
#line 456 "query-operators-test.c"
	}
	{
		PublicEngine* _tmp4_;
#line 100 "/home/manish/code/zeitgeist/test/direct/query-operators-test.vala"
		_tmp4_ = engine;
#line 100 "/home/manish/code/zeitgeist/test/direct/query-operators-test.vala"
		public_engine_PUBLIC_assert_no_negation (_tmp4_, "field name", "!bad", &_inner_error_);
#line 100 "/home/manish/code/zeitgeist/test/direct/query-operators-test.vala"
		if (_inner_error_ != NULL) {
#line 100 "/home/manish/code/zeitgeist/test/direct/query-operators-test.vala"
			if (g_error_matches (_inner_error_, ZEITGEIST_ENGINE_ERROR, ZEITGEIST_ENGINE_ERROR_INVALID_ARGUMENT)) {
#line 468 "query-operators-test.c"
				goto __catch0_zeitgeist_engine_error_invalid_argument;
			}
			goto __finally0;
		}
#line 101 "/home/manish/code/zeitgeist/test/direct/query-operators-test.vala"
		g_assert_not_reached ();
#line 475 "query-operators-test.c"
	}
	goto __finally0;
	__catch0_zeitgeist_engine_error_invalid_argument:
	{
		GError* e = NULL;
#line 98 "/home/manish/code/zeitgeist/test/direct/query-operators-test.vala"
		e = _inner_error_;
#line 98 "/home/manish/code/zeitgeist/test/direct/query-operators-test.vala"
		_inner_error_ = NULL;
#line 98 "/home/manish/code/zeitgeist/test/direct/query-operators-test.vala"
		_g_error_free0 (e);
#line 487 "query-operators-test.c"
	}
	__finally0:
#line 98 "/home/manish/code/zeitgeist/test/direct/query-operators-test.vala"
	if (_inner_error_ != NULL) {
#line 98 "/home/manish/code/zeitgeist/test/direct/query-operators-test.vala"
		_g_object_unref0 (engine);
#line 98 "/home/manish/code/zeitgeist/test/direct/query-operators-test.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 98 "/home/manish/code/zeitgeist/test/direct/query-operators-test.vala"
		g_clear_error (&_inner_error_);
#line 98 "/home/manish/code/zeitgeist/test/direct/query-operators-test.vala"
		return;
#line 500 "query-operators-test.c"
	}
#line 90 "/home/manish/code/zeitgeist/test/direct/query-operators-test.vala"
	_g_object_unref0 (engine);
#line 504 "query-operators-test.c"
}


void parse_noexpand_test (void) {
	gchar* val = NULL;
	gchar* _tmp0_;
	gboolean _tmp1_ = FALSE;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	gboolean _tmp4_ = FALSE;
	const gchar* _tmp5_;
	gchar* _tmp6_;
	gboolean _tmp7_ = FALSE;
	const gchar* _tmp8_;
#line 113 "/home/manish/code/zeitgeist/test/direct/query-operators-test.vala"
	_tmp0_ = g_strdup ("no expand");
#line 113 "/home/manish/code/zeitgeist/test/direct/query-operators-test.vala"
	_g_free0 (val);
#line 113 "/home/manish/code/zeitgeist/test/direct/query-operators-test.vala"
	val = _tmp0_;
#line 114 "/home/manish/code/zeitgeist/test/direct/query-operators-test.vala"
	_tmp1_ = zeitgeist_utils_parse_noexpand (&val);
#line 114 "/home/manish/code/zeitgeist/test/direct/query-operators-test.vala"
	_vala_assert (_tmp1_ == FALSE, "Utils.parse_noexpand (ref val) == false");
#line 115 "/home/manish/code/zeitgeist/test/direct/query-operators-test.vala"
	_tmp2_ = val;
#line 115 "/home/manish/code/zeitgeist/test/direct/query-operators-test.vala"
	_vala_assert (g_strcmp0 (_tmp2_, "no expand") == 0, "val == \"no expand\"");
#line 118 "/home/manish/code/zeitgeist/test/direct/query-operators-test.vala"
	_tmp3_ = g_strdup ("+noexpand");
#line 118 "/home/manish/code/zeitgeist/test/direct/query-operators-test.vala"
	_g_free0 (val);
#line 118 "/home/manish/code/zeitgeist/test/direct/query-operators-test.vala"
	val = _tmp3_;
#line 119 "/home/manish/code/zeitgeist/test/direct/query-operators-test.vala"
	_tmp4_ = zeitgeist_utils_parse_noexpand (&val);
#line 119 "/home/manish/code/zeitgeist/test/direct/query-operators-test.vala"
	_vala_assert (_tmp4_ == TRUE, "Utils.parse_noexpand (ref val) == true");
#line 120 "/home/manish/code/zeitgeist/test/direct/query-operators-test.vala"
	_tmp5_ = val;
#line 120 "/home/manish/code/zeitgeist/test/direct/query-operators-test.vala"
	_vala_assert (g_strcmp0 (_tmp5_, "noexpand") == 0, "val == \"noexpand\"");
#line 123 "/home/manish/code/zeitgeist/test/direct/query-operators-test.vala"
	_tmp6_ = g_strdup ("some + chars++");
#line 123 "/home/manish/code/zeitgeist/test/direct/query-operators-test.vala"
	_g_free0 (val);
#line 123 "/home/manish/code/zeitgeist/test/direct/query-operators-test.vala"
	val = _tmp6_;
#line 124 "/home/manish/code/zeitgeist/test/direct/query-operators-test.vala"
	_tmp7_ = zeitgeist_utils_parse_noexpand (&val);
#line 124 "/home/manish/code/zeitgeist/test/direct/query-operators-test.vala"
	_vala_assert (_tmp7_ == FALSE, "Utils.parse_noexpand (ref val) == false");
#line 125 "/home/manish/code/zeitgeist/test/direct/query-operators-test.vala"
	_tmp8_ = val;
#line 125 "/home/manish/code/zeitgeist/test/direct/query-operators-test.vala"
	_vala_assert (g_strcmp0 (_tmp8_, "some + chars++") == 0, "val == \"some + chars++\"");
#line 108 "/home/manish/code/zeitgeist/test/direct/query-operators-test.vala"
	_g_free0 (val);
#line 563 "query-operators-test.c"
}


void assert_no_noexpand_test (void) {
	PublicEngine* _tmp0_;
	PublicEngine* engine;
	PublicEngine* _tmp1_;
	PublicEngine* _tmp2_;
	PublicEngine* _tmp3_;
	GError * _inner_error_ = NULL;
#line 130 "/home/manish/code/zeitgeist/test/direct/query-operators-test.vala"
	_tmp0_ = public_engine_new ();
#line 130 "/home/manish/code/zeitgeist/test/direct/query-operators-test.vala"
	engine = _tmp0_;
#line 132 "/home/manish/code/zeitgeist/test/direct/query-operators-test.vala"
	_tmp1_ = engine;
#line 132 "/home/manish/code/zeitgeist/test/direct/query-operators-test.vala"
	public_engine_PUBLIC_assert_no_noexpand (_tmp1_, "field name", "good", &_inner_error_);
#line 132 "/home/manish/code/zeitgeist/test/direct/query-operators-test.vala"
	if (_inner_error_ != NULL) {
#line 132 "/home/manish/code/zeitgeist/test/direct/query-operators-test.vala"
		_g_object_unref0 (engine);
#line 132 "/home/manish/code/zeitgeist/test/direct/query-operators-test.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 132 "/home/manish/code/zeitgeist/test/direct/query-operators-test.vala"
		g_clear_error (&_inner_error_);
#line 132 "/home/manish/code/zeitgeist/test/direct/query-operators-test.vala"
		return;
#line 592 "query-operators-test.c"
	}
#line 133 "/home/manish/code/zeitgeist/test/direct/query-operators-test.vala"
	_tmp2_ = engine;
#line 133 "/home/manish/code/zeitgeist/test/direct/query-operators-test.vala"
	public_engine_PUBLIC_assert_no_noexpand (_tmp2_, "field name", "good+", &_inner_error_);
#line 133 "/home/manish/code/zeitgeist/test/direct/query-operators-test.vala"
	if (_inner_error_ != NULL) {
#line 133 "/home/manish/code/zeitgeist/test/direct/query-operators-test.vala"
		_g_object_unref0 (engine);
#line 133 "/home/manish/code/zeitgeist/test/direct/query-operators-test.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 133 "/home/manish/code/zeitgeist/test/direct/query-operators-test.vala"
		g_clear_error (&_inner_error_);
#line 133 "/home/manish/code/zeitgeist/test/direct/query-operators-test.vala"
		return;
#line 608 "query-operators-test.c"
	}
#line 134 "/home/manish/code/zeitgeist/test/direct/query-operators-test.vala"
	_tmp3_ = engine;
#line 134 "/home/manish/code/zeitgeist/test/direct/query-operators-test.vala"
	public_engine_PUBLIC_assert_no_noexpand (_tmp3_, "field name", "go+od", &_inner_error_);
#line 134 "/home/manish/code/zeitgeist/test/direct/query-operators-test.vala"
	if (_inner_error_ != NULL) {
#line 134 "/home/manish/code/zeitgeist/test/direct/query-operators-test.vala"
		_g_object_unref0 (engine);
#line 134 "/home/manish/code/zeitgeist/test/direct/query-operators-test.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 134 "/home/manish/code/zeitgeist/test/direct/query-operators-test.vala"
		g_clear_error (&_inner_error_);
#line 134 "/home/manish/code/zeitgeist/test/direct/query-operators-test.vala"
		return;
#line 624 "query-operators-test.c"
	}
	{
		PublicEngine* _tmp4_;
#line 138 "/home/manish/code/zeitgeist/test/direct/query-operators-test.vala"
		_tmp4_ = engine;
#line 138 "/home/manish/code/zeitgeist/test/direct/query-operators-test.vala"
		public_engine_PUBLIC_assert_no_noexpand (_tmp4_, "field name", "+bad", &_inner_error_);
#line 138 "/home/manish/code/zeitgeist/test/direct/query-operators-test.vala"
		if (_inner_error_ != NULL) {
#line 138 "/home/manish/code/zeitgeist/test/direct/query-operators-test.vala"
			if (g_error_matches (_inner_error_, ZEITGEIST_ENGINE_ERROR, ZEITGEIST_ENGINE_ERROR_INVALID_ARGUMENT)) {
#line 636 "query-operators-test.c"
				goto __catch1_zeitgeist_engine_error_invalid_argument;
			}
			goto __finally1;
		}
#line 139 "/home/manish/code/zeitgeist/test/direct/query-operators-test.vala"
		g_assert_not_reached ();
#line 643 "query-operators-test.c"
	}
	goto __finally1;
	__catch1_zeitgeist_engine_error_invalid_argument:
	{
		GError* e = NULL;
#line 136 "/home/manish/code/zeitgeist/test/direct/query-operators-test.vala"
		e = _inner_error_;
#line 136 "/home/manish/code/zeitgeist/test/direct/query-operators-test.vala"
		_inner_error_ = NULL;
#line 136 "/home/manish/code/zeitgeist/test/direct/query-operators-test.vala"
		_g_error_free0 (e);
#line 655 "query-operators-test.c"
	}
	__finally1:
#line 136 "/home/manish/code/zeitgeist/test/direct/query-operators-test.vala"
	if (_inner_error_ != NULL) {
#line 136 "/home/manish/code/zeitgeist/test/direct/query-operators-test.vala"
		_g_object_unref0 (engine);
#line 136 "/home/manish/code/zeitgeist/test/direct/query-operators-test.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 136 "/home/manish/code/zeitgeist/test/direct/query-operators-test.vala"
		g_clear_error (&_inner_error_);
#line 136 "/home/manish/code/zeitgeist/test/direct/query-operators-test.vala"
		return;
#line 668 "query-operators-test.c"
	}
#line 128 "/home/manish/code/zeitgeist/test/direct/query-operators-test.vala"
	_g_object_unref0 (engine);
#line 672 "query-operators-test.c"
}


void parse_wildcard_test (void) {
	gchar* val = NULL;
	gchar* _tmp0_;
	gboolean _tmp1_ = FALSE;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	gboolean _tmp4_ = FALSE;
	const gchar* _tmp5_;
	gchar* _tmp6_;
	gboolean _tmp7_ = FALSE;
	const gchar* _tmp8_;
#line 151 "/home/manish/code/zeitgeist/test/direct/query-operators-test.vala"
	_tmp0_ = g_strdup ("no wildcard");
#line 151 "/home/manish/code/zeitgeist/test/direct/query-operators-test.vala"
	_g_free0 (val);
#line 151 "/home/manish/code/zeitgeist/test/direct/query-operators-test.vala"
	val = _tmp0_;
#line 152 "/home/manish/code/zeitgeist/test/direct/query-operators-test.vala"
	_tmp1_ = zeitgeist_utils_parse_wildcard (&val);
#line 152 "/home/manish/code/zeitgeist/test/direct/query-operators-test.vala"
	_vala_assert (_tmp1_ == FALSE, "Utils.parse_wildcard (ref val) == false");
#line 153 "/home/manish/code/zeitgeist/test/direct/query-operators-test.vala"
	_tmp2_ = val;
#line 153 "/home/manish/code/zeitgeist/test/direct/query-operators-test.vala"
	_vala_assert (g_strcmp0 (_tmp2_, "no wildcard") == 0, "val == \"no wildcard\"");
#line 156 "/home/manish/code/zeitgeist/test/direct/query-operators-test.vala"
	_tmp3_ = g_strdup ("yes wildcar*");
#line 156 "/home/manish/code/zeitgeist/test/direct/query-operators-test.vala"
	_g_free0 (val);
#line 156 "/home/manish/code/zeitgeist/test/direct/query-operators-test.vala"
	val = _tmp3_;
#line 157 "/home/manish/code/zeitgeist/test/direct/query-operators-test.vala"
	_tmp4_ = zeitgeist_utils_parse_wildcard (&val);
#line 157 "/home/manish/code/zeitgeist/test/direct/query-operators-test.vala"
	_vala_assert (_tmp4_ == TRUE, "Utils.parse_wildcard (ref val) == true");
#line 158 "/home/manish/code/zeitgeist/test/direct/query-operators-test.vala"
	_tmp5_ = val;
#line 158 "/home/manish/code/zeitgeist/test/direct/query-operators-test.vala"
	_vala_assert (g_strcmp0 (_tmp5_, "yes wildcar") == 0, "val == \"yes wildcar\"");
#line 161 "/home/manish/code/zeitgeist/test/direct/query-operators-test.vala"
	_tmp6_ = g_strdup ("some * chars");
#line 161 "/home/manish/code/zeitgeist/test/direct/query-operators-test.vala"
	_g_free0 (val);
#line 161 "/home/manish/code/zeitgeist/test/direct/query-operators-test.vala"
	val = _tmp6_;
#line 162 "/home/manish/code/zeitgeist/test/direct/query-operators-test.vala"
	_tmp7_ = zeitgeist_utils_parse_wildcard (&val);
#line 162 "/home/manish/code/zeitgeist/test/direct/query-operators-test.vala"
	_vala_assert (_tmp7_ == FALSE, "Utils.parse_wildcard ( ref val) == false");
#line 163 "/home/manish/code/zeitgeist/test/direct/query-operators-test.vala"
	_tmp8_ = val;
#line 163 "/home/manish/code/zeitgeist/test/direct/query-operators-test.vala"
	_vala_assert (g_strcmp0 (_tmp8_, "some * chars") == 0, "val == \"some * chars\"");
#line 146 "/home/manish/code/zeitgeist/test/direct/query-operators-test.vala"
	_g_free0 (val);
#line 731 "query-operators-test.c"
}


void assert_no_wildcard_test (void) {
	PublicEngine* _tmp0_;
	PublicEngine* engine;
	PublicEngine* _tmp1_;
	PublicEngine* _tmp2_;
	PublicEngine* _tmp3_;
	GError * _inner_error_ = NULL;
#line 169 "/home/manish/code/zeitgeist/test/direct/query-operators-test.vala"
	_tmp0_ = public_engine_new ();
#line 169 "/home/manish/code/zeitgeist/test/direct/query-operators-test.vala"
	engine = _tmp0_;
#line 171 "/home/manish/code/zeitgeist/test/direct/query-operators-test.vala"
	_tmp1_ = engine;
#line 171 "/home/manish/code/zeitgeist/test/direct/query-operators-test.vala"
	public_engine_PUBLIC_assert_no_wildcard (_tmp1_, "field name", "good", &_inner_error_);
#line 171 "/home/manish/code/zeitgeist/test/direct/query-operators-test.vala"
	if (_inner_error_ != NULL) {
#line 171 "/home/manish/code/zeitgeist/test/direct/query-operators-test.vala"
		_g_object_unref0 (engine);
#line 171 "/home/manish/code/zeitgeist/test/direct/query-operators-test.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 171 "/home/manish/code/zeitgeist/test/direct/query-operators-test.vala"
		g_clear_error (&_inner_error_);
#line 171 "/home/manish/code/zeitgeist/test/direct/query-operators-test.vala"
		return;
#line 760 "query-operators-test.c"
	}
#line 172 "/home/manish/code/zeitgeist/test/direct/query-operators-test.vala"
	_tmp2_ = engine;
#line 172 "/home/manish/code/zeitgeist/test/direct/query-operators-test.vala"
	public_engine_PUBLIC_assert_no_wildcard (_tmp2_, "field name", "*good", &_inner_error_);
#line 172 "/home/manish/code/zeitgeist/test/direct/query-operators-test.vala"
	if (_inner_error_ != NULL) {
#line 172 "/home/manish/code/zeitgeist/test/direct/query-operators-test.vala"
		_g_object_unref0 (engine);
#line 172 "/home/manish/code/zeitgeist/test/direct/query-operators-test.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 172 "/home/manish/code/zeitgeist/test/direct/query-operators-test.vala"
		g_clear_error (&_inner_error_);
#line 172 "/home/manish/code/zeitgeist/test/direct/query-operators-test.vala"
		return;
#line 776 "query-operators-test.c"
	}
#line 173 "/home/manish/code/zeitgeist/test/direct/query-operators-test.vala"
	_tmp3_ = engine;
#line 173 "/home/manish/code/zeitgeist/test/direct/query-operators-test.vala"
	public_engine_PUBLIC_assert_no_wildcard (_tmp3_, "field name", "go*od", &_inner_error_);
#line 173 "/home/manish/code/zeitgeist/test/direct/query-operators-test.vala"
	if (_inner_error_ != NULL) {
#line 173 "/home/manish/code/zeitgeist/test/direct/query-operators-test.vala"
		_g_object_unref0 (engine);
#line 173 "/home/manish/code/zeitgeist/test/direct/query-operators-test.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 173 "/home/manish/code/zeitgeist/test/direct/query-operators-test.vala"
		g_clear_error (&_inner_error_);
#line 173 "/home/manish/code/zeitgeist/test/direct/query-operators-test.vala"
		return;
#line 792 "query-operators-test.c"
	}
	{
		PublicEngine* _tmp4_;
#line 177 "/home/manish/code/zeitgeist/test/direct/query-operators-test.vala"
		_tmp4_ = engine;
#line 177 "/home/manish/code/zeitgeist/test/direct/query-operators-test.vala"
		public_engine_PUBLIC_assert_no_wildcard (_tmp4_, "field name", "bad*", &_inner_error_);
#line 177 "/home/manish/code/zeitgeist/test/direct/query-operators-test.vala"
		if (_inner_error_ != NULL) {
#line 177 "/home/manish/code/zeitgeist/test/direct/query-operators-test.vala"
			if (g_error_matches (_inner_error_, ZEITGEIST_ENGINE_ERROR, ZEITGEIST_ENGINE_ERROR_INVALID_ARGUMENT)) {
#line 804 "query-operators-test.c"
				goto __catch2_zeitgeist_engine_error_invalid_argument;
			}
			goto __finally2;
		}
#line 178 "/home/manish/code/zeitgeist/test/direct/query-operators-test.vala"
		g_assert_not_reached ();
#line 811 "query-operators-test.c"
	}
	goto __finally2;
	__catch2_zeitgeist_engine_error_invalid_argument:
	{
		GError* e = NULL;
#line 175 "/home/manish/code/zeitgeist/test/direct/query-operators-test.vala"
		e = _inner_error_;
#line 175 "/home/manish/code/zeitgeist/test/direct/query-operators-test.vala"
		_inner_error_ = NULL;
#line 175 "/home/manish/code/zeitgeist/test/direct/query-operators-test.vala"
		_g_error_free0 (e);
#line 823 "query-operators-test.c"
	}
	__finally2:
#line 175 "/home/manish/code/zeitgeist/test/direct/query-operators-test.vala"
	if (_inner_error_ != NULL) {
#line 175 "/home/manish/code/zeitgeist/test/direct/query-operators-test.vala"
		_g_object_unref0 (engine);
#line 175 "/home/manish/code/zeitgeist/test/direct/query-operators-test.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 175 "/home/manish/code/zeitgeist/test/direct/query-operators-test.vala"
		g_clear_error (&_inner_error_);
#line 175 "/home/manish/code/zeitgeist/test/direct/query-operators-test.vala"
		return;
#line 836 "query-operators-test.c"
	}
#line 167 "/home/manish/code/zeitgeist/test/direct/query-operators-test.vala"
	_g_object_unref0 (engine);
#line 840 "query-operators-test.c"
}



