/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.user.client.ui;

import com.google.gwt.dom.client.AnchorElement;
import com.google.gwt.dom.client.Document;
import com.google.gwt.dom.client.Element;
import com.google.gwt.i18n.client.BidiUtils;
import com.google.gwt.i18n.client.HasDirection;
import com.google.gwt.i18n.shared.DirectionEstimator;
import com.google.gwt.i18n.shared.HasDirectionEstimator;
import com.google.gwt.safehtml.shared.SafeHtml;
import com.google.gwt.user.client.ui.DirectionalTextHelper;
import com.google.gwt.user.client.ui.FocusWidget;
import com.google.gwt.user.client.ui.HasDirectionalSafeHtml;
import com.google.gwt.user.client.ui.HasHTML;
import com.google.gwt.user.client.ui.HasHorizontalAlignment;
import com.google.gwt.user.client.ui.HasName;
import com.google.gwt.user.client.ui.HasWordWrap;
import com.google.gwt.user.client.ui.RootPanel;

public class Anchor
extends FocusWidget
implements HasHorizontalAlignment,
HasName,
HasHTML,
HasWordWrap,
HasDirection,
HasDirectionEstimator,
HasDirectionalSafeHtml {
    public static final DirectionEstimator DEFAULT_DIRECTION_ESTIMATOR = DirectionalTextHelper.DEFAULT_DIRECTION_ESTIMATOR;
    private static final String DEFAULT_HREF = "javascript:;";
    private final DirectionalTextHelper directionalTextHelper;
    private HasHorizontalAlignment.HorizontalAlignmentConstant horzAlign;

    public static Anchor wrap(Element element) {
        assert (Document.get().getBody().isOrHasChild(element));
        Anchor anchor = new Anchor(element);
        anchor.onAttach();
        RootPanel.detachOnWindowClose(anchor);
        return anchor;
    }

    public Anchor() {
        this(false);
    }

    public Anchor(boolean useDefaultHref) {
        this.setElement(Document.get().createAnchorElement());
        this.setStyleName("gwt-Anchor");
        this.directionalTextHelper = new DirectionalTextHelper(this.getAnchorElement(), true);
        if (useDefaultHref) {
            this.setHref(DEFAULT_HREF);
        }
    }

    public Anchor(SafeHtml html) {
        this(html.asString(), true);
    }

    public Anchor(SafeHtml html, HasDirection.Direction dir) {
        this(html.asString(), true, dir, DEFAULT_HREF);
    }

    public Anchor(SafeHtml html, DirectionEstimator directionEstimator) {
        this(html.asString(), true, directionEstimator, DEFAULT_HREF);
    }

    public Anchor(String text) {
        this(text, DEFAULT_HREF);
    }

    public Anchor(String text, HasDirection.Direction dir) {
        this(text, dir, DEFAULT_HREF);
    }

    public Anchor(String text, DirectionEstimator directionEstimator) {
        this(text, directionEstimator, DEFAULT_HREF);
    }

    public Anchor(String text, boolean asHtml) {
        this(text, asHtml, DEFAULT_HREF);
    }

    public Anchor(SafeHtml html, String href) {
        this(html.asString(), true, href);
    }

    public Anchor(SafeHtml html, HasDirection.Direction dir, String href) {
        this(html.asString(), true, dir, href);
    }

    public Anchor(SafeHtml html, DirectionEstimator directionEstimator, String href) {
        this(html.asString(), true, directionEstimator, href);
    }

    public Anchor(String text, String href) {
        this(text, false, href);
    }

    public Anchor(String text, HasDirection.Direction dir, String href) {
        this(text, false, dir, href);
    }

    public Anchor(String text, DirectionEstimator directionEstimator, String href) {
        this(text, false, directionEstimator, href);
    }

    public Anchor(String text, boolean asHTML, String href) {
        this();
        this.directionalTextHelper.setTextOrHtml(text, asHTML);
        this.setHref(href);
    }

    public Anchor(SafeHtml html, String href, String target) {
        this(html.asString(), true, href, target);
    }

    public Anchor(String text, String href, String target) {
        this(text, false, href, target);
    }

    public Anchor(String text, boolean asHtml, String href, String target) {
        this(text, asHtml, href);
        this.setTarget(target);
    }

    protected Anchor(Element element) {
        AnchorElement.as(element);
        this.setElement(element);
        this.directionalTextHelper = new DirectionalTextHelper(this.getAnchorElement(), true);
    }

    private Anchor(String text, boolean asHTML, HasDirection.Direction dir, String href) {
        this();
        this.directionalTextHelper.setTextOrHtml(text, dir, asHTML);
        this.setHref(href);
    }

    private Anchor(String text, boolean asHTML, DirectionEstimator directionEstimator, String href) {
        this();
        this.directionalTextHelper.setDirectionEstimator(directionEstimator);
        this.directionalTextHelper.setTextOrHtml(text, asHTML);
        this.setHref(href);
    }

    public HasDirection.Direction getDirection() {
        return BidiUtils.getDirectionOnElement(this.getElement());
    }

    public DirectionEstimator getDirectionEstimator() {
        return this.directionalTextHelper.getDirectionEstimator();
    }

    public HasHorizontalAlignment.HorizontalAlignmentConstant getHorizontalAlignment() {
        return this.horzAlign;
    }

    public String getHref() {
        return this.getAnchorElement().getHref();
    }

    public String getHTML() {
        return this.getElement().getInnerHTML();
    }

    public String getName() {
        return this.getAnchorElement().getName();
    }

    public int getTabIndex() {
        return this.getAnchorElement().getTabIndex();
    }

    public String getTarget() {
        return this.getAnchorElement().getTarget();
    }

    public String getText() {
        return this.directionalTextHelper.getTextOrHtml(false);
    }

    public HasDirection.Direction getTextDirection() {
        return this.directionalTextHelper.getTextDirection();
    }

    public boolean getWordWrap() {
        return !this.getElement().getStyle().getProperty("whiteSpace").equals("nowrap");
    }

    public void setAccessKey(char key) {
        this.getAnchorElement().setAccessKey(Character.toString(key));
    }

    @Deprecated
    public void setDirection(HasDirection.Direction direction) {
        this.directionalTextHelper.setDirection(direction);
    }

    public void setDirectionEstimator(boolean enabled) {
        this.directionalTextHelper.setDirectionEstimator(enabled);
    }

    public void setDirectionEstimator(DirectionEstimator directionEstimator) {
        this.directionalTextHelper.setDirectionEstimator(directionEstimator);
    }

    public void setFocus(boolean focused) {
        if (focused) {
            this.getAnchorElement().focus();
        } else {
            this.getAnchorElement().blur();
        }
    }

    public void setHorizontalAlignment(HasHorizontalAlignment.HorizontalAlignmentConstant align) {
        this.horzAlign = align;
        this.getElement().getStyle().setProperty("textAlign", align.getTextAlignString());
    }

    public void setHref(String href) {
        this.getAnchorElement().setHref(href);
    }

    public void setHTML(SafeHtml html) {
        this.setHTML(html.asString());
    }

    public void setHTML(String html) {
        this.directionalTextHelper.setTextOrHtml(html, true);
    }

    public void setHTML(SafeHtml html, HasDirection.Direction dir) {
        this.directionalTextHelper.setTextOrHtml(html.asString(), dir, true);
    }

    public void setName(String name) {
        this.getAnchorElement().setName(name);
    }

    public void setTabIndex(int index) {
        this.getAnchorElement().setTabIndex(index);
    }

    public void setTarget(String target) {
        this.getAnchorElement().setTarget(target);
    }

    public void setText(String text) {
        this.directionalTextHelper.setTextOrHtml(text, false);
    }

    public void setText(String text, HasDirection.Direction dir) {
        this.directionalTextHelper.setTextOrHtml(text, dir, false);
    }

    public void setWordWrap(boolean wrap) {
        this.getElement().getStyle().setProperty("whiteSpace", wrap ? "normal" : "nowrap");
    }

    private AnchorElement getAnchorElement() {
        return AnchorElement.as(this.getElement());
    }
}

