/*  limitdlg
 *  Copyright (C) 2000 FURUKAWA Yo
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/
/* $Id: limitdlg.c,v 1.1.1.1 2000/05/07 06:46:46 furukawa Exp $ */

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <gtk/gtk.h>

#include "callbacks.h"
#include "interface.h"
#include "support.h"

#include "gtktrain.h"
#include "libtrain.h"

/* -- callbacks */

void
LimitDialog_Prepare(GtkWidget *LimitDialog)
{
    GtkWidget *walk_limit_spin = get_widget(LimitDialog, "SpinWalkLimit");
    GtkWidget *wait_limit_spin = get_widget(LimitDialog, "SpinWaitLimit");
    GtkWidget *change_limit_spin = get_widget(LimitDialog, "SpinChangeLimit");
    GtkWidget *charged_express_check = get_widget(LimitDialog, "CheckUseChargedExpress");
    GtkWidget *shinkansen_check = get_widget(LimitDialog, "CheckUseShinkansen");
    GtkWidget *misc_check = get_widget(LimitDialog, "CheckUseMisc");
    GtkWidget *starting_wait_check = get_widget(LimitDialog, "CheckStartingWait");
    GtkWidget *detail_check = get_widget(LimitDialog, "CheckDetail");

    gtk_spin_button_set_value(GTK_SPIN_BUTTON(walk_limit_spin),
			      Train_GetWalkLimit());
    gtk_spin_button_set_value(GTK_SPIN_BUTTON(wait_limit_spin),
			      Train_GetWaitLimit());
    gtk_spin_button_set_value(GTK_SPIN_BUTTON(change_limit_spin),
			      Train_GetChangeLimit());

    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(charged_express_check),
				 Train_GetUseChargedExpress());
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(shinkansen_check),
				 Train_GetUseShinkansen());
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(misc_check),
				 Train_GetUseMisc());
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(starting_wait_check),
				 Train_GetStartingWait());
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(detail_check),
				 Train_GetDetailed());
}

void
on_Limit_ButtonOK_clicked(GtkButton *button, gpointer user_data)
{
    
    GtkWidget *LimitDialog = gtk_widget_get_toplevel(GTK_WIDGET(button));
    GtkWidget *walk_limit_spin = get_widget(LimitDialog, "SpinWalkLimit");
    GtkWidget *wait_limit_spin = get_widget(LimitDialog, "SpinWaitLimit");
    GtkWidget *change_limit_spin = get_widget(LimitDialog, "SpinChangeLimit");
    GtkWidget *charged_express_check = get_widget(LimitDialog, "CheckUseChargedExpress");
    GtkWidget *shinkansen_check = get_widget(LimitDialog, "CheckUseShinkansen");
    GtkWidget *misc_check = get_widget(LimitDialog, "CheckUseMisc");
    GtkWidget *starting_wait_check = get_widget(LimitDialog, "CheckStartingWait");
    GtkWidget *detail_check = get_widget(LimitDialog, "CheckDetail");

    Train_SetWalkLimit(gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(walk_limit_spin)));
    Train_SetWaitLimit(gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(wait_limit_spin)));
    Train_SetChangeLimit(gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(change_limit_spin)));

    
    Train_SetUseChargedExpress(gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(charged_express_check)));
    Train_SetUseShinkansen(gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(shinkansen_check)));
    Train_SetUseMisc(gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(misc_check)));
    Train_SetStartingWait(gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(starting_wait_check)));
    Train_SetDetailed(gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(detail_check)));

    gtk_widget_destroy(gtk_widget_get_toplevel(GTK_WIDGET(button)));
}

void
on_Limit_ButtonCancel_clicked(GtkButton *button, gpointer user_data)
{
    gtk_widget_destroy(gtk_widget_get_toplevel(GTK_WIDGET(button)));
}
