/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.utils.recalibration;

import org.broadinstitute.sting.gatk.GenomeAnalysisEngine;
import org.broadinstitute.sting.gatk.WalkerManager;
import org.broadinstitute.sting.gatk.iterators.ReadTransformer;
import org.broadinstitute.sting.gatk.walkers.Walker;
import org.broadinstitute.sting.utils.recalibration.BQSRMode;
import org.broadinstitute.sting.utils.recalibration.BaseRecalibration;
import org.broadinstitute.sting.utils.sam.GATKSAMRecord;

public class BQSRReadTransformer
extends ReadTransformer {
    private boolean enabled;
    private BaseRecalibration bqsr;

    public ReadTransformer.ApplicationTime initializeSub(GenomeAnalysisEngine engine, Walker walker) {
        this.enabled = engine.hasBaseRecalibration();
        this.bqsr = engine.getBaseRecalibration();
        BQSRMode mode = (BQSRMode)WalkerManager.getWalkerAnnotation((Walker)walker, BQSRMode.class);
        return mode.ApplicationTime();
    }

    public boolean enabled() {
        return this.enabled;
    }

    public GATKSAMRecord apply(GATKSAMRecord read) {
        this.bqsr.recalibrateRead(read);
        return read;
    }
}

