/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.utils.sam;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import net.sf.picard.sam.MergingSamRecordIterator;
import net.sf.picard.sam.SamFileHeaderMerger;
import net.sf.samtools.SAMFileHeader;
import net.sf.samtools.SAMRecord;
import net.sf.samtools.util.CloseableIterator;
import org.broadinstitute.sting.gatk.iterators.StingSAMIterator;
import org.broadinstitute.sting.gatk.iterators.StingSAMIteratorAdapter;
import org.broadinstitute.sting.utils.exceptions.ReviewedStingException;
import org.broadinstitute.sting.utils.sam.ArtificialSAMFileReader;
import org.broadinstitute.sting.utils.sam.ArtificialSingleSampleReadStream;

public class ArtificialMultiSampleReadStream
implements Iterable<SAMRecord> {
    private Collection<ArtificialSingleSampleReadStream> perSampleArtificialReadStreams;
    private MergingSamRecordIterator mergingIterator;

    public ArtificialMultiSampleReadStream(Collection<ArtificialSingleSampleReadStream> perSampleArtificialReadStreams) {
        if (perSampleArtificialReadStreams == null || perSampleArtificialReadStreams.isEmpty()) {
            throw new ReviewedStingException("Can't create an ArtificialMultiSampleReadStream out of 0 ArtificialSingleSampleReadStreams");
        }
        this.perSampleArtificialReadStreams = perSampleArtificialReadStreams;
    }

    @Override
    public Iterator<SAMRecord> iterator() {
        this.initialize();
        return this.mergingIterator;
    }

    public StingSAMIterator getStingSAMIterator() {
        this.initialize();
        return StingSAMIteratorAdapter.adapt((CloseableIterator)this.mergingIterator);
    }

    private void initialize() {
        ArrayList<ArtificialSAMFileReader> perSampleSAMReaders = new ArrayList<ArtificialSAMFileReader>(this.perSampleArtificialReadStreams.size());
        ArrayList<SAMFileHeader> headers = new ArrayList<SAMFileHeader>(this.perSampleArtificialReadStreams.size());
        for (ArtificialSingleSampleReadStream readStream : this.perSampleArtificialReadStreams) {
            Collection<SAMRecord> thisStreamReads = readStream.makeReads();
            ArtificialSAMFileReader reader = new ArtificialSAMFileReader(readStream.getHeader(), thisStreamReads.toArray(new SAMRecord[thisStreamReads.size()]));
            perSampleSAMReaders.add(reader);
            headers.add(reader.getFileHeader());
        }
        SamFileHeaderMerger headerMerger = new SamFileHeaderMerger(SAMFileHeader.SortOrder.coordinate, headers, true);
        this.mergingIterator = new MergingSamRecordIterator(headerMerger, perSampleSAMReaders, true);
    }
}

