/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.utils.sam;

import net.sf.samtools.SAMRecord;

public class ComparableSAMRecord
implements Comparable<ComparableSAMRecord> {
    private SAMRecord record;

    public ComparableSAMRecord(SAMRecord record) {
        this.record = record;
    }

    public SAMRecord getRecord() {
        return this.record;
    }

    @Override
    public int compareTo(ComparableSAMRecord o) {
        int comparison = this.record.getAlignmentStart() - o.record.getAlignmentStart();
        if (comparison == 0) {
            comparison = this.record.getReadName().compareTo(o.getRecord().getReadName());
        }
        if (comparison == 0 && this.record.getReadPairedFlag()) {
            comparison = this.record.getFirstOfPairFlag() ? -1 : 1;
        }
        return comparison;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ComparableSAMRecord)) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        ComparableSAMRecord csr = (ComparableSAMRecord)obj;
        if (this.record.getAlignmentStart() != csr.record.getAlignmentStart()) {
            return false;
        }
        if (!this.record.getReadName().equals(csr.getRecord().getReadName())) {
            return false;
        }
        return this.record.getFirstOfPairFlag() == csr.record.getFirstOfPairFlag();
    }
}

