/*
 * Decompiled with CFR 0.152.
 */
package net.sf.picard.analysis;

import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import net.sf.picard.analysis.CollectAlignmentSummaryMetrics;
import net.sf.picard.analysis.CollectInsertSizeMetrics;
import net.sf.picard.analysis.MeanQualityByCycle;
import net.sf.picard.analysis.QualityScoreDistribution;
import net.sf.picard.analysis.SinglePassSamProgram;
import net.sf.picard.cmdline.CommandLineProgram;
import net.sf.picard.cmdline.Option;
import net.sf.picard.cmdline.Usage;
import net.sf.picard.util.CollectionUtil;

public class CollectMultipleMetrics
extends CommandLineProgram {
    @Usage
    public final String USAGE = this.getStandardUsagePreamble() + "Takes an input BAM and reference sequence and runs one or more Picard " + "metrics modules at the same time to cut down on I/O. Currently all programs are run with " + "default options and fixed output extesions, but this may become more flexible in future.";
    @Option(shortName="I", doc="Input SAM or BAM file.")
    public File INPUT;
    @Option(shortName="R", doc="Reference sequence fasta.", optional=true)
    public File REFERENCE_SEQUENCE;
    @Option(doc="If true (default), then the sort order in the header file will be ignored.", shortName="AS")
    public boolean ASSUME_SORTED = true;
    @Option(doc="Stop after processing N reads, mainly for debugging.")
    public int STOP_AFTER = 0;
    @Option(shortName="O", doc="Base name of output files.")
    public String OUTPUT;
    @Option(doc="List of metrics programs to apply during the pass through the SAM file.")
    public List<Program> PROGRAM = CollectionUtil.makeList(Program.values());

    public static void main(String[] args) {
        new CollectMultipleMetrics().instanceMainWithExit(args);
    }

    @Override
    protected int doWork() {
        if (this.OUTPUT.endsWith(".")) {
            this.OUTPUT = this.OUTPUT.substring(0, this.OUTPUT.length() - 1);
        }
        ArrayList<SinglePassSamProgram> programs = new ArrayList<SinglePassSamProgram>();
        for (Program program : new HashSet<Program>(this.PROGRAM)) {
            SinglePassSamProgram instance = program.makeInstance(this.OUTPUT);
            instance.INPUT = this.INPUT;
            instance.REFERENCE_SEQUENCE = this.REFERENCE_SEQUENCE;
            instance.setDefaultHeaders(this.getDefaultHeaders());
            programs.add(instance);
        }
        SinglePassSamProgram.makeItSo(this.INPUT, this.REFERENCE_SEQUENCE, this.ASSUME_SORTED, this.STOP_AFTER, programs);
        return 0;
    }

    public static enum Program {
        CollectAlignmentSummaryMetrics{

            @Override
            public SinglePassSamProgram makeInstance(String outbase) {
                CollectAlignmentSummaryMetrics program = new CollectAlignmentSummaryMetrics();
                program.OUTPUT = new File(outbase + ".alignment_summary_metrics");
                return program;
            }
        }
        ,
        CollectInsertSizeMetrics{

            @Override
            public SinglePassSamProgram makeInstance(String outbase) {
                CollectInsertSizeMetrics program = new CollectInsertSizeMetrics();
                program.OUTPUT = new File(outbase + ".insert_size_metrics");
                program.HISTOGRAM_FILE = new File(outbase + ".insert_size_histogram.pdf");
                return program;
            }
        }
        ,
        QualityScoreDistribution{

            @Override
            public SinglePassSamProgram makeInstance(String outbase) {
                QualityScoreDistribution program = new QualityScoreDistribution();
                program.OUTPUT = new File(outbase + ".quality_distribution_metrics");
                program.CHART_OUTPUT = new File(outbase + ".quality_distribution.pdf");
                return program;
            }
        }
        ,
        MeanQualityByCycle{

            @Override
            public SinglePassSamProgram makeInstance(String outbase) {
                MeanQualityByCycle program = new MeanQualityByCycle();
                program.OUTPUT = new File(outbase + ".quality_by_cycle_metrics");
                program.CHART_OUTPUT = new File(outbase + ".quality_by_cycle.pdf");
                return program;
            }
        };


        public abstract SinglePassSamProgram makeInstance(String var1);
    }
}

