/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.hul.ois.jhove.module.tiff;

import edu.harvard.hul.ois.jhove.ErrorMessage;
import edu.harvard.hul.ois.jhove.InfoMessage;
import edu.harvard.hul.ois.jhove.ModuleBase;
import edu.harvard.hul.ois.jhove.Property;
import edu.harvard.hul.ois.jhove.PropertyArity;
import edu.harvard.hul.ois.jhove.PropertyType;
import edu.harvard.hul.ois.jhove.Rational;
import edu.harvard.hul.ois.jhove.RepInfo;
import edu.harvard.hul.ois.jhove.module.tiff.TiffException;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.text.NumberFormat;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;

public abstract class IFD {
    private static final boolean debug_allowoutofsequence = false;
    public static final int TIFF = 0;
    public static final int EXIF = 1;
    public static final int INTEROPERABILITY = 2;
    public static final int GPSINFO = 3;
    public static final int GLOBALPARAMETERS = 4;
    public static final int NULL = -1;
    public static final int BYTE = 1;
    public static final int ASCII = 2;
    public static final int SHORT = 3;
    public static final int LONG = 4;
    public static final int RATIONAL = 5;
    public static final int SBYTE = 6;
    public static final int UNDEFINED = 7;
    public static final int SSHORT = 8;
    public static final int SLONG = 9;
    public static final int SRATIONAL = 10;
    public static final int FLOAT = 11;
    public static final int DOUBLE = 12;
    public static final int IFD = 13;
    public static final String[] TYPE = new String[]{"", "BYTE", "ASCII", "SHORT", "LONG", "RATIONAL", "SBYTE", "UNDEFINED", "SSHORT", "SLONG", "SRATIONAL", "FLOAT", "DOUBLE", "IFD"};
    protected boolean _bigEndian;
    private List _errors;
    private boolean _first;
    private boolean _thumbnail;
    private NumberFormat _format;
    protected RepInfo _info;
    protected long _next;
    protected long _offset;
    private RandomAccessFile _raf;
    protected int _version;

    public IFD(long l, RepInfo repInfo, RandomAccessFile randomAccessFile, boolean bl) {
        this._offset = l;
        this._info = repInfo;
        this._raf = randomAccessFile;
        this._bigEndian = bl;
        this._first = false;
        this._thumbnail = false;
        this._next = 0L;
        this._version = 4;
        this._errors = new LinkedList();
        this._format = NumberFormat.getInstance();
        this._format.setGroupingUsed(false);
        this._format.setMinimumFractionDigits(0);
    }

    public List getErrors() {
        return this._errors;
    }

    public long getNext() {
        return this._next;
    }

    public long getOffset() {
        return this._offset;
    }

    public abstract Property getProperty(boolean var1) throws TiffException;

    public int getVersion() {
        return this._version;
    }

    public boolean isFirst() {
        return this._first;
    }

    public boolean isThumbnail() {
        return this._thumbnail;
    }

    public abstract void lookupTag(int var1, int var2, long var3, long var5) throws TiffException;

    public long parse() throws TiffException {
        return this.parse(false, false);
    }

    public long parse(boolean bl, boolean bl2) throws TiffException {
        try {
            return this.parse(bl);
        }
        catch (TiffException tiffException) {
            if (bl2) {
                this._info.setMessage(new InfoMessage(tiffException.getMessage(), tiffException.getOffset()));
                return 0L;
            }
            throw tiffException;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public long parse(boolean bl) throws TiffException {
        byte[] byArray;
        long l = this._offset;
        this._next = 0L;
        int n = 0;
        try {
            this._raf.seek(l);
            n = ModuleBase.readUnsignedShort(this._raf, this._bigEndian);
            l += 2L;
            int n2 = 12 * n;
            byArray = new byte[n2];
            this._raf.read(byArray, 0, n2);
            l += (long)n2;
            this._next = ModuleBase.readUnsignedInt(this._raf, this._bigEndian);
        }
        catch (Exception exception) {
            throw new TiffException("Premature EOF", l);
        }
        DataInputStream dataInputStream = new DataInputStream(new ByteArrayInputStream(byArray));
        try {
            int n3 = 0;
            for (int i = 0; i < n; ++i) {
                int n4 = ModuleBase.readUnsignedShort(dataInputStream, this._bigEndian, null);
                if (n4 < n3) {
                    this._info.setMessage(new ErrorMessage("Tag " + n4 + " out of sequence", this._offset + 2L + (long)(12 * i)));
                    this._info.setWellFormed(false);
                }
                n3 = n4;
                int n5 = ModuleBase.readUnsignedShort(dataInputStream, this._bigEndian, null);
                if (n5 < 1 || n5 > 13) {
                    this._info.setMessage(new ErrorMessage("Unknown data type", "Type = " + n5 + ", Tag = " + n4, this._offset + 4L + (long)(12 * i)));
                    continue;
                }
                if (6 <= n5 && n5 <= 13) {
                    this._version = 6;
                }
                long l2 = ModuleBase.readUnsignedInt(dataInputStream, this._bigEndian, null);
                long l3 = ModuleBase.readUnsignedInt(dataInputStream, this._bigEndian, null);
                if (edu.harvard.hul.ois.jhove.module.tiff.IFD.calcValueSize(n5, l2) > 4L) {
                    if ((l3 & 1L) != 0L) {
                        if (!bl) throw new TiffException("Value offset not word-aligned: " + l3, this._offset + 10L + (long)(12 * i));
                        this._info.setMessage(new InfoMessage("Value offset not word-aligned: " + l3, this._offset + 10L + (long)(12 * i)));
                    }
                } else {
                    l3 = this._offset + 10L + (long)(12 * i);
                }
                this.lookupTag(n4, n5, l2, l3);
            }
        }
        catch (IOException iOException) {
            throw new TiffException("Read error", this._offset + 2L);
        }
        this.postParseInitialization();
        return this._next;
    }

    public void setFirst(boolean bl) {
        this._first = bl;
    }

    public void setThumbnail(boolean bl) {
        this._thumbnail = bl;
    }

    protected Property addBitmaskProperty(String string, long l, String[] stringArray, boolean bl) {
        Property property = null;
        if (!bl) {
            LinkedList<String> linkedList = new LinkedList<String>();
            try {
                for (int i = 0; i < stringArray.length; ++i) {
                    if ((l & (long)(1 << i)) == 0L) continue;
                    linkedList.add(stringArray[i]);
                }
            }
            catch (Exception exception) {
                this._errors.add(string + " value out of range: " + l);
            }
            property = new Property(string, PropertyType.STRING, PropertyArity.LIST, linkedList);
        }
        if (property == null) {
            property = new Property(string, PropertyType.LONG, new Long(l));
        }
        return property;
    }

    protected Property addIntegerProperty(String string, int n, String[] stringArray, boolean bl) {
        Property property = null;
        if (!bl) {
            try {
                property = new Property(string, PropertyType.STRING, stringArray[n]);
            }
            catch (Exception exception) {
                this._errors.add(string + " value out of range: " + n);
            }
        }
        if (property == null) {
            property = new Property(string, PropertyType.INTEGER, new Integer(n));
        }
        return property;
    }

    protected Property addIntegerProperty(String string, int n, String[] stringArray, int[] nArray, boolean bl) {
        Property property = null;
        if (!bl) {
            int n2 = -1;
            for (int i = 0; i < nArray.length; ++i) {
                if (n != nArray[i]) continue;
                n2 = i;
                break;
            }
            if (n2 > -1) {
                property = new Property(string, PropertyType.STRING, stringArray[n2]);
            } else {
                this._errors.add(string + " value out of range: " + n);
            }
        }
        if (property == null) {
            property = new Property(string, PropertyType.INTEGER, new Integer(n));
        }
        return property;
    }

    protected Property addIntegerArrayProperty(String string, int[] nArray, String[] stringArray, boolean bl) {
        Property property = null;
        if (!bl) {
            String[] stringArray2 = new String[nArray.length];
            for (int i = 0; i < nArray.length; ++i) {
                try {
                    stringArray2[i] = stringArray[nArray[i]];
                    continue;
                }
                catch (Exception exception) {
                    this._errors.add(string + " value out of range: " + nArray[i]);
                }
            }
            property = new Property(string, PropertyType.STRING, PropertyArity.ARRAY, stringArray2);
        }
        if (property == null) {
            property = new Property(string, PropertyType.INTEGER, PropertyArity.ARRAY, nArray);
        }
        return property;
    }

    protected Property addRationalProperty(String string, Rational rational, boolean bl) {
        Property property = null;
        if (!bl) {
            property = new Property(string, PropertyType.STRING, this._format.format(rational.toDouble()));
        }
        if (property == null) {
            property = new Property(string, PropertyType.RATIONAL, rational);
        }
        return property;
    }

    protected Property addRationalArrayProperty(String string, Rational[] rationalArray, boolean bl) {
        Property property = null;
        if (!bl) {
            String[] stringArray = new String[rationalArray.length];
            for (int i = 0; i < rationalArray.length; ++i) {
                stringArray[i] = this._format.format(rationalArray[i].toDouble());
            }
            property = new Property(string, PropertyType.STRING, PropertyArity.ARRAY, stringArray);
        }
        if (property == null) {
            property = new Property(string, PropertyType.RATIONAL, PropertyArity.ARRAY, rationalArray);
        }
        return property;
    }

    protected void postParseInitialization() {
    }

    protected Property propertyHeader(String string, List list) {
        Property[] propertyArray = new Property[]{new Property("Offset", PropertyType.LONG, new Long(this._offset)), new Property("Type", PropertyType.STRING, string), new Property("Entries", PropertyType.PROPERTY, PropertyArity.LIST, list)};
        return new Property("IFD", PropertyType.PROPERTY, PropertyArity.ARRAY, propertyArray);
    }

    protected String readASCII(long l, long l2) throws IOException {
        byte by;
        this._raf.seek(l2);
        byte[] byArray = new byte[(int)l];
        this._raf.read(byArray);
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while ((long)n < l && (by = byArray[n]) != 0) {
            if (by < 32 || by > 127) {
                stringBuffer.append(this.byteToHex(by));
            } else {
                stringBuffer.append((char)by);
            }
            ++n;
        }
        return stringBuffer.toString();
    }

    protected String[] readASCIIArray(long l, long l2) throws IOException {
        this._raf.seek(l2);
        int n = 0;
        LinkedList<String> linkedList = new LinkedList<String>();
        byte[] byArray = new byte[(int)l];
        this._raf.read(byArray);
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = 0;
        while ((long)n2 < l) {
            byte by = byArray[n2];
            if (by == 0) {
                linkedList.add(stringBuffer.toString());
                stringBuffer.setLength(0);
            } else if (by < 32 || by > 127) {
                stringBuffer.append(this.byteToHex(by));
            } else {
                stringBuffer.append((char)by);
            }
            ++n2;
        }
        String[] stringArray = new String[n];
        ListIterator listIterator = linkedList.listIterator();
        for (int i = 0; i < n; ++i) {
            stringArray[i] = (String)listIterator.next();
        }
        return stringArray;
    }

    protected int readByte(int n, long l, long l2) throws IOException {
        this._raf.seek(l2);
        return (int)this.readUnsigned(n);
    }

    protected int[] readByteArray(int n, long l, long l2) throws IOException {
        this._raf.seek(l2);
        int[] nArray = new int[(int)l];
        int n2 = 0;
        while ((long)n2 < l) {
            nArray[n2] = (int)this.readUnsigned(n);
            ++n2;
        }
        return nArray;
    }

    protected byte[] readTrueByteArray(int n, long l, long l2) throws IOException {
        this._raf.seek(l2);
        byte[] byArray = new byte[(int)l];
        this._raf.read(byArray);
        return byArray;
    }

    protected double[] readDoubleArray(long l, long l2) throws IOException {
        this._raf.seek(l2);
        double[] dArray = new double[(int)l];
        int n = 0;
        while ((long)n < l) {
            dArray[n] = ModuleBase.readDouble(this._raf, this._bigEndian);
            ++n;
        }
        return dArray;
    }

    protected long readLong(int n, long l, long l2) throws IOException {
        this._raf.seek(l2);
        return this.readUnsigned(n);
    }

    protected long[] readLongArray(int n, long l, long l2) throws IOException {
        this._raf.seek(l2);
        long[] lArray = new long[(int)l];
        int n2 = 0;
        while ((long)n2 < l) {
            lArray[n2] = this.readUnsigned(n);
            ++n2;
        }
        return lArray;
    }

    public long readUnsigned(int n) throws IOException {
        long l = 0L;
        switch (n) {
            case 1: 
            case 7: {
                l = ModuleBase.readUnsignedByte(this._raf);
                break;
            }
            case 3: {
                l = ModuleBase.readUnsignedShort(this._raf, this._bigEndian);
                break;
            }
            case 4: 
            case 13: {
                l = ModuleBase.readUnsignedInt(this._raf, this._bigEndian);
            }
        }
        return l;
    }

    protected Rational readRational(long l, long l2) throws IOException {
        this._raf.seek(l2);
        long l3 = ModuleBase.readUnsignedInt(this._raf, this._bigEndian);
        long l4 = ModuleBase.readUnsignedInt(this._raf, this._bigEndian);
        return new Rational(l3, l4);
    }

    protected Rational[] readRationalArray(long l, long l2) throws IOException {
        this._raf.seek(l2);
        byte[] byArray = new byte[(int)edu.harvard.hul.ois.jhove.module.tiff.IFD.calcValueSize(5, l)];
        this._raf.read(byArray);
        DataInputStream dataInputStream = new DataInputStream(new ByteArrayInputStream(byArray));
        Rational[] rationalArray = new Rational[(int)l];
        int n = 0;
        while ((long)n < l) {
            long l3 = ModuleBase.readUnsignedInt(dataInputStream, this._bigEndian, null);
            long l4 = ModuleBase.readUnsignedInt(dataInputStream, this._bigEndian, null);
            rationalArray[n] = new Rational(l3, l4);
            ++n;
        }
        return rationalArray;
    }

    protected Rational readSignedRational(long l, long l2) throws IOException {
        this._raf.seek(l2);
        long l3 = ModuleBase.readSignedInt(this._raf, this._bigEndian);
        long l4 = ModuleBase.readSignedInt(this._raf, this._bigEndian);
        return new Rational(l3, l4);
    }

    protected Rational[] readSignedRationalArray(long l, long l2) throws IOException {
        this._raf.seek(l2);
        byte[] byArray = new byte[(int)edu.harvard.hul.ois.jhove.module.tiff.IFD.calcValueSize(10, l)];
        this._raf.read(byArray);
        DataInputStream dataInputStream = new DataInputStream(new ByteArrayInputStream(byArray));
        Rational[] rationalArray = new Rational[(int)l];
        int n = 0;
        while ((long)n < l) {
            long l3 = ModuleBase.readSignedInt(dataInputStream, this._bigEndian, null);
            long l4 = ModuleBase.readSignedInt(dataInputStream, this._bigEndian, null);
            rationalArray[n] = new Rational(l3, l4);
            ++n;
        }
        return rationalArray;
    }

    protected int readShort(int n, long l, long l2) throws IOException {
        this._raf.seek(l2);
        return (int)this.readUnsigned(n);
    }

    protected int[] readShortArray(int n, long l, long l2) throws IOException {
        this._raf.seek(l2);
        int[] nArray = new int[(int)l];
        int n2 = 0;
        while ((long)n2 < l) {
            nArray[n2] = (int)this.readUnsigned(n);
            ++n2;
        }
        return nArray;
    }

    protected int[] readSShortArray(int n, long l, long l2) throws IOException {
        this._raf.seek(l2);
        int[] nArray = new int[(int)l];
        int n2 = 0;
        while ((long)n2 < l) {
            nArray[n2] = ModuleBase.readSignedShort(this._raf, this._bigEndian);
            ++n2;
        }
        return nArray;
    }

    public static long calcValueSize(int n, long l) {
        int n2 = 0;
        switch (n) {
            case 1: 
            case 2: 
            case 6: 
            case 7: {
                n2 = 1;
                break;
            }
            case 3: 
            case 8: 
            case 11: {
                n2 = 2;
                break;
            }
            case 4: 
            case 9: 
            case 13: {
                n2 = 4;
                break;
            }
            case 5: 
            case 10: 
            case 12: {
                n2 = 8;
            }
        }
        return l * (long)n2;
    }

    public boolean isBigEndian() {
        return this._bigEndian;
    }

    protected static void checkCount(int n, long l, int n2) throws TiffException {
        if (l < (long)n2) {
            throw new TiffException("Count mismatch for tag " + n + "; expecting " + n2 + ", saw " + l);
        }
    }

    protected static void checkType(int n, int n2, int n3) throws TiffException {
        if (!(n2 != 1 && n2 != 3 && n2 != 4 && n2 != 13 || n3 != 1 && n3 != 3 && n3 != 4 && n3 != 13)) {
            return;
        }
        if (n2 != n3) {
            throw new TiffException("Type mismatch for tag " + n + "; expecting " + n3 + ", saw " + n2);
        }
    }

    protected static void checkType(int n, int n2, int n3, int n4) throws TiffException {
        if (n2 != n3 && n2 != n4) {
            throw new TiffException("Type mismatch for tag " + n + "; expecting " + n3 + " or " + n4 + ", saw " + n2);
        }
    }

    protected static Rational average(Rational rational, Rational rational2) {
        long l = rational.getDenominator();
        long l2 = rational2.getDenominator();
        Rational rational3 = new Rational(rational.getNumerator() * l2, rational.getDenominator() * l2);
        Rational rational4 = new Rational(rational2.getNumerator() * l, rational2.getDenominator() * l);
        return new Rational((rational3.getNumerator() + rational4.getNumerator()) / 2L, rational3.getDenominator());
    }

    private String byteToHex(byte by) {
        int[] nArray = new int[]{(by & 0xF0) >> 4, by & 0xF};
        StringBuffer stringBuffer = new StringBuffer("%");
        for (int i = 0; i <= 1; ++i) {
            int n = nArray[i];
            n = n >= 10 ? (n += 55) : (n += 48);
            stringBuffer.append((char)n);
        }
        return stringBuffer.toString();
    }
}

