/*###############################################################################
# Linux Management Providers (LMP), Battery provider package
# Copyright (C) 2009 Shakhrom RUSTAMOV, TUIT <shahrombek@gmail.com>
#
# This program is being developed under the "OpenDRIM" project.
# The "OpenDRIM" project web page: http://opendrim.sourceforge.net
# The "OpenDRIM" project mailing list: opendrim@googlegroups.com
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; version 2
# of the License.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
#################################################################################

#################################################################################
# To contributors, please leave your contact information in this section
# AND comment your changes in the source code.
#
# Modified by 2009 Guillaume BOTTEX, ETRI <guillaumebottex@etri.re.kr>
###############################################################################*/

#include "cmpiOpenDRIM_Battery.h"
#include "OpenDRIM_BatteryAccess.h"

#include <iostream>

#define ToString(name, value, condition) os << (string) "      " + name + (string) "="; instance.condition ? os << "NULL" : os << instance.value; os << endl
#define ToStringInt(name, value, condition) os << (string) "      " + name + (string) "="; instance.condition ? os << "NULL" : os << (long) instance.value; os << endl
#define ToStringRef(name, value, condition) os << (string) "      " + name + (string) "="; instance.condition ? os << "NULL" : os << instance.value.toString(); os << endl
#define ToStringArray(name, value, condition) os << (string) "      " + name + (string) "=["; for (size_t i = 0; i < instance.value.size(); i++) { os << instance.value[i]; if (i < instance.value.size()-1) os << ","; } os << "]" << endl
#define ToStringArrayInt(name, value, condition) os << (string) "      " + name + (string) "=["; for (size_t i = 0; i < instance.value.size(); i++) { os << (long) instance.value[i]; if (i < instance.value.size()-1) os << ","; } os << "]" << endl
#define ToStringRefArray(name, value, condition) os << (string) "      " + name + (string) "=["; for (size_t i = 0; i < instance.value.size(); i++) { os << instance.value[i].toString(); if (i < instance.value.size()-1) os << ","; } os << "]" << endl

ostream& operator<<(ostream& os, OpenDRIM_Battery& instance) {
	os << "   [OpenDRIM_Battery]" << endl;
	ToString("Caption", Caption, Caption_isNULL);
	ToString("Description", Description, Description_isNULL);
	ToString("ElementName", ElementName, ElementName_isNULL);
	ToString("InstallDate", InstallDate, InstallDate_isNULL);
	ToString("Name", Name, Name_isNULL);
	ToStringArrayInt("OperationalStatus", OperationalStatus, OperationalStatus_isNULL);
	ToStringArray("StatusDescriptions", StatusDescriptions, StatusDescriptions_isNULL);
	ToString("Status", Status, Status_isNULL);
	ToStringInt("HealthState", HealthState, HealthState_isNULL);
	ToStringInt("PrimaryStatus", PrimaryStatus, PrimaryStatus_isNULL);
	ToStringInt("DetailedStatus", DetailedStatus, DetailedStatus_isNULL);
	ToStringInt("OperatingStatus", OperatingStatus, OperatingStatus_isNULL);
	ToStringInt("CommunicationStatus", CommunicationStatus, CommunicationStatus_isNULL);
	ToStringInt("EnabledState", EnabledState, EnabledState_isNULL);
	ToString("OtherEnabledState", OtherEnabledState, OtherEnabledState_isNULL);
	ToStringInt("RequestedState", RequestedState, RequestedState_isNULL);
	ToStringInt("EnabledDefault", EnabledDefault, EnabledDefault_isNULL);
	ToString("TimeOfLastStateChange", TimeOfLastStateChange, TimeOfLastStateChange_isNULL);
	ToStringArrayInt("AvailableRequestedStates", AvailableRequestedStates, AvailableRequestedStates_isNULL);
	ToStringInt("TransitioningToState", TransitioningToState, TransitioningToState_isNULL);
	ToString("SystemCreationClassName", SystemCreationClassName, SystemCreationClassName_isNULL);
	ToString("SystemName", SystemName, SystemName_isNULL);
	ToString("CreationClassName", CreationClassName, CreationClassName_isNULL);
	ToString("DeviceID", DeviceID, DeviceID_isNULL);
	ToString("PowerManagementSupported", PowerManagementSupported, PowerManagementSupported_isNULL);
	ToStringArrayInt("PowerManagementCapabilities", PowerManagementCapabilities, PowerManagementCapabilities_isNULL);
	ToStringInt("Availability", Availability, Availability_isNULL);
	ToStringInt("StatusInfo", StatusInfo, StatusInfo_isNULL);
	ToString("LastErrorCode", LastErrorCode, LastErrorCode_isNULL);
	ToString("ErrorDescription", ErrorDescription, ErrorDescription_isNULL);
	ToString("ErrorCleared", ErrorCleared, ErrorCleared_isNULL);
	ToStringArray("OtherIdentifyingInfo", OtherIdentifyingInfo, OtherIdentifyingInfo_isNULL);
	ToString("PowerOnHours", PowerOnHours, PowerOnHours_isNULL);
	ToString("TotalPowerOnHours", TotalPowerOnHours, TotalPowerOnHours_isNULL);
	ToStringArray("IdentifyingDescriptions", IdentifyingDescriptions, IdentifyingDescriptions_isNULL);
	ToStringArrayInt("AdditionalAvailability", AdditionalAvailability, AdditionalAvailability_isNULL);
	ToString("MaxQuiesceTime", MaxQuiesceTime, MaxQuiesceTime_isNULL);
	ToStringInt("LocationIndicator", LocationIndicator, LocationIndicator_isNULL);
	ToString("MaxPowerProduced", MaxPowerProduced, MaxPowerProduced_isNULL);
	ToString("MaxPowerProducedUnits", MaxPowerProducedUnits, MaxPowerProducedUnits_isNULL);
	ToString("MaxPowerConsumed", MaxPowerConsumed, MaxPowerConsumed_isNULL);
	ToString("MaxPowerConsumedUnits", MaxPowerConsumedUnits, MaxPowerConsumedUnits_isNULL);
	ToStringInt("BatteryStatus", BatteryStatus, BatteryStatus_isNULL);
	ToString("TimeOnBattery", TimeOnBattery, TimeOnBattery_isNULL);
	ToString("EstimatedRunTime", EstimatedRunTime, EstimatedRunTime_isNULL);
	ToStringInt("EstimatedChargeRemaining", EstimatedChargeRemaining, EstimatedChargeRemaining_isNULL);
	ToStringInt("Chemistry", Chemistry, Chemistry_isNULL);
	ToString("DesignCapacity", DesignCapacity, DesignCapacity_isNULL);
	ToString("FullChargeCapacity", FullChargeCapacity, FullChargeCapacity_isNULL);
	ToString("DesignVoltage", DesignVoltage, DesignVoltage_isNULL);
	ToString("SmartBatteryVersion", SmartBatteryVersion, SmartBatteryVersion_isNULL);
	ToString("TimeToFullCharge", TimeToFullCharge, TimeToFullCharge_isNULL);
	ToString("ExpectedLife", ExpectedLife, ExpectedLife_isNULL);
	ToString("MaxRechargeTime", MaxRechargeTime, MaxRechargeTime_isNULL);
	ToString("RechargeCount", RechargeCount, RechargeCount_isNULL);
	ToString("MaxRechargeCount", MaxRechargeCount, MaxRechargeCount_isNULL);
	ToString("RemainingCapacity", RemainingCapacity, RemainingCapacity_isNULL);
	ToStringInt("RemainingCapacityMaxError", RemainingCapacityMaxError, RemainingCapacityMaxError_isNULL);
	os << "   [\\OpenDRIM_Battery]" << endl;
	return os;
}

int main() {
	
	string errorMessage;

	int errorCode = Battery_OpenDRIM_Battery_load(NULL, errorMessage);
	if (errorCode != OK) {
		cout << "ERROR " << errorCode << ": " << errorMessage << endl;
		return -1;
	}

	cout << endl << "[enumInstances]" << endl;
	vector<OpenDRIM_Battery> instances;
	
	errorCode = Battery_OpenDRIM_Battery_retrieve(NULL, NULL, instances, NULL, errorMessage, "ei");
	if (errorCode != OK) {
		cout << "ERROR " << errorCode << ": " << errorMessage << endl;
		return -1;
	}
	
	vector<OpenDRIM_Battery>::iterator it = instances.begin();
	for (; it != instances.end(); ++it) {
		cout << *it;
	}
	
	cout << "[\\enumInstances]" << endl;
	cout << endl << "[enumInstanceNames & getInstance]" << endl;
	
	instances.clear();
	errorCode = Battery_OpenDRIM_Battery_retrieve(NULL, NULL, instances, NULL, errorMessage, "ein");
	if (errorCode != OK) {
		cout << "ERROR " << errorCode << ": " << errorMessage << endl;
		return -1;
	}
	
	it = instances.begin();
	for (; it != instances.end(); ++it) {
		errorCode = Battery_OpenDRIM_Battery_getInstance(NULL, NULL, *it, NULL, errorMessage);
		if (errorCode != OK) {
			cout << "ERROR " << errorCode << ": " << errorMessage << endl;
			return -1;
		}
		cout << *it;
	}
	
	cout << "[\\enumInstanceNames & getInstance]" << endl;
	cout << endl;

	errorCode = Battery_OpenDRIM_Battery_unload(errorMessage);
	if (errorCode != OK) {
		cout << "ERROR " << errorCode << ": " << errorMessage << endl;
		return -1;
	}
	return 0;
}
