/*###############################################################################
# Linux Management Providers (LMP), EthernetPort provider package
# Copyright (C) 2008 Guillaume BOTTEX, ETRI <guillaumebottex@etri.re.kr, guillaumebottex@gmail.com>
# 
# This program is being developed under the "OpenDRIM" project.
# The "OpenDRIM" project web page: http://opendrim.sourceforge.net
# The "OpenDRIM" project mailing list: opendrim@googlegroups.com
# 
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; version 2
# of the License.
# 
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
#################################################################################

#################################################################################
# To contributors, please leave your contact information in this section
# AND comment your changes in the source code.
# 
# Modified by <Author(s)>, <Affiliation>, <Year>
###############################################################################*/

#ifndef OPENDRIM_LANENDPOINTCAPABILITIESACCESS_H_
#define OPENDRIM_LANENDPOINTCAPABILITIESACCESS_H_

#include "EthernetPort_Common.h"

#include "OpenDRIM_LANEndpointCapabilities.h"
#include "assocOpenDRIM_LANEndpointCapabilities.h"

int EthernetPort_OpenDRIM_LANEndpointCapabilities_load(const CMPIBroker* broker, string& errorMessage);

int EthernetPort_OpenDRIM_LANEndpointCapabilities_unload(string& errorMessage);

int EthernetPort_OpenDRIM_LANEndpointCapabilities_retrieve(const CMPIBroker* broker, const CMPIContext* ctx, vector<OpenDRIM_LANEndpointCapabilities>& instances, const char** properties, string& errorMessage, const string& discriminant);

int EthernetPort_OpenDRIM_LANEndpointCapabilities_getInstance(const CMPIBroker* broker, const CMPIContext* ctx, OpenDRIM_LANEndpointCapabilities& instance, const char** properties, string& errorMessage);

int EthernetPort_OpenDRIM_LANEndpointCapabilities_setInstance(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_LANEndpointCapabilities& newInstance, const OpenDRIM_LANEndpointCapabilities& oldInstance, const char** properties, string& errorMessage);

int EthernetPort_OpenDRIM_LANEndpointCapabilities_createInstance(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_LANEndpointCapabilities& instance, string& errorMessage);

int EthernetPort_OpenDRIM_LANEndpointCapabilities_deleteInstance(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_LANEndpointCapabilities& instance, string& errorMessage);

int EthernetPort_OpenDRIM_LANEndpointCapabilities_associatorCapabilitiesToManagedElement(const CMPIBroker* broker, const CMPIContext* ctx, const Instance& Capabilities_instance, const char** properties, vector<Instance>& ManagedElement_associatedInstances, string& errorMessage, const string& discriminant);

int EthernetPort_OpenDRIM_LANEndpointCapabilities_associatorManagedElementToCapabilities(const CMPIBroker* broker, const CMPIContext* ctx, const Instance& ManagedElement_instance, const char** properties, vector<Instance>& Capabilities_associatedInstances, string& errorMessage, const string& discriminant);

int EthernetPort_OpenDRIM_LANEndpointCapabilities_referenceCapabilitiesToManagedElement(const CMPIBroker* broker, const CMPIContext* ctx, const Instance& Capabilities_instance, const vector<Instance>& ManagedElement_instances, vector<OpenDRIM_LANEndpointCapabilities>& OpenDRIM_LANEndpointCapabilities_instances, const char** properties, string& errorMessage, const string& discriminant);

int EthernetPort_OpenDRIM_LANEndpointCapabilities_referenceManagedElementToCapabilities(const CMPIBroker* broker, const CMPIContext* ctx, const Instance& ManagedElement_instance, const vector<Instance>& Capabilities_instances, vector<OpenDRIM_LANEndpointCapabilities>& OpenDRIM_LANEndpointCapabilities_instances, const char** properties, string& errorMessage, const string& discriminant);

int EthernetPort_OpenDRIM_LANEndpointCapabilities_populate(OpenDRIM_LANEndpointCapabilities& instance, string& errorMessage);

#endif /*OPENDRIM_LANENDPOINTCAPABILITIESACCESS_H_*/
