/*###############################################################################
# Linux Management Providers (LMP), Physical Asset provider package
# Copyright (C) 2008 Guillaume BOTTEX, ETRI <guillaumebottex@etri.re.kr, guillaumebottex@gmail.com>
#
# This program is being developed under the "OpenDRIM" project.
# The "OpenDRIM" project web page: http://opendrim.sourceforge.net
# The "OpenDRIM" project mailing list: opendrim@googlegroups.com
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; version 2
# of the License.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
#################################################################################

#################################################################################
# To contributors, please leave your contact information in this section
# AND comment your changes in the source code.
#
# Modified by <Author(s)>, <Affiliation>, <Year>
###############################################################################*/

#include "cmpiOpenDRIM_Slot.h"
#include "OpenDRIM_SlotAccess.h"

#include <iostream>

#define ToString(name, value, condition) os << (string) "      " + name + (string) "="; instance.condition ? os << "NULL" : os << instance.value; os << endl
#define ToStringInt(name, value, condition) os << (string) "      " + name + (string) "="; instance.condition ? os << "NULL" : os << (long) instance.value; os << endl
#define ToStringRef(name, value, condition) os << (string) "      " + name + (string) "="; instance.condition ? os << "NULL" : os << instance.value.toString(); os << endl
#define ToStringArray(name, value, condition) os << (string) "      " + name + (string) "=["; for (size_t i = 0; i < instance.value.size(); i++) { os << instance.value[i]; if (i < instance.value.size()-1) os << ","; } os << "]" << endl
#define ToStringArrayInt(name, value, condition) os << (string) "      " + name + (string) "=["; for (size_t i = 0; i < instance.value.size(); i++) { os << (long) instance.value[i]; if (i < instance.value.size()-1) os << ","; } os << "]" << endl
#define ToStringRefArray(name, value, condition) os << (string) "      " + name + (string) "=["; for (size_t i = 0; i < instance.value.size(); i++) { os << instance.value[i].toString(); if (i < instance.value.size()-1) os << ","; } os << "]" << endl

ostream& operator<<(ostream& os, OpenDRIM_Slot& instance) {
	os << "   [OpenDRIM_Slot]" << endl;
	ToString("Caption", Caption, Caption_isNULL);
	ToString("InstallDate", InstallDate, InstallDate_isNULL);
	ToString("Name", Name, Name_isNULL);
	ToStringArrayInt("OperationalStatus", OperationalStatus, OperationalStatus_isNULL);
	ToStringArray("StatusDescriptions", StatusDescriptions, StatusDescriptions_isNULL);
	ToString("Status", Status, Status_isNULL);
	ToStringInt("HealthState", HealthState, HealthState_isNULL);
	ToStringInt("PrimaryStatus", PrimaryStatus, PrimaryStatus_isNULL);
	ToStringInt("DetailedStatus", DetailedStatus, DetailedStatus_isNULL);
	ToStringInt("OperatingStatus", OperatingStatus, OperatingStatus_isNULL);
	ToStringInt("CommunicationStatus", CommunicationStatus, CommunicationStatus_isNULL);
	ToString("Tag", Tag, Tag_isNULL);
	ToString("Description", Description, Description_isNULL);
	ToString("CreationClassName", CreationClassName, CreationClassName_isNULL);
	ToString("ElementName", ElementName, ElementName_isNULL);
	ToString("Manufacturer", Manufacturer, Manufacturer_isNULL);
	ToString("Model", Model, Model_isNULL);
	ToString("SKU", SKU, SKU_isNULL);
	ToString("SerialNumber", SerialNumber, SerialNumber_isNULL);
	ToString("Version", Version, Version_isNULL);
	ToString("PartNumber", PartNumber, PartNumber_isNULL);
	ToString("OtherIdentifyingInfo", OtherIdentifyingInfo, OtherIdentifyingInfo_isNULL);
	ToString("ManufactureDate", ManufactureDate, ManufactureDate_isNULL);
	ToString("VendorEquipmentType", VendorEquipmentType, VendorEquipmentType_isNULL);
	ToString("UserTracking", UserTracking, UserTracking_isNULL);
	ToString("CanBeFRUed", CanBeFRUed, CanBeFRUed_isNULL);
	ToString("ConnectorPinout", ConnectorPinout, ConnectorPinout_isNULL);
	ToString("OtherTypeDescription", OtherTypeDescription, OtherTypeDescription_isNULL);
	ToStringInt("ConnectorGender", ConnectorGender, ConnectorGender_isNULL);
	ToStringArrayInt("ConnectorElectricalCharacteristics", ConnectorElectricalCharacteristics, ConnectorElectricalCharacteristics_isNULL);
	ToStringArray("OtherElectricalCharacteristics", OtherElectricalCharacteristics, OtherElectricalCharacteristics_isNULL);
	ToString("NumPhysicalPins", NumPhysicalPins, NumPhysicalPins_isNULL);
	ToStringInt("ConnectorLayout", ConnectorLayout, ConnectorLayout_isNULL);
	ToString("ConnectorDescription", ConnectorDescription, ConnectorDescription_isNULL);
	ToStringArrayInt("ConnectorType", ConnectorType, ConnectorType_isNULL);
	ToString("PoweredOn", PoweredOn, PoweredOn_isNULL);
	ToString("SupportsHotPlug", SupportsHotPlug, SupportsHotPlug_isNULL);
	ToString("HeightAllowed", HeightAllowed, HeightAllowed_isNULL);
	ToString("LengthAllowed", LengthAllowed, LengthAllowed_isNULL);
	ToStringInt("MaxDataWidth", MaxDataWidth, MaxDataWidth_isNULL);
	ToStringArrayInt("VccMixedVoltageSupport", VccMixedVoltageSupport, VccMixedVoltageSupport_isNULL);
	ToStringArrayInt("VppMixedVoltageSupport", VppMixedVoltageSupport, VppMixedVoltageSupport_isNULL);
	ToString("ThermalRating", ThermalRating, ThermalRating_isNULL);
	ToString("SpecialPurpose", SpecialPurpose, SpecialPurpose_isNULL);
	ToString("PurposeDescription", PurposeDescription, PurposeDescription_isNULL);
	ToStringInt("Number", Number, Number_isNULL);
	ToString("Powered", Powered, Powered_isNULL);
	ToString("OpenSwitch", OpenSwitch, OpenSwitch_isNULL);
	ToStringInt("MaxLinkWidth", MaxLinkWidth, MaxLinkWidth_isNULL);
	ToStringArray("VendorCompatibilityStrings", VendorCompatibilityStrings, VendorCompatibilityStrings_isNULL);
	os << "   [\\OpenDRIM_Slot]" << endl;
	return os;
}

int main() {
	
	string errorMessage;

	int errorCode = PhysicalAsset_OpenDRIM_Slot_load(NULL, errorMessage);
	if (errorCode != OK) {
		cout << "ERROR " << errorCode << ": " << errorMessage << endl;
		return -1;
	}

	cout << endl << "[enumInstances]" << endl;
	vector<OpenDRIM_Slot> instances;
	
	errorCode = PhysicalAsset_OpenDRIM_Slot_retrieve(NULL, NULL, instances, NULL, errorMessage, "ei");
	if (errorCode != OK) {
		cout << "ERROR " << errorCode << ": " << errorMessage << endl;
		return -1;
	}
	
	vector<OpenDRIM_Slot>::iterator it = instances.begin();
	for (; it != instances.end(); ++it) {
		cout << *it;
	}
	
	cout << "[\\enumInstances]" << endl;
	cout << endl << "[enumInstanceNames & getInstance]" << endl;
	
	instances.clear();
	errorCode = PhysicalAsset_OpenDRIM_Slot_retrieve(NULL, NULL, instances, NULL, errorMessage, "ein");
	if (errorCode != OK) {
		cout << "ERROR " << errorCode << ": " << errorMessage << endl;
		return -1;
	}
	
	it = instances.begin();
	for (; it != instances.end(); ++it) {
		errorCode = PhysicalAsset_OpenDRIM_Slot_getInstance(NULL, NULL, *it, NULL, errorMessage);
		if (errorCode != OK) {
			cout << "ERROR " << errorCode << ": " << errorMessage << endl;
			return -1;
		}
		cout << *it;
	}
	
	cout << "[\\enumInstanceNames & getInstance]" << endl;
	cout << endl;

	errorCode = PhysicalAsset_OpenDRIM_Slot_unload(errorMessage);
	if (errorCode != OK) {
		cout << "ERROR " << errorCode << ": " << errorMessage << endl;
		return -1;
	}
	return 0;
}
