/*###############################################################################
# Linux Management Providers (LMP), System Memory provider package
# Copyright (C) 2008 Guillaume BOTTEX, ETRI <guillaumebottex@etri.re.kr, guillaumebottex@gmail.com>
#
# This program is being developed under the "OpenDRIM" project.
# The "OpenDRIM" project web page: http://opendrim.sourceforge.net
# The "OpenDRIM" project mailing list: opendrim@googlegroups.com
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; version 2
# of the License.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
#################################################################################

#################################################################################
# To contributors, please leave your contact information in this section
# AND comment your changes in the source code.
#
# Modified by <Author(s)>, <Affiliation>, <Year>
###############################################################################*/

#ifndef OPENDRIM_MEMORYCONFORMSTOPROFILE_H_
#define OPENDRIM_MEMORYCONFORMSTOPROFILE_H_

#include <Association.h>

// Direct Invocation includes, may have to be adjusted
/*
#include "cmpiCIM_RegisteredProfile.h"
#include "CIM_RegisteredProfileAccess.h"
#include "cmpiCIM_ManagedElement.h"
#include "CIM_ManagedElementAccess.h"
*/

const static char* OpenDRIM_MemoryConformsToProfile_classnames[] = {"OpenDRIM_MemoryConformsToProfile"};
static string OpenDRIM_MemoryConformsToProfile_NAMESPACE = _INTEROP_NAMESPACE;
const static string ConformantStandard_role = "ConformantStandard";
const static char* ConformantStandard_classnames[] = {"OpenDRIM_RegisteredMemoryProfile"};
const static string ConformantStandard_NAMESPACE = _INTEROP_NAMESPACE;

const static string ManagedElement_role = "ManagedElement";
const static char* ManagedElement_classnames[] = {"OpenDRIM_Memory"};
const static string ManagedElement_NAMESPACE = _NAMESPACE;

class OpenDRIM_MemoryConformsToProfile {

public:
	
	Objectpath ConformantStandard;
	bool ConformantStandard_isNULL;
	
	Objectpath ManagedElement;
	bool ManagedElement_isNULL;
	
	OpenDRIM_MemoryConformsToProfile() {
		ConformantStandard_isNULL = true;
		ManagedElement_isNULL = true;
	}
	
	~OpenDRIM_MemoryConformsToProfile() {}
	
	string getKeys() const {
		return CF_toLowCase(".ConformantStandard=\"" + CF_quoteString(ConformantStandard.toString()) + "\""".ManagedElement=\"" + CF_quoteString(ManagedElement.toString()) + "\"");
	}

	int getConformantStandard(Objectpath& value) const {
		if (ConformantStandard_isNULL==true)
			return NOT_FOUND;
		value = ConformantStandard;
		return OK;
	}
	
	int setConformantStandard(const Objectpath& newValue) {
		ConformantStandard = newValue;
		ConformantStandard.setNamespace(ConformantStandard_NAMESPACE);
		ConformantStandard_isNULL = false;
		return OK;
	}

	int getManagedElement(Objectpath& value) const {
		if (ManagedElement_isNULL==true)
			return NOT_FOUND;
		value = ManagedElement;
		return OK;
	}
	
	int setManagedElement(const Objectpath& newValue) {
		ManagedElement = newValue;
		ManagedElement.setNamespace(ManagedElement_NAMESPACE);
		ManagedElement_isNULL = false;
		return OK;
	}

};

#endif /*OPENDRIM_MEMORYCONFORMSTOPROFILE_H_*/
