<!-- This Source Code Form is subject to the terms of the Mozilla Public
   - License, v. 2.0. If a copy of the MPL was not distributed with this
   - file, You can obtain one at http://mozilla.org/MPL/2.0/. -->

# Package Specification #

A *package* is a directory that, at minimum, contains a JSON file
called `package.json`. This file is also referred to as the
*package manifest*.

## The Package Manifest ##

`package.json` may contain the following keys:

* `name` - the name of the package. The package system will only load
  one package with a given name. This name cannot contain spaces or periods.
  The name defaults to the name of the parent directory. If the package is
  ever built as an XPI and the `fullName` key is not present, this is
  used as the add-on's `em:name` element in its `install.rdf`.

* `fullName` - the full name of the package. It can contain spaces. If
  the package is ever built as an XPI, this is used as the add-on's
  `em:name` element in its `install.rdf`.

* `description` - a String describing the package. If the package is
  ever built as an XPI, this is used as the add-on's
  `em:description` element in its `install.rdf`.

* `author` - the original author of the package. The author may be a
  String including an optional URL in parentheses and optional email
  address in angle brackets. If the package is ever built as an XPI,
  this is used as the add-on's `em:creator` element in its
  `install.rdf`.

* `translators` - an Array of Strings consisted of translators of the package.

* `contributors` - may be an Array of additional author Strings.

* `homepage` - the URL of the package's website.

* `icon` - the relative path from the root of the package to a
  PNG file containing the icon for the package. By default, this
  is `icon.png`. If the package is built as an XPI, this is used
  as the add-on's icon to display in the Add-on Manager's add-ons list.
  This key maps on to the
  [`iconURL` entry in the Install Manifest](https://developer.mozilla.org/en/install_manifests#iconURL),
  so the icon may be up to 48x48 pixels in size.

* `icon64` - the relative path from the root of the package to a
  PNG file containing the icon64 for the package. By default, this
  is `icon64.png`. If the package is built as an XPI, this is used
  as the add-on's icon to display in the Addon Manager's add-on details view.
  This key maps on to the
  [`icon64URL` entry in the Install Manifest](https://developer.mozilla.org/en/install_manifests#icon64URL),
  so the icon should be 64x64 pixels in size.

* `preferences` - *experimental*
  An array of JSON objects that use the following keys `name`, `type`, `value`,
  `title`, and `description`.  These JSON objects will be used to automatically
  create a preferences interface for the addon in the Add-ons Manager.
  For more information see the documentation of [simple-prefs](modules/sdk/simple-prefs.html).

* `license` - the name of the license as a String, with an optional
  URL in parentheses.

* `id` - a globally unique identifier for the package. When the package is
   built as an XPI, this is used as the add-on's `em:id` element in its
  `install.rdf`. See the
  [Program ID page](dev-guide/guides/program-id.html).

* `version` - a String representing the version of the package. If the
  package is ever built as an XPI, this is used as the add-on's
  `em:version` element in its `install.rdf`.

* `dependencies` - a String or Array of Strings representing package
  names that this package requires in order to function properly.

* `lib` - a String representing the top-level module directory provided in
  this package. Defaults to `"lib"`.

* `tests` - a String representing the top-level module directory containing
  test suites for this package. Defaults to `"tests"`.

* `packages` - a String or Array of Strings representing paths to
  directories containing additional packages, defaults to
  `"packages"`.

* `main` - a String representing the name of a program module that is
  located in one of the top-level module directories specified by
  `lib`. Defaults to `"main"`.

* `harnessClassID` - a String in the GUID format:
  `xxxxxxxx-xxxx-xxxx-xxxx-xxxxxxxxxxxx`, where `x` represents a single
  hexadecimal digit. It is used as a `classID` (CID) of the "harness service"
  XPCOM component. Defaults to a random GUID generated by `cfx`.

* `permissions` - a set of permissions that the add-on needs.
    * `private-browsing` - A Boolean indicating whether or not the
      package supports private browsing.  If this value is not `true`
      then the package will not see private windows.

## Documentation ##

A package may optionally contain a
[Markdown](http://daringfireball.net/projects/markdown/)-formatted file
called `README.md` in its root directory. Package-browsing tools may display
this file to developers.

Additionally, Markdown files can be placed in an optional `docs`
directory. When package-browsing tools are asked to show the
documentation for a module, they will look in this directory for a
`.md` file with the module's name. Thus, for instance, if a user
browses to a module at `lib/foo/bar.js`, the package-browsing tool
will look for a file at `docs/foo/bar.js` to represent the module's
API documentation.

## Data Resources ##

Packages may optionally contain a directory called `data` into which
arbitrary files may be placed, such as images or text files. The
URL for these resources may be reached using the
[self](modules/sdk/self.html) module.

  [Markdown]: http://daringfireball.net/projects/markdown/
  [non-bootstrapped XUL extension]: #guide/xul-extensions
