.AUTODEPEND

#               *Translator Definitions*
# bc5frac.cfg - optimize for speed
# bc5frac2.cfg - optimize for size
#
CC = bcc +BC5FRAC.CFG
CCsize = bcc +BC5FRAC2.CFG
TASM = TASM /ml /zi /o /jJUMPS /m2
TLIB = tlib
TLINK = tlink
# put your libpath here
LIBPATH = ..\LIB
# and include here
INCLUDEPATH = ..\INCLUDE


#               *Implicit Rules*
.c.obj:
  $(CC) -c {$< }

.cpp.obj:
  $(CC) -c {$< }

#               *List Macros*
Link_Exclude =  \
 fractint.hlp

Link_Include =  \
 3d.obj \
 ant.obj \
 bigflt.obj \
 biginit.obj \
 bignum.obj \
 bignumc.obj \
 calcfrac.obj \
 decoder.obj \
 diskvid.obj \
 encoder.obj \
 evolve.obj \
 f16.obj \
 fracsubr.obj \
 fractalb.obj \
 fractalp.obj \
 fractals.obj \
 fractint.obj \
 framain2.obj \
 frasetup.obj \
 gifview.obj \
 hcmplx.obj \
 jb.obj \
 jiim.obj \
 line3d.obj \
 loadmap.obj \
 lorenz.obj \
 lsys.obj \
 lsysf.obj \
 memory.obj \
 miscfrac.obj \
 miscovl.obj \
 miscres.obj \
 mpmath_c.obj \
 parser.obj \
 plot3d.obj \
 printer.obj \
 realdos.obj \
 rotate.obj \
 slideshw.obj \
 soi.obj \
 soi1.obj \
 sound.obj \
 stereo.obj \
 targa.obj \
 testpt.obj \
 tgaview.obj \
 tplus.obj \
 yourvid.obj \
 zoom.obj \
 cmdfiles.obj \
 editpal.obj \
 help.obj \
 intro.obj \
 loadfdos.obj \
 loadfile.obj \
 parserfp.obj \
 prompts1.obj \
 prompts2.obj \
 uclock.obj \
 calcmand.obj \
 calmanfp.obj \
 calmanp5.obj \
 fpu087.obj \
 fpu387.obj \
 fr8514a.obj \
 fracsuba.obj \
 general.obj \
 hgcfra.obj \
 lsysa.obj \
 lsysaf.obj \
 lyapunov.obj \
 mpmath_a.obj \
 newton.obj \
 parsera.obj \
 tplus_a.obj \
 video.obj

#               *Explicit Rules*
fractint.exe: bc5fract.lk $(Link_Include) $(Link_Exclude)
  $(TLINK) /L$(LIBPATH)/o @bc5fract.lk



#               *Individual File Dependencies*
hc.exe: hc.obj
  $(TLINK) /v- /i/c/P=48000/L$(LIBPATH) @bc5hc.lk

fractint.hlp: help.src help2.src help3.src help4.src help5.src hc.exe
  hc /c help.src

hc.obj: hc.c helpcom.h
  $(CC) -ml -c hc.c


# first all these

3d.obj: bc5fract.mak bc5frac.cfg fractint.hlp 3d.c

ant.obj: bc5fract.mak bc5frac.cfg fractint.hlp ant.c

bigflt.obj: bc5fract.mak bc5frac.cfg fractint.hlp bigflt.c

biginit.obj: bc5fract.mak bc5frac.cfg fractint.hlp biginit.c

bignum.obj: bc5fract.mak bc5frac.cfg fractint.hlp bignum.c

bignumc.obj: bc5fract.mak bc5frac.cfg fractint.hlp bignumc.c

calcfrac.obj: bc5fract.mak bc5frac.cfg calcfrac.c

decoder.obj: bc5fract.mak bc5frac.cfg decoder.c

diskvid.obj: bc5fract.mak bc5frac.cfg diskvid.c

encoder.obj: bc5fract.mak bc5frac.cfg encoder.c

evolve.obj: bc5fract.mak bc5frac.cfg evolve.c

f16.obj: bc5fract.mak bc5frac.cfg f16.c

fracsubr.obj: bc5fract.mak bc5frac.cfg fracsubr.c

fractalb.obj: bc5fract.mak bc5frac.cfg fractalb.c

fractalp.obj: bc5fract.mak bc5frac.cfg fractalp.c

fractals.obj: bc5fract.mak bc5frac.cfg fractals.c

fractint.obj: bc5fract.mak bc5frac.cfg fractint.c

framain2.obj: bc5fract.mak bc5frac.cfg framain2.c

frasetup.obj: bc5fract.mak bc5frac.cfg frasetup.c

gifview.obj: bc5fract.mak bc5frac.cfg gifview.c

hcmplx.obj: bc5fract.mak bc5frac.cfg hcmplx.c

jb.obj: bc5fract.mak  bc5frac.cfg jb.c

jiim.obj: bc5fract.mak  bc5frac.cfg jiim.c

line3d.obj: bc5fract.mak  bc5frac.cfg line3d.c

loadmap.obj: bc5fract.mak  bc5frac.cfg loadmap.c

lorenz.obj: bc5fract.mak  bc5frac.cfg lorenz.c

lsys.obj: bc5fract.mak  bc5frac.cfg lsys.c

lsysf.obj: bc5fract.mak  bc5frac.cfg lsysf.c

memory.obj: bc5fract.mak  bc5frac.cfg memory.c

miscfrac.obj: bc5fract.mak  bc5frac.cfg miscfrac.c

miscovl.obj: bc5fract.mak  bc5frac.cfg miscovl.c

miscres.obj: bc5fract.mak  bc5frac.cfg miscres.c

mpmath_c.obj: bc5fract.mak  bc5frac.cfg mpmath_c.c

parser.obj: bc5fract.mak  bc5frac.cfg parser.c

plot3d.obj: bc5fract.mak  bc5frac.cfg plot3d.c

printer.obj: bc5fract.mak  bc5frac.cfg printer.c

realdos.obj: bc5fract.mak  bc5frac.cfg realdos.c

rotate.obj: bc5fract.mak  bc5frac.cfg rotate.c

slideshw.obj: bc5fract.mak  bc5frac.cfg slideshw.c

soi.obj: bc5fract.mak  bc5frac.cfg soi.c

soi1.obj: bc5fract.mak  bc5frac.cfg soi1.c

sound.obj: bc5fract.mak  bc5frac.cfg sound.c

stereo.obj: bc5fract.mak bc5frac.cfg stereo.c

targa.obj: bc5fract.mak  bc5frac.cfg targa.c

testpt.obj: bc5fract.mak  bc5frac.cfg testpt.c

tgaview.obj: bc5fract.mak  bc5frac.cfg tgaview.c

tplus.obj: bc5fract.mak  bc5frac.cfg tplus.c

uclock.obj: bc5fract.mak  bc5frac.cfg uclock.c uclock.h

yourvid.obj: bc5fract.mak  bc5frac.cfg yourvid.c

zoom.obj: bc5fract.mak  bc5frac.cfg zoom.c


# then the ones optimized for size

cmdfiles.obj: bc5fract.mak bc5frac2.cfg cmdfiles.c
  $(CCsize) -c {cmdfiles.c }

editpal.obj: bc5fract.mak bc5frac2.cfg editpal.c
  $(CCsize) -c {editpal.c }

help.obj: bc5fract.mak bc5frac2.cfg help.c
  $(CCsize) -c {help.c }

intro.obj: bc5fract.mak  bc5frac2.cfg intro.c
  $(CCsize) -c {intro.c }

loadfdos.obj: bc5fract.mak  bc5frac2.cfg loadfdos.c
  $(CCsize) -c {loadfdos.c }

loadfile.obj: bc5fract.mak  bc5frac2.cfg loadfile.c
  $(CCsize) -c {loadfile.c }

parserfp.obj: bc5fract.mak  bc5frac2.cfg parserfp.c
  $(CCsize) -c {parserfp.c }

prompts1.obj: bc5fract.mak  bc5frac2.cfg prompts1.c
  $(CCsize) -c {prompts1.c }

prompts2.obj: bc5fract.mak  bc5frac2.cfg prompts2.c
  $(CCsize) -c {prompts2.c }

calcmand.obj: bc5fract.mak  bc5frac.cfg calcmand.asm
	$(TASM)  CALCMAND.ASM,CALCMAND.OBJ

calmanfp.obj: bc5fract.mak  bc5frac.cfg calmanfp.asm
	$(TASM)  CALMANFP.ASM,CALMANFP.OBJ

calmanp5.obj: bcfract.mak  bcfract.cfg calmanp5.asm
	$(TASM)  CALMANP5.ASM,CALMANP5.OBJ

fpu087.obj: bc5fract.mak  bc5frac.cfg fpu087.asm
	$(TASM)  FPU087.ASM,FPU087.OBJ

fpu387.obj: bc5fract.mak  bc5frac.cfg fpu387.asm
	$(TASM)  FPU387.ASM,FPU387.OBJ

fr8514a.obj: bc5fract.mak  bc5frac.cfg fr8514a.asm
	$(TASM)  FR8514A.ASM,FR8514A.OBJ

fracsuba.obj: bc5fract.mak  bc5frac.cfg fracsuba.asm
	$(TASM)  FRACSUBA.ASM,FRACSUBA.OBJ

general.obj: bc5fract.mak  bc5frac.cfg general.asm
	$(TASM)  GENERAL.ASM,GENERAL.OBJ

hgcfra.obj: bc5fract.mak  bc5frac.cfg hgcfra.asm
	$(TASM)  HGCFRA.ASM,HGCFRA.OBJ

lsysa.obj: bc5fract.mak  bc5frac.cfg lsysa.asm
	$(TASM)  LSYSA.ASM,LSYSA.OBJ

lsysaf.obj: bc5fract.mak  bc5frac.cfg lsysaf.asm
	$(TASM)  LSYSAF.ASM,LSYSAF.OBJ

lyapunov.obj: bc5fract.mak  bc5frac.cfg lyapunov.asm
	$(TASM)  LYAPUNOV.ASM,LYAPUNOV.OBJ

mpmath_a.obj: bc5fract.mak  bc5frac.cfg mpmath_a.asm
	$(TASM)  MPMATH_A.ASM,MPMATH_A.OBJ

newton.obj: bc5fract.mak  bc5frac.cfg newton.asm
	$(TASM)  NEWTON.ASM,NEWTON.OBJ

parsera.obj: bc5fract.mak  bc5frac.cfg parsera.asm
	$(TASM)  PARSERA.ASM,PARSERA.OBJ

tplus_a.obj: bc5fract.mak  bc5frac.cfg tplus_a.asm
	$(TASM)  TPLUS_A.ASM,TPLUS_A.OBJ

video.obj: bc5fract.mak  bc5frac.cfg video.asm
	$(TASM)  VIDEO.ASM,VIDEO.OBJ
