!{\src2tex{textfont=tt}}
!!****f* ABINIT/rdkss
!! NAME
!! rdkss
!!
!! FUNCTION
!!  read _KSS file
!!
!! COPYRIGHT
!! Copyright (C) 1999-2007 ABINIT group (GMR, VO, LR, RWG, MM, XG, MG, RShaltaf)
!! This file is distributed under the terms of the
!! GNU General Public License, see ~abinit/COPYING
!! or http://www.gnu.org/copyleft/gpl.txt .
!! For the initials of contributors, see ~abinit/doc/developers/contributors.txt .
!!
!! INPUTS
!!  dtfil=filenames (here, only dtfil%filkss is used)
!!  mpsangx= 1+maximum angular momentum for nonlocal pseudopotential
!!  natomx=maximum number of atoms
!!  nbx=maximum number of bands
!!  ngx=maximum number of G vectors
!!  nkx=maximum number of k points
!!  nopx=maximum number of symmetry operations
!!  nsx=1 for unpolarized, 2 for spin-polarized
!!  ntypatx=maximum number of types of atoms
!!  nwx=maximum number of planewaves
!!  nonlocal= if true, only master proc has access to kss file
!!  min_band_proc,max_band_proc=index of the min and max bands to be stored in the memory of each proc
!! OUTPUT
!!  a1(3), a2(3), a3(3)= real-space lattice vectors in au
!!  en(nkx,nbx,nsx)=KS energies for each k point and each band
!!  gvec(3,ngx)=integer coordinates of G vectors
!!  hdr=header of the KSS file
!!  kibz(3,nkx)=coordinates of k points in IBZ
!!  mpi_enreg=informations about MPI parallelization
!!  nel=number of electrons
!!  oc(nkx,nbx,nsx)=occupation numbers for each k point, each band and each spin
!!  op(3,3,nop)=symmetry operations in reciprocal space
!!  tit(2)(len=80)= titles in the KSS file
!!  typat(natomx)=types of atoms
!!  vkb(nwx,ntypatx,mpsangx,nkx)=KB projector function
!!  vkbd(nwx,ntypatx,mpsangx,nkx)=derivative of the KB projector function in reciprocal space
!!  vkbsign(mpsangx,ntypatx)=sign of each KB dyadic product
!!  wf(nwx,nbx,nkx,nsx)=wavefunctions, for each band, each k point and spin
!!  xred(3,natomx)=coordinates of atoms in real space
!!
!! PARENTS
!!      screening,sigma
!!
!! CHILDREN
!!      hdr_io,hdr_io_netcdf,leave_new,pclock,wrtout,xcast_mpi,xcomm_init
!!      xmaster_init,xmax_mpi_dpv,xme_init,xmin_mpi_dpv
!!
!! SOURCE
#if defined HAVE_CONFIG_H
#include "config.h"
#endif

subroutine rdkss(dtfil,hdr,nopx,nbx,nkx,ngx,nsx,nwx,tit,a1,a2,a3,op,gvec,kibz,en, &
& oc,wf,ntypatx,natomx,mpsangx,typat,xred,vkbsign,vkb,vkbd,nel,mpi_enreg,nonlocal,min_band_proc,max_band_proc)

 use defs_basis
 use defs_datatypes

!This section has been created automatically by the script Abilint (TD). Do not modify these by hand.
#ifdef HAVE_FORTRAN_INTERFACES
 use interfaces_01manage_mpi
 use interfaces_13io_mpi
 use interfaces_lib01hidempi
#else
 use defs_interfaces
 use defs_xfuncmpi
#endif
!End of the abilint section

 implicit none

#if defined MPI || defined MPI_FFT
    include 'mpif.h'
#endif
    
!Arguments ------------------------------------
!scalars
 integer,intent(in) :: mpsangx,natomx,nbx,ngx,nkx,nopx,nsx,ntypatx,nwx,min_band_proc,max_band_proc
 integer,intent(out) :: nel
 type(datafiles_type),intent(in) :: dtfil
 type(hdr_type),intent(out) :: hdr
 type(MPI_type),intent(in) :: mpi_enreg
 logical,intent(in)::nonlocal   
!arrays
 integer,intent(out) :: gvec(3,ngx),typat(natomx)
 real(dp),intent(out) :: a1(3),a2(3),a3(3),en(nkx,min_band_proc:max_band_proc,nsx),kibz(3,nkx)
 real(dp),intent(out) :: oc(nkx,min_band_proc:max_band_proc,nsx)
 real(dp),intent(out) :: op(3,3,nopx),vkb(nwx,ntypatx,mpsangx,nkx)
 real(dp),intent(out) :: vkbd(nwx,ntypatx,mpsangx,nkx),vkbsign(mpsangx,ntypatx)
 real(dp),intent(out) :: xred(3,natomx)
 complex,intent(out) :: wf(nwx,min_band_proc:max_band_proc,nkx,nsx)
 character(len=80),intent(out) :: tit(2)
 
!Local variables-------------------------------
!scalars
 integer,parameter :: unitkss=23
 integer :: day,fform,i,ia,ib,ibp,ig,ik,il,ipa,is,ish,isym,isymend,isymin,it,isppol,ios
 integer :: itypat,j,month,mpsang,natom,nbandkss,nela,nkpt,npwkss,nsh,nsym2,nsppol
 integer :: ntypat,osl,rdwr,readnetcdf,year,ierr
 complex :: cdum
 logical,parameter :: DEBUG=.false.
 character(len=10) :: stag(2)=(/' UP   ',' DOWN '/)
 character(len=500) :: message
!arrays
 integer,allocatable :: shlim(:),symrel2(:,:,:)
 real(dp),allocatable :: energyd(:),tnons2(:,:),vkbdb(:,:,:),vkbdd(:,:,:)
 real(dp),allocatable :: vkbsignd(:,:)
 complex,allocatable :: wfgs(:)
 complex,allocatable :: temp_wf(:,:,:)
 real(dp),allocatable::temp_en(:,:),temp_oc(:,:,:)
!no_abirules
 real(dp) :: cinf,csup,dum,einf,esup,cinf1,csup1,einf1,esup1
 real,allocatable :: vkbsigns(:,:)
 real,allocatable :: vkbds(:,:,:),vkbs(:,:,:)
 real,allocatable :: energys(:)
 complex (kind(0.0_dp)), allocatable :: wfgd(:)
 integer::spaceComm,me,master
 logical::i_can_read,master_must_cast_data
! *************************************************************************
!start clock
! call pclock(0)
!Init mpi_comm
 call xcomm_init(mpi_enreg,spaceComm)
!Init me
 call xme_init(mpi_enreg,me)
!Init master
 call xmaster_init(mpi_enreg,master)
    
!DEBUG
!write(6,*)' rdkss : enter '
!ENDDEBUG
!NOTES

! paralellized by RShaltaf 13/12/06
! nonlocal==true, master proc will read and cast data to other proc
! nonlocal==false, every proc has access to the file

 if( mpi_enreg%nproc==1 .or. (.not.nonlocal) .or. me==0 )then
  i_can_read=.true.
 else 
  i_can_read=.false.
 end if

 if(mpi_enreg%nproc>1.and.nonlocal)then
   master_must_cast_data=.true.
  else
   master_must_cast_data=.false.
  end if
 allocate(temp_oc(nkx,nbx,nsx))
 
if(i_can_read)then

 open(unit=unitkss,file=dtfil%filkss,form='unformatted',status='old',iostat=ios)
 if (ios/=0) then 
  write(message,'(5a)')&
&  ' rdkss: ERROR- ',ch10,&
&  ' opening file: ',trim(dtfil%filkss),' as old'
  call wrtout(6,message,'COLL')
  call leave_new('COLL')
 end if

 !Read the header of the GS wavefunction file
 rdwr=1
 readnetcdf = 0 ! should become input parameter and make KSS a netcdf file as well
 if (readnetcdf == 0) then
  call hdr_io(fform,hdr,rdwr,unitkss)
 else if (readnetcdf == 1) then
  call hdr_io_netcdf(fform,hdr,rdwr,unitkss)
 end if

 if(fform/=502.and.fform/=602) then
  write(message,'(4a,i8)')&
&  ' rdkss : ERROR -  ',ch10,&
&  trim(dtfil%filkss),' has fform/=502,602 ',fform
  call wrtout(6,message,'COLL')
  call leave_new('COLL')
 end if

 if(fform==502) then
  write(message,'(2a)')' Kohn Sham Structure double precision file',ch10
 else if(fform==602) then
  write(message,'(2a)')' Kohn Sham Structure single precision file',ch10
 end if
 call wrtout(6,message,'COLL')

 !Write the header of the GS wavefunction file
 rdwr=4
 call hdr_io(fform,hdr,rdwr,6)

 natom=hdr%natom
 nsppol=hdr%nsppol
 ntypat=hdr%ntypat
 nkpt=hdr%nkpt

 a1(:) = hdr%rprimd(:,1)
 a2(:) = hdr%rprimd(:,2)
 a3(:) = hdr%rprimd(:,3)

 if(ntypat/=ntypatx) stop 'ntypat/=ntypatx'
 if(natom/=natomx) stop 'natom/=natomx'
 if(nkpt/=nkx) stop 'nkpt/=nkx'
 if(nsppol/=nsx) stop 'nsppol/=nsx'

 typat(1:natomx)=hdr%typat(1:natomx)
 kibz(:,1:nkx) = hdr%kptns(:,1:nkx)

 temp_oc(:,:,:) = 0.0
 do isppol=1,nsppol
  do ik = 1, nkpt
   do ib = 1, hdr%nband(ik+nkpt*(isppol-1))
    !MG 060914 Added external loop on spin
    !note: hdr%nband(nkpt*nsppol)
    !      hdr%occ(bantot) where bantot is the total number of bands 
    !      (i.e sum of nband on all kpts and spins)
    !      hdr%nband(nkpt*nsppol),
    !      in the GW part the number of bands is the same for each k-point and spin
    i = (ik-1)*hdr%nband(ik) +(isppol-1)*nkpt*hdr%nband(ik) + ib 
    if(ib<=nbx) temp_oc(ik,ib,isppol) = hdr%occ(i)
   end do
  end do
 end do 

 do itypat = 1, ntypat
  if(hdr%pspso(itypat)/=1) then
   write(message,'(3a)')&
&   ' rdkss:  ERROR- ',ch10,&
&   ' pspso value not programmed'
   write(*,*)' pspso = ', hdr%pspso(itypat)
   call wrtout(6,message,'COLL')
   call leave_new('COLL')
  end if
 end do

 nel = 0
 do ia = 1, hdr%natom
  it = hdr%typat(ia)
  nela = hdr%znucltypat(it)  ! if it is not a pseudoatom, add all electron
  do ipa = 1, hdr%npsp
   if(hdr%znuclpsp(ipa) == hdr%znucltypat(it)) nela = hdr%zionpsp(ipa)
  end do
  nel = nel + nela
 end do

 xred(:,1:natomx) =hdr%xred(:,1:natomx)
 !End of treatment of the header

 end if ! i_can_read
 if(master_must_cast_data)then 

   call xcast_mpi(a1,master,spaceComm,ierr)
   call xcast_mpi(a2,master,spaceComm,ierr)
   call xcast_mpi(a3,master,spaceComm,ierr)
   call xcast_mpi(kibz,master,spaceComm,ierr)
   call xcast_mpi(temp_oc,master,spaceComm,ierr)
   call xcast_mpi(typat,master,spaceComm,ierr)
   call xcast_mpi(xred,master,spaceComm,ierr)
   call xcast_mpi(nel,master,spaceComm,ierr)
   call xcast_mpi(nkpt,master,spaceComm,ierr)
   call xcast_mpi(ntypat,master,spaceComm,ierr)
   call xcast_mpi(fform,master,spaceComm,ierr)
   call xcast_mpi(nsppol,master,spaceComm,ierr)
  end if

 if(i_can_read)then 
 read(unitkss) tit(1)
 read(unitkss) tit(2)
 write(message,'(1x,a79,a,1x,a79)')tit(1)(:79),ch10,tit(2)(:79)
 call wrtout(6,message,'COLL')
 end if

 if(master_must_cast_data)then
! the follwoing string data is not important to be known by every proc
  if(me>0)then
    tit(1)='only master proc knows'   
    tit(2)='only master proc knows'
   end if
 end if
 
 write(6,'(1x,a79/1x,a79)') tit(1)(:79), tit(2)(:79)

 if(i_can_read)then
  read(unitkss) nsym2, nbandkss, npwkss, nsh, mpsang
  write(message,'(a,i8)')' number of electrons                    ',nel
   call wrtout(6,message,'COLL')
  write(message,'(a,i8)')' number of symmetries without inversion ',nsym2
   call wrtout(6,message,'COLL')
  write(message,'(a,i8)')' number of bands                        ',nbandkss
   call wrtout(6,message,'COLL')
  write(message,'(a,i8)')' number of plane waves                  ',npwkss
   call wrtout(6,message,'COLL')
  write(message,'(a,i8)')' number of shells                       ',nsh
  !write(*,*)' mpsang ',mpsang

  if(mpsang/=mpsangx) stop 'mpsang/=mpsangx'
  if(nopx>nsym2) stop 'nopx>nsym2'
  if(ngx>npwkss) stop 'ngx>npwkss'
  if(nwx>npwkss) stop 'nwx>npwkss'
  if(nbx>nbandkss) stop 'nbx>nbandkss'

  allocate(symrel2(3,3,nsym2))
!MG FIXME op are symmetry operations in reciprocal space
!   in this implementation we do not read transpose R**-1
!   but transpose R 
!   this approach is correct since Rs form a group but in this 
!   way we lose the correspondence btw an operation in G space
!   and the phase associated to tnons
  read(unitkss) (((symrel2(j,i,isym),i=1,3),j=1,3),isym=1,nsym2)
  op(:,:,1:nopx) = symrel2(:,:,1:nopx)

  write(message,'(a)')' symmetry operations [reciprocal lattice units]:'
  call wrtout(6,message,'COLL')
  if(mpi_enreg%me==0)then ! only master should write
   do isymin=1,nopx,8
    isymend=isymin+7
    if(isymend.gt.nopx) isymend=nopx
    do i=1,3
     write(6,2995) ((symrel2(i,j,isym),j=1,3),isym=isymin,isymend)
2995      format(7(3i3,1x),3i3)
    end do
    write(*,*)
   end do
  end if
 end if ! i_can_read

 if(master_must_cast_data)then
  call xcast_mpi(nsym2,master,spaceComm,ierr)
  call xcast_mpi(nbandkss,master,spaceComm,ierr)
  call xcast_mpi(npwkss,master,spaceComm,ierr)
  call xcast_mpi(nsh,master,spaceComm,ierr)
  call xcast_mpi(mpsang,master,spaceComm,ierr)
  call xcast_mpi(op,master,spaceComm,ierr)
 end if

 if(i_can_read)then
  allocate(tnons2(3,nsym2))
  read(unitkss) ((tnons2(i,isym),i=1,3),isym=1,nsym2)
  write(message,'(a)')' translations '
  call wrtout(6,message,'COLL')
  if(mpi_enreg%me==0)then ! only master should write
   write(*,'(10x,3f7.3)') tnons2
   write(*,*)
  end if

  allocate(shlim(nsh))

  read(unitkss) ((gvec(i,ig),i=1,3),ig=1,ngx)
  read(unitkss) (shlim(i),i=1,nsh)

  write(message,'(a)')' (" shell limit G-vectors [reduced coordinates]")'
  call wrtout(6,message,'COLL')

  if(mpi_enreg%me==0)then ! only master should write
   osl = 1
   do ish = 1, nsh
    if(shlim(ish)>ngx) osl = shlim(ish)+1
    write(*,'(i6,i6,4(i5," (",3i3,")"),20(/12x,4(i5," (",3i3,")")))')&
&   ish, shlim(ish), (ig,(gvec(i,ig),i=1,3),ig=osl,shlim(ish))
    osl = shlim(ish)+1
   end do
   write(*,*)
  end if

  if(fform==502) then
   allocate(vkbsignd(mpsang,ntypat))
   read(unitkss) ((vkbsignd(il,is),il=1,mpsang),is=1,ntypat)
   vkbsign(1:mpsang,1:ntypat) = vkbsignd(1:mpsang,1:ntypat)
   deallocate(vkbsignd)
  else if(fform==602) then
   allocate(vkbsigns(mpsang,ntypat))
   read(unitkss) ((vkbsigns(il,is),il=1,mpsang),is=1,ntypat)
   vkbsign(1:mpsang,1:ntypat) = vkbsigns(1:mpsang,1:ntypat)
   deallocate(vkbsigns)
  end if
 end if ! i_can_read

 if(master_must_cast_data)then
  call xcast_mpi(vkbsign,master,spaceComm,ierr)
  call xcast_mpi(gvec,master,spaceComm,ierr)
 end if

 write(6,'(" vkbsign: ",8f4.1)') vkbsign(:,:)
 write(6,*)

 if(fform==502) then
  allocate(vkbdb(npwkss,ntypat,mpsang))
  allocate(vkbdd(npwkss,ntypat,mpsang))
  allocate(energyd(nbandkss))
  allocate(wfgd(npwkss))
 else if(fform==602) then
  allocate(vkbs(npwkss,ntypat,mpsang))
  allocate(vkbds(npwkss,ntypat,mpsang))
  allocate(energys(nbandkss))
  allocate(wfgs(npwkss))
 end if

 write(message,'(2a)')ch10,' k       eigenvalues [eV]'
 call wrtout(ab_out,message,'COLL')
 call wrtout(6,message,'COLL')

 !MG 090614 added external loop on isppol
 do isppol=1,nsppol
  do ik = 1, nkpt
   !write(*,*)'ik ', ik
   do is = 1, ntypat
    !write(*,*)'is ', is
    do il = 1, mpsang
     !write(*,*)'il ', il
     if(fform==502) then
      if(i_can_read)then
       read(unitkss) vkbdb(:,is,il)
       read(unitkss) vkbdd(:,is,il)
      end if
      if(master_must_cast_data)then
       call xcast_mpi(vkbdb(:,is,il),master,spaceComm,ierr)
       call xcast_mpi(vkbdd(:,is,il),master,spaceComm,ierr)
      end if
      vkb(1:nwx,is,il,ik) = vkbdb(1:nwx,is,il)
      vkbd(1:nwx,is,il,ik) =vkbdd(1:nwx,is,il)
     else if(fform==602) then
      if(i_can_read)then
       read(unitkss) vkbs(:,is,il)
       read(unitkss) vkbds(:,is,il)
      end if
      if(master_must_cast_data)then
       call xcast_mpi(vkbs(:,is,il),master,spaceComm,ierr)
       call xcast_mpi(vkbds(:,is,il),master,spaceComm,ierr)
      end if
      vkb(1:nwx,is,il,ik) = vkbs(1:nwx,is,il)
      vkbd(1:nwx,is,il,ik) = vkbds(1:nwx,is,il)
     end if
     if(DEBUG) print *, 'vkb ', vkb(:,:,:,ik)
     if(DEBUG) print *, 'vkbd ', vkbd(:,:,:,ik)
    end do !il
   end do !is

   if(fform==502) then

    if(i_can_read)then
     read(unitkss) energyd(1:nbandkss)
    end if
    if(master_must_cast_data)then
     call xcast_mpi(energyd,master,spaceComm,ierr)
    end if
    en(ik,min_band_proc:max_band_proc,isppol)=energyd(min_band_proc:max_band_proc)

   else if(fform==602) then

    if(i_can_read)then
     read(unitkss) energys(1:nbandkss)
    end if
    if(master_must_cast_data)then
     call xcast_mpi(energys,master,spaceComm,ierr)
    end if
    en(ik,min_band_proc:max_band_proc,isppol)=energys(min_band_proc:max_band_proc)

   end if
    if (nsppol==2) then 
     write(6,'(i3,a,10f7.2/50(10x,10f7.2/))') ik,stag(isppol), (Ha_eV*en(ik,ib,isppol),ib=min_band_proc,max_band_proc)
     write(ab_out,'(i3,a,10f7.2/50(10x,10f7.2/))') ik,stag(isppol), (Ha_eV*en(ik,ib,isppol),ib=min_band_proc,max_band_proc)
    else 
     write(6,'(i3,7x,10f7.2/50(10x,10f7.2/))') ik, (Ha_eV*en(ik,ib,isppol),ib=min_band_proc,max_band_proc)
     write(ab_out,'(i3,7x,10f7.2/50(10x,10f7.2/))') ik, (Ha_eV*en(ik,ib,isppol),ib=min_band_proc,max_band_proc)
    end if

   if(fform==502) then
    do ib = 1, nbx
     if(i_can_read)then
      read(unitkss) wfgd(1:npwkss)
     end if
     if(master_must_cast_data)then
      call xcast_mpi(wfgd,master,spaceComm,ierr)
     end if
     if(ib>=min_band_proc.and.ib<=max_band_proc)then
      wf(1:nwx,ib,ik,isppol) = wfgd(1:nwx)
     end if
    end do
    do ib = nbx+1 , nbandkss
     if(i_can_read)then
      read(unitkss) wfgd(1:npwkss)
     end if
    end do

   else if(fform==602) then
    do ib = 1, nbx
     if(i_can_read)then
      read(unitkss) wfgs(1:npwkss)
     end if
     if(master_must_cast_data)then
      call xcast_mpi(wfgs,master,spaceComm,ierr)
     end if
     if(ib>=min_band_proc.and.ib<=max_band_proc)then
      wf(1:nwx,ib,ik,isppol) = wfgs(1:nwx)
     end if
    end do
    do ib = nbx+1 , nbandkss
     if(i_can_read)then
      read(unitkss) wfgs(1:npwkss)
     end if
    end do

   end if ! fform
  end do ! ik

  oc(:,min_band_proc:max_band_proc,isppol)=temp_oc(:,min_band_proc:max_band_proc,isppol)

 end do !isppol

  write(ab_out,*)

 einf1 = 1.0e24; esup1 = 0.0
 cinf1 = 1.0e24; csup1 = 0.0

 !MG 090614 added external loop on isppol
 do isppol=1,nsppol

  do ik = 1, nkx

!  test on the normalization of wavefunctions
   do ib =min_band_proc,max_band_proc
    dum = 0.0
    do ig = 1, nwx
     dum = dum + conjg(wf(ig,ib,ik,isppol))*wf(ig,ib,ik,isppol)
    end do
    if(dum<einf1) einf1 = dum
    if(dum>esup1) esup1 = dum
   end do
   if(mpi_enreg%nproc>1)then
    call xmin_mpi_dpv(einf1,einf,spaceComm,ierr)
    call xmax_mpi_dpv(esup1,esup,spaceComm,ierr)
   else
    einf=einf1
    esup=esup1
   end if
!  test on the orthogonalization of wavefunctions
!  MG WARNING: in case of parallelization over bands we are evaluating
!  the scalar product only btw bands belonging to the same sub-block
   do ib = min_band_proc,max_band_proc
    do ibp = ib+1,max_band_proc
     cdum = 0.0
     do ig = 1, nwx
      cdum = cdum + conjg(wf(ig,ib,ik,isppol))*wf(ig,ibp,ik,isppol)
     end do
     if(abs(cdum)<cinf1) cinf1 = abs(cdum)
     if(abs(cdum)>csup1) csup1 = abs(cdum)
    end do
   end do
   if(mpi_enreg%nproc>1)then
    call xmin_mpi_dpv(cinf1,cinf,spaceComm,ierr)
    call xmax_mpi_dpv(csup1,csup,spaceComm,ierr)
   else
    csup=csup1
    cinf=cinf1
   end if

  end do !ik
 end do !isppol

 !MG060914 FIXME add a label for the spin 
 write(message,'(a)')' test on the normalization of the wavefunctions'
 call wrtout(6,message,'COLL') ; call wrtout(ab_out,message,'COLL')

 write(message,'(a,f9.6,a,a,f9.6)')&
& ' min sum_G |a(n,k,G)| = ',einf,ch10,&
& ' max sum_G |a(n,k,G)| = ',esup
 call wrtout(6,message,'COLL') ; call wrtout(ab_out,message,'COLL')

 write(message,'(a)')' test on the orthogonalization of the wavefunctions'
 call wrtout(6,message,'COLL') ; call wrtout(ab_out,message,'COLL')
 write(message,'(a,f9.6,a,a,f9.6,a)')&
& ' min sum_G a(n,k,G)* a(n",k,G) = ',cinf,ch10,&
& ' max sum_G a(n,k,G)* a(n",k,G) = ',csup,ch10
 call wrtout(6,message,'COLL') ; call wrtout(ab_out,message,'COLL')

 if(i_can_read)then
  close(unitkss)
 end if

 !deallocations added by MM
 if(allocated(symrel2))deallocate(symrel2)
 if(allocated(tnons2))deallocate(tnons2)
 if(allocated(shlim))deallocate(shlim)
 if(allocated(vkbdb))deallocate(vkbdb)
 if(allocated(vkbdb))deallocate(vkbdb)
 if(allocated(vkbdd))deallocate(vkbdd)
 if(allocated(energyd))deallocate(energyd)
 if(allocated(wfgd))deallocate(wfgd)
 if(allocated(vkbs))deallocate(vkbs)
 if(allocated(vkbds))deallocate(vkbds)
 if(allocated(energys))deallocate(energys)
 if(allocated(wfgs))deallocate(wfgs)
 if(allocated(temp_oc))deallocate(temp_oc)
 end subroutine rdkss
!!***
