# ----------------------------------------------------------------------------
# - std-tls-inets                                                            -
# - afnix:tls inet server class module                                       -
# ----------------------------------------------------------------------------
# - This program is  free software;  you can  redistribute it and/or  modify -
# - it provided that this copyright notice is kept intact.                   -
# -                                                                          -
# - This  program  is  distributed in the hope  that it  will be useful, but -
# - without  any   warranty;  without  even   the   implied    warranty   of -
# - merchantability  or fitness for a particular purpose. In not event shall -
# - the copyright holder be  liable for  any direct, indirect, incidental or -
# - special damages arising in any way out of the use of this software.      -
# ----------------------------------------------------------------------------
# - copyright (c) 1999-2015 amaury darsch                                    -
# ----------------------------------------------------------------------------

# ----------------------------------------------------------------------------
# - global section                                                           -
# ----------------------------------------------------------------------------

# the inet server class
const afnix:tls:inets (class)

# ----------------------------------------------------------------------------
# - private section                                                          -
# ----------------------------------------------------------------------------

# the option messages
const AFNIX:TLS:U-CLS-MSG "axi [i afnix-std-tls cmd-tls-inets] [options]"
const AFNIX:TLS:H-LCO-MSG "    [h]              print this help message"
const AFNIX:TLS:V-LCO-MSG "    [v]              print system version"
const AFNIX:TLS:D-LCO-MSG "    [d]              set the debug flag"
const AFNIX:TLS:T-LCO-MSG "    [t]              connect with a tcp socket"

# ----------------------------------------------------------------------------
# - initial section                                                          -
# ----------------------------------------------------------------------------

# preset the inet server class

trans afnix:tls:inets:preset (argv) {
  # preini the server class
  this:preini argv
  # postdo the server class
  this:postdo
}

# preini the inet server class
# @param argv the argument vector

trans afnix:tls:inets:preini (argv) {
  # create an option class and bind it
  const this:opts (afnix:sys:Options AFNIX:TLS:U-CLS-MSG)
  # register the options
  this:opts:add-unique-option 't' AFNIX:TLS:T-LCO-MSG
  this:opts:add-unique-option 'd' AFNIX:TLS:D-LCO-MSG
  this:opts:add-unique-option 'v' AFNIX:TLS:V-LCO-MSG
  this:opts:add-unique-option 'h' AFNIX:TLS:H-LCO-MSG
  # parse the options
  try (this:opts:parse argv) {
    this:opts:usage (interp:get-error-stream)
    afnix:sys:exit 1
  }
  # check for the help option
  if (this:opts:get-unique-option 'h') {
    this:opts:usage (interp:get-output-stream)
    afnix:sys:exit 0
  }
  # check for the version option
  if (this:opts:get-unique-option 'v') {
    println (afnix:tls:get-copyright-message)
    println (afnix:tls:get-revision-message)
    afnix:sys:exit 0
  }
}

# postdo the inet server class

trans afnix:tls:inets:postdo nil {
  # create a tcp server socket
  const this:host AFNIX:TLS:SERVER-HOST
  const this:port AFNIX:TLS:SERVER-PORT
  const this:dbug (this:opts:get-unique-option 'd')
  const this:topt (this:opts:get-unique-option 't')
}

# execute the command

trans afnix:tls:inets:run nil {
  # connect the socket and get the state
  const cs (if this:topt (this:accept-tcp-socket) (this:accept-tls-socket))
}

# ----------------------------------------------------------------------------
# - process section                                                          -
# ----------------------------------------------------------------------------

# connect the socket with a tcp socket
# @param s the tcp socket

trans afnix:tls:inets:accept-tcp-socket nil {
  # create a tcp server
  const this:ssrv (afnix:net:TcpServer this:host this:port)
  # accept with a tcp socket
  const s (this:ssrv:accept)
  # create a tls connect object
  const co (afnix:tls:TlsConnect true)
  # get the connected socket state
  const cs (co:connect s s)
  # get information in debug mode
  if this:dbug (afnix:tls:write-error-plist (co:get-info))
  # here is the tls state
  eval cs
}

# connect the socket with a tls socket

trans afnix:tls:inets:accept-tls-socket nil {
  # create a tls server
  const this:ssrv (afnix:tls:TlsServer this:host this:port)
  # accept with a tls state
  this:ssrv:accept
}
