/*
 * This file was automatically generated by EvoSuite
 * Thu Sep 20 11:33:46 GMT 2018
 */

package uk.ac.sanger.artemis.components;

import org.junit.Test;
import static org.junit.Assert.*;
import static org.evosuite.runtime.EvoAssertions.*;
import java.awt.HeadlessException;
import java.awt.datatransfer.Clipboard;
import java.util.Vector;
import javax.swing.JLayeredPane;
import org.evosuite.runtime.EvoRunner;
import org.evosuite.runtime.EvoRunnerParameters;
import org.junit.runner.RunWith;
import uk.ac.sanger.artemis.EntryGroup;
import uk.ac.sanger.artemis.Feature;
import uk.ac.sanger.artemis.GotoEventSource;
import uk.ac.sanger.artemis.Selection;
import uk.ac.sanger.artemis.SimpleEntryGroup;
import uk.ac.sanger.artemis.SimpleGotoEventSource;
import uk.ac.sanger.artemis.components.BasePlotGroup;
import uk.ac.sanger.artemis.components.FeatureDisplay;
import uk.ac.sanger.artemis.io.FastaStreamSequence;
import uk.ac.sanger.artemis.io.PartialSequence;
import uk.ac.sanger.artemis.io.Range;
import uk.ac.sanger.artemis.io.RawStreamSequence;
import uk.ac.sanger.artemis.sequence.Bases;

@RunWith(EvoRunner.class) @EvoRunnerParameters(mockJVMNonDeterminism = true, useVFS = true, useVNET = true, resetStaticState = true, useJEE = true) 
public class FeatureDisplay_ESTest extends FeatureDisplay_ESTest_scaffolding {

  @Test(timeout = 4000)
  public void test0()  throws Throwable  {
      Clipboard clipboard0 = new Clipboard("($AwS7}>meOOU;yx");
      Selection selection0 = new Selection(clipboard0);
      SimpleGotoEventSource simpleGotoEventSource0 = new SimpleGotoEventSource((EntryGroup) null);
      FastaStreamSequence fastaStreamSequence0 = new FastaStreamSequence("($AwS7}>meOOU;yx");
      Bases bases0 = new Bases(fastaStreamSequence0);
      SimpleEntryGroup simpleEntryGroup0 = new SimpleEntryGroup(bases0);
      Range range0 = new Range(2, 2);
      EntryGroup entryGroup0 = simpleEntryGroup0.truncate(range0);
      FeatureDisplay featureDisplay0 = null;
      try {
        featureDisplay0 = new FeatureDisplay(entryGroup0, selection0, simpleGotoEventSource0, (BasePlotGroup) null, (-5271));
        fail("Expecting exception: HeadlessException");
      
      } catch(HeadlessException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("java.awt.dnd.DragSource", e);
      }
  }

  @Test(timeout = 4000)
  public void test1()  throws Throwable  {
      SimpleEntryGroup simpleEntryGroup0 = new SimpleEntryGroup();
      Clipboard clipboard0 = new Clipboard("*U@U");
      Selection selection0 = new Selection(clipboard0);
      FeatureDisplay featureDisplay0 = null;
      try {
        featureDisplay0 = new FeatureDisplay(simpleEntryGroup0, selection0, (GotoEventSource) null, (BasePlotGroup) null, 205);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.SimpleEntryGroup", e);
      }
  }

  @Test(timeout = 4000)
  public void test2()  throws Throwable  {
      // Undeclared exception!
      try { 
        FeatureDisplay.getParentQualifier((Feature) null);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.components.FeatureDisplay", e);
      }
  }

  @Test(timeout = 4000)
  public void test3()  throws Throwable  {
      Clipboard clipboard0 = new Clipboard("one_line_per_entry");
      Selection selection0 = new Selection(clipboard0);
      SimpleGotoEventSource simpleGotoEventSource0 = new SimpleGotoEventSource((EntryGroup) null);
      FeatureDisplay featureDisplay0 = null;
      try {
        featureDisplay0 = new FeatureDisplay((EntryGroup) null, selection0, simpleGotoEventSource0, (BasePlotGroup) null, 1);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.components.FeatureDisplay", e);
      }
  }

  @Test(timeout = 4000)
  public void test4()  throws Throwable  {
      SimpleEntryGroup simpleEntryGroup0 = new SimpleEntryGroup();
      Clipboard clipboard0 = new Clipboard("");
      Selection selection0 = new Selection(clipboard0);
      SimpleGotoEventSource simpleGotoEventSource0 = new SimpleGotoEventSource(simpleEntryGroup0);
      FeatureDisplay featureDisplay0 = null;
      try {
        featureDisplay0 = new FeatureDisplay(simpleEntryGroup0, selection0, simpleGotoEventSource0, (BasePlotGroup) null);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.SimpleEntryGroup", e);
      }
  }

  @Test(timeout = 4000)
  public void test5()  throws Throwable  {
      Integer integer0 = JLayeredPane.DEFAULT_LAYER;
      PartialSequence partialSequence0 = new PartialSequence((char[]) null, (-5246), 1751474532, (Short) null, integer0);
      Bases bases0 = new Bases(partialSequence0);
      SimpleEntryGroup simpleEntryGroup0 = new SimpleEntryGroup(bases0);
      Clipboard clipboard0 = new Clipboard("Metal");
      Selection selection0 = new Selection(clipboard0);
      SimpleGotoEventSource simpleGotoEventSource0 = new SimpleGotoEventSource(simpleEntryGroup0);
      FeatureDisplay featureDisplay0 = null;
      try {
        featureDisplay0 = new FeatureDisplay(simpleEntryGroup0, selection0, simpleGotoEventSource0, (BasePlotGroup) null, (-5246));
        fail("Expecting exception: HeadlessException");
      
      } catch(HeadlessException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("java.awt.dnd.DragSource", e);
      }
  }

  @Test(timeout = 4000)
  public void test6()  throws Throwable  {
      RawStreamSequence rawStreamSequence0 = new RawStreamSequence("onV7^`");
      Bases bases0 = new Bases(rawStreamSequence0);
      SimpleEntryGroup simpleEntryGroup0 = new SimpleEntryGroup(bases0);
      Clipboard clipboard0 = new Clipboard("onV7^`");
      Selection selection0 = new Selection(clipboard0);
      SimpleGotoEventSource simpleGotoEventSource0 = new SimpleGotoEventSource(simpleEntryGroup0);
      FeatureDisplay featureDisplay0 = null;
      try {
        featureDisplay0 = new FeatureDisplay(simpleEntryGroup0, selection0, simpleGotoEventSource0, (BasePlotGroup) null, 2);
        fail("Expecting exception: HeadlessException");
      
      } catch(HeadlessException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("java.awt.dnd.DragSource", e);
      }
  }

  @Test(timeout = 4000)
  public void test7()  throws Throwable  {
      FeatureDisplay.getAllPossibleContigKeys();
      Vector<String> vector0 = FeatureDisplay.getAllPossibleContigKeys();
      assertNotNull(vector0);
      assertEquals("[fasta_record, contig, insertion_gap, gap, scaffold, source]", vector0.toString());
  }

  @Test(timeout = 4000)
  public void test8()  throws Throwable  {
      FeatureDisplay.getContigKeys();
      Vector<String> vector0 = FeatureDisplay.getContigKeys();
      assertEquals("[fasta_record, contig, insertion_gap]", vector0.toString());
      assertNotNull(vector0);
      assertEquals(3, vector0.capacity());
  }

  @Test(timeout = 4000)
  public void test9()  throws Throwable  {
      RawStreamSequence rawStreamSequence0 = new RawStreamSequence("uk.ac.sanger.artemis.components.FeatureDisplay$6");
      Bases bases0 = new Bases(rawStreamSequence0);
      SimpleEntryGroup simpleEntryGroup0 = new SimpleEntryGroup(bases0);
      Clipboard clipboard0 = new Clipboard("uk.ac.sanger.artemis.components.FeatureDisplay$6");
      Selection selection0 = new Selection(clipboard0);
      SimpleGotoEventSource simpleGotoEventSource0 = new SimpleGotoEventSource(simpleEntryGroup0);
      FeatureDisplay featureDisplay0 = null;
      try {
        featureDisplay0 = new FeatureDisplay(simpleEntryGroup0, selection0, simpleGotoEventSource0, (BasePlotGroup) null, 1);
        fail("Expecting exception: HeadlessException");
      
      } catch(HeadlessException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("java.awt.dnd.DragSource", e);
      }
  }
}
