// This file is part of PUMA.
// Copyright (C) 1999-2003  The PUMA developer team.
//                                                                
// This program is free software;  you can redistribute it and/or 
// modify it under the terms of the GNU General Public License as 
// published by the Free Software Foundation; either version 2 of 
// the License, or (at your option) any later version.            
//                                                                
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of 
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the  
// GNU General Public License for more details.                   
//                                                                
// You should have received a copy of the GNU General Public      
// License along with this program; if not, write to the Free     
// Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, 
// MA  02111-1307  USA                                            

#include "Puma/CCLexer.h"

namespace Puma {

  void CCLexer::add_keywords (lexertl::rules &rules) {

    // add the keywords from C first
    CLexer::add_c89_keywords (rules);

    // C++ boolean constants
    rules.add ("true", TOK_BOOL_VAL, LID(Token::keyword_id));
    rules.add ("false", TOK_BOOL_VAL, LID(Token::keyword_id));

    // C++ keywords
    rules.add ("bool", TOK_BOOL, LID(Token::keyword_id));
    rules.add ("catch", TOK_CATCH, LID(Token::keyword_id));
    rules.add ("class", TOK_CLASS, LID(Token::keyword_id));
    rules.add ("const_cast", TOK_CONST_CAST, LID(Token::keyword_id));
    rules.add ("delete", TOK_DELETE, LID(Token::keyword_id));
    rules.add ("dynamic_cast", TOK_DYN_CAST, LID(Token::keyword_id));
    rules.add ("explicit", TOK_EXPLICIT, LID(Token::keyword_id));
    rules.add ("export", TOK_EXPORT, LID(Token::keyword_id));
    rules.add ("friend", TOK_FRIEND, LID(Token::keyword_id));
    rules.add ("mutable", TOK_MUTABLE, LID(Token::keyword_id));
    rules.add ("namespace", TOK_NAMESPACE, LID(Token::keyword_id));
    rules.add ("new", TOK_NEW, LID(Token::keyword_id));
    rules.add ("operator", TOK_OPERATOR, LID(Token::keyword_id));
    rules.add ("private", TOK_PRIVATE, LID(Token::keyword_id));
    rules.add ("protected", TOK_PROTECTED, LID(Token::keyword_id));
    rules.add ("public", TOK_PUBLIC, LID(Token::keyword_id));
    rules.add ("reinterpret_cast", TOK_REINT_CAST, LID(Token::keyword_id));
    rules.add ("static_cast", TOK_STAT_CAST, LID(Token::keyword_id));
    rules.add ("template", TOK_TEMPLATE, LID(Token::keyword_id));
    rules.add ("this", TOK_THIS, LID(Token::keyword_id));
    rules.add ("throw", TOK_THROW, LID(Token::keyword_id));
    rules.add ("try", TOK_TRY, LID(Token::keyword_id));
    rules.add ("typeid", TOK_TYPEID, LID(Token::keyword_id));
    rules.add ("typename", TOK_TYPENAME, LID(Token::keyword_id));
    rules.add ("using", TOK_USING, LID(Token::keyword_id));
    rules.add ("virtual", TOK_VIRTUAL, LID(Token::keyword_id));
    rules.add ("wchar_t", TOK_WCHAR_T, LID(Token::keyword_id));

    // C++ alternative representation of operators (ISO 646)
    rules.add ("and", TOK_AND_AND_ISO_646, LID(Token::keyword_id));
    rules.add ("and_eq", TOK_AND_EQ_ISO_646, LID(Token::keyword_id));
    rules.add ("bitand", TOK_AND_ISO_646, LID(Token::keyword_id));
    rules.add ("bitor", TOK_OR_ISO_646, LID(Token::keyword_id));
    rules.add ("compl", TOK_TILDE_ISO_646, LID(Token::keyword_id));
    rules.add ("not", TOK_NOT_ISO_646, LID(Token::keyword_id));
    rules.add ("not_eq", TOK_NEQ_ISO_646, LID(Token::keyword_id));
    rules.add ("or", TOK_OR_OR_ISO_646, LID(Token::keyword_id));
    rules.add ("or_eq", TOK_IOR_EQ_ISO_646, LID(Token::keyword_id));
    rules.add ("xor", TOK_ROOF_ISO_646, LID(Token::keyword_id));
    rules.add ("xor_eq", TOK_XOR_EQ_ISO_646, LID(Token::keyword_id));
  }

} // namespace Puma
