//
// BAGEL - Parallel electron correlation program.
// Filename: _eriroot_36.cc
// Copyright (C) 2013 Toru Shiozaki
//
// Author: Toru Shiozaki <shiozaki@northwestern.edu>
// Maintainer: Shiozaki group
//
// This file is part of the BAGEL package.
//
// The BAGEL package is free software; you can redistribute it and/or modify
// it under the terms of the GNU Library General Public License as published by
// the Free Software Foundation; either version 3, or (at your option)
// any later version.
//
// The BAGEL package is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU Library General Public License for more details.
//
// You should have received a copy of the GNU Library General Public License
// along with the BAGEL package; see COPYING.  If not, write to
// the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
//

#include <algorithm>
#include <cassert>
#include <src/integral/rys/erirootlist.h>

using namespace std;
using namespace bagel;

void ERIRootList::eriroot36(const double* ta, double* rr, double* ww, const int n) {

  constexpr double ax[36] = {1.701682030786294e-02,1.531993443541016e-01,4.258207394435934e-01,8.353963631572779e-01,1.382705977968209e+00,
    2.068802013658777e+00,2.895020911958181e+00,3.862997854545114e+00,4.974685277546449e+00,6.232375698446639e+00,7.638729532506021e+00,9.196808765492420e+00,
    1.091011759151622e+01,1.278265143803660e+01,1.481895621137477e+01,1.702420014340631e+01,1.940426135867573e+01,2.196583529224571e+01,2.471656749400496e+01,
    2.766521934111706e+01,3.082187703740853e+01,3.419821847086066e+01,3.780785878836020e+01,4.166680521232595e+01,4.579406689835668e+01,5.021249054596233e+01,
    5.494993461162085e+01,6.004096932514831e+01,6.552942763185496e+01,7.147240386350147e+01,7.794687302909200e+01,8.506144411451777e+01,9.297928299344353e+01,
    1.019691843478137e+02,1.125455238418826e+02,1.260322711180887e+02};
  constexpr double aw[36] = {2.565050262603475e-01,2.239528539567135e-01,1.706741212270929e-01,1.134768369502365e-01,6.577177108772145e-02,
    3.319797174509760e-02,1.457296656606504e-02,5.554499781136583e-03,1.834687915559234e-03,5.239781182130335e-04,1.290485370032876e-04,2.732528526822099e-05,
    4.957249020873694e-06,7.674727375189976e-07,1.009431516889197e-07,1.122175891149605e-08,1.048308842089190e-09,8.174958986801377e-11,5.281614965927222e-12,
    2.802669328967043e-13,1.209409465038828e-14,4.195302407355946e-16,1.154266755648343e-17,2.479396376616585e-19,4.080813569324274e-21,5.031977590646028e-23,
    4.522938813265549e-25,2.864454299009973e-27,1.224405814762339e-29,3.340299656230092e-32,5.394480517090200e-35,4.639214221043844e-38,1.813239398249085e-41,
    2.484322377845049e-45,7.288876060071841e-50,1.314020063575881e-55};
  constexpr double x[13824] = {  9.259098430971102e-04, -6.338954268099771e-06,  3.253304691002131e-08, -1.483260964424024e-10,  6.334984476976308e-13,
 -2.595050152504610e-15,  1.032379262776963e-17, -4.018269450360870e-20,  1.537393858844583e-22, -5.800297611321348e-25,  2.162640470397383e-27, -7.981107583509379e-30,
  8.323178778222218e-03, -5.677406296859716e-05,  2.892451178683120e-07, -1.302590554549916e-09,  5.460525712160138e-12, -2.178387157360828e-14,  8.359709404768460e-17,
 -3.102662257045011e-19,  1.116101466398748e-21, -3.890698322443030e-24,  1.311156602703818e-26, -4.249268140330924e-29,  2.306440138094074e-02, -1.561781060377036e-04,
  7.839800601281118e-07, -3.442945799664533e-09,  1.388243521642531e-11, -5.230407548133832e-14,  1.849092162281365e-16, -6.101572621244916e-19,  1.846973838199419e-21,
 -4.915155087434863e-24,  1.012449131534803e-26, -6.332436682864294e-30,  4.504328476546027e-02, -3.016599160457784e-04,  1.480573579098437e-06, -6.253308251264398e-09,
  2.367906352554078e-11, -8.080838459909761e-14,  2.434029296788821e-16, -6.031117794601429e-19,  9.139771564549858e-22,  1.701041415600981e-24, -2.337812396274648e-26,
  1.341981416232839e-28,  7.410123283449223e-02, -4.889846330602443e-04,  2.327739025091701e-06, -9.307906362408284e-09,  3.208586084032881e-11, -9.255264214725698e-14,
  1.943438861330616e-16, -6.948364369214969e-20, -2.087269780153964e-21,  1.442170978725799e-23, -6.510632428815181e-26,  2.229800082088034e-28,  1.100283556313435e-01,
 -7.126930224121050e-04,  3.262412218716515e-06, -1.212310141850952e-08,  3.635560858051092e-11, -7.609526714288571e-14,  1.072414248592549e-17,  9.226523597583153e-19,
 -5.845406658483607e-21,  2.349802911060790e-23, -6.300435759180510e-26,  4.773392319166548e-29,  1.525648108480698e-01, -9.662557101496591e-04,  4.213879288708259e-06,
 -1.421687175775518e-08,  3.433432685911736e-11, -2.729769569825900e-14, -2.779160469088872e-16,  1.986573311755866e-18, -7.797772024055617e-21,  1.725100037480218e-23,
  1.562269364426281e-26, -3.729806840388599e-28,  2.014024736395654e-01, -1.242258303669676e-03,  5.108428210733118e-06, -1.516910269138223e-08,  2.494339314844751e-11,
  4.852462814682631e-14, -5.878016422902138e-16,  2.557895136759530e-18, -5.612366234073393e-21, -7.884370824954403e-24,  1.370570946286120e-25, -6.763157756765903e-28,
  2.561869297234166e-01, -1.532612517144647e-03,  5.874229874339322e-06, -1.467566362828868e-08,  8.475127677014977e-12,  1.369889144161652e-13, -8.052093598215983e-16,
  2.155529176819403e-18,  1.132073552331227e-21, -4.119499885952836e-23,  2.061174375844006e-25, -4.259881571318825e-28,  3.165197854429246e-01, -1.828787678951149e-03,
  6.446137300436540e-06, -1.258988157107851e-08, -1.335876653125667e-11,  2.176016020565101e-13, -8.254142369199617e-16,  6.460716484700202e-19,  1.012571312729436e-20,
 -6.134055844672090e-23,  1.337428001160862e-25,  4.150424355188303e-28,  3.819612870156809e-01, -2.122056380791553e-03,  6.770093407810826e-06, -8.946378063990141e-09,
 -3.764289442247692e-11,  2.686326871781982e-13, -5.930901798818608e-16, -1.618185490120162e-18,  1.703482470399602e-20, -4.920525973517771e-23, -7.919819574325975e-26,
  1.276581845991246e-27,  4.520332395659162e-01, -2.403747553805321e-03,  6.806858750422625e-06, -3.964185819972735e-09, -6.070737309375401e-11,  2.727191873441318e-13,
 -1.295182585088694e-16, -3.869982890790406e-18,  1.756536601833395e-20, -2.270563290104935e-24, -3.137365158668098e-25,  1.345066120844584e-27,  5.262222147335726e-01,
 -2.665499942224516e-03,  6.534810070434240e-06,  1.971605424178255e-09, -7.873673361072090e-11,  2.217638900741942e-13,  4.643220205558278e-16, -5.198974424140944e-18,
  9.881540048428827e-21,  5.960853106735231e-23, -3.981444782017044e-25,  2.839499200086838e-28,  6.039830336601135e-01, -2.899508804360967e-03,  5.951616373836906e-06,
  8.347961492280579e-09, -8.843371845309423e-11,  1.198142863254146e-13,  1.031896529243978e-15, -4.923564299013107e-18, -3.955395177989380e-21,  1.026216147977579e-22,
 -2.317468056370440e-25, -1.317434011518082e-27,  6.847425099703215e-01, -3.098758715406370e-03,  5.074668519893743e-06,  1.457774631507114e-08, -8.762025002066983e-11,
 -1.692912644224443e-14,  1.406275929613407e-15, -2.906975566027110e-18, -1.846148651664403e-20,  9.814246617674907e-23,  1.229129853365052e-25, -2.259098138955725e-27,
  7.679034350078382e-01, -3.257235584656063e-03,  3.940217072865140e-06,  2.006336421460939e-08, -7.566578951468625e-11, -1.631241607222791e-13,  1.462423177586482e-15,
  3.262478505628380e-19, -2.708145054441684e-20,  4.135140297524634e-23,  4.581304041673414e-25, -1.661684788277881e-27,  8.528487850552942e-01, -3.370111435083201e-03,
  2.601256696750624e-06,  2.426301355654361e-08, -5.366126975474315e-11, -2.897004498283503e-13,  1.159479027482862e-15,  3.739955051138258e-18, -2.534572583027161e-20,
 -4.285963509162780e-23,  5.509356170701841e-25,  2.337659588002946e-28,  9.389461276017864e-01, -3.433896124508325e-03,  1.124278479085875e-06,  2.675191202128531e-08,
 -2.430029589668339e-11, -3.704224644485248e-13,  5.584276351558833e-16,  6.157384499835234e-18, -1.323635676038956e-20, -1.117680788286284e-22,  3.192562406171433e-25,
  2.126845325758127e-27,  1.025552200945050e+00, -3.446551008147081e-03, -4.149111621372128e-07,  2.727128477858120e-08,  8.519068285909124e-12, -3.880139692867082e-13,
 -1.918319321888159e-16,  6.710411237645761e-18,  4.524545909446630e-21, -1.284707243354336e-22, -1.097562158577833e-25,  2.618551788733832e-27,  1.112017638576682e+00,
 -3.407560539131984e-03, -1.936040187752230e-06,  2.575919574858554e-08,  4.030803232717885e-11, -3.383172009518886e-13, -8.966475550376229e-16,  5.183638714843924e-18,
  2.052433109359028e-20, -8.335978303783087e-23, -4.757010082069101e-25,  1.320637364598360e-27,  1.197691806950002e+00, -3.317958957185408e-03, -3.359574239418896e-06,
  2.235932241204618e-08,  6.671217860263243e-11, -2.314149722170421e-13, -1.373098600089373e-15,  2.107675347108673e-18,  2.809225965689983e-20, -1.510899389784129e-25,
 -5.570405299017884e-25, -8.148666138023032e-28,  1.281927722434936e+00, -3.180310499722874e-03, -4.611928177868586e-06,  1.740630806014405e-08,  8.422154432963202e-11,
 -8.938621810850533e-14, -1.504457684325324e-15, -1.441910545226625e-18,  2.440916560393916e-20,  7.757105428795298e-23, -3.182655340957495e-25, -2.241845002763264e-27,
  1.364087010594926e+00, -2.998642951406397e-03, -5.630332859455276e-06,  1.138908377038313e-08,  9.073970506996849e-11,  5.878999292789472e-14, -1.273967668865092e-15,
 -4.259922150208417e-18,  1.172658233976363e-20,  1.112528971591989e-22,  7.273656778819197e-26, -2.027672999559667e-27,  1.443544868457017e+00, -2.778335788477449e-03,
 -6.367020566811736e-06,  4.896209259685783e-09,  8.590947367470645e-11,  1.839383077282432e-13, -7.669910569387747e-16, -5.470121376115486e-18, -3.899289958094481e-21,
  8.856441625557682e-23,  3.669451319619050e-25, -5.217941907383758e-28,  1.519694988273321e+00, -2.525965628643295e-03, -6.792432711853307e-06, -1.450489446606376e-09,
  7.113582994907410e-11,  2.633362899805223e-13, -1.411332783747571e-16, -4.838331636019590e-18, -1.566094968406680e-20,  2.827238253065674e-23,  4.041494193440386e-25,
  1.033504573890502e-27,  1.591954399479101e+00, -2.249113117291678e-03, -6.897215437750722e-06, -7.066192901800766e-09,  4.930152899116093e-11,  2.856544360759167e-13,
  4.253063044075065e-16, -2.815522968214183e-18, -1.923118844878116e-20, -3.329994003443194e-23,  2.077926317830515e-25,  1.556042300547819e-27,  1.659768184230019e+00,
 -1.956136715258416e-03, -6.692848900484506e-06, -1.146888613180020e-08,  2.422743651881184e-11,  2.529730453086068e-13,  7.890081747564941e-16, -3.042803681525332e-19,
 -1.452845446604093e-20, -6.477401032732009e-23, -5.599901162073403e-26,  9.191362473123012e-28,  1.722614021139550e+00, -1.655920050589648e-03, -6.210849145911860e-06,
 -1.433272421298276e-08, -2.269748156052646e-14,  1.794246515303803e-13,  8.828105197275748e-16,  1.739076493076219e-18, -5.219465424116118e-21, -5.672947574571899e-23,
 -2.119354351991981e-25, -1.283190254929933e-28,  1.780006511731312e+00, -1.357600506686337e-03, -5.500581254153075e-06, -1.552243114384326e-08, -1.986387915240969e-11,
  8.689528985321511e-14,  7.292173446694548e-16,  2.688073725729957e-18,  3.592956941996709e-21, -2.337681923740186e-23, -1.945565822524714e-25, -7.245968897217802e-28,
  1.831501244786099e+00, -1.070287495790170e-03, -4.625821669704544e-06, -1.510446107542073e-08, -3.280357444973069e-11, -1.013033776292342e-15,  4.230778900419985e-16,
  2.452096044311583e-18,  8.110638670536572e-21,  1.027952797591832e-23, -6.872633805599320e-26, -5.936401437476647e-28,  1.876698555411323e+00, -8.027793697517914e-04,
 -3.660298993375745e-06, -1.333348796613954e-08, -3.783358738494455e-11, -6.511257762656072e-14,  9.123319313656936e-17,  1.430012238058202e-18,  7.505136888960599e-21,
  2.568137265011053e-23,  4.722503091181305e-26, -1.045381968789339e-28,  1.915246938914754e+00, -5.632881152536955e-04, -2.682518917275180e-06, -1.061585127313162e-08,
 -3.552878339735660e-11, -9.521175510965729e-14, -1.551676828900025e-16,  2.554424611495439e-19,  3.734870720063116e-21,  2.056992785386090e-23,  8.029867943090670e-26,
  2.232045426683732e-28,  1.946846087030300e+00, -3.591808312060720e-04, -1.770234216565777e-06, -7.454483409832865e-09, -2.783798403525566e-11, -9.196197312909934e-14,
 -2.579900962440165e-16, -5.294426186736100e-19, -1.393950273621736e-22,  6.154999837607128e-24,  4.320492600410924e-26,  2.056121054825088e-28,  1.971249540312517e+00,
 -1.967463842952074e-04, -9.949495710469251e-07, -4.382201145189577e-09, -1.761215597028271e-11, -6.556146720516924e-14, -2.259779492271396e-16, -7.109467123203479e-19,
 -1.962522923409252e-21, -4.221844401954074e-24, -3.230266771258150e-27,  3.386342511836959e-29,  1.988267115686422e+00, -8.099375752040133e-05, -4.168463448314212e-07,
 -1.891724338052444e-09, -7.966110397380705e-12, -3.179394126325623e-14, -1.214357533379208e-16, -4.455565043799598e-19, -1.570194871554712e-21, -5.294560579169425e-24,
 -1.693229230862398e-26, -5.046113444299438e-29,  1.997769559703380e+00, -1.547165880732497e-05, -8.040172208209687e-08, -3.708504155054554e-10, -1.600653246239909e-12,
 -6.617495355627976e-15, -2.652830263175204e-17, -1.038588229394424e-19, -3.988583268491969e-22, -1.506857834971297e-24, -5.610569499211285e-27, -2.061216377958750e-29,
  9.010635201627725e-04, -6.085641092743538e-06,  3.081227945660775e-08, -1.385922398570008e-10,  5.839868138544199e-13, -2.360243306939616e-15,  9.264528476707427e-18,
 -3.558109870624160e-20,  1.343343979589514e-22, -5.001540958736240e-25,  1.840440226915435e-27, -6.703810154074464e-30,  8.100613505413183e-03, -5.452117352690074e-05,
  2.741242095415656e-07, -1.218601434744477e-09,  5.044228220862177e-12, -1.987788083523620e-14,  7.538929773740876e-17, -2.766943487426024e-19,  9.850424269360124e-22,
 -3.401844653632245e-24,  1.137367694656163e-26, -3.664721676493460e-29,  2.245197620184772e-02, -1.500678288966853e-04,  7.439636690929516e-07, -3.228960057267723e-09,
  1.287938191459615e-11, -4.806474919260175e-14,  1.686262101026404e-16, -5.538076814725344e-19,  1.677240385924825e-21, -4.516863226537372e-24,  9.765231156087427e-27,
 -9.754112159739103e-30,  4.385986796049916e-02, -2.901091662986693e-04,  1.407754749238306e-06, -5.887060860472243e-09,  2.211996197707882e-11, -7.516600449536948e-14,
  2.269332454472454e-16, -5.730541207358113e-19,  9.597327368069048e-22,  8.760975016369392e-25, -1.805598033245405e-26,  1.085226462760580e-28,  7.218184286333365e-02,
 -4.708009120481071e-04,  2.219064125426998e-06, -8.809088378581844e-09,  3.028125590602690e-11, -8.791882073104656e-14,  1.915378230477185e-16, -1.284532478009146e-19,
 -1.612668039934332e-21,  1.200625132123095e-23, -5.584884810677717e-26,  1.979690817491445e-28,  1.072288745897114e-01, -6.871658603367805e-04,  3.120374985646692e-06,
 -1.155356452647041e-08,  3.483826362235474e-11, -7.554824916042721e-14,  3.406339637421031e-17,  7.486524566122510e-19, -5.044254854418886e-21,  2.102844877331802e-23,
 -6.028308715537980e-26,  7.408405848634138e-29,  1.487661427206600e-01, -9.332177905026031e-04,  4.046553783066793e-06, -1.367223414957495e-08,  3.372603536571952e-11,
 -3.332781154881133e-14, -2.256913512621141e-16,  1.747071396921457e-18, -7.169184525036263e-21,  1.757580835315462e-23,  1.283609767706681e-27, -2.815293328918501e-28,
  1.965140320938328e-01, -1.202112141413079e-03,  4.928823153209647e-06, -1.476298697080011e-08,  2.577850875978172e-11,  3.525632132987069e-14, -5.187303752081585e-16,
  2.374759328560381e-18, -5.804475675787475e-21, -2.973219088110372e-24,  1.090987960082565e-25, -5.942442213767117e-28,  2.501493555028978e-01, -1.486320603265827e-03,
  5.699022590745761e-06, -1.451917277486697e-08,  1.102656000463430e-11,  1.183909268153262e-13, -7.445591937285681e-16,  2.169580804982915e-18, -2.072037796196587e-22,
 -3.334058233921505e-23,  1.862828179263472e-25, -4.701328700895141e-28,  3.093068113904663e-01, -1.777826204652918e-03,  6.293916428839316e-06, -1.276987513583615e-08,
 -9.203187908666048e-12,  1.980433523191967e-13, -8.031123368715982e-16,  9.358267561796587e-19,  8.017579513587955e-21, -5.568757701244538e-23,  1.474453098130431e-25,
  2.144382891428726e-28,  3.735806891393578e-01, -2.068334895318451e-03,  6.659297906068414e-06, -9.506470852459098e-09, -3.241594103664122e-11,  2.539147544891450e-13,
 -6.310378125396894e-16, -1.101918701065555e-18,  1.521936662570742e-20, -5.131386089791975e-23, -2.782176340659632e-26,  1.058490539637247e-27,  4.425268350458777e-01,
 -2.349499063869170e-03,  6.753639962425573e-06, -4.892073312606184e-09, -5.529252321517516e-11,  2.683737920004225e-13, -2.300373804281723e-16, -3.311505146720272e-18,
  1.727201735731966e-20, -1.363522492463421e-23, -2.545842944697710e-25,  1.333274120724403e-27,  5.156648919819817e-01, -2.613147900220404e-03,  6.551058800926470e-06,
  7.478565576701754e-10, -7.420161711593873e-11,  2.311983684454571e-13,  3.234785230869337e-16, -4.851474315148625e-18,  1.174463211873526e-20,  4.402355753524644e-23,
 -3.789941754112932e-25,  5.736440879505236e-28,  5.924808250420120e-01, -2.851519034563722e-03,  6.043385582335589e-06,  6.953490789330432e-09, -8.580100387776699e-11,
  1.429145296836068e-13,  8.928067241032058e-16, -4.992922011249533e-18, -4.407269058158771e-22,  9.231506513519177e-23, -2.805620858687988e-25, -9.033479282936110e-28,
  6.724297440484669e-01, -3.057485482092531e-03,  5.241184620143066e-06,  1.317491860498798e-08, -8.762825039366153e-11,  1.578128911646363e-14,  1.317146667716585e-15,
 -3.440455757929747e-18, -1.486337389492952e-20,  1.011208037230874e-22,  2.739733325051131e-26, -2.068165623008380e-27,  7.549390315911134e-01, -3.224771623236334e-03,
  4.173612047262551e-06,  1.882852007937955e-08, -7.857705104870982e-11, -1.280128133833435e-13,  1.459673783291233e-15, -5.131514959440509e-19, -2.528133148858765e-20,
  5.813201775239940e-23,  3.790771785183748e-25, -1.911962047371639e-27,  8.394117822372338e-01, -3.348151783075424e-03,  2.887075166152756e-06,  2.335962706786503e-08,
 -5.916900072260380e-11, -2.607092517208028e-13,  1.252641318874418e-15,  2.908468150413107e-18, -2.649101841085725e-20, -2.078056468936780e-23,  5.490219616087042e-25,
 -3.143716211080582e-28,  9.252305546374019e-01, -3.423624972602884e-03,  1.442726632897880e-06,  2.630462559274587e-08, -3.156102040778878e-11, -3.550028080086431e-13,
  7.243182228613691e-16,  5.672083487465803e-18, -1.700864545375799e-20, -9.724344528927391e-23,  4.039089456049640e-25,  1.706289551066343e-27,  1.011761433443593e+00,
 -3.448559549676501e-03, -8.709463861676000e-08,  2.734532160971266e-08,  7.280347771940284e-13, -3.903511748529500e-13, -2.613430812141856e-18,  6.780577476821054e-18,
 -1.513859884239693e-22, -1.305288251687998e-22,  7.285103119977266e-27,  2.678062303514239e-27,  1.098358392267060e+00, -3.421801977041525e-03, -1.623287206486667e-06,
  2.634887493195089e-08,  3.333862071089230e-11, -3.580237248757812e-13, -7.427873928258598e-16,  5.788852516111084e-18,  1.719627198044326e-20, -1.010734345269335e-22,
 -4.063257897208346e-25,  1.822024709936301e-27,  1.184367942381131e+00, -3.343744521189015e-03, -3.085016475957526e-06,  2.338792224461191e-08,  6.175964010373066e-11,
 -2.635597384353247e-13, -1.301530197076731e-15,  3.002179200709578e-18,  2.767849424317343e-20, -2.299677554980144e-23, -5.813289241760452e-25, -2.778163898539452e-28,
  1.269134044610423e+00, -3.216347662773284e-03, -4.395032596238423e-06,  1.873757705481993e-08,  8.206994664300009e-11, -1.258869331962352e-13, -1.533494684443239e-15,
 -6.187843391227209e-19,  2.694910456675052e-20,  6.290292400976894e-23, -4.140314721011298e-25, -2.089417897007050e-27,  1.352003253981940e+00, -3.043114178691624e-03,
 -5.484919531236917e-06,  1.284862445251244e-08,  9.160032609382524e-11,  2.682955471757527e-14, -1.387386915518914e-15, -3.820208643392326e-18,  1.576167658378898e-20,
  1.122824192954019e-22, -2.350270216833611e-26, -2.335053259976647e-27,  1.432330058435290e+00, -2.829013294761794e-03, -6.299900729524989e-06,  6.299138520864662e-09,
  8.939169573664089e-11,  1.636815077760565e-13, -9.214021289533156e-16, -5.541105546394661e-18, -4.535097999400334e-22,  1.026499370085945e-22,  3.339592077023918e-25,
 -9.843989003560907e-28,  1.509482364440255e+00, -2.580354966043105e-03, -6.802836468011838e-06, -2.704134654190044e-10,  7.635742215786938e-11,  2.582678360136485e-13,
 -2.834469175122670e-16, -5.319991761784084e-18, -1.434175392472398e-20,  4.528535386354794e-23,  4.447830140123734e-25,  7.977704839280662e-28,  1.582847074040878e+00,
 -2.304616170377348e-03, -6.977086553646452e-06, -6.231137197228075e-09,  5.510994174639447e-11,  2.948451847103304e-13,  3.376880938627162e-16, -3.448361321341051e-18,
 -2.026351974265784e-20, -2.358057360682895e-23,  2.790322379143261e-25,  1.673320349728874e-27,  1.651835689969923e+00, -2.010223031948696e-03, -6.827979415430578e-06,
 -1.103974646323155e-08,  2.947528857833365e-11,  2.717523003569867e-13,  7.736264197269139e-16, -8.068490885018504e-19, -1.689015019319150e-20, -6.612336639851949e-23,
 -9.403652358662325e-27,  1.202519484675185e-27,  1.715889878424188e+00, -1.706294540407509e-03, -6.382721821798694e-06, -1.430321205181736e-08,  3.781508536424896e-12,
  2.011756143519869e-13,  9.288476061335069e-16,  1.537733088519475e-18, -7.415242542231537e-21, -6.527095016029880e-23, -2.138348636045579e-25,  5.074238829691568e-29,
  1.774486913254080e+00, -1.402355498002863e-03, -5.688696858710420e-06, -1.582537325078063e-08, -1.794480099659044e-11,  1.053118581681133e-13,  8.059554657328480e-16,
  2.788018353116865e-18,  2.603536509381867e-21, -3.180633488623824e-23, -2.271125460260235e-25, -7.509841904332320e-28,  1.827144921123238e+00, -1.108028003689119e-03,
 -4.810223162214776e-06, -1.562890478266941e-08, -3.271658212846083e-11,  9.994389589290434e-15,  4.954216889624199e-16,  2.716973662215602e-18,  8.424592655885873e-21,
  6.971523787447104e-24, -9.760141031283248e-26, -7.209568874591117e-28,  1.873427845145812e+00, -8.327121579855216e-04, -3.823975423893627e-06, -1.394911029559805e-08,
 -3.911055577560437e-11, -6.241449125089890e-14,  1.347773655941738e-16,  1.685323384190284e-18,  8.462362582670516e-21,  2.745642866268888e-23,  4.094707147369093e-26,
 -1.843300850449634e-28,  1.912950045510869e+00, -5.852676373054484e-04, -2.813383383696521e-06, -1.119974534319320e-08, -3.746960661684891e-11, -9.883573865892371e-14,
 -1.462262155352007e-16,  3.874459217384590e-19,  4.535600551515784e-21,  2.398157270410826e-23,  9.035496553215875e-26,  2.329661989356196e-28,  1.945380462540410e+00,
 -3.737082340668700e-04, -1.862422262391315e-06, -7.914946535802666e-09, -2.974034358811707e-11, -9.833191509582152e-14, -2.728411438670677e-16, -5.300060638061448e-19,
  1.155764689751396e-22,  8.075603979018157e-24,  5.312001360617973e-26,  2.460884824384392e-28,  1.970446295638006e+00, -2.049212186270182e-04, -1.049270995665994e-06,
 -4.674787048405970e-09, -1.897926972391272e-11, -7.123105381519762e-14, -2.467866757739727e-16, -7.762010051414147e-19, -2.116438224035575e-21, -4.317047477505682e-24,
 -1.418521055976271e-27,  4.916979439323814e-29,  1.987936324219750e+00, -8.442154720638338e-05, -4.403332922727924e-07, -2.024431833385761e-09, -8.632174434132618e-12,
 -3.486396505487688e-14, -1.346443946022734e-16, -4.989875836777076e-19, -1.773543151168254e-21, -6.018218863598887e-24, -1.930047470831838e-26, -5.730641050662357e-29,
  1.997706357827764e+00, -1.613311906996615e-05, -8.501007214775880e-08, -3.975552749504289e-10, -1.739613170145691e-12, -7.290565172811397e-15, -2.962351271933971e-17,
 -1.175353924156540e-19, -4.573733896833224e-22, -1.750527621568477e-24, -6.601646802388237e-27, -2.455871263971798e-29,  8.772036388707458e-04, -5.845639950918121e-06,
  2.920371578028663e-08, -1.296143390202971e-10,  5.389271782647099e-13, -2.149380262548085e-15,  8.325830743172947e-18, -3.155683567046816e-20,  1.175858781695760e-22,
 -4.321094514099233e-25,  1.569509792705958e-27, -5.643542005391796e-30,  7.886824082886481e-03, -5.238533027786297e-05,  2.599724302306675e-07, -1.140978507966323e-09,
  4.664154432299828e-12, -1.815805517340460e-14,  6.806535239441357e-17, -2.470477098491585e-19,  8.703905380710135e-22, -2.977611929063281e-24,  9.874567262305261e-27,
 -3.161915463522444e-29,  2.186336775513120e-02, -1.442676780903659e-04,  7.064215444650622e-07, -3.030365582959496e-09,  1.195733190177977e-11, -4.419788220514957e-14,
  1.538470858474061e-16, -5.026631984058954e-19,  1.521554220794265e-21, -4.135548756631321e-24,  9.284913618445785e-27, -1.189839706174997e-29,  4.272151630048873e-02,
 -2.791238029529862e-04,  1.339184869510237e-06, -5.544877501318961e-09,  2.066982422105838e-11, -6.990865801283313e-14,  2.113214901078104e-16, -5.419684903429754e-19,
  9.793626656793833e-22,  2.428230311499883e-25, -1.376194184856646e-26,  8.733983340289823e-29,  7.033348620428043e-02, -4.534631308056357e-04,  2.116204844502057e-06,
 -8.338406852903162e-09,  2.856852873938234e-11, -8.337052030160878e-14,  1.872806573198875e-16, -1.735575665609797e-19, -1.218619759681480e-21,  9.939407313181537e-24,
 -4.766645451125999e-26,  1.742092236331319e-28,  1.045292723041302e-01, -6.627480700518438e-04,  2.985026985379334e-06, -1.100818880190113e-08,  3.333708043923530e-11,
 -7.449673743163153e-14,  5.287636558016511e-17,  5.988900172379785e-19, -4.329798137560167e-21,  1.868776989559270e-23, -5.663197604865640e-26,  9.044514691685967e-29,
  1.450969902110818e-01, -9.014925064852542e-04,  3.885701767329520e-06, -1.313822816188587e-08,  3.300914407101348e-11, -3.818272733855732e-14, -1.798900892221580e-16,
  1.527768257067112e-18, -6.538301911049793e-21,  1.740276557947089e-23, -9.384935265882152e-27, -2.058755227022395e-28,  1.917833326758223e-01, -1.163383118501990e-03,
  4.754163185316983e-06, -1.434554401452807e-08,  2.636441706242162e-11,  2.358365244666092e-14, -4.548478944615276e-16,  2.188096082617198e-18, -5.839041319423448e-21,
  8.919863427392573e-25,  8.475640420756002e-26, -5.126125461134236e-28,  2.442941584577890e-01, -1.441422169859990e-03,  5.525926116574159e-06, -1.432475554446787e-08,
  1.322059654926461e-11,  1.012486774320693e-13, -6.840741811355032e-16,  2.145143337784965e-18, -1.278386948228497e-21, -2.630926188215857e-23,  1.651745970633612e-25,
 -4.851609726977194e-28,  3.022952355785460e-01, -1.728090036227639e-03,  6.139921762983453e-06, -1.288647705714877e-08, -5.432803246640034e-12,  1.791102742964048e-13,
 -7.736104860742665e-16,  1.161466928974050e-18,  6.120798929600833e-21, -4.965128746037992e-23,  1.531955935326454e-25,  5.326233112739273e-29,  3.654131638871269e-01,
 -2.015525259250645e-03,  6.542273217406169e-06, -9.985331943707255e-09, -2.749131701812271e-11,  2.384529231361550e-13, -6.553519929858264e-16, -6.445832557557896e-19,
  1.336268021056215e-20, -5.155884285550918e-23,  1.401491102517971e-26,  8.447575176247764e-28,  4.332365045350798e-01, -2.295719397427772e-03,  6.689803072022505e-06,
 -5.734144254429700e-09, -4.998744623217649e-11,  2.618021637513613e-13, -3.151088066499319e-16, -2.768506026443585e-18,  1.661184522501240e-20, -2.266154592583538e-23,
 -1.972209353947414e-25,  1.266355910384946e-27,  5.053171461320902e-01, -2.560723361602184e-03,  6.553063557353467e-06, -4.020011654789132e-10, -6.951079272415968e-11,
  2.373755873140675e-13,  1.931165397274339e-16, -4.453160805555178e-18,  1.306331640492391e-20,  2.943660220170703e-23, -3.488083984787896e-25,  7.858653501331758e-28,
  5.811719388864300e-01, -2.802861295662228e-03,  6.118688540379837e-06,  5.604657749265858e-09, -8.273975911075151e-11,  1.626656671347932e-13,  7.532912136898090e-16,
 -4.956088397624029e-18,  2.672106661080553e-21,  8.041529122398999e-23, -3.115693183076255e-25, -5.113202897921810e-28,  6.602846287640644e-01, -3.014947408942416e-03,
  5.390887218916710e-06,  1.177707548722956e-08, -8.700457584409266e-11,  4.618643696282323e-14,  1.214702878866023e-15, -3.857800314516738e-18, -1.122456810301570e-20,
  1.004703057461461e-22, -5.798551209657809e-26, -1.802661879091352e-27,  7.421081234438652e-01, -3.190500513096273e-03,  4.391932551268358e-06,  1.755270212292652e-08,
 -8.078861332006350e-11, -9.324244458087270e-14,  1.434314011810458e-15, -1.285911125456762e-18, -2.293636250847611e-20,  7.156540505106283e-23,  2.916371333019103e-25,
 -2.043183130366921e-27,  8.260671204094175e-01, -3.323950399150386e-03,  3.161543761438600e-06,  2.237286897815374e-08, -6.407645288295137e-11, -2.297649468406027e-13,
  1.322128003088417e-15,  2.052988257828902e-18, -2.684853442194129e-20,  7.532320768114727e-25,  5.240619137850960e-25, -8.090655907214485e-28,  9.115611247018556e-01,
 -3.410829655313194e-03,  1.755121184508970e-06,  2.574384617931944e-08, -3.847470707591040e-11, -3.357779736115067e-13,  8.750134465350106e-16,  5.075051273111553e-18,
 -2.020177904559696e-20, -7.972674027883190e-23,  4.683239339433979e-25,  1.212222188415078e-27,  9.979678794727761e-01, -3.447944126358392e-03,  2.408616454553136e-07,
  2.729457505596615e-08, -7.064258821890032e-12, -3.881405047753558e-13,  1.864702286166071e-16,  6.700834600190032e-18, -4.816890599617215e-21, -1.278948538909496e-22,
  1.238093582299460e-25,  2.595219653269686e-27,  1.084647226355047e+00, -3.433515010802813e-03, -1.304139479730801e-06,  2.682409665705483e-08,  2.601331305791547e-11,
 -3.738468563641724e-13, -5.735640186949949e-16,  6.277942838192835e-18,  1.328559498274664e-20, -1.155925541785958e-22, -3.165703237889210e-25,  2.241670914510202e-27,
  1.170945404688670e+00, -3.367285645595023e-03, -2.798611848260352e-06,  2.433224010276771e-08,  5.618340045400644e-11, -2.936885713394565e-13, -1.205225757496807e-15,
  3.870143278080837e-18,  2.643065885170366e-20, -4.632343782895891e-23, -5.807013978308074e-25,  3.123978692282517e-28,  1.256199788739836e+00, -3.250586401181015e-03,
 -4.162392531379535e-06,  2.002855050274198e-08,  7.918327792561330e-11, -1.627992954472584e-13, -1.538430825574460e-15,  2.764472087089865e-19,  2.889401078634656e-20,
  4.457732599856994e-23, -5.001694951704035e-25, -1.804043420013481e-27,  1.339744050263403e+00, -3.086351856828348e-03, -5.321930656116656e-06,  1.431667795096459e-08,
  9.179559045889789e-11, -7.690603720584025e-15, -1.486686333633310e-15, -3.251547186588568e-18,  1.976148989153807e-20,  1.092151405844792e-22, -1.314745056974118e-25,
 -2.556101833440346e-27,  1.420913720223375e+00, -2.879085586679840e-03, -6.215625470800390e-06,  7.754340449306761e-09,  9.243162849677528e-11,  1.397079097934574e-13,
 -1.076182866819688e-15, -5.494006617693771e-18,  3.470595107189043e-21,  1.149984178954710e-22,  2.798752733317529e-25, -1.476805644454501e-27,  1.499052108476654e+00,
 -2.634769478504127e-03, -6.798581998162822e-06,  9.922069692596051e-10,  8.144242470251785e-11,  2.496273637181812e-13, -4.385618556246210e-16, -5.749346443487854e-18,
 -1.238359299983557e-20,  6.368778855672325e-23,  4.729107406805602e-25,  4.643959347697533e-28,  1.573516524164570e+00, -2.360716516630628e-03, -7.046373714281666e-06,
 -5.301796710381803e-09,  6.107968797850245e-11,  3.017170728943901e-13,  2.319445008124023e-16, -4.108076862001342e-18, -2.089357224813235e-20, -1.092568723839038e-23,
  3.541034189904418e-25,  1.726705076283054e-27,  1.643684723022057e+00, -2.065368338248919e-03, -6.957444144663982e-06, -1.052366147725179e-08,  3.509385001472178e-11,
  2.899849588892383e-13,  7.431101057812862e-16, -1.385384836741259e-18, -1.926381539488589e-20, -6.535379939405755e-23,  5.006744228954349e-26,  1.502341950553018e-27,
  1.708961491534547e+00, -1.758041526863312e-03, -6.553860603466867e-06, -1.420929447123042e-08,  8.031283823746286e-12,  2.239555916846143e-13,  9.682171319962432e-16,
  1.261206628474971e-18, -9.917835878134488e-21, -7.371474537095621e-23, -2.066432268683943e-25,  2.858262663249841e-28,  1.768785262712966e+00, -1.448629404739964e-03,
 -5.880251055534350e-06, -1.609456250635910e-08, -1.563876736404967e-11,  1.255998556065275e-13,  8.850013527993103e-16,  2.851193007238937e-18,  1.287008014550938e-21,
 -4.155296552380087e-23, -2.601864751029926e-25, -7.463304842108828e-28,  1.822634645203430e+00, -1.147268855807409e-03, -5.000902050533597e-06, -1.615009854815560e-08,
 -3.239147271538459e-11,  2.282807998366013e-14,  5.753031558372138e-16,  2.989758308491556e-18,  8.597285764459063e-21,  2.392935573407733e-24, -1.323380689339685e-25,
 -8.595753400873447e-28,  1.870034737632711e+00, -8.639842503882910e-04, -3.995159939870246e-06, -1.458467315031297e-08, -4.032251465936716e-11, -5.858204172748088e-14,
  1.859083066505206e-16,  1.972232464930813e-18,  9.478064874475275e-21,  2.890359399473745e-23,  3.066106528574726e-26, -2.873887570041953e-28,  1.910563095058929e+00,
 -6.083226353340981e-04, -2.951443248485754e-06, -1.181525945221513e-08, -3.948044871552966e-11, -1.021977621104419e-13, -1.332109026609435e-16,  5.471162106449598e-19,
  5.466476909286924e-21,  2.780218102061370e-23,  1.006950440091964e-25,  2.356007260923878e-28,  1.943855217691716e+00, -3.889957707742034e-04, -1.960322759110972e-06,
 -8.406885959029854e-09, -3.177366246337346e-11, -1.050574828342277e-13, -2.875827799703580e-16, -5.212240148237504e-19,  4.472746035533829e-22,  1.043028569173911e-23,
  6.495573158848278e-26,  2.930063026354036e-28,  1.969609459710286e+00, -2.135450491312650e-04, -1.107238525588810e-06, -4.990181671386825e-09, -2.046492018872798e-11,
 -7.742253449523514e-14, -2.694918840936321e-16, -8.464200445532986e-19, -2.272302419849051e-21, -4.325016437607803e-24,  1.165438498122036e-27,  6.914823619534368e-29,
  1.987591435455340e+00, -8.804378838201036e-05, -4.654787552370759e-07, -2.168305303389689e-09, -9.362934107057797e-12, -3.826970912710245e-14, -1.494442563766931e-16,
 -5.593615198021392e-19, -2.004722818861674e-21, -6.842849500237111e-24, -2.198642304329026e-26, -6.490822253070619e-29,  1.997640434293184e+00, -1.683276681343628e-05,
 -8.995267834485303e-08, -4.265953546168530e-10, -1.892809488224727e-12, -8.042735337542695e-15, -3.312925682350710e-17, -1.332328019712899e-19, -5.254180563385429e-22,
 -2.037542674039036e-24, -7.783793193767846e-27, -2.932417582726700e-29,  8.542786905575417e-04, -5.618088322738936e-06,  2.769869649565741e-08, -1.213248410781078e-10,
  4.978683394786781e-13, -1.959752183173505e-15,  7.492662895411462e-18, -2.803133522544059e-20,  1.031026335906293e-22, -3.740239571332238e-25,  1.341186578587958e-27,
 -4.761349746902716e-30,  7.681357361651100e-03, -5.035907618943944e-05,  2.467167438595963e-07, -1.069170865170048e-09,  4.316784564464209e-12, -1.660444380198255e-14,
  6.152236477291054e-17, -2.208367267615717e-19,  7.699830142575482e-22, -2.609133910409858e-24,  8.580812919139136e-27, -2.729549886992767e-29,  2.129737398435312e-02,
 -1.387585767891005e-04,  6.711765277391723e-07, -2.845924005188104e-09,  1.110918537844400e-11, -4.066908006744108e-14,  1.404322959748084e-16, -4.562849098114387e-19,
  1.379229564118168e-21, -3.775035815309978e-24,  8.731990819918007e-27, -1.310282657156920e-29,  4.162603443523870e-02, -2.686709604209805e-04,  1.274585381583162e-06,
 -5.225075231600005e-09,  1.932115735724532e-11, -6.501549782869429e-14,  1.965857254780981e-16, -5.105880710207726e-19,  9.790724514266653e-22, -2.361704719128428e-25,
 -1.031443292384104e-26,  6.993417021423842e-29,  6.855287004487791e-02, -4.369260900838013e-04,  2.018832302859858e-06, -7.894407189782804e-09,  2.694565064524705e-11,
 -7.893818856537349e-14,  1.819263571888155e-16, -2.071816912660166e-19, -8.933341953530540e-22,  8.179427160771331e-24, -4.049322954165135e-26,  1.521519854420421e-28,
  1.019252164860849e-01, -6.393872923053041e-04,  2.856080149899064e-06, -1.048664061451901e-08,  3.186111596722944e-11, -7.304152796649207e-14,  6.780360373126446e-17,
  4.706714107724880e-19, -3.696825537113772e-21,  1.650515250518386e-23, -5.243489526414985e-26,  9.926337539621013e-29,  1.415522055052371e-01, -8.710286083024691e-04,
  3.731185985494406e-06, -1.261641154341731e-08,  3.220566113917058e-11, -4.200982596707757e-14, -1.399481669537128e-16,  1.328477579546732e-18, -5.920567146545932e-21,
  1.686527712020302e-23, -1.704139395325047e-26, -1.443235311784145e-28,  1.872047867179022e-01, -1.126031195915152e-03,  4.584561341117340e-06, -1.392051262738103e-08,
  2.673178030625780e-11,  1.338144128793158e-14, -3.961878508726456e-16,  2.002372146559315e-18, -5.751128334622409e-21,  3.854427799064278e-24,  6.393325935063851e-26,
 -4.347155817972248e-28,  2.386158011872270e-01, -1.397898604987743e-03,  5.355362217482729e-06, -1.409789791619322e-08,  1.508623003802047e-11,  8.554621200341870e-14,
 -6.247164213688392e-16,  2.090314224766163e-18, -2.111735964974679e-21, -2.012857633473813e-23,  1.439098935092829e-25, -4.783664135236970e-28,  2.954801330741402e-01,
 -1.679590424994968e-03,  5.984877465361654e-06, -1.294574161865728e-08, -2.033522539234075e-12,  1.609543990793403e-13, -7.386075603093706e-16,  1.329918212533539e-18,
  4.443856903333326e-21, -4.351577045499669e-23,  1.526741829350800e-25, -7.120446879046334e-29,  3.574549702505420e-01, -1.963673490213632e-03,  6.419964663648365e-06,
 -1.038790041631663e-08, -2.288076248492056e-11,  2.225545053302104e-13, -6.676917052283593e-16, -2.464981062337274e-19,  1.152506073089318e-20, -5.031500004611286e-23,
  4.671886122683143e-26,  6.446204657187263e-28,  4.241602093255127e-01, -2.242489413217989e-03,  6.616365935104599e-06, -6.492491235472412e-09, -4.483300098870437e-11,
  2.533685972188702e-13, -3.853177450373882e-16, -2.251395275455007e-18,  1.566719923682446e-20, -2.946500209762371e-23, -1.437304419756462e-25,  1.159682978531539e-27,
  4.951790449358753e-01, -2.508336693894926e-03,  6.541723877113777e-06, -1.475983463762749e-09, -6.472678483971113e-11,  2.405622438223697e-13,  7.442092127526146e-17,
 -4.020801513312144e-18,  1.388065301878084e-20,  1.622178757418740e-23, -3.109223780506342e-25,  9.246547596406413e-28,  5.700587872360852e-01, -2.753665015581427e-03,
  6.178111829312535e-06,  4.307783427257865e-09, -7.931683531417571e-11,  1.790916608684316e-13,  6.161356781291888e-16, -4.826704626004688e-18,  5.338286109558978e-21,
  6.760965722290479e-23, -3.261434812928515e-25, -1.587976035369681e-28,  6.483119550770725e-01, -2.971278596503130e-03,  5.523895197421862e-06,  1.039393866232110e-08,
 -8.579826355814262e-11,  7.400581940776618e-14,  1.102195544827899e-15, -4.159713065641876e-18, -7.667688627242659e-21,  9.665445512640552e-23, -1.305121793009614e-25,
 -1.487975374004039e-27,  7.294176951232022e-01, -3.154544627130786e-03,  4.594753751420638e-06,  1.624702216136456e-08, -8.231256154906443e-11, -5.933145564929254e-14,
  1.388435350272948e-15, -1.976578397949954e-18, -2.017182882528784e-20,  8.141976138572276e-23,  2.009523983153295e-25, -2.060999061513377e-27,  8.128235787994541e-01,
 -3.297601918094817e-03,  3.423720838704626e-06,  2.131262519496435e-08, -6.835028603993403e-11, -1.974409871812532e-13,  1.367616009796910e-15,  1.198237312195180e-18,
 -2.645385721992726e-20,  2.087487002214320e-23,  4.789879773359733e-25, -1.225079016678199e-27,  8.979478291143022e-01, -3.395563949075830e-03,  2.060135978152680e-06,
  2.507571437542731e-08, -4.496914141085449e-11, -3.131480036565098e-13,  1.007659339382588e-15,  4.386382264861135e-18, -2.272330611931153e-20, -6.008250793756571e-23,
  5.099934802812085e-25,  6.781034131406075e-28,  9.841820276532395e-01, -3.444709603149007e-03,  5.674631656267015e-07,  2.711975101570348e-08, -1.476722649872404e-11,
 -3.814353713866919e-13,  3.712515565837164e-16,  6.474202721770420e-18, -9.304926569261141e-21, -1.207136764038258e-22,  2.336529766943455e-25,  2.376273989265817e-27,
  1.070894347945674e+00, -3.442654067186367e-03, -9.800020381788431e-07,  2.717980682174467e-08,  1.841319060262749e-11, -3.854588908627386e-13, -3.924715358161871e-16,
  6.634255706114655e-18,  8.921026506056536e-21, -1.261829786119790e-22, -2.107017289964271e-25,  2.550128899246129e-27,  1.157433354540208e+00, -3.388491767398722e-03,
 -2.501430181151049e-06,  2.518265126616590e-08,  5.002963914669340e-11, -3.212197484332717e-13, -1.085303266455950e-15,  4.684796641809893e-18,  2.434985251965427e-20,
 -6.909751231492322e-23, -5.535653930921170e-25,  9.209672646748972e-28,  1.243132397088184e+00, -3.282902893624077e-03, -3.914562264777945e-06,  2.126743347759478e-08,
  7.555924134962266e-11, -1.995229272109025e-13, -1.517532930887302e-15,  1.222722105875411e-18,  3.012055453081348e-20,  2.309592413039019e-23, -5.708815167517387e-25,
 -1.389755914559509e-27,  1.327314615231163e+00, -3.128215157568253e-03, -5.141329580966257e-06,  1.578220863973276e-08,  9.127798372463840e-11, -4.438854688709177e-14,
 -1.568293958553269e-15, -2.557509159200135e-18,  2.357108329854075e-20,  1.016662426896088e-22, -2.467490545025440e-25, -2.662631026240099e-27,  1.409298552960916e+00,
 -2.928413037721702e-03, -6.113612429907166e-06,  9.254144400925537e-09,  9.495512375951615e-11,  1.120499836841022e-13, -1.227823229044346e-15, -5.314683727528741e-18,
  7.795053301808946e-21,  1.247473372818944e-22,  2.039638680790524e-25, -1.971487298483061e-27,  1.488404360427525e+00, -2.689087980772200e-03, -6.778694291615049e-06,
  2.334598747049378e-09,  8.631645565730865e-11,  2.371275696042733e-13, -6.047205013633841e-16, -6.105253464177769e-18, -9.746492984650061e-21,  8.289283679300592e-23,
  4.841968769805319e-25,  3.272716947272665e-29,  1.563960537243542e+00, -2.417324918536563e-03, -7.103931621898191e-06, -4.275984987243191e-09,  6.715998736476002e-11,
  3.058276139146310e-13,  1.075192491278516e-16, -4.780082105283650e-18, -2.101364340428422e-20,  4.755445034860874e-24,  4.297219902676203e-25,  1.694620525526829e-27,
  1.635311144829487e+00, -2.121523034627833e-03, -7.080164582933571e-06, -9.914807737785464e-09,  4.106838439875086e-11,  3.072822973568015e-13,  6.953389771551851e-16,
 -2.038949555855748e-18, -2.156376015943152e-20, -6.193985758419793e-23,  1.228261359879601e-25,  1.803596019277122e-27,  1.701823387294281e+00, -1.811151924644352e-03,
 -6.723449202251234e-06, -1.404368715072547e-08,  1.274543223045832e-11,  2.475781970006382e-13,  9.986775754863216e-16,  8.998103528501547e-19, -1.271657567584862e-20,
 -8.164644927220084e-23, -1.877899097401717e-25,  5.813260340668088e-28,  1.762895432146392e+00, -1.496448007384720e-03, -6.074800418800485e-06, -1.632350555685693e-08,
 -1.290788550198676e-11,  1.478010871330909e-13,  9.651717619194811e-16,  2.866370443970243e-18, -4.040579840280416e-22, -5.260673993838955e-23, -2.921569982194357e-25,
 -6.987100049155775e-28,  1.817964315553639e+00, -1.188060047706336e-03, -5.197795238761352e-06, -1.666393040103908e-08, -3.178989672167721e-11,  3.767104349436518e-14,
  6.628731982211366e-16,  3.265151614170326e-18,  8.578646022005428e-21, -3.699602235783159e-24, -1.733518474878828e-25, -1.005425943347660e-27,  1.866513754037817e+00,
 -8.966566493163806e-04, -4.174084805139072e-06, -1.523894468245841e-08, -4.144488324236397e-11, -5.342233031664350e-14,  2.455349488928175e-16,  2.292388850020915e-18,
  1.053729624542904e-20,  2.984086807529903e-23,  1.525299880570172e-26, -4.178403610105695e-28,  1.908081668099213e+00, -6.325122088995569e-04, -3.097084483080785e-06,
 -1.246346640432433e-08, -4.155502753001332e-11, -1.051902728417234e-13, -1.152865423294750e-16,  7.388551005641263e-19,  6.542342546474060e-21,  3.203586546576026e-23,
  1.109313311024548e-25,  2.275856663962246e-28,  1.942267218106420e+00, -4.050906879575908e-04, -2.064326228382117e-06, -8.932453691972734e-09, -3.394500422499769e-11,
 -1.121326179551273e-13, -3.019164989874246e-16, -5.003757994432417e-19,  8.727787677246025e-22,  1.330169491124618e-23,  7.900693219309693e-26,  3.468604963064707e-28,
  1.968737176426935e+00, -2.226481725204931e-04, -1.169137597567006e-06, -5.330367624926379e-09, -2.208001168509737e-11, -8.418309688466517e-14, -2.942329431529537e-16,
 -9.216095642869389e-19, -2.426366409087667e-21, -4.210403019777796e-24,  4.753700037547765e-27,  9.504941982738777e-29,  1.987231644176839e+00, -9.187430325957408e-05,
 -4.924231646831441e-07, -2.324435736389928e-09, -1.016550199578050e-11, -4.205179965843502e-14, -1.660427714447902e-16, -6.276295957596559e-19, -2.267605728516568e-21,
 -7.781832330654968e-24, -2.502362560429979e-26, -7.327017832227640e-29,  1.997571630818512e+00, -1.757339217346531e-05, -9.525898400430260e-08, -4.582116480808176e-10,
 -2.061927503262777e-12, -8.884573623907522e-15, -3.710663325290992e-17, -1.512825143368792e-19, -6.046994697847457e-22, -2.376317438886646e-24, -9.196924204846327e-27,
 -3.509149055582190e-29,  8.322404830550716e-04, -5.402189839600739e-06,  2.628933126253231e-08, -1.136629978699861e-10,  4.604098351443229e-13, -1.788986064442308e-15,
  6.752022784526962e-18, -2.493753083819648e-20,  9.055501362815507e-23, -3.243402503225571e-25,  1.148354268916244e-27, -4.025633023998983e-30,  7.483788892823388e-03,
 -4.843551300246437e-05,  2.342904001071047e-07, -1.002680851345589e-09,  3.998974227863185e-12, -1.519940840779328e-14,  5.567022720197631e-17, -1.976361679763711e-19,
  6.819533470601075e-22, -2.288786296637225e-24,  7.463634608394902e-27, -2.357787445069697e-29,  2.075286639731533e-02, -1.335228078694794e-04,  6.380656614100724e-07,
 -2.674505223919749e-09,  1.032849792481356e-11, -3.744715259049218e-14,  1.282542568653828e-16, -4.142577136730447e-19,  1.249474504571614e-21, -3.437482520119346e-24,
  8.141892463474716e-27, -1.362511268582439e-29,  4.057135414504472e-02, -2.587199228065875e-04,  1.213697216931435e-06, -4.926087642981958e-09,  1.806688821470772e-11,
 -6.046546824188696e-14,  1.827260716260208e-16, -4.794676630873105e-19,  9.638450274760155e-22, -5.916092963540289e-25, -7.561217371743137e-27,  5.568651859837354e-29,
  6.683687721730906e-02, -4.211471524438395e-04,  1.926634862775161e-06, -7.475671684768756e-09,  2.541006373185592e-11, -7.464453811608982e-14,  1.757671684683915e-16,
 -2.313569143124498e-19, -6.264720232896800e-22,  6.687524452741152e-24, -3.424846506859893e-26,  1.320306375909875e-28,  9.941257970361826e-02, -6.170334540594628e-04,
  2.733251220330867e-06, -9.988456740436772e-09,  3.041755894705913e-11, -7.126892883596304e-14,  7.941271516808409e-17,  3.614837919492552e-19, -3.139328085474687e-21,
  1.449641078270243e-23, -4.797870268394473e-26,  1.025131428583103e-28,  1.381268434818853e-01, -8.417760132120947e-04,  3.582852506461296e-06, -1.210801276068078e-08,
  3.133478176591665e-11, -4.494306626520006e-14, -1.053129392176956e-16,  1.148590783576107e-18, -5.327076318175840e-21,  1.607194377754657e-23, -2.226678350550162e-26,
 -9.507460719850206e-29,  1.827729672444453e-01, -1.090015601671671e-03,  4.420088649940887e-06, -1.349116105058689e-08,  2.690875855617643e-11,  4.525078785767220e-15,
 -3.426737674748692e-16,  1.821013648330858e-18, -5.570748461814895e-21,  6.050890951537092e-24,  4.641480761009559e-26, -3.626642693242436e-28,  2.331088270805138e-01,
 -1.355728178057434e-03,  5.187689596294415e-06, -1.384362571766033e-08,  1.665192100562159e-11,  7.124709658246965e-14, -5.672349327567380e-16,  2.012214746709944e-18,
 -2.737772576211231e-21, -1.478750227000616e-23,  1.233072106324026e-25, -4.560141160814321e-28,  2.888565450711186e-01, -1.632333115530729e-03,  5.829436493049210e-06,
 -1.295347548789547e-08,  1.011392939551668e-12,  1.436893335833968e-13, -6.996061509885752e-16,  1.448227274018879e-18,  2.986189516216129e-21, -3.750067420792923e-23,
  1.474135594652476e-25, -1.628654928513843e-28,  3.497021978965244e-01, -1.912818283074340e-03,  6.293257366444274e-06, -1.071925618339087e-08, -1.859026911599644e-11,
  2.064870961897242e-13, -6.696998533122796e-16,  9.373524265497517e-20,  9.753693203427201e-21, -4.793366358953497e-23,  7.103352116652808e-26,  4.642025200207250e-28,
  4.152956033859099e-01, -2.189881938139183e-03,  6.534317611738195e-06, -7.169803157036158e-09, -3.986292297479749e-11,  2.434201377539046e-13, -4.415047157878396e-16,
 -1.768028750148416e-18,  1.451493144456796e-20, -3.423123792372692e-23, -9.554694219793556e-26,  1.027300854098455e-27,  4.852502291951544e-01, -2.456090989670998e-03,
  6.517957287237050e-06, -2.473062386232081e-09, -5.990653673464356e-11,  2.410480048517755e-13, -3.187184030246150e-17, -3.569595968236188e-18,  1.425082253014471e-20,
  4.624523718119909e-24, -2.684107372250339e-25,  9.975922006926069e-28,  5.591432742621029e-01, -2.704054644309019e-03,  6.222311492647593e-06,  3.068126593869729e-09,
 -7.559796752337316e-11,  1.922786063472329e-13,  4.837274018806632e-16, -4.619462179956269e-18,  7.536577382103469e-21,  5.451684834078837e-23, -3.263021854350055e-25,
  1.424441273418201e-28,  6.365159801668523e-01, -2.926611741367494e-03,  5.640439218268747e-06,  9.034404580985710e-09, -8.406318425996060e-11,  9.903629856060381e-14,
  9.828036522189776e-16, -4.350535856762296e-18, -4.296977426097655e-21,  9.022341467516800e-23, -1.885663776248047e-25, -1.148723736769145e-27,  7.168742357361595e-01,
 -3.117029207592033e-03,  4.781782662941396e-06,  1.492231856924221e-08, -8.317081434814756e-11, -2.674331948216842e-14,  1.324504856988592e-15, -2.573804239212777e-18,
 -1.711773793874356e-20,  8.766184876500086e-23,  1.117590528835736e-25, -1.977928645045884e-27,  7.996895437924834e-01, -3.269208025127803e-03,  3.672786206390500e-06,
  2.018922312805945e-08, -7.196865128932515e-11, -1.643104284973661e-13,  1.389454023385659e-15,  3.673239409780289e-19, -2.537141873660089e-20,  3.885478985599254e-23,
  4.176779230783393e-25, -1.544852951350987e-27,  8.844004233632422e-01, -3.377891925813898e-03,  2.356525202239876e-06,  2.430745867591602e-08, -5.098074754492069e-11,
 -2.875743790990101e-13,  1.120001196195106e-15,  3.628614894920582e-18, -2.451334435015921e-20, -3.924562237307573e-23,  5.279166667668859e-25,  1.384731857038865e-28,
  9.704143233216912e-01, -3.438872742794007e-03,  8.912325117315859e-07,  2.682299082264903e-08, -2.229234074013188e-11, -3.703875944915741e-13,  5.477213420374551e-16,
  6.108916970897185e-18, -1.345801196700623e-20, -1.093682228959729e-22,  3.311481853481352e-25,  2.037327837571546e-27,  1.057110123604038e+00, -3.449185033283313e-03,
 -6.523325768388102e-07,  2.741229635016524e-08,  1.062501481930308e-11, -3.926210893713228e-13, -2.034089649030133e-16,  6.845643909639894e-18,  4.254356443048820e-21,
 -1.323051090339178e-22, -9.412628016234745e-26,  2.725469937156063e-27,  1.143841297025564e+00, -3.407281330746264e-03, -2.194651984346863e-06,  2.593036124975350e-08,
  4.335584125982675e-11, -3.456073351797324e-13, -9.436241394057378e-16,  5.420008071098030e-18,  2.147514751634306e-20, -9.025370996861734e-23, -4.999554254848995e-25,
  1.509222578723929e-27,  1.229939797441185e+00, -3.313178318887338e-03, -3.652237434527428e-06,  2.244249241599984e-08,  7.120791360585116e-11, -2.354233591065832e-13,
 -1.469709779832326e-15,  2.195364998431017e-18,  3.052756998781974e-20, -8.143084554271560e-25, -6.207769336080819e-25, -8.611150119308402e-28,  1.314720727720366e+00,
 -3.168563501461383e-03, -4.943216374507949e-06,  1.723348638505245e-08,  9.000847638694155e-11, -8.279838389250782e-14, -1.628809061976762e-15, -1.746809081746881e-18,
  2.702514292992636e-20,  8.945178584462334e-23, -3.637452002693172e-25, -2.630983952893589e-27,  1.397487823000034e+00, -2.976851750771143e-03, -5.993378375458991e-06,
  1.078970326196321e-08,  9.688955562935872e-11,  8.082888090096416e-14, -1.372456855042251e-15, -4.991991063183444e-18,  1.241062613609700e-20,  1.310310579795413e-22,
  1.068418225619075e-25, -2.435006580811039e-27,  1.477539760439190e+00, -2.743181641269617e-03, -6.742238937307333e-06,  3.752755173712315e-09,  9.089985745904502e-11,
  2.205305599883212e-13, -7.795587873591777e-16, -6.365662867396342e-18, -6.414715670447403e-21,  1.021418133023725e-22,  4.744420351180505e-25, -4.901149353273777e-28,
  1.554177276091765e+00, -2.474342885737164e-03, -7.148593910195176e-06, -3.152399436306362e-09,  7.329111144842022e-11,  3.067262633432767e-13, -3.568693752205275e-17,
 -5.446318040297789e-18, -2.051535827431855e-20,  2.340318157586247e-23,  5.016567331570086e-25,  1.555907927478522e-27,  1.626711032925610e+00, -2.178628618604312e-03,
 -7.194994023927690e-06, -9.207662537476359e-09,  4.737587577220395e-11,  3.232053486732769e-13,  6.282602912424346e-16, -2.763558655474418e-18, -2.368525493490212e-20,
 -5.535436627726654e-23,  2.085079214249964e-25,  2.085954317762314e-27,  1.694470142489342e+00, -1.865609763669328e-03, -6.890582245204280e-06, -1.379883774433431e-08,
  1.793847020175705e-11,  2.718000455819894e-13,  1.017723351786325e-15,  4.444578108915112e-19, -1.578398324474403e-20, -8.854578255207836e-23, -1.545749080383314e-25,
  9.385092660203473e-28,  1.756811198073761e+00, -1.545833216976833e-03, -6.271819942441707e-06, -1.650509772862343e-08, -9.713736883486430e-12,  1.719250168039718e-13,
  1.044947987226944e-15,  2.820824996117981e-18, -2.515433226992028e-21, -6.488180422368984e-23, -3.208386707149650e-25, -5.944603203237270e-28,  1.813127632055721e+00,
 -1.230450862095154e-03, -5.400786484521818e-06, -1.716564535470365e-08, -3.086982130613585e-11,  5.470793847743033e-14,  7.581105993503469e-16,  3.536109910532336e-18,
  8.309590348559524e-21, -1.156181840521912e-23, -2.208275202842621e-25, -1.151987054928304e-27,  1.862859167904736e+00, -9.307921491210872e-04, -4.360965010410568e-06,
 -1.591026768781118e-08, -4.244900117751900e-11, -4.672015012899592e-14,  3.146046624048269e-16,  2.646849799331849e-18,  1.161771108560190e-20,  3.003803767745875e-23,
 -6.573768027529237e-27, -5.798117530795511e-28,  1.905501102519322e+00, -6.578985949483230e-04, -3.250705254851909e-06, -1.314532014863954e-08, -4.368469913523188e-11,
 -1.076841406947550e-13, -9.148803433126016e-17,  9.675383882379987e-19,  7.777869158613408e-21,  3.666783603855286e-23,  1.204984924470755e-25,  2.043294008791238e-28,
  1.940613134005609e+00, -4.220434616258263e-04, -2.174849688780813e-06, -9.493913378471714e-09, -3.626123312621227e-11, -1.195431191991175e-13, -3.154595011980551e-16,
 -4.641442825983457e-19,  1.412360833106536e-21,  1.678465916145711e-23,  9.558614653133432e-26,  4.079398792422891e-28,  1.967827463776731e+00, -2.322632672054590e-04,
 -1.235278518228569e-06, -5.697509720499180e-09, -2.383642567243858e-11, -9.156326060521676e-14, -3.211474981387297e-16, -1.001633061840093e-18, -2.573427418600946e-21,
 -3.927389642919744e-24,  9.639854447783160e-27,  1.284280144726465e-28,  1.986856087546416e+00, -9.592809186465382e-05, -5.213207539522596e-07, -2.494034701980966e-09,
 -1.104785521915245e-11, -4.625617530020323e-14, -1.846758173584682e-16, -7.048749588682014e-19, -2.566569459095134e-21, -8.849878775436867e-24, -2.844486518217583e-26,
 -8.235350946107146e-29,  1.997499777471999e+00, -1.835803287512139e-05, -1.009614934107185e-07, -4.926738875493139e-10, -2.248879322011122e-12, -9.828232001223786e-15,
 -4.162683390332903e-17, -1.720757921459422e-19, -6.972584815975732e-22, -2.777036126392945e-24, -1.088993059140374e-26, -4.208730562222830e-29,  8.110438878919281e-04,
 -5.197208445133953e-06,  2.496842178721924e-08, -1.065741052895470e-10,  4.261956886406543e-13, -1.634999561310680e-15,  6.092646493047141e-18, -2.221806008359768e-20,
  7.966462724864456e-23, -2.817596431640635e-25,  9.851525047156101e-28, -3.410690403973595e-30,  7.293720789199965e-03, -4.660825340210897e-05,  2.226323299221226e-07,
 -9.410584131551045e-10,  3.707911104018829e-12, -1.392733688739483e-14,  5.042994202356656e-17, -1.770763526120031e-19,  6.046897886147424e-22, -2.010013357784194e-24,
  6.498287603120415e-27, -2.038101638578098e-29,  2.022878484646731e-02, -1.285439053298677e-04,  6.069389505659431e-07, -2.515077421876414e-09,  9.609419231205560e-12,
 -3.450383504399575e-14,  1.171966431275434e-16, -3.761928396920276e-19,  1.131442393802053e-21, -3.123837204614144e-24,  7.540128634290967e-27, -1.366104048184947e-29,
  3.955552604506340e-02, -2.492419734662690e-04,  1.156279438788594e-06, -4.646458133767788e-09,  1.690036359599693e-11, -5.623768004568525e-14,  1.697291883524807e-16,
 -4.490191877425631e-19,  9.376604702575324e-22, -8.486483694825792e-25, -5.375316298406206e-27,  4.406655257628848e-29,  6.518255622402915e-02, -4.060861062268613e-04,
  1.839317639611425e-06, -7.080826831285273e-09,  2.395882157542193e-11, -7.050591404269888e-14,  1.690428874338372e-16, -2.478053705916136e-19, -4.090301019127084e-22,
  5.428297278916590e-24, -2.884475450651485e-26,  1.139257434026236e-28,  9.698743032258049e-02, -5.956387242840338e-04,  2.616263131975311e-06, -9.513072028576238e-09,
  2.901200259818856e-11, -6.925244774347196e-14,  8.820370732601594e-17,  2.690136592939440e-19, -2.650914244279586e-21,  1.266749795708421e-23, -4.347253991027353e-26,
  1.017635157660968e-28,  1.348161568016014e-01, -8.136859238650456e-04,  3.440534414174763e-06, -1.161397387629050e-08,  3.041315303235147e-11, -4.710338472863804e-14,
 -7.545321541768952e-17,  9.872024372015435e-19, -4.765415122995752e-21,  1.510970913640875e-23, -2.556312295441357e-26, -5.635335469259404e-29,  1.784826112663956e-01,
 -1.055295144960651e-03,  4.260779543754893e-06, -1.306032677133833e-08,  2.692104527885503e-11, -3.107161537363134e-15, -2.941459534691928e-16,  1.646563308278198e-18,
 -5.323163367459077e-21,  7.608009422668013e-24,  3.191466270792484e-26, -2.976542299001081e-28,  2.277678718174486e-01, -1.314886522414679e-03,  5.023209351082305e-06,
 -1.356651614826663e-08,  1.794523712646199e-11,  5.829920374574303e-14, -5.121929098291005e-16,  1.917001636475042e-18, -3.186095934689851e-21, -1.024747498654446e-23,
  1.039328831745530e-25, -4.233028368657113e-28,  2.824194997976938e-01, -1.586318902760968e-03,  5.674183798845330e-06, -1.291520122809573e-08,  3.720609373896951e-12,
  1.273949812791472e-13, -6.579129018806815e-16,  1.523307699002542e-18,  1.740385478876554e-21, -3.176799814589231e-23,  1.387592839670575e-25, -2.262300484873069e-28,
  3.421507954866184e-01, -1.862991496799162e-03,  6.162975083001339e-06, -1.098453433578918e-08, -1.462086698013979e-11,  1.904794901820660e-13, -6.629609022080144e-16,
  3.788290566900638e-19,  8.083707441388000e-21, -4.473185393765116e-23,  8.791172169417011e-26,  3.069819778778779e-28,  4.066400649857434e-01, -2.137962024333463e-03,
  6.444611881874054e-06, -7.769254326916381e-09, -3.510422490674557e-11,  2.322812900102107e-13, -4.846968501510529e-16, -1.323919866179544e-18,  1.322432230244700e-20,
 -3.719143267254994e-23, -5.352696607283179e-26,  8.813487272414417e-28,  4.755299420787336e-01, -2.404081966987627e-03,  6.482688377514614e-06, -3.393073908282323e-09,
 -5.510105501370919e-11,  2.391353092975542e-13, -1.254254040372911e-16, -3.112891603032431e-18,  1.423471387322406e-20, -5.225348347232031e-24, -2.239611384209211e-25,
  1.014479713794217e-27,  5.484268172069757e-01, -2.654149148793144e-03,  6.252000435104264e-06,  1.889911006405937e-09, -7.164662954803231e-11,  2.023649007398787e-13,
  3.580360268904160e-16, -4.349392162252388e-18,  9.266456316723657e-21,  4.166609941503196e-23, -3.144611745672646e-25,  3.860003532407826e-28,  6.249004347720652e-01,
 -2.881077282732716e-03,  5.740851409115030e-06,  7.706479357818552e-09, -8.185652019098459e-11,  1.211492151053415e-13,  8.595409699240867e-16, -4.437618988434111e-18,
 -1.195962503197912e-21,  8.177095079926503e-23, -2.315663331087716e-25, -8.070772344791278e-28,  7.044837295474049e-01, -3.078081327013362e-03,  4.952853962164015e-06,
  1.358900818427399e-08, -8.339394438352697e-11,  4.121043781223276e-15,  1.245249195043866e-15, -3.070383574144160e-18, -1.390203160724149e-20,  9.043524537756801e-23,
  2.812555350333317e-26, -1.811468712320722e-27,  7.866729827018334e-01, -3.238876466209362e-03,  3.908045323194245e-06,  1.901324875093539e-08, -7.492102605044558e-11,
 -1.309304497683431e-13,  1.388605177404329e-15, -4.190939733607879e-19, -2.368895887856756e-20,  5.413157090557962e-23,  3.446004390841243e-25, -1.759118227892051e-27,
  8.709283872893296e-01, -3.357887260402301e-03,  2.643135576896351e-06,  2.344724823048807e-08, -5.645566825525367e-11, -2.595649356722410e-13,  1.210437117662323e-15,
  2.825660572119591e-18, -2.554602392540581e-20, -1.816092934787972e-23,  5.225826682386795e-25, -3.739293676382902e-28,  9.566751213216828e-01, -3.430462000721181e-03,
  1.210726351352617e-06,  2.640782282002344e-08, -2.955505107901758e-11, -3.552418927666465e-13,  7.121691338823064e-16,  5.617989118693604e-18, -1.713633663721815e-20,
 -9.445138126152532e-23,  4.115253718256870e-25,  1.602778283558878e-27,  1.043305032775616e+00, -3.453085611852042e-03, -3.226248297209028e-07,  2.751927735841505e-08,
  2.739361554616639e-12, -3.951918055640584e-13, -1.054483408921000e-17,  6.905084859325097e-18, -5.473004604368337e-22, -1.336521956531521e-22,  2.698976152143752e-26,
  2.755349854353973e-27,  1.130179043924578e+00, -3.423582629548053e-03, -1.879557431036623e-06,  2.656758000619205e-08,  3.622990543711778e-11, -3.663586744742789e-13,
 -7.827582175957475e-16,  6.051506638207671e-18,  1.788352709155832e-20, -1.087626014116946e-22, -4.216351094379877e-25,  2.037792513293609e-27,  1.216630380852609e+00,
 -3.341299980358154e-03, -3.376253091417870e-06,  2.354225767851753e-08,  6.615226491930102e-11, -2.698485635596332e-13, -1.394602161154806e-15,  3.166922138277683e-18,
  3.004376079470418e-20, -2.622670276872204e-23, -6.453377363391668e-25, -2.431221750170729e-28,  1.301968726377346e+00, -3.207257682533491e-03, -4.727835292301574e-06,
  1.865823546440576e-08,  8.795815006016749e-11, -1.223761367518176e-13, -1.665149659855733e-15, -8.335124606705712e-19,  2.995598461195316e-20,  7.262990357089491e-23,
 -4.759948808736996e-25, -2.444975718750571e-27,  1.385485379313030e+00, -3.024254407059133e-03, -5.854553116957119e-06,  1.235103242893561e-08,  9.816567228231385e-11,
  4.626186698571267e-14, -1.505958874178141e-15, -4.518769331574046e-18,  1.717772338057224e-20,  1.330394020485693e-22, -9.304997327130783e-27, -2.829857620300935e-27,
  1.466459478599308e+00, -2.796914367458886e-03, -6.688337398084123e-06,  5.241360264358752e-09,  9.510883223918662e-11,  1.996626181203702e-13, -9.600925295738251e-16,
 -6.508489728037526e-18, -2.402759863678789e-21,  1.205169449670303e-22,  4.399582927019507e-25, -1.087808739431483e-27,  1.544165316221662e+00, -2.531662551350570e-03,
 -7.179184612997565e-06, -1.930765159003177e-09,  7.940434002819301e-11,  3.039665506357327e-13, -1.972196972544124e-16, -6.085326466121099e-18, -1.929575485824379e-20,
  4.477059501651640e-23,  5.647932229470913e-25,  1.291975535704189e-27,  1.617880717611035e+00, -2.236617155901527e-03, -7.300721996646923e-06, -8.397144290840097e-09,
  5.398404724505022e-11,  3.372676148443914e-13,  5.399826152113609e-16, -3.551577205871178e-18, -2.550508439371603e-20, -4.510421173682929e-23,  3.057351323983917e-25,
  2.323726739149025e-27,  1.686896412851014e+00, -1.921391464803870e-03, -7.054262509097198e-06, -1.346700393628948e-08,  2.361942512973192e-11,  2.963146830436621e-13,
  1.022609730553396e-15, -1.127375677105091e-19, -1.907190342110361e-20, -9.378458247509304e-23, -1.043372590371920e-25,  1.354082235588813e-27,  1.750526258325123e+00,
 -1.596802393032388e-03, -6.470695676635345e-06, -1.663162024180408e-08, -6.018107892702630e-12,  1.979402218883966e-13,  1.122435090300736e-15,  2.700433825962001e-18,
 -5.088076432799964e-21, -7.819244527298389e-23, -3.434147055977677e-25, -4.186519770171268e-28,  1.808118099698461e+00, -1.274489411791662e-03, -5.609698328854439e-06,
 -1.764978645041232e-08, -2.958554266788164e-11,  7.412032522670728e-14,  8.607690598420830e-16,  3.793550756105228e-18,  7.721773322531120e-21, -2.145023028909595e-23,
 -2.745971892536042e-25, -1.289640120809289e-27,  1.859064998297211e+00, -9.664551764027897e-04, -4.555992762489181e-06, -1.659649071961224e-08, -4.330167466470541e-11,
 -3.823729097996764e-14,  3.940830903939636e-16,  3.035814549120463e-18,  1.268769940319114e-20,  2.920946815752413e-23, -3.629101584367537e-26, -7.770630999215038e-28,
  1.902816480819478e+00, -6.845472589995781e-04, -3.412714259310441e-06, -1.386161436479826e-08, -4.585799404910378e-11, -1.095253824441265e-13, -6.070729678133825e-17,
  1.238498064694767e-18,  9.186737000733163e-21,  4.165628646802978e-23,  1.286016875678511e-25,  1.599549171116837e-28,  1.938889426859397e+00, -4.399080144333023e-04,
 -2.292337970498188e-06, -1.009363568610724e-08, -3.872882960731444e-11, -1.272644070119162e-13, -3.277264947748392e-16, -4.085065763041381e-19,  2.089933739200304e-21,
  2.098667033648441e-23,  1.150115111390298e-25,  4.761820914210792e-28,  1.966878203900713e+00, -2.424256012705990e-04, -1.305998746479238e-06, -6.093971133900941e-09,
 -2.574708662385808e-11, -9.961678247649943e-14, -3.503667763965555e-16, -1.086158748630902e-18, -2.706404439294486e-21, -3.416943696005738e-24,  1.619373880267640e-26,
  1.712063045273114e-28,  1.986463840163170e+00, -1.002214484865533e-04, -5.523410923689593e-07, -2.678449072030164e-09, -1.201894882015997e-11, -5.093481603011410e-14,
 -2.056116423483159e-16, -7.923295615033029e-19, -2.906544239926135e-21, -1.006296026045498e-23, -3.227988765805174e-26, -9.205455129884575e-29,  1.997424691629669e+00,
 -1.919000016408170e-05, -1.070961395289651e-07, -5.302844399487414e-10, -2.455838103673785e-12, -1.088771024103348e-14, -4.677297825104038e-17, -1.960754692257640e-19,
 -8.055403168343208e-22, -3.252053263612123e-24, -1.292283628750700e-26, -5.059307895590140e-29,  7.906466096743559e-04, -5.002463137274694e-06,  2.372939337976577e-08,
 -1.000088358407658e-10,  3.949089919803722e-13, -1.495962354006128e-15,  5.504758250534192e-18, -1.982376412496892e-20,  7.019587572326711e-23, -2.451967165336744e-25,
  8.467436778879087e-28, -2.895565494770007e-30,  7.110779768886535e-03, -4.487137776526523e-05,  2.116866048907319e-07, -8.838960960155602e-10,  3.441076966301096e-12,
 -1.277439448502463e-14,  4.573217474039076e-17, -1.588355835222369e-19,  5.367996529894814e-22, -1.767177645584331e-24,  5.663517934852051e-27, -1.763127801139732e-29,
  1.972413272457352e-02, -1.238065551499846e-04,  5.776582386459147e-07, -2.366698012420796e-09,  8.946637230248658e-12, -3.181352696660730e-14,  1.071536318182310e-16,
 -3.417289755533455e-19,  1.024268872863127e-21, -2.834185087191296e-24,  6.944693519581204e-27, -1.335849562413417e-29,  3.857671187022586e-02, -2.402102551117870e-04,
  1.102107964621998e-06, -4.384833232215130e-09,  1.581534402286669e-11, -5.231168901451784e-14,  1.575718553323084e-16, -4.195407568842625e-19,  9.036793013043972e-22,
 -1.027805980923116e-24, -3.651295369656351e-27,  3.462375886179130e-29,  6.358711179919957e-02, -3.917050337470737e-04,  1.756601938136052e-06, -6.708548583880952e-09,
  2.258870465902520e-11, -6.653345355885135e-14,  1.619489372364696e-16, -2.579808063215488e-19, -2.332162824395881e-22,  4.369877352374576e-24, -2.419357493612504e-26,
  9.781446108138272e-29,  9.464602364486489e-02, -5.751574599253223e-04,  2.504846092432743e-06, -9.059842967177400e-09,  2.764868486086214e-11, -6.705434629516061e-14,
  9.461469446681805e-17,  1.911539837209280e-19, -2.225113065622502e-21,  1.101727748604166e-23, -3.906423675524828e-26,  9.824258097354354e-29,  1.316155905782591e-01,
 -7.867109191110470e-04,  3.304055008348793e-06, -1.113498926580743e-08,  2.945512859190257e-11, -4.859929817652044e-14, -4.986611165878636e-17,  8.432107214144621e-19,
 -4.240382144954448e-21,  1.404697232035136e-23, -2.735637746371898e-26, -2.648834331328968e-29,  1.743286209028272e-01, -1.021828488909782e-03,  4.106636791650475e-06,
 -1.263045542674438e-08,  2.679194304959172e-11, -9.632406440968207e-15, -2.503841700653846e-16,  1.480826113855268e-18, -5.029292783838363e-21,  8.640125818738504e-24,
  2.010963033836494e-26, -2.401980499341924e-28,  2.225876730246260e-01, -1.275347074911399e-03,  4.862170263395973e-06, -1.327071434270826e-08,  1.899258177607835e-11,
  4.663885246113769e-14, -4.599941816337629e-16,  1.809910610406872e-18, -3.484561432250637e-21, -6.451544884736028e-24,  8.614728256417005e-26, -3.844076758335194e-28,
  2.761640312492187e-01, -1.541544161884459e-03,  5.519639904139677e-06, -1.283613159758203e-08,  6.114092942852491e-12,  1.121221773251707e-13, -6.146450015710212e-16,
  1.561752594647411e-18,  6.941217640280489e-22, -2.642996377621702e-23,  1.278534959509969e-25, -2.659736129903783e-28,  3.347965970363974e-01, -1.814218646726892e-03,
  6.029879994937422e-06, -1.118885187652514e-08, -1.096938376423070e-11,  1.747234826903018e-13, -6.489692970247383e-16,  6.124447666318390e-19,  6.539537330548278e-21,
 -4.098608139428662e-23,  9.841064928263824e-26,  1.743102149066771e-28,  3.981907271954152e-01, -2.086787252933263e-03,  6.348162050250311e-06, -8.294400723084925e-09,
 -3.057768716238892e-11,  2.202502976008227e-13, -5.160459097907282e-16, -9.225038292211806e-19,  1.185583609195085e-20, -3.860097763852097e-23, -1.804057933130924e-26,
  7.317734816918364e-28,  4.660170586701148e-01, -2.352397952722381e-03,  6.436839010091823e-06, -4.236621405231225e-09, -5.035524590031248e-11,  2.351304072737901e-13,
 -2.062493190532658e-16, -2.662032496424983e-18,  1.389606276443433e-20, -1.329647955538255e-23, -1.798028536625387e-25,  9.861749011793887e-28,  5.379103691488081e-01,
 -2.604061607042371e-03,  6.267936252275034e-06,  7.763694102646592e-10, -6.752308856850040e-11,  2.095311772015355e-13,  2.406128178974948e-16, -4.031256722867052e-18,
  1.054465719857550e-20,  2.948582311978219e-23, -2.932114849122956e-25,  5.701762785837245e-28,  6.134685337749077e-01, -2.834802634205211e-03,  5.825554409109634e-06,
  6.417237460861147e-09, -7.923732162164369e-11,  1.402854883064115e-13,  7.351812725846710e-16, -4.430641006368084e-18,  1.573396461952270e-21,  7.189558789378033e-23,
 -2.598295398224513e-25, -4.815924176767364e-28,  6.922516506654602e-01, -3.037828889410997e-03,  5.107924139576168e-06,  1.225695815020219e-08, -8.301987435069385e-11,
  3.292811804394526e-14,  1.153540443655484e-15, -3.463092923781822e-18, -1.064474851798454e-20,  9.002985649539626e-23, -4.672162493125106e-26, -1.582058695143820e-27,
  7.737814215518012e-01, -3.206720033478854e-03,  4.128931326516850e-06,  1.779536869639695e-08, -7.720775503245840e-11, -9.782850841203243e-14,  1.366568930085530e-15,
 -1.143454453238391e-18, -2.151113506097059e-20,  6.632827510814578e-23,  2.644519428274010e-25, -1.866698741112688e-27,  8.575408882217441e-01, -3.335632447970932e-03,
  2.918916681024876e-06,  2.250403079073658e-08, -6.135053290762434e-11, -2.296578581399698e-13,  1.278041243031646e-15,  2.001720839422204e-18, -2.582879985913099e-20,
  2.273998871694260e-24,  4.958345407046924e-25, -8.306726088611309e-28,  9.429746398818281e-01, -3.419517187062208e-03,  1.524551632208442e-06,  2.587908429780686e-08,
 -3.647655989492190e-11, -3.363271791902600e-13,  8.613079870919772e-16,  5.018528756363250e-18, -2.022459172161923e-20, -7.672340430460568e-23,  4.712295775590808e-25,
  1.103011341991645e-27,  1.029489620056247e+00, -3.454345540525123e-03,  7.608785561604213e-09,  2.749992834792139e-08, -5.151373632158256e-12, -3.931311846145315e-13,
  1.818318788869587e-16,  6.811031844672423e-18, -5.310328837528546e-21, -1.301718895881945e-22,  1.461709771951394e-25,  2.638167145305237e-27,  1.116456672793672e+00,
 -3.437334553827904e-03, -1.557513343027081e-06,  2.708767911488827e-08,  2.872891323793636e-11, -3.830506283898810e-13, -6.059149850466855e-16,  6.558060855489082e-18,
  1.368735125636277e-20, -1.236993943118558e-22, -3.220527297615078e-25,  2.470043820436681e-27,  1.203212974940299e+00, -3.367162405132181e-03, -3.087579285639730e-06,
  2.455573167654033e-08,  6.042832881484727e-11, -3.021473421770409e-13, -1.292646258827641e-15,  4.108224609635533e-18,  2.863415237418452e-20, -5.205872057792672e-23,
 -6.413560643727201e-25,  4.299582807324652e-28,  1.289065501821310e+00, -3.244161045103049e-03, -4.495580303090483e-06,  2.004380837171943e-08,  8.510967057510778e-11,
 -1.625091884685147e-13, -1.674702046947118e-15,  1.630339509033409e-19,  3.220282038594261e-20,  5.152888937693912e-23, -5.765319841342421e-25, -2.098547054730619e-27,
  1.373295665285387e+00, -3.070471224024625e-03, -5.696892766337378e-06,  1.392707946922942e-08,  9.871957069088837e-11,  8.667078873755001e-15, -1.624070737500598e-15,
 -3.892772645073950e-18,  2.192956601679903e-20,  1.300832570742114e-22, -1.405991393855256e-25, -3.117167624914395e-27,  1.455165242985777e+00, -2.850143316703295e-03,
 -6.616183074680453e-06,  6.793733573802957e-09,  9.885687368288474e-11,  1.744289842658144e-13, -1.142730822514050e-15, -6.512668612406785e-18,  2.239380052396417e-21,
  1.369702215870927e-22,  3.779948162114273e-25, -1.734010434861289e-27,  1.533923683422253e+00, -2.589166646936027e-03, -7.194531354664108e-06, -6.119774119243613e-10,
  8.542218308998182e-11,  2.971204825350188e-13, -3.759793383563871e-16, -6.672537636252619e-18, -1.726462841051956e-20,  6.839113982127210e-23,  6.133025689220934e-25,
  8.893977271038222e-28,  1.608816820663825e+00, -2.295410794092970e-03, -7.396080478507228e-06, -7.478768067833973e-09,  6.085045771020236e-11,  3.489402303372011e-13,
  4.288860743856337e-16, -4.391156289700421e-18, -2.688355905120345e-20, -3.077547700150072e-23,  4.118903591271286e-25,  2.486397182992026e-27,  1.679096964973929e+00,
 -1.978465097530594e-03, -7.213399210332966e-06, -1.304035165605266e-08,  2.979051968798808e-11,  3.207473273346963e-13,  1.010396274940489e-15, -7.777394060367092e-19,
 -2.250770139644260e-20, -9.663283619217961e-23, -3.469012908387533e-26,  1.818612401200364e-27,  1.744034251716880e+00, -1.649367602637846e-03, -6.670717406810160e-06,
 -1.669475053435445e-08, -1.783900920509094e-12,  2.257649147403776e-13,  1.195325511382496e-15,  2.489893431376031e-18, -8.154072299130723e-21, -9.222694034808891e-23,
 -3.563982816884209e-25, -1.559337432372853e-28,  1.802929034291358e+00, -1.320222115303089e-03, -5.824283323186697e-06, -1.811013683116119e-08, -2.788780682419790e-11,
  9.608054554867327e-14,  9.703159792731829e-16,  4.026059088403414e-18,  6.737847340851091e-21, -3.360511553753986e-23, -3.339893675349750e-25, -1.405005386372914e-27,
  1.855125003674019e+00, -1.003711582747884e-03, -4.759331102915877e-06, -1.729489185775768e-08, -4.396471412641853e-11, -2.771242452172274e-14,  4.849256647306590e-16,
  3.458294617022224e-18,  1.370427074595429e-20,  2.700756660387765e-23, -7.551825985242619e-26, -1.012442407659422e-27,  1.900022617043107e+00, -7.125269708698203e-04,
 -3.583528508602805e-06, -1.461293308683942e-08, -4.806008484351646e-11, -1.105315815054153e-13, -2.168109634865502e-17,  1.557473141463210e-18,  1.078048283300520e-20,
  4.692201761906653e-23,  1.341551445023087e-25,  8.707941180969593e-29,  1.937092335147395e+00, -4.587419431889951e-04, -2.417264955477736e-06, -1.073409036405506e-08,
 -4.135365646119016e-11, -1.352588130126985e-13, -3.381082348457105e-16, -3.286102209794118e-19,  2.933507227204485e-21,  2.602774453499402e-23,  1.375870597817582e-25,
  5.509688515268044e-28,  1.965887132283565e+00, -2.531732595022947e-04, -1.381665376107726e-06, -6.522330601063202e-09, -2.782602474987291e-11, -1.084004296185553e-13,
 -3.820092020653172e-16, -1.174591213107318e-18, -2.815803502693375e-21, -2.603423544797090e-24,  2.487916915895509e-26,  2.257463179687070e-28,  1.986053908630026e+00,
 -1.047720911361355e-04, -5.856708068770134e-07, -2.879177677740600e-09, -1.308884470940653e-11, -5.614657208635172e-14, -2.291552860697935e-16, -8.913925421428357e-19,
 -3.293055359273508e-21, -1.143812104151323e-23, -3.655188553169160e-26, -1.021728990420401e-28,  1.997346176823791e+00, -2.007290787646048e-05, -1.137027019536868e-07,
 -5.713827956746926e-10, -2.685278048769666e-12, -1.207916776455744e-14, -5.264231089252512e-17, -2.238302315454598e-19, -9.324813376182929e-22, -3.816391153474120e-24,
 -1.536950737918450e-26, -6.095914683449831e-29,  7.710089754525799e-04, -4.817323227256331e-06,  2.256623402496597e-08, -9.392265199874085e-11,  3.662672046245843e-13,
 -1.370263040989066e-15,  4.979858803862989e-18, -1.771243369846386e-20,  6.194896364650359e-23, -2.137423001160636e-25,  7.291251050819498e-28, -2.463128775020357e-30,
  6.934615363653163e-03, -4.321939500281786e-05,  2.014019531504795e-07, -8.308246108469650e-10,  3.196214347273346e-12, -1.172830723675497e-14,  4.151600382779325e-17,
 -1.426336402704171e-19,  4.770786520517449e-22, -1.555430164317981e-24,  4.941082627333753e-27, -1.526521821844185e-29,  1.923797253962153e-02, -1.192965047247273e-04,
  5.500961866288691e-07, -2.228505440529364e-09,  8.335327269600327e-12, -2.935304937037006e-14,  9.802912996537379e-17, -3.105323906195634e-19,  9.270980092859854e-22,
 -2.568010181071465e-24,  6.367921923379764e-27, -1.282842866270383e-29,  3.763317729980421e-02, -2.315996398147936e-04,  1.050974367957834e-06, -4.139956060077651e-09,
  1.480599270885687e-11, -4.866769760212494e-14,  1.462238155607759e-16, -3.912403877814732e-19,  8.643947153197359e-22, -1.145758092672993e-24, -2.301959710750823e-27,
  2.697803945238910e-29,  6.204789598797201e-02, -3.779681842174109e-04,  1.678224636026523e-06, -6.357565949843576e-09,  2.129631446714276e-11, -6.273406504059338e-14,
  1.546433593991525e-16, -2.631052950221768e-19, -9.232238437528704e-23,  3.483895232049551e-24, -2.020899317162054e-26,  8.360703824580551e-29,  9.238479327831516e-02,
 -5.555461443185706e-04,  2.398738398991031e-06, -8.628067647631124e-09,  2.633069893251046e-11, -6.472705599380322e-14,  9.902767932106919e-17,  1.260031109890106e-19,
 -1.855588731627312e-21,  9.539693333446046e-24, -3.485398956301239e-26,  9.289665219353755e-29,  1.285207767356558e-01, -7.608050209886836e-04,  3.173230564615103e-06,
 -1.067154036404158e-08,  2.847300987438636e-11, -4.952763961618919e-14, -2.808139719181885e-17,  7.153965133591228e-19, -3.754602947229390e-21,  1.293652282455572e-23,
 -2.800216279600125e-26, -3.958720280241539e-30,  1.703060634874565e-01, -9.895743857223911e-04,  3.957635975791074e-06, -1.220363824992905e-08,  2.654246848437998e-11,
 -1.516196241018254e-14, -2.111264100387984e-16,  1.325000952887505e-18, -4.706176793651005e-21,  9.248360721205512e-24,  1.066536483068783e-26, -1.903187540417127e-28,
  2.175630782567145e-01, -1.237081474031839e-03,  4.704773864289324e-06, -1.295995364917402e-08,  1.981899915281020e-11,  3.619433026025496e-14, -4.109081303276682e-16,
  1.695321255051186e-18, -3.658756498645619e-21, -3.331739519341045e-24,  7.014796913569168e-26, -3.425719433204274e-28,  2.700851958601809e-01, -1.498001348642348e-03,
  5.366264722976886e-06, -1.272115315708218e-08,  8.212573111529711e-12,  9.789711165029589e-14, -5.707410991658108e-16,  1.569704507670395e-18, -1.681916793634952e-22,
 -2.155719683822631e-23,  1.156349323893792e-25, -2.866239798496998e-28,  3.276353463076802e-01, -1.766519395217609e-03,  5.894673304747515e-06, -1.133724627676609e-08,
 -7.629161191529568e-12,  1.593763121047921e-13, -6.291074541969559e-16,  7.988746641159665e-19,  5.136433167573157e-21, -3.692989114457278e-23,  1.036096112513968e-25,
  6.592295271598865e-29,  3.899445070960241e-01, -2.036408074528891e-03,  6.245836946848782e-06, -8.749084621357429e-09, -2.629840836755228e-11,  2.075968176915678e-13,
 -5.367741519143751e-16, -5.654301338909011e-19,  1.046057599453791e-20, -3.872197690452711e-23,  1.093027910714717e-26,  5.862777684467547e-28,  4.567101154325968e-01,
 -2.301119939567275e-03,  6.381319697412427e-06, -5.004977868246557e-09, -4.570791744238428e-11,  2.293357390242592e-13, -2.746421626690794e-16, -2.226321396019272e-18,
  1.329824448419548e-20, -1.963704627199079e-23, -1.376821873532855e-25,  9.236345874875212e-28,  5.275944431981235e-01, -2.553898897234414e-03,  6.270909672437285e-06,
 -2.701989391589815e-10, -6.328365990844895e-11,  2.139904132032074e-13,  1.326053718750688e-16, -3.679055824768344e-18,  1.140146465485939e-20,  1.830049450683267e-23,
 -2.651310754344662e-25,  6.971044190256954e-28,  6.022229896802714e-01, -2.787911504832186e-03,  5.895050054654246e-06,  5.172802621995791e-09, -7.626517775596593e-11,
  1.564491517655554e-13,  6.122027904709406e-16, -4.340922391458718e-18,  3.970272386733972e-21,  6.116804533644394e-23, -2.743976502854289e-25, -1.865627560792518e-28,
  6.801829616213328e-01, -2.996399684051827e-03,  5.247064242888040e-06,  1.093537925326720e-08, -8.209250285647567e-11,  5.941397662914400e-14,  1.052288898341647e-15,
 -3.752359940508397e-18, -7.453388558033407e-21,  8.684623501674113e-23, -1.104836924162277e-25, -1.311119136908651e-27,  7.610219269378162e-01, -3.172855542860049e-03,
  4.335004978912805e-06,  1.654616180424256e-08, -7.883933439666583e-11, -6.549056370763518e-14,  1.325287806942287e-15, -1.791725450648904e-18, -1.895280080168239e-20,
  7.525465035145582e-23,  1.818177563011351e-25, -1.873626468629774e-27,  8.442467473980044e-01, -3.311217946554315e-03,  3.182929271642984e-06,  2.148736095105452e-08,
 -6.563290214453463e-11, -1.984054764523084e-13,  1.322557272370892e-15,  1.180258252810661e-18, -2.539982666822758e-20,  2.125861822971432e-23,  4.506353179024787e-25,
 -1.209535459035147e-27,  9.293229160985771e-01, -3.406089003271105e-03,  1.831380683564801e-06,  2.524281656570582e-08, -4.298539584498913e-11, -3.140451138460283e-13,
  9.923773889211911e-16,  4.330872697052875e-18, -2.263706391922132e-20, -5.705884712988221e-23,  5.081240549963246e-25,  5.716246573202550e-28,  1.015674446865639e+00,
 -3.452966670552156e-03,  3.368548715607670e-07,  2.735490692957999e-08, -1.295502770241270e-11, -3.865021991093844e-13,  3.694665951344963e-16,  6.567474065060679e-18,
 -9.863878665190190e-21, -1.220690449378266e-22,  2.571118091750511e-25,  2.383173629469645e-27,  1.102684483286669e+00, -3.448487224767081e-03, -1.229958418162071e-06,
  2.748532678266988e-08,  2.093759277762479e-11, -3.953437843679839e-13, -4.168432727965300e-16,  6.922537751242503e-18,  9.029415099040025e-21, -1.343079059739382e-22,
 -2.061461249345443e-25,  2.775425913551884e-27,  1.189696812872233e+00, -3.390668397804992e-03, -2.787314152043069e-06,  2.547259670132353e-08,  5.408499144815428e-11,
 -3.316888553855807e-13, -1.165104637585518e-15,  4.989629529213354e-18,  2.630466694281381e-20, -7.713192052912203e-23, -6.072957003637636e-25,  1.116864057786479e-27,
  1.276018484024076e+00, -3.279140696081290e-03, -4.246998394931729e-06,  2.137738148672140e-08,  8.145853656187456e-11, -2.025292621863469e-13, -1.655464097941634e-15,
  1.218581377869303e-18,  3.362172949744992e-20,  2.675756100418647e-23, -6.583847969241841e-25, -1.597757931532759e-27,  1.360923726471202e+00, -3.115351015380743e-03,
 -5.520291971427426e-06,  1.550582596709739e-08,  9.849473450184388e-11, -3.153501154918282e-14, -1.722549224957144e-15, -3.117455709097709e-18,  2.647776834116061e-20,
  1.216624785319806e-22, -2.814846330083180e-25, -3.260126988278904e-27,  1.443659365411546e+00, -2.902719537875731e-03, -6.525057884614121e-06,  8.401800273641900e-09,
  1.020564887895179e-10,  1.448279420670898e-13, -1.323321135255000e-15, -6.359356351777535e-18,  7.422307178698002e-21,  1.503697528137549e-22,  2.871810703574688e-25,
 -2.392421117340619e-27,  1.523451891215697e+00, -2.646728589737302e-03, -7.193480218851678e-06,  8.017619027482809e-10,  9.125891201869247e-11,  2.857950228461168e-13,
 -5.701406563378170e-16, -7.180810012205756e-18, -1.435288975324800e-20,  9.355545463378043e-23,  6.409314574751581e-25,  3.427930545796640e-28,  1.599516295883592e+00,
 -2.354921333655802e-03, -7.479752057673472e-06, -6.448814604872488e-09,  6.792172951943588e-11,  3.576599519596694e-13,  2.937472251530227e-16, -5.265761414452550e-18,
 -2.766830733055630e-20, -1.208695850235279e-23,  5.229294989667150e-25,  2.539915744915757e-27,  1.671066711222783e+00, -2.036789629018227e-03, -7.366807603011057e-06,
 -1.251107512149677e-08,  3.644576314154376e-11,  3.446509097094167e-13,  9.780121839251296e-16, -1.553749038558484e-18, -2.599086288563677e-20, -9.627551997843137e-23,
  5.617391611569827e-26,  2.314943576599498e-27,  1.737328780807091e+00, -1.703534821734171e-03, -6.871071550409675e-06, -1.668558872519953e-08,  3.023756814628610e-12,
  2.552566796488841e-13,  1.260870705288828e-15,  2.173081384749927e-18, -1.173161138165595e-20, -1.065207345806952e-22, -3.556410585179227e-25,  2.081519259193827e-28,
  1.797553570420793e+00, -1.367693099484973e-03, -6.044214577093060e-06, -1.853966480984843e-08, -2.572406814831951e-11,  1.207440359123296e-13,  1.085863227351784e-15,
  4.219612730904801e-18,  5.272451429278883e-21, -4.822687170177822e-23, -3.976496716678084e-25, -1.480330511696309e-27,  1.851032676700992e+00, -1.042628382630107e-03,
 -4.971106567511262e-06, -1.800209510284432e-08, -4.439447721054264e-11, -1.486179164003942e-14,  5.880389084452404e-16,  3.911712889507595e-18,  1.461072887688297e-20,
  2.301788389569482e-23, -1.259665746305378e-25, -1.287115464238029e-27,  1.897114043443859e+00, -7.419098601850431e-04, -3.763570473968939e-06, -1.539959222069321e-08,
 -5.027217936331543e-11, -1.104880366198829e-13,  2.701916888022411e-17,  1.930517141131513e-18,  1.256692777434776e-20,  5.233541347483063e-23,  1.357113526292097e-25,
 -2.338684556629009e-29,  1.935217859189995e+00, -4.786067558374144e-04, -2.550134697915873e-06, -1.141783409671131e-08, -4.414066534827358e-11, -1.434723111594879e-13,
 -3.458463934163209e-16, -2.186350350551555e-19,  3.975621972861290e-21,  3.203929180318553e-23,  1.635723564621484e-25,  6.308428026779753e-28,  1.964851825995839e+00,
 -2.645473911200380e-04, -1.462677830583611e-06, -6.985400572130585e-09, -3.008843248621743e-11, -1.179735742929352e-13, -4.161718383417160e-16, -1.265983874526188e-18,
 -2.889047220854303e-21, -1.390409539712616e-24,  3.627500847310521e-26,  2.949288926930819e-28,  1.985625225573936e+00, -1.095993056126554e-04, -6.215155165049678e-07,
 -3.097890168381402e-09, -1.426885829070697e-11, -6.195810532169655e-14, -2.556535327943052e-16, -1.003649825581622e-18, -3.732255933767928e-21, -1.299311885549233e-23,
 -4.127231213343302e-26, -1.123666943609188e-28,  1.997264021468033e+00, -2.101070507906356e-05, -1.208252827782510e-07, -6.163507500665362e-10, -2.940021186436969e-12,
 -1.342129336056511e-14, -5.934884066947687e-17, -2.559919833210145e-19, -1.081615824362667e-21, -4.488359125542987e-24, -1.832106038851375e-26, -7.362259667122307e-29,
  7.520937421191450e-04, -4.641204059104446e-06,  2.147344006271264e-08, -8.827528975676174e-11,  3.400180663656996e-13, -1.256480713769158e-15,  4.510545959327272e-18,
 -1.584775879590626e-20,  5.475411663935133e-23, -1.866332154254528e-25,  6.289773583421542e-28, -2.099345006874162e-30,  6.764898276499643e-03, -4.164720707055328e-05,
  1.917313254415866e-07, -7.815089010643845e-10,  2.971297251312345e-12, -1.077817333949511e-14,  3.772783968174816e-17, -1.282261821584007e-19,  4.244845744548072e-22,
 -1.370598520129701e-24,  4.315329729096601e-27, -1.322829967144817e-29,  1.876942183626592e-02, -1.150004800843924e-04,  5.241353458881282e-07, -2.099711759161545e-09,
  7.771105955353803e-12, -2.710142043987257e-14,  8.973600901581168e-17, -2.822963606640901e-19,  8.391002327531750e-22, -2.324391838890926e-24,  5.817918605743988e-27,
 -1.215340291422758e-29,  3.672328528328115e-02, -2.233866082863549e-04,  1.002684757463281e-06, -3.910660001365108e-09,  1.386686112929225e-11, -4.528669584020232e-14,
  1.356500188658507e-16, -3.642552792647531e-19,  8.217584933415057e-22, -1.216008681326905e-24, -1.255458875242746e-27,  2.081054893304333e-29,  6.056239972396746e-02,
 -3.648418517553512e-04,  1.603937532692647e-06, -6.026663223172903e-09,  2.007814959647711e-11, -5.911125114751435e-14,  1.472528337964783e-16, -2.642019343980599e-19,
  1.939926693432153e-23,  2.745326304160379e-24, -1.680999405797367e-26,  7.117337031005223e-29,  9.020034276462240e-02, -5.367633199643028e-04,  2.297687035748614e-06,
 -8.217002578772677e-09,  2.506017686566665e-11, -6.231445654931444e-14,  1.017742189073084e-16,  7.185794835790696e-20, -1.536286201670962e-21,  8.225443325478422e-24,
 -3.090557754674082e-26,  8.644281992344637e-29,  1.255275281377901e-01, -7.359237412376294e-04,  3.047872700369344e-06, -1.022392667478151e-08,  2.747727169791943e-11,
 -4.997437397529884e-14, -9.663886092662428e-18,  6.024844614789092e-19, -3.309043039849908e-21,  1.181821395723863e-23, -2.779293297881153e-26,  1.258357329751390e-29,
  1.664101708034176e-01, -9.584918777740821e-04,  3.813729528810829e-06, -1.178164766519367e-08,  2.619147736581492e-11, -1.980050327590985e-14, -1.760842023788850e-16,
  1.179797099562040e-18, -4.367455107090099e-21,  9.520548925635739e-24,  3.254348617498273e-27, -1.477057260223350e-28,  2.126890514646788e-01, -1.200059918511590e-03,
  4.551179240522916e-06, -1.263757849389000e-08,  2.044804401840770e-11,  2.688884082879433e-14, -3.650925956149257e-16,  1.576834772414955e-18, -3.731711424800002e-21,
 -8.147895543362308e-25,  5.600815521111311e-26, -3.002251590125025e-28,  2.641780872373525e-01, -1.455679468347780e-03,  5.214461534179288e-06, -1.257481777205682e-08,
  1.003709149872375e-11,  8.472545202712512e-14, -5.269751695957921e-16,  1.552773285391476e-18, -8.640587311346893e-22, -1.718666555223591e-23,  1.028503224523163e-25,
 -2.923546854841067e-28,  3.206627192520946e-01, -1.719908034771500e-03,  5.757996502519007e-06, -1.143462507802194e-08, -4.590718009403303e-12,  1.445635287047938e-13,
 -6.046319786463579e-16,  9.427728149938894e-19,  3.882008496803751e-21, -3.275425840259629e-23,  1.045494478228966e-25, -1.959172325064364e-29,  3.818981335703043e-01,
 -1.986868177207408e-03,  6.138458017649187e-06, -9.137348336729701e-09, -2.227639016943979e-11,  1.945607951362633e-13, -5.481285392164384e-16, -2.528631810586816e-19,
  9.080298290322262e-21, -3.780967249831288e-23,  3.369515862136996e-26,  4.504389138342198e-28,  4.476073393158617e-01, -2.250321707317383e-03,  6.317022148570819e-06,
 -5.699989300633088e-09, -4.119192046429168e-11,  2.220436803175952e-13, -3.311349484313590e-16, -1.813073335932953e-18,  1.250175762811543e-20, -2.435557398279286e-23,
 -9.887485446361567e-26,  8.371927405457428e-28,  5.174791377579436e-01, -2.503761476341479e-03,  6.261733753715518e-06, -1.248360389964961e-09, -5.898015506158482e-11,
  2.159785441522982e-13,  3.478446985393041e-17, -3.305653087620908e-18,  1.187701932104534e-20,  8.334258074097071e-24, -2.326377379478361e-25,  7.717702172393814e-28,
  5.911660286287970e-01, -2.740523311212185e-03,  5.949907959199441e-06,  3.978348912641933e-09, -7.299902870908739e-11,  1.696997839665791e-13,  4.927515145155027e-16,
 -4.180770550296230e-18,  5.973494443499950e-21,  5.010610719250948e-23, -2.768433728509843e-25,  6.816128714815162e-29,  6.682821156083911e-01, -2.953920502020300e-03,
  5.370451473052355e-06,  9.632741457868998e-09, -8.066031149048180e-11,  8.338402145449181e-14,  9.443470040606179e-16, -3.941805647609193e-18, -4.419602997302383e-21,
  8.135813797630181e-23, -1.617938474192506e-25, -1.019337119341921e-27,  7.484010919628227e-01, -3.137402819968496e-03,  4.525952669201661e-06,  1.527596388130288e-08,
 -7.983548362782218e-11, -3.435165994211995e-14,  1.267044995630389e-15, -2.353625047228214e-18, -1.613243804661080e-20,  8.089672357148569e-23,  1.008841208309999e-25,
 -1.791748657309092e-27,  8.310544099331011e-01, -3.284741261527415e-03,  3.434351510062474e-06,  2.040722384909639e-08, -6.928139232930440e-11, -1.663585520720869e-13,
  1.344364605096112e-15,  3.830779722537196e-19, -2.432372855539204e-20,  3.812834843439276e-23,  3.907663711884649e-25, -1.495668672708042e-27,  9.157297635055833e-01,
 -3.390238463377622e-03,  2.129964915438367e-06,  2.450613680839538e-08, -4.901873571075693e-11, -2.888564956238664e-13,  1.103219823112439e-15,  3.577583253345909e-18,
 -2.432070304659968e-20, -3.638787466877870e-23,  5.215670997958289e-25,  4.249862599487191e-29,  1.001870043089339e+00, -3.448962903860187e-03,  6.636167104081474e-07,
  2.708632974830738e-08, -2.058170596303638e-11, -3.754679818955209e-13,  5.482915239379054e-16,  6.183702224459638e-18, -1.404888890887768e-20, -1.097895776468038e-22,
  3.541369904735670e-25,  2.009528387753092e-27,  1.088872951181465e+00, -3.457002505526250e-03, -8.983869941498205e-07,  2.775659613023584e-08,  1.294652461579617e-11,
 -4.029939183981151e-13, -2.197038567406671e-16,  7.132768751289716e-18,  4.075879041605124e-21, -1.400539028381954e-22, -8.000967178849958e-26,  2.932332552829472e-27,
  1.176091498263723e+00, -3.411730029057165e-03, -2.476674534659935e-06,  2.628341622925090e-08,  4.718338579902982e-11, -3.578824642256113e-13, -1.014060768467724e-15,
  5.782370527999293e-18,  2.310430614784879e-20, -1.002441008503584e-22, -5.435326123036694e-25,  1.772530129420782e-27,  1.262835624803048e+00, -3.312068734010494e-03,
 -3.982790422590127e-06,  2.264616846235674e-08,  7.701403510485867e-11, -2.417286758886787e-13, -1.606173455226999e-15,  2.304679331930144e-18,  3.409562924305808e-20,
 -8.055540892651757e-25, -7.151351382471672e-25, -9.617725158850072e-28,  1.348375213921137e+00, -3.158742343604782e-03, -5.324794731298791e-06,  1.707442200845933e-08,
  9.744406375188019e-11, -7.382395212617837e-14, -1.797334628070391e-15, -2.202543676697938e-18,  3.062031727582647e-20,  1.075300910328463e-22, -4.249023587476942e-25,
 -3.227881624022074e-27,  1.431944764336150e+00, -2.954488746545646e-03, -6.414349025789230e-06,  1.005609096083162e-08,  1.046211877435000e-10,  1.109634060052579e-13,
 -1.497229560279094e-15, -6.033229739322608e-18,  1.301529954316174e-20,  1.595634763886762e-22,  1.679429142967152e-25, -3.017986455546455e-27,  1.512749977716803e+00,
 -2.704212695257553e-03, -7.174912192968474e-06,  2.306818981829801e-09,  9.682143826611183e-11,  2.696502843347655e-13, -7.770917167459135e-16, -7.581248356236451e-18,
 -1.052151909071475e-20,  1.193023236491537e-22,  6.414200974081868e-25, -3.422942463068440e-28,  1.589976471207653e+00, -2.415049872632246e-03, -7.550380191855865e-06,
 -5.304510227593618e-09,  7.513296691736018e-11,  3.628402886026201e-13,  1.338751342769662e-16, -6.153854413458674e-18, -2.770011281347428e-20,  1.105023234721361e-23,
  6.332710062803554e-25,  2.448888965804483e-27,  1.662800747639546e+00, -2.096314176125917e-03, -7.513210155059178e-06, -1.187153996116412e-08,  4.356948112277903e-11,
  3.675039775793201e-13,  9.223465506055073e-16, -2.440269565498574e-18, -2.939043676588339e-20, -9.184300313357200e-23,  1.691113801610435e-25,  2.816808842434948e-27,
  1.730403437956839e+00, -1.759303081162706e-03, -7.070834484543478e-06, -1.659470349383598e-08,  8.436193293411364e-12,  2.862016695338457e-13,  1.315865299021210e-15,
  1.733593977304407e-18, -1.581902586314848e-20, -1.204312736831876e-22, -3.364114314534599e-25,  6.853034985184633e-28,  1.791984671950856e+00, -1.416943524028005e-03,
 -6.269075677064290e-06, -1.893047439675659e-08, -2.303891885969319e-11,  1.482398912902324e-13,  1.206090810376773e-15,  4.357354593558715e-18,  3.234186355776633e-21,
 -6.544470416654078e-23, -4.633377322962895e-25, -1.493042833510941e-27,  1.846781240235407e+00, -1.083273428452216e-03, -5.191400799403438e-06, -1.871397962267462e-08,
 -4.454143578181090e-11,  6.190381480516709e-16,  7.042294479184896e-16,  4.391425982209884e-18,  1.533421942682470e-20,  1.675721795102501e-23, -1.893427353657561e-25,
 -1.599524800727094e-27,  1.894084996980995e+00, -7.727714460544410e-04, -3.953264465577245e-06, -1.622157072463004e-08, -5.247083470797716e-11, -1.091437025491440e-13,
  8.699431747158222e-17,  2.363847214191888e-18,  1.454808329451990e-20,  5.770042131361208e-23,  1.313824937108050e-25, -1.823844719323132e-28,  1.933261745014851e+00,
 -4.995681167355161e-04, -2.691482368564193e-06, -1.214749310443087e-08, -4.709353158234948e-11, -1.518305978509403e-13, -3.500043745274508e-16, -7.164198380315684e-20,
  5.253717911688953e-21,  3.916149405588796e-23,  1.931375358035240e-25,  7.131233123339125e-28,  1.963769690900734e+00, -2.765924799520467e-04, -1.549470780821038e-06,
 -7.486246192479336e-09, -3.255071061292046e-11, -1.283975513735475e-13, -4.529190543224827e-16, -1.358927411135555e-18, -2.909638222615232e-21,  3.443785938571248e-25,
  5.109980377125473e-26,  3.822360147411471e-28,  1.985176643057376e+00, -1.147241059928916e-04, -6.601020078552368e-07, -3.336448373291758e-09, -1.557172514753939e-11,
 -6.844495612491168e-14, -2.855004258331062e-16, -1.130894520620032e-18, -4.230942490281626e-21, -1.474581398442842e-23, -4.643335931812361e-26, -1.220902085454113e-28,
  1.997177997444022e+00, -2.200771277861655e-05, -1.285128493885969e-07, -6.656183962476930e-10, -3.223292230957845e-12, -1.493574448495562e-14, -6.702651743101086e-17,
 -2.933370147371392e-19, -1.257207705632073e-21, -5.290326194046531e-24, -2.189015983143891e-26, -8.913001588579612e-29,  7.338659200978994e-04, -4.473563139969190e-06,
  2.044596769145054e-08, -8.303030324359866e-11,  3.159360379222837e-13, -1.153360505747214e-15,  4.090362098911653e-18, -1.419844706372835e-20,  4.846678645001958e-23,
 -1.632274865653275e-25,  5.435414813195094e-28, -1.792687171919520e-30,  6.601318874522072e-03, -4.015007677056285e-05,  1.826315056627379e-07, -7.356446493451476e-10,
  2.764505392613156e-12, -9.914298676228590e-15,  3.432048907308923e-17, -1.153999322342036e-19,  3.781147023473371e-22, -1.209090759743384e-24,  3.772832898117218e-27,
 -1.147371218836271e-29,  1.831764943410396e-02, -1.109061101879470e-04,  4.996673158435027e-07, -1.979595909237986e-09,  7.249989299342886e-12, -2.503964935267216e-14,
  8.219536243676187e-17, -2.567401215375535e-19,  7.594841391089313e-22, -2.102151053024747e-24,  5.299654984206792e-27, -1.139424218661282e-29,  3.584548983164210e-02,
 -2.155491378240386e-04,  9.570587305342861e-07, -3.695862621777284e-09,  1.299287227029423e-11, -4.215055443576770e-14,  1.258123786231499e-16, -3.386674232420762e-19,
  7.772847722460749e-22, -1.249452184586229e-24, -4.527826826985459e-28,  1.585513416098233e-29,  5.912824488417094e-02, -3.522942586858860e-04,  1.533506678079126e-06,
 -5.714681124932844e-09,  1.893066677728398e-11, -5.566579800979466e-14,  1.398778374842268e-16, -2.621236969724109e-19,  1.068523412861610e-22,  2.132264612471297e-24,
 -1.392181506886370e-26,  6.036195362263455e-29,  8.808943748446073e-02, -5.187695172867279e-04,  2.201448085771479e-06, -7.825876760823678e-09,  2.383844894151979e-11,
 -5.985302097286561e-14,  1.031408427920371e-16,  2.720337219418832e-20, -1.261524156355958e-21,  7.063248002215193e-24, -2.725542384369166e-26,  7.941434923658462e-29,
  1.226318325686724e-01, -7.120241103124645e-04,  2.927790389612327e-06, -9.792293303819859e-09,  2.647677112148692e-11, -5.001545248095666e-14,  5.785665416705111e-18,
  5.031891285351973e-19, -2.903429963739823e-21,  1.072133466050332e-23, -2.696575136149484e-26,  2.430840694350560e-29,  1.626363375755943e-01, -9.285404680836095e-04,
  3.674850356557559e-06, -1.136597077006329e-08,  2.575580259872264e-11, -2.364558773778309e-14, -1.449548694762437e-16,  1.045535452831246e-18, -4.023837247897261e-21,
  9.531767981023400e-24, -2.432223876262467e-27, -1.118365496714811e-28,  2.079606781046429e-01, -1.164251488635626e-03,  4.401507555737576e-06, -1.230656888731105e-08,
  2.090170507434210e-11,  1.864292887839848e-14, -3.226145016983035e-16,  1.457357967266674e-18, -3.723789914421746e-21,  1.173576207753120e-24,  4.370972128527389e-26,
 -2.591103367356192e-28,  2.584378490808558e-01, -1.414564512847226e-03,  5.064581014793700e-06, -1.240134069223233e-08,  1.160862971622373e-11,  7.259611141223551e-14,
 -4.839721148189506e-16,  1.515992770690685e-18, -1.411819535695742e-21, -1.332900828645481e-23,  9.007289152832618e-26, -2.868649915026408e-28,  3.138743445460154e-01,
 -1.674393958770733e-03,  5.620433175718787e-06, -1.148572562760513e-08, -1.842352873033209e-12,  1.303821094795311e-13, -5.766667276323814e-16,  1.048934815339423e-18,
  2.777733900672147e-21, -2.861001308976844e-23,  1.021911734064789e-25, -8.438970069474312e-29,  3.740481735811881e-01, -1.938204873885448e-03,  6.026797393791621e-06,
 -9.463357444371953e-09, -1.851713421742711e-11,  1.813523350423814e-13, -5.513432925263196e-16,  1.622464478894144e-20,  7.747847276101555e-21, -3.610259349258821e-23,
  5.076635202608290e-26,  3.279397032919253e-28,  4.387066762654260e-01, -2.200069999199021e-03,  6.244812957486692e-06, -6.323981296956984e-09, -3.683440119471118e-11,
  2.135316195683775e-13, -3.764370599597718e-16, -1.427738882403049e-18,  1.156238226423687e-20, -2.760282273683960e-23, -6.422501204205171e-26,  7.360684818541408e-28,
  5.075641625018734e-01, -2.453743241783659e-03,  6.241233942798657e-06, -2.157471639150163e-09, -5.465951022131527e-11,  2.157458339732438e-13, -5.242022280929287e-17,
 -2.922516721124746e-18,  1.201784889615605e-20, -2.804418174170371e-25, -1.978849193585788e-25,  8.010509601859885e-28,  5.802994085792837e-01, -2.692752680604279e-03,
  5.990754214865253e-06,  2.838119574978784e-09, -6.949613622603881e-11,  1.801442721032598e-13,  3.786220548881686e-16, -3.962885024766382e-18,  7.579306860900914e-21,
  3.915725400193998e-23, -2.690782778914734e-25,  2.769669809150011e-28,  6.565530621156211e-01, -2.910516323693763e-03,  5.478359899867931e-06,  8.356711566639408e-09,
 -7.877499907433084e-11,  1.047105811346003e-13,  8.324273863846929e-16, -4.037702223661924e-18, -1.617218454772769e-21,  7.407631952527019e-23, -2.001537916731309e-25,
 -7.253134525824376e-28,  7.359250261866257e-01, -3.100483709195629e-03,  4.701582645578266e-06,  1.399472868302435e-08, -8.022405402403374e-11, -4.789017941022041e-15,
  1.194358646080881e-15, -2.822639579993241e-18, -1.316615575464346e-20,  8.339620348917896e-23,  2.521883750706538e-26, -1.637036591257197e-27,  8.179719185370894e-01,
 -3.256305988704676e-03,  3.672483070732611e-06,  1.927385933671467e-08, -7.228549584215831e-11, -1.340516690572976e-13,  1.344420851610286e-15, -3.704352811356818e-19,
 -2.268619531142493e-20,  5.238065122769345e-23,  3.204918808516611e-25, -1.681975628702716e-27,  9.022047321670265e-01, -3.372036212136205e-03,  2.419146862444601e-06,
  2.367709105866942e-08, -5.452343802444853e-11, -2.612661620837983e-13,  1.192328232023319e-15,  2.782382501950142e-18, -2.525605220149692e-20, -1.563704628099022e-23,
  5.123625881514797e-25, -4.529652300056522e-28,  9.880868592527156e-01, -3.442359990350836e-03,  9.864314892809523e-07,  2.669772045704567e-08, -2.794572867228816e-11,
 -3.602856123114492e-13,  7.145675582847036e-16,  5.673798122425813e-18, -1.772621125455483e-20, -9.398702793404522e-23,  4.325991140266778e-25,  1.544416691218988e-27,
  1.075032680630693e+00, -3.462854377484597e-03, -5.643316921937633e-07,  2.789904311260447e-08,  4.850150782083583e-12, -4.058601368501442e-13, -1.892124701295105e-17,
  7.182161409606880e-18, -9.924529775997995e-22, -1.406628217479730e-22,  4.954759021950513e-26,  2.930138469586856e-27,  1.162406966285315e+00, -3.430269539767722e-03,
 -2.156984266758062e-06,  2.697982337961277e-08,  3.979589343605220e-11, -3.801969815626921e-13, -8.423751650670208e-16,  6.459934954444336e-18,  1.912459923905341e-20,
 -1.202480392415501e-22, -4.524396303388551e-25,  2.351919335557856e-27,  1.249525375401016e+00, -3.342823474404632e-03, -3.703809313790262e-06,  2.383764614208341e-08,
  7.179984331117857e-11, -2.793794027616045e-13, -1.526411730755661e-15,  3.389684378270328e-18,  3.354344672283445e-20, -3.004590531103276e-23, -7.414935238502274e-25,
 -2.225686606831447e-28,  1.335656382738369e+00, -3.200494751948706e-03, -5.110603405226606e-06,  1.861935254021602e-08,  9.553181599144015e-11, -1.175858620316012e-13,
 -1.844730977966290e-15, -1.164311377898122e-18,  3.415169484755633e-20,  8.774599669845816e-23, -5.626398434754705e-25, -2.999495343661143e-27,  1.420024984409053e+00,
 -3.005292233724403e-03, -6.283565543434480e-06,  1.174577520109497e-08,  1.064677033048954e-10,  7.305514214239419e-14, -1.659457892149868e-15, -5.523804965981456e-18,
  1.884696454139342e-20,  1.634580831802700e-22,  2.283797151544613e-26, -3.559381050069503e-27,  1.501818541370006e+00, -2.761474527134972e-03, -7.137761019097497e-06,
  3.898019906563700e-09,  1.020105685252877e-10,  2.484188824033187e-13, -9.933995803820694e-16, -7.844310082041387e-18, -5.770514409089710e-21,  1.444288120906166e-22,
  6.090402710176619e-25, -1.146885932484590e-27,  1.580195092070534e+00, -2.475686542137740e-03, -7.606581674082183e-06, -4.044214117852527e-09,  8.240743033311681e-11,
  3.638859806507548e-13, -5.074657759303386e-17, -7.028797119025032e-18, -2.682095108880594e-20,  3.847084819967740e-23,  7.358027383373028e-25,  2.179738071348586e-27,
  1.654294394812376e+00, -2.156977274088732e-03, -7.651239583951768e-06, -1.111445006889373e-08,  5.113482729225566e-11,  3.887110861724835e-13,  8.403657870177576e-16,
 -3.432108565267061e-18, -3.254385343544320e-20, -8.245741615545309e-23,  3.036046170846420e-25,  3.287920053255565e-27,  1.723251834910154e+00, -1.816663561910058e-03,
 -7.268966558093347e-06, -1.641220082317651e-08,  1.447965318850859e-11,  3.183036254513427e-13,  1.356649106309852e-15,  1.155488440159188e-18, -2.038799699689539e-20,
 -1.331177814533378e-22, -2.935678356347174e-25,  1.282002997137920e-27,  1.786215145391108e+00, -1.468010823052157e-03, -6.498350059393484e-06, -1.927376431022968e-08,
 -1.977472603257831e-11,  1.786595286944205e-13,  1.329165225001976e-15,  4.419447714434550e-18,  5.288672330993009e-22, -8.527687773076370e-23, -5.277107928623694e-25,
 -1.415621929474773e-27,  1.842363644751459e+00, -1.125715014021064e-03, -5.420241032834495e-06, -1.942558242332373e-08, -4.434979146757233e-11,  1.905201420026402e-14,
  8.341385480653486e-16,  4.890167867499705e-18,  1.578329012556577e-20,  7.676556228416233e-24, -2.672008575236863e-25, -1.944039160938102e-27,  1.890929405759498e+00,
 -8.051906342866384e-04, -4.153032117963361e-06, -1.707843015657707e-08, -5.462718876731536e-11, -1.062070252396632e-13,  1.600189787835697e-16,  2.863616402907737e-18,
  1.671742265059063e-20,  6.273529128656292e-23,  1.187578151447861e-25, -4.027339725562851e-28,  1.931219467228614e+00, -5.216960985433168e-04, -2.841874952465618e-06,
 -1.292573923413643e-08, -5.021420316479862e-11, -1.602344195804542e-13, -3.494337495968954e-16,  1.205878456867568e-19,  6.810371404995163e-21,  4.753851105086020e-23,
  2.262987380873864e-25,  7.933949193000007e-28,  1.962637947732027e+00, -2.893566388755452e-04, -1.642517294667103e-06, -8.028204902939198e-09, -3.523049853342021e-11,
 -1.397347031325311e-13, -4.922676641510385e-16, -1.451408293463409e-18, -2.856121006971453e-21,  2.755221867140585e-24,  7.023999752573439e-26,  4.918294307749116e-28,
  1.984706925311382e+00, -1.201694135965753e-04, -7.016806836671376e-07, -3.596930508961315e-09, -1.701179043784531e-11, -7.569274957573186e-14, -3.191433563237663e-16,
 -1.275147400644583e-18, -4.796542417039766e-21, -1.671319590286973e-23, -5.199718240898853e-26, -1.305071519434450e-28,  1.997087858531911e+00, -2.306866527661679e-05,
 -1.368198547413231e-07, -7.196710703111663e-10, -3.538783037281294e-12, -1.664767041825991e-14, -7.583306493706170e-17, -3.367918653121760e-19, -1.464413454720600e-21,
 -6.249687366987105e-24, -2.621644876002602e-26, -1.081665005859984e-28,  7.162926117689926e-04, -4.313896637503891e-06,  1.947918961003506e-08, -7.815466256983719e-11,
  2.938191958742251e-13, -1.059792520995050e-15,  3.713664360961072e-18, -1.273748225973706e-20,  4.296366594516959e-23, -1.429839827142985e-25,  4.705193426380497e-28,
 -1.533666408234657e-30,  6.443585804598626e-03, -3.872359850728965e-05,  1.740627609772354e-07, -6.929551714475465e-10,  2.574201508672154e-12, -9.128053254736373e-15,
  3.125234483309922e-17, -1.039685312980431e-19,  3.371864389233202e-22, -1.067812828110634e-24,  3.302074937665443e-27, -9.961324090095205e-30,  1.788187195579563e-02,
 -1.070018576435979e-04,  4.765919783687135e-07, -1.867497637230612e-09,  6.768354814436711e-12, -2.315054752760917e-14,  7.533579716823323e-17, -2.336075214520561e-19,
  6.875037509745835e-22, -1.899958272673250e-24,  4.815807436961042e-27, -1.059518843337892e-29,  3.499833024059187e-02, -2.080665983431156e-04,  9.139283981876151e-07,
 -3.494559868900640e-09,  1.217930240391231e-11, -3.924208059564312e-14,  1.166711349268528e-16, -3.145162009512235e-19,  7.321352804221817e-22, -1.254843090360016e-24,
  1.543832711626189e-28,  1.189056595916931e-29,  5.774317679981066e-02, -3.402954442532120e-04,  1.466711693208131e-06, -5.420517071072379e-09,  1.785032928578892e-11,
 -5.239634988374535e-14,  1.325970466149257e-16, -2.575786917461268e-19,  1.742040858471232e-22,  1.625658171907275e-24, -1.147657933862858e-26,  5.101309349029667e-29,
  8.604899685317317e-02, -5.015271807287835e-04,  2.109786988929528e-06, -7.453903385613217e-09,  2.266618141637835e-11, -5.737283448809002e-14,  1.033741395141043e-16,
 -9.300673941081003e-21, -1.026048324450511e-21,  6.040794887776645e-24, -2.391981463604690e-26,  7.219906674645984e-29,  1.198298466263043e-01, -6.890646915438445e-04,
  2.812791666878241e-06, -9.376655287795707e-09,  2.547893909166249e-11, -4.971767452002578e-14,  1.863077696501538e-17,  4.162489338722272e-19, -2.536595608030178e-21,
  9.666669351966950e-24, -2.571003839341922e-26,  3.221309032271766e-29,  1.589801193365407e-01, -8.996802633707891e-04,  3.540915072564149e-06, -1.095784054789669e-08,
  2.525039909451303e-11, -2.678743872309097e-14, -1.174311568212164e-16,  9.222351151064387e-19, -3.683546364675912e-21,  9.345243904543068e-24, -6.677256273402410e-27,
 -8.206932411676546e-29,  2.033731690320118e-01, -1.129624432560576e-03,  4.255846271713327e-06, -1.196956579440417e-08,  2.120037207703940e-11,  1.137643845313182e-14,
 -2.834681050444639e-16,  1.339188506763055e-18, -3.652711836265876e-21,  2.705544404758775e-24,  3.317064669048672e-26, -2.204090802424327e-28,  2.528596864219294e-01,
 -1.374639865217683e-03,  4.916925263275982e-06, -1.220460400361957e-08,  1.294780873154506e-11,  6.148462996508304e-14, -4.422241334010384e-16,  1.463807910184328e-18,
 -1.829822331338414e-21, -9.975036373896777e-24,  7.772461721869449e-26, -2.733261451068511e-28,  3.072658222743256e-01, -1.629982115969534e-03,  5.482511246357578e-06,
 -1.149508395481456e-08,  6.293162599959416e-13,  1.169036707251861e-13, -5.462013874202129e-16,  1.122123666320022e-18,  1.820317810874769e-21, -2.461158490963175e-23,
  9.739078046803284e-26, -1.310404972607988e-28,  3.663910568757511e-01, -1.890449501565622e-03,  5.911576824843478e-06, -9.731333526631735e-09, -1.502223336044449e-11,
  1.681523774755349e-13, -5.476104062290139e-16,  2.437788257786978e-19,  6.487883567653050e-21, -3.381603040629300e-23,  6.278182173509849e-26,  2.208606201014545e-28,
  4.300058189327824e-01, -2.150424744284086e-03,  6.165528384853717e-06, -6.879670382660069e-09, -3.265713968762999e-11,  2.040582850661229e-13, -4.113863651534716e-16,
 -1.074076224233541e-18,  1.052995747164131e-20, -2.955560383282713e-23, -3.420128485483361e-26,  6.280805562692522e-28,  4.978488647523577e-01, -2.403931468912122e-03,
  6.210239066835279e-06, -2.997599866394198e-09, -5.036357830668408e-11,  2.135491773110841e-13, -1.288787044160922e-16, -2.539565770706989e-18,  1.187377490101908e-20,
 -7.490887214657417e-24, -1.626980737487255e-25,  7.928448644422000e-28,  5.696244392996997e-01, -2.644709043253075e-03,  6.018260413345804e-06,  1.755460984429116e-09,
 -6.581122241307523e-11,  1.879283077332189e-13,  2.712540660965686e-16, -3.699842963613855e-18,  8.798637831625992e-21,  2.868871084923942e-23, -2.531762332063691e-25,
  4.379918427518682e-28,  6.449992556582140e-01, -2.866309583118118e-03,  5.571150558699070e-06,  7.114112246611072e-09, -7.649018235971289e-11,  1.233287299772754e-13,
  7.190367581554104e-16, -4.048387809724567e-18,  8.984946432626474e-22,  6.551593316017901e-23, -2.258197950603237e-25, -4.446266870334430e-28,  7.235993494684980e-01,
 -3.062221119294377e-03,  4.861819689400525e-06,  1.271190732694540e-08, -8.003982431731374e-11,  2.288235147277020e-14,  1.109878229056745e-15, -3.195863130984626e-18,
 -1.016256958934570e-20,  8.302263827876513e-23, -4.237097403499587e-26, -1.427804330825281e-27,  8.050068911127612e-01, -3.226020832937548e-03,  3.896747166766234e-06,
  1.809759128171843e-08, -7.464512462141603e-11, -1.019902409310953e-13,  1.324185523322076e-15, -1.063894925470898e-18, -2.058788299932114e-20,  6.368757298157718e-23,
  2.442228811024527e-25, -1.768766623356670e-27,  8.887570716795005e-01, -3.351561754139322e-03,  2.697870374234046e-06,  2.276449310030145e-08, -5.945676572781079e-11,
 -2.318071097289259e-13,  1.258863537857431e-15,  1.969090278071198e-18, -2.545611007742405e-20,  4.325603461116496e-24,  4.825978643657750e-25, -8.881630829024441e-28,
  9.743352197766704e-01, -3.433195190409817e-03,  1.303886719368005e-06,  2.619392771893572e-08, -3.496742061968486e-11, -3.412966965810727e-13,  8.650084413486129e-16,
  5.055886439126017e-18, -2.078326588250692e-20, -7.547510186837276e-23,  4.891769875090454e-25,  1.020467377216017e-27,  1.061174355190282e+00, -3.466029174440450e-03,
 -2.293453214445516e-07,  2.791175147978844e-08, -3.255342244662993e-12, -4.039092883770704e-13,  1.809775648184195e-16,  7.070013882151072e-18, -5.989876259461164e-21,
 -1.361383255355384e-22,  1.755105495757322e-25,  2.770164760255470e-27,  1.148653441355650e+00, -3.446220142622370e-03, -1.829660297716674e-06,  2.755469039066416e-08,
  3.200477488627659e-11, -3.981784124586013e-13, -6.536036341666420e-16,  6.999377747533370e-18,  1.449619722410886e-20, -1.361301488194342e-22, -3.382958836567762e-25,
  2.814083933897683e-27,  1.236096659210663e+00, -3.371290649762184e-03, -3.411055519702712e-06,  2.493978692691034e-08,  6.585422611737329e-11, -3.147542615694612e-13,
 -1.416676567204733e-15,  4.440038603993975e-18,  3.192767056069110e-20, -5.966894651166570e-23, -7.338307904879199e-25,  5.767585728021855e-28,  1.322774085575716e+00,
 -3.240460060019591e-03, -4.878085544080660e-06,  2.012663350229235e-08,  9.273537268481746e-11, -1.621243643828119e-13, -1.861589287490814e-15, -2.551073074628621e-20,
  3.687464100547677e-20,  6.271328968260464e-23, -6.858481394728041e-25, -2.567497206257466e-27,  1.407904212116355e+00, -3.054967904917894e-03, -6.132354275242046e-06,
  1.345873205274349e-08,  1.075183835472083e-10,  3.144574072401679e-14, -1.804796912951845e-15, -4.826688301309894e-18,  2.470894628320331e-20,  1.611087851668445e-22,
 -1.432470229229967e-25, -3.962784528551887e-27,  1.490658774993509e+00, -2.818361394649038e-03, -7.081032210110082e-06,  5.568565641017266e-09,  1.067226525299306e-10,
  2.219257077609348e-13, -1.214810929560669e-15, -7.941187758407396e-18, -1.470628422583523e-22,  1.675239224706566e-22,  5.392273072374527e-25, -2.036887769170155e-27,
  1.570170365607650e+00, -2.536710350649471e-03, -7.646961366784336e-06, -2.667608289749667e-09,  8.965653441032048e-11,  3.602108896950219e-13, -2.593189283079311e-16,
 -7.859047482089111e-18, -2.488421118171495e-20,  6.969701713216553e-23,  8.220484444256058e-25,  1.704777197857461e-27,  1.645543241607984e+00, -2.218706177901133e-03,
 -7.779444036784007e-06, -1.023303804653794e-08,  5.910233329163589e-11,  4.076063460891024e-13,  7.292592277479720e-16, -4.518373035706726e-18, -3.525772489043467e-20,
 -6.729653414935723e-23,  4.573152598075497e-25,  3.681877866277586e-27,  1.715867636082927e+00, -1.875598646184582e-03, -7.464307083648425e-06, -1.612781910524570e-08,
  2.117354204391421e-11,  3.511732190154315e-13,  1.379133066042446e-15,  4.242526156317284e-19, -2.537618694587633e-20, -1.435303034483090e-22, -2.218528855100844e-25,
  1.996492551172623e-27,  1.780237656470840e+00, -1.520927859907616e-03, -6.731409960173232e-06, -1.955979910093973e-08, -1.587251519117793e-11,  2.120433556401361e-13,
  1.452655437386391e-15,  4.383058953354480e-18, -2.935637006790858e-21, -1.075823384128842e-22, -5.861124551822527e-25, -1.215999231284279e-27,  1.837772567511635e+00,
 -1.170021397122147e-03, -5.657589374484220e-06, -2.013099546415780e-08, -4.375717127186797e-11,  4.077168547793328e-14,  9.781600008662126e-16,  5.397418391650877e-18,
  1.584567897781021e-20, -4.828762738434461e-24, -3.607274146184788e-25, -2.309275303848994e-27,  1.887640875559971e+00, -8.392496744123463e-04, -4.363286833515007e-06,
 -1.796922125990765e-08, -5.670610864818273e-11, -1.013418257772351e-13,  2.480354793117223e-16,  3.435586859717794e-18,  1.905639960553428e-20,  6.705003682461429e-23,
  9.482374286995187e-26, -6.989658631322331e-28,  1.929086210871936e+00, -5.450654384186904e-04, -3.001911613255408e-06, -1.375525804158555e-08, -5.350234794751553e-11,
 -1.685540402549139e-13, -3.427361075768985e-16,  3.677185524323158e-19,  8.693307514294413e-21,  5.731060975762101e-23,  2.628277061600934e-25,  8.648395599043901e-28,
  1.961453616942360e+00, -3.028919304004140e-04, -1.742332223802624e-06, -8.614906350851303e-09, -3.814668154164885e-11, -1.520470158666998e-13, -5.341676051852561e-16,
 -1.540630335846528e-18, -2.700801637291255e-21,  6.035736205459700e-24,  9.478130482460999e-26,  6.286133837337330e-28,  1.984214740711642e+00, -1.259602567556646e-04,
 -7.465283208691015e-07, -3.881658617545663e-09, -1.860522391930512e-11, -8.379855453128009e-14, -3.570897139443619e-16, -1.438676330822068e-18, -5.437057615821713e-21,
 -1.890989361103145e-23, -5.788061829438321e-26, -1.363708109472990e-28,  1.996993338665044e+00, -2.419875683813976e-05, -1.458069475339046e-07, -7.790574167539874e-10,
 -3.890728501437317e-12, -1.858633672565532e-14, -8.595461645732443e-17, -3.874650010982810e-19, -1.709484010944661e-21, -7.400074927228485e-24, -3.147342535887915e-26,
 -1.315927099571654e-28,  6.993428632400407e-04, -4.161736205619033e-06,  1.856885620072600e-08, -7.361839814633052e-11,  2.734865194757892e-13, -9.747936432999094e-16,
  3.375513903692891e-18, -1.144149923479411e-20,  3.813936994696639e-23, -1.254456614695085e-25,  4.079925695625516e-28, -1.314454031364187e-30,  6.291424720680471e-03,
 -3.736367169958840e-05,  1.659885271068555e-07, -6.531886510624100e-10,  2.398911359572531e-12, -8.411745768202226e-15,  2.848668337788542e-17, -9.376896663745838e-20,
  3.010206904254180e-22, -9.440977987318160e-25,  2.893174724322426e-27, -8.656757401953729e-30,  1.746135062049999e-02, -1.032769552721754e-04,  4.548168016705004e-07,
 -1.762811989938405e-09,  6.322907217994713e-12, -2.141855640254212e-14,  6.909276552441052e-17, -2.126654969783575e-19,  6.224624491888998e-22, -1.716411863468294e-24,
  4.367395355389840e-27, -9.787893785847822e-30,  3.418042571447859e-02, -2.009196559352664e-04,  8.731374777695611e-07, -3.305820571271793e-09,  1.142176204688719e-11,
 -3.654504507400875e-14,  1.081859008239459e-16, -2.918085062519978e-19,  6.871891321868555e-22, -1.239186330069497e-24,  6.054792242114891e-28,  8.733635995580797e-30,
  5.640505720151619e-02, -3.288171587686083e-04,  1.403345091794295e-06, -5.143124752086220e-09,  1.683364486463199e-11, -4.929988626922693e-14,  1.254710777626448e-16,
 -2.511521395181338e-19,  2.249830504400831e-22,  1.209029229376394e-24, -9.413446422188642e-27,  4.296782981157584e-29,  8.407608681536448e-02, -4.850005933101361e-04,
  2.022478671902616e-06, -7.100289489374583e-09,  2.154349508051946e-11, -5.489849586647857e-14,  1.026854625966805e-16, -3.883329631311883e-20, -8.250556247247478e-22,
  5.145425817733844e-24, -2.090057452477824e-26,  6.507124826255517e-29,  1.171178895854975e-01, -6.670055827852077e-04,  2.702685057047774e-06, -8.976918994001173e-09,
  2.448995497530829e-11, -4.913953403432839e-14,  2.920026977870704e-17,  3.404502688081890e-19, -2.206749870837110e-21,  8.668255054758984e-24, -2.417491062886523e-26,
  3.713472185118611e-29,  1.554372297696070e-01, -8.718720926971759e-04,  3.411826871984655e-06, -1.055826473880552e-08,  2.468849094542743e-11, -2.930892634092731e-14,
 -9.320863207279934e-17,  8.096863387049683e-19, -3.352726168702193e-21,  9.013470866311560e-24, -9.734062167599819e-27, -5.771032586071943e-29,  1.989218633159087e-01,
 -1.096146420090816e-03,  4.114253063245593e-06, -1.162889674074545e-08,  2.136283793231452e-11,  5.010061759196060e-15, -2.475908803283073e-16,  1.224097875356353e-18,
 -3.533668643236576e-21,  3.849120199547338e-24,  2.426712295434252e-26, -1.848572931362760e-28,  2.474388753059049e-01, -1.335886672520872e-03,  4.771751754552962e-06,
 -1.198816437102333e-08,  1.407465192768346e-11,  5.135616264991694e-14, -4.021071139928536e-16,  1.400084793738050e-18, -2.135812928940293e-21, -7.101314765087557e-24,
  6.609973227159312e-26, -2.543756410486135e-28,  3.008327408341772e-01, -1.586673445734839e-03,  5.344705531980185e-06, -1.146701176313081e-08,  2.838876958983322e-12,
  1.041776611579753e-13, -5.140943283459112e-16,  1.166937510467899e-18,  1.002937659306706e-21, -2.084148742106225e-23,  9.088694968941868e-26, -1.622704262554725e-28,
  3.589230990799498e-01, -1.843627826058181e-03,  5.793467362910213e-06, -9.945496235354292e-09, -1.178994288128661e-11,  1.551139905095146e-13, -5.380574823768911e-16,
  4.324150560213150e-19,  5.317795014702000e-21, -3.113832652391005e-23,  7.044158330194875e-26,  1.299936215059579e-28,  4.215022334189969e-01, -2.101439317490318e-03,
  6.079970169306480e-06, -7.370081292713466e-09, -2.867695013709701e-11,  1.938612077428202e-13, -4.369046122186824e-16, -7.543535142711865e-19,  9.447698601834279e-21,
 -3.040303554560755e-23, -8.961442039977270e-27,  5.195333185013062e-28,  4.883322559710092e-01, -2.354406816678342e-03,  6.169573298786999e-06, -3.769440716586433e-09,
 -4.612906470309577e-11,  2.096454374737527e-13, -1.947161976799480e-16, -2.165108031444281e-18,  1.149528742464681e-20, -1.331029515973383e-23, -1.285464146670881e-25,
  7.553386223380459e-28,  5.591420038161191e-01, -2.596496310694964e-03,  6.033133151430501e-06,  7.328690318016015e-10, -6.199577829922292e-11,  1.932279593567172e-13,
  1.717418109505521e-16, -3.403676403846124e-18,  9.654131553740645e-21,  1.898406965310761e-23, -2.312225397378709e-25,  5.524599707690159e-28,  6.336236672895729e-01,
 -2.821419513229952e-03,  5.649261177218631e-06,  5.910901094676112e-09, -7.386019487252192e-11,  1.392307189585083e-13,  6.064263695498445e-16, -3.983675730848703e-18,
  3.090470906973818e-21,  5.616919039768962e-23, -2.396568603614397e-25, -1.893154823266179e-28,  7.114291895335288e-01, -3.022738117029244e-03,  5.006698460021597e-06,
  1.143634754479080e-08, -7.932323298159450e-11,  4.841161811048274e-14,  1.016287525270962e-15, -3.473690149703211e-18, -7.218767577091577e-21,  8.014143580168120e-23,
 -9.990418620058814e-26, -1.183020137566432e-27,  7.921665022985646e-01, -3.193998618558087e-03,  4.106690579146062e-06,  1.688866614726697e-08, -7.636991335128225e-11,
 -7.063952071810450e-14,  1.285530329166049e-15, -1.684290368209383e-18, -1.813809960038035e-20,  7.189534079602969e-23,  1.662102560761312e-25, -1.762814486929797e-27,
  8.753956974080072e-01, -3.328902609312277e-03,  2.965188813914933e-06,  2.177775436195458e-08, -6.378678941111022e-11, -2.010245447115403e-13,  1.302643224615798e-15,
  1.160628768510299e-18, -2.496335589985005e-20,  2.273713665756870e-23,  4.353931795189596e-25, -1.242964823333074e-27,  9.606252778391156e-01, -3.421516810472037e-03,
  1.614635505783086e-06,  2.558101623772731e-08, -4.157468432816393e-11, -3.189152420240605e-13,  9.968812731019146e-16,  4.351202943871495e-18, -2.313880262124388e-20,
 -5.517069098501064e-23,  5.220505176843054e-25,  4.727782021025523e-28,  1.047308688203340e+00, -3.466525670470569e-03,  1.050175506179452e-07,  2.779534337185970e-08,
 -1.127418956551100e-11, -3.972164357922899e-13,  3.755287270178874e-16,  6.801510933315024e-18, -1.073582281532122e-20, -1.267600108430289e-22,  2.911831763552174e-25,
  2.465459877661519e-27,  1.134841391862183e+00, -3.459526705000655e-03, -1.496196929003880e-06,  2.800227346199319e-08,  2.390046772259985e-11, -4.114653059946024e-13,
 -4.518806824323471e-16,  7.382482064333591e-18,  9.382743436034228e-21, -1.470819713015714e-22, -2.070209137977761e-25,  3.125995450072530e-27,  1.222558839789508e+00,
 -3.397364562008175e-03, -3.105669672292029e-06,  2.594129083555160e-08,  5.922979602616986e-11, -3.471493816321226e-13, -1.278414850363564e-15,  5.421753536295272e-18,
  2.925952460083273e-20, -8.827552546515617e-23, -6.906046374431902e-25,  1.385053589387547e-27,  1.309735760856708e+00, -3.278493704134551e-03, -4.627778206543300e-06,
  2.158203423538697e-08,  8.904674336896054e-11, -2.066758486804389e-13, -1.845483324711432e-15,  1.185094892869450e-18,  3.861281609144937e-20,  3.319101173893659e-23,
 -7.856960744026122e-25, -1.940493306672663e-27,  1.395587287022461e+00, -3.103351442695050e-03, -5.960514716595200e-06,  1.518165977840937e-08,  1.077036845042979e-10,
 -1.339649385997080e-14, -1.928012541203147e-15, -3.944655255464109e-18,  3.036296344254764e-20,  1.518133072882102e-22, -3.230904903321538e-25, -4.176768324562771e-27,
  1.479272497523355e+00, -2.874713005957582e-03, -7.003822914599826e-06,  7.309976544400980e-09,  1.108516228740893e-10,  1.901071912918588e-13, -1.436294847570917e-15,
 -7.845428707265803e-18,  6.247969316537963e-21,  1.870286596419320e-22,  4.292590221232468e-25, -2.962714762149502e-27,  1.559901005231698e+00, -2.597989155258607e-03,
 -7.670129203391160e-06, -1.175884553769137e-09,  9.678023698119731e-11,  3.512591628801584e-13, -4.900971424302469e-16, -8.608714816612605e-18, -2.176685732264943e-20,
  1.038902328937606e-22,  8.825304141486608e-25,  1.007001468742683e-27,  1.636543191600549e+00, -2.281416214670021e-03, -7.896294691880575e-06, -9.221278080468593e-09,
  6.741856684763428e-11,  4.234607979022625e-13,  5.866121464862527e-16, -5.681530170952457e-18, -3.731126417274434e-20, -4.567527638504493e-23,  6.256587476993038e-25,
  3.943284865095282e-27,  1.708244595719724e+00, -1.936080933486944e-03, -7.655570646165578e-06, -1.573105400168048e-08,  2.852846586610242e-11,  3.843183700717471e-13,
  1.378855673981174e-15, -4.719858191807975e-19, -3.067972135100629e-20, -1.504133189394794e-22, -1.163308396391340e-25,  2.815315206638524e-27,  1.774044750272758e+00,
 -1.575721992450960e-03, -6.967505112762449e-06, -1.977789665610359e-08, -1.127314064000432e-11,  2.483654357962365e-13,  1.573450847042230e-15,  4.222526998839294e-18,
 -7.242676535839298e-21, -1.320044468177925e-22, -6.323951975322716e-25, -8.587388223373249e-28,  1.833000413827206e+00, -1.216260231331672e-03, -5.903330824563284e-06,
 -2.082325880298486e-08, -4.269444275355713e-11,  6.611809082448955e-14,  1.136339409172961e-15,  5.898708676434016e-18,  1.538664169493779e-20, -2.139871803034403e-23,
 -4.704454877162919e-25, -2.676112721018141e-27,  1.884212676636786e+00, -8.750340675331981e-04, -4.584427020553571e-06, -1.889237627681016e-08, -5.866525905699862e-11,
 -9.416345422745775e-14,  3.531368932625000e-16,  4.084678084521528e-18,  2.153010074493339e-20,  7.012093223377427e-23,  5.589792219369951e-26, -1.086835161165715e-27,
  1.926856852246520e+00, -5.697557954354091e-04, -3.172223617559999e-06, -1.463870709169717e-08, -5.695468061229794e-11, -1.766227376176034e-13, -3.282203189104282e-16,
  6.810198302984730e-19,  1.095505628765844e-20,  6.860203750005928e-23,  3.021280287976329e-25,  9.173837298997988e-28,  1.960213502213477e+00, -3.172547153035074e-04,
 -1.849475829286968e-06, -9.250292172278652e-09, -4.131936575469150e-11, -1.653942279589921e-13, -5.784770045825769e-16, -1.622790806549438e-18, -2.408180225130617e-21,
  1.042750815907676e-23,  1.260421533627408e-25,  7.982615374713390e-28,  1.983698652909197e+00, -1.321239940256953e-04, -7.949511794610820e-07, -4.193229672093193e-09,
 -2.037026379529446e-11, -9.287240859936953e-14, -3.999140473788420e-16, -1.624012905105858e-18, -6.160942141851699e-21, -2.134595691132149e-23, -6.393368594788605e-26,
 -1.378590100721093e-28,  1.996894149985940e+00, -2.540369445078297e-05, -1.555417868791440e-07, -8.443987745919504e-10, -4.283996138490645e-12, -2.078587238731354e-14,
 -9.761133474577131e-17, -4.466857075048954e-19, -2.000015676837194e-21, -8.782880244075068e-24, -3.787716818203027e-26, -1.604922710666352e-28,  6.829875282192300e-04,
 -4.016646104410811e-06,  1.771106073144808e-08, -6.939428564174937e-11,  2.547755160688275e-13, -8.974918043447275e-16,  3.071581268643635e-18, -1.029025607056613e-20,
  3.390366474039520e-23, -1.102257450087527e-25,  3.543564400518775e-28, -1.128576846178272e-30,  6.144577112601869e-03, -3.606647658296287e-05,  1.583751249673309e-07,
 -6.161156754888868e-10,  2.237306075262351e-12, -7.758513873098036e-15,  2.599105515173546e-17, -8.465849380560440e-20,  2.690276087339172e-22, -8.356452477854512e-25,
  2.537652246077109e-27, -7.530578832439060e-30,  1.705538828032566e-02, -9.972134798430647e-05,  4.342562070488385e-07, -1.664984331308787e-09,  5.910647422942666e-12,
 -1.982959072261042e-14,  6.340794113699349e-17, -1.937024638301570e-19,  5.637144993879820e-22, -1.550094273646567e-24,  3.954264383144061e-27, -8.994502801487736e-30,
  3.339047036187673e-02, -1.940901834267841e-04,  8.345404498342450e-07, -3.128781245156080e-09,  1.071617660785051e-11, -3.404418727188223e-14,  1.003164543482720e-16,
 -2.705268468795815e-19,  6.430998087379014e-22, -1.208060625901594e-24,  9.326082451834394e-28,  6.233118582566613e-30,  5.511185757707659e-02, -3.178327631555963e-04,
  1.343211610244498e-06, -4.881513177611405e-09,  1.587719495082871e-11, -4.637211627493523e-14,  1.185456562016485e-16, -2.433253825832743e-19,  2.621667190911456e-22,
  8.681953498289201e-25, -7.678443164863324e-27,  3.607371550431050e-29,  8.216791264265208e-02, -4.691558005775518e-04,  1.939307573159303e-06, -6.764243846813083e-09,
  2.047006688739614e-11, -5.244991062774099e-14,  1.012552338899208e-16, -6.242718584833760e-20, -6.541973282664047e-22,  4.364623551266220e-24, -1.818946916824326e-26,
  5.821770653529006e-29,  1.144924372754235e-01, -6.458084076019707e-04,  2.597280764564992e-06, -8.592900861537901e-09,  2.351490446037043e-11, -4.833203412825571e-14,
  3.778985417204268e-17,  2.746438114728670e-19, -1.911696204724644e-21,  7.734857088507680e-24, -2.247588743800485e-26,  3.976615426433698e-29,  1.520035376213462e-01,
 -8.450776044610593e-04,  3.287478073189925e-06, -1.016805236203803e-08,  2.408171732192574e-11, -3.128570533734930e-14, -7.199121770431366e-17,  7.075111182519838e-19,
 -3.035805568111508e-21,  8.579425054838880e-24, -1.182519893585480e-26, -3.806172349698568e-29,  1.946022300992021e-01, -1.063784766361858e-03,  3.976759426906572e-06,
 -1.128660115722704e-08,  2.140632813948356e-11, -5.334658764160376e-16, -2.148771455356638e-16,  1.113409589442885e-18, -3.379499552230460e-21,  4.666816804929628e-24,
  1.685085991231569e-26, -1.528475444788369e-28,  2.421707710467749e-01, -1.298284187348618e-03,  4.629277181330910e-06, -1.175526411482356e-08,  1.500840401388773e-11,
  4.216807879601281e-14, -3.638965030968845e-16,  1.328137197487750e-18, -2.346508209504146e-21, -4.674808104899206e-24,  5.538771400107256e-26, -2.321439955725161e-28,
  2.945706921403374e-01, -1.544465291819068e-03,  5.207440539225162e-06, -1.140558051914873e-08,  4.801710048835388e-12,  9.223444636486647e-14, -4.810786365326332e-16,
  1.187714107942267e-18,  3.163032892078515e-22, -1.735508823110460e-23,  8.329853868959936e-26, -1.807736932756362e-28,  3.516405231736045e-01, -1.797760446602020e-03,
  5.673089688100518e-06, -1.011001426045659e-08, -8.815721094304228e-12,  1.423641154460317e-13, -5.237320743147647e-16,  5.852024083540623e-19,  4.248698650717695e-21,
 -2.822943823393381e-23,  7.445781409054544e-26,  5.514826918586398e-29,  4.131931849174121e-01, -2.053160829233976e-03,  5.988902291321829e-06, -7.798471005065910e-09,
 -2.490612170146497e-11,  1.831551844194282e-13, -4.539587263444954e-16, -4.695656483758199e-19,  8.351961943264653e-21, -3.033544448111019e-23,  1.158095987885471e-26,
  4.152347803800643e-28,  4.790130381039513e-01, -2.305243393635927e-03,  6.120049108952388e-06, -4.474236261758858e-09, -4.198758548505432e-11,  2.042858627493226e-13,
 -2.502680723413118e-16, -1.805853868446046e-18,  1.093142935510204e-20, -1.780349434826002e-23, -9.654338951430360e-26,  6.964362061949130e-28,  5.488525809842982e-01,
 -2.548212635618491e-03,  6.036104153977866e-06, -2.279547636374287e-10, -5.809753774796833e-11,  1.962416057597393e-13,  8.085422068479019e-17, -3.085545366736885e-18,
  1.017715997555820e-20,  1.024533215422875e-23, -2.051943354744265e-25,  6.239392192298351e-28,  6.224287985669186e-01, -2.775961573951713e-03,  5.713195762378004e-06,
  4.752167971471697e-09, -7.093900769985888e-11,  1.524594138625922e-13,  4.965587029057134e-16, -3.854289539771946e-18,  4.938623972734915e-21,  4.648419306860963e-23,
 -2.429786330862570e-25,  3.226113431158668e-29,  6.994191830507245e-01, -2.982157078556614e-03,  5.136355753245093e-06,  1.017621340961166e-08, -7.811909364276423e-11,
  7.161189157653375e-14,  9.162178526174584e-16, -3.659397759244923e-18, -4.417456685647934e-21,  7.518069730396380e-23, -1.462213826664898e-25, -9.208509038989460e-28,
  7.794574689582339e-01, -3.160355307131631e-03,  4.301981822643341e-06,  1.565710435849245e-08, -7.747832511851842e-11, -4.041586808517616e-14,  1.230641702579803e-15,
 -2.222165309847119e-18, -1.544871494578370e-20,  7.701264782918180e-23,  9.028929045319471e-26, -1.675986925506032e-27,  8.621291602180927e-01, -3.304153411071320e-03,
  3.220271186944685e-06,  2.072670988700188e-08, -6.749247650225634e-11, -1.694605297946126e-13,  1.324103618967218e-15,  3.781470664600285e-19, -2.384529399320086e-20,
  3.897500268130427e-23,  3.745936542972084e-25, -1.504641207751370e-27,  9.469669723296512e-01, -3.407383622066624e-03,  1.917410367218416e-06,  2.486613467898578e-08,
 -4.770430881294766e-11, -2.936134474685171e-13,  1.108079110275742e-15,  3.583044258652584e-18, -2.474551684242958e-20, -3.403255422839359e-23,  5.309423333152529e-25,
 -6.411076753203820e-29,  1.033446373127449e+00, -3.464355020432396e-03,  4.372189473911001e-07,  2.755195539732927e-08, -1.911318377480968e-11, -3.859613904534404e-13,
  5.604925814413088e-16,  6.387404078129302e-18, -1.506444368982056e-20, -1.130606481482365e-22,  3.906783803854075e-25,  2.039432641501174e-27,  1.120981482412908e+00,
 -3.470146299283703e-03, -1.158148485039788e-06,  2.831832807265410e-08,  1.557960810501178e-11, -4.198009433452662e-13, -2.417735419429788e-16,  7.596684958265832e-18,
  3.972400895808993e-21, -1.525578354924641e-22, -6.575384664462183e-26,  3.265686441735834e-27,  1.208921684400054e+00, -3.420949165155828e-03, -2.788922494935973e-06,
  2.683181009709392e-08,  5.199281902389578e-11, -3.759069502135748e-13, -1.114012483850831e-15,  6.302013186353511e-18,  2.560115614888022e-20, -1.144512910639303e-22,
 -6.126257734236454e-25,  2.147279559765776e-27,  1.296549415583623e+00, -3.314456101145369e-03, -4.360389472836662e-06,  2.297132128932390e-08,  8.447372367165125e-11,
 -2.504287493335464e-13, -1.794866644044143e-15,  2.433603594476807e-18,  3.922342720175503e-20,  2.788242989721082e-25, -8.541098531156213e-25, -1.144363257190011e-27,
  1.383079708132933e+00, -3.150277582231251e-03, -5.768012328866846e-06,  1.690022564900799e-08,  1.069646736379947e-10, -6.087945472037773e-14, -2.024058537860187e-15,
 -2.888450782455713e-18,  3.555118080899582e-20,  1.352015607390436e-22, -5.073629390665326e-25, -4.157902915348165e-27,  1.467662182823329e+00, -2.930362282333062e-03,
 -6.905342239354965e-06,  9.112072531283869e-09,  1.142914060767495e-10,  1.530289767494657e-13, -1.652133491920679e-15, -7.534722439419751e-18,  1.325619739458119e-20,
  2.013230985033923e-22,  2.789141991725538e-25, -3.860659599403297e-27,  1.549386275037984e+00, -2.659379777770506e-03, -7.674719381646336e-06,  4.280782929513074e-10,
  1.036678811383507e-10,  3.365292955895500e-13, -7.402814522013996e-16, -9.238528654269871e-18, -1.738300597877959e-20,  1.398221906646372e-22,  9.073513470925136e-25,
  8.517963432630674e-29,  1.627290511952931e+00, -2.345010207351008e-03, -8.000196038122624e-06, -8.074118874187235e-09,  7.601498094629035e-11,  4.354942395446655e-13,
  4.106030751031236e-16, -6.896627667477590e-18, -3.846292939293646e-20, -1.714280679461185e-23,  8.014612365255410e-25,  4.010434223667458e-27,  1.700376599035117e+00,
 -1.998072233690684e-03, -7.841345104274351e-06, -1.521131613435933e-08,  3.654409349429877e-11,  4.171363519661132e-13,  1.351076595174802e-15, -1.541015331265386e-18,
 -3.614615429465517e-20, -1.523299687738039e-22,  2.701786634139968e-26,  3.709693479080119e-27,  1.767628875286875e+00, -1.632414047643610e-03, -7.205751418117226e-06,
 -1.991643698739530e-08, -5.918781655045483e-12,  2.875162684612145e-13,  1.687687282219285e-15,  3.909779302503580e-18, -1.245795531854166e-20, -1.579089443513090e-22,
 -6.588172800908140e-25, -3.072866504133169e-28,  1.828039320791324e+00, -1.264497896829759e-03, -6.157260003041507e-06, -2.149425205965696e-08, -4.108569717418600e-11,
  9.542699338445032e-14,  1.308253399772638e-15,  6.374887168022433e-18,  1.424824573800536e-20, -4.267462356077776e-23, -5.958263116883135e-25, -3.015485990204013e-27,
  1.880637731001575e+00, -9.126324146472005e-04, -4.816827947286425e-06, -1.984558576708846e-08, -6.045409893645828e-11, -8.423551864128761e-14,  4.775353546369047e-16,
  4.814360886599559e-18,  2.408193849018937e-20,  7.126292516023366e-23, -2.405652504369171e-27, -1.582364665165518e-27,  1.924525938717149e+00, -5.958520052014744e-04,
 -3.353473689912802e-06, -1.557866239274894e-08, -6.056414896650245e-11, -1.842292217910319e-13, -3.038555349111802e-16,  1.073508360464219e-18,  1.365207378659647e-20,
  8.150313425618364e-23,  3.430693320237952e-25,  9.366367219551447e-28,  1.958914172512435e+00, -3.325060312069609e-04, -1.964557640722847e-06, -9.938635035678618e-09,
 -4.476980868432604e-11, -1.798312583462968e-13, -6.249302261354807e-16, -1.692801143691249e-18, -1.933048316548335e-21,  1.623007488052378e-23,  1.656069688308927e-25,
  1.007176644412887e-27,  1.983157111016107e+00, -1.386905638299469e-04, -8.472885091060362e-07, -4.534550836789642e-09, -2.232749281392851e-11, -1.030390200304471e-13,
 -4.482656225231504e-16, -1.833963708578853e-18, -6.976882590129249e-21, -2.402361576742050e-23, -6.990954431268188e-26, -1.323477913437170e-28,  1.996789980677462e+00,
 -2.668975757708939e-05, -1.660999787303811e-07, -9.164001239781625e-10, -4.724192045016936e-12, -2.328616583650461e-14, -1.110642421571345e-16, -5.160519590503231e-19,
 -2.345262618496225e-21, -1.044916998988655e-23, -4.569742810185399e-26, -1.962325062090451e-28,  6.671991428750031e-04, -3.878220583972327e-06,  1.690220812059697e-08,
 -6.545756653498458e-11,  2.375401395669104e-13, -8.271123553798488e-16,  2.798065354400450e-18, -9.266187395747366e-21,  3.017915070471543e-23, -9.699629061738675e-26,
  3.082658468610390e-28, -9.706709433685415e-31,  6.002799227328210e-03, -3.482845216507152e-05,  1.511915052509820e-07, -5.815270369647012e-10,  2.088186557704587e-12,
 -7.162228111747440e-15,  2.373675518892959e-17, -7.651198146239980e-20,  2.406943556016652e-22, -7.404693466768208e-25,  2.228226873300435e-27, -6.557596457773380e-30,
  1.666332667950785e-02, -9.632563949251383e-05,  4.148309925792759e-07, -1.573505831126299e-09,  5.528844516980638e-12, -1.837089626138178e-14,  5.822864036164032e-17,
 -1.765266876706814e-19,  5.106648738920046e-22, -1.399611361480326e-24,  3.575450270255222e-27, -8.230026100156200e-30,  3.262722853583476e-02, -1.875611774377420e-04,
  7.980017754824818e-07, -2.962641210827589e-09,  1.005876710527016e-11, -3.172520385410281e-14,  9.302332757865536e-17, -2.506357971946969e-19,  6.003415434595307e-22,
 -1.165885425975672e-24,  1.161825821372009e-27,  4.264553245923404e-30,  5.386165292038094e-02, -3.073171338018670e-04,  1.286127551680995e-06, -4.634745312518933e-09,
  1.497765673529671e-11, -4.360780302460199e-14,  1.118542896749277e-16, -2.344922491166412e-19,  2.882592770157122e-22,  5.910016270432744e-25, -6.224093155325522e-27,
  3.018831803142450e-29,  8.032181203545292e-02, -4.539605347078779e-04,  1.860067582457481e-06, -6.444983360545453e-09,  1.944521671867990e-11, -5.004298584005731e-14,
  9.923684092530194e-17, -8.098300571101510e-20, -5.095676101231434e-22,  3.686343697519945e-24, -1.577157358676651e-26,  5.175884635313488e-29,  1.119501160100677e-01,
 -6.254362978048407e-04,  2.496391652388269e-06, -8.224343744186058e-09,  2.255792157869549e-11, -4.733945882697105e-14,  4.466408491375387e-17,  2.177547438228070e-19,
 -1.648998691496811e-21,  6.871191100227443e-24, -2.070085676493098e-26,  4.067341813237640e-29,  1.486750632646479e-01, -8.192593442933376e-04,  3.167752354988206e-06,
 -9.787837932658415e-09,  2.344027442391690e-11, -3.278646625289813e-14, -5.349518380662079e-17,  6.152128191705967e-19, -2.735819224033605e-21,  8.077788108228174e-24,
 -1.314304147500287e-26, -2.245360850637529e-29,  1.904098696196281e-01, -1.032506627860467e-03,  3.843373989229876e-06, -1.094445507949953e-08,  2.134655103855435e-11,
 -5.328472445704315e-15, -1.851895821739135e-16,  1.008071144475181e-18, -3.200903486668596e-21,  5.214951522993911e-24,  1.076221455772522e-26, -1.245164604329561e-28,
  2.370508151761332e-01, -1.261810079214895e-03,  4.489681146747510e-06, -1.150884478966760e-08,  1.576739818691019e-11,  3.387219114392754e-14, -3.277822624509155e-16,
  1.250764273555771e-18, -2.477320674501390e-21, -2.656637497228571e-24,  4.569461478533791e-26, -2.083015702982480e-28,  2.884752852211983e-01, -1.503351793128198e-03,
  5.071093410747175e-06, -1.131461165304591e-08,  6.533637382742208e-12,  8.108822008343857e-14, -4.477703697290709e-16,  1.188466590091395e-18, -2.504513316312402e-22,
 -1.418533149968596e-23,  7.512904742192313e-26, -1.890825497063268e-28,  3.445394793556287e-01, -1.752863195672718e-03,  5.551014971683728e-06, -1.022896465041192e-08,
 -6.092731754069320e-12,  1.300056185893002e-13, -5.055916475665057e-16,  7.054790335204848e-19,  3.286461734705855e-21, -2.522122847442882e-23,  7.551789156325706e-26,
 -4.569150827565447e-30,  4.050757621515640e-01, -2.005630437446837e-03,  5.893048605543269e-06, -8.168260024765851e-09, -2.135288126845750e-11,  1.721315965943112e-13,
 -4.635282252040987e-16, -2.196526933796725e-19,  7.272361424885607e-21, -2.953588662021406e-23,  2.769291384554158e-26,  3.186078527408971e-28,  4.698896295565795e-01,
 -2.256508876416374e-03,  6.062461191862814e-06, -5.113694729454217e-09, -3.796582656285094e-11,  1.977115727613795e-13, -2.960360253964938e-16, -1.466989541516045e-18,
  1.022819029470325e-20, -2.107307486457815e-23, -6.746866612482706e-26,  6.233512193085030e-28,  5.387562688682279e-01, -2.499950247916485e-03,  6.027921115519484e-06,
 -1.126039985267048e-09, -5.416010720167855e-11,  1.971824499336086e-13, -9.372130781431233e-19, -2.755504542273584e-18,  1.040498626686982e-20,  2.599078228641194e-24,
 -1.768739149881020e-25,  6.575994528002886e-28,  6.114166976381041e-01, -2.730046963435796e-03,  5.763514254531126e-06,  3.642148514636076e-09, -6.777928825189152e-11,
  1.631011188303584e-13,  3.910893313628044e-16, -3.671348243506854e-18,  6.437974312058372e-21,  3.685019550157657e-23, -2.373882521223150e-25,  2.152541244558108e-28,
  6.875734799761132e-01, -2.940598906242205e-03,  5.251021919312381e-06,  8.938925468826527e-09, -7.647533513499995e-11,  9.235804744520721e-14,  8.121740886023054e-16,
 -3.758655703722604e-18, -1.825285685368114e-21,  6.859941296532590e-23, -1.809234044894637e-25, -6.575295129246106e-28,  7.668860395591313e-01, -3.125209036760827e-03,
  4.482407619341171e-06,  1.441256724746137e-08, -7.799660609793711e-11, -1.168039418021858e-14,  1.161920987576001e-15, -2.671609762281925e-18, -1.262866102943513e-20,
  7.919000573663556e-23,  1.969014036943742e-26, -1.523649985224633e-27,  8.489656199001854e-01, -3.277414963805362e-03,  3.462406183048746e-06,  1.962144527559098e-08,
 -7.056348434532654e-11, -1.376398135239786e-13,  1.324239828329620e-15, -3.596938167663334e-19, -2.218895744739773e-20,  5.257941699822672e-23,  3.044372582782370e-25,
 -1.668032968104857e-27,  9.333699873386639e-01, -3.390864176978312e-03,  2.211035354669096e-06,  2.405736500921914e-08, -5.330297914681587e-11, -2.659061115583580e-13,
  1.197163320428290e-15,  2.775669296114000e-18, -2.559045954433826e-20, -1.300094051713091e-23,  5.170311137386685e-25, -5.589725011557101e-28,  1.019598034390904e+00,
 -3.459540555395253e-03,  7.657553432066642e-07,  2.718518129776855e-08, -2.668370380914645e-11, -3.704215225888981e-13,  7.320016177622029e-16,  5.843401845517638e-18,
 -1.883303650585386e-20, -9.578533294195453e-23,  4.693255261924708e-25,  1.523516476522129e-27,  1.107084524172093e+00, -3.478048609548996e-03, -8.171107975789161e-07,
  2.850019089245706e-08,  7.142845527649128e-12, -4.230417438695960e-13, -2.811435987284234e-17,  7.635702223932872e-18, -1.532362326102702e-21, -1.523132091269060e-22,
  7.768329615993375e-26,  3.224321317089311e-27,  1.195195323397487e+00, -3.441959056695911e-03, -2.462202099492796e-06,  2.760215902745893e-08,  4.422207166792711e-11,
 -4.004371710065776e-13, -9.267387946319715e-16,  7.050793938676053e-18,  2.106446052583511e-20, -1.368628247901317e-22, -5.031228074101367e-25,  2.809406288030137e-27,
  1.283223602684943e+00, -3.348214012385767e-03, -4.076796934942408e-06,  2.428051747948551e-08,  7.904063228455633e-11, -2.925462546873810e-13, -1.709199642921343e-15,
  3.682237307843708e-18,  3.860876206792634e-20, -3.462845522514608e-23, -8.845273284263352e-25, -2.216865322257200e-28,  1.370387634954572e+00, -3.195581485451330e-03,
 -5.554989811916874e-06,  1.859925521304463e-08,  1.052554424147285e-10, -1.102944775145126e-13, -2.088306501563311e-15, -1.677208182576783e-18,  4.000958534678896e-20,
  1.113112170037764e-22, -6.851059824885689e-25, -3.876498011625925e-27,  1.455830984912188e+00, -2.985136335249096e-03, -6.784931567212011e-06,  1.096299450100828e-08,
  1.169386612260236e-10,  1.109008059058395e-13, -1.856064029150607e-15, -6.992755863381020e-18,  2.066146784337203e-20,  2.088380002982188e-22,  9.102662403710854e-26,
 -4.656305173888863e-27,  1.538626033425179e+00, -2.720728282590108e-03, -7.659411586055374e-06,  2.139554731806107e-09,  1.101995423134056e-10,  3.156004394784700e-13,
 -1.005941232228203e-15, -9.707253933806954e-18, -1.169808011661420e-20,  1.758733402217335e-22,  8.869961527726102e-25, -1.041358335139628e-27,  1.617781884420338e+00,
 -2.409377992193402e-03, -8.089499051286647e-06, -6.787732837512728e-09,  8.480704854170575e-11,  4.428920239872343e-13,  2.002194347375092e-16, -8.130784954491897e-18,
 -3.846077706818525e-20,  1.840954049062864e-23,  9.747750385648552e-25,  3.819863118473879e-27,  1.692257707401851e+00, -2.061522552294932e-03, -8.020091693858392e-06,
 -1.455812410500075e-08,  4.520688694557078e-11,  4.489086531631396e-13,  1.290913695018418e-15, -2.784890244093359e-18, -4.156877158401069e-20, -1.477132058543501e-22,
  2.105470961393014e-25,  4.632195859814232e-27,  1.760982411746002e+00, -1.691017206368477e-03, -7.445119875876845e-06, -1.996289780513017e-08,  2.452002736064170e-13,
  3.292839661621107e-13,  1.790688981282690e-15,  3.415069014873179e-18, -1.861838562531022e-20, -1.843201543836512e-22, -6.560674778494663e-25,  4.724230344955055e-28,
  1.822881163909461e+00, -1.314798719825034e-03, -6.419066578796195e-06, -2.213458733705494e-08, -3.884845861893231e-11,  1.290169682179980e-13,  1.492868175958026e-15,
  6.801385860274030e-18,  1.225019113236723e-20, -6.924763513686699e-23, -7.348019066093395e-25, -3.286136086235807e-27,  1.876908600453511e+00, -9.521361936155173e-04,
 -5.060832019253586e-06, -2.082565889723819e-08, -6.201282176504647e-11, -7.106759831451026e-14,  6.235108720231351e-16,  5.625865456222914e-18,  2.662733762072712e-20,
  6.960167727219512e-23, -8.515548917198182e-26, -2.200219285008022e-27,  1.922087667509958e+00, -6.234443265123598e-04, -3.546354641558932e-06, -1.657755053570238e-08,
 -6.431895702785518e-11, -1.911088821184923e-13, -2.672207284170031e-16,  1.560049398158283e-18,  1.684308792793223e-20,  9.604481377943500e-23,  3.837699292646108e-25,
  9.026096629209462e-28,  1.957551942570337e+00, -3.487120029208338e-04, -2.088240535440316e-06, -1.068455611882111e-08, -4.852029003874565e-11, -1.954047670509860e-13,
 -6.730971889667040e-16, -1.743940787281832e-18, -1.218203725486072e-21,  2.381217025166789e-23,  2.153553592416784e-25,  1.262334813554760e-27,  1.982588438733638e+00,
 -1.456927639265834e-04, -9.039165065052796e-07, -4.908879427037431e-09, -2.450015023986417e-11, -1.144396538799135e-13, -5.028761783389029e-16, -2.071612432827250e-18,
 -7.893437585808726e-21, -2.693261622761618e-23, -7.542276061225833e-26, -1.161023268026156e-28,  1.996680492539114e+00, -2.806386595405418e-05, -1.775661544600530e-07,
 -9.958628809706813e-10, -5.217786536259670e-12, -2.613394220167138e-14, -1.266235421292831e-16, -5.974894839992523e-19, -2.756527022480353e-21, -1.246210421117760e-23,
 -5.527175386583091e-26, -2.405423099406468e-28,  6.519518106812034e-04, -3.746081505218963e-06,  1.613898686405479e-08, -6.178569989282300e-11,  2.216489630310557e-13,
 -7.629662414532569e-16,  2.551623918297758e-18, -8.354025671551953e-21,  2.689931997715972e-23, -8.547872052172948e-26,  2.685910276144911e-28, -8.362822849558649e-31,
  5.865861074456647e-03, -3.364627612313695e-05,  1.444090179572339e-07, -5.492317688555033e-10,  1.950469683311085e-12, -6.617407691844654e-15,  2.169836280853995e-17,
 -6.921961936001668e-20,  2.155745975073803e-22, -6.568544335529720e-25,  1.958644448255193e-27, -5.716251308958556e-30,  1.628454391784832e-02, -9.308104342472481e-05,
  3.964678083325149e-07, -1.487909380008334e-09,  5.175010452192023e-12, -1.703092088269248e-14,  5.350728902808716e-17, -1.609646806563130e-19,  4.627678961968173e-22,
 -1.263619085045290e-24,  3.229450909881667e-27, -7.504163199885216e-30,  3.188953049372724e-02, -1.813166814732546e-04,  7.633951704640512e-07, -2.806658014831181e-09,
  9.446031240625535e-12, -2.957472523784978e-14,  8.626823442443259e-17, -2.320871108383697e-19,  5.592469728157423e-22, -1.116140620357554e-24,  1.314216711698837e-27,
  2.725779961712305e-30,  5.265261585056705e-02, -2.972465725880250e-04,  1.231920148245927e-06, -4.401936408622203e-09,  1.413181934026421e-11, -4.100102911877701e-14,
  1.054205173722872e-16, -2.249730801307919e-19,  3.053600363259416e-22,  3.670702798839583e-25, -5.008929760528062e-27,  2.518110345789412e-29,  7.853524852693665e-02,
 -4.393841393791376e-04,  1.784561911558701e-06, -6.141738168520557e-09,  1.846798115628981e-11, -4.769023616649886e-14,  9.676013816777429e-17, -9.528324561370109e-20,
 -3.876823655443678e-22,  3.099229126835082e-24, -1.362781072811003e-26,  4.576544691443009e-29,  1.094876966030243e-01, -6.058538688985031e-04,  2.399834037960127e-06,
 -7.870931101752896e-09,  2.162231578318745e-11, -4.620009503799843e-14,  5.005853411460225e-17,  1.687882816038851e-19, -1.416109233492817e-21,  6.078921886947443e-24,
 -1.891526971558718e-26,  4.031316298706268e-29,  1.454479749842965e-01, -7.943808161798297e-04,  3.052526716691519e-06, -9.418103451946137e-09,  2.277305155730496e-11,
 -3.387326685088132e-14, -3.745188832795571e-17,  5.322162461171080e-19, -2.454684781106953e-21,  7.536123186174019e-24, -1.385148913882502e-26, -1.026403186344139e-29,
  1.863405134979060e-01, -1.002279173149958e-03,  3.714085523868536e-06, -1.060399491484112e-08,  2.119776332289952e-11, -9.445708796628429e-15, -1.583688390431931e-16,
  9.087188685326091e-19, -3.006667794892807e-21,  5.543394492675986e-24,  5.839807137793507e-27, -9.981709245160675e-29,  2.320745412045516e-01, -1.226440717091295e-03,
  4.353109682736006e-06, -1.125156255106430e-08,  1.636896437352894e-11,  2.641663945513637e-14, -2.938826668802147e-16,  1.170295050668324e-18, -2.542203413014582e-21,
 -1.005028945146933e-24,  3.706207161913910e-26, -1.841158963974730e-28,  2.825421582994791e-01, -1.463324250535529e-03,  4.935996957804967e-06, -1.119767194020480e-08,
  8.050625729341907e-12,  7.073969882365334e-14, -4.146782378128678e-16,  1.172845072402965e-18, -7.090419548643127e-22, -1.134718268171929e-23,  6.677568570177173e-26,
 -1.894862153034263e-28,  3.376160633267396e-01, -1.708947530066162e-03,  5.427766180562114e-06, -1.030629983158650e-08, -3.612303418151033e-12,  1.181195257069712e-13,
 -4.844982472043244e-16,  7.967001017149032e-19,  2.432688480390160e-21, -2.221900367792212e-23,  7.425890167785690e-26, -5.051462276842980e-29,  3.971469005321916e-01,
 -1.958883675362873e-03,  5.793091252952842e-06, -8.482971140896704e-09, -1.802186251626774e-11,  1.609584385545833e-13, -4.665786557101012e-16, -3.710177345429050e-21,
  6.232146086202728e-21, -2.817409748387243e-23,  3.976459337541931e-26,  2.318599005581397e-28,  4.609601906032803e-01, -2.208264672986402e-03,  5.997581338363725e-06,
 -5.689913443280017e-09, -3.408578277978408e-11,  1.901500665080418e-13, -3.326469603851748e-16, -1.152294148834100e-18,  9.427379350396569e-21, -2.324673036381724e-23,
 -4.180466741271991e-26,  5.423502836745238e-28,  5.288528086328783e-01, -2.451795360878881e-03,  6.009339331817875e-06, -1.961079285487790e-09, -5.022273797645500e-11,
  1.962717707663943e-13, -7.342524650630897e-17, -2.422356583460538e-18,  1.037820501717008e-20, -3.894537039591721e-24, -1.477935269733835e-25,  6.595315556390731e-28,
  6.005889771192927e-01, -2.683782211182008e-03,  5.800822429276438e-06,  2.584251544759230e-09, -6.443160577607884e-11,  1.712781302620736e-13,  2.913622813100641e-16,
 -3.445918719478943e-18,  7.596358592492357e-21,  2.758901043569606e-23, -2.246319646881056e-25,  3.579279947562338e-28,  6.758957508871962e-01, -2.898182316669419e-03,
  5.351011681706764e-06,  7.731120596843749e-09, -7.444180164982208e-11,  1.105829476591921e-13,  7.064749973958142e-16, -3.779000380983542e-18,  5.077423296659812e-22,
  6.085900689446593e-23, -2.042679768670010e-25, -4.065846723273655e-28,  7.544579873272462e-01, -3.088679195694973e-03,  4.647867879621418e-06,  1.316424161026120e-08,
 -7.795763697222941e-11,  1.526501982770469e-14,  1.081887190788631e-15, -3.030089294184533e-18, -9.779294911922793e-21,  7.869294605797787e-23, -4.307988897567430e-26,
 -1.323029709136430e-27,  8.359128224156301e-01, -3.248793276251825e-03,  3.691004170389966e-06,  1.847212912002351e-08, -7.299968579344820e-11, -1.060573205952464e-13,
  1.304528224454926e-15, -1.037249732260486e-18, -2.009484508232809e-20,  6.326251894670220e-23,  2.292307474931660e-25, -1.735038735496343e-27,  9.198437145678743e-01,
 -3.372036032941354e-03,  2.494436275749629e-06,  2.316355822140157e-08, -5.832796651733505e-11, -2.363343931840037e-13,  1.263375313217206e-15,  1.953221454143561e-18,
 -2.569336421308148e-20,  7.057038421094547e-24,  4.827546631450366e-25, -9.861120537622769e-28,  1.005774179347869e+00, -3.452117438482871e-03,  1.089174645946860e-06,
  2.669998348779285e-08, -3.390356602803692e-11, -3.509612546023563e-13,  8.866878217996927e-16,  5.189316820218870e-18, -2.192873588311933e-20, -7.583661490508510e-23,
  5.239590898947734e-25,  9.541581233822426e-28,  1.093161423870860e+00, -3.483216186814177e-03, -4.747019217659592e-07,  2.854682560833004e-08, -1.307469060100862e-12,
 -4.211614718664023e-13,  1.841803542255449e-16,  7.499808582067636e-18, -6.925963441208177e-21, -1.464201372157019e-22,  2.153849329355678e-25,  3.006944876690340e-27,
  1.181390205870519e+00, -3.460320357632265e-03, -2.126998888786487e-06,  2.824450219370612e-08,  3.600727598546048e-11, -4.202383515224292e-13, -7.206466296016857e-16,
  7.642391380404643e-18,  1.580645090183057e-20, -1.543519754600991e-22, -3.675863126978337e-25,  3.323463120750062e-27,  1.269767392951093e+00, -3.379641882940776e-03,
 -3.778043022884887e-06,  2.549616894843461e-08,  7.278856633352899e-11, -3.321916012707164e-13, -1.589036392347687e-15,  4.890941314895497e-18,  3.672555437031505e-20,
 -6.991542005136573e-23, -8.725848393202588e-25,  7.707542968582314e-28,  1.357517882893862e+00, -3.239100195624382e-03, -5.321775879512448e-06,  2.026295870493920e-08,
  1.025453180924289e-10, -1.608291953916973e-13, -2.116781220867045e-15, -3.384006262140517e-19,  4.348367815208691e-20,  8.063918995498608e-23, -8.444535536297414e-25,
 -3.321742626642736e-27,  1.443782758960185e+00, -3.038857604214976e-03, -6.642084345670086e-06,  1.284927176432373e-08,  1.186957780659690e-10,  6.408737686760669e-14,
 -2.041471995042182e-15, -6.211008273199138e-18,  2.819398293593930e-20,  2.081849603020583e-22, -1.281578197200828e-25, -5.270051870997957e-27,  1.527620775253391e+00,
 -2.781870431647209e-03, -7.622953980186104e-06,  3.951838634987948e-09,  1.162479162504620e-10,  2.881600047725271e-13, -1.281985061962805e-15, -9.973553372604182e-18,
 -4.742389740664129e-21,  2.100674648418897e-22,  8.133235030377320e-25, -2.329024762960488e-27,  1.608014458054167e+00, -2.474396053764978e-03, -8.162517431712749e-06,
 -5.359776147494062e-09,  9.369378591483393e-11,  4.448271619421146e-13, -4.451781767247001e-17, -9.343078894412523e-18, -3.705678008535952e-20,  6.063754199498816e-23,
  1.132937928510877e-24,  3.312882367588033e-27,  1.683882207580798e+00, -2.126369086394641e-03, -8.190147668527686e-06, -1.376133445663543e-08,  5.448776572106146e-11,
  4.787997007909836e-13,  1.193528510812080e-15, -4.198133678736341e-18, -4.668330853588991e-20, -1.349496389998721e-22,  4.340666343663179e-25,  5.514335361623087e-27,
  1.754097704595624e+00, -1.751535801937106e-03, -7.684426133282161e-06, -1.990392288780382e-08,  7.268015715247485e-12,  3.733343298262041e-13,  1.876936543459824e-15,
  2.708104796634086e-18, -2.571870595527461e-20, -2.098618014924786e-22, -6.134828703951589e-25,  1.506768086273032e-27,  1.817517567093332e+00, -1.367224070350367e-03,
 -6.688319443026450e-06, -2.273350774534630e-08, -3.589418695373416e-11,  1.671728534484661e-13,  1.688378198688218e-15,  7.147546397392634e-18,  9.192859347244396e-21,
 -1.015858365030887e-22, -8.831833767715918e-25, -3.432636490349423e-27,  1.873017475668308e+00, -9.936394513514601e-04, -5.316737277240616e-06, -2.182836648314402e-08,
 -6.327126432418379e-11, -5.411447533013541e-14,  7.933349916856890e-16,  6.517171618102356e-18,  2.904644995556925e-20,  6.404812982797175e-23, -1.979909055217063e-25,
 -2.951174184939943e-27,  1.919535863551585e+00, -6.526286734979214e-04, -3.751587085155402e-06, -1.763756373573258e-08, -6.820140074019422e-11, -1.969337957412433e-13,
 -2.154522818056836e-16,  2.157388935523630e-18,  2.058635500240934e-20,  1.121631614676509e-22,  4.213185322451931e-25,  7.882326136495678e-28,  1.956122851653155e+00,
 -3.659442862173860e-04, -2.221245012549479e-06, -1.149303991172187e-08, -5.259390314196928e-11, -2.121486144037727e-13, -7.223319073878027e-16, -1.767431199072786e-18,
 -1.917415802661852e-22,  3.362395241406552e-23,  2.774806404810723e-25,  1.570942489845864e-27,  1.981990822296108e+00, -1.531665645406684e-04, -9.652527835217071e-07,
 -5.319868172978015e-09, -2.691448340811147e-11, -1.272342035507383e-13, -5.645675527275786e-16, -2.340307417952259e-18, -8.918475770692189e-21, -3.004358468976956e-23,
 -7.989165023041050e-26, -8.385663053544512e-29,  1.996565318273858e+00, -2.953365667129286e-05, -1.900352157843640e-07, -1.083699886293353e-09, -5.772263466890227e-12,
 -2.938406160511241e-14, -1.446587831703783e-16, -6.933248229390343e-19, -3.247647354287676e-21, -1.489999404916686e-23, -6.702350956470279e-26, -2.956120916950987e-28,
  6.372210963479359e-04, -3.619876173862626e-06,  1.541834377296168e-08, -5.835814158143136e-11,  2.069835719051777e-13, -7.044397230722905e-16,  2.329313860865276e-18,
 -7.540479502462321e-21,  2.400692517573121e-23, -7.543595868135790e-26,  2.343812136848745e-28, -7.217048170050729e-31,  5.733545508583698e-03, -3.251684645447704e-05,
  1.380012042179935e-07, -5.190553897090813e-10,  1.823176084320979e-12, -6.119146579736460e-15,  1.985334101055617e-17, -6.268493818630707e-20,  1.932794816565876e-22,
 -5.833169913712193e-25,  1.723529255005906e-27, -4.988093119487890e-30,  1.591845210160580e-02, -8.997933844663549e-05,  3.790986782671341e-07, -1.407765889417208e-09,
  4.846877189043601e-12, -1.579919786744159e-14,  4.920093334943781e-17, -1.468596547783870e-19,  4.195251024031055e-22, -1.140840780898044e-24,  2.914427964779795e-27,
 -6.822698103262508e-30,  3.117626835346822e-02, -1.753417146072977e-04,  7.306029324130445e-07, -2.660143150800335e-09,  8.874725033559027e-12, -2.758028340303501e-14,
  8.001437099225160e-17, -2.148237471731433e-19,  5.200376073268017e-22, -1.061546907740790e-24,  1.406790467581063e-27,  1.533148130647464e-30,  5.148301108098458e-02,
 -2.875987219338045e-04,  1.180426944812310e-06, -4.182252117217333e-09,  1.333659519662844e-11, -3.854541259495787e-14,  9.925979548079520e-17, -2.150267071436317e-19,
  3.152232144458584e-22,  1.875710233773613e-25, -3.996952519179165e-27,  2.093419683237781e-29,  7.680580518506477e-02, -4.253974959018909e-04,  1.712602910349998e-06,
 -5.853755663619848e-09,  1.753717594279593e-11, -4.540131045337936e-14,  9.393457086625312e-17, -1.060052929665479e-19, -2.854519673128139e-22,  2.592736509718683e-24,
 -1.173683246388017e-26,  4.027188018599073e-29,  1.071020884922017e-01, -5.870271898102495e-04,  2.307428330613097e-06, -7.532299270822410e-09,  2.071068511752682e-11,
 -4.494690093353802e-14,  5.418206710054884e-17,  1.268316709015406e-19, -1.210462344248007e-21,  5.357469572186852e-24, -1.716658480101356e-26,  3.904920883356412e-29,
  1.423185850477819e-01, -7.704065289221083e-04,  2.941673187131285e-06, -9.059198276808386e-09,  2.208776001017042e-11, -3.460191681227200e-14, -2.360951333502354e-17,
  4.578995027284626e-19, -2.193439174757496e-21,  6.975967958808413e-24, -1.408834811012706e-26, -9.301276256700902e-31,  1.823900243894477e-01, -9.730697305803133e-04,
  3.588865690223569e-06, -1.026654007027078e-08,  2.097284619907225e-11, -1.295191770268304e-14, -1.342414234387914e-16,  8.157353804450927e-19, -2.803899818725897e-21,
  5.695642633354269e-24,  1.927267459100677e-27, -7.857720712812923e-29,  2.272375793079079e-01, -1.192151424555390e-03,  4.219678576367597e-06, -1.098580470628010e-08,
  1.682937193720552e-11,  1.974745839306968e-14, -2.622568016174455e-16,  1.088636339246547e-18, -2.553588147868115e-21,  3.224466779638357e-25,  2.948369446381161e-26,
 -1.605125411732217e-28,  2.767669894544389e-01, -1.424371469289603e-03,  4.802442721579688e-06, -1.105807320244414e-08,  9.368542154890527e-12,  6.117857374008827e-14,
 -3.822140563326180e-16,  1.144119020519608e-18, -1.071460628846699e-21, -8.841651256261408e-24,  5.854112677874124e-26, -1.839881953922988e-28,  3.308663330310398e-01,
 -1.666020910084835e-03,  5.303819734905793e-06, -1.034582161429721e-08, -1.364343167511136e-12,  1.067673368929158e-13, -4.612169904046322e-16,  8.623162573870985e-19,
  1.685635544212662e-21, -1.930387072636904e-23,  7.125181799915942e-26, -8.430815751287395e-29,  3.894034039821686e-01, -1.912950789195215e-03,  5.689669763055250e-06,
 -8.746175651328363e-09, -1.491456850633808e-11,  1.497809138985117e-13, -4.640407201185315e-16,  1.798157562934671e-19,  5.248755932883409e-21, -2.640257733568418e-23,
  4.826018223098300e-26,  1.561816009225600e-28,  4.522226480678335e-01, -2.160566123299776e-03,  5.926154207321743e-06, -6.205306095291734e-09, -3.036505726417301e-11,
  1.818126743394780e-13, -3.608155797136645e-16, -8.642856521575092e-19,  8.565924945334903e-21, -2.446624762211254e-23, -1.978146314494898e-26,  4.586256932319539e-28,
  5.191416086835234e-01, -2.403828141015493e-03,  5.981114165377310e-06, -2.733357744028518e-09, -4.632022527091003e-11,  1.937330116879974e-13, -1.366306793698760e-16,
 -2.093581762830666e-18,  1.013853909613610e-20, -9.231150312814162e-24, -1.192080515400264e-25,  6.361658873865187e-28,  5.899468334409685e-01, -2.637268850420062e-03,
  5.825762199518140e-06,  1.581097989791734e-09, -6.094378593510631e-11,  1.771413212779221e-13,  1.984168623079152e-16, -3.188645289318513e-18,  8.431930398174573e-21,
  1.895187360238153e-23, -2.064736131937558e-25,  4.611220887048963e-28,  6.643891970158696e-01, -2.855023203704217e-03,  5.436714586641960e-06,  6.558630367782789e-09,
 -7.206914159872079e-11,  1.262724067102292e-13,  6.012083992025432e-16, -3.729305608188624e-18,  2.547914659519738e-21,  5.239958782398485e-23, -2.170404079752648e-25,
 -1.784286380113749e-28,  7.421786070191295e-01, -3.050885541315069e-03,  4.798369410322484e-06,  1.192074315350746e-08, -7.739972759206335e-11,  4.017944347822997e-14,
  9.930864413651743e-16, -3.298142094357991e-18, -6.990793963588187e-21,  7.587193020081751e-23, -9.628405012216898e-26, -1.091691076618851e-27,  8.229780810285999e-01,
 -3.218398586814883e-03,  3.905597232421764e-06,  1.728885492647178e-08, -7.481046429795589e-11, -7.516765814452022e-14,  1.266836869431489e-15, -1.642225329275869e-18,
 -1.767075505184257e-20,  7.090518840225363e-23,  1.530606055276102e-25, -1.713563374517954e-27,  9.063972189889796e-01, -3.350984905587042e-03,  2.766648892211183e-06,
  2.219416162308095e-08, -6.274749308289262e-11, -2.054496446968311e-13,  1.306619126441654e-15,  1.138734116704783e-18, -2.510317061526935e-20,  2.539240602420742e-23,
  4.315305886006284e-25, -1.326871667809300e-27,  9.919851518744762e-01, -3.442132189587564e-03,  1.406091947885686e-06,  2.610257681635607e-08, -4.069863664863283e-11,
 -3.280188069056710e-13,  1.021783455021756e-15,  4.448032158482427e-18, -2.427305374497140e-20, -5.421085052474843e-23,  5.530665459386631e-25,  3.694929457548152e-28,
  1.079223132107921e+00, -3.485644548443324e-03, -1.325425262238784e-07,  2.845883132491270e-08, -9.669635510190676e-12, -4.142510567335389e-13,  3.902930627355915e-16,
  7.195755547965469e-18, -1.201101535800000e-20, -1.352584617363815e-22,  3.399632719179544e-25,  2.631826859866668e-27,  1.167517052017327e+00, -3.475971463160648e-03,
 -1.784888364166880e-06,  2.875251446720228e-08,  2.744715996450573e-11, -4.349140996109576e-13, -5.004322747180431e-16,  8.056746262985839e-18,  1.002139724422534e-20,
 -1.660195942848389e-22, -2.133979493804987e-25,  3.652157015547059e-27,  1.256190341708236e+00, -3.408623130677079e-03, -3.465327118777275e-06,  2.660561216895781e-08,
  6.577513381615395e-11, -3.685548833382353e-13, -1.436062925299112e-15,  6.019235447131544e-18,  3.359120166290524e-20, -1.038453643679949e-22, -8.166532647409226e-25,
  1.766291272550894e-27,  1.344477912714658e+00, -3.280674150714263e-03, -5.068891114991476e-06,  2.187519047975305e-08,  9.882076233368412e-11, -2.115859678593461e-13,
 -2.106387402680401e-15,  1.092733128461232e-18,  4.574544908754089e-20,  4.416009787972412e-23, -9.735515810221878e-25, -2.505457664293021e-27,  1.431522077423923e+00,
 -3.091345148852354e-03, -6.476464772265508e-06,  1.475593890783502e-08,  1.194740418680133e-10,  1.311397796113116e-14, -2.201632345535842e-15, -5.190337135087861e-18,
  3.553930394321328e-20,  1.982953944188997e-22, -3.689099934991378e-25, -5.624519071215912e-27,  1.516371671805270e+00, -2.842632329131093e-03, -7.564187606083055e-06,
  5.856144022139552e-09,  1.216807617387725e-10,  2.540313076337713e-13, -1.562188775253174e-15, -9.998256554777562e-18,  3.377280934894569e-21,  2.401486584532682e-22,
  6.806797811228205e-25, -3.708256080373305e-27,  1.597985903086035e+00, -2.539927302455143e-03, -8.217546992924116e-06, -3.789652606101180e-09,  1.025577719776322e-10,
  4.404877990612489e-13, -3.223333494465569e-16, -1.048495037894567e-17, -3.402501451963551e-20,  1.086420393985865e-22,  1.260960705656083e-24,  2.443910355169757e-27,
  1.675244664906401e+00, -2.192535253448338e-03, -8.349731923866878e-06, -1.281140895127316e-08,  6.433979422062655e-11,  5.058606481477217e-13,  1.054363008219937e-15,
 -5.765890720097071e-18, -5.116834003697922e-20, -1.125001733849671e-22,  6.938935099516637e-25,  6.265923910800878e-27,  1.746967101430862e+00, -1.813964038911231e-03,
 -7.922321083372441e-06, -1.972542960136897e-08,  1.519079820426120e-11,  4.191905846736476e-13,  1.940072815033889e-15,  1.759640785882713e-18, -3.369618492689604e-20,
 -2.327116160097149e-22, -5.195326874881543e-25,  2.807544282176159e-27,  1.811939916524334e+00, -1.421831328738437e-03, -6.964449724863108e-06, -2.327879683791771e-08,
 -3.212915193652219e-11,  2.101251169429100e-13,  1.892027792083857e-15,  7.376090389615950e-18,  4.863425240891968e-21, -1.399365030681736e-22, -1.034007036152253e-24,
 -3.384183266855300e-27,  1.868956166714854e+00, -1.037238396161545e-03, -5.584783906788239e-06, -2.284826655973863e-08, -6.414782084679194e-11, -3.277756461468447e-14,
  9.891627937800575e-16,  7.481752403643975e-18,  3.117606358374148e-20,  5.328008967614304e-23, -3.468741834769195e-25, -3.838413659184119e-27,  1.916863956423225e+00,
 -6.835068250765865e-04, -3.969916011382283e-06, -1.876055457812507e-08, -7.218649126549164e-11, -2.013014786594192e-13, -1.451921111973058e-16,  2.884075402502074e-18,
  2.493542518476869e-20,  1.296515487360990e-22,  4.514273680981013e-25,  5.577360133177834e-28,  1.954622640488036e+00, -3.842805464442232e-04, -2.364353621378874e-06,
 -1.236944488442118e-08, -5.701424216878528e-11, -2.300779318872282e-13, -7.717078226999719e-16, -1.751916043791786e-18,  1.236103835616382e-21,  4.620959341310658e-23,
  3.544872930858688e-25,  1.939801185957823e-27,  1.981362297087126e+00, -1.611514595126516e-04, -1.031761413613460e-06, -5.771616449108028e-09, -2.960014249915185e-11,
 -1.416034389013470e-13, -6.342586684916665e-16, -2.643626904281623e-18, -1.005832856632716e-20, -3.329867525755083e-23, -8.245901138382385e-26, -2.824481166312425e-29,
  1.996444058445510e+00, -3.110757197074574e-05, -2.036137747896668e-07, -1.180953004939075e-09, -6.396298132370413e-12, -3.310108781748730e-14, -1.656113048180928e-16,
 -8.063759210302238e-19, -3.835610797618796e-21, -1.786017594482576e-23, -8.148488771645748e-26, -3.642220742409892e-28,  6.229839280285183e-04, -3.499275366307875e-06,
  1.473746121323977e-08, -5.515614761644841e-11,  1.934371491867509e-13, -6.509854285978540e-16,  2.128539827395709e-18, -6.813959885908091e-21,  2.145260665523311e-23,
 -6.666588852465598e-26,  2.048347145493779e-28, -6.238487574190793e-31,  5.605647381868828e-03, -3.143726471136201e-05,  1.319436080685246e-07, -4.908383314865528e-10,
  1.705419316496112e-12, -5.663048574270330e-15,  1.818168747152512e-17, -5.682309737459970e-20,  1.734698795435945e-22, -5.185731083124841e-25,  1.518257393723921e-27,
 -4.357330027869628e-30,  1.556449516651993e-02, -8.701282703737747e-05,  3.626605644029685e-07, -1.332680939323716e-09,  4.542376059933549e-12, -1.466624046713995e-14,
  4.527079309672427e-17, -1.340700521490068e-19,  3.804826119396507e-22, -1.030077502261611e-24,  2.628354671425108e-27, -6.188564205574896e-30,  3.048639232454340e-02,
 -1.696222053481893e-04,  6.995153176927868e-07, -2.522458068606992e-09,  8.341845164320644e-12, -2.573027374235411e-14,  7.422661593482349e-17, -1.987830199462035e-19,
  4.828484155715484e-22, -1.004213497181062e-24,  1.453223473310877e-27,  6.183178957514347e-31,  5.035119021826000e-02, -2.783524846812167e-04,  1.131495206301887e-06,
 -3.974906451790834e-09,  1.258902752856345e-11, -3.623428145033357e-14,  9.338107292873320e-17, -2.048606449563758e-19,  3.193098430627051e-22,  4.501360715038344e-26,
 -3.157067892929663e-27,  1.734238410179890e-29,  7.513117860687998e-02, -4.119729509983484e-04,  1.644011840392030e-06, -5.580303594194626e-09,  1.665144863065947e-11,
 -4.318344763587371e-14,  9.085194570426071e-17, -1.137335728135147e-19, -2.001506901456914e-22,  2.157198342662540e-24, -1.007638557502790e-26,  3.528640013487002e-29,
  1.047903339949206e-01, -5.689237480785686e-04,  2.218999532159412e-06, -7.208048028749759e-09,  1.982501656731912e-11, -4.360811935812279e-14,  5.721913584966966e-17,
  9.105358283978255e-20, -1.029543944626465e-21,  4.704652189803516e-24, -1.548801364199612e-26,  3.716768543134207e-29,  1.392833456161499e-01, -7.473020298454826e-04,
  2.835060307352660e-06, -8.711356990700538e-09,  2.139105388634458e-11, -3.502239421480825e-14, -1.173400928761977e-17,  3.916188998750807e-19, -1.952437405171258e-21,
  6.413824562724855e-24, -1.396805400218493e-26,  6.047179320453203e-30,  1.785543950873555e-01, -9.448459151541173e-04,  3.467671508099073e-06, -9.933214302913619e-09,
  2.068338839734645e-11, -1.590957384855110e-14, -1.126260865252140e-16,  7.292997276102824e-19, -2.598251525814908e-21,  5.709115967855432e-24, -1.122300827995667e-27,
 -6.054500048527087e-29,  2.225356600450664e-01, -1.158916709136108e-03,  4.089476493066168e-06, -1.071370694690492e-08,  1.716380085251284e-11,  1.380986171849074e-14,
 -2.329157017757578e-16,  1.007321450076828e-18, -2.522392766313262e-21,  1.367235711387503e-24,  2.291878983340843e-26, -1.381347349020313e-28,  2.711455059633711e-01,
 -1.386480076980122e-03,  4.670684016168841e-06, -1.089887554459980e-08,  1.050295590419295e-11,  5.238570763715209e-14, -3.507034580136245e-16,  1.105175742541734e-18,
 -1.349538263301374e-21, -6.659314883865602e-24,  5.064647284765426e-26, -1.742923835500736e-28,  3.242863239091984e-01, -1.624087164324321e-03,  5.179607439528922e-06,
 -1.035116144715039e-08,  6.622960732396408e-13,  9.599333999752606e-14, -4.364175656622984e-16,  9.056799062191664e-19,  1.041033258247276e-21, -1.653556499082299e-23,
  6.699345678928472e-26, -1.076782776536971e-28,  3.818419654002734e-01, -1.867857080539187e-03,  5.583380757432959e-06, -8.961446868110212e-09, -1.202981776767385e-11,
  1.387224695866850e-13, -4.567945988445950e-16,  3.329528746480734e-19,  4.334485464889365e-21, -2.435446478025424e-23,  5.367767410843437e-26,  9.195265205023602e-29,
  4.436747191389611e-01, -2.113462730369539e-03,  5.848893939797792e-06, -6.662535168343388e-09, -2.681720310674075e-11,  1.728928564769422e-13, -3.813113223042450e-16,
 -6.043833215866754e-19,  7.675537631719319e-21, -2.487837152898953e-23, -1.424899889511069e-27,  3.762710852671098e-28,  5.096217688106178e-01, -2.356122734745106e-03,
  5.943994364602998e-06, -3.443681508469315e-09, -4.248291659314525e-11,  1.897867542446571e-13, -1.907651094714858e-16, -1.775331841877736e-18,  9.727033119208633e-21,
 -1.345094158616360e-23, -9.209068495717152e-26,  5.938098812325121e-28,  5.794910673524416e-01, -2.590603166042839e-03,  5.839002441724712e-06,  6.345689619894152e-10,
 -5.736041126333022e-11,  1.808630054516035e-13,  1.130037389302307e-16, -2.909460154557865e-18,  8.970632501146762e-21,  1.112083041933978e-23, -1.845945147337907e-25,
  5.276468619929671e-28,  6.530565626750485e-01, -2.811234078707960e-03,  5.508585296194434e-06,  5.426476347528729e-09, -6.940780672107648e-11,  1.394592576691638e-13,
  4.982008777905474e-16, -3.619277408246981e-18,  4.276695314029777e-21,  4.362163694434451e-23, -2.204133619606505e-25,  1.973567099941752e-29,  7.300527151103444e-01,
 -3.011947373758463e-03,  4.934018580729450e-06,  1.069003938664729e-08, -7.636539820107039e-11,  6.288255859756809e-14,  8.980113832836932e-16, -3.478978255693472e-18,
 -4.339653121230587e-21,  7.113162744868316e-23, -1.389417642683881e-25, -8.462521990391316e-28,  8.101682613255988e-01, -3.186344395969707e-03,  4.105837382013138e-06,
  1.608149587469691e-08, -7.601382125944744e-11, -4.537686123108523e-14,  1.213329377453812e-15, -2.165812633510291e-18, -1.502592890407812e-20,  7.554334527602384e-23,
  7.955886817329772e-26, -1.616106191298383e-27,  8.930392080124337e-01, -3.327803763176116e-03,  3.026825020461205e-06,  2.115904284154449e-08, -6.654077985686952e-11,
 -1.737979832236071e-13,  1.327417950920925e-15,  3.532710399798023e-19, -2.389314364103319e-20,  4.140705211665037e-23,  3.674280540564601e-25, -1.570345288056171e-27,
  9.782410881086572e-01, -3.429642090074756e-03,  1.715203736017939e-06,  2.540028877106662e-08, -4.700415732968783e-11, -3.020908865612269e-13,  1.135191213366946e-15,
  3.644360329392690e-18, -2.582405721598512e-20, -3.193157385263752e-23,  5.567900464951269e-25, -1.939153803000680e-28,  1.065280591566186e+00, -3.485342120908692e-03,
  2.077635927377126e-07,  2.823841359537487e-08, -1.784490953125742e-11, -4.025140811420636e-13,  5.856812477133602e-16,  6.736336986110428e-18, -1.660889862178658e-20,
 -1.194839613589188e-22,  4.450914358186718e-25,  2.128501522329843e-27,  1.153586802805225e+00, -3.488863648677946e-03, -1.437512209349415e-06,  2.912150748794632e-08,
  1.864721058284422e-11, -4.441867436155944e-13, -2.712621994909747e-16,  8.280473924786835e-18,  3.930264535172841e-21, -1.712906279299752e-22, -4.927656385581583e-26,
  3.772487207821863e-27,  1.242502450482251e+00, -3.435051359483329e-03, -3.139994510324178e-06,  2.759723234463906e-08,  5.807364495943165e-11, -4.008801402878156e-13,
 -1.253081470423396e-15,  7.028203330966452e-18,  2.928607294001113e-20, -1.346767540643474e-22, -7.181504127669277e-25,  2.694137026440923e-27,  1.331275813869190e+00,
 -3.320148730636006e-03, -4.797050544545650e-06,  2.341973558803056e-08,  9.408684844810392e-11, -2.616054964395830e-13, -2.055112668576594e-15,  2.574309450734802e-18,
  4.661031922239276e-20,  3.305209333306317e-24, -1.061598747303906e-24, -1.463740842742983e-27,  1.419054240724044e+00, -3.142416083978132e-03, -6.287924771084885e-06,
  1.666670386903271e-08,  1.191968497191881e-10, -4.133415924653169e-14, -2.329990123962303e-15, -3.942195830627434e-18,  4.235232655275090e-20,  1.785554271225631e-22,
 -6.183029401049571e-25, -5.653224352777886e-27,  1.504880607771239e+00, -2.902831265478082e-03, -7.482071722031682e-06,  7.841549265410574e-09,  1.263638842100111e-10,
  2.131997428956330e-13, -1.839291756866239e-15, -9.746946767757441e-18,  1.246967078120348e-20,  2.637035951345352e-22,  4.870290392986195e-25, -5.084635168773635e-27,
  1.587694465371597e+00, -2.605821019703383e-03, -8.252888195631310e-06, -2.078772509818556e-09,  1.112657688467801e-10,  4.291097876445425e-13, -6.304966712586498e-16,
 -1.150124794606584e-17, -2.918314873268546e-20,  1.608901533251886e-22,  1.342311759722802e-24,  1.190057940568963e-27,  1.666339980245875e+00, -2.259929778490357e-03,
 -8.496954047476167e-06, -1.169971791670157e-08,  7.469600589249406e-11,  5.290394592129910e-13,  8.694271690893598e-16, -7.462170891337383e-18, -5.465069708780600e-20,
 -7.905844246918014e-23,  9.819307427121850e-25,  6.777123917843104e-27,  1.739582995699353e+00, -1.878284642622064e-03, -8.157283021032219e-06, -1.941276202245333e-08,
  2.404355517412869e-11,  4.662138482797367e-13,  1.972960362747576e-15,  5.435778310787868e-19, -4.241411679197869e-20, -2.505818374028377e-22, -3.626407562355212e-25,
  4.363518564907309e-27,  1.806139378929337e+00, -1.478672712145758e-03, -7.246732818508797e-06, -2.375670557164642e-08, -2.745576388216486e-11,  2.580247890852001e-13,
  2.099921221351530e-15,  7.442846738123960e-18, -9.540321507879153e-22, -1.842015172014954e-22, -1.176856449297210e-24, -3.054842294649581e-27,  1.864716095431989e+00,
 -1.083030873497769e-03, -5.865138551730124e-06, -2.387851295917924e-08, -6.454841469099538e-11, -6.409388037063892e-15,  1.212885999871771e-15,  8.507050367752938e-18,
  3.280107051819676e-20,  3.573738845871583e-23, -5.376493584172124e-25, -4.852403586297438e-27,  1.914064956540193e+00, -7.161866015782369e-04, -4.202105962699986e-06,
 -1.994790687041103e-08, -7.624034111073793e-11, -2.037224350862919e-13, -5.254015914433368e-17,  3.760215463782770e-18,  2.993291711975788e-20,  1.480974368236728e-22,
  4.680136010922609e-25,  1.650433054789537e-28,  1.953046726203624e+00, -4.038049729823460e-04, -2.518415483701313e-06, -1.331950811236975e-08, -6.180495403645921e-11,
 -2.491814544469095e-13, -8.199370975687038e-16, -1.682833138753063e-18,  3.176560854442812e-21,  6.221909062084018e-23,  4.491513807735041e-25,  2.374230042528991e-27,
  1.980700732766455e+00, -1.696908603881988e-04, -1.103958632433613e-06, -6.268728188714137e-09, -3.259062185679857e-11, -1.577514069432875e-13, -7.129711115033988e-16,
 -2.985311121342838e-18, -1.131654265523377e-20, -3.659849201881305e-23, -8.188370580392505e-26,  6.096432306309707e-29,  1.996316278060474e+00, -3.279495946225777e-05,
 -2.184218233229543e-07, -1.288813840313110e-09, -7.099969747914705e-12, -3.736118840442744e-14, -1.900095168553114e-16, -9.400647391483718e-19, -4.541323185361703e-21,
 -2.146392932506146e-23, -9.932633481481140e-26, -4.499069516564539e-28,  6.092185070731000e-04, -3.383971528564313e-06,  1.409373657478772e-08, -5.216259878323342e-11,
  1.809132278100714e-13, -6.021145529751001e-16,  1.947009893355690e-18, -6.164346841479673e-21,  1.919373507288004e-23, -5.899589894368968e-26,  1.792742434310165e-28,
 -5.401332094945450e-31,  5.481972760762366e-03, -3.040482066911026e-05,  1.262136060810688e-07, -4.644345311615362e-10,  1.596396245321213e-12, -5.245170208450211e-15,
  1.666563017598547e-17, -5.155940331669631e-20,  1.558497153629404e-22, -4.615106266116151e-25,  1.338848515510188e-27, -3.810442829098416e-30,  1.522214685900626e-02,
 -8.417429759634196e-05,  3.470949693091722e-07, -1.262291739751337e-09,  4.259619137713229e-12, -1.362344669725861e-14,  4.168185469922666e-17, -1.224681643242268e-19,
  3.452282219758301e-22, -9.302133021727505e-25,  2.369122645235713e-27, -5.602653916154566e-30,  2.981890719390642e-02, -1.641449303024928e-04,  6.700299644617817e-07,
 -2.393010459695471e-09,  7.844612120593410e-12, -2.401391307673743e-14,  6.887165289067235e-17, -1.838990388778812e-19,  4.477475927144167e-22, -9.457587863387910e-25,
  1.464471820088986e-27, -7.442497360881332e-32,  4.925558687250356e-02, -2.694879486195812e-04,  1.084981350060230e-06, -3.779159656936186e-09,  1.188629470367572e-11,
 -3.406081359049078e-14,  8.778810389492450e-17, -1.946397385353487e-19,  3.188326096421281e-22, -6.693743581656307e-26, -2.462541574422037e-27,  1.431262199907669e-29,
  7.350917319783931e-02, -3.990842465282739e-04,  1.578618616025586e-06, -5.320672391660985e-09,  1.580932275136231e-11, -4.104187011477140e-14,  8.758887549563036e-17,
 -1.189706833272449e-19, -1.293847833451514e-22,  1.783838652263231e-24, -8.624279152507451e-27,  3.079905517707060e-29,  1.025496027095019e-01, -5.515124115177095e-04,
  2.134377619951272e-06, -6.897749647201873e-09,  1.896677469094369e-11, -4.220783662556428e-14,  5.933202793888360e-17,  6.070164928993615e-20, -8.709395666446628e-22,
  4.117191283151259e-24, -1.390163665248754e-26,  3.489050574630502e-29,  1.363388445424309e-01, -7.250339274710047e-04,  2.732554410179616e-06, -8.374715408852792e-09,
  2.068864243569014e-11, -3.517927699210693e-14, -1.609425727029817e-18,  3.327280520259955e-19, -1.731517669746733e-21,  5.862037945036283e-24, -1.358449753351298e-26,
  1.110291055037346e-29,  1.748297471559593e-01, -9.175757365971495e-04,  3.350447584267863e-06, -9.604965708459063e-09,  2.033977295961456e-11, -1.837676101970326e-14,
 -9.333890365903931e-17,  6.494305369887424e-19, -2.394130714383635e-21,  5.615595605144236e-24, -3.443622677851406e-27, -4.542398640906547e-29,  2.179646172068291e-01,
 -1.126710467506524e-03,  3.962567891066771e-06, -1.043717085121919e-08,  1.738633600013263e-11,  8.549275428939836e-15, -2.058321392113409e-16,  9.275578294350528e-19,
 -2.458078557426511e-21,  2.168661351888521e-24,  1.730354664483328e-26, -1.173987151565665e-28,  2.656734924196045e-01, -1.349634817365922e-03,  4.540938915126643e-06,
 -1.072289342344506e-08,  1.146898165514775e-11,  4.433507585971500e-14, -3.203964688623413e-16,  1.058530950231997e-18, -1.554624641944271e-21, -4.783319282909113e-24,
  4.324435505152544e-26, -1.618095816303015e-28,  3.178720627247509e-01, -1.583146838157416e-03,  5.055518618469319e-06, -1.032576618115088e-08,  2.479493926779672e-12,
  8.582685946290234e-14, -4.106780037313841e-16,  9.299761031610805e-19,  4.928008010386931e-22, -1.395547527249099e-23,  6.190438825665032e-26, -1.223460980109779e-28,
  3.744591857539690e-01, -1.823623249034790e-03,  5.474778169156721e-06, -9.132320575948481e-09, -9.364166322923630e-12,  1.278861497457024e-13, -4.456588798945895e-16,
  4.580495462693465e-19,  3.497196978038824e-21, -2.214283910087349e-23,  5.651756822215327e-26,  3.893826916116789e-29,  4.353139342124164e-01, -2.066998415278384e-03,
  5.766481550363380e-06, -7.064450055964526e-09, -2.345209150613723e-11,  1.635652395180752e-13, -3.949299539729569e-16, -3.730760807206249e-19,  6.782667077082307e-21,
 -2.462759238558854e-23,  1.339596718962596e-26,  2.983331457832985e-28,  5.002921041264340e-01, -2.308747345115657e-03,  5.898716235304813e-06, -4.093307325310245e-09,
 -3.873681179557035e-11,  1.846465814689841e-13, -2.361942638539922e-16, -1.472475274805162e-18,  9.182650391524465e-21, -1.662758364587168e-23, -6.714624926687663e-26,
  5.383089243543519e-28,  5.692221052916717e-01, -2.543876013496721e-03,  5.841230442432039e-06, -2.541392906969814e-10, -5.372245988152215e-11,  1.826302744939444e-13,
  3.560799069699830e-17, -2.617373200286135e-18,  9.243784690726535e-21,  4.213591809079445e-24, -1.605201309679039e-25,  5.616791277698759e-28,  6.419001497691464e-01,
 -2.766923588368191e-03,  5.567133916994596e-06,  4.338880415853232e-09, -6.650717601910378e-11,  1.502168563510487e-13,  3.990010437043856e-16, -3.458993896356717e-18,
  5.689053292054025e-21,  3.487330547350609e-23, -2.158084856635169e-25,  1.837487050730025e-28,  7.180846531666811e-01, -2.971982771586410e-03,  5.055013179721211e-06,
  9.479391859367920e-09, -7.490018582383644e-11,  8.325252896718102e-14,  7.990327440886283e-16, -3.578016450573309e-18, -1.887264923942883e-21,  6.490181334617656e-23,
 -1.707642313122948e-25, -6.014053203422858e-28,  7.974897700660953e-01, -3.152746519670724e-03,  4.291493123423790e-06,  1.485957505456394e-08, -7.663534156868800e-11,
 -1.703647154212551e-14,  1.146367433549341e-15, -2.602651809058559e-18, -1.226584189079515e-20,  7.734618811191802e-23,  1.173549305070767e-26, -1.458178748303665e-27,
  8.797780043615412e-01, -3.302591880964755e-03,  3.274236525525860e-06,  2.006831546688290e-08, -6.969779830622974e-11, -1.419061755669206e-13,  1.326848931730282e-15,
 -3.847607929411176e-19, -2.215505562759971e-20,  5.467293641324240e-23,  2.948252473553467e-25, -1.713324590523156e-27,  9.645518747874111e-01, -3.414714480851822e-03,
  2.015300307955840e-06,  2.460140100348603e-08, -5.276575030994389e-11, -2.737160812408090e-13,  1.225521814215480e-15,  2.803870279632894e-18, -2.657618038923116e-20,
 -9.985572281060781e-24,  5.367924567739428e-25, -7.039292776300567e-28,  1.051344685767018e+00, -3.482330028675292e-03,  5.446484317071739e-07,  2.788931951799930e-08,
 -2.573967643385597e-11, -3.862582270613446e-13,  7.662367591689667e-16,  6.139638718215474e-18, -2.056881917514173e-20, -9.997682212094318e-23,  5.259361801192726e-25,
  1.534764350718192e-27,  1.139610567517695e+00, -3.498961519021872e-03, -1.086558080492622e-06,  2.934851826514459e-08,  9.717202143952526e-12, -4.479062887066772e-13,
 -3.857602942559429e-17,  8.307522806841715e-18, -2.231758821333432e-21, -1.699542754875752e-22,  1.154041044561260e-25,  3.677906085662161e-27,  1.228714124005768e+00,
 -3.458831471996156e-03, -2.803522338906113e-06,  2.846070457776595e-08,  4.977177015104675e-11, -4.284913929038975e-13, -1.043938597647232e-15,  7.882486491406809e-18,
  2.395146227385805e-20, -1.607868216851744e-22, -5.815787357365059e-25,  3.485986565383701e-27,  1.317920281621161e+00, -3.357375810978653e-03, -4.507162646202116e-06,
  2.488061595506604e-08,  8.836822045681152e-11, -3.098948754034097e-13, -1.962191752695816e-15,  4.059442451250924e-18,  4.595256526342300e-20, -4.010094377029140e-23,
 -1.099903193718817e-24, -2.559840421921928e-28,  1.406385281924965e+00, -3.191887141560447e-03, -6.076518645256080e-06,  1.856416699180137e-08,  1.178028440286705e-10,
 -9.841959717743643e-14, -2.420468254180625e-15, -2.489329453761192e-18,  4.827581294867869e-20,  1.489215461856023e-22, -8.608905998975316e-25, -5.309600588015732e-27,
  1.493150214450316e+00, -2.962276765888952e-03, -7.375709506637732e-06,  9.894993069045535e-09,  1.301646136809601e-10,  1.658357519420164e-13, -2.105168532578711e-15,
 -9.192724930250528e-18,  2.225623343585993e-20,  2.783270144921036e-22,  2.349582340328341e-25, -6.343522605909639e-27,  1.577139020673533e+00, -2.671912995705526e-03,
 -8.266871706281760e-06, -2.307961281321619e-10,  1.196700392602008e-10,  4.100136463462847e-13, -9.646605829974055e-16, -1.233199753590566e-17, -2.241610062021269e-20,
  2.151764770338807e-22,  1.360133399380057e-24, -4.390330305077463e-28,  1.657163450440885e+00, -2.328445868878041e-03, -8.629827210140101e-06, -1.041887640204468e-08,
  8.546750195580429e-11,  5.471984606907533e-13,  6.356324565453174e-16, -9.248362091139309e-18, -5.671721941131971e-20, -3.374327989607384e-23,  1.284913066047686e-24,
  6.924130751013360e-27,  1.731937875418705e+00, -1.944467454146311e-03, -8.387611941818152e-06, -1.895089587571452e-08,  3.384174712219958e-11,  5.135857440964747e-13,
  1.967805231665791e-15, -9.604030010111475e-19, -5.164530015084909e-20, -2.607404070299428e-22, -1.324051432339961e-25,  6.130944012918602e-27,  1.800106924842941e+00,
 -1.537793954189588e-03, -7.534269678997071e-06, -2.415190481810864e-08, -2.177445166446310e-11,  3.109137866912092e-13,  2.306830376708187e-15,  7.296879442618657e-18,
 -8.463453812301820e-21, -2.337865054828876e-22, -1.297243670333188e-24, -2.346158513763270e-27,  1.860288290168194e+00, -1.131115706758354e-03, -6.157876235563822e-06,
 -2.491064835826839e-08, -6.436559836536472e-11,  2.567788323469067e-14,  1.465939595612499e-15,  9.572681957399790e-18,  3.364613635159711e-20,  9.639668870225682e-24,
 -7.753402703182455e-25, -5.964145303306040e-27,  1.911131430712669e+00, -7.507819960997652e-04, -4.448934493989630e-06, -2.120037862123770e-08, -8.031829051970267e-11,
 -2.036066734114787e-13,  6.698312016416115e-17,  4.806990834770267e-18,  3.560169951229751e-20,  1.668010811365537e-22,  4.627149757034011e-25, -4.475537413341685e-28,
  1.951390175140031e+00, -4.246088299697681e-04, -2.684350823027486e-06, -1.434934139379340e-08, -6.698911607996637e-11, -2.694116914390514e-13, -8.652706502356280e-16,
 -1.541664751821884e-18,  5.766305926140352e-21,  8.241737253340008e-23,  5.644201144223721e-25,  2.876336904681446e-27,  1.980003816724724e+00, -1.788325390164436e-04,
 -1.182419277375638e-06, -6.816377250045680e-09, -3.592375047947472e-11, -1.759079386191639e-13, -8.018321713304541e-16, -3.369146016440853e-18, -1.269207484816117e-20,
 -3.978393002063659e-23, -7.639313622284050e-26,  1.978905689581754e-28,  1.996181502720256e+00, -3.460618674937864e-05, -2.345946726717420e-07, -1.408648173111669e-09,
 -7.895015867911919e-12, -4.225444236780590e-14, -2.184877048867484e-16, -1.098557577495698e-18, -5.390579015423530e-21, -2.586272907223223e-23, -1.213942030466886e-25,
 -5.571670080742391e-28,  5.959042246710029e-04, -3.273677131315061e-06,  1.348476373042853e-08, -4.936184402641708e-11,  1.693245889278043e-13, -5.573900456121156e-16,
  1.782697293858842e-18, -5.582790118149852e-21,  1.719343361526741e-23, -5.227832885432330e-26,  1.571265202926839e-28, -4.683984382909619e-31,  5.362338201438624e-03,
 -2.941697829204263e-05,  1.207902530127878e-07, -4.397101673875986e-10,  1.495378504362333e-12, -4.861970481284530e-15,  1.528936169402558e-17, -4.682802582807010e-20,
  1.401602230458831e-22, -4.111652996220300e-25,  1.181873267586334e-27, -3.335855297060862e-30,  1.489090886278786e-02, -8.145698958917997e-05,  3.323475733262823e-07,
 -1.196264375708660e-09,  3.996882413762511e-12, -1.266301344291662e-14,  3.840250167894202e-17, -1.119388468905083e-19,  3.133883805232839e-22, -8.402168952740740e-25,
  2.134617572558838e-27, -5.064431812325784e-30,  2.917286904826462e-02, -1.588974572806092e-04,  6.420513587259120e-07, -2.271250805211995e-09,  7.380454208210763e-12,
 -2.242119548498860e-14,  6.391803279503074e-17, -1.701045836595004e-19,  4.147523986475236e-22, -8.874087529816611e-25,  1.449275974732112e-27, -5.904139405461352e-31,
  4.819471206049732e-02, -2.609863154482841e-04,  1.040750404135417e-06, -3.594316028427663e-09,  1.122571208038922e-11, -3.201814802711377e-14,  8.248053732166060e-17,
 -1.844934774902533e-19,  3.147944181049268e-22, -1.536266643111824e-25, -1.890479556743569e-27,  1.176324720541001e-29,  7.193769572794073e-02, -3.867064513863249e-04,
  1.516261521537603e-06, -5.074176851245011e-09,  1.500923467907111e-11, -3.898012208633827e-14,  8.420892642531746e-17, -1.221475074066334e-19, -7.106059617862837e-23,
  1.464756373603512e-24, -7.359047364146058e-27,  2.678769358443362e-29,  1.003771860756705e-01, -5.347633872290550e-04,  2.053397829447821e-06, -6.600956614105737e-09,
  1.813697960778926e-11, -4.076648832749739e-14,  6.066302746659374e-17,  3.509872435809724e-20, -7.323664607952775e-22,  3.591104222499771e-24, -1.242096411602235e-26,
  3.238710122450156e-29,  1.334818010986795e-01, -7.035699046893091e-04,  2.634020718215309e-06, -8.049324855505582e-09,  1.998539371618003e-11, -3.511217648160162e-14,
  6.962223352692546e-18,  2.805921735241400e-19, -1.530136903532552e-21,  5.329561907301550e-24, -1.301379257833381e-26,  1.461069931401409e-29,  1.712123291662115e-01,
 -8.912276905521412e-04,  3.237128107567922e-06, -9.282585307590436e-09,  1.995126535819978e-11, -2.040715746948545e-14, -7.619723860135773e-17,  5.760226778169026e-19,
 -2.194894852712751e-21,  5.441741711413184e-24, -5.157883962921979e-27, -3.289884668602548e-29,  2.135203898894172e-01, -1.095506168201174e-03,  3.838995725939767e-06,
 -1.015788132485139e-08,  1.750997988261143e-11,  3.912151776946782e-15, -1.809491068278913e-16,  8.502722874596936e-19, -2.368741020246412e-21,  2.763183707403799e-24,
  1.255991459527504e-26, -9.854307495771520e-29,  2.603467977224603e-01, -1.313818820641694e-03,  4.413393151366405e-06, -1.053270392766676e-08,  1.228115908236197e-11,
  3.699545796668009e-14, -2.914776607216607e-16,  1.006347932184146e-18, -1.697367108892107e-21, -3.191864266262267e-24,  3.643142739248905e-26, -1.476775078494787e-28,
  3.116195800315807e-01, -1.543197524542382e-03,  4.931902390990912e-06, -1.027288862527243e-08,  4.099584881883319e-12,  7.628439391893691e-14, -3.844900797356697e-16,
  9.381745767765548e-19,  3.365209867708933e-23, -1.158966088349260e-23,  5.633116577694790e-26, -1.299440682272635e-28,  3.672515918078880e-01, -1.780265731488555e-03,
  5.364373897116260e-06, -9.262262013469144e-09, -6.912300315755863e-12,  1.173561662479172e-13, -4.313834592443993e-16,  5.576444344896855e-19,  2.741038479734812e-21,
 -1.986110704653351e-23,  5.725980793498007e-26, -3.533922663939727e-30,  4.271376586758519e-01, -2.021211790189613e-03,  5.679563025116124e-06, -7.414031191281085e-09,
 -2.027629274768678e-11,  1.539852782805889e-13, -4.024698542864878e-16, -1.700884344248101e-19,  5.908685260487942e-21, -2.385076826319424e-23,  2.492492370044408e-26,
  2.269142534923445e-28,  4.911511686068729e-01, -2.261764351803070e-03,  5.845998645648154e-06, -4.683874286158856e-09, -3.510373716900924e-11,  1.785158014023267e-13,
 -2.734031653679845e-16, -1.188681074786127e-18,  8.541254812084113e-21, -1.885798737806641e-23, -4.483683004214123e-26,  4.748231595071180e-28,  5.591400213469762e-01,
 -2.497172703373878e-03,  5.833144034551964e-06, -1.084455686722113e-09, -5.006707149115569e-11,  1.826389514589421e-13, -3.352299313063890e-17, -2.320335676660074e-18,
  9.285892890810445e-21, -1.709198087008779e-24, -1.355724606150952e-25,  5.682041093167836e-28,  6.309218340795969e-01, -2.722196109176124e-03,  5.612916532539452e-06,
  3.299288048684527e-09, -6.341481261568140e-11,  1.586523319657753e-13,  3.048748704934214e-16, -3.258504927979044e-18,  6.791430881098755e-21,  2.644304052617656e-23,
 -2.047697351440767e-25,  3.121404635933627e-28,  7.062782941384796e-01, -2.931107895046201e-03,  5.161633692670430e-06,  8.295317071200856e-09, -7.305150861070318e-11,
  1.012223875054876e-13,  6.983443593647502e-16, -3.602391354429606e-18,  3.205086475841372e-22,  5.761160756808363e-23, -1.920542790759237e-25, -3.692713196593315e-28,
  7.849485477550595e-01, -3.117722176203172e-03,  4.462444559923604e-06,  1.363215307489676e-08, -7.670706393399290e-11,  9.560075607476920e-15,  1.068416618706081e-15,
 -2.950638901920186e-18, -9.487880488519184e-21,  7.658913005996458e-23, -4.811918464026956e-26, -1.256728124003377e-27,  8.666215227798626e-01, -3.275453871899556e-03,
  3.508277255599400e-06,  1.893217083671793e-08, -7.221875674317916e-11, -1.102692971754707e-13,  1.306461420851883e-15, -1.060103717752824e-18, -1.999292152279346e-20,
  6.493784342704416e-23,  2.180843219050177e-25, -1.759581620239862e-27,  9.509271105780642e-01, -3.397425968964425e-03,  2.305276200724301e-06,  2.371497746706706e-08,
 -5.794008505242506e-11, -2.434577424056496e-13,  1.292099165514841e-15,  1.951756172696906e-18, -2.655785992470290e-20,  1.073334834015051e-23,  4.960117370038363e-25,
 -1.135022764804637e-27,  1.037426188965934e+00, -3.476641735413103e-03,  8.765977195327408e-07,  2.741673962155686e-08, -3.326741741607988e-11, -3.658831804831334e-13,
  9.284203956230853e-16,  5.428031031882641e-18, -2.377473345498013e-20, -7.777566732863454e-23,  5.794423961727660e-25,  8.930083371409159e-28,  1.125599569833575e+00,
 -3.506243292462672e-03, -7.337385754122485e-07,  2.943235706051404e-08,  7.685940283488781e-13, -4.460544695327781e-13,  1.921231538593020e-16,  8.139416171216409e-18,
 -8.228668547460776e-21, -1.621754456504275e-22,  2.713555941990968e-25,  3.378764007061595e-27,  1.214836123016892e+00, -3.479880658738713e-03, -2.457502799316695e-06,
  2.918720951083366e-08,  4.096969885776996e-11, -4.508162965837192e-13, -8.133991133017911e-16,  8.552142064216076e-18,  1.778313669339219e-20, -1.807907830816099e-22,
 -4.142682580549711e-25,  4.082678868514153e-27,  1.304420587993395e+00, -3.392215293886423e-03, -4.200324611745743e-06,  2.624240721958210e-08,  8.170945573845515e-11,
 -3.554589779586790e-13, -1.828218196791263e-15,  5.498335643258208e-18,  4.371771920336314e-20, -8.394452589416862e-23, -1.082833814304045e-24,  1.038937127388484e-27,
  1.393521964950191e+00, -3.239576338541995e-03, -5.842514806378236e-06,  2.043008857334248e-08,  1.152488162032172e-10, -1.571679796429300e-13, -2.467785929552093e-15,
 -8.658169720044884e-19,  5.296250446697003e-20,  1.100013341799440e-22, -1.079768996132317e-24, -4.575151810561605e-27,  1.481183898346685e+00, -3.020771843692654e-03,
 -7.244373462907232e-06,  1.200132952073976e-08,  1.329556945754208e-10,  1.123127393606019e-13, -2.351078059077390e-15, -8.318960771420392e-18,  3.237495100003876e-20,
  2.818222280615509e-22, -6.760465659155171e-26, -7.358481968364614e-27,  1.566319127966855e+00, -2.738025882859566e-03, -8.257886725853074e-06,  1.748150002467320e-09,
  1.276104375006027e-10,  3.826447160639622e-13, -1.318759909461571e-15, -1.291494140580325e-17, -1.370011369724343e-20,  2.686413507665170e-22,  1.298870983948830e-24,
 -2.392533747597602e-27,  1.647710831817743e+00, -2.397960508791329e-03, -8.746285260356217e-06, -8.963107497296643e-09,  9.654198431850162e-11,  5.591403474368590e-13,
  3.511605446920443e-16, -1.107223673872144e-17, -5.693390863809199e-20,  2.368488075004517e-23,  1.583996632222630e-24,  6.579216945773146e-27,  1.724024377588349e+00,
 -2.012467990465522e-03, -8.611426639315594e-06, -1.832470079888166e-08,  4.458255502404391e-11,  5.602949287005215e-13,  1.916361656204405e-15, -2.763700682868991e-18,
 -6.105725939059444e-20, -2.600893930214759e-22,  1.787596516855591e-25,  8.024052957957400e-27,  1.793833357453270e+00, -1.599232833228977e-03, -7.825967748766968e-06,
 -2.444747291951019e-08, -1.498617980219865e-11,  3.686907239781684e-13,  2.506013638838316e-15,  6.881189229666083e-18, -1.783588437428003e-20, -2.874284520067842e-22,
 -1.376176862738103e-24, -1.153206568913504e-27,  1.855663383463392e+00, -1.181591883295653e-03, -6.462959719495947e-06, -2.593438456284643e-08, -6.347787503675841e-11,
  6.419861266651604e-14,  1.749054582143903e-15,  1.064839158315927e-17,  3.336859163525510e-20, -2.696132328348638e-23, -1.063115179165959e-24, -7.116780701663200e-27,
  1.908055477298343e+00, -7.874132454783304e-04, -4.711183560029581e-06, -2.251791284035129e-08, -8.436275645303882e-11, -2.002495188868103e-13,  2.184563286537213e-16,
  6.045842238725832e-18,  4.193278482837661e-20,  1.846738719910811e-22,  4.243613341179454e-25, -1.349982404807804e-27,  1.949647673383995e+00, -4.467910428880226e-04,
 -2.863155380635190e-06, -1.546541569945765e-08, -7.258839137841196e-11, -2.906724318166636e-13, -9.053753687492048e-16, -1.305056057194151e-18,  9.171684026996628e-21,
  1.076876136548062e-22,  7.032159333772660e-25,  3.442353061847488e-27,  1.979269035659554e+00, -1.886291249394226e-04, -1.267784060264101e-06, -7.420381034164700e-09,
 -3.964223307664327e-11, -1.963311823139917e-13, -9.020737106295619e-16, -3.798777527038344e-18, -1.417671532973566e-20, -4.261112259998762e-23, -6.348365664547141e-26,
  4.018995082220117e-28,  1.996039214282474e+00, -3.655277281854412e-05, -2.522852125410441e-07, -1.542024866058079e-09, -8.795137808814203e-12, -4.788764999599870e-14,
 -2.518092355644407e-16, -1.286940350944230e-18, -6.415286050778147e-21, -3.124620622324022e-23, -1.487589398786239e-25, -6.917382969120460e-28,  5.830215847876245e-04,
 -3.168123166085969e-06,  1.290831627275719e-08, -4.673956042507741e-11,  1.585922876843773e-13, -5.164206531784229e-16,  1.633807318867948e-18, -5.061538716514189e-21,
  1.541975042018463e-23, -4.638665537389649e-26,  1.379053719560118e-28, -4.068340868437913e-31,  5.246570078988406e-03, -2.847136287586225e-05,  1.156541418257852e-07,
 -4.165425261237094e-10,  1.401704898021958e-12, -4.510266555703429e-15,  1.403880694907170e-17, -4.257088534141184e-20,  1.261749983632621e-22, -3.667003757621844e-25,
  1.044374150411898e-27, -2.923653071616085e-30,  1.457030905934145e-02, -7.885456146823073e-05,  3.183679032893505e-07, -1.134291307999398e-09,  3.752590608114207e-12,
 -1.177785901322349e-14,  3.540417971546292e-17, -1.023783313346548e-19,  2.846251481452493e-22, -7.591407842299184e-25,  1.922771382944328e-27, -4.572397230404602e-30,
  2.854738221565540e-02, -1.538680925125426e-04,  6.154903403074828e-07, -2.156669172831080e-09,  6.946992456268173e-12, -2.094284721349232e-14,  5.933619030848045e-17,
 -1.573325240943973e-19,  3.838417946473072e-22, -8.300770206209364e-25,  1.414575125741421e-27, -9.664727874404566e-31,  4.716714988453096e-02, -2.528298339683263e-04,
  9.986754918241967e-07, -3.419721720174120e-09,  1.060473187696824e-11, -3.009947225091311e-14,  7.745481803867718e-17, -1.745221670683529e-19,  3.080214147087393e-22,
 -2.195515997764905e-25, -1.421348057127361e-27,  9.623019414026517e-30,  7.041475015562092e-02, -3.748158957332085e-04,  1.456786911482675e-06, -4.840157274336328e-09,
  1.424956422070142e-11, -3.700035962136071e-14,  8.076449632172476e-17, -1.236323184890836e-19, -2.335371949190258e-23,  1.192887030856482e-24, -6.260382602406096e-27,
  2.322245393824968e-29,  9.827049210287610e-02, -5.186481787021507e-04,  1.975900851280798e-06, -6.317208185933975e-09,  1.733627537991398e-11, -3.930131463965451e-14,
  6.133645890085710e-17,  1.363832562121853e-20, -6.116933040837014e-22,  3.122003901674756e-24, -1.105301849691215e-26,  2.978446267554613e-29,  1.307090616668411e-01,
 -6.828787238082189e-04,  2.539324280181965e-06, -7.735164851616218e-09,  1.928542964732478e-11, -3.485616340323272e-14,  1.416143770202819e-17,  2.345984577061728e-19,
 -1.347480701243487e-21,  4.822617370608788e-24, -1.231688406791461e-26,  1.688724415981644e-29,  1.676985145968499e-01, -8.657708346799538e-04,  3.127638629414953e-06,
 -8.966724225005006e-09,  1.952610103551842e-11, -2.205010479200221e-14, -6.102276514799927e-17,  5.088780282805199e-19, -2.003025540071617e-21,  5.209645720212635e-24,
 -6.372333737291246e-27, -2.265393675224905e-29,  2.091990238790363e-01, -1.065277013529685e-03,  3.718783947550381e-06, -9.877323718379714e-09,  1.754667968503277e-11,
 -1.534054889586262e-16, -1.581870807086310e-16,  7.761529588658307e-19, -2.261221423082274e-21,  3.183973515593195e-24,  8.602458190915520e-27, -8.167137143049185e-29,
  2.551613410318677e-01, -1.279013850933212e-03,  4.288202907215458e-06, -1.033065672719896e-08,  1.295336386490619e-11,  3.033189290638972e-14, -2.640756806065615e-16,
  9.504624716317145e-19, -1.787569994229430e-21, -1.860210335354681e-24,  3.025978680032248e-26, -1.327888103089935e-28,  3.055249213551968e-01, -1.504234176242167e-03,
  4.809070035648790e-06, -1.019558221037475e-08,  5.535121969734157e-12,  6.737161010028227e-14, -3.582658033217398e-16,  9.329994282443649e-19, -3.444045045090300e-22,
 -9.451716993329801e-24,  5.055147269745201e-26, -1.319636419471401e-28,  3.602156525086623e-01, -1.737797034280213e-03,  5.252638819946873e-06, -9.354638877162216e-09,
 -4.667395804927160e-12,  1.071995984761795e-13, -4.146457714546628e-16,  6.343587780455523e-19,  2.067132887189372e-21, -1.758416358067133e-23,  5.634795926753724e-26,
 -3.642230781438598e-29,  4.191431135753118e-01, -1.976136443996108e-03,  5.588748053446950e-06, -7.714340296344834e-09, -1.729345862629268e-11,  1.442894318390758e-13,
 -4.047128405856068e-16,  5.462233366648773e-21,  5.070232802034311e-21, -2.267340499785650e-23,  3.347987798150769e-26,  1.633044551372208e-28,  4.821972780784722e-01,
 -2.215230467846338e-03,  5.786538831419873e-06, -5.217338839097356e-09, -3.160157691414975e-11,  1.715849750926118e-13, -3.029640496162344e-16, -9.265295678420660e-19,
  7.834941405277518e-21, -2.025323799893756e-23, -2.541494810420199e-26,  4.077053591076648e-28,  5.492445595591657e-01, -2.450572945993889e-03,  5.815444468650349e-06,
 -1.856371798908724e-09, -4.642742734052433e-11,  1.810882515593962e-13, -9.434874167200316e-17, -2.025169481710518e-18,  9.132748466137299e-21, -6.635259619778619e-24,
 -1.108453471912587e-25,  5.525356548159947e-28,  6.201230830230240e-01, -2.677151416336237e-03,  5.646526081769948e-06,  2.310402408351037e-09, -6.017585584936090e-11,
  1.648998527987052e-13,  2.168112974698567e-16, -3.027500063704181e-18,  7.599533574629756e-21,  1.855692729277301e-23, -1.888550797293553e-25,  4.056603975618782e-28,
  6.946370512997907e-01, -2.889436360691455e-03,  5.254234215677830e-06,  7.143564906576765e-09, -7.086761451142825e-11,  1.167752702628166e-13,  5.979220475482265e-16,
 -3.560461384250740e-18,  2.252914964766724e-21,  4.966818913005430e-23, -2.035849958929508e-25, -1.590762625107253e-28,  7.725500647817144e-01, -3.081389117256490e-03,
  4.618677263159405e-06,  1.240773420447080e-08, -7.626630103766717e-11,  3.417888338281657e-14,  9.819594035900354e-16, -3.210611472308683e-18, -6.778048037564886e-21,
  7.362418572223333e-23, -9.846545793722415e-26, -1.028709652869039e-27,  8.535772506342306e-01, -3.246498709752712e-03,  3.728463015104616e-06,  1.776071990234967e-08,
 -7.411336051511938e-11, -7.934049578901134e-14,  1.268184258853729e-15, -1.660940582893541e-18, -1.751675182304321e-20,  7.211892677197771e-23,  1.412695711584754e-25,
 -1.718651240315445e-27,  9.373760707367170e-01, -3.377861559167199e-03,  2.584138504503522e-06,  2.275068462362234e-08, -6.249520382557894e-11, -2.118871141830064e-13,
  1.334935208658468e-15,  1.111812109922312e-18, -2.582734408061417e-20,  2.946908639132086e-23,  4.383369859849079e-25, -1.469640144126410e-27,  1.023535717762301e+00,
 -3.468322546919241e-03,  1.202167499069628e-06,  2.682718039083595e-08, -4.035040404916421e-11, -3.418656675054991e-13,  1.069365543292981e-15,  4.626979459556879e-18,
 -2.614973351378185e-20, -5.400352821901978e-23,  6.044499886159231e-25,  2.463430458442490e-28,  1.111565093109418e+00, -3.510700914862326e-03, -3.807698797964143e-07,
  2.937361326205744e-08, -8.088101983330218e-12, -4.387437375156461e-13,  4.154792528464442e-16,  7.785063899681368e-18, -1.383693160528685e-20, -1.484767363465623e-22,
  4.100956523169431e-25,  2.901003749798956e-27,  1.200879513385817e+00, -3.498129243041889e-03, -2.103623943576858e-06,  2.976961590788350e-08,  3.177785982069450e-11,
 -4.674061710667754e-13, -5.669714576304888e-16,  9.014227920492891e-18,  1.102084658159520e-20, -1.936450758941121e-22, -2.258403461247234e-25,  4.440089968483959e-27,
  1.290786546691921e+00, -3.424536585776908e-03, -3.877813792893657e-06,  2.749055622797638e-08,  7.417477810465967e-11, -3.973337791955279e-13, -1.655192536568726e-15,
  6.840703544255685e-18,  3.993058824542653e-20, -1.259602535173470e-22, -1.008544555292540e-24,  2.329103419330274e-27,  1.380471775960064e+00, -3.285304724892679e-03,
 -5.586404026068007e-06,  2.224570000980951e-08,  1.115122284891352e-10, -2.164908924102845e-13, -2.467767901364319e-15,  8.836318550564364e-19,  5.609929482197744e-20,
  6.308511834029167e-23, -1.257953360282778e-24, -3.465445378700087e-27,  1.468985864352054e+00, -3.078114453217178e-03, -7.087529777586087e-06,  1.414344789588050e-08,
  1.346194679101729e-10,  5.321810288135290e-14, -2.567987218195437e-15, -7.121801726521084e-18,  4.239178378809037e-20,  2.724218578432184e-22, -4.071228786352260e-25,
 -8.003227739145910e-27,  1.555235080861610e+00, -2.803969785593461e-03, -8.224411686584892e-06,  3.849296770524408e-09,  1.349173215363123e-10,  3.466148071110411e-13,
 -1.684991919079433e-15, -1.318882367348538e-17, -3.124916980295898e-21,  3.178611855254102e-22,  1.146224772727430e-24, -4.572725046928642e-27,  1.637978406217973e+00,
 -2.468333908284267e-03, -8.844204300794188e-06, -7.328624476354902e-09,  1.077828989641490e-10,  5.636432947881508e-13,  1.585010729683392e-17, -1.286769768846194e-17,
 -5.487304836283832e-20,  9.260139867133444e-23,  1.854892756610317e-24,  5.625408671451865e-27,  1.715835348385802e+00, -2.082225995026858e-03, -8.826665315947288e-06,
 -1.751926418705080e-08,  5.624093480774226e-11,  6.051296374166304e-13,  1.810230785263844e-15, -4.865240221228361e-18, -7.020156983626382e-20, -2.453171385423191e-22,
  5.735902533623758e-25,  9.907143599073942e-27,  1.787309347639730e+00, -1.663017548199225e-03, -8.120521999857193e-06, -2.462492921632347e-08, -6.995690791184782e-12,
  4.310726935250862e-13,  2.689064713856207e-15,  6.134186542678627e-18, -2.918211406469662e-20, -3.430126090941674e-22, -1.390090962020845e-24,  6.247732238035104e-28,
  1.850831613333911e+00, -1.234557564580712e-03, -6.780216168982080e-06, -2.693737448920683e-08, -6.174936046369571e-11,  1.098732372319847e-13,  2.061950601151495e-15,
  1.169181707755028e-17,  3.155404431044076e-20, -7.608020601215673e-23, -1.400850047067465e-24, -8.215825163582801e-27,  1.904828701224188e+00, -8.262068226760586e-04,
 -4.989628416650799e-06, -2.389941163537609e-08, -8.830079521775596e-11, -1.928172781812841e-13,  4.075478398334782e-16,  7.497203296843216e-18,  4.886917973811501e-20,
  2.001153832896484e-22,  3.384489963144419e-25, -2.623529263075994e-27,  1.947813494888575e+00, -4.704588194806628e-04, -3.055904555118250e-06, -1.667452993970442e-08,
 -7.862190263812374e-11, -3.128029909471724e-13, -9.371847454870028e-16, -9.437983913163608e-19,  1.359287589499900e-20,  1.390240115908144e-22,  8.680959883839276e-25,
  4.058655653625860e-27,  1.978493655039958e+00, -1.991386646476926e-04, -1.360767777063053e-06, -8.087283161639364e-09, -4.379424105098743e-11, -2.193100376185152e-13,
 -1.015024532499944e-15, -4.277427302094074e-18, -1.575144985000350e-20, -4.471709283213903e-23, -3.965227504459720e-26,  6.993845543294044e-28,  1.995888845957846e+00,
 -3.864753897505165e-05, -2.716665481650589e-07, -1.690750136992639e-09, -9.816368259869236e-12, -5.438776323893047e-14, -2.908952640199532e-16, -1.511438033436014e-18,
 -7.655014252593584e-21, -3.785229471727609e-23, -1.827767432250897e-25, -8.609373294301811e-28,  5.705521328587330e-04, -3.067057769055064e-06,  1.236233234155671e-08,
 -4.428262784398719e-11,  1.486447905599515e-13, -4.788557025083454e-16,  1.498748630753352e-18, -4.593794822456641e-21,  1.384495678044870e-23, -4.121229883423020e-26,
  1.211976958560947e-28, -3.539203574567830e-31,  5.134503965885699e-03, -2.756574925742531e-05,  1.107872766185754e-07, -3.948189810198296e-10,  1.314774637034213e-12,
 -4.187194673379843e-15,  1.290142003387109e-17, -3.873668726080225e-20,  1.136957318868789e-22, -3.273891136098653e-25,  9.237977971887348e-28, -2.565344572679259e-30,
  1.425989991154573e-02, -7.636106112722069e-05,  3.051090298328571e-07, -1.076089105104738e-09,  3.525303450745290e-12, -1.096155334579694e-14,  3.266109362472348e-17,
 -9.369313327070134e-20,  2.586332241062725e-22, -6.861186702653721e-25,  1.731596704971580e-27, -4.124432191901764e-30,  2.794159641049294e-02, -1.490458316661980e-04,
  5.902636458330335e-07, -2.048792247877000e-09,  6.542026424987831e-12, -1.957028162566076e-14,  5.509842573145358e-17, -1.455168789401512e-19,  3.549664770435189e-22,
 -7.744299002386076e-25,  1.365846322354751e-27, -1.232472221888117e-30,  4.617155347039045e-02, -2.450017372923987e-04,  9.586373424681184e-07, -3.254762566129663e-09,
  1.002094149595304e-11, -2.829808993626661e-14,  7.270492914219632e-17, -1.648021215679809e-19,  2.991911698270242e-22, -2.684882634968157e-25, -1.038537442967159e-27,
  7.830090470186131e-30,  6.893843270985768e-02, -3.633901076712049e-04,  1.400048900049203e-06, -4.617980165448700e-09,  1.352865983510530e-11, -3.510359861500796e-14,
  7.729845156174324e-17, -1.237389239464906e-19,  1.532022550154760e-23,  9.619506712802868e-25, -5.309398349218181e-27,  2.006906254680876e-29,  9.622704027289096e-02,
 -5.031395416357940e-04,  1.901732955965409e-06, -6.046035916112230e-09,  1.656498976743623e-11, -3.782676816937712e-14,  6.146059596517654e-17, -4.220397908619977e-21,
 -5.069505161204782e-22,  2.705323502931330e-24, -9.800010241333515e-27,  2.717559946656049e-29,  1.280175954234799e-01, -6.629302246934304e-04,  2.448330763854546e-06,
 -7.432154349151815e-09,  1.859221268036928e-11, -3.444217925030961e-14,  2.015195380490371e-17,  1.941632979497124e-19, -1.182551369074316e-21,  4.345250576172265e-24,
 -1.154193639308375e-26,  1.819771653670590e-29,  1.642847994583715e-01, -8.411748513175669e-04,  3.021897646513033e-06, -8.657909482477507e-09,  1.907157090768994e-11,
 -2.335073958893284e-14, -4.764370244962668e-17,  4.477309790999665e-19, -1.820282981222732e-21,  4.937383983407949e-24, -7.180567587458927e-27, -1.438597435122256e-29,
  2.049966724274492e-01, -1.035996082328136e-03,  3.601939794587906e-06, -9.596800421002181e-09,  1.750736519062653e-11, -3.697176491379837e-15, -1.374501592773372e-16,
  7.056874975900796e-19, -2.141229207497671e-21,  3.460724544749752e-24,  5.343486482455242e-27, -6.678792492058986e-29,  2.501131167768518e-01, -1.245200531971747e-03,
  4.165497477455658e-06, -1.011888522578503e-08,  1.349874556940589e-11,  2.430691430502043e-14, -2.382720296093032e-16,  8.924111925036669e-19, -1.834118364745463e-21,
 -7.622545180850061e-25,  2.474706289987528e-26, -1.178229395789540e-28,  2.995841571632803e-01, -1.466249398936287e-03,  4.687297396988029e-06, -1.009669912399318e-08,
  6.798678701157042e-12,  5.908517253152970e-14, -3.323445485876211e-16,  9.169132131795527e-19, -6.496655335485083e-22, -7.545395266431037e-24,  4.478104276307356e-26,
 -1.297260483866767e-28,  3.533477940582660e-01, -1.696226056457387e-03,  5.140004100503538e-06, -9.412699806134710e-09, -2.621443890009926e-12,  9.746814980958171e-14,
 -3.960497347472797e-16,  6.908099478773648e-19,  1.474215581713659e-21, -1.537006011615142e-23,  5.417945809142777e-26, -6.084711668708502e-29,  4.113273951224706e-01,
 -1.931801235830729e-03,  5.494609320295894e-06, -7.968476698531378e-09, -1.450469709616315e-11,  1.345957482988640e-13, -4.024092231225284e-16,  1.549212998703803e-19,
  4.279672779239495e-21, -2.120736413695800e-23,  3.942026814946448e-26,  1.081254012849161e-28,  4.734285325162044e-01, -2.169196926887476e-03,  5.721008957437533e-06,
 -5.695913858371182e-09, -2.824454661555848e-11,  1.640301752435301e-13, -3.255076357544267e-16, -6.876396140145775e-19,  7.091668205552270e-21, -2.093093997318565e-23,
 -8.960222854367144e-27,  3.404610756059714e-28,  5.395351563360798e-01, -2.404150849989766e-03,  5.788830042500494e-06, -2.570378235457849e-09, -4.283272946317956e-11,
  1.781761986909859e-13, -1.470037537533227e-16, -1.737552102892646e-18,  8.819853746973106e-21, -1.059138276588851e-23, -8.719885234269787e-26,  5.199309989133894e-28,
  6.095049745906428e-01, -2.631884423855724e-03,  5.668583700677438e-06,  1.374227093136105e-09, -5.683254599961666e-11,  1.691141298700967e-13,  1.355361306693473e-16,
 -2.775047993336169e-18,  8.136097110360007e-21,  1.137992985160347e-23, -1.695502402432125e-25,  4.667557830156309e-28,  6.831638895424389e-01, -2.847078689445272e-03,
  5.333233208647919e-06,  6.029113079563930e-09, -6.839663403329479e-11,  1.299388266146772e-13,  4.994959709811879e-16, -3.461341216189219e-18,  3.893213311297883e-21,
  4.144056423884825e-23, -2.064705233372377e-25,  2.288986120857073e-29,  7.602993209292258e-01, -3.043864812225649e-03,  4.760275130064948e-06,  1.119419150937797e-08,
 -7.535445116145006e-11,  5.664505393517051e-14,  8.894182591509235e-16, -3.385945985071439e-18, -4.208744253300831e-21,  6.885030562890972e-23, -1.384876967625448e-25,
 -7.899110154838239e-28,  8.406522324130782e-01, -3.215838759847142e-03,  3.934429717526567e-06,  1.656384844640756e-08, -7.539989026476603e-11, -4.952305586460571e-14,
  1.214227652011139e-15, -2.178991820350468e-18, -1.483672693903640e-20,  7.628615682625174e-23,  6.792666358340404e-26, -1.604305849088617e-27,  9.239076753596741e-01,
 -3.356113727677748e-03,  2.851012998596130e-06,  2.171860909759972e-08, -6.641051814069186e-11, -1.795673939572126e-13,  1.354678154714197e-15,  3.055641202812784e-19,
 -2.446713704517972e-20,  4.563407022643967e-23,  3.682439072213636e-25, -1.698683580826058e-27,  1.009683684952335e+00, -3.457428987942270e-03,  1.519999026845277e-06,
  2.612831219819952e-08, -4.692107137992423e-11, -3.147424160246448e-13,  1.186946957706617e-15,  3.763758444273353e-18, -2.765772382400594e-20, -2.979251990115868e-23,
  6.016433559792458e-25, -3.650646666953328e-28,  1.097518425546304e+00, -3.512340003434318e-03, -2.935059412211863e-08,  2.917461956880821e-08, -1.674588429939292e-11,
 -4.262113080667428e-13,  6.264825084833833e-16,  7.260164908649406e-18, -1.885762374847249e-20, -1.296932050986855e-22,  5.245764233524405e-25,  2.283300559522494e-27,
  1.186855612181849e+00, -3.513521364281144e-03, -1.743648525076886e-06,  3.020262379625579e-08,  2.231428594551999e-11, -4.779513483069826e-13, -3.106939445365743e-16,
  9.253997282618212e-18,  3.934564526501242e-21, -1.987243613471532e-22, -2.744321116351596e-26,  4.533504174000589e-27,  1.277028472280001e+00, -3.454219991517930e-03,
 -3.541075387216148e-06,  2.861168856678404e-08,  6.584709847377587e-11, -4.346199976168319e-13, -1.446499872785731e-15,  8.038365513082134e-18,  3.469786474979045e-20,
 -1.638919038156419e-22, -8.793680280418038e-25,  3.518010058573563e-27,  1.367242907629857e+00, -3.328898182091020e-03, -5.308903728033647e-06,  2.399205123868743e-08,
  1.065932064230812e-10, -2.752158223848391e-13, -2.417623158604744e-15,  2.705160236631464e-18,  5.743149580078927e-20,  1.011817255304817e-23, -1.379948901984716e-24,
 -2.032745966923445e-27,  1.456561132737506e+00, -3.134099130633069e-03, -6.904860835508880e-06,  1.630246069667176e-08,  1.350521909962282e-10, -1.064429474318230e-14,
 -2.746958227580862e-15, -5.612187308992631e-18,  5.182012484189773e-20,  2.490079187505486e-22, -7.647703554923615e-25, -8.166156522026049e-27,  1.543887956162930e+00,
 -2.869543103374144e-03, -8.165046757359725e-06,  6.061109432317531e-09,  1.414152949540805e-10,  3.017431358218953e-13, -2.053898066722276e-15, -1.309731746536578e-17,
  9.088821104607477e-21,  3.590205912487658e-22,  8.952530742997995e-25, -6.834126373857233e-27,  1.627963048858148e+00, -2.539409143467402e-03, -8.921428907896177e-06,
 -5.514020522958916e-09,  1.190293744528719e-10,  5.595053337913754e-13, -3.684226186087634e-16, -1.455551783430761e-17, -5.014807430410253e-20,  1.713143722574602e-22,
  2.068742229231293e-24,  3.975316025828700e-27,  1.707363909124776e+00, -2.153664009816681e-03, -9.031090462248190e-06, -1.652027893409612e-08,  6.876560267108037e-11,
  6.466786264522808e-13,  1.641262762854887e-15, -7.247681012702382e-18, -7.851019922955112e-20, -2.131377276457342e-22,  1.047668749416066e-24,  1.159048822023100e-26,
  1.780525475806881e+00, -1.729164945334415e-03, -8.416396715516115e-06, -2.466432574852225e-08,  2.284455781126704e-12,  4.975540192086425e-13,  2.845815957330053e-15,
  4.992144975403023e-18, -4.251880659100102e-20, -3.973975756638124e-22, -1.311366093950478e-24,  3.068158668765205e-27,  1.845782828907543e+00, -1.290108898697116e-03,
 -7.109311066450661e-06, -2.790498243255356e-08, -5.902993305633477e-11,  1.633996664108853e-13,  2.402964660646534e-15,  1.264618518275930e-17,  2.771678776390149e-20,
 -1.396301117990273e-22, -1.783245053771262e-24, -9.118809781337072e-27,  1.901442189234419e+00, -8.672953288460206e-04, -5.285023567679376e-06, -2.534246904225866e-08,
 -9.204138380729612e-11, -1.803336148069222e-13,  6.404631344511746e-16,  9.178642865710073e-18,  5.628494570074051e-20,  2.108707976540591e-22,  1.867033067841176e-25,
 -4.357488228567743e-27,  1.945881467045776e+00, -4.957283019574104e-04, -3.263757047977553e-06, -1.798375898839010e-08, -8.510475278192061e-11, -3.355585163071098e-13,
 -9.567192358767734e-16, -4.216863173222248e-19,  1.926751350675581e-20,  1.775069545577583e-22,  1.060699156801389e-24,  4.696000490492850e-27,  1.977674696195844e+00,
 -2.104252506464633e-04, -1.462168568005082e-06, -8.824445981443063e-09, -4.843404960616393e-11, -2.451662960164831e-13, -1.142092956703785e-15, -4.807469995451778e-18,
 -1.738137196674426e-20, -4.557295726122281e-23, -3.872036293807644e-29,  1.126076896562634e-27,  1.995729776758492e+00, -4.090478262649610e-05, -2.929350863778327e-07,
 -1.856908302223069e-09, -1.097751491928013e-11, -6.190608475105485e-14, -3.368603381488085e-16, -1.779690019937845e-18, -9.158958276615735e-21, -4.598017360016303e-23,
 -2.251683559123908e-25, -1.074098732853003e-27,  5.584783897559684e-04, -2.970244960452882e-06,  1.184490087590995e-08, -4.197901658867789e-11,  1.394172104911408e-13,
 -4.443805252398506e-16,  1.376108373851105e-18, -4.173588461476535e-21,  1.244495085481648e-23, -3.666194075546051e-26,  1.066517711723722e-28, -3.083797827686074e-31,
  5.025984055657146e-03, -2.669805099390074e-05,  1.061729571684941e-07, -3.744360760369791e-10,  1.234041309012238e-12, -3.890175636376186e-15,  1.186600624394171e-17,
 -3.528008329271184e-20,  1.025485250822628e-22, -2.925998065188991e-25,  8.179369529750370e-28, -2.253658349230577e-30,  1.395925696083500e-02, -7.397089867228154e-05,
  2.925272906408527e-07, -1.021396383782703e-09,  3.313703288473637e-12, -1.020825512761332e-14,  3.014993359085290e-17, -8.579905410075980e-20,  2.351370871129570e-22,
 -6.203617643756490e-25,  1.559208005830751e-27, -3.718062887020591e-30,  2.735470406744967e-02, -1.444203143830635e-04,  5.662934860148787e-07, -1.947180584344362e-09,
  6.163520908031113e-12, -1.829555490699453e-14,  5.117886143214354e-17, -1.345935886483555e-19,  3.280567978013770e-22, -7.209391555415158e-25,  1.307381067406806e-27,
 -1.412624379847933e-30,  4.520664114884398e-02, -2.374861838645922e-04,  9.205238281842046e-07, -3.098861938925694e-09,  9.472060661404274e-12, -2.660747247590267e-14,
  6.822300092790520e-17, -1.553900249672903e-19,  2.888566433569804e-22, -3.036001854285765e-25, -7.279719831600761e-28,  6.330960077840325e-30,  6.750692722055665e-02,
 -3.524077524317180e-04,  1.345909044326130e-06, -4.407038563286728e-09,  1.284485926818795e-11, -3.328992608332459e-14,  7.384554875263414e-17, -1.227339054758169e-19,
  4.633276707263737e-23,  7.663918948075751e-25, -4.488768320016166e-27,  1.729119793737288e-29,  9.424445662072034e-02, -4.882114390111504e-04,  1.830746057745590e-06,
 -5.786968290155208e-09,  1.582318627353243e-11, -3.635487771090398e-14,  6.112942613396215e-17, -1.895791070563907e-20, -4.163336045197844e-22,  2.336481240506484e-24,
 -8.660673484975205e-27,  2.462656511643518e-29,  1.254044900438107e-01, -6.436953170820185e-04,  2.360907122234943e-06, -7.140161643475551e-09,  1.790862442899797e-11,
 -3.389742820284180e-14,  2.508163350197834e-17,  1.587369946222361e-19, -1.034237542239634e-21,  3.899800650511342e-24, -1.072647417667391e-26,  1.876152771522923e-29,
  1.609677996905299e-01, -8.174100982094085e-04,  2.919818002161171e-06, -8.356558447614460e-09,  1.859410375336711e-11, -2.435017075509188e-14, -3.589640246115404e-17,
  3.922693096410192e-19, -1.647840855047680e-21,  4.639550332841600e-24, -7.663266070309698e-27, -7.812238491769959e-30,  2.009095964920103e-01, -1.007636455139702e-03,
  3.488455893892477e-06, -9.317446780865655e-09,  1.740199459995319e-11, -6.766495545162167e-15, -1.186311885965175e-16,  6.391972830879056e-19, -2.013467814398572e-21,
  3.619641614327035e-24,  2.696751251170921e-27, -5.382717723679192e-29,  2.451981988030643e-01, -1.212358552014582e-03,  4.045381793348874e-06, -9.899318520937816e-09,
  1.392968819746469e-11,  1.888158481154295e-14, -2.141090219445240e-16,  8.334615128938185e-19, -1.844951582511656e-21,  1.282688973899144e-25,  1.988507718581368e-26,
 -1.032788966569871e-28,  2.937933917023587e-01, -1.429233725040734e-03,  4.566827296788150e-06, -9.978891330807008e-09,  7.902685857394193e-12,  5.141439810936186e-14,
 -3.070004639903757e-16,  8.921123923646487e-19, -8.904207721491783e-22, -5.866927534501786e-24,  3.918145941542707e-26, -1.243707223144459e-28,  3.466444137173645e-01,
 -1.655558401447519e-03,  5.026862718467503e-06, -9.439557787244074e-09, -7.655406386064606e-13,  8.819990262992034e-14, -3.761268403729609e-16,  7.295443796752370e-19,
  9.592061278609590e-22, -1.326196163161949e-23,  5.110072243056961e-26, -7.799320652081035e-29,  4.036874930196853e-01, -1.888230592242753e-03,  5.397682287090150e-06,
 -8.179539529625751e-09, -1.190893195692857e-11,  1.250047614502443e-13, -3.962666882797204e-16,  2.799681468358808e-19,  3.545605122658976e-21, -1.954974745180455e-23,
  4.312081851732205e-26,  6.147321605931653e-29,  4.648428375418195e-01, -2.123709695072350e-03,  5.650053382837625e-06, -6.122012332046989e-09, -2.504349494207778e-11,
  1.560118905315408e-13, -3.416980850028894e-16, -4.728034841591651e-19,  6.335137087620290e-21, -2.100904374220228e-23,  4.583654666359199e-27,  2.757711551047937e-28,
  5.300109627756857e-01, -2.357974968804882e-03,  5.753990493167562e-06, -3.227401380424201e-09, -3.930826391216183e-11,  1.740958084007971e-13, -1.917657825324944e-16,
 -1.462046575980582e-18,  8.381182399875419e-21, -1.363421712262444e-23, -6.526840640263478e-26,  4.753041200013025e-28,  5.990682171921859e-01, -2.586484991729601e-03,
  5.679730618308736e-06,  4.921154722772611e-10, -5.342387505316203e-11,  1.714643337606693e-13,  6.153225077221599e-17, -2.509406079239674e-18,  8.428755722131869e-21,
  5.020120508822499e-24, -1.482055104050441e-25,  4.990517928730100e-28,  6.718613387298127e-01, -2.804141828656488e-03,  5.399104268842736e-06,  4.956175808439153e-09,
 -6.568575039112263e-11,  1.407791187218053e-13,  4.045355140826443e-16, -3.314477774247812e-18,  5.237085901130139e-21,  3.324846805715353e-23, -2.020402051279214e-25,
  1.730897052622240e-28,  7.482008480276620e-01, -3.005265692928806e-03,  4.887412454833187e-06,  9.998710821766614e-09, -7.401583810482810e-11,  7.684044589179248e-14,
  7.930908765473008e-16, -3.482100930844002e-18, -1.837581906467176e-21,  6.268571950423378e-23, -1.680227086734472e-25, -5.540844270892188e-28,  8.278530580616780e-01,
 -3.183588831246557e-03,  4.125929894166529e-06,  1.535108818952615e-08, -7.610414514211799e-11, -2.116483011048224e-14,  1.146984840373548e-15, -2.609437200260518e-18,
 -1.205810976870404e-20,  7.763832716351289e-23,  9.321730917036664e-28, -1.432916191236087e-27,  9.105304614242071e-01, -3.332281455570786e-03,  3.105148109867303e-06,
  2.062907786227454e-08, -6.967650068527085e-11, -1.470393059293691e-13,  1.352539051901343e-15, -4.484051541213497e-19, -2.257759892311657e-20,  5.882531963025887e-23,
  2.904270416860667e-25, -1.821190127206835e-27,  9.958802561011628e-01, -3.444028067455524e-03,  1.828831727587614e-06,  2.532879806900047e-08, -5.292303669762842e-11,
 -2.850919024556274e-13,  1.279813179840049e-15,  2.866154037971116e-18, -2.830246025721414e-20, -6.213606623610524e-24,  5.733518023172377e-25, -9.070532615219672e-28,
  1.083470805916699e+00, -3.511179623524176e-03,  3.188587683901482e-07,  2.883937638009594e-08, -2.510365878059304e-11, -4.088086663056504e-13,  8.206469623591017e-16,
  6.586251795076019e-18, -2.312652032074190e-20, -1.069049047762741e-22,  6.096595027052456e-25,  1.573038921563256e-27,  1.172775931355822e+00, -3.526015485733884e-03,
 -1.379391387185749e-06,  3.048286328011793e-08,  1.270172598000154e-11, -4.822910408098330e-13, -5.089408972235387e-17,  9.265614874445995e-18, -3.191456326798766e-21,
 -1.958646800152186e-22,  1.691607090923916e-25,  4.359904864393523e-27,  1.263157133995409e+00, -3.481157995641969e-03, -3.191706547804283e-06,  2.959389541731651e-08,
  5.682639400556124e-11, -4.665153228375165e-13, -1.206814531653589e-15,  9.047828366342371e-18,  2.820476784102749e-20, -1.956607351272846e-22, -7.018097919078187e-25,
  4.514077524521796e-27,  1.353844236192371e+00, -3.370189238770803e-03, -5.010957940473116e-06,  2.565038491920525e-08,  1.005158690292025e-10, -3.321222201808435e-13,
 -2.316171429264806e-15,  4.537996319596766e-18,  5.678495412527066e-20, -4.639103539148221e-23, -1.433347034005397e-24, -3.644375402500167e-28,  1.443915549237707e+00,
 -3.188518804710507e-03, -6.696285062840974e-06,  1.845796067897807e-08,  1.341683094247436e-10, -7.826155099396529e-14, -2.879582572041724e-15, -3.817117915322157e-18,
  6.014778922045028e-20,  2.113059112481636e-22, -1.117418878565808e-24, -7.765851694979428e-27,  1.532279658531128e+00, -2.934533638587193e-03, -8.078547439977704e-06,
  8.369230830303900e-09,  1.469277387991728e-10,  2.480939230001298e-13, -2.414562468789280e-15, -1.259339523867258e-17,  2.257974269742882e-20,  3.881675931645385e-22,
  5.463762218692389e-25, -8.989106562562064e-27,  1.617662297179935e+00, -2.611012025099923e-03, -8.975803003222062e-06, -3.520651853715529e-09,  1.300971369054173e-10,
  5.455974788891098e-13, -7.974006410104732e-16, -1.604530408957443e-17, -4.245491649569004e-20,  2.569140595803340e-22,  2.193884257834376e-24,  1.592628743727595e-27,
  1.698603527815922e+00, -2.226686006166891e-03, -9.222298772027603e-06, -1.531449469772530e-08,  8.207514437246386e-11,  6.833430435801476e-13,  1.402065189331802e-15,
 -9.873664112232141e-18, -8.530215819467682e-20, -1.606245635173004e-22,  1.587070282404146e-24,  1.283277269449389e-26,  1.773472281094311e+00, -1.797678604706523e-03,
 -8.711808787543745e-06, -2.454441028261267e-08,  1.292900219896446e-11,  5.673636413898834e-13,  2.964326478690261e-15,  3.392833864084339e-18, -5.772889123276864e-20,
 -4.462771624338734e-22, -1.109692918315380e-24,  6.214645778849347e-27,  1.840506501243367e+00, -1.348338613197055e-03, -7.449719402158775e-06, -2.882006181855556e-08,
 -5.515605025564249e-11,  2.254150038911603e-13,  2.768616534419798e-15,  1.343813220375524e-17,  2.130771641120939e-20, -2.191705187271309e-22, -2.197498834146405e-24,
 -9.625863703153390e-27,  1.897886485816407e+00, -9.108172593899657e-04, -5.598085236135022e-06, -2.684305826500483e-08, -9.547244601460266e-11, -1.616678932355642e-13,
  9.238299470098252e-16,  1.110225216178917e-17,  6.395885670371692e-20,  2.138748240492303e-22, -5.313060155150137e-26, -6.641862766184202e-27,  1.943844933596583e+00,
 -5.227252454342682e-04, -3.487957729688590e-06, -1.940037463980703e-08, -9.204610588272693e-11, -3.585855856778380e-13, -9.588731630789290e-16,  3.057218987539645e-19,
  2.647293642929503e-20,  2.242503432358840e-22,  1.280889540046885e-24,  5.301391642085190e-27,  1.976808910735816e+00, -2.225597292195678e-04, -1.572878350316913e-06,
 -9.640153588990784e-09, -5.362271242583429e-11, -2.742562013139221e-13, -1.284735006620886e-15, -5.389817823713014e-18, -1.900862679848815e-20, -4.442060047415168e-23,
  6.204769982024635e-26,  1.729989169202300e-27,  1.995561325198447e+00, -4.334047783781841e-05, -3.163141561224418e-07, -2.042910339083229e-09, -1.230069731935841e-11,
 -7.062342150838945e-14, -3.910566668354650e-16, -2.101096390833697e-18, -1.098842755025727e-20, -5.600677813192130e-23, -2.781195475634364e-25, -1.343127056823598e-27,
  5.467837905830302e-04, -2.877463488754639e-06,  1.135424914394017e-08, -3.981768659781604e-11,  1.308506277987546e-13, -4.127124397779468e-16,  1.264630540457437e-18,
 -3.795669775669599e-21,  1.119875000261729e-23, -3.265526961639524e-26,  9.396749455469175e-29, -2.691376965325206e-31,  4.920862628055044e-03, -2.586631042314548e-05,
  1.017956739258927e-07, -3.552986992399260e-10,  1.159007498485959e-12, -3.616884291033911e-15,  1.092256602131499e-17, -3.216094246727584e-20,  9.258070580060962e-23,
 -2.617829593961665e-25,  7.248806562876323e-28, -1.982372196092698e-30,  1.366797742899257e-02, -7.167882131139335e-05,  2.805820372605401e-07, -9.699719382441678e-10,
  3.116583885944724e-12, -9.512655161062822e-15,  2.784962809158027e-17, -7.862027190547996e-20,  2.138882814864439e-22, -5.611544627540023e-25,  1.403832706451649e-27,
 -3.350657160131376e-30,  2.678593785063551e-02, -1.399817820672380e-04,  5.435071546728541e-07, -1.851426061658178e-09,  5.809593508640785e-12, -1.711132304855483e-14,
  4.755337991515601e-17, -1.245010630106048e-19,  3.030289715876436e-22, -6.699247769519301e-25,  1.242509859613897e-27, -1.526561416024649e-30,  4.427119286579834e-02,
 -2.302682020843285e-04,  8.842295259856589e-07, -2.951478661798543e-09,  8.955937662140696e-12, -2.502129728322504e-14,  6.399980789383679e-17, -1.463265845259411e-19,
  2.774664957554561e-22, -3.275327171890256e-25, -4.777651327340867e-28,  5.079454826968742e-30,  6.611850068710215e-02, -3.418485741072815e-04,  1.294236025444209e-06,
 -4.206752073671429e-09,  1.219650628737622e-11, -3.155867967587521e-14,  7.043366552844056e-17, -1.208430251619117e-19,  7.086752669080313e-23,  6.013161714880149e-25,
 -3.782778212731090e-27,  1.485212888951669e-29,  9.232046899590912e-02, -4.738389958629750e-04,  1.762797727581185e-06, -5.539534584032781e-09,  1.511070932587197e-11,
 -3.489557142203275e-14,  6.042426759291570e-17, -3.099955754262346e-20, -3.382014702799507e-22,  2.010997471902125e-24, -7.631321233575412e-27,  2.218220939990599e-29,
  1.228669474464114e-01, -6.251459680215454e-04,  2.276922148071291e-06, -6.859013089148555e-09,  1.723703668448121e-11, -3.324574636913898e-14,  2.908345563535733e-17,
  1.278064875568684e-19, -9.013684502400687e-22,  3.487286623941487e-24, -9.899269231309862e-27,  1.875804349605892e-29,  1.577442483782619e-01, -7.944476486996459e-04,
  2.821308121960934e-06, -8.062991994632754e-09,  1.809934472076792e-11, -2.508568831859237e-14, -2.562641044339188e-17,  3.421510486440232e-19, -1.486402619730339e-21,
  4.327752955191834e-24, -7.889216111233974e-27, -2.675400916813215e-30,  1.969341645073744e-01, -9.801713233519446e-04,  3.378312173333337e-06, -9.040246245905195e-09,
  1.723960578882485e-11, -9.406033446767192e-15, -1.016159861347420e-16,  5.768676194256760e-19, -1.881758573870768e-21,  3.683552469596324e-24,  5.799838641390249e-28,
 -4.267723940951101e-29,  2.404127437400934e-01, -1.180466849156624e-03,  3.927938800005335e-06, -9.673693839737903e-09,  1.425778957808364e-11,  1.401634954795693e-14,
 -1.915968994894845e-16,  7.746418170741895e-19, -1.827074200760232e-21,  8.369053962672907e-25,  1.564708063069588e-26, -8.950683808952817e-29,  2.881487707776438e-01,
 -1.393175868328856e-03,  4.447871918454505e-06, -9.844613949408708e-09,  8.859299589332033e-12,  4.434273237003084e-14, -2.824498821735582e-16,  8.605314765413633e-19,
 -1.074719604042957e-21, -4.407031424828553e-24,  3.386816506440299e-26, -1.168566022462518e-28,  3.401018923874914e-01, -1.615796675788600e-03,  4.913571175410304e-06,
 -9.438177920288698e-09,  9.098576834127370e-13,  7.942102664975660e-14, -3.553388745520202e-16,  7.529876443201820e-19,  5.177069795819685e-22, -1.129022123681227e-23,
  4.740598704442926e-26, -8.903763307912737e-29,  3.962203075955714e-01, -1.845444804408739e-03,  5.298465392398706e-06, -8.350595523116838e-09, -9.503242220921563e-12,
  1.156006128534405e-13, -3.869425518616369e-16,  3.825043166686075e-19,  2.873403767465083e-21, -1.778270790518636e-23,  4.495138665421215e-26,  2.305129266765039e-29,
  4.564379250349922e-01, -2.078809702209708e-03,  5.574286572527732e-06, -6.498196020821431e-09, -2.200622155821847e-11,  1.476744853642818e-13, -3.522117577063414e-16,
 -2.821222769935896e-19,  5.584870583179672e-21, -2.060111747970486e-23,  1.537395915655828e-26,  2.155576321283786e-28,  5.206708667182385e-01, -2.312108389039505e-03,
  5.711602139750570e-06, -3.828741715669408e-09, -3.587553281299491e-11,  1.690320177794239e-13, -2.290254651204390e-16, -1.202165900752642e-18,  7.848261987735749e-21,
 -1.584165204974382e-23, -4.548448403795420e-26,  4.230325222511186e-28,  5.888131701452975e-01, -2.541037795503759e-03,  5.680620674392681e-06, -3.351753365759323e-10,
 -4.998535389107854e-11,  1.721285528693370e-13, -4.935775102272486e-18, -2.237895236000450e-18,  8.508102707581382e-21, -4.650115086257754e-25, -1.259946658663679e-25,
  5.068727993769457e-28,  6.607315088157707e-01, -2.760728747334787e-03,  5.452367084116612e-06,  3.928224775982054e-09, -6.278049436679635e-11,  1.493942944534661e-13,
  3.142452687281944e-16, -3.129282506382285e-18,  6.290737547555680e-21,  2.535608729564754e-23, -1.917245602087048e-25,  2.903953878571806e-28,  7.362587154974156e-01,
 -2.965706464127089e-03,  5.000345438139628e-06,  8.827752831028424e-09, -7.229661044628137e-11,  9.470003401562949e-14,  6.950985644759385e-16, -3.506137389209954e-18,
  2.928607693924015e-22,  5.554381351064134e-23, -1.874570354228695e-25, -3.324017851069052e-28,  8.151858550433814e-01, -3.149865262767296e-03,  4.302827760890357e-06,
  1.413150556942458e-08, -7.625829797775996e-11,  5.445012864142757e-15,  1.068938098551555e-15, -2.950689628811126e-18, -9.277113026518892e-21,  7.647447892073589e-23,
 -5.758548325939592e-26, -1.221870419699950e-27,  8.972525587455579e-01, -3.306469239030749e-03,  3.345916752188326e-06,  1.949248556147555e-08, -7.229410776153435e-11,
 -1.148086403871236e-13,  1.330202378374386e-15, -1.134920519342957e-18, -2.027022695253184e-20,  6.882628983265540e-23,  2.094615295575898e-25, -1.843341395959091e-27,
  9.821353092476796e-01, -3.428196448762624e-03,  2.127514008287233e-06,  2.443810909726392e-08, -5.831174837004027e-11, -2.535157506091646e-13,  1.347383426011679e-15,
  1.961236017272427e-18, -2.812423464426736e-20,  1.578319341692642e-23,  5.232334528204713e-25, -1.353665684278742e-27,  1.069433370505574e+00, -3.507251905637621e-03,
  6.622551540051455e-07,  2.837343972937017e-08, -3.306838587242462e-11, -3.869871688071438e-13,  9.941570374737468e-16,  5.789454742860516e-18, -2.652146112700722e-20,
 -8.135418724505179e-23,  6.623978061942306e-25,  8.216472159096239e-28,  1.158652119759242e+00, -3.535584717601216e-03, -1.012695948857488e-06,  3.060894588149856e-08,
  3.064617907052757e-12, -4.804172520429344e-13,  2.060647891323421e-16,  9.052345282900862e-18, -1.007550236229641e-20, -1.853687710522189e-22,  3.525567675982890e-25,
  3.937910187000373e-27,  1.249183704718217e+00, -3.505256403157832e-03, -2.831437227085998e-06,  3.042698946864244e-08,  4.722747133428826e-11, -4.923435050987361e-13,
 -9.419348229498178e-16,  9.832665383494152e-18,  2.070572746551155e-20, -2.195252588485634e-22, -4.861226236404215e-25,  5.240026995355099e-27,  1.340285291247576e+00,
 -3.409018867721062e-03, -4.693732655304922e-06,  2.720252585317772e-08,  9.332888886543220e-11, -3.859821722952937e-13, -2.163997861406873e-15,  6.317327939760386e-18,
  5.408374476137977e-20, -1.035237272638038e-22, -1.410252694980405e-24,  1.423072932146836e-27,  1.431055787595734e+00, -3.241166752838078e-03, -6.461973282650054e-06,
  2.058834446681187e-08,  1.319044740573138e-10, -1.484298857681158e-13, -2.958437381828241e-15, -1.779957123467395e-18,  6.687011673808601e-20,  1.600259576009900e-22,
 -1.439290260841597e-24, -6.765420337515296e-27,  1.520412960170229e+00, -2.998719974624286e-03, -7.963858387891681e-06,  1.075650283582032e-08,  1.512820376943018e-10,
  1.860077343088566e-13, -2.754935627219293e-15, -1.164384924025776e-17,  3.684660205004071e-20,  4.015419088320562e-22,  1.089710084310418e-25, -1.082097727087503e-26,
  1.607074419703173e+00, -2.682951232210034e-03, -9.005205197976308e-06, -1.352997274873288e-09,  1.407805646607065e-10,  5.209242783419039e-13, -1.264177240691555e-15,
 -1.723885552599642e-17, -3.161725820759734e-20,  3.452122101526954e-22,  2.198583355310667e-24, -1.486369324167279e-27,  1.689548096009947e+00, -2.301176117579043e-03,
 -9.397736836141418e-06, -1.389022881839261e-08,  9.605449230366302e-11,  7.133617270223755e-13,  1.086611746842870e-15, -1.268248225882796e-17, -8.980380443425240e-20,
 -8.563333561322813e-23,  2.166314409148202e-24,  1.335292014946742e-26,  1.766140318493248e+00, -1.868546802360896e-03, -9.004713466612806e-06, -2.424287423191946e-08,
  2.499426542722747e-11,  6.394235845484799e-13,  3.030990363365123e-15,  1.280485333778989e-18, -7.451821748072554e-20, -4.841182267364188e-22, -7.545468675918187e-25,
  1.003133015661367e-26,  1.834991740257582e+00, -1.409334367100334e-03, -7.800694303593610e-06, -2.966275272833329e-08, -4.995243953949345e-11,  2.964461442692970e-13,
  3.153118183195771e-15,  1.397594193085190e-17,  1.173308685593915e-20, -3.155545646486853e-22, -2.620633612342737e-24, -9.473778863259770e-27,  1.894151570367759e+00,
 -9.569166139476403e-04, -5.929469789677743e-06, -2.839516964470851e-08, -9.845767943283439e-11, -1.355272579115167e-13,  1.264497598283979e-15,  1.327109813385302e-17,
  7.154237878107598e-20,  2.050952355322606e-22, -4.070550486464737e-25, -9.554224130484175e-27,  1.941696714788182e+00, -5.515857149471641e-04, -3.729839355983830e-06,
 -2.093173166645563e-08, -9.944672607317365e-11, -3.813922684216038e-13, -9.371662416864104e-16,  1.292378311363365e-18,  3.552584133724352e-20,  2.803066622607815e-22,
  1.525478619193831e-24,  5.786954334629438e-27,  1.975892751958902e+00, -2.356204967856876e-04, -1.693894552808962e-06, -1.054372584087812e-08, -5.942875838902558e-11,
 -3.069710120078318e-13, -1.444401832338516e-15, -6.023038930461854e-18, -2.054270130787087e-20, -4.018762630950405e-23,  1.557463846657558e-25,  2.575080340848670e-27,
  1.995382742130117e+00, -4.597250733567250e-05, -3.420582668438848e-07, -2.251551923464531e-09, -1.381199818268949e-11, -8.075642679008204e-14, -4.551292943106807e-16,
 -2.487254194672438e-18, -1.322000929657091e-20, -6.840785437834096e-23, -3.444088034391660e-25, -1.683185382558764e-27,  5.354526279029795e-04, -2.788505769974497e-06,
  1.088873141961520e-08, -3.778849688506705e-11,  1.228914865192493e-13, -3.835972180426227e-16,  1.163197137315184e-18, -3.455416319677290e-21,  1.008805763917265e-23,
 -2.912308462803500e-26,  8.288819177003857e-29, -2.352899137327683e-31,  4.818999552369518e-03, -2.506868952588639e-05,  9.764101242584397e-08, -3.373193379834544e-10,
  1.089219981404151e-12, -3.365222523378415e-15,  1.006215794976325e-17, -2.934371704805465e-20,  8.365807127181426e-23, -2.344603163261874e-25,  6.429713110925023e-28,
 -1.746170299243817e-30,  1.338567891647346e-02, -6.947989018248179e-05,  2.692354033269955e-07, -9.215930397653669e-10,  2.932840302011106e-12, -8.869925364000718e-15,
  2.574112108683415e-17, -7.208851661632248e-20,  1.946628650640527e-22, -5.078497367279440e-25,  1.263814673706544e-27, -3.019576265651999e-30,  2.623456832555386e-02,
 -1.357210386835245e-04,  5.218366671103693e-07, -1.761149533418599e-09,  5.478503060118351e-12, -1.601080047971556e-14,  4.419954911718252e-17, -1.151805531722426e-19,
  2.797898937055730e-22, -6.215896687715371e-25,  1.173783265607042e-27, -1.590239253585715e-30,  4.336404680711053e-02, -2.233336383341741e-04,  8.496553045755228e-07,
 -2.812104986139078e-09,  8.470544940291241e-12, -2.353347532377811e-14,  6.002517204979280e-17, -1.376395861839167e-19,  2.653822412791644e-22, -3.424944433629282e-25,
 -2.779188570013513e-28,  4.035749159047133e-30,  6.477149907488208e-02, -3.316933399317249e-04,  1.244905330815225e-06, -4.016566661890786e-09,  1.158196410715359e-11,
 -2.990859971364519e-14,  6.708486280468897e-17, -1.182568702919490e-19,  8.994284864724229e-23,  4.624253535604953e-25, -3.177318347960235e-27,  1.271578606082527e-29,
  9.045290250469475e-02, -4.599984541203282e-04,  1.697751163965546e-06, -5.303268049282862e-09,  1.442722337069144e-11, -3.345696295363739e-14,  5.941524006635657e-17,
 -4.072071629076104e-20, -2.710711990064943e-22,  1.724574323951606e-24, -6.706672580845709e-27,  1.987081290211386e-29,  1.204022795964146e-01, -6.072551852726079e-04,
  2.196246930365660e-06, -6.588500737252358e-09,  1.657937528922029e-11, -3.250794649368409e-14,  3.227656188530117e-17,  1.008965608823395e-19, -7.827555481750435e-22,
  3.107723919310152e-24, -9.081982494116862e-27,  1.833197024196690e-29,  1.546109928256456e-01, -7.722593226495050e-04,  2.726273098989518e-06, -7.777446443669876e-09,
  1.759222943951963e-11, -2.559099247216632e-14, -1.668910283830048e-17,  2.970178911339382e-19, -1.336300709880781e-21,  4.011066938138482e-24, -7.916488303383091e-27,
  1.254080452737679e-30,  1.930668517501324e-01, -9.535740837435949e-04,  3.271477598044410e-06, -8.766044654951282e-09,  1.702837097292888e-11, -1.165767143078070e-14,
 -8.628677372822798e-17,  5.187740519890911e-19, -1.749158976541606e-21,  3.672101951589263e-24, -1.083490064956949e-27, -3.319839417624948e-29,  2.357529936646145e-01,
 -1.149503778224349e-03,  3.813231683078084e-06, -9.443569176792427e-09,  1.449385618970440e-11,  9.671728881516774e-15, -1.707201107851229e-16,  7.167708234424732e-19,
 -1.786593764961155e-21,  1.387859597871909e-24,  1.199364990987795e-26, -7.673729122665236e-29,  2.826464885522323e-01, -1.358062959672884e-03,  4.330615139169157e-06,
 -9.696130512891421e-09,  9.680297277210943e-12,  3.784905009402634e-14, -2.588585194765833e-16,  8.238535545801191e-19, -1.210203830661936e-21, -3.152599631115423e-24,
  2.891820525556665e-26, -1.079722884497552e-28,  3.337166060264181e-01, -1.576940773698962e-03,  4.800451323288182e-06, -9.411368997542924e-09,  2.414712790752136e-12,
  7.114740687170470e-14, -3.340818262800210e-16,  7.634092788077564e-19,  1.444273701761364e-22, -9.474444246195077e-24,  4.333883541071649e-26, -9.509891229439643e-29,
  3.889226657572671e-01, -1.803460322282977e-03,  5.197420607210654e-06, -8.484652052762716e-09, -7.283177423164009e-12,  1.064523242083803e-13, -3.750389033923018e-16,
  4.645588218833012e-19,  2.265747469639044e-21, -1.597395417970726e-23,  4.526232402576120e-26, -7.712555490871070e-30,  4.482113727901935e-01, -2.034533087261358e-03,
  5.494291593943171e-06, -6.827129263432325e-09, -1.913780104713643e-11,  1.391461243949678e-13, -3.577197039565639e-16, -1.151364182241170e-19,  4.856434523729050e-21,
 -1.981295040342182e-23,  2.363750952192402e-26,  1.610762594845529e-28,  5.115135143719706e-01, -2.266608854735184e-03,  5.662323751684057e-06, -4.376014707946753e-09,
 -3.255244069199148e-11,  1.631593195619417e-13, -2.592581213758250e-16, -9.604620167192774e-19,  7.249550859953510e-21, -1.730512872681124e-23, -2.809892577862436e-26,
  3.668461524294021e-28,  5.787398645711380e-01, -2.495622253050972e-03,  5.671913503495607e-06, -1.107427618415312e-09, -4.654888415550235e-11,  1.712888776016432e-13,
 -6.379441092695131e-17, -1.966832961025055e-18,  8.406002781918409e-21, -5.061010688683783e-24, -1.038935325790518e-25,  4.948306197180285e-28,  6.497761064397121e-01,
 -2.716938102571665e-03,  5.493578701184357e-06,  2.948020357824322e-09, -5.972416587612560e-11,  1.559082804653956e-13,  2.295704366720984e-16, -2.914827238270186e-18,
  7.068847500482287e-21,  1.797000922248998e-23, -1.769586857250517e-25,  3.756495060931652e-28,  7.244765385122294e-01, -2.925299483496753e-03,  5.099403344522735e-06,
  7.687032141631436e-09, -7.024372490728495e-11,  1.102071916140029e-13,  5.973480569990042e-16, -3.466244729373286e-18,  2.154498136492228e-21,  4.781350338765980e-23,
 -1.976070750576046e-25, -1.332133265578446e-28,  8.026562839698700e-01, -3.114785053479228e-03,  4.465093061885142e-06,  1.291360923742401e-08, -7.589970738281743e-11,
  3.007707489673253e-14,  9.825727633711632e-16, -3.204053637275919e-18, -6.577835882241678e-21,  7.316350540549977e-23, -1.062593813484003e-25, -9.881860637822844e-28,
  8.840816699094829e-01, -3.278786093002155e-03,  3.572816157022158e-06,  1.831913294544378e-08, -7.427397489503331e-11, -8.333607040684492e-14,  1.289726643209213e-15,
 -1.742464744138481e-18, -1.766110193710766e-20,  7.559621162250124e-23,  1.295195913587308e-25, -1.777001524628760e-27,  9.684583980877797e-01, -3.410019542098830e-03,
  2.415011807191747e-06,  2.346633244066782e-08, -6.305476611819563e-11, -2.206206038940346e-13,  1.389811887537553e-15,  1.074267923079123e-18, -2.719465499198295e-20,
  3.541431332760227e-23,  4.558841281706996e-25, -1.688350193656692e-27,  1.055417101884059e+00, -3.500601513431015e-03,  9.993107998715829e-07,  2.778377734655841e-08,
 -4.055690752214412e-11, -3.612805665500357e-13,  1.143976669643113e-15,  4.899079156436560e-18, -2.896658540515710e-20, -5.435590039653994e-23,  6.821085032177665e-25,
  7.985924421376254e-29,  1.144495904250316e+00, -3.542216950277219e-03, -6.454103662076920e-07,  3.058146716107832e-08, -6.473954941321094e-12, -4.724726026950917e-13,
  4.540347348423206e-16,  8.626207392477363e-18, -1.645472543291332e-20, -1.679736604365310e-22,  5.125858170424688e-25,  3.305403995690700e-27,  1.235119705700365e+00,
 -3.526435315480149e-03, -2.462108182856861e-06,  3.110272062542697e-08,  3.717719286904781e-11, -5.115787184949632e-13, -6.585561961923952e-16,  1.036550924951908e-17,
  1.250971989053433e-20, -2.342160468100056e-22, -2.454939756322212e-25,  5.640891727562513e-27,  1.326576218488243e+00, -3.445238226978362e-03, -4.358606488004013e-06,
  2.863127268578551e-08,  8.510520833047131e-11, -4.356037611969925e-13, -1.963520187140304e-15,  7.977645080830741e-18,  4.936140905250764e-20, -1.581541545926964e-22,
 -1.308349587709235e-24,  3.194597316854658e-27,  1.417989344048250e+00, -3.291838671291470e-03, -6.202360815390072e-06,  2.267119693693017e-08,  1.282230851930012e-10,
 -2.197837343040300e-13, -2.977534779260218e-15,  4.403926511426522e-19,  7.152682165900785e-20,  9.692610756777399e-23, -1.704169820726458e-24, -5.183277917054217e-27,
  1.508291534466743e+00, -3.061873122025110e-03, -7.820146446722406e-06,  1.320307595917456e-08,  1.543153448830235e-10,  1.161235466384186e-13, -3.062282510050650e-15,
 -1.023358618039048e-17,  5.126187381776200e-20,  3.959532492899709e-22, -3.977767023193923e-25, -1.210450001321963e-26,  1.596198483752547e+00, -2.755018745077259e-03,
 -9.007588213964038e-06,  9.810251392994503e-10,  1.508560100274285e-10,  4.846895267724158e-13, -1.759041470625017e-15, -1.803498188171580e-17, -1.763179411429246e-20,
  4.308086126479162e-22,  2.054636230245243e-24, -5.135007787665904e-27,  1.680192010418201e+00, -2.376997523537212e-03, -9.554723286141187e-06, -1.223792873338412e-08,
  1.105520617216159e-10,  7.348521421908147e-13,  6.909325727787139e-16, -1.558765786642973e-17, -9.118569336548622e-20,  1.270679962383879e-23,  2.747089106251389e-24,
  1.285370854524593e-26,  1.758520224321497e+00, -1.941740371974226e-03, -9.292793664261768e-06, -2.373669866585962e-08,  3.851161732786357e-11,  7.123118492365855e-13,
  3.030803576877306e-15, -1.387837380351273e-18, -9.237206115883783e-20, -5.042233181439377e-22, -2.189809768792593e-25,  1.438318015295243e-26,  1.829227318757916e+00,
 -1.473176842749071e-03, -8.161233432231283e-06, -3.041031503918242e-08, -4.323489882695939e-11,  3.768480841215741e-13,  3.547844301038779e-15,  1.414860812430366e-17,
 -1.612051416200640e-21, -4.284659599361388e-22, -3.016702648408914e-24, -8.337324615538011e-27,  1.890226836297377e+00, -1.005742315538974e-03, -6.279747512792118e-06,
 -2.999039689081730e-08, -1.008332808604334e-10, -1.004548408466871e-13,  1.669221850308067e-15,  1.567456511506731e-17,  7.852234371476733e-20,  1.793994996436911e-22,
 -9.038387252676439e-25, -1.313843721136022e-26,  1.939429064725323e+00, -5.824567900095392e-04, -3.990822659721581e-06, -2.258510937309950e-08, -1.072958551782371e-10,
 -4.033118000570938e-13, -8.834601757130830e-16,  2.602942541756546e-18,  4.677746685856470e-20,  3.465101271565421e-22,  1.786380671381895e-24,  6.015214053324944e-27,
  1.974922342884169e+00, -2.496943957938727e-04, -1.826333285650976e-06, -1.154564352942192e-08, -6.592888472074900e-11, -3.437359674613099e-13, -1.622457601779959e-15,
 -6.702110949608263e-18, -2.184716678210953e-20, -3.137413091094347e-23,  2.934415275521316e-25,  3.745668851702245e-27,  1.995193202579910e+00, -4.882093155303453e-05,
 -3.704581302931710e-07, -2.486082980078912e-09, -1.554225591148027e-11, -9.256542511017072e-14, -5.310850287923423e-16, -2.952508122820923e-18, -1.594958916952394e-20,
 -8.378477242361938e-23, -4.275687171506688e-25, -2.113541776131870e-27,  5.244699990338517e-04, -2.703176913357585e-06,  1.044681869055200e-08, -3.588212409803923e-11,
  1.154910570835955e-13, -3.568059745779206e-16,  1.070811763592120e-18, -3.148753185581314e-21,  9.096892785440522e-24, -2.600570045579799e-26,  7.319371453029501e-29,
 -2.060764690796425e-31,  4.720261825817385e-03, -2.430346151812467e-05,  9.369556619354532e-08, -3.204174068386556e-10,  1.024265428235348e-12, -3.133295339200082e-15,
  9.276778326503295e-18, -2.679689066549706e-20,  7.566249664014861e-23, -2.102154872064066e-25,  5.707674803606421e-28, -1.540525650675453e-30,  1.311199818983170e-02,
 -6.736945895677669e-05,  2.584520922534133e-07, -8.760538904011926e-10,  2.761459734459779e-12, -8.275672849204582e-15,  2.380717118424769e-17, -6.614232418506752e-20,
  1.772590240609032e-22, -4.598645066011299e-25,  1.137611752715223e-27, -2.722296425613080e-30,  2.569990178225367e-02, -1.316294143387423e-04,  5.012184256208656e-07,
 -1.675998654899910e-09,  5.168638854958925e-12, -1.498772060249982e-14,  4.109653926652583e-17, -1.065763881292711e-19,  2.582408304774240e-22, -5.760478456805938e-25,
  1.103116382165922e-27, -1.616703863133101e-30,  4.248409622482902e-02, -2.166691082174658e-04,  8.167079349696952e-07, -2.680264643532613e-09,  8.013974219391807e-12,
 -2.213816993450112e-14,  5.628828793571867e-17, -1.293464457117877e-19,  2.528926766474753e-22, -3.503274136393138e-25, -1.200650126762697e-28,  3.165432293383299e-30,
  6.346434332962846e-02, -3.219237870890302e-04,  1.197798940055873e-06, -3.835954253234904e-09,  1.099962601638965e-11, -2.833795754979851e-14,  6.381629876824635e-17,
 -1.151358110263870e-19,  1.044321234964770e-22,  3.459542859980496e-25, -2.659839356897822e-27,  1.084738656557653e-29,  8.863967513210282e-02, -4.466671278234241e-04,
  1.635475129092051e-06, -5.077708516530535e-09,  1.377224658569829e-11, -3.204560398940570e-14,  5.816259408731201e-17, -4.845174417922814e-20, -2.136105347712212e-22,
  1.473146011474143e-24, -5.880497976414728e-27,  1.770774425317868e-29,  1.180079043818382e-01, -5.899969974090572e-04,  2.118755225142684e-06, -6.328389004515221e-09,
  1.593717736913340e-11, -3.170213730055570e-14,  3.476731931645567e-17,  7.756988572812157e-20, -6.772238807911782e-22,  2.760379763500725e-24, -8.290579679474728e-27,
  1.759823029241495e-29,  1.515649915226720e-01, -7.508177092264850e-04,  2.634615642662311e-06, -7.500084351659975e-09,  1.707705342742476e-11, -2.589643374938229e-14,
 -8.949991527719006e-18,  2.565056924278110e-19, -1.197580309989947e-21,  3.696438162160754e-24, -7.793680123497694e-27,  4.177245797144941e-30,  1.893042393519740e-01,
 -9.278184198123921e-04,  3.167911740483744e-06, -8.495563638269761e-09,  1.677565312691569e-11, -1.356044909588731e-14, -7.252492552927220e-17,  4.649050223019465e-19,
 -1.618072976483060e-21,  3.601995775968462e-24, -2.363854081023732e-27, -2.523736831601136e-29,  2.312152781306307e-01, -1.119447260463232e-03,  3.701305943736302e-06,
 -9.210335912108525e-09,  1.464791039655491e-11,  5.808870212794935e-15, -1.514427877181482e-16,  6.604854284024097e-19, -1.728777013615078e-21,  1.803585620741872e-24,
  8.877363588661809e-27, -6.510732902338610e-29,  2.772827934402168e-01, -1.323880764407169e-03,  4.215214789745523e-06, -9.535519696862028e-09,  1.037699770131757e-11,
  3.190878721043706e-14, -2.363483144793992e-16,  7.835252572585823e-19, -1.303995851894595e-21, -2.088090227945429e-24,  2.437739118040694e-26, -9.835186200869950e-29,
  3.274849359550588e-01, -1.538988146672836e-03,  4.687792273744326e-06, -9.361778377360972e-09,  3.759214106715452e-12,  6.338616740822626e-14, -3.126906010277003e-16,
  7.629000085963726e-19, -1.664655149329233e-22, -7.825451938579269e-24,  3.909555084951655e-26, -9.720448771708947e-29,  3.817913357769099e-01, -1.762290043095348e-03,
  5.094974284338861e-06, -8.584635007072012e-09, -5.243046523513470e-12,  9.761515634415207e-14, -3.611001674219500e-16,  5.282100468188082e-19,  1.723123112984933e-21,
 -1.417774299741413e-23,  4.437459102346635e-26, -3.156741467449390e-29,  4.401606231709376e-01, -1.990911453729022e-03,  5.410619137062871e-06, -7.111537955309422e-09,
 -1.644090443243320e-11,  1.305390743237325e-13, -3.588736917455828e-16,  2.905268707717317e-20,  4.161761365971647e-21, -1.874032685628749e-23,  2.964364476842078e-26,
  1.130218341370057e-28,  5.025373313799532e-01, -2.221528921929336e-03,  5.606793107062440e-06, -4.871095019892654e-09, -2.935352156663365e-11,  1.566400411570500e-13,
 -2.829982830640351e-16, -7.386305015952476e-19,  6.610071872212163e-21, -1.812308183597866e-23, -1.321460618973377e-26,  3.097837918736651e-28,  5.688480244781909e-01,
 -2.450312503117302e-03,  5.654268410537251e-06, -1.824904912217021e-09, -4.314272176331728e-11,  1.691271559928258e-13, -1.151327083818943e-16, -1.701515890006177e-18,
  8.154187481758820e-21, -8.788387928761929e-24, -8.267493624608872e-26,  4.674929353200057e-28,  6.389964527188363e-01, -2.672863974168499e-03,  5.523325220027075e-06,
  2.017651106428019e-09, -5.655737972623326e-11,  1.604646996803302e-13,  1.512098244798778e-16, -2.679606042698230e-18,  7.592512196945675e-21,  1.124063297324270e-23,
 -1.591060220556427e-25,  4.311871127040872e-28,  7.128574884996383e-01, -2.884154213078474e-03,  5.184979502792693e-06,  6.581511796983872e-09, -6.790403217132387e-11,
  1.233882131206988e-13,  5.015062594364330e-16, -3.371294016671830e-18,  3.732576778743983e-21,  3.984453486989906e-23, -1.995944886031324e-25,  3.793406341649384e-29,
  7.902695376043315e-01, -3.078465046572715e-03,  4.612793917775686e-06,  1.170527662651107e-08, -7.506972792782082e-11,  5.256087609571856e-14,  8.903020316565400e-16,
 -3.373303339307152e-18, -4.030290419455392e-21,  6.811436655478358e-23, -1.444423220094104e-25, -7.474041877636178e-28,  8.710250541755368e-01, -3.249344563716940e-03,
  3.785465848756504e-06,  1.711907967470108e-08, -7.563543308055213e-11, -5.302941503693005e-14,  1.233440836442029e-15, -2.263227557604856e-18, -1.486490620743012e-20,
  7.924946833586872e-23,  5.415775368620568e-26, -1.637999171701990e-27,  9.548587189092965e-01, -3.389590538105715e-03,  2.690414823619577e-06,  2.242397767500292e-08,
 -6.713168967177067e-11, -1.870012002762014e-13,  1.407924074194707e-15,  2.278072393418700e-19, -2.561007913192735e-20,  5.209173945810070e-23,  3.764156000618250e-25,
 -1.904161376412772e-27,  1.041432780084835e+00, -3.491284976429123e-03,  1.328589174743331e-06,  2.707859841460927e-08, -4.749740165558536e-11, -3.322853989437566e-13,
  1.267917203067028e-15,  3.946099662252980e-18, -3.043333078529160e-20, -2.720873821969819e-23,  6.702457932790962e-25, -6.065644143430479e-28,  1.130319030647356e+00,
 -3.545914797607550e-03, -2.793639523694717e-07,  3.040296130778241e-08, -1.579520509965069e-11, -4.587423028577204e-13,  6.873175473432016e-16,  8.007131825444665e-18,
 -2.209967914154223e-20, -1.447846334337756e-22,  6.411031033496240e-25,  2.515222931391394e-27,  1.220976947758697e+00, -3.544629920842591e-03, -2.085646677164052e-06,
  3.161494375222747e-08,  2.681127449981396e-11, -5.238638675909257e-13, -3.639958451593759e-16,  1.062950500941819e-17,  3.961414346065576e-21, -2.390316350736580e-22,
  5.068894360785707e-27,  5.689594500331626e-27,  1.312727735640216e+00, -3.478710307539617e-03, -4.007156693075709e-06,  2.992077807453307e-08,  7.594088041065021e-11,
 -4.798748806826710e-13, -1.718958416758322e-15,  9.456317549485783e-18,  4.276422356083894e-20, -2.071855300337144e-22, -1.131442008552098e-24,  4.809486784390235e-27,
  1.404724523366494e+00, -3.340334822939553e-03, -5.918154647602130e-06,  2.468372707955350e-08,  1.231151495985728e-10, -2.908352127239620e-13, -2.932731419216455e-15,
  2.771512227674632e-18,  7.373942720028943e-20,  2.477916738135323e-23, -1.887974609686248e-24, -3.098159260376082e-27,  1.495919982525819e+00, -3.123758422084460e-03,
 -7.646831813446555e-06,  1.568661410691596e-08,  1.558806716292555e-10,  3.938867951111889e-14, -3.323742702839867e-15, -8.369263839541074e-18,  6.509935897173049e-20,
  3.691737684607500e-22, -9.450607370365523e-25, -1.263235021662236e-26,  1.585034420798935e+00, -2.826990607778485e-03, -8.981021741908962e-06,  3.469805182859659e-09,
  1.600864606056360e-10,  4.363639062968835e-13, -2.269478282270379e-15, -1.833570274040748e-17, -7.083254060295768e-22,  5.073155011194262e-22,  1.741598164850743e-24,
 -9.126628968613633e-27,  1.670530258599973e+00, -2.453991538176705e-03, -9.690477931822811e-06, -1.035077274062070e-08,  1.253778761386746e-10,  7.458685512968569e-13,
  2.138532247722575e-16, -1.847599074740858e-17, -8.861774512295675e-20,  1.334755692963157e-22,  3.278297814509620e-24,  1.105832583815146e-26,  1.750602790394042e+00,
 -2.017210499364139e-03, -9.573454056089929e-06, -2.300261016158014e-08,  5.348030201560149e-11,  7.842340035625133e-13,  2.947828103573787e-15, -4.634547905950206e-18,
 -1.105169536448694e-19, -4.989730084669973e-22,  5.151862603493025e-25,  1.900203591732664e-26,  1.823201704659740e+00, -1.539937561687224e-03, -8.530043689792980e-06,
 -3.103701693894785e-08, -3.481445916341234e-11,  4.667293482380240e-13,  3.940794246656180e-15,  1.382625478008241e-17, -1.929178604599080e-20, -5.558485667642325e-22,
 -3.334305521882105e-24, -5.842854052171803e-27,  1.886101072902304e+00, -1.057447399132327e-03, -6.649371099660966e-06, -3.161747108987297e-08, -1.024047227732698e-10,
 -5.483723698992216e-14,  2.144201949091834e-15,  1.828243479005826e-17,  8.417977985324978e-20,  1.304823131254203e-22, -1.572875451395507e-24, -1.737280458890059e-26,
  1.937033625915308e+00, -6.154972613925264e-04, -4.272414216454126e-06, -2.436749700030609e-08, -1.155672932216368e-10, -4.234590760828597e-13, -7.876448489638645e-16,
  4.313719016253643e-18,  6.060163704932294e-20,  4.232319414066593e-22,  2.048033987103334e-24,  5.780420518404754e-27,  1.973893440476268e+00, -2.648777221718530e-04,
 -1.971444077720855e-06, -1.265768436234985e-08, -7.320860666850312e-11, -3.850068127281139e-13, -1.820055893376161e-15, -7.416678571416517e-18, -2.272172329674195e-20,
 -1.590354618242658e-23,  4.917671758942229e-25,  5.351482337482582e-27,  1.994991796421737e+00, -5.190830141471946e-05, -4.018465984841314e-07, -2.750291259939276e-09,
 -1.752803144643652e-11, -1.063640919403438e-13, -6.213787456938527e-16, -3.514646610625819e-18, -1.929746279585358e-20, -1.028985899762015e-22, -5.320883634931112e-25,
 -2.658586487245042e-27,  5.138217570828145e-04, -2.621293825641969e-06,  1.002708929351671e-08, -3.408998919730083e-11,  1.086049574471308e-13, -3.321324242398287e-16,
  9.865852676667756e-19, -2.872084114457768e-21,  8.211272341321099e-24, -2.325160654387547e-26,  6.469457563614372e-29, -1.808605668116201e-31,  4.624523144217345e-03,
 -2.356900310917098e-05,  8.994685731739609e-08, -3.045186405943548e-10,  9.637665577725750e-13, -2.919389657333038e-15,  8.559255163524466e-18, -2.449249785574021e-20,
  6.848985533512233e-23, -1.886859661966439e-25,  5.070113298608187e-28, -1.361606092950042e-30,  1.284659005145138e-02, -6.534315406884923e-05,  2.481991826273624e-07,
 -8.331642160905126e-10,  2.601513236597763e-12, -7.725898581732006e-15,  2.203217064421770e-17, -6.072636444223468e-20,  1.614948514613811e-22, -4.166752154534846e-25,
  1.023788352970708e-27, -2.456514417969624e-30,  2.518127819896531e-02, -1.276987314375773e-04,  4.815929100559749e-07, -1.595645876679297e-09,  4.878510642874392e-12,
 -1.403629838830608e-14,  3.822503462898272e-17, -9.863610832290762e-20,  2.382801907412453e-22, -5.333474925081910e-25,  1.031901952854300e-27, -1.616755617568365e-30,
  4.163028645240030e-02, -2.102619508188012e-04,  7.852997240166559e-07, -2.555510978359886e-09,  7.584431328575315e-12, -2.082980864982065e-14,  5.277798230558869e-17,
 -1.214563366805096e-19,  2.402259577702649e-22, -3.525678393294201e-25,  2.753084788994458e-30,  2.438612094163504e-30,  6.219552559953155e-02, -3.125225720129195e-04,
  1.152805016644440e-06, -3.664412182885680e-09,  1.044792364693888e-11, -2.684466358906201e-14,  6.064101281694540e-17, -1.116143438430902e-19,  1.150818669754793e-22,
  2.486096270589699e-25, -2.219288645415717e-27,  9.213693819977117e-30,  8.687879354196848e-02, -4.338233589673187e-04,  1.575843856853634e-06, -4.862404498320310e-09,
  1.314517985013359e-11, -3.066670651632006e-14,  5.671790538260445e-17, -5.448265891720634e-20, -1.646289707019488e-22,  1.252906302521341e-24, -5.146122902595946e-27,
  1.569825536195502e-29,  1.156813415749603e-01, -5.733464312570967e-04,  2.044323751476688e-06, -6.078420476431201e-09,  1.531164243372964e-11, -3.084401742668863e-14,
  3.665037137548023e-17,  5.742619587724958e-20, -5.836352209016323e-22,  2.443976084416596e-24, -7.536545965246798e-27,  1.664620445803160e-29,  1.486033110352489e-01,
 -7.300961826021251e-04,  2.546236904608455e-06, -7.231004231431987e-09,  1.655753664297120e-11, -2.602925726691990e-14, -2.284769673205488e-18,  2.202525043960233e-19,
 -1.070069487205638e-21,  3.389037185771886e-24, -7.561165366346198e-27,  6.266973479946079e-30,  1.856430130116636e-01, -9.028783711702714e-04,  3.067566195126044e-06,
 -8.229413110439252e-09,  1.648806283481433e-11, -1.515057106011637e-14, -6.021312967357342e-17,  4.151811393268025e-19, -1.490352014081131e-21,  3.487268679780079e-24,
 -3.324454216665606e-27, -1.863818974337850e-29,  2.267960156332081e-01, -1.090274917228273e-03,  3.592191323260604e-06, -8.975231231779515e-09,  1.472920746839902e-11,
  2.389977463306578e-15, -1.337134697247731e-16,  6.062665497734087e-19, -1.658117727946661e-21,  2.104542413344294e-24,  6.246397853996463e-27, -5.468350478828805e-29,
  2.720539931659618e-01, -1.290613881955580e-03,  4.101804826801815e-06, -9.364683152386772e-09,  1.096020224535202e-11,  2.649491396410225e-14, -2.150038046047270e-16,
  7.407745522988841e-19, -1.362631919230363e-21, -1.196645509447830e-24,  2.026668745120154e-26, -8.849394241858422e-29,  3.214032781168617e-01, -1.501934057604896e-03,
  4.575852351647050e-06, -9.291889664662791e-09,  4.953617790967217e-12,  5.613707572484295e-14, -2.914442253183185e-16,  7.533591047503064e-19, -4.210633451637812e-22,
 -6.347087227637584e-24,  3.482956246772409e-26, -9.627294725065636e-29,  3.748230409392856e-01, -1.721943592068434e-03,  4.991518246500535e-06, -8.653371066312387e-09,
 -3.376179211604523e-12,  8.913200228050378e-14, -3.456126319710883e-16,  5.755231154432032e-19,  1.244287170288182e-21, -1.243618566688793e-23,  4.257379010867257e-26,
 -4.935985319322610e-29,  4.322830007297960e-01, -1.947972130998919e-03,  5.323786996070450e-06, -7.354173606202701e-09, -1.391611158026420e-11,  1.219503013840498e-13,
 -3.562954859234046e-16,  1.516724311660049e-19,  3.509535322701498e-21, -1.746778738719975e-23,  3.368191264119377e-26,  7.163556183877857e-29,  4.937405432178210e-01,
 -2.176916138129547e-03,  5.545624197600769e-06, -5.316064597623452e-09, -2.629019458577421e-11,  1.496231986831383e-13, -3.008172848230039e-16, -5.376234449385559e-19,
  5.951260533130075e-21, -1.839558999248223e-23, -8.158269225561973e-28,  2.542011035362535e-28,  5.591370878383185e-01, -2.405177430069517e-03,  5.628338944912335e-06,
 -2.488293920435493e-09, -3.979151846651731e-11,  1.658214330235278e-13, -1.591739605014962e-16, -1.446242640774943e-18,  7.783141335814834e-21, -1.169461844983263e-23,
 -6.291640751748677e-26,  4.291348371470929e-28,  6.283935019721659e-01, -2.628595663699694e-03,  5.542214001759311e-06,  1.138579548821938e-09, -5.331772940264227e-11,
  1.632211732867573e-13,  7.963459606536426e-17, -2.431361580738283e-18,  7.887288625348394e-21,  5.266208689452211e-24, -1.394031454169323e-25,  4.603644829528898e-28,
  7.014043056915463e-01, -2.842376742746080e-03,  5.257522324777557e-06,  5.515411525045663e-09, -6.532347732301295e-11,  1.343063759842841e-13,  4.089869063033795e-16,
 -3.230436061642259e-18,  5.024074866484344e-21,  3.193768786788429e-23, -1.947270752780944e-25,  1.780767761723364e-28,  7.780303430096109e-01, -3.041021173643664e-03,
  4.746088905911724e-06,  1.051369932626137e-08, -7.381255442369680e-11,  7.278234577724676e-14,  7.944043009785119e-16, -3.464213979346517e-18, -1.689459428022923e-21,
  6.174885309217144e-23, -1.721234901779849e-25, -5.128091330161302e-28,  8.580895152870555e-01, -3.218259764206079e-03,  3.983603952792237e-06,  1.590201396675912e-08,
 -7.640539514611392e-11, -2.423838325336484e-14,  1.163842064671277e-15, -2.692976593205528e-18, -1.198981870352168e-20,  8.002800241932941e-23, -1.381854166629161e-26,
 -1.444360101048270e-27,  9.413450814780662e-01, -3.367009400717760e-03,  2.952940441755634e-06,  2.132178690701739e-08, -7.053376611560039e-11, -1.532252527393078e-13,
  1.403131038683430e-15, -5.589707988786393e-19, -2.348430398839478e-20,  6.543533897132758e-23,  2.900450777311907e-25, -2.003075493666276e-27,  1.027490936688241e+00,
 -3.479369903754105e-03,  1.648758750336858e-06,  2.626716326553342e-08, -5.383043166148581e-11, -3.006402650841685e-13,  1.364663141109353e-15,  2.961671869023458e-18,
 -3.093837573602730e-20, -1.115210425422756e-24,  6.301036213349328e-25, -1.200229291247748e-27,  1.116133205281858e+00, -3.546695354472464e-03,  8.365558163328800e-08,
  3.007781025009038e-08, -2.478736754559595e-11, -4.396408319544221e-13,  9.008694732135703e-16,  7.221696712866490e-18, -2.682598159310900e-20, -1.171830909086975e-22,
  7.325154147326270e-25,  1.629505043761422e-27,  1.206767469706653e+00, -3.559791083146898e-03, -1.704040480563345e-06,  3.195973262371130e-08,  1.627078619667309e-11,
 -5.290218673995592e-13, -6.588553113330598e-17,  1.061911350883959e-17, -4.580279078339907e-21, -2.338858181377535e-22,  2.500314118963925e-25,  5.389358008776005e-27,
  1.298751082063944e+00, -3.509311451332081e-03, -3.641140757487190e-06,  3.105690337338854e-08,  6.595304853457627e-11, -5.178051179419414e-13, -1.436204193395426e-15,
  1.069713835624810e-17,  3.454573181880340e-20, -2.477953526573889e-22, -8.893722090177259e-25,  6.136389186096787e-27,  1.391270416225901e+00, -3.386462220664987e-03,
 -5.610335123730556e-06,  2.660324274470537e-08,  1.166022552165124e-10, -3.600225995896514e-13, -2.822064963722006e-15,  5.130646394492885e-18,  7.324562243202713e-20,
 -5.276552511357353e-23, -1.971384032980030e-24, -6.467533954604604e-28,  1.483303851612318e+00, -3.184137688237999e-03, -7.443616149816415e-06,  1.818259759542728e-08,
  1.558530331316457e-10, -4.294582628045254e-14, -3.526977917634062e-15, -6.081822043496249e-18,  7.757549144999520e-20,  3.202985244158741e-22, -1.495887378599255e-24,
 -1.224459761047070e-26,  1.573583088047542e+00, -2.898628044367618e-03, -8.923737842172976e-06,  6.097872996579240e-09,  1.682275386276042e-10,  3.757504053653679e-13,
 -2.780358740573292e-15, -1.805356724099906e-17,  1.870133789382592e-20,  5.677560397161314e-22,  1.251168092168609e-24, -1.313766771917022e-26,  1.660558507782643e+00,
 -2.531976961305003e-03, -9.802158246374424e-06, -8.225290480212218e-09,  1.403030345126905e-10,  7.444780214782038e-13, -3.422671849902186e-16, -2.120866561502717e-17,
 -8.134259182924303e-20,  2.734816478859071e-22,  3.697984752547920e-24,  7.758777742001106e-27,  1.742379047072513e+00, -2.094886493697763e-03, -9.843821361289284e-06,
 -2.201765544243607e-08,  6.985981455587464e-11,  8.530086269931791e-13,  2.765886950529369e-15, -8.452805459991588e-18, -1.278952858928466e-19, -4.603014749762464e-22,
  1.450948079727030e-24,  2.346278753448846e-26,  1.816903102510086e+00, -1.609676414088976e-03, -8.905505037763195e-06, -3.151410266916551e-08, -2.450316600828170e-11,
  5.658648513281261e-13,  4.316092285195854e-15,  1.286256892214257e-17, -4.175513606411329e-20, -6.932534968567775e-22, -3.505082141733715e-24, -1.600225311272638e-27,
  1.881762451031033e+00, -1.112187924926922e-03, -7.038638252735000e-06, -3.326174499662310e-08, -1.029438046177721e-10,  3.074769682313128e-15,  2.694433205216088e-15,
  2.103762649344545e-17,  8.754804627102565e-20,  5.091042555009257e-23, -2.440368566469023e-24, -2.212554352146882e-26,  1.934501381077913e+00, -6.508782993941133e-04,
 -4.576201328505111e-06, -2.628530903786067e-08, -1.242145316294488e-10, -4.406793515863363e-13, -6.373051053912508e-16,  6.513049039193151e-18,  7.737192889410358e-20,
  5.100148254171216e-22,  2.283916061898616e-24,  4.786157944090677e-27,  1.972801395594809e+00, -2.812773573704601e-04, -2.130626305214687e-06, -1.389306860227955e-08,
 -8.136280370001643e-11, -4.312627011664541e-13, -2.037958391396987e-15, -8.148642415977883e-18, -2.287809624362805e-20,  9.071277554191108e-24,  7.728420742958451e-25,
  7.532955255893397e-27,  1.994777517697609e+00, -5.526002291673552e-05, -4.366057041705499e-07, -3.048603055851482e-09, -1.981279111216630e-11, -1.225314582741976e-13,
 -7.290216676484189e-16, -4.195782781406281e-18, -2.341483055537085e-20, -1.267131556112094e-22, -6.636640976936124e-25, -3.349011888961526e-27,  5.034944654188401e-04,
 -2.542684386843425e-06,  9.628220385556228e-09, -3.240419137661719e-11,  1.021927257737674e-13, -3.093904620806739e-16,  9.097231973922048e-19, -2.622232046505879e-21,
  7.418937610988306e-24, -2.081634391099728e-26,  5.722690635517914e-29, -1.591121910815946e-31,  4.531663502406909e-03, -2.286378736697469e-05,  8.638326395038448e-08,
 -2.895545455383661e-10,  9.073786906847384e-13, -2.721955492730305e-15,  7.903154751605466e-18, -2.240570579382593e-20,  6.204820427169861e-23, -1.695563765824262e-25,
  4.505996934931409e-28, -1.206203759640747e-30,  1.258912628534766e-02, -6.339685643813973e-05,  2.384459497211098e-07, -7.927479859110563e-10,  2.452148218735239e-12,
 -7.216960162205697e-15,  2.040198223314182e-17, -5.579083756369563e-20,  1.472062783119229e-22, -3.778137908938516e-25,  9.210034750326125e-28, -2.220251769412743e-30,
  2.467806933631094e-02, -1.239212732202461e-04,  4.629043915342532e-07, -1.519786592428912e-09,  4.606739355446735e-12, -1.315119512833641e-14,  3.556714263581192e-17,
 -9.131052301121660e-20,  2.198055418005078e-22, -4.934900619338885e-25,  9.610958329309584e-28, -1.599548073519365e-30,  4.080161209711002e-02, -2.041001858081595e-04,
  7.553481698223403e-07, -2.437425164784058e-09,  7.180230847955179e-12, -1.960308946861877e-14,  4.948291932159927e-17, -1.139719653275292e-19,  2.275596392314026e-22,
 -3.504988348281909e-25,  9.626008670404673e-29,  1.829033131738134e-30,  6.096360565526702e-02, -3.034732221246931e-04,  1.109817606904518e-06, -3.501462529809936e-09,
  9.925333260475544e-12, -2.542635788859966e-14,  5.756859565462488e-17, -1.078048911883265e-19,  1.225276440865848e-22,  1.675113430600722e-25, -1.846042535736465e-27,
  7.782958659710211e-30,  8.516834905196208e-02, -4.214464741749863e-04,  1.518736938247687e-06, -4.656914862477125e-09,  1.254533154563071e-11, -2.932433796975650e-14,
  5.512514230018160e-17, -5.906752255672575e-20, -1.230681859724044e-22,  1.060318062023845e-24, -4.496825959404410e-27,  1.383949581499487e-29,  1.134202088882528e-01,
 -5.572794872312509e-04,  1.972832422597418e-06, -5.838320938446121e-09,  1.470367784748266e-11, -2.994714448541814e-14,  3.800965647421996e-17,  4.010083083383810e-20,
 -5.009047349789043e-22,  2.156847346360856e-24, -6.827929684814186e-27,  1.554324702439357e-29,  1.457231228449120e-01, -7.100689114920947e-04,  2.461037193953069e-06,
 -6.970249277034057e-09,  1.603688315895965e-11, -2.601384560898915e-14,  3.420837886643098e-18,  1.879045617084657e-19, -9.534374784078365e-22,  3.092563645444036e-24,
 -7.252315081274445e-27,  7.668855783810902e-30,  1.820799614511434e-01, -8.787283922052322e-04,  2.970385848685269e-06, -7.968102857328563e-09,  1.617151453040060e-11,
 -1.646145937725207e-14, -4.923705414425162e-17,  3.694713742789313e-19, -1.367386243504099e-21,  3.339557709157922e-24, -4.021869527345848e-27, -1.325042353623110e-29,
  2.224917145673062e-01, -1.061964188868717e-03,  3.485903580488166e-06, -8.739350213555917e-09,  1.474626011354338e-11, -6.213643869083004e-16, -1.174691359130370e-16,
  5.544626839217991e-19, -1.578411035446036e-21,  2.309073663697666e-24,  4.047182329977424e-27, -4.548168792145395e-29,  2.669564590590099e-01, -1.258245928472062e-03,
  3.990497405910498e-06, -9.185354132118058e-09,  1.144015407420836e-11,  2.157876122930351e-14, -1.948779802699143e-16,  6.966300784915146e-19, -1.392031275196093e-21,
 -4.609726390909214e-25,  1.658772270218010e-26, -7.878227507759360e-29,  3.154680513520749e-01, -1.465771819216858e-03,  4.464861061913322e-06, -9.204022749186273e-09,
  6.008112579428050e-12,  4.939381869071580e-14, -2.705712879543399e-16,  7.364897988253521e-19, -6.254950996577816e-22, -5.037830474385367e-24,  3.065640764511015e-26,
 -9.310784594848946e-29,  3.680144720852677e-01, -1.682427593648233e-03,  4.887411062908262e-06, -8.693573937460176e-09, -1.675159371002623e-12,  8.103477218596585e-14,
 -3.290055313029240e-16,  6.085012337807592e-19,  8.266766239050327e-22, -1.078072899183438e-23,  4.010727843821806e-26, -6.197318559219437e-29,  4.245757287773523e-01,
 -1.905738438191810e-03,  5.234279952769964e-06, -7.557782287690127e-09, -1.156220932130422e-11,  1.134622905270538e-13, -3.505690353394638e-16,  2.541816550577701e-19,
  2.905607158756548e-21, -1.606818903888389e-23,  3.604437795736015e-26,  3.680660243269414e-29,  4.851211948327257e-01, -2.132813241727481e-03,  5.479405031338228e-06,
 -5.713165003790492e-09, -2.337103746905897e-11,  1.422438505161168e-13, -3.133040563346106e-16, -3.577643329618494e-19,  5.290984046700572e-21, -1.822022306233156e-23,
  9.202495996306205e-27,  2.018149526566053e-28,  5.496062274814044e-01, -2.360280729277682e-03,  5.594768165477345e-06, -3.098647616495642e-09, -3.651642789463517e-11,
  1.615430588083886e-13, -1.962484511785959e-16, -1.204367769933606e-18,  7.321268144262150e-21, -1.384664294159653e-23, -4.501706710675650e-26,  3.835687194728257e-28,
  6.179678611272404e-01, -2.584217553631651e-03,  5.550866454668207e-06,  3.116924780454682e-10, -5.003955995786348e-11,  1.643441242213266e-13,  1.511103576816596e-17,
 -2.176971342532369e-18,  7.981417936666975e-21,  9.868007874092007e-26, -1.189245109459234e-25,  4.671279424365436e-28,  6.901193134381491e-01, -2.800069384921171e-03,
  5.317526495809279e-06,  4.492227813136720e-09, -6.254642137109812e-11,  1.430558113210482e-13,  3.209477102072664e-16, -3.052755433914743e-18,  6.035831885347767e-21,
  2.433950645427959e-23, -1.843926212659514e-25,  2.864750946332108e-28,  7.659429665887925e-01, -3.002567764648243e-03,  4.865218594194901e-06,  9.345346470618920e-09,
 -7.217413034594448e-11,  9.067996950522820e-14,  6.969739067033766e-16, -3.484078313554327e-18,  4.047327019558456e-22,  5.447827329235247e-23, -1.898180605609975e-25,
 -2.949766125332131e-28,  8.452813930705535e-01, -3.185648445293420e-03,  4.167082049342126e-06,  1.467714077003684e-08, -7.661716117947176e-11,  2.748286209857857e-15,
  1.083498931317187e-15, -3.030781763672104e-18, -9.133482373710399e-21,  7.826983602832307e-23, -7.241476413811256e-26, -1.214665213352163e-27,  9.279258840009733e-01,
 -3.342381837644145e-03,  3.201935423096024e-06,  2.017055347103457e-08, -7.326321682718331e-11, -1.198205888244904e-13,  1.377327987452906e-15, -1.270711450082723e-18,
 -2.094109734286001e-20,  7.526958816230250e-23,  2.017307704214202e-25, -1.994618471503025e-27,  1.013601812258993e+00, -3.464934097072044e-03,  1.958604402042089e-06,
  2.535957962087238e-08, -5.950957844664267e-11, -2.670049670259017e-13,  1.433757563313827e-15,  1.975753499401761e-18, -3.053894799291838e-20,  2.288383753531593e-23,
  5.663938917153405e-25, -1.674342680868055e-27,  1.101950037877486e+00, -3.544589777379193e-03,  4.419235432182813e-07,  2.961211152749337e-08, -3.334811382136346e-11,
 -4.156941698744780e-13,  1.090465797227403e-15,  6.301546977838702e-18, -3.050233635460620e-20, -8.671812363818673e-23,  7.840537183784634e-25,  7.134463980654364e-28,
  1.192503474853785e+00, -3.571885718342694e-03, -1.319310851045730e-06,  3.213543648645961e-08,  5.698502147858545e-12, -5.270593599450110e-13,  2.281482957374927e-16,
  1.034021125109827e-17, -1.276441716157782e-20, -2.193021327551804e-22,  4.746545795549623e-25,  4.772671994830077e-27,  1.284657962604741e+00, -3.536932705517813e-03,
 -3.262473958822501e-06,  3.202753449710229e-08,  5.527712804111692e-11, -5.485633374374192e-13, -1.122594698576702e-15,  1.165355271533539e-17,  2.505266052930199e-20,
 -2.776644510948054e-22, -5.972928353367860e-25,  7.067469673273494e-27,  1.377636867851692e+00, -3.430036801070800e-03, -5.280151784742066e-06,  2.840764882051794e-08,
  1.087375033218551e-10, -4.257657052030339e-13, -2.645986995072106e-15,  7.428884482003913e-18,  6.992679540107562e-20, -1.314211287152682e-22, -1.942191334983086e-24,
  1.986612900254027e-27,  1.470449644601922e+00, -3.242771556151643e-03, -7.210506475452918e-06,  2.066472289411847e-08,  1.541353416894788e-10, -1.293460597612716e-13,
 -3.660870006641402e-15, -3.427497803768642e-18,  8.790227672837620e-20,  2.500226986225312e-22, -2.007796130186417e-24, -1.085699830084083e-26,  1.561846324824618e+00,
 -2.969678944572735e-03, -8.834177737619916e-06,  8.845837683380095e-09,  1.750347459432879e-10,  3.030426229627775e-13, -3.274345743973342e-15, -1.711963581567073e-17,
  3.989190347259183e-20,  6.051309349069907e-22,  5.910918171236675e-25, -1.676690884934340e-26,  1.650273195646804e+00, -2.610749751110220e-03, -9.886903295210166e-06,
 -5.861978832656443e-09,  1.550608718038727e-10,  7.288534954776576e-13, -9.708641915862806e-16, -2.362496394462385e-17, -6.876427796817202e-20,  4.269050082248613e-22,
  3.937580065073350e-24,  2.871939569243589e-27,  1.733840355178715e+00, -2.174673590608022e-03, -1.010075225592390e-05, -2.075989929545495e-08,  8.756217554311958e-11,
  9.160724421507787e-13,  2.469512066372200e-15, -1.279729624489829e-17, -1.431618747729123e-19, -3.804458977526181e-22,  2.568960010731827e-24,  2.717584511620568e-26,
  1.810319505472889e+00, -1.682438898904000e-03, -9.285634544376050e-06, -3.180986733435082e-08, -1.212171623290166e-11,  6.735978733343019e-13,  4.653592790940457e-15,
  1.109999253164120e-17, -6.923765679345348e-20, -8.331608375862449e-22, -3.444128442973658e-24,  4.740821150831993e-27,  1.877198513732397e+00, -1.170121566905099e-03,
 -7.447647826329210e-06, -3.490463437803817e-08, -1.021862912434395e-10,  7.512735400639066e-14,  3.322838022846873e-15,  2.384765714552844e-17,  8.737583605673169e-20,
 -6.763676458779356e-23, -3.523259882224044e-24, -2.709684804638242e-26,  1.931822602387691e+00, -6.887840661113873e-04, -4.903842990323387e-06, -2.834401402477550e-08,
 -1.331647800459050e-10, -4.534889075747865e-13, -4.173889615231917e-16,  9.300732832648690e-18,  9.742292857663308e-20,  6.050476230721355e-22,  2.452015664377361e-24,
  2.620707692816144e-27,  1.971641108141437e+00, -2.990120389637449e-04, -2.305447414848727e-06, -1.526661204875058e-08, -9.049607429261468e-11, -4.829938416415595e-13,
 -2.276274151317754e-15, -8.868854914867755e-18, -2.190800736222646e-20,  4.741594180692613e-23,  1.165727808553088e-24,  1.046587300639300e-26,  1.994549252359148e+00,
 -5.890478320474098e-05, -4.751750318667171e-07, -3.386204914188403e-09, -2.244835766677440e-11, -1.415268348999534e-13, -8.577174683055447e-16, -5.023470091005549e-18,
 -2.849203752497888e-20, -1.564493207722377e-22, -8.295050047227409e-25, -4.223102363723881e-27,  4.934753553106386e-04, -2.467186691211977e-06,  9.248980168610237e-09,
 -3.081744844883843e-11,  9.621743864045168e-14, -2.884120254049094e-16,  8.395147982485132e-19, -2.396387812997510e-21,  6.709117794743958e-24, -1.866157053777876e-26,
  5.064803720219458e-29, -1.403961524044941e-31,  4.441568822078444e-03, -2.218637713801324e-05,  8.299395407727511e-08, -2.754619029891923e-10,  8.547866578975149e-13,
 -2.539589247810376e-15,  7.302699157770147e-18, -2.051445042728115e-20,  5.625619208559393e-23, -1.525528181163861e-25,  4.005577014859169e-28, -1.071689627701528e-30,
  1.233929467332039e-02, -6.152668455891149e-05,  2.291637016749178e-07, -7.546422455630253e-10,  2.312581656178487e-12, -6.745538330183330e-15,  1.890379206995292e-17,
 -5.129093451145673e-20,  1.342451406379263e-22, -3.428641806750095e-25,  8.279938768581213e-28, -2.011974670872523e-30,  2.418967695292078e-02, -1.202897545040541e-04,
  4.451006675088553e-07, -1.448137429592460e-09,  4.352048513868430e-12, -1.232748537755360e-14,  3.310630220949399e-17, -8.455371352168823e-20,  2.027149931425487e-22,
 -4.564464700635175e-25,  8.912768102115340e-28, -1.573162279542066e-30,  3.999711439872766e-02, -1.981724732175036e-04,  7.267756380538108e-07, -2.325614510162971e-09,
  6.799790674070947e-12, -1.845298275829971e-14,  4.639176027379810e-17, -1.068910532294148e-19,  2.150289348835194e-22, -3.451967621629531e-25,  1.650888451666828e-28,
  1.313168794166098e-30,  5.976720749830820e-02, -2.947600899456466e-04,  1.068736347528459e-06, -3.346651363720689e-09,  9.430380375805833e-12, -2.408048589763468e-14,
  5.460575981697969e-17, -1.038011247427572e-19,  1.273079343988860e-22,  1.001367747240476e-25, -1.531847817246061e-27,  6.524547840168003e-30,  8.350651377997075e-02,
 -4.095167423610196e-04,  1.464039188957107e-06, -4.460810138526035e-09,  1.197193870059159e-11, -2.802159219851416e-14,  5.342161480319414e-17, -6.242851675509831e-20,
 -8.799240648854890e-23,  8.921084245015606e-25, -3.926164752974767e-27,  1.212178117285107e-29,  1.112222181323041e-01, -5.417731130510182e-04,  1.904164520813477e-06,
 -5.607803721338397e-09,  1.411393916079887e-11, -2.902318022885062e-14,  3.891937911102677e-17,  2.526282873608362e-20, -4.280126829879348e-22,  1.897059495626399e-24,
 -6.170249144250554e-27,  1.433737355719819e-29,  1.429217001611802e-01, -6.907108633769788e-04,  2.378916593464731e-06, -6.717815172893026e-09,  1.551783602687653e-11,
 -2.587195631088223e-14,  8.271367321822271e-18,  1.591205688822704e-19, -8.472428881230726e-22,  2.809502642939418e-24, -6.894676731908098e-27,  8.502147940387375e-30,
  1.786119746564525e-01, -8.553434011223978e-04,  2.876310016651368e-06, -7.712053233638776e-09,  1.583128132449299e-11, -1.752384081334681e-14, -3.948659857975458e-17,
  3.276064923585490e-19, -1.250186054384128e-21,  3.168366036371780e-24, -4.506301681889303e-27, -8.935567489429383e-30,  2.182989737385994e-01, -1.034492439966191e-03,
  3.382446126783928e-06, -8.503657473000834e-09,  1.470686858691136e-11, -3.259953889426986e-15, -1.026386113868332e-16,  5.053110348527668e-19, -1.492830327200268e-21,
  2.433377315436812e-24,  2.226244186927833e-27, -3.748421208300787e-29,  2.619866296509252e-01, -1.226759703319944e-03,  3.881384847836425e-06, -8.999106644814681e-09,
  1.182651247734023e-11,  1.713071290385239e-14, -1.759975883308873e-16,  6.519410008601258e-19, -1.397493248742636e-21,  1.359778129933256e-25,  1.332738124611540e-26,
 -6.950679053839403e-29,  3.096757047497243e-01, -1.430493016785929e-03,  4.355021043813024e-06, -9.100335793258332e-09,  6.932709832805240e-12,  4.314514724792421e-14,
 -2.502554188445115e-16,  7.138008951606515e-19, -7.857600788283634e-22, -3.892214175723955e-24,  2.665876047357682e-26, -8.840050105081595e-29,  3.613622990917187e-01,
 -1.643745931922832e-03,  4.782979469537395e-06, -8.707834104832238e-09, -1.320312069485324e-13,  7.334573743644568e-14, -3.116533151602825e-16,  6.290493114169785e-19,
  4.667650911218151e-22, -9.233703438996988e-24,  3.718356610319720e-26, -7.028405581371013e-29,  4.170359448961399e-01, -1.864229947534976e-03,  5.142550004583054e-06,
 -7.725078210279034e-09, -9.376471526930406e-12,  1.051440209152032e-13, -3.422351984596370e-16,  3.381866986919850e-19,  2.353413128863694e-21, -1.460288692168300e-23,
  3.701216818252605e-26,  8.162415229970614e-30,  4.766771694529927e-01, -2.089258376778346e-03,  5.408695980746282e-06, -6.064754205142087e-09, -2.060206852515931e-11,
  1.346228734228766e-13, -3.210491018475069e-16, -1.988601530832612e-19,  4.643689376639897e-21, -1.768901044634832e-23,  1.700813355790251e-26,  1.537700588045893e-28,
  5.402543716569850e-01, -2.315681007680019e-03,  5.554184576272316e-06, -3.657330476683833e-09, -3.333526303019385e-11,  1.564544298968167e-13, -2.267680493852395e-16,
 -9.783782329303161e-19,  6.794313448187362e-21, -1.532417283724639e-23, -2.922044917858408e-26,  3.340424968675750e-28,  6.077198095788098e-01, -2.539809021685362e-03,
  5.549911442221831e-06, -4.626459224146957e-10, -4.675383914153067e-11,  1.640041589679710e-13, -4.227426578268321e-17, -1.922387131147082e-18,  7.904280351526246e-21,
 -4.249425374462768e-24, -9.856488259575771e-26,  4.556435428458294e-28,  6.790044340038204e-01, -2.757330338625033e-03,  5.365524467192508e-06,  3.514763857133969e-09,
 -5.961508529355838e-11,  1.497554154831031e-13,  2.382963376078020e-16, -2.846986573486272e-18,  6.782561003928389e-21,  1.724093104073736e-23, -1.699705224020622e-25,
  3.641738997671710e-28,  7.540112217481325e-01, -2.963216927053717e-03,  4.970496737611913e-06,  8.205944914772565e-09, -7.020114404690392e-11,  1.062399156776559e-13,
  5.998852935182169e-16, -3.441234602137429e-18,  2.226693251184430e-21,  4.668486208703052e-23, -1.984436589112806e-25, -1.016213393266720e-28,  8.326065586607713e-01,
 -3.151628112798309e-03,  4.335858801482984e-06,  1.345308938546182e-08, -7.630918924395974e-11,  2.770347228825349e-14,  9.949642681296896e-16, -3.278629049221441e-18,
 -6.380131093929687e-21,  7.437657619453524e-23, -1.204401010311867e-25, -9.666633455978013e-28,  9.146090922206535e-01, -3.315818265811796e-03,  3.436875495915552e-06,
  1.898095331634429e-08, -7.533233239357524e-11, -8.726484396176749e-14,  1.332783929410505e-15, -1.896084298067523e-18, -1.810709383712949e-20,  8.160707950047099e-23,
  1.158784874585698e-25, -1.894051039077133e-27,  9.997753174978383e-01, -3.448064582254647e-03,  2.257036317510364e-06,  2.436659202455024e-08, -6.450166188722417e-11,
 -2.320404473239934e-13,  1.475551366086949e-15,  1.015909941803481e-18, -2.932609975213134e-20,  4.395623391134689e-23,  4.847538911516507e-25, -2.013693716585078e-27,
  1.087780986438400e+00, -3.539642700694144e-03,  7.937978696593765e-07,  2.901351057813126e-08, -4.138657499524642e-11, -3.875186343651226e-13,  1.252818179133354e-15,
  5.281620967434603e-18, -3.305452011484112e-20, -5.499267761986895e-23,  7.957722636668818e-25, -1.707667636806903e-28,  1.178197266434994e+00, -3.580896952919454e-03,
 -9.334851857117572e-07,  3.214267804496338e-08, -4.764746849045778e-12, -5.181627999441798e-13,  5.107973238709410e-16,  9.809492848808853e-18, -2.026910014969241e-20,
 -1.963573161713442e-22,  6.661998257927949e-25,  3.897036037503007e-27,  1.270460486407746e+00, -3.561480982923602e-03, -2.873203427413564e-06,  3.282284700014811e-08,
  4.406329726111869e-11, -5.715088118894685e-13, -7.866036479224893e-16,  1.229131124123986e-17,  1.470325959735248e-20, -2.951650144174703e-22, -2.743622535425990e-25,
  7.530113443693238e-27,  1.363834438074342e+00, -3.470885540815737e-03, -4.929113176532944e-06,  3.007595120472235e-08,  9.960528735391004e-11, -4.865253351652507e-13,
 -2.407467955315680e-15,  9.576067184605642e-18,  6.382539801037427e-20, -2.065850789759181e-22, -1.797036794935746e-24,  4.587535125280733e-27,  1.457364819682172e+00,
 -3.299422004202729e-03, -6.947833715004404e-06,  2.310539240678103e-08,  1.506637140467286e-10, -2.180329844395601e-13, -3.716222346519809e-15, -4.870101061615445e-19,
  9.534796368705418e-20,  1.607865160502237e-22, -2.436709581032856e-24, -8.483203372848133e-27,  1.549827002270912e+00, -3.039879724727167e-03, -8.711038611017366e-06,
  1.169045056666880e-08,  1.802717594837541e-10,  2.188706320561146e-13, -3.732525102957363e-15, -1.549147454230535e-17,  6.191608052507776e-20,  6.131190730154147e-22,
 -2.121679636187850e-25, -1.957227092270482e-26,  1.639671621671502e+00, -2.690083077400701e-03, -9.941884880015302e-06, -3.265883522042038e-09,  1.693501320548215e-10,
  6.973814069477363e-13, -1.660641522792978e-15, -2.554898260537892e-17, -5.054617828885023e-20,  5.851590390008085e-22,  3.928641951941575e-24, -3.504591831367254e-27,
  1.724978506513098e+00, -2.256450854201248e-03, -1.034085039522877e-05, -1.920924395072890e-08,  1.064445566744895e-10,  9.705112796184836e-13,  2.045147468308592e-15,
 -1.757539204944149e-17, -1.547126714588090e-19, -2.529813088644254e-22,  3.820613550378212e-24,  2.940663085149402e-26,  1.803438758920076e+00, -1.758253082198793e-03,
 -9.668052128677676e-06, -3.188987004590307e-08,  2.490863345572118e-12,  7.887346822131459e-13,  4.928678522446239e-15,  8.378445251337483e-18, -1.016395992585579e-19,
 -9.643759337086229e-22, -3.053520449237878e-24,  1.340524603918557e-26,  1.872396173295225e+00, -1.231405823142343e-03, -7.876249069177609e-06, -3.652302900532069e-08,
 -9.983055695136745e-11,  1.632009487330187e-13,  4.029142898649712e-15,  2.657510795214216e-17,  8.210385989813003e-20, -2.338291772967178e-22, -4.820346395306449e-24,
 -3.174970388063960e-26,  1.928986798442381e+00, -7.294122359003472e-04, -5.257055785471205e-06, -3.054765786057292e-08, -1.423117289605349e-10, -4.600081074755423e-13,
 -1.099124639215823e-16,  1.278587207088995e-17,  1.209890520960755e-19,  7.044371617060974e-22,  2.489233407254081e-24, -1.266163244484118e-27,  1.970406976821206e+00,
 -3.182137844532020e-04, -2.497663007560141e-06, -1.679488234679213e-08, -1.007227729615452e-10, -5.406816534395421e-13, -2.534090576992466e-15, -9.532636865915591e-18,
 -1.924112806356376e-20,  1.043242321672629e-22,  1.708046042884045e-24,  1.436355957428164e-26,  1.994305764161004e+00, -6.287504988140887e-05, -5.180616991653196e-07,
 -3.769191140001415e-09, -2.549669519406043e-11, -1.639084097068719e-13, -1.012033616523265e-15, -6.032115346315925e-18, -3.476899872849816e-20, -1.936525102358665e-22,
 -1.038695165183462e-24, -5.327993099316296e-27,  4.837522864807484e-04, -2.394648347630756e-06,  8.888220794206185e-09, -2.932304301231760e-11,  9.064536947213757e-14,
 -2.690452034550550e-16,  7.753233469856076e-19, -2.192065891317217e-21,  6.072324059774041e-24, -1.675429433436050e-26,  4.483250452247179e-29, -1.243647596486775e-31,
  4.354130604912510e-03, -2.153541897402972e-05,  7.976882495330926e-08, -2.621823197244651e-10,  8.057020241429742e-13, -2.371018867180709e-15,  6.752693227053422e-18,
 -1.879912049040459e-20,  5.104165228373736e-23, -1.374382375337626e-25,  3.560137771170728e-28, -9.559978522717188e-31,  1.209679807621301e-02, -5.972897884654327e-05,
  2.203256290480042e-07, -7.186960543522344e-10,  2.182093933026656e-12, -6.308606824798367e-15,  1.752597673205076e-17, -4.718635747842029e-20,  1.224773576040886e-22,
 -3.114596766166201e-25,  7.435512112295388e-28, -1.830752629146210e-30,  2.371553113397090e-02, -1.167972944646526e-04,  4.281328165436646e-07, -1.380434672368476e-09,
  4.113256275818141e-12, -1.156062609543282e-14,  3.082719253368005e-17, -7.832300114123729e-20,  1.869080340699884e-22, -4.221714083760097e-25,  8.226807660345919e-28,
 -1.545208829171757e-30,  3.921587874399257e-02, -1.924680757269962e-04,  6.995090580796461e-07, -2.219710845524256e-09,  6.441626582370601e-12, -1.737472979539780e-14,
  4.349328524206995e-17, -1.002075813266007e-19,  2.027334011979589e-22, -3.375727862268216e-25,  2.128789807291924e-28,  8.692215751008772e-31,  5.860501614816802e-02,
 -2.863683095120061e-04,  1.029466182533873e-06, -3.199547929406564e-09,  8.961643011027759e-12, -2.280436157277699e-14,  5.175682305790856e-17, -9.968087680219372e-20,
  1.298760209818986e-22,  4.426661479686087e-26, -1.269787224172046e-27,  5.408215524977891e-30,  8.189153695761514e-02, -3.980153335118902e-04,  1.411640503175238e-06,
 -4.273673511956941e-09,  1.142418493395753e-11, -2.676073898866749e-14,  5.163881363164267e-17, -6.475971477985063e-20, -5.857916257793008e-23,  7.452518235727738e-25,
 -3.428262819993436e-27,  1.052908356733468e-29,  1.090851714813571e-01, -5.268051762561082e-04,  1.838206824005196e-06, -5.386573439282868e-09,  1.354286576627929e-11,
 -2.808211308269862e-14,  3.944492294720257e-17,  1.261270660185059e-20, -3.640124630495097e-22,  1.662494725610625e-24, -5.567301898203479e-27,  1.305897650602327e-29,
  1.401964147263134e-01, -6.719978041541581e-04,  2.299775487104619e-06, -6.473657062721863e-09,  1.500272747069775e-11, -2.562295104370081e-14,  1.236200826434349e-17,
  1.335745836498587e-19, -7.509734960880434e-22,  2.541334722055975e-24, -6.511118384806557e-27,  8.860328879260054e-30,  1.752360419398749e-01, -8.326988203914914e-04,
  2.785273456657356e-06, -7.461604998682499e-09,  1.547204781526090e-11, -1.836585993968980e-14, -3.085680511171394e-17,  2.893900242127990e-19, -1.139454440976612e-21,
  2.981305930476716e-24, -4.822220140447677e-27, -5.572412429724156e-30,  2.142144824786331e-01, -1.007837052043560e-03,  3.281811524289835e-06, -8.268998294496292e-09,
  1.461815473527703e-11, -5.558812648661828e-15, -8.914541648615543e-17,  4.589561771897714e-19, -1.404004120680521e-21,  2.491534411391547e-24,  7.313452098152345e-28,
 -3.065499554859737e-29,  2.571410136369754e-01, -1.196137340266733e-03,  3.774541492892805e-06, -8.807364916311910e-09,  1.212833983217598e-11,  1.312077768101316e-14,
 -1.583678817102456e-16,  6.073966015701008e-19, -1.383715695502449e-21,  6.104984473546159e-25,  1.046146702692367e-26, -6.088469077060497e-29,  3.040227241397549e-01,
 -1.396087715362443e-03,  4.246509991597025e-06, -8.982828802761165e-09,  7.737155170173109e-12,  3.737589068877661e-14, -2.306406552575238e-16,  6.866129503865841e-19,
 -9.076082739093034e-22, -2.902041152515294e-24,  2.289117747324521e-26, -8.273978403183253e-29,  3.548631813331433e-01, -1.605899999241018e-03,  4.678519893474192e-06,
 -8.698611666995236e-09,  1.261520886382277e-12,  6.607880922513399e-14, -2.938787854477947e-16,  6.389480860756589e-19,  1.603631992562189e-22, -7.809861906200625e-24,
  3.397327358391333e-26, -7.513471733953417e-29,  4.096607154066407e-01, -1.823462744716581e-03,  5.049016883397549e-06, -7.858721619541714e-09, -7.354918592287607e-12,
  9.705204129930682e-14, -3.317886335738559e-16,  4.053706561861969e-19,  1.854378612536662e-21, -1.312237857948970e-23,  3.684568119104980e-26, -1.485557497506839e-29,
  4.684062065154053e-01, -2.046285318998220e-03,  5.334028622229354e-06, -6.373267888361515e-09, -1.798702955350559e-11,  1.268670861480988e-13, -3.246315373219339e-16,
 -6.030721428122505e-20,  4.020641972668479e-21, -1.688641482025620e-23,  2.280804425393842e-26,  1.107159316491228e-28,  5.310802241326884e-01, -2.271431914279181e-03,
  5.507198702956776e-06, -4.165966560671512e-09, -3.026269294403855e-11,  1.507073127497246e-13, -2.512031680791091e-16, -7.699846528536227e-19,  6.225010655975198e-21,
 -1.621398082959444e-23, -1.564053801371588e-26,  2.831929941985142e-28,  5.976493192886844e-01, -2.495444405356715e-03,  5.539979338001952e-06, -1.184539597861215e-09,
 -4.348811474058231e-11,  1.623720687974034e-13, -9.258818547641039e-17, -1.672619915660141e-18,  7.685107023092498e-21, -7.797708913341782e-24, -7.903652548809687e-26,
  4.299970908833589e-28,  6.680612055731469e-01, -2.714253420011216e-03,  5.402078357449384e-06,  2.585167442163010e-09, -5.656911381055602e-11,  1.545429932220002e-13,
  1.617034402408056e-16, -2.621293650405591e-18,  7.284871059118660e-21,  1.077906720837686e-23, -1.527635386416838e-25,  4.135343755881439e-28,  7.422384789014028e-01,
 -2.923077996103184e-03,  5.062301329898147e-06,  7.100474650608290e-09, -6.794012998069925e-11,  1.194904576121817e-13,  5.047699838347545e-16, -3.344627603249196e-18,
  3.763855019688719e-21,  3.870818817101827e-23, -1.991958220579857e-25,  6.230543559942518e-29,  8.200704131484116e-01, -3.116316199813340e-03,  4.489992592747466e-06,
  1.223784075025814e-08, -7.552387316518154e-11,  5.046036365070163e-14,  9.006997929646251e-16, -3.440960894842269e-18, -3.798867361379274e-21,  6.878233429846721e-23,
 -1.574463707816765e-25, -7.162176480691151e-28,  9.014022226294073e-01, -3.287432787925195e-03,  3.657363014603987e-06,  1.776339237960650e-08, -7.676238821136158e-11,
 -5.597784665745920e-14,  1.272028695453000e-15, -2.427771359794366e-18, -1.510547602202519e-20,  8.462196354088194e-23,  3.613316018444004e-26, -1.720364212469443e-27,
  9.860209983930430e-01, -3.428856579909692e-03,  2.543096370174130e-06,  2.329937086539248e-08, -6.878657579035029e-11, -1.963903203907461e-13,  1.491122298467130e-15,
  1.063582081349136e-19, -2.741665227893072e-20,  6.150528459603130e-23,  3.912372738645997e-25, -2.214443420177296e-27,  1.073637304772974e+00, -3.531911504551144e-03,
  1.137736547164854e-06,  2.829100418097605e-08, -4.882491729067675e-11, -3.557975088385349e-13,  1.385641162711526e-15,  4.198314530659239e-18, -3.446533548439737e-20,
 -2.355488841124327e-23,  7.702972432070828e-25, -9.691753811719885e-28,  1.163861182841825e+00, -3.586824064692118e-03, -5.485700428983369e-07,  3.198429411306394e-08,
 -1.498356937090767e-11, -5.026873074157695e-13,  7.753584039629839e-16,  9.053240477585963e-18, -2.681969802454066e-20, -1.665811314676502e-22,  8.148871144276879e-25,
  2.838141861262470e-27,  1.256171101524905e+00, -3.582880003243167e-03, -2.475479383555813e-06,  3.343551045872881e-08,  3.247244572797711e-11, -5.862141298770594e-13,
 -4.374686413125903e-16,  1.259033273460027e-17,  3.959926466393733e-21, -2.994872617866003e-22,  5.798843120326562e-26,  7.494463850301427e-27,  1.349874353120859e+00,
 -3.508848467377445e-03, -4.558970671469658e-06,  3.158874763413739e-08,  8.931986869747703e-11, -5.408635721423343e-13, -2.111958742845269e-15,  1.148605195117632e-17,
  5.514968115779409e-20, -2.737130163062599e-22, -1.542243688438661e-24,  6.934324622242062e-27,  1.444057779714015e+00, -3.353854997448598e-03, -6.656264886267424e-06,
  2.547628222845456e-08,  1.454118585097459e-10, -3.070365191811879e-13, -3.686410653605909e-15,  2.637248807114701e-18,  9.929995168567421e-20,  5.674948976704569e-23,
 -2.741538548130968e-24, -5.246171945460306e-27,  1.537529064850737e+00, -3.108957557723043e-03, -8.553318819575238e-06,  1.460480761625724e-08,  1.837194747194394e-10,
  1.243290765384966e-13, -4.135251396728005e-15, -1.316036129746111e-17,  8.362277406632181e-20,  5.868477123288727e-22, -1.112738711030788e-24, -2.112328538718589e-26,
  1.628752037405465e+00, -2.769727810883183e-03, -9.964365284354456e-06, -4.471121153966422e-10,  1.828404030456956e-10,  6.487793165245419e-13, -2.395276981341527e-15,
 -2.679950855914759e-17, -2.670845366606261e-20,  7.370690424060187e-22,  3.611850523107582e-24, -1.104808013517754e-26,  1.715785832427807e+00, -2.340069256521567e-03,
 -1.056049395066301e-05, -1.734835984653763e-08,  1.263028337330866e-10,  1.013122748412937e-12,  1.482581097805310e-15, -2.263987478026343e-17, -1.607554118393879e-19,
 -7.410500894797758e-23,  5.122757235706574e-24,  2.933251713114887e-26,  1.796248636717262e+00, -1.837126294475416e-03, -1.004994986160927e-05, -3.171731895474384e-08,
  1.946540361301539e-11,  9.094377056418142e-13,  5.112360746157420e-15,  4.548258642277042e-18, -1.383858595379490e-19, -1.071650641105515e-21, -2.230253984684281e-24,
  2.437787347519694e-26,  1.867341716304021e+00, -1.296195791521818e-03, -8.323983715097974e-06, -3.808869353924744e-08, -9.553777505290791e-11,  2.691173246005455e-13,
  4.808481478444710e-15,  2.902772954684630e-17,  6.986804707805551e-20, -4.557298927674865e-22, -6.300228036351085e-24, -3.523681510644294e-26,  1.925982659414257e+00,
 -7.729743780578601e-04, -5.637593323197048e-06, -3.289826024762183e-08, -1.515069087761173e-10, -4.578883421623671e-13,  3.062433759818924e-16,  1.708229014115415e-17,
  1.481128911264198e-19,  8.012375918415732e-22,  2.304918259841833e-24, -7.577662464424099e-27,  1.969092842875544e+00, -3.390294832209684e-04, -2.709238786685279e-06,
 -1.849635218597027e-08, -1.121665508215207e-10, -6.047683954024681e-13, -2.808958258451039e-15, -1.007375749303852e-17, -1.409070694566849e-20,  1.866930734763072e-22,
  2.447580593765737e-24,  1.947328259302864e-26,  1.994045678385403e+00, -6.720765775986016e-05, -5.658522925027513e-07, -4.204743073568857e-09, -2.903211047391506e-11,
 -1.903564720744824e-13, -1.197617341831808e-15, -7.264767153793010e-18, -4.254833052123482e-20, -2.402758217015289e-22, -1.302605418189448e-24, -6.720590945535359e-27,
  4.743137103484688e-04, -2.324925834283397e-06,  8.544871882574857e-09, -2.791477379211582e-11,  8.544568255971990e-14, -2.511525649441210e-16,  7.165776358031238e-19,
 -2.007066338214951e-21,  5.500168412896110e-24, -1.506626090658389e-26,  3.966826463397545e-29, -1.107559094524216e-31,  4.269245609068398e-03, -2.090963752241455e-05,
  7.669844768072221e-08, -2.496618205496196e-10,  7.598605915861475e-13, -2.215090643087692e-15,  6.248459825281908e-18, -1.724228406345433e-20,  4.634034512444756e-23,
 -1.240087960625080e-25,  3.161745051670262e-28, -8.576493725109303e-31,  1.186135357545745e-02, -5.800028713801897e-05,  2.119066665540531e-07, -6.847695160190507e-10,
  2.060023257915081e-12, -5.903405280233379e-15,  1.625798298573665e-17, -4.344089728180042e-20,  1.117811877067618e-22, -2.832813111463678e-25,  6.664907260982290e-28,
 -1.676490399363448e-30,  2.325508872478934e-02, -1.134373913055067e-04,  4.119549712701050e-07, -1.316432807124715e-09,  3.889268077712667e-12, -1.084642796288467e-14,
  2.871564302159702e-17, -7.257889623506479e-20,  1.722858741100539e-22, -3.906168426024995e-25,  7.552064290725484e-28, -1.523531965491583e-30,  3.845703232721370e-02,
 -1.869768233063111e-04,  6.734796379040720e-07, -2.119369002660000e-09,  6.104346845377236e-12, -1.636383878148050e-14,  4.077648269958685e-17, -9.391284334460623e-20,
  1.907421845637603e-22, -3.284114160958692e-25,  2.423275627683694e-28,  4.759234524249551e-31,  5.747577459951551e-02, -2.782837550142703e-04,  9.919170902797105e-07,
 -3.059743788681723e-09,  8.517753773008861e-12, -2.159521982910114e-14,  4.902411525257411e-17, -9.550870213301427e-20,  1.306099505181395e-22, -2.068502512203215e-27,
 -1.054286812199197e-27,  4.402899886384256e-30,  8.032174140623730e-02, -3.869242786786747e-04,  1.361435697127002e-06, -4.095101554253881e-09,  1.090121560151678e-11,
 -2.554335468215521e-14,  4.980314788097622e-17, -6.623056972251165e-20, -3.411086128975707e-23,  6.169417222512129e-25, -2.998094282034537e-27,  9.038611036222294e-30,
  1.070069578505408e-01, -5.123544358797959e-04,  1.774849690540675e-06, -5.174329191850981e-09,  1.299071231824958e-11, -2.713245953960871e-14,  3.964369854127471e-17,
  1.880025850063788e-21, -3.080361720687159e-22,  1.450905044457738e-24, -5.021924219328329e-27,  1.172131963318510e-29,  1.375447336293920e-01, -6.539062938904959e-04,
  2.223515008617839e-06, -6.237695751459095e-09,  1.449352459701079e-11, -2.528401454866388e-14,  1.577906023580940e-17,  1.109577386337455e-19, -6.640793255362564e-22,
  2.288700341541864e-24, -6.120966475789670e-27,  8.810730070991306e-30,  1.719492498557837e-01, -8.107706095453085e-04,  2.697207268808637e-06, -7.217028326380976e-09,
  1.509796044163694e-11, -1.901321065326699e-14, -2.324849314643427e-17,  2.546070561014715e-19, -1.035651144631273e-21,  2.784311312431520e-24, -5.009236826487650e-27,
 -3.062279280134282e-30,  2.102350204122833e-01, -9.819755048125999e-04,  3.183982853964688e-06, -8.036109195391957e-09,  1.448659860915349e-11, -7.549087230777128e-15,
 -7.691012768717400e-17,  4.154662836608138e-19, -1.314091222047264e-21,  2.495570511899238e-24, -4.880186454932116e-28, -2.495358523297710e-29,  2.524161922619821e-01,
 -1.166360444300907e-03,  3.670025440871811e-06, -8.611412973601834e-09,  1.235409890708031e-11,  9.519053330104464e-15, -1.419768313286485e-16,  5.635450114873221e-19,
 -1.354829507008193e-21,  9.777395876773541e-25,  7.957436913064133e-27, -5.308175467295559e-29,  2.985056377867284e-01, -1.362544651816419e-03,  4.139482524437416e-06,
 -8.853348456608345e-09,  8.430859116282231e-12,  3.206784461269683e-14, -2.118365877920468e-16,  6.560676151177864e-19, -9.964612944232898e-22, -2.057423296470274e-24,
  1.938428154093213e-26, -7.662774996176156e-29,  3.485137771737347e-01, -1.568888932339280e-03,  4.574300046783795e-06, -8.668231851291170e-09,  2.514017224726506e-12,
  5.924073423318596e-14, -2.759568311204514e-16,  6.398369833873051e-19, -9.713549083752150e-23, -6.517860092626531e-24,  3.061099005310732e-26, -7.731962249515127e-29,
  4.024470488017523e-01, -1.783449684097176e-03,  4.954068815473171e-06, -7.961300668512087e-09, -5.492554818469400e-12,  8.923159769589498e-14, -3.196764930181423e-16,
  4.574351068803912e-19,  1.408292259849226e-21, -1.166727830868078e-23,  3.577775634143716e-26, -3.293326415943885e-29,  4.603059186727641e-01, -2.003923709265186e-03,
  5.255905012810506e-06, -6.641185266646397e-09, -1.552766339847539e-11,  1.190696494782630e-13, -3.246089738837503e-16,  5.881166417856550e-20,  3.430221346039753e-21,
 -1.588817744024928e-23,  2.682829585518191e-26,  7.288390253983581e-29,  5.220822837197805e-01, -2.227582295590769e-03,  5.454400272381217e-06, -4.626390978891816e-09,
 -2.731046774410288e-11,  1.444416884392377e-13, -2.700624077241841e-16, -5.802208287349071e-19,  5.632913590831646e-21, -1.660526086383633e-23, -4.288910424618282e-27,
  2.330397959108815e-28,  5.877560749365316e-01, -2.451193011376505e-03,  5.521696735973124e-06, -1.854506064604889e-09, -4.026654558905702e-11,  1.596154611092584e-13,
 -1.360249550489099e-16, -1.431761709918461e-18,  7.351953281898675e-21, -1.059074369441139e-23, -6.087803451169467e-26,  3.939645045958542e-28,  6.572908002082881e-01,
 -2.670927855760005e-03,  5.427772346205362e-06,  1.704974884789707e-09, -5.344525270394447e-11,  1.575697804978394e-13,  9.162097741586060e-17, -2.383112215543000e-18,
  7.567396391106029e-21,  5.041272835759946e-24, -1.339500497099967e-25,  4.377757963320387e-28,  7.306276775299863e-01, -2.882257056651248e-03,  5.141065682701632e-06,
  6.033177684151812e-09, -6.543668604459120e-11,  1.304959852383352e-13,  4.130051864311369e-16, -3.203418243894477e-18,  5.014968907158714e-21,  3.083639640411173e-23,
 -1.934321592946026e-25,  1.943280590754806e-28,  8.076778894159073e-01, -3.079829301041904e-03,  4.629633408284498e-06,  1.103867397410560e-08, -7.430636348830930e-11,
  7.090950218942836e-14,  8.030142436775836e-16, -3.524178840248261e-18, -1.443004700197967e-21,  6.192590965406575e-23, -1.836285644663137e-25, -4.766166025605685e-28,
  8.883123297282549e-01, -3.257342194772046e-03,  3.863122896123379e-06,  1.652787237921147e-08, -7.758243476457537e-11, -2.631668930445976e-14,  1.197742967662790e-15,
 -2.862269720697685e-18, -1.205074028645568e-20,  8.461681909096644e-23, -3.474157049398943e-26, -1.494315700675043e-27,  9.723480055758125e-01, -3.407412434977997e-03,
  2.815961988704269e-06,  2.216930688109775e-08, -7.235677492871625e-11, -1.606646383441206e-13,  1.482170954770279e-15, -7.327197895227753e-19, -2.494453698570577e-20,
  7.517671120923896e-23,  2.918370187484443e-25, -2.282922732771545e-27,  1.059529993209074e+00, -3.521465453234409e-03,  1.472312535660390e-06,  2.745472249679973e-08,
 -5.559943845718099e-11, -3.212566871260443e-13,  1.487667871927039e-15,  3.087706830255301e-18, -3.477088483030872e-20,  6.196307024409881e-24,  7.123740757485896e-25,
 -1.639920506840174e-27,  1.149507533516435e+00, -3.589682211544052e-03, -1.665252035677884e-07,  3.166522247465884e-08, -2.483122063577597e-11, -4.811391075085156e-13,
  1.015978543346765e-15,  8.105574565607645e-18, -3.220285802330057e-20, -1.318244112327114e-22,  9.145144092776547e-25,  1.681477705718677e-27,  1.241802526231294e+00,
 -3.601070995460395e-03, -2.071524324612428e-06,  3.386082486077384e-08,  2.067175736926106e-11, -5.924786366576763e-13, -8.477920616675223e-17,  1.254563192508170e-17,
 -6.701415337006309e-21, -2.906916380725297e-22,  3.780082012803858e-25,  6.975770516925210e-27,  1.335768449658505e+00, -3.543780517306591e-03, -4.171696576187007e-06,
  3.292868618192651e-08,  7.802276802250139e-11, -5.875013622749821e-13, -1.767204814768907e-15,  1.308191008333748e-17,  4.426461679534084e-20, -3.287052057161411e-22,
 -1.193591013049510e-24,  8.822975363929838e-27,  1.430537850867184e+00, -3.405843200742092e-03, -6.336808092421397e-06,  2.774897062538111e-08,  1.383942317892519e-10,
 -3.942640695961561e-13, -3.567927370062282e-15,  5.825984048976655e-18,  9.932336991818739e-20, -5.642556644177267e-23, -2.888984104555083e-24, -1.375280834275724e-27,
  1.524957562236682e+00, -3.176632952469652e-03, -8.360359797410962e-06,  1.755869989634055e-08,  1.851853925309494e-10,  2.098271015133269e-14, -4.463174311935146e-15,
 -1.015682544735080e-17,  1.037229157359299e-19,  5.236406999327394e-22, -2.047203881727487e-24, -2.106369514154543e-26,  1.617513733820617e+00, -2.849413497370743e-03,
 -9.951760574934844e-06,  2.578759037503004e-09,  1.951799500765656e-10,  5.822169449364566e-13, -3.153446997503501e-15, -2.720283643418150e-17,  2.287810037204903e-21,
  8.694432851145175e-22,  2.947461463828879e-24, -1.919095977943254e-26,  1.706255319568215e+00, -2.425350023634317e-03, -1.075587488747053e-05, -1.516370758821844e-08,
  1.468667516202781e-10,  1.040515416032025e-12,  7.765415282816316e-16, -2.778469672664386e-17, -1.594295873816619e-19,  1.559307346171822e-22,  6.355886061920770e-24,
  2.614420949895447e-26,  1.788736931177338e+00, -1.919041604254302e-03, -1.042806709119254e-05, -3.125366211115668e-08,  3.888870026781196e-11,  1.033125968178486e-12,
  5.171805815168538e-15, -5.122614148088882e-19, -1.782792960934878e-19, -1.135730600699609e-21, -8.797681249776102e-25,  3.726647499883620e-26,  1.862020818563599e+00,
 -1.364641453621813e-03, -8.790020969962107e-06, -3.956768823080219e-08, -8.893432332740344e-11,  3.945098659569930e-13,  5.649727865988399e-15,  3.094929955426732e-17,
  4.854660541249882e-20, -7.392945368338837e-22, -7.886219840732888e-24, -3.633906695677600e-26,  1.922798001049115e+00, -8.196961435625782e-04, -6.047217553847388e-06,
 -3.539506097496161e-08, -1.605495512847986e-10, -4.442360057292699e-13,  8.553607385259796e-16,  2.230040951956503e-17,  1.785138535016931e-19,  8.842136677482473e-22,
  1.774185031978062e-24, -1.716275651764310e-26,  1.967691927084834e+00, -3.616226712462075e-04, -2.942374278034135e-06, -2.039153955629890e-08, -1.249591503681946e-10,
 -6.756121989556591e-13, -3.096180777643941e-15, -1.039644671671208e-17, -5.384608893830740e-21,  3.035555243367221e-22,  3.443493339795463e-24,  2.606106633824147e-26,
  1.993767463014191e+00, -7.194450034448520e-05, -6.192271818635559e-07, -4.701347604308909e-09, -3.314397498596227e-11, -2.217024717143465e-13, -1.421468032114897e-15,
 -8.775375683539148e-18, -5.221177788361219e-20, -2.987801859881857e-22, -1.635327790306348e-24, -8.467548028109903e-27,  4.651486357540140e-04, -2.257883902913647e-06,
  8.217934597366037e-09, -2.658691162007943e-11,  8.059015856655503e-14, -2.346096778129179e-16,  6.627644443597041e-19, -1.839442195659780e-21,  4.985201890765016e-24,
 -1.357349301723991e-26,  3.505284276205704e-29, -9.939836483239820e-32,  4.186815547256399e-03, -2.030783034107794e-05,  7.377401644322630e-08, -2.378504787793352e-10,
  7.170201523980032e-13, -2.070757487599296e-15,  5.785782192819403e-18, -1.582845349627810e-20,  4.209481178730549e-23, -1.120912780882123e-25,  2.802972914684223e-28,
 -7.758326261005509e-31,  1.163269167047657e-02, -5.633735125349177e-05,  2.038833659080809e-07, -6.527328947316383e-10,  1.945760593910511e-12, -5.527414871928566e-15,
  1.509021857523692e-17, -4.002206589826962e-20,  1.020455174037209e-22, -2.580577429214995e-25,  5.956071712208310e-28, -1.550289466569689e-30,  2.280783186225932e-02,
 -1.102038986758477e-04,  3.965241081111895e-07, -1.255903181064118e-09,  3.679069829132687e-12, -1.018102884205846e-14,  2.675854478852322e-17, -6.728504426698767e-20,
  1.587512936681895e-22, -3.617459548646244e-25,  6.883858763855504e-28, -1.517132136526584e-30,  3.771974194785659e-02, -1.816890800648296e-04,  6.486225968622821e-07,
 -2.024265376586145e-09,  5.786646949746028e-12, -1.541607904481451e-14,  3.823061176483366e-17, -8.799635321891109e-20,  1.790979040243700e-22, -3.184081705141634e-25,
  2.551794529357175e-28,  1.109541768281702e-31,  5.637828094043332e-02, -2.704930015787446e-04,  9.560038209465891e-07, -2.926851936789497e-09,  8.097400989867350e-12,
 -2.045026005209980e-14,  4.640831774052542e-17, -9.133815203976622e-20,  1.298205508986658e-22, -4.064295307224656e-26, -8.811907971362825e-28,  3.474807160868122e-30,
  7.879552017036409e-02, -3.762264312527245e-04,  1.313324345200533e-06, -3.924704730553218e-09,  1.040215049910123e-11, -2.437043623606840e-14,  4.793658851734862e-17,
 -6.698915156217293e-20, -1.396758874981102e-23,  5.045502593901330e-25, -2.631812192897784e-27,  7.619172807699164e-30,  1.049855493875348e-01, -4.984005135883963e-04,
  1.713987108654686e-06, -4.970767294439511e-09,  1.245757632226104e-11, -2.618144604338594e-14,  3.956592067493456e-17, -7.179195109771517e-21, -2.592987835286888e-22,
  1.259935449276796e-24, -4.536763442353212e-27,  1.031935944780066e-29,  1.349642161441097e-01, -6.364136792718826e-04,  2.150037419947118e-06, -6.009823210266286e-09,
  1.399187083930210e-11, -2.487036215309017e-14,  1.860042329449142e-17,  9.097899073242710e-20, -5.860006174067702e-22,  2.051518079050155e-24, -5.741193772820433e-27,
  8.392471164079332e-30,  1.687487799990312e-01, -7.895352911945428e-04,  2.612039692637005e-06, -6.978531031398023e-09,  1.471267507273895e-11, -1.948928020360257e-14,
 -1.656867565802393e-17,  2.230310827213983e-19, -9.390498313272938e-22,  2.581810504083988e-24, -5.103229366415137e-27, -1.335308811634488e-30,  2.063574569213258e-01,
 -9.568854469743416e-04,  3.088934960424140e-06, -7.805627891598048e-09,  1.431807650529524e-11, -9.260002551408307e-15, -6.585231745249651e-17,  3.748469854196655e-19,
 -1.224853466175717e-21,  2.455524765188107e-24, -1.480736408853937e-27, -2.034951505244343e-29,  2.478088211860135e-01, -1.137410214989350e-03,  3.567880175996437e-06,
 -8.412404203097865e-09,  1.251165848085079e-11,  6.296096047653368e-15, -1.267988309589688e-16,  5.208106346784660e-19, -1.314445256067347e-21,  1.251414168400883e-24,
  5.776175627357317e-27, -4.623483296085039e-29,  2.931210213448616e-01, -1.329851412173971e-03,  4.034071992320744e-06, -8.713593910407586e-09,  9.022844295495705e-12,
  2.720053877113151e-14, -1.939232147545562e-16,  6.231389385054089e-19, -1.057367858837400e-21, -1.347668365685808e-24,  1.614813393724168e-26, -7.050100665727161e-29,
  3.423107525406983e-01, -1.532709835542970e-03,  4.470560560087147e-06, -8.618882823692148e-09,  3.634050715135036e-12,  5.283219574451260e-14, -2.581185407289003e-16,
  6.332040087746933e-19, -3.105604111994050e-22, -5.361654772801053e-24,  2.719742025098872e-26, -7.758571560267432e-29,  3.953919081738546e-01, -1.744200637034685e-03,
  4.858063476838125e-06, -8.035316906596971e-09, -3.783583053070869e-12,  8.171777414362798e-14, -3.062985869312774e-16,  4.960532098514541e-19,  1.013640718536249e-21,
 -1.026951837106666e-23,  3.400902138784175e-26, -4.684401971987622e-29,  4.523738078583611e-01, -1.962199291340502e-03,  5.174797350797232e-06, -6.870999250858411e-09,
 -1.322398128908751e-11,  1.113106775491791e-13, -3.215099849629817e-16,  1.596399390574097e-19,  2.878244557834674e-21, -1.476090075036372e-23,  2.929721477994113e-26,
  4.015540667006572e-29,  5.132588631353888e-01, -2.184176371388495e-03,  5.396355952275842e-06, -5.040605118355953e-09, -2.448766197281223e-11,  1.377850520104593e-13,
 -2.838750374452087e-16, -4.095461392239579e-19,  5.034376550247747e-21, -1.658607073566740e-23,  4.898458688620998e-27,  1.850041134515979e-28,  5.780394939523242e-01,
 -2.407119164882868e-03,  5.495681810354460e-06, -2.473422853546569e-09, -3.710999375181441e-11,  1.558960066495021e-13, -1.728810828646776e-16, -1.203036271894356e-18,
  6.930920910386554e-21, -1.269145400399721e-23, -4.447185129194677e-26,  3.508446699929727e-28,  6.466940425145142e-01, -2.627438135132979e-03,  5.443205622824965e-06,
  8.751592870290671e-10, -5.027713095843445e-11,  1.589954536145125e-13,  2.830415877996780e-17, -2.139048012787395e-18,  7.657103412365446e-21,  7.076089212187024e-26,
 -1.145557547559512e-25,  4.405529813211514e-28,  7.191813400138597e-01, -2.840856535736559e-03,  5.207269682421024e-06,  5.007578466167394e-09, -6.273481256817494e-11,
  1.393508681136882e-13,  3.257125282074824e-16, -3.026652105771775e-18,  5.988161175694526e-21,  2.330178784149599e-23, -1.825722597468342e-25,  2.940280187080292e-28,
  7.954334569023197e-01, -3.042282474337017e-03,  4.755014185442125e-06,  9.862131191033330e-09, -7.270346127694590e-11,  8.899451032115323e-14,  7.040155882249811e-16,
 -3.536140308360602e-18,  6.496664845648149e-22,  5.422745110588237e-23, -1.997030040518091e-25, -2.582416467386816e-28,  8.753459972020255e-01, -3.225665006143544e-03,
  4.053997064925701e-06,  1.528387661266660e-08, -7.782801517116033e-11,  1.426645818000521e-15,  1.112655994617151e-15, -3.199546526163743e-18, -9.044721816241890e-21,
  8.198637965345278e-23, -9.490179093178456e-26, -1.236693776306077e-27,  9.587650680038370e-01, -3.383840525075257e-03,  3.074947620018485e-06,  2.098781632552161e-08,
 -7.521646374911078e-11, -1.254263523590583e-13,  1.450901430141695e-15, -1.485586445486331e-18, -2.205221532508307e-20,  8.484779577860271e-23,  1.920779502522547e-25,
 -2.233724337890187e-27,  1.045469752977678e+00, -3.508384724886417e-03,  1.796225988907318e-06,  2.651569746790508e-08, -6.166117721072453e-11, -2.846405211710457e-13,
  1.558618183251151e-15,  1.983955958488586e-18, -3.405380897673939e-20,  3.308450379280324e-23,  6.282791191446351e-25, -2.155509643116336e-27,  1.135148536335817e+00,
 -3.589501958935491e-03,  2.107606143109684e-07,  3.119234053973312e-08, -3.419240397754627e-11, -4.541527243420894e-13,  1.227845388275432e-15,  7.006336294606053e-18,
 -3.627540685312620e-20, -9.410992638414043e-23,  9.626936692410188e-25,  5.134812364885095e-28,  1.227367678033391e+00, -3.616013148440990e-03, -1.663601006563740e-06,
  3.409678472048637e-08,  8.830125278024782e-12, -5.903317882255453e-13,  2.619472433617447e-16,  1.216725244464456e-17, -1.682240041089812e-20, -2.696824377326046e-22,
  6.655622900419295e-25,  6.031313946002777e-27,  1.321529111789507e+00, -3.575553198130779e-03, -3.769457024938966e-06,  3.408087309359646e-08,  6.587906107418824e-11,
 -6.253699393840394e-13, -1.382920903810972e-15,  1.430061466095057e-17,  3.166933631653030e-20, -3.682620511924531e-22, -7.750060219562596e-25,  1.009068662793763e-26,
  1.416815250372074e+00, -3.455168700867769e-03, -5.990809716844155e-06,  2.989560539865231e-08,  1.296677064411249e-10, -4.775803184429741e-13, -3.360767659789072e-15,
  8.949482281332632e-18,  9.520849623877584e-20, -1.719734621109213e-22, -2.857867937877066e-24,  2.812234614848493e-27,  1.512118670236294e+00, -3.242622649197329e-03,
 -8.131882852312039e-06,  2.051911370314720e-08,  1.845128593065380e-10, -8.915429577628709e-14, -4.698386685504779e-15, -6.553669849646852e-18,  1.208802122261880e-19,
  4.236359057397244e-22, -2.939283969074788e-24, -1.917507716534410e-26,  1.605957123728266e+00, -2.928849855620046e-03, -9.901707954672013e-06,  5.790422410894219e-09,
  2.060059339678960e-10,  4.974320278117530e-13, -3.909244095134532e-15, -2.660786781399278e-17,  3.548466501814346e-20,  9.680693183332191e-22,  1.925841936586348e-24,
 -2.713868780456239e-26,  1.696380731522363e+00, -2.512083346134639e-03, -1.092305089761055e-05, -1.264661928366064e-08,  1.677974633692023e-10,  1.049247252297540e-12,
 -7.164816049131981e-17, -3.274540957720243e-17, -1.489780999308955e-19,  4.314161020547086e-22,  7.367779258385162e-24,  1.919109339794964e-26,  1.780891557467293e+00,
 -2.003954124944699e-03, -1.079867405475831e-05, -3.045941567759301e-08,  6.078779860395632e-11,  1.156394592083741e-12,  5.071418139621396e-15, -6.874722085044859e-18,
 -2.193669659301350e-19, -1.134066705152705e-21,  1.064343896337994e-24,  5.116169562889830e-26,  1.856418571971196e+00, -1.436884411558590e-03, -9.273085870884768e-06,
 -4.091985112169141e-08, -7.961720360157859e-11,  5.406509983061808e-13,  6.533604006479821e-15,  3.201297171309181e-17,  1.587254257118956e-20, -1.086221837516517e-21,
 -9.439273567916987e-24, -3.344198959529173e-26,  1.919419708438564e+00, -8.698171832877202e-04, -6.487660016324179e-06, -3.803359187156931e-08, -1.691749449602568e-10,
 -4.155390426590159e-13,  1.564619815526016e-15,  2.853416293050431e-17,  2.114076410996825e-19,  9.363537600794590e-22,  7.323919266230123e-25, -3.096644550657728e-26,
  1.966196759282511e+00, -3.861755019117901e-04, -3.199528084437719e-06, -2.250312051912843e-08, -1.392381110064268e-10, -7.534221085323108e-13, -3.387847562047870e-15,
 -1.036494349841663e-17,  8.319900351213140e-21,  4.665436467064442e-22,  4.766447544914926e-24,  3.437519616910358e-26,  1.993469406888215e+00, -7.713334710504219e-05,
 -6.789777393550664e-07, -5.269064263997494e-09, -3.794009891219181e-11, -2.589654371890672e-13, -1.692280829939979e-15, -1.063163912205218e-17, -6.424055553944648e-20,
 -3.722513727222832e-22, -2.054068172749461e-24, -1.064313806974269e-26,  4.562465969740658e-04, -2.193395028446764e-06,  7.906476223197851e-09, -2.533415957949057e-11,
  7.605294790407835e-14, -2.193037992783747e-16,  6.134218542046352e-19, -1.687471839683546e-21,  4.520766475694841e-24, -1.225599154507619e-26,  3.088903169496834e-29,
 -9.022772667236461e-32,  4.106746804765579e-03, -1.972886310230348e-05,  7.098730196646660e-08, -2.267020808743651e-10,  6.769584625617467e-13, -1.937068513377038e-15,
  5.360852379591525e-18, -1.454388572525960e-20,  3.825330108208234e-23, -1.015416878701362e-25,  2.476576472320281e-28, -7.105744367123819e-31,  1.141055552787103e-02,
 -5.473709453398399e-05,  1.962337788102749e-07, -6.224658084432954e-10,  1.838745050072932e-12, -5.178336466583034e-15,  1.401395253204447e-17, -3.690078407187729e-20,
  9.316811777049671e-23, -2.355672820107553e-25,  5.296102690860357e-28, -1.455036509498320e-30,  2.237326659728572e-02, -1.070910037082599e-04,  3.817998524653848e-07,
 -1.198632765648481e-09,  3.481721616923471e-12, -9.560869343682974e-15,  2.494376349122067e-17, -6.240818494255845e-20,  1.462079608257957e-22, -3.355491816016296e-25,
  6.213062361727948e-28, -1.537503736093354e-30,  3.700321193656003e-02, -1.765957131726998e-04,  6.248769150631509e-07, -1.934096571528477e-09,  5.487304442237532e-12,
 -1.452747404009723e-14,  3.584524057998895e-17, -8.244665018829390e-20,  1.678191527732849e-22, -3.082091980594042e-25,  2.521341519184563e-28, -2.513412952275202e-31,
  5.531138562341600e-02, -2.629832881065753e-04,  9.216456447016425e-07, -2.800505907226869e-09,  7.699329049640946e-12, -1.936668220235044e-14,  4.390874228425510e-17,
 -8.721382428161569e-20,  1.277573937071004e-22, -7.309605326301094e-26, -7.479440834874205e-28,  2.584333232958763e-30,  7.731133330341203e-02, -3.659054295733645e-04,
  1.267210611133788e-06, -3.762107721491408e-09,  9.926094431827776e-12, -2.324250090063606e-14,  4.605722424222552e-17, -6.716517985110783e-20,  2.378376765808373e-24,
  4.055728469537738e-25, -2.327185824952091e-27,  6.227727118605676e-30,  1.030189980802688e-01, -4.849238645495337e-04,  1.655516715594202e-06, -4.775583595379985e-09,
  1.194342226752169e-11, -2.523517310131812e-14,  3.925531144196726e-17, -1.478519473110110e-20, -2.171020654713147e-22,  1.087114510127906e-24, -4.115153336468384e-27,
  8.826055853762127e-30,  1.324525106024191e-01, -6.194980832787497e-04,  2.079246427430312e-06, -5.789907450974306e-09,  1.349912337087246e-11, -2.439543535661298e-14,
  2.089609770586456e-17,  7.336503402562819e-20, -5.161924330462320e-22,  1.829052753512957e-24, -5.387756634904082e-27,  7.611478615068603e-30,  1.656319067114233e-01,
 -7.689699710491129e-04,  2.529696809812985e-06, -6.746266057368749e-09,  1.431940163134164e-11, -1.981530110941840e-14, -1.073080834819872e-17,  1.944291206032337e-19,
 -8.497899314920304e-22,  2.376847845363562e-24, -5.137794660588723e-27, -3.595451922586587e-31,  2.025787503439782e-01, -9.325447575286438e-04,  2.996635580868571e-06,
 -7.578102649442569e-09,  1.411789950596745e-11, -1.071885742351377e-14, -5.589213822000843e-17,  3.370529422866165e-19, -1.137726212748032e-21,  2.379501040823106e-24,
 -2.294877686707133e-27, -1.683914438719323e-29,  2.433156318819233e-01, -1.109267557291924e-03,  3.468136077941221e-06, -8.211370764559518e-09,  1.260830549867948e-11,
  3.423206568636712e-15, -1.127979366024401e-16,  4.795099219986642e-19, -1.265709433424099e-21,  1.443553056478804e-24,  3.872718670801237e-27, -4.047764788035621e-29,
  2.878655021321538e-01, -1.297994594798384e-03,  3.930392207714481e-06, -8.565123328385267e-09,  9.521706843921466e-12,  2.275189233804981e-14, -1.769554646944584e-16,
  5.886456103734114e-19, -1.094989026038974e-21, -7.620526473468428e-25,  1.317451689199472e-26, -6.475926881957397e-29,  3.362507886310261e-01, -1.497357990828020e-03,
  4.367516630445398e-06, -8.552615441821306e-09,  4.630175753166299e-12,  4.684881331900370e-14, -2.405555184976418e-16,  6.203810605881583e-19, -4.848187461670380e-22,
 -4.341820622611251e-24,  2.380120360927471e-26, -7.664737869002732e-29,  3.884922226648870e-01, -1.705722731926334e-03,  4.761329102964287e-06, -8.083174020853987e-09,
 -2.221596655215072e-12,  7.453661493851203e-14, -2.920087171462959e-16,  5.228327849436720e-19,  6.678971347010475e-22, -8.953707355670983e-24,  3.170453137901762e-26,
 -5.743039147504607e-29,  4.446072803963055e-01, -1.921134150944395e-03,  5.091147969161934e-06, -7.065190791285176e-09, -1.107451633637156e-11,  1.036580018175021e-13,
 -3.158288691285439e-16,  2.434705970365113e-19,  2.368293285530640e-21, -1.356224938558575e-23,  3.043119068203125e-26,  1.211290407093357e-29,  5.046081071288897e-01,
 -2.141253926449788e-03,  5.333607604472272e-06, -5.410735853060316e-09, -2.180092804487784e-11,  1.308520979267689e-13, -2.931763346304871e-16, -2.579467403625659e-19,
  4.442643368762014e-21, -1.624082650672871e-23,  1.203547492470431e-26,  1.399363923640250e-28,  5.684987462818875e-01, -2.363282293173069e-03,  5.462540307606449e-06,
 -3.042475836972297e-09, -3.403616587373965e-11,  1.513672689728969e-13, -2.035320089128224e-16, -9.888710253564960e-19,  6.445604523381974e-21, -1.417532684411969e-23,
 -3.006801550824256e-26,  3.033402704519659e-28,  6.362714287884432e-01, -2.583863916070417e-03,  5.448985931811157e-06,  9.618150702606650e-11, -4.709513725512841e-11,
  1.589836930502246e-13, -2.816450664415817e-17, -1.894826570914908e-18,  7.581814894918142e-21, -4.127024092916246e-24, -9.544294512375015e-26,  4.255807051423006e-28,
  7.079015869541901e-01, -2.798974863948514e-03,  5.261431351620357e-06,  4.026513918386300e-09, -5.987637363159139e-11,  1.461733922456495e-13,  2.437651793629514e-16,
 -2.822991889566630e-18,  6.698898974862081e-21,  1.628000864318045e-23, -1.680179154306388e-25,  3.625463740857287e-28,  7.833411290214348e-01, -3.003788612828585e-03,
  4.866441845759572e-06,  8.713999369345405e-09, -7.076260770239458e-11,  1.047068387063034e-13,  6.055770861203062e-16, -3.485676380730769e-18,  2.455863224310113e-21,
  4.607018688512646e-23, -2.067781182517801e-25, -6.855686453130910e-29,  8.625093328337011e-01, -3.192520561325427e-03,  4.229937651699015e-06,  1.404027652322827e-08,
 -7.753985894613726e-11,  2.702533479501028e-14,  1.019454550163990e-15, -3.442587818295031e-18, -6.173935545491297e-21,  7.718115194489564e-23, -1.433929036935771e-25,
 -9.669413419670165e-28,  9.452804710204121e-01, -3.358254166241557e-03,  3.319503940603148e-06,  1.976616112383959e-08, -7.738054372029195e-11, -9.118074522263009e-14,
  1.399894282029265e-15, -2.141092329195122e-18, -1.888276134382952e-20,  9.060204148379767e-23,  9.670279063300188e-26, -2.087414121423995e-27,  1.031466944655387e+00,
 -3.492759354701053e-03,  2.108313652676871e-06,  2.548562527487243e-08, -6.697605076919907e-11, -2.466889449377450e-13,  1.599125367801404e-15,  9.179484470893220e-19,
 -3.243432907345132e-20,  5.620412192500331e-23,  5.251678000297512e-25, -2.503456341897452e-27,  1.120796257261276e+00, -3.586328621597381e-03,  5.814918521123593e-07,
  3.057426305349671e-08, -4.296557542932157e-11, -4.224643419362228e-13,  1.407315243741538e-15,  5.798772195288233e-18, -3.896780719188315e-20, -5.548148825560887e-23,
  9.607078110523446e-25, -5.866765070058341e-28,  1.212879601390395e+00, -3.627683803547708e-03, -1.253980096793133e-06,  3.414406984288737e-08, -2.886399554525914e-12,
 -5.800264619084476e-13,  5.936738920533135e-16,  1.147923489072776e-17, -2.599100843212589e-20, -2.381081826802009e-22,  9.038229322658038e-25,  4.752482461606967e-27,
  1.307169201861333e+00, -3.604056014911879e-03, -3.354580366969603e-06,  3.503321359494782e-08,  5.307273420882397e-11, -6.536529602374845e-13, -9.703464215877998e-16,
  1.509681376921606e-17,  1.796295051383216e-20, -3.901678371041177e-22, -3.163193914985047e-25,  1.063440667808468e-26,  1.402901043479151e+00, -3.501625673873876e-03,
 -5.619943503605807e-06,  3.188958472173796e-08,  1.193315653915904e-10, -5.548939442663506e-13, -3.068615000850372e-15,  1.187535081290532e-17,  8.700086207648856e-20,
 -2.825800316633134e-22, -2.642321446526523e-24,  6.944131115214573e-27,  1.499019699590302e+00, -3.306642782656815e-03, -7.868019092367491e-06,  2.345087371372263e-08,
  1.815896125881205e-10, -2.036672657496719e-13, -4.825613455487894e-15, -2.465774762387797e-18,  1.338200947333472e-19,  2.901616163837054e-22, -3.707131846021897e-24,
 -1.543007804568465e-26,  1.594083817110507e+00, -3.007728823636864e-03, -9.812135209246092e-06,  9.160758243261079e-09,  2.149568108258552e-10,  3.948309116692775e-13,
 -4.633036238306923e-15, -2.490234760919081e-17,  7.141450914928059e-20,  1.019102803087283e-21,  5.762213718373131e-25, -3.393395600105612e-26,  1.686156734714617e+00,
 -2.600027557468624e-03, -1.105801044664914e-05, -9.794394962753434e-09,  1.886882305907975e-10,  1.036002956000685e-12, -1.052512736633193e-15, -3.720585302226574e-17,
 -1.279651493856308e-19,  7.400652711067110e-22,  7.984302866416536e-24,  8.158414742266989e-27,  1.772700672980631e+00, -2.091787234753792e-03, -1.115756698634918e-05,
 -2.929525483376817e-08,  8.511298075352445e-11,  1.274968173566757e-12,  4.774597233320456e-15, -1.453482422684713e-17, -2.588476014080859e-19, -1.042432300754112e-21,
  3.614977682927956e-24,  6.452726882262405e-26,  1.850519525624375e+00, -1.513054028601111e-03, -9.771382074143952e-06, -4.209839709272865e-08, -6.716337966667973e-11,
  7.082324414835312e-13,  7.430663834224046e-15,  3.181959652631380e-17, -3.036405836236069e-20, -1.491119816717337e-21, -1.074140028602003e-23, -2.458964262285357e-26,
  1.915833680814660e+00, -9.235907083711754e-04, -6.960570784100997e-06, -4.080455117464083e-08, -1.770414181106449e-10, -3.676049607988332e-13,  2.463377947078455e-15,
  3.584123402847661e-17,  2.452689157605794e-19,  9.332247183462331e-22, -1.026711242660197e-24, -4.990664117442147e-26,  1.964599099574312e+00, -4.128909235288115e-04,
 -3.483444226032610e-06, -2.485599350655534e-08, -1.551429179098651e-10, -8.381660752460374e-13, -3.671533424392617e-15, -9.790053410134189e-18,  2.893765067183471e-20,
  6.903147067727966e-22,  6.496383106387443e-24,  4.457279332540335e-26,  1.993149594300423e+00, -8.282881229596286e-05, -7.460271123698241e-07, -5.919852607513360e-09,
 -4.355092282587391e-11, -3.033976746997078e-13, -2.020879695891303e-15, -1.291857122599686e-17, -7.924015234824862e-20, -4.645297950751722e-22, -2.579363190770752e-24,
 -1.332293239194363e-26,  };
  constexpr double w[13824] = {  8.601219706481898e-02, -3.138005274928349e-04,  1.208247149503499e-06, -4.838487358655930e-09,  1.986432801037984e-11,
 -8.267408578605809e-14,  3.461197585140237e-16, -1.450613298890146e-18,  6.068915808778118e-21, -2.530738662797991e-23,  1.051068440442633e-25, -4.346450467364567e-28,
  8.554378781504247e-02, -4.649327527677540e-04,  2.936072798598366e-06, -1.845932781591411e-08,  1.121444443314038e-10, -6.589844368550836e-13,  3.765152515727601e-15,
 -2.101283518446117e-17,  1.149418962917386e-19, -6.178590653239378e-22,  3.270294067327298e-24, -1.707068204671262e-26,  8.461776023054551e-02, -7.612242217454324e-04,
  7.107009776706448e-06, -6.044652755619057e-08,  4.779871348066663e-10, -3.578284588384459e-12,  2.564768767148054e-14, -1.773355960449718e-16,  1.189190461271712e-18,
 -7.765520747853063e-21,  4.953592460624555e-23, -3.094394699019771e-25,  8.325515813337386e-02, -1.191078778278964e-03,  1.506570054579813e-05, -1.649689274450205e-07,
  1.638628976251622e-09, -1.513755775711987e-11,  1.320308904718746e-13, -1.098362151291376e-15,  8.778549195466256e-18, -6.777488836633969e-20,  5.075859691021254e-22,
 -3.699753119797521e-24,  8.148624510804985e-02, -1.737946273662246e-03,  2.862461170737485e-05, -3.936156802759868e-07,  4.800853239482182e-09, -5.356696445240801e-11,
  5.571748490516996e-13, -5.471220131209268e-15,  5.117736637277860e-17, -4.590686849037468e-19,  3.969363278412364e-21, -3.321622001143631e-23,  7.934905712254822e-02,
 -2.381253891195962e-03,  4.984606115665156e-05, -8.442929958078551e-07,  1.242416764599753e-08, -1.647596891839344e-10,  2.013334914678044e-12, -2.300962405276214e-14,
  2.485450236740529e-16, -2.557400023845885e-18,  2.521745487580690e-20, -2.394091165681359e-22,  7.688765088482359e-02, -3.097522281901710e-03,  8.079309400703661e-05,
 -1.658068634234261e-06,  2.901530484849083e-08, -4.513910193896509e-10,  6.402691542325520e-12, -8.420962762664567e-14,  1.039265697451504e-15, -1.214219391333899e-17,
  1.352146959873123e-19, -1.442756287219148e-21,  7.415017519614661e-02, -3.861577837772631e-03,  1.232771488433094e-04, -3.021120399834031e-06,  6.209179749571790e-08,
 -1.120646920929840e-09,  1.826386143993892e-11, -2.738223856495781e-13,  3.826589307667302e-15, -5.033396248097493e-17,  6.278774439265281e-19, -7.470894912111077e-21,
  7.118689691508623e-02, -4.647770621158265e-03,  1.786294516634997e-04, -5.159667242900247e-06,  1.231721508198267e-07, -2.553765361209499e-09,  4.739393368422972e-11,
 -8.032719908642644e-13,  1.261219323211461e-14, -1.853975768611686e-16,  2.572400118311143e-18, -3.390181069611237e-20,  6.804830510826067e-02, -5.431114663678930e-03,
  2.475188016013585e-04, -8.326943572765813e-06,  2.285708108145437e-07, -5.395742588010047e-09,  1.131087512666360e-10, -2.151055384682067e-12,  3.768121018949139e-14,
 -6.149369579236627e-16,  9.430897929858919e-18, -1.368382297283099e-19,  6.478339857154231e-02, -6.188281892335276e-03,  3.298317198362407e-04, -1.278267685423157e-05,
  3.997294794129925e-07, -1.065603346303791e-08,  2.504471640745206e-10, -5.307761167992426e-12,  1.030745710985055e-13, -1.856225217658019e-15,  3.128630014863625e-17,
 -4.970518679464747e-19,  6.143823624346580e-02, -6.898400414170234e-03,  4.246229485276998e-04, -1.876687246673104e-05,  6.628240996870147e-07, -1.980216613796318e-08,
  5.182120160015417e-10, -1.216125819940224e-11,  2.602605846405386e-13, -5.143222896741875e-15,  9.476769282129208e-17, -1.640235065002144e-18,  5.805480068388953e-02,
 -7.543629545426414e-03,  5.301362013032276e-04, -2.647075304773746e-05,  1.047457857468955e-06, -3.482020326279772e-08,  1.008056050417629e-09, -2.603981622904188e-11,
  6.107176184954445e-13, -1.317474357282973e-14,  2.640679285405502e-16, -4.955723576180264e-18,  5.467019527931395e-02, -8.109505163396237e-03,  6.438879365448872e-04,
 -3.600827193277985e-05,  1.584377694880000e-06, -5.821169961030518e-08,  1.852951138356387e-09, -5.238991949932341e-11,  1.339482786628586e-12, -3.138804956635569e-14,
  6.811637413432770e-16, -1.379906347743706e-17,  5.131616916161678e-02, -8.585067504623782e-03,  7.628015223189735e-04, -4.739165243471227e-05,  2.302313509950310e-06,
 -9.289866539294754e-08,  3.232525000896686e-09, -9.950061054114113e-11,  2.759477149610082e-12, -6.990899403282292e-14,  1.635295930527446e-15, -3.560861589283340e-17,
  4.801894215555522e-02, -8.962797930817527e-03,  8.833759011949383e-04, -6.051392969026576e-05,  3.224204700337358e-06, -1.420172917529836e-07,  5.372195078007779e-09,
 -1.791063759998697e-10,  5.362207968128850e-12, -1.462076117489860e-13,  3.670739285805599e-15, -8.556661664935670e-17,  4.479928660389100e-02, -9.238400696573218e-03,
  1.001871796961502e-03, -7.514060603854353e-05,  4.363215595663463e-06, -2.085973239727218e-07,  8.533068729399309e-09, -3.066260277042863e-10,  9.864529451402966e-12,
 -2.882301897978257e-13,  7.734947824996357e-15, -1.922637680699134e-16,  4.167281392955359e-02, -9.410470357365162e-03,  1.114499382602436e-03, -9.091144127766771e-05,
  5.719022940042955e-06, -2.951446371677831e-07,  1.299042044959044e-08, -5.007542294061162e-10,  1.723470610087602e-11, -5.373866685546790e-13,  1.535373720114221e-14,
 -4.054125469835881e-16,  3.865041078519366e-02, -9.480085697499214e-03,  1.217593691797881e-03, -1.073522659343868e-04,  7.274869476376605e-06, -4.031660368027320e-07,
  1.900023314016789e-08, -7.821447017624856e-10,  2.867620853172293e-11, -9.503134214184107e-13,  2.879597832185363e-14, -8.047503126319113e-16,  3.573877157932938e-02,
 -9.450367854154075e-03,  1.307767348311308e-03, -1.238956894295330e-04,  8.995816042377988e-06, -5.326932608337126e-07,  2.675561134557020e-08, -1.171029775511626e-09,
  4.554715915119658e-11, -1.597951986350325e-12,  5.116141273529206e-14, -1.507873518099355e-15,  3.294097973883379e-02, -9.326034753643232e-03,  1.382033854260145e-03,
 -1.399087933470213e-04,  1.082850147783239e-05, -6.818737070924641e-07,  3.633743913861126e-08, -1.683810619653573e-09,  6.919951648793846e-11, -2.560387745669363e-12,
  8.630124829662192e-14, -2.673118443386436e-15,  3.025709789756173e-02, -9.112977141315735e-03,  1.437898242678822e-03, -1.547254166773893e-04,  1.270255563109656e-05,
 -8.466959456672847e-07,  4.766592912490990e-08, -2.328901815710539e-09,  1.007359841704499e-10, -3.916280523559472e-12,  1.384760847300848e-13, -4.492365706880623e-15,
  2.768473603805400e-02, -8.817874322088741e-03,  1.473415008634478e-03, -1.676804655405227e-04,  1.453363112418192e-05, -1.020907837808112e-06,  6.046114277038128e-08,
 -3.102374798418425e-09,  1.407030699266167e-10, -5.726703937631679e-12,  2.116835785042862e-13, -7.168668175261072e-15,  2.521957543698266e-02, -8.447860966364443e-03,
  1.487215672093216e-03, -1.781437815141064e-04,  1.622784933673100e-05, -1.196165260371966e-06,  7.422072492378458e-08, -3.984154028824801e-09,  1.887619668550617e-10,
 -8.014729228619486e-12,  3.086568750737559e-13, -1.087572665590722e-14,  2.285583433728058e-02, -8.010250468126610e-03,  1.478510010633194e-03, -1.855514181484670e-04,
  1.768731603655527e-05, -1.362422868988017e-06,  8.822178275624307e-08, -4.935614728745651e-09,  2.433991987457036e-10, -1.074385864554472e-11,  4.296389701754922e-13,
 -1.570082858363438e-14,  2.058666813534848e-02, -7.512315632885014e-03,  1.447065952326143e-03, -1.894326287771504e-04,  1.881626608093332e-05, -1.508548910306315e-06,
  1.015511314554291e-07, -5.899365786261253e-09,  3.017497553063244e-10, -1.379995681379080e-11,  5.711558971226992e-13, -2.157936840095256e-14,  1.840450232302493e-02,
 -6.961123997406551e-03,  1.393173433329556e-03, -1.894313847219517e-04,  1.952735074185045e-05, -1.623118004984247e-06,  1.131643839528530e-07, -6.801761472647049e-09,
  3.596013570048426e-10, -1.698208743827611e-11,  7.251067336546962e-13, -2.823582375127173e-14,  1.630130044860790e-02, -6.363422775190090e-03,  1.317597336432119e-03,
 -1.853217561135350e-04,  1.974758439421445e-05, -1.695312857439212e-06,  1.219701497031726e-07, -7.558294774535750e-09,  4.116271029846437e-10, -2.000716857826463e-11,
  8.785196439790761e-13, -3.515056577565761e-14,  1.426877208374417e-02, -5.725567127150191e-03,  1.221524084490150e-03, -1.770169487056804e-04,  1.942351289404638e-05,
 -1.715850850142075e-06,  1.269316023323582e-07, -8.081543818731059e-09,  4.518568181102112e-10, -2.253141476018282e-11,  1.014258668003595e-12, -4.157155386455286e-14,
  1.229852741603254e-02, -5.053484980665568e-03,  1.106505707742978e-03, -1.645721684887996e-04,  1.852524382803700e-05, -1.677846041537251e-06,  1.271745328611307e-07,
 -8.290857041017642e-09,  4.743510194129836e-10, -2.418833693038328e-11,  1.112797979430085e-12, -4.658321572030752e-14,  1.038218590978531e-02, -4.352671771266256e-03,
  9.744043600349344e-04, -1.481817685487375e-04,  1.704907746840035e-05, -1.577521486873434e-06,  1.220892468235658e-07, -8.122566782704074e-09,  4.739949576235962e-10,
 -2.463923253483635e-11,  1.154934241493463e-12, -4.923201191808793e-14,  8.511446911992928e-03, -3.628209146311233e-03,  8.273394373267782e-04, -1.281713230008002e-04,
  1.501858590856739e-05, -1.414700166690875e-06,  1.114135988464290e-07, -7.539298136713511e-09,  4.472942918092056e-10, -2.362852534779418e-11,  1.125040602032479e-12,
 -4.869205734068645e-14,  6.678131292838029e-03, -2.884803101211194e-03,  6.676388159482794e-04, -1.049853976883178e-04,  1.248409885499364e-05, -1.193023510683952e-06,
  9.528615132604032e-08, -6.536945454198254e-09,  3.930379886757300e-10, -2.103398809391301e-11,  1.014253374757462e-12, -4.443932424753582e-14,  4.874211756988432e-03,
 -2.126841897112594e-03,  4.977959843018701e-04, -7.917197132857999e-05,  9.520673712005958e-06, -9.198734373637636e-07,  7.426179363031786e-08, -5.148144116710417e-09,
  3.127040268377196e-10, -1.690159512813849e-11,  8.228972992616726e-13, -3.639455617121413e-14,  3.091931430174037e-03, -1.358511451514548e-03,  3.204429155111686e-04,
 -5.136583717906223e-05,  6.224885717379360e-06, -6.060176425763329e-07,  4.928783069675913e-08, -3.441615948193902e-09,  2.105243589825539e-10, -1.145708435469598e-11,
  5.615536052085422e-13, -2.499747740960764e-14,  1.325831491144634e-03, -5.847668954757216e-04,  1.385283733961654e-04, -2.230233029109185e-05,  2.714388331863143e-06,
 -2.653711454755998e-07,  2.167174608742461e-08, -1.519352124697221e-09,  9.330305804036039e-11, -5.097075889001102e-12,  2.507542561230211e-13, -1.120253402149578e-14,
  8.477596665003559e-02, -3.043615173920823e-04,  1.152039136995986e-06, -4.533448049573025e-09,  1.829073499209792e-11, -7.483348616425599e-14,  3.080900724735164e-16,
 -1.270209571239435e-18,  5.229138354258982e-21, -2.146162226774957e-23,  8.774469138979791e-26, -3.572426417999108e-28,  8.372967284170270e-02, -4.423006855469134e-04,
  2.724907176596997e-06, -1.676573727678445e-08,  9.982279908149456e-11, -5.752851440917660e-13,  3.225115085917213e-15, -1.766673271222406e-17,  9.488329645599438e-20,
 -5.009052133552481e-22,  2.604411929906109e-24, -1.335741059194388e-26,  8.168215820392778e-02, -7.071447941376516e-04,  6.425280445402952e-06, -5.333942839851693e-08,
  4.121958661418121e-10, -3.018270002836601e-12,  2.117560104134820e-14, -1.433971348726580e-16,  9.422454512088949e-19, -6.031582993489737e-21,  3.772989572959026e-23,
 -2.311982524055632e-25,  7.871995683675057e-02, -1.078047915560264e-03,  1.323392145238644e-05, -1.410106176518517e-07,  1.365229122127520e-09, -1.230824469375044e-11,
  1.048689394920153e-13, -8.528658363420087e-16,  6.668032560330103e-18, -5.038701187227737e-20,  3.695204865847099e-22, -2.638530334372771e-24,  7.496428083467098e-02,
 -1.526614047693639e-03,  2.432897005638154e-05, -3.246951287157377e-07,  3.851722562893958e-09, -4.186228236436959e-11,  4.246266370970970e-13, -4.069970322924417e-15,
  3.718860345587120e-17, -3.260760579161076e-19,  2.757520902448308e-21, -2.258004023151140e-23,  7.056187320480357e-02, -2.019866495338738e-03,  4.080646638361783e-05,
 -6.694463822338256e-07,  9.564296030802119e-09, -1.233507331925624e-10,  1.467850115781247e-12, -1.635345324552941e-14,  1.723543449964645e-16, -1.731651025923881e-18,
  1.668371498045731e-20, -1.548516919678902e-22,  6.567453911822498e-02, -2.523508254518697e-03,  6.340882826178708e-05, -1.258436104262847e-06,  2.135097749398274e-08,
 -3.226323087428744e-10,  4.451479531749674e-12, -5.701585338100918e-14,  6.859236736803605e-16, -7.818523737088742e-18,  8.500552662247553e-20, -8.861254992600963e-22,
  6.046847080365801e-02, -3.005046109681454e-03,  9.231546920867782e-05, -2.185516777192113e-06,  4.350614647506659e-08, -7.619973185502834e-10,  1.206989907211247e-11,
 -1.760941707770617e-13,  2.397214225892964e-15, -3.074442085967432e-17,  3.742255020486110e-19, -4.348024515033973e-21,  5.510439447119930e-02, -3.436411300422930e-03,
  1.270335992181931e-04, -3.542612788616190e-06,  8.186146447784695e-08, -1.646127830573660e-09,  2.967551125783391e-11, -4.892047231612705e-13,  7.479047673451701e-15,
 -1.071517049954363e-16,  1.450225195399544e-18, -1.865727384091499e-20,  4.972935169280077e-02, -3.795822102407933e-03,  1.664042815696647e-04, -5.403900797790392e-06,
  1.435494696240438e-07, -3.285748844528453e-09,  6.689030990894442e-11, -1.237005490249428e-12,  2.109526084376354e-14, -3.354711752044381e-16,  5.017852164676607e-18,
 -7.106446701584181e-20,  4.447063287414914e-02, -4.068771727589131e-03,  2.087150419213205e-04, -7.809925356483170e-06,  2.363707148263497e-07, -6.110055124480493e-09,
  1.394635052112747e-10, -2.874213094072546e-12,  5.433911228176115e-14, -9.536198365486082e-16,  1.567707504856462e-17, -2.431235997824095e-19,  3.943206365346673e-02,
 -4.248160469459540e-03,  2.518911993825134e-04, -1.075508802504098e-05,  3.677927857621247e-07, -1.065820443366754e-08,  2.709559572414696e-10, -6.185115727889377e-12,
  1.288966637683333e-13, -2.482914736782312e-15,  4.463379302022940e-17, -7.542898771797572e-19,  3.469255747807776e-02, -4.333700903281896e-03,  2.937271611755661e-04,
 -1.418129529775505e-05,  5.437173419266359e-07, -1.754258122259899e-08,  4.936260288759199e-10, -1.240918054022589e-11,  2.835386067172466e-13, -5.964895520677999e-15,
  1.166930721782197e-16, -2.139220576246346e-18,  3.030662599262885e-02, -4.330795197721972e-03,  3.321172297033725e-04, -1.797919714471493e-05,  7.672339204144916e-07,
 -2.738217711651864e-08,  8.478162239734851e-10, -2.334439037057610e-11,  5.818714016034056e-13, -1.330514559541831e-14,  2.819962960458748e-16, -5.583709780352819e-18,
  2.630640146640849e-02, -4.249110467362534e-03,  3.652517343696415e-04, -2.199681937942435e-05,  1.037608483439167e-06, -4.071201993054558e-08,  1.379278651812760e-09,
 -4.138295486495963e-11,  1.119811521886660e-12, -2.770560344750260e-14,  6.334404723626040e-16, -1.349195465580669e-17,  2.270467272753153e-02, -4.101066689717011e-03,
  3.917557040120136e-04, -2.605393874230631e-05,  1.349720290076707e-06, -5.788188963285271e-08,  2.134248201505226e-09, -6.943091304735898e-11,  2.030234083344778e-12,
 -5.411371282871453e-14,  1.329132176720009e-15, -3.033326313813335e-17,  1.949845477592832e-02, -3.900412856427332e-03,  4.107604986131794e-04, -2.995960551129288e-05,
  1.694072971139552e-06, -7.896224134014955e-08,  3.152606006144106e-09, -1.106751902840138e-10,  3.481601046745037e-12, -9.955319720127594e-14,  2.616434372341323e-15,
 -6.373737280680755e-17,  1.667268146735046e-02, -3.661013702651164e-03,  4.219108653204521e-04, -3.352993145277514e-05,  2.057390529364251e-06, -1.036757237434852e-07,
  4.460029670611286e-09, -1.681897094254697e-10,  5.667536947487040e-12, -1.731491175014871e-13,  4.850573657301392e-15, -1.256642593320573e-16,  1.420370746780339e-02,
 -3.395913584357665e-03,  4.253187858943814e-04, -3.660358571908198e-05,  2.423697772675568e-06, -1.313686739611605e-07,  6.060432554249226e-09, -2.444110634920090e-10,
  8.785567654047589e-12, -2.856476670910025e-13,  8.497508830454438e-15, -2.332854125853519e-16,  1.206240964926040e-02, -3.116694900229481e-03,  4.214804091175639e-04,
 -3.905319402701487e-05,  2.775704019483717e-06, -1.610295892040103e-07,  7.930119174198626e-09, -3.405539639052108e-10,  1.300550512961353e-11, -4.482830791290943e-13,
  1.410946790694706e-14, -4.090369878247779e-16,  1.021677395916581e-02, -2.833111159473473e-03,  4.111734950237799e-04, -4.079177424497948e-05,  3.096273580884088e-06,
 -1.913528350950809e-07,  1.001487766949485e-08, -4.560653725760925e-10,  1.843078538030789e-11, -6.709672925749708e-13,  2.226385359474258e-14, -6.792313392388217e-16,
  8.633932267444999e-03, -2.552951098021839e-03,  3.953509974246603e-04, -4.177423748633699e-05,  3.369777497763829e-06, -2.208379603126111e-07,  1.223074199357208e-08,
 -5.882244947315198e-10,  2.505869242248275e-11, -9.599545045787990e-13,  3.346289166479091e-14, -1.070735721996907e-15,  7.281670970104108e-03, -2.282079155748954e-03,
  3.750428269839345e-04, -4.199467721944839e-05,  3.583167980080007e-06, -2.479096782791701e-07,  1.446851293980093e-08, -7.319799626888819e-10,  3.274702085700815e-11,
 -1.315319960346916e-12,  4.800177061423079e-14, -1.605597148855785e-15,  6.129469577160158e-03, -2.024596537750951e-03,  3.512735843622156e-04, -4.148058393075688e-05,
  3.726683528266194e-06, -2.710416876681089e-07,  1.660148816318115e-08, -8.800788068834441e-10,  4.119476292221058e-11, -1.728735017788753e-12,  6.582477133063074e-14,
 -2.294078620474263e-15,  5.149146130565821e-03, -1.783072772666059e-03,  3.250000050065808e-04, -4.028526066762094e-05,  3.794161798044265e-06, -2.888689152313675e-07,
  1.849535985566332e-08, -1.023493067347380e-09,  4.994270265039182e-11, -2.182068705184976e-12,  8.639856321936322e-14, -3.127242866083386e-15,  4.315191297338145e-03,
 -1.558807071632805e-03,  2.970685614564216e-04, -3.847962965162609e-05,  3.782995501047417e-06, -3.002766230416153e-07,  2.001898311805822e-08, -1.152100642739854e-09,
  5.839669090364580e-11, -2.647272594737101e-12,  1.086359476845638e-13, -4.070769570950609e-15,  3.604868725448158e-03, -1.352089391080024e-03,  2.681913607327535e-04,
 -3.614439128062536e-05,  3.693806307122595e-06, -3.044599131354539e-07,  2.105471787529251e-08, -1.255537806310957e-09,  6.587255943408436e-11, -3.087816728963381e-12,
  1.308995452715433e-13, -5.061903622789922e-15,  2.998149574824959e-03, -1.162441176672095e-03,  2.389371472932269e-04, -3.336320410366631e-05,  3.529930865483904e-06,
 -3.009522851052014e-07,  2.150726092066098e-08, -1.324118703858467e-09,  7.165795465052025e-11, -3.461677261911965e-12,  1.511030289433670e-13, -6.011155774693795e-15,
  2.477537042568003e-03, -9.888243103153040e-04,  2.097337195901136e-04, -3.021726250627873e-05,  3.296814143424118e-06, -2.896261392126608e-07,  2.131023264736956e-08,
 -1.349714190742324e-09,  7.508358166594533e-11, -3.725589585843148e-12,  1.669096026621039e-13, -6.809595910087091e-15,  2.027824290054857e-03, -8.298133856431565e-04,
  1.808781674983534e-04, -2.678140061975196e-05,  3.001393261647011e-06, -2.706709580186274e-07,  2.043017463860558e-08, -1.326496167561555e-09,  7.559491967286982e-11,
 -3.840035860138114e-12,  1.760073941109054e-13, -7.341429902587208e-15,  1.635817751530697e-03, -6.837311046586391e-04,  1.525518125131242e-04, -2.312166728312776e-05,
  2.651535564441557e-06, -2.445562287884543e-07,  1.886797113432226e-08, -1.251478736298765e-09,  7.281552509820023e-11, -3.774282452396854e-12,  1.764238565963596e-13,
 -7.500295931810216e-15,  1.290048048623444e-03, -5.487495782711670e-04,  1.248373925963308e-04, -1.929420147144311e-05,  2.255572897303391e-06, -2.119861753659136e-07,
  1.665797734326760e-08, -1.124817553805475e-09,  6.659439039287502e-11, -3.510747286404526e-12,  1.668302116936310e-13, -7.206670546606841e-15,  9.804830028450795e-04,
 -4.229620429943491e-04,  9.773675036708783e-05, -1.534518444211065e-05,  1.821953945110652e-06, -1.738524305167082e-07,  1.386530010170820e-08, -9.498579919603883e-10,
  5.703208586417191e-11, -3.048060396656401e-12,  1.467849606991424e-13, -6.423219671463789e-15,  6.982523515772190e-04, -3.044307423755934e-04,  7.118805870739718e-05,
 -1.131165481269418e-05,  1.359022002724051e-06, -1.311894770643057e-07,  1.058174946262932e-08, -7.329480277290140e-10,  4.448317266779976e-11, -2.402365074700521e-12,
  1.168732243059207e-13, -5.165039910606128e-15,  4.354006883178689e-04, -1.912218524159857e-04,  4.508336409553701e-05, -7.223185094923778e-06,  8.749363841822197e-07,
 -8.513822683309684e-08,  6.921135773494484e-09, -4.830618117425337e-10,  2.953586146181832e-11, -1.606692296607349e-12,  7.871642986615093e-14, -3.502600622382039e-15,
  1.849213935200163e-04, -8.154378031263597e-05,  1.931272848955686e-05, -3.108493043257247e-06,  3.782393086157496e-07, -3.696957567644187e-08,  3.018437145884369e-09,
 -2.115658929252040e-10,  1.298923743516485e-11, -7.094324141053824e-13,  3.489329464998111e-14, -1.558531292916020e-15,  8.357661554149970e-02, -2.953579459180205e-04,
  1.099345549990698e-06, -4.252379659150294e-09,  1.686522082941216e-11, -6.784789669701864e-14,  2.747553653841889e-16, -1.114591213667422e-18,  4.516086508381801e-21,
 -1.824678683084065e-23,  7.345369960955962e-26, -2.945025037215816e-28,  8.200283163082030e-02, -4.212798796429675e-04,  2.532934807538997e-06, -1.525657478557783e-08,
  8.905276067298428e-11, -5.034912769386524e-13,  2.770380346662569e-15, -1.489997743572507e-17,  7.859250343795275e-20, -4.075869863785930e-22,  2.082316985923028e-24,
 -1.049593245991300e-26,  7.895248217055331e-02, -6.581951407698640e-04,  5.822871907415826e-06, -4.720091106992691e-08,  3.566041793216395e-10, -2.555020548293754e-12,
  1.755193122554751e-14, -1.164469794078485e-16,  7.499905605384385e-19, -4.707629351123138e-21,  2.888604486331461e-23, -1.736815459746948e-25,  7.460929176509158e-02,
 -9.785915699691682e-04,  1.166515437580707e-05, -1.210072277452183e-07,  1.142416327904741e-09, -1.005542089316917e-11,  8.372237581080023e-14, -6.658714536563296e-16,
  5.094380213076683e-18, -3.768991744891340e-20,  2.707428677189234e-22, -1.894388526084487e-24,  6.922381081269020e-02, -1.346580201113985e-03,  2.077645806158734e-05,
 -2.692482783282670e-07,  3.107808193453722e-09, -3.291441007066671e-11,  3.257044601139269e-13, -3.048268217421302e-15,  2.721716783711948e-17, -2.333461656590692e-19,
  1.930592553457253e-21, -1.547394017790766e-23,  6.308787302916444e-02, -1.723122489406424e-03,  3.361567101341333e-05, -5.343848536435949e-07,  7.415468054942710e-09,
 -9.304716376425038e-11,  1.078642958550185e-12, -1.171898522606932e-14,  1.205485814198759e-16, -1.182986367574582e-18,  1.113962272967314e-20, -1.011114032801646e-22,
  5.650700285199356e-02, -2.071290308193652e-03,  5.016177206981429e-05, -9.631381863600214e-07,  1.584916910529116e-08, -2.327121984199905e-10,  3.124286890208547e-12,
 -3.898287660838102e-14,  4.573000434669193e-16, -5.086903607237201e-18,  5.401198880623216e-20, -5.502118618084060e-22,  4.977453328066468e-02, -2.360657201328453e-03,
  6.980969116170896e-05, -1.597131471271174e-06,  3.080440205921409e-08, -5.237470122534729e-10,  8.065440887826965e-12, -1.145399762428370e-13,  1.519335717666757e-15,
 -1.900347185602391e-17,  2.257652117555067e-19, -2.561973634945096e-21,  4.315047493133738e-02, -2.570193598598279e-03,  9.140820517690772e-05, -2.461725624950044e-06,
  5.507749694063462e-08, -1.074444590333742e-09,  1.881987842808489e-11, -3.018295105806696e-13,  4.494067127788653e-15, -6.276550344079912e-17,  8.287883433523488e-19,
 -1.041032372991062e-20,  3.684702234687917e-02, -2.689410625961504e-03,  1.134230116591622e-04, -3.556138475270592e-06,  9.143410931803102e-08, -2.029646685729166e-09,
  4.013363112684627e-11, -7.218420923391957e-13,  1.198572321479131e-14, -1.857650889272676e-16,  2.710367275940087e-18, -3.747143196598057e-20,  3.102129240311897e-02,
 -2.717863505051693e-03,  1.341769216351174e-04, -4.847937276696013e-06,  1.420172567282977e-07, -3.560037956202255e-09,  7.892351098522126e-11, -1.581862978112765e-12,
  2.911758062563250e-14, -4.980110537338519e-16,  7.986011315927157e-18, -1.209034724456962e-19,  2.577473948970596e-02, -2.663402006887060e-03,  1.521055662395293e-04,
 -6.273834763522076e-06,  2.077288122736582e-07, -5.839080155151597e-09,  1.442062023819464e-10, -3.201977079041926e-12,  6.498059789054845e-14, -1.220125261995927e-15,
  2.139882779959507e-17, -3.531004540017432e-19,  2.115787482668878e-02, -2.539696937170328e-03,  1.659721024587290e-04, -7.746889469829462e-06,  2.877528614422627e-07,
 -9.010016030896593e-09,  2.464045270374832e-10, -6.027780921222975e-12,  1.341738122259870e-13, -2.752475767435533e-15,  5.255468252466919e-17, -9.410612425492696e-19,
  1.717851079442091e-02, -2.363576602792989e-03,  1.750031619691447e-04, -9.168423191245314e-06,  3.793664669549956e-07, -1.314946380427613e-08,  3.959605469489296e-10,
 -1.061613811784316e-11,  2.579334012171812e-13, -5.754537445506009e-15,  1.191016818929774e-16, -2.304767782760340e-18,  1.381172824890391e-02, -2.152607800371669e-03,
  1.789326941038221e-04, -1.044183167320674e-05,  4.781096438686534e-07, -1.823657875584580e-08,  6.014007716741535e-10, -1.758417479333001e-11,  4.641700957176417e-13,
 -1.121322552695979e-14,  2.505311598327046e-16, -5.218696045032294e-18,  1.101002668810921e-02, -1.923200800705087e-03,  1.779626152362786e-04, -1.148526351419717e-05,
  5.782890685803528e-07, -2.413639121695579e-08,  8.672164719375681e-10, -2.752045074664741e-11,  7.857578795711001e-13, -2.046777050573307e-14,  4.916992081086128e-16,
 -1.098361963130919e-17,  8.712536075412107e-03, -1.689355126187504e-03,  1.726640852793358e-04, -1.224079055029923e-05,  6.737040496519394e-07, -3.060269582574884e-08,
  1.192053245748032e-09, -4.086921515288977e-11,  1.256720727367223e-12, -3.515507399107041e-14,  9.045770971074422e-16, -2.158964636733302e-17,  6.852625453196752e-03,
 -1.462028016635769e-03,  1.638490267894639e-04, -1.267884294491450e-05,  7.584357257252178e-07, -3.730087997277109e-08,  1.567687345230185e-09, -5.780970005961847e-11,
  1.906516929785988e-12, -5.704890014657778e-14,  1.566428973998508e-15, -3.980302426538160e-17,  5.363648936700774e-03, -1.249018310191878e-03,  1.524393709140593e-04,
 -1.279790639143514e-05,  8.275413207768694e-07, -4.384607948260533e-08,  1.979097940743339e-09, -7.815807766780965e-11,  2.753264908064651e-12, -8.778988375234949e-14,
  2.562885463097774e-15, -6.909179168111787e-17,  4.182875432056366e-03, -1.055217037865110e-03,  1.393543332801654e-04, -1.262043257728709e-05,  8.775367419427272e-07,
 -4.984863811567442e-08,  2.405679665041822e-09, -1.013173327619171e-10,  3.797259680073882e-12, -1.285360311258283e-13,  3.975372110699697e-15, -1.133135349784769e-16,
  3.253841119843752e-03, -8.830735255183021e-04,  1.254270037600737e-04, -1.218642263789906e-05,  9.066136432996473e-07, -5.495788688770817e-08,  2.823367237754512e-09,
 -1.262902332566716e-10,  5.016289502486042e-12, -1.795947443982830e-13,  5.863912657487347e-15, -1.761310968762310e-16,  2.527455027704717e-03, -7.331485756904444e-04,
  1.113532449042910e-04, -1.154620519141634e-05,  9.145998940002647e-07, -5.889667567273830e-08,  3.207248249947773e-09, -1.517560385021858e-10,  6.363990016141215e-12,
 -2.401157097351108e-13,  8.248015696947710e-15, -2.601949305763876e-16,  1.962202591165831e-03, -6.046608057447689e-04,  9.766982132053669e-05, -1.075366309698632e-05,
  9.027190965227234e-07, -6.148207990819471e-08,  3.534170414926987e-09, -1.761972267095947e-10,  7.771839082278363e-12, -3.079213013825522e-13,  1.108958016398245e-14,
 -3.662150941615390e-16,  1.523757805717203e-03, -4.959679085651906e-04,  8.475526113901677e-05, -9.860729649314152e-06,  8.732281511423110e-07, -6.263116786283506e-08,
  3.784907569288347e-09, -1.980525579479663e-10,  9.154597021758945e-12, -3.795268084716437e-13,  1.428202479905534e-14, -4.921134889718272e-16,  1.184255899752372e-03,
 -4.049549708733184e-04,  7.284586587641401e-05, -8.913523953512221e-06,  8.290129404857414e-07, -6.235367572687231e-08,  3.945597310854817e-09, -2.158695184452177e-10,
  1.041827589855383e-11, -4.503637401095622e-13,  1.764897205158963e-14, -6.324712466677919e-16,  9.214135405221143e-04, -3.293242148474370e-04,  6.205984726235612e-05,
 -7.950126536967892e-06,  7.732074447375488e-07, -6.073531743796762e-08,  4.008346926343903e-09, -2.284325296354040e-10,  1.146927206681464e-11, -5.151773455234536e-13,
  2.095400242737913e-14, -7.784532878755720e-16,  7.176237636572089e-04, -2.667944708986636e-04,  5.242402868596362e-05, -6.999754118759021e-06,  7.088791903163174e-07,
 -5.791611967494893e-08,  3.971071123744513e-09, -2.348512680610532e-10,  1.222320503164441e-11, -5.685360743575325e-13,  2.392075442654728e-14, -9.183070338112563e-16,
  5.591037103512389e-04, -2.152257120078750e-04,  4.389928676746659e-05, -6.082976573176003e-06,  6.388010505867886e-07, -5.406783032595657e-08,  3.836740923138379e-09,
 -2.346031873504341e-10,  1.261224165367849e-11, -6.053738626720193e-13,  2.626059910948811e-14, -1.038417241595387e-15,  4.351364170862571e-04, -1.726860241200443e-04,
  3.640251536948377e-05, -5.212602769623691e-06,  5.653107568353899e-07, -4.937348453202587e-08,  3.612276171371304e-09, -2.275332185239422e-10,  1.259013217227192e-11,
 -6.214878381745721e-13,  2.770377493846321e-14, -1.124784874262142e-15,  3.374224370666173e-04, -1.374773424505739e-04,  2.982416205726874e-05, -4.394909118946732e-06,
  4.902470765817549e-07, -4.401102289524033e-08,  3.307311435409903e-09, -2.138199053106292e-10,  1.213469669136422e-11, -6.139308263202300e-13,  2.802947390203402e-14,
 -1.164713483967804e-15,  2.595409238655796e-04, -1.081336711921929e-04,  2.404126037416970e-05, -3.630961897954514e-06,  4.149454281208156e-07, -3.814174814310983e-08,
  2.933024052837475e-09, -1.939202725934478e-10,  1.124794934546339e-11, -5.812631613422678e-13,  2.709087610312210e-14, -1.148449434868907e-15,  1.965106221780503e-04,
 -8.340238509225561e-05,  1.892639894193149e-05, -2.917866980596821e-06,  3.402744660436671e-07, -3.190355706884113e-08,  2.501154001303520e-09, -1.685058242343966e-10,
  9.954352385839468e-12, -5.236544318253214e-13,  2.483226764747914e-14, -1.070535476501415e-15,  1.444368387610184e-04, -6.221623284139526e-05,  1.435331335840482e-05,
 -2.249853817951319e-06,  2.666972332370261e-07, -2.540835487518704e-08,  2.023285101558974e-09, -1.384000796146477e-10,  8.297829847955236e-12, -4.428472078381609e-13,
  2.129678397474652e-14, -9.306911543714204e-16,  1.002292703637742e-04, -4.366119564382847e-05,  1.019986115056888e-05, -1.619159876652065e-06,  1.943444964357966e-07,
 -1.874284670964070e-08,  1.510408755596241e-09, -1.045251190977502e-10,  6.338167827051058e-12, -3.420088602377971e-13,  1.662468494326832e-14, -7.341124150182415e-16,
  6.137750827243897e-05, -2.694406533765071e-05,  6.349254993210711e-06, -1.016748014758742e-06,  1.230952783412779e-07, -1.197219104170944e-08,  9.727806319790817e-10,
 -6.786304858640404e-11,  4.147420458783423e-12, -2.255088100713773e-13,  1.104340774917132e-14, -4.911795224532868e-16,  2.580551991474213e-05, -1.137685226334300e-05,
  2.693815933445570e-06, -4.334760127641491e-07,  5.273185349255724e-08, -5.152798795992572e-09,  4.206052270370229e-10, -2.947362829240988e-11,  1.809125458099268e-12,
 -9.878586783479757e-14,  4.857649831985040e-15, -2.169212693821592e-16,  8.241245644892034e-02, -2.867628092542572e-04,  1.049892407933299e-06, -3.993043833043532e-09,
  1.557175818313849e-11, -6.161252770382345e-14,  2.454751673729573e-16, -9.800439184348545e-19,  3.909111022428615e-21, -1.555202056504999e-23,  6.165591467862493e-26,
 -2.434863203238807e-28,  8.035711278547980e-02, -4.017252369415920e-04,  2.358083997342604e-06, -1.390881354618088e-08,  7.961544649532891e-11, -4.417373553609618e-13,
  2.386294146985064e-15, -1.260457296415555e-17,  6.531372685527313e-20, -3.328377145052253e-22,  1.671260101598436e-24, -8.281135234008392e-27,  7.640941228532638e-02,
 -6.137845531487127e-04,  5.289079885798817e-06, -4.188222148405273e-08,  3.094655093028148e-10, -2.170337394648537e-12,  1.460344126764009e-14, -9.494999990513548e-17,
  5.995962896658721e-19, -3.691580908255344e-21,  2.222559923648429e-23, -1.311613417306267e-25,  7.087279079937685e-02, -8.907825497764105e-04,  1.031644011942375e-05,
 -1.042342828927802e-07,  9.599812271070766e-10, -8.252578237635341e-12,  6.717028806397638e-14, -5.226232647588777e-16,  3.913943434969874e-18, -2.835935566109099e-20,
  1.996043672531406e-22, -1.368976028891333e-24,  6.415058121435821e-02, -1.192494537899598e-03,  1.782340533722876e-05, -2.243922775250110e-07,  2.521253125986677e-09,
 -2.603056422861521e-11,  2.513823905198979e-13, -2.298058477345954e-15,  2.005698102112574e-17, -1.681933988002092e-19,  1.361821036027370e-21, -1.068711489316565e-23,
  5.669529250398277e-02, -1.477963404086541e-03,  2.785779576538825e-05, -4.293225582658001e-07,  5.788916799075824e-09, -7.069788676550846e-11,  7.986809927631603e-13,
 -8.464838210966124e-15,  8.501402760301620e-17, -8.151193581941883e-19,  7.504081424779921e-21, -6.662775464057605e-23,  4.895688242720538e-02, -1.712244772930820e-03,
  3.998429414817439e-05, -7.430547586136242e-07,  1.186421954906877e-08, -1.693293592471934e-10,  2.212825855368231e-12, -2.690551005621141e-14,  3.078558187910612e-16,
 -3.342932564246957e-18,  3.467344468217012e-20, -3.452559399469052e-22,  4.133833676399214e-02, -1.871195988883766e-03,  5.328697351474152e-05, -1.178542328286068e-06,
  2.203131238921279e-08, -3.637428180871133e-10,  5.447393177006286e-12, -7.532328939911161e-14,  9.738180289119690e-16, -1.188194443136665e-17,  1.378077186861499e-19,
 -1.527740716480141e-21,  3.416432200777484e-02, -1.943596586504769e-03,  6.651809760662714e-05, -1.730461393756084e-06,  3.749671893347998e-08, -7.098111386922449e-10,
  1.208321020664187e-11, -1.885743618203338e-13,  2.735143629829163e-15, -3.724623675177453e-17,  4.799305006665838e-19, -5.886931366145891e-21,  2.766531497020215e-02,
 -1.930627356973080e-03,  7.833992360343739e-05, -2.371766511142975e-06,  5.903636446150314e-08, -1.271142101490667e-09,  2.441865904913937e-11, -4.272263461229310e-13,
  6.908156050909925e-15, -1.043664391552877e-16,  1.485565015174736e-18, -2.005222720463562e-20,  2.197638568200000e-02, -1.843330792919378e-03,  8.758206855279224e-05,
 -3.055708433888671e-06,  8.665159702811216e-08, -2.106685071227306e-09,  4.536657865043868e-11, -8.844024800693598e-13,  1.585165909142435e-14, -2.642545584913266e-16,
  4.133853343611280e-18, -6.110098184123533e-20,  1.714744837870377e-02, -1.698988808141665e-03,  9.344270813469406e-05, -3.723104374524534e-06,  1.193560573213892e-07,
 -3.254380444128425e-09,  7.808109445217425e-11, -1.686475825810358e-12,  3.332976344527540e-14, -6.100534318376902e-16,  1.043879062603873e-17, -1.681913871563974e-19,
  1.316063828406184e-02, -1.517362842546022e-03,  9.558982476418059e-05, -4.312834946430925e-06,  1.551845526594184e-07, -4.715304976841484e-09,  1.253222044076757e-10,
 -2.983191201960065e-12,  6.468676383391326e-14, -1.293958217085783e-15,  2.411227662186435e-17, -4.217204769000962e-19,  9.950466082155652e-03, -1.317521784956197e-03,
  9.415463793573849e-05, -4.772590578421530e-06,  1.914439031729073e-07, -6.443620499002460e-09,  1.886790128096165e-10, -4.925132883246749e-12,  1.166287609520409e-13,
 -2.538468350798443e-15,  5.130006635632518e-17, -9.700923964463031e-19,  7.423222439128991e-03, -1.115656069554010e-03,  8.963950333514380e-05, -5.067084248938166e-06,
  2.251450804943382e-07, -8.346367457149595e-09,  2.678632473666397e-10, -7.630827163023459e-12,  1.964610743532894e-13, -4.633222781896267e-15,  1.011424303528500e-16,
 -2.060123520174249e-18,  5.473323782943301e-03, -9.239579434789087e-04,  8.277884903300261e-05, -5.182038297983635e-06,  2.534999953071621e-07, -1.029416038025574e-08,
  3.603040659206694e-10, -1.115057205989749e-11,  3.107834004288506e-13, -7.909585139905370e-15,  1.858014783006380e-16, -4.061553964383710e-18,  3.995523729359022e-03,
 -7.504149238840616e-04,  7.439301623343767e-05, -5.123682661632803e-06,  2.743550492002802e-07, -1.214038139085628e-08,  4.612047059268353e-10, -1.543708065736418e-11,
  4.638537017219187e-13, -1.269025028584047e-14,  3.195976895450142e-16, -7.471314460962640e-18,  2.892906866994350e-03, -5.992432900312650e-04,  6.526531199935085e-05,
 -4.914710273108519e-06,  2.864655413993387e-07, -1.374394541900436e-08,  5.640855503181427e-10, -2.033252061239434e-11,  6.560114564798894e-13, -1.921950662390341e-14,
  5.170670086754096e-16, -1.288235676195759e-17,  2.081225001975192e-03, -4.716688191327541e-04,  5.605836507214175e-05, -4.588286470725462e-06,  2.895716708996121e-07,
 -1.499001631062897e-08,  6.616914405370756e-10, -2.557737953292380e-11,  8.826132659971347e-13, -2.758840897632926e-14,  7.900727316073896e-16, -2.090760290672166e-17,
  1.490440223478400e-03, -3.668093526732614e-04,  4.727247801411413e-05, -4.181755185516546e-06,  2.842941267537444e-07, -1.580421230009961e-08,  7.470405505785295e-10,
 -3.084031470342423e-11,  1.133836448176613e-12, -3.767417257052114e-14,  1.144481598139697e-15, -3.206193721867866e-17,  1.064382644707148e-03, -2.824911143135748e-04,
  3.923932713403375e-05, -3.731293065743942e-06,  2.719066036312318e-07, -1.615815218023260e-08,  8.143704086107494e-10, -3.576219151288491e-11,  1.395477194551866e-12,
 -4.911189007745657e-14,  1.577187598418740e-15, -4.662069238802706e-17,  7.593134411865032e-04, -2.159088876589605e-04,  3.213992469886845e-05, -3.268184898459954e-06,
  2.540566827551845e-07, -1.606667591640842e-08,  8.597909146424507e-10, -4.000402600946293e-11,  1.650594731958459e-12, -6.130910796036888e-14,  2.074308024640829e-15,
 -6.448582396298032e-17,  5.419953725184018e-04, -1.641023188417500e-04,  2.603539157623784e-05, -2.816849584215895e-06,  2.324985496318646e-07, -1.557891501780057e-08,
  8.815537945596181e-10, -4.328846857083784e-11,  1.881632762277044e-12, -7.350251364845016e-14,  2.611142781330189e-15, -8.509517192220381e-17,  3.876771325713534e-04,
 -1.242609878155026e-04,  2.090122636702399e-05, -2.394364094756508e-06,  2.088800967623808e-07, -1.476621001075219e-08,  8.799525512572049e-10, -4.542732976000197e-11,
  2.072554991314832e-12, -8.484507397157313e-14,  3.154052895216351e-15, -1.074031983714130e-16,  2.782307252878426e-04, -9.389122893881753e-05,  1.665886360956336e-05,
 -2.011046409147325e-06,  1.846029820078081e-07, -1.370973451213349e-08,  8.569443849377509e-10, -4.633203352844370e-11,  2.210577801775208e-12, -9.450508865580526e-14,
  3.663930844446308e-15, -1.299452077316122e-16,  2.005564886410342e-04, -7.088326037527504e-05,  1.320129171840817e-05, -1.671634429894726e-06,  1.607543660634595e-07,
 -1.248992239161470e-08,  8.156210351313553e-10, -4.600816715614730e-11,  2.287233084162726e-12, -1.017575488594240e-13,  4.100566785603855e-15, -1.509768448923179e-16,
  1.452879461401947e-04, -5.351388457571320e-05,  1.041178162749591e-05, -1.376675151686139e-06,  1.380966311164072e-07, -1.117880999140067e-08,  7.596516034335034e-10,
 -4.453830224113409e-11,  2.298683793594994e-12, -1.060524014017632e-13,  4.427066286382973e-15, -1.686633524331375e-16,  1.057807428228922e-04, -4.041268845709056e-05,
  8.176214709069427e-06, -1.123857052690507e-06,  1.170963964651978e-07, -9.835519180626664e-09,  6.927904495720909e-10, -4.205852914527387e-11,  2.245382331630766e-12,
 -1.070516486421472e-13,  4.613561929246736e-15, -1.812837441508949e-16,  7.734680996336304e-05, -3.051154789637640e-05,  6.390203713009789e-06, -9.091357646770875e-07,
  9.797470865469223e-08, -8.504491183977057e-09,  6.185032729097697e-10, -3.873386843754889e-11,  2.131268699846004e-12, -1.046349940413379e-13,  4.639718982730007e-15,
 -1.874154571996226e-16,  5.668767768668826e-05, -2.299009298224921e-05,  4.962386436290008e-06, -7.275955910620557e-07,  8.076396068634946e-08, -7.215770120550533e-09,
  5.397274251902927e-10, -3.473645697373138e-11,  1.962741639358170e-12, -9.887983731576112e-14,  4.495860330796974e-15, -1.860735056182375e-16,  4.148259445481401e-05,
 -1.722430191228280e-05,  3.815153746839185e-06, -5.740506074291990e-07,  6.536179838345061e-08, -5.986574488093378e-09,  4.587556222460343e-10, -3.022878224843088e-11,
  1.747614336315660e-12, -9.002476256399631e-14,  4.182828747778248e-15, -1.767908643512394e-16,  3.009306326429285e-05, -1.274159351450476e-05,  2.883819513490904e-06,
 -4.434220387179053e-07,  5.157662980896139e-08, -4.823494383837467e-09,  3.772174412057887e-10, -2.535274723927022e-11,  1.494210425319250e-12, -7.842624525472725e-14,
  3.710901061346737e-15, -1.596395757235297e-16,  2.135264434642655e-05, -9.183400383567629e-06,  2.114959192575401e-06, -3.309408013341131e-07,  3.916271034237136e-08,
 -3.724825954450069e-09,  2.961286391710378e-10, -2.022426231062576e-11,  1.210689970243210e-12, -6.451684313501612e-14,  3.098148664362430e-15, -1.352017489378944e-16,
  1.441782890926991e-05, -6.274860330983336e-06,  1.464396241391474e-06, -2.322236876444490e-07,  2.784503054232501e-08, -2.682742483177480e-09,  2.159813810708761e-10,
 -1.493246877258274e-11,  9.046374127318120e-13, -4.877065843461858e-14,  2.368620540450988e-15, -1.045048849209416e-16,  8.661910968854210e-06, -3.800693741733106e-06,
  8.951422739147058e-07, -1.432680802008802e-07,  1.733591345014288e-08, -1.685203260695342e-09,  1.368584433564462e-10, -9.542738111298343e-12,  5.829155461445312e-13,
 -3.167991062220324e-14,  1.550676652535247e-15, -6.893843435274291e-17,  3.603074074987552e-06, -1.588125813360529e-06,  3.759409684577424e-07, -6.047886157225791e-08,
  7.355272134589638e-09, -7.185504820622218e-10,  5.863794175103825e-11, -4.107989364628836e-12,  2.520912728301977e-13, -1.376192344769571e-14,  6.765618136742908e-16,
 -3.020524903718157e-17,  8.128190587774700e-02, -2.785511921932380e-04,  1.003431118446347e-06, -3.753442689096751e-09,  1.439626984817763e-11, -5.603678390722490e-14,
  2.197043278886071e-16, -8.634545193013978e-19,  3.391166843029955e-21, -1.328719008935073e-23,  5.188846079929235e-26, -2.018758369288249e-28,  7.878691382369132e-02,
 -3.835071844146816e-04,  2.198539532761867e-06, -1.270264853542636e-08,  7.132599803767370e-11, -3.884758851810411e-13,  2.060913356347604e-15, -1.069402597014206e-17,
  5.445202097142610e-20, -2.727365544236436e-22,  1.346323531944394e-24, -6.559550670993980e-27,  7.403583093802941e-02, -5.734012656020878e-04,  4.814828799886307e-06,
 -3.725985086212671e-08,  2.693589463549608e-10, -1.849706794419011e-12,  1.219464251026803e-14, -7.772836475483709e-17,  4.814031191329288e-19, -2.907996632425425e-21,
  1.718347226505472e-23, -9.955596000700463e-26,  6.746715461921339e-02, -8.130051580658407e-04,  9.152610941334882e-06, -9.011213803183179e-08,  8.099345542503748e-10,
 -6.802830955346511e-12,  5.414714252449994e-14, -4.122816180666206e-16,  3.023307359709993e-18, -2.146071234408762e-20,  1.480426138349013e-22, -9.955176649808249e-25,
  5.964964228736065e-02, -1.060029883972798e-03,  1.535656318858756e-05, -1.879099559708328e-07,  2.056114000931103e-09, -2.070224893874888e-11,  1.951819652397911e-13,
 -1.743456419745153e-15,  1.487891578178882e-17, -1.220772723926249e-19,  9.675999750327847e-22, -7.436868459111623e-24,  5.119862443203753e-02, -1.274235008520166e-03,
  2.321816650985659e-05, -3.470454539107037e-07,  4.548925042474937e-09, -5.409149434844787e-11,  5.957224247490834e-13, -6.161250815173673e-15,  6.043373422063244e-17,
 -5.663109294597366e-19,  5.098502972033662e-21, -4.429437221470814e-23,  4.269541856055247e-02, -1.425049809002626e-03,  3.210353713863168e-05, -5.776718666170605e-07,
  8.953002832532175e-09, -1.242508998615299e-10,  1.581048175916425e-12, -1.873910456595721e-14,  2.092015222863046e-16, -2.218182908744414e-18,  2.248110144605130e-20,
 -2.188661589013806e-22,  3.462436033178524e-02, -1.495987773609983e-03,  4.104059395281225e-05, -8.777952177507382e-07,  1.590964740129927e-08, -2.551529052410770e-10,
  3.717192326837145e-12, -5.006014606300119e-14,  6.309726983896341e-16, -7.512119876920858e-18,  8.507783431096070e-20, -9.216191339614909e-22,  2.733580532070464e-02,
 -1.485299630478471e-03,  4.893030099726771e-05, -1.229959116425520e-06,  2.581908172364429e-08, -4.744028416384969e-10,  7.850640028163587e-12, -1.192522254112700e-13,
  1.685324799532542e-15, -2.238212165403541e-17,  2.814880760763420e-19, -3.372447199689886e-21,  2.103635064056463e-02, -1.403438640833778e-03,  5.480028644606440e-05,
 -1.602384010714566e-06,  3.862078539150660e-08, -8.067630930530278e-10,  1.505909018072358e-11, -2.563415321955073e-13,  4.037221901316391e-15, -5.946391566255896e-17,
  8.258862154900470e-19, -1.088566538268012e-20,  1.580163193140304e-02, -1.268634802125646e-03,  5.801258948548057e-05, -1.954685060602174e-06,  5.366275604209753e-08,
 -1.265493994361262e-09,  2.647499730482759e-11, -5.020589374453243e-13,  8.763326225775905e-15, -1.424063303220537e-16,  2.173447289388138e-18, -3.136670934208198e-20,
  1.160367709966054e-02, -1.102048187450337e-03,  5.836639667473200e-05, -2.246411722051906e-06,  6.972918267652236e-08, -1.844303399170733e-09,  4.299016338500150e-11,
 -9.032863230513349e-13,  1.738545681176797e-14, -3.102112977229278e-16,  5.179121927096096e-18, -8.148402688032098e-20,  8.344173883553761e-03, -9.236812965194807e-04,
  5.608223043876187e-05, -2.445594814381345e-06,  8.523775006920530e-08, -2.513205008470398e-09,  6.491225760128758e-11, -1.503533098550246e-12,  3.175865584273451e-14,
 -6.194518097976607e-16,  1.126541231618521e-17, -1.924440408705287e-19,  5.886500186228245e-03, -7.496974406105568e-04,  5.169440120189624e-05, -2.534686975358772e-06,
  9.855110634748815e-08, -3.220546433589853e-09,  9.169001677880138e-11, -2.329973308376678e-12,  5.377048686745205e-14, -1.141653844864904e-15,  2.252589408562421e-17,
 -4.162234513737695e-19,  4.081934910688743e-03, -5.912526256058679e-04,  4.589973258572981e-05, -2.512483377488161e-06,  1.083047769662328e-07, -3.901253419812197e-09,
  1.218226482681640e-10, -3.380710550534817e-12,  8.487684903314864e-14, -1.953799419955924e-15,  4.166612163610874e-17, -8.297333536891869e-19,  2.788121376429648e-03,
 -4.545628589534267e-04,  3.941033661231519e-05, -2.392129543266509e-06,  1.136539368358898e-07, -4.488999378274157e-09,  1.530135554739008e-10, -4.616856645343093e-12,
  1.255828444026596e-13, -3.122063815834611e-15,  7.169843929664898e-17, -1.533413285842481e-18,  1.879934384289162e-03, -3.417525414431818e-04,  3.284321771593184e-05,
 -2.196487671720699e-06,  1.143789423398322e-07, -4.928651658252441e-09,  1.825419374638561e-10, -5.962980841722852e-12,  1.750329341502780e-13, -4.681909138152574e-15,
  1.153751238401577e-16, -2.641091752568588e-18,  1.254146167368685e-03, -2.520324758814377e-04,  2.665961797661684e-05, -1.952590030430812e-06,  1.108428026953387e-07,
 -5.185500190986696e-09,  2.077482887078148e-10, -7.316789498196192e-12,  2.308673809011280e-13, -6.620140720169211e-15,  1.744493812534223e-16, -4.260133108454124e-18,
  8.297532828979019e-04, -1.828659473459631e-04,  2.115037478665112e-05, -1.686692205607325e-06,  1.038387431182878e-07, -5.249190610349439e-09,  2.264955400911522e-10,
 -8.565714260951012e-12,  2.894264049600164e-13, -8.865084337254806e-15,  2.489518960685802e-16, -6.464508559504348e-18,  5.457423054960649e-04, -1.309248708964181e-04,
  1.645406446176658e-05, -1.420833414710768e-06,  9.438794651389435e-08, -5.132188285314134e-09,  2.374870345517618e-10, -9.605834648835015e-12,  3.462697734658177e-13,
 -1.128908806832788e-14,  3.367105069947543e-16, -9.267067021236055e-18,  3.576971490607781e-04, -9.276404718390821e-05,  1.259234293488268e-05, -1.171145529434920e-06,
  8.354501519763886e-08, -4.864172367986294e-09,  2.403805081323298e-10, -1.035811856724048e-11,  3.968771402075654e-13, -1.372376869583988e-14,  4.332934252346668e-16,
 -1.259914696032682e-17,  2.341949317797307e-04, -6.522688924706050e-05,  9.509390587515419e-06, -9.476569523028315e-07,  7.224998800581894e-08, -4.484517949054090e-09,
  2.357048510441693e-10, -1.077829548258204e-11,  4.373451207536620e-13, -1.598439632894219e-14,  5.324349492797947e-16, -1.630458962636823e-17,  1.535299913692025e-04,
 -4.563911702835109e-05,  7.106948130676942e-06, -7.550950978407407e-07,  6.124226149294546e-08, -4.034937344914569e-09,  2.246373077441767e-10, -1.085899637292692e-11,
  4.649148117373627e-13, -1.789718671735446e-14,  6.268557057112714e-16, -2.015135915522797e-17,  1.010027811209616e-04, -3.185806580318578e-05,  5.270959741032517e-06,
 -5.941690859657424e-07,  5.103240417166007e-08, -3.553707073319476e-09,  2.087198977792236e-10, -1.062507805750369e-11,  4.782319323271789e-13, -1.932293494944176e-14,
  7.092762068968045e-16, -2.385882904564072e-17,  6.681742115303020e-05, -2.223763502539217e-05,  3.889196945413229e-06, -4.629253192747086e-07,  4.191671767828325e-08,
 -3.072090950152744e-09,  1.895869180815710e-10, -1.012453472383712e-11,  4.773274876954499e-13, -2.017219455285871e-14,  7.733829903718343e-16, -2.713438517037139e-17,
  4.452834753091887e-05, -1.555360830637487e-05,  2.861162444690962e-06, -3.579251180660199e-07,  3.401630721046124e-08, -2.612884047458049e-09,  1.687514171325725e-10,
 -9.417826057485040e-12,  4.633774290769818e-13, -2.041010443680103e-14,  8.145457718921595e-16, -2.971089384479674e-17,  2.993490019857620e-05, -1.091825845444044e-05,
  2.102314226229228e-06, -2.751354041875114e-07,  2.732482975005474e-08, -2.190589986620093e-09,  1.474703751065257e-10, -8.568007107189615e-12,  4.383367931609396e-13,
 -2.005180588743814e-14,  8.301756910697753e-16, -3.137725314125679e-17,  2.031759289129817e-05, -7.700303165082120e-06,  1.544630271158181e-06, -2.105231522321816e-07,
  2.175397938009065e-08, -1.812606123338471e-09,  1.266853897978607e-10, -7.633143758951003e-12,  4.045457725873671e-13, -1.915130649169818e-14,  8.197189016799687e-16,
 -3.199702858297633e-17,  1.392263743853982e-05, -5.457349620890693e-06,  1.135143896744203e-06, -1.603990745562784e-07,  1.717082556863656e-08, -1.480847973555287e-09,
  1.070220658124269e-10, -6.661549420096499e-12,  3.643825713560565e-13, -1.778732949481728e-14,  7.843618936476511e-16, -3.151378835867851e-17,  9.620323121101635e-06,
 -3.882549435376129e-06,  8.335917228577977e-07, -1.215757076894403e-07,  1.342507929134078e-08, -1.193397076741821e-09,  8.882672925308369e-11, -5.689651271517626e-12,
  3.200052396816936e-13, -1.604932073869742e-14,  7.265672851151602e-16, -2.994493666686434e-17,  6.681731979998922e-06, -2.764365522018131e-06,  6.098792464992634e-07,
 -9.140307523694740e-08,  1.036685606956809e-08, -9.459264055910603e-10,  7.222085933842622e-11, -4.741885269697484e-12,  2.731941051545990e-13, -1.402581507093052e-14,
  6.495615716281749e-16, -2.736781211468033e-17,  4.634228245608488e-06, -1.957204409554931e-06,  4.417398801549804e-07, -6.773286302492723e-08,  7.856709744575530e-09,
 -7.327984569451978e-10,  5.715857452432091e-11, -3.831897152764717e-12,  2.252847502338290e-13, -1.179625088039198e-14,  5.568714653954165e-16, -2.390239190491238e-17,
  3.168471546685117e-06, -1.360462770181832e-06,  3.127448661476788e-07, -4.884723613664523e-08,  5.770016555027240e-09, -5.478268321751627e-10,  4.347812777176490e-11,
 -2.964399844259474e-12,  1.771703926864687e-13, -9.426391684622372e-15,  4.519686876241195e-16, -1.969440803810321e-17,  2.078647034782254e-06, -9.037840125803339e-07,
  2.106925906424521e-07, -3.337519707749736e-08,  3.997592392147785e-09, -3.847453261693338e-10,  3.094321506399134e-11, -2.137209180603792e-12,  1.293504013759641e-13,
 -6.966923196907024e-15,  3.380478314163419e-16, -1.490154942024399e-17,  1.223848211404083e-06, -5.367364786382326e-07,  1.263419995869747e-07, -2.020969750595855e-08,
  2.444074611189086e-09, -2.374552598460885e-10,  1.927382603614241e-11, -1.343202418874623e-12,  8.200711660655752e-14, -4.454639538311235e-15,  2.179404074244696e-16,
 -9.684372387039316e-18,  5.033590426946456e-07, -2.218134982799909e-07,  5.249372408519940e-08, -8.442553268072979e-09,  1.026483216630692e-09, -1.002523607113829e-10,
  8.179032187278922e-12, -5.728490471868548e-13,  3.514457094284423e-14, -1.918098914139742e-15,  9.427415252608256e-17, -4.207876893612142e-18,  8.018347616339069e-02,
 -2.707000760638552e-04,  9.597357698951422e-07, -3.531789767501837e-09,  1.332636644324298e-11, -5.104216637885469e-14,  1.969776922860373e-16, -7.622067579950617e-19,
  2.948143640917067e-21, -1.137878786404915e-23,  4.377940878038846e-26, -1.678356228197543e-28,  7.728712294934012e-02, -3.665097681255563e-04,  2.052707087470380e-06,
 -1.162099965477753e-08,  6.402782589932528e-11, -3.424189730612145e-13,  1.784470042669529e-15, -9.098802879399931e-18,  4.553716570458811e-20, -2.242363742459923e-22,
  1.088462421231933e-24, -5.215804634853346e-27,  7.181653124058508e-02, -5.366005542030095e-04,  4.392397802985192e-06, -3.323086884345939e-08,  2.351238393322738e-10,
 -1.581503543526167e-12,  1.021907722298748e-14, -6.387392685592641e-17,  3.881004036793203e-19, -2.300816929498150e-21,  1.334727838974710e-23, -7.593943554984858e-26,
  6.435502517653061e-02, -7.438992512482308e-04,  8.144747581292037e-06, -7.817476723680667e-08,  6.859918071622762e-10, -5.631568911038910e-12,  4.384923142611767e-14,
 -3.268347159501964e-16,  2.347543058461799e-18, -1.632993673578969e-20,  1.104384634965622e-22, -7.283481655232016e-25,  5.564169665328793e-02, -9.456676858236156e-04,
  1.328614849628592e-05, -1.580856537488230e-07,  1.685220283878188e-09, -1.655368970687298e-11,  1.524200255188953e-13, -1.330773711089103e-15,  1.110857710827957e-17,
 -8.920191276759595e-20,  6.923276323731038e-22, -5.212922511172091e-24,  4.644844401603432e-02, -1.103987998763881e-03,  1.945698251024135e-05, -2.821954219595064e-07,
  3.597149105027497e-09, -4.166332748093214e-11,  4.474768359854177e-13, -4.517724825634235e-15,  4.329182640770741e-17, -3.966035452989440e-19,  3.492850885578693e-21,
 -2.969976732325204e-23,  3.746817766636703e-02, -1.193690844964393e-03,  2.595517913984586e-05, -4.524079524352511e-07,  6.808553740123705e-09, -9.191362703058750e-11,
  1.139206947525753e-12, -1.316600673907014e-14,  1.434532445963490e-16, -1.485658069705161e-18,  1.471660474202143e-20, -1.401191905198977e-22,  2.923598125337320e-02,
 -1.205828318489285e-03,  3.188046809758506e-05, -6.596566136517953e-07,  1.159598988253444e-08, -1.807071265009912e-10,  2.561788596384720e-12, -3.361108754755599e-14,
  4.131328192472233e-16, -4.800608860731705e-18,  5.310370323029003e-20, -5.622378425708200e-22,  2.209305594940101e-02, -1.146532273537332e-03,  3.636662124976298e-05,
 -8.835554948148832e-07,  1.797331186702913e-08, -3.206355474053229e-10,  5.159430930490565e-12, -7.630137693095728e-14,  1.050924058944732e-15, -1.361448022167743e-17,
  1.671529955074495e-19, -1.956412511513849e-21,  1.619098021582200e-02, -1.032555758088092e-03,  3.880433288463237e-05, -1.096097475892657e-06,  2.558613770290565e-08,
 -5.186483767090306e-10,  9.408933358642426e-12, -1.558584073602811e-13,  2.391303205071697e-15, -3.434429187901325e-17,  4.655108647836142e-19, -5.992344298758289e-21,
  1.152506467495618e-02, -8.854835621699358e-04,  3.897278910297988e-05, -1.268301364607305e-06,  3.371386078072276e-08, -7.712954922953823e-10,  1.567822409275747e-11,
 -2.892540803613903e-13,  4.917447100459514e-15, -7.790512820505584e-17,  1.160174957683655e-18, -1.634997619644923e-20,  7.982111139165035e-03, -7.264560865442090e-04,
  3.704677169497124e-05, -1.377361803492244e-06,  4.139790888497905e-08, -1.062223693189300e-09,  2.405694284864659e-11, -4.917541459603532e-13,  9.218192574159548e-15,
 -1.603541920981201e-16,  2.612284539565184e-18, -4.013496099620075e-20,  5.389209121428761e-03, -5.725609743722942e-04,  3.349873458088391e-05, -1.411741890014406e-06,
  4.765877608831419e-08, -1.363521171537071e-09,  3.422435385345283e-11, -7.713504590099253e-13,  1.587135539168274e-14, -3.018552636525618e-16,  5.357453042382529e-18,
 -8.938901967249387e-20,  3.554433652631101e-03, -4.352171747989490e-04,  2.894766502901150e-05, -1.372707825813479e-06,  5.172519633636478e-08, -1.640967479899194e-09,
  4.542026171824570e-11, -1.123509213727426e-12,  2.526631510547016e-14, -5.232699505611548e-16,  1.007964116485329e-17, -1.819740984423541e-19,  2.295271247406776e-03,
 -3.202328322614296e-04,  2.401068310720452e-05, -1.272345349539990e-06,  5.319689895586840e-08, -1.861558071221103e-09,  5.654983925921467e-11, -1.528490608093412e-12,
  3.741584827350059e-14, -8.405612218624458e-16,  1.750923021960934e-17, -3.408486465008419e-19,  1.454682234123554e-03, -2.289045814009736e-04,  1.919616893870562e-05,
 -1.129318090414405e-06,  5.209515175876118e-08, -2.000738638705685e-09,  6.639892415646590e-11, -1.952824946782898e-12,  5.182922131913589e-14, -1.258378285372959e-15,
  2.824654093158829e-17, -5.909326414165511e-19,  9.071794984549178e-04, -1.595138601568061e-04,  1.485239681554559e-05, -9.640760509887417e-07,  4.880218021114387e-08,
 -2.047039684363392e-09,  7.389072423533589e-11, -2.354976357309054e-12,  6.750847529187712e-14, -1.765050477711540e-15,  4.254897685640897e-17, -9.535197479853692e-19,
  5.582032435494646e-04, -1.087458757337652e-04,  1.116505576707320e-05, -7.949284967271378e-07,  4.392786061672369e-08, -2.002994631917426e-09,  7.830093109120543e-11,
 -2.693553774772693e-12,  8.308788927230481e-14, -2.331161187978180e-15,  6.014988778495903e-17, -1.439335024889811e-18,  3.398628596524602e-04, -7.277963436468817e-05,
  8.186292689679250e-06, -6.357061908961081e-07,  3.815630389297058e-08, -1.882666132162588e-09,  7.937009420083569e-11, -2.935479249169630e-12,  9.708204005167973e-14,
 -2.912768987689544e-15,  8.018113117947519e-17, -2.042315985807424e-18,  2.053576100498798e-04, -4.798458452815284e-05,  5.876657212234904e-06, -4.950457709624882e-07,
  3.211674139359704e-08, -1.707127217386608e-09,  7.729507297961015e-11, -3.061702685993772e-12,  1.081674754818932e-13, -3.458658566608744e-15,  1.012423391922694e-16,
 -2.736425085486624e-18,  1.235179020999818e-04, -3.127501269039278e-05,  4.145913063046452e-06, -3.768812405403241e-07,  2.630260857465339e-08, -1.499536323406795e-09,
  7.262324455324218e-11, -3.069149378015807e-12,  1.154150001818343e-13, -3.919540790470127e-15,  1.216092998769899e-16, -3.477026926071457e-18,  7.418123197475668e-05,
 -2.022064185724210e-05,  2.885072282499901e-06, -2.815791003620846e-07,  2.104157610606557e-08, -1.281103910092674e-09,  6.609720807116259e-11, -2.968985854732196e-12,
  1.184141651164709e-13, -4.256540875583551e-15,  1.395249401372297e-16, -4.206860574650985e-18,  4.462032475609938e-05, -1.301266982757600e-05,  1.987459067126307e-06,
 -2.072268983498376e-07,  1.650506336457196e-08, -1.068600973882416e-09,  5.849948520898745e-11, -2.782366367613766e-12,  1.172735265136537e-13, -4.446784900403581e-15,
  1.534909770000124e-16, -4.865076760899820e-18,  2.696164043255612e-05, -8.362533844550475e-06,  1.360012240897032e-06, -1.507593060313014e-07,  1.274043252431156e-08,
 -8.734389232615140e-10,  5.053224951882208e-11, -2.535248288180407e-12,  1.125195860503027e-13, -4.485073714308456e-15,  1.624850534015525e-16, -5.396873050592373e-18,
  1.641243853375499e-05, -5.383438625772672e-06,  9.274733503369580e-07, -1.087828641247686e-07,  9.710555087063764e-09, -7.019520635165430e-10,  4.274684608739302e-11,
 -2.253672844286656e-12,  1.049399538799035e-13, -4.381929635615247e-15,  1.660599489221476e-16, -5.761279545392373e-18,  1.009128676792003e-05, -3.481502624846532e-06,
  6.322070899874523e-07, -7.808862957910193e-08,  7.330302413781605e-09, -5.563747433629574e-10,  3.552057690887101e-11, -1.960361075693830e-12,  9.541876718070037e-14,
 -4.159212936740413e-15,  1.643216521376573e-16, -5.935486364624689e-18,  6.281127698926941e-06, -2.267368680987899e-06,  4.318394515352087e-07, -5.591037016034601e-08,
  5.494788971310132e-09, -4.360570994825207e-10,  2.906820351651516e-11, -1.672875498551163e-12,  8.480012706983542e-14, -3.844817966312334e-15,  1.578154235304685e-16,
 -5.915305932107330e-18,  3.964372901299521e-06, -1.489837483189310e-06,  2.961683412423565e-07, -4.000713717942295e-08,  4.098239035957644e-09, -3.386064332349907e-10,
  2.347287923225031e-11, -1.403151491498798e-12,  7.379721060930570e-14, -3.467749534843182e-15,  1.473645455161898e-16, -5.712429156249027e-18,  2.539357222291252e-06,
 -9.886927765717727e-07,  2.041655022847650e-07, -2.864227710787427e-08,  3.044697340590082e-09, -2.607940431627417e-10,  1.872341190482823e-11, -1.157979825659003e-12,
  6.294841918087996e-14, -3.054386911737789e-15,  1.339051754392467e-16, -5.349747892093481e-18,  1.650072896478241e-06, -6.624882016706264e-07,  1.414382656280906e-07,
 -2.051269491690657e-08,  2.252724393565086e-09, -1.991850243585125e-10,  1.474906366527653e-11, -9.399918151806972e-13,  5.261146385653527e-14, -2.626213977771932e-15,
  1.183484432791103e-16, -4.856115871082563e-18,  1.085073995040659e-06, -4.471984085440580e-07,  9.824805871656993e-08, -1.466285782710992e-08,  1.656224758114580e-09,
 -1.505188239175305e-10,  1.144741115646524e-11, -7.487849255982705e-13,  4.298216506409056e-14, -2.198893553810605e-15,  1.014851019296173e-16, -4.261641163211678e-18,
  7.178900237804375e-07, -3.023778608791339e-07,  6.804448626897339e-08, -1.040247277450197e-08,  1.203130353227634e-09, -1.118982108132274e-10,  8.704040055033277e-12,
 -5.819544261641948e-13,  3.412533516912095e-14, -1.782348853999748e-15,  8.393437926476693e-17, -3.594155716749692e-18,  4.720273682119944e-07, -2.023228065773070e-07,
  4.642000495184237e-08, -7.236166539198938e-09,  8.531267739224158e-10, -8.084769097459119e-11,  6.404786164043536e-12, -4.359153595615074e-13,  2.600818724407085e-14,
 -1.381463721970601e-15,  6.612997818762031e-17, -2.877075412961854e-18,  3.003954896617307e-07, -1.304763593503710e-07,  3.038216780156314e-08, -4.807201673246670e-09,
  5.751399093439126e-10, -5.529243628089977e-11,  4.442089014675607e-12, -3.064860475348504e-13,  1.853043836969490e-14, -9.970693056152022e-16,  4.833266917003871e-17,
 -2.128556074482476e-18,  1.731321026897365e-07, -7.588988005126450e-08,  1.785315479073721e-08, -2.854097169089070e-09,  3.449594572660419e-10, -3.349537290877994e-11,
  2.717226420317798e-12, -1.892604643631560e-13,  1.154878308018777e-14, -6.270023039800911e-16,  3.065997166144846e-17, -1.361723498060862e-18,  7.036167700263180e-08,
 -3.099849453547117e-08,  7.333986919921339e-09, -1.179191795806803e-09,  1.433312480952907e-10, -1.399469494163247e-11,  1.141437964963638e-12, -7.992342370884663e-14,
  4.902048410055364e-15, -2.674716780486459e-16,  1.314282927604022e-17, -5.864769571573029e-19,  7.911576823252661e-02, -2.631881669924220e-04,  9.186007486924697e-07,
 -3.326484861265229e-09,  1.235112260849481e-11, -4.656050951572136e-14,  1.768974179554934e-16, -6.740962869523697e-19,  2.568327947070533e-21, -9.766686148806949e-24,
  3.702895235271159e-26, -1.399075827801060e-28,  7.585306791327463e-02, -3.506290096177238e-04,  1.919183074229366e-06, -1.064909827794081e-08,  5.758790356905737e-11,
 -3.024913967296689e-13,  1.548948053011138e-15, -7.762799655531333e-18,  3.819606645666706e-20, -1.849592319357390e-22,  8.830567713267558e-25, -4.162760693013585e-27,
  6.973796906630512e-02, -5.029948200283704e-04,  4.015197035705656e-06, -2.970918608115163e-08,  2.058084218893406e-10, -1.356376964408660e-12,  8.592722701104221e-15,
 -5.268313725641288e-17,  3.141273392305967e-19, -1.828163647841201e-21,  1.041439741705049e-23, -5.820210279541993e-26,  6.150405543555316e-02, -6.823152729983007e-04,
  7.268965823029165e-06, -6.804573536404970e-08,  5.831846553813925e-10, -4.681029304773969e-12,  3.566691510107354e-14, -2.603257261203852e-16,  1.832023300564834e-18,
 -1.249215112843899e-20,  8.284912271663504e-23, -5.360193788770195e-25,  5.206020528052502e-02, -8.465321597110412e-04,  1.154058722983521e-05, -1.335839463409184e-07,
  1.387904768589336e-09, -1.330536711260792e-11,  1.196879007668322e-13, -1.021753096693806e-15,  8.345068717932061e-18, -6.560356810494148e-20,  4.987302105221106e-22,
 -3.679849446838159e-24,  4.232365922910315e-02, -9.609588342599577e-04,  1.639024502108919e-05, -2.307640111947384e-07,  2.861787168500567e-09, -3.229758395826119e-11,
  3.384072584208316e-13, -3.336228451102312e-15,  3.124299232059481e-17, -2.799026679316034e-19,  2.412064747657614e-21, -2.007920704667389e-23,  3.307675587963852e-02,
 -1.006043710754911e-03,  2.112373257275287e-05, -3.568083501995086e-07,  5.216315394753754e-09, -6.852334835564211e-11,  8.275305823627445e-13, -9.328682002902784e-15,
  9.923080142135848e-17, -1.004046806075879e-18,  9.723627238977982e-21, -9.056467839582805e-23,  2.487673781389970e-02, -9.795484394010600e-04,  2.496854427264053e-05,
 -4.999883543209905e-07,  8.527539424627358e-09, -1.291697824221673e-10,  1.782445371293294e-12, -2.278997469875438e-14,  2.732491804622145e-16, -3.099795996882757e-18,
  3.349988924901392e-20, -3.467373986638449e-22,  1.802795274846027e-02, -8.935682292784107e-04,  2.729773525591029e-05, -6.412196925116150e-07,  1.264368624404998e-08,
 -2.190569141803043e-10,  3.428433588066191e-12, -4.937481780251686e-14,  6.629341932143969e-16, -8.379358833799639e-18,  1.004550055605333e-19, -1.148860574000152e-21,
  1.260720093385993e-02, -7.684897593414175e-04,  2.780115854471582e-05, -7.587754305457302e-07,  1.715809797566184e-08, -3.375811023801014e-10,  5.953244834694590e-12,
 -9.598478282418244e-14,  1.434934932730319e-15, -2.009931674696339e-17,  2.659137808956293e-19, -3.343577302921277e-21,  8.521856664988716e-03, -6.264615663562083e-04,
  2.654005262224805e-05, -8.343065548725851e-07,  2.147666008466277e-08, -4.767289233130381e-10,  9.417035940840829e-12, -1.690537814221392e-13,  2.799576363230473e-15,
 -4.324568841588715e-17,  6.284817865962334e-19, -8.649907668110811e-21,  5.578354784426229e-03, -4.863668419627967e-04,  2.388169435108287e-05, -8.577244535794559e-07,
  2.496381220650740e-08, -6.214437108318522e-10,  1.367570151942295e-11, -2.719845314913577e-13,  4.966080451709848e-15, -8.422565525668263e-17,  1.338928072924653e-18,
 -2.008973788455942e-20,  3.543546372706976e-03, -3.611867945375710e-04,  2.035988136277453e-05, -8.291624806130944e-07,  2.711159990342975e-08, -7.526524410119176e-10,
  1.835881673599149e-11, -4.026207095369672e-13,  8.070068429060920e-15, -1.496604185160953e-16,  2.592338448079491e-18, -4.224640850903341e-20,  2.189402881234273e-03,
 -2.576131711915161e-04,  1.652390214913249e-05, -7.576819226370310e-07,  2.766591484109007e-08, -8.519857479918477e-10,  2.292485080918799e-11, -5.519550950921461e-13,
  1.209528995116098e-14, -2.443263480595418e-16,  4.594506390356760e-18, -8.104030176440208e-20,  1.319035524931006e-03, -1.771643355013770e-04,  1.282508436988887e-05,
 -6.577361770105979e-07,  2.666717410965009e-08, -9.064065413215194e-10,  2.678186157480173e-11, -7.049567885462094e-13,  1.682327554422890e-14, -3.688029525254642e-16,
  7.503020177824452e-18, -1.427645984612818e-19,  7.769799269778849e-04, -1.179314649523054e-04,  9.561755575839410e-06, -5.450171669848508e-07,  2.440287673033699e-08,
 -9.110611496988563e-10,  2.943106170665293e-11, -8.435291614723186e-13,  2.183994478045395e-14, -5.177626381163275e-16,  1.135774929106610e-17, -2.323872508789768e-19,
  4.488017793083872e-04, -7.627740881319844e-05,  6.877441022056160e-06, -4.330924248578317e-07,  2.130355278386955e-08, -8.695511722509113e-10,  3.058105622021949e-11,
 -9.506481210366856e-13,  2.660662340828114e-14, -6.797878888620999e-16,  1.602664298298604e-17, -3.515205728002884e-19,  2.550033660873845e-04, -4.812317114566821e-05,
  4.792823576884079e-06, -3.315461587510635e-07,  1.782676508442018e-08, -7.919336612644005e-10,  3.019609591659314e-11, -1.014217600205595e-12,  3.057514683868729e-14,
 -8.390656415548638e-16,  2.119278201617854e-17, -4.967784362472427e-19,  1.429945204420554e-04, -2.973072566378301e-05,  3.250042501008750e-06, -2.456169415464490e-07,
  1.436574817402913e-08, -6.915162164956241e-10,  2.847150860641592e-11, -1.029369764200711e-12,  3.330791529986395e-14, -9.785352682817826e-16,  2.639507962396708e-17,
 -6.592609502477540e-19,  7.941137494386560e-05, -1.805827865661001e-05,  2.153666335174337e-06, -1.768749898923454e-07,  1.119998289739146e-08, -5.816627365722012e-10,
  2.575682774492430e-11, -9.986632717875187e-13,  3.456347200399143e-14, -1.083464859476419e-15,  3.111385633330714e-17, -8.255546541679798e-19,  4.383329370923767e-05,
 -1.082722760401743e-05,  1.400620260223178e-06, -1.243650893056873e-07,  8.486211168499550e-09, -4.734745436053767e-10,  2.246021628961786e-11, -9.304658170831899e-13,
  3.432482321944227e-14, -1.144303764375849e-15,  3.487457529601762e-17, -9.800610614379905e-19,  2.413774478346764e-05, -6.434204340201248e-06,  8.977859078910172e-07,
 -8.575670816261539e-08,  6.277178550368350e-09, -3.746653346359580e-10,  1.896479167699308e-11, -8.363523715995893e-13,  3.277104200140654e-14, -1.158027130274802e-15,
  3.733718548305150e-17, -1.107954467578696e-18,  1.331060559404287e-05, -3.805199042732633e-06,  5.696111222956271e-07, -5.824541901672990e-08,  4.552807527415380e-09,
 -2.894887770070497e-10,  1.557453560853991e-11, -7.284502326073360e-13,  3.021111220633966e-14, -1.127812140916949e-15,  3.834648622433209e-17, -1.197867773728402e-18,
  7.378056760629675e-06, -2.248603047643760e-06,  3.592078104976371e-07, -3.913096143050425e-08,  3.251726214008493e-09, -2.193407704919646e-10,  1.249300231037959e-11,
 -6.174071241031560e-13,  2.700601414650238e-14, -1.061447724965888e-15,  3.793521214964720e-17, -1.243578093755875e-18,  4.125965394818378e-06, -1.332899262827032e-06,
  2.260576830430539e-07, -2.611030607628125e-08,  2.296376055450883e-09, -1.636351402932721e-10,  9.827909740537304e-12, -5.112633299581204e-13,  2.350119095178849e-14,
 -9.691655915180381e-16,  3.628772121309658e-17, -1.244384268556522e-18,  2.335932369370426e-06, -7.954850315861939e-07,  1.425076589795848e-07, -1.736961211837023e-08,
  1.609609172162566e-09, -1.206555378538365e-10,  7.610701485503446e-12, -4.151671497704336e-13,  1.998171555607433e-14, -8.615571819272241e-16,  3.368184823024572e-17,
 -1.204317460032408e-18,  1.343106903244698e-06, -4.795815273441154e-07,  9.029797527245193e-08, -1.155947736025610e-08,  1.123630987116991e-09, -8.822544864385271e-11,
  5.821009317551071e-12, -3.316815169969592e-13,  1.665229882571843e-14, -7.480145083974321e-16,  3.042781172883696e-17, -1.130623632786210e-18,  7.863343683568839e-07,
 -2.928826441008436e-07,  5.767222698726492e-08, -7.717671195060297e-09,  7.833799591406509e-10, -6.415303380466348e-11,  4.409181100113819e-12, -2.613884385445237e-13,
  1.363731491430747e-14, -6.358522461651497e-16,  2.681815837303666e-17, -1.032035514772494e-18,  4.695923788452294e-07, -1.815368147506924e-07,  3.720154880345213e-08,
 -5.179508967786339e-09,  5.465211337369554e-10, -4.647676104317669e-11,  3.313562722176293e-12, -2.035536866520253e-13,  1.099319255512065e-14, -5.300467570596597e-16,
  2.309539254627948e-17, -9.172517913589105e-19,  2.861980316383378e-07, -1.142755262357508e-07,  2.425223205607410e-08, -3.496473433291947e-09,  3.817648472804557e-10,
 -3.356566339438165e-11,  2.471879454881712e-12, -1.567056510293140e-13,  8.725907810987041e-15, -4.334107933207286e-16,  1.943743133769005e-17, -7.938564359516551e-19,
  1.777344444861303e-07, -7.295313673462103e-08,  1.595634696766668e-08, -2.370816764040155e-09,  2.666297259236323e-10, -2.412907427672347e-11,  1.827558780353906e-12,
 -1.190664326637447e-13,  6.808348222135221e-15, -3.470008399023494e-16,  1.595700732428721e-17, -6.677303269317023e-19,  1.119065913276563e-07, -4.700109044210067e-08,
  1.054349530878348e-08, -1.606797642800645e-09,  1.852663065036955e-10, -1.717910178370677e-11,  1.332381720783831e-12, -8.883100820340197e-14,  5.194661613105228e-15,
 -2.705912722343735e-16,  1.270973962885334e-17, -5.428828633421729e-19,  7.061632537826100e-08, -3.021176284257046e-08,  6.917376715254668e-09, -1.076085949374195e-09,
  1.266105498434096e-10, -1.197466432512153e-11,  9.468106511139551e-13, -6.432017872371848e-14,  3.830586939682014e-15, -2.031084558426721e-16,  9.706053172411536e-18,
 -4.215752624656572e-19,  4.352092220632396e-08, -1.888269258707803e-08,  4.391605782534327e-09, -6.940108196578331e-10,  8.293253118535583e-11, -7.963545150099895e-12,
  6.390433193916416e-13, -4.404224290547424e-14,  2.659949536886823e-15, -1.429733559453927e-16,  6.923494674211794e-18, -3.046057763002809e-19,  2.452407269505470e-08,
 -1.074382722907805e-08,  2.525926302084779e-09, -4.035545667818678e-10,  4.874528486375363e-11, -4.730266200136021e-12,  3.835029080460089e-13, -2.669628892625426e-14,
  1.628101564736049e-15, -8.834352569273826e-17,  4.317611727685156e-18, -1.916608710003485e-19,  9.841429824667609e-09, -4.334636036242361e-09,  1.025244524587803e-09,
 -1.647952966378912e-10,  2.002510733590266e-11, -1.954665855804802e-12,  1.593816843789671e-13, -1.115678922078684e-14,  6.841067758205704e-16, -3.731705408129909e-17,
  1.833174295847933e-18, -8.178121990464715e-20,  7.807746501506016e-02, -2.559957420753690e-04,  8.798386382648617e-07, -3.136092161192898e-09,  1.146088560268156e-11,
 -4.253249571224756e-14,  1.591224459938888e-16, -5.972611506846666e-19,  2.241969642076588e-21, -8.401558652149243e-24,  3.139467201704138e-26, -1.169295622706158e-28,
  7.448047099617922e-02, -3.357714848527697e-04,  1.796729035960048e-06, -9.774142109489000e-09,  5.189290569747795e-11, -2.677927444962472e-13,  1.347747107235199e-15,
 -6.640587368195728e-18,  3.213157085049770e-20, -1.530419453373820e-22,  7.188356248783994e-25, -3.334314031689607e-27,  6.778805144163653e-02, -4.722452960889444e-04,
  3.677584175253989e-06, -2.662254859395141e-08,  1.806292731325865e-10, -1.166775326044955e-12,  7.248975354040999e-15, -4.360843695097178e-17,  2.552335074000392e-19,
 -1.458592043138090e-21,  8.161562873464086e-24, -4.481430182238326e-26,  5.888614124915607e-02, -6.272779403175184e-04,  6.505457407424740e-06, -5.941960013208944e-08,
  4.975662634207482e-10, -3.906261953537527e-12,  2.913523993974238e-14, -2.083002816124158e-16,  1.436682290564777e-18, -9.605625470890882e-21,  6.248993684778006e-23,
 -3.967267600412805e-25,  4.884908116985406e-02, -7.602612375421052e-04,  1.006251742161315e-05, -1.133594666067740e-07,  1.148352356013250e-09, -1.074804279870632e-11,
  9.448807815751533e-14, -7.889440483803015e-16,  6.306566557873590e-18, -4.855114911666060e-20,  3.616266468424459e-22, -2.615392461938977e-24,  3.872556737804656e-02,
 -8.401815156837018e-04,  1.387583934505601e-05, -1.897315882432061e-07,  2.290033318087499e-09, -2.519249318309611e-11,  2.575982738510344e-13, -2.480655716119046e-15,
  2.270948232987714e-17, -1.990179170155419e-19,  1.678625037728890e-21, -1.368396233523664e-23,  2.936531739085041e-02, -8.528593739469366e-04,  1.730084072714425e-05,
 -2.833146960587510e-07,  4.025020202048543e-09, -5.146912879678297e-11,  6.058421927086065e-13, -6.663717250284148e-15,  6.922155246243350e-17, -6.844944110252755e-19,
  6.482553947432157e-21, -5.907832757365889e-23,  2.132307515838698e-02, -8.016622819686732e-04,  1.970905206943413e-05, -3.820909992636252e-07,  6.324943369722527e-09,
 -9.315500984005999e-11,  1.251649934202017e-12, -1.560002201061983e-14,  1.825019845229021e-16, -2.021727725796354e-18,  2.135119680839695e-20, -2.160945496330757e-22,
  1.484616102196940e-02, -7.028319007435551e-04,  2.068560917290675e-05, -4.699293774652653e-07,  8.984689677418789e-09, -1.512205469014386e-10,  2.302588751167983e-12,
 -3.230108330853451e-14,  4.228766248937570e-16, -5.216326784381412e-18,  6.107565828743893e-20, -6.826581391666289e-22,  9.926364117935285e-03, -5.783015815608142e-04,
  2.014308439654918e-05, -5.313241263718453e-07,  1.164178616383686e-08, -2.223671242206576e-10,  3.812866287920102e-12, -5.984825316658131e-14,  8.719556823872027e-16,
 -1.191394822733361e-17,  1.538785631287721e-19, -1.890281094804119e-21,  6.384627183371977e-03, -4.489983649270496e-04,  1.831127378602697e-05, -5.561209239161741e-07,
  1.386554748620704e-08, -2.986807315381863e-10,  5.734402633374719e-12, -1.001834224546551e-13,  1.616353399286793e-15, -2.434856394373712e-17,  3.453620280362176e-19,
 -4.642734009271662e-21,  3.958279898994635e-03, -3.305342952630564e-04,  1.562677148501355e-05, -5.422001204500646e-07,  1.528238249361793e-08, -3.691271997718412e-10,
  7.893862296491922e-12, -1.527612115947545e-13,  2.717033594707339e-15, -4.493247815019269e-17,  6.970793994867706e-19, -1.021521844519448e-20,  2.370618510801787e-03,
 -2.317387823546515e-04,  1.258410688286284e-05, -4.952267006299692e-07,  1.568355408450428e-08, -4.224836554057464e-10,  1.001491208779325e-11, -2.137202367069489e-13,
  4.173094838099730e-15, -7.546495225770755e-17,  1.275752910823155e-18, -2.030705211293487e-20,  1.374881402621854e-03, -1.553895751990997e-04,  9.609503256302700e-06,
 -4.260116147751139e-07,  1.507199611750295e-08, -4.505226112962565e-10,  1.178396558403225e-11, -2.761463578667096e-13,  5.896332880524984e-15, -1.161690195677384e-16,
  2.132518819307835e-18, -3.674829949754109e-20,  7.742652464501800e-04, -1.000617313817162e-04,  6.991188574003865e-06, -3.469185735130834e-07,  1.363684909784973e-08,
 -4.501400090725147e-10,  1.293509364498413e-11, -3.315349567611720e-13,  7.712313221277976e-15, -1.649656688653681e-16,  3.277451973532481e-18, -6.094930484795746e-20,
  4.246373355673924e-04, -6.213091477047962e-05,  4.868294682693162e-06, -2.687656952053028e-07,  1.167704654645552e-08, -4.236898416290142e-10,  1.331989549222528e-11,
 -3.719648020569288e-13,  9.393218307348398e-15, -2.174011668708653e-16,  4.659722501919727e-18, -9.323069010733539e-20,  2.275330627806787e-04, -3.735317503128353e-05,
  3.259627763714656e-06, -1.990567490270562e-07,  9.511168951904051e-09, -3.776531948454363e-10,  1.293652019362407e-11, -3.921378127316547e-13,  1.071267300288660e-14,
 -2.674011792651092e-16,  6.164124633726111e-18, -1.322978233725791e-19,  1.195289395934272e-04, -2.183477995524751e-05,  2.108239437422657e-06, -1.416252522089839e-07,
  7.406186223837368e-09, -3.204167879219089e-10,  1.191226632523518e-11, -3.905259872518117e-13,  1.150205062841549e-14, -3.086493756701318e-16,  7.628917977192195e-18,
 -1.751323060196653e-19,  6.178958755921230e-05, -1.246351734273047e-05,  1.323270351380436e-06, -9.726850159793063e-08,  5.540923354207112e-09, -2.600894432357493e-10,
  1.045369852944527e-11, -3.693147073132556e-13,  1.168761219508351e-14, -3.360950434451551e-16,  8.880583116174526e-18, -2.174292312194595e-19,  3.155614167096039e-05,
 -6.977915320204192e-06,  8.098397329076954e-07, -6.480244955626026e-08,  4.002794366121235e-09, -2.030075316968995e-10,  8.787385360073453e-12, -3.333542484747094e-13,
  1.129753940344373e-14, -3.470499942809099e-16,  9.773448081900381e-18, -2.544775316887242e-19,  1.598759821921637e-05, -3.849291026809102e-06,  4.855661640455455e-07,
 -4.208573399198521e-08,  2.806140839922786e-09, -1.531348402561829e-10,  7.111525287389560e-12, -2.886552131175418e-13,  1.044115004177121e-14, -3.415455753835564e-16,
  1.022040507128737e-17, -2.821880591236784e-19,  8.070400997499382e-06, -2.101987506381539e-06,  2.866167857640654e-07, -2.677646864000100e-08,  1.918645961745628e-09,
 -1.121996710103338e-10,  5.568805963606648e-12, -2.409865811188232e-13,  9.272228425058358e-15, -3.219459417292427e-16,  1.020557856913714e-17, -2.979230334684247e-19,
  4.077170470227640e-06, -1.141648099429746e-06,  1.673711520846476e-07, -1.677263298789859e-08,  1.285840536028969e-09, -8.024768965534479e-11,  4.240493906007394e-12,
 -1.949351986627097e-13,  7.950898165617748e-15, -2.920776173081177e-16,  9.777693907572308e-18, -3.008858548943489e-19,  2.070827330100020e-06, -6.196657152585332e-07,
  9.716375889919396e-08, -1.039486309123024e-08,  8.488476790336706e-10, -5.630305217994897e-11,  3.155326634053796e-12, -1.535210554516349e-13,  6.614772537157178e-15,
 -2.562338710913983e-16,  9.029764136214605e-18, -2.920202288173749e-19,  1.062215747095634e-06, -3.377188936328268e-07,  5.634536578128704e-08, -6.404749124696754e-09,
  5.546433884890026e-10, -3.893720912524920e-11,  2.305139890250007e-12, -1.182629833154302e-13,  5.363781244157360e-15, -2.183504156400066e-16,  8.073798584367709e-18,
 -2.735404832860891e-19,  5.526772309840452e-07, -1.856558228754313e-07,  3.279065837583448e-08, -3.941494355814951e-09,  3.603596470924384e-10, -2.666277465468626e-11,
  1.660810205980645e-12, -8.950418765276154e-14,  4.257528781531001e-15, -1.815031276403222e-16,  7.018324570762594e-18, -2.483013973672227e-19,  2.928889458962510e-07,
 -1.033875444661445e-07,  1.923302683890115e-08, -2.433082581204429e-09,  2.337971275032335e-10, -1.815380703676578e-11,  1.184928619183097e-12, -6.681783486567595e-14,
  3.321036224184829e-15, -1.477345907519695e-16,  5.953242255669644e-18, -2.192053912285467e-19,  1.586619617474429e-07, -5.854132580678047e-08,  1.141269959444745e-08,
 -1.512222473425240e-09,  1.520282194229505e-10, -1.233447206332376e-11,  8.401253542058648e-13, -4.937236182228613e-14,  2.554242215403483e-15, -1.181257347926114e-16,
  4.942956580218320e-18, -1.887725347769293e-19,  8.810403538243360e-08, -3.380366105183453e-08,  6.871452898971525e-09, -9.490673594835108e-10,  9.936253063043059e-11,
 -8.386088919717665e-12,  5.935130929310795e-13, -3.620161342850460e-14,  1.941717849836354e-15, -9.300060816542745e-17,  4.026229805479453e-18, -1.589125791132004e-19,
  5.022610440012263e-08, -1.993803868526774e-08,  4.204738060228558e-09, -6.024096405870079e-10,  6.537247077702459e-11, -5.713566906147371e-12,  4.183420810669399e-13,
 -2.637301766672187e-14,  1.460607779201455e-15, -7.216806023745337e-17,  3.220166719444914e-18, -1.308729941570914e-19,  2.937864836159375e-08, -1.200674678262450e-08,
  2.613747470207529e-09, -3.865298464369560e-10,  4.327053340028570e-11, -3.898321744336887e-12,  2.939811519004667e-13, -1.907245181142306e-14,  1.086137674914298e-15,
 -5.513848999882625e-17,  2.525867074945276e-18, -1.053053923693181e-19,  1.756014057761744e-08, -7.352955238987748e-09,  1.643947253734269e-09, -2.496973899392730e-10,
  2.869640575472270e-11, -2.652448566967401e-12,  2.050833719897059e-13, -1.363207071396223e-14,  7.948580734318717e-16, -4.128762013419003e-17,  1.933988737032142e-18,
 -8.238990029211909e-20,  1.061138420535342e-08, -4.530906891489416e-09,  1.035141850891818e-09, -1.606765086678864e-10,  1.886425095504122e-11, -1.780412113356112e-12,
  1.404860075677434e-13, -9.524793192588926e-15,  5.661576738217670e-16, -2.996323320255765e-17,  1.429275912461570e-18, -6.197075395903425e-20,  6.322072125953833e-09,
 -2.739829215306533e-09,  6.363899827976907e-10, -1.004392852559894e-10,  1.198694985516577e-11, -1.149606958825088e-12,  9.213962875983967e-14, -6.342685800190759e-15,
  3.826300699390366e-16, -2.054361155154373e-17,  9.937490594593272e-19, -4.367508891329872e-20,  3.478590905928228e-09, -1.523058013465579e-09,  3.578439808508913e-10,
 -5.713315224058255e-11,  6.896599127961528e-12, -6.688211402266961e-13,  5.419028403435918e-14, -3.769975822912967e-15,  2.297791601042349e-16, -1.246096930863171e-17,
  6.086603135970067e-19, -2.700387231882987e-20,  1.377382740182783e-09, -6.065051765971014e-10,  1.434100226649376e-10, -2.304436472074560e-11,  2.799389392524412e-12,
 -2.731688340732837e-13,  2.226738468731633e-14, -1.558275986164045e-15,  9.552248673569098e-17, -5.209162337631040e-18,  2.558263800156658e-19, -1.140981772135997e-20,
  7.706732543937604e-02, -2.491045113610603e-04,  8.432783628419566e-07, -2.959321238762876e-09,  1.064711122995806e-11, -3.890640083964348e-14,  1.433597383668883e-16,
 -5.301247614654250e-19,  1.960931466016386e-21, -7.242825765480490e-24,  2.667995842141898e-26, -9.797231123921988e-29,  7.316540929077262e-02, -3.218530924484448e-04,
  1.684249831424198e-06, -8.985006186563924e-09,  4.684602883350268e-11, -2.375667627752652e-13,  1.175415305627469e-15, -5.695254396455297e-18,  2.710614115099543e-20,
 -1.270189615474466e-22,  5.870740161829466e-25, -2.680097023301143e-27,  6.595595538874059e-02, -4.440550879380706e-04,  3.374713454620145e-06, -2.391011075996078e-08,
  1.589391885833796e-10, -1.006575785811633e-12,  6.134817668660424e-15, -3.622176822984390e-17,  2.081547476104677e-19, -1.168374039478645e-21,  6.423194481608408e-24,
 -3.466086832201348e-26,  5.647678445345392e-02, -5.779567840044459e-04,  5.837728299580397e-06, -5.204744296003462e-08,  4.259866099226929e-10, -3.272113128819996e-12,
  2.389773152867398e-14, -1.674090360138792e-16,  1.131963125954399e-18, -7.422948982276556e-21,  4.738173673948232e-23, -2.952525629043211e-25,  4.596084157200978e-02,
 -6.849055729388463e-04,  8.805731480309646e-06, -9.658942351697318e-08,  9.543906638774663e-10, -8.724130071465776e-12,  7.497890059633110e-14, -6.125180545772242e-16,
  4.793569183110914e-18, -3.614924865892120e-20,  2.638776459069440e-22, -1.871140062596192e-24,  3.557326664410805e-02, -7.376952498401125e-04,  1.180330338768682e-05,
 -1.568081648216102e-07,  1.842778813306718e-09, -1.976770182139913e-11,  1.973226709139746e-13, -1.856719820635687e-15,  1.662119493794641e-17, -1.425288208077483e-19,
  1.176964230994369e-21, -9.398022108191212e-24,  2.621060999558818e-02, -7.270303460524891e-04,  1.425589266756842e-05, -2.264186254997351e-07,  3.127129566568686e-09,
 -3.893871806528236e-11,  4.468942557842461e-13, -4.797527474884429e-15,  4.868199761102632e-17, -4.705862644295296e-19,  4.359461198597682e-21, -3.888450488281027e-23,
  1.840498655597536e-02, -6.607415323414544e-04,  1.567458032871710e-05, -2.943020016103362e-07,  4.730003594038230e-09, -6.775887900801782e-11,  8.867442050681899e-13,
 -1.077660108759329e-14,  1.230470050720456e-16, -1.331435860131031e-18,  1.374411464092638e-20, -1.360520405614365e-22,  1.233325844418798e-02, -5.576715717755666e-04,
  1.581812890021808e-05, -3.476491175183986e-07,  6.446864603239083e-09, -1.054404659115586e-10,  1.562425797300752e-12, -2.135522832617436e-14,  2.726713739669392e-16,
 -3.283241279178042e-18,  3.755302261115716e-20, -4.103085575877000e-22,  7.899128827477410e-03, -4.398022087627413e-04,  1.475271908807285e-05, -3.761800275408453e-07,
  7.988551773135426e-09, -1.481718961647970e-10,  2.470884893277765e-12, -3.776583094638606e-14,  5.363465837687693e-16, -7.149977455193031e-18,  9.017186061385223e-20,
 -1.082364806294970e-21,  4.844130621365680e-03, -3.258403042945711e-04,  1.279363436803890e-05, -3.754415221454410e-07,  9.068060736196424e-09, -1.895956129138840e-10,
  3.538538208040314e-12, -6.017304469603060e-14,  9.459875352950707e-16, -1.389873568290284e-17,  1.924378777661455e-19, -2.527139196980208e-21,  2.850168779145317e-03,
 -2.278896810426730e-04,  1.037361210243919e-05, -3.477436946595357e-07,  9.492972971310202e-09, -2.224994552848925e-10,  4.624414229017877e-12, -8.708774098358116e-14,
  1.509028203294613e-15, -2.433555419413346e-17,  3.684795971835130e-19, -5.274311110371480e-21,  1.612643445319015e-03, -1.511373116740922e-04,  7.905501913052252e-06,
 -3.006199114060605e-07,  9.221232528019258e-09, -2.410429446819480e-10,  5.553111696830621e-12, -1.153190905927523e-13,  2.193636403003026e-15, -3.868366580242145e-17,
  6.382676386373995e-19, -9.923870073584760e-21,  8.796945865591089e-04, -9.545913399719626e-05,  5.690348934286379e-06, -2.438665983960699e-07,  8.359104390544306e-09,
 -2.425170367182614e-10,  6.165985481230592e-12, -1.406337023402442e-13,  2.925854209201652e-15, -5.622205412133387e-17,  1.007476289515245e-18, -1.696103993737463e-20,
  4.639671013967249e-04, -5.766356954375611e-05,  3.887295344762830e-06, -1.866008309130902e-07,  7.110311711421782e-09, -2.279035931148271e-10,  6.368362404516767e-12,
 -1.589212042238182e-13,  3.603335343572754e-15, -7.519716794483927e-17,  1.458847009123792e-18, -2.651278899962259e-20,  2.373384415996999e-04, -3.345570213324367e-05,
  2.532346935872821e-06, -1.353655979153037e-07,  5.705376620852323e-09, -2.011465783765104e-10,  6.152840798858900e-12, -1.673814596582073e-13,  4.122024311050688e-15,
 -9.312364495783839e-17,  1.949986236491414e-18, -3.814591879344833e-20,  1.181599844337048e-04, -1.872432724795185e-05,  1.580670471621368e-06, -9.356875973568788e-08,
  4.341349876497625e-09, -1.676368545839180e-10,  5.591688796261030e-12, -1.652380309236181e-13,  4.405117084353523e-15, -1.074013130532191e-16,  2.420282076729675e-18,
 -5.081981590331562e-20,  5.746776140937993e-05, -1.015432626414784e-05,  9.499653673226072e-07, -6.194231654040854e-08,  3.149081023510721e-09, -1.326309657820010e-10,
  4.806086495390640e-12, -1.537388959934883e-13,  4.422493474071407e-15, -1.160105003301077e-16,  2.805326107202142e-18, -6.305257266925497e-20,  2.741538001082016e-05,
 -5.360683603415253e-06,  5.524280901228468e-07, -3.947427217360206e-08,  2.189024359019334e-09, -1.001529665561520e-10,  3.928001334399337e-12, -1.355493857316665e-13,
  4.193951372629852e-15, -1.180099698574935e-16,  3.053441245464865e-18, -7.326092264087943e-20,  1.288477764069653e-05, -2.768293302854328e-06,  3.124332881541893e-07,
 -2.434385043111450e-08,  1.466029926473799e-09, -7.257168683252317e-11,  3.069286648949318e-12, -1.138708730077667e-13,  3.777375504643276e-15, -1.136680050304629e-16,
  3.137962830930580e-18, -8.014985744241234e-20,  5.993689061021987e-06, -1.405439183109649e-06,  1.727541481412820e-07, -1.460627992623112e-08,  9.510732233901044e-10,
 -5.073646903085993e-11,  2.305453608793188e-12, -9.164156842862194e-14,  3.248801620092984e-15, -1.042320665226908e-16,  3.061200090542840e-18, -8.300706714945419e-20,
  2.773204854598052e-06, -7.051605279420868e-07,  9.389186841325540e-08, -8.573138520527899e-09,  6.009705037122648e-10, -3.441223980875246e-11,  1.673826599654477e-12,
 -7.104039191303766e-14,  2.682706330374377e-15, -9.148265496858067e-17,  2.849907440406913e-18, -8.180819666929109e-20,  1.282838021742105e-06, -3.515435276966574e-07,
  5.043682342597288e-08, -4.949988459604517e-09,  3.719442437783991e-10, -2.276949369503479e-11,  1.181109432661555e-12, -5.333577029072498e-14,  2.138360019672811e-15,
 -7.726139296088467e-17,  2.545346480057852e-18, -7.712576754756647e-20,  5.964374053939950e-07, -1.750954288662832e-07,  2.692861877650634e-08, -2.827279656550840e-09,
  2.267340002825215e-10, -1.477921348760499e-11,  8.144768030134648e-13, -3.899275843381324e-14,  1.654105514983841e-15, -6.311792719208356e-17,  2.192210249248724e-18,
 -6.990799582515156e-20,  2.802168282572626e-07, -8.761570029508585e-08,  1.437001303161344e-08, -1.606431196511199e-09,  1.368929008145019e-10, -9.462165773627408e-12,
  5.518555321654065e-13, -2.790689035812224e-14,  1.248210753558137e-15, -5.013405231615489e-17,  1.829847660297649e-18, -6.122262484370608e-20,  1.337437097129103e-07,
 -4.428705476422837e-08,  7.706638974598804e-09, -9.129789070171421e-10,  8.230406152944577e-11, -6.007396435701003e-12,  3.693206843956010e-13, -1.965298002664921e-14,
  9.234927384739279e-16, -3.890727179685522e-17,  1.487379235454403e-18, -5.204513840039572e-20,  6.518159658925796e-08, -2.273195950745441e-08,  4.175585004836119e-09,
 -5.217041020483967e-10,  4.952950500675046e-11, -3.801218398072743e-12,  2.453295113331416e-13, -1.368420043047741e-14,  6.730233698038181e-16, -2.963610096112407e-17,
  1.182552569524126e-18, -4.313137366974323e-20,  3.258977936141128e-08, -1.190538806576234e-08,  2.296625551413466e-09, -3.011631385933985e-10,  2.997221934901055e-11,
 -2.408033840120639e-12,  1.624701576993683e-13, -9.461019243288301e-15,  4.851463964889405e-16, -2.224532553266385e-17,  9.231789282358130e-19, -3.497568553756274e-20,
  1.678191136803624e-08, -6.387641210631999e-09,  1.287408406737743e-09, -1.763169717050400e-10,  1.830808591578768e-11, -1.532891281913303e-12,  1.076526655056698e-13,
 -6.517400378387095e-15,  3.470489513505393e-16, -1.650634050791153e-17,  7.097773970294624e-19, -2.783179241824417e-20,  8.923866611865967e-09, -3.520605959335829e-09,
  7.375147260313282e-10, -1.049640883272575e-10,  1.131694776422114e-11, -9.828995595825638e-13,  7.152959066168938e-14, -4.482814391767799e-15,  2.468559464887723e-16,
 -1.212980112181101e-17,  5.383470861558147e-19, -2.176650147290352e-20,  4.902953970610792e-09, -1.994593361076469e-09,  4.320325346403936e-10, -6.357232823515961e-11,
  7.082023941034421e-12, -6.350121290562715e-13,  4.766781494571693e-14, -3.078760844045931e-15,  1.745737739766455e-16, -8.825370098427087e-18,  4.026518777268520e-19,
 -1.672132002932642e-20,  2.774868302233611e-09, -1.158173398418680e-09,  2.580229209144946e-10, -3.905212459394028e-11,  4.472494717193185e-12, -4.120038468091044e-13,
  3.175116487503617e-14, -2.103823132048919e-15,  1.222919228542160e-16, -6.333303847576577e-18,  2.958059558063527e-19, -1.256641934611036e-20,  1.602079282537318e-09,
 -6.826280938972387e-10,  1.555924150162032e-10, -2.409509593117937e-11,  2.822425449823961e-12, -2.657879772478143e-13,  2.092700043465071e-14, -1.415846664164105e-15,
  8.398701545955941e-17, -4.436129477082869e-18,  2.112021534055679e-19, -9.140356268630738e-21,  9.209730141874876e-10, -3.986370707472786e-10,  9.246628312523031e-11,
 -1.457359583710766e-11,  1.736939672789554e-12, -1.663612692819487e-13,  1.331653634543522e-14, -9.155361898739447e-16,  5.516381994119586e-17, -2.958285378370580e-18,
  1.429363761505874e-19, -6.275065510429837e-21,  4.941320088097081e-10, -2.162161974526941e-10,  5.076507595265889e-11, -8.099465339083985e-12,  9.770210689422563e-13,
 -9.468600172278163e-14,  7.666742322650901e-15, -5.330263854756204e-16,  3.246747701366743e-17, -1.759642532277696e-18,  8.589920365583140e-20, -3.808808081227869e-21,
  1.929020611395977e-10, -8.491752155861663e-11,  2.007275705458791e-11, -3.224442741699984e-12,  3.915762892027423e-13, -3.819874752605198e-14,  3.112821666212551e-15,
 -2.177703631628592e-16,  1.334540491039731e-17, -7.275588657604862e-19,  3.572087017407258e-20, -1.592702061661437e-21,  7.608417895134541e-02, -2.424974938112645e-04,
  8.087635444927601e-07, -2.795010464351196e-09,  9.902222877095149e-12, -3.563703207530948e-14,  1.293569652454847e-16, -4.713489913714724e-19,  1.718404792574525e-21,
 -6.257011796557586e-24,  2.272488685598146e-26, -8.229049040950913e-29,  7.190427958282686e-02, -3.087979833797262e-04,  1.580775002829385e-06, -8.272000173681384e-09,
  4.236436561671520e-11, -2.111764537609214e-13,  1.027435332284908e-15, -4.896709418285183e-18,  2.292921726695366e-20, -1.057331294328089e-22,  4.809907862696580e-25,
 -2.161570666981629e-27,  6.423197236276189e-02, -4.181633138379762e-04,  3.102410950401695e-06, -2.152046783652355e-08,  1.402016094369141e-10, -8.707951513577676e-13,
  5.207875233655629e-15, -3.018704727371349e-17,  1.703728408238850e-19, -9.395182475289147e-22,  5.075872527928417e-24, -2.692451547576758e-26,  5.425456263184057e-02,
 -5.336421452862984e-04,  5.251990863945043e-06, -4.572555579158634e-08,  3.659202712324378e-10, -2.750958271041814e-12,  1.967969285694323e-14, -1.351200143337152e-16,
  8.959385701412067e-19, -5.763942327427088e-21,  3.610920677317180e-23, -2.209082716737533e-25,  4.335511995693385e-02, -6.188490723559620e-04,  7.732823472536430e-06,
 -8.262279525626997e-08,  7.965985401472924e-10, -7.114242408535480e-12,  5.979391641237485e-14, -4.780594121792818e-16,  3.663896883037851e-18, -2.707320225162222e-20,
  1.937326613528461e-22, -1.347245918602618e-24,  3.280009109483211e-02, -6.503228375678864e-04,  1.008625316332092e-05, -1.302458796809257e-07,  1.490862797153925e-09,
 -1.560014851444201e-11,  1.520698261343050e-13, -1.398603237679646e-15,  1.224657811273682e-17, -1.027859714778977e-19,  8.312108741987768e-22, -6.502978383446190e-24,
  2.351450237039794e-02, -6.230563348067686e-04,  1.181514414323434e-05, -1.820746919011611e-07,  2.445576507049410e-09, -2.966371931647663e-11,  3.320480762949011e-13,
 -3.480189356200134e-15,  3.450693146046868e-17, -3.261666733344491e-19,  2.956412116372898e-21, -2.581545473742864e-23,  1.599213617113886e-02, -5.482807845070039e-04,
  1.255579918420243e-05, -2.284021707182443e-07,  3.565327791207405e-09, -4.969378441676912e-11,  6.336123799681346e-13, -7.510596891976946e-15,  8.372013496680960e-17,
 -8.850880036119363e-19,  8.932799154686767e-21, -8.650576056248855e-23,  1.033152070380394e-02, -4.462081255336752e-04,  1.220173182187126e-05, -2.595192214464534e-07,
  4.669271166657818e-09, -7.423128436326565e-11,  1.070746211786567e-12, -1.426296382559580e-14,  1.776609505177917e-16, -2.088670003390108e-18,  2.334252721080924e-20,
 -2.493654993064594e-22,  6.350168833118694e-03, -3.378701523757869e-04,  1.091719873885829e-05, -2.691761254187817e-07,  5.541571038817227e-09, -9.983562415651654e-11,
  1.619500205655961e-12, -2.410860636975288e-14,  3.338220068151312e-16, -4.342700978183333e-18,  5.348765306948573e-20, -6.274647634914896e-22,  3.720070754816242e-03,
 -2.393067298838206e-04,  9.047254597262299e-06, -2.565903388467971e-07,  6.004819329169947e-09, -1.218822917596419e-10,  2.211727474127701e-12, -3.661487601025316e-14,
  5.609933265278552e-16, -8.040264576246137e-18,  1.086840357304922e-19, -1.394459920030794e-21,  2.081403509181842e-03, -1.593131646431836e-04,  6.982647290699699e-06,
 -2.261661583907306e-07,  5.980431083302346e-09, -1.360363584090793e-10,  2.748220252061843e-12, -5.037114574492729e-14,  8.504166373534266e-16, -1.337527776557860e-17,
  1.976838898029964e-19, -2.764097932962310e-21,  1.114846264760717e-03, -1.001391394095288e-04,  5.044980394198499e-06, -1.853758362952154e-07,  5.507690528577907e-09,
 -1.397129699314879e-10,  3.128300095328362e-12, -6.322159338635168e-14,  1.171670113917603e-15, -2.014971362747773e-17,  3.245048177389282e-19, -4.928542579027606e-21,
  5.731521943737996e-04, -5.969059994185519e-05,  3.429160445618914e-06, -1.420531788195284e-07,  4.717292642350005e-09, -1.328308636976155e-10,  3.282748045560926e-12,
 -7.287183469973244e-14,  1.477206978879133e-15, -2.768467332567479e-17,  4.842741723942210e-19, -7.964887395508459e-21,  2.836613468089703e-04, -3.388716208037003e-05,
  2.203526638964748e-06, -1.023030709094931e-07,  3.778241191379459e-09, -1.175796153320561e-10,  3.194645081260321e-12, -7.761323623729385e-14,  1.715119467939458e-15,
 -3.491801135895217e-17,  6.614469224385073e-19, -1.174697680221010e-20,  1.355903344282120e-04, -1.840317409739863e-05,  1.345123375497589e-06, -6.959999435698073e-08,
  2.845119965488770e-09, -9.744433882926186e-11,  2.899713047972597e-12, -7.683337445700944e-14,  1.844937201935268e-15, -4.067940775981925e-17,  8.320779131209624e-19,
 -1.591271808161163e-20,  6.282468342181715e-05, -9.603638912249339e-06,  7.838975452251568e-07, -4.496394270707404e-08,  2.025145213510308e-09, -7.602649704999851e-11,
  2.468760134327988e-12, -7.110369656269999e-14,  1.849419382044788e-15, -4.403388481869243e-17,  9.698590950198496e-19, -1.991964287339427e-20,  2.832938533198422e-05,
 -4.838415244710013e-06,  4.383330523592930e-07, -2.772948346505705e-08,  1.369954957704444e-09, -5.615035376106839e-11,  1.982555777647429e-12, -6.186197180601954e-14,
  1.737573941465982e-15, -4.454491094752027e-17,  1.053568692745853e-18, -2.317890577141061e-20,  1.248657757311699e-05, -2.365014643535395e-06,  2.364098917880822e-07,
 -1.641291659771757e-08,  8.856099166072786e-10, -3.947678693870468e-11,  1.510215181150560e-12, -5.088675206260251e-14,  1.538783768775660e-15, -4.235359265075248e-17,
  1.072797186296407e-18, -2.521606126776561e-20,  5.405136789958194e-06, -1.127407073655517e-06,  1.236521019538531e-07, -9.375900734144220e-09,  5.501920698849718e-10,
 -2.657053628274406e-11,  1.097476573352909e-12, -3.980285677449183e-14,  1.291864581104631e-15, -3.806620335269236e-17,  1.029781698123007e-18, -2.579301825603755e-20,
  2.309646914871126e-06, -5.270083526088606e-07,  6.307651684925541e-08, -5.199025845939608e-09,  3.303997594234734e-10, -1.722071823606383e-11,  7.652696936153683e-13,
 -2.977579018408054e-14,  1.034094649568468e-15, -3.252599651015531e-17,  9.371620989623332e-19, -2.494715453530903e-20,  9.795625275497062e-07, -2.429620924975716e-07,
  3.156604210991079e-08, -2.815112222596674e-09,  1.929336825339494e-10, -1.081128805022988e-11,  5.150680990716615e-13, -2.142890594597187e-14,  7.938390399527286e-16,
 -2.657438955226135e-17,  8.132050905905029e-19, -2.294463821987322e-20,  4.147411474997331e-07, -1.111350198826785e-07,  1.559223658427756e-08, -1.497601745802216e-09,
  1.102237938425152e-10, -6.614803283611113e-12,  3.366341503192205e-13, -1.492472731538748e-14,  5.878710349349349e-16, -2.088098500600985e-17,  6.766725157309647e-19,
 -2.018012104863882e-20,  1.763623523179394e-07, -5.075233584506960e-08,  7.649965105219815e-09, -7.876795284087925e-10,  6.199396313880824e-11, -3.968704421026260e-12,
  2.149504047315393e-13, -1.012011319027918e-14,  4.224436995594252e-16, -1.587115943938426e-17,  5.430247025346475e-19, -1.706761433359622e-20,  7.579181447304169e-08,
 -2.328723011656403e-08,  3.751871723981255e-09, -4.122079166021545e-10,  3.454316753981211e-11, -2.349448826206359e-12,  1.349126465875326e-13, -6.721018380516855e-15,
  2.963049316474785e-16, -1.173623844879773e-17,  4.226314101043355e-19, -1.395767744456977e-20,  3.312503437170604e-08, -1.080474904312098e-08,  1.851187082038012e-09,
 -2.159970864639435e-10,  1.918782872985234e-11, -1.380806212180878e-12,  8.373584358115148e-14, -4.397519074215781e-15,  2.040253921907478e-16, -8.490679641453232e-18,
  3.207553953640078e-19, -1.109564209176171e-20,  1.481459290285237e-08, -5.101153005726770e-09,  9.246461083164891e-10, -1.140298434606928e-10,  1.068973294509644e-11,
 -8.104369341877421e-13,  5.169197221858393e-14, -2.850669465407111e-15,  1.386696100750210e-16, -6.041677662569952e-18,  2.386141057164527e-19, -8.617137615050151e-21,
  6.819471270344167e-09, -2.465138991092974e-09,  4.702893798216446e-10, -6.099958663019569e-11,  6.006601067905845e-12, -4.776460785657122e-13,  3.190808478093268e-14,
 -1.840325136379318e-15,  9.349739297419759e-17, -4.248837512085679e-18,  1.748036633798237e-19, -6.567418925695459e-21,  3.247595553906264e-09, -1.225708390162878e-09,
  2.448190281561039e-10, -3.323151491219620e-11,  3.420804830406342e-12, -2.840159388257503e-13,  1.978431971584642e-14, -1.188372675497307e-15,  6.280065431895309e-17,
 -2.965024934150111e-18,  1.265925978736859e-19, -4.929952965010099e-21,  1.606242585266320e-09, -6.295374599486581e-10,  1.309484013379769e-10, -1.850633043617400e-11,
  1.981680727508586e-12, -1.709726462789548e-13,  1.236253865356279e-14, -7.699589681161586e-16,  4.214474336485312e-17, -2.058835212391072e-18,  9.086157075368405e-20,
 -3.653766802160432e-21,  8.265703520556568e-10, -3.346206783930245e-10,  7.209500595590022e-11, -1.055257117570190e-11,  1.169502811189221e-12, -1.043382583252728e-13,
  7.794199683457687e-15, -5.010417100358592e-16,  2.828095453615979e-17, -1.423405458959624e-18,  6.466471341936186e-20, -2.674322025889483e-21,  4.417506118223165e-10,
 -1.837447329968066e-10,  4.078131575189023e-11, -6.149109246733054e-12,  7.016433019577976e-13, -6.440365233225214e-14,  4.946043504978511e-15, -3.266202824175415e-16,
  1.892401063477769e-17, -9.769488144942193e-19,  4.549017783131978e-20, -1.926799749896645e-21,  2.430889840494121e-10, -1.033458634873540e-10,  2.349754637549156e-11,
 -3.629834043573074e-12,  4.241557564872455e-13, -3.984835327930989e-14,  3.130283303011204e-15, -2.113120734043863e-16,  1.250780524248016e-17, -6.592692024261408e-19,
  3.132379843074175e-20, -1.352963379262748e-21,  1.345659186077029e-10, -5.816993975443980e-11,  1.347326895222936e-11, -2.120422289854333e-12,  2.523581376738204e-13,
 -2.413663865708286e-14,  1.929408782693422e-15, -1.324749144935182e-16,  7.971760561740103e-18, -4.269706710917366e-19,  2.060509645685823e-20, -9.035264444812118e-22,
  7.029866171066707e-11, -3.074034949139645e-11,  7.212201753979683e-12, -1.149843596556273e-12,  1.386022531730825e-13, -1.342278563635965e-14,  1.086089504681372e-15,
 -7.545863194771837e-17,  4.593268417967348e-18, -2.487816115013752e-19,  1.213698499901933e-20, -5.378318319589778e-22,  2.703441623702305e-11, -1.189742060230676e-11,
  2.811392373899092e-12, -4.514666594471698e-13,  5.480810895210725e-14, -5.344866539214431e-15,  4.354152119885322e-16, -3.045174720580834e-17,  1.865571080601585e-18,
 -1.016757324886838e-19,  4.990485797369392e-21, -2.224486552272259e-22,  7.512692050440778e-02, -2.361589056471981e-04,  7.761510462820889e-07, -2.642112520022165e-09,
  9.219490140360736e-12, -3.268482645062088e-14,  1.168963868440094e-16, -4.197954797579758e-19,  1.508678460751192e-21, -5.416427488830411e-24,  1.939900003181197e-26,
 -6.928445880273938e-29,  7.069376723274844e-02, -2.965376287672899e-04,  1.485442819393731e-06, -7.626663949507350e-09,  3.837672932970744e-11, -1.880837769114334e-13,
  9.000529650284268e-16, -4.220341721122895e-18,  1.944739685510792e-20, -8.826744041671821e-23,  3.952950127532190e-25, -1.749125697825542e-27,  6.260737427329618e-02,
 -3.943401547237541e-04,  2.857071204744176e-06, -1.941005492428074e-08,  1.239701884752265e-10, -7.553628318565519e-13,  4.434146785537357e-15, -2.523929689149727e-17,
  1.399364298738773e-19, -7.583192827446944e-22,  4.027151568970126e-24, -2.100319173612270e-26,  5.220068596524913e-02, -4.937255356270007e-04,  4.736676655449307e-06,
 -4.028655287329434e-08,  3.153337444279589e-10, -2.320988469710139e-12,  1.626840106423821e-14, -1.095091981329560e-16,  7.122528365790390e-19, -4.496639341030434e-21,
  2.765422315111500e-23, -1.661401091151634e-25,  4.099746175920661e-02, -5.607460326848975e-04,  6.813368673190847e-06, -7.094184992945503e-08,  6.676448284171383e-10,
 -5.827417552152879e-12,  4.791318602387150e-14, -3.750219273096866e-16,  2.815559434396580e-18, -2.039093727341175e-20,  1.430788860337245e-22, -9.760474117741056e-25,
  3.035082388290482e-02, -5.755015867086612e-04,  8.656737126833832e-06, -1.087023592642629e-07,  1.212399701217576e-09, -1.237932252615193e-11,  1.178818268664994e-13,
 -1.060021056532738e-15,  9.081681823186944e-18, -7.462515819878697e-20,  5.911469357599887e-22, -4.532477921669607e-24,  2.119836466953516e-02, -5.366520016338935e-04,
  9.846762290942724e-06, -1.472896900574227e-07,  1.924702218675929e-09, -2.274921745885991e-11,  2.484473684270361e-13, -2.543066308941087e-15,  2.464556756178317e-17,
 -2.278522878138161e-19,  2.021268616342399e-21, -1.728296659939546e-23,  1.398382310857226e-02, -4.578984267568933e-04,  1.012694005347607e-05, -1.785481096304436e-07,
  2.707933086696939e-09, -3.673506439926152e-11,  4.564838604924637e-13, -5.279216414163694e-15,  5.746590086277586e-17, -5.937273340751734e-19,  5.860034922075693e-21,
 -5.553019386544188e-23,  8.723847348132576e-03, -3.598855421129804e-04,  9.490936374038975e-06, -1.954166912038232e-07,  3.412323328876817e-09, -5.274683803952309e-11,
  7.408417710138557e-13, -9.620160329556153e-15,  1.169284964662748e-16, -1.342505557269694e-18,  1.466317874022456e-20, -1.531907553197864e-22,  5.154849902486439e-03,
 -2.620847961834720e-04,  8.159446712887715e-06, -1.945823721642688e-07,  3.884535510106797e-09, -6.799193823885105e-11,  1.073166926982282e-12, -1.556335229045614e-14,
  2.101538496635398e-16, -2.668444030449352e-18,  3.210437699744876e-20, -3.681407997657848e-22,  2.890182298540125e-03, -1.777798352404486e-04,  6.472661718601887e-06,
 -1.774455338131766e-07,  4.024394856526032e-09, -7.931505839959646e-11,  1.399673767929114e-12, -2.256221656094816e-14,  3.369580001069913e-16, -4.711773102169266e-18,
  6.219123866315292e-20, -7.797160892169491e-22,  1.540735120095005e-03, -1.128669513297576e-04,  4.763410751693570e-06, -1.490908131280778e-07,  3.819220879435078e-09,
 -8.432438814172216e-11,  1.656069193102324e-12, -2.954589192987220e-14,  4.860853686468617e-16, -7.456996888489064e-18,  1.075917428877737e-19, -1.469731696847977e-21,
  7.827858764980700e-04, -6.736781120079230e-05,  3.268733897776309e-06, -1.160609859844982e-07,  3.340183811911510e-09, -8.222965210105880e-11,  1.789623275307238e-12,
 -3.520004224437149e-14,  6.356107291042748e-16, -1.066069655117047e-17,  1.675882088422987e-19, -2.486487753504587e-21,  3.800368222785122e-04, -3.796994803932300e-05,
  2.101892827918696e-06, -8.415697409896818e-08,  2.707397005640101e-09, -7.399073109779996e-11,  1.777440510092091e-12, -3.840219974275375e-14,  7.585093353949896e-16,
 -1.386462102668341e-17,  2.367490477456671e-19, -3.804089885412250e-21,  1.768394115296902e-04, -2.029673258820749e-05,  1.272713114987060e-06, -5.713869480466838e-08,
  2.045052484502407e-09, -6.178553292125018e-11,  1.632147684118138e-12, -3.860155076503131e-14,  8.313332410509854e-16, -1.651073658305350e-17,  3.053711395302464e-19,
 -5.299361142953293e-21,  7.913429494079986e-05, -1.033586118060327e-05,  7.292466968200152e-07, -3.651468934458076e-08,  1.447381127320753e-09, -4.814937468607902e-11,
  1.393666008929244e-12, -3.596317831958818e-14,  8.419074506222699e-16, -1.811550858752844e-17,  3.619175232083796e-19, -6.765613292367844e-21,  3.418329016811408e-05,
 -5.037463198291722e-06,  3.973986057733976e-07, -2.207961791108293e-08,  9.650545491449836e-10, -3.521379892212389e-11,  1.112929300644000e-12, -3.123462888746898e-14,
  7.924851944080038e-16, -1.842311166451111e-17,  3.965285293926784e-19, -7.964901849485696e-21,  1.431322091464103e-05, -2.361213507977857e-06,  2.070366601409214e-07,
 -1.270136280807224e-08,  6.095614676157513e-10, -2.430537378013356e-11,  8.359279429466053e-13, -2.543613979134190e-14,  6.974174498324082e-16, -1.746886572555111e-17,
  4.040226585030344e-19, -8.698571280867649e-21,  5.836262455424980e-06, -1.069933146962114e-06,  1.036810101423968e-07, -6.989968541052691e-09,  3.668203971610819e-10,
 -1.592428990558138e-11,  5.939947658546244e-13, -1.953604321730453e-14,  5.771837348414901e-16, -1.553493336548030e-17,  3.850924083530876e-19, -8.864989779677735e-21,
  2.329167545845940e-06, -4.712594081286140e-07,  5.019539937374828e-08, -3.701689962274503e-09,  2.115539004369744e-10, -9.962328747245504e-12,  4.016878502238593e-13,
 -1.423549259809914e-14,  4.518893209785273e-16, -1.303375511441419e-17,  3.453974251132661e-19, -8.480710697568534e-21,  9.148027039136906e-07, -2.029483297941049e-07,
  2.363501752623488e-08, -1.897906277094457e-09,  1.176476570006709e-10, -5.987806313880836e-12,  2.601010877537806e-13, -9.901504865499652e-15,  3.367235479745286e-16,
 -1.037897911514888e-17,  2.932645091359645e-19, -7.660955647447859e-21,  3.557152573990342e-07, -8.598726470582436e-08,  1.089254441202418e-08, -9.481402600966380e-10,
  6.349105379597781e-11, -3.479685286200376e-12,  1.622862644151690e-13, -6.615098934374980e-15,  2.402835969346459e-16, -7.892619217860761e-18,  2.371443253537692e-19,
 -6.573956535666870e-21,  1.378157291193588e-07, -3.607985407878031e-08,  4.946247922002352e-09, -4.646101342734789e-10,  3.347259765124608e-11, -1.968033277195477e-12,
  9.820411270226573e-14, -4.272313526153382e-15,  1.652455133305998e-16, -5.767318717822774e-18,  1.837563232038643e-19, -5.391209417105916e-21,  5.356173785985145e-08,
 -1.509661140700175e-08,  2.228498595260184e-09, -2.248683178170354e-10,  1.735766898040698e-11, -1.090648063271456e-12,  5.802042761053855e-14, -2.684899977578665e-15,
  1.102264974866254e-16, -4.075276084789219e-18,  1.372903317334942e-19, -4.251097247150469e-21,  2.103006198858926e-08, -6.344467365516537e-09,  1.003353804305201e-09,
 -1.082632392160395e-10,  8.915952829451804e-12, -5.963429437864256e-13,  3.369607929630349e-14, -1.652783164305724e-15,  7.178212411475018e-17, -2.802407456262112e-18,
  9.951857138129218e-20, -3.242708878421203e-21,  8.402483315110810e-09, -2.697718049091326e-09,  4.547470315738509e-10, -5.222484178431865e-11,  4.568741597382086e-12,
 -3.239546279005906e-13,  1.936762103269844e-14, -1.003247916248834e-15,  4.593367506760630e-17, -1.887275726296050e-18,  7.042090079284822e-20, -2.407147779764415e-21,
  3.441217555759273e-09, -1.169133462673338e-09,  2.089835325736025e-10, -2.542254559538769e-11,  2.351893623534474e-12, -1.760427559274564e-13,  1.109086332822524e-14,
 -6.043945221578267e-16,  2.906470565826389e-17, -1.252345043576569e-18,  4.893355149058142e-20, -1.748963865670822e-21,  1.454805963767845e-09, -5.200763387928287e-10,
  9.806458288579379e-11, -1.257415186348355e-11,  1.224422864241483e-12, -9.632067949679948e-14,  6.367731380911416e-15, -3.635839935322949e-16,  1.829301638005982e-17,
 -8.235205118070816e-19,  3.357450460398928e-20, -1.250393028923445e-21,  6.389573757168891e-10, -2.390042626293610e-10,  4.728520049507694e-11, -6.358347908803825e-12,
  6.485562319844297e-13, -5.337192462406985e-14,  3.686121207411558e-15, -2.195859282608217e-16,  1.151171981762132e-17, -5.393176566240027e-19,  2.285472506903549e-20,
 -8.836397289440471e-22,  2.930826474603898e-10, -1.140696883410646e-10,  2.355006160088262e-11, -3.303581730207819e-12,  3.511986694567396e-13, -3.008815827954075e-14,
  2.160849915033876e-15, -1.336994187199803e-16,  7.271845682796559e-18, -3.530637194121547e-19,  1.548921582761474e-20, -6.192949396366260e-22,  1.408448546383959e-10,
 -5.672240355574639e-11,  1.215219538854059e-11, -1.768763450502604e-12,  1.949538449110390e-13, -1.730065055069619e-14,  1.285733509519943e-15, -8.224052473988829e-17,
  4.619648500309328e-18, -2.314272332395467e-19,  1.046621879491729e-20, -4.309637125806872e-22,  7.087975330333271e-11, -2.937438839293963e-11,  6.493406486139932e-12,
 -9.751819265766040e-13,  1.108382373320592e-13, -1.013516634472412e-14,  7.754888590557591e-16, -5.102796805946985e-17,  2.946287559388253e-18, -1.515927805141656e-19,
  7.035831871541712e-21, -2.970802648904964e-22,  3.708079061021072e-11, -1.572680120189174e-11,  3.566363831693063e-12, -5.494717892055215e-13,  6.404161706771507e-14,
 -6.001438209935079e-15,  4.702929952326093e-16, -3.167242200722970e-17,  1.870431988905390e-18, -9.836903292110149e-20,  4.663745546264906e-21, -2.010216212195114e-22,
  1.972441927601121e-11, -8.514591326244887e-12,  1.969094960587661e-12, -3.094156283479884e-13,  3.676845395005013e-14, -3.511473269051385e-15,  2.802909882317377e-16,
 -1.921803308177933e-17,  1.154882698966334e-18, -6.177426165743798e-20,  2.977331020670139e-21, -1.303930212302865e-22,  1.001737289253080e-11, -4.377389723187717e-12,
  1.026213909785666e-12, -1.634819548928256e-13,  1.969097246596898e-14, -1.905515528531877e-15,  1.540693938647112e-16, -1.069667491861984e-17,  6.506673102250444e-19,
 -3.521768288921902e-20,  1.716985043561553e-21, -7.603680212786111e-23,  3.791472491175091e-12, -1.668067303392002e-12,  3.940351530981526e-13, -6.325422879614422e-14,
  7.676442854926127e-15, -7.483511566749695e-16,  6.094358535559214e-17, -4.260838640314832e-18,  2.609491154925197e-19, -1.421756355343284e-20,  6.976172076685304e-22,
 -3.108662906130350e-23,  7.419450597401558e-02, -2.300740596866248e-04,  7.453096781917976e-07, -2.499681717680405e-09,  8.592924096699789e-12, -3.001508402790536e-14,
  1.057897218366813e-16, -3.744936318369093e-19,  1.326950220699901e-21, -4.698110205030533e-24,  1.659558165084721e-26, -5.847036880121550e-29,  6.953081854544171e-02,
 -2.850100060678902e-04,  1.397486577732392e-06, -7.041594964514323e-09,  3.482184612721613e-11, -1.678330494170612e-13,  7.901390431352374e-16, -3.645959698211879e-18,
  1.653677476100603e-20, -7.389259533846211e-23,  3.258429016249913e-25, -1.419922815626542e-27,  6.107429776621753e-02, -3.723826595733396e-04,  2.635571238820362e-06,
 -1.754183932124294e-08,  1.098723963405975e-10, -6.569418589698660e-13,  3.786245584546832e-15, -2.116875392834803e-17,  1.153269161255291e-19, -6.142894184322645e-22,
  3.207457366285851e-24, -1.645118843698753e-26,  5.029862547562888e-02, -4.576835012135039e-04,  4.282044184727750e-06, -3.559235515719732e-08,  2.725827269813995e-10,
 -1.964908711303947e-12,  1.349834012970692e-14, -8.910719449668626e-17,  5.686414916495115e-19, -3.523851465842680e-21,  2.128016124810010e-23, -1.255776337975490e-25,
  3.885834513468173e-02, -5.094711614669656e-04,  6.022507334942507e-06, -6.113283604292358e-08,  5.617949685651428e-10, -4.793968168603675e-12,  3.857100110747718e-14,
 -2.956434560849253e-16,  2.174932997633581e-18, -1.544230506575108e-20,  1.062768538121468e-22, -7.113679821002650e-25,  2.817950590379775e-02, -5.111534959023616e-04,
  7.461000549660258e-06, -9.114046859091840e-08,  9.908605106350276e-10, -9.875814722850562e-12,  9.189636935832008e-14, -8.081909889475896e-16,  6.776766432722490e-18,
 -5.453317117496501e-20,  4.232704836240762e-22, -3.181317614190170e-24,  1.919880685168141e-02, -4.644568773949195e-04,  8.250029889552615e-06, -1.198330524984001e-07,
  1.524007896478556e-09, -1.755888863620452e-11,  1.871527833324686e-13, -1.871421655640175e-15,  1.773185757474785e-17, -1.603865070504623e-19,  1.392823284049009e-21,
 -1.166479496708713e-23,  1.230166159976222e-02, -3.847688629242159e-04,  8.221878514572654e-06, -1.405502931679321e-07,  2.071810308042023e-09, -2.736371498336324e-11,
  3.314940972831045e-13, -3.741437228236668e-15,  3.978167912692706e-17, -4.017841396294594e-19,  3.879047725766431e-21, -3.597723204797190e-23,  7.422520507072233e-03,
 -2.924842247998459e-04,  7.441602421462817e-06, -1.483774659944868e-07,  2.515379479943253e-09, -3.781710992002239e-11,  5.173322393707622e-13, -6.550521339340124e-15,
  7.771044262691906e-17, -8.715592031491652e-19,  9.305540569000053e-21, -9.509457904994456e-23,  4.223639628360779e-03, -2.051875223201769e-04,  6.156657795260786e-06,
 -1.420446513772719e-07,  2.750539728757306e-09, -4.678592994775450e-11,  7.186993783551666e-13, -1.015617260827882e-14,  1.337680571604237e-16, -1.658214425237948e-18,
  1.949154913193359e-20, -2.185206043774848e-22,  2.270539840198269e-03, -1.335309764077943e-04,  4.682683320736497e-06, -1.241151729750520e-07,  2.728533817680920e-09,
 -5.222644673531613e-11,  8.964586359304494e-13, -1.407338774946951e-14,  2.049117455112231e-16, -2.796066906525085e-18,  3.604241965163496e-20, -4.416277374835999e-22,
  1.155464691526551e-03, -8.099261735076933e-05,  3.291608527746312e-06, -9.956822916280598e-08,  2.471309867297549e-09, -5.296967402247862e-11,  1.011454660303533e-12,
 -1.756776200775874e-14,  2.816811405751988e-16, -4.215478686305313e-18,  5.938306962148565e-20, -7.925920437033903e-22,  5.579288347075437e-04, -4.599167498143025e-05,
  2.149122360253591e-06, -7.373900065579268e-08,  2.055792983128679e-09, -4.912070126711445e-11,  1.039196012255202e-12, -1.989490633419868e-14,  3.500542416379064e-16,
 -5.726591197768342e-18,  8.788065905842027e-20, -1.273834334759055e-21,  2.562997207305490e-04, -2.455696897086177e-05,  1.309701441157307e-06, -5.068092344177080e-08,
  1.579504129128551e-09, -4.189566485845701e-11,  9.783056770576841e-13, -2.057241420314207e-14,  3.959358314212802e-16, -7.058822683312039e-18,  1.176661312614821e-19,
 -1.847130286301627e-21,  1.123502613780407e-04, -1.238314413697042e-05,  7.486018111696068e-07, -3.249491065283822e-08,  1.126988474687470e-09, -3.305301093565664e-11,
  8.488723171445621e-13, -1.954343232152969e-14,  4.101726416129183e-16, -7.946561075589641e-18,  1.434968878542823e-19, -2.433256911363022e-21,  4.715602119343098e-05,
 -5.923786350794566e-06,  4.033085872025148e-07, -1.953758865825018e-08,  7.508076679903540e-10, -2.425614088281364e-11,  6.828144751165885e-13, -1.715759410923164e-14,
  3.915538954008074e-16, -8.221066324415664e-18,  1.604043889092821e-19, -2.930835274201026e-21,  1.902407449163432e-05, -2.700988608393392e-06,  2.058447791873623e-07,
 -1.107438511028785e-08,  4.696009139515353e-10, -1.665098019049211e-11,  5.120882216256064e-13, -1.400190145457874e-14,  3.464795043990501e-16, -7.863182167898773e-18,
  1.653605022203335e-19, -3.247920707755686e-21,  7.408661196746155e-06, -1.179687918436565e-06,  1.000609164947824e-07, -5.950447499914765e-09,  2.773085254518455e-10,
 -1.075348285877071e-11,  3.601516896761662e-13, -1.068410520270433e-14,  2.858880107383081e-16, -6.994958231440252e-18,  1.581639137157024e-19, -3.331734622115456e-21,
  2.798506325556447e-06, -4.961920190857521e-07,  4.658477978400158e-08, -3.048299762783311e-09,  1.555130386426915e-10, -6.572187388827548e-12,  2.389473624064336e-13,
 -7.668319265263189e-15,  2.212826431614277e-16, -5.822343529406393e-18,  1.412082909044143e-19, -3.182809341376648e-21,  1.030788942882051e-06, -2.021445138635205e-07,
  2.089589495009566e-08, -1.497864855440667e-09,  8.332812681011318e-11, -3.824583658752329e-12,  1.504734000507986e-13, -5.208779415251173e-15,  1.616554610933255e-16,
 -4.562358327951820e-18,  1.183959212527704e-19, -2.848826009300395e-21,  3.724014819423545e-07, -8.025767519733974e-08,  9.087947814405819e-09, -7.105166137835610e-10,
  4.293636529289663e-11, -2.132824442206515e-12,  9.051690957280257e-14, -3.369780338333658e-15,  1.121664729294941e-16, -3.386714046798724e-18,  9.380713578945109e-20,
 -2.403893148227027e-21,  1.328100873919540e-07, -3.126145728003420e-08,  3.858242223402280e-09, -3.275710063157283e-10,  2.141921797661761e-11, -1.147466717038022e-12,
  5.236055532899438e-14, -2.090065346815424e-15,  7.440407600614773e-17, -2.396977722358059e-18,  7.068437600398593e-20, -1.924382291183305e-21,  4.708076600831797e-08,
 -1.203153034340616e-08,  1.610449631654667e-09, -1.478347974781685e-10,  1.041873393525673e-11, -5.997840703574912e-13,  2.932920223600254e-14, -1.251368291491415e-15,
  4.750301023407072e-17, -1.628283560158022e-18,  5.098447444332284e-20, -1.470915611097831e-21,  1.671415866734158e-08, -4.610089874079570e-09,  6.659339721450887e-10,
 -6.580502019251671e-11,  4.978443921012114e-12, -3.068368555136240e-13,  1.602335327396999e-14, -7.283790358461085e-16,  2.939400768550435e-17, -1.068909638128266e-18,
  3.543933944067230e-20, -1.080570483148964e-21,  5.989386435068999e-09, -1.772703204847184e-09,  2.749725007929161e-10, -2.911811065565002e-11,  2.355044387862492e-12,
 -1.548022901568777e-13,  8.601969157329603e-15, -4.151857906033442e-16,  1.775438012533917e-17, -6.828450563977234e-19,  2.390130065351050e-20, -7.680213047621722e-22,
  2.184286301277861e-09, -6.897500112937244e-10,  1.143095767391764e-10, -1.291214815330027e-11,  1.111669779500958e-12, -7.762041480891318e-14,  4.572221830447427e-15,
 -2.334819531307565e-16,  1.054368528084840e-17, -4.274867096226199e-19,  1.574755381874042e-20, -5.316616905460480e-22,  8.175378497903704e-10, -2.738582865277701e-10,
  4.824106427066740e-11, -5.785025805910544e-12,  5.278208434955846e-13, -3.898352527678807e-14,  2.424544273528607e-15, -1.304928254336697e-16,  6.200453566669183e-18,
 -2.640908947184469e-19,  1.020420828285477e-20, -3.608012233631566e-22,  3.166466578552059e-10, -1.118760257733604e-10,  2.083699957281076e-11, -2.639671285612466e-12,
  2.540440427371417e-13, -1.975946131035240e-14,  1.292079342065449e-15, -7.300014642925157e-17,  3.635612832444168e-18, -1.620658858630851e-19,  6.544795524286648e-21,
 -2.415171747925184e-22,  1.279075103818555e-10, -4.739226983049244e-11,  9.282303017456888e-12, -1.235845939407191e-12,  1.248469961237582e-13, -1.017862245143744e-14,
  6.966716572819316e-16, -4.114140074412400e-17,  2.138748572771920e-18, -9.938772039722214e-20,  4.178793365591612e-21, -1.603456532763215e-22,  5.424868820944590e-11,
 -2.095805244714221e-11,  4.292618790539319e-12, -5.974483003779773e-13,  6.302924748503581e-14, -5.359963753053005e-15,  3.821848090663754e-16, -2.348361681768890e-17,
  1.268725715390767e-18, -6.120135678586253e-20,  2.668182961086649e-21, -1.060370372818371e-22,  2.427157501704097e-11, -9.720907057401745e-12,  2.070152071935797e-12,
 -2.995230930417430e-13,  3.282222142282748e-14, -2.896337732155332e-15,  2.140751589204135e-16, -1.362094276379686e-17,  7.612227195555033e-19, -3.794650877123249e-20,
  1.707937841140442e-21, -7.000361149585764e-23,  1.146778653700329e-11, -4.734019386040932e-12,  1.042027884049000e-12, -1.558276651659880e-13,  1.763770460646034e-14,
 -1.606305979870875e-15,  1.224255461432033e-16, -8.025240476387136e-18,  4.616696572354034e-19, -2.366969719521080e-20,  1.094806640344901e-21, -4.607393687676977e-23,
  5.688238373938337e-12, -2.406376662221199e-12,  5.441642378267090e-13, -8.360485650719485e-14,  9.717514536906991e-15, -9.082123105387744e-16,  7.098624524915783e-17,
 -4.768649594333725e-18,  2.809304137069109e-19, -1.473979037091637e-20,  6.972301141368011e-22, -2.998653401309991e-23,  2.900953217543268e-12, -1.250422150923267e-12,
  2.886985704474471e-13, -4.529011508181161e-14,  5.373199032183081e-15, -5.123433433056841e-16,  4.083328426792090e-17, -2.795549176653609e-18,  1.677522944872021e-19,
 -8.960443055098211e-21,  4.312794449529106e-22, -1.886318906247732e-23,  1.429896367094499e-12, -6.243776361843210e-13,  1.462559471117690e-13, -2.328018687797140e-14,
  2.801754719502500e-15, -2.709127912125356e-16,  2.188749579362464e-17, -1.518448375149950e-18,  9.229763529726058e-20, -4.992078240431457e-21,  2.432117701396158e-22,
 -1.076337462550602e-23,  5.321368702084182e-13, -2.340415362169268e-13,  5.526631371981730e-14, -8.868677347266159e-15,  1.075905525136762e-15, -1.048495535086948e-16,
  8.535693920344485e-18, -5.965658916505591e-19,  3.652367978857282e-20, -1.989308328669277e-21,  9.757872852668335e-23, -4.346861700317064e-24,  7.328594795495005e-02,
 -2.242292744522182e-04,  7.161190456554463e-07, -2.366862876591091e-09,  8.017186748994337e-12, -2.759731413102283e-14,  9.587383277653979e-17, -3.346140822915063e-19,
  1.169172508509836e-21, -4.082968862369743e-24,  1.422709851713147e-26, -4.945668537841829e-29,  6.841261618867538e-02, -2.741588870424182e-04,  1.316222810805263e-06,
 -6.510302037411891e-09,  3.164684839955495e-11, -1.500373288240665e-13,  6.950779911510081e-16, -3.156946754811594e-18,  1.409694432756154e-20, -6.202656717051140e-23,
  2.693771495553228e-25, -1.156276505028024e-27,  5.962564400166771e-02, -3.521111801038762e-04,  2.435198795353989e-06, -1.588424869008104e-08,  9.759631900119993e-11,
 -5.727872263773626e-13,  3.242031068479972e-15, -1.780871042823016e-17,  9.535755748029747e-20, -4.993678779722660e-22,  2.564186631631520e-24, -1.293694414477973e-26,
  4.853380003192075e-02, -4.250643146511519e-04,  3.879861809904676e-06, -3.152862783626887e-08,  2.363322091892316e-10, -1.668943958527895e-12,  1.124013053643668e-14,
 -7.278634643632178e-17,  4.558609346098842e-19, -2.773618990518526e-21,  1.645108265404008e-23, -9.538043724510257e-26,  3.691238102803981e-02, -4.640796441647662e-04,
  5.339837160863989e-06, -5.286353420265748e-08,  4.745406936225542e-10, -3.960221571732704e-12,  3.118929380811230e-14, -2.341774223329694e-16,  1.688545035790429e-18,
 -1.175676917397500e-20,  7.938046457918026e-23, -5.214784987274250e-25,  2.624770288885700e-02, -4.555849891160083e-04,  6.456287658286848e-06, -7.675427315523858e-08,
  8.136857188269620e-10, -7.919052842885099e-12,  7.202968185755379e-14, -6.197332705138189e-16,  5.087368030467091e-18, -4.010219033398250e-20,  3.050597062156883e-22,
 -2.248177842251108e-24,  1.746442443412219e-02, -4.038192825950258e-04,  6.947493640170906e-06, -9.803102821552597e-08,  1.213812464944553e-09, -1.363687524252985e-11,
  1.419000535118349e-13, -1.386561555084476e-15,  1.284829584987217e-17, -1.137298686603241e-19,  9.670999876000055e-22, -7.934975588411357e-24,  1.088419845423163e-02,
 -3.252156677929345e-04,  6.717417519753164e-06, -1.113804460037313e-07,  1.596299403927263e-09, -2.053349524249231e-11,  2.425784114744638e-13, -2.672749004822966e-15,
  2.776672973120940e-17, -2.742074881392334e-19,  2.590225041221649e-21, -2.351881879713955e-23,  6.361267845916445e-03, -2.394427300338259e-04,  5.879616194077126e-06,
 -1.135651836775491e-07,  1.869678404569472e-09, -2.734772251946320e-11,  3.644834256191354e-13, -4.501423603522405e-15,  5.213494187845581e-17, -5.713109181557925e-19,
  5.964156815830871e-21, -5.963033008773017e-23,  3.491570242593551e-03, -1.620697291896907e-04,  4.688086190267426e-06, -1.046732219106082e-07,  1.966558764245188e-09,
 -3.251612414430780e-11,  4.862532783780558e-13, -6.697244219991902e-15,  8.606072590872212e-17, -1.041727296147926e-18,  1.196596404135949e-20, -1.311819098699904e-22,
  1.802858025632689e-03, -1.013572812293029e-04,  3.424221276210180e-06, -8.776762963511618e-08,  1.870704637929755e-09, -3.478306369596525e-11,  5.808552756767321e-13,
 -8.882542344389480e-15,  1.261138564873283e-16, -1.679555882709470e-18,  2.114740452626969e-20, -2.532825088798369e-22,  8.774454685568213e-04, -5.883953438337530e-05,
  2.302931447609904e-06, -6.733404958989261e-08,  1.619545512533825e-09, -3.370434905218600e-11,  6.258478258380655e-13, -1.058418914619775e-14,  1.654204744391753e-16,
 -2.415334793030456e-18,  3.322399089648510e-20, -4.333325962024256e-22,  4.034449598383121e-04, -3.184570746023350e-05,  1.433112813765211e-06, -4.751936112775659e-08,
  1.283478149941395e-09, -2.976758733563670e-11,  6.122385526509651e-13, -1.140964043621267e-14,  1.956380932027315e-16, -3.121917348595226e-18,  4.677310541539295e-20,
 -6.624124939191785e-22,  1.757072566324600e-04, -1.613868711999349e-05,  8.291648842692830e-07, -3.100926131488555e-08,  9.362355511402632e-10, -2.410283080935769e-11,
  5.471131074308537e-13, -1.119837679835267e-14,  2.100135439845875e-16, -3.652015573408014e-18,  5.943020289547914e-20, -9.114895103335062e-22,  7.270027532039657e-05,
 -7.691419424361082e-06,  4.481736246049282e-07, -1.880705037716175e-08,  6.320058569402685e-10, -1.799284926814112e-11,  4.492363183343756e-13, -1.006781715064886e-14,
  2.059148247621564e-16, -3.891467473838128e-18,  6.860735612761934e-20, -1.136731806007083e-21,  2.867506579889481e-05, -3.462705194830988e-06,  2.274183808745024e-07,
 -1.065623805712700e-08,  3.969469949369417e-10, -1.245241955596977e-11,  3.408787508760090e-13, -8.340002452046416e-15,  1.855207406165257e-16, -3.800531840564800e-18,
  7.241491720967116e-20, -1.293147761712518e-21,  1.082369630385207e-05, -1.479621132529648e-06,  1.088908035167732e-07, -5.670872670902796e-09,  2.332376103272729e-10,
 -8.034641718931204e-12,  2.404033068334204e-13, -6.402989797183430e-15,  1.545046380997326e-16, -3.422535195619796e-18,  7.031420982228280e-20, -1.350287298438656e-21,
  3.926893643591982e-06, -6.031268532149488e-07,  4.946227065107555e-08, -2.850145908048954e-09,  1.289377940710900e-10, -4.861150551804365e-12,  1.585003588358545e-13,
 -4.582982603513881e-15,  1.196532568130343e-16, -2.859163979154942e-18,  6.319098922435804e-20, -1.302131453189943e-21,  1.376139123588763e-06, -2.358095323511054e-07,
  2.143655925027364e-08, -1.360805630578904e-09,  6.746116913487410e-11, -2.774413712696695e-12,  9.828467658360339e-14, -3.076745737982720e-15,  8.669244943374391e-17,
 -2.229291530489494e-18,  5.288369582742363e-20, -1.166808806830898e-21,  4.683906248513199e-07, -8.895753661851732e-08,  8.918542408983913e-09, -6.210668018264431e-10,
  3.361557647230595e-11, -1.503113717798445e-12,  5.768157727442073e-14, -1.949576984891747e-15,  5.913361713899546e-17, -1.632481195793936e-18,  4.147186409953611e-20,
 -9.776079517530522e-22,  1.557940628234570e-07, -3.258919830615873e-08,  3.585527201673094e-09, -2.727597525517798e-10,  1.605944799700919e-11, -7.781864217252251e-13,
  3.225172694364227e-14, -1.173669405433627e-15,  3.822220832298666e-17, -1.130041362098180e-18,  3.067192320209626e-20, -7.707610837018616e-22,  5.098437309707878e-08,
 -1.167561673984151e-08,  1.402868024312377e-09, -1.160946897241935e-10,  7.408018244553521e-12, -3.877053864430516e-13,  1.730053836992853e-14, -6.759300202813038e-16,
  2.357138592596017e-17, -7.444411033050120e-19,  2.153645637759224e-20, -5.755993934424168e-22,  1.653864680713750e-08, -4.121942594563029e-09,  5.382727001775166e-10,
 -4.825469590571108e-11,  3.324538542300530e-12, -1.872770834393326e-13,  8.969151360195371e-15, -3.751072313532858e-16,  1.396821795188515e-17, -4.700082989698292e-19,
  1.445617930498437e-20, -4.099379920825156e-22,  5.361091176461644e-09, -1.445755509623381e-09,  2.042018121656014e-10, -1.974612637496196e-11,  1.463166050070235e-12,
 -8.840019522871039e-14,  4.528874414462913e-15, -2.021189597572146e-16,  8.013464917264079e-18, -2.864792940017531e-19,  9.343057349768064e-21, -2.803891667114131e-22,
  1.751739132756278e-09, -5.082192649454271e-10,  7.726026533307453e-11, -8.023415714452778e-12,  6.368651190178441e-13, -4.111467585829788e-14,  2.245388521900213e-15,
 -1.065847299027283e-16,  4.485220208758707e-18, -1.698542074726159e-19,  5.857150291739228e-21, -1.855151181453830e-22,  5.822880397023386e-10, -1.807020180937258e-10,
  2.941989811684933e-11, -3.266299377931430e-12,  2.765667379668389e-13, -1.900368955073908e-14,  1.102271029693821e-15, -5.545764942227358e-17,  2.468775438127896e-18,
 -9.872186161062827e-20,  3.588503669881518e-21, -1.196054961364071e-22,  1.987888308592703e-10, -6.560767085101951e-11,  1.138096234507516e-11, -1.344484722518883e-12,
  1.209045437049795e-13, -8.805798922191149e-15,  5.403439653371117e-16, -2.870720669465710e-17,  1.347078613385792e-18, -5.668637042434435e-20,  2.164914782498395e-21,
 -7.569129600752437e-23,  7.037131545739797e-11, -2.455682331214525e-11,  4.514839711902966e-12, -5.647248979686032e-13,  5.368433344364810e-14, -4.126189568425731e-15,
  2.667358010793507e-16, -1.490425529771321e-17,  7.343909427862786e-19, -3.240150263892225e-20,  1.295526778404499e-21, -4.735097868792549e-23,  2.607168060061868e-11,
 -9.563424505692752e-12,  1.853294881675106e-12, -2.441778445744058e-13,  2.441769409942821e-14, -1.971268835876598e-15,  1.336478088950528e-16, -7.820463449117195e-18,
  4.029678401753498e-19, -1.856659535456716e-20,  7.742212226027285e-22, -2.947226642925785e-23,  1.019344024083650e-11, -3.907178673420871e-12,  7.935580229134302e-13,
 -1.095323751886852e-13,  1.146218066784159e-14, -9.671219014316394e-16,  6.843851868544532e-17, -4.174568994061742e-18,  2.239453260949461e-19, -1.072918885255334e-20,
  4.646786329389265e-22, -1.834965112172247e-23,  4.232738607953832e-12, -1.685269869778669e-12,  3.566132300234543e-13, -5.127194382045165e-14,  5.583933083624676e-15,
 -4.898075282619559e-16,  3.599404458478489e-17, -2.277419413128412e-18,  1.265902405873218e-19, -6.277566348714835e-21,  2.811240056545619e-22, -1.146648506202266e-23,
  1.871821749223032e-12, -7.694945005190437e-13,  1.686087996217486e-13, -2.510034905885144e-14,  2.828505080953690e-15, -2.564948845695786e-16,  1.946778752415843e-17,
 -1.271028299516152e-18,  7.283470515930839e-20, -3.720189826702521e-21,  1.714465413115408e-22, -7.189870140407936e-24,  8.778182929969351e-13, -3.703480739831123e-13,
  8.349819422989788e-14, -1.279030581971913e-14,  1.482294524049882e-15, -1.381439122373633e-16,  1.076765281253689e-17, -7.214103228533779e-19,  4.238994022611599e-20,
 -2.218546058458651e-21,  1.046890358992990e-22, -4.491957297228255e-24,  4.281911004035433e-13, -1.842752219018258e-13,  4.247106659668454e-14, -6.651027379906630e-15,
  7.877157576793861e-16, -7.498396052768915e-17,  5.966411088433872e-18, -4.078296307960407e-19,  2.443508371474380e-20, -1.303253844707363e-21,  6.263719467776294e-23,
 -2.735795042664279e-24,  2.044766304018551e-13, -8.921710923985888e-14,  2.088027139385852e-14, -3.320690991403109e-15,  3.992982214507197e-16, -3.857718095333532e-17,
  3.114154101814562e-18, -2.158721760585420e-19,  1.311140851344736e-20, -7.086171174305595e-22,  3.449812020835355e-23, -1.525631411598132e-24,  7.474428548632258e-14,
 -3.286284734878699e-14,  7.757322780238866e-15, -1.244362505616316e-15,  1.509037722419780e-16, -1.470052446068643e-17,  1.196322316808809e-18, -8.358222577356636e-20,
  5.115395819654353e-21, -2.785217231493871e-22,  1.365737988581628e-23, -6.082003822331880e-25,  7.240031190459198e-02, -2.186117919814419e-04,  6.884685232834004e-07,
 -2.242881550556191e-09,  7.487512568631054e-12, -2.540467674011064e-14,  8.700708982825282e-17, -2.994466348415499e-19,  1.031925956267360e-21, -3.555092079251280e-24,
  1.222156158100459e-26, -4.192569033487143e-29,  6.733655728147900e-02, -2.639332134246211e-04,  1.241041115208054e-06, -6.027081216685087e-09,  2.880601553704024e-11,
 -1.343672078864689e-13,  6.126774951825892e-16, -2.739587761468004e-18,  1.204628275163092e-20, -5.220329404054566e-23,  2.233281457332412e-25, -9.444404586383732e-28,
  5.825499162180013e-02, -3.333663314667305e-04,  2.253592263709895e-06, -1.441028947510523e-08,  8.687998581963065e-11, -5.006333243468360e-13,  2.783539724312534e-15,
 -1.502617036285833e-17,  7.909719622656630e-20, -4.073327766746761e-22,  2.057388999468088e-24, -1.021265259116466e-26,  4.689331190946251e-02, -3.954769568392857e-04,
  3.523150318831781e-06, -2.800035080045420e-08,  2.054940254354425e-10, -1.422076561072286e-12,  9.392187787407592e-15, -5.967717151181278e-17,  3.669097715001594e-19,
 -2.192385037818915e-21,  1.277494388902033e-23, -7.278671996587334e-26,  3.513765682456569e-02, -4.237750873907865e-04,  4.748542816863893e-06, -4.586597203787414e-08,
  4.023205506581029e-10, -3.284626584263128e-12,  2.532928890928887e-14, -1.863452697821032e-16,  1.317328331020508e-18, -8.996871912251541e-21,  5.961080773054877e-23,
 -3.844322258858556e-25,  2.452312753021946e-02, -4.074090251743089e-04,  5.608412528468239e-06, -6.491400859389516e-08,  6.712759345376632e-10, -6.381429246244052e-12,
  5.675499132009189e-14, -4.778619786847015e-16,  3.841419184416529e-18, -2.967009050145585e-20,  2.212614883257581e-22, -1.599243992802221e-24,  1.595329705783297e-02,
 -3.526342540109737e-04,  5.879212190603723e-06, -8.061930130874770e-08,  9.722112270086117e-10, -1.065423136293822e-11,  1.082663810624109e-13, -1.034091585168644e-15,
  9.373677991917822e-18, -8.122121368996710e-20,  6.764641884235665e-22, -5.438977945196796e-24,  9.682923822376559e-03, -2.764176707673613e-04,  5.521504038299619e-06,
 -8.883244087956021e-08,  1.238269172800953e-09, -1.551770593949982e-11,  1.788285678807847e-13, -1.924022995923157e-15,  1.953511761324246e-17, -1.886804537679158e-19,
  1.744283497503193e-21, -1.550856917722644e-23,  5.489606628413562e-03, -1.973870571852546e-04,  4.679703771294053e-06, -8.759036845003681e-08,  1.400890011773922e-09,
 -1.994155529704485e-11,  2.590088456655859e-13, -3.120822208880970e-15,  3.529667543432963e-17, -3.780142239776458e-19,  3.859365519955588e-21, -3.776006117527627e-23,
  2.911040364974881e-03, -1.291000505542279e-04,  3.601228822695346e-06, -7.783535970042786e-08,  1.419220161397954e-09, -2.281673273297941e-11,  3.322463352004899e-13,
 -4.461181201848643e-15,  5.594289884619537e-17, -6.613773295829352e-19,  7.425413619057767e-21, -7.961818354145510e-23,  1.446200470541158e-03, -7.771586365572129e-05,
  2.529881320799036e-06, -6.272122986160131e-08,  1.296442401889456e-09, -2.342157328656790e-11,  3.806021181004377e-13, -5.670635068846899e-15,  7.852359895664487e-17,
 -1.020854926492908e-18,  1.255740440223333e-20, -1.470369850319391e-22,  6.743773256044924e-04, -4.325398909305883e-05,  1.630546446058371e-06, -4.608885725916532e-08,
  1.074438156336215e-09, -2.171414792380849e-11,  3.921601963539847e-13, -6.458663267201491e-15,  9.840855766446667e-17, -1.402118394484192e-18,  1.883558973755805e-20,
 -2.400983155682415e-22,  2.958195977527256e-04, -2.235317991033844e-05,  9.687650552640294e-07, -3.104527149633103e-08,  8.124448408915933e-10, -1.829229580659396e-11,
  3.657964670608562e-13, -6.636620217696365e-15,  1.109082969394568e-16, -1.726571390354841e-18,  2.525689455454127e-20, -3.495144442676714e-22,  1.223789085037254e-04,
 -1.077163642149151e-05,  5.330739993248651e-07, -1.926686468253448e-08,  5.635514247400107e-10, -1.408219356140380e-11,  3.107461765821114e-13, -6.191204404878581e-15,
  1.131472822810347e-16, -1.919245531488954e-18,  3.049175740416620e-20, -4.569255968536439e-22,  4.788694503670148e-05, -4.860833131079803e-06,  2.729509638892021e-07,
 -1.107194737417514e-08,  3.604925078604018e-10, -9.962057090931035e-12,  2.418022928728364e-13, -5.274960355451075e-15,  1.051371039948314e-16, -1.938178571713717e-18,
  3.336136309851974e-20, -5.400960065707994e-22,  1.778374764168964e-05, -2.063277987901429e-06,  1.306806495526725e-07, -5.921737542935407e-09,  2.137897310784775e-10,
 -6.511611961525151e-12,  1.733248471819937e-13, -4.128631980686171e-15,  8.951455744125737e-17, -1.789094082526901e-18,  3.328787232470535e-20, -5.809318877672849e-22,
  6.292179983173936e-06, -8.276982683020654e-07,  5.879854773490607e-08, -2.963320657413787e-09,  1.181862658346879e-10, -3.954656497023993e-12,  1.151010775321161e-13,
 -2.985776223255569e-15,  7.024652415526159e-17, -1.518662818501921e-18,  3.047652901386994e-20, -5.721461717036407e-22,  2.130402462411930e-06, -3.153995029700854e-07,
  2.499687025959678e-08, -1.395153069805793e-09,  6.124875775497599e-11, -2.244451382834414e-12,  7.122794323716502e-14, -2.006953108921925e-15,  5.111433551554600e-17,
 -1.192610482563940e-18,  2.575898006773004e-20, -5.191443788416948e-22,  6.937053159508805e-07, -1.147961545802153e-07,  1.009893311732349e-08, -6.216445051447161e-10,
  2.993470731499752e-11, -1.197603459724039e-12,  4.132482158452985e-14, -1.261527685072909e-15,  3.469842137935623e-17, -8.718022890715934e-19,  2.022360457292574e-20,
 -4.366779539243943e-22,  2.184715675623660e-07, -4.015165471573673e-08,  3.901657852060064e-09, -2.638095614641355e-10,  1.388573110082281e-11, -6.046337243665071e-13,
  2.262230718776220e-14, -7.462926509207773e-16,  2.211540101509594e-17, -5.970124542090899e-19,  1.484272449706479e-20, -3.426723769015745e-22,  6.697018009633842e-08,
 -1.358570870563142e-08,  1.451297317380810e-09, -1.073585615114972e-10,  6.155292618309619e-12, -2.908096050195595e-13,  1.176449769586693e-14, -4.183129031055514e-16,
  1.332309161340807e-17, -3.855504443687261e-19,  1.025084336953200e-20, -2.525148010759575e-22,  2.012429688886232e-08, -4.479644488099464e-09,  5.236122013529478e-10,
 -4.220794845725804e-11,  2.626710497822295e-12, -1.342250174010114e-13,  5.854102698349760e-15, -2.237580473511593e-16,  7.640297338464373e-18, -2.364532821478108e-19,
  6.708021357641551e-21, -1.759328564355732e-22,  5.975002439793057e-09, -1.451017134607757e-09,  1.847158512195070e-10, -1.615994655354288e-11,  1.087682328555004e-12,
 -5.991926304225085e-14,  2.808987355723333e-15, -1.150914126429983e-16,  4.202042876164004e-18, -1.387311254490136e-19,  4.189525363490348e-21, -1.167227415773511e-22,
  1.768079224033663e-09, -4.657669880477081e-10,  6.427257502015893e-11, -6.077458708782585e-12,  4.407726375711962e-13, -2.608818548606665e-14,  1.310427791129368e-15,
 -5.738498839851662e-17,  2.234045285674838e-18, -7.847571933387453e-20,  2.516355295594717e-21, -7.429294464659470e-23,  5.263936211057647e-10, -1.495679021827751e-10,
  2.226615929643807e-11, -2.265969009594777e-12,  1.763976966384589e-13, -1.117714422710695e-14,  5.995610356162471e-16, -2.797331413638663e-17,  1.157761997847514e-18,
 -4.314792149201318e-20,  1.465085545756421e-21, -4.571815997081195e-23,  1.592797117557762e-10, -4.853615074115782e-11,  7.756939944254620e-12, -8.458360540906061e-13,
  7.038798101735964e-14, -4.756563844711689e-15,  2.715046587041818e-16, -1.345071639694487e-17,  5.899386530611371e-19, -2.325474281631711e-20,  8.336862089283138e-22,
 -2.741868275553449e-23,  4.950824067717714e-11, -1.608603125158560e-11,  2.745902298974231e-12, -3.193353988534986e-13,  2.828479357037518e-14, -2.030204922407776e-15,
  1.228392284078014e-16, -6.438394981906886e-18,  2.982030666829576e-19, -1.239171385988721e-20,  4.675383819884049e-22, -1.615605712242687e-23,  1.598110658584746e-11,
 -5.504236185584695e-12,  9.982631873614784e-13, -1.232082013493247e-13,  1.156208178104350e-14, -8.776490790180786e-16,  5.605717030509109e-17, -3.096178675285765e-18,
  1.508648596556277e-19, -6.584781326591752e-21,  2.605552720627756e-22, -9.428054081727514e-24,  5.415452732341954e-12, -1.965408068830916e-12,  3.766236082606520e-13,
 -4.907651603427629e-14,  4.855339662981453e-15, -3.879405691709905e-16,  2.604010056116711e-17, -1.509132876255175e-18,  7.704176668742904e-20, -3.517945858178546e-21,
  1.454308962682828e-22, -5.490034678299676e-24,  1.945852856344161e-12, -7.396380223402894e-13,  1.488882332375477e-13, -2.037037151064209e-14,  2.113511009089494e-15,
 -1.768559079153363e-16,  1.241544366218820e-17, -7.514782094124149e-19,  4.001341790669675e-20, -1.903270913406176e-21,  8.185834028242757e-23, -3.210872329523376e-24,
  7.474751042105230e-13, -2.957444405776398e-13,  6.215887868417070e-14, -8.877085809676594e-15,  9.604854294883758e-16, -8.371900530831275e-17,  6.114600255257672e-18,
 -3.845997599769999e-19,  2.125602338585132e-20, -1.048269678270757e-21,  4.669392403090196e-23, -1.894769797503367e-24,  3.083938976011965e-13, -1.262162953341746e-13,
  2.752241135825926e-14, -4.077499044404351e-15,  4.573290530554571e-16, -4.128278073716203e-17,  3.119526333542772e-18, -2.028020248548410e-19,  1.157343221824787e-20,
 -5.887831933908759e-22,  2.702981800491739e-23, -1.129325377163113e-24,  1.363306522168325e-13, -5.735057330035368e-14,  1.288897737166374e-14, -1.968063268270292e-15,
  2.273734224244333e-16, -2.112624564244776e-17,  1.641865523528045e-18, -1.096896355680059e-19,  6.427657699722759e-21, -3.355088167622534e-22,  1.579136949529415e-23,
 -6.758906502853567e-25,  6.344469057975886e-14, -2.725783660123634e-14,  6.270542937890856e-15, -9.801381870559744e-16,  1.158699217575203e-16, -1.101015138031402e-17,
  8.745497801316919e-19, -5.967872786709400e-20,  3.569823111803083e-21, -1.900973519272794e-22,  9.122522912474601e-24, -3.978545592799413e-25,  2.929673244239979e-14,
 -1.277214965588230e-14,  2.986415981631962e-15, -4.745026889330073e-16,  5.700462979909824e-17, -5.502435921302143e-18,  4.437991673638199e-19, -3.073797749521091e-20,
  1.865393654895238e-21, -1.007361620217604e-22,  4.900401095442607e-24, -2.165502671391319e-25,  1.050721279459099e-14, -4.618123645899000e-15,  1.089692115727197e-15,
 -1.747302137997691e-16,  2.118125465950583e-17, -2.062611783839582e-18,  1.677911324869582e-19, -1.171855597771176e-20,  7.169387470856736e-22, -3.902184331815885e-23,
  1.912780803793003e-24, -8.515245847152357e-26,  7.153671259924636e-02, -2.132097033980528e-04,  6.622563386837760e-07, -2.127035425572409e-09,  6.999640385233144e-12,
 -2.341350417977543e-14,  7.906629907848178e-17, -2.683818775541236e-19,  9.123153737434502e-22, -3.101186816873557e-24,  1.051961190999061e-26, -3.561886793303321e-29,
  6.630023382607377e-02, -2.542865483390602e-04,  1.171395354268970e-06, -5.586910108742057e-09,  2.625971856341593e-11, -1.205415669342194e-13,  5.410950854073504e-16,
 -2.382529779010938e-18,  1.031823236712249e-20, -4.404834952426608e-23,  1.856617391329702e-25, -7.736910123459989e-28,  5.695652097766202e-02, -3.160063939661019e-04,
  2.088690229483790e-06, -1.309681936959688e-08,  7.750271218325582e-11, -4.386041514155540e-13,  2.396146360734246e-15, -1.271463923189432e-17,  6.581234551642347e-20,
 -3.333617171471228e-22,  1.656591391123836e-24, -8.092260158051688e-27,  4.536572261731620e-02, -3.685819614646713e-04,  3.205973140906809e-06, -2.492827638790151e-08,
  1.791778311589866e-10, -1.215458388582678e-12,  7.874405843613206e-15, -4.910618701472646e-17,  2.964594118483379e-19, -1.740088283106205e-21,  9.963451432566401e-24,
 -5.579946032751568e-26,  3.351519551487186e-02, -3.878836668387823e-04,  4.234708413684069e-06, -3.992304607232977e-08,  3.423078228958045e-10, -2.734855803783203e-12,
  2.065619231058682e-14, -1.489439142331608e-16,  1.032576141806592e-18, -6.919147302690310e-21,  4.499875520238841e-23, -2.849509831283585e-25,  2.297853812620865e-02,
 -3.654842508618787e-04,  4.889903049865745e-06, -5.512492521645430e-08,  5.562525688137631e-10, -5.166909624359528e-12,  4.494666251511074e-14, -3.704470900519220e-16,
  2.916992290581428e-18, -2.208148593067910e-20,  1.614709304423801e-22, -1.144909001576638e-24,  1.463105344660958e-02, -3.092211652075378e-04,  4.998512874410032e-06,
 -6.663668692647896e-08,  7.829295663977046e-10, -8.371923766572088e-12,  8.310634264164633e-14, -7.761295899079384e-16,  6.884132930951009e-18, -5.840536337585468e-20,
  4.765572688373744e-22, -3.755690543577325e-24,  8.659292139704603e-03, -2.361949443265068e-04,  4.564855119604670e-06, -7.128689633484559e-08,  9.668103176659406e-10,
 -1.180747896976360e-11,  1.327753116381631e-13, -1.395343384801501e-15,  1.384977031860955e-17, -1.308640693987929e-19,  1.184262593229061e-21, -1.031288112794073e-23,
  4.768777365672225e-03, -1.638009781639987e-04,  3.750961435328194e-06, -6.805659472007174e-08,  1.057752904761972e-09, -1.465789079103107e-11,  1.855878960497566e-13,
 -2.182242627103428e-15,  2.410815152966223e-17, -2.523908737370887e-19,  2.520648061375000e-21, -2.413917354216618e-23,  2.446846897547971e-03, -1.036723529900116e-04,
  2.789686146884629e-06, -5.838435904795615e-08,  1.033465724098850e-09, -1.615959636203473e-11,  2.291884674546917e-13, -3.000854653800075e-15,  3.673052327848473e-17,
 -4.242114082267985e-19,  4.656098383193911e-21, -4.883883682373456e-23,  1.171502958663147e-03, -6.016742480222954e-05,  1.887698366055438e-06, -4.527857718899023e-08,
  9.078294765215169e-10, -1.593929574793502e-11,  2.521022093796037e-13, -3.660335665255350e-15,  4.944476222005296e-17, -6.276241941324761e-19,  7.543759343730227e-21,
 -8.637100726318722e-23,  5.243202699322085e-04, -3.215959980839198e-05,  1.167797570105129e-06, -3.191636797090077e-08,  7.212839467841545e-10, -1.415847961830094e-11,
  2.487445201106490e-13, -3.990231572858143e-15,  5.928141299445357e-17, -8.243320290019843e-19,  1.081636327322088e-20, -1.347697250498940e-22,  2.198265528508817e-04,
 -1.589723949543273e-05,  6.635319709930372e-07, -2.055256069068969e-08,  5.211903423047356e-10, -1.139318111122123e-11,  2.215471003408709e-13, -3.913668170474132e-15,
  6.375128249362951e-17, -9.683040240181792e-19,  1.383167823500640e-20, -1.870497616077671e-22,  8.654844014063058e-05, -7.297605569462882e-06,  3.478459471099983e-07,
 -1.215030126586948e-08,  3.443163520237838e-10, -8.351696566951022e-12,  1.791703317509349e-13, -3.475018666436151e-15,  6.189174946691620e-17, -1.024115624363858e-18,
  1.588566472555992e-20, -2.326013132540637e-22,  3.209013161793306e-05, -3.123942861034395e-06,  1.690189090724198e-07, -6.626807612072757e-09,  2.090416928104211e-10,
 -5.607310599767812e-12,  1.323131775364764e-13, -2.809724741360252e-15,  5.457452706784869e-17, -9.813974562111661e-19,  1.649272755267626e-20, -2.608935823204758e-22,
  1.124215715239044e-05, -1.252528509529119e-06,  7.648319998105012e-08, -3.351106133227481e-09,  1.172418913670881e-10, -3.466779753430669e-12,  8.972101948177748e-14,
 -2.080622151364130e-15,  4.396626857351936e-17, -8.572870263806658e-19,  1.557502719552925e-20, -2.656242698370582e-22,  3.735485714860254e-06, -4.725631335742883e-07,
  3.239276837395498e-08, -1.579421347941449e-09,  6.107117355809823e-11, -1.984623419472870e-12,  5.618006451585851e-14, -1.419186652837264e-15,  3.255103593465860e-17,
 -6.867263419970847e-19,  1.346019769319339e-20, -2.470059261855386e-22,  1.182403100544349e-06, -1.686232736234149e-07,  1.290926029089804e-08, -6.976309290984141e-10,
  2.971227562333652e-11, -1.058019272349081e-12,  3.267277953886351e-14, -8.969207997461572e-16,  2.227961837933297e-17, -5.074917327772883e-19,  1.071027684866099e-20,
 -2.110816179541789e-22,  3.583314684068269e-07, -5.722323651436258e-08,  4.868975512229306e-09, -2.904937188915957e-10,  1.358252188480527e-11, -5.284386188645495e-13,
  1.775602224662654e-14, -5.284356279947548e-16,  1.418460240882497e-17, -3.481316511361468e-19,  7.895328643001869e-21, -1.668023542466937e-22,  1.045668465416820e-07,
 -1.858192322210367e-08,  1.749038953291705e-09, -1.147649503405936e-10,  5.871703024272516e-12, -2.488752271647270e-13,  9.075339445612312e-15, -2.921149965073488e-16,
  8.454550623223508e-18, -2.231111223223047e-19,  5.426878226146099e-21, -1.226729439456122e-22,  2.957475389662967e-08, -5.813410223309021e-09,  6.025574140577719e-10,
 -4.331830399446695e-11,  2.417206808918455e-12, -1.112938574728788e-13,  4.392768776369813e-15, -1.525534092950698e-16,  4.749971865517776e-18, -1.344948200314382e-19,
  3.501579748569131e-21, -8.452680146022631e-23,  8.167009336149824e-09, -1.765547711025885e-09,  2.006083160494467e-10, -1.574109579194381e-11,  9.548212337818256e-13,
 -4.761321830800883e-14,  2.028634138749044e-15, -7.582157974876279e-17,  2.533839773601641e-18, -7.681052310939148e-20,  2.135995382172945e-21, -5.495307049492691e-23,
  2.220284274024511e-09, -5.249024353635038e-10,  6.508745361015135e-11, -5.552939706218083e-12,  3.649000627739240e-13, -1.964669601386440e-14,  9.010466107695982e-16,
 -3.614948405293115e-17,  1.293412181574716e-18, -4.187891978152304e-20,  1.241180630504607e-21, -3.395983895250768e-23,  5.997267999935045e-10, -1.541865775542302e-10,
  2.077021503524823e-11, -1.919059973036586e-12,  1.361334066111318e-13, -7.888367545546493e-15,  3.882662395386023e-16, -1.667398382346322e-17,  6.370632597687017e-19,
 -2.197742669480880e-20,  6.925401597659892e-22, -2.010589953585004e-23,  1.625924108018929e-10, -4.520450713660329e-11,  6.584661284168683e-12, -6.561737154692088e-13,
  5.006140946187608e-14, -3.111313946686331e-15,  1.638270358044119e-16, -7.508431120633728e-18,  3.054711942112648e-19, -1.119771958629522e-20,  3.742025902586928e-22,
 -1.149888683833454e-23,  4.473379060842109e-11, -1.337347194816484e-11,  2.096361450995479e-12, -2.243452777059296e-13,  1.833549331061410e-14, -1.217748226563150e-15,
  6.836034301295676e-17, -3.332812885633715e-18,  1.439361508264591e-19, -5.590043101509846e-21,  1.975491874374482e-22, -6.407859275625412e-24,  1.263787115288019e-11,
 -4.039277056497790e-12,  6.779819942149382e-13, -7.756246866925234e-14,  6.762097315560079e-15, -4.780243911411845e-16,  2.850222189837486e-17, -1.472950788211450e-18,
  6.730019472178411e-20, -2.760204226345146e-21,  1.028330998228564e-22, -3.510390707108439e-24,  3.711511331399809e-12, -1.260777738194932e-12,  2.254015384843394e-13,
 -2.743213023404022e-14,  2.539599922632535e-15, -1.902704338239373e-16,  1.200081479869845e-17, -6.548389342462994e-19,  3.153665947253382e-20, -1.361032804836754e-21,
  5.327187029818734e-23, -1.907489867315405e-24,  1.147217811479852e-12, -4.116827768265225e-13,  7.795934940159636e-14, -1.004101225902465e-14,  9.822501296459027e-16,
 -7.763102496110320e-17,  5.156426267165324e-18, -2.958236320264142e-19,  1.495502912135272e-20, -6.764801296060617e-22,  2.771210689031938e-23, -1.036998745763125e-24,
  3.776549114688871e-13, -1.422796791901403e-13,  2.837122632810572e-14, -3.845633835974818e-15,  3.954035601632112e-16, -3.279840456029808e-17,  2.283094961210964e-18,
 -1.370677514028305e-19,  7.241119571829968e-21, -3.418225608125694e-22,  1.459408060049784e-23, -5.684156771462682e-25,  1.337593464070471e-13, -5.256980596200441e-14,
  1.096972400717760e-14, -1.555490128964872e-15,  1.671375955680403e-16, -1.447069848752915e-17,  1.050058795513508e-18, -6.563437423002223e-20,  3.605578395015202e-21,
 -1.767774377065345e-22,  7.829999184757118e-24, -3.160050793207451e-25,  5.131531149501806e-14, -2.090228392354857e-14,  4.534427128640627e-15, -6.683470061686662e-16,
  7.458713413110720e-17, -6.700343456059479e-18,  5.039395796935210e-19, -3.261309939624779e-20,  1.853013282856601e-21, -9.387127587974657e-23,  4.291838487400433e-24,
 -1.786101753802347e-25,  2.131671958689249e-14, -8.939554870582604e-15,  2.002241554753879e-15, -3.046923310253074e-16,  3.508488216531564e-17, -3.249393196956795e-18,
  2.517452086033465e-19, -1.676783713248911e-20,  9.797049004529966e-22, -5.099405441683220e-23,  2.393585791577025e-24, -1.021789296664160e-25,  9.438911348110150e-15,
 -4.047941844179137e-15,  9.293528628786786e-16, -1.449756661046906e-16,  1.710521341350327e-17, -1.622273657389826e-18,  1.286213604930552e-19, -8.761345022990073e-21,
  5.231727802982174e-22, -2.781285958416667e-23,  1.332535632054848e-24, -5.802387969943983e-26,  4.206132514878153e-15, -1.832082249713479e-15,  4.279609545508807e-16,
 -6.793026674138669e-17,  8.152911916971694e-18, -7.862228197423399e-19,  6.335431009849426e-20, -4.384047276119235e-21,  2.658225567460386e-22, -1.434296817779592e-23,
  6.971531025657275e-25, -3.078289298070670e-26,  1.478320994279928e-15, -6.495167340134190e-16,  1.531976490524901e-16, -2.455485432615252e-17,  2.975388021606143e-18,
 -2.896241696595248e-19,  2.355130515900851e-20, -1.644190773972360e-21,  1.005531781860003e-22, -5.470923664231252e-24,  2.680776644190413e-25, -1.192995975754574e-26,
  7.069431087415061e-02, -2.080118814179502e-04,  6.373887532760779e-07, -2.018686734560519e-09,  6.549754145251876e-12, -2.160289070881207e-14,  7.194410190202372e-17,
 -2.408958246942170e-19,  8.078839871324370e-22, -2.710121668183748e-24,  9.072180287961889e-27, -3.032532275687020e-29,  6.530141520102463e-02, -2.451765932956483e-04,
  1.106796033699210e-06, -5.185357703140311e-09,  2.397353325858488e-11, -1.083199197424704e-13,  4.787782760265755e-16, -2.076348869225724e-18,  8.858357262114565e-21,
 -3.725996578263409e-23,  1.547622137516243e-25, -6.356326724445254e-28,  5.572494799413511e-02, -2.999050856844523e-04,  1.938688979272939e-06, -1.192394496357021e-08,
  6.927805193621418e-11, -3.851414284671863e-13,  2.067903540277050e-15, -1.078853653842365e-17,  5.492302359688809e-20, -2.737019586254030e-22,  1.338451374312326e-24,
 -6.435457700701262e-27,  4.394086224251115e-02, -3.440837802638644e-04,  2.923264722509850e-06, -2.224608512593798e-08,  1.566524522128602e-10, -1.041955576549146e-12,
  6.623350860184421e-15, -4.054941424193071e-17,  2.404354697371671e-19, -1.386615660842561e-21,  7.803521612792928e-24, -4.296694555408827e-26,  3.202850820835975e-02,
 -3.558331867712514e-04,  3.786771939925083e-06, -3.485811576087436e-08,  2.922487516344363e-10, -2.285636867558193e-12,  1.691325207289848e-14, -1.195626282258918e-16,
  8.130771033078934e-19, -5.346921690542413e-21,  3.414056896422860e-23, -2.123323662882038e-25,  2.159085378294506e-02, -3.288672118586041e-04,  4.278574689298127e-06,
 -4.699632508356645e-08,  4.629129519416670e-10, -4.202804375635061e-12,  3.576979933200495e-14, -2.886679608447253e-16,  2.227124449511637e-18, -1.652779952801527e-20,
  1.185406437108154e-22, -8.247353129261713e-25,  1.346936531543351e-02, -2.722307225365754e-04,  4.268840278791010e-06, -5.534791554539685e-08,  6.337972122933248e-10,
 -6.615076901324535e-12,  6.416718599494404e-14, -5.861003111186963e-16,  5.088252925187827e-18, -4.227935511079212e-20,  3.380531153696535e-22, -2.611948213700217e-24,
  7.782481173870758e-03, -2.028517869573694e-04,  3.794959818689322e-06, -5.754642424391705e-08,  7.596036498873524e-10, -9.043672992135003e-12,  9.926253722827716e-14,
 -1.019205211256128e-15,  9.892233999703440e-18, -9.146375514748822e-20,  8.104360557008722e-22, -6.913979979461194e-24,  4.168795199486291e-03, -1.367930992565556e-04,
  3.026883082334190e-06, -5.325511179773927e-08,  8.046041419521322e-10, -1.085758771837851e-11,  1.340471823054029e-13, -1.538602940120192e-15,  1.660709976248913e-17,
 -1.699978984766809e-19,  1.661163789503895e-21, -1.557438403095599e-23,  2.072722003479246e-03, -8.389896399289726e-05,  2.178516629971757e-06, -4.416192858775754e-08,
  7.591039967481751e-10, -1.154746548149761e-11,  1.595578029247434e-13, -2.037699820684850e-15,  2.435068161464592e-17, -2.747980811427979e-19,  2.949263495044876e-21,
 -3.026880972965259e-23,  9.579144196389393e-04, -4.701453268881253e-05,  1.421964000023832e-06, -3.300672961267014e-08,  6.420889115669025e-10, -1.095888872005536e-11,
  1.687431451220105e-13, -2.388080215545496e-15,  3.147524088032550e-17, -3.901658505244360e-19,  4.583218689748002e-21, -5.131931382465341e-23,  4.121920292575790e-04,
 -2.417260326928100e-05,  8.456552924318549e-07, -2.235127307603323e-08,  4.897647007882639e-10, -9.339666602930793e-12,  1.596490818237052e-13, -2.494910630339698e-15,
  3.614768420612355e-17, -4.906445254777882e-19,  6.289236629145422e-21, -7.660794526825216e-23,  1.654715742536390e-04, -1.144935301359795e-05,  4.602591824564510e-07,
 -1.378101543365990e-08,  3.386892474469086e-10, -7.189274656568053e-12,  1.359616699610398e-13, -2.338857867793639e-15,  3.714096603106666e-17, -5.504681468444772e-19,
  7.679166660702589e-21, -1.014942582282806e-22,  6.211734047420599e-05, -5.015724337623628e-06,  2.302598258947303e-07, -7.773325564310268e-09,  2.134285374191559e-10,
 -5.025545520712177e-12,  1.048253476537642e-13, -1.979316329774147e-15,  3.435839101711812e-17, -5.546420392962020e-19,  8.400512022937938e-21, -1.201949344289590e-22,
  2.186532603266755e-05, -2.040540874360558e-06,  1.063579164702546e-07, -4.030349435690924e-09,  1.231744960203183e-10, -3.207114082666227e-12,  7.357123671254872e-14,
 -1.520831616292602e-15,  2.878777767385393e-17, -5.050002759740980e-19,  8.286047993407340e-21, -1.280771321196108e-22,  7.240013784024086e-06, -7.742234711322566e-07,
  4.556809962278338e-08, -1.930198755569004e-09,  6.543512938305684e-11, -1.878306146378630e-12,  4.726153274063604e-14, -1.066947131016853e-15,  2.197319797135529e-17,
 -4.179781543107774e-19,  7.414690632618412e-21, -1.235716414812383e-22,  2.263482529027180e-06, -2.752219132085394e-07,  1.819760785381258e-08, -8.582163712392223e-10,
  3.216659308776043e-11, -1.015038923015036e-12,  2.794255046298444e-14, -6.873138983492277e-16,  1.536720869297319e-17, -3.163414687503063e-19,  6.055490568706534e-21,
 -1.086132179506639e-22,  6.710306785937698e-07, -9.212229895586358e-08,  6.809523832735688e-09, -3.561919292259819e-10,  1.471334299295013e-11, -5.089955509387630e-13,
  1.529224421147069e-14, -4.089229547153530e-16,  9.905367708959608e-18, -2.202363696002698e-19,  4.540856282858005e-21, -8.750146966913761e-23,  1.895842699135326e-07,
 -2.919516752894692e-08,  2.401395430975027e-09, -1.388070277423048e-10,  6.299568719514224e-12, -2.382680059901285e-13,  7.793792265546509e-15, -2.260711070902963e-16,
  5.920786630385751e-18, -1.419145939167063e-19,  3.145922132127985e-21, -6.501609463920901e-23,  5.133996499665206e-08, -8.814493024928316e-09,  8.031639400094222e-10,
 -5.111658310603228e-11,  2.540985403029779e-12, -1.047957714999126e-13,  3.723122713083210e-15, -1.168892992985910e-16,  3.303160075202632e-18, -8.518775376482473e-20,
  2.026681672326940e-21, -4.484388936103373e-23,  1.341439360891019e-08, -2.552829128044847e-09,  2.565581153541797e-10, -1.791419523706632e-11,  9.724011753718414e-13,
 -4.361115669976429e-14,  1.678732614271258e-15, -5.691783990426912e-17,  1.731893893713358e-18, -4.796466179566897e-20,  1.222403532419838e-21, -2.890739426895866e-23,
  3.407424523137796e-09, -7.147402662203416e-10,  7.888550992430786e-11, -6.021453435164926e-12,  3.557977872770471e-13, -1.730457331641711e-14,  7.198998045944789e-16,
 -2.629855690376091e-17,  8.597750303502966e-19, -2.551847680459435e-20,  6.953367948553422e-22, -1.754137305242648e-23,  8.486772795409533e-10, -1.951402988270316e-10,
  2.355093093586906e-11, -1.958016731249431e-12,  1.255385272066508e-13, -6.602172080138309e-15,  2.960602311429969e-16, -1.162445859875795e-17,  4.073930928248581e-19,
 -1.293054878999731e-20,  3.759362427718822e-22, -1.009722628767903e-23,  2.092729822914795e-10, -5.245972537319695e-11,  6.892861703851230e-12, -6.218333803533483e-13,
  4.311575512314072e-14, -2.444418010172529e-15,  1.178238350063370e-16, -4.959349075917371e-18,  1.858607975925994e-19, -6.293829087421263e-21,  1.948079051099650e-22,
 -5.558902224390201e-24,  5.164366266450277e-11, -1.403620299872820e-11,  1.998860972846976e-12, -1.948997660806775e-13,  1.456236969089794e-14, -8.871303552581982e-16,
  4.582450440640107e-17, -2.061859916149943e-18,  8.241075644271926e-20, -2.969831103474002e-21,  9.762552171585875e-23, -2.952741430086162e-24,  1.290656996149468e-11,
 -3.782108786333158e-12,  5.810232314783851e-13, -6.097696976787302e-14,  4.890954746181268e-15, -3.190337369416799e-16,  1.760235746612832e-17, -8.440255575430751e-19,
  3.587275189520621e-20, -1.371876276893761e-21,  4.776602144578653e-23, -1.527338415974172e-24,  3.308915386370350e-12, -1.039461585323232e-12,  1.714178476915443e-13,
 -1.927690531247172e-14,  1.653053139087441e-15, -1.150139422952402e-16,  6.753662914462982e-18, -3.439224884322708e-19,  1.549307035885566e-20, -6.268081549574202e-22,
  2.304672243798586e-23, -7.768242609947598e-25,  8.822087795163755e-13, -2.953415548538391e-13,  5.201064183193262e-14, -6.237335764482564e-15,  5.692814503314800e-16,
 -4.207094403060037e-17,  2.618742883278704e-18, -1.410913084183596e-19,  6.712231217609334e-21, -2.862835748302364e-22,  1.107856224362640e-23, -3.923609916977488e-25,
  2.480634825881692e-13, -8.796051863987722e-14,  1.644964929852855e-14, -2.092833434532703e-15,  2.023099419706690e-16, -1.580703205353833e-17,  1.038398804330207e-18,
 -5.894174103076780e-20,  2.949299239516891e-21, -1.320951562725706e-22,  5.359850310065889e-24, -1.987304592367306e-25,  7.458084101599116e-14, -2.783365679567713e-14,
  5.494825197167064e-15, -7.374938705056675e-16,  7.510559419388542e-17, -6.172572677154123e-18,  4.258540450979998e-19, -2.534739806995631e-20,  1.327999519754440e-21,
 -6.218907773660129e-23,  2.634709052825044e-24, -1.018562021122137e-25,  2.427277819097050e-14, -9.471779789530242e-15,  1.961395361081541e-15, -2.760250255477207e-16,
  2.944131731010591e-17, -2.530918360703507e-18,  1.823953397892700e-19, -1.132523243732502e-20,  6.181690246424479e-22, -3.012122446958000e-23,  1.326214940039983e-24,
 -5.321665509839805e-26,  8.628732404245171e-15, -3.496947100202634e-15,  7.544427309285589e-16, -1.105942261810290e-16,  1.227668811025460e-17, -1.097167823369976e-18,
  8.210840728471958e-20, -5.288204348025188e-21,  2.990704971647718e-22, -1.508259420795954e-23,  6.865966934429986e-25, -2.845431893526748e-26,  3.357174849050144e-15,
 -1.403220603433886e-15,  3.131446773667631e-16, -4.748046522380339e-17,  5.447975728680531e-18, -5.028340447266449e-19,  3.882744222024290e-20, -2.577849951827858e-21,
  1.501501341280098e-22, -7.791933410510558e-24,  3.646814786610737e-25, -1.552424335977064e-26,  1.410374277177362e-15, -6.036818265572572e-16,  1.383017101210770e-16,
 -2.152858773600196e-17,  2.534789921912285e-18, -2.399141361636051e-19,  1.898409723189068e-20, -1.290683723427285e-21,  7.692951939231620e-23, -4.082425377885146e-24,
  1.952545821457895e-25, -8.487995606543088e-27,  6.051891199719283e-16, -2.633572026885955e-16,  6.145393306925484e-17, -9.744336934438823e-18,  1.168296615783133e-18,
 -1.125507495901436e-19,  9.060522814753800e-21, -6.263813942859246e-22,  3.794495542899442e-23, -2.045557285261062e-24,  9.933965178098647e-26, -4.382661277304953e-27,
  2.081803091602418e-16, -9.143174740352692e-17,  2.155627006105320e-17, -3.453593928489252e-18,  4.183036100322897e-19, -4.070051826073136e-20,  3.308268863418468e-21,
 -2.308673026712914e-22,  1.411348251594139e-23, -7.675928817221941e-25,  3.759814998695382e-26, -1.672570539005137e-27,  6.987231062090694e-02, -2.030079190599326e-04,
  6.137793287011824e-07, -1.917255557541999e-09,  6.134431287903383e-12, -1.995433966033990e-14,  6.554676828354623e-17, -2.165370569864398e-19,  7.165425502877746e-22,
 -2.372554312137747e-24,  7.838602057376548e-27, -2.587257426885723e-29,  6.433803247095203e-02, -2.365647620806773e-04,  1.046803679010247e-06, -4.818507237305598e-09,
  2.191749292757676e-11, -9.749606053325607e-14,  4.244156124765797e-16, -1.813201009973781e-18,  7.622005685660733e-21, -3.159417897211969e-23,  1.293419908665357e-25,
 -5.236698473669451e-28,  5.455546630766071e-02, -2.849496479698777e-04,  1.802006601900370e-06, -1.087452146180034e-08,  6.204804088503228e-11, -3.389468383764973e-13,
  1.789019339313503e-15, -9.178848409028739e-18,  4.596892944324483e-20, -2.254217353374298e-22,  1.085015054396297e-24, -5.135977223527819e-27,  4.260966678942984e-02,
 -3.217243946172654e-04,  2.670689604399503e-06, -1.989809289216666e-08,  1.373152839050620e-10, -8.957944030547892e-13,  5.588587000656138e-15, -3.359743742305660e-17,
  1.957084520653938e-19, -1.109224461737688e-21,  6.136878059124790e-24, -3.322840862059538e-26,  3.066322241247482e-02, -3.271360454707112e-04,  3.395090364676076e-06,
 -3.052687028223761e-08,  2.503384996915474e-10, -1.917120644192583e-12,  1.390259785613789e-14, -9.637766219306328e-17,  6.430734988396070e-19, -4.151267858620836e-21,
  2.602970255848800e-23, -1.590337890517740e-25,  2.034044011175924e-02, -2.967746239248785e-04,  3.756428497637708e-06, -4.021813269844419e-08,  3.868263185752170e-10,
 -3.433787081362110e-12,  2.860153513889551e-14, -2.260713837542371e-16,  1.709398020791941e-18, -1.243944679695797e-20,  8.752755823422782e-23, -5.976736322574071e-25,
  1.244476820222785e-02, -2.405738451200845e-04,  3.661400429746607e-06, -4.618716423307448e-08,  5.156559674137056e-10, -5.254913370289432e-12,  4.982448003173020e-14,
 -4.452286328018279e-16,  3.784231528375560e-18, -3.080379276284947e-20,  2.414130845366592e-22, -1.829139229449602e-24,  7.027694422732814e-03, -1.750606756964671e-04,
  3.171750095758310e-06, -4.671941133891948e-08,  6.004143666161760e-10, -6.970887387134516e-12,  7.470289295622267e-14, -7.496303914488989e-16,  7.116488823860461e-18,
 -6.440300421537457e-20,  5.588842373703792e-22, -4.672054106798223e-24,  3.666294099492456e-03, -1.149308640942805e-04,  2.458426375022128e-06, -4.195749731108563e-08,
  6.164220860508647e-10, -8.102602096360628e-12,  9.757046560295493e-14, -1.093500555969680e-15,  1.153460246255885e-17, -1.154773615628779e-19,  1.104321413733945e-21,
 -1.013857466117554e-23,  1.768896054407584e-03, -6.840041787153927e-05,  1.714450684146039e-06, -3.367372004017931e-08,  5.622461023231498e-10, -8.323080291907769e-12,
  1.120724979087654e-13, -1.396366243807182e-15,  1.629526474976183e-17, -1.797249902500399e-19,  1.886516961525064e-21, -1.894823820853705e-23,  7.903254744308428e-04,
 -3.706382854055515e-05,  1.080946155987179e-06, -2.428752963602275e-08,  4.585307392648166e-10, -7.609448553263817e-12,  1.140950214919530e-13, -1.574216972262148e-15,
  2.024869980442803e-17, -2.451687147522250e-19,  2.815153161178160e-21, -3.083334261084907e-23,  3.275043276291085e-04, -1.835995883096184e-05,  6.189079439086333e-07,
 -1.582279522194618e-08,  3.362407952914689e-10, -6.230403877020106e-12,  1.036417514735098e-13, -1.578152323067782e-15,  2.230268370228658e-17, -2.955426766221057e-19,
  3.701459405035247e-21, -4.408387845879917e-23,  1.261079283023757e-04, -8.346522135512228e-06,  3.231750512320791e-07, -9.355042367309593e-09,  2.228534900543498e-10,
 -4.594138277828467e-12,  8.451058118967229e-14, -1.415895147850632e-15,  2.192226919808481e-17, -3.170869524224825e-19,  4.320496754498154e-21, -5.581586319969180e-23,
  4.522072750932124e-05, -3.495548772889028e-06,  1.545484024919995e-07, -5.042687254404551e-09,  1.341581069758129e-10, -3.066911335685711e-12,  6.220392788109216e-14,
 -1.143579183862022e-15,  1.934934978415560e-17, -3.047536170025333e-19,  4.507286390717645e-21, -6.302365038055416e-23,  1.514016035133217e-05, -1.353947328982707e-06,
  6.797706503695377e-08, -2.489559019772367e-09,  7.371429515047616e-11, -1.863064855378694e-12,  4.155104784063351e-14, -8.361507966042382e-16,  1.542517368775244e-17,
 -2.639728876630712e-19,  4.229020094971275e-21, -6.387516186179325e-23,  4.747326491381176e-06, -4.870296697169001e-07,  2.762277372118025e-08, -1.131024347052767e-09,
  3.715025861312880e-11, -1.035161525366884e-12,  2.532263860366897e-14, -5.565063662879817e-16,  1.116957699456992e-17, -2.072736212046816e-19,  3.590161728633582e-21,
 -5.846822134672726e-23,  1.399112922602399e-06, -1.634211002318016e-07,  1.041937205108913e-08, -4.751835362450284e-10,  1.726114451423389e-11, -5.288445235031087e-13,
  1.415614836100006e-14, -3.390210537350826e-16,  7.388322039881659e-18, -1.483940675461673e-19,  2.773985675772528e-21, -4.862781399498892e-23,  3.891955800027582e-07,
 -5.140241108235936e-08,  3.667090890694082e-09, -1.856080309554056e-10,  7.434185636770918e-12, -2.497990526180227e-13,  7.300192926500821e-15, -1.901238575366158e-16,
  4.490314590935440e-18, -9.743886013392244e-20,  1.962459631676296e-21, -3.697013468703982e-23,  1.026899282086452e-07, -1.523870439346206e-08,  1.211063869940130e-09,
 -6.779362972508211e-11,  2.985372080588339e-12, -1.097408265855627e-13,  3.493583676398144e-15, -9.874500562546642e-17,  2.522691979351256e-18, -5.903973492133143e-20,
  1.279013703157286e-21, -2.585282591608790e-23,  2.584738877688232e-08, -4.284139777418480e-09,  3.776681850121648e-10, -2.330255333015155e-11,  1.124985935008022e-12,
 -4.512855783819004e-14,  1.561534894092304e-15, -4.780370319365675e-17,  1.318589901532447e-18, -3.322435362187718e-20,  7.729166620802617e-22, -1.673640710068791e-23,
  6.247640645061065e-09, -1.150113803126669e-09,  1.119978439383932e-10, -7.591231946086462e-12,  4.006351609131490e-13, -1.749447439916927e-14,  6.564828708330413e-16,
 -2.172243856790581e-17,  6.456999502909109e-19, -1.748520054519377e-20,  4.360737036200164e-22, -1.009916172496636e-23,  1.461348384972243e-09, -2.971614406039963e-10,
  3.183464939536588e-11, -2.362345240327044e-12,  1.358974212769948e-13, -6.443100251984255e-15,  2.615969401272758e-16, -9.336180870744600e-18,  2.984739956434144e-19,
 -8.670264389511367e-21,  2.314033232466460e-22, -5.722128173452338e-24,  3.336962565876308e-10, -7.455646246547569e-11,  8.750731979352019e-12, -7.084841598879564e-13,
  4.429190492144729e-14, -2.273919561490757e-15,  9.964807226117668e-17, -3.827186161143187e-18,  1.313165662132495e-19, -4.083864627903500e-21,  1.164231634584994e-22,
 -3.068355506416968e-24,  7.513914230545922e-11, -1.834787511717219e-11,  2.349510466256252e-12, -2.068014731091265e-13,  1.400567355659042e-14, -7.763999452717558e-16,
  3.662704003028406e-17, -1.510198991217175e-18,  5.548679297481655e-20, -1.843459510818284e-21,  5.601996599738794e-23, -1.570479272263521e-24,  1.687417526829963e-11,
 -4.479133763361576e-12,  6.230727852610163e-13, -5.939823687143235e-14,  4.343295173500187e-15, -2.591787548072267e-16,  1.312521936747242e-17, -5.794414887332535e-19,
  2.274026567548533e-20, -8.051956639587149e-22,  2.602361542322133e-23, -7.743413136946641e-25,  3.827545962911827e-12, -1.098390682383303e-12,  1.652286851169434e-13,
 -1.699178293777629e-14,  1.336601781013440e-15, -8.557094840115896e-17,  4.637338679749389e-18, -2.185584947111532e-19,  9.136429925526484e-21, -3.438693315197702e-22,
  1.179000937762241e-23, -3.714422432868255e-25,  8.892222007136692e-13, -2.743127753858485e-13,  4.440887644155855e-14, -4.905298343420789e-15,  4.134491007583018e-16,
 -2.829349423686630e-17,  1.635150924573906e-18, -8.200255801584922e-20,  3.640012789278399e-21, -1.451890512815630e-22,  5.265789792755055e-24, -1.751662535377840e-25,
  2.147892526090262e-13, -7.080806994808130e-14,  1.227340311120325e-14, -1.449306753401727e-15,  1.303204067021762e-16, -9.493694500828057e-18,  5.828411282446052e-19,
 -3.098758938621884e-20,  1.455454558712832e-21, -6.131612510431528e-23,  2.344765592064289e-24, -8.209746501565252e-26,  5.479652461998636e-14, -1.918574458085450e-14,
  3.540859869784079e-15, -4.447006504382674e-16,  4.245368173501305e-17, -3.277248539235345e-18,  2.128028878524714e-19, -1.194474441635431e-20,  5.912770474307426e-22,
 -2.620874776722698e-23,  1.052833276785542e-24, -3.866159019226148e-26,  1.499926636832956e-14, -5.541777711022576e-15,  1.082481930227943e-15, -1.437771127216924e-16,
  1.449460530289191e-17, -1.179655154615533e-18,  8.062258340781823e-20, -4.755371829682243e-21,  2.469712472791219e-22, -1.146821538230858e-23,  4.819224509827273e-25,
 -1.848526347167173e-26,  4.470071452704158e-15, -1.731091188950495e-15,  3.555622944942326e-16, -4.963700108098483e-17,  5.253148549004592e-18, -4.481861989243603e-19,
  3.206464648133101e-20, -1.976990123956603e-21,  1.071809926698800e-22, -5.188483771250591e-24,  2.270067247550961e-25, -9.053799090378374e-27,  1.467172087790006e-15,
 -5.913782831451160e-16,  1.268384160949518e-16, -1.848533405373162e-17,  2.040387712975315e-18, -1.813507742280182e-19,  1.349987109973663e-20, -8.650192063097292e-22,
  4.867929288805383e-23, -2.443288469868212e-24,  1.107134253284789e-25, -4.567940125407909e-27,  5.327909365541327e-16, -2.219026648221003e-16,  4.932765914413642e-17,
 -7.450369463842055e-18,  8.516399211336373e-19, -7.831650285839769e-20,  6.025974076957390e-21, -3.987107227661491e-22,  2.314667188679168e-23, -1.197346161543390e-24,
  5.586594830471141e-26, -2.371110473213331e-27,  2.117185851609437e-16, -9.043455060056620e-17,  2.067103812560630e-17, -3.210406863253862e-18,  3.771532885648933e-19,
 -3.561973862435919e-20,  2.812633182710546e-21, -1.908361608667770e-22,  1.135221108034390e-23, -6.012850156340970e-25,  2.870550483639895e-26, -1.245659136580070e-27,
  8.727793924417887e-17, -3.794227108786410e-17,  8.843886629562111e-18, -1.400746475604579e-18,  1.677578896660120e-19, -1.614406255150256e-20,  1.298270942092162e-21,
 -8.966269838895014e-23,  5.426264656371475e-24, -2.922438128347257e-25,  1.417932224662156e-26, -6.250043149106054e-28,  2.934401737460241e-17, -1.288262369760031e-17,
  3.035892901903133e-18, -4.861689219655616e-19,  5.885895219424291e-20, -5.724389192890617e-21,  4.650954995770256e-22, -3.244291743438252e-23,  1.982493781128196e-24,
 -1.077786536164620e-25,  5.277112932146151e-27, -2.346641682443986e-28,  6.906995601882444e-02, -1.981880739171075e-04,  5.913482688971812e-07, -1.822213894102643e-09,
  5.750597676591814e-12, -1.845145946578787e-14,  5.979232037069976e-17, -1.949159295275326e-19,  6.365106025398571e-22, -2.080626856203160e-24,  6.785094264546318e-27,
 -2.211922048181934e-29,  6.340816430030584e-02, -2.284158041200036e-04,  9.910230708152224e-07, -4.482890061124694e-09,  2.006545723086206e-11, -8.789277653404189e-14,
  3.768965214491762e-16, -1.586539911092678e-18,  6.572447444133138e-21, -2.685316103946007e-23,  1.083716991760560e-25, -4.326034667433346e-28,  5.344369652355627e-02,
 -2.710391955823509e-04,  1.677252576423187e-06, -9.933735905817581e-09,  5.567847943492199e-11, -2.989354531882132e-13,  1.551442936890097e-15, -7.829731855441716e-18,
  3.858343158202690e-20, -1.862219483733786e-22,  8.824179184315195e-25, -4.112995471770580e-27,  4.136403898123331e-02, -3.012779522824860e-04,  2.444526294548115e-06,
 -1.783739550876412e-08,  1.206679645103301e-10, -7.722846438203537e-13,  4.729854930789029e-15, -2.792902086623510e-17,  1.598640640974211e-19, -8.906591910808920e-22,
  4.845387810203541e-24, -2.580484976299531e-26,  2.940677206536915e-02, -3.013753208867196e-04,  3.051591432220500e-06, -2.681094198268930e-08,  2.151255826512699e-10,
 -1.613647064418694e-12,  1.147101075005721e-14, -7.800241614918039e-17,  5.107977388896932e-19, -3.237587266115909e-21,  1.994031220885205e-23, -1.197082206976873e-25,
  1.921052984665810e-02, -2.685534368498986e-04,  3.308795121282218e-06, -3.454306719713258e-08,  3.245324888632222e-10, -2.817519881570080e-12,  2.297455970905129e-14,
 -1.779083219416997e-16,  1.318737745573443e-18, -9.412641273441535e-21,  6.499056070180671e-23, -4.356534490138962e-25,  1.153773299239468e-02, -2.133669525845750e-04,
  3.153388631580300e-06, -3.871648865914731e-08,  4.215723989492495e-10, -4.196000612643369e-12,  3.889913236293366e-14, -3.401592489443371e-16,  2.831322089544263e-18,
 -2.258352480386488e-20,  1.735212843342502e-22, -1.289570723575471e-24,  6.374866391836345e-03, -1.517758904739692e-04,  2.664453256382401e-06, -3.813741038999721e-08,
  4.773495848750757e-10, -5.406157987190439e-12,  5.658145971782987e-14, -5.550565830643466e-16,  5.155314645678673e-18, -4.567611520556659e-20,  3.882879120148346e-22,
 -3.181375783652657e-24,  3.242938145478822e-03, -9.712128429356806e-05,  2.009150608459405e-06, -3.327363447598504e-08,  4.755071992550156e-10, -6.090174709408143e-12,
  7.155106551146866e-14, -7.831850607625966e-16,  8.075586544341217e-18, -7.908914624663655e-20,  7.403624894195485e-22, -6.657380063216540e-24,  1.520366734592173e-03,
 -5.615998356781801e-05,  1.359287903068613e-06, -2.587563776715996e-08,  4.197958680622002e-10, -6.049091103413115e-12,  7.939694624962422e-14, -9.653636496481031e-16,
  1.100391179283336e-17, -1.186413971841785e-19,  1.218242269323644e-21, -1.197723088128368e-23,  6.576814058513351e-04, -2.946800949743425e-05,  8.289364617596298e-07,
 -1.803353621693616e-08,  3.305006818327839e-10, -5.334324924556781e-12,  7.790233165682227e-14, -1.048145833754123e-15,  1.316011829615409e-17, -1.556695803909584e-19,
  1.747592792764697e-21, -1.872607372265117e-23,  2.628821393596126e-04, -1.408539322062850e-05,  4.576014198278698e-07, -1.131834792712223e-08,  2.333060028956758e-10,
 -4.201510497330381e-12,  6.802928321866385e-14, -1.009531972618253e-15,  1.391846272637043e-17, -1.800972746630767e-19,  2.204215265295991e-21, -2.567202551649355e-23,
  9.725885313108322e-05, -6.155876291003194e-06,  2.295996494064874e-07, -6.426424247240086e-09,  1.484109271796396e-10, -2.971818315561143e-12,  5.318320658022609e-14,
 -8.679494610763065e-16,  1.310443282876333e-17, -1.850061453996749e-19,  2.462480945824366e-21, -3.109912219673966e-23,  3.337403678328659e-05, -2.468903603665706e-06,
  1.051269445498595e-07, -3.315496112080895e-09,  8.547790138827731e-11, -1.897308021057060e-12,  3.742271870025387e-14, -6.699311752613532e-16,  1.104989716004371e-17,
 -1.698191397072411e-19,  2.452829350567359e-21, -3.351986577967399e-23,  1.064776997518719e-05, -9.120949940256528e-07,  4.410525953405788e-08, -1.561096747242532e-09,
  4.478371443434368e-11, -1.098745611945250e-12,  2.382503461091699e-14, -4.667552484595113e-16,  8.392216907022743e-18, -1.401117689618572e-19,  2.191801909760976e-21,
 -3.235054990777296e-23,  3.167646934726696e-06, -3.116143213865326e-07,  1.702776122005826e-08, -6.738760969136062e-10,  2.144502882148570e-11, -5.800308611303071e-13,
  1.379447359527576e-14, -2.951139482734170e-16,  5.772603077570059e-18, -1.045023018977784e-19,  1.767364861646502e-21, -2.812621989821521e-23,  8.817266284539721e-07,
 -9.887808508710153e-08,  6.077211919945329e-09, -2.679640002245319e-10,  9.432443836818034e-12, -2.805547470464751e-13,  7.301828217212516e-15, -1.702450416379821e-16,
  3.616140589670506e-18, -7.085985227664859e-20,  1.293475842202336e-21, -2.215962661380412e-23,  2.305755209382481e-07, -2.927854736162347e-08,  2.015121770257925e-09,
 -9.866406870242154e-11,  3.830956570107325e-12, -1.250082658785853e-13,  3.553033231885898e-15, -9.010978706207563e-17,  2.074755556268095e-18, -4.393462555687457e-20,
  8.642622645868684e-22, -1.591550802452698e-23,  5.691857400613000e-08, -8.133553269591658e-09,  6.242418649148420e-10, -3.382858765530859e-11,  1.445000330155931e-12,
 -5.161027388428270e-14,  1.598659452270060e-15, -4.402044406683828e-17,  1.096811761315437e-18, -2.505901641862494e-20,  5.304299461842198e-22, -1.048448373767259e-23,
  1.333835710348296e-08, -2.132641225582574e-09,  1.817831617077154e-10, -1.086872549527738e-11,  5.093920801863388e-13, -1.986859407183955e-14,  6.693713258058432e-16,
 -1.997532816248112e-17,  5.376736981464317e-19, -1.323290111889179e-20,  3.009502391535801e-22, -6.375820316260604e-24,  2.986932905339582e-09, -5.314460627868022e-10,
  5.011258648852150e-11, -3.295340025947472e-12,  1.690115360727925e-13, -7.182586789127358e-15,  2.626465598811317e-16, -8.478478945944192e-18,  2.461174985436224e-19,
 -6.514536611838220e-21,  1.589414452869189e-22, -3.603856321907689e-24,  6.441259374480816e-10, -1.268635325397812e-10,  1.318213250340748e-11, -9.503740984604772e-13,
  5.319681525779251e-14, -2.457398776351817e-15,  9.732809570195775e-17, -3.392063998667115e-18,  1.060009411955089e-19, -3.012487388946397e-21,  7.872291132841822e-23,
 -1.907468493274048e-24,  1.349665633484035e-10, -2.927398308210204e-11,  3.338838083423699e-12, -2.630608396894731e-13,  1.602550750252896e-14, -8.027024034753632e-16,
  3.435727111120316e-17, -1.290126598388948e-18,  4.331805160894956e-20, -1.319403575963858e-21,  3.686669054303170e-23, -9.530250316571043e-25,  2.776374448288923e-11,
 -6.597587253182602e-12,  8.226814156239899e-13, -7.059672377660769e-14,  4.666884832207747e-15, -2.528002074859328e-16,  1.166536002020768e-17, -4.709045705035189e-19,
  1.695335767948935e-20, -5.523357829620710e-22,  1.647125868692566e-23, -4.534492143705739e-25,  5.673620535629379e-12, -1.469430716872092e-12,  1.994945197928222e-13,
 -1.857938406024373e-14,  1.328583492416571e-15, -7.760730380312468e-17,  3.850653117519753e-18, -1.666951207926789e-19,  6.419892576079409e-21, -2.232346403701925e-22,
  7.089947656059609e-24, -2.074439609141586e-25,  1.167305828845336e-12, -3.277332980111927e-13,  4.823268821642454e-14, -4.856566337036717e-15,  3.743741030418319e-16,
 -2.350772938414625e-17,  1.250485893914659e-18, -5.789286186623628e-20,  2.378925079006482e-21, -8.806916879915628e-23,  2.971883823430525e-24, -9.220417736056556e-26,
  2.454352044926126e-13, -7.428319009430749e-14,  1.179565641223640e-14, -1.278760567919982e-15,  1.058601152864028e-16, -7.120272023531020e-18,  4.047307132531459e-19,
 -1.997630774602566e-20,  8.732408368801660e-22, -3.432066909461682e-23,  1.227180715442727e-24, -4.026678615470083e-26,  5.360640882899922e-14, -1.738756861698260e-14,
  2.964061320129794e-15, -3.443841125035804e-16,  3.048673262981918e-17, -2.187812789122409e-18,  1.323896156520249e-19, -6.941611998715241e-21,  3.217116680217929e-22,
 -1.337988732480442e-23,  5.053458213780354e-25, -1.748358978676350e-26,  1.237626413040652e-14, -4.275541296618507e-15,  7.781531431731250e-16, -9.640593026944903e-17,
  9.083036787978675e-18, -6.923340436394605e-19,  4.441008370670945e-20, -2.463642102811856e-21,  1.205806961034369e-22, -5.286870277964220e-24,  2.101589274453643e-25,
 -7.639658869756030e-27,  3.074673888088765e-15, -1.123927434445303e-15,  2.170810420295213e-16, -2.851617393974332e-17,  2.844193311443381e-18, -2.290990915313862e-19,
  1.550260001553437e-20, -9.056716271566276e-22,  4.660402314151767e-23, -2.144908685156988e-24,  8.936435214491486e-26, -3.399587938492267e-27,  8.360974803062513e-16,
 -3.211694974653674e-16,  6.539821170738454e-17, -9.051979398245135e-18,  9.500664859533860e-19, -8.041022747133996e-20,  5.708493623515392e-21, -3.493517031066952e-22,
  1.880425695998663e-23, -9.040048644980692e-25,  3.928871562684787e-26, -1.556923745326709e-27,  2.524302606565458e-16, -1.011585983610747e-16,  2.156076026456014e-17,
 -3.122792472218633e-18,  3.426132037947855e-19, -3.027412971653920e-20,  2.240940825369677e-21, -1.428109499628175e-22,  7.994639778385594e-24, -3.992353744074584e-25,
  1.800245071137025e-26, -7.392784914655701e-28,  8.524842269159107e-17, -3.536993313974457e-17,  7.829834291849091e-18, -1.177717472948790e-18,  1.340804432138427e-19,
 -1.228183407159436e-20,  9.414438776111535e-22, -6.206385441952198e-23,  3.590360530856449e-24, -1.850934674188149e-25,  8.607788159676150e-27, -3.641849294685975e-28,
  3.193980628242372e-17, -1.361270336861618e-17,  3.103920175253873e-18, -4.808935897491116e-19,  5.636005132213880e-20, -5.310543541711303e-21,  4.183965211006120e-22,
 -2.832659695055677e-23,  1.681529038287161e-24, -8.888428065054324e-26,  4.235062878309520e-27, -1.834317769521629e-28,  1.261795686128133e-17, -5.479524561051990e-18,
  1.275691117950533e-18, -2.018103507854249e-19,  2.414116286330530e-20, -2.320558695210938e-21,  1.864076681633254e-22, -1.286007072702543e-23,  7.774632365119612e-25,
 -4.182976490642789e-26,  2.027543701692060e-27, -8.928666143168374e-29,  4.140276009904833e-18, -1.816905679213478e-18,  4.279667388484822e-19, -6.850209435678449e-20,
  8.289424870894242e-21, -8.058233404200164e-22,  6.544188162562539e-23, -4.562898527395913e-24,  2.787047400250615e-25, -1.514541513042000e-26,  7.412503855461196e-28,
 -3.294883508764620e-29,  6.828652897908226e-02, -1.935432174189841e-04,  5.700218291720477e-07, -1.733080410665079e-09,  5.395488182925745e-12, -1.707970129014655e-14,
  5.460893345768905e-17, -1.756954951190393e-19,  5.662676712927488e-22, -1.827716096554691e-24,  5.883521896799520e-27, -1.894907664215419e-29,  6.251002428624551e-02,
 -2.206974709492905e-04,  9.390982164901184e-07, -4.175428804048105e-09,  1.839457773426470e-11, -7.935743568744458e-14,  3.352782871120028e-16, -1.390888219682740e-18,
  5.679385007306285e-21, -2.287602339429789e-23,  9.102582547109611e-26, -3.583218140183212e-28,  5.238564161610786e-02, -2.580832913462410e-04,  1.563201937682046e-06,
 -9.088758931749704e-09,  5.005505446459005e-11, -2.641980543294182e-13,  1.348534582912954e-15, -6.695852261923258e-18,  3.247348515601608e-20, -1.542929747369331e-22,
  7.199117490676669e-25, -3.304790707119224e-27,  4.019672878851369e-02, -2.825462503045794e-04,  2.241571241822196e-06, -1.602436173965545e-08,  1.062969603150798e-10,
 -6.676025505187211e-13,  4.014895565004216e-15, -2.329109606717907e-17,  1.310318142815434e-19, -7.177690125968047e-22,  3.840466709423481e-24, -2.012139627093492e-26,
  2.824813810570080e-02, -2.781933596031527e-04,  2.749493678941169e-06, -2.361286867223110e-08,  1.854378824992749e-10, -1.362807009606837e-12,  9.499299296440390e-15,
 -6.337753777599247e-17,  4.074173230393771e-19, -2.536101383565720e-21,  1.534608644759581e-23, -9.054337400631372e-26,  1.818675075758882e-02, -2.436569663315150e-04,
  2.923666485630550e-06, -2.977300346668092e-08,  2.733158678696549e-10, -2.321435139152594e-12,  1.853635115400783e-14, -1.406638896135240e-16,  1.022398539123280e-18,
 -7.159364662342148e-21,  4.851879987072387e-23, -3.193526044562541e-25,  1.073193081842102e-02, -1.898896310237751e-04,  2.726648242599205e-06, -3.259502919816806e-08,
  3.462665872083271e-10, -3.367182817864853e-12,  3.052982804722970e-14, -2.613290612400478e-16,  2.130688339924686e-18, -1.665735025675106e-20,  1.255088393927759e-22,
 -9.151071654575244e-25,  5.807668680548745e-03, -1.321687839731360e-04,  2.249287156457580e-06, -3.129598729806792e-08,  3.816373717520530e-10, -4.217478954330713e-12,
  4.312214148023389e-14, -4.136522491137506e-16,  3.759802137562589e-18, -3.262116495694101e-20,  2.717159633089068e-22, -2.182473256539978e-24,  2.884241732742462e-03,
 -8.252456180140910e-05,  1.651779225077336e-06, -2.655360700088164e-08,  3.692401507192613e-10, -4.609337808851886e-12,  5.284937200811023e-14, -5.651336488342248e-16,
  5.697654413793716e-18, -5.459981978317582e-20,  5.004335065993751e-22, -4.408360488588870e-24,  1.315658732491966e-03, -4.642209133304093e-05,  1.085400134029206e-06,
 -2.003174665945630e-08,  3.158699096988401e-10, -4.431770542052103e-12,  5.671594963776126e-14, -6.731134952279721e-16,  7.496210840341404e-18, -7.902618545578415e-20,
  7.939748612924148e-22, -7.642453624341179e-24,  5.518187996269188e-04, -2.361972582076963e-05,  6.410451584877728e-07, -1.350661673579653e-08,  2.403591471128027e-10,
 -3.773991921458379e-12,  5.369509164973778e-14, -7.046587112247231e-16,  8.638072560786220e-18, -9.984502283761668e-20,  1.096093165974229e-21, -1.149271441692930e-23,
  2.130838363452071e-04, -1.091025756796904e-05,  3.416687433886297e-07, -8.177759794108768e-09,  1.635499403973003e-10, -2.863114218606616e-12,  4.513279069911035e-14,
 -6.528498116589329e-16,  8.782740520308333e-18, -1.109882759523747e-19,  1.327676956566757e-21, -1.512405735061166e-23,  7.587208976176818e-05, -4.591284098203383e-06,
  1.649725689203531e-07, -4.465472427095557e-09,  9.999107958388651e-11, -1.945202000040456e-12,  3.387161241692714e-14, -5.385507546289522e-16,  7.930262552006019e-18,
 -1.092936619592922e-19,  1.421262177522788e-21, -1.754924435463486e-23,  2.495786105624780e-05, -1.766377710866540e-06,  7.243687879761985e-08, -2.208344851133504e-09,
  5.517857280067691e-11, -1.189340268718746e-12,  2.281588072382835e-14, -3.977683976999543e-16,  6.396408322443330e-18, -9.593082075090701e-20,  1.353313633596641e-21,
 -1.807683496064217e-23,  7.601655637023025e-06, -6.234926728531281e-07,  2.903585381435753e-08, -9.932405661889577e-10,  2.760726575721807e-11, -6.575464976347145e-13,
  1.386352792651586e-14, -2.644307729521680e-16,  4.634157090513097e-18, -7.548584518346735e-20,  1.153095277940113e-21, -1.663253695296940e-23,  2.149623611981969e-06,
 -2.026825808150688e-07,  1.066855752685383e-08, -4.080466857297935e-10,  1.258049515693539e-11, -3.302903479851850e-13,  7.636677832026020e-15, -1.590438613660447e-16,
  3.031936050583373e-18, -5.354601921156887e-20,  8.842269692044018e-22, -1.375096237228336e-23,  5.662133813754017e-07, -6.092880524140441e-08,  3.608913765439913e-09,
 -1.538245770545748e-10,  5.246410916162355e-12, -1.514794952322392e-13,  3.832977983113938e-15, -8.699959472333686e-17,  1.801024580207479e-18, -3.443027663593472e-20,
  6.136937194834270e-22, -1.027453618456387e-23,  1.394586902726821e-07, -1.701510886666085e-08,  1.129371739395047e-09, -5.347641763942559e-11,  2.012492437269379e-12,
 -6.376300087280163e-14,  1.762324874843699e-15, -4.351871063045992e-17,  9.767371204056378e-19, -2.018168969062405e-20,  3.877250166375287e-22, -6.978826080511365e-24,
  3.226754138544787e-08, -4.437078155197189e-09,  3.287148122661352e-10, -1.723869134591758e-11,  7.140638816526809e-13, -2.477404861476843e-14,  7.465174131803920e-16,
 -2.002204379346444e-17,  4.864485753108071e-19, -1.084795417183620e-20,  2.243241552258096e-22, -4.335256797806129e-24,  7.052230668928852e-09, -1.086868864908634e-09,
  8.952801418617870e-11, -5.184670892227755e-12,  2.358092802942248e-13, -8.940123917620945e-15,  2.931671799191058e-16, -8.525941730363583e-18,  2.238904427608556e-19,
 -5.380956915820224e-21,  1.196095901726538e-22, -2.478714293523634e-24,  1.465392549003502e-09, -2.517871155641946e-10,  2.297523734941642e-11, -1.464980224433822e-12,
  7.298375777437788e-14, -3.017344439599558e-15,  1.074786366400024e-16, -3.383609894269572e-18,  9.588884652388167e-20, -2.480157363244757e-21,  5.917969269198029e-23,
 -1.313374583667892e-24,  2.917324328131781e-10, -5.560177731492568e-11,  5.599710448777049e-12, -3.919877321963487e-13,  2.133785255625091e-14, -9.599186119220319e-16,
  3.707038761445883e-17, -1.261135167249990e-18,  3.850762162842194e-20, -1.070267269234801e-21,  2.737505784747840e-23, -6.497319600566937e-25,  5.614855450047256e-11,
 -1.181151059294342e-11,  1.308071695798536e-12, -1.002233016732886e-13,  5.945906371131769e-15, -2.904083389841274e-16,  1.213440616513479e-17, -4.452721232726991e-19,
  1.462384977244939e-20, -4.360547099758709e-22,  1.193736797580782e-23, -3.025610004978978e-25,  1.055828609372038e-11, -2.439290082587014e-12,  2.959378432182554e-13,
 -2.474033609585604e-14,  1.595313404010060e-15, -8.439071703087563e-17,  3.806874629873003e-18, -1.503732402461632e-19,  5.301992530690287e-21, -1.693089876756736e-22,
  4.952426401285020e-24, -1.338262027428035e-25,  1.963606290993312e-12, -4.957130175936942e-13,  6.562510776210259e-14, -5.966134884242532e-15,  4.169154269655603e-16,
 -2.382342462772952e-17,  1.157414029533791e-18, -4.910290936529265e-20,  1.854768280531055e-21, -6.330271743851860e-23,  1.974698494544231e-24, -5.678620812228345e-26,
  3.662755484744590e-13, -1.005119241708568e-13,  1.445925845068048e-14, -1.424346536740895e-15,  1.075175353857831e-16, -6.616992319257504e-18,  3.452781808315805e-19,
 -1.569255955729264e-20,  6.334930148517902e-22, -2.305521742351868e-23,  7.653035118191259e-25, -2.337080125150122e-26,  6.962160041745801e-14, -2.065407667014410e-14,
  3.214146795442707e-15, -3.417058501275928e-16,  2.776219903615543e-17, -1.834045575025406e-18,  1.024680106873021e-19, -4.974425999279779e-21,  2.140155291414735e-22,
 -8.283436623966315e-24,  2.918439207004803e-25, -9.440940544734500e-27,  1.372533698916066e-14, -4.376379829787702e-15,  7.331066028416728e-16, -8.374213428234632e-17,
  7.293038770984965e-18, -5.152094335883251e-19,  3.070948233545067e-20, -1.587006357201362e-21,  7.253124140995536e-23, -2.976301053831368e-24,  1.109665742418500e-25,
 -3.791610106908163e-27,  2.860553791301493e-15, -9.742820871611984e-16,  1.747308892626961e-16, -2.133893818132359e-17,  1.982814295407651e-18, -1.491336074462011e-19,
  9.444352109230282e-21, -5.175011017717736e-22,  2.502972861161292e-23, -1.084957132206806e-24,  4.265578690812814e-26, -1.534264568667331e-27,  6.429861144454472e-16,
 -2.323845489001583e-16,  4.435177152037649e-17, -5.758396390511587e-18,  5.678786699409034e-19, -4.524636629603507e-20,  3.029739168112594e-21, -1.752194610670689e-22,
  8.929124826040172e-24, -4.071208858740142e-25,  1.680952579480984e-26, -6.339312938413800e-28,  1.589684831735880e-16, -6.053726384099904e-17,  1.221373739011083e-17,
 -1.675256207537541e-18,  1.742872682708957e-19, -1.462613870989535e-20,  1.029865420219405e-21, -6.253064431194511e-23,  3.340280287689665e-24, -1.594095599432477e-25,
  6.879279575947301e-27, -2.707635132607235e-28,  4.397828423766177e-17, -1.751452602595556e-17,  3.708088382271907e-18, -5.335211065195732e-19,  5.815880862875749e-20,
 -5.107154605089742e-21,  3.757758330233705e-22, -2.380919692146530e-23,  1.325432473905538e-24, -6.583401559968862e-26,  2.953242183641273e-27, -1.206720806391275e-28,
  1.375928388804994e-17, -5.685450132191580e-18,  1.252983033067727e-18, -1.876331090517243e-19,  2.126959074586594e-20, -1.940178913251137e-21,  1.481220313040391e-22,
 -9.726844287917167e-24,  5.605817956650583e-25, -2.879501840092888e-26,  1.334438499224589e-27, -5.626866808884414e-29,  4.843976555276031e-18, -2.059586429226848e-18,
  4.683905345621342e-19, -7.237892408071508e-20,  8.461095264179300e-21, -7.952787195622262e-22,  6.250698350381004e-23, -4.222113305722705e-24,  2.500742867446651e-25,
 -1.319021694696559e-26,  6.271639461938361e-28, -2.710960242522424e-29,  1.829011477979403e-18, -7.933646217612549e-19,  1.844687706229791e-19, -2.914521361098161e-20,
  3.482084967909016e-21, -3.343070588305034e-22,  2.682279931762655e-23, -1.848360659105648e-24,  1.116199245296770e-25, -5.999027570727320e-27,  2.904783828156201e-28,
 -1.277890563830890e-29,  5.847782350569789e-19, -2.565091545957382e-19,  6.039002540821908e-20, -9.661428758852741e-21,  1.168548130494608e-21, -1.135404650135600e-22,
  9.216365757146817e-24, -6.423067566733249e-25,  3.921466126518716e-26, -2.130062495228678e-27,  1.042047865894307e-28, -4.629982177726719e-30,  6.752134678277445e-02,
 -1.890647885791901e-04,  5.497317846917342e-07, -1.649415778440443e-09,  5.066612153973600e-12, -1.582613216232665e-14,  4.993357054079089e-17, -1.585838543091134e-19,
  5.045126357511954e-22, -1.608228334430041e-24,  5.110395335696226e-27, -1.626648224917647e-29,  6.164194954930831e-02, -2.133802203219162e-04,  8.907079553008331e-07,
 -3.893388428405680e-09,  1.688484427130055e-11, -7.175829514894199e-14,  2.987588134828141e-16, -1.221651467255054e-18,  4.917759622140662e-21, -1.953154492842259e-23,
  7.664032763710463e-26, -2.975627077175860e-28,  5.137764764175064e-02, -2.460007117630670e-04,  1.458773271997357e-06, -8.328452955663626e-09,  4.508014127170890e-11,
 -2.339705470937001e-13,  1.174801843926733e-15, -5.740288046819070e-18,  2.740406569148173e-20, -1.282053387830008e-22,  5.891326535981557e-25, -2.664041221044149e-27,
  3.910123059737430e-02, -2.653549187692215e-04,  2.059059164397810e-06, -1.442540486140135e-08,  9.385801116641489e-11, -5.786199113861300e-13,  3.417764324534558e-15,
 -1.948351265563816e-17,  1.077565207040854e-19, -5.804877379058282e-22,  3.055385835950585e-24, -1.575179806315531e-26,  2.717763056306183e-02, -2.572823826438996e-04,
  2.483080376959824e-06, -2.085210247698659e-08,  1.603251045387689e-10, -1.154725768492896e-12,  7.894327410294263e-15, -5.168987858127323e-17,  3.262700645061349e-19,
 -1.995074554569796e-21,  1.186334953339414e-23, -6.880606459975253e-26,  1.725673929892987e-02, -2.216257746266622e-04,  2.591171412467430e-06, -2.574848333179756e-08,
  2.310350063265409e-10, -1.920354192732198e-12,  1.501956969844458e-14, -1.117222119739784e-16,  7.964553099501655e-19, -5.472943790755452e-21,  3.641273903259045e-23,
 -2.353854397043460e-25,  1.001364797392020e-02, -1.695516932540910e-04,  2.366649623090312e-06, -2.755605816725900e-08,  2.856949824508111e-10, -2.715090242668359e-12,
  2.408349049498045e-14, -2.018463433246285e-16,  1.612462078957706e-18, -1.235847999519727e-20,  9.133607097559706e-23, -6.534955324693819e-25,  5.312742178537408e-03,
 -1.155789525874614e-04,  1.907760908368813e-06, -2.581206127745772e-08,  3.067648607089007e-10, -3.308953784252794e-12,  3.306165795860911e-14, -3.102051328379167e-16,
  2.759951239923846e-18, -2.345536157072913e-20,  1.914739843077392e-22, -1.508040032893259e-24,  2.578686963253236e-03, -7.049105155132278e-05,  1.365750212212138e-06,
 -2.131937443762051e-08,  2.885547657684322e-10, -3.511921994976442e-12,  3.930817732320454e-14, -4.107447818726403e-16,  4.050054508663719e-18, -3.798494004464842e-20,
  3.409514764481719e-22, -2.942990882806481e-24,  1.145927338044931e-03, -3.862078322282306e-05,  8.726408806382941e-07, -1.561890579540851e-08,  2.394493882048906e-10,
 -3.272072418246039e-12,  4.083954985852937e-14, -4.732267453235684e-16,  5.150193614152746e-18, -5.309957166709920e-20,  5.221057064453738e-22, -4.921264612554014e-24,
  4.666553858192233e-04, -1.907961719290352e-05,  4.997591452101801e-07, -1.020087682895786e-08,  1.763163271292695e-10, -2.693881296395631e-12,  3.734918909946481e-14,
 -4.781885616456595e-16,  5.724435121903706e-18, -6.466933663256724e-20,  6.943685814412994e-22, -7.125504562599585e-24,  1.743455083352560e-04, -8.528952765437175e-06,
  2.575217027995626e-07, -5.965893546521995e-09,  1.157885653715924e-10, -1.970881689401523e-12,  3.025316376847236e-14, -4.266560899692153e-16,  5.601765916750185e-18,
 -6.914862403961041e-20,  8.086182776042396e-22, -9.010761479326608e-24,  5.984196971605964e-05, -3.461341905903031e-06,  1.198324226036744e-07, -3.137332967282096e-09,
  6.812888366083136e-11, -1.287838202399216e-12,  2.182371830940790e-14, -3.381151910339077e-16,  4.856614684116967e-18, -6.535035272116913e-20,  8.303927842156018e-22,
 -1.002621856031755e-23,  1.890253362446658e-05, -1.279506404217184e-06,  5.053586592891819e-08, -1.489438333695747e-09,  3.607268086006813e-11, -7.551326400172257e-13,
  1.409112504086574e-14, -2.392727380210229e-16,  3.751726503946037e-18, -5.491593863115199e-20,  7.567410686893766e-22, -9.881124274380460e-24,  5.506189840004471e-06,
 -4.322656085960086e-07,  1.938562639353402e-08, -6.408989058635548e-10,  1.726085579672179e-11, -3.991383459930935e-13,  8.183071859117498e-15, -1.519750868242265e-16,
  2.596193159522246e-18, -4.126310132230966e-20,  6.155538375243633e-22, -8.677641541667042e-24,  1.482820870943517e-06, -1.339425986872486e-07,  6.790282956248549e-09,
 -2.509844703605975e-10,  7.496684724525848e-12, -1.910488687946656e-13,  4.294536211608882e-15, -8.706984144341681e-17,  1.617723192433933e-18, -2.787253801272650e-20,
  4.494287369233736e-22, -6.830063333890174e-24,  3.702975736566107e-07, -3.821550928117152e-08,  2.180878387893164e-09, -8.984474943981453e-11,  2.968771221347443e-12,
 -8.320289220441816e-14,  2.046770749214858e-15, -4.522437917582825e-17,  9.124178161275260e-19, -1.701645805910497e-20,  2.961574387420820e-22, -4.845389782773611e-24,
  8.606558611569359e-08, -1.008342014607309e-08,  6.452185919999986e-10, -2.953895609811658e-11,  1.077241145129120e-12, -3.313513290704590e-14,  8.904534685112499e-16,
 -2.140789605446703e-17,  4.683194593005174e-19, -9.441145724238935e-21,  1.771264679800362e-22, -3.115956781611113e-24,  1.870002767009945e-08, -2.472755694797201e-09,
  1.767494506935328e-10, -8.967100956000280e-12,  3.600955340118905e-13, -1.213311433222111e-14,  3.555936157892944e-16, -9.287883775981794e-18,  2.200020813970008e-19,
 -4.787975215810864e-21,  9.671255437319228e-23, -1.827183894911781e-24,  3.818502659735469e-09, -5.668249958215478e-10,  4.509637729036791e-11, -2.528459324328761e-12,
  1.115597675584903e-13, -4.109836710893720e-15,  1.311443362253298e-16, -3.715940892723659e-18,  9.517665275471038e-20, -2.233306591715157e-21,  4.851016757658568e-23,
 -9.831663004421559e-25,  7.374667745312669e-10, -1.222663117736927e-10,  1.078944073020869e-11, -6.667527291667849e-13,  3.225116505382504e-14, -1.296607367242175e-15,
  4.497373231187678e-17, -1.380346879238881e-18,  3.817757072049905e-20, -9.646421590593545e-22,  2.250517931067005e-23, -4.887331501248448e-25,  1.357331068703644e-10,
 -2.501144060905816e-11,  2.439692787694318e-12, -1.657215420271285e-13,  8.768306768393350e-15, -3.839618780536936e-16,  1.445186385879901e-17, -4.797268393097643e-19,
  1.430726551067439e-20, -3.887582097265319e-22,  9.729359052432169e-24, -2.261244603765318e-25,  2.402371987285889e-11, -4.896727174149224e-12,  5.261444932788817e-13,
 -3.917635950652339e-14,  2.262064252774664e-15, -1.076728507083654e-16,  4.389772658957736e-18, -1.573398134989724e-19,  5.052232442591985e-21, -1.474186545115943e-22,
  3.952386026094188e-24, -9.818238971742327e-26,  4.132723591911605e-12, -9.273415771813575e-13,  1.093710353302786e-13, -8.900960052805717e-15,  5.594788140776776e-16,
 -2.888441258074915e-17,  1.273043338432050e-18, -4.917916707663690e-20,  1.697375064975093e-21, -5.310141561611927e-23,  1.522868631260912e-24, -4.037563180655151e-26,
  6.996952222623800e-13, -1.720019665339596e-13,  2.218441011647007e-14, -1.967202880432672e-15,  1.342414900146979e-16, -7.498853199229072e-18,  3.565015194982788e-19,
 -1.481343650629260e-20,  5.484993117611010e-22, -1.836455106182525e-23,  5.623921989649015e-25, -1.588761654898406e-26,  1.182979573997691e-13, -3.169737540022074e-14,
  4.453148682720344e-15, -4.288061555439991e-16,  3.167247421932777e-17, -1.909119169306630e-18,  9.765506281403321e-20, -4.354391745530430e-21,  1.725886164350486e-22,
 -6.171361640013014e-24,  2.014052029524020e-25, -6.050769699828975e-27,  2.030945124524851e-14, -5.899883781224053e-15,  8.989624169340878e-16, -9.364560914409745e-17,
  7.461257318268410e-18, -4.837787283203226e-19,  2.654842554983723e-20, -1.266836941979835e-21,  5.360962349195247e-23, -2.042211934431396e-24,  7.085804164808983e-26,
 -2.258663346881455e-27,  3.607991146207138e-15, -1.129868727868856e-15,  1.858266039319151e-16, -2.085232494819764e-17,  1.785199027381287e-18, -1.240590734891355e-19,
  7.278974540994165e-21, -3.705098588205690e-22,  1.668875071755706e-23, -6.752926003898679e-25,  2.483980808396801e-26, -8.378027977164291e-28,  6.771973649653284e-16,
 -2.272068666434277e-16,  4.012071475439433e-17, -4.826218841329512e-18,  4.419648891704492e-19, -3.277909624628617e-20,  2.048079853480279e-21, -1.107811395734953e-22,
  5.291820479892294e-24, -2.266515500921082e-25,  8.808718626758022e-27, -3.133386404909474e-28,  1.373015767940554e-16, -4.902699585174560e-17,  9.239540267994748e-18,
 -1.184862413710315e-18,  1.154593330880901e-19, -9.094033457078169e-21,  6.022368825313130e-22, -3.446010954258337e-23,  1.738160617563433e-24, -7.847238847617430e-26,
  3.209362184432969e-27, -1.199313769340158e-28,  3.075087195363121e-17, -1.160242875715160e-17,  2.317987772580175e-18, -3.148842279094412e-19,  3.245436291165710e-20,
 -2.699100856100009e-21,  1.884068318968851e-22, -1.134427073760018e-23,  6.011312005554694e-25, -2.846639625722602e-26,  1.219314831328607e-27, -4.764770902593639e-29,
  7.764269222617203e-18, -3.071615077410587e-18,  6.456683218885060e-19, -9.224443420011149e-20,  9.986698164636555e-21, -8.711737524521893e-22,  6.369090212606050e-23,
 -4.010675909477441e-24,  2.219487847392056e-25, -1.096129735648369e-26,  4.890093207823104e-28, -1.987572349703283e-29,  2.241483989672661e-18, -9.221344846276636e-19,
  2.022542248557147e-19, -3.014407178377158e-20,  3.401312090473223e-21, -3.088795952980784e-22,  2.347981139985747e-23, -1.535469292654962e-24,  8.813882135195791e-26,
 -4.509902792032779e-27,  2.082235953283463e-28, -8.748650862123029e-30,  7.388023373068055e-19, -3.133248691407950e-19,  7.105616858407128e-20, -1.094938531827485e-20,
  1.276490377215821e-21, -1.196630368860724e-22,  9.381171358134732e-24, -6.320979378111646e-25,  3.734966569816769e-26, -1.965480939149453e-27,  9.324636128594320e-29,
 -4.022015522179963e-30,  2.658670927771828e-19, -1.151829288464185e-19,  2.674526280423419e-20, -4.219874851931586e-21,  5.034914726226265e-22, -4.827636789272323e-23,
  3.868533933129711e-24, -2.662560106998330e-25,  1.605985703103894e-26, -8.621532013045238e-28,  4.170008048534625e-29, -1.832537316663837e-30,  8.268551414075957e-20,
 -3.625259781586592e-20,  8.530500666600732e-21, -1.364021934049901e-21,  1.648921449347081e-22, -1.601333080476307e-23,  1.299191606965787e-24, -9.049894730544583e-26,
  5.522580837174766e-27, -2.998358159900478e-28,  1.466159585911069e-29, -6.511493419236556e-31,  6.677375989580100e-02, -1.847447517805635e-04,  5.304149517418650e-07,
 -1.570818529315098e-09,  4.761723105823924e-12, -1.467923844618172e-14,  4.571081392517714e-17, -1.433276949626449e-19,  4.501298025306524e-22, -1.417430453455187e-24,
  4.446053092430136e-27, -1.399253745526582e-29,  6.080239044088094e-02, -2.064369532444242e-04,  8.455621096672536e-07, -3.634333984105787e-09,  1.551869899917360e-11,
 -6.498140506025078e-14,  2.666540985589840e-16, -1.074966340379222e-18,  4.266791063889146e-21, -1.671240327834587e-23,  6.467946494693217e-26, -2.477299197762445e-28,
  5.041636905873806e-02, -2.347183754770976e-04,  1.363009926752654e-06, -7.643126959052937e-09,  4.067015840374489e-11, -2.076090540361253e-13,  1.025688098324258e-15,
 -4.932875739848594e-18,  2.318605801022747e-20, -1.068259061273394e-22,  4.835481728532174e-25, -2.154325550614346e-27,  3.807169445546479e-02, -2.495501869485467e-04,
  1.894596732174905e-06, -1.301197781597985e-08,  8.306362255104882e-11, -5.027688786697498e-13,  2.917519926958281e-15, -1.634736853354548e-17,  8.890154092146066e-20,
 -4.710777082466558e-22,  2.439656916348918e-24, -1.237854379461683e-26,  2.618670489086775e-02, -2.383767227808285e-04,  2.247516288650791e-06, -1.846183440507820e-08,
  1.390138222907496e-10, -9.815131478448198e-13,  6.583002668866017e-15, -4.231242204045400e-17,  2.623067407643364e-19, -1.575956751681839e-21,  9.210949083247515e-24,
 -5.252616152441067e-26,  1.640982308143389e-02, -2.020722857755138e-04,  2.303162195705184e-06, -2.234060840041441e-08,  1.959933798915869e-10, -1.594715682027846e-12,
  1.222043286706652e-14, -8.912602224443498e-17,  6.233293771583236e-19, -4.204213345685080e-21,  2.746705957201536e-23, -1.744210512650533e-25,  9.371317846158382e-03,
 -1.518674100595900e-04,  2.061708403589289e-06, -2.338976971991689e-08,  2.367439045494340e-10, -2.199463387255865e-12,  1.909201109128226e-14, -1.567135519731050e-16,
  1.226933641321344e-18, -9.221267748139485e-21,  6.686160628972364e-23, -4.695434784203804e-25,  4.879100328413874e-03, -1.014771676965954e-04,  1.625413684982033e-06,
 -2.139292680854918e-08,  2.478654874111731e-10, -2.610453348169916e-12,  2.549526411155240e-14, -2.340394799019158e-16,  2.038798386236301e-18, -1.697562777809731e-20,
  1.358455287836724e-22, -1.049333223825778e-24,  2.317058652161593e-03, -6.051491642975327e-05,  1.135457062136720e-06, -1.721680995622187e-08,  2.268893684557385e-10,
 -2.693066324195607e-12,  2.943356806707693e-14, -3.006241856682061e-16,  2.899776677826268e-18, -2.662399131881968e-20,  2.340873833559112e-22, -1.980310664227983e-24,
  1.004305223835937e-03, -3.232888205999494e-05,  7.062025411502212e-07, -1.226218374998579e-08,  1.828253979959296e-10, -2.433936338186899e-12,  2.963556985896027e-14,
 -3.353638234217281e-16,  3.567588454837409e-18, -3.598145024204540e-20,  3.463149386743647e-22, -3.197207011011966e-24,  3.976204763910576e-04, -1.552702753413583e-05,
  3.926431932965326e-07, -7.766338986978548e-09,  1.304164767689369e-10, -1.939446225449153e-12,  2.620940319276740e-14, -3.274542687707929e-16,  3.828916681480652e-18,
 -4.228528953239328e-20,  4.441589780170085e-22, -4.461665483809185e-24,  1.439374496941737e-04, -6.726405760264779e-06,  1.958634089323384e-07, -4.392892191737504e-09,
  8.275971498814422e-11, -1.370000998508722e-12,  2.048253602511749e-14, -2.816878167865390e-16,  3.610204556321906e-18, -4.353955772978405e-20,  4.978134670817161e-22,
 -5.427508649465886e-24,  4.769927905123831e-05, -2.636530862409009e-06,  8.795891901730812e-08, -2.227795464264366e-09,  4.692527334933207e-11, -8.620784615943991e-13,
  1.421972867117330e-14, -2.147087934185837e-16,  3.008850488929299e-18, -3.953592161451193e-20,  4.909648507142252e-22, -5.797440257775977e-24,  1.449236085567184e-05,
 -9.379395623492644e-07,  3.568103303338025e-08, -1.016777138005629e-09,  2.387228606853825e-11, -4.854121824862500e-13,  8.812248718308434e-15, -1.457637020629927e-16,
  2.228833046470466e-18, -3.184530712652872e-20,  4.287019625835226e-22, -5.472668939581234e-24,  4.044496728475512e-06, -3.037927087806282e-07,  1.311943382219234e-08,
 -4.192105730875660e-10,  1.094060380132973e-11, -2.456399244119843e-13,  4.897540808577909e-15, -8.857120393412723e-17,  1.475035988451301e-18, -2.287681562587409e-20,
  3.333038195212954e-22, -4.592530643803528e-24,  1.039157326727008e-06, -8.988622799341462e-08,  4.388163744002925e-09, -1.567396826286868e-10,  4.535628249563124e-12,
 -1.122020424984099e-13,  2.452174847027354e-15, -4.840159463351578e-17,  8.764915228870811e-19, -1.473340361689617e-20,  2.319808682826311e-22, -3.445293378154096e-24,
  2.464941563005413e-07, -2.438457187605901e-08,  1.340427255369435e-09, -5.336558261952640e-11,  1.708286291916684e-12, -4.647004371644970e-14,  1.111322171443433e-15,
 -2.390329876487318e-17,  4.699935591570391e-19, -8.551004006683533e-21,  1.453143298228589e-22, -2.323299375589905e-24,  5.416610180790536e-08, -6.090253912074360e-09,
  3.755669372812582e-10, -1.662049358612754e-11,  5.872722753031344e-13, -1.753493652393285e-14,  4.581306789964984e-16, -1.072231241758296e-17,  2.286077041074701e-19,
 -4.496206523182078e-21,  8.237004382109481e-23, -1.416117212750236e-24,  1.107277972904115e-08, -1.407051909821795e-09,  9.699646471210701e-11, -4.759090241136882e-12,
  1.852323424139744e-13, -6.060084089375907e-15,  1.727125163730077e-16, -4.392523565175540e-18,  1.014248962422921e-19, -2.153907281218970e-21,  4.249196773235584e-23,
 -7.847203441545069e-25,  2.116396549760065e-09, -3.023650923322727e-10,  2.322247160087429e-11, -1.260083441871146e-12,  5.391610954866977e-14, -1.929506035392960e-15,
  5.989835900410786e-17, -1.653207684384051e-18,  4.129201853742189e-20, -9.457849615116906e-22,  2.007121254899430e-23, -3.977623036722716e-25,  3.805563574169717e-10,
 -6.082884067607476e-11,  5.188013621920610e-12, -3.105600278543916e-13,  1.457905215450500e-14, -5.697655985225125e-16,  1.923780775882140e-17, -5.754717097068122e-19,
  1.552936067431325e-20, -3.832154399035909e-22,  8.739217819770106e-24, -1.856651612440910e-25,  6.485565478952771e-11, -1.154413634758083e-11,  1.089868909111429e-12,
 -7.179614298258013e-14,  3.690418929358350e-15, -1.572315877967999e-16,  5.765534530011643e-18, -1.866724439158773e-19,  5.435834381920504e-21, -1.443514841142756e-22,
  3.533700944049361e-24, -8.039798496560274e-26,  1.056972314594410e-11, -2.085518637829382e-12,  2.172449579179135e-13, -1.570946151483978e-14,  8.823023494510018e-16,
 -4.090698326981229e-17,  1.626474543343575e-18, -5.691626164418050e-20,  1.786096108364961e-21, -5.097877192801384e-23,  1.338042235793899e-24, -3.256532242476208e-26,
  1.664982707082108e-12, -3.625037566276733e-13,  4.152750958935960e-14, -3.287603846118604e-15,  2.013004457506242e-16, -1.013661611112791e-17,  4.362500733084682e-19,
 -1.647338784238801e-20,  5.562815950668513e-22, -1.704154143492765e-23,  4.789519297599546e-25, -1.245372853745566e-26,  2.567477767307197e-13, -6.139509130363942e-14,
  7.707911981659404e-15, -6.661484563395849e-16,  4.435854747967710e-17, -2.420739599070577e-18,  1.125454008143173e-19, -4.577689357288030e-21,  1.660607736718372e-22,
 -5.451523934119742e-24,  1.638111235221602e-25, -4.543972442621326e-27,  3.934239989250234e-14, -1.028240682742291e-14,  1.409468619891007e-15, -1.325596985515714e-16,
  9.573202086904076e-18, -5.647671991632256e-19,  2.830063104947961e-20, -1.237274117471551e-21,  4.812061117284514e-23, -1.689656787521569e-24,  5.418536870234372e-26,
 -1.600666954168748e-27,  6.096096288271731e-15, -1.732372949741936e-15,  2.582124320465447e-16, -2.633382073644437e-17,  2.055985738546032e-18, -1.307418308689662e-19,
  7.042408172401524e-21, -3.301021071546139e-22,  1.373165756650938e-23, -5.145410916359000e-25,  1.757174368640101e-26, -5.516251358290565e-28,  9.744756013956859e-16,
 -2.994244827101351e-16,  4.830647892757907e-17, -5.320581005102591e-18,  4.474248079970444e-19, -3.056402925726528e-20,  1.764028878771870e-21, -8.838436135934512e-23,
  3.921105104033577e-24, -1.563642985347753e-25,  5.671412423672138e-27, -1.887184439559743e-28,  1.643489340489825e-16, -5.427052187358799e-17,  9.427761182846951e-18,
 -1.116191846317133e-18,  1.006626068011980e-19, -7.356794376101248e-21,  4.532146795708577e-22, -2.418410310489687e-23,  1.140261820864308e-24, -4.822904896468086e-26,
  1.851894269383564e-27, -6.511361607902161e-29,  2.996597982876652e-17, -1.056356291604372e-17,  1.964313141314462e-18, -2.486252894163537e-19,  2.392325174220225e-20,
 -1.861527156378802e-21,  1.218445757347014e-22, -6.894102624742224e-24,  3.440011863295030e-25, -1.536996522642483e-26,  6.223410202474722e-28, -2.303369921010286e-29,
  6.057495647053964e-18, -2.263035365997504e-18,  4.474197576567444e-19, -6.015869262389399e-20,  6.139139193107951e-21, -5.057049416708512e-22,  3.497639195405717e-23,
 -2.087406521428280e-24,  1.096723827108599e-25, -5.151061338762070e-27,  2.189012459400562e-28, -8.489368563712187e-30,  1.390198312230346e-18, -5.460607753801964e-19,
  1.139095624347144e-19, -1.615148857636687e-20,  1.735856512208496e-21, -1.503581680296440e-22,  1.091798306649802e-23, -6.830230843614605e-25,  3.756033731692048e-26,
 -1.843738038574409e-27,  8.177339372135011e-29, -3.305019245398773e-30,  3.687860189939909e-19, -1.510009383935222e-19,  3.294999575015779e-20, -4.885993663443415e-21,
  5.485945181746865e-22, -4.958149844382835e-23,  3.751665162602472e-24, -2.442543399899634e-25,  1.396080814692206e-26, -7.114108572592459e-28,  3.271585293473157e-29,
 -1.369338686355297e-30,  1.133663979743200e-19, -4.794630716294756e-20,  1.084052624033665e-20, -1.665457037218708e-21,  1.935927180536323e-22, -1.809669356365661e-23,
  1.414835052038026e-24, -9.507892237640944e-26,  5.603744485535609e-27, -2.941652699186206e-28,  1.392268955397867e-29, -5.991596783686997e-31,  3.876308738535596e-20,
 -1.677143687826799e-20,  3.888620507917079e-21, -6.126535398521337e-22,  7.299408535591541e-23, -6.989204739273824e-24,  5.593141544819193e-25, -3.844534455205642e-26,
  2.316004137245803e-27, -1.241804632040542e-28,  5.999211089124722e-30, -2.633398018180483e-31,  1.170496369729075e-20, -5.129397811267256e-21,  1.206319091118885e-21,
 -1.927823037327959e-22,  2.329200682071069e-23, -2.260759810577236e-24,  1.833230325226033e-25, -1.276332656443727e-26,  7.784745372745950e-28, -4.224479233019691e-29,
  2.064731069065683e-30, -9.165604590067644e-32,  6.604314994526257e-02, -1.805755581991887e-04,  5.120127559343065e-07, -1.496921366659967e-09,  4.478792081352142e-12,
 -1.362875529953209e-14,  4.189186339668157e-17, -1.297068261118250e-19,  4.021605118395434e-22, -1.251310606314811e-24,  3.873993196519256e-27, -1.206208273042317e-29,
  5.998990124401791e-02, -1.998427798745417e-04,  8.033981082724750e-07, -3.396094071031633e-09,  1.428070730005487e-11, -5.892800525168114e-14,  2.383795561596989e-16,
 -9.475765975672589e-19,  3.709203006461920e-21, -1.433058431733738e-23,  5.470975525972296e-26, -2.067509757363522e-28,  4.949873804997008e-02, -2.241704109773330e-04,
  1.275063924202061e-06, -7.024329872776379e-09,  3.675337339806717e-11, -1.845695695805827e-13,  8.974023684118628e-16, -4.248898326157848e-18,  1.966679860692195e-20,
 -8.925339318715089e-23,  3.980379656311872e-25, -1.747506230467311e-27,  3.710284926417447e-02, -2.349961349622772e-04,  1.746107190562235e-06, -1.175974846740623e-08,
  7.367297119491607e-11, -4.379346702910120e-13,  2.497200380719858e-15, -1.375604126381505e-17,  7.357556974799380e-20, -3.835666999162214e-22,  1.954915175758577e-24,
 -9.764057937384309e-27,  2.526780664319872e-02, -2.212463868249947e-04,  2.038698549687652e-06, -1.638645751348707e-08,  1.208722038449006e-10, -8.368395442855353e-13,
  5.507721147953779e-15, -3.475953350718138e-17,  2.116827904806070e-19, -1.249883460556513e-21,  7.181817718962267e-24, -4.027608928552170e-26,  1.563675883834158e-02,
 -1.846683517038492e-04,  2.052887141636544e-06, -1.944474303463289e-08,  1.668409141097504e-10, -1.329250301028683e-12,  9.982831725208110e-15, -7.140320940439471e-17,
  4.900348246171325e-19, -3.244905816273648e-21,  2.082193717515632e-23, -1.299156178778561e-25,  8.795144614902696e-03, -1.364352459680672e-04,  1.802383688099204e-06,
 -1.993030125493247e-08,  1.970029845541761e-10, -1.789763517256068e-12,  1.520725105746640e-14, -1.222848102061967e-16,  9.385139620721262e-19, -6.918423953337419e-21,
  4.922671041318602e-23, -3.393854387037694e-25,  4.497662622359482e-03, -8.943706173117953e-05,  1.390872659242439e-06, -1.781360802150176e-08,  2.012803168350843e-10,
 -2.070361282248488e-12,  1.977065296641126e-14, -1.776112481983771e-16,  1.515294180395039e-18, -1.236410683977909e-20,  9.701366509347868e-23, -7.351239965238092e-25,
  2.091939848151056e-03, -5.219981048203483e-05,  9.489762364106776e-07, -1.398177333375139e-08,  1.794609379533391e-10, -2.078009816000285e-12,  2.218306206242765e-14,
 -2.215172673292318e-16,  2.090774664415130e-18, -1.879644577135423e-20,  1.619203435215544e-22, -1.342791265712358e-24,  8.854226356407243e-04, -2.722158151175396e-05,
  5.751181605957863e-07, -9.690737424476951e-09,  1.405605223309879e-10, -1.823572202906216e-12,  2.166650883332042e-14, -2.395056267315139e-16,  2.491046960977773e-18,
 -2.458218183870242e-20,  2.316495929755688e-22, -2.095083646689952e-24,  3.412508708319369e-04, -1.272593341387540e-05,  3.107898261127700e-07, -5.958694844696634e-09,
  9.724114639861816e-11, -1.407892684710541e-12,  1.854957937800888e-14, -2.262067849426115e-16,  2.584162211596045e-18, -2.790441299113907e-20,  2.867920100189274e-22,
 -2.820602368840121e-24,  1.198610190587036e-04, -5.349767965360546e-06,  1.502691530470738e-07, -3.263691772260700e-09,  5.969842288545115e-11, -9.613343806324891e-13,
  1.400192498846584e-14, -1.878201345188468e-16,  2.350232045761333e-18, -2.769747458209996e-20,  3.096883022266383e-22, -3.304075492216827e-24,  3.840761781199074e-05,
 -2.028229315619823e-06,  6.521614399637508e-08, -1.598245005713785e-09,  3.266058461200992e-11, -5.832581442434281e-13,  9.366262113530225e-15, -1.378566281268009e-16,
  1.885109679729355e-18, -2.419231386298758e-20,  2.936484319217973e-22, -3.391649903074429e-24,  1.124250455786662e-05, -6.954728523314888e-07,  2.548482776022751e-08,
 -7.022504996444961e-10,  1.598594348090099e-11, -3.157870370018255e-13,  5.578156407459035e-15, -8.989446569181126e-17,  1.340642913773415e-18, -1.869995413139362e-20,
  2.459617267940794e-22, -3.070072058640101e-24,  3.011133349904047e-06, -2.163192099861362e-07,  8.995677278398843e-09, -2.778330589827743e-10,  7.026977923276564e-12,
 -1.532030442069093e-13,  2.970836987029076e-15, -5.232358606072395e-17,  8.495665612639283e-19, -1.285881431318318e-20,  1.829896259686875e-22, -2.464632491534927e-24,
  7.394512795804238e-07, -6.122258030044623e-08,  2.877878215450186e-09, -9.933378492924880e-11,  2.784846272004682e-12, -6.687610294843208e-14,  1.421094199564438e-15,
 -2.730937592473586e-17,  4.820315721594682e-19, -7.905644804777900e-21,  1.215551457197802e-22, -1.764323003177523e-24,  1.669203933502018e-07, -1.582028440680452e-08,
  8.375043526743210e-10, -3.221931317969197e-11,  9.990978500057820e-13, -2.637910965830176e-14,  6.132798774685755e-16, -1.284074420933450e-17,  2.460583811926952e-19,
 -4.367318079297237e-21,  7.246789470803715e-23, -1.132228237636129e-24,  3.474570826432248e-08, -3.746988276048192e-09,  2.226143605482942e-10, -9.521242648704955e-12,
  3.259182819396145e-13, -9.445373508238619e-15,  2.399014955072955e-16, -5.465627856928571e-18,  1.135669386875275e-19, -2.179002067564065e-21,  3.897836811899798e-23,
 -6.548692192224632e-25,  6.695428063799280e-09, -8.170651124487129e-10,  5.429940160443672e-11, -2.575802009825927e-12,  9.714869770601662e-14, -3.085520384290633e-15,
  8.550097197592252e-17, -2.117047615498845e-18,  4.764625364104644e-20, -9.872325648975820e-22,  1.901961637470083e-23, -3.432998714802554e-25,  1.200121923703378e-09,
 -1.648980103465000e-10,  1.221963592209714e-11, -6.414459786298327e-13,  2.660802841555971e-14, -9.247770383218916e-16,  2.792220427728055e-17, -7.505254037327392e-19,
  1.827672421119443e-20, -4.085597541686794e-22,  8.469547026244605e-24, -1.640950525124197e-25,  2.012796332108520e-10, -3.099277024514371e-11,  2.553246552048833e-12,
 -1.479821607776154e-13,  6.739423278388932e-15, -2.559425231745133e-16,  8.409606103222692e-18, -2.451093829294392e-19,  6.451859247653822e-21, -1.554528111842379e-22,
  3.464493889831516e-24, -7.198942967983316e-26,  3.181479540562586e-11, -5.465326702430991e-12,  4.990545875573624e-13, -3.186484324122163e-14,  1.590419950257242e-15,
 -6.589908575100732e-17,  2.353274925877360e-18, -7.428940643938474e-20,  2.111495111249054e-21, -5.478221686568912e-23,  1.311358410418378e-24, -2.919871938310853e-26,
  4.781037761626485e-12, -9.123098739646941e-13,  9.206227944220186e-14, -6.461038353802952e-15,  3.527639926468040e-16, -1.592276956420345e-17,  6.171308361309850e-19,
 -2.107506006364532e-20,  6.460754829250902e-22, -1.803082143549996e-23,  4.631377673546880e-25, -1.103963481006712e-26,  6.903912869970999e-13, -1.457000658318849e-13,
  1.619869933192889e-14, -1.246567141442736e-15,  7.430463374766587e-17, -3.647326778781041e-18,  1.531942426571223e-19, -5.651686595716410e-21,  1.866368061559226e-22,
 -5.596301498385679e-24,  1.540722051565017e-25, -3.927389780127554e-27,  9.703065947911767e-14, -2.254681353619965e-14,  2.752887641889870e-15, -2.316918139312099e-16,
  1.504433911434635e-17, -8.015297423230321e-19,  3.642053991224452e-20, -1.449239821990462e-21,  5.147865934692983e-23, -1.656162596527752e-24,  4.880721165056147e-26,
 -1.328763203123973e-27,  1.347742389058263e-14, -3.432175486209762e-15,  4.586086101825305e-16, -4.209158125251734e-17,  2.969827108668323e-18, -1.713543492057729e-19,
  8.406169288254259e-21, -3.601091389349498e-22,  1.373486123412184e-23, -4.733123051819381e-25,  1.490714603547676e-26, -4.327849397073085e-28,  1.883828675673759e-15,
 -5.231446517316941e-16,  7.620526841841344e-17, -7.602159376162176e-18,  5.811358389953065e-19, -3.621667430364308e-20,  1.913493363750170e-21, -8.804688985515770e-23,
  3.598086424915076e-24, -1.325414425301305e-25,  4.452553172807177e-27, -1.375853894033377e-28,  2.706183842839057e-16, -8.150668284258804e-17,  1.288684200894402e-17,
 -1.391982195239223e-18,  1.148881964119221e-19, -7.708832456150527e-21,  4.373513267018597e-22, -2.155513642289518e-23,  9.412791784673869e-25, -3.696985803486233e-26,
  1.321448879361370e-27, -4.335766800715749e-29,  4.092478098659421e-17, -1.328843905858330e-17,  2.269001330672698e-18, -2.641797600102523e-19,  2.344455621508249e-20,
 -1.687166834040949e-21,  1.024096427168635e-22, -5.387557158265974e-24,  2.505729246073359e-25, -1.046005998988998e-26,  3.965997429648489e-28, -1.377624715020840e-29,
  6.690778174077843e-18, -2.326635383819417e-18,  4.265497701535036e-19, -5.324701034744239e-20,  5.055637919657950e-21, -3.883789831472709e-22,  2.510978489969400e-23,
 -1.404026748556755e-24,  6.926568293479648e-26, -3.061121575386287e-27,  1.226490924146396e-28, -4.493717369928955e-30,  1.216273278784021e-18, -4.496179942109388e-19,
  8.790957978743656e-20, -1.169183513922373e-20,  1.180626574411856e-21, -9.627055889319945e-23,  6.593741726052843e-24, -3.898417388007389e-25,  2.029829142383622e-26,
 -9.451239520588268e-28,  3.983011847719314e-29, -1.532329303387038e-30,  2.526593832075715e-19, -9.848563051659059e-20,  2.037689054311956e-20, -2.866086599536265e-21,
  3.056311287686107e-22, -2.627476744562674e-23,  1.894107572132667e-24, -1.176704179965679e-25,  6.427556708928517e-27, -3.134801049366015e-28,  1.381725781508427e-29,
 -5.551225902718448e-31,  6.131976453630976e-20, -2.498024162242643e-20,  5.421025210932982e-21, -7.994905155839544e-22,  8.929221404856063e-23, -8.029007846408998e-24,
  6.045424637294952e-25, -3.917280783417351e-26,  2.228790759121879e-27, -1.130756788006698e-28,  5.178064308379697e-30, -2.158501997405960e-31,  1.750887674421494e-20,
 -7.383138152710783e-21,  1.663894198362498e-21, -2.548045305146429e-22,  2.952551082907049e-23, -2.751606391508511e-24,  2.144950973328346e-25, -1.437360770013020e-26,
  8.448393771812725e-28, -4.423278291711536e-29,  2.088209769425700e-30, -8.964661938943084e-32,  5.669833077680200e-21, -2.449672991644417e-21,  5.670923718312559e-22,
 -8.920607025304260e-23,  1.061215038191206e-23, -1.014609614764029e-24,  8.107797874707289e-26, -5.565282698866477e-27,  3.348106414334081e-28, -1.792871334968804e-29,
  8.650569634974852e-31, -3.792637561679283e-32,  1.658980764249242e-21, -7.266275778990295e-22,  1.707868615454652e-22, -2.727746223334339e-23,  3.293757388456280e-24,
 -3.195156566139546e-25,  2.589485637651532e-26, -1.801876486701270e-27,  1.098439413735540e-28, -5.957735636554121e-30,  2.910405790750797e-31, -1.291336073570839e-32,
  6.532892784352075e-02, -1.765501105126940e-04,  4.944708422348350e-07, -1.427387876385180e-09,  4.215984190253704e-12, -1.266551843865637e-14,  3.843367544393361e-17,
 -1.175295450774268e-19,  3.597793078628110e-22, -1.106463173488149e-24,  3.380323846146505e-27, -1.042127736673470e-29,  5.920313175929311e-02, -1.935748107662292e-04,
  7.639780176721777e-07, -3.176729173713079e-09,  1.315727653312326e-11, -5.351233118361020e-14,  2.134344885396412e-16, -8.367313195926557e-19,  3.230596316503094e-21,
 -1.231371816478061e-23,  4.637946142917149e-26, -1.729666433790949e-28,  4.862193733253388e-02, -2.142973436387508e-04,  1.194182156763419e-06, -6.464676023892692e-09,
  3.326807739639588e-11, -1.643912901051107e-13,  7.867819690111548e-16, -3.668042112387381e-18,  1.672266361254611e-20, -7.476855345180688e-23,  3.285745430254893e-25,
 -1.421765977792059e-27,  3.618993613717057e-02, -2.215723514517442e-04,  1.611783978834252e-06, -1.064792045548029e-08,  6.548372991654487e-11, -3.823700812333757e-13,
  2.143020140625184e-15, -1.160826704769361e-17,  6.107702622399820e-20, -3.133266888316952e-22,  1.571886092559221e-24, -7.729798834732014e-27,  2.441423969666228e-02,
 -2.056916980721244e-04,  1.853134869472062e-06, -1.457953216384783e-08,  1.053822178644961e-10, -7.156076714140726e-13,  4.622899821793175e-15, -2.865346162447614e-17,
  1.714576812674196e-19, -9.951402099719164e-22,  5.622701015214245e-24, -3.101612337446181e-26,  1.492951533098574e-02, -1.691351606436480e-04,  1.834730031754175e-06,
 -1.697560005134127e-08,  1.424985650300364e-10, -1.111984308601082e-12,  8.186600448681571e-15, -5.744096241575069e-17,  3.869279515777062e-19, -2.516007093183104e-21,
  1.586051804170337e-23, -9.725288590607693e-26,  8.276799285132910e-03, -1.229218432579676e-04,  1.581012310997313e-06, -1.704589132423530e-08,  1.645967221369605e-10,
 -1.462700758426061e-12,  1.216883736279701e-14, -9.588473898854063e-17,  7.215684553604756e-19, -5.218457242168837e-21,  3.644519923736955e-23, -2.467285383543942e-25,
  4.160887847623573e-03, -7.911337286004363e-05,  1.195144952488934e-06, -1.490019712203684e-08,  1.642418908464986e-10, -1.650449676184343e-12,  1.541446968017270e-14,
 -1.355535958504892e-16,  1.132885819625865e-18, -9.060837007661065e-21,  6.972472158271038e-23, -5.184031832920046e-25,  1.897326584498933e-03, -4.523329291956772e-05,
  7.971399699190912e-07, -1.141593360120302e-08,  1.427588485406966e-10, -1.613069143186267e-12,  1.682380411932756e-14, -1.642962736396861e-16,  1.517723699706325e-18,
 -1.336356134566966e-20,  1.128145584012845e-22, -9.173100922433159e-25,  7.850522430863419e-04, -2.305015812873729e-05,  4.712052217717951e-07, -7.707415406009685e-09,
  1.087891436515234e-10, -1.375800216079776e-12,  1.595507830464938e-14, -1.723290973902258e-16,  1.752813243053413e-18, -1.692804155170678e-20,  1.562174873189774e-22,
 -1.384390809291744e-24,  2.949016184613364e-04, -1.050117545823817e-05,  2.477642784318498e-07, -4.605907208846727e-09,  7.306677877697290e-11, -1.030218604412397e-12,
  1.323695770330440e-14, -1.575944386655770e-16,  1.759306605963432e-18, -1.857919952747708e-20,  1.868763012606120e-22, -1.799820083222864e-24,  1.006393500502198e-04,
 -4.289384873700719e-06,  1.162560221482691e-07, -2.445718160220671e-09,  4.344652273406338e-11, -6.807397076793864e-13,  9.661494894192741e-15, -1.264338010354008e-16,
  1.544991712488615e-18, -1.779580919269268e-20,  1.946189070138318e-22, -2.032254308906204e-24,  3.122815761398095e-05, -1.575145497406445e-06,  4.882392107560625e-08,
 -1.157982670438766e-09,  2.296275332302278e-11, -3.987014920486308e-13,  6.234492129689061e-15, -8.946394398283059e-17,  1.193971473119028e-18, -1.496783672035391e-20,
  1.776118836500492e-22, -2.006873616602225e-24,  8.820559860787417e-06, -5.213907360794547e-07,  1.840547051545049e-08, -4.905033403431992e-10,  1.082772166320556e-11,
 -2.078282217555169e-13,  3.572661834830111e-15, -5.610247117056688e-17,  8.161676415028994e-19, -1.111548361529789e-20,  1.428667530747518e-22, -1.743833993491156e-24,
  2.271092310501757e-06, -1.559884064620006e-07,  6.246466237870438e-09, -1.864877995572632e-10,  4.571477972842101e-12, -9.679367671137046e-14,  1.825753243997616e-15,
 -3.131954838052811e-17,  4.958542854815303e-19, -7.325121064144444e-21,  1.018275848573830e-22, -1.340746600846495e-24,  5.340067345089892e-07, -4.230088439083430e-08,
  1.914440893548599e-09, -6.385500630503762e-11,  1.734452524399846e-12, -4.043560254296994e-14,  8.354988086708527e-16, -1.563310514442212e-17,  2.689764167833196e-19,
 -4.304384402615555e-21,  6.463402568747992e-23, -9.168999343674970e-25,  1.149273227813076e-07, -1.043047034533990e-08,  5.316670939131094e-10, -1.976260610295840e-11,
  5.936276536960014e-13, -1.521258361313875e-14,  3.438240850857239e-16, -7.007894072460963e-18,  1.308750626054119e-19, -2.266171874411720e-21,  3.671729110686539e-23,
 -5.606051765721767e-25,  2.270447211144088e-08, -2.346999038927749e-09,  1.343007829955003e-10, -5.550455620301113e-12,  1.840410013032708e-13, -5.176503641352450e-15,
  1.278066268075465e-16, -2.834314738067695e-18,  5.739209500253869e-20, -1.074218416811362e-21,  1.876233623415329e-23, -3.080380025002152e-25,  4.132122706550602e-09,
 -4.839383661074764e-10,  3.099233446045516e-11, -1.421041727988407e-12,  5.192512026566040e-14, -1.600775812973860e-15,  4.312346895095365e-17, -1.039424508901574e-18,
  2.279890947638298e-20, -4.608628774575701e-22,  8.669964886509683e-24, -1.529379237747452e-25,  6.959182394697067e-10, -9.189323552861483e-11,  6.567246804932913e-12,
 -3.333808738540854e-13,  1.340301885163822e-14, -4.522928678079609e-16,  1.327962504581601e-17, -3.475551223940639e-19,  8.250431712043807e-21, -1.799681039557765e-22,
  3.643828338885070e-24, -6.901053530716215e-26,  1.090662939807051e-10, -1.616468936898199e-11,  1.285552351764308e-12, -7.210769480073469e-14,  3.184644605308847e-15,
 -1.174876225737329e-16,  3.755549861795676e-18, -1.066251201482488e-19,  2.736996735996334e-21, -6.437441620464316e-23,  1.401755876517789e-24, -2.848278591345323e-26,
  1.601670665752624e-11, -2.653062651169437e-12,  2.341572899739764e-13, -1.448339754121342e-14,  7.016048309708462e-16, -2.826079022500946e-17,  9.824476859580232e-19,
 -3.022935998753816e-20,  8.383616952215888e-22, -2.124446361121128e-23,  4.971389956408759e-25, -1.083002599058851e-26,  2.222855320558410e-12, -4.098126376589775e-13,
  4.003132862824070e-14, -2.724912479650003e-15,  1.445500353809136e-16, -6.348779372522327e-18,  2.397509121902445e-19, -7.986783722287323e-21,  2.390903087271305e-22,
 -6.522008524179164e-24,  1.638844855000455e-25, -3.824683583139832e-27,  2.946143296273237e-13, -6.020588273224551e-14,  6.490741899143544e-15, -4.851865539610152e-16,
  2.813621500418648e-17, -1.345497481551173e-18,  5.512445404604056e-20, -1.985879794076107e-21,  6.410293482597816e-23, -1.880532587473638e-24,  5.069477868388420e-26,
 -1.266316354326715e-27,  3.777067924431515e-14, -8.519625231285719e-15,  1.010727689837741e-15, -8.277519778186131e-17,  5.237314255573834e-18, -2.722370302532900e-19,
  1.208254717934338e-20, -4.700917935723086e-22,  1.634201070102434e-23, -5.149774324468430e-25,  1.487707713954279e-26, -3.973329681770228e-28,  4.757099608728437e-15,
 -1.179136587590107e-15,  1.534401921628501e-16, -1.373160177446452e-17,  9.458271618724517e-19, -5.333569566497641e-20,  2.559819290447860e-21, -1.073845059594140e-22,
  4.014230101269718e-24, -1.356878396967148e-25,  4.194899371394178e-27, -1.196296803984881e-28,  5.996333524733575e-16, -1.625509372322052e-16,  2.311856043874829e-17,
 -2.253958377468439e-18,  1.685656402358288e-19, -1.028749059975882e-20,  5.327627666159171e-22, -2.404879848065481e-23,  9.648554329291568e-25, -3.491947643909730e-26,
  1.153300716939460e-27, -3.505950038599210e-29,  7.732695698638908e-17, -2.280524095660792e-17,  3.530263815689718e-18, -3.736317400234992e-19,  3.024192074983816e-20,
 -1.991644162899368e-21,  1.109908535948236e-22, -5.377281559159427e-24,  2.309859302926741e-25, -8.929962191089005e-27,  3.143752781362449e-28, -1.016518270421844e-29,
  1.046531829009959e-17, -3.338181426013296e-18,  5.597439277527119e-19, -6.403498081446423e-20,  5.587598714744317e-21, -3.956491044933688e-22,  2.364572576839669e-23,
 -1.225568722549039e-24,  5.619163069899938e-26, -2.313690774528146e-27,  8.657340350637365e-29, -2.969255600240437e-30,  1.529830231105026e-18, -5.243132756238532e-19,
  9.469142363191941e-20, -1.164888950599360e-20,  1.090556704878880e-21, -8.265211772296734e-23,  5.274772042726916e-24, -2.912889711635155e-25,  1.419934248383797e-26,
 -6.203456677857651e-28,  2.458164225142402e-29, -8.911167365369051e-31,  2.491726684454958e-19, -9.107810714047610e-20,  1.759800162892032e-20, -2.313532007884050e-21,
  2.310170800429149e-22, -1.863584335880924e-23,  1.263265994233412e-24, -7.394948066600580e-26,  3.813806170323123e-27, -1.759544229623924e-28,  7.349993929681762e-30,
 -2.803775777249018e-31,  4.665155069682692e-20, -1.803573471136302e-20,  3.699105222378631e-21, -5.158319559711200e-22,  5.455014708644090e-23, -4.652099397273258e-24,
  3.327817891084230e-25, -2.052090294590154e-26,  1.112944868596865e-27, -5.390821509960594e-29,  2.360462345419913e-30, -9.423416916082168e-32,  1.031152345750873e-20,
 -4.177731440898126e-21,  9.012748724722637e-22, -1.321452381394855e-22,  1.467536405783719e-23, -1.312382276752044e-24,  9.829612125226594e-26, -6.337116602434009e-27,
  3.588038963971339e-28, -1.811832062940943e-29,  8.259496379986192e-31, -3.428102370678026e-32,  2.723039986937143e-21, -1.144583657177064e-21,  2.570478122396000e-22,
 -3.922728439357259e-23,  4.530142389549740e-24, -4.208066032392154e-25,  3.269984419334878e-26, -2.184620394753548e-27,  1.280308552968880e-28, -6.684389064057357e-30,
  3.147119947948665e-31, -1.347537019384341e-32,  8.321877922551136e-22, -3.590033720877116e-22,  8.296866304842543e-23, -1.302945299368881e-23,  1.547474353368897e-24,
 -1.477163399185283e-25,  1.178594468175739e-26, -8.077985645377284e-28,  4.852789233249318e-29, -2.595009223703977e-30,  1.250410446297420e-31, -5.475056537658487e-33,
  2.354365461347396e-22, -1.030635616814783e-22,  2.420915619939195e-23, -3.864194350563140e-24,  4.663158496645683e-25, -4.520847956359945e-26,  3.661733193690615e-27,
 -2.546537401232151e-28,  1.551527185662799e-29, -8.410639549665445e-31,  4.106501217854980e-32, -1.821104574535746e-33,  6.463053204742686e-02, -1.726617305766214e-04,
  4.777387223003081e-07, -1.361909590716359e-09,  3.971637917278432e-12, -1.178133508729231e-14,  3.529822211895711e-17, -1.066287049157775e-19,  3.222738793920360e-22,
 -9.799937157119807e-25,  2.953309520863188e-27, -9.025665918351857e-30,  5.844081968047977e-02, -1.876119704152109e-04,  7.270859282731813e-07, -2.974504164234738e-09,
  1.213641516075799e-11, -4.865976050705904e-14,  1.913891459827184e-16, -7.401012532604508e-19,  2.818940582847089e-21, -1.060214612267094e-23,  3.940238136872747e-26,
 -1.450447745083361e-28,  4.778337601080113e-02, -2.050453852949385e-04,  1.119694512160360e-06, -5.957697291115321e-09,  3.016106242724355e-11, -1.466829151968099e-13,
  6.911812961706238e-16, -3.173564390282571e-18,  1.425323959339317e-20, -6.279555913729258e-23,  2.719792462484404e-25, -1.160127697253046e-27,  3.532865043477299e-02,
 -2.091719318082191e-04,  1.490051766631901e-06, -9.658672158169263e-09,  5.832542428412444e-11, -3.346271256140734e-13,  1.843738259980221e-15, -9.822778415986001e-18,
  5.085162609143566e-20, -2.567573547376665e-22,  1.268140500261396e-24, -6.141018435354718e-27,  2.362005409827135e-02, -1.915388225658088e-04,  1.687843683109001e-06,
 -1.300214767987858e-08,  9.211764351997215e-11, -6.136972618322934e-13,  3.892324919033708e-15, -2.369914362303847e-17,  1.393724635084522e-19, -7.953164720567306e-22,
  4.419629908248228e-24, -2.398525027163644e-26,  1.428109279852236e-02, -1.552350130579126e-04,  1.644001928123881e-06, -1.486338786965350e-08,  1.221002779237731e-10,
 -9.334864430937084e-13,  6.738807387246186e-15, -4.639394781394968e-17,  3.068103994616398e-19, -1.959545002830999e-21,  1.213781222937791e-23, -7.315773115749984e-26,
  7.809173019783676e-03, -1.110493018045689e-04,  1.391346533289774e-06, -1.463137573613698e-08,  1.380585444138852e-10, -1.200420771621757e-12,  9.780974425206315e-15,
 -7.553895967638349e-17,  5.575236719259742e-19, -3.956632838948627e-21,  2.712839607769762e-23, -1.803772369448186e-25,  3.862484178859542e-03, -7.022513312012891e-05,
  1.031082265819794e-06, -1.251751879679172e-08,  1.346448935599615e-10, -1.322235101223469e-12,  1.208105853833623e-14, -1.040236623772328e-16,  8.518473317269426e-19,
 -6.679765416389261e-21,  5.042251027126821e-23, -3.679179651828432e-25,  1.728331798723584e-03, -3.936762428326799e-05,  6.728560064564753e-07, -9.369415612331451e-09,
  1.141891390062316e-10, -1.259428539215816e-12,  1.283690538715267e-14, -1.226288437170479e-16,  1.108992072767200e-18, -9.565753379790294e-21,  7.915439331173055e-23,
 -6.311919416644662e-25,  6.998443093412233e-04, -1.962284539753684e-05,  3.883151377526253e-07, -6.167645072277365e-09,  8.474203084475461e-11, -1.044965493735274e-12,
  1.183146359203002e-14, -1.248934707036555e-16,  1.242597470199455e-18, -1.174712970319437e-20,  1.061841093779995e-22, -9.222243000988879e-25,  2.565372219260033e-04,
 -8.721731411480720e-06,  1.988799311879651e-07, -3.585806014980044e-09,  5.531228391412991e-11, -7.596917282773682e-13,  9.521385319478476e-15, -1.106974269980528e-16,
  1.207876893534714e-18, -1.247766934828222e-20,  1.228519929886412e-22, -1.158887549197797e-24,  8.517144787001241e-05, -3.465872178555878e-06,  9.066672997566151e-08,
 -1.848003785132076e-09,  3.189027886286445e-11, -4.863011743240793e-13,  6.726971174115162e-15, -8.590107709174850e-17,  1.025289825228668e-18, -1.154480120953176e-20,
  1.235145622835767e-22, -1.262573637930792e-24,  2.562883210804436e-05, -1.234448569450303e-06,  3.689359170409427e-08, -8.470210267831415e-10,  1.630246318765833e-11,
 -2.752689945616802e-13,  4.192253627818873e-15, -5.866312787281022e-17,  7.642385322320108e-19, -9.360414713605963e-21,  1.086034566160570e-22, -1.200674800625999e-24,
  6.995982681231872e-06, -3.950340746282170e-07,  1.343547488416997e-08, -3.463389326384959e-10,  7.415171685202062e-12, -1.383172414485156e-13,  2.314350390724954e-15,
 -3.541918506976135e-17,  5.027145928483791e-19, -6.685856125055535e-21,  8.398414497865219e-23, -1.002587952152029e-24,  1.734488368390113e-06, -1.138576668642524e-07,
  4.390559361068266e-09, -1.267191274286794e-10,  3.011078881938309e-12, -6.192413116785545e-14,  1.136305062166243e-15, -1.898795128742299e-17,  2.931624612796620e-19,
 -4.227434597396728e-21,  5.741172718881513e-23, -7.390649967790133e-25,  3.911743608147546e-07, -2.963368391694946e-08,  1.291161709553116e-09, -4.161697332656894e-11,
  1.095282539694653e-12, -2.479085463326183e-14,  4.981249368403096e-16, -9.075773482921937e-18,  1.522273429835456e-19, -2.377158020893771e-21,  3.486214673554933e-23,
 -4.833932612815463e-25,  8.041092682968693e-08, -6.984781929612243e-09,  3.427523673355318e-10, -1.230930594371202e-11,  3.581591649393246e-13, -8.908540866162163e-15,
  1.957423931801705e-16, -3.883905941163674e-18,  7.069248503268784e-20, -1.194214109542710e-21,  1.889383107614839e-23, -2.819139105271813e-25,  1.510496885412984e-08,
 -1.495861244581493e-09,  8.242097120772995e-11, -3.291040839618880e-12,  1.056941473443297e-13, -2.885087725561501e-15,  6.924070624463369e-17, -1.494620827717350e-18,
  2.949287157976605e-20, -5.384974188897335e-22,  9.183284880435129e-24, -1.473307830461322e-25,  2.601385473509885e-09, -2.921976180027923e-10,  1.802643424100911e-11,
 -7.987182219454662e-13,  2.827060406143917e-14, -8.458457332925880e-16,  2.214965340168612e-17, -5.196665279600051e-19,  1.110790514247042e-20, -2.190397663064423e-22,
  4.023462711125928e-24, -6.935739780946513e-26,  4.124486695394918e-10, -5.230138805961898e-11,  3.603048064312581e-12, -1.768226270518905e-13,  6.888036280032260e-15,
 -2.256374977224976e-16,  6.440947544728309e-18, -1.641110372835268e-19,  3.797039092050346e-21, -8.080986526916285e-23,  1.597815384185888e-24, -2.957675429669399e-26,
  6.051834349621330e-11, -8.626381949457525e-12,  6.619096086651355e-13, -3.591523215123514e-14,  1.537696082804157e-15, -5.509112799609803e-17,  1.712754944388955e-18,
 -4.735632049572189e-20,  1.185183751359131e-21, -2.720567038949670e-23,  5.786960723198438e-25, -1.149633521712297e-26,  8.271989808512544e-12, -1.320039023772888e-12,
  1.125359471958089e-13, -6.739443366047131e-15,  3.167190885766400e-16, -1.239710433819320e-17,  4.193965089730019e-19, -1.257390692051398e-20,  3.401595288604499e-22,
 -8.416670480724170e-24,  1.924896843729406e-25, -4.101645447857976e-27,  1.061960574627228e-12, -1.889819399009977e-13,  1.785611126880401e-14, -1.178152544928952e-15,
  6.068995889259796e-17, -2.592496524608088e-18,  9.534775340566190e-20, -3.097190409043677e-21,  9.050467873603322e-23, -2.412262351837398e-24,  5.927855650052325e-26,
 -1.354034056973039e-27,  1.293675934049458e-13, -2.557333164599835e-14,  2.671272855260566e-15, -1.938221446642554e-16,  1.092810242081562e-17, -5.088325198148161e-19,
  2.032380398987340e-20, -7.146249392100525e-22,  2.253791203891239e-23, -6.465939504292665e-25,  1.706075853961115e-26, -4.174548469218975e-28,  1.514469755033834e-14,
 -3.312456204359730e-15,  3.814904820564753e-16, -3.037746318447892e-17,  1.871539709427166e-18, -9.485275730463716e-20,  4.109488334221802e-21, -1.562434325402633e-22,
  5.312937044660638e-24, -1.639120821468980e-25,  4.639658712690062e-27, -1.215074114315680e-28,  1.730499536723103e-15, -4.170360649786607e-16,  5.280035183363511e-17,
 -4.603396222495445e-18,  3.093057351007992e-19, -1.703443587496763e-20,  7.993204451593705e-22, -3.281568523673075e-23,  1.201600870696499e-24, -3.981760685290251e-26,
  1.207709705454751e-27, -3.381449297438795e-29,  1.966909540573366e-16, -5.199125170572216e-17,  7.212434756549966e-18, -6.866134730871650e-19,  5.019517809423516e-20,
 -2.997658285661853e-21,  1.520564355747177e-22, -6.728958052254792e-24,  2.648837301073118e-25, -9.412991914303991e-27,  3.054738845491713e-28, -9.130668979563938e-30,
  2.275018094736935e-17, -6.562770090284378e-18,  9.936885230776037e-19, -1.029537832228067e-19,  8.165200505177701e-21, -5.273733360314142e-22,  2.884750471248368e-23,
 -1.372899331412325e-24,  5.797389268734422e-26, -2.204762401156730e-27,  7.640121064843647e-29, -2.433176639951373e-30,  2.750673897015277e-18, -8.610439029161486e-19,
  1.416476975850567e-19, -1.590798884568935e-20,  1.363731809296178e-21, -9.493923513362808e-23,  5.582522992388120e-24, -2.848720801222707e-25,  1.286742839215887e-26,
 -5.222633361463228e-28,  1.927405185443303e-29, -6.523430921615475e-31,  3.585560133471338e-19, -1.210053061597994e-19,  2.150903412188398e-20, -2.605456334287114e-21,
  2.403215119372307e-22, -1.795585593985477e-23,  1.130362620352655e-24, -6.160865355339682e-26,  2.965634500433300e-27, -1.280058509897319e-28,  5.013675160058674e-30,
 -1.797337178546336e-31,  5.213683621874325e-20, -1.882886337933551e-20,  3.592514285789321e-21, -4.665096863485717e-22,  4.603300273236059e-23, -3.671265841742576e-24,
  2.461509230246504e-25, -1.425844370527183e-26,  7.279593525760070e-28, -3.326074230141498e-29,  1.376462982506757e-30, -5.203899221463905e-32,  8.759504663656115e-21,
 -3.356720463863129e-21,  6.820389671102417e-22, -9.423771709437557e-23,  9.877526216109314e-24, -8.351832043574950e-25,  5.925399487530157e-26, -3.625102973586935e-27,
  1.951182653540274e-28, -9.382269016706970e-30,  4.079440596166484e-31, -1.617652585828236e-32,  1.754982727914414e-21, -7.068503537994397e-22,  1.515248943606414e-22,
 -2.207772777122970e-23,  2.436973672536320e-24, -2.166586519427663e-25,  1.613622689696814e-26, -1.034669045639483e-27,  5.827763506844945e-29, -2.928092125218550e-30,
  1.328389562558459e-31, -5.488011393653285e-33,  4.266707950544070e-22, -1.787254665707044e-22,  3.998679384839985e-23, -6.079511882695197e-24,  6.995442581489071e-25,
 -6.475335090560609e-26,  5.014838869845583e-27, -3.339438668113726e-28,  1.950973152702410e-29, -1.015520011516136e-30,  4.767371625003197e-32, -2.035613349504382e-33,
  1.225976085091446e-22, -5.280163031916481e-23,  1.218084295033725e-23, -1.909441911473249e-24,  2.263807673622251e-25, -2.157266745205102e-26,  1.718397464999218e-27,
 -1.175901243366737e-28,  7.053291255647777e-30, -3.766128955146595e-31,  1.812120873019953e-32, -7.923638257774673e-34,  3.345807131300954e-23, -1.463788191315155e-23,
  3.436121659734197e-24, -5.481023129117373e-25,  6.609991096592549e-26, -6.404198579653093e-27,  5.183971372001489e-28, -3.602997395507713e-29,  2.193906972652597e-30,
 -1.188610508907285e-31,  5.800171519365423e-33, -2.570805317378970e-34,  6.394742694141811e-02, -1.689041297865986e-04,  4.617694551462526e-07, -1.300203363321273e-09,
  3.744246842168546e-12, -1.096887146113979e-14,  3.245185151299813e-17, -9.685837236333211e-20,  2.890281147298338e-22, -8.694405047381534e-25,  2.582993008059095e-27,
 -7.838649526019802e-30,  5.770178367622480e-02, -1.819348304596228e-04,  6.925256483239241e-07, -2.787864378684449e-09,  1.120752601845029e-11, -4.430524383088818e-14,
  1.718739159981443e-16, -6.557098548748665e-19,  2.464160424515879e-21, -9.146566073010867e-24,  3.354499828444617e-26, -1.219129306608107e-28,  4.698066809191501e-02,
 -1.963658121073122e-04,  1.051003635110241e-06, -5.497717569407944e-09,  2.738634775656744e-11, -1.311113581707684e-13,  6.083815060889376e-16, -2.751627154009350e-18,
  1.217672355840316e-20, -5.287195508777326e-23,  2.257350362601716e-25, -9.493347506931459e-28,  3.451509122221823e-02, -1.976997628876286e-04,  1.379533627734347e-06,
 -8.776691785720630e-09,  5.205401619900050e-11, -2.935021848474120e-13,  1.590159276363496e-15, -8.334133398063453e-18,  4.245988140751127e-20, -2.110472671312380e-22,
  1.026425759547865e-24, -4.895598792668702e-27,  2.287995032725562e-02, -1.786360211190275e-04,  1.540272010364763e-06, -1.162159822981084e-08,  8.072660321860685e-11,
 -5.277656899539799e-13,  3.287115317274501e-15, -1.966516892953532e-17,  1.136843870381602e-19, -6.379547974046291e-22,  3.487455918108022e-24, -1.862375972857843e-26,
  1.368537224479863e-02, -1.427645928977876e-04,  1.476774103530605e-06, -1.305077636252849e-08,  1.049481101499209e-10, -7.862959874821566e-13,  5.567256157244332e-15,
 -3.761695957315062e-17,  2.442823624278007e-19, -1.532765449242234e-21,  9.331084146560072e-24, -5.529358964324751e-26,  7.386176081577998e-03, -1.005850288532653e-04,
  1.228270800704133e-06, -1.260243643390270e-08,  1.162361270648856e-10, -9.891669630127205e-13,  7.895648711698333e-15, -5.978238250362086e-17,  4.328451565880700e-19,
 -3.015025247482606e-21,  2.029941995943800e-23, -1.325898512397648e-25,  3.597178808274664e-03, -6.254260463237739e-05,  8.929737268613848e-07, -1.055994201807932e-08,
  1.108787446244173e-10, -1.064370390912946e-12,  9.516474820579894e-15, -8.025242337714909e-17,  6.440904394638892e-19, -4.952940940171456e-21,  3.668313616888921e-23,
 -2.627423050842747e-25,  1.580956377103288e-03, -3.440525982875610e-05,  5.706051520814027e-07, -7.728257780580518e-09,  9.182275332116102e-11, -9.888336070027329e-13,
  9.852417470534825e-15, -9.209036825775371e-17,  8.155025218582468e-19, -6.892497957780654e-21,  5.591653221333211e-23, -4.373737961440384e-25,  6.271277951979371e-04,
 -1.679081512917830e-05,  3.217958662257653e-07, -4.964651708005812e-09,  6.642067806249597e-11, -7.988446413731767e-13,  8.832969439054704e-15, -9.115024313697876e-17,
  8.872881822240133e-19, -8.212842742835629e-21,  7.273086963157572e-23, -6.192018381660455e-25,  2.245796670089704e-04, -7.288844706079562e-06,  1.606963587927737e-07,
 -2.810924523406706e-09,  4.217344755293428e-11, -5.643885974109925e-13,  6.901682017186159e-15, -7.837558842950859e-17,  8.360816681898045e-19, -8.450415364217338e-21,
  8.145860439973842e-23, -7.527742130583822e-25,  7.262951701067125e-05, -2.821254356715899e-06,  7.125752328995946e-08, -1.407551221300188e-09,  2.360155183241499e-11,
 -3.503616247771175e-13,  4.724807138037162e-15, -5.888709461949904e-17,  6.866651002990123e-19, -7.559969418375217e-21,  7.914050982142876e-23, -7.920662577517802e-25,
  2.122271179041670e-05, -9.759080509479851e-07,  2.812899198760635e-08, -6.252704231352000e-10,  1.168323847052994e-11, -1.918859951031056e-13,  2.846834219224796e-15,
 -3.885417605432268e-17,  4.941991385577377e-19, -5.914904968731166e-21,  6.711297266154442e-23, -7.260937412702981e-25,  5.607085265006092e-06, -3.023498031215235e-07,
  9.908902229661772e-09, -2.471161538546449e-10,  5.132469242233951e-12, -9.305705137811501e-14,  1.515811904759225e-15, -2.261251126229486e-17,  3.131759887930096e-19,
 -4.067974294206499e-21,  4.994823512612641e-23, -5.832533996167179e-25,  1.340719273134141e-06, -8.408202033933889e-08,  3.122471589274891e-09, -8.713133474040347e-11,
  2.007179711047072e-12, -4.009890558206861e-14,  7.159263112958205e-16, -1.165521980022008e-17,  1.755089529394173e-19, -2.470755940263646e-21,  3.278521935003403e-23,
 -4.126761747765508e-25,  2.905110671765342e-07, -2.103794208000103e-08,  8.824329963786299e-10, -2.748685832715080e-11,  7.009728442375606e-13, -1.540525242173377e-14,
  3.010378609480395e-16, -5.341376511564266e-18,  8.734580193814120e-20, -1.331110521915464e-21,  1.906743713729683e-23, -2.584392519209198e-25,  5.714189560765942e-08,
 -4.748239549461992e-09,  2.242801823293585e-10, -7.781715492707656e-12,  2.193275771259376e-13, -5.295145277240662e-15,  1.131145279164791e-16, -2.185012909668253e-18,
  3.876265117193352e-20, -6.388733759957491e-22,  9.870316577763719e-24, -1.439310658437164e-25,  1.022560637441202e-08, -9.695769295432756e-10,  5.142872011769508e-11,
 -1.983775529574882e-12,  6.170382530971396e-14, -1.634517400314636e-15,  3.813012115598725e-17, -8.011378066865633e-19,  1.540536989120493e-20, -2.743863956970075e-22,
  4.568726370954428e-24, -7.162525578099920e-26,  1.669685783846631e-09, -1.797549684434843e-10,  1.067913387777528e-11, -4.571487883844375e-13,  1.567128305800760e-14,
 -4.550033935918852e-16,  1.158094204977330e-17, -2.644523258525879e-19,  5.508231992053678e-21, -1.059521519367143e-22,  1.900173612074898e-24, -3.200786711916239e-26,
  2.497065433090383e-10, -3.038620595990648e-11,  2.016972377861743e-12, -9.566291374117110e-14,  3.609886376656313e-15, -1.147688542276794e-16,  3.184662322200694e-18,
 -7.898387878478243e-20,  1.780913250618029e-21, -3.697509944629179e-23,  7.138732683356955e-25, -1.291406533707273e-26,  3.436976448322744e-11, -4.707971993836456e-12,
  3.483514961046190e-13, -1.827716727239970e-14,  7.583505610567796e-16, -2.637787900883771e-17,  7.974054906913319e-19, -2.146658265935269e-20,  5.236916385105208e-22,
 -1.173010428447536e-23,  2.436952916691395e-25, -4.732385324178292e-27,  4.380832729050438e-12, -6.729030553937421e-13,  5.537641081865165e-14, -3.209281325412982e-15,
  1.462520246046635e-16, -5.560861587664248e-18,  1.830135028581752e-19, -5.344711156003095e-21,  1.410022271440644e-22, -3.405758828886771e-24,  7.610425158569042e-26,
 -1.585827397852028e-27,  5.211644345421654e-13, -8.943511892660487e-14,  8.167870647560178e-15, -5.220637471743748e-16,  2.610135922837053e-17, -1.083912557344598e-18,
  3.880863683755755e-20, -1.228756553386450e-21,  3.503706755541451e-23, -9.121584088526815e-25,  2.191403390233890e-26, -4.897754069741037e-28,  5.844266482888761e-14,
 -1.116406380321261e-14,  1.128944420164719e-15, -7.945586716259702e-17,  4.352976541233343e-18, -1.972381940915416e-19,  7.676660372788221e-21, -2.633351227957953e-22,
  8.110857847777519e-24, -2.274691496414991e-25,  5.872260552787710e-27, -1.406980004409704e-28,  6.254897633591070e-15, -1.325142372422810e-15,  1.480218240571062e-16,
 -1.145133223070098e-17,  6.864992566440450e-19, -3.390225369284363e-20,  1.432979670544400e-21, -5.321190588539913e-23,  1.769014317811419e-24, -5.340637342345795e-26,
  1.480526332694694e-27, -3.800352140540084e-29,  6.488973374793184e-16, -1.518694076675906e-16,  1.868977650306598e-17, -1.586115796809847e-18,  1.038792566641384e-19,
 -5.583357734049204e-21,  2.559801721860152e-22, -1.027850070777753e-23,  3.684487748158277e-25, -1.196278532963065e-26,  3.557969776783107e-28, -9.775781161967977e-30,
  6.651439344350145e-17, -1.712416514581148e-17,  2.314759542699643e-18, -2.149755225485084e-19,  1.534992391056573e-20, -8.963434610011346e-22,  4.450271995183066e-23,
 -1.929405577736215e-24,  7.447262513100975e-26, -2.597033350463902e-27,  8.276557970209692e-29, -2.431135638880065e-30,  6.895987500257381e-18, -1.943617593652835e-18,
  2.875568777496341e-19, -2.913855439160982e-20,  2.262451099705228e-21, -1.431967661382761e-22,  7.682701299373432e-24, -3.589174156955702e-25,  1.488920449012619e-26,
 -5.566640562486748e-28,  1.897630935964055e-29, -5.949003892035771e-31,  7.437264147879633e-19, -2.282264617638537e-19,  3.679805136619976e-20, -4.053308739505539e-21,
  3.410812781627557e-22, -2.332701187863635e-23,  1.348527880533197e-24, -6.770268740207651e-26,  3.010679309243746e-27, -1.203788066923589e-28,  4.378999525053684e-30,
 -1.461730556464854e-31,  8.622836962560640e-20, -2.862714969589150e-20,  5.003687245474284e-21, -5.963012543672251e-22,  5.414604175381364e-23, -3.985254383594754e-24,
  2.472958437442506e-25, -1.329378267640438e-26,  6.315037440427417e-28, -2.691340313187476e-29,  1.041336035340427e-30, -3.689543673925021e-32,  1.115377740095369e-20,
 -3.976570423925795e-21,  7.486097260793800e-22, -9.594738000746486e-23,  9.349018575399075e-24, -7.366410714191872e-25,  4.882019271051393e-26, -2.796619759908845e-27,
  1.412623937974872e-28, -6.388425072026182e-30,  2.617839508341245e-31, -9.803863487024823e-33,  1.674204089760074e-21, -6.355187461692603e-22,  1.278400739087232e-22,
 -1.749089522086710e-23,  1.815977821228607e-24, -1.521519553633879e-25,  1.070051150131127e-26, -6.491586589773364e-28,  3.465914128785033e-29, -1.653696305830620e-30,
  7.136875165874295e-32, -2.809858062573612e-33,  3.025557810941881e-22, -1.210865324171563e-22,  2.578003612200966e-23, -3.731026445073120e-24,  4.091583452726922e-25,
 -3.614825501221724e-26,  2.676020147112024e-27, -1.705955984485700e-28,  9.555343110847112e-30, -4.775312216769250e-31,  2.155288406691166e-32, -8.860313672086316e-34,
  6.739309044509856e-23, -2.812465960098448e-23,  6.266891999563640e-24, -9.489786053895496e-25,  1.087690420159994e-25, -1.003029811509800e-26,  7.739819580294342e-28,
 -5.136052886978665e-29,  2.990525319744498e-30, -1.551602877480058e-31,  7.261399214374823e-33, -3.091293048933087e-34,  1.813314551207818e-23, -7.795971714212410e-24,
  1.794956058214803e-24, -2.808278548254956e-25,  3.323162255361021e-26, -3.160968050864122e-27,  2.513456150136763e-28, -1.717026715301643e-29,  1.028212655215566e-30,
 -5.481466200901329e-32,  2.633441345365505e-33, -1.149797441228944e-34,  4.761662495876515e-24, -2.081929400578976e-24,  4.883762002677643e-25, -7.784737323588775e-26,
  9.381760099561702e-27, -9.083561175905584e-28,  7.348002782743299e-29, -5.103799904137137e-30,  3.105835287478030e-31, -1.681657998936324e-32,  8.201324874665525e-34,
 -3.632997431234584e-35,  6.327910133424844e-02, -1.652713818739823e-04,  4.465193576296917e-07, -1.242009019718190e-09,  3.532443463694638e-12, -1.022155453677779e-14,
  2.986473462310418e-17, -8.809098561879337e-20,  2.595077245899879e-22, -7.727099331889889e-25,  2.260876901766193e-27, -6.830303585038227e-30,  5.698491710376620e-02,
 -1.765254602343397e-04,  6.601186661332334e-07, -2.615414763672674e-09,  1.036122852376047e-11, -4.039197319988721e-14,  1.545702700334794e-16, -5.818763092793868e-19,
  2.157797985086168e-21, -7.906137126960664e-24,  2.861626204687226e-26, -1.027055519953312e-28,  4.621161333506044e-02, -1.882144186451403e-04,  9.875760802527618e-07,
 -5.079745918375217e-09,  2.490411178020989e-11, -1.173924161073487e-13,  5.365169419945553e-16, -2.390762064777911e-18,  1.042628092404924e-20, -4.462520069733340e-23,
  1.878423441333150e-25, -7.790005701600638e-28,  3.374571709720249e-02, -1.870710494135436e-04,  1.279023306922917e-06, -7.988790974300823e-09,  4.654747361267348e-11,
 -2.579918431657005e-13,  1.374737526382942e-15, -7.089459126416440e-18,  3.555210562208416e-20, -1.739929379188767e-22,  8.334198047612430e-25, -3.915837987155444e-27,
  2.218919732883458e-02, -1.668504993708054e-04,  1.408227650634648e-06, -1.041030876951192e-08,  7.091763435723152e-11, -4.550916329399513e-13,  2.784151636159594e-15,
 -1.636933150658214e-17,  9.304336928945161e-20, -5.135575381626153e-22,  2.762275026609491e-24, -1.451805702667170e-26,  1.313698918151775e-02, -1.315494411686672e-04,
  1.329743424881452e-06, -1.149049710609406e-08,  9.047737441746126e-11, -6.644863365918948e-13,  4.615611752958448e-15, -3.061526250703053e-17,  1.952736342866401e-19,
 -1.203978868130787e-21,  7.205041364568815e-24, -4.198446238781505e-26,  7.002573247137699e-03, -9.133360252723351e-05,  1.087579242751637e-06, -1.089117138968178e-08,
  9.821984000480112e-11, -8.182880653192567e-13,  6.400393839557506e-15, -4.752201717244456e-17,  3.376154794583325e-19, -2.308730314273238e-21,  1.526697077637773e-23,
 -9.798004879796424e-26,  3.360533955350526e-03, -5.587707386514231e-05,  7.762345041914852e-07, -8.944495999395804e-09,  9.170465104120014e-11, -8.607659409526514e-13,
  7.533049435938265e-15, -6.223238758017698e-17,  4.896292723002256e-19, -3.693165686596889e-21,  2.684331916644433e-23, -1.887673978714154e-25,  1.451911051027952e-03,
 -3.018782290091476e-05,  4.860677556080492e-07, -6.405285990893890e-09,  7.421612096059944e-11, -7.805838159231508e-13,  7.604802712099445e-15, -6.956770903220045e-17,
  6.033892376204242e-19, -4.998134112639745e-21,  3.976245468612257e-23, -3.051418222981571e-25,  5.647599489447908e-04, -1.443782855312637e-05,  2.681042645229805e-07,
 -4.019031147910650e-09,  5.237246057624471e-11, -6.145257845514826e-13,  6.637534164057515e-15, -6.697541580394419e-17,  6.380288882001131e-19, -5.783536389062662e-21,
  5.018899572673163e-23, -4.189348268454637e-25,  1.977969326177640e-04, -6.127529930043361e-06,  1.306686565050439e-07, -2.218146879461591e-09,  3.237883232385759e-11,
 -4.223192724871293e-13,  5.040130767606795e-15, -5.591908892861537e-17,  5.833229435905395e-19, -5.769661021648405e-21,  5.446383021686738e-23, -4.931615746303547e-25,
  6.238605416794840e-05, -2.312832140400419e-06,  5.641994566972910e-08, -1.080342055615517e-09,  1.760655682207052e-11, -2.545005441345284e-13,  3.346670425470553e-15,
 -4.071962147979832e-17,  4.639786105576135e-19, -4.995697079872256e-21,  5.118061005702391e-23, -5.016162497254580e-25,  1.772575301837584e-05, -7.779805168828381e-07,
  2.163177964088791e-08, -4.656681855520984e-10,  8.449100976989958e-12, -1.350096202720971e-13,  1.951667965327207e-15, -2.598533396027055e-17,  3.227584259332302e-19,
 -3.775575299090687e-21,  4.190135521932684e-23, -4.437015562229664e-25,  4.539247007860727e-06, -2.336737254375038e-07,  7.380667889111339e-09, -1.781056594298900e-10,
  3.589162790229153e-12, -6.326560462069572e-14,  1.003431887976002e-15, -1.459361546836798e-17,  1.972573031716638e-19, -2.502921080204065e-21,  3.004396903478281e-23,
 -3.432174669405899e-25,  1.048426174462840e-06, -6.279399172234617e-08,  2.245865800136751e-09, -6.059922631931337e-11,  1.353551356683425e-12, -2.627213382906072e-14,
  4.564540780749119e-16, -7.240713039687743e-18,  1.063577641102742e-19, -1.461905933045341e-21,  1.895600754461516e-23, -2.333345568356342e-25,  2.186304572029160e-07,
 -1.512827948548952e-08,  6.108618050490233e-10, -1.838926679966182e-11,  4.544645969925818e-13, -9.698722091330209e-15,  1.843395204264879e-16, -3.185539585499257e-18,
  5.079209106560085e-20, -7.554703002464084e-22,  1.057104925633033e-23, -1.400689444203383e-25,  4.122071267727192e-08, -3.275047548554014e-09,  1.488867334495656e-10,
 -4.990723391746261e-12,  1.362597814085364e-13, -3.193200711954724e-15,  6.632125577063341e-17, -1.247284493851474e-18,  2.156777606856199e-20, -3.468356880390838e-22,
  5.232895217750716e-24, -7.457861420113443e-26,  7.040175099504297e-09, -6.387805474657463e-10,  3.261060232859346e-11, -1.215045667354922e-12,  3.660103506041746e-14,
 -9.408747276541767e-16,  2.133461863485690e-17, -4.363100940693906e-19,  8.176032276902793e-21, -1.420564883858129e-22,  2.309488586914309e-24, -3.538064271298800e-26,
  1.092004607147591e-09, -1.126071278029343e-10,  6.440301901055132e-12, -2.663069753809393e-13,  8.840556822493183e-15, -2.490599648257090e-16,  6.161070782279652e-18,
 -1.369243359828050e-19,  2.778955724443957e-21, -5.213948519441185e-23,  9.129324470489611e-25, -1.502639957702860e-26,  1.543490328454304e-10, -1.801113779570144e-11,
  1.151464604374100e-12, -5.276503043401006e-14,  1.928393232188848e-15, -5.949310465233650e-17,  1.604518202551746e-18, -3.873044501694075e-20,  8.509516959783910e-22,
 -1.723350047066328e-23,  3.248568618853595e-25, -5.742625961704477e-27,  1.996820037433421e-11, -2.626423224771360e-12,  1.872998994217581e-13, -9.498903245752294e-15,
  3.818310632270916e-16, -1.289106301423544e-17,  3.788412600579922e-19, -9.927856104171805e-21,  2.360445676993996e-22, -5.158208460636513e-24,  1.046473992342213e-25,
 -1.986178872443479e-27,  2.378038717794027e-12, -3.512785737827676e-13,  2.788836947691932e-14, -1.563314310046618e-15,  6.905740395959322e-17, -2.549732296762467e-18,
  8.160916706614031e-20, -2.320891534506999e-21,  5.969449089244385e-23, -1.407174079474551e-24,  3.071649761938047e-26, -6.257777862265153e-28,  2.626367848366131e-13,
 -4.342041133919689e-14,  3.830164088959862e-15, -2.370164585720568e-16,  1.149545480338141e-17, -4.638706363228968e-19,  1.616224494787578e-20, -4.986115209801707e-22,
  1.386874849511810e-23, -3.525590840599118e-25,  8.278148301794358e-27, -1.809782616760324e-28,  2.715610808406167e-14, -5.007742826076289e-15,  4.898457780922315e-16,
 -3.341835537387352e-17,  1.777896680597169e-18, -7.835296595639332e-20,  2.970149863809872e-21, -9.935386305697540e-23,  2.987341239190829e-24, -8.186691621480283e-26,
  2.067027352792161e-27, -4.847817835884824e-29,  2.660754133465262e-15, -5.454110707871759e-16,  5.903745733017649e-17, -4.433889829784391e-18,  2.584687136732562e-19,
 -1.242982714507660e-20,  5.122753473089420e-22, -1.856940716495608e-23,  6.032478821497734e-25, -1.781315018698587e-26,  4.834146163555578e-28, -1.215724398180068e-29,
  2.508495072564244e-16, -5.695123890803727e-17,  6.805929508484026e-18, -5.617428624805681e-19,  3.583299040610176e-20, -1.878333002088385e-21,  8.408536156257689e-23,
 -3.300235835392648e-24,  1.157484237904700e-25, -3.680258033306497e-27,  1.072778721345346e-28, -2.891064160141142e-30,  2.319719211664661e-17, -5.809919031901354e-18,
  7.644852289394461e-19, -6.920038126017302e-20,  4.822055879097487e-21, -2.751161455981509e-22,  1.336006675063671e-23, -5.670878945516373e-25,  2.144948670950431e-26,
 -7.335818804122817e-28,  2.294572865386875e-29, -6.620010870692234e-31,  2.154890874894721e-18, -5.927178100616749e-19,  8.559699807323218e-20, -8.475069966539323e-21,
  6.436686843925086e-22, -3.989033779831952e-23,  2.097543395178959e-24, -9.612436938991041e-26,  3.914739585327890e-27, -1.437942255405164e-28,  4.819236937409603e-30,
 -1.486347170969905e-31,  2.070293774009553e-19, -6.221113854032352e-20,  9.820991899542121e-21, -1.060003879363597e-21,  8.747980964641535e-23, -5.872684484915226e-24,
  3.335176422258194e-25, -1.646175611571473e-26,  7.202006090579850e-28, -2.834942200116019e-29,  1.015878476995673e-30, -3.342470600183263e-32,  2.129885785927143e-20,
 -6.948988689701964e-21,  1.193186388897732e-21, -1.397665084521691e-22,  1.248326508167473e-23, -9.043739277863059e-25,  5.527551473118942e-26, -2.928636280911910e-27,
  1.371998567743853e-28, -5.769671306165031e-30,  2.203976662323329e-31, -7.713428482851385e-33,  2.442323934469399e-21, -8.588435123323526e-22,  1.593891665490226e-22,
 -2.014642217120832e-23,  1.936964325460643e-24, -1.506747801913674e-25,  9.863822252473288e-27, -5.584208658360091e-28,  2.788988607328474e-29, -1.247681312153837e-30,
  5.059750376879697e-32, -1.876050500541778e-33,  3.260672352421366e-22, -1.225194965139501e-22,  2.438264007045715e-23, -3.301118487200065e-24,  3.392782181878484e-25,
 -2.815092527177400e-26,  1.961377117362460e-27, -1.179273119966573e-28,  6.242322304560871e-30, -2.953920816424349e-31,  1.264759412493181e-32, -4.941775067914845e-34,
  5.288111366603179e-23, -2.101877100227674e-23,  4.442216330442852e-24, -6.382641352473593e-25,  6.950595386068957e-26, -6.099454980067184e-27,  4.486231139390008e-28,
 -2.842242339194183e-29,  1.582517654169786e-30, -7.863503580420968e-32,  3.529635185088802e-33, -1.443386102564037e-34,  1.073698967555126e-23, -4.462715266140808e-24,
  9.900511825753438e-25, -1.492713685509159e-25,  1.703712383983266e-26, -1.564735981566465e-27,  1.202710938514171e-28, -7.951131085506196e-30,  4.612958202890113e-31,
 -2.385097949012028e-32,  1.112494420326892e-33, -4.720943920485393e-35,  2.693564128170237e-24, -1.155830173344476e-24,  2.655609052606631e-25, -4.146122131367843e-26,
  4.896306880987882e-27, -4.648160779455467e-28,  3.688980192692161e-29, -2.515450981982969e-30,  1.503677060047244e-31, -8.002564402185461e-33,  3.838342712498376e-34,
 -1.673234120866668e-35,  6.787134568609037e-25, -2.965557727769160e-25,  6.951425475476939e-26, -1.107237298697360e-26,  1.333410208267927e-27, -1.290107162222037e-28,
  1.042887136129236e-29, -7.238828846145105e-31,  4.402181896441300e-32, -2.382046109478601e-33,  1.160986610391525e-34, -5.139812498895516e-36,  6.262506706007710e-02,
 -1.617578979091141e-04,  4.319477416367449e-07, -1.187087251477822e-09,  3.334984861747558e-12, -9.533486190722764e-15,  2.751038569245668e-17, -8.021493735120376e-20,
  2.332479726057049e-22, -6.880237173857691e-25,  1.979650189680997e-27, -5.976506874231003e-30,  5.628918228934788e-02, -1.713672926729947e-04,  6.297023463049158e-07,
 -2.455901665749290e-09,  9.589205466107510e-12, -3.687024986623420e-14,  1.392031641725011e-16, -5.171683319115923e-19,  1.892736829938514e-21, -6.846950061862255e-24,
  2.445943616125595e-26, -8.672243310121273e-29,  4.547418015058978e-02, -1.805510378902036e-04,  9.289346506199424e-07, -4.699385398653551e-09,  2.267979400661386e-11,
 -1.052830382998140e-13,  4.740150298098961e-16, -2.081439492282591e-18,  8.947152611890251e-21, -3.775429319303503e-23,  1.567076822086884e-25, -6.409604312354315e-28,
  3.301730749583278e-02, -1.772100448388627e-04,  1.187461725972354e-06, -7.283582684370150e-09,  4.170213551166322e-11, -2.272572101269197e-13,  1.191262356377712e-15,
 -6.045900006626371e-18,  2.984911648545929e-20, -1.438611644859779e-22,  6.787969897342948e-25, -3.142379711428046e-27,  2.154356213946051e-02, -1.560657522919029e-04,
  1.289823026387056e-06, -9.344960741867519e-09,  6.244854143026555e-11, -3.934519946151538e-13,  2.364859507296261e-15, -1.366761713000852e-17,  7.639930551761213e-20,
 -4.148530538809879e-22,  2.195915964122839e-24, -1.136111720832923e-26,  1.263122749309517e-02, -1.214394000977638e-04,  1.200123456050263e-06, -1.014343741917688e-08,
  7.822944538054449e-11, -5.633304196494139e-13,  3.839727644970448e-15, -2.500779622848710e-17,  1.567018133520809e-19, -9.495818516777204e-22,  5.587270300328500e-24,
 -3.202183254689537e-26,  6.653848518125145e-03, -8.313022074933680e-05,  9.658000705210013e-07, -9.442665315922259e-09,  8.328839145234272e-11, -6.794979768064925e-13,
  5.209328124315756e-15, -3.793823163602387e-17,  2.645283240032734e-19, -1.776275878436979e-21,  1.153900411756165e-23, -7.277779438530963e-26,  3.148799196826284e-03,
 -5.007283733596682e-05,  6.771663673769349e-07, -7.605683139440417e-09,  7.616477565414226e-11, -6.992281608259141e-13,  5.991297530808794e-15, -4.849950248441467e-17,
  3.741555097779205e-19, -2.768825671855148e-21,  1.975422434910041e-23, -1.364165379786648e-25,  1.338477053810015e-03, -2.658767299392521e-05,  4.158442891593573e-07,
 -5.333429860220071e-09,  6.028242632308093e-11, -6.194173453738827e-13,  5.902220664157395e-15, -5.285567541457639e-17,  4.491202668462834e-19, -3.646946724337279e-21,
  2.845702169406324e-23, -2.143004444079860e-25,  5.110118032797448e-04, -1.247254347387661e-05,  2.245244495305157e-07, -3.271338992545307e-09,  4.153420766434727e-11,
 -4.756009656933632e-13,  5.019325747848331e-15, -4.953573876746169e-17,  4.619159458609359e-19, -4.101442794679198e-21,  3.488455634472097e-23, -2.855507477673633e-25,
  1.752205701222949e-04, -5.180446408074970e-06,  1.069004523516073e-07, -1.761581034619985e-09,  2.502539202806369e-11, -3.182135293500104e-13,  3.707268159285887e-15,
 -4.019468451497441e-17,  4.101068373080496e-19, -3.970484032560040e-21,  3.671040035616952e-23, -3.257677618478037e-25,  5.396162314633124e-05, -1.908900307063011e-06,
  4.499124551817187e-08, -8.353526389782098e-10,  1.323540860518624e-11, -1.863375504139654e-13,  2.389931970832330e-15, -2.839419514571447e-17,  3.162178771568618e-19,
 -3.330397623831813e-21,  3.339797131309606e-23, -3.206045469924898e-25,  1.492754196452846e-05, -6.251700254399403e-07,  1.677338392580834e-08, -3.497670190476642e-10,
  6.163912175553630e-12, -9.584847230661715e-14,  1.350343414789288e-15, -1.754300705296662e-17,  2.128257862602651e-19, -2.433722585847177e-21,  2.642284917596352e-23,
 -2.739004098888416e-25,  3.710368142039481e-06, -1.822895054460291e-07,  5.550091911028286e-09, -1.296201650540731e-10,  2.534937076489141e-12, -4.344905345540893e-14,
  6.711330305002878e-16, -9.517769816338487e-18,  1.255775744658367e-19, -1.556764123838897e-21,  1.827131542531111e-23, -2.042310952313657e-25,  8.290501186287191e-07,
 -4.740404491993091e-08,  1.633031516844894e-09, -4.261331736445790e-11,  9.230345473727909e-13, -1.740938034865483e-14,  2.943880326760278e-16, -4.550962326223624e-18,
  6.521747826930350e-20, -8.753760235776690e-22,  1.109325341081519e-23, -1.335507931012338e-25,  1.666504204820692e-07, -1.101377399187992e-08,  4.281211417892228e-10,
 -1.245656743425492e-11,  2.983591385008008e-13, -6.183736077671458e-15,  1.143293700216175e-16, -1.924444240309999e-18,  2.992205735613213e-20, -4.344187973093488e-22,
  5.938490323812620e-24, -7.693058929773359e-26,  3.016998195136822e-08, -2.290791260804927e-09,  1.002222575549085e-10, -3.245601855197604e-12,  8.584291836209173e-14,
 -1.952826413547659e-15,  3.943722451724405e-17, -7.221500880073531e-19,  1.217246591671353e-20, -1.910046321362456e-22,  2.814443020826782e-24, -3.920486661079818e-26,
  4.926853245168199e-09, -4.275304761414379e-10,  2.100270444624847e-11, -7.558252985139282e-13,  2.204913924355001e-14, -5.500355719310026e-16,  1.212338871648981e-17,
 -2.413317610077630e-19,  4.407113808898977e-21, -7.469834960132514e-23,  1.185762497019568e-24, -1.775150660752173e-26,  7.273359056413662e-10, -7.179499808952831e-11,
  3.951786046657603e-12, -1.578163253382507e-13,  5.072867645028470e-15, -1.386632519058559e-16,  3.333609173335080e-18, -7.210131988631359e-20,  1.425825890091971e-21,
 -2.609317637323479e-23,  4.460420471225374e-25, -7.173538600558550e-27,  9.735418385318140e-11, -1.088608427729304e-11,  6.700334220596877e-13, -2.965724716265572e-14,
  1.049535894059318e-15, -3.141554331751550e-17,  8.233952340202103e-19, -1.934209039201699e-20,  4.140599700744327e-22, -8.178927469080750e-24,  1.505172518606126e-25,
 -2.599842902112280e-27,  1.186171572319043e-11, -1.496911921637269e-12,  1.028354087175610e-13, -5.039268424002184e-15,  1.961914230679814e-16, -6.427533114373369e-18,
  1.835926387227116e-19, -4.682640376520383e-21,  1.084887676268782e-22, -2.312612196792180e-24,  4.580941140579301e-26, -8.496538689821214e-28,  1.322488608661915e-12,
 -1.877070675629006e-13,  1.436782168371898e-14, -7.786717354196019e-16,  3.332918190675865e-17, -1.194574945123507e-18,  3.717387523820127e-20, -1.029241179453192e-21,
  2.580308554910283e-23, -5.934920717472977e-25,  1.265251318122830e-26, -2.519646674888143e-28,  1.358567425109884e-13, -2.161764443022759e-14,  1.840559353962109e-15,
 -1.102079236484455e-16,  5.182771435584574e-18, -2.031383790001258e-19,  6.885029904113875e-21, -2.068912028025793e-22,  5.611684037254362e-24, -1.392552496687755e-25,
  3.194776348073401e-27, -6.830238436949378e-29,  1.297535417817258e-14, -2.307415736279617e-15,  2.181538180200686e-16, -1.441690699971316e-17,  7.443976673579681e-19,
 -3.189160661133382e-20,  1.176901083974352e-21, -3.837349396160369e-23,  1.125903624555703e-24, -3.013912604151414e-26,  7.439946224234669e-28, -1.707420600408134e-29,
  1.165635943639848e-15, -2.309291027438591e-16,  2.420112810531593e-17, -1.763149310057577e-18,  9.987568149179844e-20, -4.674370568148185e-21,  1.877364088539305e-22,
 -6.639674158434539e-24,  2.106745556532117e-25, -6.081972589338320e-27,  1.615079161515074e-28, -3.977768624156137e-30,  9.998074609837414e-17, -2.199365603271795e-17,
  2.549824968388900e-18, -2.045084533849495e-19,  1.269633821942888e-20, -6.486207596839176e-22,  2.833342683980836e-23, -1.086344480313167e-24,  3.725796655319863e-26,
 -1.159478044883332e-27,  3.310854656501519e-29, -8.747415083331600e-31,  8.345949835079420e-18, -2.031103959105886e-18,  2.598875360021103e-19, -2.290771889451931e-20,
  1.556503795815526e-21, -8.669964730947633e-23,  4.115117594380887e-24, -1.708995465868553e-25,  6.330385060080904e-27, -2.122055383291374e-28,  6.511003570067412e-30,
 -1.844040355824695e-31,  6.945617675802614e-19, -1.862178937947985e-19,  2.622204482215449e-20, -2.534384806200480e-21,  1.881114480261354e-22, -1.140555303604699e-23,
  5.873415503883959e-25, -2.638423546310235e-26,  1.054176765317283e-27, -3.801821116125801e-29,  1.251939658744462e-30, -3.796504032042651e-32,  5.938003486999809e-20,
 -1.745241479773142e-20,  2.694692205256603e-21, -2.847108833207832e-22,  2.302310403614913e-23, -1.515844331124485e-24,  8.450368965583064e-26, -4.097531987991145e-27,
  1.762439860840534e-28, -6.825305309990248e-30,  2.407789369694509e-31, -7.803994629789302e-33,  5.408887584235390e-21, -1.732378518117984e-21,  2.919195683910060e-22,
 -3.357892649667269e-23,  2.947358670458129e-24, -2.100026165893608e-25,  1.263270663484769e-26, -6.591922890481160e-28,  3.043411131531408e-29, -1.262053437475632e-30,
  4.756597401604619e-32, -1.643379125944772e-33,  5.479879433164086e-22, -1.898876316021405e-22,  3.470902246427679e-23, -4.322836960272193e-24,  4.097620543901392e-25,
 -3.144480415486754e-26,  2.031901949014108e-27, -1.136074616451960e-28,  5.606667507922258e-30, -2.479628322375885e-31,  9.945726129405820e-33, -3.648999274546174e-34,
  6.478169519768148e-23, -2.407674133774149e-23,  4.736742156076169e-24, -6.341334996022778e-25,  6.447245555018595e-26, -5.294187588848871e-27,  3.652104957088577e-28,
 -2.174962560011334e-29,  1.140800736464349e-30, -5.351193424881459e-32,  2.271962505508446e-33, -8.805833132901869e-35,  9.379173045215860e-24, -3.700396207758593e-24,
  7.758886924471440e-25, -1.106163734702396e-25,  1.195568291727660e-26, -1.041605144824508e-27,  7.608167873273493e-29, -4.788162207110515e-30,  2.649008972454270e-31,
 -1.308248629828648e-32,  5.837810377255870e-34, -2.373864064492234e-35,  1.726546166308632e-24, -7.144840907674794e-25,  1.577573905029051e-25, -2.367406742485452e-26,
  2.689799192948150e-27, -2.459598784708224e-28,  1.882599389821034e-29, -1.239570972477506e-30,  7.163704296844246e-32, -3.690173924008467e-33,  1.715081286549102e-34,
 -7.253148983978028e-36,  4.019666349392984e-25, -1.721304153329825e-25,  3.945848575038753e-26, -6.146638738066167e-27,  7.242859170255987e-28, -6.861203995862394e-29,
  5.434210975587347e-30, -3.698195832892490e-31,  2.206502625399065e-32, -1.172156599225354e-33,  5.612240375720435e-35, -2.442392701589209e-36,  9.690084735177542e-26,
 -4.230978588094605e-26,  9.909832040389514e-27, -1.577210736563682e-27,  1.897909082029882e-28, -1.834882623408409e-29,  1.482175580537637e-30, -1.028062671670347e-31,
  6.247657081956692e-33, -3.378360837436216e-34,  1.645501278460204e-35, -7.280184870958401e-37,  6.198485767549385e-02, -1.583584033097703e-04,  4.180166752180706e-07,
 -1.135217726697290e-09,  3.150739966790455e-12, -8.899368080893737e-15,  2.536524500084211e-17, -7.313252196171010e-20,  2.098431181057528e-22, -6.138763590415120e-25,
  1.732946522938284e-27, -5.258373256631741e-30,  5.561360531749346e-02, -1.664450038060284e-04,  6.011283305075249e-07, -2.308196900504673e-09,  8.884070719389972e-12,
 -3.369651953536981e-14,  1.255346455306258e-16, -4.603629846536151e-19,  1.662975452514187e-21, -5.940790096085746e-24,  2.094556962205482e-26, -7.339603428823074e-29,
  4.476649030314377e-02, -1.733391183908402e-04,  8.746517487194712e-07, -4.352755113984079e-09,  2.068333817138313e-11, -9.457490228280798e-14,  4.195470382674682e-16,
 -1.815720351097635e-18,  7.694349939260386e-21, -3.201532399718597e-23,  1.310572710482609e-25, -5.287755452312135e-28,  3.232692872237934e-02, -1.680489556357332e-04,
  1.103917028181067e-06, -6.651211938292146e-09,  3.742972034824723e-11, -2.005950060953894e-13,  1.034606835722357e-15, -5.168610823554687e-18,  2.512728179917195e-20,
 -1.192838933892621e-22,  5.545248306347053e-25, -2.529707882642994e-27,  2.093924929793429e-02, -1.461793188314853e-04,  1.183428524380717e-06, -8.405777937769013e-09,
  5.511744098715716e-11, -3.410246428312407e-13,  2.014263361956664e-15, -1.144577343775775e-17,  6.293221381028112e-20, -3.362511216866902e-22,  1.751911248767372e-24,
 -8.924007715789732e-27,  1.216392991753402e-02, -1.123048439103290e-04,  1.085556027893977e-06, -8.977120425114234e-09,  6.783045374915969e-11, -4.790430522518622e-13,
  3.204864900903028e-15, -2.049977518270008e-17,  1.262219163943778e-19, -7.519101666044674e-22,  4.350807817244586e-24, -2.452980205880981e-26,  6.336093468208337e-03,
 -7.583540410711005e-05,  8.600563608340886e-07, -8.212322454519709e-09,  7.086733064892312e-11, -5.663208628165894e-13,  4.256553724218496e-15, -3.041328419691315e-17,
  2.081727568763819e-19, -1.372912416787638e-21,  8.763323131634040e-24, -5.432896044338596e-26,  2.958792384719684e-03, -4.500087663455936e-05,  5.927725993774171e-07,
 -6.491549085131218e-09,  6.351474731545408e-11, -5.704668335541775e-13,  4.786971130844673e-15, -3.797987752807433e-17,  2.873642237355648e-19, -2.086814217042053e-21,
  1.461728451141221e-23, -9.914660790380135e-26,  1.238396497008514e-03, -2.350142038940751e-05,  3.572450515083557e-07, -4.460796766576609e-09,  4.919864127591608e-11,
 -4.940134286151371e-13,  4.605195955535573e-15, -4.038198191671418e-17,  3.362336208659487e-19, -2.677075978213700e-21,  2.049309548827714e-23, -1.514727251548071e-25,
  4.644804456947419e-04, -1.082275745953328e-05,  1.889617507353840e-07, -2.676785810763961e-09,  3.312256601962168e-11, -3.702382449853927e-13,  3.818852947086048e-15,
 -3.687034153829788e-17,  3.366212401665322e-19, -2.928406898478909e-21,  2.441747011983921e-23, -1.960424048044406e-25,  1.560843209896388e-04, -4.403445845870492e-06,
  8.796857132355505e-08, -1.407612219848415e-09,  1.946684265860410e-11, -2.413841561775573e-13,  2.745925610599506e-15, -2.910070637730678e-17,  2.904755156631976e-19,
 -2.753305378329423e-21,  2.493885785758146e-23, -2.169292298828114e-25,  4.698712798527025e-05, -1.585731487159373e-06,  3.612403337499683e-08, -6.505347123101136e-10,
  1.002331410700020e-11, -1.374783928752255e-13,  1.720225894985403e-15, -1.996097810131823e-17,  2.173176872909130e-19, -2.239263654586801e-21,  2.198509955284639e-23,
 -2.067483039671251e-25,  1.267084203690568e-05, -5.062302127193040e-07,  1.310993400006433e-08, -2.648734653519234e-10,  4.534896158975197e-12, -6.863930901488418e-14,
  9.426421577101984e-16, -1.195187674763237e-17,  1.416493015353275e-19, -1.583745031287324e-21,  1.682426282613878e-23, -1.707551668251375e-25,  3.061053453015078e-06,
 -1.434818107471005e-07,  4.211933117039019e-09, -9.522091941124999e-11,  1.807585737068400e-12, -3.013288750517493e-14,  4.533812604699864e-16, -6.270817064972562e-18,
  8.077668685686940e-20, -9.785156231943513e-22,  1.123109690495935e-23, -1.228516733729547e-25,  6.626462865017804e-07, -3.615833389886390e-08,  1.199927405813853e-09,
 -3.028581079680907e-11,  6.362840044508630e-13, -1.166368357816741e-14,  1.919908469273408e-16, -2.892894192165051e-18,  4.045136112961653e-20, -5.302831761757382e-22,
  6.568547795570471e-24, -7.735160737123966e-26,  1.286018592901047e-07, -8.114080737145339e-09,  3.036407250146667e-10, -8.539677769710819e-12,  1.982621700512053e-13,
 -3.991208016821610e-15,  7.179105021025457e-17, -1.177214792185226e-18,  1.785121360097497e-20, -2.530062383568840e-22,  3.379195377938568e-24, -4.280363702753653e-26,
  2.239314028403321e-08, -1.624118176152402e-09,  6.837663124718434e-11, -2.139298577265281e-12,  5.481658686837886e-14, -1.210612704877619e-15,  2.377389318611022e-17,
 -4.239030005575903e-19,  6.965701590762185e-21, -1.066625020947579e-22,  1.535053547061529e-24, -2.090148280297195e-26,  3.502813227393260e-09, -2.905347770923590e-10,
  1.373205312894156e-11, -4.772755164011376e-13,  1.348359725994160e-14, -3.264173198463038e-16,  6.993579733528851e-18, -1.355143951150612e-19,  2.411758741444989e-21,
 -3.987905989686855e-23,  6.181286410370721e-25, -9.043113602148705e-27,  4.930923775954071e-10, -4.656166543201658e-11,  2.465874621463089e-12, -9.509320076397744e-14,
  2.959509282736806e-15, -7.848548434110747e-17,  1.833706876047830e-18, -3.859698177255617e-20,  7.436905276980547e-22, -1.327463539549565e-23,  2.215355116547384e-25,
 -3.481264004430644e-27,  6.262428571902256e-11, -6.705482572327006e-12,  3.972005267680715e-13, -1.697776826479185e-14,  5.816906704397350e-16, -1.689122381432454e-17,
  4.301965047332150e-19, -9.833591797699995e-21,  2.050910912807226e-22, -3.951068438299064e-24,  7.098191016161430e-26, -1.197907939816645e-27,  7.200626860768471e-12,
 -8.711596569624070e-13,  5.762514889902209e-14, -2.727601034852820e-15,  1.028245874398059e-16, -3.268268061077798e-18,  9.071811406514411e-20, -2.251640117492808e-21,
  5.082609636396738e-23, -1.056721997047880e-24,  2.043529617930234e-26, -3.703510878499120e-28,  7.531155123800783e-13, -1.026186291951673e-13,  7.568743817804873e-15,
 -3.964041697096808e-16,  1.643470757549233e-17, -5.716443743689208e-19,  1.729088812294467e-20, -4.659703439498757e-22,  1.138398711548622e-23, -2.554348352571557e-25,
  5.317376989137982e-27, -1.034893186509892e-28,  7.210551222753558e-14, -1.103235471580804e-14,  9.060045961169968e-16, -5.246386481055569e-17,  2.391194021026445e-18,
 -9.099839579775294e-20,  2.999196591878564e-21, -8.775636867114722e-23,  2.320482773179015e-24, -5.619540049595393e-26,  1.259342683288320e-27, -2.632286034759214e-29,
  6.373061976148734e-15, -1.091780442395413e-15,  9.968959751516291e-17, -6.377669008987096e-18,  3.194226227550604e-19, -1.329679569933868e-20,  4.774846024435484e-22,
 -1.516909571382522e-23,  4.341458670119035e-25, -1.134794298708446e-26,  2.737864123563869e-28, -6.146303171691051e-30,  5.258010243359800e-16, -1.005655787526767e-16,
  1.019471468890108e-17, -7.199455563483178e-19,  3.960348282805847e-20, -1.802802581561395e-21,  7.052258872204108e-23, -2.432291468288017e-24,  7.534391422129674e-26,
 -2.125589470846530e-27,  5.521031317350235e-29, -1.331145440998190e-30,  4.108599181244508e-17, -8.746898684222400e-18,  9.828182455462591e-19, -7.653476087089028e-20,
  4.620849921985874e-21, -2.299120838572864e-22,  9.793981104330298e-24, -3.666230077686965e-25,  1.228900892987392e-26, -3.741260167585408e-28,  1.045996128938706e-29,
 -2.708072643128704e-31,  3.098444262372235e-18, -7.317976476195842e-19,  9.095892488287310e-20, -7.800056438226882e-21,  5.163555907680464e-22, -2.805874946954660e-23,
  1.300766856737445e-24, -5.281891700253923e-26,  1.914843179238687e-27, -6.287838141785005e-29,  1.891429081657727e-30, -5.255922090446680e-32,  2.310312891756816e-19,
 -6.030207217632474e-20,  8.270636678817453e-21, -7.795434165964527e-22,  5.649600697416349e-23, -3.348543993976122e-24,  1.687438549967984e-25, -7.425072692999760e-27,
  2.908541047834315e-28, -1.029236189865489e-29,  3.328109610311937e-31, -9.917564143604958e-33,  1.756179078414726e-20, -5.042396660288753e-21,  7.606412390000162e-22,
 -7.859252300498835e-23,  6.221542538814673e-24, -4.013995847538513e-25,  2.194763019285585e-26, -1.044709637005356e-27,  4.414614222126759e-29, -1.680833259714743e-30,
  5.833667321801635e-32, -1.861434937797386e-33,  1.413623974434457e-21, -4.439613808855634e-22,  7.333956688523757e-23, -8.276053800794705e-24,  7.132355301392617e-25,
 -4.993729664576375e-26,  2.954167280941597e-27, -1.517069871388609e-28,  6.897698888706800e-30, -2.818689247793138e-31,  1.047488948113162e-32, -3.570476712716822e-34,
  1.261296864998884e-22, -4.302505694097538e-23,  7.738337527408671e-24, -9.487826009821066e-25,  8.859285716351606e-26, -6.701415120846292e-27,  4.271125671499340e-28,
 -2.356814246190127e-29,  1.148534396709688e-30, -5.018497329924150e-32,  1.989688211082071e-33, -7.219284260707411e-35,  1.314443730302177e-23, -4.828116845777599e-24,
  9.382356923006775e-25, -1.241071559479368e-25,  1.247301039129047e-26, -1.012943350497059e-27,  6.913877100469964e-29, -4.075847506641379e-30,  2.117136391602156e-31,
 -9.838698383201901e-33,  4.140010355661812e-34, -1.590919893563569e-35,  1.689784391755350e-24, -6.613489328378512e-25,  1.374908023331290e-25, -1.943822216141819e-26,
  2.084018546799573e-27, -1.801605296020627e-28,  1.306185799863924e-29, -8.161999935048231e-31,  4.484795196878073e-32, -2.200407851138151e-33,  9.757365465843049e-35,
 -3.943886154152946e-36,  2.804211741301519e-25, -1.154944141511396e-25,  2.537037639477586e-26, -3.787997972691795e-27,  4.282790847915926e-28, -3.897819625879567e-29,
  2.969937901653824e-30, -1.947029528924532e-31,  1.120539549730661e-32, -5.749076486132794e-34,  2.661751492426863e-35, -1.121531629534646e-36,  6.028664738930436e-26,
 -2.575808678338426e-26,  5.890166005123359e-27, -9.153021337156539e-28,  1.075985187479550e-28, -1.016954728713628e-29,  8.036734180410484e-31, -5.457719052229588e-32,
  3.249668904706584e-33, -1.722929691315152e-34,  8.233752873476528e-36, -3.576760038280370e-37,  1.385891322271004e-26, -6.046647601639886e-27,  1.415060635566428e-27,
 -2.250258070119421e-28,  2.705569131621321e-29, -2.613613063178556e-30,  2.109562020496449e-31, -1.462116070299326e-32,  8.878894280507484e-34, -4.797740260694489e-35,
  2.335216550691477e-36, -1.032474486601853e-37,  6.135802724482739e-02, -1.550679166731834e-04,  4.046907652243551e-07, -1.086197392669062e-09,  2.978678236015296e-12,
 -8.314435888211568e-15,  2.340831461932623e-17, -6.675819799719298e-20,  1.889372214075775e-22, -5.490018691201762e-25,  1.515120463241264e-27, -4.662010181948251e-30,
  5.495727127786205e-02, -1.617444043224648e-04,  5.742611173260421e-07, -2.171283791886636e-09,  8.239254800029672e-12, -3.083254867208792e-14,  1.133584606895172e-16,
 -4.104140745566784e-19,  1.463440947102527e-21, -5.164134189600560e-24,  1.796824818472673e-26, -6.226574581956345e-29,  4.408680520542015e-02, -1.665453510618536e-04,
  8.243435944927125e-07, -4.036423396655515e-09,  1.888855276221325e-11, -8.508906251272219e-14,  3.719876285691834e-16, -1.586974007371821e-18,  6.630812216614735e-21,
 -2.721008985689262e-23,  1.098698361580433e-25, -4.373523506239327e-28,  3.167190406195138e-02, -1.595269930764302e-04,  1.027567584931528e-06, -6.083130106230128e-09,
  3.365485673911211e-11, -1.774140550490463e-13,  9.005264960800804e-16, -4.429172888672938e-18,  2.120688814495640e-20, -9.917761323797820e-23,  4.543324586443182e-25,
 -2.042788831456701e-27,  2.037284854241496e-02, -1.371008778509504e-04,  1.087633607271349e-06, -7.575941233690402e-09,  4.875554263830929e-11, -2.963112589953710e-13,
  1.720247701372629e-15, -9.612830461714474e-18,  5.199936322015366e-20, -2.734369567187520e-22,  1.402538410701013e-24, -7.035282688473121e-27,  1.173142229713804e-02,
 -1.040335495146156e-04,  9.840391611385732e-07, -7.964488164948547e-09,  5.897452369972261e-11, -4.085816615665720e-13,  2.683577055786332e-15, -1.686218810668658e-17,
  1.020420460943050e-19, -5.976831300453230e-22,  3.401709985026788e-24, -1.887037549721354e-26,  6.045914738931094e-03, -6.933069491491767e-05,  7.679552032966417e-07,
 -7.163782509708387e-09,  6.049721394575892e-11, -4.736730449095549e-13,  3.491269513675845e-15, -2.447931313250273e-17,  1.645210880629675e-19, -1.065891290225741e-21,
  6.686448035625148e-24, -4.075442747922527e-26,  2.787803177473168e-03, -4.055384246084918e-05,  5.206141933617741e-07, -5.560689335747250e-09,  5.317323509090986e-11,
 -4.673672390637023e-13,  3.841737589688322e-15, -2.988139293080631e-17,  2.217906195506711e-19, -1.580869691128042e-21,  1.087396434495961e-23, -7.245857923492592e-26,
  1.149785664916878e-03, -2.084490990047375e-05,  3.081309632160620e-07, -3.747019129020097e-09,  4.033795865341295e-11, -3.959249514905844e-13,  3.611701494523491e-15,
 -3.101846879232606e-17,  2.531375253151908e-19, -1.976624522786395e-21,  1.484735206362213e-23, -1.077348895509950e-25,  4.240213839856854e-04, -9.431071901257714e-06,
  1.597909519885109e-07, -2.201413380319549e-09,  2.655660457255451e-11, -2.898480529538912e-13,  2.922693340863281e-15, -2.761238962966305e-17,  2.468813690494364e-19,
 -2.104695919100756e-21,  1.720766174336426e-23, -1.355367352036664e-25,  1.397780754666449e-04, -3.762312623611302e-06,  7.279761292054234e-08, -1.131442765665056e-09,
  1.523724469813374e-11, -1.842945574663778e-13,  2.047609576375939e-15, -2.121610300750069e-17,  2.072274106310960e-19, -1.923461280041737e-21,  1.707146056621882e-23,
 -1.455858545387399e-25,  4.117633665100175e-05, -1.325433827473536e-06,  2.919589831726573e-08, -5.100918432417476e-10,  7.645094873796842e-12, -1.021828711921895e-13,
  1.247672203982022e-15, -1.414323169768005e-17,  1.505609919508096e-19, -1.518142107439911e-21,  1.459552651307966e-23, -1.344863058671479e-25,  1.083716300667195e-05,
 -4.129280506647093e-07,  1.032519212925768e-08, -2.021734094123849e-10,  3.363676637743612e-12, -4.956790156170647e-14,  6.637245882642479e-16, -8.214853212678400e-18,
  9.513154831448159e-20, -1.040167192845021e-21,  1.081373431887829e-23, -1.074765881270234e-25,  2.547918577554331e-06, -1.139075239666015e-07,  3.224686373328081e-09,
 -7.058443198836872e-11,  1.300899208668777e-12, -2.109633582457175e-14,  3.092524823554816e-16, -4.172460574679788e-18,  5.248308953428265e-20, -6.213671215228627e-22,
  6.975612762730894e-24, -7.468212207232946e-26,  5.351329208882763e-07, -2.785579334942458e-08,  8.906245044952221e-10, -2.174621810556220e-11,  4.432142630914536e-13,
 -7.897622175451297e-15,  1.265684313604992e-16, -1.859171839094139e-18,  2.537054025084616e-20, -3.248738774210961e-22,  3.934018877362274e-24, -4.532192732673465e-26,
  1.004236102420035e-07, -6.046441853666149e-09,  2.178387641214577e-10, -5.922605854940724e-12,  1.332989534801530e-13, -2.606784073378364e-15,  4.562373061262562e-17,
 -7.289086962178099e-19,  1.078121708836071e-20, -1.491872293276147e-22,  1.947061295233634e-24, -2.411791264537681e-26,  1.684696179439826e-08, -1.166538406061008e-09,
  4.725883012814693e-11, -1.428554064768339e-12,  3.546518502433603e-14, -7.604476945637262e-16,  1.452308021634389e-17, -2.521807500176072e-19,  4.040159031630912e-21,
 -6.037625005862691e-23,  8.487471126325993e-25, -1.129725256068360e-26,  2.528705111659050e-09, -2.003627651171949e-10,  9.110096456441792e-12, -3.057937552711994e-13,
  8.366369636966422e-15, -1.965567331547097e-16,  4.093805003957174e-18, -7.722007622168845e-20,  1.339397283316873e-21, -2.160709455666522e-23,  3.270379305363687e-25,
 -4.675820881117187e-27,  3.400693510566940e-10, -3.069956405301130e-11,  1.563915512508063e-12, -5.823174623484831e-14,  1.754576526434281e-15, -4.514302675725288e-17,
  1.024973793073892e-18, -2.099565007483111e-20,  3.941705009926174e-22, -6.862548936368143e-24,  1.118096382133296e-25, -1.716758966260097e-27,  4.106085530728885e-11,
 -4.207037303962473e-12,  2.397515616264075e-13, -9.894119721713149e-15,  3.281497106665542e-16, -9.243105764936784e-18,  2.287340818044785e-19, -5.087422756305597e-21,
  1.033671337055347e-22, -1.942059077747250e-24,  3.405788266470761e-26, -5.615489812741675e-28,  4.464480684404174e-12, -5.174086337512072e-13,  3.293974193450100e-14,
 -1.505563622491458e-15,  5.494378805030957e-17, -1.694008478184377e-18,  4.568672987410087e-20, -1.103330750667272e-21,  2.426243248630771e-23, -4.919435616494020e-25,
  9.286615643852045e-27, -1.644337163987756e-28,  4.389403907288394e-13, -5.736760345144678e-14,  4.074827748570745e-15, -2.061560478437297e-16,  8.276212105158730e-18,
 -2.792879797465954e-19,  8.209327766437533e-21, -2.152871740410515e-22,  5.124501657373082e-24, -1.121505163065052e-25,  2.279291040054980e-27, -4.334727591476478e-29,
  3.924836423979296e-14, -5.768695481475919e-15,  4.566370842909535e-16, -2.555895393992285e-17,  1.128540795678371e-18, -4.168362796319834e-20,  1.335526683503735e-21,
 -3.803956380821264e-23,  9.803144084210580e-25, -2.316226830185083e-26,  5.069132708691801e-28, -1.035657613652120e-29,  3.216623175886032e-15, -5.302917237331436e-16,
  4.672733529100206e-17, -2.892104619186307e-18,  1.404291987337720e-19, -5.677353216232101e-21,  1.983010023016540e-22, -6.135747329672106e-24,  1.712359106780579e-25,
 -4.369011199022615e-27,  1.029902184037939e-28, -2.260986574591502e-30,  2.441661291444673e-16, -4.503368861263599e-17,  4.412158939084248e-18, -3.018062546437799e-19,
  1.611195694909271e-20, -7.129644659753427e-22,  2.715055519460104e-23, -9.127436939026879e-25,  2.759029321571307e-26, -7.603358170650012e-28,  1.930928839241636e-29,
 -4.555829352746474e-31,  1.740720734035185e-17, -3.582200940356550e-18,  3.897202598545132e-19, -2.944153411730460e-20,  1.727423115318392e-21, -8.365209330059791e-23,
  3.472948942638186e-24, -1.268543060220935e-25,  4.153537865694085e-27, -1.236403963924364e-28,  3.382998685903724e-30, -8.578805375712761e-32,  1.187189864667068e-18,
 -2.717794398256257e-19,  3.278042930576064e-20, -2.732256982377558e-21,  1.760739128419435e-22, -9.326916835959165e-24,  4.220193523089988e-25, -1.674447598939986e-26,
  5.937519825991626e-28, -1.908819782923893e-29,  5.626186126584875e-31, -1.533145487974460e-32,  7.934118694534742e-20, -2.013529833186166e-20,  2.686854851001554e-21,
 -2.467229349816474e-22,  1.744333682816168e-23, -1.009820795914095e-24,  4.975986555364237e-26, -2.143177315974714e-27,  8.225153920849540e-29, -2.854089230356754e-30,
  9.056850226977130e-32, -2.650575879988015e-33,  5.359566381217505e-21, -1.501426155756090e-21,  2.210263987051493e-22, -2.231025468263220e-23,  1.727297964432685e-24,
 -1.091071799240901e-25,  5.846533861067296e-27, -2.729823637256518e-28,  1.132460512473431e-29, -4.236255173064400e-31,  1.445565901016611e-32, -4.538199328933128e-34,
  3.805891176538194e-22, -1.170644960222704e-22,  1.893694834415789e-23, -2.094268091074700e-24,  1.770408918103952e-25, -1.216976116873446e-26,  7.074094678757585e-28,
 -3.572382773786886e-29,  1.598407893380956e-30, -6.432122018755155e-32,  2.355338268208321e-33, -7.915761025985491e-35,  2.981548339191832e-23, -1.000136944112892e-23,
  1.768160345446629e-24, -2.132148383633728e-25,  1.959429928997610e-26, -1.459767873432860e-27,  9.169361097356586e-29, -4.989742194496663e-30,  2.399453546877552e-31,
 -1.035144372714616e-32,  4.054145539478349e-34, -1.453850262879371e-35,  2.727065165679075e-24, -9.890916460748460e-25,  1.896893966663113e-25, -2.477149457892645e-26,
  2.459059164381876e-27, -1.973571060245738e-28,  1.331929506797730e-29, -7.767502012026144e-31,  3.993159391252758e-32, -1.837379850349790e-33,  7.658337641062639e-35,
 -2.916284104258829e-36,  3.095734584930387e-25, -1.201139749706030e-25,  2.474220414895702e-26, -3.466622618376837e-27,  3.684500828379805e-28, -3.158766169772122e-29,
  2.271936415726070e-30, -1.408861959277700e-31,  7.684852481063064e-33, -3.744125615516731e-34,  1.649150478778879e-35, -6.623059514065940e-37,  4.603791484170204e-26,
 -1.886353620643234e-26,  4.120702286993528e-27, -6.118899505328879e-28,  6.881589757646630e-29, -6.231192594282859e-30,  4.724702430703784e-31, -3.082940500275945e-32,
  1.766321227101683e-33, -9.023415887343078e-35,  4.160517359423871e-36, -1.746125457794458e-37,  9.090687678823538e-27, -3.874625495048427e-27,  8.836587934901384e-28,
 -1.369535398901212e-28,  1.605832999477185e-29, -1.513981814215870e-30,  1.193615416803125e-31, -8.087270881028762e-33,  4.804794771687317e-34, -2.542058410326890e-35,
  1.212365872436329e-36, -5.256297143215291e-38,  1.985834673619200e-27, -8.657202255034183e-28,  2.024172575654354e-28, -3.215982602527008e-29,  3.863283056173508e-30,
 -3.728772269487007e-31,  3.007145342800962e-32, -2.082535856799277e-33,  1.263655844846097e-34, -6.823016246682745e-36,  3.318537090055538e-37, -1.466186761769227e-38,
  6.074414920677274e-02, -1.518817302684899e-04,  3.919369592645911e-07, -1.039838949669060e-09,  2.817859561022020e-12, -7.774401748459537e-15,  2.162083886598181e-17,
 -6.101712734051389e-20,  1.702159875191203e-22, -4.923493394533727e-25,  1.321025947398234e-27, -4.178676628152034e-30,  5.431931992415320e-02, -1.572523418526811e-04,
  5.489767991770105e-07, -2.044244917529592e-09,  7.648905675511811e-12, -2.824471989196829e-14,  1.024954986428480e-16, -3.664249758914436e-19,  1.289835256818606e-21,
 -4.497337364139687e-24,  1.543935185551647e-26, -5.295768564048689e-29,  4.343351361707268e-02, -1.601393391997900e-04,  7.776651870258638e-07, -3.747350418513900e-09,
  1.727256946903265e-11, -7.667148137394738e-14,  3.303815353810004e-16, -1.389649070143072e-18,  5.725929741359460e-21, -2.317708457138078e-23,  9.232414523301776e-26,
 -3.626492560695100e-28,  3.104978743040539e-02, -1.515895507650274e-04,  9.576874884710474e-07, -5.571905187803977e-09,  3.031303939095896e-11, -1.572161149873684e-13,
  7.854976163034214e-16, -3.804339789313808e-18,  1.794306189161954e-20, -8.268132211326252e-23,  3.733072950209502e-25, -1.654558539482929e-27,  1.984128954333475e-02,
 -1.287506289245691e-04,  1.001214303303502e-06, -6.841107393988414e-09,  4.322130953713238e-11, -2.580759184655893e-13,  1.472978149579684e-15, -8.096100393497980e-18,
  4.309508876422803e-20, -2.230672437760922e-22,  1.126637308622651e-24, -5.566002973405223e-27,  1.133044927967519e-02, -9.652808966670896e-05,  8.938681057909299e-07,
 -7.082923602409778e-09,  5.141053140869030e-11, -3.494915044999660e-13,  2.254094195890092e-15, -1.391638845817183e-17,  8.278703210745540e-20, -4.768708200114740e-22,
  2.670139265484565e-24, -1.457658370516801e-26,  5.780357112640879e-03, -6.351515112685447e-05,  6.874990566854930e-07, -6.267284934907818e-09,  5.180906921382784e-11,
 -3.975464110545810e-13,  2.874134258193247e-15, -1.978028539167181e-17,  1.305603937064040e-19, -8.311228811577856e-22,  5.124972891695178e-24, -3.071643698534444e-26,
  2.633514543596481e-03, -3.664205808909388e-05,  4.586975730702243e-07, -4.779957393937124e-09,  4.468406845937938e-11, -3.844534222060777e-13,  3.096429359138818e-15,
 -2.361658788862905e-17,  1.719967391087697e-19, -1.203559889335270e-21,  8.131255808128436e-24, -5.323970683940953e-26,  1.071066080447999e-03, -1.854931979775557e-05,
  2.667923540888493e-07, -3.160529755315862e-09,  3.322038393460362e-11, -3.188128466026128e-13,  2.846658969104648e-15, -2.395065101244839e-17,  1.916175151096273e-19,
 -1.467726450756722e-21,  1.082026844242881e-23, -7.709250507707918e-26,  3.886960907500923e-04, -8.251605781962947e-06,  1.357437897487024e-07, -1.819319864507406e-09,
  2.140279805554504e-11, -2.281539873373474e-13,  2.249642269460260e-15, -2.080249446029282e-17,  1.821876115761813e-19, -1.522387467751552e-21,  1.220705330653240e-23,
 -9.434474492320165e-26,  1.258130995958337e-04, -3.230360173535884e-06,  6.056956879938085e-08, -9.146531681906444e-10,  1.199827909572025e-11, -1.415907666418257e-13,
  1.536858521947979e-15, -1.557253330002783e-17,  1.488723638109629e-19, -1.353425670305858e-21,  1.177267010881198e-23, -9.844976597626360e-26,  3.630571222100725e-05,
 -1.114416962106907e-06,  2.374620912827968e-08, -4.026180780989188e-10,  5.871415117805649e-12, -7.649317564894067e-14,  9.116377946782605e-16, -1.009769128434113e-17,
  1.051310157193990e-19, -1.037552714089812e-21,  9.769825710584848e-24, -8.822080208998896e-26,  9.336487654789862e-06, -3.391860019583471e-07,  8.191913233601791e-09,
 -1.554923826424056e-10,  2.514622389198019e-12, -3.608653590127208e-14,  4.712438318116871e-16, -5.694747537508052e-18,  6.445177678949753e-20, -6.892961756394558e-22,
  7.014239268887534e-24, -6.828031878609416e-26,  2.138979390449161e-06, -9.117387177926359e-08,  2.489841357778497e-09, -5.277874761563257e-11,  9.446295734982210e-13,
 -1.490533596088023e-14,  2.129228331982253e-16, -2.802890569042487e-18,  3.443344624347251e-20, -3.985054510285615e-22,  4.376448743178755e-24, -4.586712627797254e-26,
  4.364626454761605e-07, -2.166507521960955e-08,  6.674959814727107e-10, -1.576954147239316e-11,  3.118535726708610e-13, -5.402731810211786e-15,  8.431525390810344e-17,
 -1.207586908336870e-18,  1.608460985497734e-20, -2.012216490638225e-22,  2.382438444317049e-24, -2.685513216578112e-26,  7.931955585090495e-08, -4.555367102169226e-09,
  1.580190298251006e-10, -4.153711191506788e-12,  9.064202680991615e-14, -1.722215420427910e-15,  2.933310125037267e-17, -4.566675571597071e-19,  6.589276062221763e-21,
 -8.903470206353896e-23,  1.135605820407551e-24, -1.375725543538841e-26,  1.284061566809370e-08, -8.484356051709867e-10,  3.307431029472300e-11, -9.660061603896801e-13,
  2.323758609113790e-14, -4.838133999718203e-16,  8.986880160318712e-18, -1.519833662449892e-19,  2.374193961461958e-21, -3.462965269536479e-23,  4.755563522054382e-25,
 -6.188369815733390e-27,  1.852633681004328e-09, -1.401518499998222e-10,  6.129490340363567e-12, -1.986989872404236e-13,  5.264893023387097e-15, -1.200456288535251e-16,
  2.430663747765320e-18, -4.463473066768116e-20,  7.545892385953874e-22, -1.187682499263999e-23,  1.755478248099182e-25, -2.453011507574641e-27,  2.384612627130877e-10,
 -2.056695027399997e-11,  1.007618768033691e-12, -3.622172277064846e-14,  1.056590780831928e-15, -2.637359286997202e-17,  5.819355609615206e-19, -1.160085488022987e-20,
  2.122108687146330e-22, -3.603689040900891e-24,  5.732198389157893e-26, -8.599910599418638e-28,  2.742644159269431e-11, -2.687013278140750e-12,  1.472724384929365e-13,
 -5.866803322221163e-15,  1.883338341462485e-16, -5.145359843840938e-18,  1.237114539902163e-19, -2.677183320810912e-21,  5.299021735003456e-23, -9.708958901222022e-25,
  1.662017784432963e-26, -2.677230239747362e-28,  2.825593650598240e-12, -3.134472720037383e-13,  1.919720575703167e-14, -8.470410870551849e-16,  2.991837411768965e-17,
 -8.946258795734915e-19,  2.343994097017254e-20, -5.507229530993476e-22,  1.179663670916008e-23, -2.332411385634731e-25,  4.297646634803167e-27, -7.434083715756012e-29,
  2.616943738243254e-13, -3.277728062639686e-14,  2.240927102340331e-15, -1.094761807596383e-16,  4.254381106464038e-18, -1.392534525722954e-19,  3.976789595175846e-21,
 -1.014683009242399e-22,  2.352806152576924e-24, -5.021458280914667e-26,  9.961931083835159e-28, -1.850998623392858e-29,  2.189945393240184e-14, -3.089079427622552e-15,
  2.355446041114903e-16, -1.273716607182755e-17,  5.446180477184401e-19, -1.951734700809590e-20,  6.077047904590343e-22, -1.684482773205237e-23,  4.229779342223649e-25,
 -9.748211575690502e-27,  2.083006772749556e-28, -4.158861127674380e-30,  1.667650925474873e-15, -2.642973543024799e-16,  2.245750394063564e-17, -1.343917832747675e-18,
  6.323172207052218e-20, -2.481636846778528e-21,  8.427751896513963e-23, -2.538864801034151e-24,  6.906738073782409e-26, -1.719617467928020e-27,  3.959439582773121e-29,
 -8.497913251891974e-31,  1.166915266479119e-16, -2.073118555605879e-17,  1.961323533089976e-18, -1.298576894316207e-19,  6.723663292692304e-21, -2.890631725668981e-22,
  1.071073864618537e-23, -3.508122780248975e-25,  1.034363980134162e-26, -2.783349464009054e-28,  6.908518895405196e-30, -1.594504653466885e-31,  7.602936144928215e-18,
 -1.510558418351327e-18,  1.589657105453480e-19, -1.164058166554754e-20,  6.632442150228212e-22, -3.123971789315094e-23,  1.263265994208979e-24, -4.499968125094316e-26,
  1.438518450008024e-27, -4.184938349416439e-29,  1.120110765864662e-30, -2.780936427233152e-32,  4.695258566102477e-19, -1.040525400603193e-19,  1.216561854757297e-20,
 -9.846788992761301e-22,  6.172093275233497e-23, -3.184741358955466e-24,  1.405505433618332e-25, -5.445566295406716e-27,  1.887583115738046e-28, -5.937617452789244e-30,
  1.713914318942245e-31, -4.577696205701760e-33,  2.814248706694684e-20, -6.935077229313690e-21,  8.993455858693174e-22, -8.037483445245636e-23,  5.538452037975928e-24,
 -3.129091000310172e-25,  1.506542644771295e-26, -6.346792582679691e-28,  2.384835789204443e-29, -8.109401552169664e-31,  2.523846319742948e-32, -7.249891835492160e-34,
  1.688944601554413e-21, -4.610284712646724e-22,  6.615448890310363e-23, -6.516600560788208e-24,  4.929590600019133e-25, -3.045910893717119e-26,  1.598220253245176e-27,
 -7.314147192909776e-29,  2.976638752587602e-30, -1.093232082815039e-31,  3.665407935597128e-33, -1.131453379200743e-34,  1.056544720900243e-22, -3.178842928683156e-23,
  5.029728174808238e-24, -5.445576535907255e-25,  4.511192548811260e-26, -3.041729293032600e-27,  1.735874077264626e-28, -8.613399044219353e-30,  3.789724795536993e-31,
 -1.500680441867850e-32,  5.411156337163876e-34, -1.791895631035106e-35,  7.246849981673820e-24, -2.387732098125925e-24,  4.144903907031782e-25, -4.910772229147466e-26,
  4.437463461566124e-27, -3.253073334238525e-28,  2.012198403812387e-29, -1.079018930186097e-30,  5.116358229978732e-32, -2.177747361949346e-33,  8.419911804458026e-35,
 -2.982415052141224e-36,  5.792317375443833e-25, -2.072446795981835e-25,  3.918822735937019e-26, -5.047836936775985e-27,  4.945428418970953e-28, -3.919393398845028e-29,
  2.613487324772731e-30, -1.506688971102150e-31,  7.660885998475984e-33, -3.488074075580043e-34,  1.439255339723985e-35, -5.427996863637124e-37,  5.773707017155202e-26,
 -2.219236494654106e-26,  4.526218500637517e-27, -6.280416365197301e-28,  6.613074736756780e-29, -5.618946163079790e-30,  4.006949718976853e-31, -2.464493915481870e-32,
  1.333797266533305e-33, -6.449780405817691e-35,  2.820540529572910e-36, -1.124980616689374e-37,  7.646402578451854e-27, -3.115479295278481e-27,  6.764724838969452e-28,
 -9.985588191534000e-29,  1.116604487445560e-29, -1.005521147156530e-30,  7.584093953144109e-32, -4.923801690338467e-33,  2.807399224234014e-34, -1.427555512418090e-35,
  6.553011203624694e-37, -2.738576891772152e-38,  1.378830406381593e-27, -5.861255679399549e-28,  1.332866177291067e-28, -2.059821871434479e-29,  2.408513840317988e-30,
 -2.264676017805977e-31,  1.780868645118294e-32, -1.203638575243334e-33,  7.134090978108275e-35, -3.765825964757862e-36,  1.792085245290666e-37, -7.753450787515482e-39,
  2.851191121790870e-28, -1.241892876033879e-28,  2.900920059838054e-29, -4.604508894431160e-30,  5.526067828272782e-31, -5.328768743014686e-32,  4.293671215459919e-33,
 -2.970929064171119e-34,  1.801216306264402e-35, -9.717671199280297e-37,  4.722720679662288e-38, -2.085000832188841e-39,  6.014281531599228e-02, -1.487953920429153e-04,
  3.797243650467189e-07, -9.959694774142913e-10,  2.667425253333768e-12, -7.275403891116621e-15,  1.998602213016045e-17, -5.584396306397645e-20,  1.533993267627349e-22,
 -4.430676622784186e-25,  1.145776429541690e-27, -3.805491971138389e-30,  5.369894170456604e-02, -1.529566127935795e-04,  5.251619372038158e-07, -1.926251334103041e-09,
  7.107802630280469e-12, -2.590342812035044e-14,  9.278993002352730e-17, -3.276259346812513e-19,  1.138507860930252e-21, -3.923972332207946e-24,  1.328559926460164e-26,
 -4.516899144082140e-29,  4.280512058709866e-02, -1.540933061906365e-04,  7.343059057547435e-07, -3.482838793089375e-09,  1.581538351092134e-11, -6.918928788221666e-14,
  2.939160499770765e-16, -1.219086639138014e-18,  4.954356233031075e-21, -1.978435209221398e-23,  7.775791751034220e-26, -3.014500216416573e-28,  3.045834009568167e-02,
 -1.441874896485050e-04,  8.936341370816329e-07, -5.111061931303780e-09,  2.734893228966638e-11, -1.395801989458113e-13,  6.865868736810083e-16, -3.275040844449425e-18,
  1.521865780152747e-20, -6.910861437243386e-23,  3.075878627390718e-25, -1.344034704303404e-27,  1.934180262739234e-02, -1.210579116247721e-04,  9.231059479965977e-07,
 -6.189012188188353e-09,  3.839571893723750e-11, -2.252960213690030e-13,  1.264446041956858e-15, -6.837303824538334e-18,  3.582012470727663e-20, -1.825415802090125e-22,
  9.079928803718643e-25, -4.418795949415342e-27,  1.095811957304926e-02, -8.970365425570921e-05,  8.135869410209789e-07, -6.313461696134022e-09,  4.493160395492794e-11,
 -2.997849479560415e-13,  1.899083093281225e-15, -1.152245927763362e-17,  6.739708688230360e-20, -3.818651693630162e-22,  2.103942076864521e-24, -1.130501796589488e-26,
  5.536839306957464e-03, -5.830247710588687e-05,  6.170145729993385e-07, -5.498379537434023e-09,  4.450539907069395e-11, -3.347675530697403e-13,  2.374546766974440e-15,
 -1.604401410897897e-17,  1.040259833626542e-19, -6.507982710667970e-22,  3.945504600891963e-24, -2.325751137028993e-26,  2.493938615621103e-03, -3.319032060155787e-05,
  4.053865065192946e-07, -4.122701234300228e-09,  3.768763284830655e-11, -3.174902502225823e-13,  2.506128118841898e-15, -1.874748020762310e-17,  1.339994017166375e-19,
 -9.207384537968366e-22,  6.111000152264563e-24, -3.932334886021610e-26,  1.000909425444598e-03, -1.655811201096202e-05,  2.318561673882695e-07, -2.676517766031063e-09,
  2.747638921881641e-11, -2.578935534737965e-13,  2.254501271807138e-15, -1.858697892952840e-17,  1.458163679823901e-19, -1.095850934264405e-21,  7.930518982469894e-24,
 -5.549166332525852e-26,  3.577310842665108e-04, -7.247489928717561e-06,  1.158250269113047e-07, -1.510633004404926e-09,  1.733565387740950e-11, -1.805408826404914e-13,
  1.741180932348065e-15, -1.576270778207319e-17,  1.352544779380711e-19, -1.108043197639625e-21,  8.715346013233344e-24, -6.610715089237674e-26,  1.137955975014835e-04,
 -2.786646339594809e-06,  5.065822440365856e-08, -7.434702735274485e-10,  9.502593577549009e-12, -1.094421798885200e-13,  1.160799670141394e-15, -1.150515154605433e-17,
  1.076756815204990e-19, -9.589905358906475e-22,  8.177040710148281e-24, -6.706732830194169e-26,  3.219949525421217e-05, -9.422849290870055e-07,  1.943156619386270e-08,
 -3.198152761886771e-10,  4.539270591345653e-12, -5.765853240401130e-14,  6.708826414157934e-16, -7.262696179929447e-18,  7.396838616033908e-20, -7.146517686465694e-22,
  6.592129452669336e-24, -5.834680245712893e-26,  8.099894855263928e-06, -2.804814654154563e-07,  6.545443168848160e-09, -1.204680649478859e-10,  1.894188289248049e-12,
 -2.647819039014826e-14,  3.372893292955810e-16, -3.980552827055275e-18,  4.403819196501156e-20, -4.607636318148664e-22,  4.590248124217492e-24, -4.377287027984657e-26,
  1.810445168663801e-06, -7.355255772035601e-08,  1.938174825581708e-09, -3.979647886837379e-11,  6.918587232488924e-13, -1.062458682020217e-14,  1.479311637448253e-16,
 -1.900362631498336e-18,  2.280559976187065e-20, -2.580473126738857e-22,  2.772780952438849e-24, -2.845194571743107e-26,  3.593935547984599e-07, -1.700477212500696e-08,
  5.049607037915562e-10, -1.154490382498139e-11,  2.215701986200668e-13, -3.732841854123917e-15,  5.673856843103458e-17, -7.924781662182817e-19,  1.030471810283689e-20,
 -1.259651246819218e-22,  1.458444614699514e-24, -1.608766295509269e-26,  6.334235374123538e-08, -3.468327592750373e-09,  1.158524470625896e-10, -2.944696737398330e-12,
  6.231356709127666e-14, -1.150509697914218e-15,  1.907280297151550e-17, -2.893896738551226e-19,  4.074056191441983e-21, -5.376093654873170e-23,  6.702129074445300e-25,
 -7.941732227904969e-27,  9.910687255188000e-09, -6.245546582260220e-10,  2.342807702007276e-11, -6.612020219504205e-13,  1.541339058639576e-14, -3.116423492825795e-16,
  5.630950171457030e-18, -9.275861648859323e-20,  1.413050755182497e-21, -2.011877251081933e-23,  2.699243574091626e-25, -3.434302188490861e-27,  1.376801736983570e-09,
 -9.938523100185472e-11,  4.180516213810635e-12, -1.308788681561531e-13,  3.358694441571671e-15, -7.432975310217962e-17,  1.463232210526398e-18, -2.616012468647407e-20,
  4.310911377997266e-22, -6.620541817637009e-24,  9.556794641965750e-26, -1.305236076886338e-27,  1.699209920267689e-10, -1.399290496123916e-11,  6.591707444883049e-13,
 -2.287522890660552e-14,  6.459820600119844e-16, -1.564338251679524e-17,  3.354511259079581e-19, -6.508114386783001e-21,  1.160029431812213e-22, -1.921500213483265e-24,
  2.984057807570543e-26, -4.374558084685164e-28,  1.865206042884674e-11, -1.746100234244342e-12,  9.201530657861528e-14, -3.537811965817707e-15,  1.099138057514260e-16,
 -2.912427318627623e-18,  6.803196959139043e-20, -1.432418980956768e-21,  2.761919220518224e-23, -4.934881572140138e-25,  8.245934597949693e-27, -1.297663613516430e-28,
  1.824502314307571e-12, -1.935742737228826e-13,  1.140076038880731e-14, -4.854858549533260e-16,  1.659379455027301e-17, -4.811672844215055e-19,  1.224626539589605e-20,
 -2.798985228027245e-22,  5.839639017633960e-24, -1.125812133741655e-25,  2.024620775902304e-27, -3.421161159685656e-29,  1.595117680168613e-13, -1.912974369159588e-14,
  1.258211501395818e-15, -5.933278996133689e-17,  2.231380174354583e-18, -7.082641028630723e-20,  1.964765568898262e-21, -4.876666286971632e-23,  1.101374787275272e-24,
 -2.291984750118963e-26,  4.437953604484950e-28, -8.055458114313439e-30,  1.251947843926528e-14, -1.693185619696229e-15,  1.242874703253185e-16, -6.490102519043373e-18,
  2.686287887502698e-19, -9.337359745699130e-21,  2.824622234406549e-22, -7.617580693018804e-24,  1.863331863183498e-25, -4.187900402948476e-27,  8.735497524602860e-29,
 -1.704074699817011e-30,  8.877237755510595e-16, -1.351084393764574e-16,  1.106221223726931e-17, -6.396890644731105e-19,  2.915009825878971e-20, -1.110136275649021e-21,
  3.664229889353329e-23, -1.074357789010638e-24,  2.848082992772095e-26, -6.917592084951606e-28,  1.555340894753619e-29, -3.262614084807388e-31,  5.737829820720348e-17,
 -9.807773669976161e-18,  8.952324570184357e-19, -5.733142396002815e-20,  2.877335912712408e-21, -1.201203916992362e-22,  4.328664831927697e-24, -1.380722636393814e-25,
  3.969368854187698e-27, -1.042550261147544e-28,  2.528222518840898e-30, -5.706206479055194e-32,  3.422828647116370e-18, -6.557607812008571e-19,  6.668918410391208e-20,
 -4.729746278050898e-21,  2.615107850923642e-22, -1.197302675925442e-23,  4.713111668115077e-25, -1.636437936631840e-26,  5.104856191183825e-28, -1.450728868921279e-29,
  3.796618598566359e-31, -9.224638039018060e-33,  1.916852542245393e-19, -4.106920634220302e-20,  4.649637842946603e-21, -3.651185992107579e-22,  2.224241596262002e-23,
 -1.117125341090496e-24,  4.805411206243198e-26, -1.816937373057640e-27,  6.152868712797764e-29, -1.892735462090269e-30,  5.347698866092468e-32, -1.399253747446945e-33,
  1.031342217434828e-20, -2.464549626394819e-21,  3.102449386860569e-22, -2.695798591127553e-23,  1.808876035800953e-24, -9.965352994735283e-26,  4.684367597160507e-27,
 -1.928889620368525e-28,  7.091508220374969e-30, -2.361571114478308e-31,  7.204090147809768e-33, -2.030043387460503e-34,  5.499150089170058e-22, -1.460686446968691e-22,
  2.040614171162204e-23, -1.959554582905131e-24,  1.446933916822961e-25, -8.737425097098481e-27,  4.485525413839140e-28, -2.010440205257461e-29,  8.020616914661279e-31,
 -2.890142040712736e-32,  9.514740066648740e-34, -2.886074458547929e-35,  3.027109104204944e-23, -8.897127350172204e-24,  1.375293232330426e-24, -1.456115712880975e-25,
  1.180894846339409e-26, -7.802873043824605e-28,  4.367990082864507e-29, -2.127901153384513e-30,  9.199262006382839e-32, -3.582042658300391e-33,  1.270969701053356e-34,
 -4.144343497026276e-36,  1.813202584191847e-24, -5.861053057682343e-25,  9.978763812360608e-26, -1.160360450790536e-26,  1.029969084548144e-27, -7.423185549498044e-29,
  4.517687093429835e-30, -2.385301002400068e-31,  1.114402883744742e-32, -4.676643136123898e-34,  1.783773288788381e-35, -6.236762608467906e-37,  1.261162027196177e-25,
 -4.446769668006727e-26,  8.282238087160102e-27, -1.051305809300952e-27,  1.015608615843108e-28, -7.941693090361340e-30,  5.228173040646073e-31, -2.977406176923962e-32,
  1.496281336077099e-33, -6.736902706641175e-35,  2.750171769072778e-36, -1.026627322171277e-37,  1.097559931328929e-26, -4.175957206310346e-27,  8.426232016472689e-28,
 -1.157033307981329e-28,  1.206137848606882e-29, -1.015013920258268e-30,  7.171978538046805e-32, -4.372576925217800e-33,  2.346668560098440e-34, -1.125686481595403e-35,
  4.885003686267625e-37, -1.934131557490856e-38,  1.285971643256805e-27, -5.207648188612422e-28,  1.123358830633318e-28, -1.647579604894129e-29,  1.830949720474651e-30,
 -1.639015225241694e-31,  1.229194959390845e-32, -7.936883788121660e-34,  4.501823352643314e-35, -2.277767544820524e-36,  1.040594842344880e-37, -4.328948685091260e-39,
  2.104639072616245e-28, -8.920720696929592e-29,  2.022208460861164e-29, -3.115413985421801e-30,  3.631824359985180e-31, -3.405029859560367e-32,  2.670154836445243e-33,
 -1.799864877614025e-34,  1.064068061788352e-35, -5.603038094131393e-37,  2.660100147226390e-38, -1.148297182572784e-39,  4.102435538893857e-29, -1.785231313623836e-29,
  4.165785643080615e-30, -6.605345988799976e-31,  7.919346886659249e-32, -7.629103228773738e-33,  6.141326448675528e-34, -4.245470134174855e-35,  2.571653921380408e-36,
 -1.386227811719624e-37,  6.731355864932310e-39, -2.969388642443243e-40,  5.955363465390259e-02, -1.458046890096803e-04,  3.680240853674614e-07, -9.544291980513595e-10,
  2.526589972025299e-12, -6.813962669587436e-15,  1.848877737310804e-17, -5.118186846666685e-20,  1.382342833238590e-22, -4.005006878326587e-25,  9.844567357576782e-28,
 -3.546986364609634e-30,  5.309537412774306e-02, -1.488458826399548e-04,  5.027125575817079e-07, -1.816553089017548e-09,  6.611281331053085e-12, -2.378256222349493e-14,
  8.410592815913483e-17, -2.933550922628036e-19,  1.006349903450465e-21, -3.430294684733155e-24,  1.144569775057834e-26, -3.865590915952354e-29,  4.220023749859980e-02,
 -1.483818361563512e-04,  6.939856626731447e-07, -3.240490968063223e-09,  1.449946258724704e-11, -6.252763811112652e-14,  2.618982369420191e-16, -1.071367736724809e-18,
  4.295051227201106e-21, -1.692379982062934e-23,  6.563553369242545e-26, -2.511881209192206e-28,  2.989551007198865e-02, -1.372765151109804e-04,  8.348375857478367e-07,
 -4.694946754169887e-09,  2.471495631919538e-11, -1.241497137434087e-13,  6.013459558135061e-16, -2.825586745046187e-18,  1.293867000317168e-20, -5.791054016603205e-23,
  2.541289660684956e-25, -1.094892608169631e-27,  1.887188461670885e-02, -1.139600250418038e-04,  8.523802639951802e-07, -5.609142047165989e-09,  3.417840307781189e-11,
 -1.971229554239171e-13,  1.088108893465024e-15, -5.789557272675206e-18,  2.985810892271645e-20, -1.498299084257766e-22,  7.341317216137165e-25, -3.519829793217385e-27,
  1.061185919658428e-02, -8.348622360410700e-05,  7.419487087972263e-07, -5.640150686560186e-09,  3.936675965463313e-11, -2.578469370234514e-13,  1.604691876933884e-15,
 -9.570389378237521e-18,  5.505214095371120e-20, -3.068705432858517e-22,  1.663998165767633e-24, -8.801969482704720e-27,  5.313100198504321e-03, -5.361866673241217e-05,
  5.550952187316513e-07, -4.836905790237786e-09,  3.834540739507884e-11, -2.828136681659603e-13,  1.968601991215917e-15, -1.306147724169418e-17,  8.320760350168385e-20,
 -5.116875275693917e-22,  3.050534557710541e-24, -1.768876623807559e-26,  2.367364053531535e-03, -3.013532937776736e-05,  3.593326792832758e-07, -3.567399692556941e-09,
  3.189915940388890e-11, -2.631868077603859e-13,  2.036565091444871e-15, -1.494585495731049e-17,  1.048654605801509e-19, -7.076876986662849e-22,  4.615201690475902e-24,
 -2.919252529100647e-26,  9.381933178764490e-04, -1.482463568635021e-05,  2.022145392033474e-07, -2.275386545479112e-09,  2.282002112390651e-11, -2.095378520217147e-13,
  1.793871171027151e-15, -1.449531704917637e-17,  1.115325177510435e-19, -8.225717947220969e-22,  5.844795121025051e-24, -4.017275428753390e-26,  3.304858296752410e-04,
 -6.388945181482872e-06,  9.924946157425870e-08, -1.260020294993587e-09,  1.410934938373591e-11, -1.435943159979165e-13,  1.354871038963736e-15, -1.201081897385477e-17,
  1.009969536433789e-19, -8.113429922580875e-22,  6.261280264670537e-24, -4.661957940153213e-26,  1.034064814238823e-04, -2.414639446544266e-06,  4.258121822582063e-08,
 -6.075287538443913e-10,  7.568132874874283e-12, -8.508914145465679e-14,  8.821227883816243e-16, -8.554133793543667e-18,  7.839142375871829e-20, -6.841217969213328e-22,
  5.719315748656744e-24, -4.601692449956289e-26,  2.871858893138687e-05, -8.010311331695834e-07,  1.599415406990855e-08, -2.556020972422364e-10,  3.531927673370414e-12,
 -4.375221494237747e-14,  4.971329764639014e-16, -5.261086220540879e-18,  5.242732930353629e-20, -4.959806793514260e-22,  4.482661647734198e-24, -3.889696820530897e-26,
  7.074218200627120e-06, -2.334227344485762e-07,  5.265520519706475e-09, -9.399295195765982e-11,  1.437308303679676e-12, -1.957561742105025e-14,  2.433016926159165e-16,
 -2.804747073972090e-18,  3.033863892117844e-20, -3.106050215121637e-22,  3.029921419476843e-24, -2.830947411076568e-26,  1.544467060631154e-06, -5.978418478103043e-08,
  1.520602064230917e-09, -3.025048162878491e-11,  5.109528136644484e-13, -7.638170599818878e-15,  1.036808799697536e-16, -1.300043529050318e-18,  1.524327837222784e-20,
 -1.686633417597943e-22,  1.773543744936394e-24, -1.782081321204696e-26,  2.986545900895679e-07, -1.346420292273670e-08,  3.854494752894987e-10, -8.529972223048924e-12,
  1.589094341364216e-13, -2.603946387788169e-15,  3.855687674342649e-17, -5.252770035609675e-19,  6.669153866870403e-21, -7.967240182675888e-23,  9.022135811582626e-25,
 -9.740367716472402e-27,  5.112069642137525e-08, -2.667504034974825e-09,  8.581247964481698e-11, -2.109401439825351e-12,  4.329368033711214e-14, -7.768845116461885e-16,
  1.253738860665626e-17, -1.854264696094748e-19,  2.547350791242737e-21, -3.283296223511028e-23,  4.001231843794378e-25, -4.638218129246588e-27,  7.742415871517110e-09,
 -4.651053263156831e-10,  1.678923056306927e-11, -4.579068171537038e-13,  1.034541181543248e-14, -2.031582967412573e-16,  3.571175968418355e-18, -5.730931564362014e-20,
  8.514631640688361e-22, -1.183511924872778e-23,  1.551488652652903e-25, -1.930247516714539e-27,  1.037357293244074e-09, -7.141143838828487e-11,  2.888908882027200e-12,
 -8.734804389757343e-14,  2.171153465599101e-15, -4.663954302216046e-17,  8.927207151085227e-19, -1.554031191574968e-20,  2.496426468299461e-22, -3.741231199137868e-24,
  5.274625854743497e-26, -7.041638371918196e-28,  1.229775327644092e-10, -9.663058436584958e-12,  4.376218302195084e-13, -1.466018394400629e-14,  4.007861550352788e-16,
 -9.416341304573666e-18,  1.962413168799550e-19, -3.705493954054501e-21,  6.435994320254516e-23, -1.039915324761404e-24,  1.576797358209672e-26, -2.258779522014438e-28,
  1.290805247668943e-11, -1.153807795376119e-12,  5.844510113661830e-14, -2.168495479222517e-15,  6.519817278945223e-17, -1.675470406891863e-18,  3.802326817245721e-20,
 -7.789159393525813e-22,  1.463027173906845e-23, -2.549209530801465e-25,  4.157838227110000e-27, -6.392345463504470e-29,  1.201244439590787e-12, -1.217974609158680e-13,
  6.895631442264051e-15, -2.833305072248268e-16,  9.369805214082151e-18, -2.634379889543899e-19,  6.512381764324162e-21, -1.447855058624469e-22,  2.942002367254130e-24,
 -5.530069871948817e-26,  9.705921297072847e-28, -1.602051320395804e-29,  9.934826722618485e-14, -1.139814532723535e-14,  7.208691075390692e-16, -3.280217041720351e-17,
  1.193536592043939e-18, -3.673021760832413e-20,  9.895908915755977e-22, -2.389018134110731e-23,  5.254495086656617e-25, -1.066075182970793e-26,  2.014496555483080e-28,
 -3.571667622354108e-30,  7.329156623360159e-15, -9.494598644067002e-16,  6.705263460429537e-17, -3.379659177209620e-18,  1.353642873085828e-19, -4.562385698006338e-21,
  1.340550070598716e-22, -3.516612625483415e-24,  8.377801728184169e-26, -1.835911042610620e-27,  3.737572202317357e-29, -7.122494722053847e-31,  4.849749940727204e-16,
 -7.080812517829083e-17,  5.582386731364410e-18, -3.117602314102349e-19,  1.375313927282546e-20, -5.080432574599526e-22,  1.629255640588246e-23, -4.647905919758556e-25,
  1.200343261918239e-26, -2.843370822010499e-28,  6.241106092780114e-30, -1.279253737492021e-31,  2.901723814456093e-17, -4.766710308932648e-18,  4.194298147990757e-19,
 -2.596336380201018e-20,  1.262321155234315e-21, -5.114673933144391e-23,  1.791722376652254e-24, -5.563423696648011e-26,  1.558864493970301e-27, -3.994939339301874e-29,
  9.461999882836870e-31, -2.087691969483773e-32,  1.588003335181877e-18, -2.930075170142475e-19,  2.876848925909746e-20, -1.974534886853332e-21,  1.058693294743712e-22,
 -4.708679189612519e-24,  1.803340433896310e-25, -6.099928514370606e-27,  1.856008888666533e-28, -5.150124311625474e-30,  1.317295912775238e-31, -3.130996226014385e-33,
  8.078063363973648e-20, -1.671080889564874e-20,  1.830031770351724e-21, -1.392937958639975e-22,  8.240255199038896e-24, -4.025542485170013e-25,  1.686692256439579e-26,
 -6.219824007875823e-28,  2.056562556051256e-29, -6.183386439006196e-31,  1.709156839502699e-32, -4.378969388970436e-34,  3.905994908113319e-21, -9.038875388039691e-22,
  1.103240211343540e-22, -9.311107652700901e-24,  6.078284681475859e-25, -3.262569948603294e-26,  1.496174993939751e-27, -6.017482474051018e-29,  2.163142212901699e-30,
 -7.050307230267047e-32,  2.106846297367771e-33, -5.820651718019211e-35,  1.851033519125904e-22, -4.777661206655887e-23,  6.490232950942828e-24, -6.068995441785630e-25,
  4.369975474934943e-26, -2.576598488443193e-27,  1.293065871751051e-28, -5.671622647712366e-30,  2.216445543640861e-31, -7.830521499710678e-33,  2.529583948205689e-34,
 -7.534993343072897e-36,  8.959015044256741e-24, -2.568762247364837e-24,  3.874357936554687e-25, -4.006922134262963e-26,  3.177925991026370e-27, -2.055817894685342e-28,
  1.127855052395024e-29, -5.389808751553324e-31,  2.287713730843326e-32, -8.752941143405318e-34,  3.053903325071294e-35, -9.799034584216156e-37,  4.675614017131183e-25,
 -1.480823253907216e-25,  2.469770108821319e-26, -2.815615676185306e-27,  2.452482607159767e-28, -1.736060431699689e-29,  1.038609158983576e-30, -5.394911010202584e-32,
  2.481463470176905e-33, -1.025939256965485e-34,  3.857676456709857e-36, -1.330495617637566e-37,  2.818555784388662e-26, -9.782765826733307e-27,  1.792797177541821e-27,
 -2.240315418146714e-28,  2.132056385605487e-29, -1.643526423123746e-30,  1.067313028466118e-31, -5.999692386540062e-33,  2.977880193102886e-34, -1.324937057262498e-35,
  5.347598228894701e-37, -1.974670050078712e-38,  2.129314219082335e-27, -8.012631765534219e-28,  1.598186164015777e-28, -2.169939643813058e-29,  2.237709983675371e-30,
 -1.863765259789518e-31,  1.303987037188762e-32, -7.875541186459893e-34,  4.188770031536697e-35, -1.992125568041672e-36,  8.574154159290336e-38, -3.368220510257824e-39,
  2.192141444345598e-28, -8.818212771399119e-29,  1.888690584714337e-29, -2.750773587816756e-30,  3.036431562442113e-31, -2.700671882381648e-32,  2.012954773088431e-33,
 -1.292129788071380e-34,  7.287866526996109e-36, -3.667620119764030e-37,  1.666943877650435e-38, -6.900607336396957e-40,  3.234697939335797e-29, -1.366728257157732e-29,
  3.087556705550610e-30, -4.740585374283858e-31,  5.508290046454458e-32, -5.148067275754455e-33,  4.024829519827978e-34, -2.705165346989330e-35,  1.594847503599574e-36,
 -8.375672855685991e-38,  3.966327165735458e-39, -1.707999417422422e-40,  5.916418599692611e-30, -2.572023986724875e-30,  5.995067234291946e-31, -9.495335163280613e-32,
  1.137189414137987e-32, -1.094358656632585e-33,  8.800470698199103e-35, -6.077735436051165e-36,  3.678029416346763e-37, -1.980787319537023e-38,  9.609918256237742e-40,
 -4.235570626062832e-41,  };
  int offset = -36;
  for (int i = 1; i <= n; ++i) {
    double t = ta[i-1];
    offset += 36;
    if (std::isnan(t)) {
      fill_n(rr+offset, 36, 0.5);
      fill_n(ww+offset, 36, 0.0);
    } else if (t >= 64.0) {
      t = 1.0/sqrt(t);
      for (int r = 0; r != 36; ++r) {
        rr[offset+r] = ax[r]*t*t;
        ww[offset+r] = aw[r]*t;
      }
    } else {
      assert(t >= 0);
      int it = static_cast<int>(t*   0.500000000000000);
      t = (t-it*2.000000000000000-   1.000000000000000) *   1.000000000000000;

      const double t2 = t * 2.0;
      for (int j=1; j <=36; ++j) {
        const int boxof = it*432+12*(j-1);
        double d = x[boxof+11];
        double e = w[boxof+11];
        double f = t2*d + x[boxof+10];
        double g = t2*e + w[boxof+10];
        d = t2*f - d + x[boxof+9];
        e = t2*g - e + w[boxof+9];
        f = t2*d - f + x[boxof+8];
        g = t2*e - g + w[boxof+8];
        d = t2*f - d + x[boxof+7];
        e = t2*g - e + w[boxof+7];
        f = t2*d - f + x[boxof+6];
        g = t2*e - g + w[boxof+6];
        d = t2*f - d + x[boxof+5];
        e = t2*g - e + w[boxof+5];
        f = t2*d - f + x[boxof+4];
        g = t2*e - g + w[boxof+4];
        d = t2*f - d + x[boxof+3];
        e = t2*g - e + w[boxof+3];
        f = t2*d - f + x[boxof+2];
        g = t2*e - g + w[boxof+2];
        d = t2*f - d + x[boxof+1];
        e = t2*g - e + w[boxof+1];
        rr[offset+j-1] = t*d - f + x[boxof+0]*0.5;
        ww[offset+j-1] = t*e - g + w[boxof+0]*0.5;
      }
    }
  }
}
