/*
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
 
#ifdef HAVE_CONFIG_H
# include "config.h"
#endif

#include "DialogError.h"


DialogError::DialogError(string primary, string secondary, Gtk::Window &parent)
: image_question(Gtk::Stock::DIALOG_ERROR,
                 Gtk::IconSize(Gtk::ICON_SIZE_DIALOG)),
  label_question("", 0, 0)
{
  set_transient_for(parent);
  set_title("");
  
  label_question.set_markup("<span weight=\"bold\" size=\"larger\">"
                            + primary
                            + "</span>\n\n"
                            + secondary);
  label_question.set_line_wrap();
  label_question.set_selectable();
  
  vbox_icon.pack_start(image_question, FALSE, FALSE);
  vbox_icon.pack_start(fixed_icon,     TRUE,  TRUE);
  hbox_main.set_border_width(12);
  hbox_main.set_spacing(12);
  hbox_main.pack_start(vbox_icon,      FALSE, FALSE);
  hbox_main.pack_start(label_question, TRUE,  TRUE);
  get_vbox()->pack_start(hbox_main,    FALSE, FALSE);
  add_button(Gtk::Stock::CLOSE, 0);
  show_all();
  
  signal_response().connect(
                        sigc::mem_fun(*this, &DialogError::on_signal_response));
}


void DialogError::on_signal_response(int response)
{
  delete this;
}
