#
# BioPerl module for Bio::Map::EntityI
#
# Please direct questions and support issues to <bioperl-l@bioperl.org> 
#
# Cared for by Sendu Bala <bix@sendu.me.uk>
#
# Copyright Sendu Bala
#
# You may distribute this module under the same terms as perl itself

# POD documentation - main docs before the code

=head1 NAME

Bio::Map::EntityI - An Entity Interface

=head1 SYNOPSIS

    # do not use this module directly

=head1 DESCRIPTION

This interface describes the basic methods required for entities. An Entity is a
kind of Bio::Map object that holds instance-specific data but relies on
registering itself with a PositionHandler to handle its relationships with
other entities. These relationships between objects are based around shared
Positions, so Bio::Map::PositionI objects are a special kind of EntityI, along
with Bio::Map::MappableI and Bio::Map::MapI objects.

=head1 FEEDBACK

=head2 Mailing Lists

User feedback is an integral part of the evolution of this and other
Bioperl modules. Send your comments and suggestions preferably to
the Bioperl mailing list.  Your participation is much appreciated.

  bioperl-l@bioperl.org                  - General discussion
  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists

=head2 Support 

Please direct usage questions or support issues to the mailing list:

I<bioperl-l@bioperl.org>

rather than to the module maintainer directly. Many experienced and 
reponsive experts will be able look at the problem and quickly 
address it. Please include a thorough description of the problem 
with code and data examples if at all possible.

=head2 Reporting Bugs

Report bugs to the Bioperl bug tracking system to help us keep track
of the bugs and their resolution. Bug reports can be submitted via the
web:

  https://redmine.open-bio.org/projects/bioperl/

=head1 AUTHOR - Sendu Bala

Email bix@sendu.me.uk

=head1 APPENDIX

The rest of the documentation details each of the object methods.
Internal methods are usually preceded with a _

=cut

# Let the code begin...

package Bio::Map::EntityI;
use strict;

use base qw(Bio::Root::RootI);

=head2 get_position_handler

 Title   : get_position_handler
 Usage   : my $position_handler = $entity->get_position_handler();
 Function: Gets a PositionHandlerI that $entity is registered with.
 Returns : Bio::Map::PositionHandlerI object
 Args    : none

=cut

sub get_position_handler {
    my $self = shift;
    $self->throw_not_implemented();
}

=head2 PositionHandlerI-based methods

 Any methods related to interation with other entities should be implemented
 as a call to the PositionHandler

=cut

1;
