(gallery)=
# Gallery

The following page contains a collection of practical examples and problems solved with **poliastro**. From interplanetary transfers, to asteroid-catching missions or even propagation under external perturbations.
In addition, the user might come across tutorials related on how to use and customize
the plotting utilities, insight on the {ref}`API <api-reference>` capabilities and many other topics related to orbital mechanics.

```{eval-rst}
.. nbgallery::

   /examples/analyzing-the-parker-solar-probe-flybys.myst.md
   /examples/atmospheric-models.myst.md
   /examples/catch-that-asteroid.myst.md
   /examples/customising-static-orbit-plots.myst.md
   /examples/czml-tutorial.myst.md
   /examples/exploring-the-new-horizons-launch.myst.md
   /examples/going-to-mars-with-python-using-poliastro.myst.md
   /examples/going-to-jupiter-with-python-using-jupyter-and-poliastro.myst.md
   /examples/generating-orbit-groundtracks.myst.md
   /examples/plotting-in-3D.myst.md
   /examples/analyzing-NEOs.myst.md
   /examples/visualizing-the-spacex-tesla-roadster-trip-to-mars.myst.md
   /examples/natural-and-artificial-perturbations.myst.md
   /examples/porkchops-with-poliastro.myst.md
   /examples/tisserand.myst.md
   /examples/detecting-events.myst.md
   /examples/loading-OMM-and-TLE-satellite-data.myst.md
   
```
