//  ************************************************************************************************
//
//  BornAgain: simulate and fit reflection and scattering
//
//! @file      GUI/View/Projection/SaveProjectionsAssistant.h
//! @brief     Defines class SaveProjectionsAssistant
//!
//! @homepage  http://www.bornagainproject.org
//! @license   GNU General Public License v3 or higher (see COPYING)
//! @copyright Forschungszentrum Jülich GmbH 2018
//! @authors   Scientific Computing Group at MLZ (see CITATION, AUTHORS)
//
//  ************************************************************************************************

#ifndef BORNAGAIN_GUI_VIEW_PROJECTION_SAVEPROJECTIONSASSISTANT_H
#define BORNAGAIN_GUI_VIEW_PROJECTION_SAVEPROJECTIONSASSISTANT_H

#include "GUI/Model/Data/ProjectionItems.h"
#include <QString>
#include <QVector>
#include <QWidget>
#include <memory>

class IntensityDataItem;
class Datafield;

//! Assistant class which save all projections of IndensityDataItem into ASCII file.

class SaveProjectionsAssistant {
public:
    SaveProjectionsAssistant();
    ~SaveProjectionsAssistant();

    void saveProjections(QWidget* parent, IntensityDataItem* intensityItem);

private:
    struct Projection {
        double axis_value; //!< value on axis where projection has been made
        QVector<double> bin_values;
    };

    struct ProjectionsData {
        bool is_horizontal;
        QVector<double> bin_centers;
        QVector<Projection> projections;
    };

    QString projectionsToString(GUI::ID::ProjectionType projectionsType,
                                IntensityDataItem* intensityItem);

    const Datafield* m_field;
    ProjectionsData projectionsData(GUI::ID::ProjectionType projectionsType,
                                    IntensityDataItem* intensityItem);
    QVector<MaskItem*> projectionItems(GUI::ID::ProjectionType projectionsType,
                                       IntensityDataItem* intensityItem);

    QString projectionFileHeader(ProjectionsData& projectionsData);
};

#endif // BORNAGAIN_GUI_VIEW_PROJECTION_SAVEPROJECTIONSASSISTANT_H
