/*
 *  Copyright (c) 1999-2000 Matthias Elter  <me@kde.org>
 *  Copyright (c) 2003-2014 Boudewijn Rempt <boud@valdyas.org>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#include "kis_aboutdata.h"

#include <klocale.h>
#include <calligraversion.h>
#include <calligragitversion.h>
#include <KoIcon.h>

KAboutData *newKritaAboutData()
{
    QString calligraVersion(CALLIGRA_VERSION_STRING);
    QString version;


#ifdef CALLIGRA_GIT_SHA1_STRING
    QString gitVersion(CALLIGRA_GIT_SHA1_STRING);
    version = QString("%1 (git %2)").arg(calligraVersion).arg(gitVersion);
#else
    version = calligraVersion;
#endif

    KAboutData * aboutData = new KAboutData("krita", 0,
                                            ki18n("Krita"),
                                            version.toLatin1(),
                                            ki18n("Digital Painting for Artists"),
                                            KAboutData::License_GPL,
                                            ki18n("© 1999-%1, The Krita Team").subs(CALLIGRA_YEAR),
                                            KLocalizedString(),
                                            "http://www.krita.org",
                                            "submit@bugs.kde.org");

    aboutData->setProgramIconName(koIconName("calligrakrita"));

    aboutData->addAuthor(ki18n("Boudewijn Rempt"), ki18n("Project Maintainer"));
    aboutData->addAuthor(ki18n("Aaron J. Seigo"));
    aboutData->addAuthor(ki18n("Adam Celarek"));
    aboutData->addAuthor(ki18n("Adam Pigg"));
    aboutData->addAuthor(ki18n("Adriaan de Groot"));
    aboutData->addAuthor(ki18n("Adrian Page"));
    aboutData->addAuthor(ki18n("Adrian Schroeter"));
    aboutData->addAuthor(ki18n("Albert Astals Cid"));
    aboutData->addAuthor(ki18n("Alberto Villa"));
    aboutData->addAuthor(ki18n("Alexander Neundorf"));
    aboutData->addAuthor(ki18n("Alexander Potashev"));
    aboutData->addAuthor(ki18n("Alexis Ménard"));
    aboutData->addAuthor(ki18n("Alfredo Beaumont Sainz"));
    aboutData->addAuthor(ki18n("Allen Winter"));
    aboutData->addAuthor(ki18n("Ana Beatriz Guerrero López"));
    aboutData->addAuthor(ki18n("Andras Mantia"));
    aboutData->addAuthor(ki18n("Andreas Hartmetz"));
    aboutData->addAuthor(ki18n("Andreas Lundin"));
    aboutData->addAuthor(ki18n("André Marcelo Alvarenga"));
    aboutData->addAuthor(ki18n("Andrew Coles"));
    aboutData->addAuthor(ki18n("Andre Woebbeking"));
    aboutData->addAuthor(ki18n("Andrius da Costa Ribas"));
    aboutData->addAuthor(ki18n("Andy Fawcett"));
    aboutData->addAuthor(ki18n("Anne-Marie Mahfouf"));
    aboutData->addAuthor(ki18n("Ariya Hidayat"));
    aboutData->addAuthor(ki18n("Arjen Hiemstra"));
    aboutData->addAuthor(ki18n("Bart Coppens"));
    aboutData->addAuthor(ki18n("Ben Cooksley"));
    aboutData->addAuthor(ki18n("Benjamin K. Stuhl"));
    aboutData->addAuthor(ki18n("Benjamin Meyer"));
    aboutData->addAuthor(ki18n("Benjamin Reed"));
    aboutData->addAuthor(ki18n("Benoît Jacob"));
    aboutData->addAuthor(ki18n("Ben Schleimer"));
    aboutData->addAuthor(ki18n("Bernhard Rosenkraenzer"));
    aboutData->addAuthor(ki18n("Bo Thorsen"));
    aboutData->addAuthor(ki18n("Brad Hards"));
    aboutData->addAuthor(ki18n("Bram Schoenmakers"));
    aboutData->addAuthor(ki18n("Burkhard Lück"));
    aboutData->addAuthor(ki18n("Carlo Segato"));
    aboutData->addAuthor(ki18n("C. Boemann"));
    aboutData->addAuthor(ki18n("Christer Stenbrenden"));
    aboutData->addAuthor(ki18n("Christian Ehrlicher"));
    aboutData->addAuthor(ki18n("Christian Mueller"));
    aboutData->addAuthor(ki18n("Christoph Feck"));
    aboutData->addAuthor(ki18n("Chusslove Illich"));
    aboutData->addAuthor(ki18n("Clarence Dang"));
    aboutData->addAuthor(ki18n("Cyrille Berger"));
    aboutData->addAuthor(ki18n("Daniel M. Duley"));
    aboutData->addAuthor(ki18n("Daniel Molkentin"));
    aboutData->addAuthor(ki18n("Dan Leinir Turthra Jensen"));
    aboutData->addAuthor(ki18n("Dan Meltzer"));
    aboutData->addAuthor(ki18n("Danny Allen"));
    aboutData->addAuthor(ki18n("David Faure"));
    aboutData->addAuthor(ki18n("David Gowers"));
    aboutData->addAuthor(ki18n("Dirk Mueller"));
    aboutData->addAuthor(ki18n("Dirk Schönberger"));
    aboutData->addAuthor(ki18n("Dmitry Kazakov"));
    aboutData->addAuthor(ki18n("Edward Apap"));
    aboutData->addAuthor(ki18n("Elvis Stansvik"));
    aboutData->addAuthor(ki18n("Emanuele Tamponi"));
    aboutData->addAuthor(ki18n("Enrique Matías Sánchez"));
    aboutData->addAuthor(ki18n("Fabian Kosmale"));
    aboutData->addAuthor(ki18n("Frank Osterfeld"));
    aboutData->addAuthor(ki18n("Frederik Schwarzer"));
    aboutData->addAuthor(ki18n("Fredrik Edemar"));
    aboutData->addAuthor(ki18n("Fredy Yanardi"));
    aboutData->addAuthor(ki18n("Friedrich W. H. Kossebau"));
    aboutData->addAuthor(ki18n("Gábor Lehel"));
    aboutData->addAuthor(ki18n("Gary Cramblitt"));
    aboutData->addAuthor(ki18n("Geoffry Song"));
    aboutData->addAuthor(ki18n("Gioele Barabucci"));
    aboutData->addAuthor(ki18n("Giovanni Venturi"));
    aboutData->addAuthor(ki18n("Gopalakrishna Bhat A"));
    aboutData->addAuthor(ki18n("Hanna Scott"));
    aboutData->addAuthor(ki18n("Harald Sitter"));
    aboutData->addAuthor(ki18n("Hasso Tepper"));
    aboutData->addAuthor(ki18n("Helge Deller"));
    aboutData->addAuthor(ki18n("Helio Castro"));
    aboutData->addAuthor(ki18n("Hideki Saito"));
    aboutData->addAuthor(ki18n("Hoàng Đức Hiếu"));
    aboutData->addAuthor(ki18n("Hugo Pereira Da Costa"));
    aboutData->addAuthor(ki18n("Inge Wallin"));
    aboutData->addAuthor(ki18n("Ingo Klöcker"));
    aboutData->addAuthor(ki18n("İsmail Dönmez"));
    aboutData->addAuthor(ki18n("Ivan Yossi"));
    aboutData->addAuthor(ki18n("Jaime"));
    aboutData->addAuthor(ki18n("Jaime Torres"));
    aboutData->addAuthor(ki18n("Jaison Lee"));
    aboutData->addAuthor(ki18n("Jakob Petsovits"));
    aboutData->addAuthor(ki18n("Jakub Stachowski"));
    aboutData->addAuthor(ki18n("Jan Hambrecht"));
    aboutData->addAuthor(ki18n("Jarosław Staniek"));
    aboutData->addAuthor(ki18n("Jens Herden"));
    aboutData->addAuthor(ki18n("Jessica Hall"));
    aboutData->addAuthor(ki18n("Johannes Simon"));
    aboutData->addAuthor(ki18n("John Layt"));
    aboutData->addAuthor(ki18n("Jonathan Riddell"));
    aboutData->addAuthor(ki18n("Jonathan Singer"));
    aboutData->addAuthor(ki18n("José Luis Vergara"));
    aboutData->addAuthor(ki18n("Juan Luis Boya García"));
    aboutData->addAuthor(ki18n("Juan Palacios"));
    aboutData->addAuthor(ki18n("Jure Repinc"));
    aboutData->addAuthor(ki18n("Kai-Uwe Behrmann"));
    aboutData->addAuthor(ki18n("Kevin Krammer"));
    aboutData->addAuthor(ki18n("Kevin Ottens"));
    aboutData->addAuthor(ki18n("Kurt Pfeifle"));
    aboutData->addAuthor(ki18n("Laurent Montel"));
    aboutData->addAuthor(ki18n("Lauri Watts"));
    aboutData->addAuthor(ki18n("Leo Savernik"));
    aboutData->addAuthor(ki18n("Lukáš Tinkl"));
    aboutData->addAuthor(ki18n("Lukáš Tvrdý"));
    aboutData->addAuthor(ki18n("Maciej Mrozowski"));
    aboutData->addAuthor(ki18n("Malcolm Hunter"));
    aboutData->addAuthor(ki18n("Manuel Riecke"));
    aboutData->addAuthor(ki18n("manu tortosa"));
    aboutData->addAuthor(ki18n("Marc Pegon"));
    aboutData->addAuthor(ki18n("Marijn Kruisselbrink"));
    aboutData->addAuthor(ki18n("Martin Ellis"));
    aboutData->addAuthor(ki18n("Martin Gräßlin"));
    aboutData->addAuthor(ki18n("Matthew Woehlke"));
    aboutData->addAuthor(ki18n("Matthias Klumpp"));
    aboutData->addAuthor(ki18n("Matthias Kretz"));
    aboutData->addAuthor(ki18n("Matus Talcik"));
    aboutData->addAuthor(ki18n("Maximiliano Curia"));
    aboutData->addAuthor(ki18n("Melchior Franz"));
    aboutData->addAuthor(ki18n("Michael David Howell"));
    aboutData->addAuthor(ki18n("Michael Drueing"));
    aboutData->addAuthor(ki18n("Michael Thaler"));
    aboutData->addAuthor(ki18n("Michel Hermier"));
    aboutData->addAuthor(ki18n("Mohit Goyal"));
    aboutData->addAuthor(ki18n("Mojtaba Shahi Senobari"));
    aboutData->addAuthor(ki18n("Montel Laurent"));
    aboutData->addAuthor(ki18n("Moritz Molch"));
    aboutData->addAuthor(ki18n("Nick Shaforostoff"));
    aboutData->addAuthor(ki18n("Nicolas Goutte"));
    aboutData->addAuthor(ki18n("Olivier Goffart"));
    aboutData->addAuthor(ki18n("Patrick Julien"));
    aboutData->addAuthor(ki18n("Patrick Spendrin"));
    aboutData->addAuthor(ki18n("Pavel Heimlich"));
    aboutData->addAuthor(ki18n("Peter Simonsson"));
    aboutData->addAuthor(ki18n("Pierre Ducroquet"));
    aboutData->addAuthor(ki18n("Pierre Stirnweiss"));
    aboutData->addAuthor(ki18n("Pino Toscano"));
    aboutData->addAuthor(ki18n("Rafael Fernández López"));
    aboutData->addAuthor(ki18n("Raphael Langerhorst"));
    aboutData->addAuthor(ki18n("Rex Dieter"));
    aboutData->addAuthor(ki18n("Rob Buis"));
    aboutData->addAuthor(ki18n("Roopesh Chander"));
    aboutData->addAuthor(ki18n("Sahil Nagpal"));
    aboutData->addAuthor(ki18n("Salil Kapur"));
    aboutData->addAuthor(ki18n("Samuel Buttigieg"));
    aboutData->addAuthor(ki18n("Sander Koning"));
    aboutData->addAuthor(ki18n("Sascha Suelzer"));
    aboutData->addAuthor(ki18n("Scott Petrovic"));
    aboutData->addAuthor(ki18n("Scott Wheeler"));
    aboutData->addAuthor(ki18n("Sebastian Sauer"));
    aboutData->addAuthor(ki18n("Shivaraman Aiyer"));
    aboutData->addAuthor(ki18n("Siddharth Sharma"));
    aboutData->addAuthor(ki18n("Silvio Heinrich"));
    aboutData->addAuthor(ki18n("Somsubhra Bairi"));
    aboutData->addAuthor(ki18n("Spencer Brown"));
    aboutData->addAuthor(ki18n("Srikanth Tiyyagura"));
    aboutData->addAuthor(ki18n("Stefan Nikolaus"));
    aboutData->addAuthor(ki18n("Stephan Binner"));
    aboutData->addAuthor(ki18n("Stephan Kulow"));
    aboutData->addAuthor(ki18n("Stuart Dickson"));
    aboutData->addAuthor(ki18n("Sune Vuorela"));
    aboutData->addAuthor(ki18n("Sven Langkamp"));
    aboutData->addAuthor(ki18n("Thiago Macieira"));
    aboutData->addAuthor(ki18n("Thomas Capricelli"));
    aboutData->addAuthor(ki18n("Thomas Friedrichsmeier"));
    aboutData->addAuthor(ki18n("Thomas Klausner"));
    aboutData->addAuthor(ki18n("Thomas Nagy"));
    aboutData->addAuthor(ki18n("Thomas Zander"));
    aboutData->addAuthor(ki18n("Thorsten Staerk"));
    aboutData->addAuthor(ki18n("Thorsten Zachmann"));
    aboutData->addAuthor(ki18n("Tim Beaulen"));
    aboutData->addAuthor(ki18n("Timothée Giet"));
    aboutData->addAuthor(ki18n("Tobias Koenig"));
    aboutData->addAuthor(ki18n("Tom Burdick"));
    aboutData->addAuthor(ki18n("Torio Mlshi"));
    aboutData->addAuthor(ki18n("Torsten Rahn"));
    aboutData->addAuthor(ki18n("Unai Garro"));
    aboutData->addAuthor(ki18n("Urs Wolfer"));
    aboutData->addAuthor(ki18n("Vadim Zhukov"));
    aboutData->addAuthor(ki18n("Vera Lukman"));
    aboutData->addAuthor(ki18n("Victor Lafon"));
    aboutData->addAuthor(ki18n("Victor Wåhlström"));
    aboutData->addAuthor(ki18n("Volker Krause"));
    aboutData->addAuthor(ki18n("Waldo Bastian"));
    aboutData->addAuthor(ki18n("Werner Trobin"));
    aboutData->addAuthor(ki18n("Wilco Greven"));
    aboutData->addAuthor(ki18n("Will Entriken"));
    aboutData->addAuthor(ki18n("William Steidtmann"));
    aboutData->addAuthor(ki18n("Wolthera van Hovell"));
    aboutData->addAuthor(ki18n("Yann Bodson"));
    aboutData->addAuthor(ki18n("Yue Liu"));
    aboutData->addAuthor(ki18n("Yuri Chornoivan"));

    aboutData->addCredit(ki18n("Peter Sikking"), ki18n("Project Vision"));
    aboutData->addCredit(ki18n("Ramon Miranda"), ki18n("Artist, Muses author, brush and preset creator"));
    aboutData->addCredit(ki18n("David Revoy"), ki18n("Brushes and Palettes"));
    aboutData->addCredit(ki18n("Ilya Portnov"), ki18n("MyPaint shade selector"));
    aboutData->addCredit(ki18n("Martin Renold"), ki18n("MyPaint shade selector"));
    aboutData->addCredit(ki18n("Sander Koning"), ki18n("Icon Management"));

    aboutData->addCredit(ki18n("Pasquale D'Antuono"), ki18n("Donor"));

    aboutData->addCredit(ki18n("マイキ"), ki18n("Krita 2.9 Kickstarter Backer"));
    aboutData->addCredit(ki18n("4lun"), ki18n("Krita 2.9 Kickstarter Backer"));
    aboutData->addCredit(ki18n("A. Agarossi"), ki18n("Krita 2.9 Kickstarter Backer"));
    aboutData->addCredit(ki18n("A. Alexeev"), ki18n("Krita 2.9 Kickstarter Backer"));
    aboutData->addCredit(ki18n("Adam J Dunn"), ki18n("Krita 2.9 Kickstarter Backer"));
    aboutData->addCredit(ki18n("Alexander Haskell"), ki18n("Krita 2.9 Kickstarter Backer"));
    aboutData->addCredit(ki18n("Alicia Rangel Avila"), ki18n("Krita 2.9 Kickstarter Backer"));
    aboutData->addCredit(ki18n("Allan Nordhøy"), ki18n("Krita 2.9 Kickstarter Backer"));
    aboutData->addCredit(ki18n("Alvaro F. Celis"), ki18n("Krita 2.9 Kickstarter Backer"));
    aboutData->addCredit(ki18n("Anatoliy Sova"), ki18n("Krita 2.9 Kickstarter Backer"));
    aboutData->addCredit(ki18n("Andreas Rieger"), ki18n("Krita 2.9 Kickstarter Backer"));
    aboutData->addCredit(ki18n("Andres"), ki18n("Krita 2.9 Kickstarter Backer"));
    aboutData->addCredit(ki18n("Andrew Buttery"), ki18n("Krita 2.9 Kickstarter Backer"));
    aboutData->addCredit(ki18n("Andrew Helm"), ki18n("Krita 2.9 Kickstarter Backer"));
    aboutData->addCredit(ki18n("Antonio Díaz"), ki18n("Krita 2.9 Kickstarter Backer"));
    aboutData->addCredit(ki18n("Armin Halac"), ki18n("Krita 2.9 Kickstarter Backer"));
    aboutData->addCredit(ki18n("Arne Brix"), ki18n("Krita 2.9 Kickstarter Backer"));
    aboutData->addCredit(ki18n("Arran Langmead"), ki18n("Krita 2.9 Kickstarter Backer"));
    aboutData->addCredit(ki18n("Arturo Jose Perez Verdu"), ki18n("Krita 2.9 Kickstarter Backer"));
    aboutData->addCredit(ki18n("AsavarTzeth"), ki18n("Krita 2.9 Kickstarter Backer"));
    aboutData->addCredit(ki18n("Axel Philipsenburg"), ki18n("Krita 2.9 Kickstarter Backer"));
    aboutData->addCredit(ki18n("Balloontree"), ki18n("Krita 2.9 Kickstarter Backer"));
    aboutData->addCredit(ki18n("Bartek Moniewski"), ki18n("Krita 2.9 Kickstarter Backer"));
    aboutData->addCredit(ki18n("Bastian"), ki18n("Krita 2.9 Kickstarter Backer"));
    aboutData->addCredit(ki18n("BenBen"), ki18n("Krita 2.9 Kickstarter Backer"));
    aboutData->addCredit(ki18n("BenjiButo"), ki18n("Krita 2.9 Kickstarter Backer"));
    aboutData->addCredit(ki18n("Bente Iren Larsen"), ki18n("Krita 2.9 Kickstarter Backer"));
    aboutData->addCredit(ki18n("Bill Travis"), ki18n("Krita 2.9 Kickstarter Backer"));
    aboutData->addCredit(ki18n("Bla6"), ki18n("Krita 2.9 Kickstarter Backer"));
    aboutData->addCredit(ki18n("blendtuts.com"), ki18n("Krita 2.9 Kickstarter Backer"));
    aboutData->addCredit(ki18n("Bogdan Covaciu"), ki18n("Krita 2.9 Kickstarter Backer"));
    aboutData->addCredit(ki18n("Børre Gaup"), ki18n("Krita 2.9 Kickstarter Backer"));
    aboutData->addCredit(ki18n("Bosse \"Melkesedek\" Jönsson"), ki18n("Krita 2.9 Kickstarter Backer"));
    aboutData->addCredit(ki18n("Brad Auty"), ki18n("Krita 2.9 Kickstarter Backer"));
    aboutData->addCredit(ki18n("Brian Hinton"), ki18n("Krita 2.9 Kickstarter Backer"));
    aboutData->addCredit(ki18n("B.Tolputt"), ki18n("Krita 2.9 Kickstarter Backer"));
    aboutData->addCredit(ki18n("Camelworks"), ki18n("Krita 2.9 Kickstarter Backer"));
    aboutData->addCredit(ki18n("Carlos Andrés Moscoso"), ki18n("Krita 2.9 Kickstarter Backer"));
    aboutData->addCredit(ki18n("Carlos Mazon"), ki18n("Krita 2.9 Kickstarter Backer"));
    aboutData->addCredit(ki18n("Cédric Archambault"), ki18n("Krita 2.9 Kickstarter Backer"));
    aboutData->addCredit(ki18n("Champagnie"), ki18n("Krita 2.9 Kickstarter Backer"));
    aboutData->addCredit(ki18n("Charles Prescott Collins IV"), ki18n("Krita 2.9 Kickstarter Backer"));
    aboutData->addCredit(ki18n("Charles Stanhope"), ki18n("Krita 2.9 Kickstarter Backer"));
    aboutData->addCredit(ki18n("chartus"), ki18n("Krita 2.9 Kickstarter Backer"));
    aboutData->addCredit(ki18n("Chris Impink"), ki18n("Krita 2.9 Kickstarter Backer"));
    aboutData->addCredit(ki18n("Chris Nutt"), ki18n("Krita 2.9 Kickstarter Backer"));
    aboutData->addCredit(ki18n("Christian Lange"), ki18n("Krita 2.9 Kickstarter Backer"));
    aboutData->addCredit(ki18n("Christian Leon Christensen @chrleon"), ki18n("Krita 2.9 Kickstarter Backer"));
    aboutData->addCredit(ki18n("Christina K"), ki18n("Krita 2.9 Kickstarter Backer"));
    aboutData->addCredit(ki18n("Christophe"), ki18n("Krita 2.9 Kickstarter Backer"));
    aboutData->addCredit(ki18n("Carré"), ki18n("Krita 2.9 Kickstarter Backer"));
    aboutData->addCredit(ki18n("chronichol"), ki18n("Krita 2.9 Kickstarter Backer"));
    aboutData->addCredit(ki18n("corien klapwijk"), ki18n("Krita 2.9 Kickstarter Backer"));
    aboutData->addCredit(ki18n("CPau"), ki18n("Krita 2.9 Kickstarter Backer"));
    aboutData->addCredit(ki18n("Cristiano Seixas"), ki18n("Krita 2.9 Kickstarter Backer"));
    aboutData->addCredit(ki18n("C.Rogers"), ki18n("Krita 2.9 Kickstarter Backer"));
    aboutData->addCredit(ki18n("cycl0ne"), ki18n("Krita 2.9 Kickstarter Backer"));
    aboutData->addCredit(ki18n("Daddle"), ki18n("Krita 2.9 Kickstarter Backer"));
    aboutData->addCredit(ki18n("DaisyBuns"), ki18n("Krita 2.9 Kickstarter Backer"));
    aboutData->addCredit(ki18n("damousey"), ki18n("Krita 2.9 Kickstarter Backer"));
    aboutData->addCredit(ki18n("Daniel Aleksandersen"), ki18n("Krita 2.9 Kickstarter Backer"));
    aboutData->addCredit(ki18n("Daniel Bull"), ki18n("Krita 2.9 Kickstarter Backer"));
    aboutData->addCredit(ki18n("Daniel Pinheiro Lima"), ki18n("Krita 2.9 Kickstarter Backer"));
    aboutData->addCredit(ki18n("Danni Coy"), ki18n("Krita 2.9 Kickstarter Backer"));
    aboutData->addCredit(ki18n("Daryl Sautter"), ki18n("Krita 2.9 Kickstarter Backer"));
    aboutData->addCredit(ki18n("David Covert"), ki18n("Krita 2.9 Kickstarter Backer"));
    aboutData->addCredit(ki18n("David Goemans"), ki18n("Krita 2.9 Kickstarter Backer"));
    aboutData->addCredit(ki18n("David Herrmann"), ki18n("Krita 2.9 Kickstarter Backer"));
    aboutData->addCredit(ki18n("David Macara"), ki18n("Krita 2.9 Kickstarter Backer"));
    aboutData->addCredit(ki18n("David Plassmann"), ki18n("Krita 2.9 Kickstarter Backer"));
    aboutData->addCredit(ki18n("David Prommer"), ki18n("Krita 2.9 Kickstarter Backer"));
    aboutData->addCredit(ki18n("David R"), ki18n("Krita 2.9 Kickstarter Backer"));
    aboutData->addCredit(ki18n("David Revoy"), ki18n("Krita 2.9 Kickstarter Backer"));
    aboutData->addCredit(ki18n("David Shere"), ki18n("Krita 2.9 Kickstarter Backer"));
    aboutData->addCredit(ki18n("Daxi Forerunner"), ki18n("Krita 2.9 Kickstarter Backer"));
    aboutData->addCredit(ki18n("denDwaler"), ki18n("Krita 2.9 Kickstarter Backer"));
    aboutData->addCredit(ki18n("Deni Klapka"), ki18n("Krita 2.9 Kickstarter Backer"));
    aboutData->addCredit(ki18n("Dezponia Veil"), ki18n("Krita 2.9 Kickstarter Backer"));
    aboutData->addCredit(ki18n("Dinesh Kumar"), ki18n("Krita 2.9 Kickstarter Backer"));
    aboutData->addCredit(ki18n("DIT"), ki18n("Krita 2.9 Kickstarter Backer"));
    aboutData->addCredit(ki18n("Ditte Mark Kreinøe"), ki18n("Krita 2.9 Kickstarter Backer"));
    aboutData->addCredit(ki18n("Dmitri \"D-Meat\" Engman"), ki18n("Krita 2.9 Kickstarter Backer"));
    aboutData->addCredit(ki18n("Dmitriy Savin"), ki18n("Krita 2.9 Kickstarter Backer"));
    aboutData->addCredit(ki18n("Don Smith"), ki18n("Krita 2.9 Kickstarter Backer"));
    aboutData->addCredit(ki18n("D. Sky Rains"), ki18n("Krita 2.9 Kickstarter Backer"));
    aboutData->addCredit(ki18n("Dustin Morabito"), ki18n("Krita 2.9 Kickstarter Backer"));
    aboutData->addCredit(ki18n("Dutch_Wolf"), ki18n("Krita 2.9 Kickstarter Backer"));
    aboutData->addCredit(ki18n("Duy Vo Van"), ki18n("Krita 2.9 Kickstarter Backer"));
    aboutData->addCredit(ki18n("D Wray"), ki18n("Krita 2.9 Kickstarter Backer"));
    aboutData->addCredit(ki18n("DzymatoR"), ki18n("Krita 2.9 Kickstarter Backer"));
    aboutData->addCredit(ki18n("edomaur"), ki18n("Krita 2.9 Kickstarter Backer"));
    aboutData->addCredit(ki18n("Edward Coughlan"), ki18n("Krita 2.9 Kickstarter Backer"));
    aboutData->addCredit(ki18n("Edward Dubovic"), ki18n("Krita 2.9 Kickstarter Backer"));
    aboutData->addCredit(ki18n("Eeku Koponen"), ki18n("Krita 2.9 Kickstarter Backer"));
    aboutData->addCredit(ki18n("Egor Nelyubov"), ki18n("Krita 2.9 Kickstarter Backer"));
    aboutData->addCredit(ki18n("Eike Hein"), ki18n("Krita 2.9 Kickstarter Backer"));
    aboutData->addCredit(ki18n("Elie Morisse"), ki18n("Krita 2.9 Kickstarter Backer"));
    aboutData->addCredit(ki18n("Elizabeth Barndollar"), ki18n("Krita 2.9 Kickstarter Backer"));
    aboutData->addCredit(ki18n("Elyaradine"), ki18n("Krita 2.9 Kickstarter Backer"));
    aboutData->addCredit(ki18n("Eo Fenstalker"), ki18n("Krita 2.9 Kickstarter Backer"));
    aboutData->addCredit(ki18n("Érico Vieira Porto"), ki18n("Krita 2.9 Kickstarter Backer"));
    aboutData->addCredit(ki18n("Erik Johansson"), ki18n("Krita 2.9 Kickstarter Backer"));
    aboutData->addCredit(ki18n("ethan calabria"), ki18n("Krita 2.9 Kickstarter Backer"));
    aboutData->addCredit(ki18n("Exilist - S.Grundmann"), ki18n("Krita 2.9 Kickstarter Backer"));
    aboutData->addCredit(ki18n("Fabian Schempp"), ki18n("Krita 2.9 Kickstarter Backer"));
    aboutData->addCredit(ki18n("Farkas Máté"), ki18n("Krita 2.9 Kickstarter Backer"));
    aboutData->addCredit(ki18n("Felicia Nørregård"), ki18n("Krita 2.9 Kickstarter Backer"));
    aboutData->addCredit(ki18n("Fernando Tortosa"), ki18n("Krita 2.9 Kickstarter Backer"));
    aboutData->addCredit(ki18n("Florian Jacob"), ki18n("Krita 2.9 Kickstarter Backer"));
    aboutData->addCredit(ki18n("Foli Ayivoh"), ki18n("Krita 2.9 Kickstarter Backer"));
    aboutData->addCredit(ki18n("Formanor"), ki18n("Krita 2.9 Kickstarter Backer"));
    aboutData->addCredit(ki18n("Francesca \"JK\" Poppi"), ki18n("Krita 2.9 Kickstarter Backer"));
    aboutData->addCredit(ki18n("François Coulon"), ki18n("Krita 2.9 Kickstarter Backer"));
    aboutData->addCredit(ki18n("Frank Bremer"), ki18n("Krita 2.9 Kickstarter Backer"));
    aboutData->addCredit(ki18n("Frédéric Momméja"), ki18n("Krita 2.9 Kickstarter Backer"));
    aboutData->addCredit(ki18n("Frederik Gladhorn"), ki18n("Krita 2.9 Kickstarter Backer"));
    aboutData->addCredit(ki18n("Frodolf"), ki18n("Krita 2.9 Kickstarter Backer"));
    aboutData->addCredit(ki18n("Fuzzyman"), ki18n("Krita 2.9 Kickstarter Backer"));
    aboutData->addCredit(ki18n("Gábor Udvari"), ki18n("Krita 2.9 Kickstarter Backer"));
    aboutData->addCredit(ki18n("gabsd84"), ki18n("Krita 2.9 Kickstarter Backer"));
    aboutData->addCredit(ki18n("Gamamoto"), ki18n("Krita 2.9 Kickstarter Backer"));
    aboutData->addCredit(ki18n("Gareth Davidson"), ki18n("Krita 2.9 Kickstarter Backer"));
    aboutData->addCredit(ki18n("Gary Thomas"), ki18n("Krita 2.9 Kickstarter Backer"));
    aboutData->addCredit(ki18n("gcala"), ki18n("Krita 2.9 Kickstarter Backer"));
    aboutData->addCredit(ki18n("geeky"), ki18n("Krita 2.9 Kickstarter Backer"));
    aboutData->addCredit(ki18n("Georg Piorczynski"), ki18n("Krita 2.9 Kickstarter Backer"));
    aboutData->addCredit(ki18n("Giant Oak Studios"), ki18n("Krita 2.9 Kickstarter Backer"));
    aboutData->addCredit(ki18n("Gibonus"), ki18n("Krita 2.9 Kickstarter Backer"));
    aboutData->addCredit(ki18n("Giovanni Bianco"), ki18n("Krita 2.9 Kickstarter Backer"));
    aboutData->addCredit(ki18n("Giovanni Remigi"), ki18n("Krita 2.9 Kickstarter Backer"));
    aboutData->addCredit(ki18n("GNX"), ki18n("Krita 2.9 Kickstarter Backer"));
    aboutData->addCredit(ki18n("goda87"), ki18n("Krita 2.9 Kickstarter Backer"));
    aboutData->addCredit(ki18n("Grant Borodin"), ki18n("Krita 2.9 Kickstarter Backer"));
    aboutData->addCredit(ki18n("Grégory Fauchille"), ki18n("Krita 2.9 Kickstarter Backer"));
    aboutData->addCredit(ki18n("Grigory Petrov"), ki18n("Krita 2.9 Kickstarter Backer"));
    aboutData->addCredit(ki18n("gummiwaffen"), ki18n("Krita 2.9 Kickstarter Backer"));
    aboutData->addCredit(ki18n("GustavN"), ki18n("Krita 2.9 Kickstarter Backer"));
    aboutData->addCredit(ki18n("Hayashihikaru"), ki18n("Krita 2.9 Kickstarter Backer"));
    aboutData->addCredit(ki18n("Heather Blandford"), ki18n("Krita 2.9 Kickstarter Backer"));
    aboutData->addCredit(ki18n("Hector Dubon"), ki18n("Krita 2.9 Kickstarter Backer"));
    aboutData->addCredit(ki18n("higekzk"), ki18n("Krita 2.9 Kickstarter Backer"));
    aboutData->addCredit(ki18n("High Iron Studios"), ki18n("Krita 2.9 Kickstarter Backer"));
    aboutData->addCredit(ki18n("Hiroki Ishikura"), ki18n("Krita 2.9 Kickstarter Backer"));
    aboutData->addCredit(ki18n("Hixe"), ki18n("Krita 2.9 Kickstarter Backer"));
    aboutData->addCredit(ki18n("home"), ki18n("Krita 2.9 Kickstarter Backer"));
    aboutData->addCredit(ki18n("Hra Luoma"), ki18n("Krita 2.9 Kickstarter Backer"));
    aboutData->addCredit(ki18n("Hydralien"), ki18n("Krita 2.9 Kickstarter Backer"));
    aboutData->addCredit(ki18n("IBurmistrov"), ki18n("Krita 2.9 Kickstarter Backer"));
    aboutData->addCredit(ki18n("icarrion"), ki18n("Krita 2.9 Kickstarter Backer"));
    aboutData->addCredit(ki18n("Ihara"), ki18n("Krita 2.9 Kickstarter Backer"));
    aboutData->addCredit(ki18n("iiinn"), ki18n("Krita 2.9 Kickstarter Backer"));
    aboutData->addCredit(ki18n("Iker AM"), ki18n("Krita 2.9 Kickstarter Backer"));
    aboutData->addCredit(ki18n("Ilya Diallo"), ki18n("Krita 2.9 Kickstarter Backer"));
    aboutData->addCredit(ki18n("Ilya Portnov"), ki18n("Krita 2.9 Kickstarter Backer"));
    aboutData->addCredit(ki18n("Imco Veenstra"), ki18n("Krita 2.9 Kickstarter Backer"));
    aboutData->addCredit(ki18n("inalyricalcoma"), ki18n("Krita 2.9 Kickstarter Backer"));
    aboutData->addCredit(ki18n("Incurious Films"), ki18n("Krita 2.9 Kickstarter Backer"));
    aboutData->addCredit(ki18n("Jack Hill"), ki18n("Krita 2.9 Kickstarter Backer"));
    aboutData->addCredit(ki18n("Jackie Myles"), ki18n("Krita 2.9 Kickstarter Backer"));
    aboutData->addCredit(ki18n("Jacson Spacial Querubin"), ki18n("Krita 2.9 Kickstarter Backer"));
    aboutData->addCredit(ki18n("James Graham"), ki18n("Krita 2.9 Kickstarter Backer"));
    aboutData->addCredit(ki18n("James O'Hare"), ki18n("Krita 2.9 Kickstarter Backer"));
    aboutData->addCredit(ki18n("James Thompson"), ki18n("Krita 2.9 Kickstarter Backer"));
    aboutData->addCredit(ki18n("Jari-Pekka Kankaanpää"), ki18n("Krita 2.9 Kickstarter Backer"));
    aboutData->addCredit(ki18n("Jarno Lehto"), ki18n("Krita 2.9 Kickstarter Backer"));
    aboutData->addCredit(ki18n("Jaroslav \"Rezza\" Reznik"), ki18n("Krita 2.9 Kickstarter Backer"));
    aboutData->addCredit(ki18n("Jefferson Ietto Novo"), ki18n("Krita 2.9 Kickstarter Backer"));
    aboutData->addCredit(ki18n("Jens Reuterberg"), ki18n("Krita 2.9 Kickstarter Backer"));
    aboutData->addCredit(ki18n("João Lima"), ki18n("Krita 2.9 Kickstarter Backer"));
    aboutData->addCredit(ki18n("Joeri \"Ailaik\" Schouten"), ki18n("Krita 2.9 Kickstarter Backer"));
    aboutData->addCredit(ki18n("Johan Manders"), ki18n("Krita 2.9 Kickstarter Backer"));
    aboutData->addCredit(ki18n("John the Treeman"), ki18n("Krita 2.9 Kickstarter Backer"));
    aboutData->addCredit(ki18n("John Urquhart 'Sympodius' Ferguson"), ki18n("Krita 2.9 Kickstarter Backer"));
    aboutData->addCredit(ki18n("Jonathan Ringstad"), ki18n("Krita 2.9 Kickstarter Backer"));
    aboutData->addCredit(ki18n("Jonathan Williamson"), ki18n("Krita 2.9 Kickstarter Backer"));
    aboutData->addCredit(ki18n("Jörg Rosenbauer"), ki18n("Krita 2.9 Kickstarter Backer"));
    aboutData->addCredit(ki18n("Josep Febrer Salord"), ki18n("Krita 2.9 Kickstarter Backer"));
    aboutData->addCredit(ki18n("Joshua Ols"), ki18n("Krita 2.9 Kickstarter Backer"));
    aboutData->addCredit(ki18n("JP LeBreton"), ki18n("Krita 2.9 Kickstarter Backer"));
    aboutData->addCredit(ki18n("Juanjo Faico"), ki18n("Krita 2.9 Kickstarter Backer"));
    aboutData->addCredit(ki18n("JuanPi Carbajal"), ki18n("Krita 2.9 Kickstarter Backer"));
    aboutData->addCredit(ki18n("Juan V Camuñas"), ki18n("Krita 2.9 Kickstarter Backer"));
    aboutData->addCredit(ki18n("Jucato"), ki18n("Krita 2.9 Kickstarter Backer"));
    aboutData->addCredit(ki18n("Kahncub Farina"), ki18n("Krita 2.9 Kickstarter Backer"));
    aboutData->addCredit(ki18n("Karith Densmore"), ki18n("Krita 2.9 Kickstarter Backer"));
    aboutData->addCredit(ki18n("Kārlis Stiģis"), ki18n("Krita 2.9 Kickstarter Backer"));
    aboutData->addCredit(ki18n("Karlos"), ki18n("Krita 2.9 Kickstarter Backer"));
    aboutData->addCredit(ki18n("Karl Ove Hufthammer"), ki18n("Krita 2.9 Kickstarter Backer"));
    aboutData->addCredit(ki18n("Kathy Reid"), ki18n("Krita 2.9 Kickstarter Backer"));
    aboutData->addCredit(ki18n("Kayne Crinomy"), ki18n("Krita 2.9 Kickstarter Backer"));
    aboutData->addCredit(ki18n("Kerry Mitchell"), ki18n("Krita 2.9 Kickstarter Backer"));
    aboutData->addCredit(ki18n("Kevin \"Hirato\" Meyer"), ki18n("Krita 2.9 Kickstarter Backer"));
    aboutData->addCredit(ki18n("Kevin Lariviere"), ki18n("Krita 2.9 Kickstarter Backer"));
    aboutData->addCredit(ki18n("Klaemoer"), ki18n("Krita 2.9 Kickstarter Backer"));
    aboutData->addCredit(ki18n("Klas Jonsson"), ki18n("Krita 2.9 Kickstarter Backer"));
    aboutData->addCredit(ki18n("kokobin"), ki18n("Krita 2.9 Kickstarter Backer"));
    aboutData->addCredit(ki18n("Kongorilla"), ki18n("Krita 2.9 Kickstarter Backer"));
    aboutData->addCredit(ki18n("Kpowgames"), ki18n("Krita 2.9 Kickstarter Backer"));
    aboutData->addCredit(ki18n("Krasi Mirchev"), ki18n("Krita 2.9 Kickstarter Backer"));
    aboutData->addCredit(ki18n("Kresimir Kis"), ki18n("Krita 2.9 Kickstarter Backer"));
    aboutData->addCredit(ki18n("Kwatch"), ki18n("Krita 2.9 Kickstarter Backer"));
    aboutData->addCredit(ki18n("Lani Aung"), ki18n("Krita 2.9 Kickstarter Backer"));
    aboutData->addCredit(ki18n("Lars Lawrenz"), ki18n("Krita 2.9 Kickstarter Backer"));
    aboutData->addCredit(ki18n("LAS"), ki18n("Krita 2.9 Kickstarter Backer"));
    aboutData->addCredit(ki18n("Laurent"), ki18n("Krita 2.9 Kickstarter Backer"));
    aboutData->addCredit(ki18n("Laurent Espitallier"), ki18n("Krita 2.9 Kickstarter Backer"));
    aboutData->addCredit(ki18n("LcLk"), ki18n("Krita 2.9 Kickstarter Backer"));
    aboutData->addCredit(ki18n("Leecifer"), ki18n("Krita 2.9 Kickstarter Backer"));
    aboutData->addCredit(ki18n("Lee Kenning"), ki18n("Krita 2.9 Kickstarter Backer"));
    aboutData->addCredit(ki18n("Lee Symes"), ki18n("Krita 2.9 Kickstarter Backer"));
    aboutData->addCredit(ki18n("Leonhard Landrock"), ki18n("Krita 2.9 Kickstarter Backer"));
    aboutData->addCredit(ki18n("Level¹Imp"), ki18n("Krita 2.9 Kickstarter Backer"));
    aboutData->addCredit(ki18n("ligertimjan"), ki18n("Krita 2.9 Kickstarter Backer"));
    aboutData->addCredit(ki18n("lili lith"), ki18n("Krita 2.9 Kickstarter Backer"));
    aboutData->addCredit(ki18n("Lilis Iskandar"), ki18n("Krita 2.9 Kickstarter Backer"));
    aboutData->addCredit(ki18n("Lim Yuen Hoe"), ki18n("Krita 2.9 Kickstarter Backer"));
    aboutData->addCredit(ki18n("Linda van Zoggel-Polman"), ki18n("Krita 2.9 Kickstarter Backer"));
    aboutData->addCredit(ki18n("Lorant Szakacs"), ki18n("Krita 2.9 Kickstarter Backer"));
    aboutData->addCredit(ki18n("LordPanther"), ki18n("Krita 2.9 Kickstarter Backer"));
    aboutData->addCredit(ki18n("Lorian Grace"), ki18n("Krita 2.9 Kickstarter Backer"));
    aboutData->addCredit(ki18n("Lucas Falcao"), ki18n("Krita 2.9 Kickstarter Backer"));
    aboutData->addCredit(ki18n("Luciano Montanaro"), ki18n("Krita 2.9 Kickstarter Backer"));
    aboutData->addCredit(ki18n("Ludovic"), ki18n("Krita 2.9 Kickstarter Backer"));
    aboutData->addCredit(ki18n("Luiz F. Paulucci"), ki18n("Krita 2.9 Kickstarter Backer"));
    aboutData->addCredit(ki18n("Lukas Filzer"), ki18n("Krita 2.9 Kickstarter Backer"));
    aboutData->addCredit(ki18n("Mads Tuxen"), ki18n("Krita 2.9 Kickstarter Backer"));
    aboutData->addCredit(ki18n("MahouTskai"), ki18n("Krita 2.9 Kickstarter Backer"));
    aboutData->addCredit(ki18n("Marc Albrecht"), ki18n("Krita 2.9 Kickstarter Backer"));
    aboutData->addCredit(ki18n("Marco Caminada"), ki18n("Krita 2.9 Kickstarter Backer"));
    aboutData->addCredit(ki18n("Mario Latronico"), ki18n("Krita 2.9 Kickstarter Backer"));
    aboutData->addCredit(ki18n("Mark Pearson"), ki18n("Krita 2.9 Kickstarter Backer"));
    aboutData->addCredit(ki18n("Mark Titchener"), ki18n("Krita 2.9 Kickstarter Backer"));
    aboutData->addCredit(ki18n("Markus Germann"), ki18n("Krita 2.9 Kickstarter Backer"));
    aboutData->addCredit(ki18n("Matias Mendiola"), ki18n("Krita 2.9 Kickstarter Backer"));
    aboutData->addCredit(ki18n("Matthieu Chevillot"), ki18n("Krita 2.9 Kickstarter Backer"));
    aboutData->addCredit(ki18n("Matt Jordan"), ki18n("Krita 2.9 Kickstarter Backer"));
    aboutData->addCredit(ki18n("maxamillion"), ki18n("Krita 2.9 Kickstarter Backer"));
    aboutData->addCredit(ki18n("Max Torres"), ki18n("Krita 2.9 Kickstarter Backer"));
    aboutData->addCredit(ki18n("Mdk"), ki18n("Krita 2.9 Kickstarter Backer"));
    aboutData->addCredit(ki18n("@meffrafax"), ki18n("Krita 2.9 Kickstarter Backer"));
    aboutData->addCredit(ki18n("\"Melkesedek\" Jönsson"), ki18n("Krita 2.9 Kickstarter Backer"));
    aboutData->addCredit(ki18n("memnoch_proxy"), ki18n("Krita 2.9 Kickstarter Backer"));
    aboutData->addCredit(ki18n("Metalfreak"), ki18n("Krita 2.9 Kickstarter Backer"));
    aboutData->addCredit(ki18n("Michael"), ki18n("Krita 2.9 Kickstarter Backer"));
    aboutData->addCredit(ki18n("Michael Abrahams"), ki18n("Krita 2.9 Kickstarter Backer"));
    aboutData->addCredit(ki18n("Michael Knubben"), ki18n("Krita 2.9 Kickstarter Backer"));
    aboutData->addCredit(ki18n("Michael Papkov"), ki18n("Krita 2.9 Kickstarter Backer"));
    aboutData->addCredit(ki18n("Michael Pohoreski"), ki18n("Krita 2.9 Kickstarter Backer"));
    aboutData->addCredit(ki18n("Michael Thaler"), ki18n("Krita 2.9 Kickstarter Backer"));
    aboutData->addCredit(ki18n("Michel Vilain"), ki18n("Krita 2.9 Kickstarter Backer"));
    aboutData->addCredit(ki18n("micrypt"), ki18n("Krita 2.9 Kickstarter Backer"));
    aboutData->addCredit(ki18n("Mike"), ki18n("Krita 2.9 Kickstarter Backer"));
    aboutData->addCredit(ki18n("Mike"), ki18n("Krita 2.9 Kickstarter Backer"));
    aboutData->addCredit(ki18n("Linksvayer"), ki18n("Krita 2.9 Kickstarter Backer"));
    aboutData->addCredit(ki18n("miko"), ki18n("Krita 2.9 Kickstarter Backer"));
    aboutData->addCredit(ki18n("Mitja"), ki18n("Krita 2.9 Kickstarter Backer"));
    aboutData->addCredit(ki18n("Mke"), ki18n("Krita 2.9 Kickstarter Backer"));
    aboutData->addCredit(ki18n("mnem"), ki18n("Krita 2.9 Kickstarter Backer"));
    aboutData->addCredit(ki18n("Mr Tonks"), ki18n("Krita 2.9 Kickstarter Backer"));
    aboutData->addCredit(ki18n("Mu57Di3"), ki18n("Krita 2.9 Kickstarter Backer"));
    aboutData->addCredit(ki18n("Mufeed Al-Hashim"), ki18n("Krita 2.9 Kickstarter Backer"));
    aboutData->addCredit(ki18n("myster0n"), ki18n("Krita 2.9 Kickstarter Backer"));
    aboutData->addCredit(ki18n("Nasser Alshammari"), ki18n("Krita 2.9 Kickstarter Backer"));
    aboutData->addCredit(ki18n("Neko-Maya"), ki18n("Krita 2.9 Kickstarter Backer"));
    aboutData->addCredit(ki18n("Nical"), ki18n("Krita 2.9 Kickstarter Backer"));
    aboutData->addCredit(ki18n("Nick Miller"), ki18n("Krita 2.9 Kickstarter Backer"));
    aboutData->addCredit(ki18n("nicoguaro"), ki18n("Krita 2.9 Kickstarter Backer"));
    aboutData->addCredit(ki18n("Nicolas Brisset"), ki18n("Krita 2.9 Kickstarter Backer"));
    aboutData->addCredit(ki18n("Nicolas Duhil"), ki18n("Krita 2.9 Kickstarter Backer"));
    aboutData->addCredit(ki18n("Nikolai Schlegel"), ki18n("Krita 2.9 Kickstarter Backer"));
    aboutData->addCredit(ki18n("Nikolaj Woroschilow"), ki18n("Krita 2.9 Kickstarter Backer"));
    aboutData->addCredit(ki18n("NiKoZ"), ki18n("Krita 2.9 Kickstarter Backer"));
    aboutData->addCredit(ki18n("Nils Sabelstrom"), ki18n("Krita 2.9 Kickstarter Backer"));
    aboutData->addCredit(ki18n("nml.121"), ki18n("Krita 2.9 Kickstarter Backer"));
    aboutData->addCredit(ki18n("nullreff"), ki18n("Krita 2.9 Kickstarter Backer"));
    aboutData->addCredit(ki18n("nut-case"), ki18n("Krita 2.9 Kickstarter Backer"));
    aboutData->addCredit(ki18n("nya"), ki18n("Krita 2.9 Kickstarter Backer"));
    aboutData->addCredit(ki18n("nylnook"), ki18n("Krita 2.9 Kickstarter Backer"));
    aboutData->addCredit(ki18n("Odd Pierrot"), ki18n("Krita 2.9 Kickstarter Backer"));
    aboutData->addCredit(ki18n("Odysseas"), ki18n("Krita 2.9 Kickstarter Backer"));
    aboutData->addCredit(ki18n("oenvoyage"), ki18n("Krita 2.9 Kickstarter Backer"));
    aboutData->addCredit(ki18n("Olle Jonsson"), ki18n("Krita 2.9 Kickstarter Backer"));
    aboutData->addCredit(ki18n("Oskar Świerad"), ki18n("Krita 2.9 Kickstarter Backer"));
    aboutData->addCredit(ki18n("Oxben"), ki18n("Krita 2.9 Kickstarter Backer"));
    aboutData->addCredit(ki18n("Pablo Gil"), ki18n("Krita 2.9 Kickstarter Backer"));
    aboutData->addCredit(ki18n("Pascal Schmid"), ki18n("Krita 2.9 Kickstarter Backer"));
    aboutData->addCredit(ki18n("Pat David"), ki18n("Krita 2.9 Kickstarter Backer"));
    aboutData->addCredit(ki18n("Patrick \"ponpat\" Poniewas"), ki18n("Krita 2.9 Kickstarter Backer"));
    aboutData->addCredit(ki18n("Paul Wortmann"), ki18n("Krita 2.9 Kickstarter Backer"));
    aboutData->addCredit(ki18n("Pawel Swierczynski"), ki18n("Krita 2.9 Kickstarter Backer"));
    aboutData->addCredit(ki18n("P+B-Snegge"), ki18n("Krita 2.9 Kickstarter Backer"));
    aboutData->addCredit(ki18n("pepeland"), ki18n("Krita 2.9 Kickstarter Backer"));
    aboutData->addCredit(ki18n("Peter Moonen"), ki18n("Krita 2.9 Kickstarter Backer"));
    aboutData->addCredit(ki18n("Peter Simonsson"), ki18n("Krita 2.9 Kickstarter Backer"));
    aboutData->addCredit(ki18n("Pete Smith"), ki18n("Krita 2.9 Kickstarter Backer"));
    aboutData->addCredit(ki18n("Pevzi"), ki18n("Krita 2.9 Kickstarter Backer"));
    aboutData->addCredit(ki18n("Philip Cohn-Cort"), ki18n("Krita 2.9 Kickstarter Backer"));
    aboutData->addCredit(ki18n("Philip Edwards (@p2edwards)"), ki18n("Krita 2.9 Kickstarter Backer"));
    aboutData->addCredit(ki18n("Pierre Dumot"), ki18n("Krita 2.9 Kickstarter Backer"));
    aboutData->addCredit(ki18n("pKrime"), ki18n("Krita 2.9 Kickstarter Backer"));
    aboutData->addCredit(ki18n("pnlarsson"), ki18n("Krita 2.9 Kickstarter Backer"));
    aboutData->addCredit(ki18n("Ponpon malon"), ki18n("Krita 2.9 Kickstarter Backer"));
    aboutData->addCredit(ki18n("Rafał Danhoffer"), ki18n("Krita 2.9 Kickstarter Backer"));
    aboutData->addCredit(ki18n("Rainer Gievers"), ki18n("Krita 2.9 Kickstarter Backer"));
    aboutData->addCredit(ki18n("RayoGlauco"), ki18n("Krita 2.9 Kickstarter Backer"));
    aboutData->addCredit(ki18n("RealZero"), ki18n("Krita 2.9 Kickstarter Backer"));
    aboutData->addCredit(ki18n("Reinhard"), ki18n("Krita 2.9 Kickstarter Backer"));
    aboutData->addCredit(ki18n("Rhakios"), ki18n("Krita 2.9 Kickstarter Backer"));
    aboutData->addCredit(ki18n("Richard Bensley"), ki18n("Krita 2.9 Kickstarter Backer"));
    aboutData->addCredit(ki18n("Richard Jarvis"), ki18n("Krita 2.9 Kickstarter Backer"));
    aboutData->addCredit(ki18n("Rick Stirling"), ki18n("Krita 2.9 Kickstarter Backer"));
    aboutData->addCredit(ki18n("ridli"), ki18n("Krita 2.9 Kickstarter Backer"));
    aboutData->addCredit(ki18n("Robert Wloch Professional Consulting"), ki18n("Krita 2.9 Kickstarter Backer"));
    aboutData->addCredit(ki18n("Robin Princeley"), ki18n("Krita 2.9 Kickstarter Backer"));
    aboutData->addCredit(ki18n("Rodrigo Hobart García"), ki18n("Krita 2.9 Kickstarter Backer"));
    aboutData->addCredit(ki18n("Roland"), ki18n("Krita 2.9 Kickstarter Backer"));
    aboutData->addCredit(ki18n("Roman Nazarenko"), ki18n("Krita 2.9 Kickstarter Backer"));
    aboutData->addCredit(ki18n("Rubén Moreno Montoliu"), ki18n("Krita 2.9 Kickstarter Backer"));
    aboutData->addCredit(ki18n("Sam Alarcón"), ki18n("Krita 2.9 Kickstarter Backer"));
    aboutData->addCredit(ki18n("Samuel Roberts"), ki18n("Krita 2.9 Kickstarter Backer"));
    aboutData->addCredit(ki18n("Scott Petrovic"), ki18n("Krita 2.9 Kickstarter Backer"));
    aboutData->addCredit(ki18n("Scott Wilson"), ki18n("Krita 2.9 Kickstarter Backer"));
    aboutData->addCredit(ki18n("SeaJey"), ki18n("Krita 2.9 Kickstarter Backer"));
    aboutData->addCredit(ki18n("sebokie"), ki18n("Krita 2.9 Kickstarter Backer"));
    aboutData->addCredit(ki18n("Shawn Rutledge"), ki18n("Krita 2.9 Kickstarter Backer"));
    aboutData->addCredit(ki18n("Shiruriru"), ki18n("Krita 2.9 Kickstarter Backer"));
    aboutData->addCredit(ki18n("Silvan Jegen"), ki18n("Krita 2.9 Kickstarter Backer"));
    aboutData->addCredit(ki18n("Simon Legrand"), ki18n("Krita 2.9 Kickstarter Backer"));
    aboutData->addCredit(ki18n("S J Bennett"), ki18n("Krita 2.9 Kickstarter Backer"));
    aboutData->addCredit(ki18n("S Jester"), ki18n("Krita 2.9 Kickstarter Backer"));
    aboutData->addCredit(ki18n("Sketch Stick"), ki18n("Krita 2.9 Kickstarter Backer"));
    aboutData->addCredit(ki18n("Skevos Mavros"), ki18n("Krita 2.9 Kickstarter Backer"));
    aboutData->addCredit(ki18n("Snoopfilou"), ki18n("Krita 2.9 Kickstarter Backer"));
    aboutData->addCredit(ki18n("Soares Chen"), ki18n("Krita 2.9 Kickstarter Backer"));
    aboutData->addCredit(ki18n("Soren Lane"), ki18n("Krita 2.9 Kickstarter Backer"));
    aboutData->addCredit(ki18n("Søren Thing Andersen"), ki18n("Krita 2.9 Kickstarter Backer"));
    aboutData->addCredit(ki18n("Soriac"), ki18n("Krita 2.9 Kickstarter Backer"));
    aboutData->addCredit(ki18n("Stefan Steinbauer"), ki18n("Krita 2.9 Kickstarter Backer"));
    aboutData->addCredit(ki18n("Stephen Croft"), ki18n("Krita 2.9 Kickstarter Backer"));
    aboutData->addCredit(ki18n("Stephen D Egts"), ki18n("Krita 2.9 Kickstarter Backer"));
    aboutData->addCredit(ki18n("Stephen Shiu"), ki18n("Krita 2.9 Kickstarter Backer"));
    aboutData->addCredit(ki18n("Sternenwolf"), ki18n("Krita 2.9 Kickstarter Backer"));
    aboutData->addCredit(ki18n("Steven Calwas"), ki18n("Krita 2.9 Kickstarter Backer"));
    aboutData->addCredit(ki18n("Stramaz"), ki18n("Krita 2.9 Kickstarter Backer"));
    aboutData->addCredit(ki18n("Stuart"), ki18n("Krita 2.9 Kickstarter Backer"));
    aboutData->addCredit(ki18n("Stuart Martin"), ki18n("Krita 2.9 Kickstarter Backer"));
    aboutData->addCredit(ki18n("Studio Regen"), ki18n("Krita 2.9 Kickstarter Backer"));
    aboutData->addCredit(ki18n("Sumanas"), ki18n("Krita 2.9 Kickstarter Backer"));
    aboutData->addCredit(ki18n("Syndarion"), ki18n("Krita 2.9 Kickstarter Backer"));
    aboutData->addCredit(ki18n("tanukisan"), ki18n("Krita 2.9 Kickstarter Backer"));
    aboutData->addCredit(ki18n("Tasuku Suzuki"), ki18n("Krita 2.9 Kickstarter Backer"));
    aboutData->addCredit(ki18n("TD-Linux"), ki18n("Krita 2.9 Kickstarter Backer"));
    aboutData->addCredit(ki18n("Teddy Ursadorable"), ki18n("Krita 2.9 Kickstarter Backer"));
    aboutData->addCredit(ki18n("Tepee (alias Tristan Paulais)"), ki18n("Krita 2.9 Kickstarter Backer"));
    aboutData->addCredit(ki18n("TesX"), ki18n("Krita 2.9 Kickstarter Backer"));
    aboutData->addCredit(ki18n("Thomas Beck (plasmasolutions)"), ki18n("Krita 2.9 Kickstarter Backer"));
    aboutData->addCredit(ki18n("Thomas Penin"), ki18n("Krita 2.9 Kickstarter Backer"));
    aboutData->addCredit(ki18n("Tim Lawrence"), ki18n("Krita 2.9 Kickstarter Backer"));
    aboutData->addCredit(ki18n("Todimus"), ki18n("Krita 2.9 Kickstarter Backer"));
    aboutData->addCredit(ki18n("Tyson Tan"), ki18n("Krita 2.9 Kickstarter Backer"));
    aboutData->addCredit(ki18n("Usamah Philips"), ki18n("Krita 2.9 Kickstarter Backer"));
    aboutData->addCredit(ki18n("Utao"), ki18n("Krita 2.9 Kickstarter Backer"));
    aboutData->addCredit(ki18n("Vinicius Braga"), ki18n("Krita 2.9 Kickstarter Backer"));
    aboutData->addCredit(ki18n("Vlad"), ki18n("Krita 2.9 Kickstarter Backer"));
    aboutData->addCredit(ki18n("Vladislav A. Makeev"), ki18n("Krita 2.9 Kickstarter Backer"));
    aboutData->addCredit(ki18n("vo hoang"), ki18n("Krita 2.9 Kickstarter Backer"));
    aboutData->addCredit(ki18n("voltagex"), ki18n("Krita 2.9 Kickstarter Backer"));
    aboutData->addCredit(ki18n("vxmrtm"), ki18n("Krita 2.9 Kickstarter Backer"));
    aboutData->addCredit(ki18n("Wahooney"), ki18n("Krita 2.9 Kickstarter Backer"));
    aboutData->addCredit(ki18n("Wilhansen Joseph Li"), ki18n("Krita 2.9 Kickstarter Backer"));
    aboutData->addCredit(ki18n("Will Thorup"), ki18n("Krita 2.9 Kickstarter Backer"));
    aboutData->addCredit(ki18n("Wohma4"), ki18n("Krita 2.9 Kickstarter Backer"));
    aboutData->addCredit(ki18n("Wybren van Keulen"), ki18n("Krita 2.9 Kickstarter Backer"));
    aboutData->addCredit(ki18n("Xavier Guillot"), ki18n("Krita 2.9 Kickstarter Backer"));
    aboutData->addCredit(ki18n("xghostx7"), ki18n("Krita 2.9 Kickstarter Backer"));
    aboutData->addCredit(ki18n("Yalyn \"Yabo\" Vinkindo"), ki18n("Krita 2.9 Kickstarter Backer"));
    aboutData->addCredit(ki18n("Yuriy Chernyshov"), ki18n("Krita 2.9 Kickstarter Backer"));
    aboutData->addCredit(ki18n("Zatapathique"), ki18n("Krita 2.9 Kickstarter Backer"));
    aboutData->addCredit(ki18n("Zett-0"), ki18n("Krita 2.9 Kickstarter Backer"));
    aboutData->addCredit(ki18n("Zorael"), ki18n("Krita 2.9 Kickstarter Backer"));
    aboutData->addCredit(ki18n("And 47 anonymous backers"), ki18n("Krita 2.9 Kickstarter Backer"));


    return aboutData;
}

