/*****************************************************************************
 * $CAMITK_LICENCE_BEGIN$
 *
 * CamiTK - Computer Assisted Medical Intervention ToolKit
 * (c) 2001-2013 UJF-Grenoble 1, CNRS, TIMC-IMAG UMR 5525 (GMCAO)
 *
 * Visit http://camitk.imag.fr for more information
 *
 * This file is part of CamiTK.
 *
 * CamiTK is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License version 3
 * only, as published by the Free Software Foundation.
 *
 * CamiTK is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License version 3 for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * version 3 along with CamiTK.  If not, see <http://www.gnu.org/licenses/>.
 *
 * $CAMITK_LICENCE_END$
 ****************************************************************************/

#include <pml/Atom.h>
#include <pml/PhysicalModel.h>


#include <Component.h>
#include "PMManagerDC.h"

#include "AtomDCPopup.h"
#include "AtomDC.h"

#include "LoadsManager.h"

// ---------------------- constructor  ----------------------------
AtomDCPopup::AtomDCPopup(camitk::Component *dc, QWidget *parent) : camitk::ComponentPopupMenu(dc,parent) {
  addAction("Add load...", SLOT(addLoad()));
}

// ---------------------- addLoad ----------------------------
void AtomDCPopup::addLoad() {
    // access to the PMManagerDC and ask it to add a load
    dynamic_cast<AtomDC*>(myComponent)->getPMManagerDC()->getLoadsManager()->addLoad();
}

