/*
 *    This file is part of CasADi.
 *
 *    CasADi -- A symbolic framework for dynamic optimization.
 *    Copyright (C) 2010-2023 Joel Andersson, Joris Gillis, Moritz Diehl,
 *                            KU Leuven. All rights reserved.
 *    Copyright (C) 2011-2014 Greg Horn
 *
 *    CasADi is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License as published by the Free Software Foundation; either
 *    version 3 of the License, or (at your option) any later version.
 *
 *    CasADi is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with CasADi; if not, write to the Free Software
 *    Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 *
 */


      #include "blocksqp.hpp"
      #include <string>

      const std::string casadi::Blocksqp::meta_doc=
      "\n"
"\n"
"\n"
"This is a modified version of blockSQP by Janka et al.\n"
"\n"
"\n"
"Dennis Janka, Joel Andersson \n"
"\n"
"Extra doc: https://github.com/casadi/casadi/wiki/L_224 \n"
"\n"
"\n"
">List of available options\n"
"\n"
"+----------------------------+-----------+---------------------------------+\n"
"|             Id             |   Type    |           Description           |\n"
"+============================+===========+=================================+\n"
"| block_hess                 | OT_INT    | Blockwise Hessian               |\n"
"|                            |           | approximation?                  |\n"
"+----------------------------+-----------+---------------------------------+\n"
"| col_eps                    | OT_DOUBLE | Epsilon for COL scaling         |\n"
"|                            |           | strategy                        |\n"
"+----------------------------+-----------+---------------------------------+\n"
"| col_tau1                   | OT_DOUBLE | tau1 for COL scaling strategy   |\n"
"+----------------------------+-----------+---------------------------------+\n"
"| col_tau2                   | OT_DOUBLE | tau2 for COL scaling strategy   |\n"
"+----------------------------+-----------+---------------------------------+\n"
"| conv_strategy              | OT_INT    | Convexification strategy        |\n"
"+----------------------------+-----------+---------------------------------+\n"
"| delta                      | OT_DOUBLE | Filter line search parameter,   |\n"
"|                            |           | cf. IPOPT paper                 |\n"
"+----------------------------+-----------+---------------------------------+\n"
"| delta_h0                   | OT_DOUBLE | Filter line search parameter,   |\n"
"|                            |           | cf. IPOPT paper                 |\n"
"+----------------------------+-----------+---------------------------------+\n"
"| eps                        | OT_DOUBLE | Values smaller than this are    |\n"
"|                            |           | regarded as numerically zero    |\n"
"+----------------------------+-----------+---------------------------------+\n"
"| eta                        | OT_DOUBLE | Filter line search parameter,   |\n"
"|                            |           | cf. IPOPT paper                 |\n"
"+----------------------------+-----------+---------------------------------+\n"
"| fallback_scaling           | OT_INT    | If indefinite update is used,   |\n"
"|                            |           | the type of fallback strategy   |\n"
"+----------------------------+-----------+---------------------------------+\n"
"| fallback_update            | OT_INT    | If indefinite update is used,   |\n"
"|                            |           | the type of fallback strategy   |\n"
"+----------------------------+-----------+---------------------------------+\n"
"| gamma_f                    | OT_DOUBLE | Filter line search parameter,   |\n"
"|                            |           | cf. IPOPT paper                 |\n"
"+----------------------------+-----------+---------------------------------+\n"
"| gamma_theta                | OT_DOUBLE | Filter line search parameter,   |\n"
"|                            |           | cf. IPOPT paper                 |\n"
"+----------------------------+-----------+---------------------------------+\n"
"| globalization              | OT_BOOL   | Enable globalization            |\n"
"+----------------------------+-----------+---------------------------------+\n"
"| hess_damp                  | OT_INT    | Activate Powell damping for     |\n"
"|                            |           | BFGS                            |\n"
"+----------------------------+-----------+---------------------------------+\n"
"| hess_damp_fac              | OT_DOUBLE | Damping factor for BFGS Powell  |\n"
"|                            |           | modification                    |\n"
"+----------------------------+-----------+---------------------------------+\n"
"| hess_lim_mem               | OT_INT    | Full or limited memory          |\n"
"+----------------------------+-----------+---------------------------------+\n"
"| hess_memsize               | OT_INT    | Memory size for L-BFGS updates  |\n"
"+----------------------------+-----------+---------------------------------+\n"
"| hess_scaling               | OT_INT    | Scaling strategy for Hessian    |\n"
"|                            |           | approximation                   |\n"
"+----------------------------+-----------+---------------------------------+\n"
"| hess_update                | OT_INT    | Type of Hessian approximation   |\n"
"+----------------------------+-----------+---------------------------------+\n"
"| ini_hess_diag              | OT_DOUBLE | Initial Hessian guess: diagonal |\n"
"|                            |           | matrix diag(iniHessDiag)        |\n"
"+----------------------------+-----------+---------------------------------+\n"
"| kappa_f                    | OT_DOUBLE | Filter line search parameter,   |\n"
"|                            |           | cf. IPOPT paper                 |\n"
"+----------------------------+-----------+---------------------------------+\n"
"| kappa_minus                | OT_DOUBLE | Filter line search parameter,   |\n"
"|                            |           | cf. IPOPT paper                 |\n"
"+----------------------------+-----------+---------------------------------+\n"
"| kappa_plus                 | OT_DOUBLE | Filter line search parameter,   |\n"
"|                            |           | cf. IPOPT paper                 |\n"
"+----------------------------+-----------+---------------------------------+\n"
"| kappa_plus_max             | OT_DOUBLE | Filter line search parameter,   |\n"
"|                            |           | cf. IPOPT paper                 |\n"
"+----------------------------+-----------+---------------------------------+\n"
"| kappa_soc                  | OT_DOUBLE | Filter line search parameter,   |\n"
"|                            |           | cf. IPOPT paper                 |\n"
"+----------------------------+-----------+---------------------------------+\n"
"| linsol                     | OT_STRING | The linear solver to be used by |\n"
"|                            |           | the QP method                   |\n"
"+----------------------------+-----------+---------------------------------+\n"
"| max_consec_reduced_steps   | OT_INT    | Maximum number of consecutive   |\n"
"|                            |           | reduced steps                   |\n"
"+----------------------------+-----------+---------------------------------+\n"
"| max_consec_skipped_updates | OT_INT    | Maximum number of consecutive   |\n"
"|                            |           | skipped updates                 |\n"
"+----------------------------+-----------+---------------------------------+\n"
"| max_conv_qp                | OT_INT    | How many additional QPs may be  |\n"
"|                            |           | solved for convexification per  |\n"
"|                            |           | iteration?                      |\n"
"+----------------------------+-----------+---------------------------------+\n"
"| max_it_qp                  | OT_INT    | Maximum number of QP iterations |\n"
"|                            |           | per SQP iteration               |\n"
"+----------------------------+-----------+---------------------------------+\n"
"| max_iter                   | OT_INT    | Maximum number of SQP           |\n"
"|                            |           | iterations                      |\n"
"+----------------------------+-----------+---------------------------------+\n"
"| max_line_search            | OT_INT    | Maximum number of steps in line |\n"
"|                            |           | search                          |\n"
"+----------------------------+-----------+---------------------------------+\n"
"| max_soc_iter               | OT_INT    | Maximum number of SOC line      |\n"
"|                            |           | search iterations               |\n"
"+----------------------------+-----------+---------------------------------+\n"
"| max_time_qp                | OT_DOUBLE | Maximum number of time in       |\n"
"|                            |           | seconds per QP solve per SQP    |\n"
"|                            |           | iteration                       |\n"
"+----------------------------+-----------+---------------------------------+\n"
"| nlinfeastol                | OT_DOUBLE | Nonlinear feasibility tolerance |\n"
"+----------------------------+-----------+---------------------------------+\n"
"| obj_lo                     | OT_DOUBLE | Lower bound on objective        |\n"
"|                            |           | function [-inf]                 |\n"
"+----------------------------+-----------+---------------------------------+\n"
"| obj_up                     | OT_DOUBLE | Upper bound on objective        |\n"
"|                            |           | function [inf]                  |\n"
"+----------------------------+-----------+---------------------------------+\n"
"| opttol                     | OT_DOUBLE | Optimality tolerance            |\n"
"+----------------------------+-----------+---------------------------------+\n"
"| print_header               | OT_BOOL   | Print solver header at startup  |\n"
"+----------------------------+-----------+---------------------------------+\n"
"| print_iteration            | OT_BOOL   | Print SQP iterations            |\n"
"+----------------------------+-----------+---------------------------------+\n"
"| print_maxit_reached        | OT_BOOL   | Print error when maximum number |\n"
"|                            |           | of SQP iterations reached       |\n"
"+----------------------------+-----------+---------------------------------+\n"
"| qp_init                    | OT_BOOL   | Use warmstarting                |\n"
"+----------------------------+-----------+---------------------------------+\n"
"| qpsol                      | OT_STRING | The QP solver to be used by the |\n"
"|                            |           | SQP method                      |\n"
"+----------------------------+-----------+---------------------------------+\n"
"| qpsol_options              | OT_DICT   | Options to be passed to the QP  |\n"
"|                            |           | solver                          |\n"
"+----------------------------+-----------+---------------------------------+\n"
"| restore_feas               | OT_BOOL   | Use feasibility restoration     |\n"
"|                            |           | phase                           |\n"
"+----------------------------+-----------+---------------------------------+\n"
"| rho                        | OT_DOUBLE | Feasibility restoration phase   |\n"
"|                            |           | parameter                       |\n"
"+----------------------------+-----------+---------------------------------+\n"
"| s_f                        | OT_DOUBLE | Filter line search parameter,   |\n"
"|                            |           | cf. IPOPT paper                 |\n"
"+----------------------------+-----------+---------------------------------+\n"
"| s_theta                    | OT_DOUBLE | Filter line search parameter,   |\n"
"|                            |           | cf. IPOPT paper                 |\n"
"+----------------------------+-----------+---------------------------------+\n"
"| schur                      | OT_BOOL   | Use qpOASES Schur compliment    |\n"
"|                            |           | approach                        |\n"
"+----------------------------+-----------+---------------------------------+\n"
"| skip_first_globalization   | OT_BOOL   | No globalization strategy in    |\n"
"|                            |           | first iteration                 |\n"
"+----------------------------+-----------+---------------------------------+\n"
"| theta_max                  | OT_DOUBLE | Filter line search parameter,   |\n"
"|                            |           | cf. IPOPT paper                 |\n"
"+----------------------------+-----------+---------------------------------+\n"
"| theta_min                  | OT_DOUBLE | Filter line search parameter,   |\n"
"|                            |           | cf. IPOPT paper                 |\n"
"+----------------------------+-----------+---------------------------------+\n"
"| warmstart                  | OT_BOOL   | Use warmstarting                |\n"
"+----------------------------+-----------+---------------------------------+\n"
"| which_second_derv          | OT_INT    | For which block should second   |\n"
"|                            |           | derivatives be provided by the  |\n"
"|                            |           | user                            |\n"
"+----------------------------+-----------+---------------------------------+\n"
"| zeta                       | OT_DOUBLE | Feasibility restoration phase   |\n"
"|                            |           | parameter                       |\n"
"+----------------------------+-----------+---------------------------------+\n"
"\n"
"\n"
"\n"
"\n"
;
