{ -*- buffer-read-only: t -*-

  Copyright 2015-2018 Michalis Kamburelis.

  This file is part of "Castle Game Engine".

  "Castle Game Engine" is free software; see the file COPYING.txt,
  included in this distribution, for details about the copyright.

  "Castle Game Engine" is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

  ----------------------------------------------------------------------------
}

{ Automatically generated node properties.

  Do not edit this file manually!
  To add new properties:
  - add them to the text files in nodes_specification/components/ ,
  - and regenerate include files by running
    nodes_specification/x3d-nodes-to-pascal/x3d-nodes-to-pascal.lpr .

  The documentation for properties should go to x3dnodes_documentation.txt . }

{$ifdef read_interface}

  strict private
    function GetColor: TAbstractColorNode;
    procedure SetColor(const Value: TAbstractColorNode);
    function GetCoord: TAbstractCoordinateNode;
    procedure SetCoord(const Value: TAbstractCoordinateNode);
    function GetFogCoord: TFogCoordinateNode;
    procedure SetFogCoord(const Value: TFogCoordinateNode);
    function GetNormal: TAbstractNormalNode;
    procedure SetNormal(const Value: TAbstractNormalNode);
    function GetTexCoord: TAbstractTextureCoordinateNode;
    procedure SetTexCoord(const Value: TAbstractTextureCoordinateNode);
    function GetCcw: boolean;
    procedure SetCcw(const Value: boolean);
    function GetColorPerVertex: boolean;
    procedure SetColorPerVertex(const Value: boolean);
    function GetNormalPerVertex: boolean;
    procedure SetNormalPerVertex(const Value: boolean);
  public
    procedure SetAttrib(const Value: array of TAbstractVertexAttributeNode);
    property Color: TAbstractColorNode read GetColor write SetColor;
    property Coord: TAbstractCoordinateNode read GetCoord write SetCoord;
    property FogCoord: TFogCoordinateNode read GetFogCoord write SetFogCoord;
    property Normal: TAbstractNormalNode read GetNormal write SetNormal;
    property TexCoord: TAbstractTextureCoordinateNode read GetTexCoord write SetTexCoord;
    property Ccw: boolean read GetCcw write SetCcw;
    property ColorPerVertex: boolean read GetColorPerVertex write SetColorPerVertex;
    property NormalPerVertex: boolean read GetNormalPerVertex write SetNormalPerVertex;
    procedure SetRadianceTransfer(const Value: array of TVector3);
    procedure SetRadianceTransfer(const Value: TVector3List);

{$endif read_interface}

{$ifdef read_implementation}

{ TAbstractComposedGeometryNode ----------------------------------------------- }

procedure TAbstractComposedGeometryNode.SetAttrib(const Value: array of TAbstractVertexAttributeNode);
var
  L: Integer;
  A: array of TX3DNode;
begin
  L := High(Value) + 1;
  SetLength(A, L);
  if L > 0 then
    Move(Value[0], A[0], L * SizeOf(TAbstractVertexAttributeNode));
  FdAttrib.Send(A);
end;

function TAbstractComposedGeometryNode.GetColor: TAbstractColorNode;
begin
  if FdColor.Value is TAbstractColorNode then
    Result := TAbstractColorNode(FdColor.Value)
  else
    Result := nil;
end;

procedure TAbstractComposedGeometryNode.SetColor(const Value: TAbstractColorNode);
begin
  FdColor.Send(Value);
end;

function TAbstractComposedGeometryNode.GetCoord: TAbstractCoordinateNode;
begin
  if FdCoord.Value is TAbstractCoordinateNode then
    Result := TAbstractCoordinateNode(FdCoord.Value)
  else
    Result := nil;
end;

procedure TAbstractComposedGeometryNode.SetCoord(const Value: TAbstractCoordinateNode);
begin
  FdCoord.Send(Value);
end;

function TAbstractComposedGeometryNode.GetFogCoord: TFogCoordinateNode;
begin
  if FdFogCoord.Value is TFogCoordinateNode then
    Result := TFogCoordinateNode(FdFogCoord.Value)
  else
    Result := nil;
end;

procedure TAbstractComposedGeometryNode.SetFogCoord(const Value: TFogCoordinateNode);
begin
  FdFogCoord.Send(Value);
end;

function TAbstractComposedGeometryNode.GetNormal: TAbstractNormalNode;
begin
  if FdNormal.Value is TAbstractNormalNode then
    Result := TAbstractNormalNode(FdNormal.Value)
  else
    Result := nil;
end;

procedure TAbstractComposedGeometryNode.SetNormal(const Value: TAbstractNormalNode);
begin
  FdNormal.Send(Value);
end;

function TAbstractComposedGeometryNode.GetTexCoord: TAbstractTextureCoordinateNode;
begin
  if FdTexCoord.Value is TAbstractTextureCoordinateNode then
    Result := TAbstractTextureCoordinateNode(FdTexCoord.Value)
  else
    Result := nil;
end;

procedure TAbstractComposedGeometryNode.SetTexCoord(const Value: TAbstractTextureCoordinateNode);
begin
  FdTexCoord.Send(Value);
end;

function TAbstractComposedGeometryNode.GetCcw: boolean;
begin
  Result := FdCcw.Value;
end;

procedure TAbstractComposedGeometryNode.SetCcw(const Value: boolean);
begin
  FdCcw.Send(Value);
end;

function TAbstractComposedGeometryNode.GetColorPerVertex: boolean;
begin
  Result := FdColorPerVertex.Value;
end;

procedure TAbstractComposedGeometryNode.SetColorPerVertex(const Value: boolean);
begin
  FdColorPerVertex.Send(Value);
end;

function TAbstractComposedGeometryNode.GetNormalPerVertex: boolean;
begin
  Result := FdNormalPerVertex.Value;
end;

procedure TAbstractComposedGeometryNode.SetNormalPerVertex(const Value: boolean);
begin
  FdNormalPerVertex.Send(Value);
end;

procedure TAbstractComposedGeometryNode.SetRadianceTransfer(const Value: array of TVector3);
begin
  FdRadianceTransfer.Send(Value);
end;

procedure TAbstractComposedGeometryNode.SetRadianceTransfer(const Value: TVector3List);
begin
  FdRadianceTransfer.Send(Value);
end;

{$endif read_implementation}
