{ -*- buffer-read-only: t -*-

  Copyright 2015-2021 Michalis Kamburelis.

  This file is part of "Castle Game Engine".

  "Castle Game Engine" is free software; see the file COPYING.txt,
  included in this distribution, for details about the copyright.

  "Castle Game Engine" is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

  ----------------------------------------------------------------------------
}

{ Automatically generated node properties.

  Do not edit this file manually!
  To add new properties:
  - add them to the text files in tools/internal/x3d-nodes-to-pascal/nodes-specification/ ,
  - and regenerate include files by running x3d-nodes-to-pascal .

  The documentation for properties should go to x3dnodes_documentation.txt . }

{$ifdef read_interface}

  strict private
    function GetSize: Integer;
    procedure SetSize(const Value: Integer);
    function GetTextureProperties: TTexturePropertiesNode;
    procedure SetTextureProperties(const Value: TTexturePropertiesNode);
  public
    { X3D field "size". } { }
    property Size: Integer read GetSize write SetSize;
    { X3D field "textureProperties". } { }
    property TextureProperties: TTexturePropertiesNode read GetTextureProperties write SetTextureProperties;

{$endif read_interface}

{$ifdef read_implementation}

{ TGeneratedCubeMapTextureNode ----------------------------------------------- }

function TGeneratedCubeMapTextureNode.GetSize: Integer;
begin
  Result := FdSize.Value;
end;

procedure TGeneratedCubeMapTextureNode.SetSize(const Value: Integer);
begin
  FdSize.Send(Value);
end;

function TGeneratedCubeMapTextureNode.GetTextureProperties: TTexturePropertiesNode;
begin
  if FdTextureProperties.Value is TTexturePropertiesNode then
    Result := TTexturePropertiesNode(FdTextureProperties.Value)
  else
    Result := nil;
end;

procedure TGeneratedCubeMapTextureNode.SetTextureProperties(const Value: TTexturePropertiesNode);
begin
  FdTextureProperties.Send(Value);
end;

{$endif read_implementation}
