{ -*- buffer-read-only: t -*-

  Copyright 2015-2021 Michalis Kamburelis.

  This file is part of "Castle Game Engine".

  "Castle Game Engine" is free software; see the file COPYING.txt,
  included in this distribution, for details about the copyright.

  "Castle Game Engine" is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

  ----------------------------------------------------------------------------
}

{ Automatically generated node properties.

  Do not edit this file manually!
  To add new properties:
  - add them to the text files in tools/internal/x3d-nodes-to-pascal/nodes-specification/ ,
  - and regenerate include files by running x3d-nodes-to-pascal .

  The documentation for properties should go to x3dnodes_documentation.txt . }

{$ifdef read_interface}

  strict private
    function GetFieldOfView: Single;
    procedure SetFieldOfView(const Value: Single);
    function GetHeadlight: Boolean;
    procedure SetHeadlight(const Value: Boolean);
    function GetGeoOrigin: TGeoOriginNode;
    procedure SetGeoOrigin(const Value: TGeoOriginNode);
    function GetSpeedFactor: Single;
    procedure SetSpeedFactor(const Value: Single);
  public
    { X3D field "fieldOfView". } { }
    property FieldOfView: Single read GetFieldOfView write SetFieldOfView;
    { X3D field "headlight". } { }
    property Headlight: Boolean read GetHeadlight write SetHeadlight;
    { Set X3D field "navType". } { }
    procedure SetNavType(const Value: array of string);
    { Set X3D field "navType". } { }
    procedure SetNavType(const Value: TCastleStringList);
    { X3D field "geoOrigin". } { }
    property GeoOrigin: TGeoOriginNode read GetGeoOrigin write SetGeoOrigin;
    { Set X3D field "geoSystem". } { }
    procedure SetGeoSystem(const Value: array of string);
    { Set X3D field "geoSystem". } { }
    procedure SetGeoSystem(const Value: TCastleStringList);
    { X3D field "speedFactor". } { }
    property SpeedFactor: Single read GetSpeedFactor write SetSpeedFactor;

{$endif read_interface}

{$ifdef read_implementation}

{ TGeoViewpointNode ----------------------------------------------- }

function TGeoViewpointNode.GetFieldOfView: Single;
begin
  Result := FdFieldOfView.Value;
end;

procedure TGeoViewpointNode.SetFieldOfView(const Value: Single);
begin
  FdFieldOfView.Send(Value);
end;

function TGeoViewpointNode.GetHeadlight: Boolean;
begin
  Result := FdHeadlight.Value;
end;

procedure TGeoViewpointNode.SetHeadlight(const Value: Boolean);
begin
  FdHeadlight.Send(Value);
end;

procedure TGeoViewpointNode.SetNavType(const Value: array of string);
begin
  FdNavType.Send(Value);
end;

procedure TGeoViewpointNode.SetNavType(const Value: TCastleStringList);
begin
  FdNavType.Send(Value);
end;

function TGeoViewpointNode.GetGeoOrigin: TGeoOriginNode;
begin
  if FdGeoOrigin.Value is TGeoOriginNode then
    Result := TGeoOriginNode(FdGeoOrigin.Value)
  else
    Result := nil;
end;

procedure TGeoViewpointNode.SetGeoOrigin(const Value: TGeoOriginNode);
begin
  FdGeoOrigin.Send(Value);
end;

procedure TGeoViewpointNode.SetGeoSystem(const Value: array of string);
begin
  FdGeoSystem.Send(Value);
end;

procedure TGeoViewpointNode.SetGeoSystem(const Value: TCastleStringList);
begin
  FdGeoSystem.Send(Value);
end;

function TGeoViewpointNode.GetSpeedFactor: Single;
begin
  Result := FdSpeedFactor.Value;
end;

procedure TGeoViewpointNode.SetSpeedFactor(const Value: Single);
begin
  FdSpeedFactor.Send(Value);
end;

{$endif read_implementation}
