{ -*- buffer-read-only: t -*-

  Copyright 2015-2021 Michalis Kamburelis.

  This file is part of "Castle Game Engine".

  "Castle Game Engine" is free software; see the file COPYING.txt,
  included in this distribution, for details about the copyright.

  "Castle Game Engine" is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

  ----------------------------------------------------------------------------
}

{ Automatically generated node properties.

  Do not edit this file manually!
  To add new properties:
  - add them to the text files in tools/internal/x3d-nodes-to-pascal/nodes-specification/ ,
  - and regenerate include files by running x3d-nodes-to-pascal .

  The documentation for properties should go to x3dnodes_documentation.txt . }

{$ifdef read_interface}

  strict private
    function GetColor: TCastleColor;
    procedure SetColor(const Value: TCastleColor);
    function GetTexture: TAbstractTextureNode;
    procedure SetTexture(const Value: TAbstractTextureNode);
  public
    { X3D field "color". } { }
    property Color: TCastleColor read GetColor write SetColor;
    { X3D field "texture". } { }
    property Texture: TAbstractTextureNode read GetTexture write SetTexture;
    { Set X3D field "texCoords". } { }
    procedure SetTexCoords(const Value: array of TVector2);
    { Set X3D field "texCoords". } { }
    procedure SetTexCoords(const Value: TVector2List);

{$endif read_interface}

{$ifdef read_implementation}

{ TImageBackgroundNode ----------------------------------------------- }

function TImageBackgroundNode.GetColor: TCastleColor;
begin
  Result := FdColor.Value;
end;

procedure TImageBackgroundNode.SetColor(const Value: TCastleColor);
begin
  FdColor.Send(Value);
end;

function TImageBackgroundNode.GetTexture: TAbstractTextureNode;
begin
  if FdTexture.Value is TAbstractTextureNode then
    Result := TAbstractTextureNode(FdTexture.Value)
  else
    Result := nil;
end;

procedure TImageBackgroundNode.SetTexture(const Value: TAbstractTextureNode);
begin
  FdTexture.Send(Value);
end;

procedure TImageBackgroundNode.SetTexCoords(const Value: array of TVector2);
begin
  FdTexCoords.Send(Value);
end;

procedure TImageBackgroundNode.SetTexCoords(const Value: TVector2List);
begin
  FdTexCoords.Send(Value);
end;

{$endif read_implementation}
