{ -*- buffer-read-only: t -*-

  Copyright 2015-2021 Michalis Kamburelis.

  This file is part of "Castle Game Engine".

  "Castle Game Engine" is free software; see the file COPYING.txt,
  included in this distribution, for details about the copyright.

  "Castle Game Engine" is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

  ----------------------------------------------------------------------------
}

{ Automatically generated node properties.

  Do not edit this file manually!
  To add new properties:
  - add them to the text files in tools/internal/x3d-nodes-to-pascal/nodes-specification/ ,
  - and regenerate include files by running x3d-nodes-to-pascal .

  The documentation for properties should go to x3dnodes_documentation.txt . }

{$ifdef read_interface}

  strict private
    function GetTextureProperties: TTexturePropertiesNode;
    procedure SetTextureProperties(const Value: TTexturePropertiesNode);
    function GetRepeatR: Boolean;
    procedure SetRepeatR(const Value: Boolean);
  public
    { Set X3D field "dimensions". } { }
    procedure SetDimensions(const Value: array of LongInt);
    { Set X3D field "dimensions". } { }
    procedure SetDimensions(const Value: TLongIntList);
    { X3D field "textureProperties". } { }
    property TextureProperties: TTexturePropertiesNode read GetTextureProperties write SetTextureProperties;
    { X3D field "repeatR". } { }
    property RepeatR: Boolean read GetRepeatR write SetRepeatR;
    { Set X3D field "depthMap". } { }
    procedure SetDepthMap(const Value: array of boolean);
    { Set X3D field "depthMap". } { }
    procedure SetDepthMap(const Value: TBooleanList);

{$endif read_interface}

{$ifdef read_implementation}

{ TRenderedTextureNode ----------------------------------------------- }

procedure TRenderedTextureNode.SetDimensions(const Value: array of LongInt);
begin
  FdDimensions.Send(Value);
end;

procedure TRenderedTextureNode.SetDimensions(const Value: TLongIntList);
begin
  FdDimensions.Send(Value);
end;

function TRenderedTextureNode.GetTextureProperties: TTexturePropertiesNode;
begin
  if FdTextureProperties.Value is TTexturePropertiesNode then
    Result := TTexturePropertiesNode(FdTextureProperties.Value)
  else
    Result := nil;
end;

procedure TRenderedTextureNode.SetTextureProperties(const Value: TTexturePropertiesNode);
begin
  FdTextureProperties.Send(Value);
end;

function TRenderedTextureNode.GetRepeatR: Boolean;
begin
  Result := FdRepeatR.Value;
end;

procedure TRenderedTextureNode.SetRepeatR(const Value: Boolean);
begin
  FdRepeatR.Send(Value);
end;

procedure TRenderedTextureNode.SetDepthMap(const Value: array of boolean);
begin
  FdDepthMap.Send(Value);
end;

procedure TRenderedTextureNode.SetDepthMap(const Value: TBooleanList);
begin
  FdDepthMap.Send(Value);
end;

{$endif read_implementation}
