{ -*- buffer-read-only: t -*-

  Copyright 2015-2021 Michalis Kamburelis.

  This file is part of "Castle Game Engine".

  "Castle Game Engine" is free software; see the file COPYING.txt,
  included in this distribution, for details about the copyright.

  "Castle Game Engine" is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

  ----------------------------------------------------------------------------
}

{ Automatically generated node properties.

  Do not edit this file manually!
  To add new properties:
  - add them to the text files in tools/internal/x3d-nodes-to-pascal/nodes-specification/ ,
  - and regenerate include files by running x3d-nodes-to-pascal .

  The documentation for properties should go to x3dnodes_documentation.txt . }

{$ifdef read_interface}

  strict private
    function GetAttenuation: TVector3;
    procedure SetAttenuation(const Value: TVector3);
    function GetBeamWidth: Single;
    procedure SetBeamWidth(const Value: Single);
    function GetCutOffAngle: Single;
    procedure SetCutOffAngle(const Value: Single);
    function GetDirection: TVector3;
    procedure SetDirection(const Value: TVector3);
    function GetLocation: TVector3;
    procedure SetLocation(const Value: TVector3);
    function GetRadius: Single;
    procedure SetRadius(const Value: Single);
    function GetProjectionAngle: Single;
    procedure SetProjectionAngle(const Value: Single);
  public
    { X3D field "attenuation". } { }
    property Attenuation: TVector3 read GetAttenuation write SetAttenuation;
    { X3D field "beamWidth". } { }
    property BeamWidth: Single read GetBeamWidth write SetBeamWidth;
    { X3D field "cutOffAngle". } { }
    property CutOffAngle: Single read GetCutOffAngle write SetCutOffAngle;
    { X3D field "direction". } { }
    property Direction: TVector3 read GetDirection write SetDirection;
    { X3D field "location". } { }
    property Location: TVector3 read GetLocation write SetLocation;
    { X3D field "radius". } { }
    property Radius: Single read GetRadius write SetRadius;
    { X3D field "projectionAngle". } { }
    property ProjectionAngle: Single read GetProjectionAngle write SetProjectionAngle;

{$endif read_interface}

{$ifdef read_implementation}

{ TSpotLightNode ----------------------------------------------- }

function TSpotLightNode.GetAttenuation: TVector3;
begin
  Result := FdAttenuation.Value;
end;

procedure TSpotLightNode.SetAttenuation(const Value: TVector3);
begin
  FdAttenuation.Send(Value);
end;

function TSpotLightNode.GetBeamWidth: Single;
begin
  Result := FdBeamWidth.Value;
end;

procedure TSpotLightNode.SetBeamWidth(const Value: Single);
begin
  FdBeamWidth.Send(Value);
end;

function TSpotLightNode.GetCutOffAngle: Single;
begin
  Result := FdCutOffAngle.Value;
end;

procedure TSpotLightNode.SetCutOffAngle(const Value: Single);
begin
  FdCutOffAngle.Send(Value);
end;

function TSpotLightNode.GetDirection: TVector3;
begin
  Result := FdDirection.Value;
end;

procedure TSpotLightNode.SetDirection(const Value: TVector3);
begin
  FdDirection.Send(Value);
end;

function TSpotLightNode.GetLocation: TVector3;
begin
  Result := FdLocation.Value;
end;

procedure TSpotLightNode.SetLocation(const Value: TVector3);
begin
  FdLocation.Send(Value);
end;

function TSpotLightNode.GetRadius: Single;
begin
  Result := FdRadius.Value;
end;

procedure TSpotLightNode.SetRadius(const Value: Single);
begin
  FdRadius.Send(Value);
end;

function TSpotLightNode.GetProjectionAngle: Single;
begin
  Result := FdProjectionAngle.Value;
end;

procedure TSpotLightNode.SetProjectionAngle(const Value: Single);
begin
  FdProjectionAngle.Send(Value);
end;

{$endif read_implementation}
