{ -*- buffer-read-only: t -*-

  Copyright 2015-2021 Michalis Kamburelis.

  This file is part of "Castle Game Engine".

  "Castle Game Engine" is free software; see the file COPYING.txt,
  included in this distribution, for details about the copyright.

  "Castle Game Engine" is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

  ----------------------------------------------------------------------------
}

{ Automatically generated node properties.

  Do not edit this file manually!
  To add new properties:
  - add them to the text files in tools/internal/x3d-nodes-to-pascal/nodes-specification/ ,
  - and regenerate include files by running x3d-nodes-to-pascal .

  The documentation for properties should go to x3dnodes_documentation.txt . }

{$ifdef read_interface}

  strict private
    function GetCenter: TVector3;
    procedure SetCenter(const Value: TVector3);
    function GetDescription: String;
    procedure SetDescription(const Value: String);
    function GetDisplayed: Boolean;
    procedure SetDisplayed(const Value: Boolean);
    function GetRetainUserOffsets: Boolean;
    procedure SetRetainUserOffsets(const Value: Boolean);
    function GetSize: TVector3;
    procedure SetSize(const Value: TVector3);
  public
    { X3D field "center". } { }
    property Center: TVector3 read GetCenter write SetCenter;
    { X3D field "description". } { }
    property Description: String read GetDescription write SetDescription;
    { X3D field "displayed". } { }
    property Displayed: Boolean read GetDisplayed write SetDisplayed;
    { X3D field "retainUserOffsets". } { }
    property RetainUserOffsets: Boolean read GetRetainUserOffsets write SetRetainUserOffsets;
    { X3D field "size". } { }
    property Size: TVector3 read GetSize write SetSize;

{$endif read_interface}

{$ifdef read_implementation}

{ TViewpointGroupNode ----------------------------------------------- }

function TViewpointGroupNode.GetCenter: TVector3;
begin
  Result := FdCenter.Value;
end;

procedure TViewpointGroupNode.SetCenter(const Value: TVector3);
begin
  FdCenter.Send(Value);
end;

function TViewpointGroupNode.GetDescription: String;
begin
  Result := FdDescription.Value;
end;

procedure TViewpointGroupNode.SetDescription(const Value: String);
begin
  FdDescription.Send(Value);
end;

function TViewpointGroupNode.GetDisplayed: Boolean;
begin
  Result := FdDisplayed.Value;
end;

procedure TViewpointGroupNode.SetDisplayed(const Value: Boolean);
begin
  FdDisplayed.Send(Value);
end;

function TViewpointGroupNode.GetRetainUserOffsets: Boolean;
begin
  Result := FdRetainUserOffsets.Value;
end;

procedure TViewpointGroupNode.SetRetainUserOffsets(const Value: Boolean);
begin
  FdRetainUserOffsets.Send(Value);
end;

function TViewpointGroupNode.GetSize: TVector3;
begin
  Result := FdSize.Value;
end;

procedure TViewpointGroupNode.SetSize(const Value: TVector3);
begin
  FdSize.Send(Value);
end;

{$endif read_implementation}
