{ -*- buffer-read-only: t -*-

  Copyright 2015-2021 Michalis Kamburelis.

  This file is part of "Castle Game Engine".

  "Castle Game Engine" is free software; see the file COPYING.txt,
  included in this distribution, for details about the copyright.

  "Castle Game Engine" is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

  ----------------------------------------------------------------------------
}

{ Automatically generated node properties.

  Do not edit this file manually!
  To add new properties:
  - add them to the text files in tools/internal/x3d-nodes-to-pascal/nodes-specification/ ,
  - and regenerate include files by running x3d-nodes-to-pascal .

  The documentation for properties should go to x3dnodes_documentation.txt . }

{$ifdef read_interface}

  strict private
    function GetControlPoint: TAbstractCoordinateNode;
    procedure SetControlPoint(const Value: TAbstractCoordinateNode);
    function GetUTessellation: Integer;
    procedure SetUTessellation(const Value: Integer);
    function GetVTessellation: Integer;
    procedure SetVTessellation(const Value: Integer);
    function GetUClosed: Boolean;
    procedure SetUClosed(const Value: Boolean);
    function GetUDimension: Integer;
    procedure SetUDimension(const Value: Integer);
    function GetUOrder: Integer;
    procedure SetUOrder(const Value: Integer);
    function GetVClosed: Boolean;
    procedure SetVClosed(const Value: Boolean);
    function GetVDimension: Integer;
    procedure SetVDimension(const Value: Integer);
    function GetVOrder: Integer;
    procedure SetVOrder(const Value: Integer);
  public
    { X3D field "controlPoint". } { }
    property ControlPoint: TAbstractCoordinateNode read GetControlPoint write SetControlPoint;
    { X3D field "uTessellation". } { }
    property UTessellation: Integer read GetUTessellation write SetUTessellation;
    { X3D field "vTessellation". } { }
    property VTessellation: Integer read GetVTessellation write SetVTessellation;
    { Set X3D field "weight". } { }
    procedure SetWeight(const Value: array of Double);
    { Set X3D field "weight". } { }
    procedure SetWeight(const Value: TDoubleList);
    { X3D field "uClosed". } { }
    property UClosed: Boolean read GetUClosed write SetUClosed;
    { X3D field "uDimension". } { }
    property UDimension: Integer read GetUDimension write SetUDimension;
    { Set X3D field "uKnot". } { }
    procedure SetUKnot(const Value: array of Double);
    { Set X3D field "uKnot". } { }
    procedure SetUKnot(const Value: TDoubleList);
    { X3D field "uOrder". } { }
    property UOrder: Integer read GetUOrder write SetUOrder;
    { X3D field "vClosed". } { }
    property VClosed: Boolean read GetVClosed write SetVClosed;
    { X3D field "vDimension". } { }
    property VDimension: Integer read GetVDimension write SetVDimension;
    { Set X3D field "vKnot". } { }
    procedure SetVKnot(const Value: array of Double);
    { Set X3D field "vKnot". } { }
    procedure SetVKnot(const Value: TDoubleList);
    { X3D field "vOrder". } { }
    property VOrder: Integer read GetVOrder write SetVOrder;

{$endif read_interface}

{$ifdef read_implementation}

{ TAbstractNurbsSurfaceGeometryNode ----------------------------------------------- }

function TAbstractNurbsSurfaceGeometryNode.GetControlPoint: TAbstractCoordinateNode;
begin
  if FdControlPoint.Value is TAbstractCoordinateNode then
    Result := TAbstractCoordinateNode(FdControlPoint.Value)
  else
    Result := nil;
end;

procedure TAbstractNurbsSurfaceGeometryNode.SetControlPoint(const Value: TAbstractCoordinateNode);
begin
  FdControlPoint.Send(Value);
end;

function TAbstractNurbsSurfaceGeometryNode.GetUTessellation: Integer;
begin
  Result := FdUTessellation.Value;
end;

procedure TAbstractNurbsSurfaceGeometryNode.SetUTessellation(const Value: Integer);
begin
  FdUTessellation.Send(Value);
end;

function TAbstractNurbsSurfaceGeometryNode.GetVTessellation: Integer;
begin
  Result := FdVTessellation.Value;
end;

procedure TAbstractNurbsSurfaceGeometryNode.SetVTessellation(const Value: Integer);
begin
  FdVTessellation.Send(Value);
end;

procedure TAbstractNurbsSurfaceGeometryNode.SetWeight(const Value: array of Double);
begin
  FdWeight.Send(Value);
end;

procedure TAbstractNurbsSurfaceGeometryNode.SetWeight(const Value: TDoubleList);
begin
  FdWeight.Send(Value);
end;

function TAbstractNurbsSurfaceGeometryNode.GetUClosed: Boolean;
begin
  Result := FdUClosed.Value;
end;

procedure TAbstractNurbsSurfaceGeometryNode.SetUClosed(const Value: Boolean);
begin
  FdUClosed.Send(Value);
end;

function TAbstractNurbsSurfaceGeometryNode.GetUDimension: Integer;
begin
  Result := FdUDimension.Value;
end;

procedure TAbstractNurbsSurfaceGeometryNode.SetUDimension(const Value: Integer);
begin
  FdUDimension.Send(Value);
end;

procedure TAbstractNurbsSurfaceGeometryNode.SetUKnot(const Value: array of Double);
begin
  FdUKnot.Send(Value);
end;

procedure TAbstractNurbsSurfaceGeometryNode.SetUKnot(const Value: TDoubleList);
begin
  FdUKnot.Send(Value);
end;

function TAbstractNurbsSurfaceGeometryNode.GetUOrder: Integer;
begin
  Result := FdUOrder.Value;
end;

procedure TAbstractNurbsSurfaceGeometryNode.SetUOrder(const Value: Integer);
begin
  FdUOrder.Send(Value);
end;

function TAbstractNurbsSurfaceGeometryNode.GetVClosed: Boolean;
begin
  Result := FdVClosed.Value;
end;

procedure TAbstractNurbsSurfaceGeometryNode.SetVClosed(const Value: Boolean);
begin
  FdVClosed.Send(Value);
end;

function TAbstractNurbsSurfaceGeometryNode.GetVDimension: Integer;
begin
  Result := FdVDimension.Value;
end;

procedure TAbstractNurbsSurfaceGeometryNode.SetVDimension(const Value: Integer);
begin
  FdVDimension.Send(Value);
end;

procedure TAbstractNurbsSurfaceGeometryNode.SetVKnot(const Value: array of Double);
begin
  FdVKnot.Send(Value);
end;

procedure TAbstractNurbsSurfaceGeometryNode.SetVKnot(const Value: TDoubleList);
begin
  FdVKnot.Send(Value);
end;

function TAbstractNurbsSurfaceGeometryNode.GetVOrder: Integer;
begin
  Result := FdVOrder.Value;
end;

procedure TAbstractNurbsSurfaceGeometryNode.SetVOrder(const Value: Integer);
begin
  FdVOrder.Send(Value);
end;

{$endif read_implementation}
