/*
** (c) 1996-2000 The Regents of the University of California (through
** E.O. Lawrence Berkeley National Laboratory), subject to approval by
** the U.S. Department of Energy.  Your use of this software is under
** license -- the license agreement is attached and included in the
** directory as license.txt or you may contact Berkeley Lab's Technology
** Transfer Department at TTD@lbl.gov.  NOTICE OF U.S. GOVERNMENT RIGHTS.
** The Software was developed under funding from the U.S. Government
** which consequently retains certain rights as follows: the
** U.S. Government has been granted for itself and others acting on its
** behalf a paid-up, nonexclusive, irrevocable, worldwide license in the
** Software to reproduce, prepare derivative works, and perform publicly
** and display publicly.  Beginning five (5) years after the date
** permission to assert copyright is obtained from the U.S. Department of
** Energy, and subject to any subsequent five (5) year renewals, the
** U.S. Government is granted for itself and others acting on its behalf
** a paid-up, nonexclusive, irrevocable, worldwide license in the
** Software to reproduce, prepare derivative works, distribute copies to
** the public, perform publicly and display publicly, and to permit
** others to do so.
*/

#ifndef _DERIVE_F_H_
#define _DERIVE_F_H_

/*
** $Id: DERIVE_F.H,v 1.15 2002/04/26 22:10:01 lijewski Exp $
*/

#ifdef BL_LANG_FORT
#    define FORT_DERLOGS      derlogs
#    define FORT_DERVEL       dervel
#    define FORT_DERPRES      derpres
#    define FORT_DERCOPY      dercopy
#else
#  ifdef BL_FORT_USE_UPPERCASE
#    define FORT_DERLOGS      DERLOGS
#    define FORT_DERVEL       DERVEL
#    define FORT_DERPRES      DERPRES
#    define FORT_DERCOPY      DERCOPY
#  else
#  ifdef BL_FORT_USE_LOWERCASE
#    define FORT_DERLOGS      derlogs
#    define FORT_DERVEL       dervel
#    define FORT_DERPRES      derpres
#    define FORT_DERCOPY      dercopy
#  else
#    define FORT_DERLOGS      derlogs_
#    define FORT_DERVEL       dervel_
#    define FORT_DERPRES      derpres_
#    define FORT_DERCOPY      dercopy_
#  endif
#  endif

extern "C"
{
     void FORT_DERLOGS   (Real* data, ARLIM_P(data_lo), ARLIM_P(data_hi),
                           const int* nvar, const Real* compdat,
                           ARLIM_P(compdat_lo), ARLIM_P(compdat_hi), 
                           const int* ncomp,
                           const int* lo, const int* hi,
                           const int* domain_lo, const int* domain_hi,
                           const Real* delta, const Real* xlo,
                           const Real* time, const Real* dt, const int* bcrec,
                           const int* level, const int* grid_no) ;

     void FORT_DERVEL    (Real* data, ARLIM_P(data_lo), ARLIM_P(data_hi),
                           const int* nvar, const Real* compdat,
                           ARLIM_P(compdat_lo), ARLIM_P(compdat_hi), 
                           const int* ncomp,
                           const int* lo, const int* hi,
                           const int* domain_lo, const int* domain_hi,
                           const Real* delta, const Real* xlo,
                           const Real* time, const Real* dt,  const int* bcrec,
                           const int* level, const int* grid_no) ;

     void FORT_DERPRES    (Real* data, ARLIM_P(data_lo), ARLIM_P(data_hi),
                           const int* nvar, const Real* compdat,
                           ARLIM_P(compdat_lo), ARLIM_P(compdat_hi), 
                           const int* ncomp,
                           const int* lo, const int* hi,
                           const int* domain_lo, const int* domain_hi,
                           const Real* delta, const Real* xlo,
                           const Real* time, const Real* dt,  const int* bcrec,
                           const int* level, const int* grid_no) ;

     void FORT_DERCOPY    (Real* data, ARLIM_P(data_lo), ARLIM_P(data_hi),
                           const int* nvar, const Real* compdat,
                           ARLIM_P(compdat_lo), ARLIM_P(compdat_hi), 
                           const int* ncomp,
                           const int* lo, const int* hi,
                           const int* domain_lo, const int* domain_hi,
                           const Real* delta, const Real* xlo,
                           const Real* time, const Real* dt,  const int* bcrec,
                           const int* level, const int* grid_no) ;

}
#endif

#endif /*_DERIVE_F_H_*/
