(define-library (euler exponential-test)
  (export run-tests)
  (import (scheme base) (scheme process-context) (euler exponential))
  (begin
    (define (test expect expr)
      (cond
       ((not (or (equal? expect expr)
                 (and (or (inexact? expect) (inexact? expr))
                      (let ((a (min expect expr))
                            (b (max expect expr)))
                        (< (abs (/ (- a b) b)) 0.000001)))))
        (write-string "FAIL\n")
        (exit 1))))
    (define (run-tests)
      (test 0.36788 (e -1.0))
      (test 1.0 (e 0.0))
      (test 2.71828 (e 1.0))
      (test 4.48167 (e 1.5))
      (test 7.38871 (e 2.0)))))
