# Условные функции

## if(cond, then, else), оператор cond ? then : else

Возвращает `then`, если `cond != 0` или `else`, если `cond = 0`.
`cond` должно иметь тип `UInt8`, а `then` и `else` должны иметь тип, для которого есть наименьший общий тип.

`then` и `else` могут быть `NULL`

## multiIf

Позволяет более компактно записать оператор [CASE](../operators.md#operator_case) в запросе.

```
multiIf(cond_1, then_1, cond_2, then_2...else)
```

**Параметры**

- `cond_N` — Условие, при выполнении которого функция вернёт `then_N`.
- `then_N` — Результат функции при выполнении.
- `else` — Результат функции, если ни одно из условий не выполнено.

Функция принимает `2N+1` параметров.

**Возвращаемые значения**

Функция возвращает одно из значений `then_N` или `else`, в зависимости от условий `cond_N`.

**Пример**

Рассмотрим таблицу

```
┌─x─┬────y─┐
│ 1 │ ᴺᵁᴸᴸ │
│ 2 │    3 │
└───┴──────┘
```

Выполним запрос `SELECT multiIf(isNull(y), x, y < 3, y, NULL) FROM t_null`. Результат:

```
┌─multiIf(isNull(y), x, less(y, 3), y, NULL)─┐
│                                          1 │
│                                       ᴺᵁᴸᴸ │
└────────────────────────────────────────────┘
```

[Оригинальная статья](https://clickhouse.yandex/docs/ru/query_language/functions/conditional_functions/) <!--hide-->
