static int testcount = 0;
#define ok(bool,testname) printf("%s %i - %s\n",(bool)?"ok":"not ok",++testcount,testname);

void test_color(COLORBLIND_RUNTIME* runtime,
                int colorred, int colorgreen, int colorblue,
                int touch,
                int resultred, int resultgreen, int resultblue) {
        COLORBLIND_XCOLOR* color = malloc(sizeof(COLORBLIND_XCOLOR));
        color->red = colorred;
        color->green = colorgreen;
        color->blue = colorblue;
        COLORBLIND_XCOLOR* result = malloc(sizeof(COLORBLIND_XCOLOR));
        result->red = resultred;
        result->green = resultgreen;
        result->blue = resultblue;
        int r = colorblind_filter(runtime,color);
        char str1[255];
        sprintf(str1,"Cor %i,%i,%i touch %i",colorred,colorgreen,colorblue,touch);
        char str2[255];
        sprintf(str2,"Cor %i,%i,%i result %i,%i,%i expected %i,%i,%i ",colorred,colorgreen,colorblue,color->red,color->green,color->blue,result->red,result->green,result->blue);
        ok(r==touch,str1);
        ok((color->red == result->red)&&(color->green == result->green)&&(color->blue == result->blue),str2);
        free(color);
        free(result);
}

void test_utils(COLORBLIND_RUNTIME* runtime, COLORBLIND_XCOLOR* color, int equalized, int main, int red_is_main, int green_is_main, int blue_is_main) {
        int this_equalized = colorblind_get_num_equalized(runtime,color);
        int this_main = colorblind_get_num_main(runtime,color);
        int this_red_is_main = colorblind_red_is_main(runtime,color);
        int this_green_is_main = colorblind_green_is_main(runtime,color);
        int this_blue_is_main = colorblind_blue_is_main(runtime,color);
        char str[255];
        sprintf(str,"color %i,%i,%i has %i equalized colors",color->red,color->green,color->blue,equalized);
        ok(equalized == this_equalized,str);
        sprintf(str,"color %i,%i,%i has %i main colors",color->red,color->green,color->blue,main);
        ok(main == this_main,str);
        sprintf(str,"color %i,%i,%i has %i in red_is_main",color->red,color->green,color->blue,red_is_main);
        ok(red_is_main == this_red_is_main,str);
        sprintf(str,"color %i,%i,%i has %i in green_is_main",color->red,color->green,color->blue,green_is_main);
        ok(green_is_main == this_green_is_main,str);
        sprintf(str,"color %i,%i,%i has %i in blue_is_main",color->red,color->green,color->blue,blue_is_main);
        ok(blue_is_main == this_blue_is_main,str);
}
