#
# Copyright (C) 2005  Robert Collins  <robertc@squid-cache.org>
# 
# 
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
# 
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

from copy import copy
import os
import tests
from StringIO import StringIO
import unittest

# if this fails to import, then the implementations module is bust
# and this test script will never be reached to be imported
import config_manager.implementations
import config_manager.implementations as implementations
from config_manager.implementations.tests import ImplementationTestAdapter
from config_manager.tests import FunctionalTestCase


class MockImplementation(object):
    """A functionless implementation for testing registration machinery."""

    def __init__(self):
        self.schemes = ["scheme"]


class MockImplementation2(MockImplementation):
    """A functionaless implementation for verifying registration machinery."""


class TestImplementations(unittest.TestCase):

    def test_list_exists(self):
        self.assertEqual([].__class__,
            config_manager.implementations.all_implementations.__class__)

    def test_register_and_unregister_do_so(self):
        current_implementations = copy(
            config_manager.implementations.all_implementations)
        mock_implementation = MockImplementation()
        config_manager.implementations.register(mock_implementation)
        # must be in all implementations
        self.assertEqual(current_implementations + [mock_implementation],
                         config_manager.implementations.all_implementations)
        # must be in schemes["scheme"]
        instances = [imp for imp in
                     config_manager.implementations.schemes["scheme"] if
                     imp is mock_implementation]
        self.assertEqual(1, len(instances))
        config_manager.implementations.unregister(mock_implementation)
        self.assertEqual(current_implementations,
                         config_manager.implementations.all_implementations)
        # must not be in schemes["scheme"]
        instances = [imp for imp in
                     config_manager.implementations.schemes["scheme"] if
                     imp is mock_implementation]
        self.assertEqual(0, len(instances))
        

class TestImplementationTestAdapter(unittest.TestCase):

    def test_adapter_sets_implementation_class(self):
        current_implementations = implementations.all_implementations
        implementations.all_implementations = []
        try:
            current_schemes = implementations.schemes
            implementations.schemes = {}
            try:
                imp1 = MockImplementation()
                imp2 = MockImplementation2()
                implementations.register(imp1)
                implementations.register(imp2)
                atest = TestImplementationTestAdapter(
                    "test_adapter_sets_implementation_class")
                suite = ImplementationTestAdapter().adapt(atest)
                test_iter = iter(suite)
                imp1_test = test_iter.next()
                imp2_test = test_iter.next()
                self.assertRaises(StopIteration, test_iter.next)
                self.assertEqual(MockImplementation, imp1_test.implementation_class)
                self.assertEqual(MockImplementation2, imp2_test.implementation_class)
                self.assertEqual("config_manager.implementations.tests."
                                 "test_vcs_implementations."
                                 "TestImplementationTestAdapter."
                                 "test_adapter_sets_implementation_class"
                                 "(MockImplementation)", imp1_test.id())
                self.assertEqual("config_manager.implementations.tests."
                                 "test_vcs_implementations."
                                 "TestImplementationTestAdapter."
                                 "test_adapter_sets_implementation_class"
                                 "(MockImplementation2)", imp2_test.id())
            finally:
                implementations.schemes = current_schemes
        finally:
            implementations.all_implementations = current_implementations
            
        
def test_suite():
    result = tests.TestSuite()
    loader = tests.TestLoader()
    result = loader.loadTestsFromName(__name__)
    return result
