/*
 * Copyright (c) 2002 Robert Collins.
 *
 *     This program is free software; you can redistribute it and/or modify
 *     it under the terms of the GNU General Public License as published by
 *     the Free Software Foundation; either version 2 of the License, or
 *     (at your option) any later version.
 *
 *     A copy of the GNU General Public License can be found at
 *     http://www.gnu.org/
 *
 * Written by Robert Collins <robertc@hotmail.com>
 *
 */

#include "File.h"
#include "FileSystemVisitor.h"
#include <sys/stat.h>
#include <sys/types.h>
#include <sys/unistd.h>
#include <errno.h>
#include <iostream>
#include <fstream>
#include "Directory.h"

File::File (string const &path, bool const isASymlink, mode_t const &protection) : path_(path), symlink_(isASymlink), mode_(protection)
{
}

void
File::visit (FileSystemVisitor &aVisitor)
{
    aVisitor.visitFile (*this);
}

/* XXX: todo: optional chmod on the copied file.
 *	      copy in binary mode
 *	      do the Right Thing with Symlinks.
 */
void
File::Copy (string const &source, string const& target)
{
    if (Directory::Exists(source))
	throw (string) "Source was a directory (" + source + ")";
    ifstream ifs(source.c_str(), ios::in);
    if (!ifs.is_open())
	throw (string) "Can't open source file (" + source + ")";

    fstream ofs (target.c_str(), ios::out | ios::trunc);
    if (!ofs.is_open())
	throw (string) "Can't open target file (" + target + ")";

    /* string based copy */
    string s;
    while(getline(ifs, s))
      {
	if (!ifs.good() || !ofs.good())
	    throw (string) "File::Copy Failed during copy";
	ofs << s << "\n";
      }
}
