# LIB_CHECK_GSL
#------------------
# Checks for the gsl library and header files.
AC_DEFUN([CPL_CHECK_GSL],
[

    AC_MSG_CHECKING([for gsl])

    AC_ARG_WITH(gsl,
                AC_HELP_STRING([--with-gsl],
                               [location where gsl is installed]),
                [
                    cpl_gsl_dir=$withval
                ])

    export PKG_CONFIG_PATH="$cpl_gsl_dir/lib/pkgconfig:$GSLDIR/lib/pkgconfig/:$PKG_CONFIG_PATH"

    AC_SUBST(PKG_CONFIG_PATH)
    PKG_CHECK_MODULES([GSL], [gsl], 
                      AC_DEFINE([HAVE_LIBGSL], [1], [1 if GSL present]),
                      AC_MSG_ERROR([No GSL available]))

])
